/*
Calf Box, an open source musical instrument.
Copyright (C) 2010-2011 Krzysztof Foltman

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CBOX_BLOB_H
#define CBOX_BLOB_H

#include <glib.h>
#include <stddef.h>

struct cbox_blob
{
    void *data;
    size_t size;
};

struct cbox_tarfile;

extern struct cbox_blob *cbox_blob_new(size_t size);
extern struct cbox_blob *cbox_blob_new_from_file(const char *context_name, struct cbox_tarfile *tarfile, const char *path, const char *name, size_t max_size, GError **error);
extern struct cbox_blob *cbox_blob_new_copy_data(const void *data, size_t size);
extern struct cbox_blob *cbox_blob_new_acquire_data(void *data, size_t size);
extern void cbox_blob_destroy(struct cbox_blob *blob);

#endif
