#! /usr/bin/env python3
# -*- coding: utf-8 -*-

"""
This documentation is licensed under Creative Commons-BY-SA-4.0.
Please read the provided documentation/LICENSE file or visit
https://creativecommons.org/licenses/by-sa/4.0/legalcode

The documentation is built statically and does not belong to the normal build process with configure and make
Its updating is part of the development process, not packaging and running.
The correct out/ dir is already part of git.

.adoc is asciidoctor, not simple asciidoc.
"""


#We still split between template and non-template, eventhough this is not the case in Agordejo.
#However, this enables an easier diff across projects to keep track of changes that we need to do manually here
#TODO: Unify in the future by creating calfbox and NSM client as documentation "modules"

#Make the readme

import sys
sys.path.append("../../engine")
from config import METADATA
import subprocess
from os import getcwd
import os.path
assert os.path.exists(os.path.join(getcwd(), __file__)), (getcwd(), __file__)
import datetime


#Readme

with open("readme.template", "r") as r:
    template_readme = r.read()

template_readme = template_readme.replace("<date>", datetime.datetime.now().isoformat())
template_readme = template_readme.replace("<name>", METADATA["name"])
template_readme = template_readme.replace("<version>", METADATA["version"])
template_readme = template_readme.replace("<shortname>", METADATA["shortName"])
template_readme = template_readme.replace("<description>", METADATA["description"])
template_readme = template_readme.replace("<dependencies>", METADATA["dependencies"])
template_readme = template_readme.replace("<author>", METADATA["author"])

with open ("../../README.md", "w") as w:
    w.write(template_readme)

print ("Built /README.md")

#Documentation index

with open("index.adoc.template", "r") as r:
    template_index = r.read()

template_index = template_index.replace("<name>", METADATA["name"])
template_index = template_index.replace("<shortname>", METADATA["shortName"])
template_index = template_index.replace("<version>", METADATA["version"])
template_index = template_index.replace("<author>", METADATA["author"])

with open ("../../documentation/index.adoc", "w") as w:
    w.write(template_index)

#print ("Built /documentation/index.adoc. You still need to run /documentation/build-documentation.sh manually")
#print ("Built /documentation/index.adoc")

#Documentation 

METADATA["supportedLanguages"].update({"English":""})
for language in METADATA["supportedLanguages"].keys():
    
    language = language.lower()    
    
    try:
        with open(f"{language}.adoc.template", "r") as r:
            template = r.read()  
    except:
        continue #language not yet supported as manual
    
    for key, value in METADATA.items(): #all strings
        if type(value) is str:
            template = template.replace(f"<{key}>", value)    

    if language == "english":
        template = template.replace("<english-only-description>", "== Introduction\n\n" + METADATA["description"])    
        

    with open (f"../../documentation/{language}.part.adoc", "r") as clientPart:     
        template = template.replace("<manual>", clientPart.read())

    with open (f"../../documentation/{language}.adoc", "w") as w:
        w.write(template)


#Create manpage
#Needs help2man
manpage_template = f"""
[name]
{METADATA["name"]} - {METADATA["tagline"]}

[usage]
{METADATA["description"]}

[Reporting bugs]
https://www.laborejo.org/bugs

[copyright]
{METADATA["name"]} {METADATA["version"]} - Copyright {METADATA["year"]}
{METADATA["author"]}
https://www.laborejo.org/

[examples]
Start {METADATA["shortName"]} through NSM, e.g. through Agordejo. This will take care of all
settings and save directories.

Other modes of operations, mostly for testing, are:

Run without session management and save in /tmp. 
    {METADATA["shortName"]} --save /tmp

Run without audio and midi. Skips all JACK checks. Used to just look at the GUI, e.g. to make screenshots
    {METADATA["shortName"]} --mute 

[see also]
The  full  documentation for {METADATA["name"]} is maintained as a multi-lingual html site to your systems doc-dir.
For example:
    xdg-open file:///usr/share/doc/{METADATA["shortName"]}/index.html

The documentation can also be found online https://www.laborejo.org/documentation/{METADATA["shortName"]}
"""

with open ("../../documentation/manpageinclude.h2m", "w") as w:
    w.write(manpage_template)

command = f"help2man ../../{METADATA['shortName']} --no-info --include ../../documentation/manpageinclude.h2m > ../../documentation/{METADATA['shortName']}.1"
subprocess.run(command, capture_output=True, text=True, shell=True)


#print ("Built /documentation. You still need to run /documentation/build-documentation.sh manually")
print ("Built template part of documentation.")
