# [![htop](htop.png)](https://htop.dev)

[![CI](https://github.com/htop-dev/htop/workflows/CI/badge.svg)](https://github.com/htop-dev/htop/actions)
[![Coverity Scan Build Status](https://scan.coverity.com/projects/21665/badge.svg)](https://scan.coverity.com/projects/21665)
[![Mailing List](https://img.shields.io/badge/Mailing%20List-htop-blue.svg)](https://groups.io/g/htop)
[![IRC #htop](https://img.shields.io/badge/IRC-htop-blue.svg)](https://web.libera.chat/#htop)
[![Github Release](https://img.shields.io/github/release/htop-dev/htop.svg)](https://github.com/htop-dev/htop/releases/latest)

![Screenshot of htop](docs/images/screenshot.png?raw=true)

## Introduction

`htop` is a cross-platform interactive process viewer.

`htop` allows scrolling the list of processes vertically and horizontally to see their full command lines and related information like memory and CPU consumption.

The information displayed is configurable through a graphical setup and can be sorted and filtered interactively.

Tasks related to processes (e.g. killing and renicing) can be done without entering their PIDs.

Running `htop` requires `ncurses` libraries (typically named libncursesw*).

For more information and details on how to contribute to `htop` visit [htop.dev](https://htop.dev).

## Build instructions

### Prerequisite
List of build-time dependencies:
*  `build-essential` standard GNU autotools-based
*  `autoconf`
*  `autotools`
*  `ncurses`

**Note about `ncurses`:**
> htop requires ncurses 6.0.  Be aware the appropriate package is sometimes still called libncurses5 (on Debian/Ubuntu). Also ncurses usually comes in two flavours:
>* With Unicode support.
>* Without Unicode support.
>
> This is also something that is reflected in the package name on Debian/Ubuntu (via the additional 'w' - 'w'ide character support).

List of additional build-time dependencies (based on feature flags):
*  `sensors`
*  `hwloc`
*  `libcap`

Compiling `htop` requires the header files for `ncurses` . Install these and other required packages for C development from your package manager.

**Debian/Ubuntu**
~~~ shell
sudo apt install libncursesw5-dev autotools-dev autoconf
~~~

**Fedora/RHEL**
~~~ shell
sudo dnf install ncurses-devel automake autoconf
~~~

### Compiling from source:
To compile from sources downloaded from the Git repository (`git clone` or downloads from [Github releases](https://github.com/htop-dev/htop/releases/)), then run:
~~~ shell
./autogen.sh && ./configure && make
~~~

By default `make install` will install into `/usr/local`, for changing the path use `./configure --prefix=/some/path`.

### Install
To install on the local system run `make install`. By default `make install` installs into `/usr/local`. To change this path use `./configure --prefix=/some/path`.

### Build Options

`htop` has several build-time options to enable/disable additional features.

#### Generic

  * `--enable-unicode`:
    enable Unicode support
    dependency: *libncursesw*
    default: *yes*
  * `--enable-pcp`:
    enable Performance Co-Pilot support via a new pcp-htop utility
    dependency: *libpcp*
    default: *no*
  * `--enable-affinity`:
    enable `sched_setaffinity(2)` and `sched_getaffinity(2)` for affinity support; conflicts with hwloc
    default: *check*
  * `--enable-hwloc`:
    enable hwloc support for CPU affinity; disables affinity support
    dependency: *libhwloc*
    default: *no*
  * `--enable-static`:
    build a static htop binary; hwloc and delay accounting are not supported
    default: *no*
  * `--enable-debug`:
    Enable asserts and internal sanity checks; implies a performance penalty
    default: *no*

#### Linux

  * `--enable-sensors`:
    enable libsensors(3) support for reading temperature data
    dependencies: *libsensors-dev*(build-time), at runtime *libsensors* is loaded via `dlopen(3)` if available
    default: *check*
  * `--enable-capabilities`:
    enable Linux capabilities support
    dependency: *libcap*
    default: *check*
  * `--with-proc`:
    location of a Linux-compatible proc filesystem
    default: */proc*
  * `--enable-openvz`:
    enable OpenVZ support
    default: *no*
  * `--enable-vserver`:
    enable VServer support
    default: *no*
  * `--enable-ancient-vserver`:
    enable ancient VServer support (implies `--enable-vserver`)
    default: *no*
  * `--enable-delayacct`:
    enable Linux delay accounting support
    dependencies: *pkg-config*(build-time), *libnl-3* and *libnl-genl-3*
    default: *check*


## Runtime dependencies:
`htop` has a set of fixed minimum runtime dependencies, which is kept as minimal as possible:
* `ncurses` libraries for terminal handling (wide character support).

### Runtime optional dependencies:
`htop` has a set of fixed optional dependencies, depending on build/configure option used:
* `libdl`, if not building static and support for some of the optional libraries is enabled, is always required when support for to optionally load dependencies (i.e. `libsensors`, `systemd`) is present.
* `libcap`, user-space interfaces to the POSIX 1003.1e, is always required when `--enable-capabilities` was used to configure `htop`.
* `libsensors`, readout of temperatures and CPU speeds, is optional even when `--enable-sensors` was used to configure `htop`.
* `systemd` is optional when `--enable-static` was not used to configure `htop` (Linux only). If building statically and `libsystemd` is not found by `configure` support for the SystemD meter is disabled entirely.

`htop` checks for the availability of the actual runtime lib as `htop` runs.

**BSD**
On most *BSD systems you also have `kvm` as a static requirement to read all the kernel information.

More information on required and optional dependencies can be found in [configure.ac](configure.ac).

## Usage
See the manual page (`man htop`) or the on-line help ('F1' or 'h' inside `htop`) for a list of supported key commands.

## Support

If you have trouble running `htop` please consult your Operating System / Linux distribution documentation for getting support and filing bugs.

## Bugs, development feedback

We have a [development mailing list](https://htop.dev/mailinglist.html). Feel free to subscribe for release announcements or asking questions on the development of htop.

You can also join our IRC channel #htop on Libera.Chat and talk to the developers there.

If you have found an issue with the source of htop, please check whether this has already been reported in our [Github issue tracker](https://github.com/htop-dev/htop/issues).
If not, please file a new issue describing the problem you have found, the location in the source code you are referring to and a possible fix.

## History

`htop` was invented, developed and maintained by Hisham Muhammad from 2004 to 2019. His [legacy repository](https://github.com/hishamhm/htop/) has been archived to preserve the history.

In 2020 a [team](https://github.com/orgs/htop-dev/people) took over the development amicably and continues to maintain `htop` collaboratively.

## License

GNU General Public License, version 2 (GPL-2.0)
