/*
 * $Id: senddata.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

/* 
 * send_statlist(buffer) prints (as in inetd), transmits (as in
 * the forking daemon), or broadcast the statistics evaluated with 
 * init_statlist, get_statlist, and eval_statlist, depending on the
 * state of the daemon (determined by runtime flags or commands).
 *
 * I'm going to have to feel my way through this -- daemon behavior is
 * fairly simple (write to stdout if inetd daemon, to socket if forking 
 * daemon).  I don't have a feel for how to wrap or implement the multicast
 * of the data, though, and will have to find some template/boilerplate to
 * see how to go about it.  First we'll just fix the inetd behavior (which
 * will make the daemon much easier to test, too).  This whole note, BTW,
 * should be decrufted when I'm done screwing around here.
 */

void send_statlist()
{

 int i;
 char my_sendbuf[64];

 sprintf(outbuf,"%s %.2f",stats[0].name,stats[0].rate);
 for(i=1;i<N_STATS;i++){
   if(stats[i].avail){
     sprintf(my_sendbuf,"|%s %.2f",stats[i].name,stats[i].rate);
     strncat(outbuf,my_sendbuf,strlen(my_sendbuf));
   }
 }
 strncat(outbuf,"|\n",2);
 buflen = strlen(outbuf);
 sendline(client_fd,outbuf,buflen);

}

/* 
 * This routine is just for verbose forking daemon operation, not for 
 * inetd. In fact, using it will probably break inetd (as in -v and -i need
 * to be orthogonal options at invocation time).  I keep it here 
 * because of its similar structure to send_statlist -- changes in one will
 * need to be mirrored in the other.
 */

void print_statlist(fd_out)
FILE *fd_out;
{

 int i,numfields;

 fprintf(stdout,"#========================================================================\n");
 fprintf(stdout,"# Report on derived values from /proc\n");
 fprintf(stdout,"# interval = %d seconds\n",interval);
 fprintf(stdout,"#========================================================================\n");
 for(i=0;i<N_STATS;i++){
   if(stats[i].avail) fprintf(stdout,"|%s %.2f",stats[i].name,stats[i].rate);
 }
 fprintf(stdout,"|\n");

} /* End eval_statlist */

