# Change Log
All notable changes to this project will be documented in this file.
This project uses the changelog in accordance with [keepchangelog](http://keepachangelog.com/). Please use this to write notable changes, which is not the same as git commit log...

## [unreleased][unreleased]

## [ice coffee.4.][2020-05-21]
 - Updated documentation (@doegox, @iceman1001)
 - Change `pm3test.sh` - more regression tests to  (@doegox, @iceman1001)
 - Change `hf 15 dump` - now supports basic json format (@iceman1001)
 - Change Test and fix many `-Wxxxxxx` warnings [compiler trials] (@doegox)
 - Fix COVERITY warnings [compiler trials] (@doegox, @iceman1001)
 - Fix CPPCHECKER warnings [compiler trials] (@doegox, @iceman1001)
 - Fix CLANG warnings [compiler trials] (@doegox)
 - Change, stricter warnings [compiler trials] (@doegox)
 - Change, remove section version_information for client (@doegox)
 - Change, Add RELEASE_NAME (@doegox)
 - Change, version info also for client (@doegox)
 - Added `make release` (@doegox)
 - Change `trace load` - err if offline mode (@doegox)
 - Fix `standalone mode matty_run` eloadcard (@iceman1001)
 - Added, HF 15 traces (@FlUxIUS)
 - Fix, follow naming conventions [android] (@dxl)
 - Change, work directory supported [android] (@dxl)
 - Added `lf fdx demod` - decoding of Bio-Thermo lf tag. Thanks to Rosco! (@iceman1001)
 - Fix,  32-bit time_t compilation error on [WIN64] (@grspy)
 - Change, LogTrace error msg (@doegox)
 - Change, remove inline [compiler trials] (@iceman1001)
 - Change, adding execute/home/current working directory functions to lua (<@iceman1001)
 - Change, fix max duration in LogTrace (@doegox)
 - Change, first attempt for trace log header (@iceman1001)
 - Change, pm3.sh, attempt to detect BT dongle when udevadm is not available (@doegox)
 - Change, pm3.sh, test access to /dev/ttyXXX files as prerequisite for [linux] (@doegox)
 - iclass bf: avoid slowdown (@doegox)
 - Change, pm3tests.sh, shellcheck (@doegox)
 - Change, pm3.sh, shellcheck (@doegox)
 - Change, pm3.sh, err msgs on stderr (@doegox)
 - Change, pm3.sh, textual and --list with no device, exit 1 (@doegox)
 - Change, pm3.sh, without udev: change detection routine (@doegox)
 - Change, pm3.sh, alternative if udevadm is not available [termux] (@doegox)
 - Change `makefiles` - allow to skip pthread [termux] (@doegox)
 - Change `script run test_t55x7` - enabled param to swap modulation to test (@iceman1001)
 - Add mf_nonce_brute from https://github.com/@iceman1001/mf_nonce_brute and merge to pm3 Makefile (@doegox)
 - Change `lf indala demod` - more lenient size check (@iceman1001)
 - Change clarify BUTTON macro usages (@doegox)
 - Change fix REV macros & hitagS (@doegox)
 - Change, `hf iclass loclass` -removed printvar function (@iceman1001)
 - Change, clock can be negative  (@iceman1001)
 - Change `data tune` (@doegox)
 - fancy timers (@doegox)
 - Change, copied from pm3 repo (@iceman1001)
 - Change psk demodualtion, keep starting samples to easily find the zero init bit (@iceman1001)
 - Change use machine/endian.h with osx (Jamie Fiedler)
 - Fix 2 issues in proxendian.h (@doegox)
 - Fix issue #729. Avoid stalling on non-rdv4 when polling for FeliCa without card in proximity (@doegox)
 - Change `lf nexwatch demod` - lenient demod sizes (@iceman1001)
 - Change `lf nexwath sim/clone` - now supports 88bit format direct. (@iceman1001)
 - Rewrited `standalone mode lf_em4100rwc `, added card bruteforce mode. (Dmitriy Loginoov)
 - Change `data load` - color (@iceman1001)
 - Change appveyor verbose (@doegox)
 - Change `lf nexwatch demod` - now detects type, and show parity /chksum (@iceman1001)
 - Change `lfsampling` - interruptible only when logging not yet triggered (@doegox)
 - Change `lf keri demod - more leanient when it comes to bits (@iceman1001)
 - fix, proper filtering of RL markers (@doegox)
 - Change, clean deps [compiler trials] (@doegox)
 - Change, remove c99 restrictions [compiler trials] (@doegox)
 - Added tracelog file for hf mfu sniff or a ntag (@iceman1001)
 - Change `trace list` - different alloc (@iceman1001)
 - Change, convert OLD -> MIX  (@iceman1001)
 - Change `trace list` - adjust messages (@iceman1001)
 - Fix a mem corruption in `trace load/list` (@doegox)
 - Change, rework banners (@doegox)
 - Change, Let's see if the prompt suffixed spaces are still needed.(@doegox)
 - Fix colored readline prompt bug (@doegox)
 - Change, simpler ul_print_type (@doegox)
 - Fix cmake for reveng [compiler trials] (@doegox)
 - Change, hook reveng outputs to pm3 machinery, add regression test (@doegox)
 - Change, cmake android: add backslashes for host compatibility [compiler trials](@doegox)
 - Change, Translation some comments from Chinese to English. [android] (@dxl)
 - Change, cmake android: use common cmake files for deps [android] (@doegox)
 - Fix, proper way to fix reveng getopt bug(@doegox)
 - Change, cmake deps: add prefix pm3rrg_rdv4_  [compiler trials] (@doegox)
 - Change, cmake deps: add -fPIC so they can be integrated in a pm3 shared lib [compiler trials] (@doegox)
 - Change, platform adaptation [android] (@dxl)
 - Change, don't mix ifdef and defined [android] (@dxl)
 - fix `trace list`- too short array for explanation (@iceman1001)
 - Change, check for sim module fw file (@iceman1001)
 - Change, rpi aling warning [compiler trials] (@iceman1001)
 - Change, more LF demodulation tests (@iceman1001)
 - Change, update whereami and avoid compiling unnneded troublesome parts [compiler trials] (@doegox)
 - Change, rework C includes in C++ [compiler trials] (@doegox)
 - Change, leanient parsing of tcp:/bt:/socket: vars (@iceman1001)
 - Change, add bluetooth group to `make accessrights` (@iceman1001)
 - Change, `Makefile` - fix PKG_CONFIG_ENV (@uli)
 - Change, `f sim` - now only fills until bigbuffer is full (@iceman1001)
 - Change, `hf mf hardnested` - don't drop field when in test mode (@doegox)
 - Change, `lf sim` - better to return err on faulty offset, thanks @iceman (@doegox)
 - Change, `lf sim` - fix offset of last packet (@doegox)
 - Change, `client Makefile` - make sure to rebuild deps when needed [compiler trials](@doegox)
 - Change, silent err if dbus absent [linux] (@doegox)
 - Change, `pm3.sh` - for direct bt devices (@doegox)
 - Change, `pm3.sh` - moved WSL/PS3.x bt native to be tested first. Since call to Win32_serialport crashes it. (@iceman1001)
 - Change, `pm3.sh` - Bt dongle, bt direct listing of serial ports on WSL and PS3.x,  now using powershell.exe since wmic is deprecated (@iceman1001)
 - Change, remove libsndfile (@doegox)
 - Change, enforce PACKED structs [compiler trials] (@iceman1001)
 - Change, adjust number of threads according to cpu (@iceman1001)
 - Change, `hitag2crack` compile flags(@doegox)
 - Change, msdsal fix bug after var de-shadowing (@doegox) 
 - Change, lighter msg for loading prefs, json will anyway always tell the filename (@doegox)
 - Change, make sure colors and emoji are disabled when not on TTY (@doegox)
 - Added `pref` command. PM3 client now support user preferences saved to a json file. (@mwalker33)
 - Added native support for Bluetooth in client [linux] (@doegox)
 - Added `LF_EM4100RSWB` (based on `LF_EM4100RWC`) standalone mode to read/sim/clone/brute EM4100 cards (@Monster1024)
 - Added `HF_MSDSAL` standalone mode which read and emulate Visa EMV cards (@Netxing)
 - Added `hf mfu tear` - Mifare Ultralight tear off experiment (@cintainfinitam, @fukmar)
 - Added Mifare Desfire Read/Write/Create files/records/values functionality and several fixes to `hf mfdes` (@bkerler)
 - Added CreateStdFile command to Mifare `hf mfdes` (@bkerler)
 - Rework des/3des/3k3des/aes auth. Port to mbedtls crypto library on device (@bkerler)
 - Port `hf mfdes` Authentification to CommandNG structure, fix auth session key (@bkerler)
 - Updates `hf mfdes` functions, improved logging and added new commands (@bkerler)
 - Updated 'legic.lua' and 'legic_clone.lua' script - works with current command set (@Pizza_4u)
 - Rewrote `hf mfdes` functions and added apdu debugging (@bkerler)
 - Add Mifare Desfire GetDFNames and improve HF MFDES Enum output (@bkerler)
 - Fix Mifare Desfire select appid handling (@bkerler)
 - Improved `hf 14a info` - card detection handling (@bkerler)
 - Updated helptext layout in all luascripts (@iceman1001)
 - Change `hf mfdes info` - output and logging (@bkerler)
 - Updated texts in `hf legic` commands (@ikarus23)
 - Fix timing bug inside 40x5 (@mwalker33)
 - Refactored all Hitag2 attacks (@doegox)
 - Added two new Hitag2 attacks (@doegox)
 - Change `hf iclass decrypt` - limit amount of data to read if wrong app limit (@iceman1001)
 - Change `hf search` - now continue to search in case of dual tech cards (@iceman1001) Thanks to @ikarus23 for the suggestion!
 - Added `hf topas info` - old reader command,  now also prints NDEF (@iceman1001)
 - Change `hf topaz reader` - now only prints lighter info, like UID. (@iceman1001)
 - Change `hf iclass readtagfile` - improved param handling (@iceman1001)
 - Change `hf mfu ndef` - text record now correctly decode language code and test (@iceman1001) Thanks to @bettse!
 - Updated the helptexts for `hf iclass` commands (@iceman1001)
 - Fix NDEF TLV lock / memory parsed correct (@merlokk)
 - Change `mem spiffs` commands now parse h param correct (@iceman1001)
 - Add colour to `hf mf chk` and `hf mf fchk` (@dunderhay)
 - Change - updated public keys info (@bkerler)
 - Change - mfc default keys removed dublicates (@iceman1001)
 . Change - mfc default keys got new entries found on TagInfo app (@bkerler)
 - Added `hf mfu ndef` - read and decode NDEF Type2 messages (@iceman1001)
 - Added `data ndef` - decode NDEF messages (@iceman1001)
 - Change - usb write's now waits for shiftregisters (@pwpiwi)
 - Change - NDEF supports more signatures now (@iceman1001)
 - OSX Makefile now supports `make style` and `make checks` (@Pizza_4u)
 - Added `HF_LEGIC` standalone mode to read and simulate a Legic prime tag (@Pizza_4u)
 - Added keri MS decode/encode and update `lf keri clone` to support MS fc/cid cloning. (@mwalker33)
 - Fix `hf mfdes enum` - now actually manages to enumerate files under all AID's. :smiley:  (@iceman1001)
 - Fix `hf mfdes info` - now detects DESFire light and work properly Wrapped commands :+1: (@iceman1001)
 - :smiling_imp: support (@doegox)
 - Additional colour changes as recommended by @iceman (@dunderhay)
 - Change type colour for `hf 14a` card types (@dunderhay)
 - Add colour to `hf mfdes` command (@dunderhay)
 - Add `HINTS` command.  Will turn off / on hint messages. Default mode is OFF.  (@iceman1001)
 - Add colour to `hf 14a` and `hf mfu` commands (@dunderhay)
 - Add colour to `lf hid` commands (@dunderhay)
 - Change `script run hf_bruteforce -s start_id -e end_id -t timeout -x mifare_card_type` - The hf_bruteforce card script now requires Mifare type (mfc or mfu) (@dunderhay)
 - Updated `hf_bruteforce.lua` script - added support for brute forcing Mifare Ultralight EV1 cards (@dunderhay)
 - Added `hf mf personlize` - personalize the UID of a Mifare Classic EV1 card (@pwpiwi)
 - Change - hint texts added to all lf clone commands (@iceman1001)
 - Change `lf keri demod` - adjusted the internal id. (@mwalker33)
 - Added seamless integration with cryptohelper (@iceman1001)
 - Change `lf hid brute` - new params for direction (UP/DOWN); textual and main loop actually exit. (@capnkrunchy and @iceman1001)
 - Fix `lf hid brute` - made it work again (@capnkrunchy)
 - Fix standalone mode HF_MATTYRUN - correct logic when all keys found in printing. partial fix  (@iceman1001)
 - Change static nonce detection got tighter (@iceman1001)
 - Improved termux notes (@msoose)
 - Fix `hf mf autopwn` - works on debian 10 *nix. Bad exit commands in hardnested (@iceman1001)
 - Fix `hf mf hardnested` - bad mutex strategies (@msoose)
 - Change `lf hitag` - now obeys `lf config` (@iceman1001)
 - Ported all python 2 scripts to python 3 (@doegox and @sigwinch28)
 - Removed undefined exit behaviour from `analyzesize` tool: it now exits with code 2 when called with wrong args (@sigwinch28)
 - Replaced shebangs in scripts with more portable versions which use `/usr/bin/env` (@sigwinch28)
 - Added `hf lto restore` - restore LTO cartridge memory from dump file [.bin|.eml] (@Kevin-Nakamoto)
 - Added `LF_ICEHID` standalone mode which searches for lf HID credentials and store to RDV4 flashmem (@iceman1001)
 - Added `HF_14ASNIFF` standalone mode with storing trace to RDV4 flashmem (@micolous)
 - Added `hf lto dump` - dump 8160 bytes of data from LTO cartridge memory and save to file (@Kevin-Nakamoto)
 - Change `data plot` - write serial port name in window title for plot / slider window (@iceman1001)
 - Added `hf lto wrbl` - write block support for LTO Cartridge memory (@Kevin-Nakamoto)
 - Fix compilation under openSUSE (@hsanjuan)
 - Added `lf nexwatch sim` - use raw hex to simulate (@iceman1001)
 - Fix `lf indala read` - long id 224bits preamble identification less strict (@iceman1001)
 - Added `hf mf staticnested` - useful when targeting the strange cards with a static nonce. (@iceman1001) Thanks to @xtigmh @uzlonewolf for their solutions.
 - Added `hf plot` (@pwpiwi)
 - Fix `lf config` - when called with no params, it no longer mess up all device lf config settings. (@iceman1001)
 - Change `lf indala clone` - new option `--Q5` writes to q5/T5555 tags. (@iceman1001)
 - Change `lf indala clone` - new option `-c <card id>` allows cloning INDALA tag from Heden2L/Hedengren ID format (@iceman1001) - Thanks to @randomdude42 for solution
 - Change `lf indala demod` - added decode Heden2L/Hedengren format (@iceman1001) - Thanks to @randomdude42 for solution
 - Added `commands.md` - document with all proxmark client commands. Generated with XX_internal_command_dump_markdown_XX. (@iceman1001)
 - Change `lf pac clone` - new option `c <card id>` to allow cloning PAC/Stanley tag from card ID (@danshuk)
 - Change `lf pac read` - decoded PAC/Stanley card ID (@danshuk)
 - Change mifare classic keytable output refactored and uses colors (@iceman1001)
 - Fix `hf mf nested` - now writes the correct blockno (@iceman1001)
 - Change `lf t55xx dump` - now supports saving to JSON (@iceman1001)
 - Change `hf mf chk | fchk`  faster authentication by lower timeout limit. (@pwpiwi)
 - Change `hf mf hardnested` - now detects "static / fixed" nonce tags and exits (@iceman1001)
 - Change `hf mf csave` - now uses UID in filename (@iceman1001)
 - Fix `hf mf chk` - read block B logical error. #489 (@iceman1001)
 - Added `hf mf ekeyprn d` - new parameter to save keys to file (@iceman1001)
 - Added `mfu_magic.lua` - script to interact with your magic NTAG tag. (@iceman1001)
 - Added `hf_bruteforce.lua` - script bruteforces uid for 14a using hf 14a sim (@keld)
 - Added `tools\pm3_cs8.pl` - convert .pm3 files to wave format (@samyk)
 - Added `tools\pm3_amii_bin2eml.pl` - amiibo convering script (@samyk)
 - Change `hf 14a info` - now detects "static / fixed" nonce tags (@iceman1001)
 - Change `data save f <filename> w` - params reworked.  (@iceman1001)
 - Change `hf search` - now should detect LTO-CM tags (@iceman1001)
 - Added `hf lto info` - skeleton support for LTO Cartridge memory (@iceman1001)
 - Added saving as wave format (@anon)
 - Added ISO15_WRITE annotation (@pwipiw)
 - Added `lto_dump.lua` @kevin
 - Added `hf mf cwipe` magic chinese card (gen1a) wipe to default state (@merlokk)
 - Added `pm3_mf7b_wipe.py` python script. Wipes magic S70 7B Gen2 card. (@vulnersCom)
 - Added `hf mfp chk` Mifare plus command for check keys from public keys list, from dictionary or 1 and 2-byte bruteforce (@merlokk)
 - Change `hf 15` - some refactoring (@grspy)
 - Added `hf 15 writeafi` and `hf 15 writedsfid` (@grspy)
 - Added detailed info for SLIX2 tags in `hf 15 info` (@grspy)
 - Fix `hf list felica` and `hf felica sniff` (@7homasSutter)
 - Added `hf felica wrunencrypted` (@7homasSutter)
 - Added `hf felica rdunencrypted` (@7homasSutter)
 - Added `hf felica rqresponse` (@7homasSutter)
 - Added `hf felica rqservice` (@7homasSutter)
 - Added polling for felica standard (@7homasSutter)
 - Added `lf t55xx dump save` and `lf t55xx restore` for .bin and .eml files (@mwalker33)
 - Added `lf t55xx detected` to try without password first (@mwalker33)
 - Change `lf indala read` - added indala 26bit decoding (@martinbeier)
 - Change `lf t55xx detect` to try without password first (@mwalker33)
 - Display high bit for detected Kastle HIDs to allow `lf hid clone [id]` to work properly (@swg0101)
 - Added option `-n` to scripts pm3* (@doegox)
 - Added `wiegand list/encode/decode` - wiegand format manipulation. Adapted to fit here. (@grauerfuchs)
 - Added support for color text on windows 10 (@mwalker33)
 - Added `s` <samples to skip> to `lf config` / `lf sniff` to skip samples when sniffing based on same option in Proxmark/proxmark3 by @marshmellow42. (@mwalker33)
 - Added save to .eml and .bin for `em 4x05_dump` (@mwalker33)
 - Added option `-n` to scripts pm3* (@doegox)
 - Fix `em 4x05_dump` to print all blocks read (@mwalker33)
 - Fix T55xx config getting displayed when using password when no password needed on read. (@mwalker33)
 - Added T55x7 downlink mode auto usage via mode detected (lf t55 detect) (@mwalker33)
 - Added `lf t55xx protect` - sets password and enables password protection on t55x7 tag (@iceman1001)
 - Change `lf t55xx wipe` - now accepts user provided configuration block (@iceman1001)
 - Added T55x7 downlink mode support r <mode> 0 Default, 1 Long Leading 0, 2 Leading 0, 3 1 of 4 and 4 (in some commands) try all. (@mwalker33)
 - Change proxmark3-flasher is now merged into proxmark3 client. Add pm3-flash (@doegox)
 - Change `hf iclass clone\dump\rdbl\wrbl` - now uses NG (@iceman1001)
 - Fix `hf iclass clone` - last block always fails (@iceman1001)
 - Change `hf iclass clone` - retries ten times, less output (honor verbose)  (@iceman1001)
 - Change `hf iclass dump` - retries ten times, less output (honor verbose)  (@iceman1001)
 - Rename `hf iclass writeblk` ->  `hf iclass wrbl` to match hf mf wrbl (@iceman1001)
 - Rename `hf iclass readblk` ->  `hf iclass rdbl`  to match hf mf rdbl (@iceman1001)
 - Added cmdscript example and show usage with shebang (@doegox)
 - Added instructions for Fedora (@doegox)
 - Change reduce the list of requirements to the minimum and move to QT5 (@doegox)
 - Added `make install` and reorganize/rename stuffs accordingly (@doegox)
 - Added searchFile for several types of files (@doegox / @iceman1001)
 - Change posix sh version of mkversion (@doegox)
 - Change remove entirely ncurses, not needed nowadays (@doegox)
 - Change remove deprecated termcap, use ncurses instead (@ZeroChaos-)
 - Change `hf iclass encrypt` - now takes transport key as param. (@iceman1001)
 - Change `hf iclass decrypt` - now takes transport key as param. (@iceman1001)
 - Change `hf mf fchk m` - now secretly dumps card to emul, if all keys are found (@iceman1001)
 - Change history and logfile are now saved into $HOME/.proxmark3/ (@doegox)
 - Change optimization of iclass mac calculations on deviceside (@pwpiwi)
 - Added `hf mf autopwn` - Autopwn function for Mifare Classic, extract all keys and dump card memory (@matthiaskonrath)
 - Added Lua paths: look for scripts also in ~/.proxmark/lua{scripts,libs} and /usr/local/share/proxmark3/lua{scripts,libs} (@doegox)
 - Change Lua directory scripts/ to luascript/ (@doegox)
 - Change non-rdv4 PLATFORM must now use the generic PM3OTHER, simpler (@doegox)
 - Fix reveng integration for all platforms else than WIN32 (@doegox)
 - Added cheat sheet for easy operations of the Proxmark3 (scund00r)
 - Chg commands are now in green in the helptext list (@iceman1001)
 - Fix `script run ndefdump` - better exit messages when failing (@iceman1001)
 - Fix `hf iclass dump` - now also saves in EML format (@iceman1001)
 - Fix `hf iclass sim 3` - now works on legacy readers and legacy SE readers (@iceman1001)
 - Rework hitag2 read/write help (@ViRb3)
 - Added `lf nedap` - encoding / decoding  (anon)
 - Added client option `-i` to stay in interactive mode after a script or command (@DidierStevens/@doegox)
 - Added VSCode tasks (@ViRb3)
 - Better warn user of hardcoded hitag info (@ViRb3)
 - Format and docs hitag (@ViRb3)
 - Fix hitag password write offset by 1 (@ViRb3)
 - Fix momentarily flash read/write of dicts (@doegox/@cjbrigato)
 - Added some more default keys (@anon)
 - Added `hf thinfilm sim` simulating Thinfilm NFC barcode tags (@doegox)
 - Added `hf thinfilm list` specific trace decoding (Thinfilm NFC barcode tags) (@doegox)
 - Fix `hf topaz reader` - don't crash when trying to read a Thinfilm tag (@iceman1001)
 - Added `hf thinfilm info` - read / decode Kovio Thinfilm NFC barcode tags (@iceman1001)
 - Added FPGA LF adc path (@anon)
 - Added ECC support / check for NID_secp128r1 (@pwpiwi)
 - Added some more default keys (ollibolli)
 - Fix T55x7 Downlink timings backward compatible (@mwalker33)
 - Added proper Makefile halting when using incompatible STANDALONE and PLATFORM vars (@doegox)
 - Added T55x7 Downlink mode support (@mwalker33)
 - Added SPIFFS Flash filesystem support (@cjbrigato)
 - Fix support for flashing 512K units with old bootrom (@slurdge/@doegox)
 - Fix `hf mf sim` - wrong access rights to write key B in trailer (@McEloff)
 - Added option -i to flasher to query Pm3 for its memory size (@doegox)
 - Added support for flashing 512K units (@slurdge)
 - Added a simple python tool to check the elf sizes (@slurdge)
 - Change: new keys for Vigik badges in default_keys.dict (@luminouw)
 - Added `hw standalone` to jump to standalone mode from command line or script (@doegox)
 - Added to `hf 14a apdu` print apdu and compose apdu (@merlokk)
 - Change: buggy `mem read` removed, `mem save` renamed `mem dump`, can now display too (@doegox)
 - Fix: timeout for mem wipe was too short, thanks @cjbrigato (@doegox)
 - Fix `hf mf sim` - Mifare Classic simulation more flexible anti-collision check (@McEloff)
 - Change: `hf mf sim` - Mifare Classic simulation not respond NACK on invalid authentication request (@McEloff)
 - Change: `read_pwd_mem.lua` now handles Mifare Classic dictionaries large than 4096 bytes (@iceman1001)
 - Change: Do not clear trace log during `hf mf chk`, to save whole process history (@McEloff)
 - Added `msleep` command, for pauses in scripts (@doegox)
 - Added support for WSL in proxmark.sh (@doegox)
 - Added documentation for usage of Proxmark3 under WSL (@doegox)
 - Change: replace aes.c with mbedtls version (@slurdge)
 - Change: replace ukbhit by kbd_enter_pressed, not requiring tcgetattr (@xianglin1998/@doegox)
 - Added config for RaspberryPi in JTAG tools (@doegox)
 - Added config for FTDI C232HM-DDHSL-0 in JTAG tools (@doegox)
 - Fix compilation under MacOSX with binutils (@matrix)
 - Added dynamic report of the chipID for flashing purposes (@slurdge)
 - Fix Clang warnings (@matrix)
 - Fix EMVGPO bug (@matrix)
 - Added hitag2 write password auth (@ViRb3)
 - Added check if bootloader segment is within bounds (@slurdge)
 - Added `hf 15 csetuid` - set UID on ISO-15693 Magic tags (@t0m4-null)
 - Change: Print help if unknown arg for hitag reader/writer (@ViRb3)
 - Fix clock deadlock in hitag sniff (@ViRb3)
 - Added compiler info in client & ARM sections (@slurdge)
 - Added support for automatic COM detection on Windows (@slurdge)
 - Added support for compilation on RaspberryPiZero (armv6) (@doegox)
 - Change: updates to README (@iceman1001)
 - Change: `hf mf/mfu dbg` => `hw dbg` (@doegox)
 - Change: replace usb_poll_validate_length() by data_available() that supports USART too (@doegox)
 - Make sure standalone modes can be launched when connected on USB without client (@doegox)
 - Change: cleaner makefile execution, use `make V=1` if you want to see full lines (@doegox)
 - Change: automate make clean when platform definitions are changed (@doegox)
 - Added STANDALONE option to Makefile.hal (@Fl0-0)
 - Change: mem info - production public key to verify rdv4.0 flash  signature (@iceman1001)
 - Fix specify that we need TCP and not UDP connection (@phcoder)
 - Change: lf cotag demod - adjusted error trigger (@iceman1001)
 - Added documentation on BT add-on (@iceman1001/@doegox)
 - Change: new button behaviour in bootloader mode, no need to keep it pressed, press again to interrupt (@doegox)
 - Change: new keys in dicts, new mem layout to accomodate them (@iceman1001/various)
 - Fix lf sim -  if called with empty graphbuffer all strange things happend, like turning on HF field (@iceman1001)
 - Change: hf 14a sim / hf mf sim - check buttonpress/usb frame fewer times in order not to disrupt simulation (@McEloff)
 - Change: data convertbitstream - converts bit to max/min in order to facilitate demodulation of simulation data (@iceman1001)
 - Change: lf em 410x_demod - now can demod the simulation data (@iceman1001)
 - Added HC-06 scripts for BT add-on (@doegox)
 - Fix lf nedap sim - error when adding parity (@iceman1001)
 - Added documentation on UART and baudrates (@doegox/@iceman1001)
 - Change: prompt now shows which channel is used (@iceman1001)
 - Change: USART baudrates computation, up to 6Mbps (@iceman1001/@doegox)
 - Change: hf mf nack - keep sync if started without card over antenna
 - Added usart btfactory - to reset a misconfigured BT add-on (@doegox)
 - Change: hw status - now prints number of dictionary keys loaded (@iceman1001)
 - Added home, end, pageup, and pagedown keybinds to the plot GUI. Also fix paged movement in GUI. (@mcd1992)
 - Change legic.lua saves data in EML and BIN formats (@iceman1001)
 - Change hf tune - is now synchronous (for BT add-on) and can be interrupted by kbd (@doegox)
 - Change: update macOS install instruction (@ Uli Heilmeier)
 - Added trace ouput in hexdump format for Wireshark import (@ Uli Heilmeier)
 - Added usart btpin - to change BT add-on PIN (@doegox)
 - Added reconnection support (@iceman1001/@doegox)
 - Added usart tx/rx/... - USART developer commands (@doegox)
 - Added PLATFORM_EXTRAS, WITH_FPC_USART_HOST, BTADDON Makefile configuration (@doegox)
 - Fix slow reconfigure on mingw of serial port (@iceman1001)
 - Fix cross thread communictions of timeout variable (@iceman1001)
 - Change: client is now "universal", adapting to Proxmark3 capabilities (@doegox)
 - Added disconnect support to Lua (@iceman1001)
 - Change: handles FPC/FLASH FW more gracefully on non-RDV4 pm3 (@doegox)
 - Added JTAG support for Shikra (@NinjaStyle82)
 - Change: smart color handling: only if linux and on real term (@doegox)
 - Change: reconfigure uart timeouts when compiled for FPC and connecting over USB (@iceman1001)
 - Change: fast push for many commands (@iceman1001/@doegox)
 - Added: fast push for Lua (@iceman1001)
 - Added NDEF parser in Lua (@iceman1001)
 - Change: improve NDEF parser (@iceman1001)
 - Change: all commands got migrated to MIX/NG packet format (@iceman1001/@doegox)
 - Fix: Mifare Ultralight read block missing bytes (@doegox)
 - Added support new frame format in all Lua scripts (@iceman1001)
 - Added CMD_CAPABILITIES for pm3 to inform dynamically the client (@doegox)
 - Change baudrate handling, make it clear it is only indicative for USB-CDC & BT (@doegox)
 - Change: new progressive light scheme for `hw detectreader` (@doegox)
 - Added common error definitions system for retvals (@doegox)
 - Change USART RX & TX code and fix delays handling to make it more robust, especially over BT (@doegox)
 - Added support for new frames format, speedup & huge changes, see doc/new_frame_format.txt (@doegox)
 - Change: loadFile* & saveFile* accept filenames with (or still without) extension (@doegox)
 - Fix LoadEML to accept final "\n", e.g. from pm3_mfd2eml.py (@doegox)
 - Change: rework shell scripts for easy client or flasher (@doegox)
 - Fix: stop poking Internet when compiling (@doegox)
 - Added support for multiple commands to "-c", e.g. proxmark3 -c "hw ping;hw version" (@doegox)
 - Fix external flash writing bitflips issues at 24MHz (@doegox)
 - Added color support to Dbprintf & alike and rework Dbprintf flags (@doegox)
 - Change: archive (and fix) hid-flasher (@doegox)
 - Added standalone placeholder to simplify new standalone integration (@doegox)
 - Change: refactor standalone mode info string (@iceman1001)
 - Added iceman skeleton standalone mode for ppl to use as base for their new modes (@iceman1001)
 - Change: move compilation options to Makefile.hal (@doegox)
 - Fix compilation under OSX (@iceman1001)
 - Added openocd config files for JLink (@doegox)
 - Fix compilation dependencies for recovery (@doegox)
 - Fix segfault when loading a file (@doegox)
 - Change/Add new dump format for Ultralight/NTAG, counters support, simulation (@mceloff)
 - Added `hf mf sim` full-byte split anticollision support (@mceloff)
 - Fix/Add `hf mf sim` bugs fix, RATS support, etc (@mceloff)
 - Fix serial of FPC. (@ryan)
 - Fix `data shiftgraphzero` corrupting end of GraphBuffer (@doegox)
 - Fix `hf legic info` - unsegmented card now uses card size to calc remaining length (@iceman1001)
 - Added 36bit HID format, extend calcWiegand() to include oem bits (@davidbeauchamp)
 - Fix `hf mf hardnested` - not verify key when reading nonce file (@iceman1001)
 - Change optimizations for ask/bi (@iceman1001)
 - Fix `hf mf sim` - bugs fix, refactoring (@mceloff)
 - Added WRITE and COMPATIBLE_WRITE support to Mifare Ultralight/NTAG simulation (@mceloff)
 - Change installation instructions and add video links (@5w0rdfish)
 - Change `hf mf sim` to support more types (@vratiskol)
 - Change better strong wave detection for biphase (@iceman1001)
 - Added `script run test_t55x7` (@iceman1001)
 - Added new lua scripting support for some t55xx commands (@iceman1001)
 - Added FPC USART for BT add-on with pm3 client. (@doegox)
 - Added `-b baudrate` option to the pm3 client. (@doegox)
 - Change `lf t55xx info`: tell if known configuration block0. (@iceman1001)
 - Fix/Add FPC usart: fix TX, bring RX, full speed. (@doegox)
 - Change `lf t55xx config` options: allow to toggle on/off i/q5/st
 - Change `lf t55xx info`: support offline block0, Q5, fix extended, add warns. (@doegox)
 - Avoid race condition when flasher finds the not yet closed pm3 port. (@doegox)
 - Fix `lf t55xx trace`: read the proper block. (@doegox)
 - Fix Indala 64 on T55xx: use PSK1. (@doegox)
 - Force proper Linefeed (LF) handling in ProxSpace. (@vratiskol)
 - Fix Makefiles race conditions to allow parallel compilation, e.g. `make -j8`. (@doegox)
 - Added - dictionary key file for MFU. (not in use at the moment) (@mazodude)
 - Change `lf fdx demod` - better biphase maxerrors. (@MalteHillmann)
 - Change `hf mf sim` - now works better against android (@mceloff)
 - Fix `lf t55xx brute` - now works after aquiredata adaptations (@iceman1001)
 - Fix `lf t55xx chk` - now works after aquiredata adaptations (@iceman1001)
 - Fix `lf t55xx recoverpwd` - now works after aquiredata adaptations (@iceman1001)
 - Fix `data detect p` - reverted bad clock detection (@iceman1001)
 - Change `data detect a` - better clock detection (@iceman1001)
 - Added `hf 14a info` - now detects some magic card Gen2 (@iceman1001)
 - Removed `LCD` code in armsrc compilation (@iceman1001)
 - Change - Generic fixes of codestyle (@doegox) (@iceman1001)
 - Change `lf indala demod` - refactoring (@iceman1001)
 - Change - handling fault bit markers (7) and partial nibbles in hex printing (@doegox)
 - Change - printing of fault bit markers (7) using a dot (@doegox)
 - Change `sc upgrade` - firmware file integrity check (@pwpiwi)
 - Fix `data rawdemod am` - last bit was missing (@doegox)
 - Fix `hf 15 dump f` - also selects tag first (@iceman1001)
 - Fix `hf iclass clone` - missing fileclose (@iceman1001)
 - Added `trace list hitag` - old hitag annotations now use the new trace (@iceman1001)
 - Change `lf hitag sim` - loads bin/eml/json (@iceman1001)
 - Change `lf hitag reader 21` - saves in bin/eml/json (@iceman1001)
 - Change `lf hitag` - refactoring (@iceman1001)
 - Change `lf hitag` - refactoring (@pwpiwi)
 - Fix `lf hitag` - generic fix for missing clock init (@pwpiwi)
 - Fix fsk sim operations on deviceside - avoid division by zero (@doegox)
 - Fix `hf mf fchk` - condition always false (@doegox)
 - Fix `lf t55xx recoverpw` - shift as u32 (@doegox)
 - Fix `lf ti demod` - shift as u32 (@doegox)
 - Fix `lf ti read` - shift as u32 (@doegox)
 - Fix `lf t55xx chk` - condition always false (@doegox)
 - Change `lf sim` - ledcontrol refactoring (@doegox)
 - Fix `hf mf nack` - signedness bug (@doegox)
 - Fix `hf epa cnonce` - check return value (@doegox)
 - Fix `lf hitag write` - condition always true (@doegox)
 - Fix `mem write` - added extra check (@doegox)
 - Fix `iso15693` - bad string cpy (@doegox)
 - Fix `make style` - EOF LF support (@doegox)
 - Added `hf 14b raw` - added -t for timeout  (@iceman1001)
 - Rename `lf hitag snoop` - renamed to `lf hitag sniff` (@iceman1001)
 - Rename `lf snoop` - renamed to `lf sniff` (@iceman1001)
 - Rename `hf snoop` - renamed to `hf sniff` (@iceman1001)
 - Fix `hf mfp wrbl` - more blocks available (@merlokk)
 - Added `make platform` - compile for non-rdv4 devices made simpler (@doegox)
 - Change Makefiles optimizations when recompiling (@doegox)
 - Fix `data load` - loads TITEST.txt again (@iceman1001)
 - Change `lf search` - now detects TI (@iceman1001)
 - Change fixing signal cleaning for LF (@doegox)
 - Fix `lf paradox demod` - wrong check (@iceman1001)
 - Change `lf t55xx` - aquiredata uses getsamples (@iceman1001)
 - Fix `lf search` - chipset detection restore demod buffer again (@iceman1001)
 - Added `make style` (@doegox)
 - Fix mixed tabs vs spaces. Now only use 4 space as tab. (@doegox)
 - Fix `lf visa2000 read` - too few samples (@iceman1001)
 - Fix `lf t55xx bruteforce` - infinity loop (@doegox)
 - Fix `analyse nuid` - correct crc (@doegox)
 - Added command history not repeating logged commands (@doegox)
 - Fix path for aidjson (@doegox)
 - Fix missing init i2x (@doegox)
 - Fix `14b select card` - (@doegox)
 - Added `hf mf ndef` - parsing of NDEF messages (@merlokk)
 - Added `hf mf mad` - parsing of Mifare Application Directory (@merlokk)
 - Rename `lf snoop` -> `lf sniff` (@iceman1001)
 - Rename `hf snoop` -> `hf sniff` (@iceman1001)
 - Change generally added more colors (@iceman1001)
 - Change `sc upgrade` updated firmware v3.11 (RDV40) (@sentiprox)
 - Change `data autocorrelate` - better visual representation and added extra peak detection (@iceman1001)
 - Fix `lf search` - false positive indala identification fixed (@iceman1001)
 - Added `lf keri` - basic support for Keri tags (@iceman1001)
 - Added `hf mf list` - re-added it again (@iceman1001)
 - Fix - A lot of bugfixes, like memory leaks (@iceman1001)
 - Change `hf 14a antifuzz` - original implementation (@asfabw),  reworked a bit
 - Fix `hf mf fchk` (@iceman1001)
 - Fix `usb slow on posix based systems` (@fl0-0)
 - Change `lf pcf7931` - improved read code (@sguerrini97)
 - Change `hf felica list` - started with some FeliCa annotations (@iceman1001)
 - Fix `hf tune` - now works as expected (@iceman1001)
 - Added `option to use flash memory to upload dictionary files` (RDV40) (@iceman1001)
 - Fix `printing percentage now standard compliant` (@fabled)
 - Added `emv roca` - command to test for ROCA vuln in public RSA modulus (@merlokk / @iceman1001)
 - Added TCP ports support (on linux) (@phcoder)
 - Added HF sniff standalone mode with optional storing of ULC/NTAG/ULEV1 authentication attempts (@bogiton)
 - Fix `Lining up plot and control window` (@anticat)
 - Fix `annoying focus behaviour` on OSX  (@Anticat)
 - Implemented AppNap API, fixing #283 and #627 OSX USB comm issues (@AntiCat)
 - Added `sc brute` - a naive SFI bruteforcer for contact smartcards (RDV40) (@iceman1001)
 - Change `lf t55xx detectconfig` - now optional to persist settings to flashmem (RDV40) (@iceman1001)
 - Change `hf mf csave` - now saves both EML/BIN formats (@iceman1001)
 - Change `hf mf esave` - now saves both EML/BIN formats (@iceman1001)
 - Fix `compiler warning on macos and gcc7.1 or higher`  (@TomHarkness)
 - Fix `crash on Bionic libc if CloseProxmark is called twice` (@micolous)
 - Change `lf hid` - got an  updated to Kastle format (@xilni)
 - Added `lf t55xx deviceconfig` - enables custom t55xx timing settings. (RDV40) (@iceman1001)
 - Chg adaptations for FPC communications (work in progress)  (@iceman1001)
 - Fix `stand-alone Colin` - remake to benefit from flashmem for persistence. (@cjbrigato)
 - Fix `LEGIC SIM` - remake of legic sim (@drandreas)
 - Changed `proxmark3 client threading`  - remake from official repo (@micolous)
 - Added `rem` - new command that adds a line to the log file (@didierStevens)
 - Fix `EM410xdemod  empty tag id in lfops.c` (@Defensor7)
 - Fix `usb device descriptor` - some android phones will enumerate better when iSerialnumber is not a multiple of 8 (@micolous, @megabug)
 - Fix `StandaloneMode LF` -  when collecting signal, justNoise detection is needed (@didierStevens, @Megabug)
 - Fix `StandAloneMode Colin` - mifare1ksim called with right params (@cjbrigato)
 - Improved `install.sh` to install dependencies for Ubuntu 18.04 and using max number of processors during compilation (@joanbono)
 - Modified `install.sh` script to work in macOS and Linux + added the `update.sh` and `proxmark3.sh` from joanbono (@TomHarkness)
 - Fix `hf emv` - some cards need to have Le=0x00, some do not need to have (@merlokk)
 - Fix `hf legic`  enhancement of rx / tx in legic commands (@drandreas)
 - Fix `data buffclear` - now frees bigbuff also (@iceman1001)
 - Fix GET_TICKS  and signess while shifting (@drandreas)
 - Added `hf 14b dump` - now dumps to file (bin & eml)  (@iceman1001)
 - Fix fixed xcorrelation for strong signal (@drandreas)
 - Fix `hf mf chk` - keytype was reversed (@TomHarkness)
 - Added strange vid/pid found in wild.  Could be pm3 easy clones. (@iceman1001)
 - Fix `make udev`  -  udev filename could be in conflict,  renamed.  (@blshkv)
 - Fix `lf t55xx config`  - wrong sized array disabled FSK1a/FSK2a as options (@grauerfuchs)
 - Added more default keys  (@j8048188) (@iceman1001)
 - Added `sc list/info/raw/reader/upgrade` - (RDV40) smart card module functionality  (@iceman1001)
 - Fix `download eml buffer` (@drandreas)
 - Changed `exclusion of floatingpoint lib` (@pwpiwi)
 - Changed `lua scripts bit32 calls` (@iceman1001)
 - Changed `hw version`  (@pwpiwi),   adapted to iceman fork (@iceman1001)
 - Added `amiibo functionality`  (@jamchamb),   adapted to iceman fork (@iceman1001)
 - Fix `hf legic`  (RDV40) adaptations to FPGA HF enhanched reading distance (@iceman1001)   Thanks to @drandreas!
 - Added `script run mifare_acces` - script to decode Mifare classic accessbits (@Neuromancer)
 - Added `mem load/save/wipe` - commands to upload / download to new RDV40 onboard flashmemory (@iceman1001)
 - Added `script run mifareplus` - script to communicate with a mifare plus tag (@dceliano)
 - Added FlashMemory functionality  (RDV40)  (@willok)
 - Fix `hf mfu dump` - partial reads lead to corrupt data (Thanks @elafargue for pointing it out)
 - Changed `hf mfu dump / read`  - now retries five times. (@jamchamb)
 - Added `hf list mf` - deciphers crypto1 stream and works with first authentication and weak nested authentications (@Merlok)
 - Adjusted `lf cmdread` to respond to client when complete and the client will then automatically call `data samples` (@marshmellow42)
 - Added a bitbang mode to `lf cmdread` if delay is 0 the cmd bits turn off and on the antenna with 0 and 1 respectively (@marshmellow42)
 - dump / restore now uses custom filenames (@brianpow)
 - Removed `hf mf sniff` ,  (@iceman1001),  use HF 14A SNIFF instead
 - Added `hf iclass lookup` (@iceman1001)
 - Added `hf iclass chk` (@iceman1001)
 - Fixed ADC mux all closed push-pull state (@iceman1001)
 - Fix `hf mf darkside` - speed fixes (@pwpiwi)
 - Fix `hw tune`  -  now compensates for 3% error in output,  also measure full 140v using ADC channel 5 and 7.  (@iceman1001)
 - Updated loclass gpl license (@holiman)
 - Fix Antenna on after changed FPGA Mode. (@iceman1001)
 - Added `hf mf nack` - Mifare NACK bug detection (@iceman1001) (@doegox)
 - Fix `hf mf mifare` - zero parity works, no more double runs for normal darkside (@iceman1001)
 - Added `hf mf fchk` - the fastest check keys implementation tothisday (@iceman1001)
 - Fix `hf iclass` - more stable demod (@iceman1001)
 - Added `hf iclass chk`  - check keys from default_iclass_keys.dic file (@iceman1001)
 - Fix `hf 15 dump` - no more crc faults (@iceman1001)
 - Fix `hf 15 read` - no more crc faults (@iceman1001)
 - Fix `hf 15 readmulti` - no more crc faults (@iceman1001)
 - Changed proxmark command line parameter `flush` to `-f` or `-flush` (@merlokk)
 - Added to proxmark command line parameters `w` - wait 20s for serial port (@merlokk)
 - Added to proxmark command line parameters `c` and `l` - execute command and lua script from command line (@merlokk)
 - Added to proxmark ability to execute commands from stdin (pipe) (@merlokk)
 - Added new standalone mode "HF Mifare ultra fast sniff/sim/clone - aka VIGIKPWN"  (@cjbrigato)
 - Added to `hf 14a apdu` - exchange apdu via iso14443-4 (@merlokk)
 - Added to `hf 14a apdu` - apdu and tlv results parser (@merlokk)
 - Added `hf emv` commands  (@merlokk)
 - lots of bug fixes (many many)
 - Changed hf mfp security. Now it works in all the modes. (@drHatson)
 - Added `hf fido` commands that work with FIDO U2F authenticators (@merlokk)
 - Added mbedtls instead of old polarssl (@merlokk)
 - Added jansson (@merlokk)
 - Added `hf emv scan` - save card data to json file (@merlokk)
 - Added `hf emv` `gpo`, `readrec`, `genac`, `challenge`, `intauth` - separate commands from `hf emc exec` (@merlokk)
 - Added  `hf fido` `assert` and `make` commands from fido2 protocol (authenticatorMakeCredential and authenticatorGetAssertion) (@merlokk)
 - Added trailer block decoding to `hf mf rdbl` and `hf mf cgetbl` (@merlokk)
 - Added `hf mf mad` and `hf mfp mad` MAD decode, check and print commands (@merlokk)
 - Added `script run luxeodump` (@0xdrrb)
 - Fix `lf hitag reader 02` - print all bytes (@bosb)
 - Fix hitag S simulation (still not working), write, add example HITAG S 256  (@bosb)


### Fixed
 - Changed driver file proxmark3.inf to support both old and new Product/Vendor IDs (@pwpiwi)
 - Changed start sequence in Qt mode (fix: short commands hangs main Qt thread) (@merlokk)

## [ice.3.1.0][2017-09-26]
 - proxmark3 client can reconnect to device without restart (@iceman1001)
 - lots of bug fixes (many many)
 - trace/securakey-64169.pm3 - trace of a scecurakey (@atyppo)
 - `hf mf decrypt` - got some longer input and helptext parameter (@iceman1001)
 - Updated the Reveng 1.51 sourcecode to 1.52 from Reveng project homepage (@iceman1001)
 - `hf 14a read` - disconnects when failing to read tag (@iceman1001)
 - `hf mf csave` - renamed parameter `i` to `o` as in output (@iceman1001)

## [3.0.0][2017-08-29]
  Notes on this release
  this version includes a merge with the PM3 offical v3.0.1 code, a.k.a the "Monster merge"
  There is a lot of changes,  command breaking changes, which is the cause for the JUMP in version number.
  It is set to v3.0.0 to show that it is on par with PM3 Offical v3 release.

 - Updated `mkversion.pl` to write a date based on file when repo is downloaded as a zip file from github (@iceman1001)
 - Update `readme.md` to fit GitHubs markup(@joanbono)
 - Added `script run ul_uid`, try to change UID on a magic UL-card. (@iceman1001)
 - Fixed `hf snoop` bug,  of wrong bool value (@ikarus23)
 - Fixed fullimage.s19, wrong offsets (@doegox)
 - Updated `77-mm-usb-device-blacklist.rules` for the pid/vid (@iceman1001)
 - `hf 14a sim` now follows Mifare UL-EV1 protocol better (@iceman1001)
 - Updated `fpga_hf.bit` file (@pwpiwi)
 - Added more card detections to `hf mfu info` (@iceman1001)
 - Fixed `hf mfu restore/dump` to use the right struct values in special data in dumpfile. (@iceman1001)
 - Added `hf mfu restore r` new parameter to use the new pwd for all further auths needed when executing (@iceman1001)
 - Added `default_keys_dic2lua.awk` script to generate default_keys file in client/lualibs (@iceman1001)
 - Fixes to lots of lua scripts, among others
    - `mifare_autopwn`, now uses PRNG detection (@iceman1001)
    - `mfkeys`, fixed bug which only tested the first key (@iceman1001)
    - `dumptoemul`, removed last newline (@iceman1001)
    - ...
 - Added USB/SERIAL communication enhancements (@micolous)
 - Change `hf 14a cuids`, to be interrupted with keyboard press (@iceman1001)
 - Change debugstatements for LF to show which function more unified (@iceman1001)
 - Added `script run calc_di` , to calculate some Mifare keys (@iceman1001)
 - Fixed iclass commands never shut down antenna afterwards (@iceman1001)
 - Change 512kb detection when flashing (@iceman1001)
 - Fixed compilation GCC4.9 or higher detection (@winguru)
 - Fixed compiler warnings in Ubuntu 17.04 (@iceman1001)
 - Ripped out `standalone` code into separete folder to be continued. (@iceman1001)
 - `hf mf nested`, added key validation to entered key (@merlokk)
 - `hf mf hardnested`, added key validation to enterd key (@iceman1001)
 - Change a lot of help texts (@iceman1001)
 - Fixed `hf mf chk` - keyblock bug, limited keys to 256. (@iceman1001)
 - Change `hf mf dump` retries three times now before giving up (@marshmellow42)
 - Fixed `mfu authentication`, with pack-len error (@iceman1001)
 - `Script list`, change sortorder to alphabetic order (@iceman1001)
 - Change `hf mfu gen` to read taguid (@iceman1001)
 - Change `hf mfu pwdgen` to read taguid (@iceman1001)
 - Added `hf mf setmod` sets Mifare Classic EV1 load modulation strength to card (@angelsl)
 - Added `hf 14a read`  Mifare PRNG detection based on @doegox LIBNFC impl (@iceman1001)
 - Added `hf mf nonces`, collects Mifare Classic nonces for analysing of PRNG (@iceman1001)
 - Added new CSNS in `hf iclass sim 2` attack (@iceman1001)
 - Added more default keys (@iceman1001)
 - Added analyse nuid, enable creation of Mifare NUID (@iceman1001)
 - Updated the Reveng 1.44 sourcecode to 1.51 from Reveng project homepage (@iceman1001)
 - script run formatMifare - got an option to execute the generate strings (@iceman1001)
 - Fix `hf mf cgetsc` (@iceman1001)
 - Fix `hf legic info` (@iceman1001)
 - Change version output (@iceman1001)
 - Added PAC/Stanley detection to lf search (@marshmellow42)
 - Added lf pac demod and lf pac read - extracts the raw blocks from a PAC/Stanley tag (@marshmellow42)
 - Added hf mf csave commands compatibity for 4k (@Fl0-0)
 - Added data fsktonrz, a fsk cleaning/demodulating routine for weak fsk signal. Note: follow this up with a `data rawdemod nr` to finish demoding your signal. (@marshmellow42)
 - Added lf em 410xbrute, LF EM410x reader bruteforce attack by simulating UIDs from a file (@Fl0-0)
 - Compiles on OS X
 - Compiles with gcc 4.9
 - Compiles for non-Intel CPUs
 - Added lf hitag write 24, the command writes a block to hitag2 tags in crypto mode (@henjo)
 - Added the improved `hf mf hardnested`, an attack working for hardened Mifare cards (EV1, Mifare Plus SL1)
 - Added experimental testmode write option for t55xx (danger) (@marshmellow42)
 - Added t55xx p1detect to `lf search` chip detections (@marshmellow42)
 - Added lf t55xx p1detect, detect page 1 of a t55xx tag based on E015 mfg code (@marshmellow42)
 - Added lf noralsy demod, read, clone, sim commands (@iceman1001)
 - Added lf jablotron demod, read, clone, sim commands (@iceman1001)
 - Added lf nexwatch read   - reads a nexwatch tag from the antenna
 - Added lf paradox read    - reads a paradox tag from the antenna
 - Added lf fdx sim (@iceman1001)
 - Added lf fdx clone       - clones an fdx-b animal tag to t55x7 or q5 (@iceman1001)
 - Added lf fdx read        - reads a fdx-b tag from the antenna (@iceman1001)
 - Added lf gproxii read    - reads a gproxii tag from the antenna (@marshmellow42)
 - Added lf indala read     - reads an indala tag from the antenna (@marshmellow42)
 - Added lf visa2000 demod, read, clone, sim commands (@iceman1001)

## [1.7.0 iceman fork] [2017-03-07]
 - hf mf dump - added retry loops to try each read attempt up to 3 times.  makes getting a complete dump easier with many antennas. (@marshmellow42)
 - Added markers in the graph around found Sequence Terminator after askmandemod. (@marshmellow42)
 - Added data mtrim <start> <stop> command to trim out samples between start and stop. (@marshmellow42)
 - Added data setgraphmarkers <orange> <blue> command to set two extra markers on the graph (@marshmellow42)
 - added json support in lua (@vitorio)
 - added a buspirate settings file for at91sam7s512 (@adamlaurie)
 - `lf read` timeouts is now depended on what threshold level you set in `lf config`  (@marshmellow42)
 - `hf mf sim` fixed a bug which made sim fail auths. (@iceman1001)
 - `hf 14a read` added magic tag generation 1a and 1b detection  (@iceman1001)
 - correctly using stdtypes.h printf and scanf format string macros (PRIx64 et al) (@pwpiwi)
 - fix linker warning re missing entry point when linking fullimage.elf (@pwpiwi)
 - small changes to lf psk and fsk demods to improve results when the trace begins with noise or the chip is not broadcasting yet (@marshmellow42)
 - NOTE CHANGED ALL `lf em4x em*` cmds to simpler `lf em ` - example: `lf em4x em410xdemod` is now `lf em 410xdemod`
 - Renamed and rebuilt `lf em readword` && readwordpwd to `lf em 4x05read` - it now demods and outputs the read block (@marshmellow42/@iceman1001)
 - Renamed and rebuilt `lf em writeword` && writewordpwd to `lf em 4x05write` - it now also reads validation output from the tag (@marshmellow42/@iceman1001)
 - Fixed bug in lf sim and continuous demods not turning off antenna when finished
 - Added lua script path fixes (@pwpiwi)
 - `lf search` - Added EM4x05/EM4x69 chip detection (@marshmellow42)
 - Added lf em 4x05dump command to read and output all the blocks of the chip (@marshmellow42)
 - Added lf em 4x05info command to read and display information about the chip (@marshmellow42)
 - `lf em4x em4x50***` refactoring of em4x50 commands. (@iceman1001)

## [1.6.9 iceman fork] [2017-02-06]
 - Serial speedup,  if possible 408600baud otherwise default to 115200baud (@iceman1001)
 - `hf emv` - Added Peter Fillmore EMV branch now compiles on iceman fork.  See seperate issue. (@iceman1001)
 - `hf 14a reader` - Aztek detection. (@iceman1001)
 - `standalone mode` - added more detection of tags and refactored (@iceman1001)
 - `script run ufodump` - dumps an Aztek tag. (@iceman1001)
 - `script run hard_autopwn` - runs hardnested attack against all sectors on tag (@iceman1001)
 - Added lf cotag read, and added it to lf search (@iceman1001)
 - Added hitag2 read UID only and added that to lf search (@marshmellow42)
 - `lf search` -  check for if signal is only noice (@marshmellow42)
 - `hf 14a reader` - fixed a bug when card has sak 0x00 but still is not UL/NTAG etc. (@iceman1001)
 - `hf mf sim` / `hf 14a sim` - use random nonce. (@micolous)
 - `hw tune` - only prints out if voltage is detected from antenna. (@iceman1001)
 - `hf iclass decrypt` - only decrypt Application1 (@iceman1001)
 - `lf t55xx detect` - when finding multiple possible config blocks, see if a known configblock exists and select. (@iceman1001)

## [1.6.7 iceman fork] [2017-01-05]
 - `lf animal` - FDX-B animal commands (@iceman1001)
 - Fixed bugs in `lf sim` and other lf continuous demods not turning off antenna when finished (@marshmellow42)
 - `hf iclass write` - fixed bugs, added crc. (?)
 - `hf iclass dump` - changed layout in dump (@iceman1001)
 - Changed - debug statements are more clear (@iceman1001)
 - `lf search` - fixed the silent option when acquire data. (@iceman1001)
 - `lf search` - added presco, visa2000, noralsy detection (@iceman1001)
 - `lf precso` - fixed some bitsgeneration in precso bits (@iceman1001)
 - Added `lf noralsy` -  adds demod/clone/sime of Noralsy LF tags. (@iceman1001)
 - Added `lf visa2000` - adds demod/clone/sim of Visa2000 lF tags. (@iceman1001)
 - Added `hf mf key_brute` - adds J-Runs 2nd phase bruteforce ref: https://github.com/J-Run/mf_key_brute   (@iceman1001)
 - Added `lf jablotron` - adds demod/clone/sim of Jablotron LF tags. (@iceman1001)
 - Added `lf t55xx recoverpw` - adds a new password recovery using bitflips and partial flips if password write went bad. (@alexgrin)
 - `hf legic` - added improved legic data mapping. (jason)
 - `hf mf mifare` - added possibility to target key A|B (@douniwan5788)
 - Added `analyse lcr` - added a new main command group,  to help analysing bytes & bits & nibbles. (@iceman1001)
 - Added `lf nedap` - added identification of a NEDAP tag. (@iceman1001)
 - `lf viking clone` - fixed a bug. (@iceman1001)
 - Added bitsliced bruteforce solver in `hf mf hardnested` (@Aczid)
 - `hf mf chk` speedup (@iceman1001)
 - `hf 14a/mf sim x` attack mode,  now uses also moebius version of mfkey32 to try finding the key. (@iceman1001)
 - `hf 14a sim` Added emulation of Mifare cards with 10byte UID length. (@iceman1001)
 - `hf mf sim` Added emulation of Mifare cards with 10byte UID length. (@iceman1001)
 - Added `lf guard clone/sim` (@iceman1001)
 - Added `lf pyramd clone/sim` (@iceman1001)
 - trying to fix `hf 14b` command to be able to read CALYPSO card. (@iceman1001)
 - `hf legic load`, it now loads faster and a casting bug is gone. (@iceman1001)
 - Added `hf legic calccrc8` added a method to calculate the legic crc-8 value (@iceman1001)
 - `hf legic decode` fixed the output overflow bugs, better printing (@iceman1001)
 - Coverity Scan fixes a lot of resource leaks, etc (@iceman1001)
 - Added `lf presco *` commands started (@iceman1001)
 - Added `lf hid wiegand` added a method to calculate WIEGAND in different formats, (@iceman1001)
 - `hf mf chkkeys` better printing, same table output as nested, faster execution and added Adam Lauries "try to read Key B if Key A is found" (@iceman1001)
 - `hf mf nested` better printing and added Adam Lauries "try to read Key B if Key A is found" (@iceman1001)
 - `hf mf mifare` fixing the zero parity path, which did not get called. (@iceman1001)
 - Updated the @blapost Crapto1 implementation to v3.3 (blapost)
 - `hf mf c*` updated the calling structure and refactored of the chinese magic commands (@iceman1001, @marshmellow42)
 - Started to add Peter Fillmore  EMV fork into Iceman fork. ref: https://github.com/peterfillmore/proxmark3  (@peterfillmore,  @iceman1001)
 - Added Travis-CI automatic build integration with GitHub fork. (@iceman1001)
 - Updated the Reveng 1.30 sourcecode to 1.31 from Reveng project homepage (@iceman1001)
 - Updated the Reveng 1.31 sourcecode to 1.40 from Reveng project homepage (@iceman1001)
 - Added possibility to write direct to a Legic Prime Tag (MIM256/1024) without using values from the `BigBuffer` -> `hf legic writeRaw <addr> <value>` (@icsom)
 - Added possibility to decrease DCF values at address 0x05 & 0x06 on a Legic Prime Tag  
   DCF-value will be pulled from the BigBuffer (address 0x05 & 0x06) so you have to
   load the data into the BigBuffer before with `hf legic load <path/to/legic.dump>` & then
   write the DCF-Values (both at once) with `hf legic write 0x05 0x02`  (@icsom)
 - Added script `legic.lua` for display and edit Data of Legic-Prime Tags (@icsom)
 - Added the experimental HITAG_S support (@spenneb)
 - Added topaz detection to `hf search` (@iceman1001)
 - Fixed the silent mode for 14b to be used inside `hf search` (@iceman1001)

### Added
 - Added a LF ASK Sequence Terminator detection option to the standard ask demod - and applied it to `lf search u`, `lf t55xx detect`, and `data rawdemod am s` (@marshmellow42)
 - `lf awid bruteforce <facilitycode>` - Simple bruteforce attack against a AWID reader.
 - `lf t55xx bruteforce <start password> <end password> [i <*.dic>]` - Simple bruteforce attack to find password - (@iceman1001 and others)
 - `lf viking clone`- clone viking tag to t55x7 or Q5 from 4byte hex ID input
 - `lf viking sim`  - sim full viking tag from 4byte hex ID input
 - `lf viking read` - read viking tag and output ID
 - `lf t55xx wipe`  - sets t55xx back to factory defaults
 - Added viking demod to `lf search` (@marshmellow42)
 - `data askvikingdemod` demod viking id tag from graphbuffer (@marshmellow42)
 - `lf t55xx resetread` added reset then read command - should allow determining start of stream transmissions (@marshmellow42)
 - `lf t55xx wakeup` added wake with password (AOR) to allow lf search or standard lf read after (@iceman1001, @marshmellow42)
 - `hf mf eload u` added an ultralight/ntag option. (@marshmellow42)
 - `hf iclass managekeys` to save, load and manage iclass keys.  (adjusted most commands to accept a loaded key in memory) (@marshmellow42)
 - `hf iclass readblk` to select, authenticate, and read 1 block from an iclass card (@marshmellow42)
 - `hf iclass writeblk` to select, authenticate, and write 1 block to an iclass card (or picopass) (@marshmellow42 + others)
 - `hf iclass clone` to take a saved dump file and clone selected blocks to a new tag (@marshmellow42 + others)
 - `hf iclass calcnewkey` - to calculate the div_key change to change a key - (experimental) (@marshmellow42 + others)
 - `hf iclass encryptblk` - to encrypt a data block hex to prep for writing that block (@marshmellow42)
 - ISO14443a stand-alone operation with ARM CFLAG="WITH_ISO14443a_StandAlone". This code can read & emulate two banks of 14a tag UIDs and write to "magic" cards  (Craig Young)
 - AWID26 command context added as `lf awid` containing realtime demodulation as well as cloning/simulation based on tag numbers (Craig Young)
 - Added `hw status`. This command makes the ARM print out some runtime information. (@holiman)
 - Added `hw ping`. This command just sends a usb packets and checks if the pm3 is responsive. Can be used to abort certain operations which supports abort over usb. (@holiman)
 - Added `data hex2bin` and `data bin2hex` for command line conversion between binary and hexadecimal (@holiman)
 - Added `hf snoop`. This command take digitalized signal from FPGA and put in BigBuffer. (@pwpiwi + enio)
 - Added Topaz (NFC type 1) protocol support (`hf topaz reader`, `hf list topaz`, `hf 14a raw -T`, `hf topaz snoop`). (@pwpiwi)
 - Added option c to `hf list` (mark CRC bytes) (@pwpiwi)

### Changed
 - Added `[l] <length>` option to data printdemodbuffer
 - Adjusted lf awid clone to optionally clone to Q5 tags
 - Adjusted lf t55xx detect to find Q5 tags (t5555) instead of just t55x7
 - Adjusted all lf NRZ demods - works more accurately and consistently (as long as you have strong signal)
 - Adjusted lf pskindalademod to reduce false positive reads.
 - Small adjustments to psk, nrz, and ask clock detect routines - more reliable.
 - Adjusted lf em410x em410xsim to accept a clock argument
 - Adjusted lf t55xx dump to allow overriding the safety check and warning text (@marshmellow42)
 - Adjusted lf t55xx write input variables (@marshmellow42)
 - Adjusted lf t55xx read with password safety check and warning text and adjusted the input variables (@marshmellow42 & @iceman1001)
 - Adjusted LF FSK demod to account for cross threshold fluctuations (898 count waves will adjust the 9 to 8 now...) more accurate. (@marshmellow42)
 - Adjusted timings for t55xx commands.  more reliable now. (@marshmellow42 & @iceman1001)
 - `lf cmdread` adjusted input methods and added help text (@marshmellow42 & @iceman1001)
 - changed `lf config t <threshold>` to be 0 - 128 and will trigger on + or - threshold value (@marshmellow42)
 - `hf iclass dump` cli options - can now dump AA1 and AA2 with different keys in one run (does not go to multiple pages for the larger tags yet) (@marshmellow42)
 - Revised workflow for StandAloneMode14a (Craig Young)
 - EPA functions (`hf epa`) now support both ISO 14443-A and 14443-B cards (@frederikmoellers)
 - `hw version` only talks to ARM at startup, after that the info is cached. (@pwpiwi)
 - Added `r` option to iclass functions - allows key to be provided in raw block 3/4 format

## [2.2.0][2015-07-12]

### Changed
 - Added `hf 14b raw -s` option to auto select a 14b std tag before raw command
 - Changed `hf 14b write` to `hf 14b sriwrite` as it only applied to sri tags (@marshmellow42)
 - Added `hf 14b info` to `hf search` (@marshmellow42)
 - Added compression of fpga config and data, *BOOTROM REFLASH REQUIRED* (@pwpiwi)
 - Implemented better detection of mifare-tags that are not vulnerable to classic attacks (`hf mf mifare`, `hf mf nested`) (@pwpiwi)

### Added
 - Added `hf 14b reader` to find and print general info about known 14b tags (@marshmellow42)
 - Added `hf 14b info` to find and print info about std 14b tags and sri tags (using 14b raw commands in the client)  (@marshmellow42)
 - Added PACE replay functionality (@frederikmoellers)

### Fixed
 - t55xx write timing (@marshmellow42)


## [2.1.0][2015-06-23]

### Changed
 - Added ultralight/ntag tag type detection to `hf 14a read` (@marshmellow42)
 - Improved ultralight dump command to auto detect tag type, take authentication, and dump full memory (or subset specified) of known tag types (@iceman1001 / @marshmellow42)
 - Combined ultralight read/write commands and added authentication (@iceman1001)
 - Improved LF manchester and biphase demodulation and ask clock detection especially for reads with heavy clipping. (@marshmellow42)
 - Iclass read, `hf iclass read` now also reads tag config and prints configuration. (@holiman)
 - *bootrom* needs to be flashed, due to new address boundaries between os and fpga, after a size optimization (@pwpiwi)

### Fixed
 - Fixed EM4x50 read/demod of the tags broadcasted memory blocks. `lf em4x em4x50read` (not page read) (@marshmellow42)
 - Fixed issue #19, problems with LF T55xx commands (@iceman1001, @marshmellow42)
 - Fixed various problems with iso14443b, issue #103 (@pwpiwi, @marshmellow42)

### Added
 - Added `hf search` - currently tests for 14443a tags, iclass tags, and 15693 tags (@marshmellow42)
 - Added `hf mfu info` Ultralight/NTAG info command - reads tag configuration and info, allows authentication if needed (@iceman1001, @marshmellow42)
 - Added Mifare Ultralight C and Ultralight EV1/NTAG authentication. (@iceman1001)
 - Added changelog
 - Added `data fdxbdemod` - Demodulate a FDX-B ISO11784/85 Biphase tag from GraphBuffer aka ANIMAL TAG (@marshmellow42, @iceman1001)

## [2.0.0] - 2015-03-25
### Changed
 - LF sim operations now abort when new commands arrive over the USB - not required to push the device button anymore.

### Fixed
 - Mifare simulation, `hf mf sim` (was broken a long time) (@pwpiwi)
 - Major improvements in LF area and data operations. (@marshmellow42, @iceman1001)
 - Issues regarding LF simulation (@pwpiwi)

### Added
 - iClass functionality: full simulation of iclass tags, so tags can be simulated with data (not only CSN). Not yet support for write/update, but readers do not seem to enforce update. (@holiman).
 - iClass decryption. Proxmark can now decrypt data on an iclass tag, but requires you to have the HID decryption key locally on your computer, as this is not bundled with the sourcecode.
