// THIS FILE IS AUTOGENERATED - SEE IMPORTER.PY FILE

// SPDX-FileCopyrightText: 2018-2021 Anton Kochkov <anton.kochkov@gmail.com>
// SPDX-License-Identifier: LGPL-3.0-only

#include <stdio.h>
#include <stdbool.h>
#include <rz_types.h>
#include <rz_util.h>
#include <rz_asm.h>
#include "hexagon.h"
#include "hexagon_insn.h"

extern ut32 constant_extender;

#if ASAN
#define NO_OPT_IF_ASAN __attribute__((optimize(0)))
#else
#define NO_OPT_IF_ASAN
#endif

NO_OPT_IF_ASAN int hexagon_disasm_instruction(ut32 hi_u32, HexInsn *hi, ut32 addr) {
	// DUPLEXES
	if (((hi_u32 >> 14) & 0x3) == 0) {
		switch ((((hi_u32 >> 29) & 0xF) << 1) | ((hi_u32 >> 13) & 1)) {
		case 0x0: {
			if ((hi_u32 & 0xf000f000) == 0x10001000) {
				// Instruction: 0: 0001IIIIuuuueeee0001iiiissssdddd | Re = memub (Ru + #U4:0) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RU____U4_0____RD___MEMUB__RS____U4_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0x1000) {
				// Instruction: 0: 0000IIIIuuuueeee0001iiiissssdddd | Re = memw (Ru + #U4:2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RU____U4_2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0x0) {
				// Instruction: 0: 0000IIIIuuuueeee0000iiiissssdddd | Re = memw (Ru + #U4:2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RU____U4_2____RD___MEMW__RS____U4_2_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			break;
		}
		case 0x1: {
			if ((hi_u32 & 0xf000ffc4) == 0x10003f40) {
				// Instruction: 1: 0001iiiissssdddd0011111101---0-- | Rd = memub (Rs + #u4:0) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc4) == 0x10003f00) {
				// Instruction: 1: 0001iiiissssdddd0011111100---0-- | Rd = memub (Rs + #u4:0) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____DEALLOCFRAME;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003f45) {
				// Instruction: 1: 0001iiiissssdddd0011111101---101 | Rd = memub (Rs + #u4:0) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003fc5) {
				// Instruction: 1: 0001iiiissssdddd0011111111---101 | Rd = memub (Rs + #u4:0) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003f47) {
				// Instruction: 1: 0001iiiissssdddd0011111101---111 | Rd = memub (Rs + #u4:0) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003fc7) {
				// Instruction: 1: 0001iiiissssdddd0011111111---111 | Rd = memub (Rs + #u4:0) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003f44) {
				// Instruction: 1: 0001iiiissssdddd0011111101---100 | Rd = memub (Rs + #u4:0) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003fc4) {
				// Instruction: 1: 0001iiiissssdddd0011111111---100 | Rd = memub (Rs + #u4:0) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003f46) {
				// Instruction: 1: 0001iiiissssdddd0011111101---110 | Rd = memub (Rs + #u4:0) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x10003fc6) {
				// Instruction: 1: 0001iiiissssdddd0011111111---110 | Rd = memub (Rs + #u4:0) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc4) == 0x10003fc0) {
				// Instruction: 1: 0001iiiissssdddd0011111111---0-- | Rd = memub (Rs + #u4:0) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc4) == 0x3f40) {
				// Instruction: 1: 0000iiiissssdddd0011111101---0-- | Rd = memw (Rs + #u4:2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc4) == 0x3f00) {
				// Instruction: 1: 0000iiiissssdddd0011111100---0-- | Rd = memw (Rs + #u4:2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____DEALLOCFRAME;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3f45) {
				// Instruction: 1: 0000iiiissssdddd0011111101---101 | Rd = memw (Rs + #u4:2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3fc5) {
				// Instruction: 1: 0000iiiissssdddd0011111111---101 | Rd = memw (Rs + #u4:2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3f47) {
				// Instruction: 1: 0000iiiissssdddd0011111101---111 | Rd = memw (Rs + #u4:2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3fc7) {
				// Instruction: 1: 0000iiiissssdddd0011111111---111 | Rd = memw (Rs + #u4:2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3f44) {
				// Instruction: 1: 0000iiiissssdddd0011111101---100 | Rd = memw (Rs + #u4:2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3fc4) {
				// Instruction: 1: 0000iiiissssdddd0011111111---100 | Rd = memw (Rs + #u4:2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3f46) {
				// Instruction: 1: 0000iiiissssdddd0011111101---110 | Rd = memw (Rs + #u4:2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc7) == 0x3fc6) {
				// Instruction: 1: 0000iiiissssdddd0011111111---110 | Rd = memw (Rs + #u4:2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ffc4) == 0x3fc0) {
				// Instruction: 1: 0000iiiissssdddd0011111111---0-- | Rd = memw (Rs + #u4:2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RS____U4_2____JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0x10003c00) {
				// Instruction: 1: 0001IIIIsssseeee0011110iiiiidddd | Re = memub (Rs + #U4:0) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RS____U4_0____RD___MEMW__SP____U5_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0x10003e00) {
				// Instruction: 1: 0001IIIIsssseeee00111110iiiiiddd | Re = memub (Rs + #U4:0) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RS____U4_0____RDD___MEMD__SP____U5_3_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x10003000) {
				// Instruction: 1: 0001IIIIuuuueeee00110iiissssdddd | Re = memub (Ru + #U4:0) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RU____U4_0____RD___MEMB__RS____U3_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x10002000) {
				// Instruction: 1: 0001IIIIuuuueeee00100iiissssdddd | Re = memub (Ru + #U4:0) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RU____U4_0____RD___MEMH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x10002800) {
				// Instruction: 1: 0001IIIIuuuueeee00101iiissssdddd | Re = memub (Ru + #U4:0) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUB__RU____U4_0____RD___MEMUH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0x3c00) {
				// Instruction: 1: 0000IIIIsssseeee0011110iiiiidddd | Re = memw (Rs + #U4:2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RS____U4_2____RD___MEMW__SP____U5_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0x3e00) {
				// Instruction: 1: 0000IIIIsssseeee00111110iiiiiddd | Re = memw (Rs + #U4:2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RS____U4_2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x3000) {
				// Instruction: 1: 0000IIIIuuuueeee00110iiissssdddd | Re = memw (Ru + #U4:2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RU____U4_2____RD___MEMB__RS____U3_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x2000) {
				// Instruction: 1: 0000IIIIuuuueeee00100iiissssdddd | Re = memw (Ru + #U4:2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RU____U4_2____RD___MEMH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0x2800) {
				// Instruction: 1: 0000IIIIuuuueeee00101iiissssdddd | Re = memw (Ru + #U4:2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__RU____U4_2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			break;
		}
		case 0x2: {
			if ((hi_u32 & 0xf800ffc4) == 0x30001f40) {
				// Instruction: 2: 00110iiissssdddd0001111101---0-- | Rd = memb (Rs + #u3:0) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x30001f00) {
				// Instruction: 2: 00110iiissssdddd0001111100---0-- | Rd = memb (Rs + #u3:0) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____DEALLOCFRAME;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001f45) {
				// Instruction: 2: 00110iiissssdddd0001111101---101 | Rd = memb (Rs + #u3:0) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001fc5) {
				// Instruction: 2: 00110iiissssdddd0001111111---101 | Rd = memb (Rs + #u3:0) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001f47) {
				// Instruction: 2: 00110iiissssdddd0001111101---111 | Rd = memb (Rs + #u3:0) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001fc7) {
				// Instruction: 2: 00110iiissssdddd0001111111---111 | Rd = memb (Rs + #u3:0) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001f44) {
				// Instruction: 2: 00110iiissssdddd0001111101---100 | Rd = memb (Rs + #u3:0) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001fc4) {
				// Instruction: 2: 00110iiissssdddd0001111111---100 | Rd = memb (Rs + #u3:0) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001f46) {
				// Instruction: 2: 00110iiissssdddd0001111101---110 | Rd = memb (Rs + #u3:0) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x30001fc6) {
				// Instruction: 2: 00110iiissssdddd0001111111---110 | Rd = memb (Rs + #u3:0) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x30001fc0) {
				// Instruction: 2: 00110iiissssdddd0001111111---0-- | Rd = memb (Rs + #u3:0) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RS____U3_0____JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x20001f40) {
				// Instruction: 2: 00100iiissssdddd0001111101---0-- | Rd = memh (Rs + #u3:1) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x20001f00) {
				// Instruction: 2: 00100iiissssdddd0001111100---0-- | Rd = memh (Rs + #u3:1) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____DEALLOCFRAME;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001f45) {
				// Instruction: 2: 00100iiissssdddd0001111101---101 | Rd = memh (Rs + #u3:1) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001fc5) {
				// Instruction: 2: 00100iiissssdddd0001111111---101 | Rd = memh (Rs + #u3:1) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001f47) {
				// Instruction: 2: 00100iiissssdddd0001111101---111 | Rd = memh (Rs + #u3:1) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001fc7) {
				// Instruction: 2: 00100iiissssdddd0001111111---111 | Rd = memh (Rs + #u3:1) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001f44) {
				// Instruction: 2: 00100iiissssdddd0001111101---100 | Rd = memh (Rs + #u3:1) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001fc4) {
				// Instruction: 2: 00100iiissssdddd0001111111---100 | Rd = memh (Rs + #u3:1) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001f46) {
				// Instruction: 2: 00100iiissssdddd0001111101---110 | Rd = memh (Rs + #u3:1) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x20001fc6) {
				// Instruction: 2: 00100iiissssdddd0001111111---110 | Rd = memh (Rs + #u3:1) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x20001fc0) {
				// Instruction: 2: 00100iiissssdddd0001111111---0-- | Rd = memh (Rs + #u3:1) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RS____U3_1____JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x28001f40) {
				// Instruction: 2: 00101iiissssdddd0001111101---0-- | Rd = memuh (Rs + #u3:1) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x28001f00) {
				// Instruction: 2: 00101iiissssdddd0001111100---0-- | Rd = memuh (Rs + #u3:1) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____DEALLOCFRAME;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001f45) {
				// Instruction: 2: 00101iiissssdddd0001111101---101 | Rd = memuh (Rs + #u3:1) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001fc5) {
				// Instruction: 2: 00101iiissssdddd0001111111---101 | Rd = memuh (Rs + #u3:1) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001f47) {
				// Instruction: 2: 00101iiissssdddd0001111101---111 | Rd = memuh (Rs + #u3:1) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001fc7) {
				// Instruction: 2: 00101iiissssdddd0001111111---111 | Rd = memuh (Rs + #u3:1) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001f44) {
				// Instruction: 2: 00101iiissssdddd0001111101---100 | Rd = memuh (Rs + #u3:1) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF__P0__DEALLOC_RETURN;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001fc4) {
				// Instruction: 2: 00101iiissssdddd0001111111---100 | Rd = memuh (Rs + #u3:1) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF__P0__JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001f46) {
				// Instruction: 2: 00101iiissssdddd0001111101---110 | Rd = memuh (Rs + #u3:1) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x28001fc6) {
				// Instruction: 2: 00101iiissssdddd0001111111---110 | Rd = memuh (Rs + #u3:1) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x28001fc0) {
				// Instruction: 2: 00101iiissssdddd0001111111---0-- | Rd = memuh (Rs + #u3:1) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RS____U3_1____JUMPR_LR;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc4) == 0x3c001f40) {
				// Instruction: 2: 0011110iiiiidddd0001111101---0-- | Rd = memw (Sp + #u5:2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc4) == 0x3c001f00) {
				// Instruction: 2: 0011110iiiiidddd0001111100---0-- | Rd = memw (Sp + #u5:2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001f45) {
				// Instruction: 2: 0011110iiiiidddd0001111101---101 | Rd = memw (Sp + #u5:2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001fc5) {
				// Instruction: 2: 0011110iiiiidddd0001111111---101 | Rd = memw (Sp + #u5:2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001f47) {
				// Instruction: 2: 0011110iiiiidddd0001111101---111 | Rd = memw (Sp + #u5:2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001fc7) {
				// Instruction: 2: 0011110iiiiidddd0001111111---111 | Rd = memw (Sp + #u5:2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001f44) {
				// Instruction: 2: 0011110iiiiidddd0001111101---100 | Rd = memw (Sp + #u5:2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001fc4) {
				// Instruction: 2: 0011110iiiiidddd0001111111---100 | Rd = memw (Sp + #u5:2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001f46) {
				// Instruction: 2: 0011110iiiiidddd0001111101---110 | Rd = memw (Sp + #u5:2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc7) == 0x3c001fc6) {
				// Instruction: 2: 0011110iiiiidddd0001111111---110 | Rd = memw (Sp + #u5:2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ffc4) == 0x3c001fc0) {
				// Instruction: 2: 0011110iiiiidddd0001111111---0-- | Rd = memw (Sp + #u5:2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x3e001f40) {
				// Instruction: 2: 00111110iiiiiddd0001111101---0-- | Rdd = memd (Sp + #u5:3) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x3e001f00) {
				// Instruction: 2: 00111110iiiiiddd0001111100---0-- | Rdd = memd (Sp + #u5:3) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001f45) {
				// Instruction: 2: 00111110iiiiiddd0001111101---101 | Rdd = memd (Sp + #u5:3) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001fc5) {
				// Instruction: 2: 00111110iiiiiddd0001111111---101 | Rdd = memd (Sp + #u5:3) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001f47) {
				// Instruction: 2: 00111110iiiiiddd0001111101---111 | Rdd = memd (Sp + #u5:3) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001fc7) {
				// Instruction: 2: 00111110iiiiiddd0001111111---111 | Rdd = memd (Sp + #u5:3) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001f44) {
				// Instruction: 2: 00111110iiiiiddd0001111101---100 | Rdd = memd (Sp + #u5:3) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001fc4) {
				// Instruction: 2: 00111110iiiiiddd0001111111---100 | Rdd = memd (Sp + #u5:3) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001f46) {
				// Instruction: 2: 00111110iiiiiddd0001111101---110 | Rdd = memd (Sp + #u5:3) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x3e001fc6) {
				// Instruction: 2: 00111110iiiiiddd0001111111---110 | Rdd = memd (Sp + #u5:3) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x3e001fc0) {
				// Instruction: 2: 00111110iiiiiddd0001111111---0-- | Rdd = memd (Sp + #u5:3) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x30001c00) {
				// Instruction: 2: 00110IIIsssseeee0001110iiiiidddd | Re = memb (Rs + #U3:0) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMB__RS____U3_0____RD___MEMW__SP____U5_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x30001e00) {
				// Instruction: 2: 00110IIIsssseeee00011110iiiiiddd | Re = memb (Rs + #U3:0) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMB__RS____U3_0____RDD___MEMD__SP____U5_3_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x30001000) {
				// Instruction: 2: 00110IIIuuuueeee00010iiissssdddd | Re = memb (Ru + #U3:0) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMB__RU____U3_0____RD___MEMB__RS____U3_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x20001c00) {
				// Instruction: 2: 00100IIIsssseeee0001110iiiiidddd | Re = memh (Rs + #U3:1) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMH__RS____U3_1____RD___MEMW__SP____U5_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20001e00) {
				// Instruction: 2: 00100IIIsssseeee00011110iiiiiddd | Re = memh (Rs + #U3:1) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMH__RS____U3_1____RDD___MEMD__SP____U5_3_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x20001000) {
				// Instruction: 2: 00100IIIuuuueeee00010iiissssdddd | Re = memh (Ru + #U3:1) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMH__RU____U3_1____RD___MEMB__RS____U3_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x20000000) {
				// Instruction: 2: 00100IIIuuuueeee00000iiissssdddd | Re = memh (Ru + #U3:1) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMH__RU____U3_1____RD___MEMH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x20000800) {
				// Instruction: 2: 00100IIIuuuueeee00001iiissssdddd | Re = memh (Ru + #U3:1) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMH__RU____U3_1____RD___MEMUH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x28001c00) {
				// Instruction: 2: 00101IIIsssseeee0001110iiiiidddd | Re = memuh (Rs + #U3:1) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUH__RS____U3_1____RD___MEMW__SP____U5_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x28001e00) {
				// Instruction: 2: 00101IIIsssseeee00011110iiiiiddd | Re = memuh (Rs + #U3:1) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUH__RS____U3_1____RDD___MEMD__SP____U5_3_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x28001000) {
				// Instruction: 2: 00101IIIuuuueeee00010iiissssdddd | Re = memuh (Ru + #U3:1) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUH__RU____U3_1____RD___MEMB__RS____U3_0_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x28000800) {
				// Instruction: 2: 00101IIIuuuueeee00001iiissssdddd | Re = memuh (Ru + #U3:1) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMUH__RU____U3_1____RD___MEMUH__RS____U3_1_;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[5].type = HEX_OP_TYPE_IMM;
				hi->ops[5].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hex_get_sub_reg(hi->ops[4].op.reg), hi->ops[5].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00fe00) == 0x3c001c00) {
				// Instruction: 2: 0011110IIIIIeeee0001110iiiiidddd | Re = memw (Sp + #U5:2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__SP____U5_2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe00ff00) == 0x3c001e00) {
				// Instruction: 2: 0011110IIIIIeeee00011110iiiiiddd | Re = memw (Sp + #U5:2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___MEMW__SP____U5_2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x3e001e00) {
				// Instruction: 2: 00111110IIIIIeee00011110iiiiiddd | Ree = memd (Sp + #U5:3) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___MEMD__SP____U5_3____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xffc4ffc7) == 0x3f001fc5) {
				// Instruction: 2: 0011111100---0--0001111111---101 | deallocframe ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 0;
				hi->duplex = true;
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; if (! p0) jumpr Lr");
				break;
			}
			if ((hi_u32 & 0xffc4ffc7) == 0x3f001fc7) {
				// Instruction: 2: 0011111100---0--0001111111---111 | deallocframe ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 0;
				hi->duplex = true;
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; if (! p0.new) jumpr:nt Lr");
				break;
			}
			if ((hi_u32 & 0xffc4ffc7) == 0x3f001fc4) {
				// Instruction: 2: 0011111100---0--0001111111---100 | deallocframe ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___IF__P0__JUMPR_LR;
				hi->op_count = 0;
				hi->duplex = true;
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; if (p0) jumpr Lr");
				break;
			}
			if ((hi_u32 & 0xffc4ffc7) == 0x3f001fc6) {
				// Instruction: 2: 0011111100---0--0001111111---110 | deallocframe ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 0;
				hi->duplex = true;
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; if (p0.new) jumpr:nt Lr");
				break;
			}
			if ((hi_u32 & 0xffc4ffc4) == 0x3f001fc0) {
				// Instruction: 2: 0011111100---0--0001111111---0-- | deallocframe ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___JUMPR_LR;
				hi->op_count = 0;
				hi->duplex = true;
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; jumpr Lr");
				break;
			}
			break;
		}
		case 0x3: {
			if ((hi_u32 & 0xfc00ff00) == 0x28003900) {
				// Instruction: 3: 001010IIIIIIdddd00111001ssss--ii | Rd = #U6 ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD____U6___P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003800) {
				// Instruction: 3: 001010iiiiiidddd00111000ssssxxxx | Rd = #u6 ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD____U6___RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003800) {
				// Instruction: 3: 001010iiiiiidddd00111000ssssxxxx | Rd = #u6 ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD____U6___RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003800) {
				// Instruction: 3: 00110000uuuudddd00111000ssssxxxx | Rd = Ru ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___RU___RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003800) {
				// Instruction: 3: 00110000uuuudddd00111000ssssxxxx | Rd = Ru ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___RU___RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003900) {
				// Instruction: 3: 00110000uuuudddd00111001ssss--ii | Rd = Ru ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___RU___P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003800) {
				// Instruction: 3: 00110011uuuudddd00111000ssssxxxx | Rd = add (Ru, #-1) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003800) {
				// Instruction: 3: 00110011uuuudddd00111000ssssxxxx | Rd = add (Ru, #-1) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003900) {
				// Instruction: 3: 00110011uuuudddd00111001ssss--ii | Rd = add (Ru, #-1) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003800) {
				// Instruction: 3: 00110001uuuudddd00111000ssssxxxx | Rd = add (Ru, #1) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003800) {
				// Instruction: 3: 00110001uuuudddd00111000ssssxxxx | Rd = add (Ru, #1) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003900) {
				// Instruction: 3: 00110001uuuudddd00111001ssss--ii | Rd = add (Ru, #1) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003900) {
				// Instruction: 3: 001011IIIIIIdddd00111001ssss--ii | Rd = add (Sp, #U6:2) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003800) {
				// Instruction: 3: 001011iiiiiidddd00111000ssssxxxx | Rd = add (Sp, #u6:2) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003800) {
				// Instruction: 3: 001011iiiiiidddd00111000ssssxxxx | Rd = add (Sp, #u6:2) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003800) {
				// Instruction: 3: 00110010uuuudddd00111000ssssxxxx | Rd = and (Ru, #1) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003800) {
				// Instruction: 3: 00110010uuuudddd00111000ssssxxxx | Rd = and (Ru, #1) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003900) {
				// Instruction: 3: 00110010uuuudddd00111001ssss--ii | Rd = and (Ru, #1) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x37003800) {
				// Instruction: 3: 00110111uuuudddd00111000ssssxxxx | Rd = and (Ru, #255) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x37003800) {
				// Instruction: 3: 00110111uuuudddd00111000ssssxxxx | Rd = and (Ru, #255) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x37003900) {
				// Instruction: 3: 00110111uuuudddd00111001ssss--ii | Rd = and (Ru, #255) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003800) {
				// Instruction: 3: 00110101uuuudddd00111000ssssxxxx | Rd = sxtb (Ru) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003800) {
				// Instruction: 3: 00110101uuuudddd00111000ssssxxxx | Rd = sxtb (Ru) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003900) {
				// Instruction: 3: 00110101uuuudddd00111001ssss--ii | Rd = sxtb (Ru) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003800) {
				// Instruction: 3: 00110100uuuudddd00111000ssssxxxx | Rd = sxth (Ru) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003800) {
				// Instruction: 3: 00110100uuuudddd00111000ssssxxxx | Rd = sxth (Ru) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003900) {
				// Instruction: 3: 00110100uuuudddd00111001ssss--ii | Rd = sxth (Ru) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x36003800) {
				// Instruction: 3: 00110110uuuudddd00111000ssssxxxx | Rd = zxth (Ru) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x36003800) {
				// Instruction: 3: 00110110uuuudddd00111000ssssxxxx | Rd = zxth (Ru) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x36003900) {
				// Instruction: 3: 00110110uuuudddd00111001ssss--ii | Rd = zxth (Ru) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fe40) == 0x3a003a00) {
				// Instruction: 3: 0011101--0--eeee0011101--0--dddd | Re = #-1 ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD_____1;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fd18) == 0x3a003c00) {
				// Instruction: 3: 0011101--0--eeee001111-0-ii00ddd | Re = #-1 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE___0___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fd08) == 0x3a003d00) {
				// Instruction: 3: 0011101--0--eeee001111-1ssss0ddd | Re = #-1 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE___0__RS_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fd18) == 0x3a003c08) {
				// Instruction: 3: 0011101--0--eeee001111-0-ii01ddd | Re = #-1 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE___1___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fd18) == 0x3a003c10) {
				// Instruction: 3: 0011101--0--eeee001111-0-ii10ddd | Re = #-1 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE___2___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fd18) == 0x3a003c18) {
				// Instruction: 3: 0011101--0--eeee001111-0-ii11ddd | Re = #-1 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE___3___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fd08) == 0x3a003d08) {
				// Instruction: 3: 0011101--0--eeee001111-1ssss1ddd | Re = #-1 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___COMBINE__RS___0_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fe70) == 0x3a003a70) {
				// Instruction: 3: 0011101--0--eeee0011101--111dddd | Re = #-1 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE_____1___IF___NOT__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fe70) == 0x3a003a50) {
				// Instruction: 3: 0011101--0--eeee0011101--101dddd | Re = #-1 ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE_____1___IF___NOT__P0_NEW__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fe70) == 0x3a003a60) {
				// Instruction: 3: 0011101--0--eeee0011101--110dddd | Re = #-1 ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE_____1___IF__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40fe70) == 0x3a003a40) {
				// Instruction: 3: 0011101--0--eeee0011101--100dddd | Re = #-1 ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE_____1___IF__P0_NEW__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe40) == 0x28003a00) {
				// Instruction: 3: 001010IIIIIIeeee0011101--0--dddd | Re = #U6 ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fc00) == 0x28002800) {
				// Instruction: 3: 001010IIIIIIeeee001010iiiiiidddd | Re = #U6 ; Rd = #u6
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD____U6;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3f0) >> 4);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = 0x%x", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003300) {
				// Instruction: 3: 001010IIIIIIeeee00110011ssssdddd | Re = #U6 ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003100) {
				// Instruction: 3: 001010IIIIIIeeee00110001ssssdddd | Re = #U6 ; Rd = add (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___ADD__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = add (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fc00) == 0x28002c00) {
				// Instruction: 3: 001010IIIIIIeeee001011iiiiiidddd | Re = #U6 ; Rd = add (Sp, #u6:2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___ADD__SP___U6_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = add (Sp, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003200) {
				// Instruction: 3: 001010IIIIIIeeee00110010ssssdddd | Re = #U6 ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003700) {
				// Instruction: 3: 001010IIIIIIeeee00110111ssssdddd | Re = #U6 ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x28003c00) {
				// Instruction: 3: 001010IIIIIIeeee001111-0-ii00ddd | Re = #U6 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd08) == 0x28003d00) {
				// Instruction: 3: 001010IIIIIIeeee001111-1ssss0ddd | Re = #U6 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x28003c08) {
				// Instruction: 3: 001010IIIIIIeeee001111-0-ii01ddd | Re = #U6 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x28003c10) {
				// Instruction: 3: 001010IIIIIIeeee001111-0-ii10ddd | Re = #U6 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x28003c18) {
				// Instruction: 3: 001010IIIIIIeeee001111-0-ii11ddd | Re = #U6 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd08) == 0x28003d08) {
				// Instruction: 3: 001010IIIIIIeeee001111-1ssss1ddd | Re = #U6 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x28003a70) {
				// Instruction: 3: 001010IIIIIIeeee0011101--111dddd | Re = #U6 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE____U6___IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x28003a50) {
				// Instruction: 3: 001010IIIIIIeeee0011101--101dddd | Re = #U6 ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE____U6___IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x28003a60) {
				// Instruction: 3: 001010IIIIIIeeee0011101--110dddd | Re = #U6 ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE____U6___IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x28003a40) {
				// Instruction: 3: 001010IIIIIIeeee0011101--100dddd | Re = #U6 ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE____U6___IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003000) {
				// Instruction: 3: 001010iiiiiieeee00110000ssssdddd | Re = #u6 ; Rd = Rs
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___RS;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003500) {
				// Instruction: 3: 001010iiiiiieeee00110101ssssdddd | Re = #u6 ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003400) {
				// Instruction: 3: 001010iiiiiieeee00110100ssssdddd | Re = #u6 ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x28003600) {
				// Instruction: 3: 001010iiiiiieeee00110110ssssdddd | Re = #u6 ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x30003a00) {
				// Instruction: 3: 00110000sssseeee0011101--0--dddd | Re = Rs ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x30003c00) {
				// Instruction: 3: 00110000sssseeee001111-0-ii00ddd | Re = Rs ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x30003c08) {
				// Instruction: 3: 00110000sssseeee001111-0-ii01ddd | Re = Rs ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x30003c10) {
				// Instruction: 3: 00110000sssseeee001111-0-ii10ddd | Re = Rs ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x30003c18) {
				// Instruction: 3: 00110000sssseeee001111-0-ii11ddd | Re = Rs ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x30003a70) {
				// Instruction: 3: 00110000sssseeee0011101--111dddd | Re = Rs ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___RS___IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x30003a50) {
				// Instruction: 3: 00110000sssseeee0011101--101dddd | Re = Rs ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___RS___IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x30003a60) {
				// Instruction: 3: 00110000sssseeee0011101--110dddd | Re = Rs ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___RS___IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x30003a40) {
				// Instruction: 3: 00110000sssseeee0011101--100dddd | Re = Rs ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___RS___IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003000) {
				// Instruction: 3: 00110000uuuueeee00110000ssssdddd | Re = Ru ; Rd = Rs
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___RS;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003300) {
				// Instruction: 3: 00110000uuuueeee00110011ssssdddd | Re = Ru ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003100) {
				// Instruction: 3: 00110000uuuueeee00110001ssssdddd | Re = Ru ; Rd = add (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___ADD__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = add (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003200) {
				// Instruction: 3: 00110000uuuueeee00110010ssssdddd | Re = Ru ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003700) {
				// Instruction: 3: 00110000uuuueeee00110111ssssdddd | Re = Ru ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003500) {
				// Instruction: 3: 00110000uuuueeee00110101ssssdddd | Re = Ru ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003400) {
				// Instruction: 3: 00110000uuuueeee00110100ssssdddd | Re = Ru ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x30003600) {
				// Instruction: 3: 00110000uuuueeee00110110ssssdddd | Re = Ru ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x30003d00) {
				// Instruction: 3: 00110000uuuueeee001111-1ssss0ddd | Re = Ru ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x30003d08) {
				// Instruction: 3: 00110000uuuueeee001111-1ssss1ddd | Re = Ru ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x33003a00) {
				// Instruction: 3: 00110011sssseeee0011101--0--dddd | Re = add (Rs, #-1) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x33003c00) {
				// Instruction: 3: 00110011sssseeee001111-0-ii00ddd | Re = add (Rs, #-1) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x33003c08) {
				// Instruction: 3: 00110011sssseeee001111-0-ii01ddd | Re = add (Rs, #-1) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x33003c10) {
				// Instruction: 3: 00110011sssseeee001111-0-ii10ddd | Re = add (Rs, #-1) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x33003c18) {
				// Instruction: 3: 00110011sssseeee001111-0-ii11ddd | Re = add (Rs, #-1) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x33003a70) {
				// Instruction: 3: 00110011sssseeee0011101--111dddd | Re = add (Rs, #-1) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x33003a50) {
				// Instruction: 3: 00110011sssseeee0011101--101dddd | Re = add (Rs, #-1) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x33003a60) {
				// Instruction: 3: 00110011sssseeee0011101--110dddd | Re = add (Rs, #-1) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x33003a40) {
				// Instruction: 3: 00110011sssseeee0011101--100dddd | Re = add (Rs, #-1) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x31003a00) {
				// Instruction: 3: 00110001sssseeee0011101--0--dddd | Re = add (Rs, #1) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x31003c00) {
				// Instruction: 3: 00110001sssseeee001111-0-ii00ddd | Re = add (Rs, #1) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x31003c08) {
				// Instruction: 3: 00110001sssseeee001111-0-ii01ddd | Re = add (Rs, #1) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x31003c10) {
				// Instruction: 3: 00110001sssseeee001111-0-ii10ddd | Re = add (Rs, #1) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x31003c18) {
				// Instruction: 3: 00110001sssseeee001111-0-ii11ddd | Re = add (Rs, #1) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x31003a70) {
				// Instruction: 3: 00110001sssseeee0011101--111dddd | Re = add (Rs, #1) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x31003a50) {
				// Instruction: 3: 00110001sssseeee0011101--101dddd | Re = add (Rs, #1) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x31003a60) {
				// Instruction: 3: 00110001sssseeee0011101--110dddd | Re = add (Rs, #1) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x31003a40) {
				// Instruction: 3: 00110001sssseeee0011101--100dddd | Re = add (Rs, #1) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003300) {
				// Instruction: 3: 00110011uuuueeee00110011ssssdddd | Re = add (Ru, #-1) ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003700) {
				// Instruction: 3: 00110011uuuueeee00110111ssssdddd | Re = add (Ru, #-1) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003500) {
				// Instruction: 3: 00110011uuuueeee00110101ssssdddd | Re = add (Ru, #-1) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003400) {
				// Instruction: 3: 00110011uuuueeee00110100ssssdddd | Re = add (Ru, #-1) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x33003600) {
				// Instruction: 3: 00110011uuuueeee00110110ssssdddd | Re = add (Ru, #-1) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x33003d00) {
				// Instruction: 3: 00110011uuuueeee001111-1ssss0ddd | Re = add (Ru, #-1) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x33003d08) {
				// Instruction: 3: 00110011uuuueeee001111-1ssss1ddd | Re = add (Ru, #-1) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003300) {
				// Instruction: 3: 00110001uuuueeee00110011ssssdddd | Re = add (Ru, #1) ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003100) {
				// Instruction: 3: 00110001uuuueeee00110001ssssdddd | Re = add (Ru, #1) ; Rd = add (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___ADD__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = add (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003200) {
				// Instruction: 3: 00110001uuuueeee00110010ssssdddd | Re = add (Ru, #1) ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003700) {
				// Instruction: 3: 00110001uuuueeee00110111ssssdddd | Re = add (Ru, #1) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003500) {
				// Instruction: 3: 00110001uuuueeee00110101ssssdddd | Re = add (Ru, #1) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003400) {
				// Instruction: 3: 00110001uuuueeee00110100ssssdddd | Re = add (Ru, #1) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x31003600) {
				// Instruction: 3: 00110001uuuueeee00110110ssssdddd | Re = add (Ru, #1) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x31003d00) {
				// Instruction: 3: 00110001uuuueeee001111-1ssss0ddd | Re = add (Ru, #1) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x31003d08) {
				// Instruction: 3: 00110001uuuueeee001111-1ssss1ddd | Re = add (Ru, #1) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe40) == 0x2c003a00) {
				// Instruction: 3: 001011IIIIIIeeee0011101--0--dddd | Re = add (Sp, #U6:2) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003300) {
				// Instruction: 3: 001011IIIIIIeeee00110011ssssdddd | Re = add (Sp, #U6:2) ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003100) {
				// Instruction: 3: 001011IIIIIIeeee00110001ssssdddd | Re = add (Sp, #U6:2) ; Rd = add (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___ADD__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = add (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fc00) == 0x2c002c00) {
				// Instruction: 3: 001011IIIIIIeeee001011iiiiiidddd | Re = add (Sp, #U6:2) ; Rd = add (Sp, #u6:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___ADD__SP___U6_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = add (Sp, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003200) {
				// Instruction: 3: 001011IIIIIIeeee00110010ssssdddd | Re = add (Sp, #U6:2) ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003700) {
				// Instruction: 3: 001011IIIIIIeeee00110111ssssdddd | Re = add (Sp, #U6:2) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x2c003c00) {
				// Instruction: 3: 001011IIIIIIeeee001111-0-ii00ddd | Re = add (Sp, #U6:2) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd08) == 0x2c003d00) {
				// Instruction: 3: 001011IIIIIIeeee001111-1ssss0ddd | Re = add (Sp, #U6:2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x2c003c08) {
				// Instruction: 3: 001011IIIIIIeeee001111-0-ii01ddd | Re = add (Sp, #U6:2) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x2c003c10) {
				// Instruction: 3: 001011IIIIIIeeee001111-0-ii10ddd | Re = add (Sp, #U6:2) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd18) == 0x2c003c18) {
				// Instruction: 3: 001011IIIIIIeeee001111-0-ii11ddd | Re = add (Sp, #U6:2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fd08) == 0x2c003d08) {
				// Instruction: 3: 001011IIIIIIeeee001111-1ssss1ddd | Re = add (Sp, #U6:2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x2c003a70) {
				// Instruction: 3: 001011IIIIIIeeee0011101--111dddd | Re = add (Sp, #U6:2) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x2c003a50) {
				// Instruction: 3: 001011IIIIIIeeee0011101--101dddd | Re = add (Sp, #U6:2) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x2c003a60) {
				// Instruction: 3: 001011IIIIIIeeee0011101--110dddd | Re = add (Sp, #U6:2) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe70) == 0x2c003a40) {
				// Instruction: 3: 001011IIIIIIeeee0011101--100dddd | Re = add (Sp, #U6:2) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003000) {
				// Instruction: 3: 001011iiiiiieeee00110000ssssdddd | Re = add (Sp, #u6:2) ; Rd = Rs
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___RS;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003500) {
				// Instruction: 3: 001011iiiiiieeee00110101ssssdddd | Re = add (Sp, #u6:2) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003400) {
				// Instruction: 3: 001011iiiiiieeee00110100ssssdddd | Re = add (Sp, #u6:2) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x2c003600) {
				// Instruction: 3: 001011iiiiiieeee00110110ssssdddd | Re = add (Sp, #u6:2) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x32003a00) {
				// Instruction: 3: 00110010sssseeee0011101--0--dddd | Re = and (Rs, #1) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x32003c00) {
				// Instruction: 3: 00110010sssseeee001111-0-ii00ddd | Re = and (Rs, #1) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x32003c08) {
				// Instruction: 3: 00110010sssseeee001111-0-ii01ddd | Re = and (Rs, #1) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x32003c10) {
				// Instruction: 3: 00110010sssseeee001111-0-ii10ddd | Re = and (Rs, #1) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x32003c18) {
				// Instruction: 3: 00110010sssseeee001111-0-ii11ddd | Re = and (Rs, #1) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x32003a70) {
				// Instruction: 3: 00110010sssseeee0011101--111dddd | Re = and (Rs, #1) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x32003a50) {
				// Instruction: 3: 00110010sssseeee0011101--101dddd | Re = and (Rs, #1) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x32003a60) {
				// Instruction: 3: 00110010sssseeee0011101--110dddd | Re = and (Rs, #1) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x32003a40) {
				// Instruction: 3: 00110010sssseeee0011101--100dddd | Re = and (Rs, #1) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x37003a00) {
				// Instruction: 3: 00110111sssseeee0011101--0--dddd | Re = and (Rs, #255) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x37003c00) {
				// Instruction: 3: 00110111sssseeee001111-0-ii00ddd | Re = and (Rs, #255) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x37003c08) {
				// Instruction: 3: 00110111sssseeee001111-0-ii01ddd | Re = and (Rs, #255) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x37003c10) {
				// Instruction: 3: 00110111sssseeee001111-0-ii10ddd | Re = and (Rs, #255) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x37003c18) {
				// Instruction: 3: 00110111sssseeee001111-0-ii11ddd | Re = and (Rs, #255) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x37003a70) {
				// Instruction: 3: 00110111sssseeee0011101--111dddd | Re = and (Rs, #255) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x37003a50) {
				// Instruction: 3: 00110111sssseeee0011101--101dddd | Re = and (Rs, #255) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x37003a60) {
				// Instruction: 3: 00110111sssseeee0011101--110dddd | Re = and (Rs, #255) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x37003a40) {
				// Instruction: 3: 00110111sssseeee0011101--100dddd | Re = and (Rs, #255) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003300) {
				// Instruction: 3: 00110010uuuueeee00110011ssssdddd | Re = and (Ru, #1) ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003200) {
				// Instruction: 3: 00110010uuuueeee00110010ssssdddd | Re = and (Ru, #1) ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003700) {
				// Instruction: 3: 00110010uuuueeee00110111ssssdddd | Re = and (Ru, #1) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003500) {
				// Instruction: 3: 00110010uuuueeee00110101ssssdddd | Re = and (Ru, #1) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003400) {
				// Instruction: 3: 00110010uuuueeee00110100ssssdddd | Re = and (Ru, #1) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x32003600) {
				// Instruction: 3: 00110010uuuueeee00110110ssssdddd | Re = and (Ru, #1) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x32003d00) {
				// Instruction: 3: 00110010uuuueeee001111-1ssss0ddd | Re = and (Ru, #1) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x32003d08) {
				// Instruction: 3: 00110010uuuueeee001111-1ssss1ddd | Re = and (Ru, #1) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x37003700) {
				// Instruction: 3: 00110111uuuueeee00110111ssssdddd | Re = and (Ru, #255) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x37003d00) {
				// Instruction: 3: 00110111uuuueeee001111-1ssss0ddd | Re = and (Ru, #255) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x37003d08) {
				// Instruction: 3: 00110111uuuueeee001111-1ssss1ddd | Re = and (Ru, #255) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x35003a00) {
				// Instruction: 3: 00110101sssseeee0011101--0--dddd | Re = sxtb (Rs) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x35003c00) {
				// Instruction: 3: 00110101sssseeee001111-0-ii00ddd | Re = sxtb (Rs) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x35003c08) {
				// Instruction: 3: 00110101sssseeee001111-0-ii01ddd | Re = sxtb (Rs) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x35003c10) {
				// Instruction: 3: 00110101sssseeee001111-0-ii10ddd | Re = sxtb (Rs) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x35003c18) {
				// Instruction: 3: 00110101sssseeee001111-0-ii11ddd | Re = sxtb (Rs) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x35003a70) {
				// Instruction: 3: 00110101sssseeee0011101--111dddd | Re = sxtb (Rs) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x35003a50) {
				// Instruction: 3: 00110101sssseeee0011101--101dddd | Re = sxtb (Rs) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x35003a60) {
				// Instruction: 3: 00110101sssseeee0011101--110dddd | Re = sxtb (Rs) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x35003a40) {
				// Instruction: 3: 00110101sssseeee0011101--100dddd | Re = sxtb (Rs) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003700) {
				// Instruction: 3: 00110101uuuueeee00110111ssssdddd | Re = sxtb (Ru) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003500) {
				// Instruction: 3: 00110101uuuueeee00110101ssssdddd | Re = sxtb (Ru) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x35003600) {
				// Instruction: 3: 00110101uuuueeee00110110ssssdddd | Re = sxtb (Ru) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x35003d00) {
				// Instruction: 3: 00110101uuuueeee001111-1ssss0ddd | Re = sxtb (Ru) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x35003d08) {
				// Instruction: 3: 00110101uuuueeee001111-1ssss1ddd | Re = sxtb (Ru) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x34003a00) {
				// Instruction: 3: 00110100sssseeee0011101--0--dddd | Re = sxth (Rs) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x34003c00) {
				// Instruction: 3: 00110100sssseeee001111-0-ii00ddd | Re = sxth (Rs) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x34003c08) {
				// Instruction: 3: 00110100sssseeee001111-0-ii01ddd | Re = sxth (Rs) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x34003c10) {
				// Instruction: 3: 00110100sssseeee001111-0-ii10ddd | Re = sxth (Rs) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x34003c18) {
				// Instruction: 3: 00110100sssseeee001111-0-ii11ddd | Re = sxth (Rs) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x34003a70) {
				// Instruction: 3: 00110100sssseeee0011101--111dddd | Re = sxth (Rs) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x34003a50) {
				// Instruction: 3: 00110100sssseeee0011101--101dddd | Re = sxth (Rs) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x34003a60) {
				// Instruction: 3: 00110100sssseeee0011101--110dddd | Re = sxth (Rs) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x34003a40) {
				// Instruction: 3: 00110100sssseeee0011101--100dddd | Re = sxth (Rs) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003700) {
				// Instruction: 3: 00110100uuuueeee00110111ssssdddd | Re = sxth (Ru) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003500) {
				// Instruction: 3: 00110100uuuueeee00110101ssssdddd | Re = sxth (Ru) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003400) {
				// Instruction: 3: 00110100uuuueeee00110100ssssdddd | Re = sxth (Ru) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x34003600) {
				// Instruction: 3: 00110100uuuueeee00110110ssssdddd | Re = sxth (Ru) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x34003d00) {
				// Instruction: 3: 00110100uuuueeee001111-1ssss0ddd | Re = sxth (Ru) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x34003d08) {
				// Instruction: 3: 00110100uuuueeee001111-1ssss1ddd | Re = sxth (Ru) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x36003a00) {
				// Instruction: 3: 00110110sssseeee0011101--0--dddd | Re = zxth (Rs) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x36003c00) {
				// Instruction: 3: 00110110sssseeee001111-0-ii00ddd | Re = zxth (Rs) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x36003c08) {
				// Instruction: 3: 00110110sssseeee001111-0-ii01ddd | Re = zxth (Rs) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x36003c10) {
				// Instruction: 3: 00110110sssseeee001111-0-ii10ddd | Re = zxth (Rs) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x36003c18) {
				// Instruction: 3: 00110110sssseeee001111-0-ii11ddd | Re = zxth (Rs) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x36003a70) {
				// Instruction: 3: 00110110sssseeee0011101--111dddd | Re = zxth (Rs) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x36003a50) {
				// Instruction: 3: 00110110sssseeee0011101--101dddd | Re = zxth (Rs) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x36003a60) {
				// Instruction: 3: 00110110sssseeee0011101--110dddd | Re = zxth (Rs) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x36003a40) {
				// Instruction: 3: 00110110sssseeee0011101--100dddd | Re = zxth (Rs) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x36003700) {
				// Instruction: 3: 00110110uuuueeee00110111ssssdddd | Re = zxth (Ru) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x36003600) {
				// Instruction: 3: 00110110uuuueeee00110110ssssdddd | Re = zxth (Ru) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x36003d00) {
				// Instruction: 3: 00110110uuuueeee001111-1ssss0ddd | Re = zxth (Ru) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x36003d08) {
				// Instruction: 3: 00110110uuuueeee001111-1ssss1ddd | Re = zxth (Ru) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c003c00) {
				// Instruction: 3: 001111-0-II00eee001111-0-ii00ddd | Ree = combine (#0, #U2) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (#0, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c003d00) {
				// Instruction: 3: 001111-0-II00eee001111-1ssss0ddd | Ree = combine (#0, #U2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c003c08) {
				// Instruction: 3: 001111-0-II00eee001111-0-ii01ddd | Ree = combine (#0, #U2) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (#1, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c003c10) {
				// Instruction: 3: 001111-0-II00eee001111-0-ii10ddd | Ree = combine (#0, #U2) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (#2, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c003c18) {
				// Instruction: 3: 001111-0-II00eee001111-0-ii11ddd | Ree = combine (#0, #U2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c003d08) {
				// Instruction: 3: 001111-0-II00eee001111-1ssss1ddd | Ree = combine (#0, #U2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fd08) == 0x3d003d00) {
				// Instruction: 3: 001111-1uuuu0eee001111-1ssss0ddd | Ree = combine (#0, Ru) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = combine (#0, %s)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fd08) == 0x3d003d08) {
				// Instruction: 3: 001111-1uuuu0eee001111-1ssss1ddd | Ree = combine (#0, Ru) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c083d00) {
				// Instruction: 3: 001111-0-II01eee001111-1ssss0ddd | Ree = combine (#1, #U2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c083c08) {
				// Instruction: 3: 001111-0-II01eee001111-0-ii01ddd | Ree = combine (#1, #U2) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = combine (#1, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c083c10) {
				// Instruction: 3: 001111-0-II01eee001111-0-ii10ddd | Ree = combine (#1, #U2) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = combine (#2, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c083c18) {
				// Instruction: 3: 001111-0-II01eee001111-0-ii11ddd | Ree = combine (#1, #U2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c083d08) {
				// Instruction: 3: 001111-0-II01eee001111-1ssss1ddd | Ree = combine (#1, #U2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c103d00) {
				// Instruction: 3: 001111-0-II10eee001111-1ssss0ddd | Ree = combine (#2, #U2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c103c10) {
				// Instruction: 3: 001111-0-II10eee001111-0-ii10ddd | Ree = combine (#2, #U2) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = combine (#2, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c103c18) {
				// Instruction: 3: 001111-0-II10eee001111-0-ii11ddd | Ree = combine (#2, #U2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c103d08) {
				// Instruction: 3: 001111-0-II10eee001111-1ssss1ddd | Ree = combine (#2, #U2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c183d00) {
				// Instruction: 3: 001111-0-II11eee001111-1ssss0ddd | Ree = combine (#3, #U2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fd18) == 0x3c183c18) {
				// Instruction: 3: 001111-0-II11eee001111-0-ii11ddd | Ree = combine (#3, #U2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fd08) == 0x3c183d08) {
				// Instruction: 3: 001111-0-II11eee001111-1ssss1ddd | Ree = combine (#3, #U2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fd08) == 0x3d083d08) {
				// Instruction: 3: 001111-1uuuu1eee001111-1ssss1ddd | Ree = combine (Ru, #0) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = combine (%s, #0)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x38003a00) {
				// Instruction: 3: 00111000ssssxxxx0011101--0--dddd | Rx = add (Rs, Rx) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c00) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii00ddd | Rx = add (Rs, Rx) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c08) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii01ddd | Rx = add (Rs, Rx) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c10) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii10ddd | Rx = add (Rs, Rx) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c18) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii11ddd | Rx = add (Rs, Rx) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a70) {
				// Instruction: 3: 00111000ssssxxxx0011101--111dddd | Rx = add (Rs, Rx) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a50) {
				// Instruction: 3: 00111000ssssxxxx0011101--101dddd | Rx = add (Rs, Rx) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a60) {
				// Instruction: 3: 00111000ssssxxxx0011101--110dddd | Rx = add (Rs, Rx) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a40) {
				// Instruction: 3: 00111000ssssxxxx0011101--100dddd | Rx = add (Rs, Rx) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x38003d00) {
				// Instruction: 3: 00111000uuuuxxxx001111-1ssss0ddd | Rx = add (Ru, Rx) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x38003d08) {
				// Instruction: 3: 00111000uuuuxxxx001111-1ssss1ddd | Rx = add (Ru, Rx) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003900) {
				// Instruction: 3: 00111000uuuuxxxx00111001ssss--ii | Rx = add (Ru, Rx) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe40) == 0x20003a00) {
				// Instruction: 3: 00100IIIIIIIxxxx0011101--0--dddd | Rx = add (Rx, #S7) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fc00) == 0x20002800) {
				// Instruction: 3: 00100IIIIIIIxxxx001010iiiiiidddd | Rx = add (Rx, #S7) ; Rd = #u6
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD____U6;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3f0) >> 4);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = 0x%x", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003300) {
				// Instruction: 3: 00100IIIIIIIxxxx00110011ssssdddd | Rx = add (Rx, #S7) ; Rd = add (Rs, #-1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___ADD__RS____1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = add (%s, #-1)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003100) {
				// Instruction: 3: 00100IIIIIIIxxxx00110001ssssdddd | Rx = add (Rx, #S7) ; Rd = add (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___ADD__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = add (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fc00) == 0x20002c00) {
				// Instruction: 3: 00100IIIIIIIxxxx001011iiiiiidddd | Rx = add (Rx, #S7) ; Rd = add (Sp, #u6:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___ADD__SP___U6_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = add (Sp, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003200) {
				// Instruction: 3: 00100IIIIIIIxxxx00110010ssssdddd | Rx = add (Rx, #S7) ; Rd = and (Rs, #1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___AND__RS___1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = and (%s, #1)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003700) {
				// Instruction: 3: 00100IIIIIIIxxxx00110111ssssdddd | Rx = add (Rx, #S7) ; Rd = and (Rs, #255)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___AND__RS___255_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = and (%s, #255)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fd18) == 0x20003c00) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-0-ii00ddd | Rx = add (Rx, #S7) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fd08) == 0x20003d00) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-1ssss0ddd | Rx = add (Rx, #S7) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fd18) == 0x20003c08) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-0-ii01ddd | Rx = add (Rx, #S7) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fd18) == 0x20003c10) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-0-ii10ddd | Rx = add (Rx, #S7) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fd18) == 0x20003c18) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-0-ii11ddd | Rx = add (Rx, #S7) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fd08) == 0x20003d08) {
				// Instruction: 3: 00100IIIIIIIxxxx001111-1ssss1ddd | Rx = add (Rx, #S7) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fe70) == 0x20003a70) {
				// Instruction: 3: 00100IIIIIIIxxxx0011101--111dddd | Rx = add (Rx, #S7) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fe70) == 0x20003a50) {
				// Instruction: 3: 00100IIIIIIIxxxx0011101--101dddd | Rx = add (Rx, #S7) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fe70) == 0x20003a60) {
				// Instruction: 3: 00100IIIIIIIxxxx0011101--110dddd | Rx = add (Rx, #S7) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800fe70) == 0x20003a40) {
				// Instruction: 3: 00100IIIIIIIxxxx0011101--100dddd | Rx = add (Rx, #S7) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003900) {
				// Instruction: 3: 00100IIIIIIIxxxx00111001ssss--ii | Rx = add (Rx, #S7) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003000) {
				// Instruction: 3: 00100iiiiiiixxxx00110000ssssdddd | Rx = add (Rx, #s7) ; Rd = Rs
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___RS;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003500) {
				// Instruction: 3: 00100iiiiiiixxxx00110101ssssdddd | Rx = add (Rx, #s7) ; Rd = sxtb (Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___SXTB__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = sxtb (%s)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003400) {
				// Instruction: 3: 00100iiiiiiixxxx00110100ssssdddd | Rx = add (Rx, #s7) ; Rd = sxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___SXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = sxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003600) {
				// Instruction: 3: 00100iiiiiiixxxx00110110ssssdddd | Rx = add (Rx, #s7) ; Rd = zxth (Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___ZXTH__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = zxth (%s)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x38003a00) {
				// Instruction: 3: 00111000ssssxxxx0011101--0--dddd | Rx = add (Rx, Rs) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c00) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii00ddd | Rx = add (Rx, Rs) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c08) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii01ddd | Rx = add (Rx, Rs) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c10) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii10ddd | Rx = add (Rx, Rs) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x38003c18) {
				// Instruction: 3: 00111000ssssxxxx001111-0-ii11ddd | Rx = add (Rx, Rs) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a70) {
				// Instruction: 3: 00111000ssssxxxx0011101--111dddd | Rx = add (Rx, Rs) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a50) {
				// Instruction: 3: 00111000ssssxxxx0011101--101dddd | Rx = add (Rx, Rs) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a60) {
				// Instruction: 3: 00111000ssssxxxx0011101--110dddd | Rx = add (Rx, Rs) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x38003a40) {
				// Instruction: 3: 00111000ssssxxxx0011101--100dddd | Rx = add (Rx, Rs) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x38003d00) {
				// Instruction: 3: 00111000uuuuxxxx001111-1ssss0ddd | Rx = add (Rx, Ru) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x38003d08) {
				// Instruction: 3: 00111000uuuuxxxx001111-1ssss1ddd | Rx = add (Rx, Ru) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003900) {
				// Instruction: 3: 00111000uuuuxxxx00111001ssss--ii | Rx = add (Rx, Ru) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003800) {
				// Instruction: 3: 00111000uuuuyyyy00111000ssssxxxx | Ry = add (Ru, Ry) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RU__RY____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Ry) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003800) {
				// Instruction: 3: 00111000uuuuyyyy00111000ssssxxxx | Ry = add (Ru, Ry) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RU__RY____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Ry) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x20002000) {
				// Instruction: 3: 00100IIIIIIIyyyy00100iiiiiiixxxx | Ry = add (Ry, #S7) ; Rx = add (Rx, #s7)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RY___S7____RX___ADD__RX___S7_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x7f0) >> 4);
				if (hi->ops[3].op.imm & (1 << 6)) {
					hi->ops[3].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Ry, %d) ; %s = add (Rx, %d)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), (st32)hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003800) {
				// Instruction: 3: 00100iiiiiiiyyyy00111000ssssxxxx | Ry = add (Ry, #s7) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RY___S7____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Ry, %d) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x20003800) {
				// Instruction: 3: 00100iiiiiiiyyyy00111000ssssxxxx | Ry = add (Ry, #s7) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RY___S7____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Ry, %d) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003800) {
				// Instruction: 3: 00111000uuuuyyyy00111000ssssxxxx | Ry = add (Ry, Ru) ; Rx = add (Rs, Rx)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RY__RU____RX___ADD__RS__RX_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Ry, %s) ; %s = add (%s, Rx)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x38003800) {
				// Instruction: 3: 00111000uuuuyyyy00111000ssssxxxx | Ry = add (Ry, Ru) ; Rx = add (Rx, Rs)
				hi->instruction = HEX_INS_DUPLEX_RY___ADD__RY__RU____RX___ADD__RX__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Ry
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rx
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Ry, %s) ; %s = add (Rx, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a703c00) {
				// Instruction: 3: 0011101--111eeee001111-0-ii00ddd | if (! p0) Re = #0 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE___0___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a703d00) {
				// Instruction: 3: 0011101--111eeee001111-1ssss0ddd | if (! p0) Re = #0 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE___0__RS_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a703c08) {
				// Instruction: 3: 0011101--111eeee001111-0-ii01ddd | if (! p0) Re = #0 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE___1___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a703c10) {
				// Instruction: 3: 0011101--111eeee001111-0-ii10ddd | if (! p0) Re = #0 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE___2___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a703c18) {
				// Instruction: 3: 0011101--111eeee001111-0-ii11ddd | if (! p0) Re = #0 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE___3___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a703d08) {
				// Instruction: 3: 0011101--111eeee001111-1ssss1ddd | if (! p0) Re = #0 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___COMBINE__RS___0_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a703a70) {
				// Instruction: 3: 0011101--111eeee0011101--111dddd | if (! p0) Re = #0 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___IF___NOT__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a503c00) {
				// Instruction: 3: 0011101--101eeee001111-0-ii00ddd | if (! p0.new) Re = #0 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE___0___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a503d00) {
				// Instruction: 3: 0011101--101eeee001111-1ssss0ddd | if (! p0.new) Re = #0 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE___0__RS_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a503c08) {
				// Instruction: 3: 0011101--101eeee001111-0-ii01ddd | if (! p0.new) Re = #0 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE___1___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a503c10) {
				// Instruction: 3: 0011101--101eeee001111-0-ii10ddd | if (! p0.new) Re = #0 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE___2___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a503c18) {
				// Instruction: 3: 0011101--101eeee001111-0-ii11ddd | if (! p0.new) Re = #0 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE___3___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a503d08) {
				// Instruction: 3: 0011101--101eeee001111-1ssss1ddd | if (! p0.new) Re = #0 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___COMBINE__RS___0_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a503a70) {
				// Instruction: 3: 0011101--101eeee0011101--111dddd | if (! p0.new) Re = #0 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___IF___NOT__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a503a50) {
				// Instruction: 3: 0011101--101eeee0011101--101dddd | if (! p0.new) Re = #0 ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___IF___NOT__P0_NEW__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a503a60) {
				// Instruction: 3: 0011101--101eeee0011101--110dddd | if (! p0.new) Re = #0 ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___IF__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a603c00) {
				// Instruction: 3: 0011101--110eeee001111-0-ii00ddd | if (p0) Re = #0 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE___0___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a603d00) {
				// Instruction: 3: 0011101--110eeee001111-1ssss0ddd | if (p0) Re = #0 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE___0__RS_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a603c08) {
				// Instruction: 3: 0011101--110eeee001111-0-ii01ddd | if (p0) Re = #0 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE___1___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a603c10) {
				// Instruction: 3: 0011101--110eeee001111-0-ii10ddd | if (p0) Re = #0 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE___2___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a603c18) {
				// Instruction: 3: 0011101--110eeee001111-0-ii11ddd | if (p0) Re = #0 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE___3___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a603d08) {
				// Instruction: 3: 0011101--110eeee001111-1ssss1ddd | if (p0) Re = #0 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___COMBINE__RS___0_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a603a70) {
				// Instruction: 3: 0011101--110eeee0011101--111dddd | if (p0) Re = #0 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___IF___NOT__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a603a60) {
				// Instruction: 3: 0011101--110eeee0011101--110dddd | if (p0) Re = #0 ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___IF__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a403c00) {
				// Instruction: 3: 0011101--100eeee001111-0-ii00ddd | if (p0.new) Re = #0 ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE___0___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a403d00) {
				// Instruction: 3: 0011101--100eeee001111-1ssss0ddd | if (p0.new) Re = #0 ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE___0__RS_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a403c08) {
				// Instruction: 3: 0011101--100eeee001111-0-ii01ddd | if (p0.new) Re = #0 ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE___1___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a403c10) {
				// Instruction: 3: 0011101--100eeee001111-0-ii10ddd | if (p0.new) Re = #0 ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE___2___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd18) == 0x3a403c18) {
				// Instruction: 3: 0011101--100eeee001111-0-ii11ddd | if (p0.new) Re = #0 ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE___3___U2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fd08) == 0x3a403d08) {
				// Instruction: 3: 0011101--100eeee001111-1ssss1ddd | if (p0.new) Re = #0 ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___COMBINE__RS___0_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a403a70) {
				// Instruction: 3: 0011101--100eeee0011101--111dddd | if (p0.new) Re = #0 ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___IF___NOT__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a403a50) {
				// Instruction: 3: 0011101--100eeee0011101--101dddd | if (p0.new) Re = #0 ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___IF___NOT__P0_NEW__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a403a60) {
				// Instruction: 3: 0011101--100eeee0011101--110dddd | if (p0.new) Re = #0 ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___IF__P0__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe70) == 0x3a403a40) {
				// Instruction: 3: 0011101--100eeee0011101--100dddd | if (p0.new) Re = #0 ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___IF__P0_NEW__RD____0;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe40) == 0x39003a00) {
				// Instruction: 3: 00111001ssss--II0011101--0--dddd | p0 = cmp.eq (Rs, #U2) ; Rd = #-1
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RD_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = #-1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x39003c00) {
				// Instruction: 3: 00111001ssss--II001111-0-ii00ddd | p0 = cmp.eq (Rs, #U2) ; Rdd = combine (#0, #u2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RDD___COMBINE___0___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (#0, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x39003c08) {
				// Instruction: 3: 00111001ssss--II001111-0-ii01ddd | p0 = cmp.eq (Rs, #U2) ; Rdd = combine (#1, #u2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RDD___COMBINE___1___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (#1, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x39003c10) {
				// Instruction: 3: 00111001ssss--II001111-0-ii10ddd | p0 = cmp.eq (Rs, #U2) ; Rdd = combine (#2, #u2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RDD___COMBINE___2___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (#2, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fd18) == 0x39003c18) {
				// Instruction: 3: 00111001ssss--II001111-0-ii11ddd | p0 = cmp.eq (Rs, #U2) ; Rdd = combine (#3, #u2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RDD___COMBINE___3___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x60) >> 5);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (#3, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x39003a70) {
				// Instruction: 3: 00111001ssss--II0011101--111dddd | p0 = cmp.eq (Rs, #U2) ; if (! p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x39003a50) {
				// Instruction: 3: 00111001ssss--II0011101--101dddd | p0 = cmp.eq (Rs, #U2) ; if (! p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x39003a60) {
				// Instruction: 3: 00111001ssss--II0011101--110dddd | p0 = cmp.eq (Rs, #U2) ; if (p0) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe70) == 0x39003a40) {
				// Instruction: 3: 00111001ssss--II0011101--100dddd | p0 = cmp.eq (Rs, #U2) ; if (p0.new) Rd = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0_NEW__RD____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0.new) %s = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x39003d00) {
				// Instruction: 3: 00111001uuuu--II001111-1ssss0ddd | p0 = cmp.eq (Ru, #U2) ; Rdd = combine (#0, Rs)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RDD___COMBINE___0__RS_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (#0, %s)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fd08) == 0x39003d08) {
				// Instruction: 3: 00111001uuuu--II001111-1ssss1ddd | p0 = cmp.eq (Ru, #U2) ; Rdd = combine (Rs, #0)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RDD___COMBINE__RS___0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = combine (%s, #0)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x39003900) {
				// Instruction: 3: 00111001uuuu--II00111001ssss--ii | p0 = cmp.eq (Ru, #U2) ; p0 = cmp.eq (Rs, #u2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____P0___CMP_EQ__RS___U2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x3) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; p0 = cmp.eq (%s, 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			break;
		}
		case 0x4: {
			if ((hi_u32 & 0xfe40f000) == 0x5a001000) {
				// Instruction: 4: 0101101--0--eeee0001iiiissssdddd | Re = #-1 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMUB__RS____U4_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40f000) == 0x5a000000) {
				// Instruction: 4: 0101101--0--eeee0000iiiissssdddd | Re = #-1 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMW__RS____U4_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x48001000) {
				// Instruction: 4: 010010IIIIIIeeee0001iiiissssdddd | Re = #U6 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x48000000) {
				// Instruction: 4: 010010IIIIIIeeee0000iiiissssdddd | Re = #U6 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x50001000) {
				// Instruction: 4: 01010000uuuueeee0001iiiissssdddd | Re = Ru ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x50000000) {
				// Instruction: 4: 01010000uuuueeee0000iiiissssdddd | Re = Ru ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x53001000) {
				// Instruction: 4: 01010011uuuueeee0001iiiissssdddd | Re = add (Ru, #-1) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x53000000) {
				// Instruction: 4: 01010011uuuueeee0000iiiissssdddd | Re = add (Ru, #-1) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x51001000) {
				// Instruction: 4: 01010001uuuueeee0001iiiissssdddd | Re = add (Ru, #1) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x51000000) {
				// Instruction: 4: 01010001uuuueeee0000iiiissssdddd | Re = add (Ru, #1) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x4c001000) {
				// Instruction: 4: 010011IIIIIIeeee0001iiiissssdddd | Re = add (Sp, #U6:2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x4c000000) {
				// Instruction: 4: 010011IIIIIIeeee0000iiiissssdddd | Re = add (Sp, #U6:2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x52001000) {
				// Instruction: 4: 01010010uuuueeee0001iiiissssdddd | Re = and (Ru, #1) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x52000000) {
				// Instruction: 4: 01010010uuuueeee0000iiiissssdddd | Re = and (Ru, #1) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x57001000) {
				// Instruction: 4: 01010111uuuueeee0001iiiissssdddd | Re = and (Ru, #255) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x57000000) {
				// Instruction: 4: 01010111uuuueeee0000iiiissssdddd | Re = and (Ru, #255) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x55001000) {
				// Instruction: 4: 01010101uuuueeee0001iiiissssdddd | Re = sxtb (Ru) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x55000000) {
				// Instruction: 4: 01010101uuuueeee0000iiiissssdddd | Re = sxtb (Ru) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x54001000) {
				// Instruction: 4: 01010100uuuueeee0001iiiissssdddd | Re = sxth (Ru) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x54000000) {
				// Instruction: 4: 01010100uuuueeee0000iiiissssdddd | Re = sxth (Ru) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x56001000) {
				// Instruction: 4: 01010110uuuueeee0001iiiissssdddd | Re = zxth (Ru) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x56000000) {
				// Instruction: 4: 01010110uuuueeee0000iiiissssdddd | Re = zxth (Ru) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c001000) {
				// Instruction: 4: 010111-0-II00eee0001iiiissssdddd | Ree = combine (#0, #U2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c000000) {
				// Instruction: 4: 010111-0-II00eee0000iiiissssdddd | Ree = combine (#0, #U2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x5d001000) {
				// Instruction: 4: 010111-1uuuu0eee0001iiiissssdddd | Ree = combine (#0, Ru) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x5d000000) {
				// Instruction: 4: 010111-1uuuu0eee0000iiiissssdddd | Ree = combine (#0, Ru) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c081000) {
				// Instruction: 4: 010111-0-II01eee0001iiiissssdddd | Ree = combine (#1, #U2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c080000) {
				// Instruction: 4: 010111-0-II01eee0000iiiissssdddd | Ree = combine (#1, #U2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c101000) {
				// Instruction: 4: 010111-0-II10eee0001iiiissssdddd | Ree = combine (#2, #U2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c100000) {
				// Instruction: 4: 010111-0-II10eee0000iiiissssdddd | Ree = combine (#2, #U2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c181000) {
				// Instruction: 4: 010111-0-II11eee0001iiiissssdddd | Ree = combine (#3, #U2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x5c180000) {
				// Instruction: 4: 010111-0-II11eee0000iiiissssdddd | Ree = combine (#3, #U2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x5d081000) {
				// Instruction: 4: 010111-1uuuu1eee0001iiiissssdddd | Ree = combine (Ru, #0) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memub (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x5d080000) {
				// Instruction: 4: 010111-1uuuu1eee0000iiiissssdddd | Ree = combine (Ru, #0) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memw (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x58001000) {
				// Instruction: 4: 01011000uuuuxxxx0001iiiissssdddd | Rx = add (Ru, Rx) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x58000000) {
				// Instruction: 4: 01011000uuuuxxxx0000iiiissssdddd | Rx = add (Ru, Rx) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x40001000) {
				// Instruction: 4: 01000IIIIIIIxxxx0001iiiissssdddd | Rx = add (Rx, #S7) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x40000000) {
				// Instruction: 4: 01000IIIIIIIxxxx0000iiiissssdddd | Rx = add (Rx, #S7) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x58001000) {
				// Instruction: 4: 01011000uuuuxxxx0001iiiissssdddd | Rx = add (Rx, Ru) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x58000000) {
				// Instruction: 4: 01011000uuuuxxxx0000iiiissssdddd | Rx = add (Rx, Ru) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a701000) {
				// Instruction: 4: 0101101--111eeee0001iiiissssdddd | if (! p0) Re = #0 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMUB__RS____U4_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a700000) {
				// Instruction: 4: 0101101--111eeee0000iiiissssdddd | if (! p0) Re = #0 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMW__RS____U4_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a501000) {
				// Instruction: 4: 0101101--101eeee0001iiiissssdddd | if (! p0.new) Re = #0 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMUB__RS____U4_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a500000) {
				// Instruction: 4: 0101101--101eeee0000iiiissssdddd | if (! p0.new) Re = #0 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMW__RS____U4_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a601000) {
				// Instruction: 4: 0101101--110eeee0001iiiissssdddd | if (p0) Re = #0 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMUB__RS____U4_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a600000) {
				// Instruction: 4: 0101101--110eeee0000iiiissssdddd | if (p0) Re = #0 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMW__RS____U4_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a401000) {
				// Instruction: 4: 0101101--100eeee0001iiiissssdddd | if (p0.new) Re = #0 ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMUB__RS____U4_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x5a400000) {
				// Instruction: 4: 0101101--100eeee0000iiiissssdddd | if (p0.new) Re = #0 ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMW__RS____U4_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x59001000) {
				// Instruction: 4: 01011001uuuu--II0001iiiissssdddd | p0 = cmp.eq (Ru, #U2) ; Rd = memub (Rs + #u4:0)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RD___MEMUB__RS____U4_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memub (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x59000000) {
				// Instruction: 4: 01011001uuuu--II0000iiiissssdddd | p0 = cmp.eq (Ru, #U2) ; Rd = memw (Rs + #u4:2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RD___MEMW__RS____U4_2_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memw (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			break;
		}
		case 0x5: {
			if ((hi_u32 & 0xfe40ffc4) == 0x5a003f40) {
				// Instruction: 5: 0101101--0--dddd0011111101---0-- | Rd = #-1 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD_____1___DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc4) == 0x5a003f00) {
				// Instruction: 5: 0101101--0--dddd0011111100---0-- | Rd = #-1 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD_____1___DEALLOCFRAME;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003f45) {
				// Instruction: 5: 0101101--0--dddd0011111101---101 | Rd = #-1 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003fc5) {
				// Instruction: 5: 0101101--0--dddd0011111111---101 | Rd = #-1 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003f47) {
				// Instruction: 5: 0101101--0--dddd0011111101---111 | Rd = #-1 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003fc7) {
				// Instruction: 5: 0101101--0--dddd0011111111---111 | Rd = #-1 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003f44) {
				// Instruction: 5: 0101101--0--dddd0011111101---100 | Rd = #-1 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003fc4) {
				// Instruction: 5: 0101101--0--dddd0011111111---100 | Rd = #-1 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003f46) {
				// Instruction: 5: 0101101--0--dddd0011111101---110 | Rd = #-1 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc7) == 0x5a003fc6) {
				// Instruction: 5: 0101101--0--dddd0011111111---110 | Rd = #-1 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD_____1___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ffc4) == 0x5a003fc0) {
				// Instruction: 5: 0101101--0--dddd0011111111---0-- | Rd = #-1 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD_____1___JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x48003f40) {
				// Instruction: 5: 010010iiiiiidddd0011111101---0-- | Rd = #u6 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD____U6___DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x48003f00) {
				// Instruction: 5: 010010iiiiiidddd0011111100---0-- | Rd = #u6 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD____U6___DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003f45) {
				// Instruction: 5: 010010iiiiiidddd0011111101---101 | Rd = #u6 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003fc5) {
				// Instruction: 5: 010010iiiiiidddd0011111111---101 | Rd = #u6 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003f47) {
				// Instruction: 5: 010010iiiiiidddd0011111101---111 | Rd = #u6 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003fc7) {
				// Instruction: 5: 010010iiiiiidddd0011111111---111 | Rd = #u6 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003f44) {
				// Instruction: 5: 010010iiiiiidddd0011111101---100 | Rd = #u6 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003fc4) {
				// Instruction: 5: 010010iiiiiidddd0011111111---100 | Rd = #u6 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003f46) {
				// Instruction: 5: 010010iiiiiidddd0011111101---110 | Rd = #u6 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x48003fc6) {
				// Instruction: 5: 010010iiiiiidddd0011111111---110 | Rd = #u6 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD____U6___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x48003fc0) {
				// Instruction: 5: 010010iiiiiidddd0011111111---0-- | Rd = #u6 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD____U6___JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x50003f40) {
				// Instruction: 5: 01010000ssssdddd0011111101---0-- | Rd = Rs ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___RS___DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x50003f00) {
				// Instruction: 5: 01010000ssssdddd0011111100---0-- | Rd = Rs ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___RS___DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003f45) {
				// Instruction: 5: 01010000ssssdddd0011111101---101 | Rd = Rs ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003fc5) {
				// Instruction: 5: 01010000ssssdddd0011111111---101 | Rd = Rs ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003f47) {
				// Instruction: 5: 01010000ssssdddd0011111101---111 | Rd = Rs ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003fc7) {
				// Instruction: 5: 01010000ssssdddd0011111111---111 | Rd = Rs ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003f44) {
				// Instruction: 5: 01010000ssssdddd0011111101---100 | Rd = Rs ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003fc4) {
				// Instruction: 5: 01010000ssssdddd0011111111---100 | Rd = Rs ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003f46) {
				// Instruction: 5: 01010000ssssdddd0011111101---110 | Rd = Rs ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x50003fc6) {
				// Instruction: 5: 01010000ssssdddd0011111111---110 | Rd = Rs ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___RS___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x50003fc0) {
				// Instruction: 5: 01010000ssssdddd0011111111---0-- | Rd = Rs ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___RS___JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x53003f40) {
				// Instruction: 5: 01010011ssssdddd0011111101---0-- | Rd = add (Rs, #-1) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x53003f00) {
				// Instruction: 5: 01010011ssssdddd0011111100---0-- | Rd = add (Rs, #-1) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003f45) {
				// Instruction: 5: 01010011ssssdddd0011111101---101 | Rd = add (Rs, #-1) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003fc5) {
				// Instruction: 5: 01010011ssssdddd0011111111---101 | Rd = add (Rs, #-1) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003f47) {
				// Instruction: 5: 01010011ssssdddd0011111101---111 | Rd = add (Rs, #-1) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003fc7) {
				// Instruction: 5: 01010011ssssdddd0011111111---111 | Rd = add (Rs, #-1) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003f44) {
				// Instruction: 5: 01010011ssssdddd0011111101---100 | Rd = add (Rs, #-1) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003fc4) {
				// Instruction: 5: 01010011ssssdddd0011111111---100 | Rd = add (Rs, #-1) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003f46) {
				// Instruction: 5: 01010011ssssdddd0011111101---110 | Rd = add (Rs, #-1) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x53003fc6) {
				// Instruction: 5: 01010011ssssdddd0011111111---110 | Rd = add (Rs, #-1) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x53003fc0) {
				// Instruction: 5: 01010011ssssdddd0011111111---0-- | Rd = add (Rs, #-1) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x51003f40) {
				// Instruction: 5: 01010001ssssdddd0011111101---0-- | Rd = add (Rs, #1) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x51003f00) {
				// Instruction: 5: 01010001ssssdddd0011111100---0-- | Rd = add (Rs, #1) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003f45) {
				// Instruction: 5: 01010001ssssdddd0011111101---101 | Rd = add (Rs, #1) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003fc5) {
				// Instruction: 5: 01010001ssssdddd0011111111---101 | Rd = add (Rs, #1) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003f47) {
				// Instruction: 5: 01010001ssssdddd0011111101---111 | Rd = add (Rs, #1) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003fc7) {
				// Instruction: 5: 01010001ssssdddd0011111111---111 | Rd = add (Rs, #1) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003f44) {
				// Instruction: 5: 01010001ssssdddd0011111101---100 | Rd = add (Rs, #1) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003fc4) {
				// Instruction: 5: 01010001ssssdddd0011111111---100 | Rd = add (Rs, #1) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003f46) {
				// Instruction: 5: 01010001ssssdddd0011111101---110 | Rd = add (Rs, #1) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x51003fc6) {
				// Instruction: 5: 01010001ssssdddd0011111111---110 | Rd = add (Rs, #1) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x51003fc0) {
				// Instruction: 5: 01010001ssssdddd0011111111---0-- | Rd = add (Rs, #1) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x4c003f40) {
				// Instruction: 5: 010011iiiiiidddd0011111101---0-- | Rd = add (Sp, #u6:2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x4c003f00) {
				// Instruction: 5: 010011iiiiiidddd0011111100---0-- | Rd = add (Sp, #u6:2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003f45) {
				// Instruction: 5: 010011iiiiiidddd0011111101---101 | Rd = add (Sp, #u6:2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003fc5) {
				// Instruction: 5: 010011iiiiiidddd0011111111---101 | Rd = add (Sp, #u6:2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003f47) {
				// Instruction: 5: 010011iiiiiidddd0011111101---111 | Rd = add (Sp, #u6:2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003fc7) {
				// Instruction: 5: 010011iiiiiidddd0011111111---111 | Rd = add (Sp, #u6:2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003f44) {
				// Instruction: 5: 010011iiiiiidddd0011111101---100 | Rd = add (Sp, #u6:2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003fc4) {
				// Instruction: 5: 010011iiiiiidddd0011111111---100 | Rd = add (Sp, #u6:2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003f46) {
				// Instruction: 5: 010011iiiiiidddd0011111101---110 | Rd = add (Sp, #u6:2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc7) == 0x4c003fc6) {
				// Instruction: 5: 010011iiiiiidddd0011111111---110 | Rd = add (Sp, #u6:2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ffc4) == 0x4c003fc0) {
				// Instruction: 5: 010011iiiiiidddd0011111111---0-- | Rd = add (Sp, #u6:2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x52003f40) {
				// Instruction: 5: 01010010ssssdddd0011111101---0-- | Rd = and (Rs, #1) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x52003f00) {
				// Instruction: 5: 01010010ssssdddd0011111100---0-- | Rd = and (Rs, #1) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003f45) {
				// Instruction: 5: 01010010ssssdddd0011111101---101 | Rd = and (Rs, #1) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003fc5) {
				// Instruction: 5: 01010010ssssdddd0011111111---101 | Rd = and (Rs, #1) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003f47) {
				// Instruction: 5: 01010010ssssdddd0011111101---111 | Rd = and (Rs, #1) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003fc7) {
				// Instruction: 5: 01010010ssssdddd0011111111---111 | Rd = and (Rs, #1) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003f44) {
				// Instruction: 5: 01010010ssssdddd0011111101---100 | Rd = and (Rs, #1) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003fc4) {
				// Instruction: 5: 01010010ssssdddd0011111111---100 | Rd = and (Rs, #1) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003f46) {
				// Instruction: 5: 01010010ssssdddd0011111101---110 | Rd = and (Rs, #1) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x52003fc6) {
				// Instruction: 5: 01010010ssssdddd0011111111---110 | Rd = and (Rs, #1) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x52003fc0) {
				// Instruction: 5: 01010010ssssdddd0011111111---0-- | Rd = and (Rs, #1) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x57003f40) {
				// Instruction: 5: 01010111ssssdddd0011111101---0-- | Rd = and (Rs, #255) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x57003f00) {
				// Instruction: 5: 01010111ssssdddd0011111100---0-- | Rd = and (Rs, #255) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003f45) {
				// Instruction: 5: 01010111ssssdddd0011111101---101 | Rd = and (Rs, #255) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003fc5) {
				// Instruction: 5: 01010111ssssdddd0011111111---101 | Rd = and (Rs, #255) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003f47) {
				// Instruction: 5: 01010111ssssdddd0011111101---111 | Rd = and (Rs, #255) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003fc7) {
				// Instruction: 5: 01010111ssssdddd0011111111---111 | Rd = and (Rs, #255) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003f44) {
				// Instruction: 5: 01010111ssssdddd0011111101---100 | Rd = and (Rs, #255) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003fc4) {
				// Instruction: 5: 01010111ssssdddd0011111111---100 | Rd = and (Rs, #255) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003f46) {
				// Instruction: 5: 01010111ssssdddd0011111101---110 | Rd = and (Rs, #255) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x57003fc6) {
				// Instruction: 5: 01010111ssssdddd0011111111---110 | Rd = and (Rs, #255) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x57003fc0) {
				// Instruction: 5: 01010111ssssdddd0011111111---0-- | Rd = and (Rs, #255) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x55003f40) {
				// Instruction: 5: 01010101ssssdddd0011111101---0-- | Rd = sxtb (Rs) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x55003f00) {
				// Instruction: 5: 01010101ssssdddd0011111100---0-- | Rd = sxtb (Rs) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003f45) {
				// Instruction: 5: 01010101ssssdddd0011111101---101 | Rd = sxtb (Rs) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003fc5) {
				// Instruction: 5: 01010101ssssdddd0011111111---101 | Rd = sxtb (Rs) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003f47) {
				// Instruction: 5: 01010101ssssdddd0011111101---111 | Rd = sxtb (Rs) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003fc7) {
				// Instruction: 5: 01010101ssssdddd0011111111---111 | Rd = sxtb (Rs) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003f44) {
				// Instruction: 5: 01010101ssssdddd0011111101---100 | Rd = sxtb (Rs) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003fc4) {
				// Instruction: 5: 01010101ssssdddd0011111111---100 | Rd = sxtb (Rs) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003f46) {
				// Instruction: 5: 01010101ssssdddd0011111101---110 | Rd = sxtb (Rs) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x55003fc6) {
				// Instruction: 5: 01010101ssssdddd0011111111---110 | Rd = sxtb (Rs) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x55003fc0) {
				// Instruction: 5: 01010101ssssdddd0011111111---0-- | Rd = sxtb (Rs) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x54003f40) {
				// Instruction: 5: 01010100ssssdddd0011111101---0-- | Rd = sxth (Rs) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x54003f00) {
				// Instruction: 5: 01010100ssssdddd0011111100---0-- | Rd = sxth (Rs) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003f45) {
				// Instruction: 5: 01010100ssssdddd0011111101---101 | Rd = sxth (Rs) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003fc5) {
				// Instruction: 5: 01010100ssssdddd0011111111---101 | Rd = sxth (Rs) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003f47) {
				// Instruction: 5: 01010100ssssdddd0011111101---111 | Rd = sxth (Rs) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003fc7) {
				// Instruction: 5: 01010100ssssdddd0011111111---111 | Rd = sxth (Rs) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003f44) {
				// Instruction: 5: 01010100ssssdddd0011111101---100 | Rd = sxth (Rs) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003fc4) {
				// Instruction: 5: 01010100ssssdddd0011111111---100 | Rd = sxth (Rs) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003f46) {
				// Instruction: 5: 01010100ssssdddd0011111101---110 | Rd = sxth (Rs) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x54003fc6) {
				// Instruction: 5: 01010100ssssdddd0011111111---110 | Rd = sxth (Rs) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x54003fc0) {
				// Instruction: 5: 01010100ssssdddd0011111111---0-- | Rd = sxth (Rs) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x56003f40) {
				// Instruction: 5: 01010110ssssdddd0011111101---0-- | Rd = zxth (Rs) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x56003f00) {
				// Instruction: 5: 01010110ssssdddd0011111100---0-- | Rd = zxth (Rs) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003f45) {
				// Instruction: 5: 01010110ssssdddd0011111101---101 | Rd = zxth (Rs) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003fc5) {
				// Instruction: 5: 01010110ssssdddd0011111111---101 | Rd = zxth (Rs) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003f47) {
				// Instruction: 5: 01010110ssssdddd0011111101---111 | Rd = zxth (Rs) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003fc7) {
				// Instruction: 5: 01010110ssssdddd0011111111---111 | Rd = zxth (Rs) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003f44) {
				// Instruction: 5: 01010110ssssdddd0011111101---100 | Rd = zxth (Rs) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003fc4) {
				// Instruction: 5: 01010110ssssdddd0011111111---100 | Rd = zxth (Rs) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003f46) {
				// Instruction: 5: 01010110ssssdddd0011111101---110 | Rd = zxth (Rs) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x56003fc6) {
				// Instruction: 5: 01010110ssssdddd0011111111---110 | Rd = zxth (Rs) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x56003fc0) {
				// Instruction: 5: 01010110ssssdddd0011111111---0-- | Rd = zxth (Rs) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c003f40) {
				// Instruction: 5: 010111-0-ii00ddd0011111101---0-- | Rdd = combine (#0, #u2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c003f00) {
				// Instruction: 5: 010111-0-ii00ddd0011111100---0-- | Rdd = combine (#0, #u2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003f45) {
				// Instruction: 5: 010111-0-ii00ddd0011111101---101 | Rdd = combine (#0, #u2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003fc5) {
				// Instruction: 5: 010111-0-ii00ddd0011111111---101 | Rdd = combine (#0, #u2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003f47) {
				// Instruction: 5: 010111-0-ii00ddd0011111101---111 | Rdd = combine (#0, #u2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003fc7) {
				// Instruction: 5: 010111-0-ii00ddd0011111111---111 | Rdd = combine (#0, #u2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003f44) {
				// Instruction: 5: 010111-0-ii00ddd0011111101---100 | Rdd = combine (#0, #u2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003fc4) {
				// Instruction: 5: 010111-0-ii00ddd0011111111---100 | Rdd = combine (#0, #u2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003f46) {
				// Instruction: 5: 010111-0-ii00ddd0011111101---110 | Rdd = combine (#0, #u2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c003fc6) {
				// Instruction: 5: 010111-0-ii00ddd0011111111---110 | Rdd = combine (#0, #u2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c003fc0) {
				// Instruction: 5: 010111-0-ii00ddd0011111111---0-- | Rdd = combine (#0, #u2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d003f40) {
				// Instruction: 5: 010111-1ssss0ddd0011111101---0-- | Rdd = combine (#0, Rs) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d003f00) {
				// Instruction: 5: 010111-1ssss0ddd0011111100---0-- | Rdd = combine (#0, Rs) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003f45) {
				// Instruction: 5: 010111-1ssss0ddd0011111101---101 | Rdd = combine (#0, Rs) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003fc5) {
				// Instruction: 5: 010111-1ssss0ddd0011111111---101 | Rdd = combine (#0, Rs) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003f47) {
				// Instruction: 5: 010111-1ssss0ddd0011111101---111 | Rdd = combine (#0, Rs) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003fc7) {
				// Instruction: 5: 010111-1ssss0ddd0011111111---111 | Rdd = combine (#0, Rs) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003f44) {
				// Instruction: 5: 010111-1ssss0ddd0011111101---100 | Rdd = combine (#0, Rs) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003fc4) {
				// Instruction: 5: 010111-1ssss0ddd0011111111---100 | Rdd = combine (#0, Rs) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003f46) {
				// Instruction: 5: 010111-1ssss0ddd0011111101---110 | Rdd = combine (#0, Rs) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d003fc6) {
				// Instruction: 5: 010111-1ssss0ddd0011111111---110 | Rdd = combine (#0, Rs) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d003fc0) {
				// Instruction: 5: 010111-1ssss0ddd0011111111---0-- | Rdd = combine (#0, Rs) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c083f40) {
				// Instruction: 5: 010111-0-ii01ddd0011111101---0-- | Rdd = combine (#1, #u2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c083f00) {
				// Instruction: 5: 010111-0-ii01ddd0011111100---0-- | Rdd = combine (#1, #u2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083f45) {
				// Instruction: 5: 010111-0-ii01ddd0011111101---101 | Rdd = combine (#1, #u2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083fc5) {
				// Instruction: 5: 010111-0-ii01ddd0011111111---101 | Rdd = combine (#1, #u2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083f47) {
				// Instruction: 5: 010111-0-ii01ddd0011111101---111 | Rdd = combine (#1, #u2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083fc7) {
				// Instruction: 5: 010111-0-ii01ddd0011111111---111 | Rdd = combine (#1, #u2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083f44) {
				// Instruction: 5: 010111-0-ii01ddd0011111101---100 | Rdd = combine (#1, #u2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083fc4) {
				// Instruction: 5: 010111-0-ii01ddd0011111111---100 | Rdd = combine (#1, #u2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083f46) {
				// Instruction: 5: 010111-0-ii01ddd0011111101---110 | Rdd = combine (#1, #u2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c083fc6) {
				// Instruction: 5: 010111-0-ii01ddd0011111111---110 | Rdd = combine (#1, #u2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c083fc0) {
				// Instruction: 5: 010111-0-ii01ddd0011111111---0-- | Rdd = combine (#1, #u2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c103f40) {
				// Instruction: 5: 010111-0-ii10ddd0011111101---0-- | Rdd = combine (#2, #u2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c103f00) {
				// Instruction: 5: 010111-0-ii10ddd0011111100---0-- | Rdd = combine (#2, #u2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103f45) {
				// Instruction: 5: 010111-0-ii10ddd0011111101---101 | Rdd = combine (#2, #u2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103fc5) {
				// Instruction: 5: 010111-0-ii10ddd0011111111---101 | Rdd = combine (#2, #u2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103f47) {
				// Instruction: 5: 010111-0-ii10ddd0011111101---111 | Rdd = combine (#2, #u2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103fc7) {
				// Instruction: 5: 010111-0-ii10ddd0011111111---111 | Rdd = combine (#2, #u2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103f44) {
				// Instruction: 5: 010111-0-ii10ddd0011111101---100 | Rdd = combine (#2, #u2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103fc4) {
				// Instruction: 5: 010111-0-ii10ddd0011111111---100 | Rdd = combine (#2, #u2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103f46) {
				// Instruction: 5: 010111-0-ii10ddd0011111101---110 | Rdd = combine (#2, #u2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c103fc6) {
				// Instruction: 5: 010111-0-ii10ddd0011111111---110 | Rdd = combine (#2, #u2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c103fc0) {
				// Instruction: 5: 010111-0-ii10ddd0011111111---0-- | Rdd = combine (#2, #u2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c183f40) {
				// Instruction: 5: 010111-0-ii11ddd0011111101---0-- | Rdd = combine (#3, #u2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c183f00) {
				// Instruction: 5: 010111-0-ii11ddd0011111100---0-- | Rdd = combine (#3, #u2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183f45) {
				// Instruction: 5: 010111-0-ii11ddd0011111101---101 | Rdd = combine (#3, #u2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183fc5) {
				// Instruction: 5: 010111-0-ii11ddd0011111111---101 | Rdd = combine (#3, #u2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183f47) {
				// Instruction: 5: 010111-0-ii11ddd0011111101---111 | Rdd = combine (#3, #u2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183fc7) {
				// Instruction: 5: 010111-0-ii11ddd0011111111---111 | Rdd = combine (#3, #u2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183f44) {
				// Instruction: 5: 010111-0-ii11ddd0011111101---100 | Rdd = combine (#3, #u2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183fc4) {
				// Instruction: 5: 010111-0-ii11ddd0011111111---100 | Rdd = combine (#3, #u2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183f46) {
				// Instruction: 5: 010111-0-ii11ddd0011111101---110 | Rdd = combine (#3, #u2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc7) == 0x5c183fc6) {
				// Instruction: 5: 010111-0-ii11ddd0011111111---110 | Rdd = combine (#3, #u2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ffc4) == 0x5c183fc0) {
				// Instruction: 5: 010111-0-ii11ddd0011111111---0-- | Rdd = combine (#3, #u2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d083f40) {
				// Instruction: 5: 010111-1ssss1ddd0011111101---0-- | Rdd = combine (Rs, #0) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d083f00) {
				// Instruction: 5: 010111-1ssss1ddd0011111100---0-- | Rdd = combine (Rs, #0) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; deallocframe", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083f45) {
				// Instruction: 5: 010111-1ssss1ddd0011111101---101 | Rdd = combine (Rs, #0) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (! p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083fc5) {
				// Instruction: 5: 010111-1ssss1ddd0011111111---101 | Rdd = combine (Rs, #0) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (! p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083f47) {
				// Instruction: 5: 010111-1ssss1ddd0011111101---111 | Rdd = combine (Rs, #0) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (! p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083fc7) {
				// Instruction: 5: 010111-1ssss1ddd0011111111---111 | Rdd = combine (Rs, #0) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083f44) {
				// Instruction: 5: 010111-1ssss1ddd0011111101---100 | Rdd = combine (Rs, #0) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (p0) dealloc_return", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083fc4) {
				// Instruction: 5: 010111-1ssss1ddd0011111111---100 | Rdd = combine (Rs, #0) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (p0) jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083f46) {
				// Instruction: 5: 010111-1ssss1ddd0011111101---110 | Rdd = combine (Rs, #0) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (p0.new) dealloc_return:nt", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc7) == 0x5d083fc6) {
				// Instruction: 5: 010111-1ssss1ddd0011111111---110 | Rdd = combine (Rs, #0) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; if (p0.new) jumpr:nt Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ffc4) == 0x5d083fc0) {
				// Instruction: 5: 010111-1ssss1ddd0011111111---0-- | Rdd = combine (Rs, #0) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; jumpr Lr", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40f800) == 0x5a003000) {
				// Instruction: 5: 0101101--0--eeee00110iiissssdddd | Re = #-1 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMB__RS____U3_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40f800) == 0x5a002000) {
				// Instruction: 5: 0101101--0--eeee00100iiissssdddd | Re = #-1 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40f800) == 0x5a002800) {
				// Instruction: 5: 0101101--0--eeee00101iiissssdddd | Re = #-1 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMUH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fe00) == 0x5a003c00) {
				// Instruction: 5: 0101101--0--eeee0011110iiiiidddd | Re = #-1 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RD___MEMW__SP____U5_2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40ff00) == 0x5a003e00) {
				// Instruction: 5: 0101101--0--eeee00111110iiiiiddd | Re = #-1 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE_____1___RDD___MEMD__SP____U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x48003000) {
				// Instruction: 5: 010010IIIIIIeeee00110iiissssdddd | Re = #U6 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x48002000) {
				// Instruction: 5: 010010IIIIIIeeee00100iiissssdddd | Re = #U6 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x48002800) {
				// Instruction: 5: 010010IIIIIIeeee00101iiissssdddd | Re = #U6 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x48003c00) {
				// Instruction: 5: 010010IIIIIIeeee0011110iiiiidddd | Re = #U6 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x48003e00) {
				// Instruction: 5: 010010IIIIIIeeee00111110iiiiiddd | Re = #U6 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE____U6___RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x50003c00) {
				// Instruction: 5: 01010000sssseeee0011110iiiiidddd | Re = Rs ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x50003e00) {
				// Instruction: 5: 01010000sssseeee00111110iiiiiddd | Re = Rs ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___RS___RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x50003000) {
				// Instruction: 5: 01010000uuuueeee00110iiissssdddd | Re = Ru ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x50002000) {
				// Instruction: 5: 01010000uuuueeee00100iiissssdddd | Re = Ru ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x50002800) {
				// Instruction: 5: 01010000uuuueeee00101iiissssdddd | Re = Ru ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___RU___RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x53003c00) {
				// Instruction: 5: 01010011sssseeee0011110iiiiidddd | Re = add (Rs, #-1) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x53003e00) {
				// Instruction: 5: 01010011sssseeee00111110iiiiiddd | Re = add (Rs, #-1) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS____1____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x51003c00) {
				// Instruction: 5: 01010001sssseeee0011110iiiiidddd | Re = add (Rs, #1) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x51003e00) {
				// Instruction: 5: 01010001sssseeee00111110iiiiiddd | Re = add (Rs, #1) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RS___1____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x53003000) {
				// Instruction: 5: 01010011uuuueeee00110iiissssdddd | Re = add (Ru, #-1) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x53002000) {
				// Instruction: 5: 01010011uuuueeee00100iiissssdddd | Re = add (Ru, #-1) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x53002800) {
				// Instruction: 5: 01010011uuuueeee00101iiissssdddd | Re = add (Ru, #-1) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU____1____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x51003000) {
				// Instruction: 5: 01010001uuuueeee00110iiissssdddd | Re = add (Ru, #1) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x51002000) {
				// Instruction: 5: 01010001uuuueeee00100iiissssdddd | Re = add (Ru, #1) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x51002800) {
				// Instruction: 5: 01010001uuuueeee00101iiissssdddd | Re = add (Ru, #1) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__RU___1____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x4c003000) {
				// Instruction: 5: 010011IIIIIIeeee00110iiissssdddd | Re = add (Sp, #U6:2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x4c002000) {
				// Instruction: 5: 010011IIIIIIeeee00100iiissssdddd | Re = add (Sp, #U6:2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x4c002800) {
				// Instruction: 5: 010011IIIIIIeeee00101iiissssdddd | Re = add (Sp, #U6:2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x4c003c00) {
				// Instruction: 5: 010011IIIIIIeeee0011110iiiiidddd | Re = add (Sp, #U6:2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x4c003e00) {
				// Instruction: 5: 010011IIIIIIeeee00111110iiiiiddd | Re = add (Sp, #U6:2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___ADD__SP___U6_2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x52003c00) {
				// Instruction: 5: 01010010sssseeee0011110iiiiidddd | Re = and (Rs, #1) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x52003e00) {
				// Instruction: 5: 01010010sssseeee00111110iiiiiddd | Re = and (Rs, #1) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___1____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x57003c00) {
				// Instruction: 5: 01010111sssseeee0011110iiiiidddd | Re = and (Rs, #255) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x57003e00) {
				// Instruction: 5: 01010111sssseeee00111110iiiiiddd | Re = and (Rs, #255) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RS___255____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x52003000) {
				// Instruction: 5: 01010010uuuueeee00110iiissssdddd | Re = and (Ru, #1) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x52002000) {
				// Instruction: 5: 01010010uuuueeee00100iiissssdddd | Re = and (Ru, #1) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x52002800) {
				// Instruction: 5: 01010010uuuueeee00101iiissssdddd | Re = and (Ru, #1) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___1____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x57003000) {
				// Instruction: 5: 01010111uuuueeee00110iiissssdddd | Re = and (Ru, #255) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x57002000) {
				// Instruction: 5: 01010111uuuueeee00100iiissssdddd | Re = and (Ru, #255) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x57002800) {
				// Instruction: 5: 01010111uuuueeee00101iiissssdddd | Re = and (Ru, #255) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___AND__RU___255____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x55003c00) {
				// Instruction: 5: 01010101sssseeee0011110iiiiidddd | Re = sxtb (Rs) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x55003e00) {
				// Instruction: 5: 01010101sssseeee00111110iiiiiddd | Re = sxtb (Rs) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RS____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x55003000) {
				// Instruction: 5: 01010101uuuueeee00110iiissssdddd | Re = sxtb (Ru) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x55002000) {
				// Instruction: 5: 01010101uuuueeee00100iiissssdddd | Re = sxtb (Ru) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x55002800) {
				// Instruction: 5: 01010101uuuueeee00101iiissssdddd | Re = sxtb (Ru) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTB__RU____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x54003c00) {
				// Instruction: 5: 01010100sssseeee0011110iiiiidddd | Re = sxth (Rs) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x54003e00) {
				// Instruction: 5: 01010100sssseeee00111110iiiiiddd | Re = sxth (Rs) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RS____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x54003000) {
				// Instruction: 5: 01010100uuuueeee00110iiissssdddd | Re = sxth (Ru) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x54002000) {
				// Instruction: 5: 01010100uuuueeee00100iiissssdddd | Re = sxth (Ru) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x54002800) {
				// Instruction: 5: 01010100uuuueeee00101iiissssdddd | Re = sxth (Ru) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___SXTH__RU____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x56003c00) {
				// Instruction: 5: 01010110sssseeee0011110iiiiidddd | Re = zxth (Rs) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x56003e00) {
				// Instruction: 5: 01010110sssseeee00111110iiiiiddd | Re = zxth (Rs) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RS____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x56003000) {
				// Instruction: 5: 01010110uuuueeee00110iiissssdddd | Re = zxth (Ru) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x56002000) {
				// Instruction: 5: 01010110uuuueeee00100iiissssdddd | Re = zxth (Ru) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x56002800) {
				// Instruction: 5: 01010110uuuueeee00101iiissssdddd | Re = zxth (Ru) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RE___ZXTH__RU____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c003000) {
				// Instruction: 5: 010111-0-II00eee00110iiissssdddd | Ree = combine (#0, #U2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c002000) {
				// Instruction: 5: 010111-0-II00eee00100iiissssdddd | Ree = combine (#0, #U2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c002800) {
				// Instruction: 5: 010111-0-II00eee00101iiissssdddd | Ree = combine (#0, #U2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x5c003c00) {
				// Instruction: 5: 010111-0-II00eee0011110iiiiidddd | Ree = combine (#0, #U2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x5c003e00) {
				// Instruction: 5: 010111-0-II00eee00111110iiiiiddd | Ree = combine (#0, #U2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0___U2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x5d003c00) {
				// Instruction: 5: 010111-1ssss0eee0011110iiiiidddd | Ree = combine (#0, Rs) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RS____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x5d003e00) {
				// Instruction: 5: 010111-1ssss0eee00111110iiiiiddd | Ree = combine (#0, Rs) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RS____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d003000) {
				// Instruction: 5: 010111-1uuuu0eee00110iiissssdddd | Ree = combine (#0, Ru) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d002000) {
				// Instruction: 5: 010111-1uuuu0eee00100iiissssdddd | Ree = combine (#0, Ru) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d002800) {
				// Instruction: 5: 010111-1uuuu0eee00101iiissssdddd | Ree = combine (#0, Ru) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___0__RU____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c083000) {
				// Instruction: 5: 010111-0-II01eee00110iiissssdddd | Ree = combine (#1, #U2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c082000) {
				// Instruction: 5: 010111-0-II01eee00100iiissssdddd | Ree = combine (#1, #U2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c082800) {
				// Instruction: 5: 010111-0-II01eee00101iiissssdddd | Ree = combine (#1, #U2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x5c083c00) {
				// Instruction: 5: 010111-0-II01eee0011110iiiiidddd | Ree = combine (#1, #U2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x5c083e00) {
				// Instruction: 5: 010111-0-II01eee00111110iiiiiddd | Ree = combine (#1, #U2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___1___U2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c103000) {
				// Instruction: 5: 010111-0-II10eee00110iiissssdddd | Ree = combine (#2, #U2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c102000) {
				// Instruction: 5: 010111-0-II10eee00100iiissssdddd | Ree = combine (#2, #U2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c102800) {
				// Instruction: 5: 010111-0-II10eee00101iiissssdddd | Ree = combine (#2, #U2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x5c103c00) {
				// Instruction: 5: 010111-0-II10eee0011110iiiiidddd | Ree = combine (#2, #U2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x5c103e00) {
				// Instruction: 5: 010111-0-II10eee00111110iiiiiddd | Ree = combine (#2, #U2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___2___U2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c183000) {
				// Instruction: 5: 010111-0-II11eee00110iiissssdddd | Ree = combine (#3, #U2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c182000) {
				// Instruction: 5: 010111-0-II11eee00100iiissssdddd | Ree = combine (#3, #U2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x5c182800) {
				// Instruction: 5: 010111-0-II11eee00101iiissssdddd | Ree = combine (#3, #U2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x5c183c00) {
				// Instruction: 5: 010111-0-II11eee0011110iiiiidddd | Ree = combine (#3, #U2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x5c183e00) {
				// Instruction: 5: 010111-0-II11eee00111110iiiiiddd | Ree = combine (#3, #U2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE___3___U2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x5d083c00) {
				// Instruction: 5: 010111-1ssss1eee0011110iiiiidddd | Ree = combine (Rs, #0) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RS___0____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memw (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x5d083e00) {
				// Instruction: 5: 010111-1ssss1eee00111110iiiiiddd | Ree = combine (Rs, #0) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RS___0____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memd (Sp + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d083000) {
				// Instruction: 5: 010111-1uuuu1eee00110iiissssdddd | Ree = combine (Ru, #0) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memb (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d082000) {
				// Instruction: 5: 010111-1uuuu1eee00100iiissssdddd | Ree = combine (Ru, #0) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x5d082800) {
				// Instruction: 5: 010111-1uuuu1eee00101iiissssdddd | Ree = combine (Ru, #0) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_REE___COMBINE__RU___0____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; %s = memuh (%s + 0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x58003c00) {
				// Instruction: 5: 01011000ssssxxxx0011110iiiiidddd | Rx = add (Rs, Rx) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x58003e00) {
				// Instruction: 5: 01011000ssssxxxx00111110iiiiiddd | Rx = add (Rs, Rx) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003f40) {
				// Instruction: 5: 01011000ssssxxxx0011111101---0-- | Rx = add (Rs, Rx) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003f00) {
				// Instruction: 5: 01011000ssssxxxx0011111100---0-- | Rx = add (Rs, Rx) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f45) {
				// Instruction: 5: 01011000ssssxxxx0011111101---101 | Rx = add (Rs, Rx) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc5) {
				// Instruction: 5: 01011000ssssxxxx0011111111---101 | Rx = add (Rs, Rx) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f47) {
				// Instruction: 5: 01011000ssssxxxx0011111101---111 | Rx = add (Rs, Rx) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc7) {
				// Instruction: 5: 01011000ssssxxxx0011111111---111 | Rx = add (Rs, Rx) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f44) {
				// Instruction: 5: 01011000ssssxxxx0011111101---100 | Rx = add (Rs, Rx) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc4) {
				// Instruction: 5: 01011000ssssxxxx0011111111---100 | Rx = add (Rs, Rx) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f46) {
				// Instruction: 5: 01011000ssssxxxx0011111101---110 | Rx = add (Rs, Rx) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc6) {
				// Instruction: 5: 01011000ssssxxxx0011111111---110 | Rx = add (Rs, Rx) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003fc0) {
				// Instruction: 5: 01011000ssssxxxx0011111111---0-- | Rx = add (Rs, Rx) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58003000) {
				// Instruction: 5: 01011000uuuuxxxx00110iiissssdddd | Rx = add (Ru, Rx) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58002000) {
				// Instruction: 5: 01011000uuuuxxxx00100iiissssdddd | Rx = add (Ru, Rx) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58002800) {
				// Instruction: 5: 01011000uuuuxxxx00101iiissssdddd | Rx = add (Ru, Rx) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x40003000) {
				// Instruction: 5: 01000IIIIIIIxxxx00110iiissssdddd | Rx = add (Rx, #S7) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x40002000) {
				// Instruction: 5: 01000IIIIIIIxxxx00100iiissssdddd | Rx = add (Rx, #S7) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x40002800) {
				// Instruction: 5: 01000IIIIIIIxxxx00101iiissssdddd | Rx = add (Rx, #S7) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x40003c00) {
				// Instruction: 5: 01000IIIIIIIxxxx0011110iiiiidddd | Rx = add (Rx, #S7) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x40003e00) {
				// Instruction: 5: 01000IIIIIIIxxxx00111110iiiiiddd | Rx = add (Rx, #S7) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x40003f40) {
				// Instruction: 5: 01000iiiiiiixxxx0011111101---0-- | Rx = add (Rx, #s7) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x40003f00) {
				// Instruction: 5: 01000iiiiiiixxxx0011111100---0-- | Rx = add (Rx, #s7) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003f45) {
				// Instruction: 5: 01000iiiiiiixxxx0011111101---101 | Rx = add (Rx, #s7) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003fc5) {
				// Instruction: 5: 01000iiiiiiixxxx0011111111---101 | Rx = add (Rx, #s7) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003f47) {
				// Instruction: 5: 01000iiiiiiixxxx0011111101---111 | Rx = add (Rx, #s7) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003fc7) {
				// Instruction: 5: 01000iiiiiiixxxx0011111111---111 | Rx = add (Rx, #s7) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003f44) {
				// Instruction: 5: 01000iiiiiiixxxx0011111101---100 | Rx = add (Rx, #s7) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003fc4) {
				// Instruction: 5: 01000iiiiiiixxxx0011111111---100 | Rx = add (Rx, #s7) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003f46) {
				// Instruction: 5: 01000iiiiiiixxxx0011111101---110 | Rx = add (Rx, #s7) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc7) == 0x40003fc6) {
				// Instruction: 5: 01000iiiiiiixxxx0011111111---110 | Rx = add (Rx, #s7) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ffc4) == 0x40003fc0) {
				// Instruction: 5: 01000iiiiiiixxxx0011111111---0-- | Rx = add (Rx, #s7) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x58003c00) {
				// Instruction: 5: 01011000ssssxxxx0011110iiiiidddd | Rx = add (Rx, Rs) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x58003e00) {
				// Instruction: 5: 01011000ssssxxxx00111110iiiiiddd | Rx = add (Rx, Rs) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003f40) {
				// Instruction: 5: 01011000ssssxxxx0011111101---0-- | Rx = add (Rx, Rs) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003f00) {
				// Instruction: 5: 01011000ssssxxxx0011111100---0-- | Rx = add (Rx, Rs) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f45) {
				// Instruction: 5: 01011000ssssxxxx0011111101---101 | Rx = add (Rx, Rs) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc5) {
				// Instruction: 5: 01011000ssssxxxx0011111111---101 | Rx = add (Rx, Rs) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f47) {
				// Instruction: 5: 01011000ssssxxxx0011111101---111 | Rx = add (Rx, Rs) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc7) {
				// Instruction: 5: 01011000ssssxxxx0011111111---111 | Rx = add (Rx, Rs) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f44) {
				// Instruction: 5: 01011000ssssxxxx0011111101---100 | Rx = add (Rx, Rs) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc4) {
				// Instruction: 5: 01011000ssssxxxx0011111111---100 | Rx = add (Rx, Rs) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003f46) {
				// Instruction: 5: 01011000ssssxxxx0011111101---110 | Rx = add (Rx, Rs) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x58003fc6) {
				// Instruction: 5: 01011000ssssxxxx0011111111---110 | Rx = add (Rx, Rs) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x58003fc0) {
				// Instruction: 5: 01011000ssssxxxx0011111111---0-- | Rx = add (Rx, Rs) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58003000) {
				// Instruction: 5: 01011000uuuuxxxx00110iiissssdddd | Rx = add (Rx, Ru) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58002000) {
				// Instruction: 5: 01011000uuuuxxxx00100iiissssdddd | Rx = add (Rx, Ru) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x58002800) {
				// Instruction: 5: 01011000uuuuxxxx00101iiissssdddd | Rx = add (Rx, Ru) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a703f40) {
				// Instruction: 5: 0101101--111dddd0011111101---0-- | if (! p0) Rd = #0 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a703f00) {
				// Instruction: 5: 0101101--111dddd0011111100---0-- | if (! p0) Rd = #0 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___DEALLOCFRAME;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703f45) {
				// Instruction: 5: 0101101--111dddd0011111101---101 | if (! p0) Rd = #0 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703fc5) {
				// Instruction: 5: 0101101--111dddd0011111111---101 | if (! p0) Rd = #0 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703f47) {
				// Instruction: 5: 0101101--111dddd0011111101---111 | if (! p0) Rd = #0 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703fc7) {
				// Instruction: 5: 0101101--111dddd0011111111---111 | if (! p0) Rd = #0 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703f44) {
				// Instruction: 5: 0101101--111dddd0011111101---100 | if (! p0) Rd = #0 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703fc4) {
				// Instruction: 5: 0101101--111dddd0011111111---100 | if (! p0) Rd = #0 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703f46) {
				// Instruction: 5: 0101101--111dddd0011111101---110 | if (! p0) Rd = #0 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a703fc6) {
				// Instruction: 5: 0101101--111dddd0011111111---110 | if (! p0) Rd = #0 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a703fc0) {
				// Instruction: 5: 0101101--111dddd0011111111---0-- | if (! p0) Rd = #0 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a703000) {
				// Instruction: 5: 0101101--111eeee00110iiissssdddd | if (! p0) Re = #0 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMB__RS____U3_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a702000) {
				// Instruction: 5: 0101101--111eeee00100iiissssdddd | if (! p0) Re = #0 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a702800) {
				// Instruction: 5: 0101101--111eeee00101iiissssdddd | if (! p0) Re = #0 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMUH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x5a703c00) {
				// Instruction: 5: 0101101--111eeee0011110iiiiidddd | if (! p0) Re = #0 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RD___MEMW__SP____U5_2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x5a703e00) {
				// Instruction: 5: 0101101--111eeee00111110iiiiiddd | if (! p0) Re = #0 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RE____0___RDD___MEMD__SP____U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a503f40) {
				// Instruction: 5: 0101101--101dddd0011111101---0-- | if (! p0.new) Rd = #0 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a503f00) {
				// Instruction: 5: 0101101--101dddd0011111100---0-- | if (! p0.new) Rd = #0 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___DEALLOCFRAME;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503f45) {
				// Instruction: 5: 0101101--101dddd0011111101---101 | if (! p0.new) Rd = #0 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503fc5) {
				// Instruction: 5: 0101101--101dddd0011111111---101 | if (! p0.new) Rd = #0 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503f47) {
				// Instruction: 5: 0101101--101dddd0011111101---111 | if (! p0.new) Rd = #0 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503fc7) {
				// Instruction: 5: 0101101--101dddd0011111111---111 | if (! p0.new) Rd = #0 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503f44) {
				// Instruction: 5: 0101101--101dddd0011111101---100 | if (! p0.new) Rd = #0 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503fc4) {
				// Instruction: 5: 0101101--101dddd0011111111---100 | if (! p0.new) Rd = #0 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503f46) {
				// Instruction: 5: 0101101--101dddd0011111101---110 | if (! p0.new) Rd = #0 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a503fc6) {
				// Instruction: 5: 0101101--101dddd0011111111---110 | if (! p0.new) Rd = #0 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a503fc0) {
				// Instruction: 5: 0101101--101dddd0011111111---0-- | if (! p0.new) Rd = #0 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a503000) {
				// Instruction: 5: 0101101--101eeee00110iiissssdddd | if (! p0.new) Re = #0 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMB__RS____U3_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a502000) {
				// Instruction: 5: 0101101--101eeee00100iiissssdddd | if (! p0.new) Re = #0 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a502800) {
				// Instruction: 5: 0101101--101eeee00101iiissssdddd | if (! p0.new) Re = #0 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMUH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x5a503c00) {
				// Instruction: 5: 0101101--101eeee0011110iiiiidddd | if (! p0.new) Re = #0 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RD___MEMW__SP____U5_2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x5a503e00) {
				// Instruction: 5: 0101101--101eeee00111110iiiiiddd | if (! p0.new) Re = #0 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RE____0___RDD___MEMD__SP____U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a603f40) {
				// Instruction: 5: 0101101--110dddd0011111101---0-- | if (p0) Rd = #0 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a603f00) {
				// Instruction: 5: 0101101--110dddd0011111100---0-- | if (p0) Rd = #0 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___DEALLOCFRAME;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603f45) {
				// Instruction: 5: 0101101--110dddd0011111101---101 | if (p0) Rd = #0 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603fc5) {
				// Instruction: 5: 0101101--110dddd0011111111---101 | if (p0) Rd = #0 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603f47) {
				// Instruction: 5: 0101101--110dddd0011111101---111 | if (p0) Rd = #0 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603fc7) {
				// Instruction: 5: 0101101--110dddd0011111111---111 | if (p0) Rd = #0 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603f44) {
				// Instruction: 5: 0101101--110dddd0011111101---100 | if (p0) Rd = #0 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603fc4) {
				// Instruction: 5: 0101101--110dddd0011111111---100 | if (p0) Rd = #0 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603f46) {
				// Instruction: 5: 0101101--110dddd0011111101---110 | if (p0) Rd = #0 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a603fc6) {
				// Instruction: 5: 0101101--110dddd0011111111---110 | if (p0) Rd = #0 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a603fc0) {
				// Instruction: 5: 0101101--110dddd0011111111---0-- | if (p0) Rd = #0 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a603000) {
				// Instruction: 5: 0101101--110eeee00110iiissssdddd | if (p0) Re = #0 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMB__RS____U3_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a602000) {
				// Instruction: 5: 0101101--110eeee00100iiissssdddd | if (p0) Re = #0 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a602800) {
				// Instruction: 5: 0101101--110eeee00101iiissssdddd | if (p0) Re = #0 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMUH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x5a603c00) {
				// Instruction: 5: 0101101--110eeee0011110iiiiidddd | if (p0) Re = #0 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RD___MEMW__SP____U5_2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x5a603e00) {
				// Instruction: 5: 0101101--110eeee00111110iiiiiddd | if (p0) Re = #0 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RE____0___RDD___MEMD__SP____U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a403f40) {
				// Instruction: 5: 0101101--100dddd0011111101---0-- | if (p0.new) Rd = #0 ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a403f00) {
				// Instruction: 5: 0101101--100dddd0011111100---0-- | if (p0.new) Rd = #0 ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___DEALLOCFRAME;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403f45) {
				// Instruction: 5: 0101101--100dddd0011111101---101 | if (p0.new) Rd = #0 ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403fc5) {
				// Instruction: 5: 0101101--100dddd0011111111---101 | if (p0.new) Rd = #0 ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF___NOT__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403f47) {
				// Instruction: 5: 0101101--100dddd0011111101---111 | if (p0.new) Rd = #0 ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403fc7) {
				// Instruction: 5: 0101101--100dddd0011111111---111 | if (p0.new) Rd = #0 ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403f44) {
				// Instruction: 5: 0101101--100dddd0011111101---100 | if (p0.new) Rd = #0 ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF__P0__DEALLOC_RETURN;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403fc4) {
				// Instruction: 5: 0101101--100dddd0011111111---100 | if (p0.new) Rd = #0 ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF__P0__JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403f46) {
				// Instruction: 5: 0101101--100dddd0011111101---110 | if (p0.new) Rd = #0 ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc7) == 0x5a403fc6) {
				// Instruction: 5: 0101101--100dddd0011111111---110 | if (p0.new) Rd = #0 ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ffc4) == 0x5a403fc0) {
				// Instruction: 5: 0101101--100dddd0011111111---0-- | if (p0.new) Rd = #0 ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___JUMPR_LR;
				hi->op_count = 1;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a403000) {
				// Instruction: 5: 0101101--100eeee00110iiissssdddd | if (p0.new) Re = #0 ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMB__RS____U3_0_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a402000) {
				// Instruction: 5: 0101101--100eeee00100iiissssdddd | if (p0.new) Re = #0 ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x5a402800) {
				// Instruction: 5: 0101101--100eeee00101iiissssdddd | if (p0.new) Re = #0 ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMUH__RS____U3_1_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x5a403c00) {
				// Instruction: 5: 0101101--100eeee0011110iiiiidddd | if (p0.new) Re = #0 ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RD___MEMW__SP____U5_2_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x5a403e00) {
				// Instruction: 5: 0101101--100eeee00111110iiiiiddd | if (p0.new) Re = #0 ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RE____0___RDD___MEMD__SP____U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Re
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].attr |= HEX_OP_REG_PAIR;
				hi->ops[1].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_regpair(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x59003c00) {
				// Instruction: 5: 01011001ssss--II0011110iiiiidddd | p0 = cmp.eq (Rs, #U2) ; Rd = memw (Sp + #u5:2)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RD___MEMW__SP____U5_2_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memw (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x59003e00) {
				// Instruction: 5: 01011001ssss--II00111110iiiiiddd | p0 = cmp.eq (Rs, #U2) ; Rdd = memd (Sp + #u5:3)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____RDD___MEMD__SP____U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf8) >> 3) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memd (Sp + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x59003f40) {
				// Instruction: 5: 01011001ssss--ii0011111101---0-- | p0 = cmp.eq (Rs, #u2) ; dealloc_return
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x59003f00) {
				// Instruction: 5: 01011001ssss--ii0011111100---0-- | p0 = cmp.eq (Rs, #u2) ; deallocframe
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____DEALLOCFRAME;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; deallocframe", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003f45) {
				// Instruction: 5: 01011001ssss--ii0011111101---101 | p0 = cmp.eq (Rs, #u2) ; if (! p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003fc5) {
				// Instruction: 5: 01011001ssss--ii0011111111---101 | p0 = cmp.eq (Rs, #u2) ; if (! p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003f47) {
				// Instruction: 5: 01011001ssss--ii0011111101---111 | p0 = cmp.eq (Rs, #u2) ; if (! p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003fc7) {
				// Instruction: 5: 01011001ssss--ii0011111111---111 | p0 = cmp.eq (Rs, #u2) ; if (! p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF___NOT__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (! p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003f44) {
				// Instruction: 5: 01011001ssss--ii0011111101---100 | p0 = cmp.eq (Rs, #u2) ; if (p0) dealloc_return
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0__DEALLOC_RETURN;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0) dealloc_return", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003fc4) {
				// Instruction: 5: 01011001ssss--ii0011111111---100 | p0 = cmp.eq (Rs, #u2) ; if (p0) jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0__JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0) jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003f46) {
				// Instruction: 5: 01011001ssss--ii0011111101---110 | p0 = cmp.eq (Rs, #u2) ; if (p0.new) dealloc_return:nt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0_NEW__DEALLOC_RETURN_NT;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0.new) dealloc_return:nt", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc7) == 0x59003fc6) {
				// Instruction: 5: 01011001ssss--ii0011111111---110 | p0 = cmp.eq (Rs, #u2) ; if (p0.new) jumpr:nt Lr
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____IF__P0_NEW__JUMPR_NT_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; if (p0.new) jumpr:nt Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ffc4) == 0x59003fc0) {
				// Instruction: 5: 01011001ssss--ii0011111111---0-- | p0 = cmp.eq (Rs, #u2) ; jumpr Lr
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____JUMPR_LR;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; jumpr Lr", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x59003000) {
				// Instruction: 5: 01011001uuuu--II00110iiissssdddd | p0 = cmp.eq (Ru, #U2) ; Rd = memb (Rs + #u3:0)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RD___MEMB__RS____U3_0_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memb (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x59002000) {
				// Instruction: 5: 01011001uuuu--II00100iiissssdddd | p0 = cmp.eq (Ru, #U2) ; Rd = memh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RD___MEMH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x59002800) {
				// Instruction: 5: 01011001uuuu--II00101iiissssdddd | p0 = cmp.eq (Ru, #U2) ; Rd = memuh (Rs + #u3:1)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____RD___MEMUH__RS____U3_1_;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rd
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; %s = memuh (%s + 0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			break;
		}
		case 0x6: {
			if ((hi_u32 & 0xfe40f000) == 0x7a001000) {
				// Instruction: 6: 0111101--0--dddd0001iiiisssstttt | Rd = #-1 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMB__RS____U4_0____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40f000) == 0x7a000000) {
				// Instruction: 6: 0111101--0--dddd0000iiiisssstttt | Rd = #-1 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMW__RS____U4_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x68001000) {
				// Instruction: 6: 011010IIIIIIdddd0001iiiisssstttt | Rd = #U6 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x68000000) {
				// Instruction: 6: 011010IIIIIIdddd0000iiiisssstttt | Rd = #U6 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x70001000) {
				// Instruction: 6: 01110000uuuudddd0001iiiisssstttt | Rd = Ru ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x70000000) {
				// Instruction: 6: 01110000uuuudddd0000iiiisssstttt | Rd = Ru ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x73001000) {
				// Instruction: 6: 01110011uuuudddd0001iiiisssstttt | Rd = add (Ru, #-1) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x73000000) {
				// Instruction: 6: 01110011uuuudddd0000iiiisssstttt | Rd = add (Ru, #-1) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x71001000) {
				// Instruction: 6: 01110001uuuudddd0001iiiisssstttt | Rd = add (Ru, #1) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x71000000) {
				// Instruction: 6: 01110001uuuudddd0000iiiisssstttt | Rd = add (Ru, #1) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x6c001000) {
				// Instruction: 6: 011011IIIIIIdddd0001iiiisssstttt | Rd = add (Sp, #U6:2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f000) == 0x6c000000) {
				// Instruction: 6: 011011IIIIIIdddd0000iiiisssstttt | Rd = add (Sp, #U6:2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x72001000) {
				// Instruction: 6: 01110010uuuudddd0001iiiisssstttt | Rd = and (Ru, #1) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x72000000) {
				// Instruction: 6: 01110010uuuudddd0000iiiisssstttt | Rd = and (Ru, #1) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x77001000) {
				// Instruction: 6: 01110111uuuudddd0001iiiisssstttt | Rd = and (Ru, #255) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x77000000) {
				// Instruction: 6: 01110111uuuudddd0000iiiisssstttt | Rd = and (Ru, #255) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x75001000) {
				// Instruction: 6: 01110101uuuudddd0001iiiisssstttt | Rd = sxtb (Ru) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x75000000) {
				// Instruction: 6: 01110101uuuudddd0000iiiisssstttt | Rd = sxtb (Ru) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x74001000) {
				// Instruction: 6: 01110100uuuudddd0001iiiisssstttt | Rd = sxth (Ru) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x74000000) {
				// Instruction: 6: 01110100uuuudddd0000iiiisssstttt | Rd = sxth (Ru) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x76001000) {
				// Instruction: 6: 01110110uuuudddd0001iiiisssstttt | Rd = zxth (Ru) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x76000000) {
				// Instruction: 6: 01110110uuuudddd0000iiiisssstttt | Rd = zxth (Ru) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c001000) {
				// Instruction: 6: 011111-0-II00ddd0001iiiisssstttt | Rdd = combine (#0, #U2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c000000) {
				// Instruction: 6: 011111-0-II00ddd0000iiiisssstttt | Rdd = combine (#0, #U2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x7d001000) {
				// Instruction: 6: 011111-1uuuu0ddd0001iiiisssstttt | Rdd = combine (#0, Ru) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x7d000000) {
				// Instruction: 6: 011111-1uuuu0ddd0000iiiisssstttt | Rdd = combine (#0, Ru) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c081000) {
				// Instruction: 6: 011111-0-II01ddd0001iiiisssstttt | Rdd = combine (#1, #U2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c080000) {
				// Instruction: 6: 011111-0-II01ddd0000iiiisssstttt | Rdd = combine (#1, #U2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c101000) {
				// Instruction: 6: 011111-0-II10ddd0001iiiisssstttt | Rdd = combine (#2, #U2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c100000) {
				// Instruction: 6: 011111-0-II10ddd0000iiiisssstttt | Rdd = combine (#2, #U2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c181000) {
				// Instruction: 6: 011111-0-II11ddd0001iiiisssstttt | Rdd = combine (#3, #U2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f000) == 0x7c180000) {
				// Instruction: 6: 011111-0-II11ddd0000iiiisssstttt | Rdd = combine (#3, #U2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x7d081000) {
				// Instruction: 6: 011111-1uuuu1ddd0001iiiisssstttt | Rdd = combine (Ru, #0) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08f000) == 0x7d080000) {
				// Instruction: 6: 011111-1uuuu1ddd0000iiiisssstttt | Rdd = combine (Ru, #0) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x78001000) {
				// Instruction: 6: 01111000uuuuxxxx0001iiiisssstttt | Rx = add (Ru, Rx) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x78000000) {
				// Instruction: 6: 01111000uuuuxxxx0000iiiisssstttt | Rx = add (Ru, Rx) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x60001000) {
				// Instruction: 6: 01100IIIIIIIxxxx0001iiiisssstttt | Rx = add (Rx, #S7) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x60000000) {
				// Instruction: 6: 01100IIIIIIIxxxx0000iiiisssstttt | Rx = add (Rx, #S7) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x78001000) {
				// Instruction: 6: 01111000uuuuxxxx0001iiiisssstttt | Rx = add (Rx, Ru) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x78000000) {
				// Instruction: 6: 01111000uuuuxxxx0000iiiisssstttt | Rx = add (Rx, Ru) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a701000) {
				// Instruction: 6: 0111101--111dddd0001iiiisssstttt | if (! p0) Rd = #0 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMB__RS____U4_0____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a700000) {
				// Instruction: 6: 0111101--111dddd0000iiiisssstttt | if (! p0) Rd = #0 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMW__RS____U4_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a501000) {
				// Instruction: 6: 0111101--101dddd0001iiiisssstttt | if (! p0.new) Rd = #0 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMB__RS____U4_0____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a500000) {
				// Instruction: 6: 0111101--101dddd0000iiiisssstttt | if (! p0.new) Rd = #0 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMW__RS____U4_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a601000) {
				// Instruction: 6: 0111101--110dddd0001iiiisssstttt | if (p0) Rd = #0 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMB__RS____U4_0____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a600000) {
				// Instruction: 6: 0111101--110dddd0000iiiisssstttt | if (p0) Rd = #0 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMW__RS____U4_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a401000) {
				// Instruction: 6: 0111101--100dddd0001iiiisssstttt | if (p0.new) Rd = #0 ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMB__RS____U4_0____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f000) == 0x7a400000) {
				// Instruction: 6: 0111101--100dddd0000iiiisssstttt | if (p0.new) Rd = #0 ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMW__RS____U4_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x79001000) {
				// Instruction: 6: 01111001uuuu--II0001iiiisssstttt | p0 = cmp.eq (Ru, #U2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x79000000) {
				// Instruction: 6: 01111001uuuu--II0000iiiisssstttt | p0 = cmp.eq (Ru, #U2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			break;
		}
		case 0x7: {
			if ((hi_u32 & 0xfe40fe00) == 0x7a003c00) {
				// Instruction: 7: 0111101--0--dddd0011110iiiii---- | Rd = #-1 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD_____1___ALLOCFRAME___U5_3_;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40ff00) == 0x7a003200) {
				// Instruction: 7: 0111101--0--dddd00110010ssssiiii | Rd = #-1 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMB__RS____U4_0_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40ff00) == 0x7a003300) {
				// Instruction: 7: 0111101--0--dddd00110011ssssiiii | Rd = #-1 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMB__RS____U4_0_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fe00) == 0x7a002a00) {
				// Instruction: 7: 0111101--0--dddd0010101iiiiiittt | Rd = #-1 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMD__SP____S6_3____RTT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[1].op.imm & (1 << 8)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40f800) == 0x7a002000) {
				// Instruction: 7: 0111101--0--dddd00100iiisssstttt | Rd = #-1 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMH__RS____U3_1____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe40ff00) == 0x7a003000) {
				// Instruction: 7: 0111101--0--dddd00110000ssssiiii | Rd = #-1 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMW__RS____U4_2_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40ff00) == 0x7a003100) {
				// Instruction: 7: 0111101--0--dddd00110001ssssiiii | Rd = #-1 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMW__RS____U4_2_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe40fe00) == 0x7a002800) {
				// Instruction: 7: 0111101--0--dddd0010100iiiiitttt | Rd = #-1 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD_____1___MEMW__SP____U5_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = #-1 ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x68003c00) {
				// Instruction: 7: 011010IIIIIIdddd0011110iiiii---- | Rd = #U6 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD____U6___ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x68003200) {
				// Instruction: 7: 011010IIIIIIdddd00110010ssssiiii | Rd = #U6 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x68003300) {
				// Instruction: 7: 011010IIIIIIdddd00110011ssssiiii | Rd = #U6 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x68002a00) {
				// Instruction: 7: 011010IIIIIIdddd0010101iiiiiittt | Rd = #U6 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x68002000) {
				// Instruction: 7: 011010IIIIIIdddd00100iiisssstttt | Rd = #U6 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x68003000) {
				// Instruction: 7: 011010IIIIIIdddd00110000ssssiiii | Rd = #U6 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x68003100) {
				// Instruction: 7: 011010IIIIIIdddd00110001ssssiiii | Rd = #U6 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x68002800) {
				// Instruction: 7: 011010IIIIIIdddd0010100iiiiitttt | Rd = #U6 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD____U6___MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = 0x%x ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x70003c00) {
				// Instruction: 7: 01110000ssssdddd0011110iiiii---- | Rd = Rs ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___RS___ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x70002a00) {
				// Instruction: 7: 01110000ssssdddd0010101iiiiiittt | Rd = Rs ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___RS___MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x70002800) {
				// Instruction: 7: 01110000ssssdddd0010100iiiiitttt | Rd = Rs ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___RS___MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x70003200) {
				// Instruction: 7: 01110000uuuudddd00110010ssssiiii | Rd = Ru ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x70003300) {
				// Instruction: 7: 01110000uuuudddd00110011ssssiiii | Rd = Ru ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x70002000) {
				// Instruction: 7: 01110000uuuudddd00100iiisssstttt | Rd = Ru ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x70003000) {
				// Instruction: 7: 01110000uuuudddd00110000ssssiiii | Rd = Ru ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x70003100) {
				// Instruction: 7: 01110000uuuudddd00110001ssssiiii | Rd = Ru ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___RU___MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = %s ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x73003c00) {
				// Instruction: 7: 01110011ssssdddd0011110iiiii---- | Rd = add (Rs, #-1) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x73002a00) {
				// Instruction: 7: 01110011ssssdddd0010101iiiiiittt | Rd = add (Rs, #-1) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x73002800) {
				// Instruction: 7: 01110011ssssdddd0010100iiiiitttt | Rd = add (Rs, #-1) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS____1____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x71003c00) {
				// Instruction: 7: 01110001ssssdddd0011110iiiii---- | Rd = add (Rs, #1) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x71002a00) {
				// Instruction: 7: 01110001ssssdddd0010101iiiiiittt | Rd = add (Rs, #1) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x71002800) {
				// Instruction: 7: 01110001ssssdddd0010100iiiiitttt | Rd = add (Rs, #1) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RS___1____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x73003200) {
				// Instruction: 7: 01110011uuuudddd00110010ssssiiii | Rd = add (Ru, #-1) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x73003300) {
				// Instruction: 7: 01110011uuuudddd00110011ssssiiii | Rd = add (Ru, #-1) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x73002000) {
				// Instruction: 7: 01110011uuuudddd00100iiisssstttt | Rd = add (Ru, #-1) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x73003000) {
				// Instruction: 7: 01110011uuuudddd00110000ssssiiii | Rd = add (Ru, #-1) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x73003100) {
				// Instruction: 7: 01110011uuuudddd00110001ssssiiii | Rd = add (Ru, #-1) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU____1____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #-1) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x71003200) {
				// Instruction: 7: 01110001uuuudddd00110010ssssiiii | Rd = add (Ru, #1) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x71003300) {
				// Instruction: 7: 01110001uuuudddd00110011ssssiiii | Rd = add (Ru, #1) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x71002000) {
				// Instruction: 7: 01110001uuuudddd00100iiisssstttt | Rd = add (Ru, #1) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x71003000) {
				// Instruction: 7: 01110001uuuudddd00110000ssssiiii | Rd = add (Ru, #1) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x71003100) {
				// Instruction: 7: 01110001uuuudddd00110001ssssiiii | Rd = add (Ru, #1) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__RU___1____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, #1) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x6c003c00) {
				// Instruction: 7: 011011IIIIIIdddd0011110iiiii---- | Rd = add (Sp, #U6:2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x6c003200) {
				// Instruction: 7: 011011IIIIIIdddd00110010ssssiiii | Rd = add (Sp, #U6:2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x6c003300) {
				// Instruction: 7: 011011IIIIIIdddd00110011ssssiiii | Rd = add (Sp, #U6:2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x6c002a00) {
				// Instruction: 7: 011011IIIIIIdddd0010101iiiiiittt | Rd = add (Sp, #U6:2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00f800) == 0x6c002000) {
				// Instruction: 7: 011011IIIIIIdddd00100iiisssstttt | Rd = add (Sp, #U6:2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x6c003000) {
				// Instruction: 7: 011011IIIIIIdddd00110000ssssiiii | Rd = add (Sp, #U6:2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00ff00) == 0x6c003100) {
				// Instruction: 7: 011011IIIIIIdddd00110001ssssiiii | Rd = add (Sp, #U6:2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfc00fe00) == 0x6c002800) {
				// Instruction: 7: 011011IIIIIIdddd0010100iiiiitttt | Rd = add (Sp, #U6:2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ADD__SP___U6_2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x3f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Sp, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x72003c00) {
				// Instruction: 7: 01110010ssssdddd0011110iiiii---- | Rd = and (Rs, #1) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x72002a00) {
				// Instruction: 7: 01110010ssssdddd0010101iiiiiittt | Rd = and (Rs, #1) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x72002800) {
				// Instruction: 7: 01110010ssssdddd0010100iiiiitttt | Rd = and (Rs, #1) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___1____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x77003c00) {
				// Instruction: 7: 01110111ssssdddd0011110iiiii---- | Rd = and (Rs, #255) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x77002a00) {
				// Instruction: 7: 01110111ssssdddd0010101iiiiiittt | Rd = and (Rs, #255) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x77002800) {
				// Instruction: 7: 01110111ssssdddd0010100iiiiitttt | Rd = and (Rs, #255) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RS___255____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x72003200) {
				// Instruction: 7: 01110010uuuudddd00110010ssssiiii | Rd = and (Ru, #1) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x72003300) {
				// Instruction: 7: 01110010uuuudddd00110011ssssiiii | Rd = and (Ru, #1) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x72002000) {
				// Instruction: 7: 01110010uuuudddd00100iiisssstttt | Rd = and (Ru, #1) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x72003000) {
				// Instruction: 7: 01110010uuuudddd00110000ssssiiii | Rd = and (Ru, #1) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x72003100) {
				// Instruction: 7: 01110010uuuudddd00110001ssssiiii | Rd = and (Ru, #1) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___1____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #1) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x77003200) {
				// Instruction: 7: 01110111uuuudddd00110010ssssiiii | Rd = and (Ru, #255) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x77003300) {
				// Instruction: 7: 01110111uuuudddd00110011ssssiiii | Rd = and (Ru, #255) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x77002000) {
				// Instruction: 7: 01110111uuuudddd00100iiisssstttt | Rd = and (Ru, #255) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x77003000) {
				// Instruction: 7: 01110111uuuudddd00110000ssssiiii | Rd = and (Ru, #255) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x77003100) {
				// Instruction: 7: 01110111uuuudddd00110001ssssiiii | Rd = and (Ru, #255) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___AND__RU___255____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = and (%s, #255) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x75003c00) {
				// Instruction: 7: 01110101ssssdddd0011110iiiii---- | Rd = sxtb (Rs) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x75002a00) {
				// Instruction: 7: 01110101ssssdddd0010101iiiiiittt | Rd = sxtb (Rs) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x75002800) {
				// Instruction: 7: 01110101ssssdddd0010100iiiiitttt | Rd = sxtb (Rs) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RS____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x75003200) {
				// Instruction: 7: 01110101uuuudddd00110010ssssiiii | Rd = sxtb (Ru) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x75003300) {
				// Instruction: 7: 01110101uuuudddd00110011ssssiiii | Rd = sxtb (Ru) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x75002000) {
				// Instruction: 7: 01110101uuuudddd00100iiisssstttt | Rd = sxtb (Ru) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x75003000) {
				// Instruction: 7: 01110101uuuudddd00110000ssssiiii | Rd = sxtb (Ru) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x75003100) {
				// Instruction: 7: 01110101uuuudddd00110001ssssiiii | Rd = sxtb (Ru) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___SXTB__RU____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxtb (%s) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x74003c00) {
				// Instruction: 7: 01110100ssssdddd0011110iiiii---- | Rd = sxth (Rs) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x74002a00) {
				// Instruction: 7: 01110100ssssdddd0010101iiiiiittt | Rd = sxth (Rs) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x74002800) {
				// Instruction: 7: 01110100ssssdddd0010100iiiiitttt | Rd = sxth (Rs) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RS____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x74003200) {
				// Instruction: 7: 01110100uuuudddd00110010ssssiiii | Rd = sxth (Ru) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x74003300) {
				// Instruction: 7: 01110100uuuudddd00110011ssssiiii | Rd = sxth (Ru) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x74002000) {
				// Instruction: 7: 01110100uuuudddd00100iiisssstttt | Rd = sxth (Ru) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x74003000) {
				// Instruction: 7: 01110100uuuudddd00110000ssssiiii | Rd = sxth (Ru) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x74003100) {
				// Instruction: 7: 01110100uuuudddd00110001ssssiiii | Rd = sxth (Ru) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___SXTH__RU____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = sxth (%s) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x76003c00) {
				// Instruction: 7: 01110110ssssdddd0011110iiiii---- | Rd = zxth (Rs) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x76002a00) {
				// Instruction: 7: 01110110ssssdddd0010101iiiiiittt | Rd = zxth (Rs) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x76002800) {
				// Instruction: 7: 01110110ssssdddd0010100iiiiitttt | Rd = zxth (Rs) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RS____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x76003200) {
				// Instruction: 7: 01110110uuuudddd00110010ssssiiii | Rd = zxth (Ru) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x76003300) {
				// Instruction: 7: 01110110uuuudddd00110011ssssiiii | Rd = zxth (Ru) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x76002000) {
				// Instruction: 7: 01110110uuuudddd00100iiisssstttt | Rd = zxth (Ru) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x76003000) {
				// Instruction: 7: 01110110uuuudddd00110000ssssiiii | Rd = zxth (Ru) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x76003100) {
				// Instruction: 7: 01110110uuuudddd00110001ssssiiii | Rd = zxth (Ru) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___ZXTH__RU____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = zxth (%s) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c003c00) {
				// Instruction: 7: 011111-0-II00ddd0011110iiiii---- | Rdd = combine (#0, #U2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c003200) {
				// Instruction: 7: 011111-0-II00ddd00110010ssssiiii | Rdd = combine (#0, #U2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c003300) {
				// Instruction: 7: 011111-0-II00ddd00110011ssssiiii | Rdd = combine (#0, #U2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c002a00) {
				// Instruction: 7: 011111-0-II00ddd0010101iiiiiittt | Rdd = combine (#0, #U2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x7c002000) {
				// Instruction: 7: 011111-0-II00ddd00100iiisssstttt | Rdd = combine (#0, #U2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c003000) {
				// Instruction: 7: 011111-0-II00ddd00110000ssssiiii | Rdd = combine (#0, #U2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c003100) {
				// Instruction: 7: 011111-0-II00ddd00110001ssssiiii | Rdd = combine (#0, #U2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c002800) {
				// Instruction: 7: 011111-0-II00ddd0010100iiiiitttt | Rdd = combine (#0, #U2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0___U2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d003c00) {
				// Instruction: 7: 011111-1ssss0ddd0011110iiiii---- | Rdd = combine (#0, Rs) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d002a00) {
				// Instruction: 7: 011111-1ssss0ddd0010101iiiiiittt | Rdd = combine (#0, Rs) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d002800) {
				// Instruction: 7: 011111-1ssss0ddd0010100iiiiitttt | Rdd = combine (#0, Rs) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RS____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d003200) {
				// Instruction: 7: 011111-1uuuu0ddd00110010ssssiiii | Rdd = combine (#0, Ru) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d003300) {
				// Instruction: 7: 011111-1uuuu0ddd00110011ssssiiii | Rdd = combine (#0, Ru) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x7d002000) {
				// Instruction: 7: 011111-1uuuu0ddd00100iiisssstttt | Rdd = combine (#0, Ru) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d003000) {
				// Instruction: 7: 011111-1uuuu0ddd00110000ssssiiii | Rdd = combine (#0, Ru) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d003100) {
				// Instruction: 7: 011111-1uuuu0ddd00110001ssssiiii | Rdd = combine (#0, Ru) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___0__RU____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#0, %s) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c083c00) {
				// Instruction: 7: 011111-0-II01ddd0011110iiiii---- | Rdd = combine (#1, #U2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c083200) {
				// Instruction: 7: 011111-0-II01ddd00110010ssssiiii | Rdd = combine (#1, #U2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c083300) {
				// Instruction: 7: 011111-0-II01ddd00110011ssssiiii | Rdd = combine (#1, #U2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c082a00) {
				// Instruction: 7: 011111-0-II01ddd0010101iiiiiittt | Rdd = combine (#1, #U2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x7c082000) {
				// Instruction: 7: 011111-0-II01ddd00100iiisssstttt | Rdd = combine (#1, #U2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c083000) {
				// Instruction: 7: 011111-0-II01ddd00110000ssssiiii | Rdd = combine (#1, #U2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c083100) {
				// Instruction: 7: 011111-0-II01ddd00110001ssssiiii | Rdd = combine (#1, #U2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c082800) {
				// Instruction: 7: 011111-0-II01ddd0010100iiiiitttt | Rdd = combine (#1, #U2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___1___U2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#1, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c103c00) {
				// Instruction: 7: 011111-0-II10ddd0011110iiiii---- | Rdd = combine (#2, #U2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c103200) {
				// Instruction: 7: 011111-0-II10ddd00110010ssssiiii | Rdd = combine (#2, #U2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c103300) {
				// Instruction: 7: 011111-0-II10ddd00110011ssssiiii | Rdd = combine (#2, #U2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c102a00) {
				// Instruction: 7: 011111-0-II10ddd0010101iiiiiittt | Rdd = combine (#2, #U2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x7c102000) {
				// Instruction: 7: 011111-0-II10ddd00100iiisssstttt | Rdd = combine (#2, #U2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c103000) {
				// Instruction: 7: 011111-0-II10ddd00110000ssssiiii | Rdd = combine (#2, #U2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c103100) {
				// Instruction: 7: 011111-0-II10ddd00110001ssssiiii | Rdd = combine (#2, #U2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c102800) {
				// Instruction: 7: 011111-0-II10ddd0010100iiiiitttt | Rdd = combine (#2, #U2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___2___U2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#2, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c183c00) {
				// Instruction: 7: 011111-0-II11ddd0011110iiiii---- | Rdd = combine (#3, #U2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c183200) {
				// Instruction: 7: 011111-0-II11ddd00110010ssssiiii | Rdd = combine (#3, #U2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c183300) {
				// Instruction: 7: 011111-0-II11ddd00110011ssssiiii | Rdd = combine (#3, #U2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c182a00) {
				// Instruction: 7: 011111-0-II11ddd0010101iiiiiittt | Rdd = combine (#3, #U2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18f800) == 0x7c182000) {
				// Instruction: 7: 011111-0-II11ddd00100iiisssstttt | Rdd = combine (#3, #U2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c183000) {
				// Instruction: 7: 011111-0-II11ddd00110000ssssiiii | Rdd = combine (#3, #U2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18ff00) == 0x7c183100) {
				// Instruction: 7: 011111-0-II11ddd00110001ssssiiii | Rdd = combine (#3, #U2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd18fe00) == 0x7c182800) {
				// Instruction: 7: 011111-0-II11ddd0010100iiiiitttt | Rdd = combine (#3, #U2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE___3___U2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x600000) >> 21);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (#3, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d083c00) {
				// Instruction: 7: 011111-1ssss1ddd0011110iiiii---- | Rdd = combine (Rs, #0) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; allocframe (0x%x)", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d082a00) {
				// Instruction: 7: 011111-1ssss1ddd0010101iiiiiittt | Rdd = combine (Rs, #0) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memd (Sp + %d) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08fe00) == 0x7d082800) {
				// Instruction: 7: 011111-1ssss1ddd0010100iiiiitttt | Rdd = combine (Rs, #0) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RS___0____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memw (Sp + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d083200) {
				// Instruction: 7: 011111-1uuuu1ddd00110010ssssiiii | Rdd = combine (Ru, #0) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memb (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d083300) {
				// Instruction: 7: 011111-1uuuu1ddd00110011ssssiiii | Rdd = combine (Ru, #0) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memb (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08f800) == 0x7d082000) {
				// Instruction: 7: 011111-1uuuu1ddd00100iiisssstttt | Rdd = combine (Ru, #0) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memh (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d083000) {
				// Instruction: 7: 011111-1uuuu1ddd00110000ssssiiii | Rdd = combine (Ru, #0) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memw (%s + 0x%x) = #0", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfd08ff00) == 0x7d083100) {
				// Instruction: 7: 011111-1uuuu1ddd00110001ssssiiii | Rdd = combine (Ru, #0) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RDD___COMBINE__RU___0____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = combine (%s, #0) ; memw (%s + 0x%x) = #1", hex_get_sub_regpair(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78003c00) {
				// Instruction: 7: 01111000ssssxxxx0011110iiiii---- | Rx = add (Rs, Rx) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78002a00) {
				// Instruction: 7: 01111000ssssxxxx0010101iiiiiittt | Rx = add (Rs, Rx) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78002800) {
				// Instruction: 7: 01111000ssssxxxx0010100iiiiitttt | Rx = add (Rs, Rx) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RS__RX____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003200) {
				// Instruction: 7: 01111000uuuuxxxx00110010ssssiiii | Rx = add (Ru, Rx) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003300) {
				// Instruction: 7: 01111000uuuuxxxx00110011ssssiiii | Rx = add (Ru, Rx) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x78002000) {
				// Instruction: 7: 01111000uuuuxxxx00100iiisssstttt | Rx = add (Ru, Rx) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003000) {
				// Instruction: 7: 01111000uuuuxxxx00110000ssssiiii | Rx = add (Ru, Rx) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003100) {
				// Instruction: 7: 01111000uuuuxxxx00110001ssssiiii | Rx = add (Ru, Rx) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RU__RX____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (%s, Rx) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x60003c00) {
				// Instruction: 7: 01100IIIIIIIxxxx0011110iiiii---- | Rx = add (Rx, #S7) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x60003200) {
				// Instruction: 7: 01100IIIIIIIxxxx00110010ssssiiii | Rx = add (Rx, #S7) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x60003300) {
				// Instruction: 7: 01100IIIIIIIxxxx00110011ssssiiii | Rx = add (Rx, #S7) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x60002a00) {
				// Instruction: 7: 01100IIIIIIIxxxx0010101iiiiiittt | Rx = add (Rx, #S7) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f800) == 0x60002000) {
				// Instruction: 7: 01100IIIIIIIxxxx00100iiisssstttt | Rx = add (Rx, #S7) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x60003000) {
				// Instruction: 7: 01100IIIIIIIxxxx00110000ssssiiii | Rx = add (Rx, #S7) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800ff00) == 0x60003100) {
				// Instruction: 7: 01100IIIIIIIxxxx00110001ssssiiii | Rx = add (Rx, #S7) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf800fe00) == 0x60002800) {
				// Instruction: 7: 01100IIIIIIIxxxx0010100iiiiitttt | Rx = add (Rx, #S7) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX___S7____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x7f00000) >> 20);
				if (hi->ops[1].op.imm & (1 << 6)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 6);
				}
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				hex_op_extend(&hi->ops[1]);
				sprintf(hi->mnem, "%s = add (Rx, %d) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78003c00) {
				// Instruction: 7: 01111000ssssxxxx0011110iiiii---- | Rx = add (Rx, Rs) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78002a00) {
				// Instruction: 7: 01111000ssssxxxx0010101iiiiiittt | Rx = add (Rx, Rs) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x78002800) {
				// Instruction: 7: 01111000ssssxxxx0010100iiiiitttt | Rx = add (Rx, Rs) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RS____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003200) {
				// Instruction: 7: 01111000uuuuxxxx00110010ssssiiii | Rx = add (Rx, Ru) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003300) {
				// Instruction: 7: 01111000uuuuxxxx00110011ssssiiii | Rx = add (Rx, Ru) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x78002000) {
				// Instruction: 7: 01111000uuuuxxxx00100iiisssstttt | Rx = add (Rx, Ru) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003000) {
				// Instruction: 7: 01111000uuuuxxxx00110000ssssiiii | Rx = add (Rx, Ru) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x78003100) {
				// Instruction: 7: 01111000uuuuxxxx00110001ssssiiii | Rx = add (Rx, Ru) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RX___ADD__RX__RU____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rx
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = add (Rx, %s) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a703c00) {
				// Instruction: 7: 0111101--111dddd0011110iiiii---- | if (! p0) Rd = #0 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___ALLOCFRAME___U5_3_;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a703200) {
				// Instruction: 7: 0111101--111dddd00110010ssssiiii | if (! p0) Rd = #0 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMB__RS____U4_0_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a703300) {
				// Instruction: 7: 0111101--111dddd00110011ssssiiii | if (! p0) Rd = #0 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMB__RS____U4_0_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a702a00) {
				// Instruction: 7: 0111101--111dddd0010101iiiiiittt | if (! p0) Rd = #0 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMD__SP____S6_3____RTT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[1].op.imm & (1 << 8)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x7a702000) {
				// Instruction: 7: 0111101--111dddd00100iiisssstttt | if (! p0) Rd = #0 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMH__RS____U3_1____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a703000) {
				// Instruction: 7: 0111101--111dddd00110000ssssiiii | if (! p0) Rd = #0 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMW__RS____U4_2_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a703100) {
				// Instruction: 7: 0111101--111dddd00110001ssssiiii | if (! p0) Rd = #0 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMW__RS____U4_2_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a702800) {
				// Instruction: 7: 0111101--111dddd0010100iiiiitttt | if (! p0) Rd = #0 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0__RD____0___MEMW__SP____U5_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0) %s = #0 ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a503c00) {
				// Instruction: 7: 0111101--101dddd0011110iiiii---- | if (! p0.new) Rd = #0 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___ALLOCFRAME___U5_3_;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a503200) {
				// Instruction: 7: 0111101--101dddd00110010ssssiiii | if (! p0.new) Rd = #0 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMB__RS____U4_0_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a503300) {
				// Instruction: 7: 0111101--101dddd00110011ssssiiii | if (! p0.new) Rd = #0 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMB__RS____U4_0_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a502a00) {
				// Instruction: 7: 0111101--101dddd0010101iiiiiittt | if (! p0.new) Rd = #0 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMD__SP____S6_3____RTT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[1].op.imm & (1 << 8)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x7a502000) {
				// Instruction: 7: 0111101--101dddd00100iiisssstttt | if (! p0.new) Rd = #0 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMH__RS____U3_1____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a503000) {
				// Instruction: 7: 0111101--101dddd00110000ssssiiii | if (! p0.new) Rd = #0 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMW__RS____U4_2_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a503100) {
				// Instruction: 7: 0111101--101dddd00110001ssssiiii | if (! p0.new) Rd = #0 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMW__RS____U4_2_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a502800) {
				// Instruction: 7: 0111101--101dddd0010100iiiiitttt | if (! p0.new) Rd = #0 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF___NOT__P0_NEW__RD____0___MEMW__SP____U5_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (! p0.new) %s = #0 ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a603c00) {
				// Instruction: 7: 0111101--110dddd0011110iiiii---- | if (p0) Rd = #0 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___ALLOCFRAME___U5_3_;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a603200) {
				// Instruction: 7: 0111101--110dddd00110010ssssiiii | if (p0) Rd = #0 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMB__RS____U4_0_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a603300) {
				// Instruction: 7: 0111101--110dddd00110011ssssiiii | if (p0) Rd = #0 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMB__RS____U4_0_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a602a00) {
				// Instruction: 7: 0111101--110dddd0010101iiiiiittt | if (p0) Rd = #0 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMD__SP____S6_3____RTT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[1].op.imm & (1 << 8)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x7a602000) {
				// Instruction: 7: 0111101--110dddd00100iiisssstttt | if (p0) Rd = #0 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMH__RS____U3_1____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a603000) {
				// Instruction: 7: 0111101--110dddd00110000ssssiiii | if (p0) Rd = #0 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMW__RS____U4_2_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a603100) {
				// Instruction: 7: 0111101--110dddd00110001ssssiiii | if (p0) Rd = #0 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMW__RS____U4_2_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a602800) {
				// Instruction: 7: 0111101--110dddd0010100iiiiitttt | if (p0) Rd = #0 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0__RD____0___MEMW__SP____U5_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0) %s = #0 ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a403c00) {
				// Instruction: 7: 0111101--100dddd0011110iiiii---- | if (p0.new) Rd = #0 ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___ALLOCFRAME___U5_3_;
				hi->op_count = 2;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a403200) {
				// Instruction: 7: 0111101--100dddd00110010ssssiiii | if (p0.new) Rd = #0 ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMB__RS____U4_0_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a403300) {
				// Instruction: 7: 0111101--100dddd00110011ssssiiii | if (p0.new) Rd = #0 ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMB__RS____U4_0_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a402a00) {
				// Instruction: 7: 0111101--100dddd0010101iiiiiittt | if (p0.new) Rd = #0 ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMD__SP____S6_3____RTT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[1].op.imm & (1 << 8)) {
					hi->ops[1].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].attr |= HEX_OP_REG_PAIR;
				hi->ops[2].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), (st32)hi->ops[1].op.imm, hex_get_sub_regpair(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70f800) == 0x7a402000) {
				// Instruction: 7: 0111101--100dddd00100iiisssstttt | if (p0.new) Rd = #0 ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMH__RS____U3_1____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a403000) {
				// Instruction: 7: 0111101--100dddd00110000ssssiiii | if (p0.new) Rd = #0 ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMW__RS____U4_2_____0;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70ff00) == 0x7a403100) {
				// Instruction: 7: 0111101--100dddd00110001ssssiiii | if (p0.new) Rd = #0 ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMW__RS____U4_2_____1;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xfe70fe00) == 0x7a402800) {
				// Instruction: 7: 0111101--100dddd0010100iiiiitttt | if (p0.new) Rd = #0 ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_IF__P0_NEW__RD____0___MEMW__SP____U5_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "if (p0.new) %s = #0 ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x79003c00) {
				// Instruction: 7: 01111001ssss--II0011110iiiii---- | p0 = cmp.eq (Rs, #U2) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____ALLOCFRAME___U5_3_;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x79002a00) {
				// Instruction: 7: 01111001ssss--II0010101iiiiiittt | p0 = cmp.eq (Rs, #U2) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____MEMD__SP____S6_3____RTT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[2].op.imm & (1 << 8)) {
					hi->ops[2].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].attr |= HEX_OP_REG_PAIR;
				hi->ops[3].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, (st32)hi->ops[2].op.imm, hex_get_sub_regpair(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00fe00) == 0x79002800) {
				// Instruction: 7: 01111001ssss--II0010100iiiiitttt | p0 = cmp.eq (Rs, #U2) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RS___U2____MEMW__SP____U5_2____RT;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x79003200) {
				// Instruction: 7: 01111001uuuu--II00110010ssssiiii | p0 = cmp.eq (Ru, #U2) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMB__RS____U4_0_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x79003300) {
				// Instruction: 7: 01111001uuuu--II00110011ssssiiii | p0 = cmp.eq (Ru, #U2) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMB__RS____U4_0_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00f800) == 0x79002000) {
				// Instruction: 7: 01111001uuuu--II00100iiisssstttt | p0 = cmp.eq (Ru, #U2) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMH__RS____U3_1____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x79003000) {
				// Instruction: 7: 01111001uuuu--II00110000ssssiiii | p0 = cmp.eq (Ru, #U2) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMW__RS____U4_2_____0;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xff00ff00) == 0x79003100) {
				// Instruction: 7: 01111001uuuu--II00110001ssssiiii | p0 = cmp.eq (Ru, #U2) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_P0___CMP_EQ__RU___U2____MEMW__RS____U4_2_____1;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x30000) >> 16);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "p0 = cmp.eq (%s, 0x%x) ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			break;
		}
		case 0x8: {
			if ((hi_u32 & 0xf000f000) == 0x90001000) {
				// Instruction: 8: 1001IIIIuuuudddd0001iiiisssstttt | Rd = memub (Ru + #U4:0) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0x90000000) {
				// Instruction: 8: 1001IIIIuuuudddd0000iiiisssstttt | Rd = memub (Ru + #U4:0) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0x80001000) {
				// Instruction: 8: 1000IIIIuuuudddd0001iiiisssstttt | Rd = memw (Ru + #U4:2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RU____U4_2____MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0x80000000) {
				// Instruction: 8: 1000IIIIuuuudddd0000iiiisssstttt | Rd = memw (Ru + #U4:2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__RU____U4_2____MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (%s + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			break;
		}
		case 0x9: {
			if ((hi_u32 & 0xf800f000) == 0x90003000) {
				// Instruction: 9: 10010IIIuuuudddd0011iiiisssstttt | Rd = memb (Ru + #U3:0) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RU____U3_0____MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x90002000) {
				// Instruction: 9: 10010IIIuuuudddd0010iiiisssstttt | Rd = memb (Ru + #U3:0) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMB__RU____U3_0____MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memb (%s + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x80003000) {
				// Instruction: 9: 10000IIIuuuudddd0011iiiisssstttt | Rd = memh (Ru + #U3:1) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RU____U3_1____MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x80002000) {
				// Instruction: 9: 10000IIIuuuudddd0010iiiisssstttt | Rd = memh (Ru + #U3:1) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMH__RU____U3_1____MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memh (%s + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x88003000) {
				// Instruction: 9: 10001IIIuuuudddd0011iiiisssstttt | Rd = memuh (Ru + #U3:1) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RU____U3_1____MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf800f000) == 0x88002000) {
				// Instruction: 9: 10001IIIuuuudddd0010iiiisssstttt | Rd = memuh (Ru + #U3:1) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUH__RU____U3_1____MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0x7000000) >> 24) << 1; // scaled
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memuh (%s + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe00f000) == 0x9c003000) {
				// Instruction: 9: 1001110IIIIIdddd0011iiiisssstttt | Rd = memw (Sp + #U5:2) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xfe00f000) == 0x9c002000) {
				// Instruction: 9: 1001110IIIIIdddd0010iiiisssstttt | Rd = memw (Sp + #U5:2) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMW__SP____U5_2____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0x1f00000) >> 20) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memw (Sp + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x9e003000) {
				// Instruction: 9: 10011110IIIIIddd0011iiiisssstttt | Rdd = memd (Sp + #U5:3) ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____MEMB__RS____U4_0____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; memb (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xff00f000) == 0x9e002000) {
				// Instruction: 9: 10011110IIIIIddd0010iiiisssstttt | Rdd = memd (Sp + #U5:3) ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RDD___MEMD__SP____U5_3____MEMW__RS____U4_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].attr |= HEX_OP_REG_PAIR;
				hi->ops[0].op.reg = (((hi_u32)&0x70000) >> 16);
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf80000) >> 19) << 3; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memd (Sp + 0x%x) ; memw (%s + 0x%x) = %s", hex_get_sub_regpair(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xffc4f000) == 0x9f003000) {
				// Instruction: 9: 1001111100---0--0011iiiisssstttt | deallocframe ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___MEMB__RS____U4_0____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			if ((hi_u32 & 0xffc4f000) == 0x9f002000) {
				// Instruction: 9: 1001111100---0--0010iiiisssstttt | deallocframe ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_DEALLOCFRAME___MEMW__RS____U4_2____RT;
				hi->op_count = 3;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "deallocframe ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg));
				break;
			}
			break;
		}
		case 0xa: {
			if ((hi_u32 & 0xf000f000) == 0xb0001000) {
				// Instruction: 10: 1011IIIIuuuuvvvv0001iiiisssstttt | memb (Ru + #U4:0) = Rv ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RV___MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0xb0000000) {
				// Instruction: 10: 1011IIIIuuuuvvvv0000iiiisssstttt | memb (Ru + #U4:0) = Rv ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RV___MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0xa0001000) {
				// Instruction: 10: 1010IIIIuuuuvvvv0001iiiisssstttt | memw (Ru + #U4:2) = Rv ; memb (Rs + #u4:0) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RV___MEMB__RS____U4_0____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8);
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memb (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000f000) == 0xa0000000) {
				// Instruction: 10: 1010IIIIuuuuvvvv0000iiiisssstttt | memw (Ru + #U4:2) = Rv ; memw (Rs + #u4:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RV___MEMW__RS____U4_2____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf00) >> 8) << 2; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memw (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			break;
		}
		case 0xb: {
			if ((hi_u32 & 0xf000fe00) == 0xb0003c00) {
				// Instruction: 11: 1011IIIIsssstttt0011110iiiii---- | memb (Rs + #U4:0) = Rt ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_MEMB__RS____U4_0____RT___ALLOCFRAME___U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xb0002a00) {
				// Instruction: 11: 1011IIIIssssvvvv0010101iiiiiittt | memb (Rs + #U4:0) = Rv ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_MEMB__RS____U4_0____RV___MEMD__SP____S6_3____RTT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[3].op.imm & (1 << 8)) {
					hi->ops[3].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].attr |= HEX_OP_REG_PAIR;
				hi->ops[4].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), (st32)hi->ops[3].op.imm, hex_get_sub_regpair(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xb0002800) {
				// Instruction: 11: 1011IIIIssssvvvv0010100iiiiitttt | memb (Rs + #U4:0) = Rv ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMB__RS____U4_0____RV___MEMW__SP____U5_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xb0003200) {
				// Instruction: 11: 1011IIIIuuuutttt00110010ssssiiii | memb (Ru + #U4:0) = Rt ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RT___MEMB__RS____U4_0_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xb0003300) {
				// Instruction: 11: 1011IIIIuuuutttt00110011ssssiiii | memb (Ru + #U4:0) = Rt ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RT___MEMB__RS____U4_0_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xb0003000) {
				// Instruction: 11: 1011IIIIuuuutttt00110000ssssiiii | memb (Ru + #U4:0) = Rt ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RT___MEMW__RS____U4_2_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xb0003100) {
				// Instruction: 11: 1011IIIIuuuutttt00110001ssssiiii | memb (Ru + #U4:0) = Rt ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RT___MEMW__RS____U4_2_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0xb0002000) {
				// Instruction: 11: 1011IIIIuuuuvvvv00100iiisssstttt | memb (Ru + #U4:0) = Rv ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMB__RU____U4_0____RV___MEMH__RS____U3_1____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memb (%s + 0x%x) = %s ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xa0003c00) {
				// Instruction: 11: 1010IIIIsssstttt0011110iiiii---- | memw (Rs + #U4:2) = Rt ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_MEMW__RS____U4_2____RT___ALLOCFRAME___U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xa0002a00) {
				// Instruction: 11: 1010IIIIssssvvvv0010101iiiiiittt | memw (Rs + #U4:2) = Rv ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_MEMW__RS____U4_2____RV___MEMD__SP____S6_3____RTT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[3].op.imm & (1 << 8)) {
					hi->ops[3].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].attr |= HEX_OP_REG_PAIR;
				hi->ops[4].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), (st32)hi->ops[3].op.imm, hex_get_sub_regpair(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xa0002800) {
				// Instruction: 11: 1010IIIIssssvvvv0010100iiiiitttt | memw (Rs + #U4:2) = Rv ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMW__RS____U4_2____RV___MEMW__SP____U5_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xa0003200) {
				// Instruction: 11: 1010IIIIuuuutttt00110010ssssiiii | memw (Ru + #U4:2) = Rt ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RT___MEMB__RS____U4_0_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xa0003300) {
				// Instruction: 11: 1010IIIIuuuutttt00110011ssssiiii | memw (Ru + #U4:2) = Rt ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RT___MEMB__RS____U4_0_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xa0003000) {
				// Instruction: 11: 1010IIIIuuuutttt00110000ssssiiii | memw (Ru + #U4:2) = Rt ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RT___MEMW__RS____U4_2_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xa0003100) {
				// Instruction: 11: 1010IIIIuuuutttt00110001ssssiiii | memw (Ru + #U4:2) = Rt ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RT___MEMW__RS____U4_2_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rt
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memw (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0xa0002000) {
				// Instruction: 11: 1010IIIIuuuuvvvv00100iiisssstttt | memw (Ru + #U4:2) = Rv ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_MEMW__RU____U4_2____RV___MEMH__RS____U3_1____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[1].type = HEX_OP_TYPE_IMM;
				hi->ops[1].op.imm = (((hi_u32)&0xf000000) >> 24) << 2; // scaled
				hi->ops[2].type = HEX_OP_TYPE_REG;
				hi->ops[2].op.reg = (((hi_u32)&0xf0000) >> 16); // Rv
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "memw (%s + 0x%x) = %s ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hi->ops[1].op.imm, hex_get_sub_reg(hi->ops[2].op.reg), hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			break;
		}
		case 0xc: {
			if ((hi_u32 & 0xf000fe00) == 0xd0001c00) {
				// Instruction: 12: 1101IIIIssssdddd0001110iiiii---- | Rd = memub (Rs + #U4:0) ; allocframe (#u5:3)
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____ALLOCFRAME___U5_3_;
				hi->op_count = 4;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 3; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; allocframe (0x%x)", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hi->ops[3].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xd0000a00) {
				// Instruction: 12: 1101IIIIssssdddd0000101iiiiiittt | Rd = memub (Rs + #U4:0) ; memd (Sp + #s6:3) = Rtt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____MEMD__SP____S6_3____RTT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f8) >> 3) << 3; // scaled
				if (hi->ops[3].op.imm & (1 << 8)) {
					hi->ops[3].op.imm |= (0xFFFFFFFF << 8);
				}
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].attr |= HEX_OP_REG_PAIR;
				hi->ops[4].op.reg = (((hi_u32)&0x7) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memd (Sp + %d) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, (st32)hi->ops[3].op.imm, hex_get_sub_regpair(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000fe00) == 0xd0000800) {
				// Instruction: 12: 1101IIIIssssdddd0000100iiiiitttt | Rd = memub (Rs + #U4:0) ; memw (Sp + #u5:2) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RS____U4_0____MEMW__SP____U5_2____RT;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Rs
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_IMM;
				hi->ops[3].op.imm = (((hi_u32)&0x1f0) >> 4) << 2; // scaled
				hi->ops[4].type = HEX_OP_TYPE_REG;
				hi->ops[4].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memw (Sp + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hi->ops[3].op.imm, hex_get_sub_reg(hi->ops[4].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xd0001200) {
				// Instruction: 12: 1101IIIIuuuudddd00010010ssssiiii | Rd = memub (Ru + #U4:0) ; memb (Rs + #u4:0) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMB__RS____U4_0_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memb (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xd0001300) {
				// Instruction: 12: 1101IIIIuuuudddd00010011ssssiiii | Rd = memub (Ru + #U4:0) ; memb (Rs + #u4:0) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMB__RS____U4_0_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0);
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memb (%s + 0x%x) = #1", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000f800) == 0xd0000000) {
				// Instruction: 12: 1101IIIIuuuudddd00000iiisssstttt | Rd = memub (Ru + #U4:0) ; memh (Rs + #u3:1) = Rt
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMH__RS____U3_1____RT;
				hi->op_count = 6;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0x700) >> 8) << 1; // scaled
				hi->ops[5].type = HEX_OP_TYPE_REG;
				hi->ops[5].op.reg = (((hi_u32)&0xf) >> 0); // Rt
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memh (%s + 0x%x) = %s", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm, hex_get_sub_reg(hi->ops[5].op.reg));
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xd0001000) {
				// Instruction: 12: 1101IIIIuuuudddd00010000ssssiiii | Rd = memub (Ru + #U4:0) ; memw (Rs + #u4:2) = #0
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMW__RS____U4_2_____0;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memw (%s + 0x%x) = #0", hex_get_sub_reg(hi->ops[0].op.reg), hex_get_sub_reg(hi->ops[1].op.reg), hi->ops[2].op.imm, hex_get_sub_reg(hi->ops[3].op.reg), hi->ops[4].op.imm);
				break;
			}
			if ((hi_u32 & 0xf000ff00) == 0xd0001100) {
				// Instruction: 12: 1101IIIIuuuudddd00010001ssssiiii | Rd = memub (Ru + #U4:0) ; memw (Rs + #u4:2) = #1
				hi->instruction = HEX_INS_DUPLEX_RD___MEMUB__RU____U4_0____MEMW__RS____U4_2_____1;
				hi->op_count = 5;
				hi->duplex = true;
				hi->ops[0].type = HEX_OP_TYPE_REG;
				hi->ops[0].op.reg = (((hi_u32)&0xf0000) >> 16); // Rd
				hi->ops[1].type = HEX_OP_TYPE_REG;
				hi->ops[1].op.reg = (((hi_u32)&0xf00000) >> 20); // Ru
				hi->ops[2].type = HEX_OP_TYPE_IMM;
				hi->ops[2].op.imm = (((hi_u32)&0xf000000) >> 24);
				hi->ops[3].type = HEX_OP_TYPE_REG;
				hi->ops[3].op.reg = (((hi_u32)&0xf0) >> 4); // Rs
				hi->ops[4].type = HEX_OP_TYPE_IMM;
				hi->ops[4].op.imm = (((hi_u32)&0xf) >> 0) << 2; // scaled
				hi->predicate = HEX_NOPRED;
				sprintf(hi->mnem, "%s = memub (%s + 0x%x) ; memw (%s + 0x%x) = #1", h