// SPDX-License-Identifier: LGPL-3.0-only
// SPDX-FileCopyrightText: 2021 Heersin <teablearcher@gmail.com>

#include "arch_54.h"

LuaOpNameList get_lua54_opnames(void) {
	LuaOpNameList list = RZ_NEWS(char *, LUA_NUM_OPCODES + 1);
	if (list == NULL) {
		eprintf("No Op Names\n");
		return NULL;
	}

	// Do not free the const string
	list[OP_MOVE] = "MOVE";
	list[OP_LOADI] = "LOADI",
	list[OP_LOADF] = "LOADF",
	list[OP_LOADK] = "LOADK",
	list[OP_LOADKX] = "LOADKX",
	list[OP_LOADFALSE] = "LOADFALSE",
	list[OP_LFALSESKIP] = "LFALSESKIP",
	list[OP_LOADTRUE] = "LOADTRUE",
	list[OP_LOADNIL] = "LOADNIL",
	list[OP_GETUPVAL] = "GETUPVAL",
	list[OP_SETUPVAL] = "SETUPVAL",
	list[OP_GETTABUP] = "GETTABUP",
	list[OP_GETTABLE] = "GETTABLE",
	list[OP_GETI] = "GETI",
	list[OP_GETFIELD] = "GETFIELD",
	list[OP_SETTABUP] = "SETTABUP",
	list[OP_SETTABLE] = "SETTABLE",
	list[OP_SETI] = "SETI",
	list[OP_SETFIELD] = "SETFIELD",
	list[OP_NEWTABLE] = "NEWTABLE",
	list[OP_SELF] = "SELF",
	list[OP_ADDI] = "ADDI",
	list[OP_ADDK] = "ADDK",
	list[OP_SUBK] = "SUBK",
	list[OP_MULK] = "MULK",
	list[OP_MODK] = "MODK",
	list[OP_POWK] = "POWK",
	list[OP_DIVK] = "DIVK",
	list[OP_IDIVK] = "IDIVK",
	list[OP_BANDK] = "BANDK",
	list[OP_BORK] = "BORK",
	list[OP_BXORK] = "BXORK",
	list[OP_SHRI] = "SHRI",
	list[OP_SHLI] = "SHLI",
	list[OP_ADD] = "ADD",
	list[OP_SUB] = "SUB",
	list[OP_MUL] = "MUL",
	list[OP_MOD] = "MOD",
	list[OP_POW] = "POW",
	list[OP_DIV] = "DIV",
	list[OP_IDIV] = "IDIV",
	list[OP_BAND] = "BAND",
	list[OP_BOR] = "BOR",
	list[OP_BXOR] = "BXOR",
	list[OP_SHL] = "SHL",
	list[OP_SHR] = "SHR",
	list[OP_MMBIN] = "MMBIN",
	list[OP_MMBINI] = "MMBINI",
	list[OP_MMBINK] = "MMBINK",
	list[OP_UNM] = "UNM",
	list[OP_BNOT] = "BNOT",
	list[OP_NOT] = "NOT",
	list[OP_LEN] = "LEN",
	list[OP_CONCAT] = "CONCAT",
	list[OP_CLOSE] = "CLOSE",
	list[OP_TBC] = "TBC",
	list[OP_JMP] = "JMP",
	list[OP_EQ] = "EQ",
	list[OP_LT] = "LT",
	list[OP_LE] = "LE",
	list[OP_EQK] = "EQK",
	list[OP_EQI] = "EQI",
	list[OP_LTI] = "LTI",
	list[OP_LEI] = "LEI",
	list[OP_GTI] = "GTI",
	list[OP_GEI] = "GEI",
	list[OP_TEST] = "TEST",
	list[OP_TESTSET] = "TESTSET",
	list[OP_CALL] = "CALL",
	list[OP_TAILCALL] = "TAILCALL",
	list[OP_RETURN] = "RETURN",
	list[OP_RETURN0] = "RETURN0",
	list[OP_RETURN1] = "RETURN1",
	list[OP_FORLOOP] = "FORLOOP",
	list[OP_FORPREP] = "FORPREP",
	list[OP_TFORPREP] = "TFORPREP",
	list[OP_TFORCALL] = "TFORCALL",
	list[OP_TFORLOOP] = "TFORLOOP",
	list[OP_SETLIST] = "SETLIST",
	list[OP_CLOSURE] = "CLOSURE",
	list[OP_VARARG] = "VARARG",
	list[OP_VARARGPREP] = "VARARGPREP",
	list[OP_EXTRAARG] = "EXTRAARG",
	list[LUA_NUM_OPCODES] = NULL;

	return list;
}