#!/usr/bin/env python
import sys

TEMPLATE = '''/*
  This file was auto-generated by Meson from zip.h
*/

#include "zipint.h"

const char * const _zip_err_str[] = {{
{zip_err_strs}
}};

const int _zip_nerr_str = sizeof(_zip_err_str)/sizeof(_zip_err_str[0]);

#define N ZIP_ET_NONE
#define S ZIP_ET_SYS
#define Z ZIP_ET_ZLIB

const int _zip_err_type[] = {{
{zip_err_types}
}};

'''

zip_err_str_c = sys.argv[1]
zip_h = sys.argv[2]

def getcomment(x):
    return x[x.index('/* ') + 3:x.index('*/')]

def def2errstr(x):
    return getcomment(x).split(' ', 1)[1]

def def2errtype(x):
    return getcomment(x).split(' ', 1)[0]

defines = [l for l in open(zip_h, 'r').read().split('\n') if l.startswith('#define ZIP_ER')]
zip_err_strs = '\n'.join(['"' + def2errstr(x) + '",' for x in defines])
zip_err_types = '\n'.join([def2errtype(x) + ',' for x in defines])

open(zip_err_str_c, 'w').write(TEMPLATE.format(zip_err_strs=zip_err_strs, zip_err_types=zip_err_types))