# Contributors

We would like to express our sincerest thanks and gratitude to everyone
that has helped with either the development of Sonic Pi or supported its
use in any capacity. On its own Sonic Pi is just a piece of
software. Only when combined with our kind and generous community does
it become a powerful tool for sharing and celebrating the creativity of
code. Thank-you everyone.


## A humble beginning

The start of any project is a fragile period which relies heavily on the
generous support of others. We would like to offer our considered
gratitude to the following people who provided support in the early days
of Sonic Pi with their time, advice, and wisdom:

* [Carrie Anne Philbin](https://twitter.com/missphilbin)
* [Robert Mullins](https://www.cl.cam.ac.uk/~rdm34/)
* [Alex Bradbury](https://twitter.com/asbradbury)
* [Alan Blackwell](https://www.cl.cam.ac.uk/~afb21/)
* [Rachel Drury](https://twitter.com/Rachel_Drury)
* [Juneau Projects](http://www.juneauprojects.co.uk)
* Stephan Lachowsky
* [Jonathan Graham](https://twitter.com/graham_jp)


## Organisations

The following organisations have kindly contributed to Sonic Pi:

* [The Raspberry Pi Foundation](https://www.raspberrypi.org)
* [The Broadcom Foundation](https://www.broadcomfoundation.org)
* [The University of Cambridge Computer Laboratory](https://www.cl.cam.ac.uk)
* [Arts Council England](http://www.artscouncil.org.uk)
* [Nesta](https://www.nesta.org.uk)
* [pi-top](https://pi-top.com)
* [Norfolk & Norwich Festival Bridge](https://nnfestival.org.uk/festival-bridge/)
* [Emute Lab at the University of Sussex](https://www.emutelab.org)
* [Trading & Consulting 'H.P.C.' GmbH](hpc.at)


## Inspiration

The following is a far from complete list of some of the individuals who
have provided inspiration for the creation of Sonic Pi through their own
projects:

* _why (why the lucky stiff) - [Shoes](https://en.wikipedia.org/wiki/Shoes_(GUI_toolkit))
* Andrew Sorensen  - [Extempore](http://extempore.moso.com.au)
* James McCartney - [SuperCollider](https://supercollider.github.io)
* Jeff Rose - [Overtone](https://overtone.github.com)
* Joe Armstrong - [Erlang](https://www.erlang.org)
* Linda Liukas - [Hello Ruby](http://www.helloruby.com/)
* Matz (Yukihiro Matsumoto まつもとゆきひろ) - [Ruby](https://www.ruby-lang.org)
* Rich Hickey - [Clojure](https://clojure.org)
* Seymour Papert - [Logo](https://en.wikipedia.org/wiki/Logo_(programming_language))
* The Scratch Team - [Scratch](https://scratch.mit.edu)
* Thor Magnusson - [ixi lang](http://www.ixi-audio.net/content/body_software_ixilang.html)


## Patreon Supporters

Sonic Pi development is increasingly funded by a growing number of very
kind and generous people via [Patreon](https://patreon.com/samaaron). We
would like to thank everyone who has supported Sonic Pi in this way -
especially the following individuals who have been remarkably generous:

* Alan Boulton
* [Alexandre Enkerli](https://twitter.com/enkerli)
* [Anderson Reinkordt](https://soundcloud.com/april-club-music)
* [André-Patrick Bubel](https://andre-bubel.de)
* [Andrew Robillard](https://www.twitter.com/hoborobo123)
* [Bartosz Majsak](https://twitter.com/majson)
* [Ben Davis](https://soundcloud.com/ben_davis_noise)
* [Benjamin Reitzammer](https://cto.coffee)
* brainTrain
* [Boris Bokowski](https://twitter.com/bokowski)
* [Brandon Weaver](https://twitter.com/keystonelemur)
* [Chih-Chun Chen](http://abmcet.net/Chih-Chun_Chen/home.html)
* [Christoffer Krakou](http://www.krakou.dk/)
* Dallas Kidd
* [Darin Wilson](https://twitter.com/darinwilson/)
* [Dean Wampler](https://twitter.com/deanwampler)
* [Emlyn Corrin](https://github.com/emlyn)
* [Evan Kroske](https://www.evankroske.com/)
* [Florian Gilcher](https://twitter.com/Argorak)
* [Gabe Jackson](https://github.com/gj)
* [James Abley](https://twitter.com/jabley)
* Jaroslav Lichtblau
* [Justin Balthrop](http://ninjudd.com)
* [Justin Worrall](https://twitter.com/juzbo)
* [Lily Foster](https://lily.flowers/)
* [Luis Espinoza](https://twitter.com/luis_espinoza)
* [Marco Rolappe](https://rolappe.it)
* [Mark Rendle](https://twitter.com/markrendle)
* [Markku Rontu](https://twitter.com/zorcam)
* [Marmaduke Woodman](https://github.com/maedoc)
* [Martin Butz](https://github.com/mbutz)
* [Martin McDermott](https://twitter.com/marv_mcd)
* [Matthew Gilliard](https://twitter.com/MaximumGilliard)
* [Michael Hunger](https://twitter.com/mesirii)
* [Nada Amin](http://namin.net)
* [NAMTAO](https://namtao.com)
* [Nathan Letwory](https://github.com/jesterKing)
* [Ole Friis Østergaard](https://github.com/olefriis)
* [Paul Williams](https://pcwilliams.design)
* [Pit Noack](http://www.maschinennah.de/)
* [Richard Buckley](https://burgundycomputing.com)
* [Robin Newman](https://twitter.com/rbnman)
* [Sam Halliday](https://github.com/fommil)
* [Sean Raser](https://twitter.com/sraser88)
* [Sébastien Rannou](https://mxs.sbrk.org/)
* [Scott Fleckenstein](http://nullstyle.com))
* [Scott Turner](https://twitter.com/scottturneruon)
* [Simon Woodman](https://twitter.com/sjwoodman)
* Terry Wisniewski
* [thattommyhall](https://twitter.com/thattommyhall)



## Outstanding Community Contributions

We would like to recognise the following individuals for their important
contributions which have supported the Sonic Pi Community:

* [Paul Winstanley](https://twitter.com/SCCMentor)
* [Robin Newman](https://twitter.com/rbnman)
* [Ethan Crawford](https://twitter.com/northwardface)


## Guidance and Advice

We would like to thank the following people for their time providing
valuable advice, feedback and suggestions on a wide variety of aspects
of Sonic Pi - from technical development, to artistic
conceptualisations, to musical production and performance.

* [Dago Sondervan](https://twitter.com/sondervan1)
* [Sam Conran](https://twitter.com/samconran)
* [Ben Smith](https://twitter.com/bensmithguitar)
* [Steve Hellier](https://twitter.com/steveguyhellier)
* [Pit Noack](https://twitter.com/maschinennah)
* [Joe Armstrong](https://twitter.com/joeerl)



## Core Team

Much of the development, distribution and support work for Sonic Pi is
carried out by the Core Team. This is a group of dedicated volunteers
(with the exception of Sam Aaron who works full time on the project) who
kindly donate their time to continue to improve Sonic Pi.

Current members:

* [Sam Aaron](https://github.com/samaaron)
* [Xavier Riley](https://github.com/xavriley)
* [Joseph Wilk](https://github.com/josephwilk)
* [Hanno Zulla](https://github.com/hzulla)
* [Adrian Cheater](https://github.com/factoid)
* [Luis Lloret](https://github.com/llloret/)
* [Robin Newman](https://github.com/rbnpi)
* [Ethan Crawford](https://github.com/ethancrawford)
* [Chris Maughan](https://github.com/cmaughan)


Previous members:

* [Jeremy Weatherford](https://github.com/jweather)



## Core Team Thanks

Sam Aaron would like to express his deep thanks to his family and
friends who have supported him over the years and given him the strength
to continue on this strange and often unforgiving path. He would
particularly like to thank his friend and partner Susanna and also his
fab Mum.

Luis Lloret wants to thank his wonderful family for their understanding
and support while working on this. Specially Marina, you are my reason
to live. Mar and Darío, keep being so special and giving us so much joy.

Xavier Riley would like to thank his wife Emily, and he'd like to
reassure her that he definitely loves her more than any computer. Also
big thanks to conference organizers, in particular Simon Starr for
putting on the awesome Bath Ruby conferences and letting me rock out
there not [once](https://youtu.be/Jp0VKD_7pmw?t=10m1s), but
[twice](https://www.youtube.com/watch?v=L06FlSoiBi4). Lastly I'd like to
thank Scott Wilson for teaching me some programming as part of a music
degree, and my good friend David Bamber for helping me get started as a
programmer.

Adrian Cheater dedicates this space in loving memory of her mother,
Katherine Cheater. Mom shared her passion for music and performance
and equipped me with all the tools I needed to live life fully. She was
kind, but did not let the opinions of strangers deter her from her path.
Though mom never met me as her daughter, I know she would have been proud
that I chose to embrace my truth as it became known to me.
My wish is that you, fellow musician, will also choose to never dampen your
light, and that you will encourage and empower others to shine bright.

Robin Newman would like to thank Sam for producing such inspirational
software as Sonic Pi. Both the sounds that it can produce and the
intricate programming beneath the surface are a work of art. To work
with Sonic Pi gives me such a buzz as I have not experienced since
working with Music on a network of BBC Micros in the 1980s. Then as now
my Wife Julia describes herself as a computer widow. I thank her for
putting up with my passion for musical programming over the years.

Ethan Crawford is grateful to his parents for giving him the opportunity
of music lessons as a young boy, and all the skills and interests that
this helped to develop. He'd also like to thank Sam for creating Sonic
Pi and the ease and fun with which it combines two of his favourite
interests - music and programming.



## Developer Contributions

In addition to the Sonic Pi Core Team, we would like to extend our
thanks to the following developers who have donated their time and
effort to help grow and improve the Sonic Pi code base:

* [Sam Aaron](https://github.com/samaaron/sonic-pi/commits?author=samaaron) (5565)
* [Ethan Crawford](https://github.com/samaaron/sonic-pi/commits?author=ethancrawford) (262)
* [Joseph Wilk](https://github.com/samaaron/sonic-pi/commits?author=josephwilk) (160)
* [Hanno Zulla](https://github.com/samaaron/sonic-pi/commits?author=hzulla) (127)
* [Jeremy Weatherford](https://github.com/samaaron/sonic-pi/commits?author=jweather) (127)
* [Xavier Riley](https://github.com/samaaron/sonic-pi/commits?author=xavriley) (106)
* [Adrian Cheater](https://github.com/samaaron/sonic-pi/commits?author=factoid) (74)
* [Robin Newman](https://github.com/samaaron/sonic-pi/commits?author=rbnpi) (68)
* [Emlyn Corrin](https://github.com/samaaron/sonic-pi/commits?author=emlyn) (62)
* [SunderB](https://github.com/samaaron/sonic-pi/commits?author=SunderB) (56)
* [Martin Keegan](https://github.com/samaaron/sonic-pi/commits?author=mk270) (48)
* [Chris Maughan](https://github.com/samaaron/sonic-pi/commits?author=cmaughan) (46)
* [Luis Lloret](https://github.com/samaaron/sonic-pi/commits?author=llloret) (39)
* [Nicolas Dermine](https://github.com/samaaron/sonic-pi/commits?author=nicoder) (37)
* [Nikolaus Gradwohl](https://github.com/samaaron/sonic-pi/commits?author=ngradwohl) (30)
* [Richard Carlsson](https://github.com/samaaron/sonic-pi/commits?author=richcarl) (20)
* [Joseph Burnett](https://github.com/samaaron/sonic-pi/commits?author=josephburnett) (15)
* [Richard Bullington-McGuire](https://github.com/samaaron/sonic-pi/commits?author=obscurerichard) (15)
* [Łukasz Siwiński](https://github.com/samaaron/sonic-pi/commits?author=hopbit) (13)
* [Mikael Karlsson](https://github.com/samaaron/sonic-pi/commits?author=karlsson) (8)
* [Clare Macrae](https://github.com/samaaron/sonic-pi/commits?author=claremacrae) (7)
* [Jeroen Castelein](https://github.com/samaaron/sonic-pi/commits?author=JeroennC) (6)
* [Kenichi Kanai](https://github.com/samaaron/sonic-pi/commits?author=kn1kn1) (6)
* [Rob McKinnon](https://github.com/samaaron/sonic-pi/commits?author=robmckinnon) (6)
* [Christoph Scholtes](https://github.com/samaaron/sonic-pi/commits?author=cschol) (5)
* [Enrike Hurtado](https://github.com/samaaron/sonic-pi/commits?author=enrike) (5)
* [Martin van Es](https://github.com/samaaron/sonic-pi/commits?author=mrvanes) (5)
* [Andrii Kurdiumov](https://github.com/samaaron/sonic-pi/commits?author=kant2002) (4)
* [Antonio Bonifacio](https://github.com/samaaron/sonic-pi/commits?author=neuromancer85) (4)
* [Anmol Gautam](https://github.com/samaaron/sonic-pi/commits?author=Tarptaeya) (3)
* [Brock Wilcox](https://github.com/samaaron/sonic-pi/commits?author=awwaiid) (3)
* [Chris Ford](https://github.com/samaaron/sonic-pi/commits?author=ctford) (3)
* [Edward Andrews-Hodgson](https://github.com/samaaron/sonic-pi/commits?author=aldreth) (3)
* [Katie Ots](https://github.com/samaaron/sonic-pi/commits?author=katiejots) (3)
* [Mariano Guerra](https://github.com/samaaron/sonic-pi/commits?author=marianoguerra) (3)
* [Mark Paton](https://github.com/samaaron/sonic-pi/commits?author=frobby) (3)
* [Petter Reinholdtsen](https://github.com/samaaron/sonic-pi/commits?author=petterreinholdtsen) (3)
* [Sebastien Rannou](https://github.com/samaaron/sonic-pi/commits?author=aimxhaisse) (3)
* [Steve Traylen](https://github.com/samaaron/sonic-pi/commits?author=traylenator) (3)
* [Tobias Thüring](https://github.com/samaaron/sonic-pi/commits?author=hexagon6) (3)
* [Ben Nuttall](https://github.com/samaaron/sonic-pi/commits?author=bennuttall) (2)
* [Bruce Adams](https://github.com/samaaron/sonic-pi/commits?author=bruceadams) (2)
* [Daniel Canelhas](https://github.com/samaaron/sonic-pi/commits?author=dcanelhas) (2)
* [Daria Trainor](https://github.com/samaaron/sonic-pi/commits?author=dariatrainor) (2)
* [Domingo Gómez](https://github.com/samaaron/sonic-pi/commits?author=domgomcom) (2)
* [Franz Laügt](https://github.com/samaaron/sonic-pi/commits?author=znarf94) (2)
* [Friends A.](https://github.com/samaaron/sonic-pi/commits?author=shaonianche) (2)
* [Hubert Figuière](https://github.com/samaaron/sonic-pi/commits?author=hfiguiere) (2)
* [Joe Francis](https://github.com/samaaron/sonic-pi/commits?author=lostapathy) (2)
* [Louis Pilfold](https://github.com/samaaron/sonic-pi/commits?author=lpil) (2)
* [Matt Ruzicka](https://github.com/samaaron/sonic-pi/commits?author=mattruzicka) (2)
* [Michael Henry](https://github.com/samaaron/sonic-pi/commits?author=neoCrimeLabs) (2)
* [Mintesno Zewdu](https://github.com/samaaron/sonic-pi/commits?author=MinteZ) (2)
* [Mistral Contrastin](https://github.com/samaaron/sonic-pi/commits?author=madgen) (2)
* [Phil Hagelberg](https://github.com/samaaron/sonic-pi/commits?author=technomancy) (2)
* [Přemek Vyhnal](https://github.com/samaaron/sonic-pi/commits?author=premek) (2)
* [Scott Kitterman](https://github.com/samaaron/sonic-pi/commits?author=kitterma) (2)
* [Will Stephenson](https://github.com/samaaron/sonic-pi/commits?author=wstephenson) (2)
* [William W. Wu](https://github.com/samaaron/sonic-pi/commits?author=willy-vvu) (2)
* [Adlai](https://github.com/samaaron/sonic-pi/commits?author=adlai) (1)
* [Alex McLean](https://github.com/samaaron/sonic-pi/commits?author=yaxu) (1)
* [Aspasia Beneti](https://github.com/samaaron/sonic-pi/commits?author=aspasia) (1)
* [Bernhard M. Wiedemann](https://github.com/samaaron/sonic-pi/commits?author=bmwiedemann) (1)
* [Björn Ekström](https://github.com/samaaron/sonic-pi/commits?author=bjornekstrom) (1)
* [Björn Þór Jónsson](https://github.com/samaaron/sonic-pi/commits?author=bthj) (1)
* [Brian Hagerty](https://github.com/samaaron/sonic-pi/commits?author=bhagerty) (1)
* [Brujo Rojas](https://github.com/samaaron/sonic-pi/commits?author=brujo-rojas) (1)
* [Centre multimédia des Pieux](https://github.com/samaaron/sonic-pi/commits?author=epnlespieux) (1)
* [Christian Perfect](https://github.com/samaaron/sonic-pi/commits?author=christianp) (1)
* [Christoph B. Wurzinger](https://github.com/samaaron/sonic-pi/commits?author=chbw) (1)
* [Cosmin Stroe](https://github.com/samaaron/sonic-pi/commits?author=cstroe) (1)
* [Dionysis Zindros](https://github.com/samaaron/sonic-pi/commits?author=dionyziz) (1)
* [Dominic Calkosz](https://github.com/samaaron/sonic-pi/commits?author=Dmcdominic) (1)
* [Drew A. Moore](https://github.com/samaaron/sonic-pi/commits?author=moore-drew) (1)
* [Eric M](https://github.com/samaaron/sonic-pi/commits?author=em13914) (1)
* [Eugene Kovalev](https://github.com/samaaron/sonic-pi/commits?author=wl8dr3) (1)
* [Falko Spiller](https://github.com/samaaron/sonic-pi/commits?author=zenon) (1)
* [Garen Hartunian](https://github.com/samaaron/sonic-pi/commits?author=garenhart) (1)
* [Graham Taylor](https://github.com/samaaron/sonic-pi/commits?author=vinnievg) (1)
* [Gábor Hermann](https://github.com/samaaron/sonic-pi/commits?author=gaborhermann) (1)
* [Ian Stevenson](https://github.com/samaaron/sonic-pi/commits?author=irstevenson) (1)
* [Ivan Zarea](https://github.com/samaaron/sonic-pi/commits?author=minivan) (1)
* [James Smith](https://github.com/samaaron/sonic-pi/commits?author=nanomancer) (1)
* [James Watson](https://github.com/samaaron/sonic-pi/commits?author=jawatson) (1)
* [Jamie Brandon](https://github.com/samaaron/sonic-pi/commits?author=jamii) (1)
* [Jean-Baptiste Mestelan](https://github.com/samaaron/sonic-pi/commits?author=Mestelan) (1)
* [Jesper Hasselquist](https://github.com/samaaron/sonic-pi/commits?author=Joxtacy) (1)
* [Joe Armstrong](https://github.com/samaaron/sonic-pi/commits?author=joearms) (1)
* [John Lawrence Aspden](https://github.com/samaaron/sonic-pi/commits?author=johnlawrenceaspden) (1)
* [Jose Añasco](https://github.com/samaaron/sonic-pi/commits?author=merongivian) (1)
* [Joseph Haig](https://github.com/samaaron/sonic-pi/commits?author=jrmhaig) (1)
* [Josh Hatcher](https://github.com/samaaron/sonic-pi/commits?author=jbjbhatcher) (1)
* [Julian Cheal](https://github.com/samaaron/sonic-pi/commits?author=juliancheal) (1)
* [Karl Hiner](https://github.com/samaaron/sonic-pi/commits?author=khiner) (1)
* [Kenan Erdogan](https://github.com/samaaron/sonic-pi/commits?author=bitnik) (1)
* [Kevin Chau](https://github.com/samaaron/sonic-pi/commits?author=kevinchau321) (1)
* [Kıvanç Güçkıran](https://github.com/samaaron/sonic-pi/commits?author=kivancguckiran) (1)
* [Lin Hsu](https://github.com/samaaron/sonic-pi/commits?author=chaosink) (1)
* [Linda van der Pal](https://github.com/samaaron/sonic-pi/commits?author=lvdpal) (1)
* [Lorenzo Moriondo](https://github.com/samaaron/sonic-pi/commits?author=Mec-iS) (1)
* [Manula Thejan](https://github.com/samaaron/sonic-pi/commits?author=manula2004) (1)
* [Marko Peltola](https://github.com/samaaron/sonic-pi/commits?author=markopeltola) (1)
* [Martin Gondermann](https://github.com/samaaron/sonic-pi/commits?author=) (1)
* [Matt Meyer](https://github.com/samaaron/sonic-pi/commits?author=mmeyer0505) (1)
* [Matthew Gilliard](https://github.com/samaaron/sonic-pi/commits?author=mjg123) (1)
* [Matthew Pagan](https://github.com/samaaron/sonic-pi/commits?author=mttpgn) (1)
* [Max Rabin](https://github.com/samaaron/sonic-pi/commits?author=maxrabin) (1)
* [Michał Lewandowski](https://github.com/samaaron/sonic-pi/commits?author=mlevvy) (1)
* [Michel Kraaijeveld](https://github.com/samaaron/sonic-pi/commits?author=LandDragoon) (1)
* [Morgan Owens](https://github.com/samaaron/sonic-pi/commits?author=equiamos) (1)
* [Neal McBurnett](https://github.com/samaaron/sonic-pi/commits?author=nealmcb) (1)
* [Nigel Michki](https://github.com/samaaron/sonic-pi/commits?author=nigeil) (1)
* [No Name Pro](https://github.com/samaaron/sonic-pi/commits?author=NoNamePro0) (1)
* [Paul Winstanley](https://github.com/samaaron/sonic-pi/commits?author=sccmentor) (1)
* [Peter Shultz](https://github.com/samaaron/sonic-pi/commits?author=pashultz) (1)
* [Pierre De Wilde](https://github.com/samaaron/sonic-pi/commits?author=pierredewilde) (1)
* [Piotr Jagielski](https://github.com/samaaron/sonic-pi/commits?author=pjagielski) (1)
* [Přemek Vyhnal](https://github.com/samaaron/sonic-pi/commits?author=premek) (1)
* [Radu Raicea](https://github.com/samaaron/sonic-pi/commits?author=Radu-Raicea) (1)
* [Reuben Brown](https://github.com/samaaron/sonic-pi/commits?author=reubenbrown) (1)
* [Ricardo Ramírez](https://github.com/samaaron/sonic-pi/commits?author=ricardoerl) (1)
* [Roland Schmid](https://github.com/samaaron/sonic-pi/commits?author=Pr0gm4n) (1)
* [Roman Milovskiy](https://github.com/samaaron/sonic-pi/commits?author=dcromster) (1)
* [Russell Jones](https://github.com/samaaron/sonic-pi/commits?author=Russell-Jones) (1)
* [Ruzsa Balázs](https://github.com/samaaron/sonic-pi/commits?author=cellux) (1)
* [Ryan Bigg](https://github.com/samaaron/sonic-pi/commits?author=radar) (1)
* [Rúben Ribeiro Franco](https://github.com/samaaron/sonic-pi/commits?author=RRFGamer) (1)
* [Sam Conran](https://github.com/samaaron/sonic-pi/commits?author=samOrbs) (1)
* [Sandy Maguire](https://github.com/samaaron/sonic-pi/commits?author=isovector) (1)
* [Sebastian Stahn](https://github.com/samaaron/sonic-pi/commits?author=stahnirockt) (1)
* [Siim Põder](https://github.com/samaaron/sonic-pi/commits?author=windo) (1)
* [Takashi Udagawa](https://github.com/samaaron/sonic-pi/commits?author=udayan28) (1)
* [Thibaut Barrère](https://github.com/samaaron/sonic-pi/commits?author=thbar) (1)
* [Thomas Starzynski](https://github.com/samaaron/sonic-pi/commits?author=dcts) (1)
* [Tom Holford](https://github.com/samaaron/sonic-pi/commits?author=tomholford) (1)
* [Tom den Braber](https://github.com/samaaron/sonic-pi/commits?author=tomdenbraber) (1)
* [Tomek Rabczak](https://github.com/samaaron/sonic-pi/commits?author=tomekr) (1)
* [Tommi Toivonen](https://github.com/samaaron/sonic-pi/commits?author=hullum) (1)
* [Tristram Oaten](https://github.com/samaaron/sonic-pi/commits?author=0atman) (1)
* [Tyler Korthal](https://github.com/samaaron/sonic-pi/commits?author=tjkorthal) (1)
* [Uriel Corfa](https://github.com/samaaron/sonic-pi/commits?author=korfuri) (1)
* [Veith Roethlingshoefer](https://github.com/samaaron/sonic-pi/commits?author=RunOrVeith) (1)



## Translation
The following volunteers have generously helped to translate Sonic Pi into additional languages:


* Łukasz Siwiński (172)
* Kenichi Kanai (123)
* Hanno Zulla (119)
* Sam Aaron (87)
* Nico Staelens (83)
* Nicolas Dermine (81)
* Olivier Humbert (51)
* Cindy Dallaire (48)
* Pau Monfort (39)
* Olympia Brikis (37)
* Mircea Patrascu (32)
* Federico Pepe (31)
* Petter Reinholdtsen (30)
* Daria Szatan (26)
* Mauro João Salgado Figueira (23)
* Ricardo Pozo (23)
* Yann Pavlenko (22)
* Giovanni Mori (21)
* Emlyn Corrin (18)
* Ruben Tobalina (18)
* Nicolas Le Bellier (15)
* Wolfgang Werner (14)
* Allan Nordhøy (13)
* G. Martin Butz (12)
* Álvaro Cáceres Muñoz (12)
* Hong Lees (11)
* Ole Friis Østergaard (11)
* Nicolas Limage (10)
* Elena Ogaderova (9)
* Kristjan Räts (9)
* Oto Popis (9)
* Tiago Morais Morgado (9)
* Yaron Shahrabani (9)
* Daniele Paradiso (8)
* Ole Erik Yrvin (8)
* Rekc@h (8)
* Yang Wanjun (8)
* Berkin Kadiroğlu (7)
* Eason Chang (7)
* Jan Lund (7)
* Paulo Chiliguano (7)
* Rachid Ben Moussa (7)
* Surajnath Sidh (7)
* Theodore Tsirpanis (7)
* Timo Dankert (7)
* ssantos (7)
* Bote Wang (6)
* Keiko Machiya (6)
* Mahmutcan İlhandağ (6)
* Matthieu Ottaviani (6)
* RD WebDesign (6)
* Stanislav Senveter (6)
* Олексій Овдієнко (6)
* Björn Ekström (5)
* CaoYi (5)
* Carlos Arturo Guerra Parra (5)
* Daria Szatan (5)
* Ettore Atalan (5)
* Francisco Llaryora (5)
* Hannes Fritz (5)
* Harald Eilertsen (5)
* Hayato Osanai (5)
* Ivan Decard (5)
* Johan Ekblad (5)
* Manula Thejan (5)
* Marcin "Tupteq" Bardź (5)
* Michiel Leegwater (5)
* Miroslav Hrabal (5)
* Muamer Ribica (5)
* Nur Sodik (5)
* Sebastian Stahn (5)
* Suleyman Poyraz (5)
* Alex Esc (4)
* André Klöpfel (4)
* ArtyomIsFlash (4)
* Dahlia Sager (4)
* Diego Gurnari (4)
* Edson Cunha (4)
* Jakob Bo Kristensen (4)
* João Medeiros (4)
* Marco Giordano (4)
* Salih Vatansever (4)
* Servaas Tilkin (4)
* Thomas G. Kristensen (4)
* Adeilson Silva (3)
* Adrian Nöthlich (3)
* Alban Vidal (3)
* Alexandr Gusev (3)
* Alexandre Karpinski Manikowski (3)
* Andreas Linz (3)
* Andres Senn (3)
* Anhquan Phanle (3)
* Anton Shestakov (3)
* Black SheepX (3)
* Chenebel Dorian (3)
* Dago Sondervan (3)
* Dan Hanley (3)
* Esteban Betancur (3)
* Hou Chen Zhong (3)
* Jiaxi Gu (3)
* Juan Pablo Riaño (3)
* Juhyun Lee (3)
* Luis Lloret (3)
* Lupa Lupin (3)
* László van den Hoek (3)
* Madis Liias (3)
* Martin Zeilinger (3)
* Michel Echevres (3)
* Moisés Cachay Tello (3)
* Nader Jafari (3)
* Nami KJ (3)
* Nathan Van der Auwera (3)
* Raúl Jiménez Martín (3)
* Rosdyana Kusuma (3)
* Sander Kesting (3)
* Sebastien van der Kwast (3)
* Stefan (3)
* Sune Sylvest Nilausen (3)
* Tasos Protopapas (3)
* Tuomas Pyylampi (3)
* Volkan Bakir (3)
* _eternal_flame (3)
* psyk10p (3)
* threewater2 (3)
* Alex Popov (2)
* Anders Berggren (2)
* André Sá (2)
* Arnold Ewald (2)
* Arnold Marko (2)
* Aron Birkir Gudmundsson (2)
* Blez Tseng (2)
* Brujo Rojas (2)
* ChiakiQ (2)
* CurlingTongs (2)
* Diego Ramos (2)
* Dimitris Panokostas (2)
* Duarte Botelho (2)
* Elmer Blanksvärd (2)
* Erick Bernalcrr (2)
* Ertu (Er2, Err) (2)
* Evgeni Latuhin (2)
* Fabian Aussems (2)
* Franz Laügt (2)
* Gabriel Barba Gonzalez (2)
* Gao Yuyang (2)
* Genek Tomashko (2)
* Giovanni Domeneghini (2)
* Guntitat Sawadwuthikul (2)
* Hamidreza Montaseri (2)
* Haowen You (2)
* Hilla Shahrabani (2)
* Hugo Vila (2)
* Italo Adler (2)
* Ivan Zarea (2)
* Jon Georgsson (2)
* Joschka Heinrich (2)
* Kaijing Zheng (2)
* Kiki Hzz (2)
* Louies (2)
* Louis Wolf (2)
* Luis Jimenez (2)
* Lukas Spee (2)
* Lázaro Henrique (2)
* Martin Solheim (2)
* Martin-Zack Mekkaoui (2)
* Mathieu H (2)
* Michael Peters (2)
* Moru (2)
* Narek Torosyan (2)
* Nicolas Cosson (2)
* Nimplex (2)
* Pierre Pintado (2)
* Přemek Vyhnal (2)
* Ran Tsoref (2)
* Raphaël Forment (2)
* Rodrigo Iglesias (2)
* Rodrigo Muniz (2)
* Roger Narayan (2)
* Roland Illig (2)
* Samuel El-Borai (2)
* Sebastian Rasmussen (2)
* Serge Stinckwich (2)
* Smite Chow (2)
* Song Li (2)
* Stefan Boeykens (2)
* Stefan Höhn (2)
* Sugahara Masayuki (2)
* Szymon Jakubiak (2)
* Tiago Naufragado (2)
* Tomás Vilariño (2)
* Vera Rojman (2)
* Vincent Renard (2)
* Vladimir Támara Patiño (2)
* Warren Alex (2)
* Weizheng Liu (2)
* Yandex (2)
* Zsolt Szakács (2)
* gedobbles (2)
* mintpi (2)
* sharmer156 (2)
* ۋولقان (2)
* Aaro Asikainen (1)
* Aaro Hillilä (1)
* Abdeselam El-Haman (1)
* Adam Süki (1)
* AgentWu (1)
* Ai Doan (1)
* Alejandro Sánchez Medina (1)
* Alessandro Kiefer (1)
* Anderson Freitas B. da Silva (1)
* Andras Nemeth (1)
* Andrey Raspopov (1)
* Anna Knudsen (1)
* Antonio Leal (1)
* Arnaud BOS (1)
* Arno van Brunschot (1)
* Artem Blinov (1)
* Arthur Augusto (1)
* Axel Céard (1)
* Baran Umut Mutlu (1)
* Benjamin Faguer (1)
* Breu Weber (1)
* Bruno Arakaki (1)
* Burak Tufekci (1)
* Carlos David Perales Cejudo (1)
* Cattice (1)
* Cedric Frossard (1)
* Cem Kaan Kösali (1)
* Cem Olcay (1)
* Christoph B. Wurzinger (1)
* Christopher Tibaldo (1)
* Claudio Pereira (1)
* Conny Söderholm (1)
* Coruna (1)
* Cristian Cabrera (1)
* Cyprien Huissoud (1)
* D. Lowl (1)
* Dag7 (1)
* Damian (1)
* Daniel Krog (1)
* David Girón (1)
* David Pilato (1)
* David Romero (1)
* Davide Facoetti (1)
* Davide Giovannini (1)
* Diemesleno Souza Carvalho (1)
* Dim Kyriakoudis (1)
* Dinh Huy (1)
* Elijah Grapes  (1)
* Elizabeth Sherrock (1)
* Enrike Hurtado (1)
* Ethan Crawford (1)
* Eugene Kovalev (1)
* Federico Saccà (1)
* Feodor Aleksandrov (1)
* Fernando Alberto Ribeiro Tavar (1)
* Filip Faste (1)
* Fredrik Forsberg (1)
* Gabriel Macedo (1)
* Gabriele Boddi (1)
* Garen Hart (1)
* Gerardo Soares (1)
* Glauco Luiz Corrêa Basilio Dos (1)
* Guillaume Gautier (1)
* Gustavo Castro (1)
* Haotong Chen (1)
* Hrafnkell Eiríksson (1)
* Huiting Milewski (1)
* Hyemin Shim (1)
* Ingrid Yrvin (1)
* Ioannis Sarlis (1)
* Ivan Krylov (1)
* Iván Montiel Cardona (1)
* Jaimie85 (1)
* Jeff Huang (1)
* Jeison Cardoso (1)
* Jesper Juellund Jensen (1)
* Joek van Montfort (1)
* Jonas Hummel (1)
* Joost T (1)
* Jose Añasco (1)
* Joyinglee (1)
* Jun Lin (1)
* Kaipo James Wilmeth (1)
* Kaique Ribeiro de Campos (1)
* Kamen Mladenov (1)
* Ke Ding (1)
* Kurushina Margarita (1)
* Lari Oesch (1)
* Lee Yunseok (1)
* Leidy (1)
* Leonardo Mendes Miraglia (1)
* Lorenzo Bloedow  (1)
* Lu Lecocq (1)
* Luis Garcia (1)
* Luis Valdez (1)
* Luna Jernberg (1)
* Manuel Carcach (1)
* Marc Kohaupt (1)
* Marek freezy Víger (1)
* Mark Lei  (1)
* Martin Gondermann (1)
* Martín Aguilar (1)
* Mateusz Bielec (1)
* Mathias Svendsen (1)
* Matteo Giaccone (1)
* Matthias Cavigelli (1)
* Mattias Münster (1)
* Mattias Roos (1)
* Mauro Garcia (1)
* Mehrad Mahmoudian (1)
* Michael Fulton (1)
* Miguel García (1)
* Mikkel Gravgaard (1)
* Mui Kai En (1)
* Nadezhda Ratckevich (1)
* Nathan (1)
* Netanel-M (1)
* Paola Ducolin (1)
* Paola García (1)
* Pascal (1)
* Paulo Amaral (1)
* Pavel Kartsel (1)
* Pedro Fernandes (1)
* Per-Erik Westerberg (1)
* Peter Bolch (1)
* Rafael Capaci Pereira (1)
* Rogério Pimentel (1)
* Rokibujjaman Rajon (1)
* Satjawat Paanakaan (1)
* Shu Shean (1)
* Simao Gomes Viana (1)
* Sohalt (1)
* Stephan Schuster (1)
* Sveinn í Felli (1)
* Sıtkı Bağdat (1)
* T-Jak-T (1)
* TA (1)
* Thiago Buenos Aires Mattos (1)
* Thiago Lopes (1)
* Thiemo Zaugg (1)
* Thodoris Bais (1)
* Thomas Qvidahl (1)
* Timo Roschier (1)
* Tino Ejlerskov (1)
* Tom Julux (1)
* Tomasz Nurkiewicz (1)
* Tommi Toivonen (1)
* Tuomas Hietala (1)
* Vadim R (1)
* Valdeci Gomes (1)
* Valentin Stern (1)
* Vee F (1)
* Veres Károly (1)
* Vibo Lavida (1)
* Victor Martin Garcia (1)
* Vitezslav Homolka (1)
* Vladimir Knyazev (1)
* Wilson Dashing (1)
* Wim Jaap (1)
* Xavier Riley (1)
* Xubin Cao (1)
* Y Honda (1)
* Zaiyi Wang (1)
* Zhe Wang (1)
* Zhengkun Wang (1)
* ggobugi27 (1)
* kuenwoo (1)
* leela (1)
* li-sky (1)
* wbk (1)
* zmni  (1)
* zxchen (1)
* Иван Лавриков (1)
* Максим Якимчук (1)
* Рамиль Иксанов (1)
* 丁科 (1)
* 张达 (1)
* 郑小则 (1)
* 陆轶凡 (1)
* 고아침 (1)
* 김운하 (1)
