/*! osc.js 2.2.0, Copyright 2017 Colin Clark | github.com/colinbdclark/osc.js */

var osc=osc||{};!function(){"use strict";osc.SECS_70YRS=2208988800,osc.TWO_32=4294967296,osc.defaults={metadata:!1,unpackSingleArgs:!0},osc.isCommonJS=!("undefined"==typeof module||!module.exports),osc.isNode=osc.isCommonJS&&"undefined"==typeof window,osc.isElectron=!("undefined"==typeof process||!process.versions||!process.versions.electron),osc.isBufferEnv=osc.isNode||osc.isElectron,osc.isArray=function(a){return a&&"[object Array]"===Object.prototype.toString.call(a)},osc.isTypedArrayView=function(a){return a.buffer&&a.buffer instanceof ArrayBuffer},osc.isBuffer=function(a){return osc.isBufferEnv&&a instanceof Buffer};var a="undefined"!=typeof dcodeIO?dcodeIO.Long:"undefined"!=typeof a?a:osc.isNode?require("long"):void 0;osc.dataView=function(a,b,c){return a.buffer?new DataView(a.buffer,b,c):a instanceof ArrayBuffer?new DataView(a,b,c):new DataView(new Uint8Array(a),b,c)},osc.byteArray=function(a){if(a instanceof Uint8Array)return a;var b=a.buffer?a.buffer:a;if(!(b instanceof ArrayBuffer||"undefined"!=typeof b.length&&"string"!=typeof b))throw new Error("Can't wrap a non-array-like object as Uint8Array. Object was: "+JSON.stringify(a,null,2));return new Uint8Array(b)},osc.nativeBuffer=function(a){return osc.isBufferEnv?osc.isBuffer(a)?a:new Buffer(a.buffer?a:new Uint8Array(a)):osc.isTypedArrayView(a)?a:new Uint8Array(a)},osc.copyByteArray=function(a,b,c){if(osc.isTypedArrayView(a)&&osc.isTypedArrayView(b))b.set(a,c);else for(var d=void 0===c?0:c,e=Math.min(b.length-c,a.length),f=0,g=d;f<e;f++,g++)b[g]=a[f];return b},osc.readString=function(a,b){for(var c=[],d=b.idx;d<a.byteLength;d++){var e=a.getUint8(d);if(0===e){d++;break}c.push(e)}return d=d+3&-4,b.idx=d,String.fromCharCode.apply(null,c)},osc.writeString=function(a){for(var b=a+"\0",c=b.length,d=c+3&-4,e=new Uint8Array(d),f=0;f<b.length;f++){var g=b.charCodeAt(f);e[f]=g}return e},osc.readPrimitive=function(a,b,c,d){var e=a[b](d.idx,!1);return d.idx+=c,e},osc.writePrimitive=function(a,b,c,d,e){e=void 0===e?0:e;var f;return b?f=new Uint8Array(b.buffer):(f=new Uint8Array(d),b=new DataView(f.buffer)),b[c](e,a,!1),f},osc.readInt32=function(a,b){return osc.readPrimitive(a,"getInt32",4,b)},osc.writeInt32=function(a,b,c){return osc.writePrimitive(a,b,"setInt32",4,c)},osc.readInt64=function(b,c){var d=osc.readPrimitive(b,"getInt32",4,c),e=osc.readPrimitive(b,"getInt32",4,c);return a?new a(e,d):{high:d,low:e,unsigned:!1}},osc.writeInt64=function(a,b,c){var d=new Uint8Array(8);return d.set(osc.writePrimitive(a.high,b,"setInt32",4,c),0),d.set(osc.writePrimitive(a.low,b,"setInt32",4,c+4),4),d},osc.readFloat32=function(a,b){return osc.readPrimitive(a,"getFloat32",4,b)},osc.writeFloat32=function(a,b,c){return osc.writePrimitive(a,b,"setFloat32",4,c)},osc.readFloat64=function(a,b){return osc.readPrimitive(a,"getFloat64",8,b)},osc.writeFloat64=function(a,b,c){return osc.writePrimitive(a,b,"setFloat64",8,c)},osc.readChar32=function(a,b){var c=osc.readPrimitive(a,"getUint32",4,b);return String.fromCharCode(c)},osc.writeChar32=function(a,b,c){var d=a.charCodeAt(0);if(!(void 0===d||d<-1))return osc.writePrimitive(d,b,"setUint32",4,c)},osc.readBlob=function(a,b){var c=osc.readInt32(a,b),d=c+3&-4,e=new Uint8Array(a.buffer,b.idx,c);return b.idx+=d,e},osc.writeBlob=function(a){a=osc.byteArray(a);var b=a.byteLength,c=b+3&-4,d=4,e=c+d,f=new Uint8Array(e),g=new DataView(f.buffer);return osc.writeInt32(b,g),f.set(a,d),f},osc.readMIDIBytes=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4);return b.idx+=4,c},osc.writeMIDIBytes=function(a){a=osc.byteArray(a);var b=new Uint8Array(4);return b.set(a),b},osc.readColor=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4),d=c[3]/255;return b.idx+=4,{r:c[0],g:c[1],b:c[2],a:d}},osc.writeColor=function(a){var b=Math.round(255*a.a),c=new Uint8Array([a.r,a.g,a.b,b]);return c},osc.readTrue=function(){return!0},osc.readFalse=function(){return!1},osc.readNull=function(){return null},osc.readImpulse=function(){return 1},osc.readTimeTag=function(a,b){var c=osc.readPrimitive(a,"getUint32",4,b),d=osc.readPrimitive(a,"getUint32",4,b),e=0===c&&1===d?Date.now():osc.ntpToJSTime(c,d);return{raw:[c,d],"native":e}},osc.writeTimeTag=function(a){var b=a.raw?a.raw:osc.jsToNTPTime(a["native"]),c=new Uint8Array(8),d=new DataView(c.buffer);return osc.writeInt32(b[0],d,0),osc.writeInt32(b[1],d,4),c},osc.timeTag=function(a,b){a=a||0,b=b||Date.now();var c=b/1e3,d=Math.floor(c),e=c-d,f=Math.floor(a),g=a-f,h=e+g;if(h>1){var i=Math.floor(h),j=h-i;f+=i,h=j}var k=d+f+osc.SECS_70YRS,l=Math.round(osc.TWO_32*h);return{raw:[k,l]}},osc.ntpToJSTime=function(a,b){var c=a-osc.SECS_70YRS,d=b/osc.TWO_32,e=1e3*(c+d);return e},osc.jsToNTPTime=function(a){var b=a/1e3,c=Math.floor(b),d=b-c,e=c+osc.SECS_70YRS,f=Math.round(osc.TWO_32*d);return[e,f]},osc.readArguments=function(a,b,c){var d=osc.readString(a,c);if(0!==d.indexOf(","))throw new Error("A malformed type tag string was found while reading the arguments of an OSC message. String was: "+d," at offset: "+c.idx);var e=d.substring(1).split(""),f=[];return osc.readArgumentsIntoArray(f,e,d,a,b,c),f},osc.readArgument=function(a,b,c,d,e){var f=osc.argumentTypes[a];if(!f)throw new Error("'"+a+"' is not a valid OSC type tag. Type tag string was: "+b);var g=f.reader,h=osc[g](c,e);return d.metadata&&(h={type:a,value:h}),h},osc.readArgumentsIntoArray=function(a,b,c,d,e,f){for(var g=0;g<b.length;){var h,i=b[g];if("["===i){var j=b.slice(g+1),k=j.indexOf("]");if(k<0)throw new Error("Invalid argument type tag: an open array type tag ('[') was found without a matching close array tag ('[]'). Type tag was: "+c);var l=j.slice(0,k);h=osc.readArgumentsIntoArray([],l,c,d,e,f),g+=k+2}else h=osc.readArgument(i,c,d,e,f),g++;a.push(h)}return a},osc.writeArguments=function(a,b){var c=osc.collectArguments(a,b);return osc.joinParts(c)},osc.joinParts=function(a){for(var b=new Uint8Array(a.byteLength),c=a.parts,d=0,e=0;e<c.length;e++){var f=c[e];osc.copyByteArray(f,b,d),d+=f.length}return b},osc.addDataPart=function(a,b){b.parts.push(a),b.byteLength+=a.length},osc.writeArrayArguments=function(a,b){for(var c="[",d=0;d<a.length;d++){var e=a[d];c+=osc.writeArgument(e,b)}return c+="]"},osc.writeArgument=function(a,b){if(osc.isArray(a))return osc.writeArrayArguments(a,b);var c=a.type,d=osc.argumentTypes[c].writer;if(d){var e=osc[d](a.value);osc.addDataPart(e,b)}return a.type},osc.collectArguments=function(a,b,c){osc.isArray(a)||(a="undefined"==typeof a?[]:[a]),c=c||{byteLength:0,parts:[]},b.metadata||(a=osc.annotateArguments(a));for(var d=",",e=c.parts.length,f=0;f<a.length;f++){var g=a[f];d+=osc.writeArgument(g,c)}var h=osc.writeString(d);return c.byteLength+=h.byteLength,c.parts.splice(e,0,h),c},osc.readMessage=function(a,b,c){b=b||osc.defaults;var d=osc.dataView(a,a.byteOffset,a.byteLength);c=c||{idx:0};var e=osc.readString(d,c);return osc.readMessageContents(e,d,b,c)},osc.readMessageContents=function(a,b,c,d){if(0!==a.indexOf("/"))throw new Error("A malformed OSC address was found while reading an OSC message. String was: "+a);var e=osc.readArguments(b,c,d);return{address:a,args:1===e.length&&c.unpackSingleArgs?e[0]:e}},osc.collectMessageParts=function(a,b,c){return c=c||{byteLength:0,parts:[]},osc.addDataPart(osc.writeString(a.address),c),osc.collectArguments(a.args,b,c)},osc.writeMessage=function(a,b){if(b=b||osc.defaults,!osc.isValidMessage(a))throw new Error("An OSC message must contain a valid address. Message was: "+JSON.stringify(a,null,2));var c=osc.collectMessageParts(a,b);return osc.joinParts(c)},osc.isValidMessage=function(a){return a.address&&0===a.address.indexOf("/")},osc.readBundle=function(a,b,c){return osc.readPacket(a,b,c)},osc.collectBundlePackets=function(a,b,c){c=c||{byteLength:0,parts:[]},osc.addDataPart(osc.writeString("#bundle"),c),osc.addDataPart(osc.writeTimeTag(a.timeTag),c);for(var d=0;d<a.packets.length;d++){var e=a.packets[d],f=e.address?osc.collectMessageParts:osc.collectBundlePackets,g=f(e,b);c.byteLength+=g.byteLength,osc.addDataPart(osc.writeInt32(g.byteLength),c),c.parts=c.parts.concat(g.parts)}return c},osc.writeBundle=function(a,b){if(!osc.isValidBundle(a))throw new Error("An OSC bundle must contain 'timeTag' and 'packets' properties. Bundle was: "+JSON.stringify(a,null,2));b=b||osc.defaults;var c=osc.collectBundlePackets(a,b);return osc.joinParts(c)},osc.isValidBundle=function(a){return void 0!==a.timeTag&&void 0!==a.packets},osc.readBundleContents=function(a,b,c,d){for(var e=osc.readTimeTag(a,c),f=[];c.idx<d;){var g=osc.readInt32(a,c),h=c.idx+g,i=osc.readPacket(a,b,c,h);f.push(i)}return{timeTag:e,packets:f}},osc.readPacket=function(a,b,c,d){var e=osc.dataView(a,a.byteOffset,a.byteLength);d=void 0===d?e.byteLength:d,c=c||{idx:0};var f=osc.readString(e,c),g=f[0];if("#"===g)return osc.readBundleContents(e,b,c,d);if("/"===g)return osc.readMessageContents(f,e,b,c);throw new Error("The header of an OSC packet didn't contain an OSC address or a #bundle string. Header was: "+f)},osc.writePacket=function(a,b){if(osc.isValidMessage(a))return osc.writeMessage(a,b);if(osc.isValidBundle(a))return osc.writeBundle(a,b);throw new Error("The specified packet was not recognized as a valid OSC message or bundle. Packet was: "+JSON.stringify(a,null,2))},osc.argumentTypes={i:{reader:"readInt32",writer:"writeInt32"},h:{reader:"readInt64",writer:"writeInt64"},f:{reader:"readFloat32",writer:"writeFloat32"},s:{reader:"readString",writer:"writeString"},S:{reader:"readString",writer:"writeString"},b:{reader:"readBlob",writer:"writeBlob"},t:{reader:"readTimeTag",writer:"writeTimeTag"},T:{reader:"readTrue"},F:{reader:"readFalse"},N:{reader:"readNull"},I:{reader:"readImpulse"},d:{reader:"readFloat64",writer:"writeFloat64"},c:{reader:"readChar32",writer:"writeChar32"},r:{reader:"readColor",writer:"writeColor"},m:{reader:"readMIDIBytes",writer:"writeMIDIBytes"}},osc.inferTypeForArgument=function(a){var b=typeof a;switch(b){case"boolean":return a?"T":"F";case"string":return"s";case"number":return"f";case"undefined":return"N";case"object":if(null===a)return"N";if(a instanceof Uint8Array||a instanceof ArrayBuffer)return"b";if("number"==typeof a.high&&"number"==typeof a.low)return"h"}throw new Error("Can't infer OSC argument type for value: "+JSON.stringify(a,null,2))},osc.annotateArguments=function(a){for(var b=[],c=0;c<a.length;c++){var d,e=a[c];if("object"==typeof e&&e.type&&void 0!==e.value)d=e;else if(osc.isArray(e))d=osc.annotateArguments(e);else{var f=osc.inferTypeForArgument(e);d={type:f,value:e}}b.push(d)}return b},osc.isCommonJS&&(module.exports=osc)}(),function(a,b){"function"==typeof define&&define.amd?define([],b):"function"==typeof require&&"object"==typeof module&&module&&module.exports?module.exports=b():(a.dcodeIO=a.dcodeIO||{}).Long=b()}(this,function(){"use strict";function a(a,b,c){this.low=0|a,this.high=0|b,this.unsigned=!!c}function b(a){return(a&&a.__isLong__)===!0}function c(a,b){var c,d,f;return b?(a>>>=0,(f=0<=a&&a<256)&&(d=i[a])?d:(c=e(a,(0|a)<0?-1:0,!0),f&&(i[a]=c),c)):(a|=0,(f=-128<=a&&a<128)&&(d=h[a])?d:(c=e(a,a<0?-1:0,!1),f&&(h[a]=c),c))}function d(a,b){if(isNaN(a)||!isFinite(a))return b?q:p;if(b){if(a<0)return q;if(a>=m)return v}else{if(a<=-n)return w;if(a+1>=n)return u}return a<0?d(-a,b).neg():e(a%l|0,a/l|0,b)}function e(b,c,d){return new a(b,c,d)}function f(a,b,c){if(0===a.length)throw Error("empty string");if("NaN"===a||"Infinity"===a||"+Infinity"===a||"-Infinity"===a)return p;if("number"==typeof b?(c=b,b=!1):b=!!b,c=c||10,c<2||36<c)throw RangeError("radix");var e;if((e=a.indexOf("-"))>0)throw Error("interior hyphen");if(0===e)return f(a.substring(1),b,c).neg();for(var g=d(j(c,8)),h=p,i=0;i<a.length;i+=8){var k=Math.min(8,a.length-i),l=parseInt(a.substring(i,i+k),c);if(k<8){var m=d(j(c,k));h=h.mul(m).add(d(l))}else h=h.mul(g),h=h.add(d(l))}return h.unsigned=b,h}function g(b){return b instanceof a?b:"number"==typeof b?d(b):"string"==typeof b?f(b):e(b.low,b.high,b.unsigned)}a.prototype.__isLong__,Object.defineProperty(a.prototype,"__isLong__",{value:!0,enumerable:!1,configurable:!1}),a.isLong=b;var h={},i={};a.fromInt=c,a.fromNumber=d,a.fromBits=e;var j=Math.pow;a.fromString=f,a.fromValue=g;var k=1<<24,l=4294967296,m=0x10000000000000000,n=m/2,o=c(k),p=c(0);a.ZERO=p;var q=c(0,!0);a.UZERO=q;var r=c(1);a.ONE=r;var s=c(1,!0);a.UONE=s;var t=c(-1);a.NEG_ONE=t;var u=e(-1,2147483647,!1);a.MAX_VALUE=u;var v=e(-1,-1,!0);a.MAX_UNSIGNED_VALUE=v;var w=e(0,-2147483648,!1);a.MIN_VALUE=w;var x=a.prototype;return x.toInt=function(){return this.unsigned?this.low>>>0:this.low},x.toNumber=function(){return this.unsigned?(this.high>>>0)*l+(this.low>>>0):this.high*l+(this.low>>>0)},x.toString=function(a){if(a=a||10,a<2||36<a)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(w)){var b=d(a),c=this.div(b),e=c.mul(b).sub(this);return c.toString(a)+e.toInt().toString(a)}return"-"+this.neg().toString(a)}for(var f=d(j(a,6),this.unsigned),g=this,h="";;){var i=g.div(f),k=g.sub(i.mul(f)).toInt()>>>0,l=k.toString(a);if(g=i,g.isZero())return l+h;for(;l.length<6;)l="0"+l;h=""+l+h}},x.getHighBits=function(){return this.high},x.getHighBitsUnsigned=function(){return this.high>>>0},x.getLowBits=function(){return this.low},x.getLowBitsUnsigned=function(){return this.low>>>0},x.getNumBitsAbs=function(){if(this.isNegative())return this.eq(w)?64:this.neg().getNumBitsAbs();for(var a=0!=this.high?this.high:this.low,b=31;b>0&&0==(a&1<<b);b--);return 0!=this.high?b+33:b+1},x.isZero=function(){return 0===this.high&&0===this.low},x.isNegative=function(){return!this.unsigned&&this.high<0},x.isPositive=function(){return this.unsigned||this.high>=0},x.isOdd=function(){return 1===(1&this.low)},x.isEven=function(){return 0===(1&this.low)},x.equals=function(a){return b(a)||(a=g(a)),(this.unsigned===a.unsigned||this.high>>>31!==1||a.high>>>31!==1)&&(this.high===a.high&&this.low===a.low)},x.eq=x.equals,x.notEquals=function(a){return!this.eq(a)},x.neq=x.notEquals,x.lessThan=function(a){return this.comp(a)<0},x.lt=x.lessThan,x.lessThanOrEqual=function(a){return this.comp(a)<=0},x.lte=x.lessThanOrEqual,x.greaterThan=function(a){return this.comp(a)>0},x.gt=x.greaterThan,x.greaterThanOrEqual=function(a){return this.comp(a)>=0},x.gte=x.greaterThanOrEqual,x.compare=function(a){if(b(a)||(a=g(a)),this.eq(a))return 0;var c=this.isNegative(),d=a.isNegative();return c&&!d?-1:!c&&d?1:this.unsigned?a.high>>>0>this.high>>>0||a.high===this.high&&a.low>>>0>this.low>>>0?-1:1:this.sub(a).isNegative()?-1:1},x.comp=x.compare,x.negate=function(){return!this.unsigned&&this.eq(w)?w:this.not().add(r)},x.neg=x.negate,x.add=function(a){b(a)||(a=g(a));var c=this.high>>>16,d=65535&this.high,f=this.low>>>16,h=65535&this.low,i=a.high>>>16,j=65535&a.high,k=a.low>>>16,l=65535&a.low,m=0,n=0,o=0,p=0;return p+=h+l,o+=p>>>16,p&=65535,o+=f+k,n+=o>>>16,o&=65535,n+=d+j,m+=n>>>16,n&=65535,m+=c+i,m&=65535,e(o<<16|p,m<<16|n,this.unsigned)},x.subtract=function(a){return b(a)||(a=g(a)),this.add(a.neg())},x.sub=x.subtract,x.multiply=function(a){if(this.isZero())return p;if(b(a)||(a=g(a)),a.isZero())return p;if(this.eq(w))return a.isOdd()?w:p;if(a.eq(w))return this.isOdd()?w:p;if(this.isNegative())return a.isNegative()?this.neg().mul(a.neg()):this.neg().mul(a).neg();if(a.isNegative())return this.mul(a.neg()).neg();if(this.lt(o)&&a.lt(o))return d(this.toNumber()*a.toNumber(),this.unsigned);var c=this.high>>>16,f=65535&this.high,h=this.low>>>16,i=65535&this.low,j=a.high>>>16,k=65535&a.high,l=a.low>>>16,m=65535&a.low,n=0,q=0,r=0,s=0;return s+=i*m,r+=s>>>16,s&=65535,r+=h*m,q+=r>>>16,r&=65535,r+=i*l,q+=r>>>16,r&=65535,q+=f*m,n+=q>>>16,q&=65535,q+=h*l,n+=q>>>16,q&=65535,q+=i*k,n+=q>>>16,q&=65535,n+=c*m+f*l+h*k+i*j,n&=65535,e(r<<16|s,n<<16|q,this.unsigned)},x.mul=x.multiply,x.divide=function(a){if(b(a)||(a=g(a)),a.isZero())throw Error("division by zero");if(this.isZero())return this.unsigned?q:p;var c,e,f;if(this.unsigned){if(a.unsigned||(a=a.toUnsigned()),a.gt(this))return q;if(a.gt(this.shru(1)))return s;f=q}else{if(this.eq(w)){if(a.eq(r)||a.eq(t))return w;if(a.eq(w))return r;var h=this.shr(1);return c=h.div(a).shl(1),c.eq(p)?a.isNegative()?r:t:(e=this.sub(a.mul(c)),f=c.add(e.div(a)))}if(a.eq(w))return this.unsigned?q:p;if(this.isNegative())return a.isNegative()?this.neg().div(a.neg()):this.neg().div(a).neg();if(a.isNegative())return this.div(a.neg()).neg();f=p}for(e=this;e.gte(a);){c=Math.max(1,Math.floor(e.toNumber()/a.toNumber()));for(var i=Math.ceil(Math.log(c)/Math.LN2),k=i<=48?1:j(2,i-48),l=d(c),m=l.mul(a);m.isNegative()||m.gt(e);)c-=k,l=d(c,this.unsigned),m=l.mul(a);l.isZero()&&(l=r),f=f.add(l),e=e.sub(m)}return f},x.div=x.divide,x.modulo=function(a){return b(a)||(a=g(a)),this.sub(this.div(a).mul(a))},x.mod=x.modulo,x.not=function(){return e(~this.low,~this.high,this.unsigned)},x.and=function(a){return b(a)||(a=g(a)),e(this.low&a.low,this.high&a.high,this.unsigned)},x.or=function(a){return b(a)||(a=g(a)),e(this.low|a.low,this.high|a.high,this.unsigned)},x.xor=function(a){return b(a)||(a=g(a)),e(this.low^a.low,this.high^a.high,this.unsigned)},x.shiftLeft=function(a){return b(a)&&(a=a.toInt()),0===(a&=63)?this:a<32?e(this.low<<a,this.high<<a|this.low>>>32-a,this.unsigned):e(0,this.low<<a-32,this.unsigned)},x.shl=x.shiftLeft,x.shiftRight=function(a){return b(a)&&(a=a.toInt()),0===(a&=63)?this:a<32?e(this.low>>>a|this.high<<32-a,this.high>>a,this.unsigned):e(this.high>>a-32,this.high>=0?0:-1,this.unsigned)},x.shr=x.shiftRight,x.shiftRightUnsigned=function(a){if(b(a)&&(a=a.toInt()),a&=63,0===a)return this;var c=this.high;if(a<32){var d=this.low;return e(d>>>a|c<<32-a,c>>>a,this.unsigned)}return 32===a?e(c,0,this.unsigned):e(c>>>a-32,0,this.unsigned)},x.shru=x.shiftRightUnsigned,x.toSigned=function(){return this.unsigned?e(this.low,this.high,!1):this},x.toUnsigned=function(){return this.unsigned?this:e(this.low,this.high,!0)},x.toBytes=function(a){return a?this.toBytesLE():this.toBytesBE()},x.toBytesLE=function(){var a=this.high,b=this.low;return[255&b,b>>>8&255,b>>>16&255,b>>>24&255,255&a,a>>>8&255,a>>>16&255,a>>>24&255]},x.toBytesBE=function(){var a=this.high,b=this.low;return[a>>>24&255,a>>>16&255,a>>>8&255,255&a,b>>>24&255,b>>>16&255,b>>>8&255,255&b]},a}),function(a,b){"use strict";"object"==typeof exports?(a.slip=exports,b(exports)):"function"==typeof define&&define.amd?define(["exports"],function(c){return a.slip=c,a.slip,b(c)}):(a.slip={},b(a.slip))}(this,function(a){"use strict";var b=a;b.END=192,b.ESC=219,b.ESC_END=220,b.ESC_ESC=221,b.byteArray=function(a,b,c){return a instanceof ArrayBuffer?new Uint8Array(a,b,c):a},b.expandByteArray=function(a){var b=new Uint8Array(2*a.length);return b.set(a),b},b.sliceByteArray=function(a,b,c){var d=a.buffer.slice?a.buffer.slice(b,c):a.subarray(b,c);return new Uint8Array(d)},b.encode=function(a,c){c=c||{},c.bufferPadding=c.bufferPadding||4,a=b.byteArray(a,c.offset,c.byteLength);var d=a.length+c.bufferPadding+3&-4,e=new Uint8Array(d),f=1;e[0]=b.END;for(var g=0;g<a.length;g++){f>e.length-3&&(e=b.expandByteArray(e));var h=a[g];h===b.END?(e[f++]=b.ESC,h=b.ESC_END):h===b.ESC&&(e[f++]=b.ESC,h=b.ESC_ESC),e[f++]=h}return e[f]=b.END,b.sliceByteArray(e,0,f+1)},b.Decoder=function(a){a="function"!=typeof a?a||{}:{onMessage:a},this.maxMessageSize=a.maxMessageSize||10485760,this.bufferSize=a.bufferSize||1024,this.msgBuffer=new Uint8Array(this.bufferSize),this.msgBufferIdx=0,this.onMessage=a.onMessage,this.onError=a.onError,this.escape=!1};var c=b.Decoder.prototype;return c.decode=function(a){a=b.byteArray(a);for(var c,d=0;d<a.length;d++){var e=a[d];if(this.escape)e===b.ESC_ESC?e=b.ESC:e===b.ESC_END&&(e=b.END);else{if(e===b.ESC){this.escape=!0;continue}if(e===b.END){c=this.handleEnd();continue}}var f=this.addByte(e);f||this.handleMessageMaxError()}return c},c.handleMessageMaxError=function(){this.onError&&this.onError(this.msgBuffer.subarray(0),"The message is too large; the maximum message size is "+this.maxMessageSize/1024+"KB. Use a larger maxMessageSize if necessary."),this.msgBufferIdx=0,this.escape=!1},c.addByte=function(a){return this.msgBufferIdx>this.msgBuffer.length-1&&(this.msgBuffer=b.expandByteArray(this.msgBuffer)),this.msgBuffer[this.msgBufferIdx++]=a,this.escape=!1,this.msgBuffer.length<this.maxMessageSize},c.handleEnd=function(){if(0!==this.msgBufferIdx){var a=b.sliceByteArray(this.msgBuffer,0,this.msgBufferIdx);return this.onMessage&&this.onMessage(a),this.msgBufferIdx=0,a}},b}),function(){"use strict";function a(){}function b(a,b){for(var c=a.length;c--;)if(a[c].listener===b)return c;return-1}function c(a){return function(){return this[a].apply(this,arguments)}}var d=a.prototype,e=this,f=e.EventEmitter;d.getListeners=function(a){var b,c,d=this._getEvents();if(a instanceof RegExp){b={};for(c in d)d.hasOwnProperty(c)&&a.test(c)&&(b[c]=d[c])}else b=d[a]||(d[a]=[]);return b},d.flattenListeners=function(a){var b,c=[];for(b=0;b<a.length;b+=1)c.push(a[b].listener);return c},d.getListenersAsObject=function(a){var b,c=this.getListeners(a);return c instanceof Array&&(b={},b[a]=c),b||c},d.addListener=function(a,c){var d,e=this.getListenersAsObject(a),f="object"==typeof c;for(d in e)e.hasOwnProperty(d)&&b(e[d],c)===-1&&e[d].push(f?c:{listener:c,once:!1});return this},d.on=c("addListener"),d.addOnceListener=function(a,b){return this.addListener(a,{listener:b,once:!0})},d.once=c("addOnceListener"),d.defineEvent=function(a){return this.getListeners(a),this},d.defineEvents=function(a){for(var b=0;b<a.length;b+=1)this.defineEvent(a[b]);return this},d.removeListener=function(a,c){var d,e,f=this.getListenersAsObject(a);for(e in f)f.hasOwnProperty(e)&&(d=b(f[e],c),d!==-1&&f[e].splice(d,1));return this},d.off=c("removeListener"),d.addListeners=function(a,b){return this.manipulateListeners(!1,a,b)},d.removeListeners=function(a,b){return this.manipulateListeners(!0,a,b)},d.manipulateListeners=function(a,b,c){var d,e,f=a?this.removeListener:this.addListener,g=a?this.removeListeners:this.addListeners;if("object"!=typeof b||b instanceof RegExp)for(d=c.length;d--;)f.call(this,b,c[d]);else for(d in b)b.hasOwnProperty(d)&&(e=b[d])&&("function"==typeof e?f.call(this,d,e):g.call(this,d,e));return this},d.removeEvent=function(a){var b,c=typeof a,d=this._getEvents();if("string"===c)delete d[a];else if(a instanceof RegExp)for(b in d)d.hasOwnProperty(b)&&a.test(b)&&delete d[b];else delete this._events;return this},d.removeAllListeners=c("removeEvent"),d.emitEvent=function(a,b){var c,d,e,f,g,h=this.getListenersAsObject(a);for(f in h)if(h.hasOwnProperty(f))for(c=h[f].slice(0),e=0;e<c.length;e++)d=c[e],d.once===!0&&this.removeListener(a,d.listener),g=d.listener.apply(this,b||[]),g===this._getOnceReturnValue()&&this.removeListener(a,d.listener);return this},d.trigger=c("emitEvent"),d.emit=function(a){var b=Array.prototype.slice.call(arguments,1);return this.emitEvent(a,b)},d.setOnceReturnValue=function(a){return this._onceReturnValue=a,this},d._getOnceReturnValue=function(){return!this.hasOwnProperty("_onceReturnValue")||this._onceReturnValue},d._getEvents=function(){return this._events||(this._events={})},a.noConflict=function(){return e.EventEmitter=f,a},"function"==typeof define&&define.amd?define(function(){return a}):"object"==typeof module&&module.exports?module.exports=a:e.EventEmitter=a}.call(this);var osc=osc||require("./osc.js"),slip=slip||require("slip"),EventEmitter=EventEmitter||require("events").EventEmitter;!function(){"use strict";osc.firePacketEvents=function(a,b,c,d){b.address?a.emit("message",b,c,d):osc.fireBundleEvents(a,b,c,d)},osc.fireBundleEvents=function(a,b,c,d){a.emit("bundle",b,c,d);for(var e=0;e<b.packets.length;e++){var f=b.packets[e];osc.firePacketEvents(a,f,b.timeTag,d)}},osc.fireClosedPortSendError=function(a,b){b=b||"Can't send packets on a closed osc.Port object. Please open (or reopen) this Port by calling open().",a.emit("error",b)},osc.Port=function(a){this.options=a||{},this.on("data",this.decodeOSC.bind(this))};var a=osc.Port.prototype=Object.create(EventEmitter.prototype);a.constructor=osc.Port,a.send=function(a){var b=Array.prototype.slice.call(arguments),c=this.encodeOSC(a),d=osc.nativeBuffer(c);b[0]=d,this.sendRaw.apply(this,b)},a.encodeOSC=function(a){a=a.buffer?a.buffer:a;var b;try{b=osc.writePacket(a,this.options)}catch(c){this.emit("error",c)}return b},a.decodeOSC=function(a,b){a=osc.byteArray(a),this.emit("raw",a,b);try{var c=osc.readPacket(a,this.options);this.emit("osc",c,b),osc.firePacketEvents(this,c,void 0,b)}catch(d){this.emit("error",d)}},osc.SLIPPort=function(a){var b=this,c=this.options=a||{};c.useSLIP=void 0===c.useSLIP||c.useSLIP,this.decoder=new slip.Decoder({onMessage:this.decodeOSC.bind(this),onError:function(a){b.emit("error",a)}});var d=c.useSLIP?this.decodeSLIPData:this.decodeOSC;this.on("data",d.bind(this))},a=osc.SLIPPort.prototype=Object.create(osc.Port.prototype),a.constructor=osc.SLIPPort,a.encodeOSC=function(a){a=a.buffer?a.buffer:a;var b;try{var c=osc.writePacket(a,this.options);b=slip.encode(c)}catch(d){this.emit("error",d)}return b},a.decodeSLIPData=function(a,b){this.decoder.decode(a,b)},osc.relay=function(a,b,c,d,e,f){c=c||"message",d=d||"send",e=e||function(){},f=f?[null].concat(f):[];var g=function(a){f[0]=a,a=e(a),b[d].apply(b,f)};return a.on(c,g),{eventName:c,listener:g}},osc.relayPorts=function(a,b,c){var d=c.raw?"raw":"osc",e=c.raw?"sendRaw":"send";return osc.relay(a,b,d,e,c.transform)},osc.stopRelaying=function(a,b){a.removeListener(b.eventName,b.listener)},osc.Relay=function(a,b,c){var d=this.options=c||{};d.raw=!1,this.port1=a,this.port2=b,this.listen()},a=osc.Relay.prototype=Object.create(EventEmitter.prototype),a.constructor=osc.Relay,a.open=function(){this.port1.open(),this.port2.open()},a.listen=function(){this.port1Spec&&this.port2Spec&&this.close(),this.port1Spec=osc.relayPorts(this.port1,this.port2,this.options),this.port2Spec=osc.relayPorts(this.port2,this.port1,this.options);var a=this.close.bind(this);this.port1.on("close",a),this.port2.on("close",a)},a.close=function(){osc.stopRelaying(this.port1,this.port1Spec),osc.stopRelaying(this.port2,this.port2Spec),this.emit("close",this.port1,this.port2)},"undefined"!=typeof module&&module.exports&&(module.exports=osc)}();var osc=osc||require("../osc.js");!function(){"use strict";osc.WebSocket="undefined"!=typeof WebSocket?WebSocket:require("ws"),osc.WebSocketPort=function(a){osc.Port.call(this,a),this.on("open",this.listen.bind(this)),this.socket=a.socket,this.socket&&(1===this.socket.readyState?(osc.WebSocketPort.setupSocketForBinary(this.socket),this.emit("open",this.socket)):this.open())};var a=osc.WebSocketPort.prototype=Object.create(osc.Port.prototype);a.constructor=osc.WebSocketPort,a.open=function(){(!this.socket||this.socket.readyState>1)&&(this.socket=new osc.WebSocket(this.options.url)),osc.WebSocketPort.setupSocketForBinary(this.socket);var a=this;this.socket.onopen=function(){a.emit("open",a.socket)}},a.listen=function(){var a=this;this.socket.onmessage=function(b){a.emit("data",b.data,b)},this.socket.onerror=function(b){a.emit("error",b)},this.socket.onclose=function(b){a.emit("close",b)},a.emit("ready")},a.sendRaw=function(a){return this.socket&&1===this.socket.readyState?void this.socket.send(a):void osc.fireClosedPortSendError(this)},a.close=function(a,b){this.socket.close(a,b)},osc.WebSocketPort.setupSocketForBinary=function(a){a.binaryType=osc.isNode?"nodebuffer":"arraybuffer"}}();