/*! osc.js 2.2.0, Copyright 2017 Colin Clark | github.com/colinbdclark/osc.js */

!function(a,b){"object"==typeof exports?(a.osc=exports,b(exports,require("slip"),require("EventEmitter"),require("long"))):"function"==typeof define&&define.amd?define(["exports","slip","EventEmitter","long"],function(c,d,e,f){return a.osc=c,a.osc,b(c,d,e,f)}):(a.osc={},b(a.osc,slip,EventEmitter))}(this,function(a,b,c,d){var e=e||{};!function(){"use strict";e.SECS_70YRS=2208988800,e.TWO_32=4294967296,e.defaults={metadata:!1,unpackSingleArgs:!0},e.isCommonJS=!("undefined"==typeof module||!module.exports),e.isNode=e.isCommonJS&&"undefined"==typeof window,e.isElectron=!("undefined"==typeof process||!process.versions||!process.versions.electron),e.isBufferEnv=e.isNode||e.isElectron,e.isArray=function(a){return a&&"[object Array]"===Object.prototype.toString.call(a)},e.isTypedArrayView=function(a){return a.buffer&&a.buffer instanceof ArrayBuffer},e.isBuffer=function(a){return e.isBufferEnv&&a instanceof Buffer};var a="undefined"!=typeof dcodeIO?dcodeIO.Long:"undefined"!=typeof a?a:e.isNode?require("long"):void 0;e.dataView=function(a,b,c){return a.buffer?new DataView(a.buffer,b,c):a instanceof ArrayBuffer?new DataView(a,b,c):new DataView(new Uint8Array(a),b,c)},e.byteArray=function(a){if(a instanceof Uint8Array)return a;var b=a.buffer?a.buffer:a;if(!(b instanceof ArrayBuffer||"undefined"!=typeof b.length&&"string"!=typeof b))throw new Error("Can't wrap a non-array-like object as Uint8Array. Object was: "+JSON.stringify(a,null,2));return new Uint8Array(b)},e.nativeBuffer=function(a){return e.isBufferEnv?e.isBuffer(a)?a:new Buffer(a.buffer?a:new Uint8Array(a)):e.isTypedArrayView(a)?a:new Uint8Array(a)},e.copyByteArray=function(a,b,c){if(e.isTypedArrayView(a)&&e.isTypedArrayView(b))b.set(a,c);else for(var d=void 0===c?0:c,f=Math.min(b.length-c,a.length),g=0,h=d;g<f;g++,h++)b[h]=a[g];return b},e.readString=function(a,b){for(var c=[],d=b.idx;d<a.byteLength;d++){var e=a.getUint8(d);if(0===e){d++;break}c.push(e)}return d=d+3&-4,b.idx=d,String.fromCharCode.apply(null,c)},e.writeString=function(a){for(var b=a+"\0",c=b.length,d=c+3&-4,e=new Uint8Array(d),f=0;f<b.length;f++){var g=b.charCodeAt(f);e[f]=g}return e},e.readPrimitive=function(a,b,c,d){var e=a[b](d.idx,!1);return d.idx+=c,e},e.writePrimitive=function(a,b,c,d,e){e=void 0===e?0:e;var f;return b?f=new Uint8Array(b.buffer):(f=new Uint8Array(d),b=new DataView(f.buffer)),b[c](e,a,!1),f},e.readInt32=function(a,b){return e.readPrimitive(a,"getInt32",4,b)},e.writeInt32=function(a,b,c){return e.writePrimitive(a,b,"setInt32",4,c)},e.readInt64=function(b,c){var d=e.readPrimitive(b,"getInt32",4,c),f=e.readPrimitive(b,"getInt32",4,c);return a?new a(f,d):{high:d,low:f,unsigned:!1}},e.writeInt64=function(a,b,c){var d=new Uint8Array(8);return d.set(e.writePrimitive(a.high,b,"setInt32",4,c),0),d.set(e.writePrimitive(a.low,b,"setInt32",4,c+4),4),d},e.readFloat32=function(a,b){return e.readPrimitive(a,"getFloat32",4,b)},e.writeFloat32=function(a,b,c){return e.writePrimitive(a,b,"setFloat32",4,c)},e.readFloat64=function(a,b){return e.readPrimitive(a,"getFloat64",8,b)},e.writeFloat64=function(a,b,c){return e.writePrimitive(a,b,"setFloat64",8,c)},e.readChar32=function(a,b){var c=e.readPrimitive(a,"getUint32",4,b);return String.fromCharCode(c)},e.writeChar32=function(a,b,c){var d=a.charCodeAt(0);if(!(void 0===d||d<-1))return e.writePrimitive(d,b,"setUint32",4,c)},e.readBlob=function(a,b){var c=e.readInt32(a,b),d=c+3&-4,f=new Uint8Array(a.buffer,b.idx,c);return b.idx+=d,f},e.writeBlob=function(a){a=e.byteArray(a);var b=a.byteLength,c=b+3&-4,d=4,f=c+d,g=new Uint8Array(f),h=new DataView(g.buffer);return e.writeInt32(b,h),g.set(a,d),g},e.readMIDIBytes=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4);return b.idx+=4,c},e.writeMIDIBytes=function(a){a=e.byteArray(a);var b=new Uint8Array(4);return b.set(a),b},e.readColor=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4),d=c[3]/255;return b.idx+=4,{r:c[0],g:c[1],b:c[2],a:d}},e.writeColor=function(a){var b=Math.round(255*a.a),c=new Uint8Array([a.r,a.g,a.b,b]);return c},e.readTrue=function(){return!0},e.readFalse=function(){return!1},e.readNull=function(){return null},e.readImpulse=function(){return 1},e.readTimeTag=function(a,b){var c=e.readPrimitive(a,"getUint32",4,b),d=e.readPrimitive(a,"getUint32",4,b),f=0===c&&1===d?Date.now():e.ntpToJSTime(c,d);return{raw:[c,d],"native":f}},e.writeTimeTag=function(a){var b=a.raw?a.raw:e.jsToNTPTime(a["native"]),c=new Uint8Array(8),d=new DataView(c.buffer);return e.writeInt32(b[0],d,0),e.writeInt32(b[1],d,4),c},e.timeTag=function(a,b){a=a||0,b=b||Date.now();var c=b/1e3,d=Math.floor(c),f=c-d,g=Math.floor(a),h=a-g,i=f+h;if(i>1){var j=Math.floor(i),k=i-j;g+=j,i=k}var l=d+g+e.SECS_70YRS,m=Math.round(e.TWO_32*i);return{raw:[l,m]}},e.ntpToJSTime=function(a,b){var c=a-e.SECS_70YRS,d=b/e.TWO_32,f=1e3*(c+d);return f},e.jsToNTPTime=function(a){var b=a/1e3,c=Math.floor(b),d=b-c,f=c+e.SECS_70YRS,g=Math.round(e.TWO_32*d);return[f,g]},e.readArguments=function(a,b,c){var d=e.readString(a,c);if(0!==d.indexOf(","))throw new Error("A malformed type tag string was found while reading the arguments of an OSC message. String was: "+d," at offset: "+c.idx);var f=d.substring(1).split(""),g=[];return e.readArgumentsIntoArray(g,f,d,a,b,c),g},e.readArgument=function(a,b,c,d,f){var g=e.argumentTypes[a];if(!g)throw new Error("'"+a+"' is not a valid OSC type tag. Type tag string was: "+b);var h=g.reader,i=e[h](c,f);return d.metadata&&(i={type:a,value:i}),i},e.readArgumentsIntoArray=function(a,b,c,d,f,g){for(var h=0;h<b.length;){var i,j=b[h];if("["===j){var k=b.slice(h+1),l=k.indexOf("]");if(l<0)throw new Error("Invalid argument type tag: an open array type tag ('[') was found without a matching close array tag ('[]'). Type tag was: "+c);var m=k.slice(0,l);i=e.readArgumentsIntoArray([],m,c,d,f,g),h+=l+2}else i=e.readArgument(j,c,d,f,g),h++;a.push(i)}return a},e.writeArguments=function(a,b){var c=e.collectArguments(a,b);return e.joinParts(c)},e.joinParts=function(a){for(var b=new Uint8Array(a.byteLength),c=a.parts,d=0,f=0;f<c.length;f++){var g=c[f];e.copyByteArray(g,b,d),d+=g.length}return b},e.addDataPart=function(a,b){b.parts.push(a),b.byteLength+=a.length},e.writeArrayArguments=function(a,b){for(var c="[",d=0;d<a.length;d++){var f=a[d];c+=e.writeArgument(f,b)}return c+="]"},e.writeArgument=function(a,b){if(e.isArray(a))return e.writeArrayArguments(a,b);var c=a.type,d=e.argumentTypes[c].writer;if(d){var f=e[d](a.value);e.addDataPart(f,b)}return a.type},e.collectArguments=function(a,b,c){e.isArray(a)||(a="undefined"==typeof a?[]:[a]),c=c||{byteLength:0,parts:[]},b.metadata||(a=e.annotateArguments(a));for(var d=",",f=c.parts.length,g=0;g<a.length;g++){var h=a[g];d+=e.writeArgument(h,c)}var i=e.writeString(d);return c.byteLength+=i.byteLength,c.parts.splice(f,0,i),c},e.readMessage=function(a,b,c){b=b||e.defaults;var d=e.dataView(a,a.byteOffset,a.byteLength);c=c||{idx:0};var f=e.readString(d,c);return e.readMessageContents(f,d,b,c)},e.readMessageContents=function(a,b,c,d){if(0!==a.indexOf("/"))throw new Error("A malformed OSC address was found while reading an OSC message. String was: "+a);var f=e.readArguments(b,c,d);return{address:a,args:1===f.length&&c.unpackSingleArgs?f[0]:f}},e.collectMessageParts=function(a,b,c){return c=c||{byteLength:0,parts:[]},e.addDataPart(e.writeString(a.address),c),e.collectArguments(a.args,b,c)},e.writeMessage=function(a,b){if(b=b||e.defaults,!e.isValidMessage(a))throw new Error("An OSC message must contain a valid address. Message was: "+JSON.stringify(a,null,2));var c=e.collectMessageParts(a,b);return e.joinParts(c)},e.isValidMessage=function(a){return a.address&&0===a.address.indexOf("/")},e.readBundle=function(a,b,c){return e.readPacket(a,b,c)},e.collectBundlePackets=function(a,b,c){c=c||{byteLength:0,parts:[]},e.addDataPart(e.writeString("#bundle"),c),e.addDataPart(e.writeTimeTag(a.timeTag),c);for(var d=0;d<a.packets.length;d++){var f=a.packets[d],g=f.address?e.collectMessageParts:e.collectBundlePackets,h=g(f,b);c.byteLength+=h.byteLength,e.addDataPart(e.writeInt32(h.byteLength),c),c.parts=c.parts.concat(h.parts)}return c},e.writeBundle=function(a,b){if(!e.isValidBundle(a))throw new Error("An OSC bundle must contain 'timeTag' and 'packets' properties. Bundle was: "+JSON.stringify(a,null,2));b=b||e.defaults;var c=e.collectBundlePackets(a,b);return e.joinParts(c)},e.isValidBundle=function(a){return void 0!==a.timeTag&&void 0!==a.packets},e.readBundleContents=function(a,b,c,d){for(var f=e.readTimeTag(a,c),g=[];c.idx<d;){var h=e.readInt32(a,c),i=c.idx+h,j=e.readPacket(a,b,c,i);g.push(j)}return{timeTag:f,packets:g}},e.readPacket=function(a,b,c,d){var f=e.dataView(a,a.byteOffset,a.byteLength);d=void 0===d?f.byteLength:d,c=c||{idx:0};var g=e.readString(f,c),h=g[0];if("#"===h)return e.readBundleContents(f,b,c,d);if("/"===h)return e.readMessageContents(g,f,b,c);throw new Error("The header of an OSC packet didn't contain an OSC address or a #bundle string. Header was: "+g)},e.writePacket=function(a,b){if(e.isValidMessage(a))return e.writeMessage(a,b);if(e.isValidBundle(a))return e.writeBundle(a,b);throw new Error("The specified packet was not recognized as a valid OSC message or bundle. Packet was: "+JSON.stringify(a,null,2))},e.argumentTypes={i:{reader:"readInt32",writer:"writeInt32"},h:{reader:"readInt64",writer:"writeInt64"},f:{reader:"readFloat32",writer:"writeFloat32"},s:{reader:"readString",writer:"writeString"},S:{reader:"readString",writer:"writeString"},b:{reader:"readBlob",writer:"writeBlob"},t:{reader:"readTimeTag",writer:"writeTimeTag"},T:{reader:"readTrue"},F:{reader:"readFalse"},N:{reader:"readNull"},I:{reader:"readImpulse"},d:{reader:"readFloat64",writer:"writeFloat64"},c:{reader:"readChar32",writer:"writeChar32"},r:{reader:"readColor",writer:"writeColor"},m:{reader:"readMIDIBytes",writer:"writeMIDIBytes"}},e.inferTypeForArgument=function(a){var b=typeof a;switch(b){case"boolean":return a?"T":"F";case"string":return"s";case"number":return"f";case"undefined":return"N";case"object":if(null===a)return"N";if(a instanceof Uint8Array||a instanceof ArrayBuffer)return"b";if("number"==typeof a.high&&"number"==typeof a.low)return"h"}throw new Error("Can't infer OSC argument type for value: "+JSON.stringify(a,null,2))},e.annotateArguments=function(a){for(var b=[],c=0;c<a.length;c++){var d,f=a[c];if("object"==typeof f&&f.type&&void 0!==f.value)d=f;else if(e.isArray(f))d=e.annotateArguments(f);else{var g=e.inferTypeForArgument(f);d={type:g,value:f}}b.push(d)}return b},e.isCommonJS&&(module.exports=e)}();var e=e||require("./osc.js"),b=b||require("slip"),c=c||require("events").EventEmitter;!function(){"use strict";e.firePacketEvents=function(a,b,c,d){b.address?a.emit("message",b,c,d):e.fireBundleEvents(a,b,c,d)},e.fireBundleEvents=function(a,b,c,d){a.emit("bundle",b,c,d);for(var f=0;f<b.packets.length;f++){var g=b.packets[f];e.firePacketEvents(a,g,b.timeTag,d)}},e.fireClosedPortSendError=function(a,b){b=b||"Can't send packets on a closed osc.Port object. Please open (or reopen) this Port by calling open().",a.emit("error",b)},e.Port=function(a){this.options=a||{},this.on("data",this.decodeOSC.bind(this))};var a=e.Port.prototype=Object.create(c.prototype);a.constructor=e.Port,a.send=function(a){var b=Array.prototype.slice.call(arguments),c=this.encodeOSC(a),d=e.nativeBuffer(c);b[0]=d,this.sendRaw.apply(this,b)},a.encodeOSC=function(a){a=a.buffer?a.buffer:a;var b;try{b=e.writePacket(a,this.options)}catch(c){this.emit("error",c)}return b},a.decodeOSC=function(a,b){a=e.byteArray(a),this.emit("raw",a,b);try{var c=e.readPacket(a,this.options);this.emit("osc",c,b),e.firePacketEvents(this,c,void 0,b)}catch(d){this.emit("error",d)}},e.SLIPPort=function(a){var c=this,d=this.options=a||{};d.useSLIP=void 0===d.useSLIP||d.useSLIP,this.decoder=new b.Decoder({onMessage:this.decodeOSC.bind(this),onError:function(a){c.emit("error",a)}});var e=d.useSLIP?this.decodeSLIPData:this.decodeOSC;this.on("data",e.bind(this))},a=e.SLIPPort.prototype=Object.create(e.Port.prototype),a.constructor=e.SLIPPort,a.encodeOSC=function(a){a=a.buffer?a.buffer:a;var c;try{var d=e.writePacket(a,this.options);c=b.encode(d)}catch(f){this.emit("error",f)}return c},a.decodeSLIPData=function(a,b){this.decoder.decode(a,b)},e.relay=function(a,b,c,d,e,f){c=c||"message",d=d||"send",e=e||function(){},f=f?[null].concat(f):[];var g=function(a){f[0]=a,a=e(a),b[d].apply(b,f)};return a.on(c,g),{eventName:c,listener:g}},e.relayPorts=function(a,b,c){var d=c.raw?"raw":"osc",f=c.raw?"sendRaw":"send";return e.relay(a,b,d,f,c.transform)},e.stopRelaying=function(a,b){a.removeListener(b.eventName,b.listener)},e.Relay=function(a,b,c){var d=this.options=c||{};d.raw=!1,this.port1=a,this.port2=b,this.listen()},a=e.Relay.prototype=Object.create(c.prototype),a.constructor=e.Relay,a.open=function(){this.port1.open(),this.port2.open()},a.listen=function(){this.port1Spec&&this.port2Spec&&this.close(),this.port1Spec=e.relayPorts(this.port1,this.port2,this.options),this.port2Spec=e.relayPorts(this.port2,this.port1,this.options);var a=this.close.bind(this);this.port1.on("close",a),this.port2.on("close",a)},a.close=function(){e.stopRelaying(this.port1,this.port1Spec),e.stopRelaying(this.port2,this.port2Spec),this.emit("close",this.port1,this.port2)},"undefined"!=typeof module&&module.exports&&(module.exports=e)}();var e=e||require("../osc.js");return function(){"use strict";e.WebSocket="undefined"!=typeof WebSocket?WebSocket:require("ws"),e.WebSocketPort=function(a){e.Port.call(this,a),this.on("open",this.listen.bind(this)),this.socket=a.socket,this.socket&&(1===this.socket.readyState?(e.WebSocketPort.setupSocketForBinary(this.socket),this.emit("open",this.socket)):this.open())};var a=e.WebSocketPort.prototype=Object.create(e.Port.prototype);a.constructor=e.WebSocketPort,a.open=function(){(!this.socket||this.socket.readyState>1)&&(this.socket=new e.WebSocket(this.options.url)),e.WebSocketPort.setupSocketForBinary(this.socket);var a=this;this.socket.onopen=function(){a.emit("open",a.socket)}},a.listen=function(){var a=this;this.socket.onmessage=function(b){a.emit("data",b.data,b)},this.socket.onerror=function(b){a.emit("error",b)},this.socket.onclose=function(b){a.emit("close",b)},a.emit("ready")},a.sendRaw=function(a){return this.socket&&1===this.socket.readyState?void this.socket.send(a):void e.fireClosedPortSendError(this)},a.close=function(a,b){this.socket.close(a,b)},e.WebSocketPort.setupSocketForBinary=function(a){a.binaryType=e.isNode?"nodebuffer":"arraybuffer"}}(),e});