/*! osc.js 2.2.0, Copyright 2017 Colin Clark | github.com/colinbdclark/osc.js */

var osc=osc||{};!function(){"use strict";osc.SECS_70YRS=2208988800,osc.TWO_32=4294967296,osc.defaults={metadata:!1,unpackSingleArgs:!0},osc.isCommonJS=!("undefined"==typeof module||!module.exports),osc.isNode=osc.isCommonJS&&"undefined"==typeof window,osc.isElectron=!("undefined"==typeof process||!process.versions||!process.versions.electron),osc.isBufferEnv=osc.isNode||osc.isElectron,osc.isArray=function(a){return a&&"[object Array]"===Object.prototype.toString.call(a)},osc.isTypedArrayView=function(a){return a.buffer&&a.buffer instanceof ArrayBuffer},osc.isBuffer=function(a){return osc.isBufferEnv&&a instanceof Buffer};var a="undefined"!=typeof dcodeIO?dcodeIO.Long:"undefined"!=typeof a?a:osc.isNode?require("long"):void 0;osc.dataView=function(a,b,c){return a.buffer?new DataView(a.buffer,b,c):a instanceof ArrayBuffer?new DataView(a,b,c):new DataView(new Uint8Array(a),b,c)},osc.byteArray=function(a){if(a instanceof Uint8Array)return a;var b=a.buffer?a.buffer:a;if(!(b instanceof ArrayBuffer||"undefined"!=typeof b.length&&"string"!=typeof b))throw new Error("Can't wrap a non-array-like object as Uint8Array. Object was: "+JSON.stringify(a,null,2));return new Uint8Array(b)},osc.nativeBuffer=function(a){return osc.isBufferEnv?osc.isBuffer(a)?a:new Buffer(a.buffer?a:new Uint8Array(a)):osc.isTypedArrayView(a)?a:new Uint8Array(a)},osc.copyByteArray=function(a,b,c){if(osc.isTypedArrayView(a)&&osc.isTypedArrayView(b))b.set(a,c);else for(var d=void 0===c?0:c,e=Math.min(b.length-c,a.length),f=0,g=d;f<e;f++,g++)b[g]=a[f];return b},osc.readString=function(a,b){for(var c=[],d=b.idx;d<a.byteLength;d++){var e=a.getUint8(d);if(0===e){d++;break}c.push(e)}return d=d+3&-4,b.idx=d,String.fromCharCode.apply(null,c)},osc.writeString=function(a){for(var b=a+"\0",c=b.length,d=c+3&-4,e=new Uint8Array(d),f=0;f<b.length;f++){var g=b.charCodeAt(f);e[f]=g}return e},osc.readPrimitive=function(a,b,c,d){var e=a[b](d.idx,!1);return d.idx+=c,e},osc.writePrimitive=function(a,b,c,d,e){e=void 0===e?0:e;var f;return b?f=new Uint8Array(b.buffer):(f=new Uint8Array(d),b=new DataView(f.buffer)),b[c](e,a,!1),f},osc.readInt32=function(a,b){return osc.readPrimitive(a,"getInt32",4,b)},osc.writeInt32=function(a,b,c){return osc.writePrimitive(a,b,"setInt32",4,c)},osc.readInt64=function(b,c){var d=osc.readPrimitive(b,"getInt32",4,c),e=osc.readPrimitive(b,"getInt32",4,c);return a?new a(e,d):{high:d,low:e,unsigned:!1}},osc.writeInt64=function(a,b,c){var d=new Uint8Array(8);return d.set(osc.writePrimitive(a.high,b,"setInt32",4,c),0),d.set(osc.writePrimitive(a.low,b,"setInt32",4,c+4),4),d},osc.readFloat32=function(a,b){return osc.readPrimitive(a,"getFloat32",4,b)},osc.writeFloat32=function(a,b,c){return osc.writePrimitive(a,b,"setFloat32",4,c)},osc.readFloat64=function(a,b){return osc.readPrimitive(a,"getFloat64",8,b)},osc.writeFloat64=function(a,b,c){return osc.writePrimitive(a,b,"setFloat64",8,c)},osc.readChar32=function(a,b){var c=osc.readPrimitive(a,"getUint32",4,b);return String.fromCharCode(c)},osc.writeChar32=function(a,b,c){var d=a.charCodeAt(0);if(!(void 0===d||d<-1))return osc.writePrimitive(d,b,"setUint32",4,c)},osc.readBlob=function(a,b){var c=osc.readInt32(a,b),d=c+3&-4,e=new Uint8Array(a.buffer,b.idx,c);return b.idx+=d,e},osc.writeBlob=function(a){a=osc.byteArray(a);var b=a.byteLength,c=b+3&-4,d=4,e=c+d,f=new Uint8Array(e),g=new DataView(f.buffer);return osc.writeInt32(b,g),f.set(a,d),f},osc.readMIDIBytes=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4);return b.idx+=4,c},osc.writeMIDIBytes=function(a){a=osc.byteArray(a);var b=new Uint8Array(4);return b.set(a),b},osc.readColor=function(a,b){var c=new Uint8Array(a.buffer,b.idx,4),d=c[3]/255;return b.idx+=4,{r:c[0],g:c[1],b:c[2],a:d}},osc.writeColor=function(a){var b=Math.round(255*a.a),c=new Uint8Array([a.r,a.g,a.b,b]);return c},osc.readTrue=function(){return!0},osc.readFalse=function(){return!1},osc.readNull=function(){return null},osc.readImpulse=function(){return 1},osc.readTimeTag=function(a,b){var c=osc.readPrimitive(a,"getUint32",4,b),d=osc.readPrimitive(a,"getUint32",4,b),e=0===c&&1===d?Date.now():osc.ntpToJSTime(c,d);return{raw:[c,d],"native":e}},osc.writeTimeTag=function(a){var b=a.raw?a.raw:osc.jsToNTPTime(a["native"]),c=new Uint8Array(8),d=new DataView(c.buffer);return osc.writeInt32(b[0],d,0),osc.writeInt32(b[1],d,4),c},osc.timeTag=function(a,b){a=a||0,b=b||Date.now();var c=b/1e3,d=Math.floor(c),e=c-d,f=Math.floor(a),g=a-f,h=e+g;if(h>1){var i=Math.floor(h),j=h-i;f+=i,h=j}var k=d+f+osc.SECS_70YRS,l=Math.round(osc.TWO_32*h);return{raw:[k,l]}},osc.ntpToJSTime=function(a,b){var c=a-osc.SECS_70YRS,d=b/osc.TWO_32,e=1e3*(c+d);return e},osc.jsToNTPTime=function(a){var b=a/1e3,c=Math.floor(b),d=b-c,e=c+osc.SECS_70YRS,f=Math.round(osc.TWO_32*d);return[e,f]},osc.readArguments=function(a,b,c){var d=osc.readString(a,c);if(0!==d.indexOf(","))throw new Error("A malformed type tag string was found while reading the arguments of an OSC message. String was: "+d," at offset: "+c.idx);var e=d.substring(1).split(""),f=[];return osc.readArgumentsIntoArray(f,e,d,a,b,c),f},osc.readArgument=function(a,b,c,d,e){var f=osc.argumentTypes[a];if(!f)throw new Error("'"+a+"' is not a valid OSC type tag. Type tag string was: "+b);var g=f.reader,h=osc[g](c,e);return d.metadata&&(h={type:a,value:h}),h},osc.readArgumentsIntoArray=function(a,b,c,d,e,f){for(var g=0;g<b.length;){var h,i=b[g];if("["===i){var j=b.slice(g+1),k=j.indexOf("]");if(k<0)throw new Error("Invalid argument type tag: an open array type tag ('[') was found without a matching close array tag ('[]'). Type tag was: "+c);var l=j.slice(0,k);h=osc.readArgumentsIntoArray([],l,c,d,e,f),g+=k+2}else h=osc.readArgument(i,c,d,e,f),g++;a.push(h)}return a},osc.writeArguments=function(a,b){var c=osc.collectArguments(a,b);return osc.joinParts(c)},osc.joinParts=function(a){for(var b=new Uint8Array(a.byteLength),c=a.parts,d=0,e=0;e<c.length;e++){var f=c[e];osc.copyByteArray(f,b,d),d+=f.length}return b},osc.addDataPart=function(a,b){b.parts.push(a),b.byteLength+=a.length},osc.writeArrayArguments=function(a,b){for(var c="[",d=0;d<a.length;d++){var e=a[d];c+=osc.writeArgument(e,b)}return c+="]"},osc.writeArgument=function(a,b){if(osc.isArray(a))return osc.writeArrayArguments(a,b);var c=a.type,d=osc.argumentTypes[c].writer;if(d){var e=osc[d](a.value);osc.addDataPart(e,b)}return a.type},osc.collectArguments=function(a,b,c){osc.isArray(a)||(a="undefined"==typeof a?[]:[a]),c=c||{byteLength:0,parts:[]},b.metadata||(a=osc.annotateArguments(a));for(var d=",",e=c.parts.length,f=0;f<a.length;f++){var g=a[f];d+=osc.writeArgument(g,c)}var h=osc.writeString(d);return c.byteLength+=h.byteLength,c.parts.splice(e,0,h),c},osc.readMessage=function(a,b,c){b=b||osc.defaults;var d=osc.dataView(a,a.byteOffset,a.byteLength);c=c||{idx:0};var e=osc.readString(d,c);return osc.readMessageContents(e,d,b,c)},osc.readMessageContents=function(a,b,c,d){if(0!==a.indexOf("/"))throw new Error("A malformed OSC address was found while reading an OSC message. String was: "+a);var e=osc.readArguments(b,c,d);return{address:a,args:1===e.length&&c.unpackSingleArgs?e[0]:e}},osc.collectMessageParts=function(a,b,c){return c=c||{byteLength:0,parts:[]},osc.addDataPart(osc.writeString(a.address),c),osc.collectArguments(a.args,b,c)},osc.writeMessage=function(a,b){if(b=b||osc.defaults,!osc.isValidMessage(a))throw new Error("An OSC message must contain a valid address. Message was: "+JSON.stringify(a,null,2));var c=osc.collectMessageParts(a,b);return osc.joinParts(c)},osc.isValidMessage=function(a){return a.address&&0===a.address.indexOf("/")},osc.readBundle=function(a,b,c){return osc.readPacket(a,b,c)},osc.collectBundlePackets=function(a,b,c){c=c||{byteLength:0,parts:[]},osc.addDataPart(osc.writeString("#bundle"),c),osc.addDataPart(osc.writeTimeTag(a.timeTag),c);for(var d=0;d<a.packets.length;d++){var e=a.packets[d],f=e.address?osc.collectMessageParts:osc.collectBundlePackets,g=f(e,b);c.byteLength+=g.byteLength,osc.addDataPart(osc.writeInt32(g.byteLength),c),c.parts=c.parts.concat(g.parts)}return c},osc.writeBundle=function(a,b){if(!osc.isValidBundle(a))throw new Error("An OSC bundle must contain 'timeTag' and 'packets' properties. Bundle was: "+JSON.stringify(a,null,2));b=b||osc.defaults;var c=osc.collectBundlePackets(a,b);return osc.joinParts(c)},osc.isValidBundle=function(a){return void 0!==a.timeTag&&void 0!==a.packets},osc.readBundleContents=function(a,b,c,d){for(var e=osc.readTimeTag(a,c),f=[];c.idx<d;){var g=osc.readInt32(a,c),h=c.idx+g,i=osc.readPacket(a,b,c,h);f.push(i)}return{timeTag:e,packets:f}},osc.readPacket=function(a,b,c,d){var e=osc.dataView(a,a.byteOffset,a.byteLength);d=void 0===d?e.byteLength:d,c=c||{idx:0};var f=osc.readString(e,c),g=f[0];if("#"===g)return osc.readBundleContents(e,b,c,d);if("/"===g)return osc.readMessageContents(f,e,b,c);throw new Error("The header of an OSC packet didn't contain an OSC address or a #bundle string. Header was: "+f)},osc.writePacket=function(a,b){if(osc.isValidMessage(a))return osc.writeMessage(a,b);if(osc.isValidBundle(a))return osc.writeBundle(a,b);throw new Error("The specified packet was not recognized as a valid OSC message or bundle. Packet was: "+JSON.stringify(a,null,2))},osc.argumentTypes={i:{reader:"readInt32",writer:"writeInt32"},h:{reader:"readInt64",writer:"writeInt64"},f:{reader:"readFloat32",writer:"writeFloat32"},s:{reader:"readString",writer:"writeString"},S:{reader:"readString",writer:"writeString"},b:{reader:"readBlob",writer:"writeBlob"},t:{reader:"readTimeTag",writer:"writeTimeTag"},T:{reader:"readTrue"},F:{reader:"readFalse"},N:{reader:"readNull"},I:{reader:"readImpulse"},d:{reader:"readFloat64",writer:"writeFloat64"},c:{reader:"readChar32",writer:"writeChar32"},r:{reader:"readColor",writer:"writeColor"},m:{reader:"readMIDIBytes",writer:"writeMIDIBytes"}},osc.inferTypeForArgument=function(a){var b=typeof a;switch(b){case"boolean":return a?"T":"F";case"string":return"s";case"number":return"f";case"undefined":return"N";case"object":if(null===a)return"N";if(a instanceof Uint8Array||a instanceof ArrayBuffer)return"b";if("number"==typeof a.high&&"number"==typeof a.low)return"h"}throw new Error("Can't infer OSC argument type for value: "+JSON.stringify(a,null,2))},osc.annotateArguments=function(a){for(var b=[],c=0;c<a.length;c++){var d,e=a[c];if("object"==typeof e&&e.type&&void 0!==e.value)d=e;else if(osc.isArray(e))d=osc.annotateArguments(e);else{var f=osc.inferTypeForArgument(e);d={type:f,value:e}}b.push(d)}return b},osc.isCommonJS&&(module.exports=osc)}();