dnl PAC_CXX_SEARCH_LIST - expands to a whitespace separated list of C++
dnl compilers for use with AC_PROG_CXX that is more suitable for HPC software
dnl packages
AC_DEFUN([PAC_CXX_SEARCH_LIST],[$CCC c++ g++ gcc CC cxx cc++ cl pgCC xlC icpc pathCC])
dnl PAC_PROG_CXX - reprioritize the C++ compiler search order
dnl NOTE: this macro suffers from a basically intractable "expanded before it
dnl was required" problem when libtool is also used
AC_DEFUN([PAC_PROG_CXX],[
	PAC_PUSH_FLAG([CXXFLAGS])
        # This test uses the list from a recent PROG_CXX, but with the
        # addition of the Portland group, IBM, and Intel C++ compilers
        # (While the Intel icc compiler will compile C++ programs, it will
        # not *link* C++ object files unless there is at least one C++ source
        # file present on the command that performs the linking.  icpc is the
        # Intel C++ compiler that both compiles and links C++ programs)
	AC_PROG_CXX([PAC_CXX_SEARCH_LIST])
	PAC_POP_FLAG([CXXFLAGS])
])

dnl This is from crypt.to/autoconf-archive, slightly modified.
dnl It defines bool as int if it is not availalbe
dnl
AC_DEFUN([AX_CXX_BOOL],
[AC_CACHE_CHECK(whether the compiler recognizes bool as a built-in type,
ac_cv_cxx_bool,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([
int f(int  x){return 1;}
int f(char x){return 1;}
int f(bool x){return 1;}
],[bool b = true; return f(b);],
 ac_cv_cxx_bool=yes, ac_cv_cxx_bool=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_bool" != yes; then
  AC_DEFINE(bool,int,[define if bool is a built-in type])
fi
])

dnl This is from crypt.to/autoconf-archive, slightly modified (name defined)
dnl
AC_DEFUN([AX_CXX_EXCEPTIONS],
[AC_CACHE_CHECK(whether the compiler supports exceptions,
ac_cv_cxx_exceptions,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE(,[try { throw  1; } catch (int i) { return i; }],
 ac_cv_cxx_exceptions=yes, ac_cv_cxx_exceptions=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_exceptions" = yes; then
  AC_DEFINE(HAVE_CXX_EXCEPTIONS,,[define if the compiler supports exceptions])
fi
])

dnl This is from crypt.to/autoconf-archive
dnl
AC_DEFUN([AX_CXX_NAMESPACES],
[AC_CACHE_CHECK(whether the compiler implements namespaces,
ac_cv_cxx_namespaces,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([namespace Outer { namespace Inner { int i = 0; }}],
                [using namespace Outer::Inner; return i;],
 ac_cv_cxx_namespaces=yes, ac_cv_cxx_namespaces=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_namespaces" = yes; then
  AC_DEFINE(HAVE_NAMESPACES,,[define if the compiler implements namespaces])
fi
])

dnl Some compilers support namespaces but don't know about std
dnl
AC_DEFUN([AX_CXX_NAMESPACE_STD],
[AC_REQUIRE([AX_CXX_NAMESPACES])
AC_CACHE_CHECK(whether the compiler implements the namespace std,
ac_cv_cxx_namespace_std,
[ac_cv_cxx_namespace_std=no
if test "$ac_cv_cxx_namespaces" = yes ; then 
   AC_LANG_SAVE
   AC_LANG_CPLUSPLUS
   AC_TRY_COMPILE([
#include <iostream>
using namespace std;],
                [cout << "message\n";],
 ac_cv_cxx_namespace_std=yes, ac_cv_cxx_namespace_std=no)
   AC_LANG_RESTORE
fi
])
if test "$ac_cv_cxx_namespace_std" = yes; then
  AC_DEFINE(HAVE_NAMESPACE_STD,,[define if the compiler implements namespace std])
fi
])

dnl/*D
dnl PAC_CXX_CHECK_COMPILER_OPTION - Check that a C++ compiler option is
dnl accepted without warning messages
dnl
dnl Synopsis:
dnl PAC_CXX_CHECK_COMPILER_OPTION(optionname,action-if-ok,action-if-fail)
dnl
dnl Output Effects:
dnl
dnl If no actions are specified, a working value is added to 'CXXOPTIONS'
dnl
dnl Notes:
dnl This is now careful to check that the output is different, since 
dnl some compilers are noisy.
dnl 
dnl We are extra careful to prototype the functions in case compiler options
dnl that complain about poor code are in effect.
dnl
dnl Because this is a long script, we have ensured that you can pass a
dnl variable containing the option name as the first argument.
dnl D*/
AC_DEFUN([PAC_CXX_CHECK_COMPILER_OPTION],[
AC_MSG_CHECKING([whether C++ compiler accepts option $1])
pac_opt="$1"
AC_LANG_PUSH([C++])
CXXFLAGS_orig="$CXXFLAGS"
CXXFLAGS_opt="$pac_opt $CXXFLAGS"
pac_result="unknown"

AC_LANG_CONFTEST([AC_LANG_PROGRAM()])
CXXFLAGS="$CXXFLAGS_orig"
rm -f pac_test1.log
PAC_LINK_IFELSE_LOG([pac_test1.log], [], [
    CXXFLAGS="$CXXFLAGS_opt"
    rm -f pac_test2.log
    PAC_LINK_IFELSE_LOG([pac_test2.log], [], [
        PAC_RUNLOG_IFELSE([diff -b pac_test1.log pac_test2.log],
                          [pac_result=yes],[pac_result=no])
    ],[
        pac_result=no
    ])
], [
    pac_result=no
])
AC_MSG_RESULT([$pac_result])
dnl Delete the conftest created by AC_LANG_CONFTEST.
rm -f conftest.$ac_ext

# clang on OSX has the terrible behavior that if you rename the object file,
# and use the same source file name (as autoconf wants to do), you can get
# the error message
#  warning: (x86_64)  could not find object file symbol for symbol __Z3foov
#
# The only fix for this is to use a different filename, and the
# easiest way to do that is to execute the simple code to create this
# object file rather than work with the standard compile and link test
# macros.
if test "$pac_result" = "yes" ; then
    AC_MSG_CHECKING([whether routines compiled with $pac_opt can be linked with ones compiled without $pac_opt])
    pac_result=unknown
    cat confdefs.h <<_ACEOF > pac_conftest.$ac_ext
            int foo(void);
            int foo(void){return 0;}
_ACEOF
    rm -f pac_test3.log
    if $CXX -c $CXXFLAGS_orig $CPPFLAGS pac_conftest.$ac_ext > pac_test3.log 2>&1 ; then
        saved_LIBS="$LIBS"
        LIBS="pac_conftest.$OBJEXT $LIBS"

        CXXFLAGS="$CXXFLAGS_opt"
        rm -f pac_test4.log
        PAC_LINK_IFELSE_LOG([pac_test4.log], [AC_LANG_PROGRAM()], [
            PAC_RUNLOG_IFELSE([diff -b pac_test2.log pac_test4.log],
                              [pac_result=yes], [pac_result=no])
        ],[
            pac_result=no
        ])
        LIBS="$saved_LIBS"
        rm -f pac_conftest.$OBJEXT
    else
        pac_result=no
    fi
    rm -f pac_conftest.$ac_ext pac_conftest.$OBJEXT
    AC_MSG_RESULT([$pac_result])
    rm -f pac_test3.log pac_test4.log
fi
rm -f pac_test1.log pac_test2.log

dnl Restore CXXFLAGS before 2nd/3rd argument commands are executed,
dnl as 2nd/3rd argument command could be modifying CXXFLAGS.
CXXFLAGS="$CXXFLAGS_orig"
if test "$pac_result" = "yes" ; then
     ifelse([$2],[],[CXXOPTIONS="$CXXOPTIONS $1"],[$2])
else
     ifelse([$3],[],[:],[$3])
fi
AC_LANG_POP([C++])
])

dnl Use the value of enable-strict-cxx to update CXXFLAGS
dnl pac_cxx_strict_flags contains the strict flags.
dnl
dnl -std=c89 is used to select the C89 version of the ANSI/ISO C standard.
dnl As of this writing, many C compilers still accepted only this version,
dnl not the later C99 version. When all compilers accept C99, this
dnl should be changed to the appropriate standard level.  Note that we've
dnl had trouble with gcc 2.95.3 accepting -std=c89 but then trying to
dnl compile program with a invalid set of options
dnl (-D __STRICT_ANSI__-trigraphs)
AC_DEFUN([PAC_CXX_STRICT],[
export enable_strict_cxx_done
if test "$enable_strict_cxx_done" != "yes" ; then

    # Some comments on strict warning options.
    # These were added to reduce warnings:
    #   -Wno-missing-field-initializers  -- We want to allow a struct to be
    #       initialized to zero using "struct x y = {0};" and not require
    #       each field to be initialized individually.
    #   -Wno-unused-parameter -- For portability, some parameters go unused
    #	    when we have different implementations of functions for
    #	    different platforms
    #   -Wno-unused-label -- We add fn_exit: and fn_fail: on all functions,
    #	    but fn_fail may not be used if the function doesn't return an
    #	    error.
    #   -Wno-sign-compare -- read() and write() return bytes read/written
    #       as a signed value, but we often compare this to size_t (or
    #	    msg_sz_t) variables.
    #   -Wno-format-zero-length -- this warning is irritating and useless, since
    #                              a zero-length format string is very well defined
    #   -Wno-type-limits -- There are places where we compare an unsigned to
    #	    a constant that happens to be zero e.g., if x is unsigned and
    #	    MIN_VAL is zero, we'd like to do "MPIU_Assert(x >= MIN_VAL);".
    #       Note this option is not supported by gcc 4.2.  This needs to be added
    #	    after most other warning flags, so that we catch a gcc bug on 32-bit
    #	    that doesn't give a warning that this is unsupported, unless another
    #	    warning is triggered, and then if gives an error.
    # These were removed to reduce warnings:
    #   -Wcast-qual -- Sometimes we need to cast "volatile char*" to
    #	    "char*", e.g., for memcpy.
    #   -Wpadded -- We catch struct padding with asserts when we need to
    #   -Wredundant-decls -- Having redundant declarations is benign and the
    #	    code already has some.
    #   -Waggregate-return -- This seems to be a performance-related warning
    #       aggregate return values are legal in ANSI C, but they may be returned
    #	    in memory rather than through a register.  We do use aggregate return
    #	    values, but they are structs of a single basic type (used to enforce
    #	    type checking for relative vs. absolute ptrs), and with optimization
    #	    the aggregate value is converted to a scalar.
    #   -Wdeclaration-after-statement -- This is a C89
    #       requirement. When compiling with C99, this should be
    #       disabled.
    #   -Wfloat-equal -- There are places in hwloc that set a float var to 0, then
    #       compare it to 0 later to see if it was updated.  Also when using strtod()
    #       one needs to compare the return value with 0 to see whether a conversion
    #       was performed.
    # the embedded newlines in this string are safe because we evaluate each
    # argument in the for-loop below and append them to the CFLAGS with a space
    # as the separator instead
    pac_common_strict_cxx_flags="
        -Wall
        -Wextra
        -Wshorten-64-to-32
        -Wno-missing-field-initializers
        -Wstrict-prototypes
        -Wmissing-prototypes
        -DGCC_WALL
        -Wno-unused-parameter
        -Wno-unused-label
        -Wshadow
        -Wmissing-declarations
        -Wno-long-long
        -Wundef
        -Wno-endif-labels
        -Wpointer-arith
        -Wbad-function-cast
        -Wcast-align
        -Wwrite-strings
        -Wno-sign-compare
        -Wold-style-definition
        -Wno-multichar
        -Wno-deprecated-declarations
        -Wpacked
        -Wnested-externs
        -Winvalid-pch
        -Wno-pointer-sign
        -Wvariadic-macros
        -Wno-format-zero-length
	-Wno-type-limits
    "

    enable_cxx_98=yes
    enable_posix=2001
    enable_opt=yes
    flags="`echo $1 | sed -e 's/:/ /g' -e 's/,/ /g'`"
    for flag in ${flags}; do
        case "$flag" in
	     c++98)
		enable_strict_cxx_done="yes"
		enable_cxx98=yes
		;;
	     posix1995)
		enable_strict_cxx_done="yes"
		enable_posix=1995
		;;
	     posix|posix2001)
		enable_strict_cxx_done="yes"
		enable_posix=2001
		;;
	     posix2008)
		enable_strict_cxx_done="yes"
		enable_posix=2008
		;;
	     noposix)
		enable_strict_cxx_done="yes"
		enable_posix=no
		;;
	     opt)
		enable_strict_cxx_done="yes"
		enable_opt=yes
		;;
	     noopt)
		enable_strict_cxx_done="yes"
		enable_opt=no
		;;
	     all|yes)
		enable_strict_cxx_done="yes"
		enable_cxx98=yes
		enable_posix=2001
		enable_opt=yes
	        ;;
	     no)
		# Accept and ignore this value
		:
		;;
	     *)
		if test -n "$flag" ; then
		   AC_MSG_WARN([Unrecognized value for enable-strict-cxx:$flag])
		fi
		;;
	esac
    done

    pac_cxx_strict_flags=""
    if test "${enable_strict_cxx_done}" = "yes" ; then
       if test "${enable_opt}" = "yes" ; then
       	  pac_cxx_strict_flags="-O2"
       fi
       pac_cxx_strict_flags="$pac_cxx_strict_flags $pac_common_strict_cxx_flags"
       case "$enable_posix" in
            no)   : ;;
            1995) PAC_APPEND_FLAG([-D_POSIX_C_SOURCE=199506L],[pac_cxx_strict_flags]) ;;
            2001) PAC_APPEND_FLAG([-D_POSIX_C_SOURCE=200112L],[pac_cxx_strict_flags]) ;;
            2008) PAC_APPEND_FLAG([-D_POSIX_C_SOURCE=200809L],[pac_cxx_strict_flags]) ;;
            *)    AC_MSG_ERROR([internal error, unexpected POSIX version: '$enable_posix']) ;;
       esac
       # We only allow one of strict-C99 or strict-C89 to be
       # enabled. If C99 is enabled, we automatically disable C89.
       if test "${enable_cxx98}" = "yes" ; then
       	  PAC_APPEND_FLAG([-std=c++98],[pac_cxx_strict_flags])
       fi
    fi

    # See if the above options work with the compiler
    accepted_flags=""
    for flag in $pac_cxx_strict_flags ; do
        PAC_PUSH_FLAG([CXXFLAGS])
	CXXFLAGS="$CXXFLAGS $accepted_flags"
        PAC_CXX_CHECK_COMPILER_OPTION([$flag],[accepted_flags="$accepted_flags $flag"],)
        PAC_POP_FLAG([CXXFLAGS])
    done
    pac_cxx_strict_flags=$accepted_flags
fi
])

dnl/*D
dnl PAC_ARG_STRICT_CXX - Add --enable-strict-cxx to configure.
dnl
dnl Synopsis:
dnl PAC_ARG_STRICT_CXX
dnl
dnl Output effects:
dnl Adds '--enable-strict-cxx' to the command line.
dnl
dnl D*/
AC_DEFUN([PAC_ARG_STRICT_CXX],[
AC_ARG_ENABLE(strict-cxx,
	AC_HELP_STRING([--enable-strict-cxx], [Turn on strict compilation testing for C++]))
PAC_CXX_STRICT($enable_strict_cxx)
CXXFLAGS="$CXXFLAGS $pac_cxx_strict_flags"
export CXXFLAGS
])
