/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

// This file is part of GNOME Games. License: GPLv3

public enum LibGamepad.StandardGamepadAxis {
	/**
	 * The horizontal axis of the left stick.
	 *
	 * Negative is left, positive is right.
	 */
	LEFT_X,

	/**
	 * The vertical axis of the left stick.
	 *
	 * Negative is up, positive is down.
	 */
	LEFT_Y,

	/**
	 * The horizontal axis of the right stick.
	 *
	 * Negative is left, positive is right.
	 */
	RIGHT_X,

	/**
	 * The vertical axis of the right stick.
	 *
	 * Negative is up, positive is down.
	 */
	RIGHT_Y,
}
