/*
   Copyright (C) 2014-2015 Alexandr Akulich <akulichalexander@gmail.com>

   This file is a part of TelegramQt library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

 */

#include "CTelegramStream.hpp"

#include <QtEndian>

#include <QIODevice>
#include <QDebug>

static const char s_nulls[4] = { 0, 0, 0, 0 };

template CTelegramStream &CTelegramStream::operator>>(TLVector<qint32> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<quint32> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<qint64> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<quint64> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<QString> &v);

template CTelegramStream &CTelegramStream::operator<<(const TLVector<qint32> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<quint32> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<qint64> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<quint64> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<QString> &v);

// Generated vector read templates instancing
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLChatParticipant> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLPhotoSize> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLAuthorization> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLDcOption> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLDisabledFeature> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLDocumentAttribute> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLInputUser> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLPrivacyRule> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLUser> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLContactBlocked> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLContact> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLContactFound> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLImportedContact> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLContactSuggested> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLStickerPack> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLStickerSet> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLDocument> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLChat> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLContactsLink> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLPhoto> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLChatLocated> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLGeoChatMessage> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLDialog> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLMessage> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLUpdate> &v);
template CTelegramStream &CTelegramStream::operator>>(TLVector<TLEncryptedMessage> &v);
// End of generated vector read templates instancing

// Generated vector write templates instancing
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLInputPrivacyRule> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLInputUser> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLInputContact> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLInputAppEvent> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLInputPhoto> &v);
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLDocumentAttribute> &v);
// End of generated vector write templates instancing
template CTelegramStream &CTelegramStream::operator<<(const TLVector<TLDcOption> &v);

CTelegramStream::CTelegramStream(QByteArray *data, bool write) :
    CRawStream(data, write)
{

}

CTelegramStream::CTelegramStream(const QByteArray &data) :
    CRawStream(data)
{

}

CTelegramStream::CTelegramStream(QIODevice *d) :
    CRawStream(d)
{

}

CTelegramStream &CTelegramStream::operator>>(QByteArray &data)
{
    quint32 length = 0;
    read(&length, 1);

    if (length < 0xfe) {
        data.resize(length);
        length += 1; // Plus one byte before data
    } else {
        read(&length, 3);
        data.resize(length);
        length += 4; // Plus four bytes before data
    }

    read(data.data(), data.size());

    if (length & 3) {
        readBytes(4 - (length & 3));
    }

    return *this;
}

template <typename T>
CTelegramStream &CTelegramStream::operator>>(TLVector<T> &v)
{
    TLVector<T> result;

    *this >> result.tlType;

    if (result.tlType == TLValue::Vector) {
        quint32 length = 0;
        *this >> length;
        for (quint32 i = 0; i < length; ++i) {
            T value;
            *this >> value;
            result.append(value);
        }
    }

    v = result;
    return *this;
}

// Generated read operators implementation
CTelegramStream &CTelegramStream::operator>>(TLAccountDaysTTL &accountDaysTTLValue)
{
    TLAccountDaysTTL result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountDaysTTL:
        *this >> result.days;
        break;
    default:
        break;
    }

    accountDaysTTLValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountPassword &accountPasswordValue)
{
    TLAccountPassword result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountNoPassword:
        *this >> result.newSalt;
        *this >> result.emailUnconfirmedPattern;
        break;
    case TLValue::AccountPassword:
        *this >> result.currentSalt;
        *this >> result.newSalt;
        *this >> result.hint;
        *this >> result.hasRecovery;
        *this >> result.emailUnconfirmedPattern;
        break;
    default:
        break;
    }

    accountPasswordValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountPasswordInputSettings &accountPasswordInputSettingsValue)
{
    TLAccountPasswordInputSettings result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountPasswordInputSettings:
        *this >> result.flags;
        if (result.flags & 1 << 0) {
            *this >> result.newSalt;
        }
        if (result.flags & 1 << 0) {
            *this >> result.newPasswordHash;
        }
        if (result.flags & 1 << 0) {
            *this >> result.hint;
        }
        if (result.flags & 1 << 1) {
            *this >> result.email;
        }
        break;
    default:
        break;
    }

    accountPasswordInputSettingsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountPasswordSettings &accountPasswordSettingsValue)
{
    TLAccountPasswordSettings result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountPasswordSettings:
        *this >> result.email;
        break;
    default:
        break;
    }

    accountPasswordSettingsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountSentChangePhoneCode &accountSentChangePhoneCodeValue)
{
    TLAccountSentChangePhoneCode result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountSentChangePhoneCode:
        *this >> result.phoneCodeHash;
        *this >> result.sendCallTimeout;
        break;
    default:
        break;
    }

    accountSentChangePhoneCodeValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAudio &audioValue)
{
    TLAudio result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AudioEmpty:
        *this >> result.id;
        break;
    case TLValue::Audio:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.userId;
        *this >> result.date;
        *this >> result.duration;
        *this >> result.mimeType;
        *this >> result.size;
        *this >> result.dcId;
        break;
    default:
        break;
    }

    audioValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthCheckedPhone &authCheckedPhoneValue)
{
    TLAuthCheckedPhone result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AuthCheckedPhone:
        *this >> result.phoneRegistered;
        break;
    default:
        break;
    }

    authCheckedPhoneValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthExportedAuthorization &authExportedAuthorizationValue)
{
    TLAuthExportedAuthorization result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AuthExportedAuthorization:
        *this >> result.id;
        *this >> result.bytes;
        break;
    default:
        break;
    }

    authExportedAuthorizationValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthPasswordRecovery &authPasswordRecoveryValue)
{
    TLAuthPasswordRecovery result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AuthPasswordRecovery:
        *this >> result.emailPattern;
        break;
    default:
        break;
    }

    authPasswordRecoveryValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthSentCode &authSentCodeValue)
{
    TLAuthSentCode result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AuthSentCode:
        *this >> result.phoneRegistered;
        *this >> result.phoneCodeHash;
        *this >> result.sendCallTimeout;
        *this >> result.isPassword;
        break;
    case TLValue::AuthSentAppCode:
        *this >> result.phoneRegistered;
        *this >> result.phoneCodeHash;
        *this >> result.sendCallTimeout;
        *this >> result.isPassword;
        break;
    default:
        break;
    }

    authSentCodeValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthorization &authorizationValue)
{
    TLAuthorization result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::Authorization:
        *this >> result.hash;
        *this >> result.flags;
        *this >> result.deviceModel;
        *this >> result.platform;
        *this >> result.systemVersion;
        *this >> result.apiId;
        *this >> result.appName;
        *this >> result.appVersion;
        *this >> result.dateCreated;
        *this >> result.dateActive;
        *this >> result.ip;
        *this >> result.country;
        *this >> result.region;
        break;
    default:
        break;
    }

    authorizationValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatLocated &chatLocatedValue)
{
    TLChatLocated result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatLocated:
        *this >> result.chatId;
        *this >> result.distance;
        break;
    default:
        break;
    }

    chatLocatedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatParticipant &chatParticipantValue)
{
    TLChatParticipant result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatParticipant:
        *this >> result.userId;
        *this >> result.inviterId;
        *this >> result.date;
        break;
    default:
        break;
    }

    chatParticipantValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatParticipants &chatParticipantsValue)
{
    TLChatParticipants result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatParticipantsForbidden:
        *this >> result.chatId;
        break;
    case TLValue::ChatParticipants:
        *this >> result.chatId;
        *this >> result.adminId;
        *this >> result.participants;
        *this >> result.version;
        break;
    default:
        break;
    }

    chatParticipantsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContact &contactValue)
{
    TLContact result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::Contact:
        *this >> result.userId;
        *this >> result.mutual;
        break;
    default:
        break;
    }

    contactValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactBlocked &contactBlockedValue)
{
    TLContactBlocked result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactBlocked:
        *this >> result.userId;
        *this >> result.date;
        break;
    default:
        break;
    }

    contactBlockedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactFound &contactFoundValue)
{
    TLContactFound result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactFound:
        *this >> result.userId;
        break;
    default:
        break;
    }

    contactFoundValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactLink &contactLinkValue)
{
    TLContactLink result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactLinkUnknown:
        break;
    case TLValue::ContactLinkNone:
        break;
    case TLValue::ContactLinkHasPhone:
        break;
    case TLValue::ContactLinkContact:
        break;
    default:
        break;
    }

    contactLinkValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactSuggested &contactSuggestedValue)
{
    TLContactSuggested result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactSuggested:
        *this >> result.userId;
        *this >> result.mutualContacts;
        break;
    default:
        break;
    }

    contactSuggestedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLDcOption &dcOptionValue)
{
    TLDcOption result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::DcOption:
        *this >> result.id;
        *this >> result.hostname;
        *this >> result.ipAddress;
        *this >> result.port;
        break;
    default:
        break;
    }

    dcOptionValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLDisabledFeature &disabledFeatureValue)
{
    TLDisabledFeature result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::DisabledFeature:
        *this >> result.feature;
        *this >> result.description;
        break;
    default:
        break;
    }

    disabledFeatureValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLEncryptedChat &encryptedChatValue)
{
    TLEncryptedChat result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::EncryptedChatEmpty:
        *this >> result.id;
        break;
    case TLValue::EncryptedChatWaiting:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.date;
        *this >> result.adminId;
        *this >> result.participantId;
        break;
    case TLValue::EncryptedChatRequested:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.date;
        *this >> result.adminId;
        *this >> result.participantId;
        *this >> result.gA;
        break;
    case TLValue::EncryptedChat:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.date;
        *this >> result.adminId;
        *this >> result.participantId;
        *this >> result.gAOrB;
        *this >> result.keyFingerprint;
        break;
    case TLValue::EncryptedChatDiscarded:
        *this >> result.id;
        break;
    default:
        break;
    }

    encryptedChatValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLEncryptedFile &encryptedFileValue)
{
    TLEncryptedFile result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::EncryptedFileEmpty:
        break;
    case TLValue::EncryptedFile:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.size;
        *this >> result.dcId;
        *this >> result.keyFingerprint;
        break;
    default:
        break;
    }

    encryptedFileValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLEncryptedMessage &encryptedMessageValue)
{
    TLEncryptedMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::EncryptedMessage:
        *this >> result.randomId;
        *this >> result.chatId;
        *this >> result.date;
        *this >> result.bytes;
        *this >> result.file;
        break;
    case TLValue::EncryptedMessageService:
        *this >> result.randomId;
        *this >> result.chatId;
        *this >> result.date;
        *this >> result.bytes;
        break;
    default:
        break;
    }

    encryptedMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLError &errorValue)
{
    TLError result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::Error:
        *this >> result.code;
        *this >> result.text;
        break;
    default:
        break;
    }

    errorValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLExportedChatInvite &exportedChatInviteValue)
{
    TLExportedChatInvite result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatInviteEmpty:
        break;
    case TLValue::ChatInviteExported:
        *this >> result.link;
        break;
    default:
        break;
    }

    exportedChatInviteValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLFileLocation &fileLocationValue)
{
    TLFileLocation result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::FileLocationUnavailable:
        *this >> result.volumeId;
        *this >> result.localId;
        *this >> result.secret;
        break;
    case TLValue::FileLocation:
        *this >> result.dcId;
        *this >> result.volumeId;
        *this >> result.localId;
        *this >> result.secret;
        break;
    default:
        break;
    }

    fileLocationValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLGeoPoint &geoPointValue)
{
    TLGeoPoint result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::GeoPointEmpty:
        break;
    case TLValue::GeoPoint:
        *this >> result.longitude;
        *this >> result.latitude;
        break;
    default:
        break;
    }

    geoPointValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLHelpAppUpdate &helpAppUpdateValue)
{
    TLHelpAppUpdate result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::HelpAppUpdate:
        *this >> result.id;
        *this >> result.critical;
        *this >> result.url;
        *this >> result.text;
        break;
    case TLValue::HelpNoAppUpdate:
        break;
    default:
        break;
    }

    helpAppUpdateValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLHelpInviteText &helpInviteTextValue)
{
    TLHelpInviteText result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::HelpInviteText:
        *this >> result.message;
        break;
    default:
        break;
    }

    helpInviteTextValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLImportedContact &importedContactValue)
{
    TLImportedContact result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ImportedContact:
        *this >> result.userId;
        *this >> result.clientId;
        break;
    default:
        break;
    }

    importedContactValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputAppEvent &inputAppEventValue)
{
    TLInputAppEvent result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputAppEvent:
        *this >> result.time;
        *this >> result.type;
        *this >> result.peer;
        *this >> result.data;
        break;
    default:
        break;
    }

    inputAppEventValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputAudio &inputAudioValue)
{
    TLInputAudio result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputAudioEmpty:
        break;
    case TLValue::InputAudio:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputAudioValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputContact &inputContactValue)
{
    TLInputContact result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPhoneContact:
        *this >> result.clientId;
        *this >> result.phone;
        *this >> result.firstName;
        *this >> result.lastName;
        break;
    default:
        break;
    }

    inputContactValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputDocument &inputDocumentValue)
{
    TLInputDocument result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputDocumentEmpty:
        break;
    case TLValue::InputDocument:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputDocumentValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputEncryptedChat &inputEncryptedChatValue)
{
    TLInputEncryptedChat result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputEncryptedChat:
        *this >> result.chatId;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputEncryptedChatValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputEncryptedFile &inputEncryptedFileValue)
{
    TLInputEncryptedFile result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputEncryptedFileEmpty:
        break;
    case TLValue::InputEncryptedFileUploaded:
        *this >> result.id;
        *this >> result.parts;
        *this >> result.md5Checksum;
        *this >> result.keyFingerprint;
        break;
    case TLValue::InputEncryptedFile:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    case TLValue::InputEncryptedFileBigUploaded:
        *this >> result.id;
        *this >> result.parts;
        *this >> result.keyFingerprint;
        break;
    default:
        break;
    }

    inputEncryptedFileValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputFile &inputFileValue)
{
    TLInputFile result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputFile:
        *this >> result.id;
        *this >> result.parts;
        *this >> result.name;
        *this >> result.md5Checksum;
        break;
    case TLValue::InputFileBig:
        *this >> result.id;
        *this >> result.parts;
        *this >> result.name;
        break;
    default:
        break;
    }

    inputFileValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputFileLocation &inputFileLocationValue)
{
    TLInputFileLocation result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputFileLocation:
        *this >> result.volumeId;
        *this >> result.localId;
        *this >> result.secret;
        break;
    case TLValue::InputVideoFileLocation:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    case TLValue::InputEncryptedFileLocation:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    case TLValue::InputAudioFileLocation:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    case TLValue::InputDocumentFileLocation:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputFileLocationValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputGeoChat &inputGeoChatValue)
{
    TLInputGeoChat result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputGeoChat:
        *this >> result.chatId;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputGeoChatValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputGeoPoint &inputGeoPointValue)
{
    TLInputGeoPoint result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputGeoPointEmpty:
        break;
    case TLValue::InputGeoPoint:
        *this >> result.latitude;
        *this >> result.longitude;
        break;
    default:
        break;
    }

    inputGeoPointValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPeer &inputPeerValue)
{
    TLInputPeer result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPeerEmpty:
        break;
    case TLValue::InputPeerSelf:
        break;
    case TLValue::InputPeerContact:
        *this >> result.userId;
        break;
    case TLValue::InputPeerForeign:
        *this >> result.userId;
        *this >> result.accessHash;
        break;
    case TLValue::InputPeerChat:
        *this >> result.chatId;
        break;
    default:
        break;
    }

    inputPeerValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPeerNotifyEvents &inputPeerNotifyEventsValue)
{
    TLInputPeerNotifyEvents result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPeerNotifyEventsEmpty:
        break;
    case TLValue::InputPeerNotifyEventsAll:
        break;
    default:
        break;
    }

    inputPeerNotifyEventsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPeerNotifySettings &inputPeerNotifySettingsValue)
{
    TLInputPeerNotifySettings result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPeerNotifySettings:
        *this >> result.muteUntil;
        *this >> result.sound;
        *this >> result.showPreviews;
        *this >> result.eventsMask;
        break;
    default:
        break;
    }

    inputPeerNotifySettingsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPhoto &inputPhotoValue)
{
    TLInputPhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPhotoEmpty:
        break;
    case TLValue::InputPhoto:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputPhotoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPhotoCrop &inputPhotoCropValue)
{
    TLInputPhotoCrop result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPhotoCropAuto:
        break;
    case TLValue::InputPhotoCrop:
        *this >> result.cropLeft;
        *this >> result.cropTop;
        *this >> result.cropWidth;
        break;
    default:
        break;
    }

    inputPhotoCropValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPrivacyKey &inputPrivacyKeyValue)
{
    TLInputPrivacyKey result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPrivacyKeyStatusTimestamp:
        break;
    default:
        break;
    }

    inputPrivacyKeyValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputStickerSet &inputStickerSetValue)
{
    TLInputStickerSet result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputStickerSetEmpty:
        break;
    case TLValue::InputStickerSetID:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    case TLValue::InputStickerSetShortName:
        *this >> result.shortName;
        break;
    default:
        break;
    }

    inputStickerSetValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputUser &inputUserValue)
{
    TLInputUser result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputUserEmpty:
        break;
    case TLValue::InputUserSelf:
        break;
    case TLValue::InputUserContact:
        *this >> result.userId;
        break;
    case TLValue::InputUserForeign:
        *this >> result.userId;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputUserValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputVideo &inputVideoValue)
{
    TLInputVideo result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputVideoEmpty:
        break;
    case TLValue::InputVideo:
        *this >> result.id;
        *this >> result.accessHash;
        break;
    default:
        break;
    }

    inputVideoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesAffectedHistory &messagesAffectedHistoryValue)
{
    TLMessagesAffectedHistory result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesAffectedHistory:
        *this >> result.pts;
        *this >> result.ptsCount;
        *this >> result.offset;
        break;
    default:
        break;
    }

    messagesAffectedHistoryValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesAffectedMessages &messagesAffectedMessagesValue)
{
    TLMessagesAffectedMessages result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesAffectedMessages:
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    default:
        break;
    }

    messagesAffectedMessagesValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesDhConfig &messagesDhConfigValue)
{
    TLMessagesDhConfig result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesDhConfigNotModified:
        *this >> result.random;
        break;
    case TLValue::MessagesDhConfig:
        *this >> result.g;
        *this >> result.p;
        *this >> result.version;
        *this >> result.random;
        break;
    default:
        break;
    }

    messagesDhConfigValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesFilter &messagesFilterValue)
{
    TLMessagesFilter result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputMessagesFilterEmpty:
        break;
    case TLValue::InputMessagesFilterPhotos:
        break;
    case TLValue::InputMessagesFilterVideo:
        break;
    case TLValue::InputMessagesFilterPhotoVideo:
        break;
    case TLValue::InputMessagesFilterPhotoVideoDocuments:
        break;
    case TLValue::InputMessagesFilterDocument:
        break;
    case TLValue::InputMessagesFilterAudio:
        break;
    default:
        break;
    }

    messagesFilterValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesSentEncryptedMessage &messagesSentEncryptedMessageValue)
{
    TLMessagesSentEncryptedMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesSentEncryptedMessage:
        *this >> result.date;
        break;
    case TLValue::MessagesSentEncryptedFile:
        *this >> result.date;
        *this >> result.file;
        break;
    default:
        break;
    }

    messagesSentEncryptedMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLNearestDc &nearestDcValue)
{
    TLNearestDc result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::NearestDc:
        *this >> result.country;
        *this >> result.thisDc;
        *this >> result.nearestDc;
        break;
    default:
        break;
    }

    nearestDcValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPeer &peerValue)
{
    TLPeer result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PeerUser:
        *this >> result.userId;
        break;
    case TLValue::PeerChat:
        *this >> result.chatId;
        break;
    default:
        break;
    }

    peerValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPeerNotifyEvents &peerNotifyEventsValue)
{
    TLPeerNotifyEvents result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PeerNotifyEventsEmpty:
        break;
    case TLValue::PeerNotifyEventsAll:
        break;
    default:
        break;
    }

    peerNotifyEventsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPeerNotifySettings &peerNotifySettingsValue)
{
    TLPeerNotifySettings result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PeerNotifySettingsEmpty:
        break;
    case TLValue::PeerNotifySettings:
        *this >> result.muteUntil;
        *this >> result.sound;
        *this >> result.showPreviews;
        *this >> result.eventsMask;
        break;
    default:
        break;
    }

    peerNotifySettingsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPhotoSize &photoSizeValue)
{
    TLPhotoSize result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PhotoSizeEmpty:
        *this >> result.type;
        break;
    case TLValue::PhotoSize:
        *this >> result.type;
        *this >> result.location;
        *this >> result.w;
        *this >> result.h;
        *this >> result.size;
        break;
    case TLValue::PhotoCachedSize:
        *this >> result.type;
        *this >> result.location;
        *this >> result.w;
        *this >> result.h;
        *this >> result.bytes;
        break;
    default:
        break;
    }

    photoSizeValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPrivacyKey &privacyKeyValue)
{
    TLPrivacyKey result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PrivacyKeyStatusTimestamp:
        break;
    default:
        break;
    }

    privacyKeyValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPrivacyRule &privacyRuleValue)
{
    TLPrivacyRule result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PrivacyValueAllowContacts:
        break;
    case TLValue::PrivacyValueAllowAll:
        break;
    case TLValue::PrivacyValueAllowUsers:
        *this >> result.users;
        break;
    case TLValue::PrivacyValueDisallowContacts:
        break;
    case TLValue::PrivacyValueDisallowAll:
        break;
    case TLValue::PrivacyValueDisallowUsers:
        *this >> result.users;
        break;
    default:
        break;
    }

    privacyRuleValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLReceivedNotifyMessage &receivedNotifyMessageValue)
{
    TLReceivedNotifyMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ReceivedNotifyMessage:
        *this >> result.id;
        *this >> result.flags;
        break;
    default:
        break;
    }

    receivedNotifyMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLSendMessageAction &sendMessageActionValue)
{
    TLSendMessageAction result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::SendMessageTypingAction:
        break;
    case TLValue::SendMessageCancelAction:
        break;
    case TLValue::SendMessageRecordVideoAction:
        break;
    case TLValue::SendMessageUploadVideoAction:
        *this >> result.progress;
        break;
    case TLValue::SendMessageRecordAudioAction:
        break;
    case TLValue::SendMessageUploadAudioAction:
        *this >> result.progress;
        break;
    case TLValue::SendMessageUploadPhotoAction:
        *this >> result.progress;
        break;
    case TLValue::SendMessageUploadDocumentAction:
        *this >> result.progress;
        break;
    case TLValue::SendMessageGeoLocationAction:
        break;
    case TLValue::SendMessageChooseContactAction:
        break;
    default:
        break;
    }

    sendMessageActionValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLStickerPack &stickerPackValue)
{
    TLStickerPack result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::StickerPack:
        *this >> result.emoticon;
        *this >> result.documents;
        break;
    default:
        break;
    }

    stickerPackValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLStickerSet &stickerSetValue)
{
    TLStickerSet result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::StickerSet:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.title;
        *this >> result.shortName;
        break;
    default:
        break;
    }

    stickerSetValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLStorageFileType &storageFileTypeValue)
{
    TLStorageFileType result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::StorageFileUnknown:
        break;
    case TLValue::StorageFileJpeg:
        break;
    case TLValue::StorageFileGif:
        break;
    case TLValue::StorageFilePng:
        break;
    case TLValue::StorageFilePdf:
        break;
    case TLValue::StorageFileMp3:
        break;
    case TLValue::StorageFileMov:
        break;
    case TLValue::StorageFilePartial:
        break;
    case TLValue::StorageFileMp4:
        break;
    case TLValue::StorageFileWebp:
        break;
    default:
        break;
    }

    storageFileTypeValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUpdatesState &updatesStateValue)
{
    TLUpdatesState result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UpdatesState:
        *this >> result.pts;
        *this >> result.qts;
        *this >> result.date;
        *this >> result.seq;
        *this >> result.unreadCount;
        break;
    default:
        break;
    }

    updatesStateValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUploadFile &uploadFileValue)
{
    TLUploadFile result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UploadFile:
        *this >> result.type;
        *this >> result.mtime;
        *this >> result.bytes;
        break;
    default:
        break;
    }

    uploadFileValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUserProfilePhoto &userProfilePhotoValue)
{
    TLUserProfilePhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UserProfilePhotoEmpty:
        break;
    case TLValue::UserProfilePhoto:
        *this >> result.photoId;
        *this >> result.photoSmall;
        *this >> result.photoBig;
        break;
    default:
        break;
    }

    userProfilePhotoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUserStatus &userStatusValue)
{
    TLUserStatus result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UserStatusEmpty:
        break;
    case TLValue::UserStatusOnline:
        *this >> result.expires;
        break;
    case TLValue::UserStatusOffline:
        *this >> result.wasOnline;
        break;
    case TLValue::UserStatusRecently:
        break;
    case TLValue::UserStatusLastWeek:
        break;
    case TLValue::UserStatusLastMonth:
        break;
    default:
        break;
    }

    userStatusValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLVideo &videoValue)
{
    TLVideo result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::VideoEmpty:
        *this >> result.id;
        break;
    case TLValue::Video:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.userId;
        *this >> result.date;
        *this >> result.duration;
        *this >> result.size;
        *this >> result.thumb;
        *this >> result.dcId;
        *this >> result.w;
        *this >> result.h;
        break;
    default:
        break;
    }

    videoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLWallPaper &wallPaperValue)
{
    TLWallPaper result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::WallPaper:
        *this >> result.id;
        *this >> result.title;
        *this >> result.sizes;
        *this >> result.color;
        break;
    case TLValue::WallPaperSolid:
        *this >> result.id;
        *this >> result.title;
        *this >> result.bgColor;
        *this >> result.color;
        break;
    default:
        break;
    }

    wallPaperValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountAuthorizations &accountAuthorizationsValue)
{
    TLAccountAuthorizations result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountAuthorizations:
        *this >> result.authorizations;
        break;
    default:
        break;
    }

    accountAuthorizationsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatPhoto &chatPhotoValue)
{
    TLChatPhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatPhotoEmpty:
        break;
    case TLValue::ChatPhoto:
        *this >> result.photoSmall;
        *this >> result.photoBig;
        break;
    default:
        break;
    }

    chatPhotoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLConfig &configValue)
{
    TLConfig result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::Config:
        *this >> result.date;
        *this >> result.expires;
        *this >> result.testMode;
        *this >> result.thisDc;
        *this >> result.dcOptions;
        *this >> result.chatSizeMax;
        *this >> result.broadcastSizeMax;
        *this >> result.forwardedCountMax;
        *this >> result.onlineUpdatePeriodMs;
        *this >> result.offlineBlurTimeoutMs;
        *this >> result.offlineIdleTimeoutMs;
        *this >> result.onlineCloudTimeoutMs;
        *this >> result.notifyCloudDelayMs;
        *this >> result.notifyDefaultDelayMs;
        *this >> result.chatBigSize;
        *this >> result.pushChatPeriodMs;
        *this >> result.pushChatLimit;
        *this >> result.disabledFeatures;
        break;
    default:
        break;
    }

    configValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactStatus &contactStatusValue)
{
    TLContactStatus result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactStatus:
        *this >> result.userId;
        *this >> result.status;
        break;
    default:
        break;
    }

    contactStatusValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLDialog &dialogValue)
{
    TLDialog result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::Dialog:
        *this >> result.peer;
        *this >> result.topMessage;
        *this >> result.readInboxMaxId;
        *this >> result.unreadCount;
        *this >> result.notifySettings;
        break;
    default:
        break;
    }

    dialogValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLDocumentAttribute &documentAttributeValue)
{
    TLDocumentAttribute result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::DocumentAttributeImageSize:
        *this >> result.w;
        *this >> result.h;
        break;
    case TLValue::DocumentAttributeAnimated:
        break;
    case TLValue::DocumentAttributeSticker:
        *this >> result.alt;
        *this >> result.stickerset;
        break;
    case TLValue::DocumentAttributeVideo:
        *this >> result.duration;
        *this >> result.w;
        *this >> result.h;
        break;
    case TLValue::DocumentAttributeAudio:
        *this >> result.duration;
        break;
    case TLValue::DocumentAttributeFilename:
        *this >> result.fileName;
        break;
    default:
        break;
    }

    documentAttributeValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputChatPhoto &inputChatPhotoValue)
{
    TLInputChatPhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputChatPhotoEmpty:
        break;
    case TLValue::InputChatUploadedPhoto:
        *this >> result.file;
        *this >> result.crop;
        break;
    case TLValue::InputChatPhoto:
        *this >> result.id;
        *this >> result.crop;
        break;
    default:
        break;
    }

    inputChatPhotoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputMedia &inputMediaValue)
{
    TLInputMedia result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputMediaEmpty:
        break;
    case TLValue::InputMediaUploadedPhoto:
        *this >> result.file;
        *this >> result.caption;
        break;
    case TLValue::InputMediaPhoto:
        *this >> result.idInputPhoto;
        *this >> result.caption;
        break;
    case TLValue::InputMediaGeoPoint:
        *this >> result.geoPoint;
        break;
    case TLValue::InputMediaContact:
        *this >> result.phoneNumber;
        *this >> result.firstName;
        *this >> result.lastName;
        break;
    case TLValue::InputMediaUploadedVideo:
        *this >> result.file;
        *this >> result.duration;
        *this >> result.w;
        *this >> result.h;
        *this >> result.caption;
        break;
    case TLValue::InputMediaUploadedThumbVideo:
        *this >> result.file;
        *this >> result.thumb;
        *this >> result.duration;
        *this >> result.w;
        *this >> result.h;
        *this >> result.caption;
        break;
    case TLValue::InputMediaVideo:
        *this >> result.idInputVeo;
        *this >> result.caption;
        break;
    case TLValue::InputMediaUploadedAudio:
        *this >> result.file;
        *this >> result.duration;
        *this >> result.mimeType;
        break;
    case TLValue::InputMediaAudio:
        *this >> result.idInputAudio;
        break;
    case TLValue::InputMediaUploadedDocument:
        *this >> result.file;
        *this >> result.mimeType;
        *this >> result.attributes;
        break;
    case TLValue::InputMediaUploadedThumbDocument:
        *this >> result.file;
        *this >> result.thumb;
        *this >> result.mimeType;
        *this >> result.attributes;
        break;
    case TLValue::InputMediaDocument:
        *this >> result.idInputDocument;
        break;
    case TLValue::InputMediaVenue:
        *this >> result.geoPoint;
        *this >> result.title;
        *this >> result.address;
        *this >> result.provider;
        *this >> result.venueId;
        break;
    default:
        break;
    }

    inputMediaValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputNotifyPeer &inputNotifyPeerValue)
{
    TLInputNotifyPeer result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputNotifyPeer:
        *this >> result.peerInput;
        break;
    case TLValue::InputNotifyUsers:
        break;
    case TLValue::InputNotifyChats:
        break;
    case TLValue::InputNotifyAll:
        break;
    case TLValue::InputNotifyGeoChatPeer:
        *this >> result.peerInputGeoChat;
        break;
    default:
        break;
    }

    inputNotifyPeerValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLInputPrivacyRule &inputPrivacyRuleValue)
{
    TLInputPrivacyRule result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::InputPrivacyValueAllowContacts:
        break;
    case TLValue::InputPrivacyValueAllowAll:
        break;
    case TLValue::InputPrivacyValueAllowUsers:
        *this >> result.users;
        break;
    case TLValue::InputPrivacyValueDisallowContacts:
        break;
    case TLValue::InputPrivacyValueDisallowAll:
        break;
    case TLValue::InputPrivacyValueDisallowUsers:
        *this >> result.users;
        break;
    default:
        break;
    }

    inputPrivacyRuleValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLNotifyPeer &notifyPeerValue)
{
    TLNotifyPeer result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::NotifyPeer:
        *this >> result.peer;
        break;
    case TLValue::NotifyUsers:
        break;
    case TLValue::NotifyChats:
        break;
    case TLValue::NotifyAll:
        break;
    default:
        break;
    }

    notifyPeerValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPhoto &photoValue)
{
    TLPhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PhotoEmpty:
        *this >> result.id;
        break;
    case TLValue::Photo:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.userId;
        *this >> result.date;
        *this >> result.geo;
        *this >> result.sizes;
        break;
    default:
        break;
    }

    photoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUser &userValue)
{
    TLUser result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UserEmpty:
        *this >> result.id;
        break;
    case TLValue::UserSelf:
        *this >> result.id;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        *this >> result.phone;
        *this >> result.photo;
        *this >> result.status;
        break;
    case TLValue::UserContact:
        *this >> result.id;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        *this >> result.accessHash;
        *this >> result.phone;
        *this >> result.photo;
        *this >> result.status;
        break;
    case TLValue::UserRequest:
        *this >> result.id;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        *this >> result.accessHash;
        *this >> result.phone;
        *this >> result.photo;
        *this >> result.status;
        break;
    case TLValue::UserForeign:
        *this >> result.id;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        *this >> result.accessHash;
        *this >> result.photo;
        *this >> result.status;
        break;
    case TLValue::UserDeleted:
        *this >> result.id;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        break;
    default:
        break;
    }

    userValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLWebPage &webPageValue)
{
    TLWebPage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::WebPageEmpty:
        *this >> result.id;
        break;
    case TLValue::WebPagePending:
        *this >> result.id;
        *this >> result.date;
        break;
    case TLValue::WebPage:
        *this >> result.flags;
        *this >> result.id;
        *this >> result.url;
        *this >> result.displayUrl;
        if (result.flags & 1 << 0) {
            *this >> result.type;
        }
        if (result.flags & 1 << 1) {
            *this >> result.siteName;
        }
        if (result.flags & 1 << 2) {
            *this >> result.title;
        }
        if (result.flags & 1 << 3) {
            *this >> result.description;
        }
        if (result.flags & 1 << 4) {
            *this >> result.photo;
        }
        if (result.flags & 1 << 5) {
            *this >> result.embedUrl;
        }
        if (result.flags & 1 << 5) {
            *this >> result.embedType;
        }
        if (result.flags & 1 << 6) {
            *this >> result.embedWidth;
        }
        if (result.flags & 1 << 6) {
            *this >> result.embedHeight;
        }
        if (result.flags & 1 << 7) {
            *this >> result.duration;
        }
        if (result.flags & 1 << 8) {
            *this >> result.author;
        }
        break;
    default:
        break;
    }

    webPageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAccountPrivacyRules &accountPrivacyRulesValue)
{
    TLAccountPrivacyRules result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AccountPrivacyRules:
        *this >> result.rules;
        *this >> result.users;
        break;
    default:
        break;
    }

    accountPrivacyRulesValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLAuthAuthorization &authAuthorizationValue)
{
    TLAuthAuthorization result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::AuthAuthorization:
        *this >> result.expires;
        *this >> result.user;
        break;
    default:
        break;
    }

    authAuthorizationValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChat &chatValue)
{
    TLChat result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatEmpty:
        *this >> result.id;
        break;
    case TLValue::Chat:
        *this >> result.id;
        *this >> result.title;
        *this >> result.photo;
        *this >> result.participantsCount;
        *this >> result.date;
        *this >> result.left;
        *this >> result.version;
        break;
    case TLValue::ChatForbidden:
        *this >> result.id;
        *this >> result.title;
        *this >> result.date;
        break;
    case TLValue::GeoChat:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.title;
        *this >> result.address;
        *this >> result.venue;
        *this >> result.geo;
        *this >> result.photo;
        *this >> result.participantsCount;
        *this >> result.date;
        *this >> result.checkedIn;
        *this >> result.version;
        break;
    default:
        break;
    }

    chatValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatFull &chatFullValue)
{
    TLChatFull result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatFull:
        *this >> result.id;
        *this >> result.participants;
        *this >> result.chatPhoto;
        *this >> result.notifySettings;
        *this >> result.exportedInvite;
        break;
    default:
        break;
    }

    chatFullValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLChatInvite &chatInviteValue)
{
    TLChatInvite result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ChatInviteAlready:
        *this >> result.chat;
        break;
    case TLValue::ChatInvite:
        *this >> result.title;
        break;
    default:
        break;
    }

    chatInviteValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsBlocked &contactsBlockedValue)
{
    TLContactsBlocked result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsBlocked:
        *this >> result.blocked;
        *this >> result.users;
        break;
    case TLValue::ContactsBlockedSlice:
        *this >> result.count;
        *this >> result.blocked;
        *this >> result.users;
        break;
    default:
        break;
    }

    contactsBlockedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsContacts &contactsContactsValue)
{
    TLContactsContacts result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsContactsNotModified:
        break;
    case TLValue::ContactsContacts:
        *this >> result.contacts;
        *this >> result.users;
        break;
    default:
        break;
    }

    contactsContactsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsFound &contactsFoundValue)
{
    TLContactsFound result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsFound:
        *this >> result.results;
        *this >> result.users;
        break;
    default:
        break;
    }

    contactsFoundValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsImportedContacts &contactsImportedContactsValue)
{
    TLContactsImportedContacts result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsImportedContacts:
        *this >> result.imported;
        *this >> result.retryContacts;
        *this >> result.users;
        break;
    default:
        break;
    }

    contactsImportedContactsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsLink &contactsLinkValue)
{
    TLContactsLink result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsLink:
        *this >> result.myLink;
        *this >> result.foreignLink;
        *this >> result.user;
        break;
    default:
        break;
    }

    contactsLinkValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLContactsSuggested &contactsSuggestedValue)
{
    TLContactsSuggested result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::ContactsSuggested:
        *this >> result.results;
        *this >> result.users;
        break;
    default:
        break;
    }

    contactsSuggestedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLDocument &documentValue)
{
    TLDocument result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::DocumentEmpty:
        *this >> result.id;
        break;
    case TLValue::Document:
        *this >> result.id;
        *this >> result.accessHash;
        *this >> result.date;
        *this >> result.mimeType;
        *this >> result.size;
        *this >> result.thumb;
        *this >> result.dcId;
        *this >> result.attributes;
        break;
    default:
        break;
    }

    documentValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLHelpSupport &helpSupportValue)
{
    TLHelpSupport result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::HelpSupport:
        *this >> result.phoneNumber;
        *this >> result.user;
        break;
    default:
        break;
    }

    helpSupportValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessageAction &messageActionValue)
{
    TLMessageAction result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessageActionEmpty:
        break;
    case TLValue::MessageActionChatCreate:
        *this >> result.title;
        *this >> result.users;
        break;
    case TLValue::MessageActionChatEditTitle:
        *this >> result.title;
        break;
    case TLValue::MessageActionChatEditPhoto:
        *this >> result.photo;
        break;
    case TLValue::MessageActionChatDeletePhoto:
        break;
    case TLValue::MessageActionChatAddUser:
        *this >> result.userId;
        break;
    case TLValue::MessageActionChatDeleteUser:
        *this >> result.userId;
        break;
    case TLValue::MessageActionGeoChatCreate:
        *this >> result.title;
        *this >> result.address;
        break;
    case TLValue::MessageActionGeoChatCheckin:
        break;
    case TLValue::MessageActionChatJoinedByLink:
        *this >> result.inviterId;
        break;
    default:
        break;
    }

    messageActionValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessageMedia &messageMediaValue)
{
    TLMessageMedia result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessageMediaEmpty:
        break;
    case TLValue::MessageMediaPhoto:
        *this >> result.photo;
        *this >> result.caption;
        break;
    case TLValue::MessageMediaVideo:
        *this >> result.video;
        *this >> result.caption;
        break;
    case TLValue::MessageMediaGeo:
        *this >> result.geo;
        break;
    case TLValue::MessageMediaContact:
        *this >> result.phoneNumber;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.userId;
        break;
    case TLValue::MessageMediaUnsupported:
        break;
    case TLValue::MessageMediaDocument:
        *this >> result.document;
        break;
    case TLValue::MessageMediaAudio:
        *this >> result.audio;
        break;
    case TLValue::MessageMediaWebPage:
        *this >> result.webpage;
        break;
    case TLValue::MessageMediaVenue:
        *this >> result.geo;
        *this >> result.title;
        *this >> result.address;
        *this >> result.provider;
        *this >> result.venueId;
        break;
    default:
        break;
    }

    messageMediaValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesAllStickers &messagesAllStickersValue)
{
    TLMessagesAllStickers result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesAllStickersNotModified:
        break;
    case TLValue::MessagesAllStickers:
        *this >> result.hash;
        *this >> result.packs;
        *this >> result.sets;
        *this >> result.documents;
        break;
    default:
        break;
    }

    messagesAllStickersValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesChatFull &messagesChatFullValue)
{
    TLMessagesChatFull result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesChatFull:
        *this >> result.fullChat;
        *this >> result.chats;
        *this >> result.users;
        break;
    default:
        break;
    }

    messagesChatFullValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesChats &messagesChatsValue)
{
    TLMessagesChats result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesChats:
        *this >> result.chats;
        break;
    default:
        break;
    }

    messagesChatsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesSentMessage &messagesSentMessageValue)
{
    TLMessagesSentMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesSentMessage:
        *this >> result.id;
        *this >> result.date;
        *this >> result.media;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    case TLValue::MessagesSentMessageLink:
        *this >> result.id;
        *this >> result.date;
        *this >> result.media;
        *this >> result.pts;
        *this >> result.ptsCount;
        *this >> result.links;
        *this >> result.seq;
        break;
    default:
        break;
    }

    messagesSentMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesStickerSet &messagesStickerSetValue)
{
    TLMessagesStickerSet result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesStickerSet:
        *this >> result.set;
        *this >> result.packs;
        *this >> result.documents;
        break;
    default:
        break;
    }

    messagesStickerSetValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesStickers &messagesStickersValue)
{
    TLMessagesStickers result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesStickersNotModified:
        break;
    case TLValue::MessagesStickers:
        *this >> result.hash;
        *this >> result.stickers;
        break;
    default:
        break;
    }

    messagesStickersValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPhotosPhoto &photosPhotoValue)
{
    TLPhotosPhoto result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PhotosPhoto:
        *this >> result.photo;
        *this >> result.users;
        break;
    default:
        break;
    }

    photosPhotoValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLPhotosPhotos &photosPhotosValue)
{
    TLPhotosPhotos result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::PhotosPhotos:
        *this >> result.photos;
        *this >> result.users;
        break;
    case TLValue::PhotosPhotosSlice:
        *this >> result.count;
        *this >> result.photos;
        *this >> result.users;
        break;
    default:
        break;
    }

    photosPhotosValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUserFull &userFullValue)
{
    TLUserFull result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UserFull:
        *this >> result.user;
        *this >> result.link;
        *this >> result.profilePhoto;
        *this >> result.notifySettings;
        *this >> result.blocked;
        *this >> result.realFirstName;
        *this >> result.realLastName;
        break;
    default:
        break;
    }

    userFullValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLGeoChatMessage &geoChatMessageValue)
{
    TLGeoChatMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::GeoChatMessageEmpty:
        *this >> result.chatId;
        *this >> result.id;
        break;
    case TLValue::GeoChatMessage:
        *this >> result.chatId;
        *this >> result.id;
        *this >> result.fromId;
        *this >> result.date;
        *this >> result.message;
        *this >> result.media;
        break;
    case TLValue::GeoChatMessageService:
        *this >> result.chatId;
        *this >> result.id;
        *this >> result.fromId;
        *this >> result.date;
        *this >> result.action;
        break;
    default:
        break;
    }

    geoChatMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLGeochatsLocated &geochatsLocatedValue)
{
    TLGeochatsLocated result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::GeochatsLocated:
        *this >> result.results;
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    default:
        break;
    }

    geochatsLocatedValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLGeochatsMessages &geochatsMessagesValue)
{
    TLGeochatsMessages result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::GeochatsMessages:
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    case TLValue::GeochatsMessagesSlice:
        *this >> result.count;
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    default:
        break;
    }

    geochatsMessagesValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLGeochatsStatedMessage &geochatsStatedMessageValue)
{
    TLGeochatsStatedMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::GeochatsStatedMessage:
        *this >> result.message;
        *this >> result.chats;
        *this >> result.users;
        *this >> result.seq;
        break;
    default:
        break;
    }

    geochatsStatedMessageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessage &messageValue)
{
    TLMessage result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessageEmpty:
        *this >> result.id;
        break;
    case TLValue::Message:
        *this >> result.flags;
        *this >> result.id;
        *this >> result.fromId;
        *this >> result.toId;
        if (result.flags & 1 << 2) {
            *this >> result.fwdFromId;
        }
        if (result.flags & 1 << 2) {
            *this >> result.fwdDate;
        }
        if (result.flags & 1 << 3) {
            *this >> result.replyToMsgId;
        }
        *this >> result.date;
        *this >> result.message;
        *this >> result.media;
        break;
    case TLValue::MessageService:
        *this >> result.flags;
        *this >> result.id;
        *this >> result.fromId;
        *this >> result.toId;
        *this >> result.date;
        *this >> result.action;
        break;
    default:
        break;
    }

    messageValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesDialogs &messagesDialogsValue)
{
    TLMessagesDialogs result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesDialogs:
        *this >> result.dialogs;
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    case TLValue::MessagesDialogsSlice:
        *this >> result.count;
        *this >> result.dialogs;
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    default:
        break;
    }

    messagesDialogsValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLMessagesMessages &messagesMessagesValue)
{
    TLMessagesMessages result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::MessagesMessages:
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    case TLValue::MessagesMessagesSlice:
        *this >> result.count;
        *this >> result.messages;
        *this >> result.chats;
        *this >> result.users;
        break;
    default:
        break;
    }

    messagesMessagesValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUpdate &updateValue)
{
    TLUpdate result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UpdateNewMessage:
        *this >> result.message;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    case TLValue::UpdateMessageID:
        *this >> result.id;
        *this >> result.randomId;
        break;
    case TLValue::UpdateDeleteMessages:
        *this >> result.messages;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    case TLValue::UpdateUserTyping:
        *this >> result.userId;
        *this >> result.action;
        break;
    case TLValue::UpdateChatUserTyping:
        *this >> result.chatId;
        *this >> result.userId;
        *this >> result.action;
        break;
    case TLValue::UpdateChatParticipants:
        *this >> result.participants;
        break;
    case TLValue::UpdateUserStatus:
        *this >> result.userId;
        *this >> result.status;
        break;
    case TLValue::UpdateUserName:
        *this >> result.userId;
        *this >> result.firstName;
        *this >> result.lastName;
        *this >> result.username;
        break;
    case TLValue::UpdateUserPhoto:
        *this >> result.userId;
        *this >> result.date;
        *this >> result.photo;
        *this >> result.previous;
        break;
    case TLValue::UpdateContactRegistered:
        *this >> result.userId;
        *this >> result.date;
        break;
    case TLValue::UpdateContactLink:
        *this >> result.userId;
        *this >> result.myLink;
        *this >> result.foreignLink;
        break;
    case TLValue::UpdateNewAuthorization:
        *this >> result.authKeyId;
        *this >> result.date;
        *this >> result.device;
        *this >> result.location;
        break;
    case TLValue::UpdateNewGeoChatMessage:
        *this >> result.messageGeoChat;
        break;
    case TLValue::UpdateNewEncryptedMessage:
        *this >> result.messageEncrypted;
        *this >> result.qts;
        break;
    case TLValue::UpdateEncryptedChatTyping:
        *this >> result.chatId;
        break;
    case TLValue::UpdateEncryption:
        *this >> result.chat;
        *this >> result.date;
        break;
    case TLValue::UpdateEncryptedMessagesRead:
        *this >> result.chatId;
        *this >> result.maxDate;
        *this >> result.date;
        break;
    case TLValue::UpdateChatParticipantAdd:
        *this >> result.chatId;
        *this >> result.userId;
        *this >> result.inviterId;
        *this >> result.version;
        break;
    case TLValue::UpdateChatParticipantDelete:
        *this >> result.chatId;
        *this >> result.userId;
        *this >> result.version;
        break;
    case TLValue::UpdateDcOptions:
        *this >> result.dcOptions;
        break;
    case TLValue::UpdateUserBlocked:
        *this >> result.userId;
        *this >> result.blocked;
        break;
    case TLValue::UpdateNotifySettings:
        *this >> result.peerNotify;
        *this >> result.notifySettings;
        break;
    case TLValue::UpdateServiceNotification:
        *this >> result.type;
        *this >> result.messageQString;
        *this >> result.media;
        *this >> result.popup;
        break;
    case TLValue::UpdatePrivacy:
        *this >> result.key;
        *this >> result.rules;
        break;
    case TLValue::UpdateUserPhone:
        *this >> result.userId;
        *this >> result.phone;
        break;
    case TLValue::UpdateReadHistoryInbox:
        *this >> result.peer;
        *this >> result.maxId;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    case TLValue::UpdateReadHistoryOutbox:
        *this >> result.peer;
        *this >> result.maxId;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    case TLValue::UpdateWebPage:
        *this >> result.webpage;
        break;
    case TLValue::UpdateReadMessagesContents:
        *this >> result.messages;
        *this >> result.pts;
        *this >> result.ptsCount;
        break;
    default:
        break;
    }

    updateValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUpdates &updatesValue)
{
    TLUpdates result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UpdatesTooLong:
        break;
    case TLValue::UpdateShortMessage:
        *this >> result.flags;
        *this >> result.id;
        *this >> result.userId;
        *this >> result.message;
        *this >> result.pts;
        *this >> result.ptsCount;
        *this >> result.date;
        if (result.flags & 1 << 2) {
            *this >> result.fwdFromId;
        }
        if (result.flags & 1 << 2) {
            *this >> result.fwdDate;
        }
        if (result.flags & 1 << 3) {
            *this >> result.replyToMsgId;
        }
        break;
    case TLValue::UpdateShortChatMessage:
        *this >> result.flags;
        *this >> result.id;
        *this >> result.fromId;
        *this >> result.chatId;
        *this >> result.message;
        *this >> result.pts;
        *this >> result.ptsCount;
        *this >> result.date;
        if (result.flags & 1 << 2) {
            *this >> result.fwdFromId;
        }
        if (result.flags & 1 << 2) {
            *this >> result.fwdDate;
        }
        if (result.flags & 1 << 3) {
            *this >> result.replyToMsgId;
        }
        break;
    case TLValue::UpdateShort:
        *this >> result.update;
        *this >> result.date;
        break;
    case TLValue::UpdatesCombined:
        *this >> result.updates;
        *this >> result.users;
        *this >> result.chats;
        *this >> result.date;
        *this >> result.seqStart;
        *this >> result.seq;
        break;
    case TLValue::Updates:
        *this >> result.updates;
        *this >> result.users;
        *this >> result.chats;
        *this >> result.date;
        *this >> result.seq;
        break;
    default:
        break;
    }

    updatesValue = result;

    return *this;
}

CTelegramStream &CTelegramStream::operator>>(TLUpdatesDifference &updatesDifferenceValue)
{
    TLUpdatesDifference result;

    *this >> result.tlType;

    switch (result.tlType) {
    case TLValue::UpdatesDifferenceEmpty:
        *this >> result.date;
        *this >> result.seq;
        break;
    case TLValue::UpdatesDifference:
        *this >> result.newMessages;
        *this >> result.newEncryptedMessages;
        *this >> result.otherUpdates;
        *this >> result.chats;
        *this >> result.users;
        *this >> result.state;
        break;
    case TLValue::UpdatesDifferenceSlice:
        *this >> result.newMessages;
        *this >> result.newEncryptedMessages;
        *this >> result.otherUpdates;
        *this >> result.chats;
        *this >> result.users;
        *this >> result.intermediateState;
        break;
    default:
        break;
    }

    updatesDifferenceValue = result;

    return *this;
}

// End of generated read operators implementation

template <typename T>
CTelegramStream &CTelegramStream::operator<<(const TLVector<T> &v)
{
    *this << v.tlType;

    if (v.tlType == TLValue::Vector) {
        *this << quint32(v.count());

        for (int i = 0; i < v.count(); ++i) {
            *this << v.at(i);
        }
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const QByteArray &data)
{
    quint32 length = data.size();

    if (length < 0xfe) {
        const char lengthToWrite = length;
        write(&lengthToWrite, 1);
        write(data.constData(), data.size());
        length += 1;
    } else {
        *this << quint32((length << 8) + 0xfe);
        write(data.constData(), data.size());
        length += 4;
    }

    if (length & 3) {
        write(s_nulls, 4 - (length & 3));
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLDcOption &dcOption)
{
    *this << dcOption.tlType;

    *this << dcOption.id;
    *this << dcOption.hostname;
    *this << dcOption.ipAddress;
    *this << dcOption.port;

    return *this;
}

// Generated write operators implementation
CTelegramStream &CTelegramStream::operator<<(const TLAccountDaysTTL &accountDaysTTLValue)
{
    *this << accountDaysTTLValue.tlType;

    switch (accountDaysTTLValue.tlType) {
    case TLValue::AccountDaysTTL:
        *this << accountDaysTTLValue.days;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLAccountPasswordInputSettings &accountPasswordInputSettingsValue)
{
    *this << accountPasswordInputSettingsValue.tlType;

    switch (accountPasswordInputSettingsValue.tlType) {
    case TLValue::AccountPasswordInputSettings:
        *this << accountPasswordInputSettingsValue.flags;
        if (accountPasswordInputSettingsValue.flags & 1 << 0) {
            *this << accountPasswordInputSettingsValue.newSalt;
        }
        if (accountPasswordInputSettingsValue.flags & 1 << 0) {
            *this << accountPasswordInputSettingsValue.newPasswordHash;
        }
        if (accountPasswordInputSettingsValue.flags & 1 << 0) {
            *this << accountPasswordInputSettingsValue.hint;
        }
        if (accountPasswordInputSettingsValue.flags & 1 << 1) {
            *this << accountPasswordInputSettingsValue.email;
        }
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputAppEvent &inputAppEventValue)
{
    *this << inputAppEventValue.tlType;

    switch (inputAppEventValue.tlType) {
    case TLValue::InputAppEvent:
        *this << inputAppEventValue.time;
        *this << inputAppEventValue.type;
        *this << inputAppEventValue.peer;
        *this << inputAppEventValue.data;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputAudio &inputAudioValue)
{
    *this << inputAudioValue.tlType;

    switch (inputAudioValue.tlType) {
    case TLValue::InputAudioEmpty:
        break;
    case TLValue::InputAudio:
        *this << inputAudioValue.id;
        *this << inputAudioValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputContact &inputContactValue)
{
    *this << inputContactValue.tlType;

    switch (inputContactValue.tlType) {
    case TLValue::InputPhoneContact:
        *this << inputContactValue.clientId;
        *this << inputContactValue.phone;
        *this << inputContactValue.firstName;
        *this << inputContactValue.lastName;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputDocument &inputDocumentValue)
{
    *this << inputDocumentValue.tlType;

    switch (inputDocumentValue.tlType) {
    case TLValue::InputDocumentEmpty:
        break;
    case TLValue::InputDocument:
        *this << inputDocumentValue.id;
        *this << inputDocumentValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputEncryptedChat &inputEncryptedChatValue)
{
    *this << inputEncryptedChatValue.tlType;

    switch (inputEncryptedChatValue.tlType) {
    case TLValue::InputEncryptedChat:
        *this << inputEncryptedChatValue.chatId;
        *this << inputEncryptedChatValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputEncryptedFile &inputEncryptedFileValue)
{
    *this << inputEncryptedFileValue.tlType;

    switch (inputEncryptedFileValue.tlType) {
    case TLValue::InputEncryptedFileEmpty:
        break;
    case TLValue::InputEncryptedFileUploaded:
        *this << inputEncryptedFileValue.id;
        *this << inputEncryptedFileValue.parts;
        *this << inputEncryptedFileValue.md5Checksum;
        *this << inputEncryptedFileValue.keyFingerprint;
        break;
    case TLValue::InputEncryptedFile:
        *this << inputEncryptedFileValue.id;
        *this << inputEncryptedFileValue.accessHash;
        break;
    case TLValue::InputEncryptedFileBigUploaded:
        *this << inputEncryptedFileValue.id;
        *this << inputEncryptedFileValue.parts;
        *this << inputEncryptedFileValue.keyFingerprint;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputFile &inputFileValue)
{
    *this << inputFileValue.tlType;

    switch (inputFileValue.tlType) {
    case TLValue::InputFile:
        *this << inputFileValue.id;
        *this << inputFileValue.parts;
        *this << inputFileValue.name;
        *this << inputFileValue.md5Checksum;
        break;
    case TLValue::InputFileBig:
        *this << inputFileValue.id;
        *this << inputFileValue.parts;
        *this << inputFileValue.name;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputFileLocation &inputFileLocationValue)
{
    *this << inputFileLocationValue.tlType;

    switch (inputFileLocationValue.tlType) {
    case TLValue::InputFileLocation:
        *this << inputFileLocationValue.volumeId;
        *this << inputFileLocationValue.localId;
        *this << inputFileLocationValue.secret;
        break;
    case TLValue::InputVideoFileLocation:
        *this << inputFileLocationValue.id;
        *this << inputFileLocationValue.accessHash;
        break;
    case TLValue::InputEncryptedFileLocation:
        *this << inputFileLocationValue.id;
        *this << inputFileLocationValue.accessHash;
        break;
    case TLValue::InputAudioFileLocation:
        *this << inputFileLocationValue.id;
        *this << inputFileLocationValue.accessHash;
        break;
    case TLValue::InputDocumentFileLocation:
        *this << inputFileLocationValue.id;
        *this << inputFileLocationValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputGeoChat &inputGeoChatValue)
{
    *this << inputGeoChatValue.tlType;

    switch (inputGeoChatValue.tlType) {
    case TLValue::InputGeoChat:
        *this << inputGeoChatValue.chatId;
        *this << inputGeoChatValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputGeoPoint &inputGeoPointValue)
{
    *this << inputGeoPointValue.tlType;

    switch (inputGeoPointValue.tlType) {
    case TLValue::InputGeoPointEmpty:
        break;
    case TLValue::InputGeoPoint:
        *this << inputGeoPointValue.latitude;
        *this << inputGeoPointValue.longitude;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPeer &inputPeerValue)
{
    *this << inputPeerValue.tlType;

    switch (inputPeerValue.tlType) {
    case TLValue::InputPeerEmpty:
        break;
    case TLValue::InputPeerSelf:
        break;
    case TLValue::InputPeerContact:
        *this << inputPeerValue.userId;
        break;
    case TLValue::InputPeerForeign:
        *this << inputPeerValue.userId;
        *this << inputPeerValue.accessHash;
        break;
    case TLValue::InputPeerChat:
        *this << inputPeerValue.chatId;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPeerNotifySettings &inputPeerNotifySettingsValue)
{
    *this << inputPeerNotifySettingsValue.tlType;

    switch (inputPeerNotifySettingsValue.tlType) {
    case TLValue::InputPeerNotifySettings:
        *this << inputPeerNotifySettingsValue.muteUntil;
        *this << inputPeerNotifySettingsValue.sound;
        *this << inputPeerNotifySettingsValue.showPreviews;
        *this << inputPeerNotifySettingsValue.eventsMask;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPhoto &inputPhotoValue)
{
    *this << inputPhotoValue.tlType;

    switch (inputPhotoValue.tlType) {
    case TLValue::InputPhotoEmpty:
        break;
    case TLValue::InputPhoto:
        *this << inputPhotoValue.id;
        *this << inputPhotoValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPhotoCrop &inputPhotoCropValue)
{
    *this << inputPhotoCropValue.tlType;

    switch (inputPhotoCropValue.tlType) {
    case TLValue::InputPhotoCropAuto:
        break;
    case TLValue::InputPhotoCrop:
        *this << inputPhotoCropValue.cropLeft;
        *this << inputPhotoCropValue.cropTop;
        *this << inputPhotoCropValue.cropWidth;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPrivacyKey &inputPrivacyKeyValue)
{
    *this << inputPrivacyKeyValue.tlType;

    switch (inputPrivacyKeyValue.tlType) {
    case TLValue::InputPrivacyKeyStatusTimestamp:
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputStickerSet &inputStickerSetValue)
{
    *this << inputStickerSetValue.tlType;

    switch (inputStickerSetValue.tlType) {
    case TLValue::InputStickerSetEmpty:
        break;
    case TLValue::InputStickerSetID:
        *this << inputStickerSetValue.id;
        *this << inputStickerSetValue.accessHash;
        break;
    case TLValue::InputStickerSetShortName:
        *this << inputStickerSetValue.shortName;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputUser &inputUserValue)
{
    *this << inputUserValue.tlType;

    switch (inputUserValue.tlType) {
    case TLValue::InputUserEmpty:
        break;
    case TLValue::InputUserSelf:
        break;
    case TLValue::InputUserContact:
        *this << inputUserValue.userId;
        break;
    case TLValue::InputUserForeign:
        *this << inputUserValue.userId;
        *this << inputUserValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputVideo &inputVideoValue)
{
    *this << inputVideoValue.tlType;

    switch (inputVideoValue.tlType) {
    case TLValue::InputVideoEmpty:
        break;
    case TLValue::InputVideo:
        *this << inputVideoValue.id;
        *this << inputVideoValue.accessHash;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLMessagesFilter &messagesFilterValue)
{
    *this << messagesFilterValue.tlType;

    switch (messagesFilterValue.tlType) {
    case TLValue::InputMessagesFilterEmpty:
        break;
    case TLValue::InputMessagesFilterPhotos:
        break;
    case TLValue::InputMessagesFilterVideo:
        break;
    case TLValue::InputMessagesFilterPhotoVideo:
        break;
    case TLValue::InputMessagesFilterPhotoVideoDocuments:
        break;
    case TLValue::InputMessagesFilterDocument:
        break;
    case TLValue::InputMessagesFilterAudio:
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLSendMessageAction &sendMessageActionValue)
{
    *this << sendMessageActionValue.tlType;

    switch (sendMessageActionValue.tlType) {
    case TLValue::SendMessageTypingAction:
        break;
    case TLValue::SendMessageCancelAction:
        break;
    case TLValue::SendMessageRecordVideoAction:
        break;
    case TLValue::SendMessageUploadVideoAction:
        *this << sendMessageActionValue.progress;
        break;
    case TLValue::SendMessageRecordAudioAction:
        break;
    case TLValue::SendMessageUploadAudioAction:
        *this << sendMessageActionValue.progress;
        break;
    case TLValue::SendMessageUploadPhotoAction:
        *this << sendMessageActionValue.progress;
        break;
    case TLValue::SendMessageUploadDocumentAction:
        *this << sendMessageActionValue.progress;
        break;
    case TLValue::SendMessageGeoLocationAction:
        break;
    case TLValue::SendMessageChooseContactAction:
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLDocumentAttribute &documentAttributeValue)
{
    *this << documentAttributeValue.tlType;

    switch (documentAttributeValue.tlType) {
    case TLValue::DocumentAttributeImageSize:
        *this << documentAttributeValue.w;
        *this << documentAttributeValue.h;
        break;
    case TLValue::DocumentAttributeAnimated:
        break;
    case TLValue::DocumentAttributeSticker:
        *this << documentAttributeValue.alt;
        *this << documentAttributeValue.stickerset;
        break;
    case TLValue::DocumentAttributeVideo:
        *this << documentAttributeValue.duration;
        *this << documentAttributeValue.w;
        *this << documentAttributeValue.h;
        break;
    case TLValue::DocumentAttributeAudio:
        *this << documentAttributeValue.duration;
        break;
    case TLValue::DocumentAttributeFilename:
        *this << documentAttributeValue.fileName;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputChatPhoto &inputChatPhotoValue)
{
    *this << inputChatPhotoValue.tlType;

    switch (inputChatPhotoValue.tlType) {
    case TLValue::InputChatPhotoEmpty:
        break;
    case TLValue::InputChatUploadedPhoto:
        *this << inputChatPhotoValue.file;
        *this << inputChatPhotoValue.crop;
        break;
    case TLValue::InputChatPhoto:
        *this << inputChatPhotoValue.id;
        *this << inputChatPhotoValue.crop;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputMedia &inputMediaValue)
{
    *this << inputMediaValue.tlType;

    switch (inputMediaValue.tlType) {
    case TLValue::InputMediaEmpty:
        break;
    case TLValue::InputMediaUploadedPhoto:
        *this << inputMediaValue.file;
        *this << inputMediaValue.caption;
        break;
    case TLValue::InputMediaPhoto:
        *this << inputMediaValue.idInputPhoto;
        *this << inputMediaValue.caption;
        break;
    case TLValue::InputMediaGeoPoint:
        *this << inputMediaValue.geoPoint;
        break;
    case TLValue::InputMediaContact:
        *this << inputMediaValue.phoneNumber;
        *this << inputMediaValue.firstName;
        *this << inputMediaValue.lastName;
        break;
    case TLValue::InputMediaUploadedVideo:
        *this << inputMediaValue.file;
        *this << inputMediaValue.duration;
        *this << inputMediaValue.w;
        *this << inputMediaValue.h;
        *this << inputMediaValue.caption;
        break;
    case TLValue::InputMediaUploadedThumbVideo:
        *this << inputMediaValue.file;
        *this << inputMediaValue.thumb;
        *this << inputMediaValue.duration;
        *this << inputMediaValue.w;
        *this << inputMediaValue.h;
        *this << inputMediaValue.caption;
        break;
    case TLValue::InputMediaVideo:
        *this << inputMediaValue.idInputVeo;
        *this << inputMediaValue.caption;
        break;
    case TLValue::InputMediaUploadedAudio:
        *this << inputMediaValue.file;
        *this << inputMediaValue.duration;
        *this << inputMediaValue.mimeType;
        break;
    case TLValue::InputMediaAudio:
        *this << inputMediaValue.idInputAudio;
        break;
    case TLValue::InputMediaUploadedDocument:
        *this << inputMediaValue.file;
        *this << inputMediaValue.mimeType;
        *this << inputMediaValue.attributes;
        break;
    case TLValue::InputMediaUploadedThumbDocument:
        *this << inputMediaValue.file;
        *this << inputMediaValue.thumb;
        *this << inputMediaValue.mimeType;
        *this << inputMediaValue.attributes;
        break;
    case TLValue::InputMediaDocument:
        *this << inputMediaValue.idInputDocument;
        break;
    case TLValue::InputMediaVenue:
        *this << inputMediaValue.geoPoint;
        *this << inputMediaValue.title;
        *this << inputMediaValue.address;
        *this << inputMediaValue.provider;
        *this << inputMediaValue.venueId;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputNotifyPeer &inputNotifyPeerValue)
{
    *this << inputNotifyPeerValue.tlType;

    switch (inputNotifyPeerValue.tlType) {
    case TLValue::InputNotifyPeer:
        *this << inputNotifyPeerValue.peerInput;
        break;
    case TLValue::InputNotifyUsers:
        break;
    case TLValue::InputNotifyChats:
        break;
    case TLValue::InputNotifyAll:
        break;
    case TLValue::InputNotifyGeoChatPeer:
        *this << inputNotifyPeerValue.peerInputGeoChat;
        break;
    default:
        break;
    }

    return *this;
}

CTelegramStream &CTelegramStream::operator<<(const TLInputPrivacyRule &inputPrivacyRuleValue)
{
    *this << inputPrivacyRuleValue.tlType;

    switch (inputPrivacyRuleValue.tlType) {
    case TLValue::InputPrivacyValueAllowContacts:
        break;
    case TLValue::InputPrivacyValueAllowAll:
        break;
    case TLValue::InputPrivacyValueAllowUsers:
        *this << inputPrivacyRuleValue.users;
        break;
    case TLValue::InputPrivacyValueDisallowContacts:
        break;
    case TLValue::InputPrivacyValueDisallowAll:
        break;
    case TLValue::InputPrivacyValueDisallowUsers:
        *this << inputPrivacyRuleValue.users;
        break;
    default:
        break;
    }

    return *this;
}

// End of generated write operators implementation
