/*
   Copyright (C) 2014-2015 Alexandr Akulich <akulichalexander@gmail.com>

   This file is a part of TelegramQt library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

 */

#ifndef CTELEGRAMSTREAM_HPP
#define CTELEGRAMSTREAM_HPP

#include <QVector>
#include <QString>

#include "CRawStream.hpp"
#include "TLTypes.hpp"

class CTelegramStream : public CRawStream
{
public:
    explicit CTelegramStream(QByteArray *data, bool write);
    explicit CTelegramStream(const QByteArray &data);

    explicit CTelegramStream(QIODevice *d = 0);

    using CRawStream::operator <<;
    using CRawStream::operator >>;

    CTelegramStream &operator>>(QByteArray &data);
    CTelegramStream &operator>>(QString &str);

    CTelegramStream &operator>>(bool &data);

    template <typename T>
    CTelegramStream &operator>>(TLVector<T> &v);

    // Generated read operators
    CTelegramStream &operator>>(TLAccountDaysTTL &accountDaysTTLValue);
    CTelegramStream &operator>>(TLAccountPassword &accountPasswordValue);
    CTelegramStream &operator>>(TLAccountPasswordInputSettings &accountPasswordInputSettingsValue);
    CTelegramStream &operator>>(TLAccountPasswordSettings &accountPasswordSettingsValue);
    CTelegramStream &operator>>(TLAccountSentChangePhoneCode &accountSentChangePhoneCodeValue);
    CTelegramStream &operator>>(TLAudio &audioValue);
    CTelegramStream &operator>>(TLAuthCheckedPhone &authCheckedPhoneValue);
    CTelegramStream &operator>>(TLAuthExportedAuthorization &authExportedAuthorizationValue);
    CTelegramStream &operator>>(TLAuthPasswordRecovery &authPasswordRecoveryValue);
    CTelegramStream &operator>>(TLAuthSentCode &authSentCodeValue);
    CTelegramStream &operator>>(TLAuthorization &authorizationValue);
    CTelegramStream &operator>>(TLChatLocated &chatLocatedValue);
    CTelegramStream &operator>>(TLChatParticipant &chatParticipantValue);
    CTelegramStream &operator>>(TLChatParticipants &chatParticipantsValue);
    CTelegramStream &operator>>(TLContact &contactValue);
    CTelegramStream &operator>>(TLContactBlocked &contactBlockedValue);
    CTelegramStream &operator>>(TLContactFound &contactFoundValue);
    CTelegramStream &operator>>(TLContactLink &contactLinkValue);
    CTelegramStream &operator>>(TLContactSuggested &contactSuggestedValue);
    CTelegramStream &operator>>(TLDcOption &dcOptionValue);
    CTelegramStream &operator>>(TLDisabledFeature &disabledFeatureValue);
    CTelegramStream &operator>>(TLEncryptedChat &encryptedChatValue);
    CTelegramStream &operator>>(TLEncryptedFile &encryptedFileValue);
    CTelegramStream &operator>>(TLEncryptedMessage &encryptedMessageValue);
    CTelegramStream &operator>>(TLError &errorValue);
    CTelegramStream &operator>>(TLExportedChatInvite &exportedChatInviteValue);
    CTelegramStream &operator>>(TLFileLocation &fileLocationValue);
    CTelegramStream &operator>>(TLGeoPoint &geoPointValue);
    CTelegramStream &operator>>(TLHelpAppUpdate &helpAppUpdateValue);
    CTelegramStream &operator>>(TLHelpInviteText &helpInviteTextValue);
    CTelegramStream &operator>>(TLImportedContact &importedContactValue);
    CTelegramStream &operator>>(TLInputAppEvent &inputAppEventValue);
    CTelegramStream &operator>>(TLInputAudio &inputAudioValue);
    CTelegramStream &operator>>(TLInputContact &inputContactValue);
    CTelegramStream &operator>>(TLInputDocument &inputDocumentValue);
    CTelegramStream &operator>>(TLInputEncryptedChat &inputEncryptedChatValue);
    CTelegramStream &operator>>(TLInputEncryptedFile &inputEncryptedFileValue);
    CTelegramStream &operator>>(TLInputFile &inputFileValue);
    CTelegramStream &operator>>(TLInputFileLocation &inputFileLocationValue);
    CTelegramStream &operator>>(TLInputGeoChat &inputGeoChatValue);
    CTelegramStream &operator>>(TLInputGeoPoint &inputGeoPointValue);
    CTelegramStream &operator>>(TLInputPeer &inputPeerValue);
    CTelegramStream &operator>>(TLInputPeerNotifyEvents &inputPeerNotifyEventsValue);
    CTelegramStream &operator>>(TLInputPeerNotifySettings &inputPeerNotifySettingsValue);
    CTelegramStream &operator>>(TLInputPhoto &inputPhotoValue);
    CTelegramStream &operator>>(TLInputPhotoCrop &inputPhotoCropValue);
    CTelegramStream &operator>>(TLInputPrivacyKey &inputPrivacyKeyValue);
    CTelegramStream &operator>>(TLInputStickerSet &inputStickerSetValue);
    CTelegramStream &operator>>(TLInputUser &inputUserValue);
    CTelegramStream &operator>>(TLInputVideo &inputVideoValue);
    CTelegramStream &operator>>(TLMessagesAffectedHistory &messagesAffectedHistoryValue);
    CTelegramStream &operator>>(TLMessagesAffectedMessages &messagesAffectedMessagesValue);
    CTelegramStream &operator>>(TLMessagesDhConfig &messagesDhConfigValue);
    CTelegramStream &operator>>(TLMessagesFilter &messagesFilterValue);
    CTelegramStream &operator>>(TLMessagesSentEncryptedMessage &messagesSentEncryptedMessageValue);
    CTelegramStream &operator>>(TLNearestDc &nearestDcValue);
    CTelegramStream &operator>>(TLPeer &peerValue);
    CTelegramStream &operator>>(TLPeerNotifyEvents &peerNotifyEventsValue);
    CTelegramStream &operator>>(TLPeerNotifySettings &peerNotifySettingsValue);
    CTelegramStream &operator>>(TLPhotoSize &photoSizeValue);
    CTelegramStream &operator>>(TLPrivacyKey &privacyKeyValue);
    CTelegramStream &operator>>(TLPrivacyRule &privacyRuleValue);
    CTelegramStream &operator>>(TLReceivedNotifyMessage &receivedNotifyMessageValue);
    CTelegramStream &operator>>(TLSendMessageAction &sendMessageActionValue);
    CTelegramStream &operator>>(TLStickerPack &stickerPackValue);
    CTelegramStream &operator>>(TLStickerSet &stickerSetValue);
    CTelegramStream &operator>>(TLStorageFileType &storageFileTypeValue);
    CTelegramStream &operator>>(TLUpdatesState &updatesStateValue);
    CTelegramStream &operator>>(TLUploadFile &uploadFileValue);
    CTelegramStream &operator>>(TLUserProfilePhoto &userProfilePhotoValue);
    CTelegramStream &operator>>(TLUserStatus &userStatusValue);
    CTelegramStream &operator>>(TLVideo &videoValue);
    CTelegramStream &operator>>(TLWallPaper &wallPaperValue);
    CTelegramStream &operator>>(TLAccountAuthorizations &accountAuthorizationsValue);
    CTelegramStream &operator>>(TLChatPhoto &chatPhotoValue);
    CTelegramStream &operator>>(TLConfig &configValue);
    CTelegramStream &operator>>(TLContactStatus &contactStatusValue);
    CTelegramStream &operator>>(TLDialog &dialogValue);
    CTelegramStream &operator>>(TLDocumentAttribute &documentAttributeValue);
    CTelegramStream &operator>>(TLInputChatPhoto &inputChatPhotoValue);
    CTelegramStream &operator>>(TLInputMedia &inputMediaValue);
    CTelegramStream &operator>>(TLInputNotifyPeer &inputNotifyPeerValue);
    CTelegramStream &operator>>(TLInputPrivacyRule &inputPrivacyRuleValue);
    CTelegramStream &operator>>(TLNotifyPeer &notifyPeerValue);
    CTelegramStream &operator>>(TLPhoto &photoValue);
    CTelegramStream &operator>>(TLUser &userValue);
    CTelegramStream &operator>>(TLWebPage &webPageValue);
    CTelegramStream &operator>>(TLAccountPrivacyRules &accountPrivacyRulesValue);
    CTelegramStream &operator>>(TLAuthAuthorization &authAuthorizationValue);
    CTelegramStream &operator>>(TLChat &chatValue);
    CTelegramStream &operator>>(TLChatFull &chatFullValue);
    CTelegramStream &operator>>(TLChatInvite &chatInviteValue);
    CTelegramStream &operator>>(TLContactsBlocked &contactsBlockedValue);
    CTelegramStream &operator>>(TLContactsContacts &contactsContactsValue);
    CTelegramStream &operator>>(TLContactsFound &contactsFoundValue);
    CTelegramStream &operator>>(TLContactsImportedContacts &contactsImportedContactsValue);
    CTelegramStream &operator>>(TLContactsLink &contactsLinkValue);
    CTelegramStream &operator>>(TLContactsSuggested &contactsSuggestedValue);
    CTelegramStream &operator>>(TLDocument &documentValue);
    CTelegramStream &operator>>(TLHelpSupport &helpSupportValue);
    CTelegramStream &operator>>(TLMessageAction &messageActionValue);
    CTelegramStream &operator>>(TLMessageMedia &messageMediaValue);
    CTelegramStream &operator>>(TLMessagesAllStickers &messagesAllStickersValue);
    CTelegramStream &operator>>(TLMessagesChatFull &messagesChatFullValue);
    CTelegramStream &operator>>(TLMessagesChats &messagesChatsValue);
    CTelegramStream &operator>>(TLMessagesSentMessage &messagesSentMessageValue);
    CTelegramStream &operator>>(TLMessagesStickerSet &messagesStickerSetValue);
    CTelegramStream &operator>>(TLMessagesStickers &messagesStickersValue);
    CTelegramStream &operator>>(TLPhotosPhoto &photosPhotoValue);
    CTelegramStream &operator>>(TLPhotosPhotos &photosPhotosValue);
    CTelegramStream &operator>>(TLUserFull &userFullValue);
    CTelegramStream &operator>>(TLGeoChatMessage &geoChatMessageValue);
    CTelegramStream &operator>>(TLGeochatsLocated &geochatsLocatedValue);
    CTelegramStream &operator>>(TLGeochatsMessages &geochatsMessagesValue);
    CTelegramStream &operator>>(TLGeochatsStatedMessage &geochatsStatedMessageValue);
    CTelegramStream &operator>>(TLMessage &messageValue);
    CTelegramStream &operator>>(TLMessagesDialogs &messagesDialogsValue);
    CTelegramStream &operator>>(TLMessagesMessages &messagesMessagesValue);
    CTelegramStream &operator>>(TLUpdate &updateValue);
    CTelegramStream &operator>>(TLUpdates &updatesValue);
    CTelegramStream &operator>>(TLUpdatesDifference &updatesDifferenceValue);
    // End of generated read operators

    CTelegramStream &operator<<(const QByteArray &data);
    CTelegramStream &operator<<(const QString &str);

    CTelegramStream &operator<<(const bool &data);

    CTelegramStream &operator<<(const TLDcOption &dcOption);

    // Generated write operators
    CTelegramStream &operator<<(const TLAccountDaysTTL &accountDaysTTLValue);
    CTelegramStream &operator<<(const TLAccountPasswordInputSettings &accountPasswordInputSettingsValue);
    CTelegramStream &operator<<(const TLInputAppEvent &inputAppEventValue);
    CTelegramStream &operator<<(const TLInputAudio &inputAudioValue);
    CTelegramStream &operator<<(const TLInputContact &inputContactValue);
    CTelegramStream &operator<<(const TLInputDocument &inputDocumentValue);
    CTelegramStream &operator<<(const TLInputEncryptedChat &inputEncryptedChatValue);
    CTelegramStream &operator<<(const TLInputEncryptedFile &inputEncryptedFileValue);
    CTelegramStream &operator<<(const TLInputFile &inputFileValue);
    CTelegramStream &operator<<(const TLInputFileLocation &inputFileLocationValue);
    CTelegramStream &operator<<(const TLInputGeoChat &inputGeoChatValue);
    CTelegramStream &operator<<(const TLInputGeoPoint &inputGeoPointValue);
    CTelegramStream &operator<<(const TLInputPeer &inputPeerValue);
    CTelegramStream &operator<<(const TLInputPeerNotifySettings &inputPeerNotifySettingsValue);
    CTelegramStream &operator<<(const TLInputPhoto &inputPhotoValue);
    CTelegramStream &operator<<(const TLInputPhotoCrop &inputPhotoCropValue);
    CTelegramStream &operator<<(const TLInputPrivacyKey &inputPrivacyKeyValue);
    CTelegramStream &operator<<(const TLInputStickerSet &inputStickerSetValue);
    CTelegramStream &operator<<(const TLInputUser &inputUserValue);
    CTelegramStream &operator<<(const TLInputVideo &inputVideoValue);
    CTelegramStream &operator<<(const TLMessagesFilter &messagesFilterValue);
    CTelegramStream &operator<<(const TLSendMessageAction &sendMessageActionValue);
    CTelegramStream &operator<<(const TLDocumentAttribute &documentAttributeValue);
    CTelegramStream &operator<<(const TLInputChatPhoto &inputChatPhotoValue);
    CTelegramStream &operator<<(const TLInputMedia &inputMediaValue);
    CTelegramStream &operator<<(const TLInputNotifyPeer &inputNotifyPeerValue);
    CTelegramStream &operator<<(const TLInputPrivacyRule &inputPrivacyRuleValue);
    // End of generated write operators

    template <typename T>
    CTelegramStream &operator<<(const TLVector<T> &v);

};

inline CTelegramStream &CTelegramStream::operator>>(QString &str)
{
    QByteArray data;
    *this >> data;
    str = QString::fromUtf8(data);
    return *this;
}

inline CTelegramStream &CTelegramStream::operator>>(bool &data)
{
    TLValue val;
    *this >> val;

    if (val == TLValue::BoolTrue) {
        data = true;
    } else if (val == TLValue::BoolFalse) {
        data = false;
    }

    return *this;
}

inline CTelegramStream &CTelegramStream::operator<<(const QString &str)
{
    return *this << str.toUtf8();
}

inline CTelegramStream &CTelegramStream::operator<<(const bool &data)
{
    if (data) {
        *this << TLValue::BoolTrue;
    } else {
        *this << TLValue::BoolFalse;
    }

    return *this;
}

#endif // CTELEGRAMSTREAM_HPP
