
Telepathy-Morse
================

Morse is a Qt-based Telegram connection manager for the Telepathy framework.

Features
========

* Contact list with first/last names
* Contact avatars
* Contact management (you can add/delete contact by its phone number)
* Personal messaging (one to one)
* User typing events
* Message acknowledgment
* Own presence (online, offline, hidden)
* Loading unread messages on connect
* DBus activation
* Sessions (Means that you don't have to get confirmation code again and again)
* Restoring connection on network problem

Experimental features:
* Group chat (Enabled for TelepathyQt-0.9.7+)

Requirements
============

* CMake-2.8.12+ (required by TelepathyQt)
* Qt4 or Qt5
* TelepathyQt-0.9.6+
* TelegramQt

Note: TelegramQt is not released yet. You can download (clone) it from https://github.com/Kaffeine/telegram-qt.git

Note: In order to use Morse, you need to have a complementary Telepathy Client application, such as KDE-Telepathy or Empathy.

Installation
============

    git clone https://github.com/TelepathyQt/telepathy-morse.git

or

    tar -xf telepathy-morse-0.1.0.tar.bz2

    mkdir morse-build
    cd morse-build
    cmake ../telepathy-morse

Information about CMake build:
* By default CMake looks for the Qt5 build. You can pass USE_QT4 option (-DUSE_QT4=true) to process Qt4 build.
* Default installation prefix is /usr/local. Probably, you'll need to set CMAKE_INSTALL_PREFIX to /usr to make DBus activation works. (-DCMAKE_INSTALL_PREFIX=/usr)

<!-- markdown "code after list" workaround -->

    make -j4
    make install

Known issues
============

* Initial low-level encryption sometimes generates bad random values, which rarely can leads to “connection doesn’t work” issue.
* Unable to send long messages (Missed TelegramQt gzip packing implementation; limit is about 400 characters; telegram protocol limitation is 4095 characters).
* Authentication doesn't work on the Sailfish OS (show-stopper).

License
=======

This application is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License,
or (at your option) any later version.
