# TeXstudio [![Codacy Badge](https://app.codacy.com/project/badge/Grade/892de515e8c54a7a99bd836743c4510c)](https://www.codacy.com/gh/texstudio-org/texstudio/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=texstudio-org/texstudio&amp;utm_campaign=Badge_Grade) ![CI](https://github.com/texstudio-org/texstudio/workflows/CI/badge.svg)

TeXstudio is a fully featured LaTeX editor. Our goal is to make writing LaTeX documents as easy and comfortable as possible. Some of the outstanding features of TeXstudio are an integrated pdf viewer with (almost) word-level synchronization, live inline preview, advanced syntax-highlighting, live checking of references, citations, latex commands, spelling and grammar. Find out more at our website.

## Features


### Comfortable Editing


* Multi-Cursors


Edit multiple positions at the same time. Vertical blocks can even be copied and pasted.

<p align="center">
<img alt="Multi-Cursors" src="https://texstudio.org/images/block-cursor.png"> </p>

* Auto completion


Suggests possible LaTeX commands as you type. There is a tooltip help explaining the command.

Completion works also for references and bibliography entries.

<p align="center">
<img alt="Auto completion" src="https://texstudio.org/images/autocompletion-help.png"> </p>

* More than 1000 mathematical symbols


Quick access to more than 1000 mathematical symbols.

<p align="center"><img alt="Symbols" src="https://texstudio.org/images/symbols.png"> </p>

* Bookmarks


Use bookmarks to keep references to important places in your text and to navigate there quickly.

Tooltips show a preview of the code position.

<p align="center"><img alt="Bookmarks" src="https://texstudio.org/images/bookmarks.png"> </p>

* Link overlays


Filenames, references and citations turn into links when moving the mouse over them while holding <Ctrl>.

Also here, tooltips show a preview of the code position.

<p align="center"><img alt="Link overlays" src="https://texstudio.org/images/link-overlay.png"> </p>

* Assistants for images, tables, formulas, ...


Generate blocks of code using assistants without the need for detailed LaTeX knowledge.

<p align="center"><img alt="assistants" src="https://texstudio.org/images/assistants.png"> </p>

* Drag & drop support for images

When you drag an image on the editor the image assistant opens. From there it's just one more click to have the code for the image inclusion. Of course, we try to make the paths relative. This also works with multiple images.

<p align="center"><img alt="drag & drop" src="https://texstudio.org/images/dragdropimages.png"> </p>

* Table-formatting


You can copy / paste / insert new table columns with a single click.

The table-autoformatter aligns the table code.

<p align="center"><img alt="table formatting" src="https://texstudio.org/images/table-formating.png"> </p>

### Keep The Overview


*  Structure view
*  Code folding
*  Advanced syntax highlighting
*  Interactive spellchecker
*  Interactive grammar checker
*  Interactive reference checker
*  Clear display of LaTeX errors and warnings (in editor and as list)

<p align="center"><img alt="Inline Checking" src="https://texstudio.org/images/inlineChecking_zoom.png"> </p>

### Advanced build system


* Built-in support for various LaTeX compilers, index, bibliography and glossary tools, Latexmk, and many more
* Automatic detection of the need for multiple LaTeX runs
* Run any program you like
* Completely customizable for the creation of the complete document

<p align="center"><img alt="Error Highlighting" src="https://texstudio.org/images/errorHighlighting_zoom.png"> </p>

### View The Result


* Integrated PDF viewer with (almost) word-level syncing
* Live-updating inline preview for formulas and code segments
* Tooltip preview for included images


### Easy Setup


* Installers or packages available for Windows, Linux and Mac OS X
* Portable USB version available
* Automatic detection of MikTeX, TeX Live, Ghostscript and Standardlatex
* SVN support

## Participate

As an open source project TeXstudio strongly benefits from an active community.

### Use and spread the word

The easiest way to help on the development with TeXstudio is to use it! Furthermore, if you like TeXstudio, tell all your friends and colleagues about it.

In particular we are looking for people who want to try the most recent features before they are officially released. If you are interested download and subscribe to [release candidates and development snapshots](https://texstudio.org/#snapshots).

### Give Feedback

User feedback is highly welcome. Depending on the type of feedback you may use different channels to communicate.

*  Feature requests, bug reports and questions can be placed in the [issue tracker](https://github.com/texstudio-org/texstudio/issues).
In case of a bug report, please state version and operation system and a description which allows to reproduce the issue on another computer.

### Contribute

You do not necessarily have to be a programmer to help and make TeXstudio even better. There are many ways to contribute.

* Write cwl-files for your favorite package.
* [Translate](https://www.transifex.com/texstudio/texstudio/) TeXstudio into a new language or update an existing translation.
* Design icons.
* Help on improving our website.
* Update or extend the [user manual](https://htmlpreview.github.io/?https://github.com/texstudio-org/texstudio/master/utilities/manual/usermanual_en.html) or [the wiki](https://github.com/texstudio-org/texstudio/wiki).
* Write tutorials or create screencasts.
* Package TeXstudio for your favorite distribution or platform.
* TeXstudio is written in C++/Qt. Programmers are welcome to implement new features or fix bugs. Code development takes place on github. Pull-requests, direct patches or changed files are welcome.

It is a good idea to announce your plans on the texstudio issue list. So everybody knows what's going on around TeXstudio and there is no duplicate work. For questions how you can contribute contact one of the developers.


[TeXstudio - A LaTeX Editor Web Site](http://www.texstudio.org)
