#!/usr/bin/python
# Unicorn Emulator Engine
# By Dang Hoang Vu & Nguyen Anh Quynh

# syntax: ./header_gen.py <arm|aarch64|x86|name>

import sys

symbols = (
    'arm_release',
    'aarch64_tb_set_jmp_target',
    'ppc_tb_set_jmp_target',
    'use_idiv_instructions_rt',
    'tcg_target_deposit_valid',
    'helper_power_down',
    'check_exit_request',
    'address_space_unregister',
    'tb_invalidate_phys_page_fast',
    'phys_mem_clean',
    'tb_cleanup',
    'memory_map',
    'memory_map_ptr',
    'memory_unmap',
    'memory_free',
    'free_code_gen_buffer',
    'helper_raise_exception',
    'tcg_enabled',
    'tcg_exec_init',
    'memory_register_types',
    'cpu_exec_init_all',
    'vm_start',
    'resume_all_vcpus',
    'a15_l2ctlr_read',
    'a64_translate_init',
    'aa32_generate_debug_exceptions',
    'aa64_cacheop_access',
    'aa64_daif_access',
    'aa64_daif_write',
    'aa64_dczid_read',
    'aa64_fpcr_read',
    'aa64_fpcr_write',
    'aa64_fpsr_read',
    'aa64_fpsr_write',
    'aa64_generate_debug_exceptions',
    'aa64_zva_access',
    'aarch64_banked_spsr_index',
    'aarch64_restore_sp',
    'aarch64_save_sp',
    'accel_find',
    'accel_init_machine',
    'accel_type',
    'access_with_adjusted_size',
    'add128',
    'add16_sat',
    'add16_usat',
    'add192',
    'add8_sat',
    'add8_usat',
    'add_cpreg_to_hashtable',
    'add_cpreg_to_list',
    'addFloat128Sigs',
    'addFloat32Sigs',
    'addFloat64Sigs',
    'addFloatx80Sigs',
    'add_qemu_ldst_label',
    'address_space_access_valid',
    'address_space_destroy',
    'address_space_destroy_dispatch',
    'address_space_get_flatview',
    'address_space_init',
    'address_space_init_dispatch',
    'address_space_lookup_region',
    'address_space_map',
    'address_space_read',
    'address_space_rw',
    'address_space_translate',
    'address_space_translate_for_iotlb',
    'address_space_translate_internal',
    'address_space_unmap',
    'address_space_update_topology',
    'address_space_update_topology_pass',
    'address_space_write',
    'addrrange_contains',
    'addrrange_end',
    'addrrange_equal',
    'addrrange_intersection',
    'addrrange_intersects',
    'addrrange_make',
    'adjust_endianness',
    'all_helpers',
    'alloc_code_gen_buffer',
    'alloc_entry',
    'always_true',
    'arm1026_initfn',
    'arm1136_initfn',
    'arm1136_r2_initfn',
    'arm1176_initfn',
    'arm11mpcore_initfn',
    'arm926_initfn',
    'arm946_initfn',
    'arm_ccnt_enabled',
    'arm_cp_read_zero',
    'arm_cp_reset_ignore',
    'arm_cpu_do_interrupt',
    'arm_cpu_exec_interrupt',
    'arm_cpu_finalizefn',
    'arm_cpu_get_phys_page_debug',
    'arm_cpu_handle_mmu_fault',
    'arm_cpu_initfn',
    'arm_cpu_list',
    'cpu_loop_exit',
    'arm_cpu_post_init',
    'arm_cpu_realizefn',
    'arm_cpu_register_gdb_regs_for_features',
    'arm_cpu_register_types',
    'cpu_resume_from_signal',
    'arm_cpus',
    'arm_cpu_set_pc',
    'arm_cp_write_ignore',
    'arm_current_el',
    'arm_dc_feature',
    'arm_debug_excp_handler',
    'arm_debug_target_el',
    'arm_el_is_aa64',
    'arm_env_get_cpu',
    'arm_excp_target_el',
    'arm_excp_unmasked',
    'arm_feature',
    'arm_generate_debug_exceptions',
    'gen_intermediate_code',
    'gen_intermediate_code_pc',
    'arm_gen_test_cc',
    'arm_gt_ptimer_cb',
    'arm_gt_vtimer_cb',
    'arm_handle_psci_call',
    'arm_is_psci_call',
    'arm_is_secure',
    'arm_is_secure_below_el3',
    'arm_ldl_code',
    'arm_lduw_code',
    'arm_log_exception',
    'arm_reg_read',
    'arm_reg_reset',
    'arm_reg_write',
    'restore_state_to_opc',
    'arm_rmode_to_sf',
    'arm_singlestep_active',
    'tlb_fill',
    'tlb_flush',
    'tlb_flush_page',
    'tlb_set_page',
    'arm_translate_init',
    'arm_v7m_class_init',
    'arm_v7m_cpu_do_interrupt',
    'ats_access',
    'ats_write',
    'bad_mode_switch',
    'bank_number',
    'bitmap_zero_extend',
    'bp_wp_matches',
    'breakpoint_invalidate',
    'build_page_bitmap',
    'bus_add_child',
    'bus_class_init',
    'bus_info',
    'bus_unparent',
    'cache_block_ops_cp_reginfo',
    'cache_dirty_status_cp_reginfo',
    'cache_test_clean_cp_reginfo',
    'call_recip_estimate',
    'can_merge',
    'capacity_increase',
    'ccsidr_read',
    'check_ap',
    'check_breakpoints',
    'check_watchpoints',
    'cho',
    'clear_bit',
    'clz32',
    'clz64',
    'cmp_flatrange_addr',
    'code_gen_alloc',
    'commonNaNToFloat128',
    'commonNaNToFloat16',
    'commonNaNToFloat32',
    'commonNaNToFloat64',
    'commonNaNToFloatx80',
    'compute_abs_deadline',
    'cond_name',
    'configure_accelerator',
    'container_get',
    'container_info',
    'container_register_types',
    'contextidr_write',
    'core_log_global_start',
    'core_log_global_stop',
    'core_memory_listener',
    'cortexa15_cp_reginfo',
    'cortex_a15_initfn',
    'cortexa8_cp_reginfo',
    'cortex_a8_initfn',
    'cortexa9_cp_reginfo',
    'cortex_a9_initfn',
    'cortex_m3_initfn',
    'count_cpreg',
    'countLeadingZeros32',
    'countLeadingZeros64',
    'cp_access_ok',
    'cpacr_write',
    'cpreg_field_is_64bit',
    'cp_reginfo',
    'cpreg_key_compare',
    'cpreg_make_keylist',
    'cp_reg_reset',
    'cpreg_to_kvm_id',
    'cpsr_read',
    'cpsr_write',
    'cptype_valid',
    'cpu_abort',
    'cpu_arm_exec',
    'cpu_arm_gen_code',
    'cpu_arm_init',
    'cpu_breakpoint_insert',
    'cpu_breakpoint_remove',
    'cpu_breakpoint_remove_all',
    'cpu_breakpoint_remove_by_ref',
    'cpu_can_do_io',
    'cpu_can_run',
    'cpu_class_init',
    'cpu_common_class_by_name',
    'cpu_common_exec_interrupt',
    'cpu_common_get_arch_id',
    'cpu_common_get_memory_mapping',
    'cpu_common_get_paging_enabled',
    'cpu_common_has_work',
    'cpu_common_initfn',
    'cpu_common_noop',
    'cpu_common_parse_features',
    'cpu_common_realizefn',
    'cpu_common_reset',
    'cpu_dump_statistics',
    'cpu_exec_init',
    'cpu_flush_icache_range',
    'cpu_gen_init',
    'cpu_get_clock',
    'cpu_get_real_ticks',
    'cpu_get_tb_cpu_state',
    'cpu_handle_debug_exception',
    'cpu_handle_guest_debug',
    'cpu_inb',
    'cpu_inl',
    'cpu_interrupt',
    'cpu_interrupt_handler',
    'cpu_inw',
    'cpu_io_recompile',
    'cpu_is_stopped',
    'cpu_ldl_code',
    'cpu_ldub_code',
    'cpu_lduw_code',
    'cpu_memory_rw_debug',
    'cpu_mmu_index',
    'cpu_outb',
    'cpu_outl',
    'cpu_outw',
    'cpu_physical_memory_clear_dirty_range',
    'cpu_physical_memory_get_clean',
    'cpu_physical_memory_get_dirty',
    'cpu_physical_memory_get_dirty_flag',
    'cpu_physical_memory_is_clean',
    'cpu_physical_memory_is_io',
    'cpu_physical_memory_map',
    'cpu_physical_memory_range_includes_clean',
    'cpu_physical_memory_reset_dirty',
    'cpu_physical_memory_rw',
    'cpu_physical_memory_set_dirty_flag',
    'cpu_physical_memory_set_dirty_range',
    'cpu_physical_memory_unmap',
    'cpu_physical_memory_write_rom',
    'cpu_physical_memory_write_rom_internal',
    'cpu_register',
    'cpu_register_types',
    'cpu_restore_state',
    'cpu_restore_state_from_tb',
    'cpu_single_step',
    'cpu_tb_exec',
    'cpu_tlb_reset_dirty_all',
    'cpu_to_be64',
    'cpu_to_le32',
    'cpu_to_le64',
    'cpu_type_info',
    'cpu_unassigned_access',
    'cpu_watchpoint_address_matches',
    'cpu_watchpoint_insert',
    'cpu_watchpoint_remove',
    'cpu_watchpoint_remove_all',
    'cpu_watchpoint_remove_by_ref',
    'crc32c_table',
    'create_new_memory_mapping',
    'csselr_write',
    'cto32',
    'ctr_el0_access',
    'ctz32',
    'ctz64',
    'dacr_write',
    'dbgbcr_write',
    'dbgbvr_write',
    'dbgwcr_write',
    'dbgwvr_write',
    'debug_cp_reginfo',
    'debug_frame',
    'debug_lpae_cp_reginfo',
    'define_arm_cp_regs',
    'define_arm_cp_regs_with_opaque',
    'define_debug_regs',
    'define_one_arm_cp_reg',
    'define_one_arm_cp_reg_with_opaque',
    'deposit32',
    'deposit64',
    'deregister_tm_clones',
    'device_class_base_init',
    'device_class_init',
    'device_finalize',
    'device_get_realized',
    'device_initfn',
    'device_post_init',
    'device_reset',
    'device_set_realized',
    'device_type_info',
    'disas_arm_insn',
    'disas_coproc_insn',
    'disas_dsp_insn',
    'disas_iwmmxt_insn',
    'disas_neon_data_insn',
    'disas_neon_ls_insn',
    'disas_thumb2_insn',
    'disas_thumb_insn',
    'disas_vfp_insn',
    'disas_vfp_v8_insn',
    'do_arm_semihosting',
    'do_clz16',
    'do_clz8',
    'do_constant_folding',
    'do_constant_folding_2',
    'do_constant_folding_cond',
    'do_constant_folding_cond2',
    'do_constant_folding_cond_32',
    'do_constant_folding_cond_64',
    'do_constant_folding_cond_eq',
    'do_fcvt_f16_to_f32',
    'do_fcvt_f32_to_f16',
    'do_ssat',
    'do_usad',
    'do_usat',
    'do_v7m_exception_exit',
    'dummy_c15_cp_reginfo',
    'dummy_func',
    'dummy_section',
    '_DYNAMIC',
    '_edata',
    '_end',
    'end_list',
    'eq128',
    'ErrorClass_lookup',
    'error_copy',
    'error_exit',
    'error_get_class',
    'error_get_pretty',
    'error_setg_file_open',
    'estimateDiv128To64',
    'estimateSqrt32',
    'excnames',
    'excp_is_internal',
    'extended_addresses_enabled',
    'extended_mpu_ap_bits',
    'extract32',
    'extract64',
    'extractFloat128Exp',
    'extractFloat128Frac0',
    'extractFloat128Frac1',
    'extractFloat128Sign',
    'extractFloat16Exp',
    'extractFloat16Frac',
    'extractFloat16Sign',
    'extractFloat32Exp',
    'extractFloat32Frac',
    'extractFloat32Sign',
    'extractFloat64Exp',
    'extractFloat64Frac',
    'extractFloat64Sign',
    'extractFloatx80Exp',
    'extractFloatx80Frac',
    'extractFloatx80Sign',
    'fcse_write',
    'find_better_copy',
    'find_default_machine',
    'find_desc_by_name',
    'find_first_bit',
    'find_paging_enabled_cpu',
    'find_ram_block',
    'find_ram_offset',
    'find_string',
    'find_type',
    '_fini',
    'flatrange_equal',
    'flatview_destroy',
    'flatview_init',
    'flatview_insert',
    'flatview_lookup',
    'flatview_ref',
    'flatview_simplify',
    'flatview_unref',
    'float128_add',
    'float128_compare',
    'float128_compare_internal',
    'float128_compare_quiet',
    'float128_default_nan',
    'float128_div',
    'float128_eq',
    'float128_eq_quiet',
    'float128_is_quiet_nan',
    'float128_is_signaling_nan',
    'float128_le',
    'float128_le_quiet',
    'float128_lt',
    'float128_lt_quiet',
    'float128_maybe_silence_nan',
    'float128_mul',
    'float128_rem',
    'float128_round_to_int',
    'float128_scalbn',
    'float128_sqrt',
    'float128_sub',
    'float128ToCommonNaN',
    'float128_to_float32',
    'float128_to_float64',
    'float128_to_floatx80',
    'float128_to_int32',
    'float128_to_int32_round_to_zero',
    'float128_to_int64',
    'float128_to_int64_round_to_zero',
    'float128_unordered',
    'float128_unordered_quiet',
    'float16_default_nan',
    'float16_is_quiet_nan',
    'float16_is_signaling_nan',
    'float16_maybe_silence_nan',
    'float16ToCommonNaN',
    'float16_to_float32',
    'float16_to_float64',
    'float32_abs',
    'float32_add',
    'float32_chs',
    'float32_compare',
    'float32_compare_internal',
    'float32_compare_quiet',
    'float32_default_nan',
    'float32_div',
    'float32_eq',
    'float32_eq_quiet',
    'float32_exp2',
    'float32_exp2_coefficients',
    'float32_is_any_nan',
    'float32_is_infinity',
    'float32_is_neg',
    'float32_is_quiet_nan',
    'float32_is_signaling_nan',
    'float32_is_zero',
    'float32_is_zero_or_denormal',
    'float32_le',
    'float32_le_quiet',
    'float32_log2',
    'float32_lt',
    'float32_lt_quiet',
    'float32_max',
    'float32_maxnum',
    'float32_maxnummag',
    'float32_maybe_silence_nan',
    'float32_min',
    'float32_minmax',
    'float32_minnum',
    'float32_minnummag',
    'float32_mul',
    'float32_muladd',
    'float32_rem',
    'float32_round_to_int',
    'float32_scalbn',
    'float32_set_sign',
    'float32_sqrt',
    'float32_squash_input_denormal',
    'float32_sub',
    'float32ToCommonNaN',
    'float32_to_float128',
    'float32_to_float16',
    'float32_to_float64',
    'float32_to_floatx80',
    'float32_to_int16',
    'float32_to_int16_round_to_zero',
    'float32_to_int32',
    'float32_to_int32_round_to_zero',
    'float32_to_int64',
    'float32_to_int64_round_to_zero',
    'float32_to_uint16',
    'float32_to_uint16_round_to_zero',
    'float32_to_uint32',
    'float32_to_uint32_round_to_zero',
    'float32_to_uint64',
    'float32_to_uint64_round_to_zero',
    'float32_unordered',
    'float32_unordered_quiet',
    'float64_abs',
    'float64_add',
    'float64_chs',
    'float64_compare',
    'float64_compare_internal',
    'float64_compare_quiet',
    'float64_default_nan',
    'float64_div',
    'float64_eq',
    'float64_eq_quiet',
    'float64_is_any_nan',
    'float64_is_infinity',
    'float64_is_neg',
    'float64_is_quiet_nan',
    'float64_is_signaling_nan',
    'float64_is_zero',
    'float64_le',
    'float64_le_quiet',
    'float64_log2',
    'float64_lt',
    'float64_lt_quiet',
    'float64_max',
    'float64_maxnum',
    'float64_maxnummag',
    'float64_maybe_silence_nan',
    'float64_min',
    'float64_minmax',
    'float64_minnum',
    'float64_minnummag',
    'float64_mul',
    'float64_muladd',
    'float64_rem',
    'float64_round_to_int',
    'float64_scalbn',
    'float64_set_sign',
    'float64_sqrt',
    'float64_squash_input_denormal',
    'float64_sub',
    'float64ToCommonNaN',
    'float64_to_float128',
    'float64_to_float16',
    'float64_to_float32',
    'float64_to_floatx80',
    'float64_to_int16',
    'float64_to_int16_round_to_zero',
    'float64_to_int32',
    'float64_to_int32_round_to_zero',
    'float64_to_int64',
    'float64_to_int64_round_to_zero',
    'float64_to_uint16',
    'float64_to_uint16_round_to_zero',
    'float64_to_uint32',
    'float64_to_uint32_round_to_zero',
    'float64_to_uint64',
    'float64_to_uint64_round_to_zero',
    'float64_trunc_to_int',
    'float64_unordered',
    'float64_unordered_quiet',
    'float_raise',
    'floatx80_add',
    'floatx80_compare',
    'floatx80_compare_internal',
    'floatx80_compare_quiet',
    'floatx80_default_nan',
    'floatx80_div',
    'floatx80_eq',
    'floatx80_eq_quiet',
    'floatx80_is_quiet_nan',
    'floatx80_is_signaling_nan',
    'floatx80_le',
    'floatx80_le_quiet',
    'floatx80_lt',
    'floatx80_lt_quiet',
    'floatx80_maybe_silence_nan',
    'floatx80_mul',
    'floatx80_rem',
    'floatx80_round_to_int',
    'floatx80_scalbn',
    'floatx80_sqrt',
    'floatx80_sub',
    'floatx80ToCommonNaN',
    'floatx80_to_float128',
    'floatx80_to_float32',
    'floatx80_to_float64',
    'floatx80_to_int32',
    'floatx80_to_int32_round_to_zero',
    'floatx80_to_int64',
    'floatx80_to_int64_round_to_zero',
    'floatx80_unordered',
    'floatx80_unordered_quiet',
    'flush_icache_range',
    'format_string',
    'fp_decode_rm',
    'frame_dummy',
    'free_range',
    'fstat64',
    'futex_wait',
    'futex_wake',
    'gen_aa32_ld16s',
    'gen_aa32_ld16u',
    'gen_aa32_ld32u',
    'gen_aa32_ld64',
    'gen_aa32_ld8s',
    'gen_aa32_ld8u',
    'gen_aa32_st16',
    'gen_aa32_st32',
    'gen_aa32_st64',
    'gen_aa32_st8',
    'gen_adc',
    'gen_adc_CC',
    'gen_add16',
    'gen_add_carry',
    'gen_add_CC',
    'gen_add_datah_offset',
    'gen_add_data_offset',
    'gen_addq',
    'gen_addq_lo',
    'gen_addq_msw',
    'gen_arm_parallel_addsub',
    'gen_arm_shift_im',
    'gen_arm_shift_reg',
    'gen_bx',
    'gen_bx_im',
    'gen_clrex',
    'generate_memory_topology',
    'generic_timer_cp_reginfo',
    'gen_exception',
    'gen_exception_insn',
    'gen_exception_internal',
    'gen_exception_internal_insn',
    'gen_exception_return',
    'gen_goto_tb',
    'gen_helper_access_check_cp_reg',
    'gen_helper_add_saturate',
    'gen_helper_add_setq',
    'gen_helper_clear_pstate_ss',
    'gen_helper_clz32',
    'gen_helper_clz64',
    'gen_helper_clz_arm',
    'gen_helper_cpsr_read',
    'gen_helper_cpsr_write',
    'gen_helper_crc32_arm',
    'gen_helper_crc32c',
    'gen_helper_crypto_aese',
    'gen_helper_crypto_aesmc',
    'gen_helper_crypto_sha1_3reg',
    'gen_helper_crypto_sha1h',
    'gen_helper_crypto_sha1su1',
    'gen_helper_crypto_sha256h',
    'gen_helper_crypto_sha256h2',
    'gen_helper_crypto_sha256su0',
    'gen_helper_crypto_sha256su1',
    'gen_helper_double_saturate',
    'gen_helper_exception_internal',
    'gen_helper_exception_with_syndrome',
    'gen_helper_get_cp_reg',
    'gen_helper_get_cp_reg64',
    'gen_helper_get_r13_banked',
    'gen_helper_get_user_reg',
    'gen_helper_iwmmxt_addcb',
    'gen_helper_iwmmxt_addcl',
    'gen_helper_iwmmxt_addcw',
    'gen_helper_iwmmxt_addnb',
    'gen_helper_iwmmxt_addnl',
    'gen_helper_iwmmxt_addnw',
    'gen_helper_iwmmxt_addsb',
    'gen_helper_iwmmxt_addsl',
    'gen_helper_iwmmxt_addsw',
    'gen_helper_iwmmxt_addub',
    'gen_helper_iwmmxt_addul',
    'gen_helper_iwmmxt_adduw',
    'gen_helper_iwmmxt_align',
    'gen_helper_iwmmxt_avgb0',
    'gen_helper_iwmmxt_avgb1',
    'gen_helper_iwmmxt_avgw0',
    'gen_helper_iwmmxt_avgw1',
    'gen_helper_iwmmxt_bcstb',
    'gen_helper_iwmmxt_bcstl',
    'gen_helper_iwmmxt_bcstw',
    'gen_helper_iwmmxt_cmpeqb',
    'gen_helper_iwmmxt_cmpeql',
    'gen_helper_iwmmxt_cmpeqw',
    'gen_helper_iwmmxt_cmpgtsb',
    'gen_helper_iwmmxt_cmpgtsl',
    'gen_helper_iwmmxt_cmpgtsw',
    'gen_helper_iwmmxt_cmpgtub',
    'gen_helper_iwmmxt_cmpgtul',
    'gen_helper_iwmmxt_cmpgtuw',
    'gen_helper_iwmmxt_insr',
    'gen_helper_iwmmxt_macsw',
    'gen_helper_iwmmxt_macuw',
    'gen_helper_iwmmxt_maddsq',
    'gen_helper_iwmmxt_madduq',
    'gen_helper_iwmmxt_maxsb',
    'gen_helper_iwmmxt_maxsl',
    'gen_helper_iwmmxt_maxsw',
    'gen_helper_iwmmxt_maxub',
    'gen_helper_iwmmxt_maxul',
    'gen_helper_iwmmxt_maxuw',
    'gen_helper_iwmmxt_minsb',
    'gen_helper_iwmmxt_minsl',
    'gen_helper_iwmmxt_minsw',
    'gen_helper_iwmmxt_minub',
    'gen_helper_iwmmxt_minul',
    'gen_helper_iwmmxt_minuw',
    'gen_helper_iwmmxt_msbb',
    'gen_helper_iwmmxt_msbl',
    'gen_helper_iwmmxt_msbw',
    'gen_helper_iwmmxt_muladdsl',
    'gen_helper_iwmmxt_muladdsw',
    'gen_helper_iwmmxt_muladdswl',
    'gen_helper_iwmmxt_mulshw',
    'gen_helper_iwmmxt_mulslw',
    'gen_helper_iwmmxt_muluhw',
    'gen_helper_iwmmxt_mululw',
    'gen_helper_iwmmxt_packsl',
    'gen_helper_iwmmxt_packsq',
    'gen_helper_iwmmxt_packsw',
    'gen_helper_iwmmxt_packul',
    'gen_helper_iwmmxt_packuq',
    'gen_helper_iwmmxt_packuw',
    'gen_helper_iwmmxt_rorl',
    'gen_helper_iwmmxt_rorq',
    'gen_helper_iwmmxt_rorw',
    'gen_helper_iwmmxt_sadb',
    'gen_helper_iwmmxt_sadw',
    'gen_helper_iwmmxt_setpsr_nz',
    'gen_helper_iwmmxt_shufh',
    'gen_helper_iwmmxt_slll',
    'gen_helper_iwmmxt_sllq',
    'gen_helper_iwmmxt_sllw',
    'gen_helper_iwmmxt_sral',
    'gen_helper_iwmmxt_sraq',
    'gen_helper_iwmmxt_sraw',
    'gen_helper_iwmmxt_srll',
    'gen_helper_iwmmxt_srlq',
    'gen_helper_iwmmxt_srlw',
    'gen_helper_iwmmxt_subnb',
    'gen_helper_iwmmxt_subnl',
    'gen_helper_iwmmxt_subnw',
    'gen_helper_iwmmxt_subsb',
    'gen_helper_iwmmxt_subsl',
    'gen_helper_iwmmxt_subsw',
    'gen_helper_iwmmxt_subub',
    'gen_helper_iwmmxt_subul',
    'gen_helper_iwmmxt_subuw',
    'gen_helper_iwmmxt_unpackhb',
    'gen_helper_iwmmxt_unpackhl',
    'gen_helper_iwmmxt_unpackhsb',
    'gen_helper_iwmmxt_unpackhsl',
    'gen_helper_iwmmxt_unpackhsw',
    'gen_helper_iwmmxt_unpackhub',
    'gen_helper_iwmmxt_unpackhul',
    'gen_helper_iwmmxt_unpackhuw',
    'gen_helper_iwmmxt_unpackhw',
    'gen_helper_iwmmxt_unpacklb',
    'gen_helper_iwmmxt_unpackll',
    'gen_helper_iwmmxt_unpacklsb',
    'gen_helper_iwmmxt_unpacklsl',
    'gen_helper_iwmmxt_unpacklsw',
    'gen_helper_iwmmxt_unpacklub',
    'gen_helper_iwmmxt_unpacklul',
    'gen_helper_iwmmxt_unpackluw',
    'gen_helper_iwmmxt_unpacklw',
    'gen_helper_neon_abd_f32',
    'gen_helper_neon_abdl_s16',
    'gen_helper_neon_abdl_s32',
    'gen_helper_neon_abdl_s64',
    'gen_helper_neon_abdl_u16',
    'gen_helper_neon_abdl_u32',
    'gen_helper_neon_abdl_u64',
    'gen_helper_neon_abd_s16',
    'gen_helper_neon_abd_s32',
    'gen_helper_neon_abd_s8',
    'gen_helper_neon_abd_u16',
    'gen_helper_neon_abd_u32',
    'gen_helper_neon_abd_u8',
    'gen_helper_neon_abs_s16',
    'gen_helper_neon_abs_s8',
    'gen_helper_neon_acge_f32',
    'gen_helper_neon_acgt_f32',
    'gen_helper_neon_addl_saturate_s32',
    'gen_helper_neon_addl_saturate_s64',
    'gen_helper_neon_addl_u16',
    'gen_helper_neon_addl_u32',
    'gen_helper_neon_add_u16',
    'gen_helper_neon_add_u8',
    'gen_helper_neon_ceq_f32',
    'gen_helper_neon_ceq_u16',
    'gen_helper_neon_ceq_u32',
    'gen_helper_neon_ceq_u8',
    'gen_helper_neon_cge_f32',
    'gen_helper_neon_cge_s16',
    'gen_helper_neon_cge_s32',
    'gen_helper_neon_cge_s8',
    'gen_helper_neon_cge_u16',
    'gen_helper_neon_cge_u32',
    'gen_helper_neon_cge_u8',
    'gen_helper_neon_cgt_f32',
    'gen_helper_neon_cgt_s16',
    'gen_helper_neon_cgt_s32',
    'gen_helper_neon_cgt_s8',
    'gen_helper_neon_cgt_u16',
    'gen_helper_neon_cgt_u32',
    'gen_helper_neon_cgt_u8',
    'gen_helper_neon_cls_s16',
    'gen_helper_neon_cls_s32',
    'gen_helper_neon_cls_s8',
    'gen_helper_neon_clz_u16',
    'gen_helper_neon_clz_u8',
    'gen_helper_neon_cnt_u8',
    'gen_helper_neon_fcvt_f16_to_f32',
    'gen_helper_neon_fcvt_f32_to_f16',
    'gen_helper_neon_hadd_s16',
    'gen_helper_neon_hadd_s32',
    'gen_helper_neon_hadd_s8',
    'gen_helper_neon_hadd_u16',
    'gen_helper_neon_hadd_u32',
    'gen_helper_neon_hadd_u8',
    'gen_helper_neon_hsub_s16',
    'gen_helper_neon_hsub_s32',
    'gen_helper_neon_hsub_s8',
    'gen_helper_neon_hsub_u16',
    'gen_helper_neon_hsub_u32',
    'gen_helper_neon_hsub_u8',
    'gen_helper_neon_max_s16',
    'gen_helper_neon_max_s32',
    'gen_helper_neon_max_s8',
    'gen_helper_neon_max_u16',
    'gen_helper_neon_max_u32',
    'gen_helper_neon_max_u8',
    'gen_helper_neon_min_s16',
    'gen_helper_neon_min_s32',
    'gen_helper_neon_min_s8',
    'gen_helper_neon_min_u16',
    'gen_helper_neon_min_u32',
    'gen_helper_neon_min_u8',
    'gen_helper_neon_mull_p8',
    'gen_helper_neon_mull_s16',
    'gen_helper_neon_mull_s8',
    'gen_helper_neon_mull_u16',
    'gen_helper_neon_mull_u8',
    'gen_helper_neon_mul_p8',
    'gen_helper_neon_mul_u16',
    'gen_helper_neon_mul_u8',
    'gen_helper_neon_narrow_high_u16',
    'gen_helper_neon_narrow_high_u8',
    'gen_helper_neon_narrow_round_high_u16',
    'gen_helper_neon_narrow_round_high_u8',
    'gen_helper_neon_narrow_sat_s16',
    'gen_helper_neon_narrow_sat_s32',
    'gen_helper_neon_narrow_sat_s8',
    'gen_helper_neon_narrow_sat_u16',
    'gen_helper_neon_narrow_sat_u32',
    'gen_helper_neon_narrow_sat_u8',
    'gen_helper_neon_narrow_u16',
    'gen_helper_neon_narrow_u8',
    'gen_helper_neon_negl_u16',
    'gen_helper_neon_negl_u32',
    'gen_helper_neon_paddl_u16',
    'gen_helper_neon_paddl_u32',
    'gen_helper_neon_padd_u16',
    'gen_helper_neon_padd_u8',
    'gen_helper_neon_pmax_s16',
    'gen_helper_neon_pmax_s8',
    'gen_helper_neon_pmax_u16',
    'gen_helper_neon_pmax_u8',
    'gen_helper_neon_pmin_s16',
    'gen_helper_neon_pmin_s8',
    'gen_helper_neon_pmin_u16',
    'gen_helper_neon_pmin_u8',
    'gen_helper_neon_pmull_64_hi',
    'gen_helper_neon_pmull_64_lo',
    'gen_helper_neon_qabs_s16',
    'gen_helper_neon_qabs_s32',
    'gen_helper_neon_qabs_s8',
    'gen_helper_neon_qadd_s16',
    'gen_helper_neon_qadd_s32',
    'gen_helper_neon_qadd_s64',
    'gen_helper_neon_qadd_s8',
    'gen_helper_neon_qadd_u16',
    'gen_helper_neon_qadd_u32',
    'gen_helper_neon_qadd_u64',
    'gen_helper_neon_qadd_u8',
    'gen_helper_neon_qdmulh_s16',
    'gen_helper_neon_qdmulh_s32',
    'gen_helper_neon_qneg_s16',
    'gen_helper_neon_qneg_s32',
    'gen_helper_neon_qneg_s8',
    'gen_helper_neon_qrdmulh_s16',
    'gen_helper_neon_qrdmulh_s32',
    'gen_helper_neon_qrshl_s16',
    'gen_helper_neon_qrshl_s32',
    'gen_helper_neon_qrshl_s64',
    'gen_helper_neon_qrshl_s8',
    'gen_helper_neon_qrshl_u16',
    'gen_helper_neon_qrshl_u32',
    'gen_helper_neon_qrshl_u64',
    'gen_helper_neon_qrshl_u8',
    'gen_helper_neon_qshl_s16',
    'gen_helper_neon_qshl_s32',
    'gen_helper_neon_qshl_s64',
    'gen_helper_neon_qshl_s8',
    'gen_helper_neon_qshl_u16',
    'gen_helper_neon_qshl_u32',
    'gen_helper_neon_qshl_u64',
    'gen_helper_neon_qshl_u8',
    'gen_helper_neon_qshlu_s16',
    'gen_helper_neon_qshlu_s32',
    'gen_helper_neon_qshlu_s64',
    'gen_helper_neon_qshlu_s8',
    'gen_helper_neon_qsub_s16',
    'gen_helper_neon_qsub_s32',
    'gen_helper_neon_qsub_s64',
    'gen_helper_neon_qsub_s8',
    'gen_helper_neon_qsub_u16',
    'gen_helper_neon_qsub_u32',
    'gen_helper_neon_qsub_u64',
    'gen_helper_neon_qsub_u8',
    'gen_helper_neon_qunzip16',
    'gen_helper_neon_qunzip32',
    'gen_helper_neon_qunzip8',
    'gen_helper_neon_qzip16',
    'gen_helper_neon_qzip32',
    'gen_helper_neon_qzip8',
    'gen_helper_neon_rhadd_s16',
    'gen_helper_neon_rhadd_s32',
    'gen_helper_neon_rhadd_s8',
    'gen_helper_neon_rhadd_u16',
    'gen_helper_neon_rhadd_u32',
    'gen_helper_neon_rhadd_u8',
    'gen_helper_neon_rshl_s16',
    'gen_helper_neon_rshl_s32',
    'gen_helper_neon_rshl_s64',
    'gen_helper_neon_rshl_s8',
    'gen_helper_neon_rshl_u16',
    'gen_helper_neon_rshl_u32',
    'gen_helper_neon_rshl_u64',
    'gen_helper_neon_rshl_u8',
    'gen_helper_neon_shl_s16',
    'gen_helper_neon_shl_s32',
    'gen_helper_neon_shl_s64',
    'gen_helper_neon_shl_s8',
    'gen_helper_neon_shl_u16',
    'gen_helper_neon_shl_u32',
    'gen_helper_neon_shl_u64',
    'gen_helper_neon_shl_u8',
    'gen_helper_neon_subl_u16',
    'gen_helper_neon_subl_u32',
    'gen_helper_neon_sub_u16',
    'gen_helper_neon_sub_u8',
    'gen_helper_neon_tbl',
    'gen_helper_neon_tst_u16',
    'gen_helper_neon_tst_u32',
    'gen_helper_neon_tst_u8',
    'gen_helper_neon_unarrow_sat16',
    'gen_helper_neon_unarrow_sat32',
    'gen_helper_neon_unarrow_sat8',
    'gen_helper_neon_unzip16',
    'gen_helper_neon_unzip8',
    'gen_helper_neon_widen_s16',
    'gen_helper_neon_widen_s8',
    'gen_helper_neon_widen_u16',
    'gen_helper_neon_widen_u8',
    'gen_helper_neon_zip16',
    'gen_helper_neon_zip8',
    'gen_helper_pre_hvc',
    'gen_helper_pre_smc',
    'gen_helper_qadd16',
    'gen_helper_qadd8',
    'gen_helper_qaddsubx',
    'gen_helper_qsub16',
    'gen_helper_qsub8',
    'gen_helper_qsubaddx',
    'gen_helper_rbit',
    'gen_helper_recpe_f32',
    'gen_helper_recpe_u32',
    'gen_helper_recps_f32',
    'gen_helper_rintd',
    'gen_helper_rintd_exact',
    'gen_helper_rints',
    'gen_helper_rints_exact',
    'gen_helper_ror_cc',
    'gen_helper_rsqrte_f32',
    'gen_helper_rsqrte_u32',
    'gen_helper_rsqrts_f32',
    'gen_helper_sadd16',
    'gen_helper_sadd8',
    'gen_helper_saddsubx',
    'gen_helper_sar_cc',
    'gen_helper_sdiv',
    'gen_helper_sel_flags',
    'gen_helper_set_cp_reg',
    'gen_helper_set_cp_reg64',
    'gen_helper_set_neon_rmode',
    'gen_helper_set_r13_banked',
    'gen_helper_set_rmode',
    'gen_helper_set_user_reg',
    'gen_helper_shadd16',
    'gen_helper_shadd8',
    'gen_helper_shaddsubx',
    'gen_helper_shl_cc',
    'gen_helper_shr_cc',
    'gen_helper_shsub16',
    'gen_helper_shsub8',
    'gen_helper_shsubaddx',
    'gen_helper_ssat',
    'gen_helper_ssat16',
    'gen_helper_ssub16',
    'gen_helper_ssub8',
    'gen_helper_ssubaddx',
    'gen_helper_sub_saturate',
    'gen_helper_sxtb16',
    'gen_helper_uadd16',
    'gen_helper_uadd8',
    'gen_helper_uaddsubx',
    'gen_helper_udiv',
    'gen_helper_uhadd16',
    'gen_helper_uhadd8',
    'gen_helper_uhaddsubx',
    'gen_helper_uhsub16',
    'gen_helper_uhsub8',
    'gen_helper_uhsubaddx',
    'gen_helper_uqadd16',
    'gen_helper_uqadd8',
    'gen_helper_uqaddsubx',
    'gen_helper_uqsub16',
    'gen_helper_uqsub8',
    'gen_helper_uqsubaddx',
    'gen_helper_usad8',
    'gen_helper_usat',
    'gen_helper_usat16',
    'gen_helper_usub16',
    'gen_helper_usub8',
    'gen_helper_usubaddx',
    'gen_helper_uxtb16',
    'gen_helper_v7m_mrs',
    'gen_helper_v7m_msr',
    'gen_helper_vfp_absd',
    'gen_helper_vfp_abss',
    'gen_helper_vfp_addd',
    'gen_helper_vfp_adds',
    'gen_helper_vfp_cmpd',
    'gen_helper_vfp_cmped',
    'gen_helper_vfp_cmpes',
    'gen_helper_vfp_cmps',
    'gen_helper_vfp_divd',
    'gen_helper_vfp_divs',
    'gen_helper_vfp_fcvtds',
    'gen_helper_vfp_fcvt_f16_to_f32',
    'gen_helper_vfp_fcvt_f16_to_f64',
    'gen_helper_vfp_fcvt_f32_to_f16',
    'gen_helper_vfp_fcvt_f64_to_f16',
    'gen_helper_vfp_fcvtsd',
    'gen_helper_vfp_get_fpscr',
    'gen_helper_vfp_maxnumd',
    'gen_helper_vfp_maxnums',
    'gen_helper_vfp_maxs',
    'gen_helper_vfp_minnumd',
    'gen_helper_vfp_minnums',
    'gen_helper_vfp_mins',
    'gen_helper_vfp_muladdd',
    'gen_helper_vfp_muladds',
    'gen_helper_vfp_muld',
    'gen_helper_vfp_muls',
    'gen_helper_vfp_negd',
    'gen_helper_vfp_negs',
    'gen_helper_vfp_set_fpscr',
    'gen_helper_vfp_shtod',
    'gen_helper_vfp_shtos',
    'gen_helper_vfp_sitod',
    'gen_helper_vfp_sitos',
    'gen_helper_vfp_sltod',
    'gen_helper_vfp_sltos',
    'gen_helper_vfp_sqrtd',
    'gen_helper_vfp_sqrts',
    'gen_helper_vfp_subd',
    'gen_helper_vfp_subs',
    'gen_helper_vfp_toshd_round_to_zero',
    'gen_helper_vfp_toshs_round_to_zero',
    'gen_helper_vfp_tosid',
    'gen_helper_vfp_tosis',
    'gen_helper_vfp_tosizd',
    'gen_helper_vfp_tosizs',
    'gen_helper_vfp_tosld',
    'gen_helper_vfp_tosld_round_to_zero',
    'gen_helper_vfp_tosls',
    'gen_helper_vfp_tosls_round_to_zero',
    'gen_helper_vfp_touhd_round_to_zero',
    'gen_helper_vfp_touhs_round_to_zero',
    'gen_helper_vfp_touid',
    'gen_helper_vfp_touis',
    'gen_helper_vfp_touizd',
    'gen_helper_vfp_touizs',
    'gen_helper_vfp_tould',
    'gen_helper_vfp_tould_round_to_zero',
    'gen_helper_vfp_touls',
    'gen_helper_vfp_touls_round_to_zero',
    'gen_helper_vfp_uhtod',
    'gen_helper_vfp_uhtos',
    'gen_helper_vfp_uitod',
    'gen_helper_vfp_uitos',
    'gen_helper_vfp_ultod',
    'gen_helper_vfp_ultos',
    'gen_helper_wfe',
    'gen_helper_wfi',
    'gen_hvc',
    'gen_intermediate_code_internal',
    'gen_intermediate_code_internal_a64',
    'gen_iwmmxt_address',
    'gen_iwmmxt_shift',
    'gen_jmp',
    'gen_load_and_replicate',
    'gen_load_exclusive',
    'gen_logic_CC',
    'gen_logicq_cc',
    'gen_lookup_tb',
    'gen_mov_F0_vreg',
    'gen_mov_F1_vreg',
    'gen_mov_vreg_F0',
    'gen_muls_i64_i32',
    'gen_mulu_i64_i32',
    'gen_mulxy',
    'gen_neon_add',
    'gen_neon_addl',
    'gen_neon_addl_saturate',
    'gen_neon_bsl',
    'gen_neon_dup_high16',
    'gen_neon_dup_low16',
    'gen_neon_dup_u8',
    'gen_neon_mull',
    'gen_neon_narrow',
    'gen_neon_narrow_op',
    'gen_neon_narrow_sats',
    'gen_neon_narrow_satu',
    'gen_neon_negl',
    'gen_neon_rsb',
    'gen_neon_shift_narrow',
    'gen_neon_subl',
    'gen_neon_trn_u16',
    'gen_neon_trn_u8',
    'gen_neon_unarrow_sats',
    'gen_neon_unzip',
    'gen_neon_widen',
    'gen_neon_zip',
    'gen_new_label',
    'gen_nop_hint',
    'gen_op_iwmmxt_addl_M0_wRn',
    'gen_op_iwmmxt_addnb_M0_wRn',
    'gen_op_iwmmxt_addnl_M0_wRn',
    'gen_op_iwmmxt_addnw_M0_wRn',
    'gen_op_iwmmxt_addsb_M0_wRn',
    'gen_op_iwmmxt_addsl_M0_wRn',
    'gen_op_iwmmxt_addsw_M0_wRn',
    'gen_op_iwmmxt_addub_M0_wRn',
    'gen_op_iwmmxt_addul_M0_wRn',
    'gen_op_iwmmxt_adduw_M0_wRn',
    'gen_op_iwmmxt_andq_M0_wRn',
    'gen_op_iwmmxt_avgb0_M0_wRn',
    'gen_op_iwmmxt_avgb1_M0_wRn',
    'gen_op_iwmmxt_avgw0_M0_wRn',
    'gen_op_iwmmxt_avgw1_M0_wRn',
    'gen_op_iwmmxt_cmpeqb_M0_wRn',
    'gen_op_iwmmxt_cmpeql_M0_wRn',
    'gen_op_iwmmxt_cmpeqw_M0_wRn',
    'gen_op_iwmmxt_cmpgtsb_M0_wRn',
    'gen_op_iwmmxt_cmpgtsl_M0_wRn',
    'gen_op_iwmmxt_cmpgtsw_M0_wRn',
    'gen_op_iwmmxt_cmpgtub_M0_wRn',
    'gen_op_iwmmxt_cmpgtul_M0_wRn',
    'gen_op_iwmmxt_cmpgtuw_M0_wRn',
    'gen_op_iwmmxt_macsw_M0_wRn',
    'gen_op_iwmmxt_macuw_M0_wRn',
    'gen_op_iwmmxt_maddsq_M0_wRn',
    'gen_op_iwmmxt_madduq_M0_wRn',
    'gen_op_iwmmxt_maxsb_M0_wRn',
    'gen_op_iwmmxt_maxsl_M0_wRn',
    'gen_op_iwmmxt_maxsw_M0_wRn',
    'gen_op_iwmmxt_maxub_M0_wRn',
    'gen_op_iwmmxt_maxul_M0_wRn',
    'gen_op_iwmmxt_maxuw_M0_wRn',
    'gen_op_iwmmxt_minsb_M0_wRn',
    'gen_op_iwmmxt_minsl_M0_wRn',
    'gen_op_iwmmxt_minsw_M0_wRn',
    'gen_op_iwmmxt_minub_M0_wRn',
    'gen_op_iwmmxt_minul_M0_wRn',
    'gen_op_iwmmxt_minuw_M0_wRn',
    'gen_op_iwmmxt_movq_M0_wRn',
    'gen_op_iwmmxt_movq_wRn_M0',
    'gen_op_iwmmxt_mulshw_M0_wRn',
    'gen_op_iwmmxt_mulslw_M0_wRn',
    'gen_op_iwmmxt_muluhw_M0_wRn',
    'gen_op_iwmmxt_mululw_M0_wRn',
    'gen_op_iwmmxt_orq_M0_wRn',
    'gen_op_iwmmxt_packsl_M0_wRn',
    'gen_op_iwmmxt_packsq_M0_wRn',
    'gen_op_iwmmxt_packsw_M0_wRn',
    'gen_op_iwmmxt_packul_M0_wRn',
    'gen_op_iwmmxt_packuq_M0_wRn',
    'gen_op_iwmmxt_packuw_M0_wRn',
    'gen_op_iwmmxt_sadb_M0_wRn',
    'gen_op_iwmmxt_sadw_M0_wRn',
    'gen_op_iwmmxt_set_cup',
    'gen_op_iwmmxt_set_mup',
    'gen_op_iwmmxt_setpsr_nz',
    'gen_op_iwmmxt_subnb_M0_wRn',
    'gen_op_iwmmxt_subnl_M0_wRn',
    'gen_op_iwmmxt_subnw_M0_wRn',
    'gen_op_iwmmxt_subsb_M0_wRn',
    'gen_op_iwmmxt_subsl_M0_wRn',
    'gen_op_iwmmxt_subsw_M0_wRn',
    'gen_op_iwmmxt_subub_M0_wRn',
    'gen_op_iwmmxt_subul_M0_wRn',
    'gen_op_iwmmxt_subuw_M0_wRn',
    'gen_op_iwmmxt_unpackhb_M0_wRn',
    'gen_op_iwmmxt_unpackhl_M0_wRn',
    'gen_op_iwmmxt_unpackhsb_M0',
    'gen_op_iwmmxt_unpackhsl_M0',
    'gen_op_iwmmxt_unpackhsw_M0',
    'gen_op_iwmmxt_unpackhub_M0',
    'gen_op_iwmmxt_unpackhul_M0',
    'gen_op_iwmmxt_unpackhuw_M0',
    'gen_op_iwmmxt_unpackhw_M0_wRn',
    'gen_op_iwmmxt_unpacklb_M0_wRn',
    'gen_op_iwmmxt_unpackll_M0_wRn',
    'gen_op_iwmmxt_unpacklsb_M0',
    'gen_op_iwmmxt_unpacklsl_M0',
    'gen_op_iwmmxt_unpacklsw_M0',
    'gen_op_iwmmxt_unpacklub_M0',
    'gen_op_iwmmxt_unpacklul_M0',
    'gen_op_iwmmxt_unpackluw_M0',
    'gen_op_iwmmxt_unpacklw_M0_wRn',
    'gen_op_iwmmxt_xorq_M0_wRn',
    'gen_rev16',
    'gen_revsh',
    'gen_rfe',
    'gen_sar',
    'gen_sbc_CC',
    'gen_sbfx',
    'gen_set_CF_bit31',
    'gen_set_condexec',
    'gen_set_cpsr',
    'gen_set_label',
    'gen_set_pc_im',
    'gen_set_psr',
    'gen_set_psr_im',
    'gen_shl',
    'gen_shr',
    'gen_smc',
    'gen_smul_dual',
    'gen_srs',
    'gen_ss_advance',
    'gen_step_complete_exception',
    'gen_store_exclusive',
    'gen_storeq_reg',
    'gen_sub_carry',
    'gen_sub_CC',
    'gen_subq_msw',
    'gen_swap_half',
    'gen_thumb2_data_op',
    'gen_thumb2_parallel_addsub',
    'gen_ubfx',
    'gen_vfp_abs',
    'gen_vfp_add',
    'gen_vfp_cmp',
    'gen_vfp_cmpe',
    'gen_vfp_div',
    'gen_vfp_F1_ld0',
    'gen_vfp_F1_mul',
    'gen_vfp_F1_neg',
    'gen_vfp_ld',
    'gen_vfp_mrs',
    'gen_vfp_msr',
    'gen_vfp_mul',
    'gen_vfp_neg',
    'gen_vfp_shto',
    'gen_vfp_sito',
    'gen_vfp_slto',
    'gen_vfp_sqrt',
    'gen_vfp_st',
    'gen_vfp_sub',
    'gen_vfp_tosh',
    'gen_vfp_tosi',
    'gen_vfp_tosiz',
    'gen_vfp_tosl',
    'gen_vfp_touh',
    'gen_vfp_toui',
    'gen_vfp_touiz',
    'gen_vfp_toul',
    'gen_vfp_uhto',
    'gen_vfp_uito',
    'gen_vfp_ulto',
    'get_arm_cp_reginfo',
    'get_clock',
    'get_clock_realtime',
    'get_constraint_priority',
    'get_float_exception_flags',
    'get_float_rounding_mode',
    'get_fpstatus_ptr',
    'get_level1_table_address',
    'get_mem_index',
    'get_next_param_value',
    'get_opt_name',
    'get_opt_value',
    'get_page_addr_code',
    'get_param_value',
    'get_phys_addr',
    'get_phys_addr_lpae',
    'get_phys_addr_mpu',
    'get_phys_addr_v5',
    'get_phys_addr_v6',
    'get_system_memory',
    'get_ticks_per_sec',
    'g_list_insert_sorted_merged',
    '_GLOBAL_OFFSET_TABLE_',
    'gt_cntfrq_access',
    'gt_cnt_read',
    'gt_cnt_reset',
    'gt_counter_access',
    'gt_ctl_write',
    'gt_cval_write',
    'gt_get_countervalue',
    'gt_pct_access',
    'gt_ptimer_access',
    'gt_recalc_timer',
    'gt_timer_access',
    'gt_tval_read',
    'gt_tval_write',
    'gt_vct_access',
    'gt_vtimer_access',
    'guest_phys_blocks_free',
    'guest_phys_blocks_init',
    'handle_vcvt',
    'handle_vminmaxnm',
    'handle_vrint',
    'handle_vsel',
    'has_help_option',
    'have_bmi1',
    'have_bmi2',
    'hcr_write',
    'helper_access_check_cp_reg',
    'helper_add_saturate',
    'helper_add_setq',
    'helper_add_usaturate',
    'helper_be_ldl_cmmu',
    'helper_be_ldq_cmmu',
    'helper_be_ldq_mmu',
    'helper_be_ldsl_mmu',
    'helper_be_ldsw_mmu',
    'helper_be_ldul_mmu',
    'helper_be_lduw_mmu',
    'helper_be_ldw_cmmu',
    'helper_be_stl_mmu',
    'helper_be_stq_mmu',
    'helper_be_stw_mmu',
    'helper_clear_pstate_ss',
    'helper_clz_arm',
    'helper_cpsr_read',
    'helper_cpsr_write',
    'helper_crc32_arm',
    'helper_crc32c',
    'helper_crypto_aese',
    'helper_crypto_aesmc',
    'helper_crypto_sha1_3reg',
    'helper_crypto_sha1h',
    'helper_crypto_sha1su1',
    'helper_crypto_sha256h',
    'helper_crypto_sha256h2',
    'helper_crypto_sha256su0',
    'helper_crypto_sha256su1',
    'helper_dc_zva',
    'helper_double_saturate',
    'helper_exception_internal',
    'helper_exception_return',
    'helper_exception_with_syndrome',
    'helper_get_cp_reg',
    'helper_get_cp_reg64',
    'helper_get_r13_banked',
    'helper_get_user_reg',
    'helper_iwmmxt_addcb',
    'helper_iwmmxt_addcl',
    'helper_iwmmxt_addcw',
    'helper_iwmmxt_addnb',
    'helper_iwmmxt_addnl',
    'helper_iwmmxt_addnw',
    'helper_iwmmxt_addsb',
    'helper_iwmmxt_addsl',
    'helper_iwmmxt_addsw',
    'helper_iwmmxt_addub',
    'helper_iwmmxt_addul',
    'helper_iwmmxt_adduw',
    'helper_iwmmxt_align',
    'helper_iwmmxt_avgb0',
    'helper_iwmmxt_avgb1',
    'helper_iwmmxt_avgw0',
    'helper_iwmmxt_avgw1',
    'helper_iwmmxt_bcstb',
    'helper_iwmmxt_bcstl',
    'helper_iwmmxt_bcstw',
    'helper_iwmmxt_cmpeqb',
    'helper_iwmmxt_cmpeql',
    'helper_iwmmxt_cmpeqw',
    'helper_iwmmxt_cmpgtsb',
    'helper_iwmmxt_cmpgtsl',
    'helper_iwmmxt_cmpgtsw',
    'helper_iwmmxt_cmpgtub',
    'helper_iwmmxt_cmpgtul',
    'helper_iwmmxt_cmpgtuw',
    'helper_iwmmxt_insr',
    'helper_iwmmxt_macsw',
    'helper_iwmmxt_macuw',
    'helper_iwmmxt_maddsq',
    'helper_iwmmxt_madduq',
    'helper_iwmmxt_maxsb',
    'helper_iwmmxt_maxsl',
    'helper_iwmmxt_maxsw',
    'helper_iwmmxt_maxub',
    'helper_iwmmxt_maxul',
    'helper_iwmmxt_maxuw',
    'helper_iwmmxt_minsb',
    'helper_iwmmxt_minsl',
    'helper_iwmmxt_minsw',
    'helper_iwmmxt_minub',
    'helper_iwmmxt_minul',
    'helper_iwmmxt_minuw',
    'helper_iwmmxt_msbb',
    'helper_iwmmxt_msbl',
    'helper_iwmmxt_msbw',
    'helper_iwmmxt_muladdsl',
    'helper_iwmmxt_muladdsw',
    'helper_iwmmxt_muladdswl',
    'helper_iwmmxt_mulshw',
    'helper_iwmmxt_mulslw',
    'helper_iwmmxt_muluhw',
    'helper_iwmmxt_mululw',
    'helper_iwmmxt_packsl',
    'helper_iwmmxt_packsq',
    'helper_iwmmxt_packsw',
    'helper_iwmmxt_packul',
    'helper_iwmmxt_packuq',
    'helper_iwmmxt_packuw',
    'helper_iwmmxt_rorl',
    'helper_iwmmxt_rorq',
    'helper_iwmmxt_rorw',
    'helper_iwmmxt_sadb',
    'helper_iwmmxt_sadw',
    'helper_iwmmxt_setpsr_nz',
    'helper_iwmmxt_shufh',
    'helper_iwmmxt_slll',
    'helper_iwmmxt_sllq',
    'helper_iwmmxt_sllw',
    'helper_iwmmxt_sral',
    'helper_iwmmxt_sraq',
    'helper_iwmmxt_sraw',
    'helper_iwmmxt_srll',
    'helper_iwmmxt_srlq',
    'helper_iwmmxt_srlw',
    'helper_iwmmxt_subnb',
    'helper_iwmmxt_subnl',
    'helper_iwmmxt_subnw',
    'helper_iwmmxt_subsb',
    'helper_iwmmxt_subsl',
    'helper_iwmmxt_subsw',
    'helper_iwmmxt_subub',
    'helper_iwmmxt_subul',
    'helper_iwmmxt_subuw',
    'helper_iwmmxt_unpackhb',
    'helper_iwmmxt_unpackhl',
    'helper_iwmmxt_unpackhsb',
    'helper_iwmmxt_unpackhsl',
    'helper_iwmmxt_unpackhsw',
    'helper_iwmmxt_unpackhub',
    'helper_iwmmxt_unpackhul',
    'helper_iwmmxt_unpackhuw',
    'helper_iwmmxt_unpackhw',
    'helper_iwmmxt_unpacklb',
    'helper_iwmmxt_unpackll',
    'helper_iwmmxt_unpacklsb',
    'helper_iwmmxt_unpacklsl',
    'helper_iwmmxt_unpacklsw',
    'helper_iwmmxt_unpacklub',
    'helper_iwmmxt_unpacklul',
    'helper_iwmmxt_unpackluw',
    'helper_iwmmxt_unpacklw',
    'helper_ldb_cmmu',
    'helper_ldb_mmu',
    'helper_ldl_cmmu',
    'helper_ldl_mmu',
    'helper_ldq_cmmu',
    'helper_ldq_mmu',
    'helper_ldw_cmmu',
    'helper_ldw_mmu',
    'helper_le_ldl_cmmu',
    'helper_le_ldq_cmmu',
    'helper_le_ldq_mmu',
    'helper_le_ldsl_mmu',
    'helper_le_ldsw_mmu',
    'helper_le_ldul_mmu',
    'helper_le_lduw_mmu',
    'helper_le_ldw_cmmu',
    'helper_le_stl_mmu',
    'helper_le_stq_mmu',
    'helper_le_stw_mmu',
    'helper_msr_i_pstate',
    'helper_neon_abd_f32',
    'helper_neon_abdl_s16',
    'helper_neon_abdl_s32',
    'helper_neon_abdl_s64',
    'helper_neon_abdl_u16',
    'helper_neon_abdl_u32',
    'helper_neon_abdl_u64',
    'helper_neon_abd_s16',
    'helper_neon_abd_s32',
    'helper_neon_abd_s8',
    'helper_neon_abd_u16',
    'helper_neon_abd_u32',
    'helper_neon_abd_u8',
    'helper_neon_abs_s16',
    'helper_neon_abs_s8',
    'helper_neon_acge_f32',
    'helper_neon_acge_f64',
    'helper_neon_acgt_f32',
    'helper_neon_acgt_f64',
    'helper_neon_addl_saturate_s32',
    'helper_neon_addl_saturate_s64',
    'helper_neon_addl_u16',
    'helper_neon_addl_u32',
    'helper_neon_add_u16',
    'helper_neon_add_u8',
    'helper_neon_ceq_f32',
    'helper_neon_ceq_u16',
    'helper_neon_ceq_u32',
    'helper_neon_ceq_u8',
    'helper_neon_cge_f32',
    'helper_neon_cge_s16',
    'helper_neon_cge_s32',
    'helper_neon_cge_s8',
    'helper_neon_cge_u16',
    'helper_neon_cge_u32',
    'helper_neon_cge_u8',
    'helper_neon_cgt_f32',
    'helper_neon_cgt_s16',
    'helper_neon_cgt_s32',
    'helper_neon_cgt_s8',
    'helper_neon_cgt_u16',
    'helper_neon_cgt_u32',
    'helper_neon_cgt_u8',
    'helper_neon_cls_s16',
    'helper_neon_cls_s32',
    'helper_neon_cls_s8',
    'helper_neon_clz_u16',
    'helper_neon_clz_u8',
    'helper_neon_cnt_u8',
    'helper_neon_fcvt_f16_to_f32',
    'helper_neon_fcvt_f32_to_f16',
    'helper_neon_hadd_s16',
    'helper_neon_hadd_s32',
    'helper_neon_hadd_s8',
    'helper_neon_hadd_u16',
    'helper_neon_hadd_u32',
    'helper_neon_hadd_u8',
    'helper_neon_hsub_s16',
    'helper_neon_hsub_s32',
    'helper_neon_hsub_s8',
    'helper_neon_hsub_u16',
    'helper_neon_hsub_u32',
    'helper_neon_hsub_u8',
    'helper_neon_max_s16',
    'helper_neon_max_s32',
    'helper_neon_max_s8',
    'helper_neon_max_u16',
    'helper_neon_max_u32',
    'helper_neon_max_u8',
    'helper_neon_min_s16',
    'helper_neon_min_s32',
    'helper_neon_min_s8',
    'helper_neon_min_u16',
    'helper_neon_min_u32',
    'helper_neon_min_u8',
    'helper_neon_mull_p8',
    'helper_neon_mull_s16',
    'helper_neon_mull_s8',
    'helper_neon_mull_u16',
    'helper_neon_mull_u8',
    'helper_neon_mul_p8',
    'helper_neon_mul_u16',
    'helper_neon_mul_u8',
    'helper_neon_narrow_high_u16',
    'helper_neon_narrow_high_u8',
    'helper_neon_narrow_round_high_u16',
    'helper_neon_narrow_round_high_u8',
    'helper_neon_narrow_sat_s16',
    'helper_neon_narrow_sat_s32',
    'helper_neon_narrow_sat_s8',
    'helper_neon_narrow_sat_u16',
    'helper_neon_narrow_sat_u32',
    'helper_neon_narrow_sat_u8',
    'helper_neon_narrow_u16',
    'helper_neon_narrow_u8',
    'helper_neon_negl_u16',
    'helper_neon_negl_u32',
    'helper_neon_paddl_u16',
    'helper_neon_paddl_u32',
    'helper_neon_padd_u16',
    'helper_neon_padd_u8',
    'helper_neon_pmax_s16',
    'helper_neon_pmax_s8',
    'helper_neon_pmax_u16',
    'helper_neon_pmax_u8',
    'helper_neon_pmin_s16',
    'helper_neon_pmin_s8',
    'helper_neon_pmin_u16',
    'helper_neon_pmin_u8',
    'helper_neon_pmull_64_hi',
    'helper_neon_pmull_64_lo',
    'helper_neon_qabs_s16',
    'helper_neon_qabs_s32',
    'helper_neon_qabs_s64',
    'helper_neon_qabs_s8',
    'helper_neon_qadd_s16',
    'helper_neon_qadd_s32',
    'helper_neon_qadd_s64',
    'helper_neon_qadd_s8',
    'helper_neon_qadd_u16',
    'helper_neon_qadd_u32',
    'helper_neon_qadd_u64',
    'helper_neon_qadd_u8',
    'helper_neon_qdmulh_s16',
    'helper_neon_qdmulh_s32',
    'helper_neon_qneg_s16',
    'helper_neon_qneg_s32',
    'helper_neon_qneg_s64',
    'helper_neon_qneg_s8',
    'helper_neon_qrdmulh_s16',
    'helper_neon_qrdmulh_s32',
    'helper_neon_qrshl_s16',
    'helper_neon_qrshl_s32',
    'helper_neon_qrshl_s64',
    'helper_neon_qrshl_s8',
    'helper_neon_qrshl_u16',
    'helper_neon_qrshl_u32',
    'helper_neon_qrshl_u64',
    'helper_neon_qrshl_u8',
    'helper_neon_qshl_s16',
    'helper_neon_qshl_s32',
    'helper_neon_qshl_s64',
    'helper_neon_qshl_s8',
    'helper_neon_qshl_u16',
    'helper_neon_qshl_u32',
    'helper_neon_qshl_u64',
    'helper_neon_qshl_u8',
    'helper_neon_qshlu_s16',
    'helper_neon_qshlu_s32',
    'helper_neon_qshlu_s64',
    'helper_neon_qshlu_s8',
    'helper_neon_qsub_s16',
    'helper_neon_qsub_s32',
    'helper_neon_qsub_s64',
    'helper_neon_qsub_s8',
    'helper_neon_qsub_u16',
    'helper_neon_qsub_u32',
    'helper_neon_qsub_u64',
    'helper_neon_qsub_u8',
    'helper_neon_qunzip16',
    'helper_neon_qunzip32',
    'helper_neon_qunzip8',
    'helper_neon_qzip16',
    'helper_neon_qzip32',
    'helper_neon_qzip8',
    'helper_neon_rbit_u8',
    'helper_neon_rhadd_s16',
    'helper_neon_rhadd_s32',
    'helper_neon_rhadd_s8',
    'helper_neon_rhadd_u16',
    'helper_neon_rhadd_u32',
    'helper_neon_rhadd_u8',
    'helper_neon_rshl_s16',
    'helper_neon_rshl_s32',
    'helper_neon_rshl_s64',
    'helper_neon_rshl_s8',
    'helper_neon_rshl_u16',
    'helper_neon_rshl_u32',
    'helper_neon_rshl_u64',
    'helper_neon_rshl_u8',
    'helper_neon_shl_s16',
    'helper_neon_shl_s32',
    'helper_neon_shl_s64',
    'helper_neon_shl_s8',
    'helper_neon_shl_u16',
    'helper_neon_shl_u32',
    'helper_neon_shl_u64',
    'helper_neon_shl_u8',
    'helper_neon_sqadd_u16',
    'helper_neon_sqadd_u32',
    'helper_neon_sqadd_u64',
    'helper_neon_sqadd_u8',
    'helper_neon_subl_u16',
    'helper_neon_subl_u32',
    'helper_neon_sub_u16',
    'helper_neon_sub_u8',
    'helper_neon_tbl',
    'helper_neon_tst_u16',
    'helper_neon_tst_u32',
    'helper_neon_tst_u8',
    'helper_neon_unarrow_sat16',
    'helper_neon_unarrow_sat32',
    'helper_neon_unarrow_sat8',
    'helper_neon_unzip16',
    'helper_neon_unzip8',
    'helper_neon_uqadd_s16',
    'helper_neon_uqadd_s32',
    'helper_neon_uqadd_s64',
    'helper_neon_uqadd_s8',
    'helper_neon_widen_s16',
    'helper_neon_widen_s8',
    'helper_neon_widen_u16',
    'helper_neon_widen_u8',
    'helper_neon_zip16',
    'helper_neon_zip8',
    'helper_pre_hvc',
    'helper_pre_smc',
    'helper_qadd16',
    'helper_qadd8',
    'helper_qaddsubx',
    'helper_qsub16',
    'helper_qsub8',
    'helper_qsubaddx',
    'helper_rbit',
    'helper_recpe_f32',
    'helper_recpe_f64',
    'helper_recpe_u32',
    'helper_recps_f32',
    'helper_ret_ldb_cmmu',
    'helper_ret_ldsb_mmu',
    'helper_ret_ldub_mmu',
    'helper_ret_stb_mmu',
    'helper_rintd',
    'helper_rintd_exact',
    'helper_rints',
    'helper_rints_exact',
    'helper_ror_cc',
    'helper_rsqrte_f32',
    'helper_rsqrte_f64',
    'helper_rsqrte_u32',
    'helper_rsqrts_f32',
    'helper_sadd16',
    'helper_sadd8',
    'helper_saddsubx',
    'helper_sar_cc',
    'helper_sdiv',
    'helper_sel_flags',
    'helper_set_cp_reg',
    'helper_set_cp_reg64',
    'helper_set_neon_rmode',
    'helper_set_r13_banked',
    'helper_set_rmode',
    'helper_set_user_reg',
    'helper_shadd16',
    'helper_shadd8',
    'helper_shaddsubx',
    'helper_shl_cc',
    'helper_shr_cc',
    'helper_shsub16',
    'helper_shsub8',
    'helper_shsubaddx',
    'helper_ssat',
    'helper_ssat16',
    'helper_ssub16',
    'helper_ssub8',
    'helper_ssubaddx',
    'helper_stb_mmu',
    'helper_stl_mmu',
    'helper_stq_mmu',
    'helper_stw_mmu',
    'helper_sub_saturate',
    'helper_sub_usaturate',
    'helper_sxtb16',
    'helper_uadd16',
    'helper_uadd8',
    'helper_uaddsubx',
    'helper_udiv',
    'helper_uhadd16',
    'helper_uhadd8',
    'helper_uhaddsubx',
    'helper_uhsub16',
    'helper_uhsub8',
    'helper_uhsubaddx',
    'helper_uqadd16',
    'helper_uqadd8',
    'helper_uqaddsubx',
    'helper_uqsub16',
    'helper_uqsub8',
    'helper_uqsubaddx',
    'helper_usad8',
    'helper_usat',
    'helper_usat16',
    'helper_usub16',
    'helper_usub8',
    'helper_usubaddx',
    'helper_uxtb16',
    'helper_v7m_mrs',
    'helper_v7m_msr',
    'helper_vfp_absd',
    'helper_vfp_abss',
    'helper_vfp_addd',
    'helper_vfp_adds',
    'helper_vfp_cmpd',
    'helper_vfp_cmped',
    'helper_vfp_cmpes',
    'helper_vfp_cmps',
    'helper_vfp_divd',
    'helper_vfp_divs',
    'helper_vfp_fcvtds',
    'helper_vfp_fcvt_f16_to_f32',
    'helper_vfp_fcvt_f16_to_f64',
    'helper_vfp_fcvt_f32_to_f16',
    'helper_vfp_fcvt_f64_to_f16',
    'helper_vfp_fcvtsd',
    'helper_vfp_get_fpscr',
    'helper_vfp_maxd',
    'helper_vfp_maxnumd',
    'helper_vfp_maxnums',
    'helper_vfp_maxs',
    'helper_vfp_mind',
    'helper_vfp_minnumd',
    'helper_vfp_minnums',
    'helper_vfp_mins',
    'helper_vfp_muladdd',
    'helper_vfp_muladds',
    'helper_vfp_muld',
    'helper_vfp_muls',
    'helper_vfp_negd',
    'helper_vfp_negs',
    'helper_vfp_set_fpscr',
    'helper_vfp_shtod',
    'helper_vfp_shtos',
    'helper_vfp_sitod',
    'helper_vfp_sitos',
    'helper_vfp_sltod',
    'helper_vfp_sltos',
    'helper_vfp_sqrtd',
    'helper_vfp_sqrts',
    'helper_vfp_sqtod',
    'helper_vfp_sqtos',
    'helper_vfp_subd',
    'helper_vfp_subs',
    'helper_vfp_toshd',
    'helper_vfp_toshd_round_to_zero',
    'helper_vfp_toshs',
    'helper_vfp_toshs_round_to_zero',
    'helper_vfp_tosid',
    'helper_vfp_tosis',
    'helper_vfp_tosizd',
    'helper_vfp_tosizs',
    'helper_vfp_tosld',
    'helper_vfp_tosld_round_to_zero',
    'helper_vfp_tosls',
    'helper_vfp_tosls_round_to_zero',
    'helper_vfp_tosqd',
    'helper_vfp_tosqs',
    'helper_vfp_touhd',
    'helper_vfp_touhd_round_to_zero',
    'helper_vfp_touhs',
    'helper_vfp_touhs_round_to_zero',
    'helper_vfp_touid',
    'helper_vfp_touis',
    'helper_vfp_touizd',
    'helper_vfp_touizs',
    'helper_vfp_tould',
    'helper_vfp_tould_round_to_zero',
    'helper_vfp_touls',
    'helper_vfp_touls_round_to_zero',
    'helper_vfp_touqd',
    'helper_vfp_touqs',
    'helper_vfp_uhtod',
    'helper_vfp_uhtos',
    'helper_vfp_uitod',
    'helper_vfp_uitos',
    'helper_vfp_ultod',
    'helper_vfp_ultos',
    'helper_vfp_uqtod',
    'helper_vfp_uqtos',
    'helper_wfe',
    'helper_wfi',
    'hex2decimal',
    'hw_breakpoint_update',
    'hw_breakpoint_update_all',
    'hw_watchpoint_update',
    'hw_watchpoint_update_all',
    '_init',
    'init_cpreg_list',
    'init_lists',
    'input_type_enum',
    'int128_2_64',
    'int128_add',
    'int128_addto',
    'int128_and',
    'int128_eq',
    'int128_ge',
    'int128_get64',
    'int128_gt',
    'int128_le',
    'int128_lt',
    'int128_make64',
    'int128_max',
    'int128_min',
    'int128_ne',
    'int128_neg',
    'int128_nz',
    'int128_rshift',
    'int128_sub',
    'int128_subfrom',
    'int128_zero',
    'int16_to_float32',
    'int16_to_float64',
    'int32_to_float128',
    'int32_to_float32',
    'int32_to_float64',
    'int32_to_floatx80',
    'int64_to_float128',
    'int64_to_float32',
    'int64_to_float64',
    'int64_to_floatx80',
    'invalidate_and_set_dirty',
    'invalidate_page_bitmap',
    'io_mem_read',
    'io_mem_write',
    'io_readb',
    'io_readl',
    'io_readq',
    'io_readw',
    'iotlb_to_region',
    'io_writeb',
    'io_writel',
    'io_writeq',
    'io_writew',
    'is_a64',
    'is_help_option',
    'isr_read',
    'is_valid_option_list',
    'iwmmxt_load_creg',
    'iwmmxt_load_reg',
    'iwmmxt_store_creg',
    'iwmmxt_store_reg',
    '__jit_debug_descriptor',
    '__jit_debug_register_code',
    'kvm_to_cpreg_id',
    'last_ram_offset',
    'ldl_be_p',
    'ldl_be_phys',
    'ldl_he_p',
    'ldl_le_p',
    'ldl_le_phys',
    'ldl_phys',
    'ldl_phys_internal',
    'ldq_be_p',
    'ldq_be_phys',
    'ldq_he_p',
    'ldq_le_p',
    'ldq_le_phys',
    'ldq_phys',
    'ldq_phys_internal',
    'ldst_name',
    'ldub_p',
    'ldub_phys',
    'lduw_be_p',
    'lduw_be_phys',
    'lduw_he_p',
    'lduw_le_p',
    'lduw_le_phys',
    'lduw_phys',
    'lduw_phys_internal',
    'le128',
    'linked_bp_matches',
    'listener_add_address_space',
    'load_cpu_offset',
    'load_reg',
    'load_reg_var',
    'log_cpu_state',
    'lpae_cp_reginfo',
    'lt128',
    'machine_class_init',
    'machine_finalize',
    'machine_info',
    'machine_initfn',
    'machine_register_types',
    'machvirt_init',
    'machvirt_machine_init',
    'maj',
    'mapping_conflict',
    'mapping_contiguous',
    'mapping_have_same_region',
    'mapping_merge',
    'mem_add',
    'mem_begin',
    'mem_commit',
    'memory_access_is_direct',
    'memory_access_size',
    'memory_init',
    'memory_listener_match',
    'memory_listener_register',
    'memory_listener_unregister',
    'memory_map_init',
    'memory_mapping_filter',
    'memory_mapping_list_add_mapping_sorted',
    'memory_mapping_list_add_merge_sorted',
    'memory_mapping_list_free',
    'memory_mapping_list_init',
    'memory_region_access_valid',
    'memory_region_add_subregion',
    'memory_region_add_subregion_common',
    'memory_region_add_subregion_overlap',
    'memory_region_big_endian',
    'memory_region_clear_pending',
    'memory_region_del_subregion',
    'memory_region_destructor_alias',
    'memory_region_destructor_none',
    'memory_region_destructor_ram',
    'memory_region_destructor_ram_from_ptr',
    'memory_region_dispatch_read',
    'memory_region_dispatch_read1',
    'memory_region_dispatch_write',
    'memory_region_escape_name',
    'memory_region_finalize',
    'memory_region_find',
    'memory_region_get_addr',
    'memory_region_get_alignment',
    'memory_region_get_container',
    'memory_region_get_fd',
    'memory_region_get_may_overlap',
    'memory_region_get_priority',
    'memory_region_get_ram_addr',
    'memory_region_get_ram_ptr',
    'memory_region_get_size',
    'memory_region_info',
    'memory_region_init',
    'memory_region_init_alias',
    'memory_region_initfn',
    'memory_region_init_io',
    'memory_region_init_ram',
    'memory_region_init_ram_ptr',
    'memory_region_init_reservation',
    'memory_region_is_iommu',
    'memory_region_is_logging',
    'memory_region_is_mapped',
    'memory_region_is_ram',
    'memory_region_is_rom',
    'memory_region_is_romd',
    'memory_region_is_skip_dump',
    'memory_region_is_unassigned',
    'memory_region_name',
    'memory_region_need_escape',
    'memory_region_oldmmio_read_accessor',
    'memory_region_oldmmio_write_accessor',
    'memory_region_present',
    'memory_region_read_accessor',
    'memory_region_readd_subregion',
    'memory_region_ref',
    'memory_region_resolve_container',
    'memory_region_rom_device_set_romd',
    'memory_region_section_get_iotlb',
    'memory_region_set_address',
    'memory_region_set_alias_offset',
    'memory_region_set_enabled',
    'memory_region_set_readonly',
    'memory_region_set_skip_dump',
    'memory_region_size',
    'memory_region_to_address_space',
    'memory_region_transaction_begin',
    'memory_region_transaction_commit',
    'memory_region_unref',
    'memory_region_update_container_subregions',
    'memory_region_write_accessor',
    'memory_region_wrong_endianness',
    'memory_try_enable_merging',
    'module_call_init',
    'module_load',
    'mpidr_cp_reginfo',
    'mpidr_read',
    'msr_mask',
    'mul128By64To192',
    'mul128To256',
    'mul64To128',
    'muldiv64',
    'neon_2rm_is_float_op',
    'neon_2rm_sizes',
    'neon_3r_sizes',
    'neon_get_scalar',
    'neon_load_reg',
    'neon_load_reg64',
    'neon_load_scratch',
    'neon_ls_element_type',
    'neon_reg_offset',
    'neon_store_reg',
    'neon_store_reg64',
    'neon_store_scratch',
    'new_ldst_label',
    'next_list',
    'normalizeFloat128Subnormal',
    'normalizeFloat16Subnormal',
    'normalizeFloat32Subnormal',
    'normalizeFloat64Subnormal',
    'normalizeFloatx80Subnormal',
    'normalizeRoundAndPackFloat128',
    'normalizeRoundAndPackFloat32',
    'normalizeRoundAndPackFloat64',
    'normalizeRoundAndPackFloatx80',
    'not_v6_cp_reginfo',
    'not_v7_cp_reginfo',
    'not_v8_cp_reginfo',
    'object_child_foreach',
    'object_class_foreach',
    'object_class_foreach_tramp',
    'object_class_get_list',
    'object_class_get_list_tramp',
    'object_class_get_parent',
    'object_deinit',
    'object_dynamic_cast',
    'object_finalize',
    'object_finalize_child_property',
    'object_get_child_property',
    'object_get_link_property',
    'object_get_root',
    'object_initialize_with_type',
    'object_init_with_type',
    'object_instance_init',
    'object_new_with_type',
    'object_post_init_with_type',
    'object_property_add_alias',
    'object_property_add_link',
    'object_property_add_uint16_ptr',
    'object_property_add_uint32_ptr',
    'object_property_add_uint64_ptr',
    'object_property_add_uint8_ptr',
    'object_property_allow_set_link',
    'object_property_del',
    'object_property_del_all',
    'object_property_find',
    'object_property_get',
    'object_property_get_bool',
    'object_property_get_int',
    'object_property_get_link',
    'object_property_get_qobject',
    'object_property_get_str',
    'object_property_get_type',
    'object_property_is_child',
    'object_property_set',
    'object_property_set_description',
    'object_property_set_link',
    'object_property_set_qobject',
    'object_release_link_property',
    'object_resolve_abs_path',
    'object_resolve_child_property',
    'object_resolve_link',
    'object_resolve_link_property',
    'object_resolve_partial_path',
    'object_resolve_path',
    'object_resolve_path_component',
    'object_resolve_path_type',
    'object_set_link_property',
    'object_unparent',
    'omap_cachemaint_write',
    'omap_cp_reginfo',
    'omap_threadid_write',
    'omap_ticonfig_write',
    'omap_wfi_write',
    'op_bits',
    'open_modeflags',
    'op_to_mov',
    'op_to_movi',
    'output_type_enum',
    'packFloat128',
    'packFloat16',
    'packFloat32',
    'packFloat64',
    'packFloatx80',
    'page_find',
    'page_find_alloc',
    'page_flush_tb',
    'page_flush_tb_1',
    'page_init',
    'page_size_init',
    'par',
    'parse_array',
    'parse_error',
    'parse_escape',
    'parse_keyword',
    'parse_literal',
    'parse_object',
    'parse_optional',
    'parse_option_bool',
    'parse_option_number',
    'parse_option_size',
    'parse_pair',
    'parser_context_free',
    'parser_context_new',
    'parser_context_peek_token',
    'parser_context_pop_token',
    'parser_context_restore',
    'parser_context_save',
    'parse_str',
    'parse_type_bool',
    'parse_type_int',
    'parse_type_number',
    'parse_type_size',
    'parse_type_str',
    'parse_value',
    'par_write',
    'patch_reloc',
    'phys_map_node_alloc',
    'phys_map_node_reserve',
    'phys_mem_alloc',
    'phys_mem_set_alloc',
    'phys_page_compact',
    'phys_page_compact_all',
    'phys_page_find',
    'phys_page_set',
    'phys_page_set_level',
    'phys_section_add',
    'phys_section_destroy',
    'phys_sections_free',
    'pickNaN',
    'pickNaNMulAdd',
    'pmccfiltr_write',
    'pmccntr_read',
    'pmccntr_sync',
    'pmccntr_write',
    'pmccntr_write32',
    'pmcntenclr_write',
    'pmcntenset_write',
    'pmcr_write',
    'pmintenclr_write',
    'pmintenset_write',
    'pmovsr_write',
    'pmreg_access',
    'pmsav5_cp_reginfo',
    'pmsav5_data_ap_read',
    'pmsav5_data_ap_write',
    'pmsav5_insn_ap_read',
    'pmsav5_insn_ap_write',
    'pmuserenr_write',
    'pmxevtyper_write',
    'print_type_bool',
    'print_type_int',
    'print_type_number',
    'print_type_size',
    'print_type_str',
    'propagateFloat128NaN',
    'propagateFloat32MulAddNaN',
    'propagateFloat32NaN',
    'propagateFloat64MulAddNaN',
    'propagateFloat64NaN',
    'propagateFloatx80NaN',
    'property_get_alias',
    'property_get_bool',
    'property_get_str',
    'property_get_uint16_ptr',
    'property_get_uint32_ptr',
    'property_get_uint64_ptr',
    'property_get_uint8_ptr',
    'property_release_alias',
    'property_release_bool',
    'property_release_str',
    'property_resolve_alias',
    'property_set_alias',
    'property_set_bool',
    'property_set_str',
    'pstate_read',
    'pstate_write',
    'pxa250_initfn',
    'pxa255_initfn',
    'pxa260_initfn',
    'pxa261_initfn',
    'pxa262_initfn',
    'pxa270a0_initfn',
    'pxa270a1_initfn',
    'pxa270b0_initfn',
    'pxa270b1_initfn',
    'pxa270c0_initfn',
    'pxa270c5_initfn',
    'qapi_dealloc_end_implicit_struct',
    'qapi_dealloc_end_list',
    'qapi_dealloc_end_struct',
    'qapi_dealloc_get_visitor',
    'qapi_dealloc_next_list',
    'qapi_dealloc_pop',
    'qapi_dealloc_push',
    'qapi_dealloc_start_implicit_struct',
    'qapi_dealloc_start_list',
    'qapi_dealloc_start_struct',
    'qapi_dealloc_start_union',
    'qapi_dealloc_type_bool',
    'qapi_dealloc_type_enum',
    'qapi_dealloc_type_int',
    'qapi_dealloc_type_number',
    'qapi_dealloc_type_size',
    'qapi_dealloc_type_str',
    'qapi_dealloc_visitor_cleanup',
    'qapi_dealloc_visitor_new',
    'qapi_free_boolList',
    'qapi_free_ErrorClassList',
    'qapi_free_int16List',
    'qapi_free_int32List',
    'qapi_free_int64List',
    'qapi_free_int8List',
    'qapi_free_intList',
    'qapi_free_numberList',
    'qapi_free_strList',
    'qapi_free_uint16List',
    'qapi_free_uint32List',
    'qapi_free_uint64List',
    'qapi_free_uint8List',
    'qapi_free_X86CPUFeatureWordInfo',
    'qapi_free_X86CPUFeatureWordInfoList',
    'qapi_free_X86CPURegister32List',
    'qbool_destroy_obj',
    'qbool_from_int',
    'qbool_get_int',
    'qbool_type',
    'qbus_create',
    'qbus_create_inplace',
    'qbus_finalize',
    'qbus_initfn',
    'qbus_realize',
    'qdev_create',
    'qdev_get_type',
    'qdev_register_types',
    'qdev_set_parent_bus',
    'qdev_try_create',
    'qdict_add_key',
    'qdict_array_split',
    'qdict_clone_shallow',
    'qdict_del',
    'qdict_destroy_obj',
    'qdict_entry_key',
    'qdict_entry_value',
    'qdict_extract_subqdict',
    'qdict_find',
    'qdict_first',
    'qdict_flatten',
    'qdict_flatten_qdict',
    'qdict_flatten_qlist',
    'qdict_get',
    'qdict_get_bool',
    'qdict_get_double',
    'qdict_get_int',
    'qdict_get_obj',
    'qdict_get_qdict',
    'qdict_get_qlist',
    'qdict_get_str',
    'qdict_get_try_bool',
    'qdict_get_try_int',
    'qdict_get_try_str',
    'qdict_haskey',
    'qdict_has_prefixed_entries',
    'qdict_iter',
    'qdict_join',
    'qdict_new',
    'qdict_next',
    'qdict_next_entry',
    'qdict_put_obj',
    'qdict_size',
    'qdict_type',
    'qemu_clock_get_us',
    'qemu_clock_ptr',
    'qemu_clocks',
    'qemu_get_cpu',
    'qemu_get_guest_memory_mapping',
    'qemu_get_guest_simple_memory_mapping',
    'qemu_get_ram_block',
    'qemu_get_ram_block_host_ptr',
    'qemu_get_ram_fd',
    'qemu_get_ram_ptr',
    'qemu_host_page_mask',
    'qemu_host_page_size',
    'qemu_init_vcpu',
    'qemu_ld_helpers',
    'qemu_log_close',
    'qemu_log_enabled',
    'qemu_log_flush',
    'qemu_loglevel_mask',
    'qemu_log_vprintf',
    'qemu_oom_check',
    'qemu_parse_fd',
    'qemu_ram_addr_from_host',
    'qemu_ram_addr_from_host_nofail',
    'qemu_ram_alloc',
    'qemu_ram_alloc_from_ptr',
    'qemu_ram_foreach_block',
    'qemu_ram_free',
    'qemu_ram_free_from_ptr',
    'qemu_ram_ptr_length',
    'qemu_ram_remap',
    'qemu_ram_setup_dump',
    'qemu_ram_unset_idstr',
    'qemu_real_host_page_size',
    'qemu_st_helpers',
    'qemu_tcg_init_vcpu',
    'qemu_try_memalign',
    'qentry_destroy',
    'qerror_human',
    'qerror_report',
    'qerror_report_err',
    'qfloat_destroy_obj',
    'qfloat_from_double',
    'qfloat_get_double',
    'qfloat_type',
    'qint_destroy_obj',
    'qint_from_int',
    'qint_get_int',
    'qint_type',
    'qlist_append_obj',
    'qlist_copy',
    'qlist_copy_elem',
    'qlist_destroy_obj',
    'qlist_empty',
    'qlist_entry_obj',
    'qlist_first',
    'qlist_iter',
    'qlist_new',
    'qlist_next',
    'qlist_peek',
    'qlist_pop',
    'qlist_size',
    'qlist_size_iter',
    'qlist_type',
    'qmp_input_end_implicit_struct',
    'qmp_input_end_list',
    'qmp_input_end_struct',
    'qmp_input_get_next_type',
    'qmp_input_get_object',
    'qmp_input_get_visitor',
    'qmp_input_next_list',
    'qmp_input_optional',
    'qmp_input_pop',
    'qmp_input_push',
    'qmp_input_start_implicit_struct',
    'qmp_input_start_list',
    'qmp_input_start_struct',
    'qmp_input_type_bool',
    'qmp_input_type_int',
    'qmp_input_type_number',
    'qmp_input_type_str',
    'qmp_input_visitor_cleanup',
    'qmp_input_visitor_new',
    'qmp_input_visitor_new_strict',
    'qmp_output_add_obj',
    'qmp_output_end_list',
    'qmp_output_end_struct',
    'qmp_output_first',
    'qmp_output_get_qobject',
    'qmp_output_get_visitor',
    'qmp_output_last',
    'qmp_output_next_list',
    'qmp_output_pop',
    'qmp_output_push_obj',
    'qmp_output_start_list',
    'qmp_output_start_struct',
    'qmp_output_type_bool',
    'qmp_output_type_int',
    'qmp_output_type_number',
    'qmp_output_type_str',
    'qmp_output_visitor_cleanup',
    'qmp_output_visitor_new',
    'qobject_decref',
    'qobject_to_qbool',
    'qobject_to_qdict',
    'qobject_to_qfloat',
    'qobject_to_qint',
    'qobject_to_qlist',
    'qobject_to_qstring',
    'qobject_type',
    'qstring_append',
    'qstring_append_chr',
    'qstring_append_int',
    'qstring_destroy_obj',
    'qstring_from_escaped_str',
    'qstring_from_str',
    'qstring_from_substr',
    'qstring_get_length',
    'qstring_get_str',
    'qstring_new',
    'qstring_type',
    'ram_block_add',
    'ram_size',
    'range_compare',
    'range_covers_byte',
    'range_get_last',
    'range_merge',
    'ranges_can_merge',
    'raw_read',
    'raw_write',
    'rcon',
    'read_raw_cp_reg',
    'recip_estimate',
    'recip_sqrt_estimate',
    'register_cp_regs_for_features',
    'register_multipage',
    'register_subpage',
    'register_tm_clones',
    'register_types_object',
    'regnames',
    'render_memory_region',
    'reset_all_temps',
    'reset_temp',
    'rol32',
    'rol64',
    'ror32',
    'ror64',
    'roundAndPackFloat128',
    'roundAndPackFloat16',
    'roundAndPackFloat32',
    'roundAndPackFloat64',
    'roundAndPackFloatx80',
    'roundAndPackInt32',
    'roundAndPackInt64',
    'roundAndPackUint64',
    'round_to_inf',
    'run_on_cpu',
    's0',
    'S0',
    's1',
    'S1',
    'sa1100_initfn',
    'sa1110_initfn',
    'save_globals',
    'scr_write',
    'sctlr_write',
    'set_bit',
    'set_bits',
    'set_default_nan_mode',
    'set_feature',
    'set_float_detect_tininess',
    'set_float_exception_flags',
    'set_float_rounding_mode',
    'set_flush_inputs_to_zero',
    'set_flush_to_zero',
    'set_swi_errno',
    'sextract32',
    'sextract64',
    'shift128ExtraRightJamming',
    'shift128Right',
    'shift128RightJamming',
    'shift32RightJamming',
    'shift64ExtraRightJamming',
    'shift64RightJamming',
    'shifter_out_im',
    'shortShift128Left',
    'shortShift192Left',
    'simple_mpu_ap_bits',
    'size_code_gen_buffer',
    'softmmu_lock_user',
    'softmmu_lock_user_string',
    'softmmu_tget32',
    'softmmu_tget8',
    'softmmu_tput32',
    'softmmu_unlock_user',
    'sort_constraints',
    'sp_el0_access',
    'spsel_read',
    'spsel_write',
    'start_list',
    'stb_p',
    'stb_phys',
    'stl_be_p',
    'stl_be_phys',
    'stl_he_p',
    'stl_le_p',
    'stl_le_phys',
    'stl_phys',
    'stl_phys_internal',
    'stl_phys_notdirty',
    'store_cpu_offset',
    'store_reg',
    'store_reg_bx',
    'store_reg_from_load',
    'stq_be_p',
    'stq_be_phys',
    'stq_he_p',
    'stq_le_p',
    'stq_le_phys',
    'stq_phys',
    'string_input_get_visitor',
    'string_input_visitor_cleanup',
    'string_input_visitor_new',
    'strongarm_cp_reginfo',
    'strstart',
    'strtosz',
    'strtosz_suffix',
    'stw_be_p',
    'stw_be_phys',
    'stw_he_p',
    'stw_le_p',
    'stw_le_phys',
    'stw_phys',
    'stw_phys_internal',
    'sub128',
    'sub16_sat',
    'sub16_usat',
    'sub192',
    'sub8_sat',
    'sub8_usat',
    'subFloat128Sigs',
    'subFloat32Sigs',
    'subFloat64Sigs',
    'subFloatx80Sigs',
    'subpage_accepts',
    'subpage_init',
    'subpage_ops',
    'subpage_read',
    'subpage_register',
    'subpage_write',
    'suffix_mul',
    'swap_commutative',
    'swap_commutative2',
    'switch_mode',
    'switch_v7m_sp',
    'syn_aa32_bkpt',
    'syn_aa32_hvc',
    'syn_aa32_smc',
    'syn_aa32_svc',
    'syn_breakpoint',
    'sync_globals',
    'syn_cp14_rrt_trap',
    'syn_cp14_rt_trap',
    'syn_cp15_rrt_trap',
    'syn_cp15_rt_trap',
    'syn_data_abort',
    'syn_fp_access_trap',
    'syn_insn_abort',
    'syn_swstep',
    'syn_uncategorized',
    'syn_watchpoint',
    'syscall_err',
    'system_bus_class_init',
    'system_bus_info',
    't2ee_cp_reginfo',
    'table_logic_cc',
    'target_parse_constraint',
    'target_words_bigendian',
    'tb_add_jump',
    'tb_alloc',
    'tb_alloc_page',
    'tb_check_watchpoint',
    'tb_find_fast',
    'tb_find_pc',
    'tb_find_slow',
    'tb_flush',
    'tb_flush_jmp_cache',
    'tb_free',
    'tb_gen_code',
    'tb_hash_remove',
    'tb_invalidate_phys_addr',
    'tb_invalidate_phys_page_range',
    'tb_invalidate_phys_range',
    'tb_jmp_cache_hash_func',
    'tb_jmp_cache_hash_page',
    'tb_jmp_remove',
    'tb_link_page',
    'tb_page_remove',
    'tb_phys_hash_func',
    'tb_phys_invalidate',
    'tb_reset_jump',
    'tb_set_jmp_target',
    'tcg_accel_class_init',
    'tcg_accel_type',
    'tcg_add_param_i32',
    'tcg_add_param_i64',
    'tcg_add_target_add_op_defs',
    'tcg_allowed',
    'tcg_canonicalize_memop',
    'tcg_commit',
    'tcg_cond_to_jcc',
    'tcg_constant_folding',
    'tcg_const_i32',
    'tcg_const_i64',
    'tcg_const_local_i32',
    'tcg_const_local_i64',
    'tcg_context_init',
    'tcg_cpu_address_space_init',
    'tcg_cpu_exec',
    'tcg_current_code_size',
    'tcg_dump_info',
    'tcg_dump_ops',
    'tcg_exec_all',
    'tcg_find_helper',
    'tcg_func_start',
    'tcg_gen_abs_i32',
    'tcg_gen_add2_i32',
    'tcg_gen_add_i32',
    'tcg_gen_add_i64',
    'tcg_gen_addi_i32',
    'tcg_gen_addi_i64',
    'tcg_gen_andc_i32',
    'tcg_gen_and_i32',
    'tcg_gen_and_i64',
    'tcg_gen_andi_i32',
    'tcg_gen_andi_i64',
    'tcg_gen_br',
    'tcg_gen_brcond_i32',
    'tcg_gen_brcond_i64',
    'tcg_gen_brcondi_i32',
    'tcg_gen_bswap16_i32',
    'tcg_gen_bswap32_i32',
    'tcg_gen_callN',
    'tcg_gen_code',
    'tcg_gen_code_common',
    'tcg_gen_code_search_pc',
    'tcg_gen_concat_i32_i64',
    'tcg_gen_debug_insn_start',
    'tcg_gen_deposit_i32',
    'tcg_gen_exit_tb',
    'tcg_gen_ext16s_i32',
    'tcg_gen_ext16u_i32',
    'tcg_gen_ext32s_i64',
    'tcg_gen_ext32u_i64',
    'tcg_gen_ext8s_i32',
    'tcg_gen_ext8u_i32',
    'tcg_gen_ext_i32_i64',
    'tcg_gen_extu_i32_i64',
    'tcg_gen_goto_tb',
    'tcg_gen_ld_i32',
    'tcg_gen_ld_i64',
    'tcg_gen_ldst_op_i32',
    'tcg_gen_ldst_op_i64',
    'tcg_gen_movcond_i32',
    'tcg_gen_movcond_i64',
    'tcg_gen_mov_i32',
    'tcg_gen_mov_i64',
    'tcg_gen_movi_i32',
    'tcg_gen_movi_i64',
    'tcg_gen_mul_i32',
    'tcg_gen_muls2_i32',
    'tcg_gen_mulu2_i32',
    'tcg_gen_neg_i32',
    'tcg_gen_neg_i64',
    'tcg_gen_not_i32',
    'tcg_gen_op0',
    'tcg_gen_op1i',
    'tcg_gen_op2_i32',
    'tcg_gen_op2_i64',
    'tcg_gen_op2i_i32',
    'tcg_gen_op2i_i64',
    'tcg_gen_op3_i32',
    'tcg_gen_op3_i64',
    'tcg_gen_op4_i32',
    'tcg_gen_op4i_i32',
    'tcg_gen_op4ii_i32',
    'tcg_gen_op4ii_i64',
    'tcg_gen_op5ii_i32',
    'tcg_gen_op6_i32',
    'tcg_gen_op6i_i32',
    'tcg_gen_op6i_i64',
    'tcg_gen_orc_i32',
    'tcg_gen_or_i32',
    'tcg_gen_or_i64',
    'tcg_gen_ori_i32',
    'tcg_gen_qemu_ld_i32',
    'tcg_gen_qemu_ld_i64',
    'tcg_gen_qemu_st_i32',
    'tcg_gen_qemu_st_i64',
    'tcg_gen_rotl_i32',
    'tcg_gen_rotli_i32',
    'tcg_gen_rotr_i32',
    'tcg_gen_rotri_i32',
    'tcg_gen_sar_i32',
    'tcg_gen_sari_i32',
    'tcg_gen_setcond_i32',
    'tcg_gen_shl_i32',
    'tcg_gen_shl_i64',
    'tcg_gen_shli_i32',
    'tcg_gen_shli_i64',
    'tcg_gen_shr_i32',
    'tcg_gen_shifti_i64',
    'tcg_gen_shr_i64',
    'tcg_gen_shri_i32',
    'tcg_gen_shri_i64',
    'tcg_gen_st_i32',
    'tcg_gen_st_i64',
    'tcg_gen_sub_i32',
    'tcg_gen_sub_i64',
    'tcg_gen_subi_i32',
    'tcg_gen_trunc_i64_i32',
    'tcg_gen_trunc_shr_i64_i32',
    'tcg_gen_xor_i32',
    'tcg_gen_xor_i64',
    'tcg_gen_xori_i32',
    'tcg_get_arg_str_i32',
    'tcg_get_arg_str_i64',
    'tcg_get_arg_str_idx',
    'tcg_global_mem_new_i32',
    'tcg_global_mem_new_i64',
    'tcg_global_mem_new_internal',
    'tcg_global_reg_new_i32',
    'tcg_global_reg_new_i64',
    'tcg_global_reg_new_internal',
    'tcg_handle_interrupt',
    'tcg_init',
    'tcg_invert_cond',
    'tcg_la_bb_end',
    'tcg_la_br_end',
    'tcg_la_func_end',
    'tcg_liveness_analysis',
    'tcg_malloc',
    'tcg_malloc_internal',
    'tcg_op_defs_org',
    'tcg_opt_gen_mov',
    'tcg_opt_gen_movi',
    'tcg_optimize',
    'tcg_out16',
    'tcg_out32',
    'tcg_out64',
    'tcg_out8',
    'tcg_out_addi',
    'tcg_out_branch',
    'tcg_out_brcond32',
    'tcg_out_brcond64',
    'tcg_out_bswap32',
    'tcg_out_bswap64',
    'tcg_out_call',
    'tcg_out_cmp',
    'tcg_out_ext16s',
    'tcg_out_ext16u',
    'tcg_out_ext32s',
    'tcg_out_ext32u',
    'tcg_out_ext8s',
    'tcg_out_ext8u',
    'tcg_out_jmp',
    'tcg_out_jxx',
    'tcg_out_label',
    'tcg_out_ld',
    'tcg_out_modrm',
    'tcg_out_modrm_offset',
    'tcg_out_modrm_sib_offset',
    'tcg_out_mov',
    'tcg_out_movcond32',
    'tcg_out_movcond64',
    'tcg_out_movi',
    'tcg_out_op',
    'tcg_out_pop',
    'tcg_out_push',
    'tcg_out_qemu_ld',
    'tcg_out_qemu_ld_direct',
    'tcg_out_qemu_ld_slow_path',
    'tcg_out_qemu_st',
    'tcg_out_qemu_st_direct',
    'tcg_out_qemu_st_slow_path',
    'tcg_out_reloc',
    'tcg_out_rolw_8',
    'tcg_out_setcond32',
    'tcg_out_setcond64',
    'tcg_out_shifti',
    'tcg_out_st',
    'tcg_out_tb_finalize',
    'tcg_out_tb_init',
    'tcg_out_tlb_load',
    'tcg_out_vex_modrm',
    'tcg_patch32',
    'tcg_patch8',
    'tcg_pcrel_diff',
    'tcg_pool_reset',
    'tcg_prologue_init',
    'tcg_ptr_byte_diff',
    'tcg_reg_alloc',
    'tcg_reg_alloc_bb_end',
    'tcg_reg_alloc_call',
    'tcg_reg_alloc_mov',
    'tcg_reg_alloc_movi',
    'tcg_reg_alloc_op',
    'tcg_reg_alloc_start',
    'tcg_reg_free',
    'tcg_reg_sync',
    'tcg_set_frame',
    'tcg_set_nop',
    'tcg_swap_cond',
    'tcg_target_callee_save_regs',
    'tcg_target_call_iarg_regs',
    'tcg_target_call_oarg_regs',
    'tcg_target_const_match',
    'tcg_target_init',
    'tcg_target_qemu_prologue',
    'tcg_target_reg_alloc_order',
    'tcg_temp_alloc',
    'tcg_temp_free_i32',
    'tcg_temp_free_i64',
    'tcg_temp_free_internal',
    'tcg_temp_local_new_i32',
    'tcg_temp_local_new_i64',
    'tcg_temp_new_i32',
    'tcg_temp_new_i64',
    'tcg_temp_new_internal',
    'tcg_temp_new_internal_i32',
    'tcg_temp_new_internal_i64',
    'tdb_hash',
    'teecr_write',
    'teehbr_access',
    'temp_allocate_frame',
    'temp_dead',
    'temps_are_copies',
    'temp_save',
    'temp_sync',
    'tgen_arithi',
    'tgen_arithr',
    'thumb2_logic_op',
    'ti925t_initfn',
    'tlb_add_large_page',
    'tlb_flush_entry',
    'tlbi_aa64_asid_is_write',
    'tlbi_aa64_asid_write',
    'tlbi_aa64_vaa_is_write',
    'tlbi_aa64_vaa_write',
    'tlbi_aa64_va_is_write',
    'tlbi_aa64_va_write',
    'tlbiall_is_write',
    'tlbiall_write',
    'tlbiasid_is_write',
    'tlbiasid_write',
    'tlbimvaa_is_write',
    'tlbimvaa_write',
    'tlbimva_is_write',
    'tlbimva_write',
    'tlb_is_dirty_ram',
    'tlb_protect_code',
    'tlb_reset_dirty_range',
    'tlb_reset_dirty_range_all',
    'tlb_set_dirty',
    'tlb_set_dirty1',
    'tlb_unprotect_code_phys',
    'tlb_vaddr_to_host',
    'token_get_type',
    'token_get_value',
    'token_is_escape',
    'token_is_keyword',
    'token_is_operator',
    'tokens_append_from_iter',
    'to_qiv',
    'to_qov',
    'tosa_init',
    'tosa_machine_init',
    'tswap32',
    'tswap64',
    'type_class_get_size',
    'type_get_by_name',
    'type_get_parent',
    'type_has_parent',
    'type_initialize',
    'type_initialize_interface',
    'type_is_ancestor',
    'type_new',
    'type_object_get_size',
    'type_register_internal',
    'type_table_add',
    'type_table_get',
    'type_table_lookup',
    'uint16_to_float32',
    'uint16_to_float64',
    'uint32_to_float32',
    'uint32_to_float64',
    'uint64_to_float128',
    'uint64_to_float32',
    'uint64_to_float64',
    'unassigned_io_ops',
    'unassigned_io_read',
    'unassigned_io_write',
    'unassigned_mem_accepts',
    'unassigned_mem_ops',
    'unassigned_mem_read',
    'unassigned_mem_write',
    'update_spsel',
    'v6_cp_reginfo',
    'v6k_cp_reginfo',
    'v7_cp_reginfo',
    'v7mp_cp_reginfo',
    'v7m_pop',
    'v7m_push',
    'v8_cp_reginfo',
    'v8_el2_cp_reginfo',
    'v8_el3_cp_reginfo',
    'v8_el3_no_el2_cp_reginfo',
    'vapa_cp_reginfo',
    'vbar_write',
    'vfp_exceptbits_from_host',
    'vfp_exceptbits_to_host',
    'vfp_get_fpcr',
    'vfp_get_fpscr',
    'vfp_get_fpsr',
    'vfp_reg_offset',
    'vfp_set_fpcr',
    'vfp_set_fpscr',
    'vfp_set_fpsr',
    'visit_end_implicit_struct',
    'visit_end_list',
    'visit_end_struct',
    'visit_end_union',
    'visit_get_next_type',
    'visit_next_list',
    'visit_optional',
    'visit_start_implicit_struct',
    'visit_start_list',
    'visit_start_struct',
    'visit_start_union',
    'vmsa_cp_reginfo',
    'vmsa_tcr_el1_write',
    'vmsa_ttbcr_raw_write',
    'vmsa_ttbcr_reset',
    'vmsa_ttbcr_write',
    'vmsa_ttbr_write',
    'write_cpustate_to_list',
    'write_list_to_cpustate',
    'write_raw_cp_reg',
    'X86CPURegister32_lookup',
    'x86_op_defs',
    'xpsr_read',
    'xpsr_write',
    'xscale_cpar_write',
    'xscale_cp_reginfo'
)

arm_symbols = (
    'ARM_REGS_STORAGE_SIZE',
)

aarch64_symbols = (
    'ARM64_REGS_STORAGE_SIZE',
    'arm64_release',
    'arm64_reg_reset',
    'arm64_reg_read',
    'arm64_reg_write',
    'gen_a64_set_pc_im',
    'aarch64_cpu_register_types',
    'helper_udiv64',
    'helper_sdiv64',
    'helper_cls64',
    'helper_cls32',
    'helper_rbit64',
    'helper_vfp_cmps_a64',
    'helper_vfp_cmpes_a64',
    'helper_vfp_cmpd_a64',
    'helper_vfp_cmped_a64',
    'helper_vfp_mulxs',
    'helper_vfp_mulxd',
    'helper_simd_tbl',
    'helper_neon_ceq_f64',
    'helper_neon_cge_f64',
    'helper_neon_cgt_f64',
    'helper_recpsf_f32',
    'helper_recpsf_f64',
    'helper_rsqrtsf_f32',
    'helper_rsqrtsf_f64',
    'helper_neon_addlp_s8',
    'helper_neon_addlp_u8',
    'helper_neon_addlp_s16',
    'helper_neon_addlp_u16',
    'helper_frecpx_f32',
    'helper_frecpx_f64',
    'helper_fcvtx_f64_to_f32',
    'helper_crc32_64',
    'helper_crc32c_64',
    'aarch64_cpu_do_interrupt',

)

mips_symbols = (
    'cpu_mips_exec',
    'cpu_mips_get_random',
    'cpu_mips_get_count',
    'cpu_mips_store_count',
    'cpu_mips_store_compare',
    'cpu_mips_start_count',
    'cpu_mips_stop_count',
    'mips_machine_init',
    'cpu_mips_kseg0_to_phys',
    'cpu_mips_phys_to_kseg0',
    'cpu_mips_kvm_um_phys_to_kseg0',
    'mips_cpu_register_types',
    'cpu_mips_init',
    'cpu_state_reset',
    'helper_msa_andi_b',
    'helper_msa_ori_b',
    'helper_msa_nori_b',
    'helper_msa_xori_b',
    'helper_msa_bmnzi_b',
    'helper_msa_bmzi_b',
    'helper_msa_bseli_b',
    'helper_msa_shf_df',
    'helper_msa_and_v',
    'helper_msa_or_v',
    'helper_msa_nor_v',
    'helper_msa_xor_v',
    'helper_msa_bmnz_v',
    'helper_msa_bmz_v',
    'helper_msa_bsel_v',
    'helper_msa_addvi_df',
    'helper_msa_subvi_df',
    'helper_msa_ceqi_df',
    'helper_msa_clei_s_df',
    'helper_msa_clei_u_df',
    'helper_msa_clti_s_df',
    'helper_msa_clti_u_df',
    'helper_msa_maxi_s_df',
    'helper_msa_maxi_u_df',
    'helper_msa_mini_s_df',
    'helper_msa_mini_u_df',
    'helper_msa_ldi_df',
    'helper_msa_slli_df',
    'helper_msa_srai_df',
    'helper_msa_srli_df',
    'helper_msa_bclri_df',
    'helper_msa_bseti_df',
    'helper_msa_bnegi_df',
    'helper_msa_sat_s_df',
    'helper_msa_sat_u_df',
    'helper_msa_srari_df',
    'helper_msa_srlri_df',
    'helper_msa_binsli_df',
    'helper_msa_binsri_df',
    'helper_msa_sll_df',
    'helper_msa_sra_df',
    'helper_msa_srl_df',
    'helper_msa_bclr_df',
    'helper_msa_bset_df',
    'helper_msa_bneg_df',
    'helper_msa_addv_df',
    'helper_msa_subv_df',
    'helper_msa_max_s_df',
    'helper_msa_max_u_df',
    'helper_msa_min_s_df',
    'helper_msa_min_u_df',
    'helper_msa_max_a_df',
    'helper_msa_min_a_df',
    'helper_msa_ceq_df',
    'helper_msa_clt_s_df',
    'helper_msa_clt_u_df',
    'helper_msa_cle_s_df',
    'helper_msa_cle_u_df',
    'helper_msa_add_a_df',
    'helper_msa_adds_a_df',
    'helper_msa_adds_s_df',
    'helper_msa_adds_u_df',
    'helper_msa_ave_s_df',
    'helper_msa_ave_u_df',
    'helper_msa_aver_s_df',
    'helper_msa_aver_u_df',
    'helper_msa_subs_s_df',
    'helper_msa_subs_u_df',
    'helper_msa_subsus_u_df',
    'helper_msa_subsuu_s_df',
    'helper_msa_asub_s_df',
    'helper_msa_asub_u_df',
    'helper_msa_mulv_df',
    'helper_msa_div_s_df',
    'helper_msa_div_u_df',
    'helper_msa_mod_s_df',
    'helper_msa_mod_u_df',
    'helper_msa_dotp_s_df',
    'helper_msa_dotp_u_df',
    'helper_msa_srar_df',
    'helper_msa_srlr_df',
    'helper_msa_hadd_s_df',
    'helper_msa_hadd_u_df',
    'helper_msa_hsub_s_df',
    'helper_msa_hsub_u_df',
    'helper_msa_mul_q_df',
    'helper_msa_mulr_q_df',
    'helper_msa_sld_df',
    'helper_msa_maddv_df',
    'helper_msa_msubv_df',
    'helper_msa_dpadd_s_df',
    'helper_msa_dpadd_u_df',
    'helper_msa_dpsub_s_df',
    'helper_msa_dpsub_u_df',
    'helper_msa_binsl_df',
    'helper_msa_binsr_df',
    'helper_msa_madd_q_df',
    'helper_msa_msub_q_df',
    'helper_msa_maddr_q_df',
    'helper_msa_msubr_q_df',
    'helper_msa_splat_df',
    'helper_msa_pckev_df',
    'helper_msa_pckod_df',
    'helper_msa_ilvl_df',
    'helper_msa_ilvr_df',
    'helper_msa_ilvev_df',
    'helper_msa_ilvod_df',
    'helper_msa_vshf_df',
    'helper_msa_sldi_df',
    'helper_msa_splati_df',
    'helper_msa_copy_s_df',
    'helper_msa_copy_u_df',
    'helper_msa_insert_df',
    'helper_msa_insve_df',
    'helper_msa_ctcmsa',
    'helper_msa_cfcmsa',
    'helper_msa_move_v',
    'helper_msa_fill_df',
    'helper_msa_nlzc_df',
    'helper_msa_nloc_df',
    'helper_msa_pcnt_df',
    'helper_msa_fcaf_df',
    'helper_msa_fcun_df',
    'helper_msa_fceq_df',
    'helper_msa_fcueq_df',
    'helper_msa_fclt_df',
    'helper_msa_fcult_df',
    'helper_msa_fcle_df',
    'helper_msa_fcule_df',
    'helper_msa_fsaf_df',
    'helper_msa_fsun_df',
    'helper_msa_fseq_df',
    'helper_msa_fsueq_df',
    'helper_msa_fslt_df',
    'helper_msa_fsult_df',
    'helper_msa_fsle_df',
    'helper_msa_fsule_df',
    'helper_msa_fcor_df',
    'helper_msa_fcune_df',
    'helper_msa_fcne_df',
    'helper_msa_fsor_df',
    'helper_msa_fsune_df',
    'helper_msa_fsne_df',
    'helper_msa_fadd_df',
    'helper_msa_fsub_df',
    'helper_msa_fmul_df',
    'helper_msa_fdiv_df',
    'helper_msa_fmadd_df',
    'helper_msa_fmsub_df',
    'helper_msa_fexp2_df',
    'helper_msa_fexdo_df',
    'helper_msa_ftq_df',
    'helper_msa_fmin_df',
    'helper_msa_fmin_a_df',
    'helper_msa_fmax_df',
    'helper_msa_fmax_a_df',
    'helper_msa_fclass_df',
    'helper_msa_ftrunc_s_df',
    'helper_msa_ftrunc_u_df',
    'helper_msa_fsqrt_df',
    'helper_msa_frsqrt_df',
    'helper_msa_frcp_df',
    'helper_msa_frint_df',
    'helper_msa_flog2_df',
    'helper_msa_fexupl_df',
    'helper_msa_fexupr_df',
    'helper_msa_ffql_df',
    'helper_msa_ffqr_df',
    'helper_msa_ftint_s_df',
    'helper_msa_ftint_u_df',
    'helper_msa_ffint_s_df',
    'helper_msa_ffint_u_df',
    'helper_paddsb',
    'helper_paddusb',
    'helper_paddsh',
    'helper_paddush',
    'helper_paddb',
    'helper_paddh',
    'helper_paddw',
    'helper_psubsb',
    'helper_psubusb',
    'helper_psubsh',
    'helper_psubush',
    'helper_psubb',
    'helper_psubh',
    'helper_psubw',
    'helper_pshufh',
    'helper_packsswh',
    'helper_packsshb',
    'helper_packushb',
    'helper_punpcklwd',
    'helper_punpckhwd',
    'helper_punpcklhw',
    'helper_punpckhhw',
    'helper_punpcklbh',
    'helper_punpckhbh',
    'helper_pavgh',
    'helper_pavgb',
    'helper_pmaxsh',
    'helper_pminsh',
    'helper_pmaxub',
    'helper_pminub',
    'helper_pcmpeqw',
    'helper_pcmpgtw',
    'helper_pcmpeqh',
    'helper_pcmpgth',
    'helper_pcmpeqb',
    'helper_pcmpgtb',
    'helper_psllw',
    'helper_psrlw',
    'helper_psraw',
    'helper_psllh',
    'helper_psrlh',
    'helper_psrah',
    'helper_pmullh',
    'helper_pmulhh',
    'helper_pmulhuh',
    'helper_pmaddhw',
    'helper_pasubub',
    'helper_biadd',
    'helper_pmovmskb',
    'helper_absq_s_ph',
    'helper_absq_s_qb',
    'helper_absq_s_w',
    'helper_addqh_ph',
    'helper_addqh_r_ph',
    'helper_addqh_r_w',
    'helper_addqh_w',
    'helper_adduh_qb',
    'helper_adduh_r_qb',
    'helper_subqh_ph',
    'helper_subqh_r_ph',
    'helper_subqh_r_w',
    'helper_subqh_w',
    'helper_addq_ph',
    'helper_addq_s_ph',
    'helper_addq_s_w',
    'helper_addu_ph',
    'helper_addu_qb',
    'helper_addu_s_ph',
    'helper_addu_s_qb',
    'helper_subq_ph',
    'helper_subq_s_ph',
    'helper_subq_s_w',
    'helper_subu_ph',
    'helper_subu_qb',
    'helper_subu_s_ph',
    'helper_subu_s_qb',
    'helper_subuh_qb',
    'helper_subuh_r_qb',
    'helper_addsc',
    'helper_addwc',
    'helper_modsub',
    'helper_raddu_w_qb',
    'helper_precr_qb_ph',
    'helper_precrq_qb_ph',
    'helper_precr_sra_ph_w',
    'helper_precr_sra_r_ph_w',
    'helper_precrq_ph_w',
    'helper_precrq_rs_ph_w',
    'helper_precrqu_s_qb_ph',
    'helper_precequ_ph_qbl',
    'helper_precequ_ph_qbr',
    'helper_precequ_ph_qbla',
    'helper_precequ_ph_qbra',
    'helper_preceu_ph_qbl',
    'helper_preceu_ph_qbr',
    'helper_preceu_ph_qbla',
    'helper_preceu_ph_qbra',
    'helper_shll_qb',
    'helper_shrl_qb',
    'helper_shra_qb',
    'helper_shra_r_qb',
    'helper_shll_ph',
    'helper_shll_s_ph',
    'helper_shll_s_w',
    'helper_shra_r_w',
    'helper_shrl_ph',
    'helper_shra_ph',
    'helper_shra_r_ph',
    'helper_muleu_s_ph_qbl',
    'helper_muleu_s_ph_qbr',
    'helper_mulq_rs_ph',
    'helper_mul_ph',
    'helper_mul_s_ph',
    'helper_mulq_s_ph',
    'helper_muleq_s_w_phl',
    'helper_muleq_s_w_phr',
    'helper_mulsaq_s_w_ph',
    'helper_mulsa_w_ph',
    'helper_dpau_h_qbl',
    'helper_dpau_h_qbr',
    'helper_dpsu_h_qbl',
    'helper_dpsu_h_qbr',
    'helper_dpa_w_ph',
    'helper_dpax_w_ph',
    'helper_dps_w_ph',
    'helper_dpsx_w_ph',
    'helper_dpaq_s_w_ph',
    'helper_dpaqx_s_w_ph',
    'helper_dpsq_s_w_ph',
    'helper_dpsqx_s_w_ph',
    'helper_dpaqx_sa_w_ph',
    'helper_dpsqx_sa_w_ph',
    'helper_dpaq_sa_l_w',
    'helper_dpsq_sa_l_w',
    'helper_maq_s_w_phl',
    'helper_maq_s_w_phr',
    'helper_maq_sa_w_phl',
    'helper_maq_sa_w_phr',
    'helper_mulq_s_w',
    'helper_mulq_rs_w',
    'helper_bitrev',
    'helper_insv',
    'helper_cmpgu_eq_qb',
    'helper_cmpgu_lt_qb',
    'helper_cmpgu_le_qb',
    'helper_cmpu_eq_qb',
    'helper_cmpu_lt_qb',
    'helper_cmpu_le_qb',
    'helper_cmp_eq_ph',
    'helper_cmp_lt_ph',
    'helper_cmp_le_ph',
    'helper_pick_qb',
    'helper_pick_ph',
    'helper_packrl_ph',
    'helper_extr_w',
    'helper_extr_r_w',
    'helper_extr_rs_w',
    'helper_extr_s_h',
    'helper_extp',
    'helper_extpdp',
    'helper_shilo',
    'helper_mthlip',
    'cpu_wrdsp',
    'helper_wrdsp',
    'cpu_rddsp',
    'helper_rddsp',
    'helper_raise_exception_err',
    'helper_clo',
    'helper_clz',
    'helper_muls',
    'helper_mulsu',
    'helper_macc',
    'helper_macchi',
    'helper_maccu',
    'helper_macchiu',
    'helper_msac',
    'helper_msachi',
    'helper_msacu',
    'helper_msachiu',
    'helper_mulhi',
    'helper_mulhiu',
    'helper_mulshi',
    'helper_mulshiu',
    'helper_bitswap',
    'helper_ll',
    'helper_sc',
    'helper_swl',
    'helper_swr',
    'helper_lwm',
    'helper_swm',
    'helper_mfc0_mvpcontrol',
    'helper_mfc0_mvpconf0',
    'helper_mfc0_mvpconf1',
    'helper_mfc0_random',
    'helper_mfc0_tcstatus',
    'helper_mftc0_tcstatus',
    'helper_mfc0_tcbind',
    'helper_mftc0_tcbind',
    'helper_mfc0_tcrestart',
    'helper_mftc0_tcrestart',
    'helper_mfc0_tchalt',
    'helper_mftc0_tchalt',
    'helper_mfc0_tccontext',
    'helper_mftc0_tccontext',
    'helper_mfc0_tcschedule',
    'helper_mftc0_tcschedule',
    'helper_mfc0_tcschefback',
    'helper_mftc0_tcschefback',
    'helper_mfc0_count',
    'helper_mftc0_entryhi',
    'helper_mftc0_cause',
    'helper_mftc0_status',
    'helper_mfc0_lladdr',
    'helper_mfc0_watchlo',
    'helper_mfc0_watchhi',
    'helper_mfc0_debug',
    'helper_mftc0_debug',
    'helper_mtc0_index',
    'helper_mtc0_mvpcontrol',
    'helper_mtc0_vpecontrol',
    'helper_mttc0_vpecontrol',
    'helper_mftc0_vpecontrol',
    'helper_mftc0_vpeconf0',
    'helper_mtc0_vpeconf0',
    'helper_mttc0_vpeconf0',
    'helper_mtc0_vpeconf1',
    'helper_mtc0_yqmask',
    'helper_mtc0_vpeopt',
    'helper_mtc0_entrylo0',
    'helper_mtc0_tcstatus',
    'helper_mttc0_tcstatus',
    'helper_mtc0_tcbind',
    'helper_mttc0_tcbind',
    'helper_mtc0_tcrestart',
    'helper_mttc0_tcrestart',
    'helper_mtc0_tchalt',
    'helper_mttc0_tchalt',
    'helper_mtc0_tccontext',
    'helper_mttc0_tccontext',
    'helper_mtc0_tcschedule',
    'helper_mttc0_tcschedule',
    'helper_mtc0_tcschefback',
    'helper_mttc0_tcschefback',
    'helper_mtc0_entrylo1',
    'helper_mtc0_context',
    'helper_mtc0_pagemask',
    'helper_mtc0_pagegrain',
    'helper_mtc0_wired',
    'helper_mtc0_srsconf0',
    'helper_mtc0_srsconf1',
    'helper_mtc0_srsconf2',
    'helper_mtc0_srsconf3',
    'helper_mtc0_srsconf4',
    'helper_mtc0_hwrena',
    'helper_mtc0_count',
    'helper_mtc0_entryhi',
    'helper_mttc0_entryhi',
    'helper_mtc0_compare',
    'helper_mtc0_status',
    'helper_mttc0_status',
    'helper_mtc0_intctl',
    'helper_mtc0_srsctl',
    'helper_mtc0_cause',
    'helper_mttc0_cause',
    'helper_mftc0_epc',
    'helper_mftc0_ebase',
    'helper_mtc0_ebase',
    'helper_mttc0_ebase',
    'helper_mftc0_configx',
    'helper_mtc0_config0',
    'helper_mtc0_config2',
    'helper_mtc0_config4',
    'helper_mtc0_config5',
    'helper_mtc0_lladdr',
    'helper_mtc0_watchlo',
    'helper_mtc0_watchhi',
    'helper_mtc0_xcontext',
    'helper_mtc0_framemask',
    'helper_mtc0_debug',
    'helper_mttc0_debug',
    'helper_mtc0_performance0',
    'helper_mtc0_taglo',
    'helper_mtc0_datalo',
    'helper_mtc0_taghi',
    'helper_mtc0_datahi',
    'helper_mftgpr',
    'helper_mftlo',
    'helper_mfthi',
    'helper_mftacx',
    'helper_mftdsp',
    'helper_mttgpr',
    'helper_mttlo',
    'helper_mtthi',
    'helper_mttacx',
    'helper_mttdsp',
    'helper_dmt',
    'helper_emt',
    'helper_dvpe',
    'helper_evpe',
    'helper_fork',
    'helper_yield',
    'r4k_helper_tlbinv',
    'r4k_helper_tlbinvf',
    'r4k_helper_tlbwi',
    'r4k_helper_tlbwr',
    'r4k_helper_tlbp',
    'r4k_helper_tlbr',
    'helper_tlbwi',
    'helper_tlbwr',
    'helper_tlbp',
    'helper_tlbr',
    'helper_tlbinv',
    'helper_tlbinvf',
    'helper_di',
    'helper_ei',
    'helper_eret',
    'helper_deret',
    'helper_rdhwr_cpunum',
    'helper_rdhwr_synci_step',
    'helper_rdhwr_cc',
    'helper_rdhwr_ccres',
    'helper_pmon',
    'helper_wait',
    'mips_cpu_do_unaligned_access',
    'mips_cpu_unassigned_access',
    'ieee_rm',
    'helper_cfc1',
    'helper_ctc1',
    'ieee_ex_to_mips',
    'helper_float_sqrt_d',
    'helper_float_sqrt_s',
    'helper_float_cvtd_s',
    'helper_float_cvtd_w',
    'helper_float_cvtd_l',
    'helper_float_cvtl_d',
    'helper_float_cvtl_s',
    'helper_float_cvtps_pw',
    'helper_float_cvtpw_ps',
    'helper_float_cvts_d',
    'helper_float_cvts_w',
    'helper_float_cvts_l',
    'helper_float_cvts_pl',
    'helper_float_cvts_pu',
    'helper_float_cvtw_s',
    'helper_float_cvtw_d',
    'helper_float_roundl_d',
    'helper_float_roundl_s',
    'helper_float_roundw_d',
    'helper_float_roundw_s',
    'helper_float_truncl_d',
    'helper_float_truncl_s',
    'helper_float_truncw_d',
    'helper_float_truncw_s',
    'helper_float_ceill_d',
    'helper_float_ceill_s',
    'helper_float_ceilw_d',
    'helper_float_ceilw_s',
    'helper_float_floorl_d',
    'helper_float_floorl_s',
    'helper_float_floorw_d',
    'helper_float_floorw_s',
    'helper_float_abs_d',
    'helper_float_abs_s',
    'helper_float_abs_ps',
    'helper_float_chs_d',
    'helper_float_chs_s',
    'helper_float_chs_ps',
    'helper_float_maddf_s',
    'helper_float_maddf_d',
    'helper_float_msubf_s',
    'helper_float_msubf_d',
    'helper_float_max_s',
    'helper_float_max_d',
    'helper_float_maxa_s',
    'helper_float_maxa_d',
    'helper_float_min_s',
    'helper_float_min_d',
    'helper_float_mina_s',
    'helper_float_mina_d',
    'helper_float_rint_s',
    'helper_float_rint_d',
    'helper_float_class_s',
    'helper_float_class_d',
    'helper_float_recip_d',
    'helper_float_recip_s',
    'helper_float_rsqrt_d',
    'helper_float_rsqrt_s',
    'helper_float_recip1_d',
    'helper_float_recip1_s',
    'helper_float_recip1_ps',
    'helper_float_rsqrt1_d',
    'helper_float_rsqrt1_s',
    'helper_float_rsqrt1_ps',
    'helper_float_add_d',
    'helper_float_add_s',
    'helper_float_add_ps',
    'helper_float_sub_d',
    'helper_float_sub_s',
    'helper_float_sub_ps',
    'helper_float_mul_d',
    'helper_float_mul_s',
    'helper_float_mul_ps',
    'helper_float_div_d',
    'helper_float_div_s',
    'helper_float_div_ps',
    'helper_float_madd_d',
    'helper_float_madd_s',
    'helper_float_madd_ps',
    'helper_float_msub_d',
    'helper_float_msub_s',
    'helper_float_msub_ps',
    'helper_float_nmadd_d',
    'helper_float_nmadd_s',
    'helper_float_nmadd_ps',
    'helper_float_nmsub_d',
    'helper_float_nmsub_s',
    'helper_float_nmsub_ps',
    'helper_float_recip2_d',
    'helper_float_recip2_s',
    'helper_float_recip2_ps',
    'helper_float_rsqrt2_d',
    'helper_float_rsqrt2_s',
    'helper_float_rsqrt2_ps',
    'helper_float_addr_ps',
    'helper_float_mulr_ps',
    'helper_cmp_d_f',
    'helper_cmpabs_d_f',
    'helper_cmp_d_un',
    'helper_cmpabs_d_un',
    'helper_cmp_d_eq',
    'helper_cmpabs_d_eq',
    'helper_cmp_d_ueq',
    'helper_cmpabs_d_ueq',
    'helper_cmp_d_olt',
    'helper_cmpabs_d_olt',
    'helper_cmp_d_ult',
    'helper_cmpabs_d_ult',
    'helper_cmp_d_ole',
    'helper_cmpabs_d_ole',
    'helper_cmp_d_ule',
    'helper_cmpabs_d_ule',
    'helper_cmp_d_sf',
    'helper_cmpabs_d_sf',
    'helper_cmp_d_ngle',
    'helper_cmpabs_d_ngle',
    'helper_cmp_d_seq',
    'helper_cmpabs_d_seq',
    'helper_cmp_d_ngl',
    'helper_cmpabs_d_ngl',
    'helper_cmp_d_lt',
    'helper_cmpabs_d_lt',
    'helper_cmp_d_nge',
    'helper_cmpabs_d_nge',
    'helper_cmp_d_le',
    'helper_cmpabs_d_le',
    'helper_cmp_d_ngt',
    'helper_cmpabs_d_ngt',
    'helper_cmp_s_f',
    'helper_cmpabs_s_f',
    'helper_cmp_s_un',
    'helper_cmpabs_s_un',
    'helper_cmp_s_eq',
    'helper_cmpabs_s_eq',
    'helper_cmp_s_ueq',
    'helper_cmpabs_s_ueq',
    'helper_cmp_s_olt',
    'helper_cmpabs_s_olt',
    'helper_cmp_s_ult',
    'helper_cmpabs_s_ult',
    'helper_cmp_s_ole',
    'helper_cmpabs_s_ole',
    'helper_cmp_s_ule',
    'helper_cmpabs_s_ule',
    'helper_cmp_s_sf',
    'helper_cmpabs_s_sf',
    'helper_cmp_s_ngle',
    'helper_cmpabs_s_ngle',
    'helper_cmp_s_seq',
    'helper_cmpabs_s_seq',
    'helper_cmp_s_ngl',
    'helper_cmpabs_s_ngl',
    'helper_cmp_s_lt',
    'helper_cmpabs_s_lt',
    'helper_cmp_s_nge',
    'helper_cmpabs_s_nge',
    'helper_cmp_s_le',
    'helper_cmpabs_s_le',
    'helper_cmp_s_ngt',
    'helper_cmpabs_s_ngt',
    'helper_cmp_ps_f',
    'helper_cmpabs_ps_f',
    'helper_cmp_ps_un',
    'helper_cmpabs_ps_un',
    'helper_cmp_ps_eq',
    'helper_cmpabs_ps_eq',
    'helper_cmp_ps_ueq',
    'helper_cmpabs_ps_ueq',
    'helper_cmp_ps_olt',
    'helper_cmpabs_ps_olt',
    'helper_cmp_ps_ult',
    'helper_cmpabs_ps_ult',
    'helper_cmp_ps_ole',
    'helper_cmpabs_ps_ole',
    'helper_cmp_ps_ule',
    'helper_cmpabs_ps_ule',
    'helper_cmp_ps_sf',
    'helper_cmpabs_ps_sf',
    'helper_cmp_ps_ngle',
    'helper_cmpabs_ps_ngle',
    'helper_cmp_ps_seq',
    'helper_cmpabs_ps_seq',
    'helper_cmp_ps_ngl',
    'helper_cmpabs_ps_ngl',
    'helper_cmp_ps_lt',
    'helper_cmpabs_ps_lt',
    'helper_cmp_ps_nge',
    'helper_cmpabs_ps_nge',
    'helper_cmp_ps_le',
    'helper_cmpabs_ps_le',
    'helper_cmp_ps_ngt',
    'helper_cmpabs_ps_ngt',
    'helper_r6_cmp_d_af',
    'helper_r6_cmp_d_un',
    'helper_r6_cmp_d_eq',
    'helper_r6_cmp_d_ueq',
    'helper_r6_cmp_d_lt',
    'helper_r6_cmp_d_ult',
    'helper_r6_cmp_d_le',
    'helper_r6_cmp_d_ule',
    'helper_r6_cmp_d_saf',
    'helper_r6_cmp_d_sun',
    'helper_r6_cmp_d_seq',
    'helper_r6_cmp_d_sueq',
    'helper_r6_cmp_d_slt',
    'helper_r6_cmp_d_sult',
    'helper_r6_cmp_d_sle',
    'helper_r6_cmp_d_sule',
    'helper_r6_cmp_d_or',
    'helper_r6_cmp_d_une',
    'helper_r6_cmp_d_ne',
    'helper_r6_cmp_d_sor',
    'helper_r6_cmp_d_sune',
    'helper_r6_cmp_d_sne',
    'helper_r6_cmp_s_af',
    'helper_r6_cmp_s_un',
    'helper_r6_cmp_s_eq',
    'helper_r6_cmp_s_ueq',
    'helper_r6_cmp_s_lt',
    'helper_r6_cmp_s_ult',
    'helper_r6_cmp_s_le',
    'helper_r6_cmp_s_ule',
    'helper_r6_cmp_s_saf',
    'helper_r6_cmp_s_sun',
    'helper_r6_cmp_s_seq',
    'helper_r6_cmp_s_sueq',
    'helper_r6_cmp_s_slt',
    'helper_r6_cmp_s_sult',
    'helper_r6_cmp_s_sle',
    'helper_r6_cmp_s_sule',
    'helper_r6_cmp_s_or',
    'helper_r6_cmp_s_une',
    'helper_r6_cmp_s_ne',
    'helper_r6_cmp_s_sor',
    'helper_r6_cmp_s_sune',
    'helper_r6_cmp_s_sne',
    'helper_msa_ld_df',
    'helper_msa_st_df',
    'no_mmu_map_address',
    'fixed_mmu_map_address',
    'r4k_map_address',
    'mips_cpu_get_phys_page_debug',
    'mips_cpu_handle_mmu_fault',
    'cpu_mips_translate_address',
    'exception_resume_pc',
    'mips_cpu_do_interrupt',
    'mips_cpu_exec_interrupt',
    'r4k_invalidate_tlb',
    'helper_absq_s_ob',
    'helper_absq_s_qh',
    'helper_absq_s_pw',
    'helper_adduh_ob',
    'helper_adduh_r_ob',
    'helper_subuh_ob',
    'helper_subuh_r_ob',
    'helper_addq_pw',
    'helper_addq_qh',
    'helper_addq_s_pw',
    'helper_addq_s_qh',
    'helper_addu_ob',
    'helper_addu_qh',
    'helper_addu_s_ob',
    'helper_addu_s_qh',
    'helper_subq_pw',
    'helper_subq_qh',
    'helper_subq_s_pw',
    'helper_subq_s_qh',
    'helper_subu_ob',
    'helper_subu_qh',
    'helper_subu_s_ob',
    'helper_subu_s_qh',
    'helper_raddu_l_ob',
    'helper_precr_ob_qh',
    'helper_precr_sra_qh_pw',
    'helper_precr_sra_r_qh_pw',
    'helper_precrq_ob_qh',
    'helper_precrq_qh_pw',
    'helper_precrq_rs_qh_pw',
    'helper_precrq_pw_l',
    'helper_precrqu_s_ob_qh',
    'helper_preceq_pw_qhl',
    'helper_preceq_pw_qhr',
    'helper_preceq_pw_qhla',
    'helper_preceq_pw_qhra',
    'helper_precequ_qh_obl',
    'helper_precequ_qh_obr',
    'helper_precequ_qh_obla',
    'helper_precequ_qh_obra',
    'helper_preceu_qh_obl',
    'helper_preceu_qh_obr',
    'helper_preceu_qh_obla',
    'helper_preceu_qh_obra',
    'helper_shll_ob',
    'helper_shrl_ob',
    'helper_shra_ob',
    'helper_shra_r_ob',
    'helper_shll_qh',
    'helper_shll_s_qh',
    'helper_shrl_qh',
    'helper_shra_qh',
    'helper_shra_r_qh',
    'helper_shll_pw',
    'helper_shll_s_pw',
    'helper_shra_pw',
    'helper_shra_r_pw',
    'helper_muleu_s_qh_obl',
    'helper_muleu_s_qh_obr',
    'helper_mulq_rs_qh',
    'helper_muleq_s_pw_qhl',
    'helper_muleq_s_pw_qhr',
    'helper_mulsaq_s_w_qh',
    'helper_dpau_h_obl',
    'helper_dpau_h_obr',
    'helper_dpsu_h_obl',
    'helper_dpsu_h_obr',
    'helper_dpa_w_qh',
    'helper_dpaq_s_w_qh',
    'helper_dps_w_qh',
    'helper_dpsq_s_w_qh',
    'helper_dpaq_sa_l_pw',
    'helper_dpsq_sa_l_pw',
    'helper_mulsaq_s_l_pw',
    'helper_maq_s_w_qhll',
    'helper_maq_s_w_qhlr',
    'helper_maq_s_w_qhrl',
    'helper_maq_s_w_qhrr',
    'helper_maq_sa_w_qhll',
    'helper_maq_sa_w_qhlr',
    'helper_maq_sa_w_qhrl',
    'helper_maq_sa_w_qhrr',
    'helper_maq_s_l_pwl',
    'helper_maq_s_l_pwr',
    'helper_dmadd',
    'helper_dmaddu',
    'helper_dmsub',
    'helper_dmsubu',
    'helper_dinsv',
    'helper_cmpgu_eq_ob',
    'helper_cmpgu_lt_ob',
    'helper_cmpgu_le_ob',
    'helper_cmpu_eq_ob',
    'helper_cmpu_lt_ob',
    'helper_cmpu_le_ob',
    'helper_cmp_eq_qh',
    'helper_cmp_lt_qh',
    'helper_cmp_le_qh',
    'helper_cmp_eq_pw',
    'helper_cmp_lt_pw',
    'helper_cmp_le_pw',
    'helper_cmpgdu_eq_ob',
    'helper_cmpgdu_lt_ob',
    'helper_cmpgdu_le_ob',
    'helper_pick_ob',
    'helper_pick_qh',
    'helper_pick_pw',
    'helper_packrl_pw',
    'helper_dextr_w',
    'helper_dextr_r_w',
    'helper_dextr_rs_w',
    'helper_dextr_l',
    'helper_dextr_r_l',
    'helper_dextr_rs_l',
    'helper_dextr_s_h',
    'helper_dextp',
    'helper_dextpdp',
    'helper_dshilo',
    'helper_dmthlip',
    'helper_dclo',
    'helper_dclz',
    'helper_dbitswap',
    'helper_lld',
    'helper_scd',
    'helper_sdl',
    'helper_sdr',
    'helper_ldm',
    'helper_sdm',
    'helper_dmfc0_tcrestart',
    'helper_dmfc0_tchalt',
    'helper_dmfc0_tccontext',
    'helper_dmfc0_tcschedule',
    'helper_dmfc0_tcschefback',
    'helper_dmfc0_lladdr',
    'helper_dmfc0_watchlo',
    'helper_dmtc0_entrylo0',
    'helper_dmtc0_entrylo1',
    'mips_reg_reset',
    'mips_reg_read',
    'mips_reg_write',
    'mips_tcg_init',
    'mips_cpu_list',
    'mips_release',
    'MIPS64_REGS_STORAGE_SIZE',
    'MIPS_REGS_STORAGE_SIZE'
)

sparc_symbols = (
    'cpu_sparc_exec',
    'helper_compute_psr',
    'helper_compute_C_icc',
    'cpu_sparc_init',
    'cpu_sparc_set_id',
    'sparc_cpu_register_types',
    'helper_fadds',
    'helper_faddd',
    'helper_faddq',
    'helper_fsubs',
    'helper_fsubd',
    'helper_fsubq',
    'helper_fmuls',
    'helper_fmuld',
    'helper_fmulq',
    'helper_fdivs',
    'helper_fdivd',
    'helper_fdivq',
    'helper_fsmuld',
    'helper_fdmulq',
    'helper_fnegs',
    'helper_fitos',
    'helper_fitod',
    'helper_fitoq',
    'helper_fdtos',
    'helper_fstod',
    'helper_fqtos',
    'helper_fstoq',
    'helper_fqtod',
    'helper_fdtoq',
    'helper_fstoi',
    'helper_fdtoi',
    'helper_fqtoi',
    'helper_fabss',
    'helper_fsqrts',
    'helper_fsqrtd',
    'helper_fsqrtq',
    'helper_fcmps',
    'helper_fcmpd',
    'helper_fcmpes',
    'helper_fcmped',
    'helper_fcmpq',
    'helper_fcmpeq',
    'helper_ldfsr',
    'helper_debug',
    'helper_udiv_cc',
    'helper_sdiv_cc',
    'helper_taddcctv',
    'helper_tsubcctv',
    'sparc_cpu_do_interrupt',
    'helper_check_align',
    'helper_ld_asi',
    'helper_st_asi',
    'helper_cas_asi',
    'helper_ldqf',
    'helper_stqf',
    'sparc_cpu_unassigned_access',
    'sparc_cpu_do_unaligned_access',
    'sparc_cpu_handle_mmu_fault',
    'dump_mmu',
    'sparc_cpu_get_phys_page_debug',
    'sparc_reg_reset',
    'sparc_reg_read',
    'sparc_reg_write',
    'gen_intermediate_code_init',
    'cpu_set_cwp',
    'cpu_get_psr',
    'cpu_put_psr',
    'cpu_cwp_inc',
    'cpu_cwp_dec',
    'helper_save',
    'helper_restore')


if __name__ == '__main__':
  arch = sys.argv[1]

  print("/* Autogen header for Unicorn Engine - DONOT MODIFY */")
  print("#ifndef UNICORN_AUTOGEN_%s_H" %arch.upper())
  print("#define UNICORN_AUTOGEN_%s_H" %arch.upper())

  for s in symbols:
      print("#define %s %s_%s" %(s, s, arch))

  if 'arm' in arch:
    for s in arm_symbols:
      print("#define %s %s_%s" %(s, s, arch))

  if 'aarch64' in arch:
    for s in aarch64_symbols:
      print("#define %s %s_%s" %(s, s, arch))

  if 'mips' in arch:
    for s in mips_symbols:
      print("#define %s %s_%s" %(s, s, arch))

  if 'sparc' in arch:
    for s in sparc_symbols:
      print("#define %s %s_%s" %(s, s, arch))

  print("#endif")

