#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#Do not change these during runtime!

import logging; logger = logging.getLogger(__name__); logger.info("import")

METADATA={
    #The pretty name of this program. Used for NSM display and Jack client name
    #Can contain everything a linux file/path supports. Never change this or it will break the
    #session, making your file unable to load and destroying saved Jack connections.
    "name" : "Vico",

    #Set this to the name the user types into a terminal.
    #MUST be the same as the binary name as well as the name in configure.
    #Program reports that as proc title so you can killall it by name.
    #Should not contain spaces or special characters. We use this as save file extension as well
    #to distinguish between compatible program versions. In basic programs this will just be e.g.
    #patroneo. But in complex programs with a bright future it will be "laborejo1" "laborejo2" etc.
    "shortName" : "vico",

    #A very short description used in various places: Desktop file, overview on the website,
    #release announcements, entries in software directories etc.
    "tagline" : 'Minimalistic MIDI sequencer. One input, one output, one piano roll with multiple layers.',

    "version" : "1.2.2",
    "year" : "2021",
    "author" : "Laborejo Software Suite",
    "url" : "https://www.laborejo.org/vico",

    "supportedLanguages" : {"German":"de.qm"},

    #Show the About Dialog the first time the program starts up. This is the initial state for a
    #new instance in NSM, not the saved state! Decide on how annoying it would be for every new
    #instance to show about. Fluajho does not show it because you add it many times into a session.
    #Patroneo does because its only added once.
    "showAboutDialogFirstStart" : True,

    #If your program handles very small duration with n-tuplets you should increase D4.
    #This will not be visible to the outside jack world
    #Take into account if the GUI needs to display these directly related to the tick value.
    #E.g. division by a factor of 7. To avoid rounding errors assume your smallest duration
    #(D1024 by default, if not limited by your client) and divide by your GUIs tickToPixel factor
    #including stretchX
    "quarterNoteInTicks" : 840,  #210 was not enough because the GUI devides by 7 for snap to grid and runs into rounding errors

    #How many audio outputs do you want? must be pairs. These are just unconnected jack outputs
    #that need to be connected internally to instrument outputs like fluidsynth
    "cboxOutputs" : 2 * 0,

    #Does the program uses a metronome? In this case you need at least two cboxOutputs above
    "metronome" : False,

    #Various strings for the README
    #Extra whitespace will be stripped so we don't need to worry about docstring indentation
    "description" : """
THIS PROGRAM IS NO LONGER IN DEVELOPMENT. NO FURTHER UPDATES!
In August 2020 it became clear that the choice of programming languages and libraries lead to grave performance problems.
Combined with the fact that this is hardly a unique program, a piano roll midi sequencer, it has been decided that
no further development will happen. Here is the original description of the program:

Vico is a minimalistic Midi sequencer that is intended to be used in parallel with other software.

"Vico" (with c like ts in "bats") just means "sequence" or "order" in Esperanto for obvious reasons.

In a loop- or pattern based environment you often want to have a 'free flowing' track in order to
create an instrumental solo, for example. Sometimes you just want to record a sketch or an idea
quickly and not open or create an entire DAW project.

Vico fulfills these conditions by connecting exactly one source to one output, and records and
plays back in between. Or to put it another way: you only get one track, intended
for one instrument (but with convenient layers).

Vico has been written primarily for users of Patroneo, but has no closer technical bond. Patroneo
is a program characterized by strict repetitions and constant reuse of very short patterns. With
this you can quickly create whole arrangements for drums, bass and accompaniment chords, but a
beautiful, long melody is extremely cumbersome. Therefore Vico wants to solve this problem.

However, all programs that run as JACK transport masters or JACK timebase masters are suitable as
"remote control".
""",

    "dependencies" : "\n".join("* "+dep for dep in ()),
}
