#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2021, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

Laborejo2 is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import logging; logger = logging.getLogger(__name__); logger.info("import")

from template.qtgui.constantsAndConfigs import ConstantsAndConfigs as TemplateConstantsAndConfigs

class ConstantsAndConfigs(TemplateConstantsAndConfigs):
    def __init__(self):        
        super().__init__()        
        self.ticksToPixelRatio = 16 #D4 is 840 ticks.  840/16 = one quarter notes in pixel
        self.stafflineGap = 10 #this is not only for Laborejo but also the grids vertical line spacing. Cannot be changed in runtime
        self.scoreHeight = self.stafflineGap * 128 #notes
        self.snapToDot = None #set during mainWindow init
        self.snapToGrid = None #set during mainWindow init
        
constantsAndConfigs = ConstantsAndConfigs() #singleton
