#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2021, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

"""
This file handles various pitches and their conversions.
"""


import logging; logger = logging.getLogger(__name__); logger.info("import")


#Third Party Modules
#Template Modules
#Our modules

#https://www.midi.org/specifications-old/item/table-3-control-change-messages-data-bytes-2

ccList = """Bank Select
Modulation Wheel or Lever
Breath Controller
Undefined
Foot Controller
Portamento Time
Data Entry MSB
Channel Volume
Balance
Undefined
Pan
Expression Controller
Effect Control 1
Effect Control 2
Undefined
Undefined
General Purpose Controller 1
General Purpose Controller 2
General Purpose Controller 3
General Purpose Controller 4
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
LSB for Control 0 (Bank Select)
LSB for Control 1 (Modulation Wheel or Lever)
LSB for Control 2 (Breath Controller)
LSB for Control 3 (Undefined)
LSB for Control 4 (Foot Controller)
LSB for Control 5 (Portamento Time)
LSB for Control 6 (Data Entry)
LSB for Control 7 (Channel Volume, formerly Main Volume)
LSB for Control 8 (Balance)
LSB for Control 9 (Undefined)
LSB for Control 10 (Pan)
LSB for Control 11 (Expression Controller)
LSB for Control 12 (Effect control 1)
LSB for Control 13 (Effect control 2)
LSB for Control 14 (Undefined)
LSB for Control 15 (Undefined)
LSB for Control 16 (General Purpose Controller 1)
LSB for Control 17 (General Purpose Controller 2)
LSB for Control 18 (General Purpose Controller 3)
LSB for Control 19 (General Purpose Controller 4)
LSB for Control 20 (Undefined)
LSB for Control 21 (Undefined)
LSB for Control 22 (Undefined)
LSB for Control 23 (Undefined)
LSB for Control 24 (Undefined)
LSB for Control 25 (Undefined)
LSB for Control 26 (Undefined)
LSB for Control 27 (Undefined)
LSB for Control 28 (Undefined)
LSB for Control 29 (Undefined)
LSB for Control 30 (Undefined)
LSB for Control 31 (Undefined)
Damper Pedal on/off (Sustain)   ≤63 off, ≥64 on
Portamento On/Off   ≤63 off, ≥64 on
Sostenuto On/Off    ≤63 off, ≥64 on
Soft Pedal On/Off   ≤63 off, ≥64 on
Legato Footswitch   ≤63 Normal, ≥64 Legato
Hold 2  ≤63 off, ≥64 on     ---
Sound Controller 1 (default: Sound Variation)   0-127   LSB
Sound Controller 2 (default: Timbre/Harmonic Intens.)   0-127   LSB
Sound Controller 3 (default: Release Time)  0-127   LSB
Sound Controller 4 (default: Attack Time)   0-127   LSB
Sound Controller 5 (default: Brightness)    0-127   LSB
Sound Controller 6 (default: Decay Time - see MMA RP-021)   0-127   LSB
Sound Controller 7 (default: Vibrato Rate - see MMA RP-021)     0-127   LSB
Sound Controller 8 (default: Vibrato Depth - see MMA RP-021)    0-127   LSB
Sound Controller 9 (default: Vibrato Delay - see MMA RP-021)    0-127   LSB
Sound Controller 10 (default undefined - see MMA RP-021)    0-127   LSB
General Purpose Controller 5
General Purpose Controller 6
General Purpose Controller 7
General Purpose Controller 8
Portamento Control
Undefined
Undefined
Undefined
High Resolution Velocity Prefix     0-127   LSB
Undefined
Undefined
Effects 1 Depth (default: Reverb Send Level
Effects 2 Depth (formerly Tremolo Depth)
Effects 3 Depth (default: Chorus Send Level
Effects 4 Depth (formerly Celeste [Detune] Depth)
Effects 5 Depth (formerly Phaser Depth)
Data Increment (Data Entry +1)
Data Decrement (Data Entry -1)
Non-Registered Parameter Number (NRPN) - LSB
Non-Registered Parameter Number (NRPN) - MSB
Registered Parameter Number (RPN) - LSB
Registered Parameter Number (RPN) - MSB
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
Undefined
[Channel Mode Message] All Sound Off
[Channel Mode Message] Reset All Controllers
[Channel Mode Message] Local Control On/Off
[Channel Mode Message] All Notes Off
[Channel Mode Message] Omni Mode Off (+ all notes off)
[Channel Mode Message] Omni Mode On (+ all notes off)
[Channel Mode Message] Mono Mode On (+ poly off, + all notes off)
[Channel Mode Message] Poly Mode On (+ mono off, +all notes off)""".split("\n")

enumeratedCCList = [str(i).zfill(3) + ": " + s for i,s in enumerate(ccList)]


programList = [
    "Acoustic Grand Piano",
    "Bright Acoustic Piano",
    "Electric Grand Piano",
    "Honky-tonk Piano",
    "Electric Piano 1",
    "Electric Piano 2",
    "Harpsichord",
    "Clavinet",

    "Celesta",
    "Glockenspiel",
    "Music Box",
    "Vibraphone",
    "Marimba",
    "Xylophone",
    "Tubular Bells",
    "Dulcimer",

    "Drawbar Organ",
    "Percussive Organ",
    "Rock Organ",
    "Church Organ",
    "Reed Organ",
    "Accordion",
    "Harmonica",
    "Tango Accordion",

    "Acoustic Guitar (nylon)",
    "Acoustic Guitar (steel)",
    "Electric Guitar (jazz)",
    "Electric Guitar (clean)",
    "Electric Guitar (muted)",
    "Overdriven Guitar",
    "Distortion Guitar",
    "Guitar harmonics",

    "Acoustic Bass",
    "Electric Bass (finger)",
    "Electric Bass (pick)",
    "Fretless Bass",
    "Slap Bass 1",
    "Slap Bass 2",
    "Synth Bass 1",
    "Synth Bass 2",

    "Violin",
    "Viola",
    "Cello",
    "Contrabass",
    "Tremolo Strings",
    "Pizzicato Strings",
    "Orchestral Harp",
    "Timpani",

    "String Ensemble 1",
    "String Ensemble 2",
    "Synth Strings 1",
    "Synth Strings 2",
    "Choir Aahs",
    "Voice Oohs",
    "Synth Voice",
    "Orchestra Hit",

    "Trumpet",
    "Trombone",
    "Tuba",
    "Muted Trumpet",
    "French Horn",
    "Brass Section",
    "Synth Brass 1",
    "Synth Brass 2",

    "Soprano Sax",
    "Alto Sax",
    "Tenor Sax",
    "Baritone Sax",
    "Oboe",
    "English Horn",
    "Bassoon",
    "Clarinet",

    "Piccolo",
    "Flute",
    "Recorder",
    "Pan Flute",
    "Blown Bottle",
    "Shakuhachi",
    "Whistle",
    "Ocarina",

    "Lead 1 (square)",
    "Lead 2 (sawtooth)",
    "Lead 3 (calliope)",
    "Lead 4 (chiff)",
    "Lead 5 (charang)",
    "Lead 6 (voice)",
    "Lead 7 (fifths)",
    "Lead 8 (bass + lead)",

    "Pad 1 (new age)",
    "Pad 2 (warm)",
    "Pad 3 (polysynth)",
    "Pad 4 (choir)",
    "Pad 5 (bowed)",
    "Pad 6 (metallic)",
    "Pad 7 (halo)",
    "Pad 8 (sweep)",

    "FX 1 (rain)",
    "FX 2 (soundtrack)",
    "FX 3 (crystal)",
    "FX 4 (atmosphere)",
    "FX 5 (brightness)",
    "FX 6 (goblins)",
    "FX 7 (echoes)",
    "FX 8 (sci-fi)",

    "Sitar",
    "Banjo",
    "Shamisen",
    "Koto",
    "Kalimba",
    "Bag pipe",
    "Fiddle",
    "Shanai",

    "Tinkle Bell",
    "Agogo",
    "Steel Drums",
    "Woodblock",
    "Taiko Drum",
    "Melodic Tom",
    "Synth Drum",

    "Reverse Cymbal",
    "Guitar Fret Noise",
    "Breath Noise",
    "Seashore",
    "Bird Tweet",
    "Telephone Ring",
    "Helicopter",
    "Applause",
    "Gunshot",
]

enumeratedProgramList = [str(i).zfill(3) + ": " + s for i,s in enumerate(programList)]
