# Public Domain CC0
%{?mingw_package_header}
%define _pkg_name viking
Name:		mingw32-%{_pkg_name}
Version:	1.9
Release:	1
Summary:	GPS data editor and analyzer
Group:		Applications/Productivity
License:	GPLv2
URL:		http://sourceforge.net/projects/viking/
Source0:	%{_pkg_name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch

# 32bit version only in this file. See mingw64-viking.spec for the 64bit version

# Programs to enable the cross build
BuildRequires:	mingw32-filesystem
BuildRequires:	mingw32-binutils
BuildRequires:	mingw32-runtime
BuildRequires:	mingw32-cross-binutils
BuildRequires:	mingw32-cross-gcc
BuildRequires:	mingw32-cross-pkg-config
BuildRequires:	mingw32-gettext-tools
BuildRequires:	intltool
BuildRequires:	libxslt-tools
BuildRequires:  glib2-devel
#^ For glib-compile-resources

# Code
# Not worried about versions ATM
BuildRequires:	mingw32-gtk2-devel
# ATM gtk2-devel auto includes at least devel versions of glib2, gobject, zlib and more

# Mandatory libraries
BuildRequires:	mingw32-libexpat-devel
BuildRequires:	mingw32-libcurl-devel
BuildRequires:	mingw32-json-glib-devel
# Optional libraries
BuildRequires:	mingw32-libgexiv2-devel
BuildRequires:	mingw32-libbz2-devel
BuildRequires:	mingw32-file-devel
BuildRequires:	mingw32-libmagic1
BuildRequires:	mingw32-libbz2-1
BuildRequires:	mingw32-sqlite-devel
BuildRequires:	mingw32-libzip-devel
BuildRequires:	mingw32-libnettle-devel
BuildRequires:	mingw32-libgps-devel
BuildRequires:	mingw32-liboauth-devel

# Libs for runtime (and thus also available for the NSIS installer to include the dependencies)
Requires:	mingw32-gtk2
Requires:	mingw32-libexpat1
Requires:	mingw32-libcurl4
Requires:	mingw32-json-glib
Requires:	mingw32-libgexiv2
Requires:	mingw32-libstdc++6
Requires:	mingw32-libsqlite3-0
Requires:	mingw32-libzip4
Requires:	mingw32-libnettle
Requires:	mingw32-libgps
Requires:	mingw32-liboauth
Requires:	mingw32-libgps
# Currently running makensis in seperate script - so you will need it then
#Requires:	mingw32-cross-nsis

%description
Viking is a free/open source program to manage GPS data.
You can import, plot and create tracks, routes and waypoints, show OSM and other maps, see real-time GPS position, control items, etc.
Other advanced capabilities include Geotagging Images, generate Maps (using Mapnik), Upload and Download tracks from OSM, Routing from OSRM, Name Searches from OSM Nominatim or Geonames and more.
It is written in mainly in C with some C++ and uses the GTK+2 toolkit.

%prep
%setup -q -n %{_pkg_name}-%{version}

%build
# Create Icon
pushd windows/installer/pixmaps
%{_mingw32_windres} viking_icon.rc -o viking_icon.o
popd

#
# Specifics for Windows build - i.e. no Mapnik yet
%{_mingw32_configure}\
  --disable-mapnik \
  --disable-geoclue \
  --enable-windows \
  CFLAGS="-DWINDOWS -DWIN32 -mwindows"

%{_mingw32_make} %{?_smp_mflags}

%install
pushd src
%{_mingw32_strip} -g %{_pkg_name}.exe
popd

%make_install

%find_lang %{_pkg_name}

%clean
#rm -rf %{buildroot}

%files -f %{_pkg_name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README.md doc/
%{_mingw32_bindir}/*%{_pkg_name}.exe
%{_mingw32_datadir}/applications/%{_pkg_name}.desktop
%{_mingw32_datadir}/%{_pkg_name}
%{_mingw32_datadir}/icons/hicolor/*/apps/%{_pkg_name}.*
%exclude %{_mingw32_datadir}/icons/hicolor/icon-theme.cache
#%{_mingw32_mandir}/man1/*

%changelog
