# -*- rpm-spec -*-

%if 0%{?rhel} >= 9
%global with_govirt 0
%global with_spice 0
%else
%global with_govirt 1
%global with_spice 1
%endif

Name: virt-viewer
Version: 10.0
Release: 1%{?dist}
Summary: Virtual Machine Viewer
License: GPLv2+
URL: https://gitlab.com/virt-viewer/virt-viewer
Source0: https://virt-manager.org/download/sources/%{name}/%{name}-%{version}.tar.xz
Requires: openssh-clients

# Our bash completion script uses virsh to list domains
Requires: libvirt-client

BuildRequires: gcc
BuildRequires: meson
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(libvirt)
BuildRequires: pkgconfig(libvirt-glib-1.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(gtk-vnc-2.0)
%if %{with_spice}
BuildRequires: pkgconfig(spice-client-gtk-3.0)
BuildRequires: pkgconfig(spice-protocol)
%endif
BuildRequires: /usr/bin/pod2man
BuildRequires: gettext
%if %{with_govirt}
BuildRequires: pkgconfig(govirt-1.0)
BuildRequires: pkgconfig(rest-0.7)
%endif
BuildRequires: pkgconfig(bash-completion)


%description
Virtual Machine Viewer provides a graphical console client for connecting
to virtual machines. It uses the GTK-VNC or SPICE-GTK widgets to provide
the display, and libvirt for looking up VNC/SPICE server details.

%prep
%setup -q

%build
%meson -Dbuild-id=%{release}
%meson_build

%install
%meson_install

%find_lang %{name}

%files -f %{name}.lang
%doc README.md COPYING AUTHORS ChangeLog NEWS
%{_bindir}/%{name}
%{_bindir}/remote-viewer
%{_datadir}/icons/hicolor/*/apps/*
%{_datadir}/applications/remote-viewer.desktop
%{_datadir}/metainfo/remote-viewer.appdata.xml
%{_datadir}/mime/packages/virt-viewer-mime.xml
%{_mandir}/man1/virt-viewer.1*
%{_mandir}/man1/remote-viewer.1*
%{_datadir}/bash-completion/completions/virt-viewer

%changelog
