/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */

import * as assert from 'assert';

import {HockeyDeployer} from './HockeyDeployer';

describe('HockeyDeployer', () => {
  describe('createVersion', () => {
    it(`doesn't upload anything if dry run is set`, async () => {
      const hockeyDeployer = new HockeyDeployer({
        dryRun: true,
        hockeyAppId: '',
        hockeyToken: '',
        version: '',
      });

      const result = await hockeyDeployer.createVersion();
      assert.deepStrictEqual(result, {id: 0});
    });
  });
});
