#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0995",
	"kh" => "0x0996",
	"g" => "0x0997",
	"gh" => "0x0998",
	"N^" => "0x0999",
	"~N" => "0x0999",
	"c" => "0x099a",
	"ch" => "0x099a",
	"chh" => "0x099b",
	"Ch" => "0x099b",
	"j" => "0x099c",
	"jh" => "0x099d",
	"~n" => "0x099e",
	"JN" => "0x099e",
	"T" => "0x099f",
	"Th" => "0x09a0",
	"D" => "0x09a1",
	"Dh" => "0x09a2",
	"N" => "0x09a3",
	"t" => "0x09a4",
	"th" => "0x09a5",
	"d" => "0x09a6",
	"dh" => "0x09a7",
	"n" => "0x09a8",
	"p" => "0x09aa",
	"ph" => "0x09ab",
	"b" => "0x09ac",
	"v" => "0x09ac",
	"bh" => "0x09ad",
	"m" => "0x09ae",
	"y" => "0x09af",
	"J" => "0x09af",
	"r" => "0x09b0",
	"l" => "0x09b2",
	"sh" => "0x09b6",
	"shh" => "0x09b7",
	"Sh" => "0x09b7",
	"s" => "0x09b8",
	"h" => "0x09b9",
	".D" => "0x09dc",
	".Dh" => "0x09dd",
	"Y" => "0x09df",
	"x" => "0x0995 0x09cd 0x09b7",
	"GY" => "0x099c 0x09cd 0x099e",
	"dny" => "0x099c 0x09cd 0x099e",
);

%vowels = (
	"" => " 0x09cd",
	"a" => "",
	"A" => " 0x09be",
	"aa" => " 0x09be",
	"i" => " 0x09bf",
	"I" => " 0x09c0",
	"ii" => " 0x09c0",
	"u" => " 0x09c1",
	"U" => " 0x09c2",
	"uu" => " 0x09c2",
	"R^i" => " 0x09c3",
	"RRi" => " 0x09c3",
	"R^I" => " 0x09c4",
	"RRI" => " 0x09c4",
	"e" => " 0x09c7",
	"ai" => " 0x09c8",
	"o" => " 0x09cb",
	"au" => " 0x09cc",
	".h" => " 0x09cd 0x200c",
	"L^i" => " 0x09e2",
	"LLi" => " 0x09e2",
	"L^I" => " 0x09e3",
	"LLI" => " 0x09e3",
);

print "// Bengali kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-01-23\n";
print "// 2003-06-04 upgraded to Unicode 4.0\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0985",
"A=0x0986",
"aa=0x0986",
"i=0x0987",
"I=0x0988",
"ii=0x0988",
"u=0x0989",
"U=0x098a",
"uu=0x098a",
"R^i=0x098b",
"RRi=0x098b",
"L^i=0x098c",
"LLi=0x098c",
"e=0x098f",
"ai=0x0990",
"o=0x0993",
"au=0x0994",
"R^I=0x09e0",
"RRI=0x09e0",
"L^I=0x09e1",
"LLI=0x09e1",

// Numbers

"0x30=0x09e6",
"0x31=0x09e7",
"0x32=0x09e8",
"0x33=0x09e9",
"0x34=0x09ea",
"0x35=0x09eb",
"0x36=0x09ec",
"0x37=0x09ed",
"0x38=0x09ee",
"0x39=0x09ef",

// Other marks

".N=0x0981",
".n=0x0982",
"M=0x0982",
"H=0x0983",
".a=0x09bd",
".h=0x09cd 0x200c",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
