/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BootstrapMethodRemapper
extends SimplifiedVisitor
implements ConstantVisitor {
    private int[] bootstrapMethodIndexMap;
    private final boolean ignoreDanglingConstants;

    public BootstrapMethodRemapper() {
        this(false);
    }

    public BootstrapMethodRemapper(boolean bl) {
        this.ignoreDanglingConstants = bl;
    }

    public void setBootstrapMethodIndexMap(int[] nArray) {
        this.bootstrapMethodIndexMap = nArray;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.u2bootstrapMethodAttributeIndex = this.remapConstantIndex(invokeDynamicConstant.u2bootstrapMethodAttributeIndex);
    }

    private int remapConstantIndex(int n) {
        int n2 = this.bootstrapMethodIndexMap[n];
        if (n2 < 0) {
            if (this.ignoreDanglingConstants) {
                return n;
            }
            throw new IllegalArgumentException("Can't remap bootstrap method index [" + n + "]");
        }
        return n2;
    }
}

