/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2021 Marcus Britanicus (https://gitlab.com/marcusbritanicus)
 * Copyright (c) 2021 Abrar (https://gitlab.com/s96Abrar)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/

#pragma once

#include <QApplication>
#include <QLockFile>
#include <QLocalServer>
#include <QLocalSocket>

#if defined(qApp)
#undef qApp
#endif

namespace WQt {
    class Registry;
    class Application;
}

#define qApp    (static_cast<WQt::Application *>(QCoreApplication::instance() ) )

class WQt::Application : public QApplication {
    Q_OBJECT;

    public:
        Application( int& argc, char **argv, bool GUIenabled = true );
        Application( const QString& id, int& argc, char **argv );

        ~Application();

        bool isRunning();
        QString id() const;

        void setActivationWindow( QWidget *aw, bool activateOnMessage = true );
        QWidget *activationWindow() const;

        WQt::Registry *waylandRegistry();

    public Q_SLOTS:
        bool sendMessage( const QString& message );
        void activateWindow();
        void disconnect();

        void handleConnection();

    Q_SIGNALS:
        void messageReceived( const QString& message );

    private:
        QLockFile *lockFile = nullptr;

        QString mSocketName;
        QString mAppId;

        QWidget *actWin;
        QLocalServer *mServer;
        WQt::Registry *registry = nullptr;
};
