"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadedAboutScreen = void 0;
const electron_1 = require("electron");
const eventType_1 = require("../../lib/eventType");
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.ABOUT.LOCALE_RENDER, (_event, labels) => {
    for (const [labelName, labelText] of Object.entries(labels)) {
        if (labelName === 'aboutReleasesUrl' || labelName === 'aboutUpdatesUrl') {
            const labelElement = document.querySelector(`[data-href="${labelName}"]`);
            if (labelElement) {
                labelElement.href = labelText;
            }
        }
        else {
            const labelElement = document.querySelector(`[data-string="${labelName}"]`);
            if (labelElement) {
                labelElement.textContent = labelText;
            }
        }
    }
});
function loadedAboutScreen(_event, details) {
    const nameElement = document.getElementById('name');
    if (nameElement) {
        nameElement.textContent = details.productName;
    }
    const versionElement = document.getElementById('version');
    if (versionElement) {
        versionElement.textContent = details.electronVersion;
    }
    const webappVersionElement = document.getElementById('webappVersion');
    if (webappVersionElement) {
        webappVersionElement.textContent = details.webappVersion;
    }
    const copyrightElement = document.getElementById('copyright');
    if (copyrightElement) {
        copyrightElement.textContent = details.copyright;
    }
    const logoElement = document.getElementById('logo');
    if (logoElement) {
        logoElement.src = '../img/logo.256.png';
    }
    const labels = [];
    const dataStrings = document.querySelectorAll('[data-string]');
    for (const index in dataStrings) {
        const label = dataStrings[index];
        if (label.dataset) {
            labels.push(label.dataset.string);
        }
    }
    electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ABOUT.LOCALE_VALUES, labels);
}
exports.loadedAboutScreen = loadedAboutScreen;
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.ABOUT.LOADED, loadedAboutScreen);
//# sourceMappingURL=preload-about.js.map