"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.OperatingSystem = void 0;
const platform = __importStar(require("platform"));
const CommonConfig_1 = require("../config/CommonConfig");
const UNKNOWN_PROPERTY = 'unknown';
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["ANDROID"] = "OperatingSystem.ANDROID";
    OperatingSystem["IOS"] = "OperatingSystem.IOS";
    OperatingSystem["LINUX"] = "OperatingSystem.LINUX";
    OperatingSystem["MAC"] = "OperatingSystem.MAC";
    OperatingSystem["WINDOWS"] = "OperatingSystem.WINDOWS";
})(OperatingSystem = exports.OperatingSystem || (exports.OperatingSystem = {}));
class Runtime {
    static getPlatform() {
        const unsetPlatform = {};
        return platform || unsetPlatform;
    }
    static getOSFamily() {
        var _a;
        const family = ((_a = Runtime.getOS().family) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
        if (family.includes('windows')) {
            return OperatingSystem.WINDOWS;
        }
        if (family.includes('android')) {
            return OperatingSystem.ANDROID;
        }
        if (family.includes('ios')) {
            return OperatingSystem.IOS;
        }
        if (['os x', 'mac os'].includes(family)) {
            return OperatingSystem.MAC;
        }
        return OperatingSystem.LINUX;
    }
    /**
     * NOTE: This converts the browser name to lowercase.
     */
    static getBrowserName() {
        return (Runtime.getPlatform().name || UNKNOWN_PROPERTY).toLowerCase();
    }
    static getBrowserVersion() {
        const [majorVersion, minorVersion] = (Runtime.getPlatform().version || UNKNOWN_PROPERTY).split('.');
        return { major: parseInt(majorVersion, 10), minor: parseInt(minorVersion, 10) };
    }
    /**
     * NOTE: This converts the User-Agent to lowercase.
     */
    static getUserAgent() {
        return (Runtime.getPlatform().ua || UNKNOWN_PROPERTY).toLowerCase();
    }
    static isWebappSupportedBrowser() {
        if (Runtime.isFranz()) {
            return false;
        }
        return Object.entries(CommonConfig_1.WEBAPP_SUPPORTED_BROWSERS).some(([browser, supportedVersion]) => {
            const isBrowserSupported = Runtime.getBrowserName() === browser;
            const currentVersion = Runtime.getBrowserVersion();
            const isSupportedMajorVersion = currentVersion.major >= supportedVersion.major;
            const isHigherMajorVersion = currentVersion.major > supportedVersion.major;
            const isSupportedMinorVersion = isHigherMajorVersion || currentVersion.minor >= supportedVersion.minor;
            return isBrowserSupported && isSupportedMajorVersion && isSupportedMinorVersion;
        });
    }
    static getOS() {
        return Object.assign({ architecture: UNKNOWN_PROPERTY, family: UNKNOWN_PROPERTY, version: UNKNOWN_PROPERTY }, platform.os);
    }
    static isChrome() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.CHROME;
    }
    static isEdge() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.MS_EDGE;
    }
    static isFirefox() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.FIREFOX;
    }
    static isInternetExplorer() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.IE;
    }
    static isOpera() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.OPERA;
    }
    static isSafari() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.SAFARI;
    }
    static isDesktopOS() {
        return Runtime.isMacOS() || Runtime.isWindows() || Runtime.isLinux();
    }
    static isElectron() {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.ELECTRON;
    }
    static isNode() {
        return typeof process === 'object';
    }
    static isDesktopApp() {
        return Runtime.isElectron() && Runtime.getUserAgent().includes('wire');
    }
    static isFranz() {
        return Runtime.isElectron() && Runtime.getUserAgent().includes('franz');
    }
    static isMacOS() {
        return Runtime.getOSFamily() === OperatingSystem.MAC;
    }
    static isWindows() {
        return Runtime.getOSFamily() === OperatingSystem.WINDOWS;
    }
    static isLinux() {
        return Runtime.getOSFamily() === OperatingSystem.LINUX;
    }
    static isMobileOS() {
        return Runtime.isAndroid() || Runtime.isIOS();
    }
    static isAndroid() {
        return Runtime.getOSFamily() === OperatingSystem.ANDROID;
    }
    static isIOS() {
        return Runtime.getOSFamily() === OperatingSystem.IOS;
    }
}
exports.Runtime = Runtime;
Runtime.isSupportingWebSockets = () => {
    try {
        return 'WebSocket' in window;
    }
    catch (error) {
        return false;
    }
};
Runtime.isSupportingClipboard = () => {
    return !!navigator.clipboard;
};
Runtime.isSupportingIndexedDb = () => {
    try {
        return !!window.indexedDB;
    }
    catch (error) {
        return false;
    }
};
Runtime.isSupportingLegacyCalling = () => {
    return (Runtime.isSupportingRTCPeerConnection() &&
        Runtime.isSupportingRTCDataChannel() &&
        Runtime.isSupportingUserMedia() &&
        Runtime.isSupportingWebSockets());
};
Runtime.isSupportingConferenceCalling = () => {
    /*
     * The API 'createEncodedVideoStreams' is important for Chrome 83 but got
     * deprecated in Chrome 86 in favor of 'createEncodedStreams'. The
     * 'createEncodedVideoStreams' API will be completely removed in
     * Chrome 88+.
     */
    const isSupportingEncodedVideoStreams = RTCRtpSender.prototype.hasOwnProperty('createEncodedVideoStreams');
    const isSupportingEncodedStreams = RTCRtpSender.prototype.hasOwnProperty('createEncodedStreams');
    return isSupportingEncodedStreams || isSupportingEncodedVideoStreams;
};
Runtime.isSupportingRTCPeerConnection = () => {
    return 'RTCPeerConnection' in window;
};
Runtime.isSupportingRTCDataChannel = () => {
    if (!Runtime.isSupportingRTCPeerConnection()) {
        return false;
    }
    const peerConnection = new RTCPeerConnection(undefined);
    return 'createDataChannel' in peerConnection;
};
Runtime.isSupportingUserMedia = () => {
    return 'mediaDevices' in navigator && 'getUserMedia' in navigator.mediaDevices;
};
Runtime.isSupportingDisplayMedia = () => {
    return 'mediaDevices' in navigator && 'getDisplayMedia' in navigator.mediaDevices;
};
Runtime.isSupportingScreensharing = () => {
    const hasScreenCaptureAPI = !!window.desktopCapturer ||
        (Runtime.isSupportingUserMedia() && Runtime.isSupportingDisplayMedia());
    return hasScreenCaptureAPI || Runtime.isFirefox();
};
Runtime.isSupportingPermissions = () => {
    return !!navigator.permissions;
};
Runtime.isSupportingNotifications = () => {
    const notificationNotSupported = window.Notification === undefined;
    if (notificationNotSupported) {
        return false;
    }
    const requestPermissionNotSupported = window.Notification.requestPermission === undefined;
    return requestPermissionNotSupported ? false : document.visibilityState !== undefined;
};
//# sourceMappingURL=Runtime.js.map