"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StyledApp = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const GlobalStyle_1 = require("../GlobalStyle");
const Theme_1 = require("../Theme/Theme");
const util_1 = require("../util");
const styledAppContainerStyle = (theme, { backgroundColor = theme.general.backgroundColor }) => ({
    background: backgroundColor,
    transition: 'background 0.15s',
});
const filterStyledAppProps = (props) => (0, util_1.filterProps)(props, ['backgroundColor', 'themeId', 'theme']);
const StyledAppContainer = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => styledAppContainerStyle(theme, props) }, filterStyledAppProps(props))));
const StyledApp = (_a) => {
    var { themeId = Theme_1.THEME_ID.LIGHT, theme, children } = _a, props = __rest(_a, ["themeId", "theme", "children"]);
    return ((0, jsx_runtime_1.jsx)(Theme_1.ThemeProvider, Object.assign({ theme: theme ? theme : Theme_1.themes[themeId] }, { children: (0, jsx_runtime_1.jsxs)(StyledAppContainer, Object.assign({}, props, { children: [(0, jsx_runtime_1.jsx)(GlobalStyle_1.GlobalStyle, {}), children] })) })));
};
exports.StyledApp = StyledApp;
