/* Target-dependent code for LoongArch

   Copyright (C) 2024 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* The syscall number definitions are obtained from Linux kernel header file.
   https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/include/uapi/asm-generic/unistd.h
   https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/arch/loongarch/include/asm/unistd.h  */

#ifndef ARCH_LOONGARCH_SYSCALL_H
#define ARCH_LOONGARCH_SYSCALL_H

enum loongarch_syscall
{
  loongarch_sys_io_setup = 0,
  loongarch_sys_io_destroy = 1,
  loongarch_sys_io_submit = 2,
  loongarch_sys_io_cancel = 3,
  loongarch_sys_io_getevents = 4,
  loongarch_sys_setxattr = 5,
  loongarch_sys_lsetxattr = 6,
  loongarch_sys_fsetxattr = 7,
  loongarch_sys_getxattr = 8,
  loongarch_sys_lgetxattr = 9,
  loongarch_sys_fgetxattr = 10,
  loongarch_sys_listxattr = 11,
  loongarch_sys_llistxattr = 12,
  loongarch_sys_flistxattr = 13,
  loongarch_sys_removexattr = 14,
  loongarch_sys_lremovexattr = 15,
  loongarch_sys_fremovexattr = 16,
  loongarch_sys_getcwd = 17,
  loongarch_sys_lookup_dcookie = 18,
  loongarch_sys_eventfd2 = 19,
  loongarch_sys_epoll_create1 = 20,
  loongarch_sys_epoll_ctl = 21,
  loongarch_sys_epoll_pwait = 22,
  loongarch_sys_dup = 23,
  loongarch_sys_dup3 = 24,
  loongarch_sys_fcntl = 25,
  loongarch_sys_inotify_init1 = 26,
  loongarch_sys_inotify_add_watch = 27,
  loongarch_sys_inotify_rm_watch = 28,
  loongarch_sys_ioctl = 29,
  loongarch_sys_ioprio_set = 30,
  loongarch_sys_ioprio_get = 31,
  loongarch_sys_flock = 32,
  loongarch_sys_mknodat = 33,
  loongarch_sys_mkdirat = 34,
  loongarch_sys_unlinkat = 35,
  loongarch_sys_symlinkat = 36,
  loongarch_sys_linkat = 37,

  loongarch_sys_umount2 = 39,
  loongarch_sys_mount = 40,
  loongarch_sys_pivot_root = 41,
  loongarch_sys_nfsservctl = 42,
  loongarch_sys_statfs = 43,
  loongarch_sys_fstatfs = 44,
  loongarch_sys_truncate = 45,
  loongarch_sys_ftruncate = 46,
  loongarch_sys_fallocate = 47,
  loongarch_sys_faccessat = 48,
  loongarch_sys_chdir = 49,
  loongarch_sys_fchdir = 50,
  loongarch_sys_chroot = 51,
  loongarch_sys_fchmod = 52,
  loongarch_sys_fchmodat = 53,
  loongarch_sys_fchownat = 54,
  loongarch_sys_fchown = 55,
  loongarch_sys_openat = 56,
  loongarch_sys_close = 57,
  loongarch_sys_vhangup = 58,
  loongarch_sys_pipe2 = 59,
  loongarch_sys_quotactl = 60,
  loongarch_sys_getdents64 = 61,
  loongarch_sys_lseek = 62,
  loongarch_sys_read = 63,
  loongarch_sys_write = 64,
  loongarch_sys_readv = 65,
  loongarch_sys_writev = 66,
  loongarch_sys_pread64 = 67,
  loongarch_sys_pwrite64 = 68,
  loongarch_sys_preadv = 69,
  loongarch_sys_pwritev = 70,
  loongarch_sys_sendfile = 71,
  loongarch_sys_pselect6 = 72,
  loongarch_sys_ppoll = 73,
  loongarch_sys_signalfd4 = 74,
  loongarch_sys_vmsplice = 75,
  loongarch_sys_splice = 76,
  loongarch_sys_tee = 77,
  loongarch_sys_readlinkat = 78,
  loongarch_sys_newfstatat = 79,
  loongarch_sys_fstat = 80,
  loongarch_sys_sync = 81,
  loongarch_sys_fsync = 82,
  loongarch_sys_fdatasync = 83,
  loongarch_sys_sync_file_range = 84,
  loongarch_sys_timerfd_create = 85,
  loongarch_sys_timerfd_settime = 86,
  loongarch_sys_timerfd_gettime = 87,
  loongarch_sys_utimensat = 88,
  loongarch_sys_acct = 89,
  loongarch_sys_capget = 90,
  loongarch_sys_capset = 91,
  loongarch_sys_personality = 92,
  loongarch_sys_exit = 93,
  loongarch_sys_exit_group = 94,
  loongarch_sys_waitid = 95,
  loongarch_sys_set_tid_address = 96,
  loongarch_sys_unshare = 97,
  loongarch_sys_futex = 98,
  loongarch_sys_set_robust_list = 99,
  loongarch_sys_get_robust_list = 100,
  loongarch_sys_nanosleep = 101,
  loongarch_sys_getitimer = 102,
  loongarch_sys_setitimer = 103,
  loongarch_sys_kexec_load = 104,
  loongarch_sys_init_module = 105,
  loongarch_sys_delete_module = 106,
  loongarch_sys_timer_create = 107,
  loongarch_sys_timer_gettime = 108,
  loongarch_sys_timer_getoverrun = 109,
  loongarch_sys_timer_settime = 110,
  loongarch_sys_timer_delete = 111,
  loongarch_sys_clock_settime = 112,
  loongarch_sys_clock_gettime = 113,
  loongarch_sys_clock_getres = 114,
  loongarch_sys_clock_nanosleep = 115,
  loongarch_sys_syslog = 116,
  loongarch_sys_ptrace = 117,
  loongarch_sys_sched_setparam = 118,
  loongarch_sys_sched_setscheduler = 119,
  loongarch_sys_sched_getscheduler = 120,
  loongarch_sys_sched_getparam = 121,
  loongarch_sys_sched_setaffinity = 122,
  loongarch_sys_sched_getaffinity = 123,
  loongarch_sys_sched_yield = 124,
  loongarch_sys_sched_get_priority_max = 125,
  loongarch_sys_sched_get_priority_min = 126,
  loongarch_sys_sched_rr_get_interval = 127,
  loongarch_sys_restart_syscall = 128,
  loongarch_sys_kill = 129,
  loongarch_sys_tkill = 130,
  loongarch_sys_tgkill = 131,
  loongarch_sys_sigaltstack = 132,
  loongarch_sys_rt_sigsuspend = 133,
  loongarch_sys_rt_sigaction = 134,
  loongarch_sys_rt_sigprocmask = 135,
  loongarch_sys_rt_sigpending = 136,
  loongarch_sys_rt_sigtimedwait = 137,
  loongarch_sys_rt_sigqueueinfo = 138,
  loongarch_sys_rt_sigreturn = 139,
  loongarch_sys_setpriority = 140,
  loongarch_sys_getpriority = 141,
  loongarch_sys_reboot = 142,
  loongarch_sys_setregid = 143,
  loongarch_sys_setgid = 144,
  loongarch_sys_setreuid = 145,
  loongarch_sys_setuid = 146,
  loongarch_sys_setresuid = 147,
  loongarch_sys_getresuid = 148,
  loongarch_sys_setresgid = 149,
  loongarch_sys_getresgid = 150,
  loongarch_sys_setfsuid = 151,
  loongarch_sys_setfsgid = 152,
  loongarch_sys_times = 153,
  loongarch_sys_setpgid = 154,
  loongarch_sys_getpgid = 155,
  loongarch_sys_getsid = 156,
  loongarch_sys_setsid = 157,
  loongarch_sys_getgroups = 158,
  loongarch_sys_setgroups = 159,
  loongarch_sys_uname = 160,
  loongarch_sys_sethostname = 161,
  loongarch_sys_setdomainname = 162,

  loongarch_sys_getrusage = 165,
  loongarch_sys_umask = 166,
  loongarch_sys_prctl = 167,
  loongarch_sys_getcpu = 168,
  loongarch_sys_gettimeofday = 169,
  loongarch_sys_settimeofday = 170,
  loongarch_sys_adjtimex = 171,
  loongarch_sys_getpid = 172,
  loongarch_sys_getppid = 173,
  loongarch_sys_getuid = 174,
  loongarch_sys_geteuid = 175,
  loongarch_sys_getgid = 176,
  loongarch_sys_getegid = 177,
  loongarch_sys_gettid = 178,
  loongarch_sys_sysinfo = 179,
  loongarch_sys_mq_open = 180,
  loongarch_sys_mq_unlink = 181,
  loongarch_sys_mq_timedsend = 182,
  loongarch_sys_mq_timedreceive = 183,
  loongarch_sys_mq_notify = 184,
  loongarch_sys_mq_getsetattr = 185,
  loongarch_sys_msgget = 186,
  loongarch_sys_msgctl = 187,
  loongarch_sys_msgrcv = 188,
  loongarch_sys_msgsnd = 189,
  loongarch_sys_semget = 190,
  loongarch_sys_semctl = 191,
  loongarch_sys_semtimedop = 192,
  loongarch_sys_semop = 193,
  loongarch_sys_shmget = 194,
  loongarch_sys_shmctl = 195,
  loongarch_sys_shmat = 196,
  loongarch_sys_shmdt = 197,
  loongarch_sys_socket = 198,
  loongarch_sys_socketpair = 199,
  loongarch_sys_bind = 200,
  loongarch_sys_listen = 201,
  loongarch_sys_accept = 202,
  loongarch_sys_connect = 203,
  loongarch_sys_getsockname = 204,
  loongarch_sys_getpeername = 205,
  loongarch_sys_sendto = 206,
  loongarch_sys_recvfrom = 207,
  loongarch_sys_setsockopt = 208,
  loongarch_sys_getsockopt = 209,
  loongarch_sys_shutdown = 210,
  loongarch_sys_sendmsg = 211,
  loongarch_sys_recvmsg = 212,
  loongarch_sys_readahead = 213,
  loongarch_sys_brk = 214,
  loongarch_sys_munmap = 215,
  loongarch_sys_mremap = 216,
  loongarch_sys_add_key = 217,
  loongarch_sys_request_key = 218,
  loongarch_sys_keyctl = 219,
  loongarch_sys_clone = 220,
  loongarch_sys_execve = 221,
  loongarch_sys_mmap = 222,
  loongarch_sys_fadvise64 = 223,
  loongarch_sys_swapon = 224,
  loongarch_sys_swapoff = 225,
  loongarch_sys_mprotect = 226,
  loongarch_sys_msync = 227,
  loongarch_sys_mlock = 228,
  loongarch_sys_munlock = 229,
  loongarch_sys_mlockall = 230,
  loongarch_sys_munlockall = 231,
  loongarch_sys_mincore = 232,
  loongarch_sys_madvise = 233,
  loongarch_sys_remap_file_pages = 234,
  loongarch_sys_mbind = 235,
  loongarch_sys_get_mempolicy = 236,
  loongarch_sys_set_mempolicy = 237,
  loongarch_sys_migrate_pages = 238,
  loongarch_sys_move_pages = 239,
  loongarch_sys_rt_tgsigqueueinfo = 240,
  loongarch_sys_perf_event_open = 241,
  loongarch_sys_accept4 = 242,
  loongarch_sys_recvmmsg = 243,
  loongarch_sys_wait4 = 260,
  loongarch_sys_prlimit64 = 261,
  loongarch_sys_fanotify_init = 262,
  loongarch_sys_fanotify_mark = 263,
  loongarch_sys_name_to_handle_at = 264,
  loongarch_sys_open_by_handle_at = 265,
  loongarch_sys_clock_adjtime = 266,
  loongarch_sys_syncfs = 267,
  loongarch_sys_setns = 268,
  loongarch_sys_sendmmsg = 269,
  loongarch_sys_process_vm_readv = 270,
  loongarch_sys_process_vm_writev = 271,
  loongarch_sys_kcmp = 272,
  loongarch_sys_finit_module = 273,
  loongarch_sys_sched_setattr = 274,
  loongarch_sys_sched_getattr = 275,
  loongarch_sys_renameat2 = 276,
  loongarch_sys_seccomp = 277,
  loongarch_sys_getrandom = 278,
  loongarch_sys_memfd_create = 279,
  loongarch_sys_bpf = 280,
  loongarch_sys_execveat = 281,
  loongarch_sys_userfaultfd = 282,
  loongarch_sys_membarrier = 283,
  loongarch_sys_mlock2 = 284,
  loongarch_sys_copy_file_range = 285,
  loongarch_sys_preadv2 = 286,
  loongarch_sys_pwritev2 = 287,
  loongarch_sys_pkey_mprotect = 288,
  loongarch_sys_pkey_alloc = 289,
  loongarch_sys_pkey_free = 290,
  loongarch_sys_statx = 291,
  loongarch_sys_io_pgetevents = 292,
  loongarch_sys_rseq = 293,
  loongarch_sys_kexec_file_load = 294,

  loongarch_sys_pidfd_send_signal = 424,
  loongarch_sys_io_uring_setup = 425,
  loongarch_sys_io_uring_enter = 426,
  loongarch_sys_io_uring_register = 427,
  loongarch_sys_open_tree = 428,
  loongarch_sys_move_mount = 429,
  loongarch_sys_fsopen = 430,
  loongarch_sys_fsconfig = 431,
  loongarch_sys_fsmount = 432,
  loongarch_sys_fspick = 433,
  loongarch_sys_pidfd_open = 434,
  loongarch_sys_clone3 = 435,
  loongarch_sys_close_range = 436,
  loongarch_sys_openat2 = 437,
  loongarch_sys_pidfd_getfd = 438,
  loongarch_sys_faccessat2 = 439,
  loongarch_sys_process_madvise = 440,
  loongarch_sys_epoll_pwait2 = 441,
  loongarch_sys_mount_setattr = 442,
  loongarch_sys_quotactl_fd = 443,
  loongarch_sys_landlock_create_ruleset = 444,
  loongarch_sys_landlock_add_rule = 445,
  loongarch_sys_landlock_restrict_self = 446,

  loongarch_sys_process_mrelease = 448,
  loongarch_sys_futex_waitv = 449,
  loongarch_sys_set_mempolicy_home_node = 450,
  loongarch_sys_cachestat = 451,
  loongarch_sys_fchmodat2 = 452,
  loongarch_sys_map_shadow_stack = 453,
  loongarch_sys_futex_wake = 454,
  loongarch_sys_futex_wait = 455,
  loongarch_sys_futex_requeue = 456,
  loongarch_sys_statmount = 457,
  loongarch_sys_listmount = 458,
  loongarch_sys_lsm_get_self_attr = 459,
  loongarch_sys_lsm_set_self_attr = 460,
  loongarch_sys_lsm_list_modules = 461,
  loongarch_sys_mseal = 462,
  loongarch_sys_syscalls = 463,
};

#endif /* ARCH_LOONGARCH_SYSCALL_H */
