/*
 *  toPrecision()
 */

function test(this_value, args, print_prefix) {
    var t;

    if (print_prefix === undefined) {
        print_prefix = '';
    } else {
        print_prefix += ' ';
    }

    try {
        t = Number.prototype.toPrecision.apply(this_value, args);
        print(print_prefix + typeof t + ' ' + t);
    } catch (e) {
        print(e.name);
    }
}

/*===
basic
0,n/a,-Infinity string -Infinity
0,0,-Infinity string -Infinity
0,1,-Infinity string -Infinity
0,2,-Infinity string -Infinity
0,3,-Infinity string -Infinity
0,4,-Infinity string -Infinity
0,5,-Infinity string -Infinity
0,6,-Infinity string -Infinity
0,7,-Infinity string -Infinity
0,8,-Infinity string -Infinity
0,9,-Infinity string -Infinity
0,10,-Infinity string -Infinity
0,11,-Infinity string -Infinity
0,12,-Infinity string -Infinity
0,13,-Infinity string -Infinity
0,14,-Infinity string -Infinity
0,15,-Infinity string -Infinity
0,16,-Infinity string -Infinity
0,17,-Infinity string -Infinity
0,18,-Infinity string -Infinity
0,19,-Infinity string -Infinity
0,20,-Infinity string -Infinity
0,21,-Infinity string -Infinity
0,22,-Infinity string -Infinity
1,n/a,-1.2345678901234569e+100 string -1.2345678901234569e+100
RangeError
1,1,-1.2345678901234569e+100 string -1e+100
1,2,-1.2345678901234569e+100 string -1.2e+100
1,3,-1.2345678901234569e+100 string -1.23e+100
1,4,-1.2345678901234569e+100 string -1.235e+100
1,5,-1.2345678901234569e+100 string -1.2346e+100
1,6,-1.2345678901234569e+100 string -1.23457e+100
1,7,-1.2345678901234569e+100 string -1.234568e+100
1,8,-1.2345678901234569e+100 string -1.2345679e+100
1,9,-1.2345678901234569e+100 string -1.23456789e+100
1,10,-1.2345678901234569e+100 string -1.234567890e+100
1,11,-1.2345678901234569e+100 string -1.2345678901e+100
1,12,-1.2345678901234569e+100 string -1.23456789012e+100
1,13,-1.2345678901234569e+100 string -1.234567890123e+100
1,14,-1.2345678901234569e+100 string -1.2345678901235e+100
1,15,-1.2345678901234569e+100 string -1.23456789012346e+100
1,16,-1.2345678901234569e+100 string -1.234567890123457e+100
1,17,-1.2345678901234569e+100 string -1.2345678901234569e+100
1,18,-1.2345678901234569e+100 string -1.23456789012345686e+100
1,19,-1.2345678901234569e+100 string -1.234567890123456864e+100
1,20,-1.2345678901234569e+100 string -1.2345678901234568638e+100
1,21,-1.2345678901234569e+100 string -1.23456789012345686377e+100
RangeError
2,n/a,-1.2345678901234568e+25 string -1.2345678901234568e+25
RangeError
2,1,-1.2345678901234568e+25 string -1e+25
2,2,-1.2345678901234568e+25 string -1.2e+25
2,3,-1.2345678901234568e+25 string -1.23e+25
2,4,-1.2345678901234568e+25 string -1.235e+25
2,5,-1.2345678901234568e+25 string -1.2346e+25
2,6,-1.2345678901234568e+25 string -1.23457e+25
2,7,-1.2345678901234568e+25 string -1.234568e+25
2,8,-1.2345678901234568e+25 string -1.2345679e+25
2,9,-1.2345678901234568e+25 string -1.23456789e+25
2,10,-1.2345678901234568e+25 string -1.234567890e+25
2,11,-1.2345678901234568e+25 string -1.2345678901e+25
2,12,-1.2345678901234568e+25 string -1.23456789012e+25
2,13,-1.2345678901234568e+25 string -1.234567890123e+25
2,14,-1.2345678901234568e+25 string -1.2345678901235e+25
2,15,-1.2345678901234568e+25 string -1.23456789012346e+25
2,16,-1.2345678901234568e+25 string -1.234567890123457e+25
2,17,-1.2345678901234568e+25 string -1.2345678901234568e+25
2,18,-1.2345678901234568e+25 string -1.23456789012345682e+25
2,19,-1.2345678901234568e+25 string -1.234567890123456824e+25
2,20,-1.2345678901234568e+25 string -1.2345678901234568245e+25
2,21,-1.2345678901234568e+25 string -1.23456789012345682448e+25
RangeError
3,n/a,-1.2345678901234568e+24 string -1.2345678901234568e+24
RangeError
3,1,-1.2345678901234568e+24 string -1e+24
3,2,-1.2345678901234568e+24 string -1.2e+24
3,3,-1.2345678901234568e+24 string -1.23e+24
3,4,-1.2345678901234568e+24 string -1.235e+24
3,5,-1.2345678901234568e+24 string -1.2346e+24
3,6,-1.2345678901234568e+24 string -1.23457e+24
3,7,-1.2345678901234568e+24 string -1.234568e+24
3,8,-1.2345678901234568e+24 string -1.2345679e+24
3,9,-1.2345678901234568e+24 string -1.23456789e+24
3,10,-1.2345678901234568e+24 string -1.234567890e+24
3,11,-1.2345678901234568e+24 string -1.2345678901e+24
3,12,-1.2345678901234568e+24 string -1.23456789012e+24
3,13,-1.2345678901234568e+24 string -1.234567890123e+24
3,14,-1.2345678901234568e+24 string -1.2345678901235e+24
3,15,-1.2345678901234568e+24 string -1.23456789012346e+24
3,16,-1.2345678901234568e+24 string -1.234567890123457e+24
3,17,-1.2345678901234568e+24 string -1.2345678901234568e+24
3,18,-1.2345678901234568e+24 string -1.23456789012345682e+24
3,19,-1.2345678901234568e+24 string -1.234567890123456824e+24
3,20,-1.2345678901234568e+24 string -1.2345678901234568245e+24
3,21,-1.2345678901234568e+24 string -1.23456789012345682448e+24
RangeError
4,n/a,-1.2345678901234569e+23 string -1.2345678901234569e+23
RangeError
4,1,-1.2345678901234569e+23 string -1e+23
4,2,-1.2345678901234569e+23 string -1.2e+23
4,3,-1.2345678901234569e+23 string -1.23e+23
4,4,-1.2345678901234569e+23 string -1.235e+23
4,5,-1.2345678901234569e+23 string -1.2346e+23
4,6,-1.2345678901234569e+23 string -1.23457e+23
4,7,-1.2345678901234569e+23 string -1.234568e+23
4,8,-1.2345678901234569e+23 string -1.2345679e+23
4,9,-1.2345678901234569e+23 string -1.23456789e+23
4,10,-1.2345678901234569e+23 string -1.234567890e+23
4,11,-1.2345678901234569e+23 string -1.2345678901e+23
4,12,-1.2345678901234569e+23 string -1.23456789012e+23
4,13,-1.2345678901234569e+23 string -1.234567890123e+23
4,14,-1.2345678901234569e+23 string -1.2345678901235e+23
4,15,-1.2345678901234569e+23 string -1.23456789012346e+23
4,16,-1.2345678901234569e+23 string -1.234567890123457e+23
4,17,-1.2345678901234569e+23 string -1.2345678901234569e+23
4,18,-1.2345678901234569e+23 string -1.23456789012345686e+23
4,19,-1.2345678901234569e+23 string -1.234567890123456858e+23
4,20,-1.2345678901234569e+23 string -1.2345678901234568580e+23
4,21,-1.2345678901234569e+23 string -1.23456789012345685803e+23
RangeError
5,n/a,-1.2345678901234568e+22 string -1.2345678901234568e+22
RangeError
5,1,-1.2345678901234568e+22 string -1e+22
5,2,-1.2345678901234568e+22 string -1.2e+22
5,3,-1.2345678901234568e+22 string -1.23e+22
5,4,-1.2345678901234568e+22 string -1.235e+22
5,5,-1.2345678901234568e+22 string -1.2346e+22
5,6,-1.2345678901234568e+22 string -1.23457e+22
5,7,-1.2345678901234568e+22 string -1.234568e+22
5,8,-1.2345678901234568e+22 string -1.2345679e+22
5,9,-1.2345678901234568e+22 string -1.23456789e+22
5,10,-1.2345678901234568e+22 string -1.234567890e+22
5,11,-1.2345678901234568e+22 string -1.2345678901e+22
5,12,-1.2345678901234568e+22 string -1.23456789012e+22
5,13,-1.2345678901234568e+22 string -1.234567890123e+22
5,14,-1.2345678901234568e+22 string -1.2345678901235e+22
5,15,-1.2345678901234568e+22 string -1.23456789012346e+22
5,16,-1.2345678901234568e+22 string -1.234567890123457e+22
5,17,-1.2345678901234568e+22 string -1.2345678901234568e+22
5,18,-1.2345678901234568e+22 string -1.23456789012345677e+22
5,19,-1.2345678901234568e+22 string -1.234567890123456774e+22
5,20,-1.2345678901234568e+22 string -1.2345678901234567741e+22
5,21,-1.2345678901234568e+22 string -1.23456789012345677414e+22
RangeError
6,n/a,-1.2345678901234568e+21 string -1.2345678901234568e+21
RangeError
6,1,-1.2345678901234568e+21 string -1e+21
6,2,-1.2345678901234568e+21 string -1.2e+21
6,3,-1.2345678901234568e+21 string -1.23e+21
6,4,-1.2345678901234568e+21 string -1.235e+21
6,5,-1.2345678901234568e+21 string -1.2346e+21
6,6,-1.2345678901234568e+21 string -1.23457e+21
6,7,-1.2345678901234568e+21 string -1.234568e+21
6,8,-1.2345678901234568e+21 string -1.2345679e+21
6,9,-1.2345678901234568e+21 string -1.23456789e+21
6,10,-1.2345678901234568e+21 string -1.234567890e+21
6,11,-1.2345678901234568e+21 string -1.2345678901e+21
6,12,-1.2345678901234568e+21 string -1.23456789012e+21
6,13,-1.2345678901234568e+21 string -1.234567890123e+21
6,14,-1.2345678901234568e+21 string -1.2345678901235e+21
6,15,-1.2345678901234568e+21 string -1.23456789012346e+21
6,16,-1.2345678901234568e+21 string -1.234567890123457e+21
6,17,-1.2345678901234568e+21 string -1.2345678901234568e+21
6,18,-1.2345678901234568e+21 string -1.23456789012345677e+21
6,19,-1.2345678901234568e+21 string -1.234567890123456774e+21
6,20,-1.2345678901234568e+21 string -1.2345678901234567741e+21
6,21,-1.2345678901234568e+21 string -1.23456789012345677414e+21
RangeError
7,n/a,-123456789012345680000 string -123456789012345680000
RangeError
7,1,-123456789012345680000 string -1e+20
7,2,-123456789012345680000 string -1.2e+20
7,3,-123456789012345680000 string -1.23e+20
7,4,-123456789012345680000 string -1.235e+20
7,5,-123456789012345680000 string -1.2346e+20
7,6,-123456789012345680000 string -1.23457e+20
7,7,-123456789012345680000 string -1.234568e+20
7,8,-123456789012345680000 string -1.2345679e+20
7,9,-123456789012345680000 string -1.23456789e+20
7,10,-123456789012345680000 string -1.234567890e+20
7,11,-123456789012345680000 string -1.2345678901e+20
7,12,-123456789012345680000 string -1.23456789012e+20
7,13,-123456789012345680000 string -1.234567890123e+20
7,14,-123456789012345680000 string -1.2345678901235e+20
7,15,-123456789012345680000 string -1.23456789012346e+20
7,16,-123456789012345680000 string -1.234567890123457e+20
7,17,-123456789012345680000 string -1.2345678901234568e+20
7,18,-123456789012345680000 string -1.23456789012345684e+20
7,19,-123456789012345680000 string -1.234567890123456840e+20
7,20,-123456789012345680000 string -1.2345678901234568397e+20
7,21,-123456789012345680000 string -123456789012345683968
RangeError
8,n/a,-12345678901234567000 string -12345678901234567000
RangeError
8,1,-12345678901234567000 string -1e+19
8,2,-12345678901234567000 string -1.2e+19
8,3,-12345678901234567000 string -1.23e+19
8,4,-12345678901234567000 string -1.235e+19
8,5,-12345678901234567000 string -1.2346e+19
8,6,-12345678901234567000 string -1.23457e+19
8,7,-12345678901234567000 string -1.234568e+19
8,8,-12345678901234567000 string -1.2345679e+19
8,9,-12345678901234567000 string -1.23456789e+19
8,10,-12345678901234567000 string -1.234567890e+19
8,11,-12345678901234567000 string -1.2345678901e+19
8,12,-12345678901234567000 string -1.23456789012e+19
8,13,-12345678901234567000 string -1.234567890123e+19
8,14,-12345678901234567000 string -1.2345678901235e+19
8,15,-12345678901234567000 string -1.23456789012346e+19
8,16,-12345678901234567000 string -1.234567890123457e+19
8,17,-12345678901234567000 string -1.2345678901234567e+19
8,18,-12345678901234567000 string -1.23456789012345672e+19
8,19,-12345678901234567000 string -1.234567890123456717e+19
8,20,-12345678901234567000 string -12345678901234567168
8,21,-12345678901234567000 string -12345678901234567168.0
RangeError
9,n/a,-1234567890123456800 string -1234567890123456800
RangeError
9,1,-1234567890123456800 string -1e+18
9,2,-1234567890123456800 string -1.2e+18
9,3,-1234567890123456800 string -1.23e+18
9,4,-1234567890123456800 string -1.235e+18
9,5,-1234567890123456800 string -1.2346e+18
9,6,-1234567890123456800 string -1.23457e+18
9,7,-1234567890123456800 string -1.234568e+18
9,8,-1234567890123456800 string -1.2345679e+18
9,9,-1234567890123456800 string -1.23456789e+18
9,10,-1234567890123456800 string -1.234567890e+18
9,11,-1234567890123456800 string -1.2345678901e+18
9,12,-1234567890123456800 string -1.23456789012e+18
9,13,-1234567890123456800 string -1.234567890123e+18
9,14,-1234567890123456800 string -1.2345678901235e+18
9,15,-1234567890123456800 string -1.23456789012346e+18
9,16,-1234567890123456800 string -1.234567890123457e+18
9,17,-1234567890123456800 string -1.2345678901234568e+18
9,18,-1234567890123456800 string -1.23456789012345677e+18
9,19,-1234567890123456800 string -1234567890123456768
9,20,-1234567890123456800 string -1234567890123456768.0
9,21,-1234567890123456800 string -1234567890123456768.00
RangeError
10,n/a,-123456789012345680 string -123456789012345680
RangeError
10,1,-123456789012345680 string -1e+17
10,2,-123456789012345680 string -1.2e+17
10,3,-123456789012345680 string -1.23e+17
10,4,-123456789012345680 string -1.235e+17
10,5,-123456789012345680 string -1.2346e+17
10,6,-123456789012345680 string -1.23457e+17
10,7,-123456789012345680 string -1.234568e+17
10,8,-123456789012345680 string -1.2345679e+17
10,9,-123456789012345680 string -1.23456789e+17
10,10,-123456789012345680 string -1.234567890e+17
10,11,-123456789012345680 string -1.2345678901e+17
10,12,-123456789012345680 string -1.23456789012e+17
10,13,-123456789012345680 string -1.234567890123e+17
10,14,-123456789012345680 string -1.2345678901235e+17
10,15,-123456789012345680 string -1.23456789012346e+17
10,16,-123456789012345680 string -1.234567890123457e+17
10,17,-123456789012345680 string -1.2345678901234568e+17
10,18,-123456789012345680 string -123456789012345680
10,19,-123456789012345680 string -123456789012345680.0
10,20,-123456789012345680 string -123456789012345680.00
10,21,-123456789012345680 string -123456789012345680.000
RangeError
11,n/a,-12345678901234568 string -12345678901234568
RangeError
11,1,-12345678901234568 string -1e+16
11,2,-12345678901234568 string -1.2e+16
11,3,-12345678901234568 string -1.23e+16
11,4,-12345678901234568 string -1.235e+16
11,5,-12345678901234568 string -1.2346e+16
11,6,-12345678901234568 string -1.23457e+16
11,7,-12345678901234568 string -1.234568e+16
11,8,-12345678901234568 string -1.2345679e+16
11,9,-12345678901234568 string -1.23456789e+16
11,10,-12345678901234568 string -1.234567890e+16
11,11,-12345678901234568 string -1.2345678901e+16
11,12,-12345678901234568 string -1.23456789012e+16
11,13,-12345678901234568 string -1.234567890123e+16
11,14,-12345678901234568 string -1.2345678901235e+16
11,15,-12345678901234568 string -1.23456789012346e+16
11,16,-12345678901234568 string -1.234567890123457e+16
11,17,-12345678901234568 string -12345678901234568
11,18,-12345678901234568 string -12345678901234568.0
11,19,-12345678901234568 string -12345678901234568.00
11,20,-12345678901234568 string -12345678901234568.000
11,21,-12345678901234568 string -12345678901234568.0000
RangeError
12,n/a,-1234567890123456.8 string -1234567890123456.8
RangeError
12,1,-1234567890123456.8 string -1e+15
12,2,-1234567890123456.8 string -1.2e+15
12,3,-1234567890123456.8 string -1.23e+15
12,4,-1234567890123456.8 string -1.235e+15
12,5,-1234567890123456.8 string -1.2346e+15
12,6,-1234567890123456.8 string -1.23457e+15
12,7,-1234567890123456.8 string -1.234568e+15
12,8,-1234567890123456.8 string -1.2345679e+15
12,9,-1234567890123456.8 string -1.23456789e+15
12,10,-1234567890123456.8 string -1.234567890e+15
12,11,-1234567890123456.8 string -1.2345678901e+15
12,12,-1234567890123456.8 string -1.23456789012e+15
12,13,-1234567890123456.8 string -1.234567890123e+15
12,14,-1234567890123456.8 string -1.2345678901235e+15
12,15,-1234567890123456.8 string -1.23456789012346e+15
12,16,-1234567890123456.8 string -1234567890123457
12,17,-1234567890123456.8 string -1234567890123456.8
12,18,-1234567890123456.8 string -1234567890123456.75
12,19,-1234567890123456.8 string -1234567890123456.750
12,20,-1234567890123456.8 string -1234567890123456.7500
12,21,-1234567890123456.8 string -1234567890123456.75000
RangeError
13,n/a,-123456789012345.67 string -123456789012345.67
RangeError
13,1,-123456789012345.67 string -1e+14
13,2,-123456789012345.67 string -1.2e+14
13,3,-123456789012345.67 string -1.23e+14
13,4,-123456789012345.67 string -1.235e+14
13,5,-123456789012345.67 string -1.2346e+14
13,6,-123456789012345.67 string -1.23457e+14
13,7,-123456789012345.67 string -1.234568e+14
13,8,-123456789012345.67 string -1.2345679e+14
13,9,-123456789012345.67 string -1.23456789e+14
13,10,-123456789012345.67 string -1.234567890e+14
13,11,-123456789012345.67 string -1.2345678901e+14
13,12,-123456789012345.67 string -1.23456789012e+14
13,13,-123456789012345.67 string -1.234567890123e+14
13,14,-123456789012345.67 string -1.2345678901235e+14
13,15,-123456789012345.67 string -123456789012346
13,16,-123456789012345.67 string -123456789012345.7
13,17,-123456789012345.67 string -123456789012345.67
13,18,-123456789012345.67 string -123456789012345.672
13,19,-123456789012345.67 string -123456789012345.6719
13,20,-123456789012345.67 string -123456789012345.67188
13,21,-123456789012345.67 string -123456789012345.671875
RangeError
14,n/a,-12345678901234.568 string -12345678901234.568
RangeError
14,1,-12345678901234.568 string -1e+13
14,2,-12345678901234.568 string -1.2e+13
14,3,-12345678901234.568 string -1.23e+13
14,4,-12345678901234.568 string -1.235e+13
14,5,-12345678901234.568 string -1.2346e+13
14,6,-12345678901234.568 string -1.23457e+13
14,7,-12345678901234.568 string -1.234568e+13
14,8,-12345678901234.568 string -1.2345679e+13
14,9,-12345678901234.568 string -1.23456789e+13
14,10,-12345678901234.568 string -1.234567890e+13
14,11,-12345678901234.568 string -1.2345678901e+13
14,12,-12345678901234.568 string -1.23456789012e+13
14,13,-12345678901234.568 string -1.234567890123e+13
14,14,-12345678901234.568 string -12345678901235
14,15,-12345678901234.568 string -12345678901234.6
14,16,-12345678901234.568 string -12345678901234.57
14,17,-12345678901234.568 string -12345678901234.568
14,18,-12345678901234.568 string -12345678901234.5684
14,19,-12345678901234.568 string -12345678901234.56836
14,20,-12345678901234.568 string -12345678901234.568359
14,21,-12345678901234.568 string -12345678901234.5683594
RangeError
15,n/a,-1234567890123.4568 string -1234567890123.4568
RangeError
15,1,-1234567890123.4568 string -1e+12
15,2,-1234567890123.4568 string -1.2e+12
15,3,-1234567890123.4568 string -1.23e+12
15,4,-1234567890123.4568 string -1.235e+12
15,5,-1234567890123.4568 string -1.2346e+12
15,6,-1234567890123.4568 string -1.23457e+12
15,7,-1234567890123.4568 string -1.234568e+12
15,8,-1234567890123.4568 string -1.2345679e+12
15,9,-1234567890123.4568 string -1.23456789e+12
15,10,-1234567890123.4568 string -1.234567890e+12
15,11,-1234567890123.4568 string -1.2345678901e+12
15,12,-1234567890123.4568 string -1.23456789012e+12
15,13,-1234567890123.4568 string -1234567890123
15,14,-1234567890123.4568 string -1234567890123.5
15,15,-1234567890123.4568 string -1234567890123.46
15,16,-1234567890123.4568 string -1234567890123.457
15,17,-1234567890123.4568 string -1234567890123.4568
15,18,-1234567890123.4568 string -1234567890123.45679
15,19,-1234567890123.4568 string -1234567890123.456787
15,20,-1234567890123.4568 string -1234567890123.4567871
15,21,-1234567890123.4568 string -1234567890123.45678711
RangeError
16,n/a,-123456789012.34567 string -123456789012.34567
RangeError
16,1,-123456789012.34567 string -1e+11
16,2,-123456789012.34567 string -1.2e+11
16,3,-123456789012.34567 string -1.23e+11
16,4,-123456789012.34567 string -1.235e+11
16,5,-123456789012.34567 string -1.2346e+11
16,6,-123456789012.34567 string -1.23457e+11
16,7,-123456789012.34567 string -1.234568e+11
16,8,-123456789012.34567 string -1.2345679e+11
16,9,-123456789012.34567 string -1.23456789e+11
16,10,-123456789012.34567 string -1.234567890e+11
16,11,-123456789012.34567 string -1.2345678901e+11
16,12,-123456789012.34567 string -123456789012
16,13,-123456789012.34567 string -123456789012.3
16,14,-123456789012.34567 string -123456789012.35
16,15,-123456789012.34567 string -123456789012.346
16,16,-123456789012.34567 string -123456789012.3457
16,17,-123456789012.34567 string -123456789012.34567
16,18,-123456789012.34567 string -123456789012.345673
16,19,-123456789012.34567 string -123456789012.3456726
16,20,-123456789012.34567 string -123456789012.34567261
16,21,-123456789012.34567 string -123456789012.345672607
RangeError
17,n/a,-12345678901.234568 string -12345678901.234568
RangeError
17,1,-12345678901.234568 string -1e+10
17,2,-12345678901.234568 string -1.2e+10
17,3,-12345678901.234568 string -1.23e+10
17,4,-12345678901.234568 string -1.235e+10
17,5,-12345678901.234568 string -1.2346e+10
17,6,-12345678901.234568 string -1.23457e+10
17,7,-12345678901.234568 string -1.234568e+10
17,8,-12345678901.234568 string -1.2345679e+10
17,9,-12345678901.234568 string -1.23456789e+10
17,10,-12345678901.234568 string -1.234567890e+10
17,11,-12345678901.234568 string -12345678901
17,12,-12345678901.234568 string -12345678901.2
17,13,-12345678901.234568 string -12345678901.23
17,14,-12345678901.234568 string -12345678901.235
17,15,-12345678901.234568 string -12345678901.2346
17,16,-12345678901.234568 string -12345678901.23457
17,17,-12345678901.234568 string -12345678901.234568
17,18,-12345678901.234568 string -12345678901.2345676
17,19,-12345678901.234568 string -12345678901.23456764
17,20,-12345678901.234568 string -12345678901.234567642
17,21,-12345678901.234568 string -12345678901.2345676422
RangeError
18,n/a,-1234567890.1234567 string -1234567890.1234567
RangeError
18,1,-1234567890.1234567 string -1e+9
18,2,-1234567890.1234567 string -1.2e+9
18,3,-1234567890.1234567 string -1.23e+9
18,4,-1234567890.1234567 string -1.235e+9
18,5,-1234567890.1234567 string -1.2346e+9
18,6,-1234567890.1234567 string -1.23457e+9
18,7,-1234567890.1234567 string -1.234568e+9
18,8,-1234567890.1234567 string -1.2345679e+9
18,9,-1234567890.1234567 string -1.23456789e+9
18,10,-1234567890.1234567 string -1234567890
18,11,-1234567890.1234567 string -1234567890.1
18,12,-1234567890.1234567 string -1234567890.12
18,13,-1234567890.1234567 string -1234567890.123
18,14,-1234567890.1234567 string -1234567890.1235
18,15,-1234567890.1234567 string -1234567890.12346
18,16,-1234567890.1234567 string -1234567890.123457
18,17,-1234567890.1234567 string -1234567890.1234567
18,18,-1234567890.1234567 string -1234567890.12345672
18,19,-1234567890.1234567 string -1234567890.123456717
18,20,-1234567890.1234567 string -1234567890.1234567165
18,21,-1234567890.1234567 string -1234567890.12345671654
RangeError
19,n/a,-123456789.01234567 string -123456789.01234567
RangeError
19,1,-123456789.01234567 string -1e+8
19,2,-123456789.01234567 string -1.2e+8
19,3,-123456789.01234567 string -1.23e+8
19,4,-123456789.01234567 string -1.235e+8
19,5,-123456789.01234567 string -1.2346e+8
19,6,-123456789.01234567 string -1.23457e+8
19,7,-123456789.01234567 string -1.234568e+8
19,8,-123456789.01234567 string -1.2345679e+8
19,9,-123456789.01234567 string -123456789
19,10,-123456789.01234567 string -123456789.0
19,11,-123456789.01234567 string -123456789.01
19,12,-123456789.01234567 string -123456789.012
19,13,-123456789.01234567 string -123456789.0123
19,14,-123456789.01234567 string -123456789.01235
19,15,-123456789.01234567 string -123456789.012346
19,16,-123456789.01234567 string -123456789.0123457
19,17,-123456789.01234567 string -123456789.01234567
19,18,-123456789.01234567 string -123456789.012345672
19,19,-123456789.01234567 string -123456789.0123456717
19,20,-123456789.01234567 string -123456789.01234567165
19,21,-123456789.01234567 string -123456789.012345671654
RangeError
20,n/a,-12345678.901234567 string -12345678.901234567
RangeError
20,1,-12345678.901234567 string -1e+7
20,2,-12345678.901234567 string -1.2e+7
20,3,-12345678.901234567 string -1.23e+7
20,4,-12345678.901234567 string -1.235e+7
20,5,-12345678.901234567 string -1.2346e+7
20,6,-12345678.901234567 string -1.23457e+7
20,7,-12345678.901234567 string -1.234568e+7
20,8,-12345678.901234567 string -12345679
20,9,-12345678.901234567 string -12345678.9
20,10,-12345678.901234567 string -12345678.90
20,11,-12345678.901234567 string -12345678.901
20,12,-12345678.901234567 string -12345678.9012
20,13,-12345678.901234567 string -12345678.90123
20,14,-12345678.901234567 string -12345678.901235
20,15,-12345678.901234567 string -12345678.9012346
20,16,-12345678.901234567 string -12345678.90123457
20,17,-12345678.901234567 string -12345678.901234567
20,18,-12345678.901234567 string -12345678.9012345672
20,19,-12345678.901234567 string -12345678.90123456717
20,20,-12345678.901234567 string -12345678.901234567165
20,21,-12345678.901234567 string -12345678.9012345671654
RangeError
21,n/a,-1234567.8901234567 string -1234567.8901234567
RangeError
21,1,-1234567.8901234567 string -1e+6
21,2,-1234567.8901234567 string -1.2e+6
21,3,-1234567.8901234567 string -1.23e+6
21,4,-1234567.8901234567 string -1.235e+6
21,5,-1234567.8901234567 string -1.2346e+6
21,6,-1234567.8901234567 string -1.23457e+6
21,7,-1234567.8901234567 string -1234568
21,8,-1234567.8901234567 string -1234567.9
21,9,-1234567.8901234567 string -1234567.89
21,10,-1234567.8901234567 string -1234567.890
21,11,-1234567.8901234567 string -1234567.8901
21,12,-1234567.8901234567 string -1234567.89012
21,13,-1234567.8901234567 string -1234567.890123
21,14,-1234567.8901234567 string -1234567.8901235
21,15,-1234567.8901234567 string -1234567.89012346
21,16,-1234567.8901234567 string -1234567.890123457
21,17,-1234567.8901234567 string -1234567.8901234567
21,18,-1234567.8901234567 string -1234567.89012345672
21,19,-1234567.8901234567 string -1234567.890123456717
21,20,-1234567.8901234567 string -1234567.8901234567165
21,21,-1234567.8901234567 string -1234567.89012345671654
RangeError
22,n/a,-123456.78901234567 string -123456.78901234567
RangeError
22,1,-123456.78901234567 string -1e+5
22,2,-123456.78901234567 string -1.2e+5
22,3,-123456.78901234567 string -1.23e+5
22,4,-123456.78901234567 string -1.235e+5
22,5,-123456.78901234567 string -1.2346e+5
22,6,-123456.78901234567 string -123457
22,7,-123456.78901234567 string -123456.8
22,8,-123456.78901234567 string -123456.79
22,9,-123456.78901234567 string -123456.789
22,10,-123456.78901234567 string -123456.7890
22,11,-123456.78901234567 string -123456.78901
22,12,-123456.78901234567 string -123456.789012
22,13,-123456.78901234567 string -123456.7890123
22,14,-123456.78901234567 string -123456.78901235
22,15,-123456.78901234567 string -123456.789012346
22,16,-123456.78901234567 string -123456.7890123457
22,17,-123456.78901234567 string -123456.78901234567
22,18,-123456.78901234567 string -123456.789012345675
22,19,-123456.78901234567 string -123456.7890123456746
22,20,-123456.78901234567 string -123456.78901234567456
22,21,-123456.78901234567 string -123456.789012345674564
RangeError
23,n/a,-12345.678901234567 string -12345.678901234567
RangeError
23,1,-12345.678901234567 string -1e+4
23,2,-12345.678901234567 string -1.2e+4
23,3,-12345.678901234567 string -1.23e+4
23,4,-12345.678901234567 string -1.235e+4
23,5,-12345.678901234567 string -12346
23,6,-12345.678901234567 string -12345.7
23,7,-12345.678901234567 string -12345.68
23,8,-12345.678901234567 string -12345.679
23,9,-12345.678901234567 string -12345.6789
23,10,-12345.678901234567 string -12345.67890
23,11,-12345.678901234567 string -12345.678901
23,12,-12345.678901234567 string -12345.6789012
23,13,-12345.678901234567 string -12345.67890123
23,14,-12345.678901234567 string -12345.678901235
23,15,-12345.678901234567 string -12345.6789012346
23,16,-12345.678901234567 string -12345.67890123457
23,17,-12345.678901234567 string -12345.678901234567
23,18,-12345.678901234567 string -12345.6789012345671
23,19,-12345.678901234567 string -12345.67890123456709
23,20,-12345.678901234567 string -12345.678901234567093
23,21,-12345.678901234567 string -12345.6789012345670926
RangeError
24,n/a,-1234.567890123457 string -1234.567890123457
RangeError
24,1,-1234.567890123457 string -1e+3
24,2,-1234.567890123457 string -1.2e+3
24,3,-1234.567890123457 string -1.23e+3
24,4,-1234.567890123457 string -1235
24,5,-1234.567890123457 string -1234.6
24,6,-1234.567890123457 string -1234.57
24,7,-1234.567890123457 string -1234.568
24,8,-1234.567890123457 string -1234.5679
24,9,-1234.567890123457 string -1234.56789
24,10,-1234.567890123457 string -1234.567890
24,11,-1234.567890123457 string -1234.5678901
24,12,-1234.567890123457 string -1234.56789012
24,13,-1234.567890123457 string -1234.567890123
24,14,-1234.567890123457 string -1234.5678901235
24,15,-1234.567890123457 string -1234.56789012346
24,16,-1234.567890123457 string -1234.567890123457
24,17,-1234.567890123457 string -1234.5678901234569
24,18,-1234.567890123457 string -1234.56789012345689
24,19,-1234.567890123457 string -1234.567890123456891
24,20,-1234.567890123457 string -1234.5678901234568912
24,21,-1234.567890123457 string -1234.56789012345689116
RangeError
25,n/a,-123.45678901234568 string -123.45678901234568
RangeError
25,1,-123.45678901234568 string -1e+2
25,2,-123.45678901234568 string -1.2e+2
25,3,-123.45678901234568 string -123
25,4,-123.45678901234568 string -123.5
25,5,-123.45678901234568 string -123.46
25,6,-123.45678901234568 string -123.457
25,7,-123.45678901234568 string -123.4568
25,8,-123.45678901234568 string -123.45679
25,9,-123.45678901234568 string -123.456789
25,10,-123.45678901234568 string -123.4567890
25,11,-123.45678901234568 string -123.45678901
25,12,-123.45678901234568 string -123.456789012
25,13,-123.45678901234568 string -123.4567890123
25,14,-123.45678901234568 string -123.45678901235
25,15,-123.45678901234568 string -123.456789012346
25,16,-123.45678901234568 string -123.4567890123457
25,17,-123.45678901234568 string -123.45678901234568
25,18,-123.45678901234568 string -123.456789012345681
25,19,-123.45678901234568 string -123.4567890123456806
25,20,-123.45678901234568 string -123.45678901234568059
25,21,-123.45678901234568 string -123.456789012345680590
RangeError
26,n/a,-12.345678901234567 string -12.345678901234567
RangeError
26,1,-12.345678901234567 string -1e+1
26,2,-12.345678901234567 string -12
26,3,-12.345678901234567 string -12.3
26,4,-12.345678901234567 string -12.35
26,5,-12.345678901234567 string -12.346
26,6,-12.345678901234567 string -12.3457
26,7,-12.345678901234567 string -12.34568
26,8,-12.345678901234567 string -12.345679
26,9,-12.345678901234567 string -12.3456789
26,10,-12.345678901234567 string -12.34567890
26,11,-12.345678901234567 string -12.345678901
26,12,-12.345678901234567 string -12.3456789012
26,13,-12.345678901234567 string -12.34567890123
26,14,-12.345678901234567 string -12.345678901235
26,15,-12.345678901234567 string -12.3456789012346
26,16,-12.345678901234567 string -12.34567890123457
26,17,-12.345678901234567 string -12.345678901234567
26,18,-12.345678901234567 string -12.3456789012345673
26,19,-12.345678901234567 string -12.34567890123456735
26,20,-12.345678901234567 string -12.345678901234567348
26,21,-12.345678901234567 string -12.3456789012345673484
RangeError
27,n/a,-1.2345678901234567 string -1.2345678901234567
RangeError
27,1,-1.2345678901234567 string -1
27,2,-1.2345678901234567 string -1.2
27,3,-1.2345678901234567 string -1.23
27,4,-1.2345678901234567 string -1.235
27,5,-1.2345678901234567 string -1.2346
27,6,-1.2345678901234567 string -1.23457
27,7,-1.2345678901234567 string -1.234568
27,8,-1.2345678901234567 string -1.2345679
27,9,-1.2345678901234567 string -1.23456789
27,10,-1.2345678901234567 string -1.234567890
27,11,-1.2345678901234567 string -1.2345678901
27,12,-1.2345678901234567 string -1.23456789012
27,13,-1.2345678901234567 string -1.234567890123
27,14,-1.2345678901234567 string -1.2345678901235
27,15,-1.2345678901234567 string -1.23456789012346
27,16,-1.2345678901234567 string -1.234567890123457
27,17,-1.2345678901234567 string -1.2345678901234567
27,18,-1.2345678901234567 string -1.23456789012345669
27,19,-1.2345678901234567 string -1.234567890123456690
27,20,-1.2345678901234567 string -1.2345678901234566904
27,21,-1.2345678901234567 string -1.23456789012345669043
RangeError
28,n/a,-0.12345678901234568 string -0.12345678901234568
RangeError
28,1,-0.12345678901234568 string -0.1
28,2,-0.12345678901234568 string -0.12
28,3,-0.12345678901234568 string -0.123
28,4,-0.12345678901234568 string -0.1235
28,5,-0.12345678901234568 string -0.12346
28,6,-0.12345678901234568 string -0.123457
28,7,-0.12345678901234568 string -0.1234568
28,8,-0.12345678901234568 string -0.12345679
28,9,-0.12345678901234568 string -0.123456789
28,10,-0.12345678901234568 string -0.1234567890
28,11,-0.12345678901234568 string -0.12345678901
28,12,-0.12345678901234568 string -0.123456789012
28,13,-0.12345678901234568 string -0.1234567890123
28,14,-0.12345678901234568 string -0.12345678901235
28,15,-0.12345678901234568 string -0.123456789012346
28,16,-0.12345678901234568 string -0.1234567890123457
28,17,-0.12345678901234568 string -0.12345678901234568
28,18,-0.12345678901234568 string -0.123456789012345677
28,19,-0.12345678901234568 string -0.1234567890123456774
28,20,-0.12345678901234568 string -0.12345678901234567737
28,21,-0.12345678901234568 string -0.123456789012345677370
RangeError
29,n/a,-0.012345678901234568 string -0.012345678901234568
RangeError
29,1,-0.012345678901234568 string -0.01
29,2,-0.012345678901234568 string -0.012
29,3,-0.012345678901234568 string -0.0123
29,4,-0.012345678901234568 string -0.01235
29,5,-0.012345678901234568 string -0.012346
29,6,-0.012345678901234568 string -0.0123457
29,7,-0.012345678901234568 string -0.01234568
29,8,-0.012345678901234568 string -0.012345679
29,9,-0.012345678901234568 string -0.0123456789
29,10,-0.012345678901234568 string -0.01234567890
29,11,-0.012345678901234568 string -0.012345678901
29,12,-0.012345678901234568 string -0.0123456789012
29,13,-0.012345678901234568 string -0.01234567890123
29,14,-0.012345678901234568 string -0.012345678901235
29,15,-0.012345678901234568 string -0.0123456789012346
29,16,-0.012345678901234568 string -0.01234567890123457
29,17,-0.012345678901234568 string -0.012345678901234568
29,18,-0.012345678901234568 string -0.0123456789012345684
29,19,-0.012345678901234568 string -0.01234567890123456843
29,20,-0.012345678901234568 string -0.012345678901234568431
29,21,-0.012345678901234568 string -0.0123456789012345684309
RangeError
30,n/a,-0.0012345678901234567 string -0.0012345678901234567
RangeError
30,1,-0.0012345678901234567 string -0.001
30,2,-0.0012345678901234567 string -0.0012
30,3,-0.0012345678901234567 string -0.00123
30,4,-0.0012345678901234567 string -0.001235
30,5,-0.0012345678901234567 string -0.0012346
30,6,-0.0012345678901234567 string -0.00123457
30,7,-0.0012345678901234567 string -0.001234568
30,8,-0.0012345678901234567 string -0.0012345679
30,9,-0.0012345678901234567 string -0.00123456789
30,10,-0.0012345678901234567 string -0.001234567890
30,11,-0.0012345678901234567 string -0.0012345678901
30,12,-0.0012345678901234567 string -0.00123456789012
30,13,-0.0012345678901234567 string -0.001234567890123
30,14,-0.0012345678901234567 string -0.0012345678901235
30,15,-0.0012345678901234567 string -0.00123456789012346
30,16,-0.0012345678901234567 string -0.001234567890123457
30,17,-0.0012345678901234567 string -0.0012345678901234567
30,18,-0.0012345678901234567 string -0.00123456789012345671
30,19,-0.0012345678901234567 string -0.001234567890123456713
30,20,-0.0012345678901234567 string -0.0012345678901234567130
30,21,-0.0012345678901234567 string -0.00123456789012345671298
RangeError
31,n/a,-0.00012345678901234567 string -0.00012345678901234567
RangeError
31,1,-0.00012345678901234567 string -0.0001
31,2,-0.00012345678901234567 string -0.00012
31,3,-0.00012345678901234567 string -0.000123
31,4,-0.00012345678901234567 string -0.0001235
31,5,-0.00012345678901234567 string -0.00012346
31,6,-0.00012345678901234567 string -0.000123457
31,7,-0.00012345678901234567 string -0.0001234568
31,8,-0.00012345678901234567 string -0.00012345679
31,9,-0.00012345678901234567 string -0.000123456789
31,10,-0.00012345678901234567 string -0.0001234567890
31,11,-0.00012345678901234567 string -0.00012345678901
31,12,-0.00012345678901234567 string -0.000123456789012
31,13,-0.00012345678901234567 string -0.0001234567890123
31,14,-0.00012345678901234567 string -0.00012345678901235
31,15,-0.00012345678901234567 string -0.000123456789012346
31,16,-0.00012345678901234567 string -0.0001234567890123457
31,17,-0.00012345678901234567 string -0.00012345678901234567
31,18,-0.00012345678901234567 string -0.000123456789012345671
31,19,-0.00012345678901234567 string -0.0001234567890123456713
31,20,-0.00012345678901234567 string -0.00012345678901234567130
31,21,-0.00012345678901234567 string -0.000123456789012345671298
RangeError
32,n/a,-0.000012345678901234568 string -0.000012345678901234568
RangeError
32,1,-0.000012345678901234568 string -0.00001
32,2,-0.000012345678901234568 string -0.000012
32,3,-0.000012345678901234568 string -0.0000123
32,4,-0.000012345678901234568 string -0.00001235
32,5,-0.000012345678901234568 string -0.000012346
32,6,-0.000012345678901234568 string -0.0000123457
32,7,-0.000012345678901234568 string -0.00001234568
32,8,-0.000012345678901234568 string -0.000012345679
32,9,-0.000012345678901234568 string -0.0000123456789
32,10,-0.000012345678901234568 string -0.00001234567890
32,11,-0.000012345678901234568 string -0.000012345678901
32,12,-0.000012345678901234568 string -0.0000123456789012
32,13,-0.000012345678901234568 string -0.00001234567890123
32,14,-0.000012345678901234568 string -0.000012345678901235
32,15,-0.000012345678901234568 string -0.0000123456789012346
32,16,-0.000012345678901234568 string -0.00001234567890123457
32,17,-0.000012345678901234568 string -0.000012345678901234568
32,18,-0.000012345678901234568 string -0.0000123456789012345678
32,19,-0.000012345678901234568 string -0.00001234567890123456781
32,20,-0.000012345678901234568 string -0.000012345678901234567807
32,21,-0.000012345678901234568 string -0.0000123456789012345678075
RangeError
33,n/a,-0.0000012345678901234567 string -0.0000012345678901234567
RangeError
33,1,-0.0000012345678901234567 string -0.000001
33,2,-0.0000012345678901234567 string -0.0000012
33,3,-0.0000012345678901234567 string -0.00000123
33,4,-0.0000012345678901234567 string -0.000001235
33,5,-0.0000012345678901234567 string -0.0000012346
33,6,-0.0000012345678901234567 string -0.00000123457
33,7,-0.0000012345678901234567 string -0.000001234568
33,8,-0.0000012345678901234567 string -0.0000012345679
33,9,-0.0000012345678901234567 string -0.00000123456789
33,10,-0.0000012345678901234567 string -0.000001234567890
33,11,-0.0000012345678901234567 string -0.0000012345678901
33,12,-0.0000012345678901234567 string -0.00000123456789012
33,13,-0.0000012345678901234567 string -0.000001234567890123
33,14,-0.0000012345678901234567 string -0.0000012345678901235
33,15,-0.0000012345678901234567 string -0.00000123456789012346
33,16,-0.0000012345678901234567 string -0.000001234567890123457
33,17,-0.0000012345678901234567 string -0.0000012345678901234567
33,18,-0.0000012345678901234567 string -0.00000123456789012345674
33,19,-0.0000012345678901234567 string -0.000001234567890123456738
33,20,-0.0000012345678901234567 string -0.0000012345678901234567384
33,21,-0.0000012345678901234567 string -0.00000123456789012345673839
RangeError
34,n/a,-1.2345678901234568e-7 string -1.2345678901234568e-7
RangeError
34,1,-1.2345678901234568e-7 string -1e-7
34,2,-1.2345678901234568e-7 string -1.2e-7
34,3,-1.2345678901234568e-7 string -1.23e-7
34,4,-1.2345678901234568e-7 string -1.235e-7
34,5,-1.2345678901234568e-7 string -1.2346e-7
34,6,-1.2345678901234568e-7 string -1.23457e-7
34,7,-1.2345678901234568e-7 string -1.234568e-7
34,8,-1.2345678901234568e-7 string -1.2345679e-7
34,9,-1.2345678901234568e-7 string -1.23456789e-7
34,10,-1.2345678901234568e-7 string -1.234567890e-7
34,11,-1.2345678901234568e-7 string -1.2345678901e-7
34,12,-1.2345678901234568e-7 string -1.23456789012e-7
34,13,-1.2345678901234568e-7 string -1.234567890123e-7
34,14,-1.2345678901234568e-7 string -1.2345678901235e-7
34,15,-1.2345678901234568e-7 string -1.23456789012346e-7
34,16,-1.2345678901234568e-7 string -1.234567890123457e-7
34,17,-1.2345678901234568e-7 string -1.2345678901234568e-7
34,18,-1.2345678901234568e-7 string -1.23456789012345684e-7
34,19,-1.2345678901234568e-7 string -1.234567890123456844e-7
34,20,-1.2345678901234568e-7 string -1.2345678901234568443e-7
34,21,-1.2345678901234568e-7 string -1.23456789012345684427e-7
RangeError
35,n/a,-1.2345678901234567e-8 string -1.2345678901234567e-8
RangeError
35,1,-1.2345678901234567e-8 string -1e-8
35,2,-1.2345678901234567e-8 string -1.2e-8
35,3,-1.2345678901234567e-8 string -1.23e-8
35,4,-1.2345678901234567e-8 string -1.235e-8
35,5,-1.2345678901234567e-8 string -1.2346e-8
35,6,-1.2345678901234567e-8 string -1.23457e-8
35,7,-1.2345678901234567e-8 string -1.234568e-8
35,8,-1.2345678901234567e-8 string -1.2345679e-8
35,9,-1.2345678901234567e-8 string -1.23456789e-8
35,10,-1.2345678901234567e-8 string -1.234567890e-8
35,11,-1.2345678901234567e-8 string -1.2345678901e-8
35,12,-1.2345678901234567e-8 string -1.23456789012e-8
35,13,-1.2345678901234567e-8 string -1.234567890123e-8
35,14,-1.2345678901234567e-8 string -1.2345678901235e-8
35,15,-1.2345678901234567e-8 string -1.23456789012346e-8
35,16,-1.2345678901234567e-8 string -1.234567890123457e-8
35,17,-1.2345678901234567e-8 string -1.2345678901234567e-8
35,18,-1.2345678901234567e-8 string -1.23456789012345675e-8
35,19,-1.2345678901234567e-8 string -1.234567890123456745e-8
35,20,-1.2345678901234567e-8 string -1.2345678901234567450e-8
35,21,-1.2345678901234567e-8 string -1.23456789012345674501e-8
RangeError
36,n/a,-1.2345678901234568e-9 string -1.2345678901234568e-9
RangeError
36,1,-1.2345678901234568e-9 string -1e-9
36,2,-1.2345678901234568e-9 string -1.2e-9
36,3,-1.2345678901234568e-9 string -1.23e-9
36,4,-1.2345678901234568e-9 string -1.235e-9
36,5,-1.2345678901234568e-9 string -1.2346e-9
36,6,-1.2345678901234568e-9 string -1.23457e-9
36,7,-1.2345678901234568e-9 string -1.234568e-9
36,8,-1.2345678901234568e-9 string -1.2345679e-9
36,9,-1.2345678901234568e-9 string -1.23456789e-9
36,10,-1.2345678901234568e-9 string -1.234567890e-9
36,11,-1.2345678901234568e-9 string -1.2345678901e-9
36,12,-1.2345678901234568e-9 string -1.23456789012e-9
36,13,-1.2345678901234568e-9 string -1.234567890123e-9
36,14,-1.2345678901234568e-9 string -1.2345678901235e-9
36,15,-1.2345678901234568e-9 string -1.23456789012346e-9
36,16,-1.2345678901234568e-9 string -1.234567890123457e-9
36,17,-1.2345678901234568e-9 string -1.2345678901234568e-9
36,18,-1.2345678901234568e-9 string -1.23456789012345683e-9
36,19,-1.2345678901234568e-9 string -1.234567890123456828e-9
36,20,-1.2345678901234568e-9 string -1.2345678901234568277e-9
36,21,-1.2345678901234568e-9 string -1.23456789012345682773e-9
RangeError
37,n/a,-1.2345678901234568e-10 string -1.2345678901234568e-10
RangeError
37,1,-1.2345678901234568e-10 string -1e-10
37,2,-1.2345678901234568e-10 string -1.2e-10
37,3,-1.2345678901234568e-10 string -1.23e-10
37,4,-1.2345678901234568e-10 string -1.235e-10
37,5,-1.2345678901234568e-10 string -1.2346e-10
37,6,-1.2345678901234568e-10 string -1.23457e-10
37,7,-1.2345678901234568e-10 string -1.234568e-10
37,8,-1.2345678901234568e-10 string -1.2345679e-10
37,9,-1.2345678901234568e-10 string -1.23456789e-10
37,10,-1.2345678901234568e-10 string -1.234567890e-10
37,11,-1.2345678901234568e-10 string -1.2345678901e-10
37,12,-1.2345678901234568e-10 string -1.23456789012e-10
37,13,-1.2345678901234568e-10 string -1.234567890123e-10
37,14,-1.2345678901234568e-10 string -1.2345678901235e-10
37,15,-1.2345678901234568e-10 string -1.23456789012346e-10
37,16,-1.2345678901234568e-10 string -1.234567890123457e-10
37,17,-1.2345678901234568e-10 string -1.2345678901234568e-10
37,18,-1.2345678901234568e-10 string -1.23456789012345678e-10
37,19,-1.2345678901234568e-10 string -1.234567890123456776e-10
37,20,-1.2345678901234568e-10 string -1.2345678901234567760e-10
37,21,-1.2345678901234568e-10 string -1.23456789012345677603e-10
RangeError
38,n/a,-1.2345678901234568e-11 string -1.2345678901234568e-11
RangeError
38,1,-1.2345678901234568e-11 string -1e-11
38,2,-1.2345678901234568e-11 string -1.2e-11
38,3,-1.2345678901234568e-11 string -1.23e-11
38,4,-1.2345678901234568e-11 string -1.235e-11
38,5,-1.2345678901234568e-11 string -1.2346e-11
38,6,-1.2345678901234568e-11 string -1.23457e-11
38,7,-1.2345678901234568e-11 string -1.234568e-11
38,8,-1.2345678901234568e-11 string -1.2345679e-11
38,9,-1.2345678901234568e-11 string -1.23456789e-11
38,10,-1.2345678901234568e-11 string -1.234567890e-11
38,11,-1.2345678901234568e-11 string -1.2345678901e-11
38,12,-1.2345678901234568e-11 string -1.23456789012e-11
38,13,-1.2345678901234568e-11 string -1.234567890123e-11
38,14,-1.2345678901234568e-11 string -1.2345678901235e-11
38,15,-1.2345678901234568e-11 string -1.23456789012346e-11
38,16,-1.2345678901234568e-11 string -1.234567890123457e-11
38,17,-1.2345678901234568e-11 string -1.2345678901234568e-11
38,18,-1.2345678901234568e-11 string -1.23456789012345684e-11
38,19,-1.2345678901234568e-11 string -1.234567890123456841e-11
38,20,-1.2345678901234568e-11 string -1.2345678901234568407e-11
38,21,-1.2345678901234568e-11 string -1.23456789012345684065e-11
RangeError
39,n/a,-1.2345678901234569e-12 string -1.2345678901234569e-12
RangeError
39,1,-1.2345678901234569e-12 string -1e-12
39,2,-1.2345678901234569e-12 string -1.2e-12
39,3,-1.2345678901234569e-12 string -1.23e-12
39,4,-1.2345678901234569e-12 string -1.235e-12
39,5,-1.2345678901234569e-12 string -1.2346e-12
39,6,-1.2345678901234569e-12 string -1.23457e-12
39,7,-1.2345678901234569e-12 string -1.234568e-12
39,8,-1.2345678901234569e-12 string -1.2345679e-12
39,9,-1.2345678901234569e-12 string -1.23456789e-12
39,10,-1.2345678901234569e-12 string -1.234567890e-12
39,11,-1.2345678901234569e-12 string -1.2345678901e-12
39,12,-1.2345678901234569e-12 string -1.23456789012e-12
39,13,-1.2345678901234569e-12 string -1.234567890123e-12
39,14,-1.2345678901234569e-12 string -1.2345678901235e-12
39,15,-1.2345678901234569e-12 string -1.23456789012346e-12
39,16,-1.2345678901234569e-12 string -1.234567890123457e-12
39,17,-1.2345678901234569e-12 string -1.2345678901234569e-12
39,18,-1.2345678901234569e-12 string -1.23456789012345688e-12
39,19,-1.2345678901234569e-12 string -1.234567890123456881e-12
39,20,-1.2345678901234569e-12 string -1.2345678901234568810e-12
39,21,-1.2345678901234569e-12 string -1.23456789012345688104e-12
RangeError
40,n/a,-1.234567890123457e-13 string -1.234567890123457e-13
RangeError
40,1,-1.234567890123457e-13 string -1e-13
40,2,-1.234567890123457e-13 string -1.2e-13
40,3,-1.234567890123457e-13 string -1.23e-13
40,4,-1.234567890123457e-13 string -1.235e-13
40,5,-1.234567890123457e-13 string -1.2346e-13
40,6,-1.234567890123457e-13 string -1.23457e-13
40,7,-1.234567890123457e-13 string -1.234568e-13
40,8,-1.234567890123457e-13 string -1.2345679e-13
40,9,-1.234567890123457e-13 string -1.23456789e-13
40,10,-1.234567890123457e-13 string -1.234567890e-13
40,11,-1.234567890123457e-13 string -1.2345678901e-13
40,12,-1.234567890123457e-13 string -1.23456789012e-13
40,13,-1.234567890123457e-13 string -1.234567890123e-13
40,14,-1.234567890123457e-13 string -1.2345678901235e-13
40,15,-1.234567890123457e-13 string -1.23456789012346e-13
40,16,-1.234567890123457e-13 string -1.234567890123457e-13
40,17,-1.234567890123457e-13 string -1.2345678901234569e-13
40,18,-1.234567890123457e-13 string -1.23456789012345688e-13
40,19,-1.234567890123457e-13 string -1.234567890123456881e-13
40,20,-1.234567890123457e-13 string -1.2345678901234568810e-13
40,21,-1.234567890123457e-13 string -1.23456789012345688104e-13
RangeError
41,n/a,-1.2345678901234568e-14 string -1.2345678901234568e-14
RangeError
41,1,-1.2345678901234568e-14 string -1e-14
41,2,-1.2345678901234568e-14 string -1.2e-14
41,3,-1.2345678901234568e-14 string -1.23e-14
41,4,-1.2345678901234568e-14 string -1.235e-14
41,5,-1.2345678901234568e-14 string -1.2346e-14
41,6,-1.2345678901234568e-14 string -1.23457e-14
41,7,-1.2345678901234568e-14 string -1.234568e-14
41,8,-1.2345678901234568e-14 string -1.2345679e-14
41,9,-1.2345678901234568e-14 string -1.23456789e-14
41,10,-1.2345678901234568e-14 string -1.234567890e-14
41,11,-1.2345678901234568e-14 string -1.2345678901e-14
41,12,-1.2345678901234568e-14 string -1.23456789012e-14
41,13,-1.2345678901234568e-14 string -1.234567890123e-14
41,14,-1.2345678901234568e-14 string -1.2345678901235e-14
41,15,-1.2345678901234568e-14 string -1.23456789012346e-14
41,16,-1.2345678901234568e-14 string -1.234567890123457e-14
41,17,-1.2345678901234568e-14 string -1.2345678901234568e-14
41,18,-1.2345678901234568e-14 string -1.23456789012345682e-14
41,19,-1.2345678901234568e-14 string -1.234567890123456818e-14
41,20,-1.2345678901234568e-14 string -1.2345678901234568179e-14
41,21,-1.2345678901234568e-14 string -1.23456789012345681794e-14
RangeError
42,n/a,-1.2345678901234568e-15 string -1.2345678901234568e-15
RangeError
42,1,-1.2345678901234568e-15 string -1e-15
42,2,-1.2345678901234568e-15 string -1.2e-15
42,3,-1.2345678901234568e-15 string -1.23e-15
42,4,-1.2345678901234568e-15 string -1.235e-15
42,5,-1.2345678901234568e-15 string -1.2346e-15
42,6,-1.2345678901234568e-15 string -1.23457e-15
42,7,-1.2345678901234568e-15 string -1.234568e-15
42,8,-1.2345678901234568e-15 string -1.2345679e-15
42,9,-1.2345678901234568e-15 string -1.23456789e-15
42,10,-1.2345678901234568e-15 string -1.234567890e-15
42,11,-1.2345678901234568e-15 string -1.2345678901e-15
42,12,-1.2345678901234568e-15 string -1.23456789012e-15
42,13,-1.2345678901234568e-15 string -1.234567890123e-15
42,14,-1.2345678901234568e-15 string -1.2345678901235e-15
42,15,-1.2345678901234568e-15 string -1.23456789012346e-15
42,16,-1.2345678901234568e-15 string -1.234567890123457e-15
42,17,-1.2345678901234568e-15 string -1.2345678901234568e-15
42,18,-1.2345678901234568e-15 string -1.23456789012345678e-15
42,19,-1.2345678901234568e-15 string -1.234567890123456778e-15
42,20,-1.2345678901234568e-15 string -1.2345678901234567785e-15
42,21,-1.2345678901234568e-15 string -1.23456789012345677849e-15
RangeError
43,n/a,-1.2345678901234568e-16 string -1.2345678901234568e-16
RangeError
43,1,-1.2345678901234568e-16 string -1e-16
43,2,-1.2345678901234568e-16 string -1.2e-16
43,3,-1.2345678901234568e-16 string -1.23e-16
43,4,-1.2345678901234568e-16 string -1.235e-16
43,5,-1.2345678901234568e-16 string -1.2346e-16
43,6,-1.2345678901234568e-16 string -1.23457e-16
43,7,-1.2345678901234568e-16 string -1.234568e-16
43,8,-1.2345678901234568e-16 string -1.2345679e-16
43,9,-1.2345678901234568e-16 string -1.23456789e-16
43,10,-1.2345678901234568e-16 string -1.234567890e-16
43,11,-1.2345678901234568e-16 string -1.2345678901e-16
43,12,-1.2345678901234568e-16 string -1.23456789012e-16
43,13,-1.2345678901234568e-16 string -1.234567890123e-16
43,14,-1.2345678901234568e-16 string -1.2345678901235e-16
43,15,-1.2345678901234568e-16 string -1.23456789012346e-16
43,16,-1.2345678901234568e-16 string -1.234567890123457e-16
43,17,-1.2345678901234568e-16 string -1.2345678901234568e-16
43,18,-1.2345678901234568e-16 string -1.23456789012345678e-16
43,19,-1.2345678901234568e-16 string -1.234567890123456778e-16
43,20,-1.2345678901234568e-16 string -1.2345678901234567785e-16
43,21,-1.2345678901234568e-16 string -1.23456789012345677849e-16
RangeError
44,n/a,-1.2345678901234568e-17 string -1.2345678901234568e-17
RangeError
44,1,-1.2345678901234568e-17 string -1e-17
44,2,-1.2345678901234568e-17 string -1.2e-17
44,3,-1.2345678901234568e-17 string -1.23e-17
44,4,-1.2345678901234568e-17 string -1.235e-17
44,5,-1.2345678901234568e-17 string -1.2346e-17
44,6,-1.2345678901234568e-17 string -1.23457e-17
44,7,-1.2345678901234568e-17 string -1.234568e-17
44,8,-1.2345678901234568e-17 string -1.2345679e-17
44,9,-1.2345678901234568e-17 string -1.23456789e-17
44,10,-1.2345678901234568e-17 string -1.234567890e-17
44,11,-1.2345678901234568e-17 string -1.2345678901e-17
44,12,-1.2345678901234568e-17 string -1.23456789012e-17
44,13,-1.2345678901234568e-17 string -1.234567890123e-17
44,14,-1.2345678901234568e-17 string -1.2345678901235e-17
44,15,-1.2345678901234568e-17 string -1.23456789012346e-17
44,16,-1.2345678901234568e-17 string -1.234567890123457e-17
44,17,-1.2345678901234568e-17 string -1.2345678901234568e-17
44,18,-1.2345678901234568e-17 string -1.23456789012345684e-17
44,19,-1.2345678901234568e-17 string -1.234567890123456840e-17
44,20,-1.2345678901234568e-17 string -1.2345678901234568401e-17
44,21,-1.2345678901234568e-17 string -1.23456789012345684012e-17
RangeError
45,n/a,-1.2345678901234568e-18 string -1.2345678901234568e-18
RangeError
45,1,-1.2345678901234568e-18 string -1e-18
45,2,-1.2345678901234568e-18 string -1.2e-18
45,3,-1.2345678901234568e-18 string -1.23e-18
45,4,-1.2345678901234568e-18 string -1.235e-18
45,5,-1.2345678901234568e-18 string -1.2346e-18
45,6,-1.2345678901234568e-18 string -1.23457e-18
45,7,-1.2345678901234568e-18 string -1.234568e-18
45,8,-1.2345678901234568e-18 string -1.2345679e-18
45,9,-1.2345678901234568e-18 string -1.23456789e-18
45,10,-1.2345678901234568e-18 string -1.234567890e-18
45,11,-1.2345678901234568e-18 string -1.2345678901e-18
45,12,-1.2345678901234568e-18 string -1.23456789012e-18
45,13,-1.2345678901234568e-18 string -1.234567890123e-18
45,14,-1.2345678901234568e-18 string -1.2345678901235e-18
45,15,-1.2345678901234568e-18 string -1.23456789012346e-18
45,16,-1.2345678901234568e-18 string -1.234567890123457e-18
45,17,-1.2345678901234568e-18 string -1.2345678901234568e-18
45,18,-1.2345678901234568e-18 string -1.23456789012345680e-18
45,19,-1.2345678901234568e-18 string -1.234567890123456802e-18
45,20,-1.2345678901234568e-18 string -1.2345678901234568016e-18
45,21,-1.2345678901234568e-18 string -1.23456789012345680160e-18
RangeError
46,n/a,-1.2345678901234568e-19 string -1.2345678901234568e-19
RangeError
46,1,-1.2345678901234568e-19 string -1e-19
46,2,-1.2345678901234568e-19 string -1.2e-19
46,3,-1.2345678901234568e-19 string -1.23e-19
46,4,-1.2345678901234568e-19 string -1.235e-19
46,5,-1.2345678901234568e-19 string -1.2346e-19
46,6,-1.2345678901234568e-19 string -1.23457e-19
46,7,-1.2345678901234568e-19 string -1.234568e-19
46,8,-1.2345678901234568e-19 string -1.2345679e-19
46,9,-1.2345678901234568e-19 string -1.23456789e-19
46,10,-1.2345678901234568e-19 string -1.234567890e-19
46,11,-1.2345678901234568e-19 string -1.2345678901e-19
46,12,-1.2345678901234568e-19 string -1.23456789012e-19
46,13,-1.2345678901234568e-19 string -1.234567890123e-19
46,14,-1.2345678901234568e-19 string -1.2345678901235e-19
46,15,-1.2345678901234568e-19 string -1.23456789012346e-19
46,16,-1.2345678901234568e-19 string -1.234567890123457e-19
46,17,-1.2345678901234568e-19 string -1.2345678901234568e-19
46,18,-1.2345678901234568e-19 string -1.23456789012345680e-19
46,19,-1.2345678901234568e-19 string -1.234567890123456802e-19
46,20,-1.2345678901234568e-19 string -1.2345678901234568016e-19
46,21,-1.2345678901234568e-19 string -1.23456789012345680160e-19
RangeError
47,n/a,-1.2345678901234569e-20 string -1.2345678901234569e-20
RangeError
47,1,-1.2345678901234569e-20 string -1e-20
47,2,-1.2345678901234569e-20 string -1.2e-20
47,3,-1.2345678901234569e-20 string -1.23e-20
47,4,-1.2345678901234569e-20 string -1.235e-20
47,5,-1.2345678901234569e-20 string -1.2346e-20
47,6,-1.2345678901234569e-20 string -1.23457e-20
47,7,-1.2345678901234569e-20 string -1.234568e-20
47,8,-1.2345678901234569e-20 string -1.2345679e-20
47,9,-1.2345678901234569e-20 string -1.23456789e-20
47,10,-1.2345678901234569e-20 string -1.234567890e-20
47,11,-1.2345678901234569e-20 string -1.2345678901e-20
47,12,-1.2345678901234569e-20 string -1.23456789012e-20
47,13,-1.2345678901234569e-20 string -1.234567890123e-20
47,14,-1.2345678901234569e-20 string -1.2345678901235e-20
47,15,-1.2345678901234569e-20 string -1.23456789012346e-20
47,16,-1.2345678901234569e-20 string -1.234567890123457e-20
47,17,-1.2345678901234569e-20 string -1.2345678901234569e-20
47,18,-1.2345678901234569e-20 string -1.23456789012345686e-20
47,19,-1.2345678901234569e-20 string -1.234567890123456862e-20
47,20,-1.2345678901234569e-20 string -1.2345678901234568618e-20
47,21,-1.2345678901234569e-20 string -1.23456789012345686179e-20
RangeError
48,n/a,-1.2345678901234568e-21 string -1.2345678901234568e-21
RangeError
48,1,-1.2345678901234568e-21 string -1e-21
48,2,-1.2345678901234568e-21 string -1.2e-21
48,3,-1.2345678901234568e-21 string -1.23e-21
48,4,-1.2345678901234568e-21 string -1.235e-21
48,5,-1.2345678901234568e-21 string -1.2346e-21
48,6,-1.2345678901234568e-21 string -1.23457e-21
48,7,-1.2345678901234568e-21 string -1.234568e-21
48,8,-1.2345678901234568e-21 string -1.2345679e-21
48,9,-1.2345678901234568e-21 string -1.23456789e-21
48,10,-1.2345678901234568e-21 string -1.234567890e-21
48,11,-1.2345678901234568e-21 string -1.2345678901e-21
48,12,-1.2345678901234568e-21 string -1.23456789012e-21
48,13,-1.2345678901234568e-21 string -1.234567890123e-21
48,14,-1.2345678901234568e-21 string -1.2345678901235e-21
48,15,-1.2345678901234568e-21 string -1.23456789012346e-21
48,16,-1.2345678901234568e-21 string -1.234567890123457e-21
48,17,-1.2345678901234568e-21 string -1.2345678901234568e-21
48,18,-1.2345678901234568e-21 string -1.23456789012345682e-21
48,19,-1.2345678901234568e-21 string -1.234567890123456824e-21
48,20,-1.2345678901234568e-21 string -1.2345678901234568242e-21
48,21,-1.2345678901234568e-21 string -1.23456789012345682417e-21
RangeError
49,n/a,-1.2345678901234568e-22 string -1.2345678901234568e-22
RangeError
49,1,-1.2345678901234568e-22 string -1e-22
49,2,-1.2345678901234568e-22 string -1.2e-22
49,3,-1.2345678901234568e-22 string -1.23e-22
49,4,-1.2345678901234568e-22 string -1.235e-22
49,5,-1.2345678901234568e-22 string -1.2346e-22
49,6,-1.2345678901234568e-22 string -1.23457e-22
49,7,-1.2345678901234568e-22 string -1.234568e-22
49,8,-1.2345678901234568e-22 string -1.2345679e-22
49,9,-1.2345678901234568e-22 string -1.23456789e-22
49,10,-1.2345678901234568e-22 string -1.234567890e-22
49,11,-1.2345678901234568e-22 string -1.2345678901e-22
49,12,-1.2345678901234568e-22 string -1.23456789012e-22
49,13,-1.2345678901234568e-22 string -1.234567890123e-22
49,14,-1.2345678901234568e-22 string -1.2345678901235e-22
49,15,-1.2345678901234568e-22 string -1.23456789012346e-22
49,16,-1.2345678901234568e-22 string -1.234567890123457e-22
49,17,-1.2345678901234568e-22 string -1.2345678901234568e-22
49,18,-1.2345678901234568e-22 string -1.23456789012345678e-22
49,19,-1.2345678901234568e-22 string -1.234567890123456777e-22
49,20,-1.2345678901234568e-22 string -1.2345678901234567772e-22
49,21,-1.2345678901234568e-22 string -1.23456789012345677715e-22
RangeError
50,n/a,-1.2345678901234567e-23 string -1.2345678901234567e-23
RangeError
50,1,-1.2345678901234567e-23 string -1e-23
50,2,-1.2345678901234567e-23 string -1.2e-23
50,3,-1.2345678901234567e-23 string -1.23e-23
50,4,-1.2345678901234567e-23 string -1.235e-23
50,5,-1.2345678901234567e-23 string -1.2346e-23
50,6,-1.2345678901234567e-23 string -1.23457e-23
50,7,-1.2345678901234567e-23 string -1.234568e-23
50,8,-1.2345678901234567e-23 string -1.2345679e-23
50,9,-1.2345678901234567e-23 string -1.23456789e-23
50,10,-1.2345678901234567e-23 string -1.234567890e-23
50,11,-1.2345678901234567e-23 string -1.2345678901e-23
50,12,-1.2345678901234567e-23 string -1.23456789012e-23
50,13,-1.2345678901234567e-23 string -1.234567890123e-23
50,14,-1.2345678901234567e-23 string -1.2345678901235e-23
50,15,-1.2345678901234567e-23 string -1.23456789012346e-23
50,16,-1.2345678901234567e-23 string -1.234567890123457e-23
50,17,-1.2345678901234567e-23 string -1.2345678901234567e-23
50,18,-1.2345678901234567e-23 string -1.23456789012345675e-23
50,19,-1.2345678901234567e-23 string -1.234567890123456748e-23
50,20,-1.2345678901234567e-23 string -1.2345678901234567478e-23
50,21,-1.2345678901234567e-23 string -1.23456789012345674777e-23
RangeError
51,n/a,-1.2345678901234567e-24 string -1.2345678901234567e-24
RangeError
51,1,-1.2345678901234567e-24 string -1e-24
51,2,-1.2345678901234567e-24 string -1.2e-24
51,3,-1.2345678901234567e-24 string -1.23e-24
51,4,-1.2345678901234567e-24 string -1.235e-24
51,5,-1.2345678901234567e-24 string -1.2346e-24
51,6,-1.2345678901234567e-24 string -1.23457e-24
51,7,-1.2345678901234567e-24 string -1.234568e-24
51,8,-1.2345678901234567e-24 string -1.2345679e-24
51,9,-1.2345678901234567e-24 string -1.23456789e-24
51,10,-1.2345678901234567e-24 string -1.234567890e-24
51,11,-1.2345678901234567e-24 string -1.2345678901e-24
51,12,-1.2345678901234567e-24 string -1.23456789012e-24
51,13,-1.2345678901234567e-24 string -1.234567890123e-24
51,14,-1.2345678901234567e-24 string -1.2345678901235e-24
51,15,-1.2345678901234567e-24 string -1.23456789012346e-24
51,16,-1.2345678901234567e-24 string -1.234567890123457e-24
51,17,-1.2345678901234567e-24 string -1.2345678901234567e-24
51,18,-1.2345678901234567e-24 string -1.23456789012345671e-24
51,19,-1.2345678901234567e-24 string -1.234567890123456711e-24
51,20,-1.2345678901234567e-24 string -1.2345678901234567110e-24
51,21,-1.2345678901234567e-24 string -1.23456789012345671103e-24
RangeError
52,n/a,-1.2345678901234568e-25 string -1.2345678901234568e-25
RangeError
52,1,-1.2345678901234568e-25 string -1e-25
52,2,-1.2345678901234568e-25 string -1.2e-25
52,3,-1.2345678901234568e-25 string -1.23e-25
52,4,-1.2345678901234568e-25 string -1.235e-25
52,5,-1.2345678901234568e-25 string -1.2346e-25
52,6,-1.2345678901234568e-25 string -1.23457e-25
52,7,-1.2345678901234568e-25 string -1.234568e-25
52,8,-1.2345678901234568e-25 string -1.2345679e-25
52,9,-1.2345678901234568e-25 string -1.23456789e-25
52,10,-1.2345678901234568e-25 string -1.234567890e-25
52,11,-1.2345678901234568e-25 string -1.2345678901e-25
52,12,-1.2345678901234568e-25 string -1.23456789012e-25
52,13,-1.2345678901234568e-25 string -1.234567890123e-25
52,14,-1.2345678901234568e-25 string -1.2345678901235e-25
52,15,-1.2345678901234568e-25 string -1.23456789012346e-25
52,16,-1.2345678901234568e-25 string -1.234567890123457e-25
52,17,-1.2345678901234568e-25 string -1.2345678901234568e-25
52,18,-1.2345678901234568e-25 string -1.23456789012345685e-25
52,19,-1.2345678901234568e-25 string -1.234567890123456849e-25
52,20,-1.2345678901234568e-25 string -1.2345678901234568488e-25
52,21,-1.2345678901234568e-25 string -1.23456789012345684879e-25
RangeError
53,n/a,-1.2345678901234567e-100 string -1.2345678901234567e-100
RangeError
53,1,-1.2345678901234567e-100 string -1e-100
53,2,-1.2345678901234567e-100 string -1.2e-100
53,3,-1.2345678901234567e-100 string -1.23e-100
53,4,-1.2345678901234567e-100 string -1.235e-100
53,5,-1.2345678901234567e-100 string -1.2346e-100
53,6,-1.2345678901234567e-100 string -1.23457e-100
53,7,-1.2345678901234567e-100 string -1.234568e-100
53,8,-1.2345678901234567e-100 string -1.2345679e-100
53,9,-1.2345678901234567e-100 string -1.23456789e-100
53,10,-1.2345678901234567e-100 string -1.234567890e-100
53,11,-1.2345678901234567e-100 string -1.2345678901e-100
53,12,-1.2345678901234567e-100 string -1.23456789012e-100
53,13,-1.2345678901234567e-100 string -1.234567890123e-100
53,14,-1.2345678901234567e-100 string -1.2345678901235e-100
53,15,-1.2345678901234567e-100 string -1.23456789012346e-100
53,16,-1.2345678901234567e-100 string -1.234567890123457e-100
53,17,-1.2345678901234567e-100 string -1.2345678901234567e-100
53,18,-1.2345678901234567e-100 string -1.23456789012345671e-100
53,19,-1.2345678901234567e-100 string -1.234567890123456714e-100
53,20,-1.2345678901234567e-100 string -1.2345678901234567135e-100
53,21,-1.2345678901234567e-100 string -1.23456789012345671352e-100
RangeError
54,n/a,0 string 0
RangeError
54,1,0 string 0
54,2,0 string 0.0
54,3,0 string 0.00
54,4,0 string 0.000
54,5,0 string 0.0000
54,6,0 string 0.00000
54,7,0 string 0.000000
54,8,0 string 0.0000000
54,9,0 string 0.00000000
54,10,0 string 0.000000000
54,11,0 string 0.0000000000
54,12,0 string 0.00000000000
54,13,0 string 0.000000000000
54,14,0 string 0.0000000000000
54,15,0 string 0.00000000000000
54,16,0 string 0.000000000000000
54,17,0 string 0.0000000000000000
54,18,0 string 0.00000000000000000
54,19,0 string 0.000000000000000000
54,20,0 string 0.0000000000000000000
54,21,0 string 0.00000000000000000000
RangeError
55,n/a,0 string 0
RangeError
55,1,0 string 0
55,2,0 string 0.0
55,3,0 string 0.00
55,4,0 string 0.000
55,5,0 string 0.0000
55,6,0 string 0.00000
55,7,0 string 0.000000
55,8,0 string 0.0000000
55,9,0 string 0.00000000
55,10,0 string 0.000000000
55,11,0 string 0.0000000000
55,12,0 string 0.00000000000
55,13,0 string 0.000000000000
55,14,0 string 0.0000000000000
55,15,0 string 0.00000000000000
55,16,0 string 0.000000000000000
55,17,0 string 0.0000000000000000
55,18,0 string 0.00000000000000000
55,19,0 string 0.000000000000000000
55,20,0 string 0.0000000000000000000
55,21,0 string 0.00000000000000000000
RangeError
56,n/a,1.2345678901234567e-100 string 1.2345678901234567e-100
RangeError
56,1,1.2345678901234567e-100 string 1e-100
56,2,1.2345678901234567e-100 string 1.2e-100
56,3,1.2345678901234567e-100 string 1.23e-100
56,4,1.2345678901234567e-100 string 1.235e-100
56,5,1.2345678901234567e-100 string 1.2346e-100
56,6,1.2345678901234567e-100 string 1.23457e-100
56,7,1.2345678901234567e-100 string 1.234568e-100
56,8,1.2345678901234567e-100 string 1.2345679e-100
56,9,1.2345678901234567e-100 string 1.23456789e-100
56,10,1.2345678901234567e-100 string 1.234567890e-100
56,11,1.2345678901234567e-100 string 1.2345678901e-100
56,12,1.2345678901234567e-100 string 1.23456789012e-100
56,13,1.2345678901234567e-100 string 1.234567890123e-100
56,14,1.2345678901234567e-100 string 1.2345678901235e-100
56,15,1.2345678901234567e-100 string 1.23456789012346e-100
56,16,1.2345678901234567e-100 string 1.234567890123457e-100
56,17,1.2345678901234567e-100 string 1.2345678901234567e-100
56,18,1.2345678901234567e-100 string 1.23456789012345671e-100
56,19,1.2345678901234567e-100 string 1.234567890123456714e-100
56,20,1.2345678901234567e-100 string 1.2345678901234567135e-100
56,21,1.2345678901234567e-100 string 1.23456789012345671352e-100
RangeError
57,n/a,1.2345678901234568e-25 string 1.2345678901234568e-25
RangeError
57,1,1.2345678901234568e-25 string 1e-25
57,2,1.2345678901234568e-25 string 1.2e-25
57,3,1.2345678901234568e-25 string 1.23e-25
57,4,1.2345678901234568e-25 string 1.235e-25
57,5,1.2345678901234568e-25 string 1.2346e-25
57,6,1.2345678901234568e-25 string 1.23457e-25
57,7,1.2345678901234568e-25 string 1.234568e-25
57,8,1.2345678901234568e-25 string 1.2345679e-25
57,9,1.2345678901234568e-25 string 1.23456789e-25
57,10,1.2345678901234568e-25 string 1.234567890e-25
57,11,1.2345678901234568e-25 string 1.2345678901e-25
57,12,1.2345678901234568e-25 string 1.23456789012e-25
57,13,1.2345678901234568e-25 string 1.234567890123e-25
57,14,1.2345678901234568e-25 string 1.2345678901235e-25
57,15,1.2345678901234568e-25 string 1.23456789012346e-25
57,16,1.2345678901234568e-25 string 1.234567890123457e-25
57,17,1.2345678901234568e-25 string 1.2345678901234568e-25
57,18,1.2345678901234568e-25 string 1.23456789012345685e-25
57,19,1.2345678901234568e-25 string 1.234567890123456849e-25
57,20,1.2345678901234568e-25 string 1.2345678901234568488e-25
57,21,1.2345678901234568e-25 string 1.23456789012345684879e-25
RangeError
58,n/a,1.2345678901234567e-24 string 1.2345678901234567e-24
RangeError
58,1,1.2345678901234567e-24 string 1e-24
58,2,1.2345678901234567e-24 string 1.2e-24
58,3,1.2345678901234567e-24 string 1.23e-24
58,4,1.2345678901234567e-24 string 1.235e-24
58,5,1.2345678901234567e-24 string 1.2346e-24
58,6,1.2345678901234567e-24 string 1.23457e-24
58,7,1.2345678901234567e-24 string 1.234568e-24
58,8,1.2345678901234567e-24 string 1.2345679e-24
58,9,1.2345678901234567e-24 string 1.23456789e-24
58,10,1.2345678901234567e-24 string 1.234567890e-24
58,11,1.2345678901234567e-24 string 1.2345678901e-24
58,12,1.2345678901234567e-24 string 1.23456789012e-24
58,13,1.2345678901234567e-24 string 1.234567890123e-24
58,14,1.2345678901234567e-24 string 1.2345678901235e-24
58,15,1.2345678901234567e-24 string 1.23456789012346e-24
58,16,1.2345678901234567e-24 string 1.234567890123457e-24
58,17,1.2345678901234567e-24 string 1.2345678901234567e-24
58,18,1.2345678901234567e-24 string 1.23456789012345671e-24
58,19,1.2345678901234567e-24 string 1.234567890123456711e-24
58,20,1.2345678901234567e-24 string 1.2345678901234567110e-24
58,21,1.2345678901234567e-24 string 1.23456789012345671103e-24
RangeError
59,n/a,1.2345678901234567e-23 string 1.2345678901234567e-23
RangeError
59,1,1.2345678901234567e-23 string 1e-23
59,2,1.2345678901234567e-23 string 1.2e-23
59,3,1.2345678901234567e-23 string 1.23e-23
59,4,1.2345678901234567e-23 string 1.235e-23
59,5,1.2345678901234567e-23 string 1.2346e-23
59,6,1.2345678901234567e-23 string 1.23457e-23
59,7,1.2345678901234567e-23 string 1.234568e-23
59,8,1.2345678901234567e-23 string 1.2345679e-23
59,9,1.2345678901234567e-23 string 1.23456789e-23
59,10,1.2345678901234567e-23 string 1.234567890e-23
59,11,1.2345678901234567e-23 string 1.2345678901e-23
59,12,1.2345678901234567e-23 string 1.23456789012e-23
59,13,1.2345678901234567e-23 string 1.234567890123e-23
59,14,1.2345678901234567e-23 string 1.2345678901235e-23
59,15,1.2345678901234567e-23 string 1.23456789012346e-23
59,16,1.2345678901234567e-23 string 1.234567890123457e-23
59,17,1.2345678901234567e-23 string 1.2345678901234567e-23
59,18,1.2345678901234567e-23 string 1.23456789012345675e-23
59,19,1.2345678901234567e-23 string 1.234567890123456748e-23
59,20,1.2345678901234567e-23 string 1.2345678901234567478e-23
59,21,1.2345678901234567e-23 string 1.23456789012345674777e-23
RangeError
60,n/a,1.2345678901234568e-22 string 1.2345678901234568e-22
RangeError
60,1,1.2345678901234568e-22 string 1e-22
60,2,1.2345678901234568e-22 string 1.2e-22
60,3,1.2345678901234568e-22 string 1.23e-22
60,4,1.2345678901234568e-22 string 1.235e-22
60,5,1.2345678901234568e-22 string 1.2346e-22
60,6,1.2345678901234568e-22 string 1.23457e-22
60,7,1.2345678901234568e-22 string 1.234568e-22
60,8,1.2345678901234568e-22 string 1.2345679e-22
60,9,1.2345678901234568e-22 string 1.23456789e-22
60,10,1.2345678901234568e-22 string 1.234567890e-22
60,11,1.2345678901234568e-22 string 1.2345678901e-22
60,12,1.2345678901234568e-22 string 1.23456789012e-22
60,13,1.2345678901234568e-22 string 1.234567890123e-22
60,14,1.2345678901234568e-22 string 1.2345678901235e-22
60,15,1.2345678901234568e-22 string 1.23456789012346e-22
60,16,1.2345678901234568e-22 string 1.234567890123457e-22
60,17,1.2345678901234568e-22 string 1.2345678901234568e-22
60,18,1.2345678901234568e-22 string 1.23456789012345678e-22
60,19,1.2345678901234568e-22 string 1.234567890123456777e-22
60,20,1.2345678901234568e-22 string 1.2345678901234567772e-22
60,21,1.2345678901234568e-22 string 1.23456789012345677715e-22
RangeError
61,n/a,1.2345678901234568e-21 string 1.2345678901234568e-21
RangeError
61,1,1.2345678901234568e-21 string 1e-21
61,2,1.2345678901234568e-21 string 1.2e-21
61,3,1.2345678901234568e-21 string 1.23e-21
61,4,1.2345678901234568e-21 string 1.235e-21
61,5,1.2345678901234568e-21 string 1.2346e-21
61,6,1.2345678901234568e-21 string 1.23457e-21
61,7,1.2345678901234568e-21 string 1.234568e-21
61,8,1.2345678901234568e-21 string 1.2345679e-21
61,9,1.2345678901234568e-21 string 1.23456789e-21
61,10,1.2345678901234568e-21 string 1.234567890e-21
61,11,1.2345678901234568e-21 string 1.2345678901e-21
61,12,1.2345678901234568e-21 string 1.23456789012e-21
61,13,1.2345678901234568e-21 string 1.234567890123e-21
61,14,1.2345678901234568e-21 string 1.2345678901235e-21
61,15,1.2345678901234568e-21 string 1.23456789012346e-21
61,16,1.2345678901234568e-21 string 1.234567890123457e-21
61,17,1.2345678901234568e-21 string 1.2345678901234568e-21
61,18,1.2345678901234568e-21 string 1.23456789012345682e-21
61,19,1.2345678901234568e-21 string 1.234567890123456824e-21
61,20,1.2345678901234568e-21 string 1.2345678901234568242e-21
61,21,1.2345678901234568e-21 string 1.23456789012345682417e-21
RangeError
62,n/a,1.2345678901234569e-20 string 1.2345678901234569e-20
RangeError
62,1,1.2345678901234569e-20 string 1e-20
62,2,1.2345678901234569e-20 string 1.2e-20
62,3,1.2345678901234569e-20 string 1.23e-20
62,4,1.2345678901234569e-20 string 1.235e-20
62,5,1.2345678901234569e-20 string 1.2346e-20
62,6,1.2345678901234569e-20 string 1.23457e-20
62,7,1.2345678901234569e-20 string 1.234568e-20
62,8,1.2345678901234569e-20 string 1.2345679e-20
62,9,1.2345678901234569e-20 string 1.23456789e-20
62,10,1.2345678901234569e-20 string 1.234567890e-20
62,11,1.2345678901234569e-20 string 1.2345678901e-20
62,12,1.2345678901234569e-20 string 1.23456789012e-20
62,13,1.2345678901234569e-20 string 1.234567890123e-20
62,14,1.2345678901234569e-20 string 1.2345678901235e-20
62,15,1.2345678901234569e-20 string 1.23456789012346e-20
62,16,1.2345678901234569e-20 string 1.234567890123457e-20
62,17,1.2345678901234569e-20 string 1.2345678901234569e-20
62,18,1.2345678901234569e-20 string 1.23456789012345686e-20
62,19,1.2345678901234569e-20 string 1.234567890123456862e-20
62,20,1.2345678901234569e-20 string 1.2345678901234568618e-20
62,21,1.2345678901234569e-20 string 1.23456789012345686179e-20
RangeError
63,n/a,1.2345678901234568e-19 string 1.2345678901234568e-19
RangeError
63,1,1.2345678901234568e-19 string 1e-19
63,2,1.2345678901234568e-19 string 1.2e-19
63,3,1.2345678901234568e-19 string 1.23e-19
63,4,1.2345678901234568e-19 string 1.235e-19
63,5,1.2345678901234568e-19 string 1.2346e-19
63,6,1.2345678901234568e-19 string 1.23457e-19
63,7,1.2345678901234568e-19 string 1.234568e-19
63,8,1.2345678901234568e-19 string 1.2345679e-19
63,9,1.2345678901234568e-19 string 1.23456789e-19
63,10,1.2345678901234568e-19 string 1.234567890e-19
63,11,1.2345678901234568e-19 string 1.2345678901e-19
63,12,1.2345678901234568e-19 string 1.23456789012e-19
63,13,1.2345678901234568e-19 string 1.234567890123e-19
63,14,1.2345678901234568e-19 string 1.2345678901235e-19
63,15,1.2345678901234568e-19 string 1.23456789012346e-19
63,16,1.2345678901234568e-19 string 1.234567890123457e-19
63,17,1.2345678901234568e-19 string 1.2345678901234568e-19
63,18,1.2345678901234568e-19 string 1.23456789012345680e-19
63,19,1.2345678901234568e-19 string 1.234567890123456802e-19
63,20,1.2345678901234568e-19 string 1.2345678901234568016e-19
63,21,1.2345678901234568e-19 string 1.23456789012345680160e-19
RangeError
64,n/a,1.2345678901234568e-18 string 1.2345678901234568e-18
RangeError
64,1,1.2345678901234568e-18 string 1e-18
64,2,1.2345678901234568e-18 string 1.2e-18
64,3,1.2345678901234568e-18 string 1.23e-18
64,4,1.2345678901234568e-18 string 1.235e-18
64,5,1.2345678901234568e-18 string 1.2346e-18
64,6,1.2345678901234568e-18 string 1.23457e-18
64,7,1.2345678901234568e-18 string 1.234568e-18
64,8,1.2345678901234568e-18 string 1.2345679e-18
64,9,1.2345678901234568e-18 string 1.23456789e-18
64,10,1.2345678901234568e-18 string 1.234567890e-18
64,11,1.2345678901234568e-18 string 1.2345678901e-18
64,12,1.2345678901234568e-18 string 1.23456789012e-18
64,13,1.2345678901234568e-18 string 1.234567890123e-18
64,14,1.2345678901234568e-18 string 1.2345678901235e-18
64,15,1.2345678901234568e-18 string 1.23456789012346e-18
64,16,1.2345678901234568e-18 string 1.234567890123457e-18
64,17,1.2345678901234568e-18 string 1.2345678901234568e-18
64,18,1.2345678901234568e-18 string 1.23456789012345680e-18
64,19,1.2345678901234568e-18 string 1.234567890123456802e-18
64,20,1.2345678901234568e-18 string 1.2345678901234568016e-18
64,21,1.2345678901234568e-18 string 1.23456789012345680160e-18
RangeError
65,n/a,1.2345678901234568e-17 string 1.2345678901234568e-17
RangeError
65,1,1.2345678901234568e-17 string 1e-17
65,2,1.2345678901234568e-17 string 1.2e-17
65,3,1.2345678901234568e-17 string 1.23e-17
65,4,1.2345678901234568e-17 string 1.235e-17
65,5,1.2345678901234568e-17 string 1.2346e-17
65,6,1.2345678901234568e-17 string 1.23457e-17
65,7,1.2345678901234568e-17 string 1.234568e-17
65,8,1.2345678901234568e-17 string 1.2345679e-17
65,9,1.2345678901234568e-17 string 1.23456789e-17
65,10,1.2345678901234568e-17 string 1.234567890e-17
65,11,1.2345678901234568e-17 string 1.2345678901e-17
65,12,1.2345678901234568e-17 string 1.23456789012e-17
65,13,1.2345678901234568e-17 string 1.234567890123e-17
65,14,1.2345678901234568e-17 string 1.2345678901235e-17
65,15,1.2345678901234568e-17 string 1.23456789012346e-17
65,16,1.2345678901234568e-17 string 1.234567890123457e-17
65,17,1.2345678901234568e-17 string 1.2345678901234568e-17
65,18,1.2345678901234568e-17 string 1.23456789012345684e-17
65,19,1.2345678901234568e-17 string 1.234567890123456840e-17
65,20,1.2345678901234568e-17 string 1.2345678901234568401e-17
65,21,1.2345678901234568e-17 string 1.23456789012345684012e-17
RangeError
66,n/a,1.2345678901234568e-16 string 1.2345678901234568e-16
RangeError
66,1,1.2345678901234568e-16 string 1e-16
66,2,1.2345678901234568e-16 string 1.2e-16
66,3,1.2345678901234568e-16 string 1.23e-16
66,4,1.2345678901234568e-16 string 1.235e-16
66,5,1.2345678901234568e-16 string 1.2346e-16
66,6,1.2345678901234568e-16 string 1.23457e-16
66,7,1.2345678901234568e-16 string 1.234568e-16
66,8,1.2345678901234568e-16 string 1.2345679e-16
66,9,1.2345678901234568e-16 string 1.23456789e-16
66,10,1.2345678901234568e-16 string 1.234567890e-16
66,11,1.2345678901234568e-16 string 1.2345678901e-16
66,12,1.2345678901234568e-16 string 1.23456789012e-16
66,13,1.2345678901234568e-16 string 1.234567890123e-16
66,14,1.2345678901234568e-16 string 1.2345678901235e-16
66,15,1.2345678901234568e-16 string 1.23456789012346e-16
66,16,1.2345678901234568e-16 string 1.234567890123457e-16
66,17,1.2345678901234568e-16 string 1.2345678901234568e-16
66,18,1.2345678901234568e-16 string 1.23456789012345678e-16
66,19,1.2345678901234568e-16 string 1.234567890123456778e-16
66,20,1.2345678901234568e-16 string 1.2345678901234567785e-16
66,21,1.2345678901234568e-16 string 1.23456789012345677849e-16
RangeError
67,n/a,1.2345678901234568e-15 string 1.2345678901234568e-15
RangeError
67,1,1.2345678901234568e-15 string 1e-15
67,2,1.2345678901234568e-15 string 1.2e-15
67,3,1.2345678901234568e-15 string 1.23e-15
67,4,1.2345678901234568e-15 string 1.235e-15
67,5,1.2345678901234568e-15 string 1.2346e-15
67,6,1.2345678901234568e-15 string 1.23457e-15
67,7,1.2345678901234568e-15 string 1.234568e-15
67,8,1.2345678901234568e-15 string 1.2345679e-15
67,9,1.2345678901234568e-15 string 1.23456789e-15
67,10,1.2345678901234568e-15 string 1.234567890e-15
67,11,1.2345678901234568e-15 string 1.2345678901e-15
67,12,1.2345678901234568e-15 string 1.23456789012e-15
67,13,1.2345678901234568e-15 string 1.234567890123e-15
67,14,1.2345678901234568e-15 string 1.2345678901235e-15
67,15,1.2345678901234568e-15 string 1.23456789012346e-15
67,16,1.2345678901234568e-15 string 1.234567890123457e-15
67,17,1.2345678901234568e-15 string 1.2345678901234568e-15
67,18,1.2345678901234568e-15 string 1.23456789012345678e-15
67,19,1.2345678901234568e-15 string 1.234567890123456778e-15
67,20,1.2345678901234568e-15 string 1.2345678901234567785e-15
67,21,1.2345678901234568e-15 string 1.23456789012345677849e-15
RangeError
68,n/a,1.2345678901234568e-14 string 1.2345678901234568e-14
RangeError
68,1,1.2345678901234568e-14 string 1e-14
68,2,1.2345678901234568e-14 string 1.2e-14
68,3,1.2345678901234568e-14 string 1.23e-14
68,4,1.2345678901234568e-14 string 1.235e-14
68,5,1.2345678901234568e-14 string 1.2346e-14
68,6,1.2345678901234568e-14 string 1.23457e-14
68,7,1.2345678901234568e-14 string 1.234568e-14
68,8,1.2345678901234568e-14 string 1.2345679e-14
68,9,1.2345678901234568e-14 string 1.23456789e-14
68,10,1.2345678901234568e-14 string 1.234567890e-14
68,11,1.2345678901234568e-14 string 1.2345678901e-14
68,12,1.2345678901234568e-14 string 1.23456789012e-14
68,13,1.2345678901234568e-14 string 1.234567890123e-14
68,14,1.2345678901234568e-14 string 1.2345678901235e-14
68,15,1.2345678901234568e-14 string 1.23456789012346e-14
68,16,1.2345678901234568e-14 string 1.234567890123457e-14
68,17,1.2345678901234568e-14 string 1.2345678901234568e-14
68,18,1.2345678901234568e-14 string 1.23456789012345682e-14
68,19,1.2345678901234568e-14 string 1.234567890123456818e-14
68,20,1.2345678901234568e-14 string 1.2345678901234568179e-14
68,21,1.2345678901234568e-14 string 1.23456789012345681794e-14
RangeError
69,n/a,1.234567890123457e-13 string 1.234567890123457e-13
RangeError
69,1,1.234567890123457e-13 string 1e-13
69,2,1.234567890123457e-13 string 1.2e-13
69,3,1.234567890123457e-13 string 1.23e-13
69,4,1.234567890123457e-13 string 1.235e-13
69,5,1.234567890123457e-13 string 1.2346e-13
69,6,1.234567890123457e-13 string 1.23457e-13
69,7,1.234567890123457e-13 string 1.234568e-13
69,8,1.234567890123457e-13 string 1.2345679e-13
69,9,1.234567890123457e-13 string 1.23456789e-13
69,10,1.234567890123457e-13 string 1.234567890e-13
69,11,1.234567890123457e-13 string 1.2345678901e-13
69,12,1.234567890123457e-13 string 1.23456789012e-13
69,13,1.234567890123457e-13 string 1.234567890123e-13
69,14,1.234567890123457e-13 string 1.2345678901235e-13
69,15,1.234567890123457e-13 string 1.23456789012346e-13
69,16,1.234567890123457e-13 string 1.234567890123457e-13
69,17,1.234567890123457e-13 string 1.2345678901234569e-13
69,18,1.234567890123457e-13 string 1.23456789012345688e-13
69,19,1.234567890123457e-13 string 1.234567890123456881e-13
69,20,1.234567890123457e-13 string 1.2345678901234568810e-13
69,21,1.234567890123457e-13 string 1.23456789012345688104e-13
RangeError
70,n/a,1.2345678901234569e-12 string 1.2345678901234569e-12
RangeError
70,1,1.2345678901234569e-12 string 1e-12
70,2,1.2345678901234569e-12 string 1.2e-12
70,3,1.2345678901234569e-12 string 1.23e-12
70,4,1.2345678901234569e-12 string 1.235e-12
70,5,1.2345678901234569e-12 string 1.2346e-12
70,6,1.2345678901234569e-12 string 1.23457e-12
70,7,1.2345678901234569e-12 string 1.234568e-12
70,8,1.2345678901234569e-12 string 1.2345679e-12
70,9,1.2345678901234569e-12 string 1.23456789e-12
70,10,1.2345678901234569e-12 string 1.234567890e-12
70,11,1.2345678901234569e-12 string 1.2345678901e-12
70,12,1.2345678901234569e-12 string 1.23456789012e-12
70,13,1.2345678901234569e-12 string 1.234567890123e-12
70,14,1.2345678901234569e-12 string 1.2345678901235e-12
70,15,1.2345678901234569e-12 string 1.23456789012346e-12
70,16,1.2345678901234569e-12 string 1.234567890123457e-12
70,17,1.2345678901234569e-12 string 1.2345678901234569e-12
70,18,1.2345678901234569e-12 string 1.23456789012345688e-12
70,19,1.2345678901234569e-12 string 1.234567890123456881e-12
70,20,1.2345678901234569e-12 string 1.2345678901234568810e-12
70,21,1.2345678901234569e-12 string 1.23456789012345688104e-12
RangeError
71,n/a,1.2345678901234568e-11 string 1.2345678901234568e-11
RangeError
71,1,1.2345678901234568e-11 string 1e-11
71,2,1.2345678901234568e-11 string 1.2e-11
71,3,1.2345678901234568e-11 string 1.23e-11
71,4,1.2345678901234568e-11 string 1.235e-11
71,5,1.2345678901234568e-11 string 1.2346e-11
71,6,1.2345678901234568e-11 string 1.23457e-11
71,7,1.2345678901234568e-11 string 1.234568e-11
71,8,1.2345678901234568e-11 string 1.2345679e-11
71,9,1.2345678901234568e-11 string 1.23456789e-11
71,10,1.2345678901234568e-11 string 1.234567890e-11
71,11,1.2345678901234568e-11 string 1.2345678901e-11
71,12,1.2345678901234568e-11 string 1.23456789012e-11
71,13,1.2345678901234568e-11 string 1.234567890123e-11
71,14,1.2345678901234568e-11 string 1.2345678901235e-11
71,15,1.2345678901234568e-11 string 1.23456789012346e-11
71,16,1.2345678901234568e-11 string 1.234567890123457e-11
71,17,1.2345678901234568e-11 string 1.2345678901234568e-11
71,18,1.2345678901234568e-11 string 1.23456789012345684e-11
71,19,1.2345678901234568e-11 string 1.234567890123456841e-11
71,20,1.2345678901234568e-11 string 1.2345678901234568407e-11
71,21,1.2345678901234568e-11 string 1.23456789012345684065e-11
RangeError
72,n/a,1.2345678901234568e-10 string 1.2345678901234568e-10
RangeError
72,1,1.2345678901234568e-10 string 1e-10
72,2,1.2345678901234568e-10 string 1.2e-10
72,3,1.2345678901234568e-10 string 1.23e-10
72,4,1.2345678901234568e-10 string 1.235e-10
72,5,1.2345678901234568e-10 string 1.2346e-10
72,6,1.2345678901234568e-10 string 1.23457e-10
72,7,1.2345678901234568e-10 string 1.234568e-10
72,8,1.2345678901234568e-10 string 1.2345679e-10
72,9,1.2345678901234568e-10 string 1.23456789e-10
72,10,1.2345678901234568e-10 string 1.234567890e-10
72,11,1.2345678901234568e-10 string 1.2345678901e-10
72,12,1.2345678901234568e-10 string 1.23456789012e-10
72,13,1.2345678901234568e-10 string 1.234567890123e-10
72,14,1.2345678901234568e-10 string 1.2345678901235e-10
72,15,1.2345678901234568e-10 string 1.23456789012346e-10
72,16,1.2345678901234568e-10 string 1.234567890123457e-10
72,17,1.2345678901234568e-10 string 1.2345678901234568e-10
72,18,1.2345678901234568e-10 string 1.23456789012345678e-10
72,19,1.2345678901234568e-10 string 1.234567890123456776e-10
72,20,1.2345678901234568e-10 string 1.2345678901234567760e-10
72,21,1.2345678901234568e-10 string 1.23456789012345677603e-10
RangeError
73,n/a,1.2345678901234568e-9 string 1.2345678901234568e-9
RangeError
73,1,1.2345678901234568e-9 string 1e-9
73,2,1.2345678901234568e-9 string 1.2e-9
73,3,1.2345678901234568e-9 string 1.23e-9
73,4,1.2345678901234568e-9 string 1.235e-9
73,5,1.2345678901234568e-9 string 1.2346e-9
73,6,1.2345678901234568e-9 string 1.23457e-9
73,7,1.2345678901234568e-9 string 1.234568e-9
73,8,1.2345678901234568e-9 string 1.2345679e-9
73,9,1.2345678901234568e-9 string 1.23456789e-9
73,10,1.2345678901234568e-9 string 1.234567890e-9
73,11,1.2345678901234568e-9 string 1.2345678901e-9
73,12,1.2345678901234568e-9 string 1.23456789012e-9
73,13,1.2345678901234568e-9 string 1.234567890123e-9
73,14,1.2345678901234568e-9 string 1.2345678901235e-9
73,15,1.2345678901234568e-9 string 1.23456789012346e-9
73,16,1.2345678901234568e-9 string 1.234567890123457e-9
73,17,1.2345678901234568e-9 string 1.2345678901234568e-9
73,18,1.2345678901234568e-9 string 1.23456789012345683e-9
73,19,1.2345678901234568e-9 string 1.234567890123456828e-9
73,20,1.2345678901234568e-9 string 1.2345678901234568277e-9
73,21,1.2345678901234568e-9 string 1.23456789012345682773e-9
RangeError
74,n/a,1.2345678901234567e-8 string 1.2345678901234567e-8
RangeError
74,1,1.2345678901234567e-8 string 1e-8
74,2,1.2345678901234567e-8 string 1.2e-8
74,3,1.2345678901234567e-8 string 1.23e-8
74,4,1.2345678901234567e-8 string 1.235e-8
74,5,1.2345678901234567e-8 string 1.2346e-8
74,6,1.2345678901234567e-8 string 1.23457e-8
74,7,1.2345678901234567e-8 string 1.234568e-8
74,8,1.2345678901234567e-8 string 1.2345679e-8
74,9,1.2345678901234567e-8 string 1.23456789e-8
74,10,1.2345678901234567e-8 string 1.234567890e-8
74,11,1.2345678901234567e-8 string 1.2345678901e-8
74,12,1.2345678901234567e-8 string 1.23456789012e-8
74,13,1.2345678901234567e-8 string 1.234567890123e-8
74,14,1.2345678901234567e-8 string 1.2345678901235e-8
74,15,1.2345678901234567e-8 string 1.23456789012346e-8
74,16,1.2345678901234567e-8 string 1.234567890123457e-8
74,17,1.2345678901234567e-8 string 1.2345678901234567e-8
74,18,1.2345678901234567e-8 string 1.23456789012345675e-8
74,19,1.2345678901234567e-8 string 1.234567890123456745e-8
74,20,1.2345678901234567e-8 string 1.2345678901234567450e-8
74,21,1.2345678901234567e-8 string 1.23456789012345674501e-8
RangeError
75,n/a,1.2345678901234568e-7 string 1.2345678901234568e-7
RangeError
75,1,1.2345678901234568e-7 string 1e-7
75,2,1.2345678901234568e-7 string 1.2e-7
75,3,1.2345678901234568e-7 string 1.23e-7
75,4,1.2345678901234568e-7 string 1.235e-7
75,5,1.2345678901234568e-7 string 1.2346e-7
75,6,1.2345678901234568e-7 string 1.23457e-7
75,7,1.2345678901234568e-7 string 1.234568e-7
75,8,1.2345678901234568e-7 string 1.2345679e-7
75,9,1.2345678901234568e-7 string 1.23456789e-7
75,10,1.2345678901234568e-7 string 1.234567890e-7
75,11,1.2345678901234568e-7 string 1.2345678901e-7
75,12,1.2345678901234568e-7 string 1.23456789012e-7
75,13,1.2345678901234568e-7 string 1.234567890123e-7
75,14,1.2345678901234568e-7 string 1.2345678901235e-7
75,15,1.2345678901234568e-7 string 1.23456789012346e-7
75,16,1.2345678901234568e-7 string 1.234567890123457e-7
75,17,1.2345678901234568e-7 string 1.2345678901234568e-7
75,18,1.2345678901234568e-7 string 1.23456789012345684e-7
75,19,1.2345678901234568e-7 string 1.234567890123456844e-7
75,20,1.2345678901234568e-7 string 1.2345678901234568443e-7
75,21,1.2345678901234568e-7 string 1.23456789012345684427e-7
RangeError
76,n/a,0.0000012345678901234567 string 0.0000012345678901234567
RangeError
76,1,0.0000012345678901234567 string 0.000001
76,2,0.0000012345678901234567 string 0.0000012
76,3,0.0000012345678901234567 string 0.00000123
76,4,0.0000012345678901234567 string 0.000001235
76,5,0.0000012345678901234567 string 0.0000012346
76,6,0.0000012345678901234567 string 0.00000123457
76,7,0.0000012345678901234567 string 0.000001234568
76,8,0.0000012345678901234567 string 0.0000012345679
76,9,0.0000012345678901234567 string 0.00000123456789
76,10,0.0000012345678901234567 string 0.000001234567890
76,11,0.0000012345678901234567 string 0.0000012345678901
76,12,0.0000012345678901234567 string 0.00000123456789012
76,13,0.0000012345678901234567 string 0.000001234567890123
76,14,0.0000012345678901234567 string 0.0000012345678901235
76,15,0.0000012345678901234567 string 0.00000123456789012346
76,16,0.0000012345678901234567 string 0.000001234567890123457
76,17,0.0000012345678901234567 string 0.0000012345678901234567
76,18,0.0000012345678901234567 string 0.00000123456789012345674
76,19,0.0000012345678901234567 string 0.000001234567890123456738
76,20,0.0000012345678901234567 string 0.0000012345678901234567384
76,21,0.0000012345678901234567 string 0.00000123456789012345673839
RangeError
77,n/a,0.000012345678901234568 string 0.000012345678901234568
RangeError
77,1,0.000012345678901234568 string 0.00001
77,2,0.000012345678901234568 string 0.000012
77,3,0.000012345678901234568 string 0.0000123
77,4,0.000012345678901234568 string 0.00001235
77,5,0.000012345678901234568 string 0.000012346
77,6,0.000012345678901234568 string 0.0000123457
77,7,0.000012345678901234568 string 0.00001234568
77,8,0.000012345678901234568 string 0.000012345679
77,9,0.000012345678901234568 string 0.0000123456789
77,10,0.000012345678901234568 string 0.00001234567890
77,11,0.000012345678901234568 string 0.000012345678901
77,12,0.000012345678901234568 string 0.0000123456789012
77,13,0.000012345678901234568 string 0.00001234567890123
77,14,0.000012345678901234568 string 0.000012345678901235
77,15,0.000012345678901234568 string 0.0000123456789012346
77,16,0.000012345678901234568 string 0.00001234567890123457
77,17,0.000012345678901234568 string 0.000012345678901234568
77,18,0.000012345678901234568 string 0.0000123456789012345678
77,19,0.000012345678901234568 string 0.00001234567890123456781
77,20,0.000012345678901234568 string 0.000012345678901234567807
77,21,0.000012345678901234568 string 0.0000123456789012345678075
RangeError
78,n/a,0.00012345678901234567 string 0.00012345678901234567
RangeError
78,1,0.00012345678901234567 string 0.0001
78,2,0.00012345678901234567 string 0.00012
78,3,0.00012345678901234567 string 0.000123
78,4,0.00012345678901234567 string 0.0001235
78,5,0.00012345678901234567 string 0.00012346
78,6,0.00012345678901234567 string 0.000123457
78,7,0.00012345678901234567 string 0.0001234568
78,8,0.00012345678901234567 string 0.00012345679
78,9,0.00012345678901234567 string 0.000123456789
78,10,0.00012345678901234567 string 0.0001234567890
78,11,0.00012345678901234567 string 0.00012345678901
78,12,0.00012345678901234567 string 0.000123456789012
78,13,0.00012345678901234567 string 0.0001234567890123
78,14,0.00012345678901234567 string 0.00012345678901235
78,15,0.00012345678901234567 string 0.000123456789012346
78,16,0.00012345678901234567 string 0.0001234567890123457
78,17,0.00012345678901234567 string 0.00012345678901234567
78,18,0.00012345678901234567 string 0.000123456789012345671
78,19,0.00012345678901234567 string 0.0001234567890123456713
78,20,0.00012345678901234567 string 0.00012345678901234567130
78,21,0.00012345678901234567 string 0.000123456789012345671298
RangeError
79,n/a,0.0012345678901234567 string 0.0012345678901234567
RangeError
79,1,0.0012345678901234567 string 0.001
79,2,0.0012345678901234567 string 0.0012
79,3,0.0012345678901234567 string 0.00123
79,4,0.0012345678901234567 string 0.001235
79,5,0.0012345678901234567 string 0.0012346
79,6,0.0012345678901234567 string 0.00123457
79,7,0.0012345678901234567 string 0.001234568
79,8,0.0012345678901234567 string 0.0012345679
79,9,0.0012345678901234567 string 0.00123456789
79,10,0.0012345678901234567 string 0.001234567890
79,11,0.0012345678901234567 string 0.0012345678901
79,12,0.0012345678901234567 string 0.00123456789012
79,13,0.0012345678901234567 string 0.001234567890123
79,14,0.0012345678901234567 string 0.0012345678901235
79,15,0.0012345678901234567 string 0.00123456789012346
79,16,0.0012345678901234567 string 0.001234567890123457
79,17,0.0012345678901234567 string 0.0012345678901234567
79,18,0.0012345678901234567 string 0.00123456789012345671
79,19,0.0012345678901234567 string 0.001234567890123456713
79,20,0.0012345678901234567 string 0.0012345678901234567130
79,21,0.0012345678901234567 string 0.00123456789012345671298
RangeError
80,n/a,0.012345678901234568 string 0.012345678901234568
RangeError
80,1,0.012345678901234568 string 0.01
80,2,0.012345678901234568 string 0.012
80,3,0.012345678901234568 string 0.0123
80,4,0.012345678901234568 string 0.01235
80,5,0.012345678901234568 string 0.012346
80,6,0.012345678901234568 string 0.0123457
80,7,0.012345678901234568 string 0.01234568
80,8,0.012345678901234568 string 0.012345679
80,9,0.012345678901234568 string 0.0123456789
80,10,0.012345678901234568 string 0.01234567890
80,11,0.012345678901234568 string 0.012345678901
80,12,0.012345678901234568 string 0.0123456789012
80,13,0.012345678901234568 string 0.01234567890123
80,14,0.012345678901234568 string 0.012345678901235
80,15,0.012345678901234568 string 0.0123456789012346
80,16,0.012345678901234568 string 0.01234567890123457
80,17,0.012345678901234568 string 0.012345678901234568
80,18,0.012345678901234568 string 0.0123456789012345684
80,19,0.012345678901234568 string 0.01234567890123456843
80,20,0.012345678901234568 string 0.012345678901234568431
80,21,0.012345678901234568 string 0.0123456789012345684309
RangeError
81,n/a,0.12345678901234568 string 0.12345678901234568
RangeError
81,1,0.12345678901234568 string 0.1
81,2,0.12345678901234568 string 0.12
81,3,0.12345678901234568 string 0.123
81,4,0.12345678901234568 string 0.1235
81,5,0.12345678901234568 string 0.12346
81,6,0.12345678901234568 string 0.123457
81,7,0.12345678901234568 string 0.1234568
81,8,0.12345678901234568 string 0.12345679
81,9,0.12345678901234568 string 0.123456789
81,10,0.12345678901234568 string 0.1234567890
81,11,0.12345678901234568 string 0.12345678901
81,12,0.12345678901234568 string 0.123456789012
81,13,0.12345678901234568 string 0.1234567890123
81,14,0.12345678901234568 string 0.12345678901235
81,15,0.12345678901234568 string 0.123456789012346
81,16,0.12345678901234568 string 0.1234567890123457
81,17,0.12345678901234568 string 0.12345678901234568
81,18,0.12345678901234568 string 0.123456789012345677
81,19,0.12345678901234568 string 0.1234567890123456774
81,20,0.12345678901234568 string 0.12345678901234567737
81,21,0.12345678901234568 string 0.123456789012345677370
RangeError
82,n/a,1.2345678901234567 string 1.2345678901234567
RangeError
82,1,1.2345678901234567 string 1
82,2,1.2345678901234567 string 1.2
82,3,1.2345678901234567 string 1.23
82,4,1.2345678901234567 string 1.235
82,5,1.2345678901234567 string 1.2346
82,6,1.2345678901234567 string 1.23457
82,7,1.2345678901234567 string 1.234568
82,8,1.2345678901234567 string 1.2345679
82,9,1.2345678901234567 string 1.23456789
82,10,1.2345678901234567 string 1.234567890
82,11,1.2345678901234567 string 1.2345678901
82,12,1.2345678901234567 string 1.23456789012
82,13,1.2345678901234567 string 1.234567890123
82,14,1.2345678901234567 string 1.2345678901235
82,15,1.2345678901234567 string 1.23456789012346
82,16,1.2345678901234567 string 1.234567890123457
82,17,1.2345678901234567 string 1.2345678901234567
82,18,1.2345678901234567 string 1.23456789012345669
82,19,1.2345678901234567 string 1.234567890123456690
82,20,1.2345678901234567 string 1.2345678901234566904
82,21,1.2345678901234567 string 1.23456789012345669043
RangeError
83,n/a,12.345678901234567 string 12.345678901234567
RangeError
83,1,12.345678901234567 string 1e+1
83,2,12.345678901234567 string 12
83,3,12.345678901234567 string 12.3
83,4,12.345678901234567 string 12.35
83,5,12.345678901234567 string 12.346
83,6,12.345678901234567 string 12.3457
83,7,12.345678901234567 string 12.34568
83,8,12.345678901234567 string 12.345679
83,9,12.345678901234567 string 12.3456789
83,10,12.345678901234567 string 12.34567890
83,11,12.345678901234567 string 12.345678901
83,12,12.345678901234567 string 12.3456789012
83,13,12.345678901234567 string 12.34567890123
83,14,12.345678901234567 string 12.345678901235
83,15,12.345678901234567 string 12.3456789012346
83,16,12.345678901234567 string 12.34567890123457
83,17,12.345678901234567 string 12.345678901234567
83,18,12.345678901234567 string 12.3456789012345673
83,19,12.345678901234567 string 12.34567890123456735
83,20,12.345678901234567 string 12.345678901234567348
83,21,12.345678901234567 string 12.3456789012345673484
RangeError
84,n/a,123.45678901234568 string 123.45678901234568
RangeError
84,1,123.45678901234568 string 1e+2
84,2,123.45678901234568 string 1.2e+2
84,3,123.45678901234568 string 123
84,4,123.45678901234568 string 123.5
84,5,123.45678901234568 string 123.46
84,6,123.45678901234568 string 123.457
84,7,123.45678901234568 string 123.4568
84,8,123.45678901234568 string 123.45679
84,9,123.45678901234568 string 123.456789
84,10,123.45678901234568 string 123.4567890
84,11,123.45678901234568 string 123.45678901
84,12,123.45678901234568 string 123.456789012
84,13,123.45678901234568 string 123.4567890123
84,14,123.45678901234568 string 123.45678901235
84,15,123.45678901234568 string 123.456789012346
84,16,123.45678901234568 string 123.4567890123457
84,17,123.45678901234568 string 123.45678901234568
84,18,123.45678901234568 string 123.456789012345681
84,19,123.45678901234568 string 123.4567890123456806
84,20,123.45678901234568 string 123.45678901234568059
84,21,123.45678901234568 string 123.456789012345680590
RangeError
85,n/a,1234.567890123457 string 1234.567890123457
RangeError
85,1,1234.567890123457 string 1e+3
85,2,1234.567890123457 string 1.2e+3
85,3,1234.567890123457 string 1.23e+3
85,4,1234.567890123457 string 1235
85,5,1234.567890123457 string 1234.6
85,6,1234.567890123457 string 1234.57
85,7,1234.567890123457 string 1234.568
85,8,1234.567890123457 string 1234.5679
85,9,1234.567890123457 string 1234.56789
85,10,1234.567890123457 string 1234.567890
85,11,1234.567890123457 string 1234.5678901
85,12,1234.567890123457 string 1234.56789012
85,13,1234.567890123457 string 1234.567890123
85,14,1234.567890123457 string 1234.5678901235
85,15,1234.567890123457 string 1234.56789012346
85,16,1234.567890123457 string 1234.567890123457
85,17,1234.567890123457 string 1234.5678901234569
85,18,1234.567890123457 string 1234.56789012345689
85,19,1234.567890123457 string 1234.567890123456891
85,20,1234.567890123457 string 1234.5678901234568912
85,21,1234.567890123457 string 1234.56789012345689116
RangeError
86,n/a,12345.678901234567 string 12345.678901234567
RangeError
86,1,12345.678901234567 string 1e+4
86,2,12345.678901234567 string 1.2e+4
86,3,12345.678901234567 string 1.23e+4
86,4,12345.678901234567 string 1.235e+4
86,5,12345.678901234567 string 12346
86,6,12345.678901234567 string 12345.7
86,7,12345.678901234567 string 12345.68
86,8,12345.678901234567 string 12345.679
86,9,12345.678901234567 string 12345.6789
86,10,12345.678901234567 string 12345.67890
86,11,12345.678901234567 string 12345.678901
86,12,12345.678901234567 string 12345.6789012
86,13,12345.678901234567 string 12345.67890123
86,14,12345.678901234567 string 12345.678901235
86,15,12345.678901234567 string 12345.6789012346
86,16,12345.678901234567 string 12345.67890123457
86,17,12345.678901234567 string 12345.678901234567
86,18,12345.678901234567 string 12345.6789012345671
86,19,12345.678901234567 string 12345.67890123456709
86,20,12345.678901234567 string 12345.678901234567093
86,21,12345.678901234567 string 12345.6789012345670926
RangeError
87,n/a,123456.78901234567 string 123456.78901234567
RangeError
87,1,123456.78901234567 string 1e+5
87,2,123456.78901234567 string 1.2e+5
87,3,123456.78901234567 string 1.23e+5
87,4,123456.78901234567 string 1.235e+5
87,5,123456.78901234567 string 1.2346e+5
87,6,123456.78901234567 string 123457
87,7,123456.78901234567 string 123456.8
87,8,123456.78901234567 string 123456.79
87,9,123456.78901234567 string 123456.789
87,10,123456.78901234567 string 123456.7890
87,11,123456.78901234567 string 123456.78901
87,12,123456.78901234567 string 123456.789012
87,13,123456.78901234567 string 123456.7890123
87,14,123456.78901234567 string 123456.78901235
87,15,123456.78901234567 string 123456.789012346
87,16,123456.78901234567 string 123456.7890123457
87,17,123456.78901234567 string 123456.78901234567
87,18,123456.78901234567 string 123456.789012345675
87,19,123456.78901234567 string 123456.7890123456746
87,20,123456.78901234567 string 123456.78901234567456
87,21,123456.78901234567 string 123456.789012345674564
RangeError
88,n/a,1234567.8901234567 string 1234567.8901234567
RangeError
88,1,1234567.8901234567 string 1e+6
88,2,1234567.8901234567 string 1.2e+6
88,3,1234567.8901234567 string 1.23e+6
88,4,1234567.8901234567 string 1.235e+6
88,5,1234567.8901234567 string 1.2346e+6
88,6,1234567.8901234567 string 1.23457e+6
88,7,1234567.8901234567 string 1234568
88,8,1234567.8901234567 string 1234567.9
88,9,1234567.8901234567 string 1234567.89
88,10,1234567.8901234567 string 1234567.890
88,11,1234567.8901234567 string 1234567.8901
88,12,1234567.8901234567 string 1234567.89012
88,13,1234567.8901234567 string 1234567.890123
88,14,1234567.8901234567 string 1234567.8901235
88,15,1234567.8901234567 string 1234567.89012346
88,16,1234567.8901234567 string 1234567.890123457
88,17,1234567.8901234567 string 1234567.8901234567
88,18,1234567.8901234567 string 1234567.89012345672
88,19,1234567.8901234567 string 1234567.890123456717
88,20,1234567.8901234567 string 1234567.8901234567165
88,21,1234567.8901234567 string 1234567.89012345671654
RangeError
89,n/a,12345678.901234567 string 12345678.901234567
RangeError
89,1,12345678.901234567 string 1e+7
89,2,12345678.901234567 string 1.2e+7
89,3,12345678.901234567 string 1.23e+7
89,4,12345678.901234567 string 1.235e+7
89,5,12345678.901234567 string 1.2346e+7
89,6,12345678.901234567 string 1.23457e+7
89,7,12345678.901234567 string 1.234568e+7
89,8,12345678.901234567 string 12345679
89,9,12345678.901234567 string 12345678.9
89,10,12345678.901234567 string 12345678.90
89,11,12345678.901234567 string 12345678.901
89,12,12345678.901234567 string 12345678.9012
89,13,12345678.901234567 string 12345678.90123
89,14,12345678.901234567 string 12345678.901235
89,15,12345678.901234567 string 12345678.9012346
89,16,12345678.901234567 string 12345678.90123457
89,17,12345678.901234567 string 12345678.901234567
89,18,12345678.901234567 string 12345678.9012345672
89,19,12345678.901234567 string 12345678.90123456717
89,20,12345678.901234567 string 12345678.901234567165
89,21,12345678.901234567 string 12345678.9012345671654
RangeError
90,n/a,123456789.01234567 string 123456789.01234567
RangeError
90,1,123456789.01234567 string 1e+8
90,2,123456789.01234567 string 1.2e+8
90,3,123456789.01234567 string 1.23e+8
90,4,123456789.01234567 string 1.235e+8
90,5,123456789.01234567 string 1.2346e+8
90,6,123456789.01234567 string 1.23457e+8
90,7,123456789.01234567 string 1.234568e+8
90,8,123456789.01234567 string 1.2345679e+8
90,9,123456789.01234567 string 123456789
90,10,123456789.01234567 string 123456789.0
90,11,123456789.01234567 string 123456789.01
90,12,123456789.01234567 string 123456789.012
90,13,123456789.01234567 string 123456789.0123
90,14,123456789.01234567 string 123456789.01235
90,15,123456789.01234567 string 123456789.012346
90,16,123456789.01234567 string 123456789.0123457
90,17,123456789.01234567 string 123456789.01234567
90,18,123456789.01234567 string 123456789.012345672
90,19,123456789.01234567 string 123456789.0123456717
90,20,123456789.01234567 string 123456789.01234567165
90,21,123456789.01234567 string 123456789.012345671654
RangeError
91,n/a,1234567890.1234567 string 1234567890.1234567
RangeError
91,1,1234567890.1234567 string 1e+9
91,2,1234567890.1234567 string 1.2e+9
91,3,1234567890.1234567 string 1.23e+9
91,4,1234567890.1234567 string 1.235e+9
91,5,1234567890.1234567 string 1.2346e+9
91,6,1234567890.1234567 string 1.23457e+9
91,7,1234567890.1234567 string 1.234568e+9
91,8,1234567890.1234567 string 1.2345679e+9
91,9,1234567890.1234567 string 1.23456789e+9
91,10,1234567890.1234567 string 1234567890
91,11,1234567890.1234567 string 1234567890.1
91,12,1234567890.1234567 string 1234567890.12
91,13,1234567890.1234567 string 1234567890.123
91,14,1234567890.1234567 string 1234567890.1235
91,15,1234567890.1234567 string 1234567890.12346
91,16,1234567890.1234567 string 1234567890.123457
91,17,1234567890.1234567 string 1234567890.1234567
91,18,1234567890.1234567 string 1234567890.12345672
91,19,1234567890.1234567 string 1234567890.123456717
91,20,1234567890.1234567 string 1234567890.1234567165
91,21,1234567890.1234567 string 1234567890.12345671654
RangeError
92,n/a,12345678901.234568 string 12345678901.234568
RangeError
92,1,12345678901.234568 string 1e+10
92,2,12345678901.234568 string 1.2e+10
92,3,12345678901.234568 string 1.23e+10
92,4,12345678901.234568 string 1.235e+10
92,5,12345678901.234568 string 1.2346e+10
92,6,12345678901.234568 string 1.23457e+10
92,7,12345678901.234568 string 1.234568e+10
92,8,12345678901.234568 string 1.2345679e+10
92,9,12345678901.234568 string 1.23456789e+10
92,10,12345678901.234568 string 1.234567890e+10
92,11,12345678901.234568 string 12345678901
92,12,12345678901.234568 string 12345678901.2
92,13,12345678901.234568 string 12345678901.23
92,14,12345678901.234568 string 12345678901.235
92,15,12345678901.234568 string 12345678901.2346
92,16,12345678901.234568 string 12345678901.23457
92,17,12345678901.234568 string 12345678901.234568
92,18,12345678901.234568 string 12345678901.2345676
92,19,12345678901.234568 string 12345678901.23456764
92,20,12345678901.234568 string 12345678901.234567642
92,21,12345678901.234568 string 12345678901.2345676422
RangeError
93,n/a,123456789012.34567 string 123456789012.34567
RangeError
93,1,123456789012.34567 string 1e+11
93,2,123456789012.34567 string 1.2e+11
93,3,123456789012.34567 string 1.23e+11
93,4,123456789012.34567 string 1.235e+11
93,5,123456789012.34567 string 1.2346e+11
93,6,123456789012.34567 string 1.23457e+11
93,7,123456789012.34567 string 1.234568e+11
93,8,123456789012.34567 string 1.2345679e+11
93,9,123456789012.34567 string 1.23456789e+11
93,10,123456789012.34567 string 1.234567890e+11
93,11,123456789012.34567 string 1.2345678901e+11
93,12,123456789012.34567 string 123456789012
93,13,123456789012.34567 string 123456789012.3
93,14,123456789012.34567 string 123456789012.35
93,15,123456789012.34567 string 123456789012.346
93,16,123456789012.34567 string 123456789012.3457
93,17,123456789012.34567 string 123456789012.34567
93,18,123456789012.34567 string 123456789012.345673
93,19,123456789012.34567 string 123456789012.3456726
93,20,123456789012.34567 string 123456789012.34567261
93,21,123456789012.34567 string 123456789012.345672607
RangeError
94,n/a,1234567890123.4568 string 1234567890123.4568
RangeError
94,1,1234567890123.4568 string 1e+12
94,2,1234567890123.4568 string 1.2e+12
94,3,1234567890123.4568 string 1.23e+12
94,4,1234567890123.4568 string 1.235e+12
94,5,1234567890123.4568 string 1.2346e+12
94,6,1234567890123.4568 string 1.23457e+12
94,7,1234567890123.4568 string 1.234568e+12
94,8,1234567890123.4568 string 1.2345679e+12
94,9,1234567890123.4568 string 1.23456789e+12
94,10,1234567890123.4568 string 1.234567890e+12
94,11,1234567890123.4568 string 1.2345678901e+12
94,12,1234567890123.4568 string 1.23456789012e+12
94,13,1234567890123.4568 string 1234567890123
94,14,1234567890123.4568 string 1234567890123.5
94,15,1234567890123.4568 string 1234567890123.46
94,16,1234567890123.4568 string 1234567890123.457
94,17,1234567890123.4568 string 1234567890123.4568
94,18,1234567890123.4568 string 1234567890123.45679
94,19,1234567890123.4568 string 1234567890123.456787
94,20,1234567890123.4568 string 1234567890123.4567871
94,21,1234567890123.4568 string 1234567890123.45678711
RangeError
95,n/a,12345678901234.568 string 12345678901234.568
RangeError
95,1,12345678901234.568 string 1e+13
95,2,12345678901234.568 string 1.2e+13
95,3,12345678901234.568 string 1.23e+13
95,4,12345678901234.568 string 1.235e+13
95,5,12345678901234.568 string 1.2346e+13
95,6,12345678901234.568 string 1.23457e+13
95,7,12345678901234.568 string 1.234568e+13
95,8,12345678901234.568 string 1.2345679e+13
95,9,12345678901234.568 string 1.23456789e+13
95,10,12345678901234.568 string 1.234567890e+13
95,11,12345678901234.568 string 1.2345678901e+13
95,12,12345678901234.568 string 1.23456789012e+13
95,13,12345678901234.568 string 1.234567890123e+13
95,14,12345678901234.568 string 12345678901235
95,15,12345678901234.568 string 12345678901234.6
95,16,12345678901234.568 string 12345678901234.57
95,17,12345678901234.568 string 12345678901234.568
95,18,12345678901234.568 string 12345678901234.5684
95,19,12345678901234.568 string 12345678901234.56836
95,20,12345678901234.568 string 12345678901234.568359
95,21,12345678901234.568 string 12345678901234.5683594
RangeError
96,n/a,123456789012345.67 string 123456789012345.67
RangeError
96,1,123456789012345.67 string 1e+14
96,2,123456789012345.67 string 1.2e+14
96,3,123456789012345.67 string 1.23e+14
96,4,123456789012345.67 string 1.235e+14
96,5,123456789012345.67 string 1.2346e+14
96,6,123456789012345.67 string 1.23457e+14
96,7,123456789012345.67 string 1.234568e+14
96,8,123456789012345.67 string 1.2345679e+14
96,9,123456789012345.67 string 1.23456789e+14
96,10,123456789012345.67 string 1.234567890e+14
96,11,123456789012345.67 string 1.2345678901e+14
96,12,123456789012345.67 string 1.23456789012e+14
96,13,123456789012345.67 string 1.234567890123e+14
96,14,123456789012345.67 string 1.2345678901235e+14
96,15,123456789012345.67 string 123456789012346
96,16,123456789012345.67 string 123456789012345.7
96,17,123456789012345.67 string 123456789012345.67
96,18,123456789012345.67 string 123456789012345.672
96,19,123456789012345.67 string 123456789012345.6719
96,20,123456789012345.67 string 123456789012345.67188
96,21,123456789012345.67 string 123456789012345.671875
RangeError
97,n/a,1234567890123456.8 string 1234567890123456.8
RangeError
97,1,1234567890123456.8 string 1e+15
97,2,1234567890123456.8 string 1.2e+15
97,3,1234567890123456.8 string 1.23e+15
97,4,1234567890123456.8 string 1.235e+15
97,5,1234567890123456.8 string 1.2346e+15
97,6,1234567890123456.8 string 1.23457e+15
97,7,1234567890123456.8 string 1.234568e+15
97,8,1234567890123456.8 string 1.2345679e+15
97,9,1234567890123456.8 string 1.23456789e+15
97,10,1234567890123456.8 string 1.234567890e+15
97,11,1234567890123456.8 string 1.2345678901e+15
97,12,1234567890123456.8 string 1.23456789012e+15
97,13,1234567890123456.8 string 1.234567890123e+15
97,14,1234567890123456.8 string 1.2345678901235e+15
97,15,1234567890123456.8 string 1.23456789012346e+15
97,16,1234567890123456.8 string 1234567890123457
97,17,1234567890123456.8 string 1234567890123456.8
97,18,1234567890123456.8 string 1234567890123456.75
97,19,1234567890123456.8 string 1234567890123456.750
97,20,1234567890123456.8 string 1234567890123456.7500
97,21,1234567890123456.8 string 1234567890123456.75000
RangeError
98,n/a,12345678901234568 string 12345678901234568
RangeError
98,1,12345678901234568 string 1e+16
98,2,12345678901234568 string 1.2e+16
98,3,12345678901234568 string 1.23e+16
98,4,12345678901234568 string 1.235e+16
98,5,12345678901234568 string 1.2346e+16
98,6,12345678901234568 string 1.23457e+16
98,7,12345678901234568 string 1.234568e+16
98,8,12345678901234568 string 1.2345679e+16
98,9,12345678901234568 string 1.23456789e+16
98,10,12345678901234568 string 1.234567890e+16
98,11,12345678901234568 string 1.2345678901e+16
98,12,12345678901234568 string 1.23456789012e+16
98,13,12345678901234568 string 1.234567890123e+16
98,14,12345678901234568 string 1.2345678901235e+16
98,15,12345678901234568 string 1.23456789012346e+16
98,16,12345678901234568 string 1.234567890123457e+16
98,17,12345678901234568 string 12345678901234568
98,18,12345678901234568 string 12345678901234568.0
98,19,12345678901234568 string 12345678901234568.00
98,20,12345678901234568 string 12345678901234568.000
98,21,12345678901234568 string 12345678901234568.0000
RangeError
99,n/a,123456789012345680 string 123456789012345680
RangeError
99,1,123456789012345680 string 1e+17
99,2,123456789012345680 string 1.2e+17
99,3,123456789012345680 string 1.23e+17
99,4,123456789012345680 string 1.235e+17
99,5,123456789012345680 string 1.2346e+17
99,6,123456789012345680 string 1.23457e+17
99,7,123456789012345680 string 1.234568e+17
99,8,123456789012345680 string 1.2345679e+17
99,9,123456789012345680 string 1.23456789e+17
99,10,123456789012345680 string 1.234567890e+17
99,11,123456789012345680 string 1.2345678901e+17
99,12,123456789012345680 string 1.23456789012e+17
99,13,123456789012345680 string 1.234567890123e+17
99,14,123456789012345680 string 1.2345678901235e+17
99,15,123456789012345680 string 1.23456789012346e+17
99,16,123456789012345680 string 1.234567890123457e+17
99,17,123456789012345680 string 1.2345678901234568e+17
99,18,123456789012345680 string 123456789012345680
99,19,123456789012345680 string 123456789012345680.0
99,20,123456789012345680 string 123456789012345680.00
99,21,123456789012345680 string 123456789012345680.000
RangeError
100,n/a,1234567890123456800 string 1234567890123456800
RangeError
100,1,1234567890123456800 string 1e+18
100,2,1234567890123456800 string 1.2e+18
100,3,1234567890123456800 string 1.23e+18
100,4,1234567890123456800 string 1.235e+18
100,5,1234567890123456800 string 1.2346e+18
100,6,1234567890123456800 string 1.23457e+18
100,7,1234567890123456800 string 1.234568e+18
100,8,1234567890123456800 string 1.2345679e+18
100,9,1234567890123456800 string 1.23456789e+18
100,10,1234567890123456800 string 1.234567890e+18
100,11,1234567890123456800 string 1.2345678901e+18
100,12,1234567890123456800 string 1.23456789012e+18
100,13,1234567890123456800 string 1.234567890123e+18
100,14,1234567890123456800 string 1.2345678901235e+18
100,15,1234567890123456800 string 1.23456789012346e+18
100,16,1234567890123456800 string 1.234567890123457e+18
100,17,1234567890123456800 string 1.2345678901234568e+18
100,18,1234567890123456800 string 1.23456789012345677e+18
100,19,1234567890123456800 string 1234567890123456768
100,20,1234567890123456800 string 1234567890123456768.0
100,21,1234567890123456800 string 1234567890123456768.00
RangeError
101,n/a,12345678901234567000 string 12345678901234567000
RangeError
101,1,12345678901234567000 string 1e+19
101,2,12345678901234567000 string 1.2e+19
101,3,12345678901234567000 string 1.23e+19
101,4,12345678901234567000 string 1.235e+19
101,5,12345678901234567000 string 1.2346e+19
101,6,12345678901234567000 string 1.23457e+19
101,7,12345678901234567000 string 1.234568e+19
101,8,12345678901234567000 string 1.2345679e+19
101,9,12345678901234567000 string 1.23456789e+19
101,10,12345678901234567000 string 1.234567890e+19
101,11,12345678901234567000 string 1.2345678901e+19
101,12,12345678901234567000 string 1.23456789012e+19
101,13,12345678901234567000 string 1.234567890123e+19
101,14,12345678901234567000 string 1.2345678901235e+19
101,15,12345678901234567000 string 1.23456789012346e+19
101,16,12345678901234567000 string 1.234567890123457e+19
101,17,12345678901234567000 string 1.2345678901234567e+19
101,18,12345678901234567000 string 1.23456789012345672e+19
101,19,12345678901234567000 string 1.234567890123456717e+19
101,20,12345678901234567000 string 12345678901234567168
101,21,12345678901234567000 string 12345678901234567168.0
RangeError
102,n/a,123456789012345680000 string 123456789012345680000
RangeError
102,1,123456789012345680000 string 1e+20
102,2,123456789012345680000 string 1.2e+20
102,3,123456789012345680000 string 1.23e+20
102,4,123456789012345680000 string 1.235e+20
102,5,123456789012345680000 string 1.2346e+20
102,6,123456789012345680000 string 1.23457e+20
102,7,123456789012345680000 string 1.234568e+20
102,8,123456789012345680000 string 1.2345679e+20
102,9,123456789012345680000 string 1.23456789e+20
102,10,123456789012345680000 string 1.234567890e+20
102,11,123456789012345680000 string 1.2345678901e+20
102,12,123456789012345680000 string 1.23456789012e+20
102,13,123456789012345680000 string 1.234567890123e+20
102,14,123456789012345680000 string 1.2345678901235e+20
102,15,123456789012345680000 string 1.23456789012346e+20
102,16,123456789012345680000 string 1.234567890123457e+20
102,17,123456789012345680000 string 1.2345678901234568e+20
102,18,123456789012345680000 string 1.23456789012345684e+20
102,19,123456789012345680000 string 1.234567890123456840e+20
102,20,123456789012345680000 string 1.2345678901234568397e+20
102,21,123456789012345680000 string 123456789012345683968
RangeError
103,n/a,1.2345678901234568e+21 string 1.2345678901234568e+21
RangeError
103,1,1.2345678901234568e+21 string 1e+21
103,2,1.2345678901234568e+21 string 1.2e+21
103,3,1.2345678901234568e+21 string 1.23e+21
103,4,1.2345678901234568e+21 string 1.235e+21
103,5,1.2345678901234568e+21 string 1.2346e+21
103,6,1.2345678901234568e+21 string 1.23457e+21
103,7,1.2345678901234568e+21 string 1.234568e+21
103,8,1.2345678901234568e+21 string 1.2345679e+21
103,9,1.2345678901234568e+21 string 1.23456789e+21
103,10,1.2345678901234568e+21 string 1.234567890e+21
103,11,1.2345678901234568e+21 string 1.2345678901e+21
103,12,1.2345678901234568e+21 string 1.23456789012e+21
103,13,1.2345678901234568e+21 string 1.234567890123e+21
103,14,1.2345678901234568e+21 string 1.2345678901235e+21
103,15,1.2345678901234568e+21 string 1.23456789012346e+21
103,16,1.2345678901234568e+21 string 1.234567890123457e+21
103,17,1.2345678901234568e+21 string 1.2345678901234568e+21
103,18,1.2345678901234568e+21 string 1.23456789012345677e+21
103,19,1.2345678901234568e+21 string 1.234567890123456774e+21
103,20,1.2345678901234568e+21 string 1.2345678901234567741e+21
103,21,1.2345678901234568e+21 string 1.23456789012345677414e+21
RangeError
104,n/a,1.2345678901234568e+22 string 1.2345678901234568e+22
RangeError
104,1,1.2345678901234568e+22 string 1e+22
104,2,1.2345678901234568e+22 string 1.2e+22
104,3,1.2345678901234568e+22 string 1.23e+22
104,4,1.2345678901234568e+22 string 1.235e+22
104,5,1.2345678901234568e+22 string 1.2346e+22
104,6,1.2345678901234568e+22 string 1.23457e+22
104,7,1.2345678901234568e+22 string 1.234568e+22
104,8,1.2345678901234568e+22 string 1.2345679e+22
104,9,1.2345678901234568e+22 string 1.23456789e+22
104,10,1.2345678901234568e+22 string 1.234567890e+22
104,11,1.2345678901234568e+22 string 1.2345678901e+22
104,12,1.2345678901234568e+22 string 1.23456789012e+22
104,13,1.2345678901234568e+22 string 1.234567890123e+22
104,14,1.2345678901234568e+22 string 1.2345678901235e+22
104,15,1.2345678901234568e+22 string 1.23456789012346e+22
104,16,1.2345678901234568e+22 string 1.234567890123457e+22
104,17,1.2345678901234568e+22 string 1.2345678901234568e+22
104,18,1.2345678901234568e+22 string 1.23456789012345677e+22
104,19,1.2345678901234568e+22 string 1.234567890123456774e+22
104,20,1.2345678901234568e+22 string 1.2345678901234567741e+22
104,21,1.2345678901234568e+22 string 1.23456789012345677414e+22
RangeError
105,n/a,1.2345678901234569e+23 string 1.2345678901234569e+23
RangeError
105,1,1.2345678901234569e+23 string 1e+23
105,2,1.2345678901234569e+23 string 1.2e+23
105,3,1.2345678901234569e+23 string 1.23e+23
105,4,1.2345678901234569e+23 string 1.235e+23
105,5,1.2345678901234569e+23 string 1.2346e+23
105,6,1.2345678901234569e+23 string 1.23457e+23
105,7,1.2345678901234569e+23 string 1.234568e+23
105,8,1.2345678901234569e+23 string 1.2345679e+23
105,9,1.2345678901234569e+23 string 1.23456789e+23
105,10,1.2345678901234569e+23 string 1.234567890e+23
105,11,1.2345678901234569e+23 string 1.2345678901e+23
105,12,1.2345678901234569e+23 string 1.23456789012e+23
105,13,1.2345678901234569e+23 string 1.234567890123e+23
105,14,1.2345678901234569e+23 string 1.2345678901235e+23
105,15,1.2345678901234569e+23 string 1.23456789012346e+23
105,16,1.2345678901234569e+23 string 1.234567890123457e+23
105,17,1.2345678901234569e+23 string 1.2345678901234569e+23
105,18,1.2345678901234569e+23 string 1.23456789012345686e+23
105,19,1.2345678901234569e+23 string 1.234567890123456858e+23
105,20,1.2345678901234569e+23 string 1.2345678901234568580e+23
105,21,1.2345678901234569e+23 string 1.23456789012345685803e+23
RangeError
106,n/a,1.2345678901234568e+24 string 1.2345678901234568e+24
RangeError
106,1,1.2345678901234568e+24 string 1e+24
106,2,1.2345678901234568e+24 string 1.2e+24
106,3,1.2345678901234568e+24 string 1.23e+24
106,4,1.2345678901234568e+24 string 1.235e+24
106,5,1.2345678901234568e+24 string 1.2346e+24
106,6,1.2345678901234568e+24 string 1.23457e+24
106,7,1.2345678901234568e+24 string 1.234568e+24
106,8,1.2345678901234568e+24 string 1.2345679e+24
106,9,1.2345678901234568e+24 string 1.23456789e+24
106,10,1.2345678901234568e+24 string 1.234567890e+24
106,11,1.2345678901234568e+24 string 1.2345678901e+24
106,12,1.2345678901234568e+24 string 1.23456789012e+24
106,13,1.2345678901234568e+24 string 1.234567890123e+24
106,14,1.2345678901234568e+24 string 1.2345678901235e+24
106,15,1.2345678901234568e+24 string 1.23456789012346e+24
106,16,1.2345678901234568e+24 string 1.234567890123457e+24
106,17,1.2345678901234568e+24 string 1.2345678901234568e+24
106,18,1.2345678901234568e+24 string 1.23456789012345682e+24
106,19,1.2345678901234568e+24 string 1.234567890123456824e+24
106,20,1.2345678901234568e+24 string 1.2345678901234568245e+24
106,21,1.2345678901234568e+24 string 1.23456789012345682448e+24
RangeError
107,n/a,1.2345678901234568e+25 string 1.2345678901234568e+25
RangeError
107,1,1.2345678901234568e+25 string 1e+25
107,2,1.2345678901234568e+25 string 1.2e+25
107,3,1.2345678901234568e+25 string 1.23e+25
107,4,1.2345678901234568e+25 string 1.235e+25
107,5,1.2345678901234568e+25 string 1.2346e+25
107,6,1.2345678901234568e+25 string 1.23457e+25
107,7,1.2345678901234568e+25 string 1.234568e+25
107,8,1.2345678901234568e+25 string 1.2345679e+25
107,9,1.2345678901234568e+25 string 1.23456789e+25
107,10,1.2345678901234568e+25 string 1.234567890e+25
107,11,1.2345678901234568e+25 string 1.2345678901e+25
107,12,1.2345678901234568e+25 string 1.23456789012e+25
107,13,1.2345678901234568e+25 string 1.234567890123e+25
107,14,1.2345678901234568e+25 string 1.2345678901235e+25
107,15,1.2345678901234568e+25 string 1.23456789012346e+25
107,16,1.2345678901234568e+25 string 1.234567890123457e+25
107,17,1.2345678901234568e+25 string 1.2345678901234568e+25
107,18,1.2345678901234568e+25 string 1.23456789012345682e+25
107,19,1.2345678901234568e+25 string 1.234567890123456824e+25
107,20,1.2345678901234568e+25 string 1.2345678901234568245e+25
107,21,1.2345678901234568e+25 string 1.23456789012345682448e+25
RangeError
108,n/a,1.2345678901234569e+100 string 1.2345678901234569e+100
RangeError
108,1,1.2345678901234569e+100 string 1e+100
108,2,1.2345678901234569e+100 string 1.2e+100
108,3,1.2345678901234569e+100 string 1.23e+100
108,4,1.2345678901234569e+100 string 1.235e+100
108,5,1.2345678901234569e+100 string 1.2346e+100
108,6,1.2345678901234569e+100 string 1.23457e+100
108,7,1.2345678901234569e+100 string 1.234568e+100
108,8,1.2345678901234569e+100 string 1.2345679e+100
108,9,1.2345678901234569e+100 string 1.23456789e+100
108,10,1.2345678901234569e+100 string 1.234567890e+100
108,11,1.2345678901234569e+100 string 1.2345678901e+100
108,12,1.2345678901234569e+100 string 1.23456789012e+100
108,13,1.2345678901234569e+100 string 1.234567890123e+100
108,14,1.2345678901234569e+100 string 1.2345678901235e+100
108,15,1.2345678901234569e+100 string 1.23456789012346e+100
108,16,1.2345678901234569e+100 string 1.234567890123457e+100
108,17,1.2345678901234569e+100 string 1.2345678901234569e+100
108,18,1.2345678901234569e+100 string 1.23456789012345686e+100
108,19,1.2345678901234569e+100 string 1.234567890123456864e+100
108,20,1.2345678901234569e+100 string 1.2345678901234568638e+100
108,21,1.2345678901234569e+100 string 1.23456789012345686377e+100
RangeError
109,n/a,Infinity string Infinity
109,0,Infinity string Infinity
109,1,Infinity string Infinity
109,2,Infinity string Infinity
109,3,Infinity string Infinity
109,4,Infinity string Infinity
109,5,Infinity string Infinity
109,6,Infinity string Infinity
109,7,Infinity string Infinity
109,8,Infinity string Infinity
109,9,Infinity string Infinity
109,10,Infinity string Infinity
109,11,Infinity string Infinity
109,12,Infinity string Infinity
109,13,Infinity string Infinity
109,14,Infinity string Infinity
109,15,Infinity string Infinity
109,16,Infinity string Infinity
109,17,Infinity string Infinity
109,18,Infinity string Infinity
109,19,Infinity string Infinity
109,20,Infinity string Infinity
109,21,Infinity string Infinity
109,22,Infinity string Infinity
110,n/a,undefined string NaN
110,0,undefined string NaN
110,1,undefined string NaN
110,2,undefined string NaN
110,3,undefined string NaN
110,4,undefined string NaN
110,5,undefined string NaN
110,6,undefined string NaN
110,7,undefined string NaN
110,8,undefined string NaN
110,9,undefined string NaN
110,10,undefined string NaN
110,11,undefined string NaN
110,12,undefined string NaN
110,13,undefined string NaN
110,14,undefined string NaN
110,15,undefined string NaN
110,16,undefined string NaN
110,17,undefined string NaN
110,18,undefined string NaN
110,19,undefined string NaN
110,20,undefined string NaN
110,21,undefined string NaN
110,22,undefined string NaN
===*/

print('basic');

function basicTest() {
    var values = [];
    var i, t;
    var prec;

    values.push(Number.NEGATIVE_INFINITY);

    t = '-1.23456789012345678901234567890';
    values.push(Number(t + 'e100'));
    for (i = 25; i >= -25; i--) {
        values.push(Number(t + 'e' + i));
    }
    values.push(Number(t + 'e-100'));

    values.push(-0);
    values.push(+0);

    t = '1.23456789012345678901234567890';
    values.push(Number(t + 'e-100'));
    for (i = -25; i <= 25; i++) {
        values.push(Number(t + 'e' + i));
    }
    values.push(Number(t + 'e100'));

    values.push(Number.POSITIVE_INFINITY);
    values.push(Number.NAN);

    for (i = 0; i < values.length; i++) {
        test(new Number(values[i]), [], i + ',' + 'n/a' + ',' + values[i]);
        for (prec = 0; prec <= 22; prec++) {  // 0 and 22 are out of bounds
            test(new Number(values[i]), [ prec ], i + ',' + prec + ',' + values[i]);
        }
    }
}

try {
    basicTest();
} catch (e) {
    print(e);
}

/*===
coercion
string 12345
string 12345
prec_invalid valueOf
string NaN
prec_invalid valueOf
string Infinity
prec_invalid valueOf
string -Infinity
prec valueOf
RangeError
prec valueOf
RangeError
prec valueOf
string 1e+2
prec valueOf
string 1.2e+2
prec valueOf
string 123.00000000000000000
prec valueOf
string 123.000000000000000000
prec valueOf
RangeError
prec valueOf
RangeError
===*/

/* toPrecision() coercion order is quite awkward:
 *
 *  - An undefined precision shortcuts to toString() without any
 *    other checks being made
 *
 *  - ToInteger(precision) is applied without range check (but with
 *    side effects)
 *
 *  - Special cases for NaN and +/- Infinity are applied
 *
 *  - Only at this point is precision checked to be in range [1,21]
 */

print('coercion');

function coercionTest() {
    function makePrec(name, v1, v2) {
        return {
            toString: function() { print(name + ' toString'); return v1; },
            valueOf: function() { print(name + ' valueOf'); return v2; }
        };
    }

    var prec_invalid = makePrec('prec_invalid', 200, 100);

    // if precision is undefined (or not given), same as ToString

    test(new Number(12345), []);
    test(new Number(12345), [ undefined ]);

    // if precision is given, it is ToInteger() coerced (with side
    // effects) but not range checked for NaN and +/- Infinity

    test(new Number(NaN), [ prec_invalid ]);
    test(new Number(Number.POSITIVE_INFINITY), [ prec_invalid ]);
    test(new Number(Number.NEGATIVE_INFINITY), [ prec_invalid ]);

    // if precision is given, it is ToInteger() coerced, and if number
    // is not NaN or +/- Infinity, it is range checked to [1,21]

    test(new Number(123), [ makePrec('prec', 100, -256*256*256*256 + 0) ]);
    test(new Number(123), [ makePrec('prec', 100, 0) ]);
    test(new Number(123), [ makePrec('prec', 100, 1) ]);
    test(new Number(123), [ makePrec('prec', 100, 2) ]);
    test(new Number(123), [ makePrec('prec', 100, 20) ]);
    test(new Number(123), [ makePrec('prec', 100, 21) ]);
    test(new Number(123), [ makePrec('prec', 100, 22) ]);
    test(new Number(123), [ makePrec('prec', 100, 256*256*256*256 + 0) ]);
}

try {
    coercionTest();
} catch (e) {
    print(e);
}
