/* panel.c generated by valac 0.22.0, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2013 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>
#include <glib/gi18n-lib.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;

#define PANEL_TYPE_KEYBINDING (panel_keybinding_get_type ())
#define PANEL_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANEL_TYPE_KEYBINDING, PanelKeybinding))
#define PANEL_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))
#define PANEL_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANEL_TYPE_KEYBINDING))
#define PANEL_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANEL_TYPE_KEYBINDING))
#define PANEL_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))

typedef struct _PanelKeybinding PanelKeybinding;
typedef struct _PanelKeybindingClass PanelKeybindingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define __g_list_free__panel_keybinding_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__panel_keybinding_unref0_ (var), NULL)))

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _panel_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _PanelKeybindingPrivate PanelKeybindingPrivate;
typedef struct _PanelParamSpecKeybinding PanelParamSpecKeybinding;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelPrivate {
	IBusBus* m_bus;
	GSettings* m_settings_general;
	GSettings* m_settings_hotkey;
	GSettings* m_settings_panel;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	GHashTable* m_engine_contexts;
	gchar* m_current_context_path;
	gboolean m_use_global_engine;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	gboolean m_switcher_is_running;
	PropertyManager* m_property_manager;
	PropertyPanel* m_property_panel;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	gboolean m_use_system_keyboard_layout;
	GList* m_keybindings;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _Block4Data {
	int _ref_count_;
	Panel * self;
	IBusEngineDesc* e;
};

struct _PanelKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PanelKeybindingPrivate * priv;
};

struct _PanelKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (PanelKeybinding *self);
};

struct _PanelKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	gboolean _reverse;
};

struct _PanelParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer panel_parent_class = NULL;
static gpointer panel_keybinding_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_manager (GValue* value, gpointer v_object);
void value_take_property_manager (GValue* value, gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
GType property_panel_get_type (void) G_GNUC_CONST;
static gpointer panel_keybinding_ref (gpointer instance);
static void panel_keybinding_unref (gpointer instance);
static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void panel_value_set_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void panel_value_take_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer panel_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType panel_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
enum  {
	PANEL_DUMMY_PROPERTY
};
static void panel_unbind_switch_shortcut (Panel* self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _panel_keybinding_unref0_ (gpointer var);
static void _g_list_free__panel_keybinding_unref0_ (GList* self);
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type, IBusBus* bus);
static void panel_init_settings (Panel* self);
static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon);
static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda43_ (Panel* self, CandidatePanel* w);
static void ___lambda43__candidate_panel_page_up (CandidatePanel* _sender, gpointer self);
static void __lambda44_ (Panel* self, CandidatePanel* w);
static void ___lambda44__candidate_panel_page_down (CandidatePanel* _sender, gpointer self);
static void __lambda45_ (Panel* self, CandidatePanel* w, guint i, guint b, guint s);
static void ___lambda45__candidate_panel_candidate_clicked (CandidatePanel* _sender, guint index, guint button, guint state, gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
static void panel_bind_switch_shortcut (Panel* self);
void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda46_ (Panel* self, PropertyManager* w, const gchar* k, gint s);
static void ___lambda46__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self);
PropertyPanel* property_panel_new (void);
PropertyPanel* property_panel_construct (GType object_type);
static void __lambda47_ (Panel* self, PropertyPanel* w, const gchar* k, gint s);
static void ___lambda47__property_panel_property_activate (PropertyPanel* _sender, const gchar* key, gint state, gpointer self);
static void __lambda23_ (Panel* self, const gchar* key);
static void panel_update_engines (Panel* self, gchar** unowned_engine_names, int unowned_engine_names_length1, gchar** order_names, int order_names_length1);
static void ___lambda23__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda24_ (Panel* self, const gchar* key);
static void panel_set_switcher_delay_time (Panel* self);
static void ___lambda24__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda25_ (Panel* self, const gchar* key);
static void panel_set_use_system_keyboard_layout (Panel* self);
static void ___lambda25__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda26_ (Panel* self, const gchar* key);
static void panel_set_embed_preedit_text (Panel* self);
static void ___lambda26__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda27_ (Panel* self, const gchar* key);
static void panel_set_use_global_engine (Panel* self);
static void ___lambda27__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda28_ (Panel* self, const gchar* key);
static void ___lambda28__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda31_ (Panel* self, const gchar* key);
static void panel_set_custom_font (Panel* self);
static void ___lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda32_ (Panel* self, const gchar* key);
static void ___lambda32__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda33_ (Panel* self, const gchar* key);
static void panel_set_show_icon_on_systray (Panel* self);
static void ___lambda33__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda34_ (Panel* self, const gchar* key);
static void panel_set_lookup_table_orientation (Panel* self);
static void ___lambda34__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda35_ (Panel* self, const gchar* key);
static void panel_set_show_property_panel (Panel* self);
static void ___lambda35__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda36_ (Panel* self, const gchar* key);
static void panel_set_timeout_property_panel (Panel* self);
static void ___lambda36__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator);
static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse);
static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse);
gboolean keybinding_manager_bind (KeybindingManager* self, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static void __lambda29_ (Panel* self, GdkEvent* e);
static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert);
static void ___lambda29__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void __lambda30_ (Panel* self, GdkEvent* e);
static void ___lambda30__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
KeybindingManager* keybinding_manager_get_instance (void);
void keybinding_manager_unbind (KeybindingManager* self, guint keysym, GdkModifierType modifiers);
static guint panel_keybinding_get_keysym (PanelKeybinding* self);
static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self);
void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical);
void property_panel_set_show (PropertyPanel* self, gint _show);
void property_panel_set_auto_hide_timeout (PropertyPanel* self, guint timeout);
static gint panel_compare_versions (Panel* self, const gchar* version1, const gchar* version2);
static void panel_update_version_1_5_3 (Panel* self);
static void panel_set_version (Panel* self);
void panel_load_settings (Panel* self);
static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value);
static void panel_engine_contexts_insert (Panel* self, IBusEngineDesc* engine);
static void panel_set_engine (Panel* self, IBusEngineDesc* engine);
static void panel_switch_engine (Panel* self, gint i, gboolean force);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index);
static void panel_run_preload_engines (Panel* self, IBusEngineDesc** engines, int engines_length1, gint index);
static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length);
static void panel_show_setup_dialog (Panel* self);
static void __lambda38_ (Panel* self, GPid pid, gint state);
static void ___lambda38__gchild_watch_func (GPid pid, gint status, gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda37_ (Panel* self, GtkMenuItem* i);
static void ____lambda37__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda39_ (Panel* self, GtkMenuItem* i);
static void ____lambda39__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda40_ (Panel* self, GtkMenuItem* i);
static void ____lambda40__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda41_ (Panel* self, GtkMenuItem* i);
static void ____lambda41__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
gint property_manager_create_menu_items (PropertyManager* self, GtkMenu* menu);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);
static void ____lambda42_ (Block4Data* _data4_, GtkMenuItem* item);
static void _____lambda42__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
void property_panel_set_cursor_location (PropertyPanel* self, gint x, gint y, gint width, gint height);
static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
void property_panel_focus_in (PropertyPanel* self);
static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_destroy_context (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props);
void property_manager_set_properties (PropertyManager* self, IBusPropList* props);
void property_panel_set_properties (PropertyPanel* self, IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop);
void property_manager_update_property (PropertyManager* self, IBusProperty* prop);
void property_panel_update_property (PropertyPanel* self, IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
void property_panel_set_preedit_text (PropertyPanel* self, IBusText* text, guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
void property_panel_set_auxiliary_text (PropertyPanel* self, IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
void property_panel_set_lookup_table (PropertyPanel* self, IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_state_changed (IBusPanelService* base);
static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value);
#define PANEL_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PANEL_TYPE_KEYBINDING, PanelKeybindingPrivate))
enum  {
	PANEL_KEYBINDING_DUMMY_PROPERTY
};
static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value);
static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value);
static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value);
static gboolean panel_keybinding_get_reverse (PanelKeybinding* self);
static void panel_keybinding_finalize (PanelKeybinding* obj);
static void panel_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _panel_keybinding_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL));
}


static void _g_list_free__panel_keybinding_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _panel_keybinding_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	panel_status_icon_popup_menu_cb (self, _sender, button, activate_time);
}


static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	panel_status_icon_activate_cb (self, _sender);
}


static void __lambda43_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void ___lambda43__candidate_panel_page_up (CandidatePanel* _sender, gpointer self) {
	__lambda43_ (self, _sender);
}


static void __lambda44_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void ___lambda44__candidate_panel_page_down (CandidatePanel* _sender, gpointer self) {
	__lambda44_ (self, _sender);
}


static void __lambda45_ (Panel* self, CandidatePanel* w, guint i, guint b, guint s) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (w != NULL);
	_tmp0_ = i;
	_tmp1_ = b;
	_tmp2_ = s;
	ibus_panel_service_candidate_clicked ((IBusPanelService*) self, _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda45__candidate_panel_candidate_clicked (CandidatePanel* _sender, guint index, guint button, guint state, gpointer self) {
	__lambda45_ (self, _sender, index, button, state);
}


static void __lambda46_ (Panel* self, PropertyManager* w, const gchar* k, gint s) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda46__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self) {
	__lambda46_ (self, _sender, key, state);
}


static void __lambda47_ (Panel* self, PropertyPanel* w, const gchar* k, gint s) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda47__property_panel_property_activate (PropertyPanel* _sender, const gchar* key, gint state, gpointer self) {
	__lambda47_ (self, _sender, key, state);
}


Panel* panel_construct (GType object_type, IBusBus* bus) {
	Panel * self = NULL;
	IBusBus* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	IBusBus* _tmp2_ = NULL;
	GDBusConnection* _tmp3_ = NULL;
	IBusBus* _tmp4_ = NULL;
	IBusBus* _tmp5_ = NULL;
	GtkStatusIcon* _tmp6_ = NULL;
	GtkStatusIcon* _tmp7_ = NULL;
	GtkStatusIcon* _tmp8_ = NULL;
	GtkStatusIcon* _tmp9_ = NULL;
	GtkStatusIcon* _tmp10_ = NULL;
	GtkStatusIcon* _tmp11_ = NULL;
	CandidatePanel* _tmp12_ = NULL;
	CandidatePanel* _tmp13_ = NULL;
	CandidatePanel* _tmp14_ = NULL;
	CandidatePanel* _tmp15_ = NULL;
	Switcher* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	PropertyManager* _tmp20_ = NULL;
	PropertyManager* _tmp21_ = NULL;
	PropertyPanel* _tmp22_ = NULL;
	PropertyPanel* _tmp23_ = NULL;
	g_return_val_if_fail (bus != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (Panel*) g_object_new (object_type, "connection", _tmp3_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	panel_init_settings (self);
	_tmp6_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp6_;
	_tmp7_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp7_, "ibus-ui-gtk");
	_tmp8_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp8_, "IBus Panel");
	_tmp9_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp9_, "popup-menu", (GCallback) _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu, self, 0);
	_tmp10_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _panel_status_icon_activate_cb_gtk_status_icon_activate, self, 0);
	_tmp11_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp11_, "ibus-keyboard");
	_tmp12_ = candidate_panel_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp12_;
	_tmp13_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp13_, "page-up", (GCallback) ___lambda43__candidate_panel_page_up, self, 0);
	_tmp14_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp14_, "page-down", (GCallback) ___lambda44__candidate_panel_page_down, self, 0);
	_tmp15_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp15_, "candidate-clicked", (GCallback) ___lambda45__candidate_panel_candidate_clicked, self, 0);
	_tmp16_ = switcher_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp16_;
	panel_bind_switch_shortcut (self);
	_tmp17_ = self->priv->m_switcher_delay_time;
	if (_tmp17_ >= 0) {
		Switcher* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp18_ = self->priv->m_switcher;
		_tmp19_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp18_, (guint) _tmp19_);
	}
	_tmp20_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp20_;
	_tmp21_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp21_, "property-activate", (GCallback) ___lambda46__property_manager_property_activate, self, 0);
	_tmp22_ = property_panel_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->m_property_panel);
	self->priv->m_property_panel = _tmp22_;
	_tmp23_ = self->priv->m_property_panel;
	g_signal_connect_object (_tmp23_, "property-activate", (GCallback) ___lambda47__property_panel_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel* panel_new (IBusBus* bus) {
	return panel_construct (TYPE_PANEL, bus);
}


static void __lambda23_ (Panel* self, const gchar* key) {
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = key;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp0_, _tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	panel_update_engines (self, _tmp4_, _vala_array_length (_tmp2_), NULL, 0);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}


static void ___lambda23__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda23_ (self, key);
}


static void __lambda24_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_switcher_delay_time (self);
}


static void ___lambda24__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda24_ (self, key);
}


static void __lambda25_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_use_system_keyboard_layout (self);
}


static void ___lambda25__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda25_ (self, key);
}


static void __lambda26_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_embed_preedit_text (self);
}


static void ___lambda26__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda26_ (self, key);
}


static void __lambda27_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_use_global_engine (self);
}


static void ___lambda27__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda27_ (self, key);
}


static void __lambda28_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_unbind_switch_shortcut (self);
	panel_bind_switch_shortcut (self);
}


static void ___lambda28__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda28_ (self, key);
}


static void __lambda31_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_custom_font (self);
}


static void ___lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda31_ (self, key);
}


static void __lambda32_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_custom_font (self);
}


static void ___lambda32__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda32_ (self, key);
}


static void __lambda33_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_show_icon_on_systray (self);
}


static void ___lambda33__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda33_ (self, key);
}


static void __lambda34_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_lookup_table_orientation (self);
}


static void ___lambda34__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda34_ (self, key);
}


static void __lambda35_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_show_property_panel (self);
}


static void ___lambda35__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda35_ (self, key);
}


static void __lambda36_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_timeout_property_panel (self);
}


static void ___lambda36__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda36_ (self, key);
}


static void panel_init_settings (Panel* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.general");
	_g_object_unref0 (self->priv->m_settings_general);
	self->priv->m_settings_general = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.general.hotkey");
	_g_object_unref0 (self->priv->m_settings_hotkey);
	self->priv->m_settings_hotkey = _tmp1_;
	_tmp2_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp2_;
	_tmp3_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp3_, "changed::preload-engines", (GCallback) ___lambda23__g_settings_changed, self, 0);
	_tmp4_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp4_, "changed::switcher-delay-time", (GCallback) ___lambda24__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp5_, "changed::use-system-keyboard-layout", (GCallback) ___lambda25__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp6_, "changed::embed-preedit-text", (GCallback) ___lambda26__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp7_, "changed::use-global-engine", (GCallback) ___lambda27__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_hotkey;
	g_signal_connect_object (_tmp8_, "changed::triggers", (GCallback) ___lambda28__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp9_, "changed::custom-font", (GCallback) ___lambda31__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp10_, "changed::use-custom-font", (GCallback) ___lambda32__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp11_, "changed::show-icon-on-systray", (GCallback) ___lambda33__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp12_, "changed::lookup-table-orientation", (GCallback) ___lambda34__g_settings_changed, self, 0);
	_tmp13_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp13_, "changed::show", (GCallback) ___lambda35__g_settings_changed, self, 0);
	_tmp14_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp14_, "changed::timeout", (GCallback) ___lambda36__g_settings_changed, self, 0);
}


static gpointer _panel_keybinding_ref0 (gpointer self) {
	return self ? panel_keybinding_ref (self) : NULL;
}


static void __lambda29_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_ = NULL;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, FALSE);
}


static void ___lambda29__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda29_ (self, event);
}


static void __lambda30_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_ = NULL;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, TRUE);
}


static void ___lambda30__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda30_ (self, event);
}


static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator) {
	guint switch_keysym = 0U;
	GdkModifierType switch_modifiers = 0;
	GdkModifierType reverse_modifier = 0;
	PanelKeybinding* keybinding = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GdkModifierType _tmp2_ = 0;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	GdkModifierType _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	guint _tmp7_ = 0U;
	gboolean _tmp9_ = FALSE;
	guint _tmp11_ = 0U;
	GdkModifierType _tmp12_ = 0;
	PanelKeybinding* _tmp13_ = NULL;
	PanelKeybinding* _tmp14_ = NULL;
	PanelKeybinding* _tmp15_ = NULL;
	KeybindingManager* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GdkModifierType _tmp18_ = 0;
	GdkModifierType _tmp19_ = 0;
	GdkModifierType _tmp20_ = 0;
	GdkModifierType _tmp21_ = 0;
	GdkModifierType _tmp22_ = 0;
	guint _tmp23_ = 0U;
	GdkModifierType _tmp24_ = 0;
	PanelKeybinding* _tmp25_ = NULL;
	PanelKeybinding* _tmp26_ = NULL;
	PanelKeybinding* _tmp27_ = NULL;
	KeybindingManager* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	GdkModifierType _tmp30_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keybinding_manager != NULL);
	switch_keysym = (guint) 0;
	switch_modifiers = 0;
	reverse_modifier = GDK_SHIFT_MASK;
	_tmp0_ = accelerator;
	gtk_accelerator_parse (_tmp0_, &_tmp1_, &_tmp2_);
	switch_keysym = _tmp1_;
	switch_modifiers = _tmp2_;
	_tmp3_ = switch_modifiers;
	if ((_tmp3_ & VIRTUAL_MODIFIERS) != 0) {
		GdkKeymap* _tmp4_ = NULL;
		GdkModifierType _tmp5_ = 0;
		_tmp4_ = gdk_keymap_get_default ();
		gdk_keymap_map_virtual_modifiers (_tmp4_, &switch_modifiers);
		_tmp5_ = switch_modifiers;
		switch_modifiers = _tmp5_ & (~VIRTUAL_MODIFIERS);
	}
	_tmp7_ = switch_keysym;
	if (_tmp7_ == ((guint) 0)) {
		GdkModifierType _tmp8_ = 0;
		_tmp8_ = switch_modifiers;
		_tmp6_ = _tmp8_ == 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = accelerator;
		g_warning ("panel.vala:202: Parse accelerator '%s' failed!", _tmp10_);
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp11_ = switch_keysym;
	_tmp12_ = switch_modifiers;
	_tmp13_ = panel_keybinding_new (_tmp11_, _tmp12_, FALSE);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp13_;
	_tmp14_ = keybinding;
	_tmp15_ = _panel_keybinding_ref0 (_tmp14_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp15_);
	_tmp16_ = keybinding_manager;
	_tmp17_ = switch_keysym;
	_tmp18_ = switch_modifiers;
	keybinding_manager_bind (_tmp16_, _tmp17_, _tmp18_, ___lambda29__keybinding_manager_keybinding_handler_func, self);
	_tmp19_ = switch_modifiers;
	_tmp20_ = reverse_modifier;
	if ((_tmp19_ & _tmp20_) != 0) {
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp21_ = switch_modifiers;
	_tmp22_ = reverse_modifier;
	switch_modifiers = _tmp21_ | _tmp22_;
	_tmp23_ = switch_keysym;
	_tmp24_ = switch_modifiers;
	_tmp25_ = panel_keybinding_new (_tmp23_, _tmp24_, TRUE);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp25_;
	_tmp26_ = keybinding;
	_tmp27_ = _panel_keybinding_ref0 (_tmp26_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp27_);
	_tmp28_ = keybinding_manager;
	_tmp29_ = switch_keysym;
	_tmp30_ = switch_modifiers;
	keybinding_manager_bind (_tmp28_, _tmp29_, _tmp30_, ___lambda30__keybinding_manager_keybinding_handler_func, self);
	_panel_keybinding_unref0 (keybinding);
}


static void panel_bind_switch_shortcut (Panel* self) {
	gchar** accelerators = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint accelerators_length1 = 0;
	gint _accelerators_size_ = 0;
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_hotkey;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "triggers");
	accelerators = _tmp2_;
	accelerators_length1 = _vala_array_length (_tmp1_);
	_accelerators_size_ = accelerators_length1;
	_tmp3_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp3_;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < _tmp4__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				KeybindingManager* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp6_ = keybinding_manager;
				_tmp7_ = accelerator;
				panel_keybinding_manager_bind (self, _tmp6_, _tmp7_);
				_g_free0 (accelerator);
			}
		}
	}
	_g_object_unref0 (keybinding_manager);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}


static void panel_unbind_switch_shortcut (Panel* self) {
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp0_ = NULL;
	GList* keybindings = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp1_ = self->priv->m_keybindings;
	keybindings = _tmp1_;
	while (TRUE) {
		GList* _tmp2_ = NULL;
		PanelKeybinding* keybinding = NULL;
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		PanelKeybinding* _tmp5_ = NULL;
		KeybindingManager* _tmp6_ = NULL;
		PanelKeybinding* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		PanelKeybinding* _tmp10_ = NULL;
		GdkModifierType _tmp11_ = 0;
		GdkModifierType _tmp12_ = 0;
		GList* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		_tmp2_ = keybindings;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = keybindings;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _panel_keybinding_ref0 ((PanelKeybinding*) _tmp4_);
		keybinding = _tmp5_;
		_tmp6_ = keybinding_manager;
		_tmp7_ = keybinding;
		_tmp8_ = panel_keybinding_get_keysym (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = keybinding;
		_tmp11_ = panel_keybinding_get_modifiers (_tmp10_);
		_tmp12_ = _tmp11_;
		keybinding_manager_unbind (_tmp6_, _tmp9_, _tmp12_);
		_tmp13_ = keybindings;
		_tmp14_ = _tmp13_->next;
		keybindings = _tmp14_;
		_panel_keybinding_unref0 (keybinding);
	}
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	self->priv->m_keybindings = NULL;
	_g_object_unref0 (keybinding_manager);
}


static void panel_set_custom_font (Panel* self) {
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_ = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp6_ = NULL;
	GdkScreen* _tmp7_ = NULL;
	GdkScreen* _tmp8_ = NULL;
	gboolean use_custom_font = FALSE;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkCssProvider* _tmp11_ = NULL;
	gboolean _tmp14_ = FALSE;
	gchar* font_name = NULL;
	GSettings* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* data_format = NULL;
	gchar* _tmp18_ = NULL;
	gchar* data = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkCssProvider* _tmp22_ = NULL;
	GdkScreen* _tmp28_ = NULL;
	GtkCssProvider* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_ = NULL;
		GdkScreen* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _tmp2_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = screen;
	if (_tmp8_ == NULL) {
		g_warning ("panel.vala:262: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp9_ = self->priv->m_settings_panel;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "use-custom-font");
	use_custom_font = _tmp10_;
	_tmp11_ = self->priv->m_css_provider;
	if (_tmp11_ != NULL) {
		GdkScreen* _tmp12_ = NULL;
		GtkCssProvider* _tmp13_ = NULL;
		_tmp12_ = screen;
		_tmp13_ = self->priv->m_css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp12_, (GtkStyleProvider*) _tmp13_);
		_g_object_unref0 (self->priv->m_css_provider);
		self->priv->m_css_provider = NULL;
	}
	_tmp14_ = use_custom_font;
	if (_tmp14_ == FALSE) {
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp15_ = self->priv->m_settings_panel;
	_tmp16_ = g_settings_get_string (_tmp15_, "custom-font");
	font_name = _tmp16_;
	_tmp17_ = font_name;
	if (_tmp17_ == NULL) {
		g_warning ("panel.vala:281: No config panel:custom-font.");
		_g_free0 (font_name);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp18_ = g_strdup ("GtkLabel { font: %s; }");
	data_format = _tmp18_;
	_tmp19_ = data_format;
	_tmp20_ = font_name;
	_tmp21_ = g_strdup_printf (_tmp19_, _tmp20_);
	data = _tmp21_;
	_tmp22_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->m_css_provider);
	self->priv->m_css_provider = _tmp22_;
	{
		GtkCssProvider* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = self->priv->m_css_provider;
		_tmp24_ = data;
		gtk_css_provider_load_from_data (_tmp23_, _tmp24_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = font_name;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("panel.vala:292: Failed css_provider_from_data: %s: %s", _tmp25_, _tmp27_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (data_format);
		_g_free0 (font_name);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (data_format);
		_g_free0 (font_name);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp28_ = screen;
	_tmp29_ = self->priv->m_css_provider;
	gtk_style_context_add_provider_for_screen (_tmp28_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (data_format);
	_g_free0 (font_name);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void panel_set_switcher_delay_time (Panel* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	Switcher* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_int (_tmp0_, "switcher-delay-time");
	self->priv->m_switcher_delay_time = _tmp1_;
	_tmp3_ = self->priv->m_switcher;
	if (_tmp3_ != NULL) {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->m_switcher_delay_time;
		_tmp2_ = _tmp4_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		Switcher* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = self->priv->m_switcher;
		_tmp7_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp6_, (guint) _tmp7_);
	}
}


static void panel_set_use_system_keyboard_layout (Panel* self) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-system-keyboard-layout");
	self->priv->m_use_system_keyboard_layout = _tmp1_;
}


static void panel_set_embed_preedit_text (Panel* self) {
	GVariant* variant = NULL;
	GSettings* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	IBusBus* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_value (_tmp0_, "embed-preedit-text");
	variant = _tmp1_;
	_tmp2_ = variant;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (variant);
		return;
	}
	_tmp3_ = self->priv->m_bus;
	_tmp4_ = variant;
	ibus_bus_set_ibus_property (_tmp3_, "EmbedPreeditText", _tmp4_);
	_g_variant_unref0 (variant);
}


static void panel_set_use_global_engine (Panel* self) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-global-engine");
	self->priv->m_use_global_engine = _tmp1_;
}


static void panel_set_show_icon_on_systray (Panel* self) {
	GtkStatusIcon* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_status_icon;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_status_icon;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "show-icon-on-systray");
	gtk_status_icon_set_visible (_tmp1_, _tmp3_);
}


static void panel_set_lookup_table_orientation (Panel* self) {
	CandidatePanel* _tmp0_ = NULL;
	CandidatePanel* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "lookup-table-orientation");
	candidate_panel_set_vertical (_tmp1_, _tmp3_ == ((gint) IBUS_ORIENTATION_VERTICAL));
}


static void panel_set_show_property_panel (Panel* self) {
	PropertyPanel* _tmp0_ = NULL;
	PropertyPanel* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "show");
	property_panel_set_show (_tmp1_, _tmp3_);
}


static void panel_set_timeout_property_panel (Panel* self) {
	PropertyPanel* _tmp0_ = NULL;
	PropertyPanel* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "auto-hide-timeout");
	property_panel_set_auto_hide_timeout (_tmp1_, (guint) _tmp3_);
}


static gint panel_compare_versions (Panel* self, const gchar* version1, const gchar* version2) {
	gint result = 0;
	gchar** version1_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint version1_list_length1 = 0;
	gint _version1_list_size_ = 0;
	gchar** version2_list = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint version2_list_length1 = 0;
	gint _version2_list_size_ = 0;
	gint major1 = 0;
	gint minor1 = 0;
	gint micro1 = 0;
	gint major2 = 0;
	gint minor2 = 0;
	gint micro2 = 0;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	const gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp61_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (version1 != NULL, 0);
	g_return_val_if_fail (version2 != NULL, 0);
	_tmp0_ = version1;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	version1_list = _tmp2_;
	version1_list_length1 = _vala_array_length (_tmp1_);
	_version1_list_size_ = version1_list_length1;
	_tmp3_ = version2;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ".", 0);
	version2_list = _tmp5_;
	version2_list_length1 = _vala_array_length (_tmp4_);
	_version2_list_size_ = version2_list_length1;
	_tmp6_ = version1;
	_tmp7_ = version2;
	if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = version1;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		result = -1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp9_ = version2;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp10_ = version1_list;
	_tmp10__length1 = version1_list_length1;
	_vala_assert (_tmp10__length1 >= 3, "version1_list.length >= 3");
	_tmp11_ = version2_list;
	_tmp11__length1 = version2_list_length1;
	_vala_assert (_tmp11__length1 >= 3, "version2_list.length >= 3");
	_tmp12_ = version1_list;
	_tmp12__length1 = version1_list_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = atoi (_tmp13_);
	major1 = _tmp14_;
	_tmp15_ = version1_list;
	_tmp15__length1 = version1_list_length1;
	_tmp16_ = _tmp15_[1];
	_tmp17_ = atoi (_tmp16_);
	minor1 = _tmp17_;
	_tmp18_ = version1_list;
	_tmp18__length1 = version1_list_length1;
	_tmp19_ = _tmp18_[2];
	_tmp20_ = atoi (_tmp19_);
	micro1 = _tmp20_;
	_tmp21_ = version2_list;
	_tmp21__length1 = version2_list_length1;
	_tmp22_ = _tmp21_[0];
	_tmp23_ = atoi (_tmp22_);
	major2 = _tmp23_;
	_tmp24_ = version2_list;
	_tmp24__length1 = version2_list_length1;
	_tmp25_ = _tmp24_[1];
	_tmp26_ = atoi (_tmp25_);
	minor2 = _tmp26_;
	_tmp27_ = version2_list;
	_tmp27__length1 = version2_list_length1;
	_tmp28_ = _tmp27_[2];
	_tmp29_ = atoi (_tmp28_);
	micro2 = _tmp29_;
	_tmp32_ = major1;
	_tmp33_ = minor1;
	if (_tmp32_ == _tmp33_) {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		_tmp34_ = minor1;
		_tmp35_ = minor2;
		_tmp31_ = _tmp34_ == _tmp35_;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp36_ = _tmp31_;
	if (_tmp36_) {
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		_tmp37_ = micro1;
		_tmp38_ = micro2;
		_tmp30_ = _tmp37_ == _tmp38_;
	} else {
		_tmp30_ = FALSE;
	}
	_tmp39_ = _tmp30_;
	if (_tmp39_) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp42_ = major1;
	_tmp43_ = major2;
	if (_tmp42_ > _tmp43_) {
		_tmp41_ = TRUE;
	} else {
		gboolean _tmp44_ = FALSE;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		gboolean _tmp49_ = FALSE;
		_tmp45_ = major1;
		_tmp46_ = major2;
		if (_tmp45_ == _tmp46_) {
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			_tmp47_ = minor1;
			_tmp48_ = minor2;
			_tmp44_ = _tmp47_ > _tmp48_;
		} else {
			_tmp44_ = FALSE;
		}
		_tmp49_ = _tmp44_;
		_tmp41_ = _tmp49_;
	}
	_tmp50_ = _tmp41_;
	if (_tmp50_) {
		_tmp40_ = TRUE;
	} else {
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp60_ = FALSE;
		_tmp53_ = major1;
		_tmp54_ = major2;
		if (_tmp53_ == _tmp54_) {
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			_tmp55_ = minor1;
			_tmp56_ = minor2;
			_tmp52_ = _tmp55_ == _tmp56_;
		} else {
			_tmp52_ = FALSE;
		}
		_tmp57_ = _tmp52_;
		if (_tmp57_) {
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			_tmp58_ = micro1;
			_tmp59_ = micro2;
			_tmp51_ = _tmp58_ > _tmp59_;
		} else {
			_tmp51_ = FALSE;
		}
		_tmp60_ = _tmp51_;
		_tmp40_ = _tmp60_;
	}
	_tmp61_ = _tmp40_;
	if (_tmp61_) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = -1;
	version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
	version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void panel_update_version_1_5_3 (Panel* self) {
	gboolean _tmp0_ = FALSE;
	NotifyNotification* notification = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	NotifyNotification* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_is_initted ();
	if (!_tmp0_) {
		notify_init ("ibus");
	}
	_tmp1_ = _ ("IBus Update");
	_tmp2_ = _ ("Super+space is now the default hotkey.");
	_tmp3_ = notify_notification_new (_tmp1_, _tmp2_, "ibus");
	notification = _tmp3_;
	notify_notification_set_timeout (notification, 30 * 1000);
	notify_notification_set_category (notification, "hotkey");
	{
		notify_notification_show (notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("panel.vala:420: Notification is failed for IBus 1.5.3: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (notification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (notification);
}


static void panel_set_version (Panel* self) {
	gchar* prev_version = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* current_version = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_string (_tmp0_, "version");
	prev_version = _tmp1_;
	current_version = NULL;
	_tmp2_ = prev_version;
	_tmp3_ = panel_compare_versions (self, _tmp2_, "1.5.3");
	if (_tmp3_ < 0) {
		panel_update_version_1_5_3 (self);
	}
	_tmp4_ = g_strdup_printf ("%d.%d.%d", IBUS_MAJOR_VERSION, IBUS_MINOR_VERSION, IBUS_MICRO_VERSION);
	_g_free0 (current_version);
	current_version = _tmp4_;
	_tmp5_ = prev_version;
	_tmp6_ = current_version;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		_g_free0 (current_version);
		_g_free0 (prev_version);
		return;
	}
	_tmp7_ = self->priv->m_settings_general;
	_tmp8_ = current_version;
	g_settings_set_string (_tmp7_, "version", _tmp8_);
	_g_free0 (current_version);
	_g_free0 (prev_version);
}


void panel_load_settings (Panel* self) {
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GSettings* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (self != NULL);
	panel_set_use_system_keyboard_layout (self);
	panel_set_use_global_engine (self);
	_tmp0_ = self->priv->m_settings_general;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "preload-engines");
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = self->priv->m_settings_general;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "engines-order");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	panel_update_engines (self, _tmp3_, _vala_array_length (_tmp1_), _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	panel_unbind_switch_shortcut (self);
	panel_bind_switch_shortcut (self);
	panel_set_switcher_delay_time (self);
	panel_set_embed_preedit_text (self);
	panel_set_custom_font (self);
	panel_set_show_icon_on_systray (self);
	panel_set_lookup_table_orientation (self);
	panel_set_show_property_panel (self);
	panel_set_timeout_property_panel (self);
	panel_set_version (self);
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine) {
	gchar* layout = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* variant = NULL;
	IBusEngineDesc* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* option = NULL;
	IBusEngineDesc* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar** args = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_ = NULL;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gint _tmp59_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = layout;
		_tmp11_ = g_strcmp0 (_tmp16_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gchar* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = g_strdup ("-layout");
		_vala_array_add14 (&args, &args_length1, &_args_size_, _tmp19_);
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = layout;
		_tmp22_ = g_strdup (_tmp21_);
		_vala_array_add15 (&args, &args_length1, &_args_size_, _tmp22_);
	}
	_tmp25_ = variant;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_ = NULL;
		_tmp26_ = variant;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		const gchar* _tmp28_ = NULL;
		_tmp28_ = variant;
		_tmp23_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp29_ = _tmp23_;
	if (_tmp29_) {
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		gchar* _tmp31_ = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		_tmp30_ = args;
		_tmp30__length1 = args_length1;
		_tmp31_ = g_strdup ("-variant");
		_vala_array_add16 (&args, &args_length1, &_args_size_, _tmp31_);
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = variant;
		_tmp34_ = g_strdup (_tmp33_);
		_vala_array_add17 (&args, &args_length1, &_args_size_, _tmp34_);
	}
	_tmp37_ = option;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_ = NULL;
		_tmp38_ = option;
		_tmp36_ = g_strcmp0 (_tmp38_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp39_ = _tmp36_;
	if (_tmp39_) {
		const gchar* _tmp40_ = NULL;
		_tmp40_ = option;
		_tmp35_ = g_strcmp0 (_tmp40_, "default") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp41_ = _tmp35_;
	if (_tmp41_) {
		gchar** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		gchar* _tmp43_ = NULL;
		gchar** _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		gchar* _tmp45_ = NULL;
		gchar** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		_tmp42_ = args;
		_tmp42__length1 = args_length1;
		_tmp43_ = g_strdup ("-option");
		_vala_array_add18 (&args, &args_length1, &_args_size_, _tmp43_);
		_tmp44_ = args;
		_tmp44__length1 = args_length1;
		_tmp45_ = g_strdup ("-option");
		_vala_array_add19 (&args, &args_length1, &_args_size_, _tmp45_);
		_tmp46_ = args;
		_tmp46__length1 = args_length1;
		_tmp47_ = option;
		_tmp48_ = g_strdup (_tmp47_);
		_vala_array_add20 (&args, &args_length1, &_args_size_, _tmp48_);
	}
	_tmp49_ = args;
	_tmp49__length1 = args_length1;
	if (_tmp49__length1 == 1) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	{
		gboolean _tmp50_ = FALSE;
		gchar** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		gchar* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gboolean _tmp54_ = FALSE;
		_tmp51_ = args;
		_tmp51__length1 = args_length1;
		_tmp54_ = g_spawn_sync (NULL, _tmp51_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp52_, &_tmp53_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp52_;
		exit_status = _tmp53_;
		_tmp50_ = _tmp54_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp50_) {
			IBusEngineDesc* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			_tmp55_ = engine;
			_tmp56_ = ibus_engine_desc_get_layout (_tmp55_);
			g_warning ("panel.vala:499: Switch xkb layout to %s failed.", _tmp56_);
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("panel.vala:503: Execute setxkbmap failed: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp59_ = exit_status;
	if (_tmp59_ != 0) {
		gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp65_ = NULL;
		_tmp61_ = standard_error;
		_tmp62_ = g_strdup (_tmp61_);
		_tmp60_ = _tmp62_;
		_tmp63_ = _tmp60_;
		if (_tmp63_ == NULL) {
			gchar* _tmp64_ = NULL;
			_tmp64_ = g_strdup ("(null)");
			_g_free0 (_tmp60_);
			_tmp60_ = _tmp64_;
		}
		_tmp65_ = _tmp60_;
		g_warning ("panel.vala:507: Execute setxkbmap failed: %s", _tmp65_);
		_g_free0 (_tmp60_);
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}


static void panel_engine_contexts_insert (Panel* self, IBusEngineDesc* engine) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GHashTable* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	IBusEngineDesc* _tmp7_ = NULL;
	IBusEngineDesc* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	_tmp2_ = g_hash_table_size (_tmp1_);
	if (_tmp2_ >= ((guint) 200)) {
		GHashTable* _tmp3_ = NULL;
		g_warning ("panel.vala:516: Contexts by windows are too much counted!");
		_tmp3_ = self->priv->m_engine_contexts;
		g_hash_table_remove_all (_tmp3_);
	}
	_tmp4_ = self->priv->m_engine_contexts;
	_tmp5_ = self->priv->m_current_context_path;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = engine;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	g_hash_table_replace (_tmp4_, _tmp6_, _tmp8_);
}


static void panel_set_engine (Panel* self, IBusEngineDesc* engine) {
	IBusBus* _tmp0_ = NULL;
	IBusEngineDesc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_ = FALSE;
	IBusEngineDesc* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_bus;
	_tmp1_ = engine;
	_tmp2_ = ibus_engine_desc_get_name (_tmp1_);
	_tmp3_ = ibus_bus_set_global_engine (_tmp0_, _tmp2_);
	if (!_tmp3_) {
		IBusEngineDesc* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = engine;
		_tmp5_ = ibus_engine_desc_get_name (_tmp4_);
		g_warning ("panel.vala:525: Switch engine to %s failed.", _tmp5_);
		return;
	}
	_tmp6_ = self->priv->m_use_system_keyboard_layout;
	if (!_tmp6_) {
		IBusEngineDesc* _tmp7_ = NULL;
		_tmp7_ = engine;
		panel_exec_setxkbmap (self, _tmp7_);
	}
	_tmp8_ = engine;
	panel_engine_contexts_insert (self, _tmp8_);
}


static void panel_switch_engine (Panel* self, gint i, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gboolean _tmp8_ = FALSE;
	IBusEngineDesc* engine = NULL;
	IBusEngineDesc** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp10_ = 0;
	IBusEngineDesc* _tmp11_ = NULL;
	IBusEngineDesc* _tmp12_ = NULL;
	IBusEngineDesc* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = i;
	if (_tmp1_ >= 0) {
		gint _tmp2_ = 0;
		IBusEngineDesc** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = i;
		_tmp3_ = self->priv->m_engines;
		_tmp3__length1 = self->priv->m_engines_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	_vala_assert (_tmp4_, "i >= 0 && i < m_engines.length");
	_tmp6_ = i;
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = force;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		return;
	}
	_tmp9_ = self->priv->m_engines;
	_tmp9__length1 = self->priv->m_engines_length1;
	_tmp10_ = i;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	engine = _tmp12_;
	_tmp13_ = engine;
	panel_set_engine (self, _tmp13_);
	_g_object_unref0 (engine);
}


static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert) {
	IBusEngineDesc** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint keyval = 0U;
	GdkEvent* _tmp1_ = NULL;
	GdkEventKey _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint modifiers = 0U;
	GdkEvent* _tmp4_ = NULL;
	GdkEventKey _tmp5_ = {0};
	GdkModifierType _tmp6_ = 0;
	guint primary_modifiers = 0U;
	GdkEvent* _tmp7_ = NULL;
	GdkEventKey _tmp8_ = {0};
	GdkModifierType _tmp9_ = 0;
	GdkModifierType _tmp10_ = 0;
	gboolean pressed = FALSE;
	GdkEvent* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->key;
	_tmp3_ = _tmp2_.keyval;
	keyval = _tmp3_;
	_tmp4_ = event;
	_tmp5_ = _tmp4_->key;
	_tmp6_ = _tmp5_.state;
	modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp6_;
	_tmp7_ = event;
	_tmp8_ = _tmp7_->key;
	_tmp9_ = _tmp8_.state;
	_tmp10_ = keybinding_manager_get_primary_modifier ((guint) _tmp9_);
	primary_modifiers = (guint) _tmp10_;
	_tmp11_ = event;
	_tmp12_ = primary_modifiers;
	_tmp13_ = keybinding_manager_primary_modifier_still_pressed (_tmp11_, _tmp12_);
	pressed = _tmp13_;
	_tmp14_ = revert;
	if (_tmp14_) {
		guint _tmp15_ = 0U;
		_tmp15_ = modifiers;
		modifiers = _tmp15_ & (~GDK_SHIFT_MASK);
	}
	_tmp17_ = pressed;
	if (_tmp17_) {
		gint _tmp18_ = 0;
		_tmp18_ = self->priv->m_switcher_delay_time;
		_tmp16_ = _tmp18_ >= 0;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		gint _tmp20_ = 0;
		gboolean _tmp21_ = FALSE;
		gint i = 0;
		gint _tmp23_ = 0;
		Switcher* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		guint _tmp26_ = 0U;
		GdkEvent* _tmp27_ = NULL;
		IBusEngineDesc** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		_tmp21_ = revert;
		if (_tmp21_) {
			IBusEngineDesc** _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			_tmp22_ = self->priv->m_engines;
			_tmp22__length1 = self->priv->m_engines_length1;
			_tmp20_ = _tmp22__length1 - 1;
		} else {
			_tmp20_ = 1;
		}
		_tmp23_ = _tmp20_;
		i = _tmp23_;
		self->priv->m_switcher_is_running = TRUE;
		_tmp24_ = self->priv->m_switcher;
		_tmp25_ = keyval;
		_tmp26_ = modifiers;
		_tmp27_ = event;
		_tmp28_ = self->priv->m_engines;
		_tmp28__length1 = self->priv->m_engines_length1;
		_tmp29_ = i;
		_tmp30_ = switcher_run (_tmp24_, _tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp28__length1, _tmp29_);
		i = _tmp30_;
		self->priv->m_switcher_is_running = FALSE;
		_tmp31_ = i;
		if (_tmp31_ < 0) {
			g_debug ("panel.vala:583: switch cancelled");
		} else {
			gint _tmp32_ = 0;
			IBusEngineDesc** _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp34_ = 0;
			_tmp32_ = i;
			_tmp33_ = self->priv->m_engines;
			_tmp33__length1 = self->priv->m_engines_length1;
			_vala_assert (_tmp32_ < _tmp33__length1, "i < m_engines.length");
			_tmp34_ = i;
			panel_switch_engine (self, _tmp34_, FALSE);
		}
	} else {
		gint _tmp35_ = 0;
		gboolean _tmp36_ = FALSE;
		gint i = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		_tmp36_ = revert;
		if (_tmp36_) {
			IBusEngineDesc** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			_tmp37_ = self->priv->m_engines;
			_tmp37__length1 = self->priv->m_engines_length1;
			_tmp35_ = _tmp37__length1 - 1;
		} else {
			_tmp35_ = 1;
		}
		_tmp38_ = _tmp35_;
		i = _tmp38_;
		_tmp39_ = i;
		panel_switch_engine (self, _tmp39_, FALSE);
	}
}


static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_run_preload_engines (Panel* self, IBusEngineDesc** engines, int engines_length1, gint index) {
	gchar** names = NULL;
	gchar** _tmp0_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	IBusEngineDesc** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	IBusEngineDesc** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	IBusEngineDesc* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	IBusBus* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	names = _tmp0_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp1_ = engines;
	_tmp1__length1 = engines_length1;
	_tmp2_ = index;
	if (_tmp1__length1 <= _tmp2_) {
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = names;
	_tmp3__length1 = names_length1;
	_tmp4_ = engines;
	_tmp4__length1 = engines_length1;
	_tmp5_ = index;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = ibus_engine_desc_get_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp8_);
	_tmp9_ = self->priv->m_bus;
	_tmp10_ = names;
	_tmp10__length1 = names_length1;
	ibus_bus_preload_engines_async (_tmp9_, _tmp10_, -1, NULL, NULL, NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void panel_update_engines (Panel* self, gchar** unowned_engine_names, int unowned_engine_names_length1, gchar** order_names, int order_names_length1) {
	gchar** engine_names = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint engine_names_length1 = 0;
	gint _engine_names_size_ = 0;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gboolean _tmp5_ = FALSE;
	gchar** names = NULL;
	gchar** _tmp8_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	IBusEngineDesc** engines = NULL;
	IBusBus* _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	IBusEngineDesc** _tmp25_ = NULL;
	IBusEngineDesc** _tmp26_ = NULL;
	gint engines_length1 = 0;
	gint _engines_size_ = 0;
	IBusEngineDesc** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = unowned_engine_names;
	_tmp0__length1 = unowned_engine_names_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	engine_names = _tmp1_;
	engine_names_length1 = _tmp1__length1;
	_engine_names_size_ = engine_names_length1;
	_tmp3_ = engine_names;
	_tmp3__length1 = engine_names_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = engine_names;
		_tmp4__length1 = engine_names_length1;
		_tmp2_ = _tmp4__length1 == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		_tmp6_ = g_strdup ("xkb:us::eng");
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp7_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	names = _tmp8_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp9_ = order_names;
	_tmp9__length1 = order_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp9_;
		name_collection_length1 = _tmp9__length1;
		for (name_it = 0; name_it < _tmp9__length1; name_it = name_it + 1) {
			gchar* _tmp10_ = NULL;
			gchar* name = NULL;
			_tmp10_ = g_strdup (name_collection[name_it]);
			name = _tmp10_;
			{
				const gchar* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				_tmp11_ = name;
				_tmp12_ = engine_names;
				_tmp12__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp12_, _tmp12__length1, _tmp11_)) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp13_ = names;
					_tmp13__length1 = names_length1;
					_tmp14_ = name;
					_tmp15_ = g_strdup (_tmp14_);
					_vala_array_add22 (&names, &names_length1, &_names_size_, _tmp15_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp16_ = engine_names;
	_tmp16__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp16_;
		name_collection_length1 = _tmp16__length1;
		for (name_it = 0; name_it < _tmp16__length1; name_it = name_it + 1) {
			gchar* _tmp17_ = NULL;
			gchar* name = NULL;
			_tmp17_ = g_strdup (name_collection[name_it]);
			name = _tmp17_;
			{
				const gchar* _tmp18_ = NULL;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp18_ = name;
				_tmp19_ = names;
				_tmp19__length1 = names_length1;
				if (_vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_)) {
					_g_free0 (name);
					continue;
				}
				_tmp20_ = names;
				_tmp20__length1 = names_length1;
				_tmp21_ = name;
				_tmp22_ = g_strdup (_tmp21_);
				_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp22_);
				_g_free0 (name);
			}
		}
	}
	_tmp23_ = self->priv->m_bus;
	_tmp24_ = names;
	_tmp24__length1 = names_length1;
	_tmp26_ = _tmp25_ = ibus_bus_get_engines_by_names (_tmp23_, _tmp24_);
	engines = _tmp26_;
	engines_length1 = _vala_array_length (_tmp25_);
	_engines_size_ = engines_length1;
	_tmp27_ = self->priv->m_engines;
	_tmp27__length1 = self->priv->m_engines_length1;
	if (_tmp27__length1 == 0) {
		IBusEngineDesc** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		IBusEngineDesc** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		IBusEngineDesc** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp28_ = engines;
		_tmp28__length1 = engines_length1;
		_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup3 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
		_tmp29__length1 = _tmp28__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp29_;
		self->priv->m_engines_length1 = _tmp29__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
		_tmp30_ = engines;
		_tmp30__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp30_, _tmp30__length1, 1);
	} else {
		IBusEngineDesc* current_engine = NULL;
		IBusEngineDesc** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		IBusEngineDesc* _tmp32_ = NULL;
		IBusEngineDesc* _tmp33_ = NULL;
		IBusEngineDesc** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		IBusEngineDesc** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gint i = 0;
		IBusEngineDesc** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		_tmp31_ = self->priv->m_engines;
		_tmp31__length1 = self->priv->m_engines_length1;
		_tmp32_ = _tmp31_[0];
		_tmp33_ = _g_object_ref0 (_tmp32_);
		current_engine = _tmp33_;
		_tmp34_ = engines;
		_tmp34__length1 = engines_length1;
		_tmp35_ = (_tmp34_ != NULL) ? _vala_array_dup4 (_tmp34_, _tmp34__length1) : ((gpointer) _tmp34_);
		_tmp35__length1 = _tmp34__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp35_;
		self->priv->m_engines_length1 = _tmp35__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp36_ = FALSE;
			i = 0;
			_tmp36_ = TRUE;
			while (TRUE) {
				gboolean _tmp37_ = FALSE;
				gint _tmp39_ = 0;
				IBusEngineDesc** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				IBusEngineDesc* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				IBusEngineDesc** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp44_ = 0;
				IBusEngineDesc* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				_tmp37_ = _tmp36_;
				if (!_tmp37_) {
					gint _tmp38_ = 0;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp36_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = self->priv->m_engines;
				_tmp40__length1 = self->priv->m_engines_length1;
				if (!(_tmp39_ < _tmp40__length1)) {
					break;
				}
				_tmp41_ = current_engine;
				_tmp42_ = ibus_engine_desc_get_name (_tmp41_);
				_tmp43_ = engines;
				_tmp43__length1 = engines_length1;
				_tmp44_ = i;
				_tmp45_ = _tmp43_[_tmp44_];
				_tmp46_ = ibus_engine_desc_get_name (_tmp45_);
				if (g_strcmp0 (_tmp42_, _tmp46_) == 0) {
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					_tmp47_ = i;
					panel_switch_engine (self, _tmp47_, FALSE);
					_tmp48_ = i;
					if (_tmp48_ != 0) {
						IBusEngineDesc** _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						_tmp49_ = engines;
						_tmp49__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp49_, _tmp49__length1, 0);
					} else {
						IBusEngineDesc** _tmp50_ = NULL;
						gint _tmp50__length1 = 0;
						_tmp50_ = engines;
						_tmp50__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp50_, _tmp50__length1, 1);
					}
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_tmp51_ = engines;
		_tmp51__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp51_, _tmp51__length1, 1);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void __lambda38_ (Panel* self, GPid pid, gint state) {
	GPid _tmp0_ = 0;
	GPid _tmp1_ = 0;
	GPid _tmp2_ = 0;
	_tmp0_ = pid;
	_tmp1_ = self->priv->m_setup_pid;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
}


static void ___lambda38__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda38_ (self, pid, status);
}


static void panel_show_setup_dialog (Panel* self) {
	GPid _tmp0_ = 0;
	gchar* binary = NULL;
	gchar* _tmp3_ = NULL;
	GPid _tmp13_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->m_setup_pid;
		_tmp2_ = kill ((pid_t) _tmp1_, SIGUSR1);
		if (_tmp2_ == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp3_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp3_;
	{
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		GPid _tmp9_ = 0;
		_tmp4_ = binary;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_strdup ("ibus-setup");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp9_, &_inner_error_);
		self->priv->m_setup_pid = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch5_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = binary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("panel.vala:668: Execute %s failed! %s", _tmp10_, _tmp12_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, ___lambda38__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void panel_show_about_dialog (Panel* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_ = NULL;
		GtkAboutDialog* _tmp2_ = NULL;
		GtkAboutDialog* _tmp3_ = NULL;
		gchar* copyright = NULL;
		gchar* _tmp4_ = NULL;
		GtkAboutDialog* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkAboutDialog* _tmp7_ = NULL;
		GtkAboutDialog* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkAboutDialog* _tmp10_ = NULL;
		GtkAboutDialog* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar** _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		GtkAboutDialog* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		GtkAboutDialog* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkAboutDialog* _tmp21_ = NULL;
		GtkAboutDialog* _tmp22_ = NULL;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = g_strdup ("Copyright © 2007-2013 Peng Huang\n" "Copyright © 2007-2013 Red Hat, Inc.\n");
		copyright = _tmp4_;
		_tmp5_ = self->priv->m_about_dialog;
		_tmp6_ = copyright;
		gtk_about_dialog_set_copyright (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp7_, "LGPL");
		_tmp8_ = self->priv->m_about_dialog;
		_tmp9_ = _ ("IBus is an intelligent input bus for Linux/Unix.");
		gtk_about_dialog_set_comments (_tmp8_, _tmp9_);
		_tmp10_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp10_, "http://code.google.com/p/ibus");
		_tmp11_ = self->priv->m_about_dialog;
		_tmp12_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 1;
		gtk_about_dialog_set_authors (_tmp11_, _tmp14_);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		_tmp15_ = self->priv->m_about_dialog;
		_tmp16_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp17_ = g_new0 (gchar*, 1 + 1);
		_tmp17_[0] = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp18__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp15_, _tmp18_);
		_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
		_tmp19_ = self->priv->m_about_dialog;
		_tmp20_ = _ ("translator-credits");
		gtk_about_dialog_set_translator_credits (_tmp19_, _tmp20_);
		_tmp21_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp21_, "ibus");
		_tmp22_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp22_, "ibus");
		_g_free0 (copyright);
	}
	_tmp23_ = self->priv->m_about_dialog;
	_tmp24_ = gtk_widget_get_visible ((GtkWidget*) _tmp23_);
	if (!_tmp24_) {
		GtkAboutDialog* _tmp25_ = NULL;
		GtkAboutDialog* _tmp26_ = NULL;
		_tmp25_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp25_);
		_tmp26_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp26_);
	} else {
		GtkAboutDialog* _tmp27_ = NULL;
		_tmp27_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp27_);
	}
}


static void ___lambda37_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void ____lambda37__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda37_ (self, _sender);
}


static void ___lambda39_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void ____lambda39__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda39_ (self, _sender);
}


static void ___lambda40_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_ = NULL;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void ____lambda40__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda40_ (self, _sender);
}


static void ___lambda41_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_ = NULL;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void ____lambda41__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda41_ (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* _tmp24_ = NULL;
	GtkStatusIcon* _tmp25_ = NULL;
	guint32 _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkImageMenuItem* item = NULL;
		GtkMenu* _tmp1_ = NULL;
		GtkImageMenuItem* _tmp2_ = NULL;
		GtkImageMenuItem* _tmp3_ = NULL;
		GtkMenu* _tmp4_ = NULL;
		GtkImageMenuItem* _tmp5_ = NULL;
		GtkImageMenuItem* _tmp6_ = NULL;
		GtkImageMenuItem* _tmp7_ = NULL;
		GtkMenu* _tmp8_ = NULL;
		GtkImageMenuItem* _tmp9_ = NULL;
		GtkMenu* _tmp10_ = NULL;
		GtkSeparatorMenuItem* _tmp11_ = NULL;
		GtkSeparatorMenuItem* _tmp12_ = NULL;
		GtkImageMenuItem* _tmp13_ = NULL;
		GtkImageMenuItem* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkImageMenuItem* _tmp16_ = NULL;
		GtkMenu* _tmp17_ = NULL;
		GtkImageMenuItem* _tmp18_ = NULL;
		GtkImageMenuItem* _tmp19_ = NULL;
		GtkImageMenuItem* _tmp20_ = NULL;
		GtkMenu* _tmp21_ = NULL;
		GtkImageMenuItem* _tmp22_ = NULL;
		GtkMenu* _tmp23_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp3_, "activate", (GCallback) ____lambda37__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
		_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp7_, "activate", (GCallback) ____lambda39__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) ((GtkMenuItem*) _tmp9_));
		_tmp10_ = self->priv->m_sys_menu;
		_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) ((GtkMenuItem*) _tmp12_));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REFRESH, NULL);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (item);
		item = _tmp13_;
		_tmp14_ = item;
		_tmp15_ = _ ("Restart");
		gtk_menu_item_set_label ((GtkMenuItem*) _tmp14_, _tmp15_);
		_tmp16_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp16_, "activate", (GCallback) ____lambda40__gtk_menu_item_activate, self, 0);
		_tmp17_ = self->priv->m_sys_menu;
		_tmp18_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp17_, (GtkWidget*) ((GtkMenuItem*) _tmp18_));
		_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (item);
		item = _tmp19_;
		_tmp20_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp20_, "activate", (GCallback) ____lambda41__gtk_menu_item_activate, self, 0);
		_tmp21_ = self->priv->m_sys_menu;
		_tmp22_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp21_, (GtkWidget*) ((GtkMenuItem*) _tmp22_));
		_tmp23_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp23_);
		_g_object_unref0 (item);
	}
	_tmp24_ = self->priv->m_sys_menu;
	_tmp25_ = self->priv->m_status_icon;
	_tmp26_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp24_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp25_, (guint) 0, _tmp26_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Panel * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->e);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ____lambda42_ (Block4Data* _data4_, GtkMenuItem* item) {
	Panel * self;
	self = _data4_->self;
	g_return_if_fail (item != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				IBusEngineDesc** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				IBusEngineDesc* _tmp5_ = NULL;
				IBusEngineDesc** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				IBusEngineDesc* _tmp8_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->m_engines;
				_tmp4__length1 = self->priv->m_engines_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = _data4_->e;
				_tmp6_ = self->priv->m_engines;
				_tmp6__length1 = self->priv->m_engines_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp5_ == _tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					panel_switch_engine (self, _tmp9_, FALSE);
					break;
				}
			}
		}
	}
}


static void _____lambda42__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda42_ (self, _sender);
}


static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon) {
	GtkMenu* _tmp0_ = NULL;
	PropertyManager* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	GtkSeparatorMenuItem* _tmp4_ = NULL;
	GtkSeparatorMenuItem* _tmp5_ = NULL;
	IBusEngineDesc** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GtkMenu* _tmp33_ = NULL;
	GtkMenu* _tmp34_ = NULL;
	GtkMenu* _tmp35_ = NULL;
	GtkStatusIcon* _tmp36_ = NULL;
	guint32 _tmp37_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->m_engines;
	_tmp6__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp6_;
		engine_collection_length1 = _tmp6__length1;
		for (engine_it = 0; engine_it < _tmp6__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp7_ = NULL;
			IBusEngineDesc* engine = NULL;
			_tmp7_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp7_;
			{
				Block4Data* _data4_;
				gchar* language = NULL;
				IBusEngineDesc* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				GtkImageMenuItem* item = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				GtkImageMenuItem* _tmp19_ = NULL;
				GtkImageMenuItem* _tmp20_ = NULL;
				IBusEngineDesc* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				IBusEngineDesc* _tmp28_ = NULL;
				IBusEngineDesc* _tmp29_ = NULL;
				GtkImageMenuItem* _tmp30_ = NULL;
				GtkMenu* _tmp31_ = NULL;
				GtkImageMenuItem* _tmp32_ = NULL;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				_tmp8_ = engine;
				_tmp9_ = ibus_engine_desc_get_language (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				language = _tmp10_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_longname (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				longname = _tmp13_;
				_tmp14_ = language;
				_tmp15_ = ibus_get_language_name (_tmp14_);
				_tmp16_ = longname;
				_tmp17_ = g_strdup_printf ("%s - %s", _tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp18_);
				g_object_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				item = _tmp20_;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_icon (_tmp21_);
				if (g_strcmp0 (_tmp22_, "") != 0) {
					IconWidget* icon = NULL;
					IBusEngineDesc* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					IconWidget* _tmp25_ = NULL;
					GtkImageMenuItem* _tmp26_ = NULL;
					IconWidget* _tmp27_ = NULL;
					_tmp23_ = engine;
					_tmp24_ = ibus_engine_desc_get_icon (_tmp23_);
					_tmp25_ = icon_widget_new (_tmp24_, GTK_ICON_SIZE_MENU);
					g_object_ref_sink (_tmp25_);
					icon = _tmp25_;
					_tmp26_ = item;
					_tmp27_ = icon;
					gtk_image_menu_item_set_image (_tmp26_, (GtkWidget*) _tmp27_);
					_g_object_unref0 (icon);
				}
				_tmp28_ = engine;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_data4_->e = _tmp29_;
				_tmp30_ = item;
				g_signal_connect_data ((GtkMenuItem*) _tmp30_, "activate", (GCallback) _____lambda42__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp31_ = self->priv->m_ime_menu;
				_tmp32_ = item;
				gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
				_g_object_unref0 (item);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp33_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp34_, FALSE);
	_tmp35_ = self->priv->m_ime_menu;
	_tmp36_ = self->priv->m_status_icon;
	_tmp37_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp35_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp36_, (guint) 0, _tmp37_);
}


static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height) {
	Panel * self;
	CandidatePanel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	PropertyPanel* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = width;
	_tmp4_ = height;
	candidate_panel_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_property_panel;
	_tmp6_ = x;
	_tmp7_ = y;
	_tmp8_ = width;
	_tmp9_ = height;
	property_panel_set_cursor_location (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_);
}


static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	PropertyPanel* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	IBusEngineDesc* engine = NULL;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gconstpointer _tmp7_ = NULL;
	IBusEngineDesc* _tmp8_ = NULL;
	IBusEngineDesc* _tmp9_ = NULL;
	IBusEngineDesc* _tmp24_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = self->priv->m_property_panel;
	property_panel_focus_in (_tmp0_);
	_tmp1_ = self->priv->m_use_global_engine;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->m_switcher_is_running;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = input_context_path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp4_;
	_tmp5_ = self->priv->m_engine_contexts;
	_tmp6_ = self->priv->m_current_context_path;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	_tmp8_ = _g_object_ref0 ((IBusEngineDesc*) _tmp7_);
	engine = _tmp8_;
	_tmp9_ = engine;
	if (_tmp9_ == NULL) {
		IBusEngineDesc* _tmp10_ = NULL;
		IBusEngineDesc** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		IBusEngineDesc* _tmp14_ = NULL;
		IBusEngineDesc* _tmp15_ = NULL;
		IBusEngineDesc* _tmp16_ = NULL;
		_tmp11_ = self->priv->m_engines;
		_tmp11__length1 = self->priv->m_engines_length1;
		if (_tmp11__length1 > 0) {
			IBusEngineDesc** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			IBusEngineDesc* _tmp13_ = NULL;
			_tmp12_ = self->priv->m_engines;
			_tmp12__length1 = self->priv->m_engines_length1;
			_tmp13_ = _tmp12_[0];
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = NULL;
		}
		_tmp14_ = _tmp10_;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (engine);
		engine = _tmp15_;
		_tmp16_ = engine;
		if (_tmp16_ == NULL) {
			_g_object_unref0 (engine);
			return;
		}
	} else {
		gboolean in_engines = FALSE;
		IBusEngineDesc** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gboolean _tmp23_ = FALSE;
		in_engines = FALSE;
		_tmp17_ = self->priv->m_engines;
		_tmp17__length1 = self->priv->m_engines_length1;
		{
			IBusEngineDesc** e_collection = NULL;
			gint e_collection_length1 = 0;
			gint _e_collection_size_ = 0;
			gint e_it = 0;
			e_collection = _tmp17_;
			e_collection_length1 = _tmp17__length1;
			for (e_it = 0; e_it < _tmp17__length1; e_it = e_it + 1) {
				IBusEngineDesc* _tmp18_ = NULL;
				IBusEngineDesc* e = NULL;
				_tmp18_ = _g_object_ref0 (e_collection[e_it]);
				e = _tmp18_;
				{
					IBusEngineDesc* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					IBusEngineDesc* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					_tmp19_ = engine;
					_tmp20_ = ibus_engine_desc_get_name (_tmp19_);
					_tmp21_ = e;
					_tmp22_ = ibus_engine_desc_get_name (_tmp21_);
					if (g_strcmp0 (_tmp20_, _tmp22_) == 0) {
						in_engines = TRUE;
						_g_object_unref0 (e);
						break;
					}
					_g_object_unref0 (e);
				}
			}
		}
		_tmp23_ = in_engines;
		if (!_tmp23_) {
			_g_object_unref0 (engine);
			return;
		}
	}
	_tmp24_ = engine;
	panel_set_engine (self, _tmp24_);
	_g_object_unref0 (engine);
}


static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_switcher_is_running;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp2_;
}


static void panel_real_destroy_context (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	_tmp2_ = input_context_path;
	g_hash_table_remove (_tmp1_, _tmp2_);
}


static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props) {
	Panel * self;
	PropertyManager* _tmp0_ = NULL;
	IBusPropList* _tmp1_ = NULL;
	PropertyPanel* _tmp2_ = NULL;
	IBusPropList* _tmp3_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = props;
	property_manager_set_properties (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->m_property_panel;
	_tmp3_ = props;
	property_panel_set_properties (_tmp2_, _tmp3_);
}


static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop) {
	Panel * self;
	PropertyManager* _tmp0_ = NULL;
	IBusProperty* _tmp1_ = NULL;
	PropertyPanel* _tmp2_ = NULL;
	IBusProperty* _tmp3_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = prop;
	property_manager_update_property (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->m_property_panel;
	_tmp3_ = prop;
	property_panel_update_property (_tmp2_, _tmp3_);
}


static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible) {
	Panel * self;
	gboolean _tmp0_ = FALSE;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		CandidatePanel* _tmp1_ = NULL;
		IBusText* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		PropertyPanel* _tmp4_ = NULL;
		IBusText* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		_tmp1_ = self->priv->m_candidate_panel;
		_tmp2_ = text;
		_tmp3_ = cursor_pos;
		candidate_panel_set_preedit_text (_tmp1_, _tmp2_, _tmp3_);
		_tmp4_ = self->priv->m_property_panel;
		_tmp5_ = text;
		_tmp6_ = cursor_pos;
		property_panel_set_preedit_text (_tmp4_, _tmp5_, _tmp6_);
	} else {
		CandidatePanel* _tmp7_ = NULL;
		PropertyPanel* _tmp8_ = NULL;
		_tmp7_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp7_, NULL, (guint) 0);
		_tmp8_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp8_, NULL, (guint) 0);
	}
}


static void panel_real_hide_preedit_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_ = NULL;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible) {
	Panel * self;
	IBusText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CandidatePanel* _tmp3_ = NULL;
	IBusText* _tmp4_ = NULL;
	IBusText* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	PropertyPanel* _tmp8_ = NULL;
	IBusText* _tmp9_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusText* _tmp2_ = NULL;
		_tmp2_ = text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_auxiliary_text (_tmp3_, _tmp4_);
	_tmp6_ = visible;
	if (_tmp6_) {
		IBusText* _tmp7_ = NULL;
		_tmp7_ = text;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = NULL;
	}
	_tmp8_ = self->priv->m_property_panel;
	_tmp9_ = _tmp5_;
	property_panel_set_auxiliary_text (_tmp8_, _tmp9_);
}


static void panel_real_hide_auxiliary_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_ = NULL;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible) {
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CandidatePanel* _tmp3_ = NULL;
	IBusLookupTable* _tmp4_ = NULL;
	IBusLookupTable* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	PropertyPanel* _tmp8_ = NULL;
	IBusLookupTable* _tmp9_ = NULL;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusLookupTable* _tmp2_ = NULL;
		_tmp2_ = table;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_lookup_table (_tmp3_, _tmp4_);
	_tmp6_ = visible;
	if (_tmp6_) {
		IBusLookupTable* _tmp7_ = NULL;
		_tmp7_ = table;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = NULL;
	}
	_tmp8_ = self->priv->m_property_panel;
	_tmp9_ = _tmp5_;
	property_panel_set_lookup_table (_tmp8_, _tmp9_);
}


static void panel_real_hide_lookup_table (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_ = NULL;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_real_state_changed (IBusPanelService* base) {
	Panel * self;
	gboolean _tmp0_ = FALSE;
	gchar* icon_name = NULL;
	gchar* _tmp1_ = NULL;
	IBusEngineDesc* engine = NULL;
	IBusBus* _tmp2_ = NULL;
	IBusEngineDesc* _tmp3_ = NULL;
	IBusEngineDesc* _tmp4_ = NULL;
	IBusEngineDesc* _tmp5_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar _tmp10_ = '\0';
	IBusEngineDesc* _tmp23_ = NULL;
	gint i = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	IBusEngineDesc** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	IBusEngineDesc** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	IBusEngineDesc* _tmp51_ = NULL;
	IBusEngineDesc* _tmp52_ = NULL;
	IBusEngineDesc* _tmp53_ = NULL;
	gchar** names = NULL;
	gchar** _tmp54_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	IBusEngineDesc** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	GSettings* _tmp61_ = NULL;
	gchar** _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_switcher_is_running;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp1_;
	_tmp2_ = self->priv->m_bus;
	_tmp3_ = ibus_bus_get_global_engine (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	engine = _tmp4_;
	_tmp5_ = engine;
	if (_tmp5_ != NULL) {
		IBusEngineDesc* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = engine;
		_tmp7_ = ibus_engine_desc_get_icon (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (icon_name);
		icon_name = _tmp8_;
	}
	_tmp9_ = icon_name;
	_tmp10_ = string_get (_tmp9_, (glong) 0);
	if (_tmp10_ == '/') {
		GtkStatusIcon* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->m_status_icon;
		_tmp12_ = icon_name;
		gtk_status_icon_set_from_file (_tmp11_, _tmp12_);
	} else {
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp13_ = NULL;
		GtkIconTheme* _tmp14_ = NULL;
		GtkIconTheme* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GtkIconInfo* _tmp17_ = NULL;
		GtkIconInfo* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp13_ = gtk_icon_theme_get_default ();
		_tmp14_ = _g_object_ref0 (_tmp13_);
		theme = _tmp14_;
		_tmp15_ = theme;
		_tmp16_ = icon_name;
		_tmp17_ = gtk_icon_theme_lookup_icon (_tmp15_, _tmp16_, 48, 0);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_ != NULL;
		_gtk_icon_info_free0 (_tmp18_);
		if (_tmp19_) {
			GtkStatusIcon* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			_tmp20_ = self->priv->m_status_icon;
			_tmp21_ = icon_name;
			gtk_status_icon_set_from_icon_name (_tmp20_, _tmp21_);
		} else {
			GtkStatusIcon* _tmp22_ = NULL;
			_tmp22_ = self->priv->m_status_icon;
			gtk_status_icon_set_from_icon_name (_tmp22_, "ibus-engine");
		}
		_g_object_unref0 (theme);
	}
	_tmp23_ = engine;
	if (_tmp23_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp24_ = FALSE;
		i = 0;
		_tmp24_ = TRUE;
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			gint _tmp27_ = 0;
			IBusEngineDesc** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			IBusEngineDesc** _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp30_ = 0;
			IBusEngineDesc* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			IBusEngineDesc* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			_tmp25_ = _tmp24_;
			if (!_tmp25_) {
				gint _tmp26_ = 0;
				_tmp26_ = i;
				i = _tmp26_ + 1;
			}
			_tmp24_ = FALSE;
			_tmp27_ = i;
			_tmp28_ = self->priv->m_engines;
			_tmp28__length1 = self->priv->m_engines_length1;
			if (!(_tmp27_ < _tmp28__length1)) {
				break;
			}
			_tmp29_ = self->priv->m_engines;
			_tmp29__length1 = self->priv->m_engines_length1;
			_tmp30_ = i;
			_tmp31_ = _tmp29_[_tmp30_];
			_tmp32_ = ibus_engine_desc_get_name (_tmp31_);
			_tmp33_ = engine;
			_tmp34_ = ibus_engine_desc_get_name (_tmp33_);
			if (g_strcmp0 (_tmp32_, _tmp34_) == 0) {
				break;
			}
		}
	}
	_tmp35_ = i;
	if (_tmp35_ == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp36_ = i;
	_tmp37_ = self->priv->m_engines;
	_tmp37__length1 = self->priv->m_engines_length1;
	if (_tmp36_ >= _tmp37__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint j = 0;
		gint _tmp38_ = 0;
		_tmp38_ = i;
		j = _tmp38_;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				gint _tmp42_ = 0;
				IBusEngineDesc** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp44_ = 0;
				IBusEngineDesc** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				IBusEngineDesc* _tmp47_ = NULL;
				IBusEngineDesc* _tmp48_ = NULL;
				IBusEngineDesc* _tmp49_ = NULL;
				_tmp40_ = _tmp39_;
				if (!_tmp40_) {
					gint _tmp41_ = 0;
					_tmp41_ = j;
					j = _tmp41_ - 1;
				}
				_tmp39_ = FALSE;
				_tmp42_ = j;
				if (!(_tmp42_ > 0)) {
					break;
				}
				_tmp43_ = self->priv->m_engines;
				_tmp43__length1 = self->priv->m_engines_length1;
				_tmp44_ = j;
				_tmp45_ = self->priv->m_engines;
				_tmp45__length1 = self->priv->m_engines_length1;
				_tmp46_ = j;
				_tmp47_ = _tmp45_[_tmp46_ - 1];
				_tmp48_ = _g_object_ref0 (_tmp47_);
				_g_object_unref0 (_tmp43_[_tmp44_]);
				_tmp43_[_tmp44_] = _tmp48_;
				_tmp49_ = _tmp43_[_tmp44_];
			}
		}
	}
	_tmp50_ = self->priv->m_engines;
	_tmp50__length1 = self->priv->m_engines_length1;
	_tmp51_ = engine;
	_tmp52_ = _g_object_ref0 (_tmp51_);
	_g_object_unref0 (_tmp50_[0]);
	_tmp50_[0] = _tmp52_;
	_tmp53_ = _tmp50_[0];
	_tmp54_ = g_new0 (gchar*, 0 + 1);
	names = _tmp54_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp55_ = self->priv->m_engines;
	_tmp55__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp55_;
		desc_collection_length1 = _tmp55__length1;
		for (desc_it = 0; desc_it < _tmp55__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp56_ = NULL;
			IBusEngineDesc* desc = NULL;
			_tmp56_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp56_;
			{
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
				IBusEngineDesc* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				gchar* _tmp60_ = NULL;
				_tmp57_ = names;
				_tmp57__length1 = names_length1;
				_tmp58_ = desc;
				_tmp59_ = ibus_engine_desc_get_name (_tmp58_);
				_tmp60_ = g_strdup (_tmp59_);
				_vala_array_add24 (&names, &names_length1, &_names_size_, _tmp60_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp61_ = self->priv->m_settings_general;
	_tmp62_ = names;
	_tmp62__length1 = names_length1;
	g_settings_set_strv (_tmp61_, "engines-order", _tmp62_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse) {
	PanelKeybinding* self = NULL;
	guint _tmp0_ = 0U;
	GdkModifierType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	self = (PanelKeybinding*) g_type_create_instance (object_type);
	_tmp0_ = keysym;
	panel_keybinding_set_keysym (self, _tmp0_);
	_tmp1_ = modifiers;
	panel_keybinding_set_modifiers (self, _tmp1_);
	_tmp2_ = reverse;
	panel_keybinding_set_reverse (self, _tmp2_);
	return self;
}


static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse) {
	return panel_keybinding_construct (PANEL_TYPE_KEYBINDING, keysym, modifiers, reverse);
}


static guint panel_keybinding_get_keysym (PanelKeybinding* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keysym = _tmp0_;
}


static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self) {
	GdkModifierType result;
	GdkModifierType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value) {
	GdkModifierType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
}


static gboolean panel_keybinding_get_reverse (PanelKeybinding* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_reverse;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_reverse = _tmp0_;
}


static void panel_value_keybinding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void panel_value_keybinding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		panel_keybinding_unref (value->data[0].v_pointer);
	}
}


static void panel_value_keybinding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = panel_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer panel_value_keybinding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* panel_value_keybinding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PanelKeybinding* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = panel_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* panel_value_keybinding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PanelKeybinding** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = panel_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	PanelParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANEL_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer panel_value_get_keybinding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void panel_value_set_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		panel_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_value_take_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_keybinding_class_init (PanelKeybindingClass * klass) {
	panel_keybinding_parent_class = g_type_class_peek_parent (klass);
	PANEL_KEYBINDING_CLASS (klass)->finalize = panel_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (PanelKeybindingPrivate));
}


static void panel_keybinding_instance_init (PanelKeybinding * self) {
	self->priv = PANEL_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void panel_keybinding_finalize (PanelKeybinding* obj) {
	PanelKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANEL_TYPE_KEYBINDING, PanelKeybinding);
}


static GType panel_keybinding_get_type (void) {
	static volatile gsize panel_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&panel_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { panel_value_keybinding_init, panel_value_keybinding_free_value, panel_value_keybinding_copy_value, panel_value_keybinding_peek_pointer, "p", panel_value_keybinding_collect_value, "p", panel_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PanelKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PanelKeybinding), 0, (GInstanceInitFunc) panel_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType panel_keybinding_type_id;
		panel_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PanelKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&panel_keybinding_type_id__volatile, panel_keybinding_type_id);
	}
	return panel_keybinding_type_id__volatile;
}


static gpointer panel_keybinding_ref (gpointer instance) {
	PanelKeybinding* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void panel_keybinding_unref (gpointer instance) {
	PanelKeybinding* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANEL_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void panel_class_init (PanelClass * klass) {
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	IBUS_PANEL_SERVICE_CLASS (klass)->set_cursor_location = panel_real_set_cursor_location;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_in = panel_real_focus_in;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_out = panel_real_focus_out;
	IBUS_PANEL_SERVICE_CLASS (klass)->destroy_context = panel_real_destroy_context;
	IBUS_PANEL_SERVICE_CLASS (klass)->register_properties = panel_real_register_properties;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_property = panel_real_update_property;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_preedit_text = panel_real_update_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_preedit_text = panel_real_hide_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_auxiliary_text = panel_real_update_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_auxiliary_text = panel_real_hide_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_lookup_table = panel_real_update_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_lookup_table = panel_real_hide_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->state_changed = panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void panel_instance_init (Panel * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	GHashFunc _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self->priv = PANEL_GET_PRIVATE (self);
	self->priv->m_settings_general = NULL;
	self->priv->m_settings_hotkey = NULL;
	self->priv->m_settings_panel = NULL;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	self->priv->m_engine_contexts = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp4_;
	self->priv->m_use_global_engine = TRUE;
	self->priv->m_switcher_is_running = FALSE;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_use_system_keyboard_layout = FALSE;
	self->priv->m_keybindings = NULL;
}


static void panel_finalize (GObject* obj) {
	Panel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	panel_unbind_switch_shortcut (self);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_settings_general);
	_g_object_unref0 (self->priv->m_settings_hotkey);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->m_engine_contexts);
	_g_free0 (self->priv->m_current_context_path);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_property_panel);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType panel_get_type (void) {
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



