package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.11.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/azure-sdk-for-go/Godeps/_workspace/src/github.com/Azure/go-autorest/autorest"
	"github.com/Azure/azure-sdk-for-go/Godeps/_workspace/src/github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ApplicationGatewayCookieBasedAffinity enumerates the values for application
// gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled specifies the disabled state for application gateway cookie
	// based affinity.
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled specifies the enabled state for application gateway cookie
	// based affinity.
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// ApplicationGatewayOperationalState enumerates the values for application
// gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running specifies the running state for application gateway operational
	// state.
	Running ApplicationGatewayOperationalState = "Running"
	// Starting specifies the starting state for application gateway
	// operational state.
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped specifies the stopped state for application gateway operational
	// state.
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping specifies the stopping state for application gateway
	// operational state.
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// ApplicationGatewayProtocol enumerates the values for application gateway
// protocol.
type ApplicationGatewayProtocol string

const (
	// ApplicationGatewayProtocolHTTP specifies the application gateway
	// protocol http state for application gateway protocol.
	ApplicationGatewayProtocolHTTP ApplicationGatewayProtocol = "Http"
	// ApplicationGatewayProtocolHTTPS specifies the application gateway
	// protocol https state for application gateway protocol.
	ApplicationGatewayProtocolHTTPS ApplicationGatewayProtocol = "Https"
)

// ApplicationGatewayRequestRoutingRuleType enumerates the values for
// application gateway request routing rule type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic specifies the basic state for application gateway request routing
	// rule type.
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
)

// ApplicationGatewaySkuName enumerates the values for application gateway sku
// name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge specifies the standard large state for application
	// gateway sku name.
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium specifies the standard medium state for application
	// gateway sku name.
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall specifies the standard small state for application
	// gateway sku name.
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
)

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard specifies the standard state for application gateway tier.
	Standard ApplicationGatewayTier = "Standard"
)

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic specifies the dynamic state for ip allocation method.
	Dynamic IPAllocationMethod = "Dynamic"
	// Static specifies the static state for ip allocation method.
	Static IPAllocationMethod = "Static"
)

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default specifies the default state for load distribution.
	Default LoadDistribution = "Default"
	// SourceIP specifies the source ip state for load distribution.
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol specifies the source ip protocol state for load
	// distribution.
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP specifies the probe protocol http state for probe
	// protocol.
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP specifies the probe protocol tcp state for probe
	// protocol.
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// Allow specifies the allow state for security rule access.
	Allow SecurityRuleAccess = "Allow"
	// Deny specifies the deny state for security rule access.
	Deny SecurityRuleAccess = "Deny"
)

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// Inbound specifies the inbound state for security rule direction.
	Inbound SecurityRuleDirection = "Inbound"
	// Outbound specifies the outbound state for security rule direction.
	Outbound SecurityRuleDirection = "Outbound"
)

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAsterisk specifies the security rule protocol
	// asterisk state for security rule protocol.
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolTCP specifies the security rule protocol tcp state
	// for security rule protocol.
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP specifies the security rule protocol udp state
	// for security rule protocol.
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP specifies the transport protocol tcp state for
	// transport protocol.
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP specifies the transport protocol udp state for
	// transport protocol.
	TransportProtocolUDP TransportProtocol = "Udp"
)

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Count specifies the count state for usage unit.
	Count UsageUnit = "Count"
)

// VirtualNetworkGatewayConnectionType enumerates the values for virtual
// network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute specifies the express route state for virtual network
	// gateway connection type.
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec specifies the i psec state for virtual network gateway connection
	// type.
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet specifies the vnet 2 vnet state for virtual network gateway
	// connection type.
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient specifies the vpn client state for virtual network gateway
	// connection type.
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// VirtualNetworkGatewayType enumerates the values for virtual network gateway
// type.
type VirtualNetworkGatewayType string

const (
	// Vpn specifies the vpn state for virtual network gateway type.
	Vpn VirtualNetworkGatewayType = "Vpn"
)

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased specifies the policy based state for vpn type.
	PolicyBased VpnType = "PolicyBased"
	// RouteBased specifies the route based state for vpn type.
	RouteBased VpnType = "RouteBased"
)

// AddressSpace is addressSpace contains an array of IP address ranges that
// can be used by subnets
type AddressSpace struct {
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway is applicationGateways resource
type ApplicationGateway struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Tags              *map[string]*string                 `json:"tags,omitempty"`
	Properties        *ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                             `json:"etag,omitempty"`
}

// ApplicationGatewayBackendAddress is backend Address of application gateway
type ApplicationGatewayBackendAddress struct {
	Fqdn      *string `json:"fqdn,omitempty"`
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool is backend Address Pool of application
// gateway
type ApplicationGatewayBackendAddressPool struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat is properties of
// Backend Address Pool of application gateway
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]SubResource                      `json:"backendIpConfigurations,omitempty"`
	BackendAddresses        *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	ProvisioningState       *string                             `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings is backend address pool settings of
// application gateway
type ApplicationGatewayBackendHTTPSettings struct {
	ID         *string                                                `json:"id,omitempty"`
	Properties *ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                                `json:"name,omitempty"`
	Etag       *string                                                `json:"etag,omitempty"`
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat is properties of
// Backend address pool settings of application gateway
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	Port                *int                                  `json:"port,omitempty"`
	Protocol            ApplicationGatewayProtocol            `json:"protocol,omitempty"`
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	ProvisioningState   *string                               `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration is frontend IP configuration of
// application gateway
type ApplicationGatewayFrontendIPConfiguration struct {
	ID         *string                                                    `json:"id,omitempty"`
	Properties *ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                                    `json:"name,omitempty"`
	Etag       *string                                                    `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat is properties of
// Frontend IP configuration of application gateway
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort is frontend Port of application gateway
type ApplicationGatewayFrontendPort struct {
	ID         *string                                         `json:"id,omitempty"`
	Properties *ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                         `json:"name,omitempty"`
	Etag       *string                                         `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendPortPropertiesFormat is properties of Frontend
// Port of application gateway
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	Port              *int    `json:"port,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener is http listener of application gateway
type ApplicationGatewayHTTPListener struct {
	ID         *string                                         `json:"id,omitempty"`
	Properties *ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                         `json:"name,omitempty"`
	Etag       *string                                         `json:"etag,omitempty"`
}

// ApplicationGatewayHTTPListenerPropertiesFormat is properties of Http
// listener of application gateway
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	FrontendIPConfiguration *SubResource               `json:"frontendIpConfiguration,omitempty"`
	FrontendPort            *SubResource               `json:"frontendPort,omitempty"`
	Protocol                ApplicationGatewayProtocol `json:"protocol,omitempty"`
	SslCertificate          *SubResource               `json:"sslCertificate,omitempty"`
	ProvisioningState       *string                    `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration is iP configuration of application gateway
type ApplicationGatewayIPConfiguration struct {
	ID         *string                                            `json:"id,omitempty"`
	Properties *ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                            `json:"name,omitempty"`
	Etag       *string                                            `json:"etag,omitempty"`
}

// ApplicationGatewayIPConfigurationPropertiesFormat is properties of IP
// configuration of application gateway
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	Subnet            *SubResource `json:"subnet,omitempty"`
	ProvisioningState *string      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult is response for ListLoadBalancers Api service
// call
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationGateway `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ApplicationGatewayListResult) ApplicationGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ApplicationGatewayPropertiesFormat is properties of Application Gateway
type ApplicationGatewayPropertiesFormat struct {
	Sku                           *ApplicationGatewaySku                       `json:"sku,omitempty"`
	OperationalState              ApplicationGatewayOperationalState           `json:"operationalState,omitempty"`
	GatewayIPConfigurations       *[]ApplicationGatewayIPConfiguration         `json:"gatewayIpConfigurations,omitempty"`
	SslCertificates               *[]ApplicationGatewaySslCertificate          `json:"sslCertificates,omitempty"`
	FrontendIPConfigurations      *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIpConfigurations,omitempty"`
	FrontendPorts                 *[]ApplicationGatewayFrontendPort            `json:"frontendPorts,omitempty"`
	BackendAddressPools           *[]ApplicationGatewayBackendAddressPool      `json:"backendAddressPools,omitempty"`
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings     `json:"backendHttpSettingsCollection,omitempty"`
	HTTPListeners                 *[]ApplicationGatewayHTTPListener            `json:"httpListeners,omitempty"`
	RequestRoutingRules           *[]ApplicationGatewayRequestRoutingRule      `json:"requestRoutingRules,omitempty"`
	ProvisioningState             *string                                      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRequestRoutingRule is request routing rule of application
// gateway
type ApplicationGatewayRequestRoutingRule struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat is properties of
// Request routing rule of application gateway
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	RuleType            ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	BackendAddressPool  *SubResource                             `json:"backendAddressPool,omitempty"`
	BackendHTTPSettings *SubResource                             `json:"backendHttpSettings,omitempty"`
	HTTPListener        *SubResource                             `json:"httpListener,omitempty"`
	ProvisioningState   *string                                  `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySku is sKU of application gateway
type ApplicationGatewaySku struct {
	Name     ApplicationGatewaySkuName `json:"name,omitempty"`
	Tier     ApplicationGatewayTier    `json:"tier,omitempty"`
	Capacity *int                      `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate is sSL certificates of application gateway
type ApplicationGatewaySslCertificate struct {
	ID         *string                                           `json:"id,omitempty"`
	Properties *ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                           `json:"name,omitempty"`
	Etag       *string                                           `json:"etag,omitempty"`
}

// ApplicationGatewaySslCertificatePropertiesFormat is properties of SSL
// certificates of application gateway
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	Data              *string `json:"data,omitempty"`
	Password          *string `json:"password,omitempty"`
	PublicCertData    *string `json:"publicCertData,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult is the response body contains the status of the
// specified asynchronous operation, indicating whether it has succeeded, is
// inprogress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the
// asynchronous operation succeeded, the response body includes the HTTP
// status code for the successful request. If the asynchronous operation
// failed, the response body includes the HTTP status code for the failed
// request and error information regarding the failure.
type AzureAsyncOperationResult struct {
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool is pool of backend IP addresseses
type BackendAddressPool struct {
	ID         *string                             `json:"id,omitempty"`
	Properties *BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name       *string                             `json:"name,omitempty"`
	Etag       *string                             `json:"etag,omitempty"`
}

// BackendAddressPoolPropertiesFormat is properties of BackendAddressPool
type BackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]SubResource `json:"backendIPConfigurations,omitempty"`
	LoadBalancingRules      *[]SubResource `json:"loadBalancingRules,omitempty"`
	ProvisioningState       *string        `json:"provisioningState,omitempty"`
}

// ConnectionResetSharedKey is
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	Properties        *ConnectionResetSharedKeyPropertiesFormat `json:"properties,omitempty"`
}

// ConnectionResetSharedKeyPropertiesFormat is
// virtualNeworkGatewayConnectionResetSharedKey properties
type ConnectionResetSharedKeyPropertiesFormat struct {
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey is response for GetConnectionSharedKey Api servive call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// DhcpOptions is dHCPOptions contains an array of DNS servers available to
// VMs deployed in the virtual networkStandard DHCP option for a subnet
// overrides VNET DHCP options.
type DhcpOptions struct {
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult is response for CheckDnsNameAvailability Api
// servive call
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	Available         *bool `json:"available,omitempty"`
}

// Error is
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails is
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// FrontendIPConfiguration is frontend IP address of the load balancer
type FrontendIPConfiguration struct {
	ID         *string                                  `json:"id,omitempty"`
	Properties *FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                  `json:"name,omitempty"`
	Etag       *string                                  `json:"etag,omitempty"`
}

// FrontendIPConfigurationPropertiesFormat is properties of Frontend IP
// Configuration of the load balancer
type FrontendIPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	InboundNatRules           *[]SubResource     `json:"inboundNatRules,omitempty"`
	LoadBalancingRules        *[]SubResource     `json:"loadBalancingRules,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// InboundNatRule is inbound NAT rule of the loadbalancer
type InboundNatRule struct {
	ID         *string                         `json:"id,omitempty"`
	Properties *InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                         `json:"name,omitempty"`
	Etag       *string                         `json:"etag,omitempty"`
}

// InboundNatRulePropertiesFormat is properties of Inbound NAT rule
type InboundNatRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	BackendIPConfiguration  *SubResource      `json:"backendIPConfiguration,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	FrontendPort            *int              `json:"frontendPort,omitempty"`
	BackendPort             *int              `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int              `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool             `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// Interface is a NetworkInterface in a resource group
type Interface struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *InterfacePropertiesFormat `json:"properties,omitempty"`
	Etag              *string                    `json:"etag,omitempty"`
}

// InterfaceDNSSettings is dns Settings of a network interface
type InterfaceDNSSettings struct {
	DNSServers           *[]string `json:"dnsServers,omitempty"`
	AppliedDNSServers    *[]string `json:"appliedDnsServers,omitempty"`
	InternalDNSNameLabel *string   `json:"internalDnsNameLabel,omitempty"`
	InternalFqdn         *string   `json:"internalFqdn,omitempty"`
}

// InterfaceIPConfiguration is iPConfiguration in a NetworkInterface
type InterfaceIPConfiguration struct {
	ID         *string                                   `json:"id,omitempty"`
	Properties *InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                   `json:"name,omitempty"`
	Etag       *string                                   `json:"etag,omitempty"`
}

// InterfaceIPConfigurationPropertiesFormat is properties of IPConfiguration
type InterfaceIPConfigurationPropertiesFormat struct {
	PrivateIPAddress                *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod       IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                          *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress                 *SubResource       `json:"publicIPAddress,omitempty"`
	LoadBalancerBackendAddressPools *[]SubResource     `json:"loadBalancerBackendAddressPools,omitempty"`
	LoadBalancerInboundNatRules     *[]SubResource     `json:"loadBalancerInboundNatRules,omitempty"`
	ProvisioningState               *string            `json:"provisioningState,omitempty"`
}

// InterfaceListResult is response for ListNetworkInterface Api service call
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Interface `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// InterfaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InterfaceListResult) InterfaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InterfacePropertiesFormat is networkInterface properties.
type InterfacePropertiesFormat struct {
	VirtualMachine       *SubResource                `json:"virtualMachine,omitempty"`
	NetworkSecurityGroup *SubResource                `json:"networkSecurityGroup,omitempty"`
	IPConfigurations     *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	DNSSettings          *InterfaceDNSSettings       `json:"dnsSettings,omitempty"`
	MacAddress           *string                     `json:"macAddress,omitempty"`
	Primary              *bool                       `json:"primary,omitempty"`
	ProvisioningState    *string                     `json:"provisioningState,omitempty"`
}

// LoadBalancer is loadBalancer resource
type LoadBalancer struct {
	autorest.Response `json:"-"`
	ID                *string                       `json:"id,omitempty"`
	Name              *string                       `json:"name,omitempty"`
	Type              *string                       `json:"type,omitempty"`
	Location          *string                       `json:"location,omitempty"`
	Tags              *map[string]*string           `json:"tags,omitempty"`
	Properties        *LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                       `json:"etag,omitempty"`
}

// LoadBalancerListResult is response for ListLoadBalancers Api service call
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LoadBalancer `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// LoadBalancerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LoadBalancerListResult) LoadBalancerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LoadBalancerPropertiesFormat is properties of Load Balancer
type LoadBalancerPropertiesFormat struct {
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	BackendAddressPools      *[]BackendAddressPool      `json:"backendAddressPools,omitempty"`
	LoadBalancingRules       *[]LoadBalancingRule       `json:"loadBalancingRules,omitempty"`
	Probes                   *[]Probe                   `json:"probes,omitempty"`
	InboundNatRules          *[]InboundNatRule          `json:"inboundNatRules,omitempty"`
	ProvisioningState        *string                    `json:"provisioningState,omitempty"`
}

// LoadBalancingRule is rules of the load balancer
type LoadBalancingRule struct {
	ID         *string                            `json:"id,omitempty"`
	Properties *LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                            `json:"name,omitempty"`
	Etag       *string                            `json:"etag,omitempty"`
}

// LoadBalancingRulePropertiesFormat is properties of the load balancer
type LoadBalancingRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	BackendAddressPool      *SubResource      `json:"backendAddressPool,omitempty"`
	Probe                   *SubResource      `json:"probe,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	LoadDistribution        LoadDistribution  `json:"loadDistribution,omitempty"`
	FrontendPort            *int              `json:"frontendPort,omitempty"`
	BackendPort             *int              `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int              `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool             `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway is a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                              `json:"etag,omitempty"`
}

// LocalNetworkGatewayListResult is response for ListLocalNetworkGateways Api
// service call
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LocalNetworkGateway `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LocalNetworkGatewayListResult) LocalNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LocalNetworkGatewayPropertiesFormat is localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	GatewayIPAddress         *string       `json:"gatewayIpAddress,omitempty"`
	ProvisioningState        *string       `json:"provisioningState,omitempty"`
}

// Probe is load balancer Probe
type Probe struct {
	ID         *string                `json:"id,omitempty"`
	Properties *ProbePropertiesFormat `json:"properties,omitempty"`
	Name       *string                `json:"name,omitempty"`
	Etag       *string                `json:"etag,omitempty"`
}

// ProbePropertiesFormat is
type ProbePropertiesFormat struct {
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	Protocol           ProbeProtocol  `json:"protocol,omitempty"`
	Port               *int           `json:"port,omitempty"`
	IntervalInSeconds  *int           `json:"intervalInSeconds,omitempty"`
	NumberOfProbes     *int           `json:"numberOfProbes,omitempty"`
	RequestPath        *string        `json:"requestPath,omitempty"`
	ProvisioningState  *string        `json:"provisioningState,omitempty"`
}

// PublicIPAddress is publicIPAddress resource
type PublicIPAddress struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Tags              *map[string]*string              `json:"tags,omitempty"`
	Properties        *PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                          `json:"etag,omitempty"`
}

// PublicIPAddressDNSSettings is contains FQDN of the DNS record associated
// with the public IP address
type PublicIPAddressDNSSettings struct {
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	Fqdn            *string `json:"fqdn,omitempty"`
	ReverseFqdn     *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressListResult is response for ListPublicIpAddresses Api service
// call
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PublicIPAddress `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PublicIPAddressListResult) PublicIPAddressListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PublicIPAddressPropertiesFormat is publicIpAddress properties
type PublicIPAddressPropertiesFormat struct {
	PublicIPAllocationMethod IPAllocationMethod          `json:"publicIPAllocationMethod,omitempty"`
	IPConfiguration          *SubResource                `json:"ipConfiguration,omitempty"`
	DNSSettings              *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress                *string                     `json:"ipAddress,omitempty"`
	IdleTimeoutInMinutes     *int                        `json:"idleTimeoutInMinutes,omitempty"`
	ProvisioningState        *string                     `json:"provisioningState,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SecurityGroup is networkSecurityGroup resource
type SecurityGroup struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Type              *string                        `json:"type,omitempty"`
	Location          *string                        `json:"location,omitempty"`
	Tags              *map[string]*string            `json:"tags,omitempty"`
	Properties        *SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                        `json:"etag,omitempty"`
}

// SecurityGroupListResult is response for ListNetworkSecurityGroups Api
// servive call
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityGroup `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// SecurityGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityGroupListResult) SecurityGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityGroupPropertiesFormat is network Security Group resource
type SecurityGroupPropertiesFormat struct {
	SecurityRules        *[]SecurityRule `json:"securityRules,omitempty"`
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	NetworkInterfaces    *[]SubResource  `json:"networkInterfaces,omitempty"`
	Subnets              *[]SubResource  `json:"subnets,omitempty"`
	ProvisioningState    *string         `json:"provisioningState,omitempty"`
}

// SecurityRule is network security rule
type SecurityRule struct {
	autorest.Response `json:"-"`
	ID                *string                       `json:"id,omitempty"`
	Properties        *SecurityRulePropertiesFormat `json:"properties,omitempty"`
	Name              *string                       `json:"name,omitempty"`
	Etag              *string                       `json:"etag,omitempty"`
}

// SecurityRuleListResult is response for ListSecurityRule Api service
// callRetrieves all security rules that belongs to a network security group
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityRule `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// SecurityRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityRuleListResult) SecurityRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityRulePropertiesFormat is
type SecurityRulePropertiesFormat struct {
	Description              *string               `json:"description,omitempty"`
	Protocol                 SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange          *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange     *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix      *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix *string               `json:"destinationAddressPrefix,omitempty"`
	Access                   SecurityRuleAccess    `json:"access,omitempty"`
	Priority                 *int                  `json:"priority,omitempty"`
	Direction                SecurityRuleDirection `json:"direction,omitempty"`
	ProvisioningState        *string               `json:"provisioningState,omitempty"`
}

// Subnet is subnet in a VirtualNework resource
type Subnet struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Properties        *SubnetPropertiesFormat `json:"properties,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Etag              *string                 `json:"etag,omitempty"`
}

// SubnetListResult is response for ListSubnets Api service callRetrieves all
// subnet that belongs to a virtual network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Subnet `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// SubnetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SubnetListResult) SubnetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SubnetPropertiesFormat is
type SubnetPropertiesFormat struct {
	AddressPrefix        *string        `json:"addressPrefix,omitempty"`
	NetworkSecurityGroup *SubResource   `json:"networkSecurityGroup,omitempty"`
	IPConfigurations     *[]SubResource `json:"ipConfigurations,omitempty"`
	ProvisioningState    *string        `json:"provisioningState,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// Usage is describes Network Resource Usage.
type Usage struct {
	Unit         UsageUnit  `json:"unit,omitempty"`
	CurrentValue *int       `json:"currentValue,omitempty"`
	Limit        *int32     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageName is the Usage Names.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult is the List Usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
}

// VirtualNetwork is virtual Network resource
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	ID                *string                         `json:"id,omitempty"`
	Name              *string                         `json:"name,omitempty"`
	Type              *string                         `json:"type,omitempty"`
	Location          *string                         `json:"location,omitempty"`
	Tags              *map[string]*string             `json:"tags,omitempty"`
	Properties        *VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                         `json:"etag,omitempty"`
}

// VirtualNetworkGateway is a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response `json:"-"`
	ID                *string                                `json:"id,omitempty"`
	Name              *string                                `json:"name,omitempty"`
	Type              *string                                `json:"type,omitempty"`
	Location          *string                                `json:"location,omitempty"`
	Tags              *map[string]*string                    `json:"tags,omitempty"`
	Properties        *VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                                `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnection is a common class for general resource
// information
type VirtualNetworkGatewayConnection struct {
	autorest.Response `json:"-"`
	ID                *string                                          `json:"id,omitempty"`
	Name              *string                                          `json:"name,omitempty"`
	Type              *string                                          `json:"type,omitempty"`
	Location          *string                                          `json:"location,omitempty"`
	Tags              *map[string]*string                              `json:"tags,omitempty"`
	Properties        *VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                                          `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnectionListResult is response for
// ListVirtualNetworkGatewayConnections Api service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	NextLink          *string                            `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayConnectionListResult) VirtualNetworkGatewayConnectionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayConnectionPropertiesFormat is
// virtualNeworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	VirtualNetworkGateway1 *VirtualNetworkGateway              `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2 *VirtualNetworkGateway              `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2   *LocalNetworkGateway                `json:"localNetworkGateway2,omitempty"`
	ConnectionType         VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	RoutingWeight          *int                                `json:"routingWeight,omitempty"`
	SharedKey              *string                             `json:"sharedKey,omitempty"`
	ProvisioningState      *string                             `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayIPConfiguration is ipConfiguration for Virtual network
// gateway
type VirtualNetworkGatewayIPConfiguration struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat is properties of
// VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult is response for ListVirtualNetworkGateways
// Api service call
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGateway `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayListResult) VirtualNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayPropertiesFormat is virtualNeworkGateay properties
type VirtualNetworkGatewayPropertiesFormat struct {
	IPConfigurations  *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	GatewayType       VirtualNetworkGatewayType               `json:"gatewayType,omitempty"`
	VpnType           VpnType                                 `json:"vpnType,omitempty"`
	EnableBgp         *bool                                   `json:"enableBgp,omitempty"`
	ProvisioningState *string                                 `json:"provisioningState,omitempty"`
}

// VirtualNetworkListResult is response for ListVirtualNetworks Api servive
// call
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkListResult) VirtualNetworkListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkPropertiesFormat is
type VirtualNetworkPropertiesFormat struct {
	AddressSpace      *AddressSpace `json:"addressSpace,omitempty"`
	DhcpOptions       *DhcpOptions  `json:"dhcpOptions,omitempty"`
	Subnets           *[]Subnet     `json:"subnets,omitempty"`
	ProvisioningState *string       `json:"provisioningState,omitempty"`
}
