/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libcdr
 * Version: MPL 1.1 / GPLv2+ / LGPLv2+
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License or as specified alternatively below. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Major Contributor(s):
 * Copyright (C) 2012 Fridrich Strba <fridrich.strba@bluewin.ch>
 *
 * All Rights Reserved.
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPLv2+"), or
 * the GNU Lesser General Public License Version 2 or later (the "LGPLv2+"),
 * in which case the provisions of the GPLv2+ or the LGPLv2+ are applicable
 * instead of those above.
 */

/* These palettes are necessary to be able to convert the colours from CorelDraw internal palettes,
 * since CorelDraw does include in the file only identifier of the palette, index of the palette
 * and intensity of the colour.
 * These palettes were obtained by clean-room reverse-engineering where a CorelDraw user was
 * inspecting the *.cpl files and dumping into a spreadsheet the CMYK, RGB or L*a*b decomposition.
 * The software engineer created these palettes from the information in that spreadsheet using only
 * the information strictly needed in order to be able to convert a document using these palettes.
 * No copyrighted colour names were used, so that these palettes cannot be used to generate colour
 * bridges, only to convert an indexed colour to CMYK, RGB or L*a*b. The names of the original
 * palettes are only used in comment in order to make debugging of potential mis-conversions easier.
 */

#ifndef __CDRCOLORPALETTES_H__
#define __CDRCOLORPALETTES_H__

// Pantone something corel8

static const unsigned char palette_19_03_C[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x14, 0x0F, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x14, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x14, 0x0F,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14,
  0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x0F, 0x0A, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x0F, 0x0A, 0x05, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x05, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x14, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x19, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x19, 0x14,
  0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x19, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x05, 0x03,
  0x03, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x05, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x28, 0x28, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E, 0x1E, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E, 0x1E, 0x28, 0x28, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E,
  0x1E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
  0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05,
  0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05,
  0x03, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A,
  0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x32, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19,
  0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x5A, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41,
  0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x64,
  0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19,
  0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x19, 0x0F, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C,
  0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50,
  0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23,
  0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x5A, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64,
  0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x0A, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x55, 0x46,
  0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64,
  0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F,
  0x05, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28,
  0x1E, 0x14, 0x0A, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50,
  0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64,
  0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A,
  0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E,
  0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32,
  0x32, 0x1E, 0x19, 0x0F, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64,
  0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F,
  0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28,
  0x19, 0x0F, 0x03, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x64,
  0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F,
  0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E,
  0x19, 0x0F, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x64, 0x5F,
  0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64,
  0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14,
  0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23,
  0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x5A, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64,
  0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D,
  0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50,
  0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23,
  0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23,
  0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37,
  0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x5A, 0x4B, 0x41,
  0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A,
  0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14,
  0x0A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x1E, 0x19, 0x14, 0x05, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03,
  0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14,
  0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A,
  0x05, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03,
  0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x32, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x23,
  0x1E, 0x1E, 0x32, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E, 0x32, 0x2D, 0x28, 0x28, 0x28,
  0x28, 0x23, 0x1E, 0x1E, 0x14, 0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14, 0x0F, 0x0F,
  0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14, 0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14,
  0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x32, 0x2D, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E,
  0x1E, 0x32, 0x2D, 0x28, 0x28, 0x28, 0x23, 0x1E, 0x1E, 0x1E, 0x32, 0x2D, 0x28, 0x28, 0x28, 0x23,
  0x1E, 0x1E, 0x1E, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x46, 0x3C, 0x32, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x28, 0x28, 0x28, 0x28, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x28, 0x28, 0x28, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x32, 0x32,
  0x32, 0x32, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x32, 0x32, 0x32, 0x32, 0x5A, 0x50, 0x46, 0x3C, 0x32,
  0x32, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x05, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0A, 0x05, 0x05, 0x03, 0x00, 0x03, 0x0A, 0x0F, 0x05, 0x03, 0x05, 0x0A,
  0x0A, 0x0F, 0x0F, 0x0A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x0A, 0x0F, 0x0A, 0x0F
};

static const unsigned char palette_19_03_M[] =
{
  0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14, 0x0F, 0x0F,
  0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14, 0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x14,
  0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x05, 0x03, 0x03, 0x1E, 0x19, 0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x05,
  0x03, 0x1E, 0x19, 0x14, 0x14, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x1E, 0x19, 0x14, 0x14, 0x0F, 0x0A,
  0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x05, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x05, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x05, 0x28, 0x28,
  0x23, 0x1E, 0x23, 0x1E, 0x19, 0x19, 0x0F, 0x28, 0x28, 0x23, 0x1E, 0x23, 0x1E, 0x19, 0x19, 0x0F,
  0x28, 0x28, 0x23, 0x1E, 0x23, 0x1E, 0x19, 0x19, 0x0F, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A,
  0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x03, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x32, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x46,
  0x3C, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x14,
  0x0F, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x14, 0x0F, 0x0A, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x0A, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x1E, 0x14, 0x0F, 0x0A, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14,
  0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x03, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x1E, 0x14, 0x0F, 0x03, 0x4B, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0A, 0x4B, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x14, 0x0A, 0x4B, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0A, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14,
  0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x05, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x19, 0x14, 0x05, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37,
  0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x4B,
  0x41, 0x37, 0x2D, 0x23, 0x1E, 0x14, 0x0A, 0x5A, 0x50, 0x46, 0x41, 0x3C, 0x37, 0x32, 0x2D, 0x23,
  0x5A, 0x50, 0x46, 0x41, 0x3C, 0x37, 0x32, 0x2D, 0x23, 0x5A, 0x50, 0x46, 0x41, 0x3C, 0x37, 0x32,
  0x2D, 0x23, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x14, 0x0A, 0x05, 0x5A, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x14, 0x0A, 0x05, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x14, 0x0A, 0x05, 0x5A, 0x4B, 0x41,
  0x37, 0x2D, 0x23, 0x19, 0x0F, 0x0A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x0A, 0x5A,
  0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x0A, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19,
  0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41,
  0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55,
  0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x14,
  0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23,
  0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x1E, 0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37,
  0x2D, 0x1E, 0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x1E, 0x19, 0x14, 0x64, 0x50, 0x46,
  0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64,
  0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x64, 0x50, 0x46, 0x3C, 0x37, 0x32, 0x2D, 0x28,
  0x23, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D,
  0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x0F, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x0F, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x0F,
  0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28,
  0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x64, 0x5A, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x1E, 0x14, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x1E,
  0x14, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x1E, 0x14, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55,
  0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F,
  0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F,
  0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23,
  0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55,
  0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A,
  0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23,
  0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x55, 0x50, 0x46,
  0x46, 0x3C, 0x3C, 0x32, 0x64, 0x64, 0x55, 0x50, 0x46, 0x46, 0x3C, 0x3C, 0x32, 0x64, 0x64, 0x55,
  0x50, 0x46, 0x46, 0x3C, 0x3C, 0x32, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x64,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x19, 0x64, 0x50, 0x41, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x50, 0x41, 0x3C, 0x32, 0x23,
  0x19, 0x0F, 0x05, 0x64, 0x50, 0x41, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x64, 0x64, 0x4B,
  0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64,
  0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F,
  0x64, 0x64, 0x4B, 0x32, 0x32, 0x23, 0x14, 0x0F, 0x05, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x23, 0x14,
  0x0F, 0x05, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x23, 0x14, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32,
  0x28, 0x19, 0x0F, 0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x64, 0x55, 0x46,
  0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x64,
  0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19,
  0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32, 0x1E, 0x19, 0x0F, 0x64, 0x64, 0x64, 0x4B, 0x32, 0x32,
  0x1E, 0x19, 0x0F, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50,
  0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64,
  0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05,
  0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19,
  0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19,
  0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x19, 0x0F, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E,
  0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19,
  0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x19, 0x0F, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B, 0x41, 0x37,
  0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B,
  0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x46, 0x41, 0x3C, 0x32, 0x28,
  0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x55,
  0x46, 0x3C, 0x32, 0x23, 0x19, 0x14, 0x0F, 0x0A, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x14, 0x0F,
  0x0A, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x32, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x4B, 0x41, 0x32, 0x23, 0x19, 0x14, 0x0A, 0x05, 0x03, 0x4B, 0x41, 0x32, 0x23, 0x19,
  0x14, 0x0A, 0x05, 0x03, 0x4B, 0x41, 0x32, 0x23, 0x19, 0x14, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x03, 0x32, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x32, 0x1E, 0x19, 0x14, 0x0F, 0x0A,
  0x0A, 0x05, 0x03, 0x32, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03,
  0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03,
  0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A,
  0x05, 0x03, 0x05, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x03, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x19, 0x14, 0x19, 0x1E, 0x1E, 0x14,
  0x0F, 0x0F, 0x1E, 0x19, 0x14, 0x19, 0x1E, 0x1E, 0x14, 0x0F, 0x0F, 0x1E, 0x19, 0x14, 0x19, 0x1E,
  0x1E, 0x14, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x23, 0x1E, 0x23, 0x23, 0x1E, 0x14, 0x14,
  0x14, 0x28, 0x23, 0x1E, 0x23, 0x23, 0x1E, 0x14, 0x14, 0x14, 0x28, 0x23, 0x1E, 0x23, 0x23, 0x1E,
  0x14, 0x14, 0x14, 0x50, 0x50, 0x50, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x50, 0x50, 0x50, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x23, 0x50, 0x50, 0x50, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x5A, 0x5A,
  0x5A, 0x5A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x4B, 0x41, 0x37, 0x2D,
  0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x4B, 0x41, 0x37, 0x2D, 0x64, 0x64, 0x64, 0x64, 0x64, 0x55, 0x4B,
  0x41, 0x37, 0x64, 0x64, 0x64, 0x64, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x55, 0x4B, 0x41, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x41, 0x37,
  0x2D, 0x23, 0x19, 0x0F, 0x0A, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x03, 0x05, 0x0A, 0x05, 0x03, 0x00, 0x03, 0x03, 0x0F, 0x0A, 0x0A, 0x0F, 0x0A, 0x0A,
  0x0F, 0x0F, 0x0A, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x03, 0x05, 0x0A, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char palette_19_03_Y[] =
{
  0x64, 0x64, 0x64, 0x55, 0x46, 0x37, 0x28, 0x19, 0x0A, 0x64, 0x64, 0x64, 0x55, 0x46, 0x37, 0x28,
  0x19, 0x0A, 0x64, 0x64, 0x64, 0x55, 0x46, 0x37, 0x28, 0x19, 0x0A, 0x64, 0x64, 0x64, 0x55, 0x46,
  0x37, 0x28, 0x19, 0x0A, 0x64, 0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x64, 0x4B,
  0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64,
  0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x50, 0x41, 0x64, 0x4B, 0x32, 0x23, 0x14,
  0x0A, 0x64, 0x50, 0x41, 0x64, 0x4B, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x50, 0x41, 0x64, 0x4B, 0x32,
  0x23, 0x14, 0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x14, 0x0F, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x23, 0x1E, 0x14, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x14, 0x0F, 0x50, 0x64,
  0x55, 0x46, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x50, 0x64, 0x55, 0x46, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x50, 0x64, 0x55, 0x46, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23,
  0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41,
  0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x55, 0x46,
  0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64,
  0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F,
  0x05, 0x64, 0x50, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x64, 0x50, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x23, 0x19, 0x64, 0x50, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46,
  0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64,
  0x64, 0x55, 0x46, 0x3C, 0x3C, 0x32, 0x23, 0x19, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x3C, 0x32, 0x23,
  0x14, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x3C, 0x32, 0x23, 0x14, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28,
  0x1E, 0x14, 0x0F, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0F, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x0F, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x64, 0x64,
  0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E,
  0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x1E, 0x14, 0x03, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x0F, 0x64, 0x5A, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x0F, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x0F, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19,
  0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23,
  0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x64, 0x50, 0x46, 0x46, 0x3C, 0x3C, 0x32, 0x28,
  0x64, 0x64, 0x50, 0x46, 0x46, 0x3C, 0x3C, 0x32, 0x28, 0x64, 0x64, 0x50, 0x46, 0x46, 0x3C, 0x3C,
  0x32, 0x28, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0A, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x19, 0x0A, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0A, 0x05, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19,
  0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D,
  0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41,
  0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55,
  0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x19,
  0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x1E, 0x19, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23,
  0x1E, 0x19, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x1E, 0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37,
  0x2D, 0x1E, 0x19, 0x14, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x1E, 0x19, 0x14, 0x5A, 0x4B, 0x41,
  0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A,
  0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23,
  0x19, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x0A, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x0A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x19, 0x14, 0x0A,
  0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28,
  0x23, 0x1E, 0x14, 0x0F, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x1E, 0x19, 0x14, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x1E, 0x1E, 0x19, 0x14, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x1E, 0x19, 0x14, 0x46,
  0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x14, 0x0F, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x14,
  0x0F, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x14, 0x0F, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A,
  0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03,
  0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A,
  0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x32, 0x28, 0x23, 0x28, 0x1E,
  0x23, 0x19, 0x1E, 0x19, 0x32, 0x28, 0x23, 0x28, 0x1E, 0x23, 0x19, 0x1E, 0x19, 0x32, 0x28, 0x23,
  0x28, 0x1E, 0x23, 0x19, 0x1E, 0x19, 0x3C, 0x32, 0x28, 0x28, 0x23, 0x19, 0x14, 0x14, 0x0F, 0x3C,
  0x32, 0x28, 0x28, 0x23, 0x19, 0x14, 0x14, 0x0F, 0x3C, 0x32, 0x28, 0x28, 0x23, 0x19, 0x14, 0x14,
  0x0F, 0x1E, 0x19, 0x14, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x1E, 0x19, 0x14, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x03, 0x1E, 0x19, 0x14, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F,
  0x05, 0x0A, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x05, 0x0A, 0x03, 0x05, 0x03, 0x14, 0x0F,
  0x0A, 0x0F, 0x05, 0x0A, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x05, 0x0A, 0x03, 0x05, 0x03,
  0x0A, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x05, 0x03, 0x0A, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05,
  0x05, 0x03, 0x0A, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
  0x1E, 0x1E, 0x19, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x23, 0x1E, 0x1E, 0x19, 0x0F, 0x0A, 0x0A, 0x0A,
  0x05, 0x23, 0x1E, 0x1E, 0x19, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x14, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x03, 0x03, 0x0F, 0x14, 0x0F, 0x0A, 0x0A,
  0x0A, 0x05, 0x03, 0x03, 0x0F, 0x14, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x03, 0x05, 0x05, 0x05, 0x03, 0x05, 0x03, 0x03, 0x05, 0x03, 0x05, 0x05, 0x05, 0x03,
  0x05, 0x03, 0x03, 0x05, 0x03, 0x05, 0x05, 0x05, 0x03, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x14, 0x0F,
  0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03,
  0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03, 0x05, 0x03, 0x14, 0x0F, 0x0A, 0x0F, 0x0A, 0x05, 0x03,
  0x05, 0x03, 0x1E, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x1E, 0x19, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x0F, 0x0A, 0x1E, 0x19, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0F, 0x0A, 0x23, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x23, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F,
  0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x03, 0x28, 0x23, 0x1E, 0x19,
  0x14, 0x0F, 0x0A, 0x05, 0x03, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28,
  0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05,
  0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x05, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14,
  0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E,
  0x19, 0x14, 0x0F, 0x0A, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x46, 0x41, 0x3C,
  0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46,
  0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14, 0x0F, 0x46, 0x41, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x14,
  0x0F, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x1E, 0x19, 0x14, 0x50, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x1E, 0x19, 0x14, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B,
  0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19,
  0x5A, 0x4B, 0x41, 0x37, 0x32, 0x2D, 0x28, 0x23, 0x19, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23,
  0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37,
  0x2D, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x2D, 0x23, 0x19, 0x0F, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14,
  0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23,
  0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C,
  0x32, 0x23, 0x1E, 0x19, 0x05, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50,
  0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03,
  0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x03, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23,
  0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32,
  0x28, 0x23, 0x19, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x19, 0x0F, 0x64, 0x50, 0x46,
  0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14, 0x0A, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x1E, 0x14,
  0x0A, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23,
  0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x23, 0x19, 0x0F, 0x05, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64,
  0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A,
  0x64, 0x64, 0x5F, 0x50, 0x41, 0x32, 0x23, 0x14, 0x0A, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x2D,
  0x23, 0x1E, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x2D, 0x23, 0x1E, 0x64, 0x64, 0x64, 0x50, 0x46,
  0x3C, 0x2D, 0x23, 0x1E, 0x64, 0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x64, 0x4B,
  0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64,
  0x64, 0x4B, 0x64, 0x32, 0x32, 0x19, 0x1E, 0x0F, 0x64, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28,
  0x23, 0x64, 0x64, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x23, 0x64, 0x64, 0x64, 0x55, 0x46, 0x3C,
  0x32, 0x28, 0x23, 0x64, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x64, 0x64, 0x64, 0x64,
  0x50, 0x46, 0x3C, 0x32, 0x28, 0x64, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x46, 0x3C, 0x32, 0x64, 0x64, 0x64, 0x64, 0x64, 0x55, 0x4B,
  0x41, 0x37, 0x64, 0x64, 0x64, 0x64, 0x64, 0x55, 0x4B, 0x41, 0x37, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x55, 0x4B, 0x41, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x41, 0x37,
  0x2D, 0x23, 0x1E, 0x14, 0x0F, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x1E, 0x19, 0x14, 0x0F, 0x0A, 0x0A, 0x05,
  0x03, 0x03, 0x03, 0x05, 0x0F, 0x0A, 0x05, 0x03, 0x0A, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x03, 0x05,
  0x0A, 0x0F, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x03, 0x05,
  0x03, 0x03, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0A, 0x05, 0x0A, 0x0F, 0x0F, 0x0A, 0x0A
};

static const unsigned char palette_19_03_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03,
  0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A,
  0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28,
  0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19,
  0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E,
  0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05,
  0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19,
  0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03,
  0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03,
  0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23,
  0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14,
  0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E,
  0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F,
  0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E,
  0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14,
  0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03,
  0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05,
  0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F,
  0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E,
  0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19,
  0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23,
  0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E,
  0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14,
  0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03,
  0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23,
  0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03,
  0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23,
  0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03,
  0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05,
  0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23,
  0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14,
  0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05,
  0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F,
  0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03,
  0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19,
  0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14,
  0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03,
  0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E,
  0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F,
  0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03,
  0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19,
  0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03,
  0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19,
  0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F,
  0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14,
  0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28, 0x23, 0x23, 0x1E,
  0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A,
  0x28, 0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19,
  0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A,
  0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x28,
  0x23, 0x23, 0x1E, 0x1E, 0x19, 0x19, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19,
  0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A,
  0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05,
  0x1E, 0x1E, 0x1E, 0x19, 0x19, 0x19, 0x14, 0x14, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0A, 0x0A, 0x0A, 0x05, 0x05, 0x05, 0x1E, 0x1E, 0x1E, 0x19, 0x19,
  0x19, 0x14, 0x14, 0x0F, 0x64, 0x55, 0x46, 0x3C, 0x32, 0x28, 0x19, 0x0F, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x1E, 0x64,
  0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x28, 0x1E, 0x64, 0x5A, 0x50, 0x46, 0x3C, 0x32, 0x28, 0x28,
  0x1E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14
};

// FOCOLTONE

static const unsigned char palette_19_08_C[] =
{
  0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x14, 0x14,
  0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x00,
  0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x00, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28,
  0x00, 0x28, 0x00, 0x00, 0x28, 0x28, 0x00, 0x00, 0x32, 0x32, 0x32, 0x00, 0x32, 0x32, 0x00, 0x32,
  0x00, 0x00, 0x32, 0x32, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00,
  0x64, 0x64, 0x00, 0x00, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x14, 0x14, 0x00, 0x14, 0x00, 0x14, 0x1e, 0x1e,
  0x00, 0x1e, 0x00, 0x1e, 0x28, 0x28, 0x00, 0x28, 0x00, 0x28, 0x32, 0x32, 0x00, 0x32, 0x00, 0x32,
  0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x1e, 0x1e, 0x1e, 0x00,
  0x1e, 0x00, 0x28, 0x28, 0x28, 0x00, 0x28, 0x00, 0x32, 0x32, 0x32, 0x00, 0x32, 0x00, 0x19, 0x19,
  0x19, 0x00, 0x19, 0x19, 0x00, 0x19, 0x00, 0x00, 0x19, 0x19, 0x00, 0x00, 0x2d, 0x2d, 0x2d, 0x00,
  0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x00, 0x2d, 0x2d, 0x00, 0x00, 0x37, 0x37, 0x37, 0x00, 0x37, 0x37,
  0x00, 0x37, 0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0x41, 0x41, 0x41, 0x00, 0x41, 0x41, 0x00, 0x41,
  0x00, 0x00, 0x41, 0x41, 0x00, 0x00, 0x46, 0x46, 0x46, 0x00, 0x46, 0x46, 0x00, 0x46, 0x00, 0x00,
  0x46, 0x46, 0x00, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x19, 0x19, 0x00, 0x19, 0x00, 0x19, 0x2d,
  0x2d, 0x00, 0x2d, 0x00, 0x2d, 0x37, 0x37, 0x00, 0x37, 0x00, 0x37, 0x41, 0x41, 0x00, 0x41, 0x00,
  0x41, 0x46, 0x46, 0x00, 0x46, 0x00, 0x46, 0x19, 0x19, 0x19, 0x00, 0x19, 0x00, 0x2d, 0x2d, 0x2d,
  0x00, 0x2d, 0x00, 0x37, 0x37, 0x37, 0x00, 0x37, 0x00, 0x41, 0x41, 0x41, 0x00, 0x41, 0x00, 0x46,
  0x46, 0x46, 0x00, 0x46, 0x00, 0x23, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00, 0x23, 0x00, 0x00, 0x23,
  0x23, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x3c, 0x00,
  0x00, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x4b, 0x4b, 0x00, 0x00, 0x50,
  0x50, 0x50, 0x00, 0x50, 0x50, 0x00, 0x50, 0x00, 0x00, 0x50, 0x50, 0x00, 0x00, 0x55, 0x55, 0x55,
  0x00, 0x55, 0x55, 0x00, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64,
  0x00, 0x00, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x23, 0x23, 0x00, 0x23, 0x00, 0x23, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x4b, 0x4b, 0x00, 0x4b,
  0x00, 0x4b, 0x50, 0x50, 0x00, 0x50, 0x00, 0x50, 0x55, 0x55, 0x00, 0x55, 0x00, 0x55, 0x23, 0x23,
  0x23, 0x00, 0x23, 0x00, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x00,
  0x50, 0x50, 0x50, 0x00, 0x50, 0x00, 0x55, 0x55, 0x55, 0x00, 0x55, 0x00, 0x05, 0x05, 0x05, 0x00,
  0x05, 0x05, 0x00, 0x05, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x0a, 0x0a,
  0x00, 0x0a, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, 0x0f,
  0x00, 0x00, 0x0f, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x14, 0x19, 0x19,
  0x19, 0x00, 0x19, 0x19, 0x00, 0x19, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e,
  0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x1e, 0x23, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00, 0x23,
  0x00, 0x00, 0x23, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x00, 0x00, 0x28, 0x2d, 0x2d,
  0x2d, 0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x00, 0x2d, 0x32, 0x32, 0x32, 0x00, 0x32, 0x32, 0x00,
  0x32, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x37, 0x37, 0x37, 0x00, 0x37, 0x37, 0x00, 0x37, 0x00,
  0x00, 0x37, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x41, 0x41, 0x41,
  0x00, 0x41, 0x41, 0x00, 0x41, 0x00, 0x00, 0x41, 0x46, 0x46, 0x46, 0x00, 0x46, 0x46, 0x00, 0x46,
  0x00, 0x00, 0x46, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x4b, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64,
  0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64,
  0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00,
  0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x64,
  0x00, 0x00, 0x64, 0x64, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00
};

static const unsigned char palette_19_08_M[] =
{
  0x1e, 0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x1e, 0x00, 0x28, 0x28,
  0x00, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x00, 0x00, 0x28, 0x00, 0x32, 0x32, 0x00, 0x32,
  0x32, 0x00, 0x32, 0x32, 0x00, 0x32, 0x00, 0x00, 0x32, 0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00,
  0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14,
  0x00, 0x14, 0x00, 0x00, 0x14, 0x00, 0x00, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x28, 0x28, 0x00, 0x28, 0x00, 0x28,
  0x32, 0x32, 0x00, 0x32, 0x00, 0x32, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x14, 0x14, 0x00, 0x14,
  0x00, 0x14, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x28, 0x28, 0x00, 0x28, 0x00, 0x28, 0x32, 0x32, 0x00, 0x32,
  0x00, 0x32, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x14, 0x14, 0x00, 0x14, 0x00, 0x14, 0x2d, 0x2d,
  0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x00, 0x2d, 0x00, 0x37, 0x37, 0x00, 0x37,
  0x37, 0x00, 0x37, 0x37, 0x00, 0x37, 0x00, 0x00, 0x37, 0x00, 0x41, 0x41, 0x00, 0x41, 0x41, 0x00,
  0x41, 0x41, 0x00, 0x41, 0x00, 0x00, 0x41, 0x00, 0x46, 0x46, 0x00, 0x46, 0x46, 0x00, 0x46, 0x46,
  0x00, 0x46, 0x00, 0x00, 0x46, 0x00, 0x19, 0x19, 0x00, 0x19, 0x19, 0x00, 0x19, 0x19, 0x00, 0x19,
  0x00, 0x00, 0x19, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x00,
  0x2d, 0x37, 0x37, 0x00, 0x37, 0x00, 0x37, 0x41, 0x41, 0x00, 0x41, 0x00, 0x41, 0x46, 0x46, 0x00,
  0x46, 0x00, 0x46, 0x19, 0x19, 0x00, 0x19, 0x00, 0x19, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x2d, 0x37, 0x37, 0x00,
  0x37, 0x00, 0x37, 0x41, 0x41, 0x00, 0x41, 0x00, 0x37, 0x46, 0x46, 0x00, 0x46, 0x00, 0x46, 0x19,
  0x19, 0x00, 0x19, 0x00, 0x19, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00,
  0x00, 0x4b, 0x00, 0x50, 0x50, 0x00, 0x50, 0x50, 0x00, 0x50, 0x50, 0x00, 0x50, 0x00, 0x00, 0x50,
  0x00, 0x55, 0x55, 0x00, 0x55, 0x55, 0x00, 0x55, 0x55, 0x00, 0x55, 0x00, 0x00, 0x55, 0x00, 0x23,
  0x23, 0x00, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00, 0x23, 0x00, 0x00, 0x23, 0x00, 0x3c, 0x3c, 0x00,
  0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x4b, 0x50, 0x50, 0x00, 0x50, 0x00, 0x50, 0x55, 0x55,
  0x00, 0x55, 0x00, 0x55, 0x23, 0x23, 0x00, 0x23, 0x00, 0x23, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x4b, 0x4b,
  0x00, 0x4b, 0x00, 0x4b, 0x50, 0x50, 0x00, 0x50, 0x00, 0x50, 0x55, 0x55, 0x00, 0x55, 0x00, 0x55,
  0x23, 0x23, 0x00, 0x23, 0x00, 0x23, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x05, 0x05, 0x00, 0x05,
  0x05, 0x00, 0x05, 0x05, 0x00, 0x05, 0x00, 0x00, 0x05, 0x00, 0x0a, 0x0a, 0x00, 0x0a, 0x0a, 0x00,
  0x0a, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x0f,
  0x00, 0x0f, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x00, 0x19, 0x19,
  0x00, 0x19, 0x19, 0x00, 0x19, 0x19, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x00,
  0x1e, 0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00, 0x23, 0x23,
  0x00, 0x23, 0x00, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x00, 0x2d, 0x2d,
  0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x32, 0x32, 0x00, 0x32, 0x32, 0x00, 0x32,
  0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x00, 0x37, 0x37, 0x00, 0x37, 0x37, 0x00,
  0x37, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x41, 0x41, 0x00,
  0x41, 0x41, 0x00, 0x41, 0x41, 0x00, 0x41, 0x00, 0x46, 0x46, 0x00, 0x46, 0x46, 0x00, 0x46, 0x46,
  0x00, 0x46, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64, 0x00, 0x64
};

static const unsigned char palette_19_08_Y[] =
{
  0x32, 0x32, 0x32, 0x32, 0x00, 0x32, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x32, 0x0f, 0x0f,
  0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x14, 0x14, 0x14, 0x14,
  0x00, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x00, 0x1e,
  0x1e, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00,
  0x28, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x64, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64,
  0x00, 0x64, 0x64, 0x00, 0x32, 0x32, 0x32, 0x00, 0x32, 0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x00,
  0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x1e, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x28, 0x28, 0x28, 0x00,
  0x28, 0x00, 0x32, 0x32, 0x32, 0x00, 0x32, 0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x14, 0x14,
  0x14, 0x00, 0x14, 0x00, 0x1e, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x28, 0x28, 0x28, 0x00, 0x28, 0x00,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x41, 0x41,
  0x41, 0x41, 0x00, 0x41, 0x41, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x41, 0x46, 0x46, 0x46, 0x46,
  0x00, 0x46, 0x46, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x46, 0x19, 0x19, 0x19, 0x19, 0x00, 0x19,
  0x19, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x19, 0x2d, 0x2d, 0x2d, 0x2d, 0x00, 0x2d, 0x2d, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x37, 0x37, 0x37, 0x37, 0x00, 0x37, 0x37, 0x00, 0x37, 0x00,
  0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x41, 0x41, 0x41, 0x00, 0x41,
  0x00, 0x46, 0x46, 0x46, 0x00, 0x46, 0x00, 0x19, 0x19, 0x19, 0x00, 0x19, 0x00, 0x2d, 0x2d, 0x2d,
  0x00, 0x2d, 0x00, 0x37, 0x37, 0x37, 0x00, 0x37, 0x00, 0x41, 0x41, 0x41, 0x00, 0x41, 0x00, 0x46,
  0x46, 0x46, 0x00, 0x46, 0x00, 0x19, 0x19, 0x19, 0x00, 0x19, 0x00, 0x2d, 0x2d, 0x2d, 0x00, 0x2d,
  0x00, 0x37, 0x37, 0x37, 0x00, 0x37, 0x00, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x3c, 0x4b, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x00,
  0x4b, 0x50, 0x50, 0x50, 0x50, 0x00, 0x50, 0x50, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x50, 0x55,
  0x55, 0x55, 0x55, 0x00, 0x55, 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x23, 0x23, 0x23,
  0x23, 0x00, 0x23, 0x23, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x64, 0x00, 0x64,
  0x64, 0x00, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x50, 0x50,
  0x50, 0x00, 0x50, 0x00, 0x55, 0x55, 0x55, 0x00, 0x55, 0x00, 0x23, 0x23, 0x23, 0x00, 0x23, 0x00,
  0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x50, 0x50, 0x50, 0x00,
  0x50, 0x00, 0x55, 0x55, 0x55, 0x00, 0x55, 0x00, 0x23, 0x23, 0x23, 0x00, 0x23, 0x00, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x05, 0x05, 0x05, 0x05,
  0x00, 0x05, 0x05, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x0a,
  0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00,
  0x0f, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x19, 0x19,
  0x19, 0x19, 0x00, 0x19, 0x19, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e,
  0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x23, 0x23, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00,
  0x23, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x00, 0x00, 0x2d, 0x2d,
  0x2d, 0x2d, 0x00, 0x2d, 0x2d, 0x00, 0x2d, 0x00, 0x00, 0x32, 0x32, 0x32, 0x32, 0x00, 0x32, 0x32,
  0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x37, 0x37, 0x00, 0x37, 0x37, 0x00, 0x37,
  0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x41, 0x41, 0x41,
  0x41, 0x00, 0x41, 0x41, 0x00, 0x41, 0x00, 0x00, 0x46, 0x46, 0x46, 0x46, 0x00, 0x46, 0x46, 0x00,
  0x46, 0x00, 0x00, 0x4b, 0x4b, 0x4b, 0x4b, 0x00, 0x4b, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00,
  0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64,
  0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64,
  0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64, 0x00,
  0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x64, 0x00, 0x64, 0x64
};

static const unsigned char palette_19_08_K[] =
{
  0x19, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x00,
  0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19,
  0x19, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x19, 0x00,
  0x00, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00,
  0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00,
  0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19,
  0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00,
  0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00,
  0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19,
  0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x19, 0x00, 0x19, 0x19, 0x00, 0x00, 0x23, 0x00,
  0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23,
  0x23, 0x00, 0x00, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x23, 0x00,
  0x00, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00,
  0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x23, 0x23,
  0x23, 0x00, 0x00, 0x00, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x00, 0x23, 0x23, 0x00,
  0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23,
  0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23,
  0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00,
  0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23,
  0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23, 0x00, 0x23, 0x23, 0x00, 0x00, 0x23,
  0x00, 0x23, 0x23, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32,
  0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00,
  0x00, 0x32, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32,
  0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32,
  0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x32, 0x32,
  0x32, 0x32, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00,
  0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00,
  0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32,
  0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00,
  0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00,
  0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x00, 0x00, 0x05, 0x00, 0x05, 0x05,
  0x05, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x0a, 0x0a, 0x00,
  0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00,
  0x0f, 0x0f, 0x0f, 0x14, 0x00, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x19, 0x00,
  0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19, 0x05, 0x0a, 0x0f, 0x14, 0x1e, 0x00, 0x1e,
  0x1e, 0x1e, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x23, 0x00, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00,
  0x23, 0x23, 0x23, 0x28, 0x00, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x2d, 0x00,
  0x2d, 0x2d, 0x2d, 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x2d, 0x32, 0x00, 0x32, 0x32, 0x32, 0x00, 0x00,
  0x00, 0x32, 0x32, 0x32, 0x1e, 0x28, 0x2d, 0x37, 0x00, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x37,
  0x37, 0x37, 0x3c, 0x00, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x41, 0x00, 0x41,
  0x41, 0x41, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x46, 0x00, 0x46, 0x46, 0x46, 0x00, 0x00, 0x00,
  0x46, 0x46, 0x46, 0x4b, 0x00, 0x4b, 0x4b, 0x4b, 0x00, 0x00, 0x00, 0x4b, 0x4b, 0x4b, 0x37, 0x3c,
  0x41, 0x46, 0x4b, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0f,
  0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
  0x1e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x37, 0x37, 0x37,
  0x37, 0x37, 0x37, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b
};

// SpectraMaster

static const unsigned char palette_19_09_L[] =
{
  0xe4, 0xd8, 0xcc, 0xbf, 0xd5, 0xca, 0xc0, 0xc0, 0xb3, 0xa6, 0x99, 0x8d, 0xb3, 0xa7, 0x9a, 0x8e,
  0xb3, 0xa6, 0x9a, 0x8d, 0xb4, 0xa6, 0x9a, 0x8c, 0x81, 0x73, 0x66, 0x59, 0x7f, 0x72, 0x65, 0x58,
  0x81, 0x74, 0x67, 0x5b, 0x81, 0x74, 0x68, 0x5a, 0x4f, 0x42, 0x35, 0x34, 0x4c, 0x40, 0x33, 0x1b,
  0x4f, 0x42, 0x35, 0x1b, 0x4c, 0x40, 0x33, 0x18, 0x81, 0x74, 0x68, 0x5b, 0x81, 0x75, 0x68, 0x5b,
  0xb4, 0xa6, 0x9a, 0x8d, 0xb4, 0xa7, 0x9a, 0x8e, 0xe3, 0xd8, 0xcd, 0xc0, 0xe2, 0xd5, 0xcb, 0xc0,
  0xd8, 0xcd, 0xc0, 0xc1, 0xe4, 0xd6, 0xcb, 0xc0, 0xb4, 0xa7, 0x99, 0x8d, 0xb2, 0xa7, 0x9a, 0x8e,
  0xb2, 0xa6, 0x9a, 0x8e, 0xb1, 0xa7, 0x99, 0x8e, 0x82, 0x74, 0x67, 0x59, 0x81, 0x74, 0x66, 0x59,
  0x81, 0x73, 0x67, 0x5b, 0x82, 0x74, 0x68, 0x5b, 0x4f, 0x42, 0x35, 0x1c, 0x4c, 0x40, 0x3f, 0x33,
  0x4f, 0x43, 0x35, 0x1b, 0x4b, 0x40, 0x33, 0x18, 0x80, 0x74, 0x68, 0x5c, 0x81, 0x75, 0x67, 0x5b,
  0xb3, 0xa6, 0x99, 0x8d, 0xb3, 0xa6, 0x99, 0x8e, 0xe1, 0xd8, 0xcc, 0xc1, 0xe0, 0xd6, 0xcc, 0xc0,
  0xe1, 0xd7, 0xcd, 0xc1, 0xd6, 0xcc, 0xbd, 0xc0, 0xb3, 0xa5, 0x99, 0x8d, 0xb3, 0xa5, 0x9a, 0x8d,
  0xb3, 0xa6, 0x99, 0x8e, 0xb3, 0xa5, 0x9a, 0x8d, 0x81, 0x75, 0x67, 0x59, 0x81, 0x74, 0x66, 0x59,
  0x81, 0x74, 0x67, 0x5b, 0x82, 0x75, 0x67, 0x5a, 0x4f, 0x42, 0x36, 0x1b, 0x4c, 0x40, 0x3e, 0x32,
  0x4f, 0x42, 0x35, 0x29, 0x4b, 0x3f, 0x32, 0x1b, 0x81, 0x74, 0x67, 0x5b, 0x81, 0x75, 0x67, 0x5a,
  0xb3, 0xa5, 0x97, 0x8c, 0xb2, 0xa3, 0x9a, 0x8d, 0xd7, 0xcc, 0xbf, 0xc1, 0xe4, 0xd4, 0xca, 0xbe,
  0xd6, 0xca, 0xbf, 0xbe, 0xe1, 0xd6, 0xcb, 0xbf, 0xb3, 0xa5, 0x98, 0x8c, 0xb2, 0xa5, 0x97, 0x8a,
  0xb4, 0xa3, 0x98, 0x8a, 0xb4, 0xa5, 0x98, 0x8b, 0x7f, 0x74, 0x67, 0x5a, 0x7d, 0x71, 0x67, 0x5a,
  0x80, 0x74, 0x67, 0x5c, 0x7f, 0x74, 0x67, 0x5a, 0x4f, 0x42, 0x35, 0x1a, 0x4b, 0x40, 0x3f, 0x31,
  0x4f, 0x42, 0x35, 0x1b, 0x58, 0x4b, 0x3e, 0x32, 0x80, 0x74, 0x66, 0x5a, 0x81, 0x73, 0x64, 0x58,
  0xb2, 0xa7, 0x9c, 0x8f, 0xa9, 0xa8, 0x9c, 0x90, 0xd4, 0xca, 0xbe, 0xb7, 0xe4, 0xd4, 0xca, 0xc1,
  0xd5, 0xcd, 0xc1, 0xc0, 0xe3, 0xd6, 0xcc, 0xc1, 0xb5, 0xa6, 0x9c, 0x91, 0xb6, 0xaa, 0x98, 0x8c,
  0xb4, 0xa7, 0x98, 0x8c, 0xb4, 0xa7, 0x9a, 0x8c, 0x80, 0x74, 0x67, 0x5c, 0x80, 0x74, 0x67, 0x5b,
  0x81, 0x73, 0x67, 0x5a, 0x81, 0x76, 0x68, 0x5b, 0x4f, 0x42, 0x35, 0x1a, 0x4c, 0x40, 0x32, 0x33,
  0x4e, 0x42, 0x36, 0x19, 0x4b, 0x40, 0x32, 0x19, 0x81, 0x72, 0x65, 0x5b, 0x82, 0x74, 0x63, 0x58,
  0xb6, 0xaa, 0x9e, 0x90, 0xb7, 0xaa, 0x9e, 0x90, 0xe1, 0xd5, 0xcb, 0xc0, 0xd5, 0xca, 0xcb, 0xc0,
  0xe1, 0xd5, 0xcb, 0xc1, 0xd4, 0xcb, 0xc1, 0xb6, 0xb7, 0xab, 0x9d, 0x8f, 0xb8, 0xa8, 0x9e, 0x91,
  0x82, 0x73, 0x66, 0x5a, 0x82, 0x77, 0x6b, 0x5d, 0x9b, 0x8e, 0x82, 0x75, 0x9a, 0x8d, 0x81, 0x74,
  0x69, 0x5c, 0x4f, 0x42, 0x68, 0x5b, 0x4d, 0x3f, 0x4d, 0x42, 0x35, 0x1a, 0x4e, 0x40, 0x34, 0x17,
  0x4e, 0x41, 0x35, 0x19, 0x4d, 0x40, 0x34, 0x18, 0x83, 0x72, 0x65, 0x5a, 0x83, 0x75, 0x66, 0x59,
  0xb8, 0xac, 0x9d, 0x91, 0xb7, 0xac, 0x9e, 0x90, 0xe2, 0xd5, 0xcb, 0xc2, 0xd5, 0xcb, 0xc1, 0xb7,
  0xe0, 0xd5, 0xcb, 0xc2, 0xcc, 0xc2, 0xb6, 0xa9, 0xb8, 0xad, 0x9e, 0x90, 0xb9, 0xab, 0x9e, 0x8e,
  0x83, 0x75, 0x66, 0x5a, 0x84, 0x75, 0x68, 0x5e, 0x9c, 0x8f, 0x82, 0x76, 0x9c, 0x8e, 0x81, 0x74,
  0x5c, 0x4f, 0x42, 0x35, 0x5b, 0x4e, 0x41, 0x36, 0x4e, 0x41, 0x35, 0x1b, 0x4f, 0x41, 0x35, 0x1c,
  0x4f, 0x42, 0x34, 0x19, 0x4c, 0x42, 0x35, 0x18, 0x84, 0x76, 0x67, 0x5b, 0x80, 0x76, 0x68, 0x5a,
  0xb8, 0xac, 0x9e, 0x90, 0xb7, 0xad, 0x9e, 0x90, 0xe5, 0xd4, 0xcb, 0xc2, 0xd3, 0xcb, 0xc0, 0xb4,
  0xe2, 0xd6, 0xca, 0xc2, 0xcb, 0xc3, 0xb6, 0xa8, 0xb8, 0xab, 0x9d, 0x91, 0xb7, 0xaa, 0x9e, 0x91,
  0x9d, 0x90, 0x83, 0x77, 0x9c, 0x8f, 0x82, 0x75, 0x85, 0x75, 0x67, 0x5a, 0x83, 0x74, 0x69, 0x5a,
  0x6a, 0x5d, 0x50, 0x42, 0x68, 0x5c, 0x50, 0x41, 0x4e, 0x42, 0x34, 0x34, 0x50, 0x40, 0x35, 0x1c,
  0x50, 0x43, 0x35, 0x1a, 0x4e, 0x41, 0x34, 0x19, 0x82, 0x77, 0x67, 0x5c, 0x84, 0x77, 0x69, 0x5b,
  0xb5, 0xaa, 0x9e, 0x90, 0xb6, 0xaa, 0x9e, 0x90, 0xe1, 0xd5, 0xc9, 0xc1, 0xd3, 0xca, 0xc0, 0xb4,
  0xd4, 0xc9, 0xc2, 0xbe, 0xe0, 0xd4, 0xc9, 0xbe, 0xb4, 0xa7, 0x9c, 0x8f, 0xb3, 0xa9, 0x9c, 0x90,
  0xb6, 0x9d, 0x8f, 0x82, 0xaa, 0x9b, 0x8e, 0x84, 0x75, 0x68, 0x5b, 0x5d, 0x77, 0x6a, 0x67, 0x5a,
  0x84, 0x77, 0x69, 0x5a, 0x82, 0x77, 0x6a, 0x5b, 0x4d, 0x41, 0x34, 0x19, 0x50, 0x41, 0x36, 0x1a,
  0x4e, 0x41, 0x34, 0x1c, 0x4e, 0x50, 0x41, 0x34, 0x4e, 0x42, 0x41, 0x34, 0x42, 0x35, 0x19, 0x19,
  0x76, 0x6b, 0x5d, 0x4e, 0x76, 0x68, 0x5a, 0x4f, 0xa8, 0x9b, 0x8d, 0x82, 0xa6, 0x98, 0x8f, 0x84,
  0xbe, 0xb4, 0xb4, 0x9a, 0xd4, 0xc8, 0xbf, 0xb3, 0xe4, 0xbe, 0xb6, 0xb4, 0xd5, 0xc8, 0xbe, 0xb2,
  0xa7, 0x9b, 0x8f, 0x84, 0xa6, 0x99, 0x8f, 0x80, 0x75, 0x69, 0x5c, 0x4e, 0x76, 0x6a, 0x60, 0x50,
  0x9c, 0x90, 0x82, 0x75, 0xaa, 0x8e, 0x84, 0x77, 0x69, 0x5c, 0x4e, 0x41, 0x6b, 0x5d, 0x50, 0x42,
  0x41, 0x34, 0x35, 0x1a, 0x42, 0x35, 0x27, 0x1a, 0x3f, 0x32, 0x33, 0x19, 0x41, 0x40, 0x35, 0x1b,
  0x76, 0x67, 0x5b, 0x4d, 0x77, 0x6a, 0x5d, 0x4f, 0xa9, 0x9b, 0x8f, 0x82, 0xa8, 0x99, 0x8e, 0x82,
  0xe1, 0xbe, 0xb3, 0xa8, 0xd3, 0xc8, 0xbe, 0xb3, 0x4e, 0x4e, 0x42, 0x35, 0x73, 0x66, 0x5b, 0x5a,
  0x74, 0x68, 0x67, 0x5c, 0x74, 0x69, 0x67, 0x66, 0x02, 0x04, 0x09, 0x06, 0x07, 0x07, 0x07, 0x07,
  0x0c, 0x0a, 0x0c, 0x0c, 0x0c, 0x0c, 0x0a, 0x0a, 0x7f, 0x71, 0x65, 0x57, 0x4a, 0x3f, 0x31, 0x18,
  0x81, 0x73, 0x65, 0x59, 0x4c, 0x3d, 0x33, 0x19, 0x82, 0x73, 0x66, 0x58, 0x4d, 0x44, 0x33, 0x1b,
  0x81, 0x73, 0x66, 0x5a, 0x4d, 0x40, 0x34, 0x18, 0x7f, 0x72, 0x65, 0x58, 0x4b, 0x3e, 0x32, 0x16,
  0x7f, 0x73, 0x67, 0x59, 0x4c, 0x3f, 0x33, 0x18, 0x7d, 0x72, 0x65, 0x5b, 0x4c, 0x40, 0x32, 0x17,
  0x80, 0x72, 0x66, 0x59, 0x4b, 0x3f, 0x30, 0x19, 0x7f, 0x72, 0x66, 0x58, 0x4b, 0x3f, 0x32, 0x18,
  0x80, 0x72, 0x65, 0x58, 0x4b, 0x3f, 0x32, 0x18, 0x7f, 0x72, 0x66, 0x59, 0x4b, 0x3f, 0x32, 0x19,
  0x80, 0x73, 0x66, 0x59, 0x4c, 0x3f, 0x33, 0x19, 0x80, 0x73, 0x66, 0x5a, 0x4d, 0x40, 0x35, 0x18,
  0x7f, 0x71, 0x66, 0x59, 0x4d, 0x40, 0x32, 0x19, 0x80, 0x74, 0x68, 0x59, 0x4c, 0x40, 0x32, 0x1a,
  0x80, 0x74, 0x67, 0x5a, 0x4d, 0x42, 0x36, 0x19, 0x80, 0x73, 0x66, 0x58, 0x4c, 0x3f, 0x32, 0x18,
  0x7f, 0x72, 0x65, 0x58, 0x4c, 0x3f, 0x31, 0x18, 0x7f, 0x71, 0x65, 0x58, 0x4a, 0x3e, 0x33, 0x18,
  0x80, 0x73, 0x66, 0x58, 0x4c, 0x3f, 0x31, 0x18, 0x80, 0x74, 0x66, 0x59, 0x4c, 0x3e, 0x32, 0x19,
  0x7f, 0x73, 0x65, 0x59, 0x4c, 0x3f, 0x32, 0x18, 0x7f, 0x72, 0x65, 0x59, 0x4b, 0x3e, 0x31, 0x19,
  0x80, 0x73, 0x66, 0x59, 0x4d, 0x40, 0x33, 0x1a, 0x80, 0x73, 0x66, 0x59, 0x4c, 0x40, 0x33, 0x1a,
  0xe3, 0xe4, 0xe4, 0xe1, 0xd7, 0xd5, 0xd6, 0xd5, 0xd4, 0xc7, 0xbd, 0xb1, 0xd6, 0xc9, 0xbd, 0xae,
  0xa6, 0x97, 0x8b, 0x7e, 0xa4, 0x99, 0x8e, 0x7e, 0xc8, 0xbe, 0xb1, 0xa4, 0xcb, 0xbf, 0xb4, 0xa7,
  0xca, 0xc3, 0xb6, 0xa9, 0xcd, 0xc2, 0xb6, 0xa9, 0x9c, 0x8e, 0x81, 0x74, 0x9b, 0x8e, 0x81, 0x74,
  0x99, 0x8c, 0x81, 0x73, 0x9b, 0x8d, 0x81, 0x75, 0x67, 0x5b, 0x4d, 0x3c, 0x75, 0x69, 0x5a, 0x31,
  0x67, 0x5c, 0x4d, 0x32, 0x67, 0x5a, 0x4d, 0x24, 0x5a, 0x4b, 0x3d, 0x2f, 0x5a, 0x4e, 0x40, 0x32,
  0x8b, 0x7f, 0x73, 0x66, 0x8c, 0x7f, 0x72, 0x74, 0xbd, 0xb0, 0xa6, 0x99, 0xbe, 0xb3, 0xa4, 0x97,
  0xe0, 0xd6, 0xca, 0xc9, 0xe3, 0xe0, 0xd5, 0xcb, 0xe2, 0xd5, 0xcc, 0xd5, 0xdf, 0xdf, 0xd7, 0xd5,
  0xcc, 0xbd, 0xb1, 0xa5, 0xcb, 0xbe, 0xb2, 0xa3, 0x98, 0x8b, 0x80, 0x73, 0x96, 0x8a, 0x7f, 0x72,
  0xca, 0xc2, 0xb6, 0xa8, 0xcd, 0xc1, 0xb6, 0xa9, 0xbf, 0xb2, 0xa4, 0x97, 0xc0, 0xb4, 0xa5, 0x9b,
  0x8b, 0x7f, 0x74, 0x64, 0x8f, 0x80, 0x74, 0x68, 0x9c, 0x8e, 0x81, 0x74, 0x9c, 0x8e, 0x81, 0x75,
  0x69, 0x5a, 0x5b, 0x4e, 0x68, 0x68, 0x5b, 0x4e, 0x5a, 0x3d, 0x2f, 0x22, 0x4c, 0x42, 0x34, 0x29,
  0x4b, 0x3e, 0x2e, 0x21, 0x4f, 0x42, 0x38, 0x16, 0x7f, 0x73, 0x66, 0x59, 0x7f, 0x74, 0x69, 0x5b,
  0xb0, 0xa4, 0x98, 0x8c, 0xb1, 0xa5, 0x98, 0x8c, 0xe2, 0xd6, 0xca, 0xbe, 0xdf, 0xd5, 0xcb, 0xbf,
  0xd5, 0xcc, 0xc0, 0xbe, 0xdf, 0xd4, 0xcb, 0xbf, 0xd7, 0xd4, 0xcb, 0xc1, 0xd6, 0xdf, 0xcd, 0xc1,
  0xb0, 0xa5, 0x99, 0x8d, 0xb3, 0xa5, 0x97, 0x8a, 0xb3, 0xa5, 0x98, 0x8b, 0xb5, 0xa7, 0x9a, 0x8f,
  0xb5, 0xa8, 0x9b, 0x8f, 0xb6, 0xa9, 0x9b, 0x8e, 0x82, 0x75, 0x6b, 0x5f, 0x7f, 0x75, 0x68, 0x5b,
  0x7e, 0x71, 0x68, 0x5e, 0x82, 0x75, 0x69, 0x5b, 0x83, 0x74, 0x69, 0x5b, 0x81, 0x75, 0x68, 0x5a,
  0x52, 0x44, 0x37, 0x37, 0x4f, 0x4d, 0x41, 0x1c, 0x51, 0x46, 0x37, 0x35, 0x5c, 0x50, 0x42, 0x1b,
  0x81, 0x75, 0x69, 0x5f, 0x8c, 0x81, 0x76, 0x68, 0xb2, 0xa3, 0x94, 0x8a, 0xb5, 0xa7, 0x99, 0x99,
  0xdf, 0xd4, 0xca, 0xbf, 0xdf, 0xd4, 0xca, 0xc0, 0xdf, 0xd4, 0xcb, 0xc0, 0xe0, 0xd4, 0xca, 0xc0,
  0xd7, 0xcd, 0xc1, 0xc1, 0xb5, 0xa8, 0x9b, 0x8e, 0xb4, 0xa8, 0x9c, 0x8f, 0xb5, 0xaa, 0x9c, 0x8f,
  0xb4, 0xa5, 0x97, 0x8b, 0xb5, 0xa9, 0x9a, 0x8c, 0x7e, 0x72, 0x66, 0x5b, 0x81, 0x73, 0x68, 0x5c,
  0x82, 0x75, 0x68, 0x5b, 0x81, 0x74, 0x68, 0x5c, 0x80, 0x73, 0x66, 0x59, 0x4e, 0x4e, 0x42, 0x41,
  0x50, 0x46, 0x38, 0x34, 0x50, 0x4e, 0x41, 0x1c, 0x4d, 0x41, 0x37, 0x34, 0x5b, 0x50, 0x41, 0x1a,
  0x7d, 0x72, 0x65, 0x59, 0x8e, 0x82, 0x75, 0x66, 0xb4, 0xa6, 0x99, 0x8c, 0xb3, 0xb5, 0xa8, 0x9b,
  0xe0, 0xd5, 0xcb, 0xc0, 0xe0, 0xd4, 0xca, 0xc0, 0xe0, 0xd6, 0xca, 0xbf, 0xe2, 0xd5, 0xcc, 0xbf,
  0xd8, 0xcc, 0xc1, 0xc1, 0xb7, 0xa8, 0x9b, 0x8e, 0xb3, 0xa8, 0x9d, 0x8e, 0xb5, 0xa9, 0x9b, 0x8e,
  0xb3, 0xa7, 0x99, 0x8b, 0xb6, 0xa8, 0x9a, 0x8e, 0x7e, 0x72, 0x66, 0x58, 0x82, 0x74, 0x68, 0x5a,
  0x81, 0x74, 0x68, 0x5b, 0x81, 0x73, 0x67, 0x5b, 0x81, 0x74, 0x67, 0x5c, 0x50, 0x4e, 0x41, 0x41,
  0x4d, 0x42, 0x36, 0x34, 0x4e, 0x41, 0x34, 0x1b, 0x4b, 0x41, 0x36, 0x1b, 0x4d, 0x40, 0x34, 0x19,
  0x7e, 0x71, 0x64, 0x58, 0x7f, 0x72, 0x67, 0x59, 0xb4, 0xa7, 0x99, 0x8c, 0xb2, 0xa7, 0x9a, 0x8f,
  0xe0, 0xd6, 0xcc, 0xc1, 0xe1, 0xd5, 0xca, 0xbf, 0xe1, 0xd7, 0xcc, 0xc1, 0xd7, 0xd9, 0xcd, 0xbf,
  0xcc, 0xc0, 0xcd, 0xc1, 0xb4, 0xa7, 0x99, 0x8c, 0xb4, 0xa7, 0x9b, 0x8c, 0xb4, 0xa8, 0x99, 0x8c,
  0xb4, 0xa6, 0x99, 0x8b, 0xb2, 0xa5, 0x98, 0x8c, 0x7e, 0x71, 0x64, 0x57, 0x7f, 0x71, 0x66, 0x59,
  0x7e, 0x70, 0x64, 0x57, 0x7e, 0x71, 0x65, 0x59, 0x7f, 0x71, 0x64, 0x58, 0x4c, 0x4c, 0x40, 0x3f,
  0x4a, 0x3f, 0x32, 0x33, 0x4b, 0x3f, 0x33, 0x1c, 0x4c, 0x3e, 0x32, 0x1b, 0x4d, 0x40, 0x32, 0x1a,
  0x7f, 0x72, 0x65, 0x58, 0x82, 0x74, 0x67, 0x5a, 0xb3, 0xa6, 0x9a, 0x8c, 0xb2, 0xa6, 0x9c, 0x8e,
  0xe2, 0xd6, 0xcb, 0xbe, 0xe2, 0xd7, 0xcc, 0xbe, 0xe4, 0xd7, 0xca, 0xbe, 0xd6, 0xca, 0xca, 0xc0,
  0xb3, 0xa7, 0x9a, 0x8d, 0xb2, 0xa5, 0x99, 0x8c, 0xb4, 0xa7, 0x9a, 0x8d, 0xb4, 0xaa, 0x9a, 0x8e,
  0x81, 0x73, 0x66, 0x59, 0x81, 0x74, 0x67, 0x5a, 0x80, 0x73, 0x65, 0x58, 0x7f, 0x72, 0x65, 0x57,
  0x4c, 0x3f, 0x33, 0x32, 0x4d, 0x40, 0x33, 0x1a, 0x4d, 0x41, 0x34, 0x1b, 0x4e, 0x40, 0x33, 0x18,
  0x7f, 0x73, 0x67, 0x5a, 0x81, 0x73, 0x67, 0x5a, 0xb2, 0xa7, 0x9a, 0x8b, 0xb4, 0xa7, 0x9a, 0x8e,
  0xe3, 0xd6, 0xcb, 0xbf, 0xe3, 0xd5, 0xcb, 0xc0, 0xe4, 0xd7, 0xcc, 0xc0, 0xd6, 0xca, 0xcb, 0xc0,
  0xb4, 0xa5, 0x99, 0x8d, 0xb2, 0xa6, 0x9a, 0x8d, 0xb3, 0xa6, 0x99, 0x8c, 0xb3, 0xa6, 0x9b, 0x8e,
  0x80, 0x73, 0x66, 0x5a, 0x84, 0x74, 0x67, 0x5b, 0x80, 0x72, 0x65, 0x59, 0x7f, 0x71, 0x65, 0x57,
  0x4e, 0x41, 0x34, 0x34, 0x4e, 0x41, 0x34, 0x1a, 0x4f, 0x42, 0x34, 0x19, 0x4c, 0x40, 0x34, 0x19,
  0x80, 0x73, 0x68, 0x5b, 0x81, 0x74, 0x67, 0x5a, 0xb3, 0xa6, 0x99, 0x8c, 0xb2, 0xa7, 0x9a, 0x8d,
  0xe4, 0xd8, 0xcc, 0xc0, 0xe2, 0xd6, 0xcb, 0xc1, 0x7e, 0x57, 0x4a, 0x32, 0x66, 0x4d, 0x42, 0x37,
  0x59, 0x52, 0x46, 0x41, 0x66, 0x51, 0x50, 0x41, 0xf4, 0xe6, 0xf0, 0xec, 0xef, 0xec, 0xf1, 0xeb,
  0xeb, 0xeb, 0xed, 0xed, 0xef, 0xf2, 0xe8, 0xe8, 0xe8, 0xe9, 0xee, 0xeb, 0xe8, 0xe9, 0xee, 0xee,
  0xeb, 0xe9, 0xe9, 0xed, 0xea, 0xf0, 0xe7, 0xe8, 0xe0, 0xd6, 0xcc, 0xbf, 0xb2, 0xa5, 0x99, 0x8c,
  0xe1, 0xd5, 0xca, 0xc0, 0xb4, 0xa7, 0x9b, 0x8e, 0xde, 0xd3, 0xcc, 0xc1, 0xb4, 0xa9, 0x9a, 0x90,
  0xe1, 0xd6, 0xcb, 0xbe, 0xb4, 0xa8, 0x9b, 0x8d, 0xe2, 0xd6, 0xcb, 0xc0, 0xb3, 0xa6, 0x99, 0x8b,
  0xe0, 0xd7, 0xcb, 0xbf, 0xb3, 0xa6, 0x99, 0x8c, 0xe3, 0xd7, 0xcc, 0xbf, 0xb2, 0xa5, 0x98, 0x8b,
  0xe4, 0xd9, 0xcd, 0xc1, 0xb4, 0xa7, 0x9a, 0x8c, 0xe4, 0xda, 0xce, 0xc2, 0xb5, 0xa8, 0x9a, 0x8d,
  0xe5, 0xda, 0xd0, 0xc3, 0xb5, 0xa8, 0x9a, 0x8c, 0xe2, 0xd8, 0xcc, 0xc2, 0xb4, 0xa6, 0x9a, 0x8c,
  0xe3, 0xd8, 0xcd, 0xc3, 0xb4, 0xa7, 0x9a, 0x8d, 0xe3, 0xd6, 0xcc, 0xc1, 0xb5, 0xa8, 0x9b, 0x8d,
  0xe1, 0xd5, 0xcb, 0xc1, 0xb5, 0xa8, 0x9a, 0x8d, 0xe2, 0xd6, 0xcc, 0xc1, 0xb5, 0xa8, 0x9b, 0x8e,
  0xe2, 0xd6, 0xcb, 0xc0, 0xb4, 0xa7, 0x9a, 0x8d, 0xe1, 0xd5, 0xcb, 0xc0, 0xb3, 0xa7, 0x99, 0x8c,
  0xe2, 0xd4, 0xca, 0xbf, 0xb3, 0xa5, 0x99, 0x8c, 0xe4, 0xd5, 0xc9, 0xbf, 0xb4, 0xa8, 0x9a, 0x8d,
  0xe2, 0xd4, 0xc9, 0xc0, 0xb5, 0xa7, 0x98, 0x8d, 0xe1, 0xd4, 0xc9, 0xbe, 0xb4, 0xa6, 0x98, 0x8d,
  0xe3, 0xd6, 0xcb, 0xc0, 0xb5, 0xa7, 0x9a, 0x8c, 0xe2, 0xd5, 0xca, 0xbf, 0xb4, 0xa8, 0x9b, 0x8d,
  0xe0, 0xd4, 0xcb, 0xc1, 0xb5, 0xa9, 0x9b, 0x8c, 0xe0, 0xd4, 0xcc, 0xc1, 0xb6, 0xa9, 0x9c, 0x8e,
  0xe3, 0xd4, 0xc8, 0xbe, 0xbf, 0xb5, 0xb5, 0xb3, 0xa7, 0x9b, 0x8e, 0x82, 0xa7, 0x9b, 0x8e, 0x84,
  0x9e, 0x90, 0x82, 0x75, 0xaa, 0x8e, 0x85, 0x77, 0x68, 0x5b, 0x4e, 0x41, 0x6a, 0x5d, 0x4f, 0x41,
  0x76, 0x69, 0x5a, 0x4d, 0x76, 0x6a, 0x5c, 0x4e, 0x40, 0x33, 0x34, 0x19, 0x41, 0x35, 0x33, 0x1b,
  0x3d, 0x31, 0x32, 0x19, 0x4b, 0x41, 0x34, 0x1a, 0x76, 0x68, 0x5a, 0x4d, 0x78, 0x6a, 0x5b, 0x4e,
  0xa8, 0x9c, 0x8f, 0x83, 0xa8, 0x9b, 0x8e, 0x83, 0xc8, 0xbf, 0xb5, 0xa9, 0xbe, 0xb6, 0xb4, 0x8f,
  0xe2, 0xcb, 0xc1, 0xb5, 0xd6, 0xd5, 0xcb, 0xbf, 0xb4, 0xa8, 0x9d, 0x8e, 0xb3, 0xa5, 0x99, 0x8d,
  0x81, 0x74, 0x67, 0x59, 0x82, 0x75, 0x6a, 0x5b, 0x9d, 0x90, 0x80, 0x74, 0xa9, 0x91, 0x82, 0x73,
  0x66, 0x59, 0x4c, 0x32, 0x64, 0x57, 0x4a, 0x3f, 0x4c, 0x3d, 0x2f, 0x18, 0x4e, 0x41, 0x34, 0x1a,
  0x4d, 0x40, 0x32, 0x32, 0x41, 0x35, 0x1b, 0x18, 0x75, 0x68, 0x5b, 0x4c, 0x74, 0x67, 0x5a, 0x4d,
  0xa8, 0x99, 0x8d, 0x81, 0xa5, 0x97, 0x8d, 0x80, 0xca, 0xc0, 0xb5, 0x9b, 0xd5, 0xca, 0xbe, 0xb3,
  0xe1, 0xcc, 0xc0, 0xb4, 0xd4, 0xca, 0xc0, 0xb3, 0xa7, 0x9b, 0x8c, 0x80, 0xa6, 0x98, 0x8c, 0x7e,
  0xb3, 0xa8, 0x9b, 0x8e, 0xb2, 0xa8, 0x9d, 0x8e, 0x81, 0x74, 0x66, 0x5a, 0x8e, 0x81, 0x74, 0x67,
  0x73, 0x59, 0x4d, 0x33, 0x80, 0x66, 0x4d, 0x40, 0x74, 0x67, 0x5b, 0x4f, 0x72, 0x65, 0x58, 0x4c,
  0x40, 0x40, 0x32, 0x17, 0x40, 0x34, 0x28, 0x1b, 0x4d, 0x41, 0x33, 0x18, 0x42, 0x3f, 0x34, 0x1b,
  0x75, 0x6a, 0x5d, 0x50, 0x74, 0x62, 0x57, 0x4b, 0xa6, 0x9a, 0x8d, 0x81, 0xa6, 0x99, 0x8e, 0x82,
  0xd7, 0xcb, 0xbe, 0xb3, 0xe2, 0xd8, 0xcc, 0xbd, 0xe2, 0xca, 0xc0, 0xb5, 0xd4, 0xcb, 0xbf, 0xb3,
  0xb1, 0x99, 0x8d, 0x81, 0xa4, 0x9a, 0x8e, 0x82, 0xa6, 0x9a, 0x8d, 0x7f, 0xb1, 0xa6, 0x99, 0x8d,
  0x73, 0x74, 0x67, 0x5c, 0x80, 0x74, 0x6a, 0x5b, 0x66, 0x5a, 0x4d, 0x41, 0x4e, 0x50, 0x41, 0x41,
  0x74, 0x68, 0x5d, 0x4c, 0x76, 0x67, 0x57, 0x4c, 0x33, 0x26, 0x32, 0x17, 0x3e, 0x33, 0x32, 0x19,
  0x4b, 0x3f, 0x33, 0x19, 0x4e, 0x40, 0x33, 0x16, 0x66, 0x71, 0x67, 0x5b, 0x73, 0x75, 0x68, 0x58,
  0xa4, 0x99, 0x8d, 0x7f, 0xa5, 0x99, 0x8a, 0x80, 0xe2, 0xca, 0xbc, 0xb0, 0xd7, 0xca, 0xbc, 0xb0,
  0xe0, 0xcb, 0xbd, 0xb1, 0xd7, 0xca, 0xbc, 0xb0, 0xa4, 0x99, 0x8d, 0x80, 0xa4, 0x9a, 0x8d, 0x7f,
  0xb2, 0xa9, 0x99, 0x8d, 0xa5, 0x98, 0x8d, 0x81, 0x74, 0x67, 0x5a, 0x4d, 0x74, 0x68, 0x59, 0x4c,
  0x74, 0x5a, 0x41, 0x19, 0x80, 0x66, 0x4c, 0x33, 0x40, 0x33, 0x33, 0x18, 0x3e, 0x40, 0x33, 0x17,
  0x30, 0x3e, 0x4d, 0x16, 0x3f, 0x3f, 0x33, 0x17, 0x73, 0x66, 0x59, 0x4c, 0x72, 0x66, 0x59, 0x4c,
  0x73, 0x67, 0x5a, 0x4b, 0x72, 0x66, 0x58, 0x4b, 0xa4, 0x99, 0x8d, 0x80, 0xa5, 0x9a, 0x8d, 0x7f,
  0xe3, 0xca, 0xbd, 0xaf, 0xd6, 0xca, 0xbe, 0xb2, 0xe3, 0xcb, 0xbf, 0xb0, 0xd6, 0xc8, 0xbb, 0xb0,
  0xa2, 0x97, 0x8f, 0x81, 0xa5, 0x99, 0x8c, 0x7f, 0x99, 0x8c, 0x7f, 0x73, 0xa4, 0x8c, 0x80, 0x72,
  0x65, 0x59, 0x4c, 0x41, 0x80, 0x74, 0x68, 0x5b, 0x8c, 0x72, 0x59, 0x40, 0x99, 0x7e, 0x66, 0x4d,
  0x3d, 0x4f, 0x3f, 0x19, 0x33, 0x33, 0x33, 0x18, 0x74, 0x67, 0x58, 0x4b, 0x73, 0x57, 0x4b, 0x3f,
  0x75, 0x68, 0x5a, 0x4b, 0x73, 0x65, 0x58, 0x4a, 0x3d, 0x3f, 0x31, 0x33, 0x8d, 0x81, 0x5a, 0x31,
  0xa4, 0x99, 0x8d, 0x7f, 0xa5, 0x99, 0x8c, 0x7f, 0xe2, 0xcb, 0xbc, 0xb0, 0xd7, 0xca, 0xba, 0xb0,
  0xd5, 0xca, 0xbc, 0xb0, 0xe3, 0xca, 0xbd, 0xb1, 0xb3, 0xa5, 0x98, 0x8c, 0xa5, 0x98, 0x8b, 0x8b,
  0xa4, 0x9a, 0x8d, 0x7f, 0xa5, 0x99, 0x8d, 0x80, 0x80, 0x72, 0x65, 0x58, 0x7f, 0x74, 0x66, 0x59,
  0x72, 0x66, 0x58, 0x4b, 0x73, 0x63, 0x57, 0x4b, 0x7e, 0x66, 0x4c, 0x32, 0x72, 0x5a, 0x40, 0x18,
  0x4b, 0x33, 0x32, 0x3e, 0x4c, 0x40, 0x3f, 0x3f, 0x67, 0x5a, 0x3e, 0x31, 0x5a, 0x4d, 0x3f, 0x31,
  0x71, 0x64, 0x59, 0x4c, 0x73, 0x66, 0x58, 0x4c, 0xa4, 0x99, 0x8b, 0x7f, 0xa5, 0x99, 0x8d, 0x7f,
  0xd5, 0xc9, 0xbc, 0xb0, 0xe1, 0xca, 0xbd, 0xb0, 0xd6, 0xca, 0xbd, 0xb0, 0xe2, 0xcc, 0xbd, 0xb0,
  0xa4, 0x96, 0x8b, 0x81, 0xa4, 0x98, 0x8b, 0x7e, 0x99, 0x7e, 0x72, 0x64, 0x8d, 0x7f, 0x72, 0x64,
  0x72, 0x72, 0x65, 0x59, 0x64, 0x57, 0x49, 0x3e, 0xb3, 0xa5, 0xa7, 0x99, 0xc0, 0xb4, 0xa7, 0x9a,
  0x8c, 0x7f, 0x72, 0x64, 0x8c, 0x7f, 0x72, 0x65, 0x56, 0x3f, 0x33, 0x33, 0x4c, 0x57, 0x3f, 0x19,
  0x57, 0x4a, 0x3f, 0x31, 0x57, 0x4b, 0x3f, 0x33, 0x66, 0x59, 0x3e, 0x31, 0x4c, 0x3f, 0x33, 0x19,
  0x71, 0x65, 0x57, 0x4a, 0x71, 0x65, 0x58, 0x4b, 0xbf, 0xa4, 0x8c, 0x7e, 0xb1, 0x97, 0x8b, 0x71,
  0xa4, 0x97, 0x8b, 0x7f, 0xa4, 0x99, 0x8c, 0x7f, 0xd8, 0xca, 0xbd, 0xaf, 0xd7, 0xcb, 0xbc, 0xb0,
  0x54, 0x52, 0x52, 0x50, 0x4e, 0x4f, 0x52, 0x5a, 0x4f, 0x48, 0x50, 0x4d, 0x47, 0x42, 0x42, 0x40,
  0xd8, 0xcb, 0xca, 0xc0, 0xe3, 0xd8, 0xce, 0xc1, 0xbc, 0xb1, 0xa2, 0x97, 0xbc, 0xb1, 0xa5, 0x99,
  0x89, 0x7e, 0x72, 0x64, 0x8d, 0x81, 0x72, 0x65, 0xb4, 0xa6, 0x9a, 0x8d, 0xb5, 0xa7, 0x9a, 0x8d,
  0x9a, 0x8e, 0x80, 0x73, 0x9a, 0x8e, 0x80, 0x72, 0x80, 0x72, 0x65, 0x57, 0x80, 0x72, 0x66, 0x57,
  0x65, 0x59, 0x4b, 0x3e, 0x64, 0x57, 0x4c, 0x3f, 0x4b, 0x3e, 0x31, 0x31, 0x4b, 0x3d, 0x31, 0x19,
  0x4c, 0x40, 0x31, 0x26, 0x4c, 0x3f, 0x33, 0x19, 0x7e, 0x71, 0x65, 0x59, 0x81, 0x73, 0x65, 0x58,
  0xaf, 0xa4, 0x98, 0x8b, 0xb1, 0xa6, 0x99, 0x8d, 0xe4, 0xd9, 0xca, 0xbb, 0xe3, 0xd8, 0xcb, 0xbd,
  0xe3, 0xd9, 0xcc, 0xbc, 0xdb, 0xcf, 0xcb, 0xbe, 0xb2, 0xa3, 0x99, 0x8c, 0xb1, 0xa5, 0x99, 0x8b,
  0x7e, 0x71, 0x65, 0x58, 0x80, 0x73, 0x68, 0x5a, 0xc0, 0xb3, 0xa7, 0x9b, 0xc3, 0xb5, 0xa7, 0x9a,
  0xa7, 0x9a, 0x8d, 0x80, 0xa8, 0x9a, 0x8d, 0x80, 0x8e, 0x8d, 0x81, 0x73, 0x8d, 0x80, 0x73, 0x65,
  0x73, 0x58, 0x58, 0x4b, 0x73, 0x66, 0x4a, 0x3e, 0x4b, 0x3e, 0x31, 0x32, 0x4c, 0x40, 0x33, 0x19,
  0x4c, 0x3e, 0x31, 0x25, 0x4c, 0x40, 0x33, 0x1a, 0x80, 0x72, 0x65, 0x58, 0x80, 0x75, 0x67, 0x5a,
  0xb1, 0xa6, 0x98, 0x8d, 0xb0, 0xa6, 0x99, 0x8c, 0xe3, 0xd7, 0xcb, 0xbe, 0xe2, 0xd7, 0xcb, 0xbf,
  0xe3, 0xd8, 0xcb, 0xbd, 0xcf, 0xd7, 0xcb, 0xbd, 0xb1, 0xa6, 0x99, 0x8c, 0xb3, 0xa5, 0x99, 0x90,
  0xbf, 0xb4, 0xa6, 0x9a, 0xc1, 0xb5, 0xa8, 0x9b, 0xc2, 0xb6, 0xa8, 0x9c, 0xc3, 0xa8, 0xa8, 0x9a,
  0x8f, 0x82, 0x74, 0x66, 0x8f, 0x81, 0x73, 0x66, 0x8e, 0x81, 0x73, 0x58, 0x8d, 0x80, 0x65, 0x59,
  0x80, 0x73, 0x65, 0x59, 0x7f, 0x74, 0x66, 0x59, 0x4b, 0x3d, 0x30, 0x33, 0x4b, 0x4b, 0x3f, 0x24,
  0x4b, 0x3d, 0x30, 0x24, 0x4d, 0x3f, 0x34, 0x18, 0x81, 0x72, 0x66, 0x59, 0x7f, 0x74, 0x67, 0x5a,
  0xaf, 0xa5, 0x9a, 0x8d, 0xb2, 0xa5, 0x99, 0x8c, 0xe3, 0xd8, 0xca, 0xbc, 0xe3, 0xd7, 0xcd, 0xc1,
  0xe2, 0xda, 0xd6, 0xd9, 0xe5, 0xda, 0xcb, 0xcd, 0xca, 0xbb, 0xb1, 0xa6, 0xcd, 0xbe, 0xb2, 0xa6,
  0xc0, 0xb4, 0xa6, 0x9a, 0xc0, 0xb4, 0xa7, 0x99, 0xce, 0xc2, 0xb6, 0xb5, 0xd0, 0xc3, 0xc2, 0xb5,
  0x8c, 0x82, 0x72, 0x66, 0x8f, 0x81, 0x74, 0x66, 0xa8, 0x9b, 0x8e, 0x81, 0xa8, 0x9a, 0x8f, 0x82,
  0x75, 0x67, 0x58, 0x4b, 0x74, 0x67, 0x59, 0x59, 0x4d, 0x3e, 0x31, 0x24, 0x4c, 0x40, 0x33, 0x18,
  0x4c, 0x3e, 0x31, 0x24, 0x4d, 0x41, 0x34, 0x18, 0x80, 0x73, 0x67, 0x5a, 0x81, 0x73, 0x67, 0x59,
  0xb0, 0xa2, 0x99, 0x8b, 0xb2, 0xa4, 0x98, 0x8c, 0xe3, 0xd8, 0xca, 0xbd, 0xe5, 0xd8, 0xcb, 0xc0,
  0xe5, 0xd5, 0xe3, 0xd9, 0xe4, 0xd8, 0xe0, 0xd8, 0xd5, 0xc9, 0xbe, 0xb0, 0xcc, 0xc0, 0xb4, 0xa6,
  0x9b, 0x8e, 0x81, 0x65, 0x98, 0x8b, 0x71, 0x69, 0xcb, 0xc0, 0xb4, 0xa8, 0xc9, 0xc1, 0xb7, 0xa8,
  0xcd, 0xc2, 0xb7, 0xaa, 0xcd, 0xc2, 0xb6, 0x9b, 0x9a, 0x8c, 0x82, 0x72, 0x9b, 0x8d, 0x81, 0x75,
  0x80, 0x74, 0x67, 0x5c, 0x80, 0x73, 0x67, 0x5b, 0x59, 0x4b, 0x3e, 0x34, 0x59, 0x4d, 0x31, 0x18,
  0x4b, 0x3e, 0x31, 0x25, 0x4c, 0x40, 0x33, 0x18, 0x8e, 0x72, 0x66, 0x59, 0x7f, 0x71, 0x64, 0x58,
  0xb1, 0xa5, 0x9b, 0x8f, 0xb1, 0xa6, 0x96, 0x8a, 0xe2, 0xd4, 0xc8, 0xbe, 0xe2, 0xd5, 0xc9, 0xbf,
  0xe2, 0xe1, 0xd7, 0xd7, 0xe1, 0xdd, 0xd3, 0xd4, 0xc9, 0xbd, 0xb2, 0xa5, 0xc9, 0xbf, 0xb2, 0xa4,
  0x99, 0x8e, 0x80, 0x73, 0x99, 0x8d, 0x81, 0x70, 0xcb, 0xbf, 0xb6, 0xa6, 0xc7, 0xbd, 0xa9, 0xa9,
  0xcc, 0xc2, 0xb6, 0xb6, 0xd7, 0xcd, 0xc2, 0xa9, 0x99, 0x8b, 0x7d, 0x63, 0x9a, 0x8d, 0x81, 0x75,
  0x9c, 0x8d, 0x81, 0x73, 0x9c, 0x8e, 0x80, 0x73, 0x69, 0x5c, 0x58, 0x5a, 0x68, 0x67, 0x57, 0x4e,
  0x4a, 0x3d, 0x31, 0x24, 0x4c, 0x41, 0x34, 0x18, 0x49, 0x3f, 0x30, 0x24, 0x4b, 0x41, 0x33, 0x17,
  0x8d, 0x7e, 0x73, 0x5b, 0x82, 0x7e, 0x66, 0x56, 0xb1, 0xa5, 0x97, 0x8b, 0xae, 0xa3, 0x99, 0x8d,
  0xe2, 0xd3, 0xc9, 0xbd, 0xe1, 0xd4, 0xc8, 0xbb, 0xd4, 0xcd, 0xd8, 0xcb, 0xd4, 0xc6, 0xca, 0xc8,
  0xc8, 0xc8, 0xca, 0xbe, 0xbe, 0xbd, 0xca, 0xa7
};

static const unsigned char palette_19_09_A[] =
{
  0x75, 0x6b, 0x63, 0x5c, 0x73, 0x70, 0x70, 0x66, 0x58, 0x55, 0x53, 0x52, 0x5d, 0x5c, 0x5d, 0x5d,
  0x65, 0x65, 0x65, 0x65, 0x6e, 0x6d, 0x6d, 0x6d, 0x66, 0x66, 0x67, 0x67, 0x6e, 0x6f, 0x6f, 0x70,
  0x51, 0x51, 0x51, 0x53, 0x5d, 0x5d, 0x5d, 0x5d, 0x55, 0x58, 0x5d, 0x65, 0x67, 0x66, 0x6e, 0x69,
  0x58, 0x5b, 0x5f, 0x6b, 0x68, 0x67, 0x6f, 0x75, 0x55, 0x55, 0x56, 0x56, 0x60, 0x60, 0x5f, 0x5f,
  0x5a, 0x58, 0x57, 0x56, 0x67, 0x5e, 0x5f, 0x60, 0x76, 0x6d, 0x65, 0x5f, 0x7c, 0x74, 0x71, 0x68,
  0x6f, 0x68, 0x69, 0x61, 0x78, 0x74, 0x72, 0x71, 0x5e, 0x5b, 0x5a, 0x58, 0x61, 0x60, 0x61, 0x61,
  0x68, 0x68, 0x69, 0x69, 0x70, 0x70, 0x6f, 0x70, 0x6a, 0x6a, 0x6a, 0x6a, 0x71, 0x71, 0x72, 0x72,
  0x58, 0x58, 0x58, 0x59, 0x62, 0x61, 0x61, 0x61, 0x5b, 0x5e, 0x62, 0x6b, 0x6a, 0x69, 0x71, 0x70,
  0x5e, 0x60, 0x64, 0x6e, 0x6c, 0x6b, 0x71, 0x77, 0x5a, 0x5b, 0x5b, 0x5c, 0x64, 0x64, 0x64, 0x63,
  0x5f, 0x5e, 0x5c, 0x5b, 0x6a, 0x63, 0x63, 0x64, 0x77, 0x71, 0x6b, 0x64, 0x7a, 0x75, 0x73, 0x6b,
  0x77, 0x76, 0x6d, 0x67, 0x76, 0x74, 0x74, 0x6c, 0x62, 0x60, 0x5f, 0x5e, 0x66, 0x65, 0x66, 0x66,
  0x6c, 0x6c, 0x6c, 0x6d, 0x75, 0x70, 0x73, 0x73, 0x6d, 0x6d, 0x6e, 0x6e, 0x74, 0x74, 0x74, 0x74,
  0x5d, 0x5d, 0x5e, 0x5f, 0x66, 0x66, 0x66, 0x66, 0x61, 0x63, 0x65, 0x6f, 0x6d, 0x6d, 0x74, 0x73,
  0x64, 0x65, 0x68, 0x6c, 0x6f, 0x6f, 0x74, 0x71, 0x60, 0x60, 0x61, 0x62, 0x69, 0x69, 0x69, 0x69,
  0x66, 0x63, 0x62, 0x61, 0x6a, 0x69, 0x68, 0x68, 0x74, 0x6f, 0x6f, 0x6a, 0x78, 0x7a, 0x77, 0x76,
  0x76, 0x73, 0x72, 0x6e, 0x7c, 0x7a, 0x78, 0x78, 0x69, 0x67, 0x65, 0x64, 0x6c, 0x6b, 0x6a, 0x6a,
  0x71, 0x70, 0x70, 0x70, 0x78, 0x77, 0x75, 0x75, 0x70, 0x71, 0x72, 0x72, 0x75, 0x76, 0x76, 0x77,
  0x64, 0x64, 0x64, 0x66, 0x6b, 0x6b, 0x6b, 0x6c, 0x67, 0x68, 0x6b, 0x72, 0x71, 0x71, 0x77, 0x76,
  0x6a, 0x6b, 0x6e, 0x74, 0x73, 0x73, 0x73, 0x73, 0x67, 0x67, 0x68, 0x69, 0x6f, 0x6f, 0x6e, 0x6e,
  0x6d, 0x6a, 0x69, 0x68, 0x73, 0x6d, 0x6d, 0x6f, 0x79, 0x76, 0x72, 0x75, 0x7c, 0x7c, 0x79, 0x79,
  0x7b, 0x79, 0x78, 0x76, 0x7d, 0x7c, 0x7c, 0x7c, 0x72, 0x6f, 0x6e, 0x6e, 0x74, 0x72, 0x73, 0x72,
  0x79, 0x77, 0x76, 0x76, 0x7c, 0x7b, 0x79, 0x78, 0x75, 0x76, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7a,
  0x6d, 0x6a, 0x6b, 0x6c, 0x72, 0x72, 0x72, 0x73, 0x6d, 0x6f, 0x70, 0x76, 0x71, 0x76, 0x75, 0x79,
  0x71, 0x72, 0x73, 0x78, 0x74, 0x78, 0x78, 0x7d, 0x73, 0x71, 0x70, 0x70, 0x76, 0x76, 0x75, 0x74,
  0x77, 0x74, 0x72, 0x73, 0x79, 0x78, 0x75, 0x76, 0x7f, 0x7d, 0x7b, 0x79, 0x7d, 0x7e, 0x7d, 0x7d,
  0x80, 0x7e, 0x7e, 0x7c, 0x7f, 0x7d, 0x80, 0x80, 0x7c, 0x78, 0x77, 0x78, 0x7c, 0x7f, 0x78, 0x79,
  0x78, 0x76, 0x75, 0x75, 0x7a, 0x7a, 0x7a, 0x7a, 0x7d, 0x7b, 0x7b, 0x7b, 0x7e, 0x7c, 0x7c, 0x7c,
  0x7b, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x76, 0x76, 0x77, 0x7a, 0x7a, 0x79, 0x7b, 0x7d,
  0x7b, 0x7b, 0x7b, 0x7d, 0x7b, 0x7d, 0x7d, 0x7f, 0x7d, 0x7c, 0x7b, 0x7a, 0x7d, 0x7c, 0x7c, 0x7b,
  0x7e, 0x7d, 0x7c, 0x7c, 0x7e, 0x7e, 0x7c, 0x7c, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x83, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x82, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x84, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81,
  0x83, 0x84, 0x83, 0x83, 0x82, 0x82, 0x83, 0x82, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x81, 0x81,
  0x83, 0x82, 0x84, 0x84, 0x81, 0x81, 0x87, 0x85, 0x86, 0x88, 0x88, 0x87, 0x84, 0x85, 0x86, 0x85,
  0x85, 0x87, 0x85, 0x84, 0x85, 0x83, 0x83, 0x83, 0x87, 0x88, 0x87, 0x88, 0x85, 0x85, 0x85, 0x85,
  0x85, 0x85, 0x85, 0x85, 0x83, 0x83, 0x83, 0x83, 0x88, 0x88, 0x87, 0x85, 0x84, 0x85, 0x85, 0x87,
  0x8d, 0x8d, 0x8d, 0x8a, 0x88, 0x88, 0x88, 0x86, 0x8c, 0x8c, 0x8d, 0x8d, 0x88, 0x88, 0x8b, 0x8b,
  0x89, 0x8b, 0x8b, 0x8b, 0x87, 0x87, 0x8a, 0x89, 0x83, 0x83, 0x86, 0x87, 0x82, 0x82, 0x84, 0x84,
  0x83, 0x84, 0x85, 0x85, 0x84, 0x85, 0x87, 0x8a, 0x89, 0x89, 0x8d, 0x8c, 0x8c, 0x8e, 0x8f, 0x90,
  0x8a, 0x89, 0x87, 0x86, 0x8a, 0x89, 0x88, 0x8b, 0x86, 0x86, 0x86, 0x89, 0x8a, 0x8a, 0x8c, 0x8c,
  0x8b, 0x8a, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0x91, 0x8c, 0x8c, 0x88, 0x92, 0x93, 0x92, 0x8f,
  0x86, 0x86, 0x86, 0x87, 0x8c, 0x89, 0x89, 0x89, 0x90, 0x8f, 0x8b, 0x8b, 0x98, 0x97, 0x92, 0x8a,
  0x90, 0x8f, 0x8f, 0x94, 0x96, 0x97, 0x98, 0x98, 0x8b, 0x90, 0x90, 0x90, 0x91, 0x93, 0x94, 0x95,
  0x87, 0x87, 0x8a, 0x8c, 0x87, 0x89, 0x8b, 0x8e, 0x83, 0x87, 0x8c, 0x8c, 0x87, 0x8a, 0x8d, 0x90,
  0x8d, 0x8e, 0x93, 0x92, 0x93, 0x96, 0x96, 0x98, 0x92, 0x92, 0x92, 0x92, 0x99, 0x9c, 0x9d, 0x9f,
  0x8d, 0x8b, 0x8a, 0x8a, 0x8e, 0x8e, 0x91, 0x8f, 0x89, 0x89, 0x89, 0x89, 0x8e, 0x8e, 0x8e, 0x8e,
  0x93, 0x93, 0x8e, 0x8d, 0x9f, 0x9c, 0x99, 0x95, 0x8f, 0x90, 0x96, 0x90, 0x9f, 0x96, 0x9d, 0x97,
  0x94, 0x95, 0x95, 0x95, 0x9b, 0x9d, 0x9e, 0x9e, 0x8e, 0x90, 0x96, 0x95, 0x95, 0x98, 0x9a, 0x9b,
  0x84, 0x89, 0x89, 0x8a, 0x89, 0x8c, 0x8f, 0x92, 0x7f, 0x7b, 0x76, 0x7f, 0x76, 0x70, 0x69, 0x7f,
  0x58, 0x5e, 0x61, 0x5c, 0x64, 0x6d, 0x6b, 0x67, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80,
  0x88, 0x8a, 0x84, 0x80, 0x7f, 0x7d, 0x7d, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x83, 0x83, 0x83, 0x83, 0x83, 0x85, 0x83, 0x83, 0x87, 0x87, 0x87, 0x87, 0x87, 0x88, 0x87, 0x88,
  0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x8b, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8a,
  0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x88,
  0x83, 0x83, 0x83, 0x84, 0x84, 0x83, 0x83, 0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7c,
  0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7c, 0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x78, 0x77,
  0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x74, 0x73, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
  0x75, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x73, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x75,
  0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7d, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x77,
  0x7b, 0x7c, 0x7c, 0x7c, 0x7d, 0x7c, 0x7c, 0x7b, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84,
  0x7b, 0x78, 0x73, 0x69, 0x79, 0x76, 0x72, 0x6d, 0x63, 0x61, 0x63, 0x62, 0x68, 0x65, 0x6a, 0x6a,
  0x63, 0x64, 0x61, 0x5e, 0x6a, 0x66, 0x6b, 0x65, 0x69, 0x6e, 0x6e, 0x6e, 0x6e, 0x72, 0x72, 0x72,
  0x73, 0x77, 0x76, 0x76, 0x76, 0x78, 0x78, 0x7a, 0x77, 0x77, 0x77, 0x77, 0x7a, 0x7b, 0x7a, 0x7a,
  0x6e, 0x6e, 0x6e, 0x63, 0x72, 0x72, 0x73, 0x6f, 0x67, 0x6d, 0x6f, 0x74, 0x74, 0x74, 0x71, 0x76,
  0x77, 0x77, 0x76, 0x7a, 0x7a, 0x7a, 0x7a, 0x79, 0x64, 0x68, 0x6d, 0x73, 0x6d, 0x72, 0x78, 0x78,
  0x5c, 0x5a, 0x58, 0x5e, 0x5d, 0x5d, 0x5e, 0x67, 0x59, 0x59, 0x59, 0x5a, 0x5c, 0x5f, 0x5e, 0x5d,
  0x6c, 0x5f, 0x5f, 0x59, 0x73, 0x66, 0x68, 0x68, 0x67, 0x69, 0x6a, 0x5d, 0x74, 0x6e, 0x75, 0x6f,
  0x56, 0x54, 0x53, 0x51, 0x60, 0x55, 0x56, 0x57, 0x50, 0x53, 0x57, 0x55, 0x56, 0x56, 0x55, 0x55,
  0x70, 0x71, 0x70, 0x6f, 0x75, 0x74, 0x74, 0x75, 0x60, 0x62, 0x61, 0x61, 0x69, 0x69, 0x68, 0x69,
  0x60, 0x60, 0x60, 0x53, 0x69, 0x6a, 0x6a, 0x60, 0x6f, 0x70, 0x70, 0x70, 0x75, 0x76, 0x76, 0x76,
  0x6b, 0x68, 0x71, 0x6f, 0x71, 0x75, 0x75, 0x75, 0x5c, 0x68, 0x6f, 0x75, 0x62, 0x75, 0x75, 0x7a,
  0x5b, 0x62, 0x6b, 0x72, 0x65, 0x6c, 0x72, 0x78, 0x4d, 0x51, 0x51, 0x53, 0x5b, 0x4f, 0x5b, 0x64,
  0x45, 0x4b, 0x49, 0x49, 0x4f, 0x5c, 0x5b, 0x5b, 0x67, 0x5b, 0x53, 0x4c, 0x72, 0x65, 0x5a, 0x5a,
  0x5b, 0x55, 0x59, 0x4c, 0x65, 0x61, 0x62, 0x62, 0x72, 0x6a, 0x6a, 0x6c, 0x77, 0x70, 0x72, 0x71,
  0x45, 0x40, 0x3e, 0x3c, 0x51, 0x4c, 0x4b, 0x4a, 0x57, 0x56, 0x56, 0x56, 0x61, 0x60, 0x61, 0x62,
  0x6a, 0x68, 0x69, 0x6b, 0x70, 0x6f, 0x71, 0x71, 0x3c, 0x3f, 0x44, 0x4b, 0x4a, 0x4b, 0x57, 0x63,
  0x55, 0x55, 0x57, 0x4b, 0x62, 0x62, 0x63, 0x63, 0x6a, 0x6b, 0x6b, 0x6b, 0x72, 0x72, 0x72, 0x72,
  0x52, 0x5b, 0x65, 0x6f, 0x6b, 0x72, 0x71, 0x76, 0x53, 0x52, 0x5e, 0x6e, 0x53, 0x5f, 0x66, 0x73,
  0x35, 0x35, 0x36, 0x3e, 0x46, 0x46, 0x45, 0x46, 0x43, 0x3c, 0x37, 0x35, 0x54, 0x53, 0x53, 0x46,
  0x66, 0x5a, 0x52, 0x4b, 0x6e, 0x68, 0x5f, 0x54, 0x66, 0x5a, 0x53, 0x4b, 0x6d, 0x66, 0x5b, 0x5c,
  0x70, 0x70, 0x6e, 0x67, 0x6e, 0x6e, 0x6e, 0x6f, 0x5b, 0x5e, 0x5c, 0x5c, 0x66, 0x66, 0x66, 0x67,
  0x43, 0x3b, 0x36, 0x33, 0x50, 0x50, 0x50, 0x50, 0x31, 0x31, 0x33, 0x35, 0x50, 0x50, 0x50, 0x50,
  0x5c, 0x5c, 0x5d, 0x5c, 0x67, 0x67, 0x67, 0x67, 0x6f, 0x6f, 0x6f, 0x6f, 0x6e, 0x66, 0x66, 0x6e,
  0x3c, 0x47, 0x54, 0x6e, 0x50, 0x5c, 0x5c, 0x70, 0x39, 0x3d, 0x4b, 0x64, 0x4e, 0x4d, 0x5b, 0x6e,
  0x31, 0x31, 0x32, 0x35, 0x4f, 0x4f, 0x4f, 0x4e, 0x44, 0x3c, 0x37, 0x33, 0x59, 0x4d, 0x4e, 0x4e,
  0x67, 0x5b, 0x54, 0x4b, 0x6c, 0x64, 0x64, 0x59, 0x68, 0x5d, 0x53, 0x4b, 0x74, 0x64, 0x66, 0x58,
  0x6f, 0x6e, 0x6d, 0x65, 0x6a, 0x6c, 0x6d, 0x6d, 0x58, 0x59, 0x59, 0x59, 0x64, 0x63, 0x64, 0x64,
  0x44, 0x3d, 0x38, 0x34, 0x50, 0x4c, 0x4c, 0x4c, 0x32, 0x32, 0x33, 0x36, 0x4b, 0x4b, 0x4b, 0x4c,
  0x58, 0x59, 0x59, 0x59, 0x64, 0x64, 0x64, 0x64, 0x6e, 0x6d, 0x6d, 0x6d, 0x6d, 0x63, 0x63, 0x6d,
  0x3a, 0x40, 0x45, 0x62, 0x58, 0x58, 0x5a, 0x6a, 0x3c, 0x41, 0x47, 0x66, 0x58, 0x59, 0x63, 0x73,
  0x33, 0x33, 0x35, 0x38, 0x4b, 0x4b, 0x4b, 0x4b, 0x45, 0x3e, 0x39, 0x35, 0x57, 0x4b, 0x4b, 0x4a,
  0x69, 0x5e, 0x56, 0x4e, 0x74, 0x6d, 0x64, 0x58, 0x69, 0x5f, 0x56, 0x4e, 0x6e, 0x65, 0x65, 0x59,
  0x6e, 0x64, 0x65, 0x6c, 0x6b, 0x6b, 0x6b, 0x6c, 0x59, 0x57, 0x58, 0x57, 0x62, 0x62, 0x63, 0x63,
  0x46, 0x3f, 0x3b, 0x39, 0x4b, 0x4a, 0x49, 0x49, 0x38, 0x39, 0x3a, 0x3d, 0x4a, 0x4a, 0x4b, 0x4e,
  0x57, 0x58, 0x58, 0x58, 0x63, 0x63, 0x63, 0x63, 0x6d, 0x6d, 0x6c, 0x6c, 0x6c, 0x62, 0x62, 0x6b,
  0x41, 0x45, 0x58, 0x6b, 0x57, 0x57, 0x62, 0x61, 0x45, 0x4a, 0x50, 0x60, 0x57, 0x58, 0x62, 0x74,
  0x3e, 0x3e, 0x3f, 0x41, 0x4b, 0x4b, 0x4b, 0x58, 0x49, 0x44, 0x41, 0x3e, 0x58, 0x57, 0x4b, 0x4b,
  0x72, 0x5f, 0x59, 0x4f, 0x73, 0x6e, 0x65, 0x59, 0x6f, 0x62, 0x59, 0x52, 0x6f, 0x6f, 0x66, 0x64,
  0x63, 0x61, 0x61, 0x61, 0x6a, 0x6b, 0x6c, 0x6c, 0x4d, 0x48, 0x45, 0x43, 0x58, 0x57, 0x58, 0x58,
  0x43, 0x42, 0x44, 0x45, 0x58, 0x59, 0x59, 0x58, 0x62, 0x63, 0x64, 0x64, 0x6c, 0x6c, 0x6d, 0x6c,
  0x49, 0x4e, 0x53, 0x6c, 0x57, 0x63, 0x63, 0x64, 0x4c, 0x51, 0x56, 0x67, 0x58, 0x63, 0x62, 0x74,
  0x46, 0x47, 0x47, 0x49, 0x59, 0x5a, 0x59, 0x59, 0x50, 0x4c, 0x49, 0x49, 0x58, 0x58, 0x58, 0x59,
  0x71, 0x66, 0x5b, 0x55, 0x73, 0x6e, 0x66, 0x65, 0x72, 0x67, 0x5e, 0x57, 0x6e, 0x6f, 0x65, 0x64,
  0x63, 0x62, 0x62, 0x62, 0x6c, 0x6b, 0x6a, 0x6b, 0x52, 0x4f, 0x4d, 0x4b, 0x58, 0x58, 0x59, 0x5a,
  0x4b, 0x4a, 0x4b, 0x4d, 0x57, 0x5a, 0x5a, 0x5a, 0x63, 0x64, 0x66, 0x66, 0x6c, 0x6d, 0x6e, 0x6e,
  0x4f, 0x53, 0x59, 0x6d, 0x59, 0x64, 0x64, 0x66, 0x52, 0x56, 0x5b, 0x69, 0x66, 0x65, 0x64, 0x75,
  0x4e, 0x4e, 0x4e, 0x50, 0x5c, 0x5c, 0x5c, 0x5c, 0x55, 0x52, 0x50, 0x4e, 0x65, 0x5b, 0x5b, 0x5c,
  0x74, 0x69, 0x61, 0x5a, 0x78, 0x6e, 0x70, 0x66, 0x38, 0x3d, 0x41, 0x57, 0x33, 0x3a, 0x3f, 0x4b,
  0x35, 0x52, 0x52, 0x5a, 0x33, 0x3c, 0x4d, 0x58, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x83, 0x81, 0x80, 0x82, 0x84,
  0x7c, 0x7f, 0x7d, 0x7e, 0x7d, 0x7c, 0x7d, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x83, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x83, 0x86, 0x86, 0x87, 0x88, 0x89, 0x89, 0x87, 0x87,
  0x8a, 0x89, 0x89, 0x89, 0x8a, 0x8b, 0x8a, 0x8a, 0x85, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x8c, 0x8a, 0x89, 0x8a, 0x8b, 0x8c, 0x8b, 0x8b, 0x8b, 0x88, 0x88, 0x89, 0x8b, 0x8b, 0x8a, 0x8a,
  0x82, 0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x83, 0x8a, 0x86, 0x87, 0x88, 0x88, 0x88, 0x87, 0x87,
  0x83, 0x82, 0x83, 0x84, 0x84, 0x84, 0x83, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7d,
  0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x76, 0x77, 0x77, 0x76, 0x76, 0x76, 0x77, 0x77,
  0x74, 0x75, 0x74, 0x74, 0x73, 0x74, 0x74, 0x75, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b,
  0x73, 0x75, 0x75, 0x73, 0x73, 0x73, 0x74, 0x74, 0x75, 0x76, 0x77, 0x76, 0x76, 0x75, 0x74, 0x75,
  0x7b, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x77, 0x79, 0x7a, 0x7b, 0x7a, 0x79, 0x78, 0x78,
  0x7d, 0x7c, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x80, 0x80, 0x84, 0x83, 0x84, 0x85, 0x86, 0x86, 0x85, 0x84,
  0x85, 0x89, 0x8d, 0x90, 0x8a, 0x8f, 0x8e, 0x93, 0x91, 0x92, 0x97, 0x99, 0x97, 0x9b, 0x9d, 0x9e,
  0x8f, 0x8f, 0x8d, 0x8d, 0x90, 0x92, 0x96, 0x94, 0x8c, 0x8c, 0x8c, 0x8c, 0x93, 0x92, 0x92, 0x92,
  0x98, 0x97, 0x98, 0x97, 0xa0, 0xa0, 0xa1, 0xa2, 0x98, 0x97, 0x8c, 0x8c, 0xa1, 0xa0, 0x91, 0x99,
  0x94, 0x93, 0x8d, 0x8e, 0x95, 0xa5, 0xa3, 0x9b, 0x9c, 0x9c, 0x9d, 0x9d, 0xa6, 0xa7, 0xa7, 0xa7,
  0x93, 0x94, 0x9c, 0x9c, 0x9b, 0x9f, 0xa3, 0xa4, 0x8f, 0x8b, 0x8b, 0x8c, 0x93, 0x91, 0x97, 0x94,
  0x88, 0x8d, 0x8e, 0x8f, 0x8b, 0x8e, 0x93, 0x97, 0x94, 0x95, 0x98, 0xa0, 0x9c, 0xa0, 0xa4, 0xa8,
  0xa0, 0xa0, 0xa1, 0xa0, 0xaa, 0xad, 0xae, 0xae, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x97, 0x97, 0x97,
  0x8f, 0x8f, 0x90, 0x90, 0x97, 0x97, 0x97, 0x90, 0xa0, 0x96, 0x96, 0x90, 0xac, 0xaa, 0xa7, 0x9d,
  0x99, 0x99, 0x99, 0x90, 0xaf, 0xab, 0xa0, 0x92, 0xa3, 0xa3, 0xa4, 0xa4, 0xb2, 0xb4, 0xb4, 0xb2,
  0x98, 0xa3, 0xa2, 0xa2, 0xa6, 0xaa, 0xae, 0xb1, 0x8f, 0x8f, 0x97, 0x98, 0x90, 0x97, 0x9e, 0xa3,
  0x8a, 0x8f, 0x90, 0x9d, 0x92, 0x98, 0x9e, 0xa4, 0xa5, 0xa4, 0xb1, 0xb1, 0xab, 0xb1, 0xb6, 0xb9,
  0x91, 0x92, 0x92, 0x91, 0x99, 0x9a, 0x98, 0x9a, 0x9a, 0x9a, 0x9a, 0x9b, 0xa4, 0xa5, 0xa5, 0xa5,
  0x91, 0x92, 0x92, 0x92, 0x91, 0x91, 0x9b, 0x92, 0xb1, 0xb2, 0xa6, 0xa6, 0xba, 0xba, 0xb8, 0xb7,
  0x9c, 0xa7, 0x9b, 0x94, 0xb3, 0xaf, 0xa9, 0xa2, 0x9c, 0x9c, 0x9a, 0x93, 0xa7, 0xb7, 0xb2, 0xa4,
  0xb3, 0xb4, 0xa6, 0xa7, 0xbf, 0xbf, 0xbf, 0xbc, 0xa7, 0xa7, 0xa6, 0xa6, 0xac, 0xb2, 0xb6, 0xbb,
  0x8b, 0x91, 0x91, 0x92, 0x8c, 0x92, 0x99, 0xa2, 0x8b, 0x91, 0x92, 0x99, 0x94, 0x99, 0x9f, 0xa5,
  0xa9, 0xa6, 0xa6, 0xa6, 0xaf, 0xb3, 0xb8, 0xbc, 0x93, 0x93, 0x92, 0x93, 0x9a, 0x9b, 0x9b, 0x9c,
  0x92, 0x9b, 0x9c, 0x9d, 0x9b, 0xa7, 0xa7, 0xa8, 0x93, 0x93, 0x93, 0x93, 0x9d, 0xa8, 0xa9, 0x9d,
  0xb4, 0xb4, 0xb5, 0xb5, 0xc0, 0xc2, 0xc3, 0xbd, 0x9d, 0xa0, 0x93, 0x95, 0xb4, 0xb1, 0xa8, 0x9f,
  0xa8, 0xa8, 0xa7, 0x93, 0xb9, 0xbb, 0xb1, 0x9f, 0xa9, 0xb6, 0xb5, 0xb7, 0xa8, 0xc1, 0xc3, 0xc4,
  0xa7, 0xa7, 0xa7, 0xb5, 0xaf, 0xb5, 0xbc, 0xbf, 0x8c, 0x92, 0x9c, 0x9c, 0x92, 0x9a, 0xa2, 0xa9,
  0x8c, 0x91, 0x92, 0x9b, 0x92, 0x99, 0xa1, 0xa8, 0xa6, 0xa6, 0xa6, 0xb4, 0xae, 0xb3, 0xb9, 0xbf,
  0x92, 0x91, 0x93, 0x93, 0x9b, 0x9c, 0x9a, 0x9b, 0x9b, 0x9b, 0x9c, 0x9c, 0xa6, 0xa6, 0xa7, 0xa8,
  0x91, 0x92, 0x93, 0x95, 0x91, 0x92, 0x92, 0x93, 0x9c, 0x9c, 0xa7, 0x9e, 0xb4, 0xa8, 0xb2, 0xa1,
  0xa6, 0xa6, 0xa7, 0x94, 0xb7, 0xb4, 0xb7, 0x9b, 0xb5, 0xb5, 0xb5, 0xb5, 0xc3, 0xc5, 0xc5, 0xbf,
  0xb4, 0xb4, 0xb4, 0xb5, 0xc2, 0xbf, 0xc6, 0xbf, 0xa6, 0xa6, 0xa6, 0xb4, 0xad, 0xb2, 0xb8, 0xbe,
  0x8a, 0x91, 0x93, 0x9c, 0x92, 0x99, 0xa0, 0xa7, 0x8b, 0x90, 0x91, 0x9b, 0x93, 0x9b, 0xa2, 0xa8,
  0xa6, 0xa5, 0xb1, 0xb5, 0xae, 0xb4, 0xb9, 0xbe, 0x9b, 0x9a, 0x9a, 0x9a, 0x9b, 0xa5, 0xa5, 0xa5,
  0xa5, 0xa6, 0xa6, 0xa6, 0xa7, 0xa8, 0xa8, 0xa7, 0x91, 0x91, 0x92, 0x92, 0x92, 0x92, 0x91, 0x92,
  0xb8, 0xa4, 0xa4, 0x9d, 0x9b, 0x9a, 0x92, 0x95, 0xb2, 0xb2, 0xb3, 0xb3, 0xc2, 0xc6, 0xc4, 0xbd,
  0xb1, 0xb1, 0xb1, 0xb1, 0xc2, 0xc5, 0xc1, 0xc5, 0xb1, 0xb2, 0xb2, 0xa6, 0xa4, 0xa4, 0xa5, 0xad,
  0xa3, 0xa3, 0xb0, 0xb1, 0xae, 0xb4, 0xba, 0xbf, 0x8b, 0x90, 0x99, 0x9a, 0x92, 0x99, 0xa2, 0xa8,
  0x92, 0x99, 0xa1, 0xa8, 0x8b, 0x8f, 0x98, 0x99, 0x91, 0x9a, 0x99, 0xa2, 0x91, 0x91, 0x91, 0x99,
  0xae, 0xb3, 0xba, 0xbf, 0xa1, 0xa2, 0xae, 0xae, 0xa2, 0xa2, 0xa2, 0xa3, 0x98, 0x98, 0x98, 0x99,
  0xc2, 0xc6, 0xc7, 0xbf, 0xae, 0xb0, 0xaf, 0xaf, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x94,
  0xa3, 0xa3, 0xad, 0xb8, 0x99, 0x99, 0xa3, 0xae, 0xac, 0xa1, 0xb5, 0xa9, 0xad, 0xa1, 0xa1, 0x99,
  0xc3, 0xc8, 0xcb, 0xc1, 0xac, 0xb9, 0xb9, 0xad, 0xaf, 0xb4, 0xbb, 0xc0, 0x9f, 0xab, 0xab, 0xac,
  0x92, 0x9a, 0xa2, 0xa9, 0x8c, 0x8f, 0x97, 0xa0, 0x93, 0x9b, 0xa2, 0xa9, 0x8b, 0x8f, 0x96, 0x9e,
  0xb0, 0xb7, 0xc2, 0xc6, 0xa7, 0xa7, 0xa8, 0xb4, 0x9f, 0xa8, 0xaa, 0xaa, 0x9f, 0x9f, 0x9f, 0x9f,
  0xb5, 0xc9, 0xca, 0xcd, 0xb5, 0xb5, 0xb9, 0xb1, 0x96, 0x9d, 0x96, 0x96, 0x90, 0x90, 0x8f, 0x8f,
  0x96, 0x96, 0x96, 0x96, 0x8f, 0x8f, 0x8f, 0x8f, 0x96, 0x96, 0x96, 0x8f, 0x96, 0x8f, 0x8f, 0x90,
  0xa9, 0xa9, 0xa8, 0xa4, 0x9e, 0x9f, 0x9f, 0x9f, 0xa7, 0xa7, 0xab, 0xa0, 0x9d, 0x9c, 0x94, 0x8e,
  0xcb, 0xcb, 0xc0, 0xb5, 0xb1, 0xb2, 0xb2, 0xa7, 0x95, 0x9e, 0xa6, 0xa6, 0x94, 0x9c, 0x9c, 0xa7,
  0xb1, 0xb7, 0xc1, 0xc7, 0xa6, 0xa7, 0xb1, 0xb1, 0x92, 0x9b, 0xa3, 0xab, 0x8c, 0x93, 0x9c, 0x9d,
  0xc8, 0xc7, 0xc2, 0xc6, 0xc4, 0xc6, 0xca, 0xcd, 0xc6, 0xc1, 0xc9, 0xc5, 0xc6, 0xc3, 0xbf, 0xc2,
  0x91, 0x91, 0x99, 0x93, 0x8a, 0x8c, 0x8c, 0x8d, 0xa1, 0xa9, 0xb4, 0xba, 0x99, 0x9b, 0xa3, 0xad,
  0xc2, 0xc7, 0xc9, 0xbf, 0xae, 0xae, 0xae, 0xad, 0x93, 0x9a, 0x92, 0x92, 0x8d, 0x93, 0x8c, 0x8c,
  0xa4, 0xa4, 0xa3, 0xa3, 0x9a, 0x9a, 0x9a, 0x9a, 0x92, 0x93, 0x93, 0x93, 0x8c, 0x8c, 0x8d, 0x8d,
  0xa3, 0xa2, 0xae, 0xa5, 0x98, 0x9a, 0xa3, 0x9a, 0x9a, 0x93, 0x9b, 0x93, 0x93, 0x8c, 0x8c, 0x8c,
  0xa7, 0x9e, 0x97, 0x90, 0x97, 0x97, 0x90, 0x8a, 0xbf, 0xb8, 0xb3, 0xad, 0xaa, 0xaa, 0xaa, 0xa0,
  0xa8, 0xb2, 0xb9, 0xc0, 0x9f, 0xa0, 0xa8, 0xa9, 0x8a, 0x90, 0x98, 0xa1, 0x87, 0x8b, 0x8f, 0x96,
  0x8a, 0x8f, 0x96, 0xa0, 0x88, 0x89, 0x8d, 0x93, 0xa9, 0xb2, 0xb8, 0xb8, 0x9b, 0xa3, 0xa3, 0xad,
  0xb2, 0xad, 0xa9, 0xa5, 0xa4, 0xa5, 0x9e, 0x9d, 0x8f, 0x94, 0x9c, 0x9d, 0x8a, 0x8f, 0x94, 0x94,
  0x8f, 0x8e, 0x8e, 0x8e, 0x8a, 0x89, 0x89, 0x89, 0x9a, 0xa4, 0x9a, 0x9b, 0x94, 0x94, 0x94, 0x94,
  0x8e, 0x8f, 0x94, 0x8e, 0x89, 0x8e, 0x89, 0x89, 0xa0, 0x9a, 0x93, 0x89, 0x95, 0x8f, 0x8e, 0x89,
  0x9a, 0x94, 0x90, 0x8b, 0x92, 0x8c, 0x88, 0x86, 0xa8, 0xa4, 0xa1, 0x9e, 0x9f, 0x99, 0x99, 0x92,
  0xa9, 0xb0, 0xb3, 0xad, 0x9d, 0x9d, 0xa5, 0x9c, 0x8a, 0x8f, 0x96, 0xa1, 0x85, 0x8c, 0x8f, 0x98,
  0x88, 0x8d, 0x98, 0xa1, 0x89, 0x88, 0x8c, 0x98, 0xa9, 0xab, 0xa8, 0xa3, 0x99, 0xa0, 0x9f, 0x97,
  0x93, 0x92, 0x97, 0x98, 0x8e, 0x8e, 0x92, 0x92, 0x8a, 0x87, 0x8e, 0x8d, 0x87, 0x86, 0x8a, 0x89,
  0x92, 0x92, 0x8e, 0x8e, 0x8d, 0x8d, 0x8a, 0x8a, 0x89, 0x89, 0x86, 0x8a, 0x86, 0x86, 0x86, 0x86,
  0x9f, 0x9b, 0x98, 0x98, 0x99, 0x92, 0x94, 0x8e, 0x94, 0x8f, 0x8c, 0x86, 0x86, 0x8a, 0x8a, 0x88,
  0x8d, 0x8a, 0x88, 0x86, 0x87, 0x87, 0x85, 0x83, 0x97, 0x94, 0x92, 0x91, 0x93, 0x8f, 0x8a, 0x8a,
  0xa2, 0x9f, 0x9f, 0x9a, 0x97, 0x97, 0x92, 0x92, 0x89, 0x8c, 0x99, 0xa2, 0x86, 0x87, 0x8f, 0x93,
  0x87, 0x84, 0x86, 0x8e, 0x83, 0x82, 0x85, 0x8a, 0x92, 0x96, 0x96, 0x96, 0x8d, 0x92, 0x91, 0x91,
  0x8c, 0x8c, 0x8c, 0x94, 0x88, 0x8a, 0x8a, 0x8c, 0x84, 0x88, 0x88, 0x85, 0x82, 0x85, 0x83, 0x83,
  0x8d, 0x8e, 0x8f, 0x8d, 0x8b, 0x8a, 0x8a, 0x8a, 0x87, 0x86, 0x86, 0x86, 0x85, 0x84, 0x84, 0x84,
  0x86, 0x84, 0x8a, 0x89, 0x84, 0x82, 0x86, 0x83, 0x84, 0x86, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82,
  0x84, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x86, 0x88, 0x87, 0x85, 0x85, 0x85, 0x82, 0x82,
  0x87, 0x83, 0x89, 0x88, 0x85, 0x85, 0x86, 0x87, 0x84, 0x87, 0x89, 0x88, 0x84, 0x84, 0x86, 0x87,
  0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7a, 0x80, 0x80, 0x7d, 0x80, 0x80, 0x80, 0x7f,
  0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x80,
  0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x7c, 0x7c, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x76, 0x78, 0x7c, 0x7c, 0x78, 0x7d, 0x7d, 0x7d,
  0x77, 0x76, 0x75, 0x76, 0x7a, 0x76, 0x7b, 0x7c, 0x7c, 0x76, 0x77, 0x78, 0x7b, 0x7b, 0x77, 0x7a,
  0x7b, 0x70, 0x72, 0x77, 0x7c, 0x70, 0x72, 0x7a, 0x70, 0x70, 0x72, 0x70, 0x72, 0x73, 0x74, 0x70,
  0x6d, 0x6d, 0x6e, 0x70, 0x75, 0x75, 0x75, 0x76, 0x78, 0x77, 0x79, 0x75, 0x79, 0x79, 0x7b, 0x78,
  0x7a, 0x7b, 0x7a, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x78, 0x77, 0x77, 0x73, 0x78, 0x79, 0x79, 0x7a,
  0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x7e, 0x7d, 0x7d, 0x7b, 0x7c, 0x78, 0x7d, 0x7c, 0x7d, 0x79, 0x7d,
  0x78, 0x79, 0x7b, 0x7c, 0x7b, 0x7c, 0x7c, 0x7e, 0x75, 0x76, 0x79, 0x7b, 0x79, 0x7b, 0x7b, 0x7d,
  0x73, 0x66, 0x6a, 0x72, 0x73, 0x6b, 0x71, 0x77, 0x69, 0x6b, 0x68, 0x65, 0x6f, 0x6f, 0x6f, 0x70,
  0x6c, 0x67, 0x6a, 0x69, 0x72, 0x6d, 0x6d, 0x6e, 0x87, 0x8d, 0x87, 0x8c, 0x77, 0x80, 0x89, 0x8a,
  0x8d, 0x8d, 0x93, 0x93, 0x97, 0x94, 0x99, 0xa6
};

static const unsigned char palette_19_09_B[] =
{
  0x79, 0x76, 0x74, 0x72, 0x7a, 0x79, 0x78, 0x75, 0x6f, 0x6b, 0x68, 0x67, 0x71, 0x6e, 0x6d, 0x6c,
  0x73, 0x71, 0x71, 0x71, 0x77, 0x75, 0x75, 0x75, 0x72, 0x72, 0x72, 0x72, 0x76, 0x77, 0x77, 0x76,
  0x65, 0x65, 0x65, 0x66, 0x6c, 0x6c, 0x6c, 0x6c, 0x68, 0x6a, 0x6d, 0x72, 0x72, 0x72, 0x77, 0x74,
  0x65, 0x68, 0x6b, 0x72, 0x70, 0x70, 0x75, 0x79, 0x62, 0x61, 0x62, 0x63, 0x69, 0x69, 0x69, 0x69,
  0x6d, 0x69, 0x65, 0x63, 0x72, 0x6b, 0x6a, 0x69, 0x77, 0x75, 0x73, 0x70, 0x7d, 0x79, 0x78, 0x73,
  0x73, 0x71, 0x71, 0x6e, 0x77, 0x77, 0x76, 0x76, 0x6a, 0x66, 0x62, 0x60, 0x6b, 0x68, 0x67, 0x66,
  0x6f, 0x6e, 0x6d, 0x6c, 0x74, 0x72, 0x71, 0x72, 0x6d, 0x6e, 0x6e, 0x6d, 0x73, 0x74, 0x74, 0x74,
  0x5f, 0x5e, 0x5f, 0x60, 0x66, 0x66, 0x66, 0x66, 0x63, 0x66, 0x69, 0x71, 0x6e, 0x6e, 0x73, 0x74,
  0x60, 0x63, 0x67, 0x6f, 0x6c, 0x6c, 0x72, 0x77, 0x5b, 0x5b, 0x5c, 0x5e, 0x63, 0x63, 0x64, 0x64,
  0x67, 0x63, 0x5f, 0x5c, 0x6e, 0x66, 0x64, 0x64, 0x75, 0x72, 0x6f, 0x6c, 0x7a, 0x76, 0x75, 0x6f,
  0x76, 0x74, 0x6c, 0x69, 0x74, 0x74, 0x73, 0x6d, 0x64, 0x5f, 0x5c, 0x5a, 0x67, 0x63, 0x62, 0x61,
  0x6c, 0x6a, 0x69, 0x68, 0x72, 0x71, 0x6f, 0x6f, 0x69, 0x6a, 0x6a, 0x6a, 0x71, 0x72, 0x72, 0x72,
  0x58, 0x58, 0x59, 0x5b, 0x61, 0x61, 0x61, 0x61, 0x5d, 0x61, 0x64, 0x6e, 0x6a, 0x6a, 0x71, 0x71,
  0x5b, 0x5e, 0x63, 0x67, 0x69, 0x69, 0x70, 0x6d, 0x55, 0x55, 0x56, 0x58, 0x5f, 0x5e, 0x5e, 0x5f,
  0x61, 0x5c, 0x58, 0x56, 0x66, 0x63, 0x60, 0x5f, 0x71, 0x69, 0x6b, 0x66, 0x78, 0x76, 0x72, 0x72,
  0x6e, 0x67, 0x69, 0x60, 0x75, 0x77, 0x72, 0x72, 0x5d, 0x58, 0x55, 0x53, 0x61, 0x5f, 0x5d, 0x5d,
  0x69, 0x66, 0x66, 0x66, 0x71, 0x6f, 0x6e, 0x6f, 0x67, 0x67, 0x67, 0x67, 0x6f, 0x6f, 0x6f, 0x6f,
  0x52, 0x52, 0x53, 0x55, 0x5d, 0x5d, 0x5c, 0x5d, 0x58, 0x5c, 0x60, 0x6b, 0x67, 0x67, 0x6f, 0x6f,
  0x55, 0x59, 0x5e, 0x6a, 0x67, 0x67, 0x66, 0x66, 0x4f, 0x4f, 0x50, 0x52, 0x5b, 0x5c, 0x5c, 0x5c,
  0x5b, 0x57, 0x53, 0x4f, 0x67, 0x5d, 0x5c, 0x5c, 0x6e, 0x67, 0x61, 0x69, 0x78, 0x75, 0x70, 0x71,
  0x6e, 0x69, 0x6a, 0x62, 0x77, 0x76, 0x70, 0x71, 0x5c, 0x56, 0x53, 0x4f, 0x62, 0x5f, 0x5b, 0x5b,
  0x67, 0x66, 0x65, 0x65, 0x70, 0x6e, 0x6d, 0x6d, 0x65, 0x66, 0x66, 0x66, 0x6e, 0x6e, 0x6e, 0x6e,
  0x4c, 0x4b, 0x4d, 0x4f, 0x5b, 0x5b, 0x5b, 0x5b, 0x52, 0x57, 0x5c, 0x69, 0x5a, 0x65, 0x65, 0x6e,
  0x4f, 0x54, 0x59, 0x67, 0x5a, 0x65, 0x64, 0x74, 0x4b, 0x4a, 0x4a, 0x4c, 0x58, 0x59, 0x59, 0x5a,
  0x5e, 0x58, 0x53, 0x4f, 0x67, 0x65, 0x5a, 0x59, 0x76, 0x6f, 0x68, 0x62, 0x75, 0x76, 0x71, 0x6f,
  0x76, 0x6f, 0x69, 0x63, 0x74, 0x71, 0x70, 0x6f, 0x5f, 0x59, 0x53, 0x4e, 0x67, 0x65, 0x59, 0x59,
  0x4b, 0x49, 0x49, 0x49, 0x59, 0x5a, 0x5a, 0x5a, 0x65, 0x64, 0x65, 0x65, 0x6d, 0x6d, 0x6e, 0x6e,
  0x65, 0x65, 0x64, 0x63, 0x6d, 0x6d, 0x6c, 0x6c, 0x4c, 0x51, 0x57, 0x65, 0x59, 0x59, 0x64, 0x6c,
  0x4a, 0x4e, 0x54, 0x64, 0x59, 0x64, 0x64, 0x6c, 0x4b, 0x48, 0x47, 0x48, 0x58, 0x58, 0x58, 0x59,
  0x5f, 0x5a, 0x54, 0x4f, 0x66, 0x66, 0x59, 0x58, 0x77, 0x6f, 0x69, 0x64, 0x75, 0x76, 0x6f, 0x6f,
  0x76, 0x6f, 0x6a, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x5f, 0x5a, 0x54, 0x4f, 0x67, 0x65, 0x59, 0x57,
  0x4b, 0x49, 0x47, 0x47, 0x57, 0x57, 0x58, 0x59, 0x65, 0x64, 0x64, 0x65, 0x6e, 0x6d, 0x6e, 0x6e,
  0x64, 0x63, 0x63, 0x63, 0x6d, 0x6c, 0x6c, 0x6c, 0x49, 0x4c, 0x51, 0x61, 0x58, 0x58, 0x59, 0x6d,
  0x48, 0x4b, 0x4f, 0x62, 0x59, 0x5a, 0x64, 0x6b, 0x4c, 0x49, 0x47, 0x46, 0x56, 0x58, 0x58, 0x58,
  0x60, 0x5a, 0x54, 0x4f, 0x66, 0x66, 0x59, 0x58, 0x79, 0x6f, 0x69, 0x64, 0x77, 0x72, 0x6f, 0x6e,
  0x77, 0x70, 0x69, 0x65, 0x72, 0x70, 0x70, 0x6d, 0x60, 0x5a, 0x54, 0x50, 0x67, 0x65, 0x5a, 0x59,
  0x64, 0x65, 0x65, 0x65, 0x6e, 0x6e, 0x6e, 0x6e, 0x4d, 0x48, 0x46, 0x46, 0x58, 0x57, 0x59, 0x59,
  0x65, 0x65, 0x64, 0x63, 0x6d, 0x6d, 0x6c, 0x6c, 0x46, 0x48, 0x4d, 0x59, 0x5b, 0x59, 0x63, 0x63,
  0x46, 0x48, 0x4c, 0x5a, 0x5a, 0x5a, 0x5a, 0x64, 0x4c, 0x49, 0x46, 0x46, 0x59, 0x59, 0x4c, 0x4c,
  0x5f, 0x5b, 0x56, 0x50, 0x67, 0x66, 0x5b, 0x59, 0x77, 0x6f, 0x68, 0x65, 0x77, 0x73, 0x6f, 0x6e,
  0x74, 0x72, 0x77, 0x6e, 0x76, 0x6f, 0x69, 0x64, 0x66, 0x65, 0x5b, 0x5a, 0x5f, 0x5b, 0x55, 0x51,
  0x70, 0x70, 0x6f, 0x6f, 0x70, 0x65, 0x64, 0x67, 0x6f, 0x6e, 0x6e, 0x66, 0x66, 0x66, 0x5a, 0x5a,
  0x5a, 0x5c, 0x4d, 0x4c, 0x4c, 0x4a, 0x47, 0x45, 0x4d, 0x5b, 0x5b, 0x65, 0x46, 0x46, 0x4b, 0x58,
  0x6d, 0x6d, 0x6d, 0x6c, 0x5b, 0x65, 0x64, 0x64, 0x5c, 0x5c, 0x66, 0x65, 0x47, 0x4a, 0x59, 0x66,
  0x5b, 0x5c, 0x5c, 0x4f, 0x4a, 0x47, 0x46, 0x46, 0x68, 0x5c, 0x5b, 0x5b, 0x5a, 0x55, 0x51, 0x4e,
  0x70, 0x70, 0x68, 0x66, 0x6f, 0x69, 0x65, 0x60, 0x78, 0x71, 0x71, 0x6a, 0x70, 0x6b, 0x66, 0x62,
  0x69, 0x67, 0x5e, 0x5e, 0x5e, 0x5a, 0x57, 0x51, 0x5d, 0x5d, 0x5e, 0x5e, 0x4d, 0x49, 0x48, 0x47,
  0x71, 0x71, 0x71, 0x70, 0x72, 0x66, 0x69, 0x68, 0x6f, 0x6f, 0x6f, 0x6f, 0x68, 0x67, 0x67, 0x67,
  0x5d, 0x5d, 0x66, 0x67, 0x49, 0x4b, 0x51, 0x5a, 0x68, 0x68, 0x5e, 0x67, 0x51, 0x5e, 0x54, 0x5f,
  0x5f, 0x5f, 0x5f, 0x5f, 0x54, 0x51, 0x50, 0x50, 0x6a, 0x69, 0x60, 0x5f, 0x61, 0x5d, 0x5a, 0x57,
  0x77, 0x71, 0x71, 0x70, 0x70, 0x6c, 0x68, 0x64, 0x49, 0x4a, 0x51, 0x51, 0x49, 0x4a, 0x52, 0x47,
  0x5e, 0x59, 0x56, 0x5e, 0x52, 0x4a, 0x4d, 0x50, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x7d,
  0x76, 0x81, 0x84, 0x82, 0x81, 0x80, 0x7b, 0x73, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x77, 0x77, 0x77, 0x77, 0x76, 0x75, 0x77, 0x76,
  0x7c, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
  0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x84, 0x83, 0x84, 0x84, 0x85, 0x86, 0x86, 0x86,
  0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89,
  0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x85,
  0x8b, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8c, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b,
  0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x87, 0x87, 0x87, 0x87, 0x87, 0x88, 0x88, 0x87,
  0x82, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7a,
  0x7c, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x77, 0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x77,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x7b, 0x7a, 0x7b, 0x7b, 0x7b, 0x7a, 0x7b, 0x7b,
  0x75, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x76, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x74,
  0x91, 0x9a, 0xa3, 0xba, 0x8e, 0x98, 0xa4, 0xb2, 0xd1, 0xdf, 0xce, 0xd1, 0xbc, 0xc8, 0xc3, 0xc2,
  0xce, 0xc9, 0xd0, 0xd5, 0xc3, 0xc0, 0xc3, 0xc3, 0xc2, 0xb4, 0xb4, 0xb5, 0xb3, 0xa6, 0xa8, 0xa4,
  0xa4, 0x99, 0x99, 0x9a, 0x98, 0x90, 0x91, 0x92, 0x9a, 0x9b, 0x9b, 0x9c, 0x92, 0x91, 0x92, 0x92,
  0xb5, 0xb4, 0xb4, 0xcc, 0xa4, 0xa5, 0xa6, 0xb3, 0xbc, 0xb6, 0xac, 0xa1, 0xa7, 0xa7, 0xa5, 0x9a,
  0x9c, 0x9c, 0x9a, 0x92, 0x92, 0x92, 0x92, 0x92, 0xb5, 0xab, 0xa1, 0x98, 0xa3, 0x99, 0x90, 0x8f,
  0xc1, 0xc6, 0xcb, 0xbb, 0xbe, 0xbd, 0xc0, 0xb0, 0xdc, 0xc8, 0xca, 0xc6, 0xc5, 0xbf, 0xbe, 0xbe,
  0xa3, 0xbb, 0xbd, 0xc9, 0x98, 0xaf, 0xb0, 0xb2, 0x9e, 0xa2, 0xa2, 0xaf, 0x8d, 0x96, 0x8d, 0x97,
  0xbb, 0xd3, 0xbf, 0xc2, 0xac, 0xbc, 0xba, 0xb9, 0xc2, 0xbd, 0xb9, 0xbc, 0xb8, 0xb9, 0xb9, 0xb8,
  0x97, 0x96, 0x97, 0x97, 0x8d, 0x8e, 0x8f, 0x90, 0xac, 0xaf, 0xae, 0xae, 0xa2, 0xa3, 0xa2, 0xa0,
  0xad, 0xad, 0xac, 0xbd, 0xa1, 0xa1, 0xa2, 0xac, 0x97, 0x97, 0x98, 0x98, 0x90, 0x90, 0x90, 0x90,
  0xa2, 0xa0, 0x99, 0x97, 0x99, 0x90, 0x91, 0x91, 0xb4, 0xa1, 0x98, 0x90, 0xaa, 0x91, 0x90, 0x89,
  0xa9, 0xa0, 0x97, 0x8f, 0x9c, 0x94, 0x8e, 0x89, 0xb6, 0xb1, 0xb1, 0xb3, 0xa8, 0xb3, 0xa8, 0x9d,
  0xbe, 0xb8, 0xba, 0xbb, 0xb4, 0xaa, 0xa9, 0xa8, 0x97, 0xa5, 0xaf, 0xb7, 0x8c, 0x9f, 0xa7, 0xa7,
  0xa3, 0xad, 0xa6, 0xb5, 0x95, 0x9b, 0x9b, 0x9b, 0x8a, 0x92, 0x93, 0x91, 0x86, 0x8a, 0x8a, 0x8a,
  0xbb, 0xbf, 0xc1, 0xc2, 0xae, 0xaf, 0xae, 0xae, 0xa4, 0xa3, 0xa2, 0xa2, 0x9b, 0x9a, 0x99, 0x9a,
  0x92, 0x92, 0x92, 0x92, 0x8c, 0x8c, 0x8c, 0x8c, 0xc2, 0xbd, 0xb5, 0xad, 0xad, 0xad, 0xa2, 0x9b,
  0xa3, 0xa2, 0xa2, 0xad, 0x9a, 0x9a, 0x9a, 0x9b, 0x93, 0x93, 0x93, 0x93, 0x8c, 0x8c, 0x8d, 0x8c,
  0xa4, 0x9c, 0x94, 0x8c, 0x93, 0x8c, 0x8d, 0x88, 0x9c, 0x9c, 0x94, 0x8a, 0x9d, 0x95, 0x8f, 0x87,
  0xb4, 0xb4, 0xb2, 0xac, 0xa6, 0xa7, 0xa6, 0xa6, 0xab, 0xaf, 0xb1, 0xb2, 0x9e, 0x9c, 0x9c, 0xa6,
  0x90, 0x9b, 0xa2, 0xa6, 0x89, 0x8f, 0x97, 0x9f, 0x8b, 0x94, 0x98, 0x9b, 0x87, 0x8c, 0x93, 0x92,
  0x87, 0x86, 0x86, 0x8b, 0x87, 0x88, 0x88, 0x88, 0x91, 0x91, 0x92, 0x91, 0x8c, 0x8d, 0x8d, 0x8c,
  0x9d, 0xa0, 0xa2, 0xa5, 0x97, 0x96, 0x95, 0x95, 0xa6, 0xa6, 0xa5, 0xa5, 0x96, 0x96, 0x97, 0x98,
  0x91, 0x91, 0x91, 0x91, 0x8c, 0x8c, 0x8c, 0x8c, 0x88, 0x88, 0x88, 0x88, 0x89, 0x8c, 0x8d, 0x88,
  0xa0, 0x9b, 0x94, 0x89, 0x97, 0x92, 0x91, 0x87, 0x97, 0x96, 0x91, 0x89, 0x91, 0x91, 0x8c, 0x85,
  0x98, 0x99, 0x99, 0x98, 0x8e, 0x8f, 0x90, 0x91, 0x93, 0x95, 0x96, 0x97, 0x8c, 0x90, 0x8f, 0x8f,
  0x87, 0x8d, 0x90, 0x92, 0x85, 0x89, 0x89, 0x8d, 0x85, 0x87, 0x89, 0x8a, 0x81, 0x85, 0x84, 0x87,
  0x82, 0x82, 0x82, 0x84, 0x83, 0x84, 0x84, 0x84, 0x87, 0x88, 0x88, 0x88, 0x85, 0x86, 0x86, 0x85,
  0x8b, 0x8b, 0x8b, 0x8c, 0x89, 0x89, 0x89, 0x88, 0x8d, 0x8d, 0x8d, 0x8d, 0x89, 0x89, 0x8a, 0x8a,
  0x87, 0x87, 0x87, 0x87, 0x85, 0x84, 0x84, 0x85, 0x83, 0x83, 0x83, 0x83, 0x83, 0x85, 0x85, 0x84,
  0x8c, 0x8b, 0x8a, 0x85, 0x88, 0x88, 0x87, 0x84, 0x85, 0x85, 0x85, 0x82, 0x84, 0x84, 0x83, 0x80,
  0x86, 0x86, 0x86, 0x85, 0x84, 0x85, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x83, 0x85, 0x85, 0x84,
  0x83, 0x84, 0x84, 0x85, 0x80, 0x81, 0x82, 0x83, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80,
  0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7b, 0x7c, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
  0x7a, 0x7a, 0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7e, 0x7e, 0x7d, 0x7c, 0x7b, 0x7d, 0x7d, 0x7d, 0x7c,
  0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7b, 0x7e, 0x7e, 0x7d, 0x7c,
  0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7b, 0x79, 0x78, 0x76, 0x7b, 0x7c, 0x7a, 0x7a,
  0x74, 0x75, 0x75, 0x75, 0x7a, 0x7a, 0x7a, 0x7a, 0x7c, 0x7c, 0x7b, 0x7b, 0x7d, 0x7d, 0x7d, 0x7d,
  0x76, 0x77, 0x78, 0x7e, 0x7a, 0x7c, 0x7d, 0x7d, 0x72, 0x73, 0x75, 0x7b, 0x77, 0x7a, 0x7a, 0x7d,
  0x70, 0x70, 0x70, 0x71, 0x76, 0x76, 0x76, 0x76, 0x77, 0x75, 0x73, 0x70, 0x78, 0x77, 0x76, 0x76,
  0x7c, 0x7b, 0x7a, 0x79, 0x7d, 0x7d, 0x7b, 0x7b, 0x7b, 0x79, 0x78, 0x77, 0x7b, 0x7b, 0x79, 0x79,
  0x78, 0x76, 0x76, 0x76, 0x7a, 0x79, 0x78, 0x79, 0x74, 0x72, 0x6f, 0x6d, 0x75, 0x74, 0x73, 0x73,
  0x6c, 0x6c, 0x6c, 0x6d, 0x73, 0x73, 0x73, 0x73, 0x76, 0x77, 0x76, 0x76, 0x79, 0x7a, 0x79, 0x79,
  0x6f, 0x70, 0x72, 0x7a, 0x73, 0x77, 0x77, 0x78, 0x6b, 0x6d, 0x6f, 0x75, 0x74, 0x74, 0x74, 0x7b,
  0x68, 0x68, 0x68, 0x6a, 0x70, 0x70, 0x70, 0x6f, 0x71, 0x6f, 0x6b, 0x69, 0x75, 0x71, 0x70, 0x70,
  0x79, 0x78, 0x76, 0x74, 0x7c, 0x7a, 0x7a, 0x77, 0x80, 0x80, 0x80, 0x80, 0x8d, 0x8c, 0x8b, 0x91,
  0x98, 0xa5, 0x9c, 0x8c, 0xa5, 0xa0, 0x92, 0x88, 0x82, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x7e,
  0x81, 0x83, 0x85, 0x87, 0x81, 0x84, 0x85, 0x89, 0x83, 0x82, 0x84, 0x88, 0x7d, 0x7d, 0x80, 0x80,
  0x7e, 0x7d, 0x7c, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
  0x79, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x76, 0x76, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
  0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7c, 0x7d, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x81, 0x81, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x86, 0x84, 0x84, 0x85, 0x85, 0x86, 0x85, 0x84,
  0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x8a, 0x87, 0x88, 0x87, 0x88, 0x88, 0x88, 0x88,
  0x8a, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x85, 0x84, 0x84, 0x83, 0x83, 0x83, 0x84, 0x84,
  0x8b, 0x8a, 0x89, 0x89, 0x8a, 0x8b, 0x8b, 0x8b, 0x8a, 0x89, 0x88, 0x89, 0x8a, 0x8a, 0x8a, 0x8a,
  0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x87, 0x86, 0x86, 0x85, 0x87, 0x87, 0x87, 0x87,
  0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x79, 0x7c, 0x7c, 0x7b, 0x7a, 0x79, 0x78, 0x79,
  0x7c, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x76, 0x78, 0x79, 0x79, 0x78, 0x77, 0x76, 0x76,
  0x77, 0x76, 0x77, 0x77, 0x76, 0x75, 0x75, 0x75, 0x7a, 0x7b, 0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
  0x76, 0x74, 0x76, 0x76, 0x76, 0x76, 0x75, 0x75, 0x76, 0x74, 0x77, 0x77, 0x77, 0x76, 0x77, 0x76,
  0x79, 0x72, 0x6d, 0x69, 0x72, 0x73, 0x6e, 0x66, 0x6b, 0x6a, 0x64, 0x61, 0x63, 0x60, 0x5d, 0x5b,
  0x73, 0x73, 0x73, 0x72, 0x73, 0x69, 0x6c, 0x6b, 0x71, 0x71, 0x71, 0x70, 0x6a, 0x6a, 0x6a, 0x6a,
  0x62, 0x62, 0x61, 0x61, 0x58, 0x56, 0x55, 0x55, 0x61, 0x63, 0x70, 0x71, 0x56, 0x59, 0x6a, 0x62,
  0x6d, 0x6d, 0x73, 0x72, 0x6c, 0x5c, 0x5e, 0x66, 0x65, 0x65, 0x65, 0x64, 0x5e, 0x5c, 0x5c, 0x5c,
  0x6d, 0x6c, 0x66, 0x66, 0x66, 0x63, 0x61, 0x60, 0x6f, 0x74, 0x74, 0x72, 0x6b, 0x6e, 0x69, 0x6b,
  0x7a, 0x76, 0x75, 0x74, 0x74, 0x75, 0x72, 0x6e, 0x70, 0x6f, 0x6e, 0x68, 0x6b, 0x68, 0x65, 0x64,
  0x69, 0x69, 0x69, 0x69, 0x63, 0x62, 0x62, 0x61, 0x75, 0x75, 0x75, 0x74, 0x74, 0x6f, 0x6f, 0x6f,
  0x74, 0x75, 0x75, 0x75, 0x6f, 0x6f, 0x6f, 0x75, 0x69, 0x6f, 0x70, 0x73, 0x61, 0x62, 0x63, 0x6a,
  0x72, 0x71, 0x71, 0x77, 0x68, 0x6a, 0x6e, 0x75, 0x6c, 0x6c, 0x6c, 0x6d, 0x66, 0x66, 0x66, 0x67,
  0x71, 0x6c, 0x6c, 0x6c, 0x6a, 0x68, 0x67, 0x66, 0x77, 0x77, 0x72, 0x71, 0x76, 0x73, 0x70, 0x6d,
  0x7b, 0x79, 0x79, 0x73, 0x79, 0x77, 0x74, 0x72, 0x70, 0x71, 0x6c, 0x6c, 0x6f, 0x6c, 0x6b, 0x6a,
  0x78, 0x79, 0x79, 0x7a, 0x74, 0x75, 0x77, 0x76, 0x76, 0x76, 0x76, 0x76, 0x71, 0x72, 0x72, 0x72,
  0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x76, 0x79, 0x6c, 0x6c, 0x72, 0x72, 0x6a, 0x6a, 0x6b, 0x6c,
  0x76, 0x72, 0x76, 0x78, 0x6e, 0x6f, 0x71, 0x73, 0x79, 0x79, 0x79, 0x7a, 0x76, 0x73, 0x75, 0x77,
  0x74, 0x73, 0x77, 0x77, 0x70, 0x70, 0x71, 0x72, 0x75, 0x75, 0x75, 0x76, 0x74, 0x73, 0x72, 0x72,
  0x7f, 0x7d, 0x7d, 0x7d, 0x7f, 0x7f, 0x7e, 0x7d, 0x7e, 0x7c, 0x7b, 0x78, 0x7d, 0x7b, 0x78, 0x76,
  0x7c, 0x7c, 0x7c, 0x7d, 0x7a, 0x7a, 0x7b, 0x7b, 0x7e, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d, 0x7e, 0x7e,
  0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7c, 0x7d, 0x7e,
  0x7b, 0x7b, 0x7b, 0x7b, 0x7a, 0x78, 0x79, 0x7a, 0x7e, 0x7c, 0x7e, 0x7d, 0x7a, 0x7c, 0x7c, 0x7c,
  0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x82, 0x81, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x81, 0x81, 0x81, 0x83, 0x83, 0x83, 0x84, 0x86, 0x86, 0x86, 0x85, 0x88, 0x88, 0x89, 0x8a, 0x8a,
  0x82, 0x84, 0x83, 0x82, 0x84, 0x84, 0x84, 0x83, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x86, 0x86,
  0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82, 0x82, 0x84, 0x84, 0x86, 0x83, 0x87, 0x86, 0x88, 0x85,
  0x88, 0x89, 0x89, 0x85, 0x8d, 0x8d, 0x8d, 0x87, 0x88, 0x88, 0x88, 0x88, 0x8b, 0x8a, 0x8a, 0x89,
  0x8c, 0x8d, 0x8d, 0x8d, 0x91, 0x90, 0x90, 0x8f, 0x89, 0x8a, 0x89, 0x8d, 0x8c, 0x8e, 0x8e, 0x8f,
  0x83, 0x83, 0x83, 0x86, 0x84, 0x88, 0x8b, 0x8e, 0x84, 0x84, 0x84, 0x88, 0x86, 0x88, 0x8a, 0x8e,
  0x8a, 0x8a, 0x95, 0x92, 0x90, 0x92, 0x93, 0x95, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8c, 0x8b, 0x8c,
  0x8c, 0x8d, 0x8d, 0x8c, 0x89, 0x8a, 0x8a, 0x89, 0x86, 0x85, 0x85, 0x86, 0x86, 0x85, 0x85, 0x85,
  0x9b, 0x94, 0x90, 0x8a, 0x89, 0x8b, 0x85, 0x89, 0x91, 0x91, 0x90, 0x91, 0x97, 0x97, 0x97, 0x95,
  0x95, 0x99, 0x96, 0x96, 0x9e, 0xa0, 0x9e, 0x9f, 0x96, 0x90, 0x90, 0x8d, 0x90, 0x90, 0x90, 0x95,
  0x90, 0x90, 0x95, 0x93, 0x95, 0x97, 0x99, 0x9b, 0x85, 0x86, 0x8a, 0x8b, 0x88, 0x8a, 0x8e, 0x92,
  0x8a, 0x8d, 0x92, 0x96, 0x86, 0x88, 0x8d, 0x8e, 0x8a, 0x8e, 0x8e, 0x92, 0x8a, 0x89, 0x89, 0x8d,
  0x9a, 0x9c, 0x9f, 0xa2, 0x93, 0x93, 0x99, 0x9a, 0x93, 0x93, 0x93, 0x94, 0x8d, 0x8e, 0x8e, 0x8e,
  0xa6, 0xa7, 0xa8, 0xa4, 0x9a, 0x99, 0x99, 0x99, 0x88, 0x88, 0x89, 0x89, 0x88, 0x89, 0x89, 0x8a,
  0x93, 0x94, 0x9b, 0x9f, 0x8e, 0x8e, 0x93, 0x99, 0x9f, 0x97, 0xa4, 0x9c, 0x9f, 0x97, 0x97, 0x8c,
  0xaf, 0xb2, 0xb4, 0xaf, 0x9f, 0xa7, 0xa8, 0x9f, 0x9f, 0xa2, 0xa7, 0xab, 0x96, 0x9d, 0x9d, 0x9e,
  0x8c, 0x91, 0x97, 0x9b, 0x87, 0x89, 0x8f, 0x96, 0x8f, 0x96, 0x9c, 0xa2, 0x88, 0x8b, 0x90, 0x99,
  0xa7, 0xac, 0xb6, 0xba, 0xa0, 0xa1, 0xa1, 0xab, 0x99, 0xa1, 0xa3, 0xa3, 0x9a, 0x99, 0x99, 0x9a,
  0xab, 0xbc, 0xbc, 0xc1, 0xab, 0xac, 0xb1, 0xa9, 0x91, 0x98, 0x91, 0x92, 0x8b, 0x8c, 0x8c, 0x8c,
  0x92, 0x92, 0x92, 0x92, 0x8c, 0x8c, 0x8c, 0x8c, 0x92, 0x92, 0x91, 0x8c, 0x93, 0x8c, 0x8c, 0x8d,
  0xa1, 0xa1, 0xa2, 0x9f, 0x9a, 0x9a, 0x99, 0x9a, 0xa6, 0xa6, 0xaa, 0xa0, 0x9c, 0x9c, 0x95, 0x8d,
  0xca, 0xcb, 0xc0, 0xb5, 0xb0, 0xb1, 0xb1, 0xa6, 0x93, 0x9c, 0xa5, 0xa6, 0x94, 0x9c, 0x9c, 0xa7,
  0xaf, 0xb6, 0xc0, 0xc7, 0xa5, 0xa6, 0xb1, 0xb1, 0x90, 0x98, 0xa1, 0xa9, 0x8c, 0x92, 0x9c, 0x9c,
  0xbd, 0xb5, 0xb7, 0xbd, 0xba, 0xbe, 0xbd, 0xbe, 0xb4, 0xb1, 0xba, 0xb6, 0xb6, 0xaf, 0xaf, 0xb1,
  0x93, 0x96, 0x9e, 0x92, 0x8c, 0x8e, 0x8c, 0x8d, 0xa5, 0xad, 0xbe, 0xc5, 0x9e, 0x9e, 0xa8, 0xb4,
  0xce, 0xd5, 0xd7, 0xcc, 0xb5, 0xb5, 0xb4, 0xb6, 0x95, 0x9e, 0x96, 0x96, 0x8d, 0x96, 0x8e, 0x8f,
  0xa9, 0xa9, 0xa9, 0xa9, 0x9f, 0x9f, 0x9e, 0x9e, 0x96, 0x96, 0x96, 0x96, 0x8f, 0x8e, 0x8e, 0x8e,
  0xa9, 0xa9, 0xb6, 0xab, 0x9c, 0x9f, 0xa9, 0x9e, 0x9e, 0x96, 0xa1, 0x96, 0x96, 0x8e, 0x8e, 0x8e,
  0xb6, 0xac, 0xa1, 0x98, 0x9f, 0xa1, 0x98, 0x8e, 0xdb, 0xd2, 0xc9, 0xc0, 0xb8, 0xb8, 0xb7, 0xab,
  0xb9, 0xc6, 0xd2, 0xdb, 0xaa, 0xaa, 0xb8, 0xb8, 0x8b, 0x95, 0xa2, 0xae, 0x8a, 0x8f, 0x97, 0xa0,
  0x8e, 0x99, 0xa5, 0xb5, 0x8e, 0x8e, 0x99, 0xa1, 0xc9, 0xd6, 0xe1, 0xe4, 0xac, 0xbd, 0xbb, 0xcf,
  0xda, 0xd0, 0xc7, 0xbd, 0xbb, 0xbb, 0xae, 0xad, 0x97, 0xa1, 0xad, 0xae, 0x8e, 0x98, 0xa2, 0xa3,
  0x99, 0x99, 0x99, 0x99, 0x90, 0x91, 0x91, 0x91, 0xaf, 0xbb, 0xaf, 0xaf, 0xa3, 0xa3, 0xa3, 0xa3,
  0x99, 0x99, 0xa3, 0x99, 0x90, 0x99, 0x90, 0x90, 0xb4, 0xaa, 0xa0, 0x90, 0xa1, 0x98, 0x98, 0x8e,
  0xb3, 0xa8, 0x9f, 0x96, 0xa3, 0x99, 0x91, 0x8c, 0xda, 0xd0, 0xc6, 0xbc, 0xbe, 0xb1, 0xb0, 0xa4,
  0xd8, 0xe5, 0xed, 0xe4, 0xbf, 0xc2, 0xd2, 0xc0, 0x8e, 0x9f, 0xac, 0xc2, 0x8a, 0x99, 0xa3, 0xb1,
  0x90, 0xa3, 0xbb, 0xd6, 0x98, 0x9a, 0xa4, 0xc1, 0xea, 0xf6, 0xed, 0xe3, 0xc3, 0xd3, 0xd4, 0xc2,
  0xb3, 0xb1, 0xbf, 0xc0, 0xa4, 0xa5, 0xb2, 0xb2, 0x9a, 0x92, 0xa6, 0xa6, 0x91, 0x92, 0x9b, 0x9b,
  0xb3, 0xb3, 0xa6, 0xa6, 0xa6, 0xa6, 0x9b, 0x9b, 0x9b, 0x9b, 0x92, 0x9b, 0x92, 0x92, 0x92, 0x92,
  0xd9, 0xcf, 0xc4, 0xba, 0xc3, 0xb3, 0xb1, 0xa4, 0xb1, 0xa7, 0x9e, 0x91, 0x92, 0x9b, 0x99, 0x95,
  0xaf, 0xa6, 0x9d, 0x95, 0x9b, 0x9b, 0x92, 0x8c, 0xd9, 0xce, 0xc5, 0xb9, 0xc1, 0xb3, 0xa6, 0xa5,
  0xfe, 0xf6, 0xed, 0xe3, 0xd7, 0xd8, 0xc1, 0xc1, 0x93, 0xa9, 0xdc, 0xfa, 0x91, 0x9a, 0xb5, 0xc5,
  0x99, 0x9a, 0xa6, 0xc2, 0x92, 0x8f, 0xa6, 0xb5, 0xee, 0xff, 0xff, 0xf6, 0xc5, 0xed, 0xd8, 0xd8,
  0xc5, 0xc6, 0xc3, 0xec, 0xb2, 0xb3, 0xb3, 0xc3, 0x9b, 0xa8, 0xa8, 0x9d, 0x91, 0x9d, 0x92, 0x93,
  0xc3, 0xd9, 0xca, 0xc2, 0xb5, 0xb5, 0xb5, 0xb4, 0xa8, 0xa7, 0xa7, 0xa8, 0x9d, 0x9c, 0x9c, 0x9d,
  0xa8, 0x9d, 0xba, 0xb1, 0x9d, 0x93, 0xa6, 0x93, 0x9b, 0xa6, 0x9d, 0x94, 0x93, 0x92, 0x92, 0x8c,
  0xae, 0xa5, 0x9c, 0x94, 0x9c, 0x93, 0x93, 0x8c, 0xd7, 0xca, 0xc1, 0xb8, 0xb6, 0xb5, 0xa8, 0xa7,
  0xfd, 0xf3, 0xec, 0xe1, 0xd8, 0xd7, 0xc3, 0xc4, 0xa3, 0xe1, 0xf2, 0xea, 0x9c, 0xc4, 0xd6, 0xd8,
  0x9c, 0xa6, 0xb8, 0xc5, 0x90, 0x98, 0xa5, 0xb6, 0xdc, 0xe6, 0xe0, 0xea, 0xc5, 0xc7, 0xc7, 0xf5,
  0xeb, 0xe3, 0xd9, 0xc3, 0xc4, 0xc4, 0xcc, 0xa9, 0xb6, 0xb3, 0xb4, 0xb5, 0xa6, 0xa6, 0xa6, 0xa6,
  0x99, 0x9a, 0x9b, 0x9c, 0x90, 0x91, 0x93, 0x9c, 0xb5, 0xb4, 0xb5, 0xb5, 0xa7, 0xa7, 0xa8, 0xa9,
  0x9c, 0x9d, 0x9d, 0x9d, 0x92, 0x93, 0x93, 0x93, 0xb7, 0xad, 0xa4, 0x93, 0xa7, 0x9c, 0x9c, 0x8b,
  0xac, 0xa4, 0x9b, 0x94, 0x9c, 0x93, 0x93, 0x8b, 0xe2, 0xcc, 0xbf, 0xb6, 0xc6, 0xb5, 0xa7, 0xa7,
  0xd9, 0xe8, 0xec, 0xe2, 0xc3, 0xda, 0xc4, 0xc4, 0xc3, 0xda, 0xde, 0xd8, 0xb8, 0xc5, 0xd7, 0xc7,
  0x9c, 0xcd, 0xcb, 0xb7, 0x90, 0xb4, 0xc2, 0x9b, 0xd3, 0xd6, 0xcc, 0xd7, 0xc6, 0xc7, 0xc7, 0xd9,
  0xe2, 0xe1, 0xd7, 0xcc, 0xc8, 0xc6, 0xc6, 0xb5, 0xb7, 0xb7, 0xa5, 0xc8, 0xa5, 0xa6, 0x9b, 0xa5,
  0x99, 0x9a, 0x9b, 0x92, 0x90, 0x90, 0x91, 0x93, 0xb6, 0xb6, 0xb4, 0xc1, 0xa6, 0xa7, 0xa8, 0xa9,
  0x9b, 0x9c, 0x9c, 0x9d, 0x92, 0x92, 0x93, 0x93, 0xa9, 0x9d, 0xb4, 0x92, 0x9d, 0x93, 0xa7, 0x93,
  0xab, 0xa3, 0x9b, 0x93, 0x9c, 0x93, 0x93, 0x8b, 0xaa, 0xa2, 0x9a, 0x93, 0x9b, 0x92, 0x93, 0x8b,
  0xb6, 0xd5, 0xcc, 0xb6, 0xb6, 0xc4, 0xbe, 0xa5, 0xd4, 0xcb, 0xd4, 0xdd, 0xc4, 0xc4, 0xc5, 0xc4,
  0xbf, 0xd7, 0xce, 0xd2, 0xb2, 0xc2, 0xc3, 0xc3, 0xf1, 0xf5, 0xe1, 0xe5, 0xda, 0xe4, 0xf2, 0xf0,
  0xd8, 0xe5, 0xee, 0xed, 0xe0, 0xf4, 0xdc, 0xeb
};

// TOYO

static const unsigned char palette_19_0A_C[] =
{
  0x21, 0x14, 0x08, 0x23, 0x1e, 0x05, 0x11, 0x0f, 0x0d, 0x00, 0x02, 0x00, 0x00, 0x02, 0x03, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x2b, 0x20, 0x03, 0x02, 0x05, 0x05, 0x16, 0x1e, 0x0a, 0x00, 0x00, 0x11,
  0x2a, 0x02, 0x0a, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
  0x05, 0x0a, 0x0f, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0f, 0x0a, 0x14, 0x0f, 0x1e, 0x19, 0x19,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x14, 0x15, 0x00, 0x05, 0x02, 0x00, 0x05, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0x05, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0b, 0x0c, 0x14, 0x22, 0x2a, 0x15, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02,
  0x04, 0x02, 0x00, 0x07, 0x06, 0x05, 0x11, 0x17, 0x28, 0x28, 0x36, 0x23, 0x16, 0x1c, 0x18, 0x11,
  0x0f, 0x11, 0x0a, 0x14, 0x0f, 0x0f, 0x12, 0x21, 0x2c, 0x38, 0x2f, 0x1f, 0x14, 0x19, 0x19, 0x1c,
  0x1c, 0x1e, 0x20, 0x28, 0x2b, 0x2f, 0x40, 0x26, 0x29, 0x26, 0x20, 0x28, 0x33, 0x46, 0x45, 0x49,
  0x4e, 0x2f, 0x31, 0x39, 0x3c, 0x54, 0x54, 0x5a, 0x59, 0x56, 0x4b, 0x3a, 0x30, 0x32, 0x32, 0x49,
  0x50, 0x54, 0x5f, 0x4b, 0x46, 0x33, 0x21, 0x50, 0x58, 0x5c, 0x55, 0x64, 0x5f, 0x64, 0x64, 0x3f,
  0x3c, 0x46, 0x47, 0x49, 0x4b, 0x64, 0x54, 0x60, 0x5a, 0x64, 0x64, 0x64, 0x50, 0x4b, 0x4d, 0x28,
  0x27, 0x22, 0x32, 0x5a, 0x5a, 0x5c, 0x57, 0x4f, 0x52, 0x1c, 0x28, 0x35, 0x37, 0x57, 0x5f, 0x5c,
  0x64, 0x64, 0x5a, 0x64, 0x50, 0x5a, 0x44, 0x49, 0x5f, 0x62, 0x62, 0x64, 0x5f, 0x64, 0x64, 0x63,
  0x64, 0x62, 0x3e, 0x37, 0x1c, 0x2a, 0x3a, 0x46, 0x46, 0x3a, 0x58, 0x64, 0x5a, 0x5f, 0x64, 0x64,
  0x64, 0x63, 0x63, 0x64, 0x64, 0x5f, 0x50, 0x3a, 0x36, 0x61, 0x64, 0x64, 0x64, 0x61, 0x61, 0x50,
  0x28, 0x25, 0x50, 0x5f, 0x60, 0x64, 0x64, 0x63, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x62,
  0x44, 0x3c, 0x1f, 0x2d, 0x50, 0x50, 0x5a, 0x41, 0x3a, 0x25, 0x3c, 0x3c, 0x32, 0x1e, 0x50, 0x63,
  0x5e, 0x5a, 0x5f, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x62, 0x5a, 0x58, 0x5f, 0x5f, 0x64, 0x5a, 0x5a,
  0x5a, 0x64, 0x50, 0x41, 0x3a, 0x31, 0x26, 0x32, 0x31, 0x2d, 0x46, 0x49, 0x59, 0x46, 0x5f, 0x64,
  0x5f, 0x5f, 0x5f, 0x50, 0x41, 0x2d, 0x37, 0x46, 0x5f, 0x5f, 0x57, 0x44, 0x41, 0x3c, 0x41, 0x50,
  0x54, 0x54, 0x54, 0x3c, 0x3a, 0x2a, 0x23, 0x2d, 0x34, 0x34, 0x55, 0x58, 0x5e, 0x57, 0x55, 0x30,
  0x25, 0x1e, 0x2b, 0x2d, 0x38, 0x46, 0x44, 0x25, 0x10, 0x1e, 0x28, 0x4e, 0x4b, 0x50, 0x4b, 0x44,
  0x3e, 0x1e, 0x23, 0x0b, 0x0b, 0x1e, 0x1e, 0x2d, 0x28, 0x3f, 0x44, 0x3e, 0x3a, 0x41, 0x3c, 0x3b,
  0x3c, 0x2c, 0x1e, 0x26, 0x05, 0x05, 0x05, 0x09, 0x00, 0x00, 0x00, 0x1e, 0x1a, 0x18, 0x37, 0x26,
  0x16, 0x23, 0x28, 0x20, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0c, 0x37, 0x61, 0x1e, 0x0a,
  0x09, 0x00, 0x00, 0x02, 0x00, 0x02, 0x11, 0x0f, 0x0a, 0x0f, 0x03, 0x07, 0x01, 0x0b, 0x11, 0x0f,
  0x3a, 0x34, 0x28, 0x20, 0x1e, 0x0e, 0x16, 0x08, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x03, 0x01, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x09, 0x00, 0x00, 0x0b, 0x08,
  0x05, 0x0f, 0x0a, 0x11, 0x05, 0x0a, 0x0f, 0x0f, 0x14, 0x25, 0x2a, 0x31, 0x1e, 0x23, 0x1e, 0x19,
  0x0c, 0x0c, 0x16, 0x09, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x03, 0x0b, 0x0e, 0x15,
  0x2f, 0x2c, 0x23, 0x1d, 0x19, 0x1a, 0x27, 0x30, 0x19, 0x14, 0x11, 0x05, 0x05, 0x0b, 0x0b, 0x13,
  0x26, 0x1e, 0x08, 0x11, 0x16, 0x27, 0x2d, 0x34, 0x3f, 0x33, 0x3c, 0x3d, 0x44, 0x4a, 0x50, 0x4e,
  0x50, 0x4b, 0x4b, 0x3d, 0x3f, 0x32, 0x3a, 0x1d, 0x28, 0x14, 0x0f, 0x19, 0x34, 0x28, 0x2d, 0x4b,
  0x4b, 0x50, 0x4b, 0x4b, 0x3f, 0x2c, 0x1c, 0x2a, 0x2d, 0x3c, 0x30, 0x40, 0x4f, 0x5a, 0x56, 0x4b,
  0x41, 0x31, 0x2e, 0x18, 0x16, 0x29, 0x37, 0x46, 0x50, 0x4b, 0x4b, 0x53, 0x37, 0x3b, 0x4a, 0x46,
  0x46, 0x3b, 0x1b, 0x19, 0x14, 0x0f, 0x20, 0x1e, 0x2f, 0x36, 0x43, 0x51, 0x42, 0x46, 0x35, 0x1b,
  0x14, 0x0f, 0x06, 0x09, 0x0a, 0x0b, 0x20, 0x42, 0x36, 0x35, 0x37, 0x3c, 0x1c, 0x19, 0x06, 0x05,
  0x00, 0x00, 0x00, 0x01, 0x21, 0x2f, 0x23, 0x19, 0x0a, 0x29, 0x23, 0x14, 0x16, 0x0d, 0x08, 0x04,
  0x02, 0x04, 0x0b, 0x0f, 0x0b, 0x0c, 0x0a, 0x2a, 0x32, 0x28, 0x2a, 0x00, 0x02, 0x03, 0x07, 0x02,
  0x0a, 0x0a, 0x0b, 0x0a, 0x0b, 0x07, 0x0c, 0x0f, 0x0e, 0x0b, 0x0d, 0x0d, 0x18, 0x18, 0x0f, 0x1c,
  0x17, 0x14, 0x19, 0x15, 0x1a, 0x20, 0x24, 0x2a, 0x26, 0x2e, 0x25, 0x31, 0x2f, 0x25, 0x26, 0x26,
  0x27, 0x32, 0x31, 0x32, 0x32, 0x2d, 0x37, 0x03, 0x0a, 0x02, 0x00, 0x00, 0x3c, 0x4b, 0x56, 0x00,
  0x00, 0x49, 0x3a, 0x31, 0x23, 0x21, 0x3d, 0x34, 0x17, 0x37, 0x23, 0x49, 0x00, 0x00, 0x00, 0x00,
  0x37, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x3c, 0x4b, 0x4b, 0x32, 0x00, 0x4b, 0x3c, 0x4d, 0x26, 0x2d,
  0x2f, 0x20, 0x27, 0x14, 0x32, 0x41, 0x32, 0x1e, 0x1e, 0x37, 0x37, 0x32, 0x3f, 0x32, 0x1e, 0x00,
  0x00, 0x00, 0x32, 0x00, 0x55, 0x50, 0x37, 0x39, 0x23, 0x1e, 0x2d, 0x30, 0x32, 0x37, 0x3c, 0x3c,
  0x3f, 0x3c, 0x3c, 0x41, 0x05, 0x4b, 0x43, 0x43, 0x37, 0x3b, 0x3c, 0x4b, 0x48, 0x50, 0x55, 0x5a,
  0x57, 0x5a, 0x5f, 0x5f, 0x32, 0x5a, 0x56, 0x50, 0x28, 0x64, 0x64, 0x64, 0x5a, 0x64, 0x64, 0x64,
  0x64, 0x5a, 0x5a, 0x59, 0x5a, 0x64, 0x64, 0x63, 0x5f, 0x5f, 0x5f, 0x5d, 0x5a, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x56, 0x55, 0x5a, 0x5b, 0x4d, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x5f, 0x63, 0x64, 0x64, 0x64, 0x5e, 0x3c, 0x5a, 0x4d, 0x4d, 0x64, 0x5f, 0x64, 0x5f, 0x53,
  0x50, 0x4b, 0x49, 0x64, 0x59, 0x57, 0x2f, 0x46, 0x5b, 0x5b, 0x28, 0x4c, 0x4e, 0x32, 0x5a, 0x56,
  0x56, 0x46, 0x28, 0x28, 0x00, 0x3d, 0x45, 0x43, 0x28, 0x32, 0x4c, 0x3a, 0x30, 0x34, 0x40, 0x46,
  0x0d, 0x05, 0x2a, 0x29, 0x39, 0x28, 0x26, 0x28, 0x37, 0x41, 0x1e, 0x3c, 0x06, 0x14, 0x07, 0x46,
  0x05, 0x0a, 0x03, 0x05, 0x14, 0x17, 0x06, 0x0c, 0x05, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x1e,
  0x00, 0x0a, 0x2e, 0x39, 0x00, 0x00, 0x0c, 0x11, 0x16, 0x00, 0x00, 0x00, 0x61, 0x16, 0x16, 0x00,
  0x05, 0x03, 0x20, 0x23, 0x1e, 0x24, 0x2d, 0x2d, 0x2e, 0x39, 0x34, 0x35, 0x2e, 0x19, 0x1e, 0x19,
  0x0a, 0x1c, 0x1c, 0x2c, 0x2c, 0x28, 0x2a, 0x27, 0x1e, 0x1e
};

static const unsigned char palette_19_0A_M[] =
{
  0x5a, 0x64, 0x64, 0x54, 0x46, 0x4b, 0x64, 0x64, 0x5a, 0x55, 0x5f, 0x46, 0x3c, 0x33, 0x2d, 0x2a,
  0x1b, 0x29, 0x44, 0x60, 0x60, 0x5f, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x62, 0x5f, 0x64, 0x55, 0x54,
  0x5d, 0x64, 0x64, 0x64, 0x55, 0x58, 0x5d, 0x41, 0x46, 0x49, 0x4b, 0x5a, 0x64, 0x64, 0x3c, 0x28,
  0x25, 0x20, 0x26, 0x18, 0x1e, 0x1c, 0x1e, 0x2d, 0x32, 0x46, 0x37, 0x3c, 0x5f, 0x55, 0x64, 0x64,
  0x5f, 0x5f, 0x64, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x3a, 0x5a, 0x5a, 0x55, 0x50, 0x46, 0x46,
  0x3c, 0x37, 0x35, 0x28, 0x4d, 0x50, 0x55, 0x58, 0x64, 0x64, 0x64, 0x55, 0x5b, 0x64, 0x5f, 0x64,
  0x5f, 0x64, 0x64, 0x5f, 0x5f, 0x5a, 0x58, 0x3b, 0x39, 0x41, 0x3e, 0x31, 0x34, 0x46, 0x49, 0x46,
  0x50, 0x55, 0x5f, 0x55, 0x5a, 0x5a, 0x52, 0x50, 0x55, 0x50, 0x5a, 0x4b, 0x46, 0x3c, 0x3a, 0x45,
  0x3a, 0x37, 0x31, 0x33, 0x1b, 0x21, 0x16, 0x29, 0x23, 0x20, 0x37, 0x55, 0x37, 0x3f, 0x3e, 0x3f,
  0x33, 0x35, 0x35, 0x34, 0x1e, 0x26, 0x1e, 0x37, 0x3f, 0x3e, 0x3a, 0x46, 0x41, 0x41, 0x32, 0x32,
  0x2e, 0x21, 0x23, 0x1e, 0x2d, 0x3c, 0x41, 0x25, 0x1e, 0x1c, 0x1e, 0x1c, 0x1c, 0x1f, 0x19, 0x12,
  0x24, 0x22, 0x23, 0x22, 0x2d, 0x1e, 0x16, 0x0f, 0x04, 0x06, 0x17, 0x14, 0x10, 0x10, 0x0f, 0x0a,
  0x15, 0x0f, 0x2d, 0x22, 0x2a, 0x1e, 0x06, 0x04, 0x01, 0x05, 0x00, 0x01, 0x05, 0x03, 0x00, 0x04,
  0x02, 0x02, 0x00, 0x00, 0x00, 0x01, 0x0a, 0x0e, 0x1b, 0x15, 0x20, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x03, 0x04, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x19, 0x0f, 0x05, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x14, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x02, 0x00, 0x1f, 0x20, 0x00,
  0x00, 0x03, 0x00, 0x03, 0x03, 0x1a, 0x03, 0x00, 0x00, 0x0f, 0x1e, 0x00, 0x02, 0x02, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x05, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0d,
  0x23, 0x3c, 0x1e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 0x00, 0x14, 0x0d,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x14,
  0x07, 0x05, 0x21, 0x23, 0x05, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x23, 0x00, 0x00,
  0x01, 0x01, 0x05, 0x14, 0x14, 0x02, 0x05, 0x05, 0x10, 0x16, 0x36, 0x14, 0x11, 0x0d, 0x02, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x0f, 0x11,
  0x2d, 0x33, 0x1a, 0x19, 0x2a, 0x32, 0x2e, 0x39, 0x3a, 0x1e, 0x0d, 0x2b, 0x3e, 0x35, 0x1e, 0x36,
  0x3a, 0x39, 0x24, 0x14, 0x0a, 0x09, 0x05, 0x0c, 0x0c, 0x0c, 0x28, 0x2b, 0x37, 0x22, 0x32, 0x40,
  0x3c, 0x3a, 0x3e, 0x21, 0x17, 0x10, 0x1e, 0x2d, 0x3e, 0x38, 0x38, 0x34, 0x2e, 0x1e, 0x2d, 0x3e,
  0x4b, 0x4e, 0x3e, 0x2d, 0x32, 0x1a, 0x16, 0x23, 0x32, 0x3c, 0x55, 0x55, 0x5f, 0x57, 0x57, 0x39,
  0x27, 0x23, 0x35, 0x38, 0x35, 0x43, 0x41, 0x28, 0x16, 0x24, 0x30, 0x50, 0x5c, 0x55, 0x54, 0x52,
  0x4b, 0x32, 0x32, 0x19, 0x17, 0x30, 0x2e, 0x34, 0x37, 0x56, 0x55, 0x5f, 0x4b, 0x63, 0x64, 0x55,
  0x4d, 0x3e, 0x35, 0x3e, 0x32, 0x2d, 0x25, 0x1e, 0x25, 0x2b, 0x37, 0x52, 0x64, 0x64, 0x5a, 0x53,
  0x64, 0x64, 0x55, 0x51, 0x50, 0x46, 0x46, 0x46, 0x30, 0x2a, 0x1b, 0x00, 0x00, 0x00, 0x32, 0x23,
  0x31, 0x37, 0x3a, 0x33, 0x28, 0x2d, 0x30, 0x31, 0x17, 0x2b, 0x25, 0x28, 0x20, 0x2b, 0x22, 0x3c,
  0x3d, 0x39, 0x32, 0x25, 0x1b, 0x16, 0x15, 0x0f, 0x0d, 0x0a, 0x0f, 0x12, 0x0f, 0x0d, 0x0d, 0x12,
  0x08, 0x08, 0x07, 0x0f, 0x0c, 0x0c, 0x0b, 0x05, 0x13, 0x15, 0x19, 0x15, 0x0f, 0x0f, 0x17, 0x14,
  0x0f, 0x19, 0x17, 0x21, 0x23, 0x1e, 0x28, 0x28, 0x21, 0x25, 0x2d, 0x30, 0x1a, 0x29, 0x14, 0x19,
  0x19, 0x11, 0x14, 0x07, 0x09, 0x10, 0x03, 0x02, 0x00, 0x00, 0x00, 0x07, 0x04, 0x0d, 0x07, 0x0f,
  0x1e, 0x1e, 0x18, 0x09, 0x00, 0x00, 0x08, 0x14, 0x08, 0x06, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x02, 0x06, 0x0d, 0x0c, 0x0d, 0x00, 0x0d, 0x0a, 0x0d, 0x0a, 0x1b, 0x11, 0x0c,
  0x00, 0x12, 0x0a, 0x13, 0x02, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x03,
  0x1b, 0x14, 0x16, 0x26, 0x23, 0x07, 0x00, 0x00, 0x00, 0x03, 0x03, 0x0a, 0x11, 0x23, 0x1a, 0x19,
  0x1e, 0x07, 0x0d, 0x05, 0x05, 0x0f, 0x05, 0x19, 0x28, 0x19, 0x0f, 0x19, 0x19, 0x13, 0x15, 0x25,
  0x21, 0x14, 0x00, 0x00, 0x06, 0x07, 0x07, 0x09, 0x12, 0x14, 0x25, 0x32, 0x2d, 0x33, 0x25, 0x0f,
  0x08, 0x06, 0x07, 0x09, 0x0c, 0x0c, 0x1a, 0x39, 0x2d, 0x35, 0x33, 0x3c, 0x15, 0x19, 0x0f, 0x0d,
  0x0f, 0x0a, 0x09, 0x1a, 0x21, 0x36, 0x40, 0x33, 0x3a, 0x34, 0x39, 0x32, 0x13, 0x14, 0x0d, 0x0f,
  0x28, 0x2e, 0x2b, 0x37, 0x32, 0x2f, 0x1e, 0x31, 0x37, 0x37, 0x29, 0x04, 0x05, 0x04, 0x03, 0x03,
  0x06, 0x08, 0x0d, 0x0a, 0x06, 0x00, 0x06, 0x0a, 0x08, 0x07, 0x0a, 0x09, 0x0c, 0x09, 0x12, 0x13,
  0x0c, 0x15, 0x12, 0x13, 0x14, 0x13, 0x14, 0x1e, 0x19, 0x1e, 0x1d, 0x17, 0x19, 0x1e, 0x23, 0x11,
  0x1a, 0x1d, 0x23, 0x20, 0x2d, 0x1e, 0x1e, 0x00, 0x00, 0x02, 0x0b, 0x00, 0x36, 0x5a, 0x64, 0x39,
  0x42, 0x64, 0x64, 0x64, 0x5a, 0x54, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x62, 0x29, 0x28, 0x33, 0x22,
  0x3c, 0x17, 0x17, 0x1d, 0x32, 0x59, 0x47, 0x5f, 0x5f, 0x5c, 0x39, 0x5a, 0x48, 0x5a, 0x5f, 0x5a,
  0x5a, 0x59, 0x44, 0x54, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x4b, 0x4d, 0x43, 0x50, 0x46, 0x3c, 0x14,
  0x0a, 0x0f, 0x34, 0x19, 0x5a, 0x55, 0x41, 0x39, 0x37, 0x2d, 0x2d, 0x2e, 0x2d, 0x32, 0x37, 0x3c,
  0x3a, 0x3a, 0x3c, 0x41, 0x0f, 0x41, 0x32, 0x25, 0x1d, 0x28, 0x32, 0x2d, 0x2d, 0x46, 0x46, 0x41,
  0x30, 0x42, 0x3a, 0x2f, 0x00, 0x3c, 0x28, 0x32, 0x00, 0x33, 0x36, 0x55, 0x00, 0x50, 0x28, 0x41,
  0x23, 0x28, 0x2d, 0x19, 0x41, 0x55, 0x5f, 0x34, 0x37, 0x32, 0x2f, 0x22, 0x3c, 0x3c, 0x5a, 0x41,
  0x55, 0x41, 0x3d, 0x46, 0x46, 0x4b, 0x5f, 0x2d, 0x41, 0x4b, 0x4c, 0x05, 0x5f, 0x50, 0x52, 0x4d,
  0x4c, 0x42, 0x50, 0x5a, 0x58, 0x59, 0x49, 0x1e, 0x23, 0x21, 0x29, 0x5a, 0x5a, 0x5d, 0x5f, 0x2f,
  0x2b, 0x1e, 0x39, 0x60, 0x51, 0x52, 0x2f, 0x32, 0x5e, 0x64, 0x1e, 0x3d, 0x40, 0x32, 0x61, 0x63,
  0x5e, 0x53, 0x32, 0x2e, 0x28, 0x4e, 0x56, 0x5a, 0x50, 0x49, 0x5e, 0x64, 0x64, 0x54, 0x56, 0x64,
  0x49, 0x32, 0x44, 0x51, 0x5f, 0x64, 0x64, 0x4a, 0x46, 0x50, 0x50, 0x2d, 0x02, 0x00, 0x00, 0x41,
  0x14, 0x07, 0x06, 0x05, 0x00, 0x06, 0x00, 0x0c, 0x05, 0x11, 0x05, 0x05, 0x05, 0x0b, 0x05, 0x0a,
  0x16, 0x00, 0x00, 0x00, 0x05, 0x11, 0x0b, 0x11, 0x00, 0x05, 0x16, 0x00, 0x5c, 0x0d, 0x00, 0x12,
  0x0a, 0x0a, 0x26, 0x23, 0x14, 0x14, 0x19, 0x0c, 0x1c, 0x15, 0x15, 0x20, 0x19, 0x19, 0x2d, 0x2d,
  0x37, 0x13, 0x0f, 0x2b, 0x2b, 0x1c, 0x23, 0x20, 0x24, 0x28
};

static const unsigned char palette_19_0A_Y[] =
{
  0x03, 0x00, 0x00, 0x06, 0x0f, 0x00, 0x05, 0x02, 0x08, 0x02, 0x03, 0x00, 0x01, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0x13, 0x1d, 0x03, 0x03, 0x12, 0x12, 0x23, 0x32, 0x0f, 0x03, 0x00, 0x11,
  0x31, 0x1c, 0x32, 0x26, 0x1e, 0x0a, 0x0b, 0x06, 0x0f, 0x04, 0x1c, 0x2d, 0x35, 0x37, 0x0a, 0x00,
  0x0c, 0x07, 0x0f, 0x05, 0x07, 0x0a, 0x0f, 0x1a, 0x14, 0x0a, 0x1b, 0x1b, 0x23, 0x19, 0x3c, 0x41,
  0x3a, 0x32, 0x3c, 0x3c, 0x46, 0x4b, 0x47, 0x43, 0x4a, 0x23, 0x3e, 0x41, 0x3e, 0x3e, 0x32, 0x35,
  0x33, 0x26, 0x23, 0x1e, 0x43, 0x43, 0x4b, 0x4b, 0x46, 0x4b, 0x4b, 0x32, 0x41, 0x4b, 0x46, 0x55,
  0x46, 0x57, 0x57, 0x52, 0x5a, 0x55, 0x5a, 0x37, 0x35, 0x41, 0x41, 0x28, 0x37, 0x57, 0x57, 0x55,
  0x60, 0x48, 0x46, 0x4f, 0x46, 0x4b, 0x5a, 0x5f, 0x55, 0x64, 0x5f, 0x46, 0x64, 0x5a, 0x5a, 0x64,
  0x4b, 0x4b, 0x3e, 0x41, 0x1b, 0x1e, 0x21, 0x2b, 0x2e, 0x27, 0x47, 0x5f, 0x3c, 0x50, 0x58, 0x5f,
  0x5f, 0x5a, 0x62, 0x64, 0x46, 0x41, 0x3e, 0x46, 0x62, 0x64, 0x5a, 0x5a, 0x5f, 0x50, 0x5f, 0x55,
  0x60, 0x64, 0x64, 0x64, 0x64, 0x55, 0x55, 0x3a, 0x3a, 0x41, 0x3c, 0x37, 0x37, 0x41, 0x46, 0x3a,
  0x64, 0x64, 0x5f, 0x64, 0x64, 0x61, 0x5f, 0x48, 0x28, 0x36, 0x64, 0x64, 0x64, 0x55, 0x5c, 0x64,
  0x5f, 0x61, 0x5a, 0x63, 0x63, 0x50, 0x47, 0x64, 0x64, 0x5a, 0x5a, 0x43, 0x36, 0x4c, 0x47, 0x4e,
  0x3e, 0x1e, 0x2d, 0x45, 0x3c, 0x63, 0x56, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x62, 0x5f,
  0x5c, 0x5c, 0x5a, 0x4e, 0x37, 0x4e, 0x44, 0x52, 0x5b, 0x61, 0x4b, 0x47, 0x55, 0x55, 0x37, 0x3e,
  0x46, 0x46, 0x46, 0x60, 0x60, 0x60, 0x56, 0x55, 0x41, 0x3c, 0x41, 0x3c, 0x49, 0x51, 0x55, 0x62,
  0x5b, 0x5a, 0x5a, 0x5a, 0x5d, 0x56, 0x4c, 0x58, 0x56, 0x5a, 0x47, 0x46, 0x32, 0x37, 0x37, 0x52,
  0x53, 0x55, 0x57, 0x3f, 0x49, 0x34, 0x26, 0x58, 0x5a, 0x5f, 0x4b, 0x54, 0x55, 0x55, 0x4f, 0x46,
  0x32, 0x32, 0x44, 0x46, 0x46, 0x4f, 0x4d, 0x43, 0x40, 0x46, 0x46, 0x41, 0x3a, 0x3a, 0x3a, 0x26,
  0x1e, 0x1c, 0x20, 0x3f, 0x3f, 0x37, 0x35, 0x33, 0x34, 0x0f, 0x1b, 0x22, 0x28, 0x34, 0x37, 0x33,
  0x45, 0x46, 0x47, 0x3c, 0x38, 0x32, 0x20, 0x23, 0x33, 0x44, 0x32, 0x35, 0x32, 0x33, 0x34, 0x28,
  0x2d, 0x2f, 0x16, 0x16, 0x0e, 0x14, 0x14, 0x19, 0x20, 0x17, 0x23, 0x27, 0x1e, 0x20, 0x28, 0x2d,
  0x25, 0x19, 0x28, 0x23, 0x11, 0x1e, 0x12, 0x0e, 0x07, 0x0a, 0x14, 0x12, 0x15, 0x23, 0x0f, 0x0d,
  0x08, 0x08, 0x0f, 0x0f, 0x14, 0x0e, 0x0a, 0x05, 0x0f, 0x0e, 0x10, 0x0a, 0x0a, 0x02, 0x06, 0x05,
  0x03, 0x0a, 0x08, 0x08, 0x08, 0x00, 0x0a, 0x05, 0x04, 0x05, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02,
  0x10, 0x15, 0x01, 0x00, 0x05, 0x05, 0x04, 0x05, 0x0d, 0x00, 0x00, 0x02, 0x00, 0x05, 0x01, 0x02,
  0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x05, 0x05, 0x09, 0x0c, 0x00, 0x07,
  0x05, 0x02, 0x02, 0x02, 0x01, 0x00, 0x05, 0x05, 0x05, 0x02, 0x02, 0x02, 0x05, 0x03, 0x03, 0x01,
  0x02, 0x02, 0x01, 0x03, 0x03, 0x02, 0x00, 0x00, 0x03, 0x03, 0x02, 0x02, 0x00, 0x05, 0x02, 0x03,
  0x05, 0x0a, 0x0a, 0x0a, 0x00, 0x09, 0x0f, 0x05, 0x03, 0x02, 0x05, 0x04, 0x05, 0x0c, 0x0a, 0x0a,
  0x0a, 0x03, 0x08, 0x01, 0x01, 0x02, 0x02, 0x03, 0x08, 0x05, 0x0a, 0x03, 0x05, 0x05, 0x07, 0x00,
  0x03, 0x00, 0x02, 0x11, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x05, 0x03,
  0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1e, 0x39, 0x41, 0x41, 0x4d, 0x55, 0x00, 0x28, 0x14,
  0x1e, 0x1e, 0x3d, 0x39, 0x28, 0x2c, 0x33, 0x25, 0x0a, 0x31, 0x32, 0x34, 0x23, 0x38, 0x33, 0x37,
  0x36, 0x36, 0x31, 0x23, 0x1a, 0x16, 0x1a, 0x0e, 0x0b, 0x0a, 0x05, 0x0b, 0x07, 0x07, 0x0f, 0x11,
  0x0a, 0x0a, 0x0b, 0x14, 0x10, 0x15, 0x1a, 0x0f, 0x1d, 0x1c, 0x1d, 0x18, 0x1e, 0x19, 0x28, 0x19,
  0x15, 0x19, 0x1c, 0x1e, 0x37, 0x32, 0x37, 0x46, 0x32, 0x31, 0x3d, 0x33, 0x23, 0x3b, 0x19, 0x23,
  0x33, 0x19, 0x19, 0x0f, 0x14, 0x1b, 0x18, 0x13, 0x13, 0x11, 0x10, 0x15, 0x23, 0x34, 0x32, 0x33,
  0x3f, 0x32, 0x23, 0x37, 0x37, 0x36, 0x36, 0x36, 0x25, 0x1e, 0x12, 0x0c, 0x14, 0x19, 0x12, 0x14,
  0x2d, 0x1e, 0x09, 0x0f, 0x10, 0x1d, 0x1e, 0x2f, 0x37, 0x1e, 0x33, 0x2d, 0x26, 0x37, 0x37, 0x33,
  0x32, 0x33, 0x2d, 0x28, 0x2d, 0x1e, 0x1a, 0x12, 0x14, 0x0d, 0x0a, 0x10, 0x17, 0x15, 0x0f, 0x23,
  0x2e, 0x27, 0x25, 0x1e, 0x23, 0x13, 0x0a, 0x0f, 0x0f, 0x11, 0x0f, 0x15, 0x1a, 0x28, 0x1a, 0x14,
  0x19, 0x0f, 0x0f, 0x0c, 0x09, 0x0f, 0x0e, 0x14, 0x19, 0x14, 0x0f, 0x13, 0x0f, 0x0e, 0x09, 0x16,
  0x13, 0x0a, 0x05, 0x00, 0x04, 0x05, 0x05, 0x05, 0x0b, 0x0a, 0x0f, 0x16, 0x13, 0x19, 0x13, 0x06,
  0x04, 0x02, 0x04, 0x06, 0x06, 0x01, 0x05, 0x0c, 0x09, 0x10, 0x1a, 0x23, 0x0b, 0x03, 0x04, 0x01,
  0x01, 0x02, 0x01, 0x02, 0x08, 0x09, 0x02, 0x04, 0x00, 0x0f, 0x14, 0x0f, 0x0b, 0x0f, 0x09, 0x07,
  0x04, 0x05, 0x09, 0x0f, 0x14, 0x1b, 0x0f, 0x23, 0x28, 0x28, 0x1a, 0x09, 0x0a, 0x0e, 0x05, 0x01,
  0x09, 0x09, 0x08, 0x0c, 0x0c, 0x0a, 0x10, 0x11, 0x0d, 0x05, 0x0c, 0x10, 0x10, 0x10, 0x11, 0x10,
  0x0e, 0x14, 0x0e, 0x13, 0x13, 0x12, 0x13, 0x1a, 0x0f, 0x16, 0x19, 0x19, 0x16, 0x23, 0x1e, 0x0e,
  0x13, 0x19, 0x1a, 0x18, 0x28, 0x17, 0x1c, 0x05, 0x00, 0x05, 0x16, 0x0b, 0x35, 0x41, 0x47, 0x22,
  0x22, 0x41, 0x3c, 0x3c, 0x37, 0x35, 0x41, 0x3c, 0x4b, 0x55, 0x4b, 0x55, 0x2f, 0x28, 0x34, 0x1d,
  0x32, 0x1d, 0x17, 0x17, 0x32, 0x5f, 0x3e, 0x5a, 0x50, 0x50, 0x43, 0x64, 0x49, 0x55, 0x58, 0x50,
  0x52, 0x4b, 0x3d, 0x4b, 0x5f, 0x5a, 0x64, 0x64, 0x5a, 0x55, 0x64, 0x58, 0x64, 0x64, 0x5f, 0x3c,
  0x28, 0x26, 0x32, 0x28, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x4a, 0x32, 0x37, 0x37, 0x50,
  0x64, 0x64, 0x5f, 0x4b, 0x37, 0x50, 0x64, 0x64, 0x56, 0x39, 0x3c, 0x5f, 0x64, 0x64, 0x5f, 0x64,
  0x61, 0x55, 0x51, 0x53, 0x2d, 0x41, 0x36, 0x37, 0x1e, 0x4f, 0x54, 0x55, 0x3c, 0x4b, 0x46, 0x41,
  0x3c, 0x35, 0x36, 0x33, 0x37, 0x41, 0x4b, 0x37, 0x32, 0x32, 0x32, 0x30, 0x32, 0x32, 0x41, 0x26,
  0x37, 0x28, 0x28, 0x28, 0x28, 0x28, 0x46, 0x26, 0x28, 0x2d, 0x2d, 0x00, 0x41, 0x23, 0x32, 0x28,
  0x25, 0x1e, 0x12, 0x14, 0x0b, 0x23, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x28, 0x23, 0x1a, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x1d, 0x23, 0x00, 0x00, 0x1a, 0x0a, 0x00, 0x18, 0x15, 0x00, 0x1e, 0x0e,
  0x23, 0x00, 0x00, 0x00, 0x00, 0x14, 0x13, 0x19, 0x00, 0x00, 0x17, 0x14, 0x10, 0x14, 0x2d, 0x1e,
  0x00, 0x00, 0x13, 0x1b, 0x41, 0x25, 0x34, 0x2e, 0x2d, 0x37, 0x1e, 0x28, 0x04, 0x00, 0x07, 0x46,
  0x14, 0x07, 0x08, 0x08, 0x02, 0x04, 0x1c, 0x00, 0x07, 0x0b, 0x05, 0x05, 0x00, 0x0b, 0x05, 0x00,
  0x22, 0x0f, 0x2e, 0x2e, 0x06, 0x0b, 0x00, 0x00, 0x28, 0x06, 0x17, 0x06, 0x5b, 0x0f, 0x10, 0x10,
  0x15, 0x1d, 0x20, 0x1b, 0x30, 0x23, 0x23, 0x20, 0x1c, 0x14, 0x14, 0x12, 0x0a, 0x06, 0x0f, 0x0f,
  0x06, 0x16, 0x0b, 0x23, 0x23, 0x1c, 0x1e, 0x23, 0x37, 0x34
};

static const unsigned char palette_19_0A_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x02, 0x02, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x04,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x3a, 0x37, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x57,
  0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x4e, 0x53, 0x53,
  0x00, 0x43, 0x53, 0x57, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x4b,
  0x48, 0x49, 0x00, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x03, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x52, 0x52, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x52,
  0x57, 0x5a, 0x53, 0x00, 0x00, 0x00, 0x57, 0x56, 0x00, 0x00, 0x49, 0x00, 0x00, 0x4c, 0x00, 0x00,
  0x00, 0x46, 0x4c, 0x32, 0x32, 0x00, 0x00, 0x00, 0x4a, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x57, 0x46, 0x00, 0x00, 0x0a, 0x0f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x39, 0x00,
  0x3c, 0x3c, 0x41, 0x41, 0x41, 0x48, 0x4d, 0x4d, 0x4b, 0x48, 0x48, 0x4d, 0x4d, 0x53, 0x53, 0x4f,
  0x57, 0x57, 0x5b, 0x57, 0x5b, 0x5b, 0x5b, 0x5f, 0x5f, 0x5f, 0x63, 0x5e, 0x23, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00
};

// DIC

static const unsigned char palette_19_0B_C[] =
{
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x15, 0x1d, 0x26, 0x2d, 0x2d,
  0x28, 0x2d, 0x23, 0x22, 0x1a, 0x13, 0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0b, 0x16, 0x29, 0x2d, 0x3c, 0x3c, 0x43, 0x3c, 0x3a, 0x38, 0x2a, 0x1c, 0x0f, 0x0a, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x19, 0x26, 0x30, 0x36, 0x41, 0x46,
  0x49, 0x3c, 0x3e, 0x46, 0x3e, 0x43, 0x1a, 0x1e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x19, 0x23, 0x39, 0x46, 0x53, 0x4f, 0x52, 0x4a,
  0x48, 0x4b, 0x5a, 0x54, 0x43, 0x43, 0x39, 0x39, 0x30, 0x28, 0x19, 0x20, 0x17, 0x0f, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x21,
  0x3b, 0x41, 0x49, 0x50, 0x56, 0x57, 0x55, 0x5a, 0x5a, 0x62, 0x5e, 0x57, 0x55, 0x43, 0x52, 0x4b,
  0x46, 0x2d, 0x3f, 0x39, 0x25, 0x1f, 0x14, 0x13, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x10, 0x1f, 0x38, 0x4b, 0x56, 0x57, 0x55, 0x5d,
  0x62, 0x64, 0x64, 0x64, 0x5d, 0x63, 0x5b, 0x64, 0x5b, 0x51, 0x4f, 0x47, 0x3c, 0x2f, 0x2c, 0x32,
  0x23, 0x0a, 0x14, 0x1e, 0x10, 0x03, 0x05, 0x08, 0x0b, 0x08, 0x08, 0x00, 0x00, 0x01, 0x10, 0x00,
  0x14, 0x15, 0x38, 0x41, 0x4e, 0x55, 0x63, 0x62, 0x60, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x55, 0x5c,
  0x55, 0x4f, 0x41, 0x41, 0x3c, 0x37, 0x2f, 0x27, 0x27, 0x18, 0x15, 0x16, 0x15, 0x18, 0x18, 0x1e,
  0x17, 0x19, 0x28, 0x28, 0x2c, 0x3d, 0x41, 0x49, 0x53, 0x58, 0x64, 0x64, 0x64, 0x64, 0x60, 0x5a,
  0x50, 0x03, 0x00, 0x03, 0x00, 0x05, 0x0e, 0x12, 0x12, 0x00, 0x06, 0x00, 0x03, 0x00, 0x18, 0x17,
  0x26, 0x00, 0x00, 0x00, 0x05, 0x0f, 0x10, 0x05, 0x10, 0x18, 0x20, 0x04, 0x0a, 0x22, 0x00, 0x00,
  0x03, 0x10, 0x0f, 0x21, 0x22, 0x00, 0x07, 0x1d, 0x11, 0x13, 0x18, 0x23, 0x18, 0x18, 0x32, 0x39,
  0x28, 0x22, 0x34, 0x44, 0x3a, 0x45, 0x4e, 0x4d, 0x13, 0x19, 0x0f, 0x14, 0x19, 0x09, 0x14, 0x13,
  0x27, 0x2f, 0x32, 0x1e, 0x25, 0x2b, 0x36, 0x3e, 0x3c, 0x50, 0x46, 0x55, 0x52, 0x13, 0x11, 0x19,
  0x22, 0x25, 0x2f, 0x30, 0x34, 0x42, 0x40, 0x42, 0x37, 0x44, 0x4e, 0x25, 0x30, 0x33, 0x3f, 0x4b,
  0x41, 0x39, 0x44, 0x46, 0x26, 0x1f, 0x23, 0x1e, 0x26, 0x32, 0x2d, 0x30, 0x37, 0x3d, 0x3e, 0x41,
  0x41, 0x3a, 0x20, 0x35, 0x3e, 0x45, 0x4b, 0x53, 0x5a, 0x59, 0x64, 0x60, 0x3a, 0x3a, 0x4c, 0x44,
  0x4e, 0x4c, 0x59, 0x59, 0x62, 0x2b, 0x3a, 0x47, 0x56, 0x40, 0x4b, 0x5a, 0x3e, 0x39, 0x37, 0x3f,
  0x4c, 0x51, 0x44, 0x36, 0x48, 0x56, 0x58, 0x64, 0x64, 0x64, 0x64, 0x3b, 0x44, 0x4d, 0x20, 0x2e,
  0x36, 0x32, 0x41, 0x45, 0x4c, 0x4f, 0x4b, 0x58, 0x56, 0x58, 0x1e, 0x37, 0x37, 0x3f, 0x44, 0x4f,
  0x5c, 0x5b, 0x64, 0x35, 0x3a, 0x40, 0x42, 0x48, 0x18, 0x25, 0x2f, 0x36, 0x3e, 0x4b, 0x50, 0x55,
  0x5d, 0x37, 0x1c, 0x23, 0x20, 0x26, 0x3c, 0x44, 0x37, 0x21, 0x2b, 0x28, 0x3a, 0x3a, 0x4d, 0x4d,
  0x54, 0x54, 0x13, 0x06, 0x11, 0x0c, 0x1e, 0x16, 0x1e, 0x2b, 0x27, 0x1d, 0x02, 0x0d, 0x1f, 0x08,
  0x19, 0x23, 0x23, 0x22, 0x2a, 0x26, 0x24, 0x30, 0x37, 0x29, 0x31, 0x40, 0x2b, 0x2b, 0x46, 0x44,
  0x42, 0x41, 0x4a, 0x46, 0x58, 0x35, 0x3e, 0x50, 0x19, 0x11, 0x3c, 0x37, 0x3a, 0x50, 0x57, 0x39,
  0x2a, 0x52, 0x4e, 0x56, 0x1c, 0x21, 0x2f, 0x52, 0x57, 0x0b, 0x20, 0x3c, 0x50, 0x58, 0x23, 0x3a,
  0x44, 0x45, 0x4d, 0x2e, 0x3e, 0x4b, 0x4b, 0x55, 0x2e, 0x43, 0x50, 0x4e, 0x5f, 0x31, 0x31, 0x4a,
  0x48, 0x50, 0x0a, 0x10, 0x16, 0x24, 0x32, 0x38, 0x40, 0x41, 0x49, 0x4e, 0x58, 0x5c, 0x19, 0x08,
  0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x5a, 0x61, 0x64, 0x64,
  0x64, 0x50, 0x52, 0x0c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x04, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x48, 0x27, 0x27, 0x27, 0x23, 0x27, 0x27, 0x2c, 0x2a, 0x2a, 0x35, 0x34,
  0x3a, 0x24, 0x1f, 0x16, 0x14, 0x32, 0x32, 0x12, 0x02, 0x2a, 0x2b, 0x36, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x53, 0x5d, 0x64, 0x64, 0x3c, 0x64, 0x64, 0x18, 0x28, 0x58, 0x0a, 0x55, 0x19, 0x23,
  0x2d, 0x40, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x08, 0x0d, 0x0f, 0x28, 0x18, 0x03, 0x02, 0x08, 0x1b, 0x1b, 0x32, 0x26, 0x32,
  0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x1f, 0x0f, 0x00, 0x00, 0x00, 0x08,
  0x0f, 0x0c, 0x19, 0x12, 0x16, 0x22, 0x1b, 0x2d, 0x3c, 0x3f, 0x46, 0x4b, 0x15, 0x1a, 0x21, 0x28,
  0x41, 0x4b, 0x37, 0x3e, 0x49, 0x11, 0x15, 0x1a, 0x2a, 0x2e, 0x30, 0x28, 0x34, 0x3c, 0x48, 0x4b,
  0x55, 0x10, 0x03, 0x05, 0x05, 0x0a, 0x10, 0x17, 0x12, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x02, 0x08, 0x0b, 0x26, 0x16, 0x06, 0x01, 0x04, 0x00, 0x00, 0x05, 0x05, 0x05, 0x0f,
  0x14, 0x18, 0x19, 0x4a, 0x3c, 0x32, 0x3c, 0x41, 0x3c, 0x4b, 0x4d, 0x36, 0x3c, 0x44, 0x4e, 0x10,
  0x14, 0x12, 0x27, 0x2b, 0x0d, 0x18, 0x26, 0x37, 0x42, 0x25, 0x1a, 0x3a, 0x21, 0x13, 0x1c, 0x28,
  0x2d, 0x3c, 0x4b, 0x52, 0x4d, 0x52, 0x64, 0x35, 0x45, 0x4b, 0x57, 0x5d, 0x5f, 0x25, 0x29, 0x33,
  0x46, 0x5d, 0x32, 0x40, 0x50, 0x64, 0x64, 0x48, 0x55, 0x58, 0x64, 0x0c, 0x1a, 0x20, 0x37, 0x42,
  0x36, 0x2c, 0x30, 0x3c, 0x2d, 0x30, 0x4f, 0x55, 0x5a, 0x64, 0x43, 0x63, 0x4a, 0x4b, 0x5a, 0x61,
  0x64, 0x5f, 0x5f, 0x64, 0x64, 0x3c, 0x58, 0x64, 0x64, 0x64, 0x3e, 0x49, 0x55, 0x0f, 0x1c, 0x22,
  0x32, 0x3c, 0x50, 0x30, 0x48, 0x40, 0x5a, 0x29, 0x48, 0x50, 0x0d, 0x12, 0x1e, 0x28, 0x37, 0x44,
  0x28, 0x2d, 0x37, 0x41, 0x52, 0x52, 0x52, 0x57, 0x23, 0x3d, 0x49, 0x5a, 0x19, 0x03, 0x08, 0x16,
  0x19, 0x3a, 0x29, 0x46, 0x52, 0x30, 0x3c, 0x03, 0x08, 0x14, 0x16, 0x25, 0x20, 0x26, 0x48, 0x3a,
  0x38, 0x4c, 0x38, 0x1e, 0x2d, 0x54, 0x5a, 0x05, 0x2f, 0x32, 0x21, 0x3c, 0x2f, 0x00, 0x11, 0x0a,
  0x25, 0x15, 0x00, 0x10, 0x11, 0x3c, 0x3a, 0x00, 0x00, 0x2d, 0x4e, 0x21, 0x2f, 0x46, 0x16, 0x2f,
  0x1e, 0x39, 0x19, 0x17, 0x2a, 0x38, 0x48, 0x1c, 0x55, 0x2b, 0x5b, 0x5d, 0x2f, 0x1b, 0x52, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03,
  0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x07, 0x00, 0x00, 0x07, 0x08, 0x0c, 0x10, 0x11, 0x0f,
  0x0a, 0x04, 0x05, 0x06, 0x07, 0x04, 0x00, 0x01, 0x01, 0x02, 0x08, 0x14, 0x1e, 0x26, 0x16, 0x0b,
  0x0c, 0x0b, 0x13, 0x1e, 0x1e, 0x1e, 0x25, 0x30, 0x23, 0x1f, 0x1a, 0x10, 0x07, 0x0b, 0x0e, 0x0c,
  0x0f, 0x0f, 0x10, 0x16, 0x1c, 0x19, 0x1e, 0x28, 0x28, 0x23, 0x2f, 0x38, 0x3d, 0x47, 0x47, 0x3f,
  0x45, 0x43, 0x3e, 0x38, 0x2e, 0x35, 0x2d, 0x1a, 0x14, 0x0f, 0x12, 0x14, 0x2a, 0x32, 0x37, 0x37,
  0x3a, 0x35, 0x40, 0x2f, 0x3f, 0x46, 0x2e, 0x26, 0x20, 0x17, 0x10, 0x12, 0x19, 0x22, 0x3c, 0x2c,
  0x35, 0x46, 0x4d, 0x3c, 0x2e, 0x25, 0x1e, 0x0b, 0x0b, 0x10, 0x29, 0x2e, 0x32, 0x3c, 0x48, 0x46,
  0x41, 0x38, 0x35, 0x2b, 0x2a, 0x31, 0x33, 0x39, 0x41, 0x3f, 0x39, 0x38, 0x3e, 0x28, 0x26, 0x13,
  0x0c, 0x0a, 0x09, 0x09, 0x14, 0x10, 0x23, 0x28, 0x1f, 0x1d, 0x23, 0x20, 0x22, 0x25, 0x19, 0x10,
  0x18, 0x17, 0x14, 0x12, 0x0a, 0x07, 0x0a, 0x10, 0x12, 0x12, 0x0c, 0x15, 0x11, 0x14, 0x10, 0x0d,
  0x02, 0x06, 0x06, 0x06, 0x0a, 0x0b, 0x0f, 0x0b, 0x07, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x3f,
  0x3d, 0x3d, 0x2d, 0x2d, 0x2e, 0x21, 0x32, 0x39, 0x39, 0x4c, 0x50, 0x4b, 0x3a, 0x37, 0x33, 0x29,
  0x25, 0x36, 0x34, 0x1f, 0x1e, 0x1e, 0x0c, 0x0c, 0x0e, 0x14, 0x1b, 0x2d, 0x43, 0x49, 0x39, 0x3a,
  0x3c, 0x43, 0x2f, 0x19, 0x18, 0x15, 0x16, 0x12, 0x27, 0x23, 0x26, 0x1d, 0x13, 0x24, 0x30, 0x28,
  0x28, 0x23, 0x15, 0x1b, 0x3a, 0x37, 0x2e, 0x24, 0x1e, 0x15, 0x17, 0x23, 0x18, 0x11, 0x1e, 0x18,
  0x20, 0x23, 0x2f, 0x28, 0x24, 0x21, 0x2a, 0x34, 0x14, 0x10, 0x19, 0x2d, 0x36, 0x3c, 0x47, 0x43,
  0x3f, 0x41, 0x4c, 0x4c, 0x46, 0x37, 0x3b, 0x25, 0x29, 0x2b, 0x34, 0x38, 0x3f, 0x4e, 0x4e, 0x5b,
  0x43, 0x46, 0x41, 0x47, 0x3a, 0x41, 0x28, 0x32, 0x3e, 0x46, 0x4e, 0x54, 0x59, 0x58, 0x55, 0x54,
  0x5a, 0x5a, 0x57, 0x5b, 0x4e, 0x5c, 0x5f, 0x5f, 0x5f, 0x64, 0x61, 0x50, 0x5a, 0x62, 0x61, 0x54,
  0x52, 0x54, 0x3c, 0x37, 0x46, 0x50, 0x64, 0x4d, 0x47, 0x3d, 0x2d, 0x37, 0x3e, 0x46, 0x46, 0x4c,
  0x55, 0x50, 0x5a, 0x55, 0x41, 0x55, 0x5e, 0x5c, 0x5f, 0x56, 0x5f, 0x5a, 0x58, 0x3e, 0x3a, 0x40,
  0x50, 0x58, 0x56, 0x52, 0x50, 0x48, 0x3b, 0x45, 0x58, 0x55, 0x5b, 0x55, 0x4c, 0x40, 0x35, 0x2b,
  0x34, 0x3e, 0x3a, 0x2e, 0x31, 0x37, 0x41, 0x3e, 0x4b, 0x55, 0x55, 0x59, 0x4e, 0x41, 0x46, 0x3a,
  0x2a, 0x17, 0x2b, 0x32, 0x21, 0x37, 0x30, 0x32, 0x39, 0x41, 0x44, 0x44, 0x41, 0x31, 0x22, 0x2c,
  0x1c, 0x1a, 0x20, 0x2a, 0x31, 0x1c, 0x11, 0x1f, 0x0f, 0x12, 0x0e, 0x0b, 0x19, 0x0a, 0x03, 0x07,
  0x07, 0x00, 0x00, 0x03, 0x0d, 0x19, 0x20, 0x31, 0x32, 0x28, 0x2f, 0x3f, 0x36, 0x4c, 0x47, 0x14,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x17, 0x0f, 0x06, 0x08, 0x07,
  0x0d, 0x07, 0x02, 0x07, 0x07, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x14, 0x20, 0x2b, 0x33, 0x35,
  0x3c, 0x32, 0x41, 0x42, 0x49, 0x46, 0x4f, 0x50, 0x54, 0x46, 0x4b, 0x56, 0x52, 0x5c, 0x60, 0x64,
  0x5e, 0x5e, 0x61, 0x4c, 0x55, 0x60, 0x51, 0x59, 0x4c, 0x47, 0x45, 0x3e, 0x4e, 0x52, 0x5b, 0x55,
  0x54, 0x48, 0x53, 0x4f, 0x5b, 0x5c, 0x55, 0x52, 0x4e, 0x4f, 0x49, 0x5c, 0x5f, 0x4e, 0x53, 0x5a,
  0x56, 0x5a, 0x64, 0x49, 0x4b, 0x57, 0x60, 0x5b, 0x59, 0x57, 0x55, 0x58, 0x53, 0x55, 0x50, 0x53,
  0x44, 0x39, 0x2f, 0x3c, 0x28, 0x23, 0x1c, 0x28, 0x32, 0x21, 0x13, 0x19, 0x0f, 0x00, 0x00, 0x04,
  0x0a, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0f, 0x10, 0x18
};

static const unsigned char palette_19_0B_M[] =
{
  0x10, 0x12, 0x17, 0x1e, 0x17, 0x1f, 0x18, 0x0d, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x1a, 0x1e, 0x31, 0x27, 0x3c, 0x32, 0x2b, 0x2e, 0x26, 0x0f,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x1c, 0x31, 0x3e, 0x45,
  0x43, 0x3f, 0x48, 0x3f, 0x3c, 0x38, 0x21, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0e, 0x21, 0x23, 0x37, 0x42, 0x47, 0x43, 0x51, 0x53, 0x58, 0x58, 0x5a,
  0x4b, 0x39, 0x2d, 0x28, 0x24, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0f, 0x1e, 0x20, 0x24, 0x2d, 0x35, 0x37, 0x43, 0x54, 0x51, 0x57, 0x58, 0x5c,
  0x5f, 0x64, 0x5c, 0x5f, 0x5a, 0x5a, 0x4c, 0x3a, 0x34, 0x25, 0x23, 0x21, 0x0e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x26, 0x2b, 0x3f, 0x41,
  0x46, 0x50, 0x64, 0x64, 0x5f, 0x5f, 0x62, 0x62, 0x60, 0x64, 0x64, 0x64, 0x64, 0x61, 0x5a, 0x4d,
  0x40, 0x32, 0x29, 0x26, 0x1e, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x1d, 0x2b, 0x2c, 0x4b, 0x49, 0x55, 0x5b, 0x5b, 0x5e, 0x5f, 0x62, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x61, 0x62, 0x59, 0x4a, 0x43, 0x41, 0x38, 0x23, 0x1f, 0x21, 0x09,
  0x0f, 0x00, 0x03, 0x08, 0x19, 0x19, 0x00, 0x01, 0x0d, 0x1f, 0x1f, 0x3f, 0x32, 0x55, 0x4e, 0x57,
  0x5b, 0x5d, 0x62, 0x62, 0x62, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5d, 0x5a, 0x4f, 0x43, 0x39,
  0x34, 0x2a, 0x2d, 0x23, 0x23, 0x24, 0x22, 0x23, 0x24, 0x19, 0x3f, 0x27, 0x2b, 0x3c, 0x44, 0x5a,
  0x5d, 0x24, 0x1d, 0x29, 0x34, 0x41, 0x4b, 0x55, 0x4b, 0x3e, 0x4e, 0x52, 0x58, 0x5c, 0x64, 0x56,
  0x64, 0x44, 0x3b, 0x4b, 0x58, 0x54, 0x58, 0x59, 0x64, 0x5c, 0x64, 0x4f, 0x64, 0x64, 0x28, 0x37,
  0x41, 0x41, 0x34, 0x4b, 0x56, 0x50, 0x5c, 0x51, 0x5b, 0x57, 0x62, 0x5d, 0x52, 0x53, 0x5a, 0x5c,
  0x60, 0x56, 0x58, 0x55, 0x58, 0x5a, 0x5a, 0x5c, 0x30, 0x38, 0x3a, 0x32, 0x47, 0x2b, 0x41, 0x4a,
  0x4a, 0x54, 0x4e, 0x3c, 0x46, 0x50, 0x57, 0x56, 0x56, 0x5a, 0x52, 0x5c, 0x5a, 0x22, 0x23, 0x32,
  0x35, 0x3e, 0x44, 0x46, 0x4b, 0x4b, 0x48, 0x50, 0x4c, 0x4b, 0x50, 0x21, 0x2c, 0x30, 0x33, 0x3b,
  0x37, 0x39, 0x3c, 0x40, 0x1e, 0x0e, 0x07, 0x03, 0x0d, 0x14, 0x0e, 0x0a, 0x0f, 0x13, 0x14, 0x23,
  0x2d, 0x23, 0x21, 0x28, 0x32, 0x32, 0x2f, 0x31, 0x38, 0x3c, 0x4e, 0x4a, 0x0a, 0x0f, 0x25, 0x13,
  0x27, 0x29, 0x36, 0x30, 0x3e, 0x0f, 0x21, 0x2b, 0x38, 0x13, 0x18, 0x31, 0x0a, 0x03, 0x0e, 0x09,
  0x20, 0x1b, 0x14, 0x0b, 0x19, 0x2d, 0x2d, 0x38, 0x44, 0x41, 0x4a, 0x07, 0x0f, 0x1d, 0x02, 0x02,
  0x0c, 0x00, 0x0d, 0x14, 0x23, 0x26, 0x29, 0x32, 0x3e, 0x46, 0x00, 0x16, 0x17, 0x1a, 0x20, 0x32,
  0x3a, 0x3b, 0x55, 0x27, 0x33, 0x38, 0x34, 0x3b, 0x0f, 0x19, 0x1d, 0x27, 0x30, 0x3e, 0x47, 0x4d,
  0x55, 0x29, 0x28, 0x29, 0x32, 0x2f, 0x3f, 0x46, 0x3a, 0x2d, 0x32, 0x3a, 0x40, 0x43, 0x52, 0x51,
  0x56, 0x53, 0x21, 0x22, 0x27, 0x35, 0x30, 0x35, 0x3b, 0x40, 0x46, 0x3c, 0x1e, 0x32, 0x4b, 0x41,
  0x46, 0x52, 0x52, 0x53, 0x57, 0x55, 0x53, 0x4f, 0x51, 0x52, 0x57, 0x5f, 0x44, 0x4e, 0x5a, 0x56,
  0x5f, 0x57, 0x5f, 0x64, 0x64, 0x38, 0x41, 0x4e, 0x23, 0x19, 0x3a, 0x39, 0x38, 0x46, 0x49, 0x29,
  0x1d, 0x48, 0x41, 0x53, 0x1e, 0x28, 0x34, 0x57, 0x5a, 0x17, 0x25, 0x3e, 0x51, 0x58, 0x23, 0x35,
  0x3f, 0x40, 0x49, 0x23, 0x34, 0x3f, 0x41, 0x48, 0x24, 0x38, 0x46, 0x43, 0x57, 0x29, 0x2a, 0x43,
  0x41, 0x4a, 0x07, 0x0e, 0x15, 0x20, 0x2d, 0x30, 0x37, 0x3a, 0x43, 0x46, 0x4e, 0x53, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x5a, 0x3d, 0x19, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x2e,
  0x3a, 0x64, 0x64, 0x12, 0x02, 0x41, 0x46, 0x3f, 0x3a, 0x2d, 0x1e, 0x17, 0x00, 0x00, 0x64, 0x5a,
  0x52, 0x20, 0x1a, 0x00, 0x00, 0x45, 0x31, 0x36, 0x33, 0x30, 0x2e, 0x20, 0x20, 0x23, 0x21, 0x1f,
  0x1e, 0x02, 0x00, 0x00, 0x00, 0x14, 0x2d, 0x15, 0x02, 0x38, 0x35, 0x2d, 0x64, 0x64, 0x64, 0x52,
  0x35, 0x0a, 0x00, 0x00, 0x01, 0x3c, 0x00, 0x00, 0x38, 0x59, 0x59, 0x5c, 0x64, 0x00, 0x15, 0x1d,
  0x25, 0x39, 0x45, 0x3a, 0x3f, 0x52, 0x12, 0x17, 0x12, 0x25, 0x28, 0x2e, 0x30, 0x26, 0x32, 0x47,
  0x47, 0x55, 0x3c, 0x3a, 0x1c, 0x64, 0x5d, 0x48, 0x63, 0x5e, 0x64, 0x64, 0x64, 0x64, 0x50, 0x58,
  0x46, 0x59, 0x39, 0x46, 0x23, 0x30, 0x3a, 0x40, 0x41, 0x4b, 0x51, 0x30, 0x25, 0x2d, 0x34, 0x2d,
  0x23, 0x36, 0x40, 0x32, 0x3c, 0x41, 0x4c, 0x52, 0x54, 0x5f, 0x5a, 0x55, 0x32, 0x3e, 0x40, 0x49,
  0x56, 0x58, 0x46, 0x4b, 0x4e, 0x2e, 0x35, 0x2f, 0x3c, 0x43, 0x46, 0x38, 0x36, 0x46, 0x50, 0x50,
  0x5a, 0x22, 0x0a, 0x11, 0x0e, 0x19, 0x18, 0x1b, 0x23, 0x08, 0x0b, 0x0a, 0x14, 0x1e, 0x20, 0x21,
  0x19, 0x1e, 0x17, 0x23, 0x21, 0x2b, 0x1a, 0x09, 0x0c, 0x0a, 0x0f, 0x11, 0x0b, 0x11, 0x0e, 0x1b,
  0x1c, 0x21, 0x18, 0x50, 0x3e, 0x33, 0x3b, 0x41, 0x38, 0x41, 0x41, 0x28, 0x32, 0x32, 0x46, 0x0b,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x29, 0x0d, 0x00, 0x2c, 0x17, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x0a, 0x07, 0x21, 0x34, 0x0f, 0x1c, 0x2b, 0x3a, 0x49, 0x50, 0x10, 0x0c, 0x19,
  0x2f, 0x53, 0x00, 0x00, 0x00, 0x23, 0x37, 0x29, 0x34, 0x41, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x08, 0x0b, 0x0e, 0x17, 0x17, 0x08, 0x0c, 0x14, 0x2a, 0x19, 0x3c, 0x19, 0x1f, 0x23, 0x30,
  0x41, 0x46, 0x55, 0x46, 0x4b, 0x1a, 0x2b, 0x43, 0x50, 0x62, 0x2b, 0x32, 0x41, 0x10, 0x1c, 0x25,
  0x34, 0x3c, 0x50, 0x2e, 0x44, 0x42, 0x5c, 0x25, 0x3e, 0x48, 0x16, 0x22, 0x30, 0x46, 0x55, 0x52,
  0x37, 0x3c, 0x3e, 0x50, 0x5a, 0x57, 0x5a, 0x5f, 0x2d, 0x3a, 0x4a, 0x5c, 0x5d, 0x5d, 0x64, 0x64,
  0x64, 0x62, 0x54, 0x64, 0x61, 0x3c, 0x49, 0x05, 0x07, 0x10, 0x1a, 0x18, 0x1f, 0x25, 0x43, 0x27,
  0x2b, 0x3c, 0x2f, 0x15, 0x1e, 0x5f, 0x53, 0x32, 0x48, 0x44, 0x27, 0x3f, 0x53, 0x18, 0x2d, 0x58,
  0x5a, 0x47, 0x56, 0x37, 0x3a, 0x4a, 0x42, 0x19, 0x14, 0x3b, 0x55, 0x2a, 0x32, 0x4b, 0x1e, 0x37,
  0x21, 0x2e, 0x17, 0x13, 0x1c, 0x2e, 0x2c, 0x0b, 0x38, 0x09, 0x36, 0x54, 0x34, 0x21, 0x5f, 0x46,
  0x36, 0x2d, 0x28, 0x23, 0x32, 0x42, 0x37, 0x23, 0x1e, 0x18, 0x12, 0x11, 0x0d, 0x0b, 0x0f, 0x0b,
  0x0d, 0x08, 0x06, 0x0e, 0x0f, 0x0f, 0x11, 0x10, 0x1a, 0x24, 0x1f, 0x24, 0x28, 0x29, 0x2d, 0x34,
  0x3c, 0x35, 0x28, 0x23, 0x0a, 0x09, 0x0b, 0x0b, 0x0b, 0x09, 0x08, 0x0f, 0x0c, 0x19, 0x1f, 0x28,
  0x2c, 0x1c, 0x14, 0x0f, 0x07, 0x01, 0x01, 0x04, 0x03, 0x07, 0x03, 0x05, 0x01, 0x02, 0x09, 0x06,
  0x09, 0x0c, 0x10, 0x08, 0x16, 0x1b, 0x16, 0x1a, 0x0d, 0x0c, 0x07, 0x07, 0x0e, 0x10, 0x0a, 0x09,
  0x05, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x09, 0x09, 0x03, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x01, 0x0a, 0x07, 0x00, 0x00, 0x02, 0x06,
  0x01, 0x01, 0x01, 0x05, 0x08, 0x09, 0x07, 0x09, 0x0b, 0x10, 0x1e, 0x1a, 0x14, 0x0c, 0x0e, 0x07,
  0x08, 0x02, 0x07, 0x08, 0x0b, 0x0d, 0x19, 0x1b, 0x1c, 0x1d, 0x23, 0x2a, 0x2b, 0x34, 0x3e, 0x35,
  0x31, 0x27, 0x1b, 0x1b, 0x11, 0x0e, 0x0f, 0x11, 0x15, 0x19, 0x1a, 0x22, 0x22, 0x28, 0x24, 0x12,
  0x07, 0x09, 0x08, 0x0c, 0x1e, 0x25, 0x30, 0x2f, 0x3c, 0x4e, 0x3a, 0x2b, 0x21, 0x30, 0x32, 0x55,
  0x5d, 0x60, 0x5d, 0x5d, 0x49, 0x4b, 0x59, 0x5a, 0x5a, 0x5f, 0x5f, 0x62, 0x55, 0x58, 0x61, 0x60,
  0x5f, 0x5f, 0x5e, 0x5f, 0x52, 0x4a, 0x38, 0x32, 0x32, 0x38, 0x40, 0x4a, 0x59, 0x58, 0x4b, 0x50,
  0x48, 0x4b, 0x36, 0x3d, 0x34, 0x38, 0x42, 0x48, 0x53, 0x5a, 0x5c, 0x54, 0x4b, 0x4d, 0x49, 0x41,
  0x3f, 0x3a, 0x3c, 0x30, 0x3c, 0x3e, 0x33, 0x33, 0x2f, 0x29, 0x24, 0x31, 0x23, 0x1a, 0x29, 0x20,
  0x25, 0x2f, 0x2f, 0x2d, 0x1f, 0x1f, 0x29, 0x2e, 0x16, 0x16, 0x14, 0x1f, 0x1c, 0x20, 0x2a, 0x27,
  0x2b, 0x2a, 0x34, 0x34, 0x33, 0x2b, 0x34, 0x1b, 0x1e, 0x1c, 0x28, 0x28, 0x2d, 0x35, 0x38, 0x46,
  0x34, 0x3b, 0x3a, 0x3c, 0x30, 0x2f, 0x0e, 0x11, 0x20, 0x21, 0x2e, 0x35, 0x3c, 0x39, 0x3c, 0x3a,
  0x42, 0x43, 0x3e, 0x3a, 0x32, 0x44, 0x46, 0x4e, 0x53, 0x58, 0x50, 0x44, 0x52, 0x5a, 0x5a, 0x3c,
  0x37, 0x35, 0x1a, 0x12, 0x13, 0x25, 0x33, 0x25, 0x23, 0x1c, 0x14, 0x1d, 0x26, 0x2a, 0x2a, 0x25,
  0x36, 0x37, 0x3f, 0x3a, 0x2c, 0x3e, 0x52, 0x54, 0x54, 0x4c, 0x51, 0x53, 0x48, 0x30, 0x2e, 0x39,
  0x4c, 0x50, 0x54, 0x46, 0x47, 0x3c, 0x31, 0x39, 0x52, 0x53, 0x64, 0x58, 0x54, 0x39, 0x2f, 0x31,
  0x3e, 0x41, 0x49, 0x3a, 0x35, 0x3f, 0x49, 0x52, 0x4b, 0x53, 0x5a, 0x5f, 0x5f, 0x5c, 0x5a, 0x4c,
  0x44, 0x44, 0x4d, 0x4c, 0x3a, 0x4b, 0x46, 0x3e, 0x44, 0x4a, 0x4a, 0x48, 0x4d, 0x3a, 0x2b, 0x3b,
  0x22, 0x26, 0x2b, 0x34, 0x3f, 0x35, 0x30, 0x3f, 0x3f, 0x34, 0x34, 0x39, 0x4b, 0x55, 0x48, 0x50,
  0x50, 0x46, 0x4b, 0x3a, 0x21, 0x30, 0x36, 0x44, 0x43, 0x46, 0x4b, 0x5d, 0x5a, 0x5a, 0x52, 0x61,
  0x64, 0x64, 0x62, 0x62, 0x60, 0x60, 0x60, 0x64, 0x62, 0x63, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x5f,
  0x59, 0x5e, 0x5c, 0x5c, 0x5b, 0x5e, 0x5a, 0x50, 0x5a, 0x56, 0x50, 0x4f, 0x4c, 0x3e, 0x45, 0x4d,
  0x46, 0x48, 0x4a, 0x49, 0x41, 0x3f, 0x3a, 0x37, 0x33, 0x38, 0x3c, 0x50, 0x40, 0x2e, 0x2b, 0x23,
  0x24, 0x22, 0x22, 0x1b, 0x1b, 0x19, 0x1a, 0x0d, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x08, 0x11, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x30,
  0x1b, 0x06, 0x03, 0x00, 0x05, 0x14, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b,
  0x10, 0x00, 0x0d, 0x13, 0x17, 0x1f, 0x14, 0x0b, 0x16, 0x0c, 0x08, 0x20, 0x26, 0x21, 0x2b, 0x32,
  0x37, 0x3e, 0x43, 0x26, 0x2d, 0x36, 0x47, 0x4b, 0x4f, 0x50, 0x54, 0x59, 0x55, 0x5e, 0x5a, 0x5a,
  0x61, 0x5f, 0x5f, 0x62, 0x62, 0x5f, 0x64, 0x64, 0x5f, 0x5e, 0x5e, 0x55, 0x50, 0x47, 0x46, 0x57,
  0x64, 0x60, 0x64, 0x64, 0x64, 0x64, 0x5e, 0x40, 0x61, 0x61, 0x5f, 0x64
};

static const unsigned char palette_19_0B_Y[] =
{
  0x11, 0x0b, 0x00, 0x0d, 0x15, 0x23, 0x2b, 0x2c, 0x33, 0x30, 0x3a, 0x3b, 0x37, 0x35, 0x23, 0x19,
  0x11, 0x10, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x00, 0x14, 0x12, 0x34, 0x37, 0x35,
  0x46, 0x50, 0x4a, 0x46, 0x44, 0x3c, 0x30, 0x2a, 0x1d, 0x14, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x30, 0x44, 0x3e, 0x4b, 0x41, 0x4b, 0x5b, 0x45, 0x4e, 0x55, 0x54, 0x46, 0x3c, 0x34,
  0x30, 0x19, 0x05, 0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x24, 0x42, 0x54, 0x50, 0x5f,
  0x5f, 0x5f, 0x64, 0x61, 0x61, 0x64, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5c, 0x58, 0x3c, 0x37, 0x24,
  0x1e, 0x14, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x2c, 0x41, 0x5c, 0x5d, 0x5d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x64,
  0x58, 0x5f, 0x5a, 0x52, 0x3c, 0x34, 0x26, 0x1b, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x5e, 0x5f, 0x5f, 0x5f, 0x64,
  0x64, 0x5f, 0x5f, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x5f, 0x5a, 0x4e, 0x4b, 0x3c, 0x35,
  0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0c, 0x00, 0x0e, 0x46, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x5f, 0x5f, 0x53, 0x50, 0x48, 0x2f, 0x2c, 0x29, 0x05, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x18, 0x13, 0x34, 0x25, 0x3b, 0x3c, 0x46, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x60, 0x55, 0x55, 0x2e, 0x26, 0x12, 0x05, 0x11,
  0x1a, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x1c, 0x12, 0x11, 0x07, 0x05, 0x05, 0x0f, 0x00, 0x0a, 0x22,
  0x3e, 0x1a, 0x14, 0x07, 0x1f, 0x20, 0x15, 0x0c, 0x29, 0x20, 0x3c, 0x27, 0x44, 0x3b, 0x28, 0x30,
  0x2b, 0x32, 0x26, 0x3d, 0x3d, 0x3a, 0x39, 0x4b, 0x46, 0x4e, 0x47, 0x55, 0x5a, 0x5f, 0x5f, 0x62,
  0x60, 0x64, 0x60, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x62, 0x51, 0x4d, 0x61, 0x43, 0x55, 0x5d,
  0x64, 0x64, 0x64, 0x59, 0x64, 0x64, 0x64, 0x62, 0x64, 0x62, 0x62, 0x64, 0x64, 0x47, 0x51, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x51, 0x4e, 0x5f, 0x5f, 0x5f,
  0x62, 0x5f, 0x5f, 0x5f, 0x4e, 0x48, 0x4e, 0x5c, 0x5f, 0x5f, 0x50, 0x46, 0x5a, 0x4b, 0x53, 0x5f,
  0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x62, 0x64, 0x64, 0x64, 0x64, 0x61, 0x5f, 0x41, 0x44, 0x55, 0x4b,
  0x5a, 0x52, 0x5a, 0x5a, 0x5f, 0x30, 0x3f, 0x4d, 0x56, 0x3c, 0x46, 0x50, 0x29, 0x2c, 0x2f, 0x2f,
  0x33, 0x37, 0x3a, 0x28, 0x2f, 0x30, 0x37, 0x3a, 0x34, 0x2f, 0x2e, 0x1f, 0x24, 0x26, 0x14, 0x13,
  0x1b, 0x12, 0x1b, 0x17, 0x18, 0x1c, 0x14, 0x0e, 0x20, 0x32, 0x05, 0x17, 0x16, 0x19, 0x1b, 0x1f,
  0x08, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x1b, 0x1c, 0x1d, 0x24, 0x26, 0x36,
  0x2e, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x20, 0x14, 0x2b, 0x0c, 0x21, 0x32,
  0x3d, 0x3e, 0x1f, 0x1e, 0x24, 0x1e, 0x27, 0x16, 0x22, 0x27, 0x30, 0x2a, 0x15, 0x0f, 0x0d, 0x17,
  0x22, 0x21, 0x00, 0x28, 0x1d, 0x02, 0x37, 0x43, 0x42, 0x20, 0x37, 0x40, 0x29, 0x3a, 0x49, 0x44,
  0x33, 0x4b, 0x5f, 0x37, 0x2d, 0x48, 0x52, 0x58, 0x32, 0x32, 0x54, 0x47, 0x4a, 0x55, 0x50, 0x3a,
  0x2c, 0x4b, 0x46, 0x52, 0x2a, 0x2e, 0x35, 0x5a, 0x5a, 0x21, 0x31, 0x47, 0x55, 0x5f, 0x3e, 0x4e,
  0x58, 0x55, 0x5a, 0x3e, 0x48, 0x57, 0x55, 0x55, 0x39, 0x48, 0x4e, 0x47, 0x5a, 0x34, 0x31, 0x44,
  0x41, 0x4e, 0x0f, 0x19, 0x1b, 0x2b, 0x35, 0x3d, 0x47, 0x46, 0x4a, 0x52, 0x5a, 0x5f, 0x00, 0x00,
  0x0a, 0x18, 0x33, 0x57, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x62, 0x64, 0x0f, 0x03, 0x00, 0x0a,
  0x00, 0x00, 0x00, 0x14, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x2d, 0x32, 0x3e, 0x46, 0x5f, 0x00, 0x5d,
  0x59, 0x64, 0x64, 0x53, 0x5f, 0x19, 0x1e, 0x20, 0x2f, 0x2f, 0x34, 0x3c, 0x4a, 0x39, 0x3a, 0x35,
  0x30, 0x17, 0x0e, 0x06, 0x02, 0x1b, 0x19, 0x03, 0x00, 0x51, 0x58, 0x2c, 0x00, 0x15, 0x2a, 0x62,
  0x62, 0x64, 0x5f, 0x05, 0x00, 0x00, 0x5d, 0x56, 0x4e, 0x64, 0x64, 0x64, 0x00, 0x4b, 0x16, 0x1c,
  0x24, 0x34, 0x43, 0x20, 0x0c, 0x1e, 0x0a, 0x0f, 0x12, 0x15, 0x21, 0x1e, 0x2d, 0x29, 0x33, 0x41,
  0x32, 0x3c, 0x29, 0x31, 0x16, 0x41, 0x43, 0x35, 0x4e, 0x55, 0x5a, 0x5a, 0x50, 0x55, 0x46, 0x50,
  0x3c, 0x5c, 0x41, 0x52, 0x26, 0x44, 0x5d, 0x5a, 0x5f, 0x5f, 0x5f, 0x41, 0x5f, 0x5f, 0x5a, 0x44,
  0x3a, 0x5f, 0x5f, 0x5f, 0x5f, 0x41, 0x59, 0x5d, 0x5a, 0x5f, 0x5d, 0x5b, 0x43, 0x4d, 0x55, 0x58,
  0x5f, 0x5f, 0x55, 0x5a, 0x55, 0x4b, 0x5d, 0x46, 0x50, 0x5d, 0x5f, 0x4d, 0x46, 0x5f, 0x5f, 0x5d,
  0x5f, 0x2f, 0x11, 0x27, 0x1e, 0x28, 0x26, 0x2c, 0x37, 0x12, 0x1f, 0x15, 0x43, 0x46, 0x4b, 0x5d,
  0x5f, 0x5d, 0x31, 0x46, 0x5d, 0x58, 0x2e, 0x30, 0x45, 0x58, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x52,
  0x5d, 0x62, 0x2f, 0x62, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x62, 0x41, 0x4e, 0x50, 0x5f, 0x35,
  0x4b, 0x5d, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x4e, 0x5f, 0x41, 0x17, 0x29, 0x31,
  0x2b, 0x3b, 0x49, 0x45, 0x64, 0x64, 0x61, 0x37, 0x43, 0x5f, 0x5a, 0x64, 0x5f, 0x2e, 0x26, 0x35,
  0x46, 0x5f, 0x14, 0x1e, 0x2c, 0x4d, 0x41, 0x32, 0x37, 0x44, 0x5f, 0x05, 0x02, 0x0c, 0x0c, 0x0e,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x0f, 0x19, 0x14, 0x1e, 0x14, 0x37, 0x0a, 0x00, 0x00, 0x0b,
  0x05, 0x00, 0x00, 0x05, 0x2e, 0x00, 0x17, 0x1a, 0x41, 0x29, 0x1e, 0x2a, 0x35, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x16, 0x0f, 0x3c, 0x0f, 0x28, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b,
  0x14, 0x03, 0x23, 0x2a, 0x31, 0x3d, 0x44, 0x4e, 0x16, 0x2e, 0x3f, 0x58, 0x00, 0x25, 0x30, 0x21,
  0x37, 0x49, 0x36, 0x40, 0x4b, 0x32, 0x36, 0x0c, 0x0a, 0x12, 0x1a, 0x19, 0x2e, 0x2d, 0x4b, 0x37,
  0x2a, 0x35, 0x28, 0x12, 0x19, 0x60, 0x55, 0x35, 0x54, 0x62, 0x59, 0x23, 0x4d, 0x0c, 0x28, 0x4a,
  0x5f, 0x46, 0x5f, 0x35, 0x47, 0x5a, 0x53, 0x23, 0x1c, 0x55, 0x5a, 0x41, 0x45, 0x5f, 0x35, 0x5a,
  0x5a, 0x3e, 0x4b, 0x2b, 0x4b, 0x4a, 0x41, 0x14, 0x32, 0x14, 0x28, 0x43, 0x00, 0x14, 0x5a, 0x19,
  0x0b, 0x08, 0x05, 0x00, 0x14, 0x1d, 0x1c, 0x0f, 0x0d, 0x0c, 0x0a, 0x03, 0x05, 0x05, 0x05, 0x00,
  0x07, 0x08, 0x07, 0x0e, 0x0e, 0x0f, 0x0d, 0x0d, 0x18, 0x24, 0x1d, 0x18, 0x1d, 0x27, 0x24, 0x31,
  0x41, 0x3b, 0x28, 0x28, 0x14, 0x13, 0x10, 0x0e, 0x0e, 0x0a, 0x0d, 0x13, 0x10, 0x2b, 0x36, 0x42,
  0x4b, 0x35, 0x32, 0x27, 0x13, 0x11, 0x0f, 0x17, 0x1c, 0x20, 0x1d, 0x28, 0x3e, 0x4e, 0x40, 0x39,
  0x26, 0x32, 0x3c, 0x3b, 0x50, 0x51, 0x5f, 0x5f, 0x5b, 0x51, 0x3e, 0x52, 0x62, 0x62, 0x55, 0x3b,
  0x1e, 0x11, 0x0f, 0x0f, 0x0f, 0x19, 0x26, 0x3e, 0x2c, 0x28, 0x37, 0x50, 0x62, 0x64, 0x51, 0x3a,
  0x3b, 0x47, 0x4b, 0x3c, 0x4b, 0x43, 0x41, 0x49, 0x39, 0x39, 0x33, 0x1d, 0x14, 0x12, 0x0a, 0x0f,
  0x17, 0x12, 0x10, 0x11, 0x24, 0x2b, 0x28, 0x39, 0x2f, 0x25, 0x31, 0x32, 0x34, 0x43, 0x3e, 0x32,
  0x39, 0x27, 0x27, 0x26, 0x23, 0x21, 0x1d, 0x11, 0x0c, 0x08, 0x0a, 0x0c, 0x16, 0x1c, 0x21, 0x21,
  0x23, 0x1d, 0x21, 0x14, 0x16, 0x1e, 0x12, 0x0e, 0x0f, 0x0f, 0x07, 0x07, 0x07, 0x0d, 0x0f, 0x0d,
  0x14, 0x14, 0x0d, 0x0b, 0x0a, 0x05, 0x0a, 0x02, 0x03, 0x02, 0x0d, 0x0b, 0x05, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x10, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x4b,
  0x52, 0x5c, 0x5c, 0x54, 0x3c, 0x37, 0x47, 0x4f, 0x46, 0x58, 0x5b, 0x60, 0x41, 0x4d, 0x4a, 0x54,
  0x5b, 0x61, 0x5f, 0x5f, 0x4c, 0x3c, 0x32, 0x39, 0x32, 0x42, 0x4c, 0x5a, 0x61, 0x61, 0x5a, 0x5a,
  0x55, 0x51, 0x41, 0x41, 0x2c, 0x37, 0x3f, 0x4b, 0x55, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5d, 0x5d,
  0x5f, 0x5f, 0x5f, 0x5f, 0x53, 0x41, 0x3a, 0x3e, 0x39, 0x2f, 0x2b, 0x3d, 0x33, 0x30, 0x41, 0x3c,
  0x3b, 0x4d, 0x5a, 0x4e, 0x3e, 0x37, 0x3d, 0x42, 0x3f, 0x4e, 0x59, 0x52, 0x49, 0x5d, 0x5d, 0x52,
  0x4d, 0x50, 0x4e, 0x4f, 0x4b, 0x42, 0x46, 0x37, 0x3b, 0x3a, 0x47, 0x48, 0x49, 0x53, 0x57, 0x5f,
  0x5c, 0x55, 0x55, 0x55, 0x45, 0x50, 0x2b, 0x31, 0x3c, 0x46, 0x52, 0x50, 0x5c, 0x53, 0x52, 0x58,
  0x5a, 0x5a, 0x48, 0x44, 0x40, 0x4e, 0x4b, 0x55, 0x5e, 0x5c, 0x4e, 0x4b, 0x58, 0x60, 0x5e, 0x3e,
  0x34, 0x3e, 0x28, 0x2b, 0x29, 0x35, 0x2e, 0x18, 0x18, 0x15, 0x10, 0x12, 0x1b, 0x1c, 0x20, 0x11,
  0x1a, 0x2a, 0x28, 0x1e, 0x00, 0x17, 0x3c, 0x46, 0x46, 0x41, 0x24, 0x36, 0x2b, 0x17, 0x0b, 0x16,
  0x2c, 0x3c, 0x49, 0x41, 0x06, 0x00, 0x00, 0x00, 0x32, 0x1e, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x03,
  0x1c, 0x2d, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x41, 0x54, 0x48, 0x2f, 0x00, 0x00, 0x00,
  0x00, 0x0d, 0x10, 0x0c, 0x00, 0x21, 0x2d, 0x2d, 0x28, 0x33, 0x36, 0x2f, 0x30, 0x24, 0x0e, 0x09,
  0x01, 0x0a, 0x2a, 0x31, 0x3a, 0x16, 0x0f, 0x14, 0x0a, 0x07, 0x0a, 0x1e, 0x22, 0x1e, 0x19, 0x17,
  0x26, 0x28, 0x38, 0x35, 0x1a, 0x2c, 0x2d, 0x2e, 0x2f, 0x39, 0x35, 0x43, 0x3f, 0x4b, 0x49, 0x50,
  0x5a, 0x52, 0x5b, 0x4a, 0x59, 0x5f, 0x5e, 0x64, 0x5d, 0x4d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x59,
  0x55, 0x5f, 0x55, 0x5e, 0x5f, 0x5f, 0x5f, 0x53, 0x5d, 0x5d, 0x5d, 0x5d, 0x57, 0x57, 0x5a, 0x55,
  0x56, 0x5a, 0x63, 0x64, 0x64, 0x5f, 0x5f, 0x5f, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x50,
  0x4a, 0x50, 0x55, 0x50, 0x57, 0x5a, 0x48, 0x44, 0x3b, 0x3c, 0x34, 0x26, 0x33, 0x37, 0x3f, 0x32,
  0x2a, 0x16, 0x10, 0x0b, 0x23, 0x19, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
  0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0x0f, 0x17, 0x28, 0x2f, 0x2d, 0x35, 0x43, 0x47, 0x49
};

static const unsigned char palette_19_0B_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
  0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2d, 0x37, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x14, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x14, 0x00, 0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x46, 0x55, 0x0a, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x14, 0x0a, 0x0a, 0x0a, 0x0a, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x0a, 0x14, 0x2d, 0x2d, 0x28, 0x1e, 0x14, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// PANTONE Match System Coated CDR10

static const unsigned char palette_19_11_C[] =
{
  0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x06, 0x06, 0x06, 0x06, 0x09, 0x12, 0x1b,
  0x1b, 0x09, 0x00, 0x0b, 0x12, 0x22, 0x2b, 0x33, 0x33, 0x06, 0x09, 0x0f, 0x1e, 0x26, 0x2b, 0x1e,
  0x06, 0x0f, 0x17, 0x2b, 0x2f, 0x33, 0x33, 0x09, 0x0f, 0x2b, 0x41, 0x3c, 0x33, 0x26, 0x17, 0x22,
  0x2f, 0x45, 0x48, 0x4f, 0x48, 0x1e, 0x2f, 0x3c, 0x4f, 0x4f, 0x4f, 0x4c, 0x26, 0x38, 0x48, 0x57,
  0x57, 0x57, 0x53, 0x0b, 0x1b, 0x38, 0x5e, 0x5e, 0x5b, 0x57, 0x1e, 0x2b, 0x38, 0x4f, 0x5e, 0x64,
  0x64, 0x1e, 0x2b, 0x3c, 0x64, 0x64, 0x64, 0x57, 0x2b, 0x3c, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x12,
  0x2f, 0x53, 0x5e, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x22, 0x48, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x45, 0x64, 0x64, 0x64, 0x64, 0x22, 0x38, 0x5b, 0x64, 0x64,
  0x64, 0x64, 0x1b, 0x2f, 0x48, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64,
  0x33, 0x4c, 0x57, 0x64, 0x64, 0x64, 0x64, 0x22, 0x48, 0x64, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x38,
  0x4c, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x53, 0x64,
  0x64, 0x64, 0x64, 0x12, 0x26, 0x33, 0x64, 0x64, 0x64, 0x64, 0x1b, 0x3c, 0x5e, 0x64, 0x64, 0x64,
  0x64, 0x26, 0x33, 0x48, 0x64, 0x64, 0x64, 0x64, 0x22, 0x2f, 0x45, 0x5b, 0x64, 0x64, 0x64, 0x2b,
  0x3c, 0x57, 0x64, 0x64, 0x64, 0x64, 0x12, 0x17, 0x26, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x33, 0x5b,
  0x64, 0x64, 0x64, 0x64, 0x22, 0x2b, 0x38, 0x53, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x3c, 0x64, 0x64,
  0x64, 0x4f, 0x0f, 0x17, 0x26, 0x5b, 0x64, 0x64, 0x4f, 0x1b, 0x26, 0x3c, 0x4c, 0x4c, 0x4c, 0x48,
  0x0b, 0x12, 0x1e, 0x41, 0x41, 0x3c, 0x2b, 0x09, 0x0f, 0x17, 0x2b, 0x38, 0x2b, 0x22, 0x09, 0x0b,
  0x12, 0x1e, 0x12, 0x0f, 0x00, 0x06, 0x0b, 0x0b, 0x12, 0x12, 0x0b, 0x06, 0x06, 0x06, 0x09, 0x0b,
  0x0b, 0x06, 0x00, 0x00, 0x06, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x0b, 0x17, 0x22, 0x06, 0x0b, 0x17,
  0x26, 0x48, 0x57, 0x5b, 0x06, 0x06, 0x09, 0x09, 0x0f, 0x0b, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x4f, 0x4c, 0x22, 0x17, 0x0f, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x06, 0x06, 0x06, 0x4f, 0x3c, 0x2f, 0x12,
  0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x48, 0x45, 0x1e, 0x0f, 0x09, 0x06, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x45, 0x3c, 0x0f, 0x06,
  0x00, 0x00, 0x53, 0x3c, 0x2f, 0x0f, 0x09, 0x00, 0x00, 0x57, 0x4c, 0x33, 0x1e, 0x12, 0x0b, 0x09,
  0x57, 0x4c, 0x45, 0x1b, 0x12, 0x09, 0x06, 0x64, 0x5e, 0x41, 0x2b, 0x1e, 0x0b, 0x09, 0x5e, 0x4f,
  0x4f, 0x2b, 0x1b, 0x12, 0x0b, 0x53, 0x4f, 0x48, 0x2f, 0x1e, 0x12, 0x06, 0x64, 0x64, 0x5b, 0x2b,
  0x1e, 0x17, 0x0f, 0x64, 0x64, 0x64, 0x4c, 0x38, 0x26, 0x1e, 0x4f, 0x48, 0x38, 0x22, 0x12, 0x0b,
  0x06, 0x5b, 0x5e, 0x64, 0x3c, 0x2b, 0x1e, 0x0f, 0x64, 0x53, 0x41, 0x2b, 0x1e, 0x12, 0x0b, 0x57,
  0x3c, 0x26, 0x12, 0x0b, 0x09, 0x06, 0x3c, 0x57, 0x53, 0x2b, 0x1b, 0x12, 0x0b, 0x57, 0x3c, 0x2b,
  0x1e, 0x12, 0x0b, 0x06, 0x45, 0x48, 0x4c, 0x2b, 0x22, 0x12, 0x0b, 0x48, 0x33, 0x1e, 0x12, 0x0b,
  0x06, 0x06, 0x45, 0x53, 0x5e, 0x2f, 0x1e, 0x17, 0x0b, 0x22, 0x33, 0x38, 0x17, 0x12, 0x12, 0x0b,
  0x22, 0x1b, 0x12, 0x09, 0x06, 0x06, 0x00, 0x22, 0x1b, 0x0f, 0x09, 0x06, 0x06, 0x00, 0x00, 0x0b,
  0x1b, 0x0b, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x1b, 0x22, 0x2f, 0x38, 0x4c, 0x53, 0x0f, 0x1e, 0x2b, 0x38, 0x4c, 0x5b, 0x64, 0x12,
  0x22, 0x2f, 0x48, 0x53, 0x64, 0x64, 0x12, 0x1b, 0x26, 0x38, 0x45, 0x5e, 0x64, 0x12, 0x1e, 0x2b,
  0x41, 0x64, 0x64, 0x64, 0x12, 0x1b, 0x2f, 0x45, 0x5b, 0x64, 0x64, 0x0b, 0x0f, 0x17, 0x22, 0x38,
  0x45, 0x4f, 0x00, 0x00, 0x00, 0x06, 0x09, 0x12, 0x09, 0x00, 0x06, 0x06, 0x0b, 0x17, 0x1b, 0x0b,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x12, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x45, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x2b, 0x5e, 0x64,
  0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x5b, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x1e, 0x51, 0x64, 0x63, 0x64, 0x63, 0x5f, 0x64,
  0x63, 0x64, 0x62, 0x59, 0x4e, 0x27, 0x14, 0x2f, 0x54, 0x53, 0x53, 0x51, 0x52, 0x54, 0x4c, 0x00,
  0x5b, 0x3a, 0x01, 0x00, 0x00, 0x02, 0x0a, 0x63, 0x4b, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x55, 0x09,
  0x00, 0x00, 0x00, 0x08, 0x4b, 0x60, 0x0a, 0x00, 0x00, 0x00, 0x07, 0x51, 0x2c, 0x2b, 0x28, 0x28,
  0x27, 0x24, 0x2a
};

static const unsigned char palette_19_11_M[] =
{
  0x00, 0x64, 0x00, 0x00, 0x33, 0x5b, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x0b, 0x0b, 0x0b, 0x06, 0x06, 0x09, 0x0f, 0x12, 0x12, 0x0b, 0x06, 0x09, 0x12, 0x1e,
  0x1b, 0x17, 0x17, 0x00, 0x06, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x06, 0x09, 0x0f, 0x1b, 0x1b, 0x17,
  0x12, 0x09, 0x12, 0x1b, 0x22, 0x26, 0x26, 0x1b, 0x0b, 0x12, 0x1e, 0x26, 0x2f, 0x2b, 0x26, 0x0b,
  0x17, 0x1e, 0x2f, 0x2f, 0x26, 0x1b, 0x0b, 0x12, 0x1e, 0x2b, 0x33, 0x2b, 0x2b, 0x17, 0x1e, 0x26,
  0x33, 0x41, 0x33, 0x33, 0x09, 0x12, 0x26, 0x3c, 0x41, 0x3c, 0x33, 0x12, 0x22, 0x2b, 0x38, 0x3c,
  0x38, 0x38, 0x0b, 0x1e, 0x2f, 0x3c, 0x41, 0x3c, 0x38, 0x1e, 0x26, 0x2f, 0x41, 0x45, 0x45, 0x45,
  0x12, 0x26, 0x33, 0x41, 0x45, 0x45, 0x3c, 0x17, 0x2f, 0x3c, 0x4f, 0x4f, 0x4c, 0x48, 0x2b, 0x33,
  0x45, 0x57, 0x5e, 0x5b, 0x5b, 0x1b, 0x3c, 0x4c, 0x5b, 0x5e, 0x5b, 0x48, 0x1b, 0x33, 0x48, 0x5b,
  0x5b, 0x5b, 0x4f, 0x26, 0x38, 0x4c, 0x5e, 0x5b, 0x5b, 0x4c, 0x1e, 0x2b, 0x48, 0x5e, 0x64, 0x64,
  0x57, 0x1b, 0x2f, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x22, 0x3c, 0x4c, 0x64, 0x64, 0x5b, 0x53, 0x2b,
  0x38, 0x48, 0x64, 0x64, 0x5e, 0x53, 0x1e, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64, 0x33, 0x45, 0x53,
  0x64, 0x64, 0x5e, 0x57, 0x22, 0x41, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x26, 0x41, 0x4c, 0x5e, 0x5e,
  0x5e, 0x5e, 0x1e, 0x3c, 0x53, 0x5e, 0x5e, 0x5e, 0x64, 0x1e, 0x26, 0x3c, 0x5b, 0x5e, 0x5e, 0x57,
  0x12, 0x2b, 0x38, 0x5b, 0x5b, 0x5e, 0x5b, 0x17, 0x26, 0x4c, 0x64, 0x64, 0x64, 0x5e, 0x22, 0x33,
  0x41, 0x5e, 0x64, 0x64, 0x5e, 0x2b, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x3c, 0x4f, 0x64,
  0x64, 0x64, 0x64, 0x0f, 0x1e, 0x38, 0x5e, 0x5e, 0x5e, 0x5e, 0x1b, 0x26, 0x33, 0x4c, 0x5b, 0x5e,
  0x5e, 0x17, 0x22, 0x2f, 0x5e, 0x5e, 0x5e, 0x57, 0x22, 0x2f, 0x45, 0x5e, 0x5e, 0x5e, 0x5e, 0x0b,
  0x22, 0x3c, 0x53, 0x57, 0x57, 0x57, 0x0b, 0x17, 0x33, 0x4f, 0x4f, 0x4f, 0x4f, 0x09, 0x2b, 0x45,
  0x4f, 0x4c, 0x4c, 0x53, 0x09, 0x0f, 0x22, 0x48, 0x48, 0x48, 0x48, 0x06, 0x12, 0x2b, 0x3c, 0x45,
  0x41, 0x3c, 0x06, 0x0b, 0x1b, 0x38, 0x38, 0x38, 0x2f, 0x06, 0x09, 0x17, 0x2f, 0x26, 0x2b, 0x26,
  0x00, 0x09, 0x12, 0x2b, 0x2b, 0x12, 0x00, 0x00, 0x00, 0x09, 0x1e, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x09, 0x0b,
  0x0b, 0x06, 0x06, 0x0b, 0x0f, 0x12, 0x1b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x17,
  0x26, 0x45, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
  0x00, 0x00, 0x09, 0x06, 0x09, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x45, 0x41, 0x1b, 0x12, 0x0b, 0x06, 0x17, 0x12,
  0x0f, 0x09, 0x06, 0x00, 0x00, 0x12, 0x12, 0x12, 0x0b, 0x06, 0x06, 0x06, 0x48, 0x41, 0x41, 0x1e,
  0x17, 0x0f, 0x09, 0x38, 0x2f, 0x22, 0x17, 0x12, 0x0b, 0x06, 0x33, 0x38, 0x38, 0x22, 0x17, 0x0f,
  0x0b, 0x4f, 0x3c, 0x26, 0x1e, 0x17, 0x12, 0x0b, 0x53, 0x57, 0x57, 0x2b, 0x1b, 0x12, 0x0b, 0x4c,
  0x57, 0x64, 0x2f, 0x22, 0x1b, 0x0f, 0x41, 0x48, 0x4c, 0x33, 0x22, 0x17, 0x0f, 0x33, 0x33, 0x38,
  0x26, 0x1b, 0x12, 0x0b, 0x48, 0x3c, 0x2f, 0x26, 0x1b, 0x12, 0x0b, 0x5e, 0x5b, 0x5b, 0x33, 0x26,
  0x1e, 0x17, 0x64, 0x5b, 0x57, 0x33, 0x26, 0x1b, 0x12, 0x64, 0x57, 0x41, 0x2b, 0x1e, 0x17, 0x0f,
  0x5e, 0x5e, 0x5e, 0x33, 0x26, 0x17, 0x0f, 0x64, 0x5e, 0x41, 0x2b, 0x22, 0x12, 0x0b, 0x64, 0x5e,
  0x5e, 0x38, 0x2b, 0x1e, 0x12, 0x57, 0x48, 0x38, 0x22, 0x17, 0x0f, 0x06, 0x53, 0x4f, 0x48, 0x1e,
  0x12, 0x0f, 0x09, 0x33, 0x2f, 0x33, 0x17, 0x0f, 0x09, 0x06, 0x26, 0x0f, 0x0b, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x17, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0b, 0x12, 0x2b, 0x33, 0x06, 0x0b, 0x12,
  0x22, 0x3c, 0x45, 0x45, 0x06, 0x0b, 0x17, 0x26, 0x3c, 0x48, 0x4f, 0x09, 0x0b, 0x12, 0x1e, 0x2f,
  0x41, 0x4f, 0x0b, 0x12, 0x22, 0x2f, 0x41, 0x5b, 0x64, 0x0b, 0x12, 0x1b, 0x2b, 0x3c, 0x4c, 0x5e,
  0x0b, 0x1b, 0x1e, 0x2f, 0x38, 0x4f, 0x57, 0x0f, 0x17, 0x1e, 0x2b, 0x3c, 0x57, 0x53, 0x0f, 0x17,
  0x22, 0x38, 0x45, 0x53, 0x57, 0x0b, 0x0f, 0x1e, 0x2f, 0x45, 0x5b, 0x5b, 0x06, 0x0b, 0x12, 0x1b,
  0x26, 0x33, 0x38, 0x09, 0x0b, 0x12, 0x22, 0x26, 0x33, 0x33, 0x06, 0x0f, 0x12, 0x1b, 0x22, 0x33,
  0x33, 0x00, 0x00, 0x1b, 0x26, 0x26, 0x00, 0x00, 0x00, 0x16, 0x4f, 0x64, 0x64, 0x5b, 0x5b, 0x48,
  0x09, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x64, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2b, 0x3a,
  0x61, 0x63, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 0x64, 0x62, 0x64, 0x63, 0x29, 0x19, 0x01, 0x14,
  0x20, 0x01, 0x00, 0x01, 0x00, 0x01, 0x58, 0x50, 0x49, 0x47, 0x49, 0x46, 0x4d, 0x48, 0x44, 0x00,
  0x00, 0x00, 0x09, 0x41, 0x57, 0x5e, 0x60, 0x0c, 0x00, 0x17, 0x4f, 0x5e, 0x61, 0x63, 0x00, 0x03,
  0x20, 0x52, 0x5e, 0x5f, 0x3b, 0x00, 0x07, 0x2a, 0x5a, 0x61, 0x62, 0x48, 0x31, 0x34, 0x33, 0x38,
  0x3b, 0x3c, 0x20
};

static const unsigned char palette_19_11_Y[] =
{
  0x64, 0x00, 0x00, 0x00, 0x57, 0x57, 0x00, 0x33, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x48, 0x4f,
  0x64, 0x5e, 0x5e, 0x64, 0x64, 0x45, 0x48, 0x4f, 0x5e, 0x64, 0x64, 0x64, 0x38, 0x45, 0x53, 0x5e,
  0x64, 0x64, 0x64, 0x1b, 0x2b, 0x3c, 0x4c, 0x64, 0x64, 0x64, 0x33, 0x41, 0x4c, 0x64, 0x64, 0x64,
  0x64, 0x2b, 0x3c, 0x4f, 0x5b, 0x5e, 0x64, 0x64, 0x2f, 0x38, 0x4f, 0x4c, 0x64, 0x64, 0x64, 0x2f,
  0x4c, 0x53, 0x64, 0x64, 0x64, 0x64, 0x26, 0x33, 0x45, 0x57, 0x64, 0x64, 0x64, 0x38, 0x45, 0x4c,
  0x57, 0x64, 0x64, 0x64, 0x1b, 0x2b, 0x4c, 0x5e, 0x64, 0x64, 0x64, 0x22, 0x33, 0x48, 0x57, 0x64,
  0x64, 0x64, 0x12, 0x2f, 0x4c, 0x64, 0x64, 0x64, 0x64, 0x26, 0x2f, 0x3c, 0x57, 0x64, 0x64, 0x64,
  0x12, 0x2f, 0x45, 0x53, 0x64, 0x64, 0x57, 0x0f, 0x2b, 0x38, 0x5b, 0x5e, 0x53, 0x4f, 0x17, 0x1e,
  0x33, 0x5b, 0x64, 0x64, 0x64, 0x0b, 0x26, 0x3c, 0x57, 0x5e, 0x5e, 0x53, 0x09, 0x17, 0x2b, 0x4c,
  0x4c, 0x48, 0x41, 0x0b, 0x17, 0x26, 0x41, 0x41, 0x38, 0x38, 0x06, 0x06, 0x0f, 0x33, 0x3c, 0x38,
  0x2b, 0x06, 0x0b, 0x22, 0x41, 0x41, 0x41, 0x41, 0x00, 0x00, 0x06, 0x2b, 0x2b, 0x22, 0x22, 0x06,
  0x06, 0x06, 0x1e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x06, 0x06,
  0x06, 0x00, 0x00, 0x00, 0x12, 0x09, 0x0b, 0x0f, 0x06, 0x09, 0x0f, 0x1e, 0x0b, 0x12, 0x17, 0x0f,
  0x12, 0x1b, 0x1e, 0x09, 0x0f, 0x12, 0x1e, 0x1e, 0x26, 0x26, 0x0b, 0x1b, 0x2b, 0x2f, 0x2f, 0x2f,
  0x2f, 0x12, 0x1b, 0x26, 0x2f, 0x2f, 0x33, 0x38, 0x12, 0x1e, 0x2b, 0x33, 0x38, 0x38, 0x3c, 0x17,
  0x22, 0x33, 0x3c, 0x38, 0x3c, 0x3c, 0x0f, 0x12, 0x1b, 0x41, 0x41, 0x41, 0x41, 0x12, 0x1e, 0x3c,
  0x45, 0x45, 0x45, 0x45, 0x17, 0x1e, 0x2b, 0x41, 0x4c, 0x4c, 0x4f, 0x17, 0x22, 0x33, 0x4f, 0x4f,
  0x53, 0x57, 0x0f, 0x17, 0x22, 0x53, 0x5b, 0x5b, 0x57, 0x26, 0x33, 0x4f, 0x5b, 0x64, 0x64, 0x64,
  0x1e, 0x2f, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x22, 0x2f, 0x3c, 0x4f, 0x64, 0x64, 0x64, 0x3c, 0x48,
  0x5b, 0x5e, 0x64, 0x64, 0x57, 0x38, 0x4c, 0x4f, 0x53, 0x64, 0x64, 0x64, 0x33, 0x4c, 0x53, 0x5e,
  0x64, 0x64, 0x64, 0x45, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x64, 0x06, 0x0f, 0x0f, 0x12, 0x17, 0x26,
  0x33, 0x09, 0x09, 0x0b, 0x12, 0x17, 0x2b, 0x48, 0x06, 0x09, 0x0b, 0x0f, 0x17, 0x1e, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x1b,
  0x2b, 0x4f, 0x5e, 0x64, 0x06, 0x06, 0x06, 0x06, 0x0b, 0x0f, 0x1b, 0x00, 0x06, 0x06, 0x06, 0x06,
  0x00, 0x00, 0x0b, 0x0b, 0x0f, 0x12, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x5e, 0x33, 0x26, 0x17, 0x0f, 0x64, 0x5b,
  0x4c, 0x2f, 0x26, 0x1b, 0x0f, 0x64, 0x64, 0x64, 0x48, 0x33, 0x26, 0x22, 0x64, 0x64, 0x64, 0x38,
  0x2b, 0x22, 0x17, 0x64, 0x5e, 0x48, 0x2b, 0x1e, 0x12, 0x0f, 0x5e, 0x5e, 0x64, 0x33, 0x26, 0x17,
  0x12, 0x64, 0x48, 0x2b, 0x22, 0x17, 0x12, 0x0b, 0x64, 0x64, 0x64, 0x2f, 0x1e, 0x12, 0x0b, 0x4c,
  0x53, 0x5b, 0x2b, 0x1b, 0x12, 0x0b, 0x41, 0x3c, 0x41, 0x17, 0x0b, 0x09, 0x06, 0x41, 0x38, 0x3c,
  0x12, 0x0b, 0x06, 0x06, 0x53, 0x33, 0x26, 0x1b, 0x0f, 0x09, 0x06, 0x64, 0x57, 0x4f, 0x17, 0x0b,
  0x09, 0x06, 0x45, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x38, 0x1e, 0x0b, 0x09, 0x06, 0x06,
  0x45, 0x26, 0x12, 0x00, 0x00, 0x00, 0x00, 0x64, 0x57, 0x33, 0x1e, 0x17, 0x09, 0x06, 0x38, 0x0b,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x2f, 0x1b, 0x06,
  0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x1e, 0x17, 0x0f, 0x0b, 0x06, 0x06, 0x22,
  0x1e, 0x12, 0x09, 0x06, 0x06, 0x06, 0x2f, 0x3c, 0x38, 0x1e, 0x12, 0x0f, 0x09, 0x48, 0x33, 0x22,
  0x17, 0x0f, 0x0b, 0x09, 0x3c, 0x2f, 0x2f, 0x1b, 0x12, 0x0b, 0x09, 0x3c, 0x33, 0x1e, 0x12, 0x0f,
  0x09, 0x06, 0x33, 0x38, 0x38, 0x1e, 0x12, 0x0f, 0x09, 0x4c, 0x5b, 0x5b, 0x33, 0x2b, 0x22, 0x17,
  0x48, 0x4f, 0x4c, 0x2b, 0x1b, 0x17, 0x0b, 0x64, 0x57, 0x41, 0x2f, 0x1e, 0x17, 0x0b, 0x5e, 0x64,
  0x64, 0x4f, 0x41, 0x33, 0x2b, 0x5b, 0x57, 0x41, 0x2f, 0x1e, 0x17, 0x12, 0x0b, 0x1e, 0x33, 0x45,
  0x57, 0x64, 0x64, 0x0b, 0x1e, 0x33, 0x45, 0x5e, 0x64, 0x64, 0x0f, 0x1b, 0x22, 0x2f, 0x5b, 0x64,
  0x64, 0x0b, 0x17, 0x17, 0x26, 0x2f, 0x3c, 0x33, 0x06, 0x09, 0x0b, 0x0b, 0x0f, 0x0f, 0x09, 0x06,
  0x09, 0x0b, 0x09, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x09, 0x12, 0x17, 0x38, 0x3c, 0x06, 0x09,
  0x0b, 0x12, 0x22, 0x41, 0x48, 0x06, 0x06, 0x0b, 0x12, 0x26, 0x48, 0x4c, 0x12, 0x1e, 0x2b, 0x3c,
  0x4f, 0x64, 0x64, 0x17, 0x1b, 0x2f, 0x53, 0x5e, 0x64, 0x64, 0x12, 0x1e, 0x2b, 0x38, 0x4c, 0x64,
  0x64, 0x1e, 0x2b, 0x5b, 0x00, 0x00, 0x0b, 0x00, 0x64, 0x63, 0x5b, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x33, 0x00, 0x00, 0x00, 0x64, 0x61, 0x00, 0x00, 0x60, 0x00, 0x00, 0x62, 0x62, 0x61,
  0x60, 0x5f, 0x60, 0x60, 0x60, 0x60, 0x38, 0x25, 0x09, 0x00, 0x01, 0x01, 0x00, 0x00, 0x05, 0x19,
  0x60, 0x59, 0x62, 0x63, 0x64, 0x63, 0x62, 0x61, 0x45, 0x46, 0x45, 0x46, 0x48, 0x45, 0x45, 0x00,
  0x0b, 0x62, 0x58, 0x5c, 0x4e, 0x29, 0x08, 0x04, 0x63, 0x61, 0x60, 0x5c, 0x34, 0x03, 0x34, 0x5e,
  0x5e, 0x5c, 0x37, 0x15, 0x00, 0x48, 0x61, 0x5f, 0x60, 0x4d, 0x14, 0x00, 0x53, 0x51, 0x4e, 0x50,
  0x4f, 0x4b, 0x20
};

static const unsigned char palette_19_11_K[] =
{
  0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1e, 0x33, 0x00, 0x00,
  0x00, 0x00, 0x06, 0x1b, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x33, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x33, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1e,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x38, 0x00, 0x00, 0x00, 0x00, 0x09, 0x26, 0x41, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x0b, 0x26, 0x53, 0x00, 0x00, 0x00, 0x00, 0x09, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x06,
  0x1e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x26, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x2f, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x33, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x4c, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x17, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x38, 0x00, 0x00, 0x00, 0x00, 0x06, 0x12,
  0x1e, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x12, 0x26, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x1b, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x3c, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x2b, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x2f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x2f, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x1e, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0f, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x26, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x38, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x06, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x06, 0x0b,
  0x1e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x45,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x33, 0x4c, 0x00, 0x00, 0x00, 0x06, 0x12, 0x33, 0x41, 0x00, 0x00,
  0x00, 0x06, 0x22, 0x33, 0x45, 0x00, 0x00, 0x00, 0x12, 0x22, 0x2f, 0x45, 0x00, 0x00, 0x00, 0x06,
  0x12, 0x1e, 0x2b, 0x00, 0x00, 0x00, 0x06, 0x17, 0x1e, 0x2f, 0x00, 0x00, 0x00, 0x0f, 0x1e, 0x2f,
  0x3c, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2b, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x26, 0x48, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1e, 0x2f, 0x00, 0x00, 0x00,
  0x0f, 0x1e, 0x2b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x26, 0x3c, 0x00, 0x00, 0x00, 0x09, 0x1b,
  0x2f, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x17, 0x2b,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x1e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x2f, 0x00, 0x00, 0x00, 0x00,
  0x0b, 0x17, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x17, 0x2b, 0x41, 0x0f, 0x17, 0x22, 0x2b, 0x38, 0x4c,
  0x64, 0x12, 0x1b, 0x22, 0x2f, 0x38, 0x4f, 0x64, 0x12, 0x1e, 0x2b, 0x33, 0x45, 0x4f, 0x64, 0x0f,
  0x1b, 0x22, 0x2f, 0x41, 0x4f, 0x64, 0x0b, 0x17, 0x22, 0x2f, 0x41, 0x4f, 0x5e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x17, 0x22, 0x2f, 0x45, 0x4f, 0x53, 0x06, 0x0b, 0x12, 0x1b, 0x22,
  0x64, 0x64, 0x1e, 0x26, 0x2b, 0x2f, 0x38, 0x3c, 0x64, 0x06, 0x0b, 0x12, 0x1b, 0x22, 0x64, 0x64,
  0x26, 0x2f, 0x38, 0x41, 0x48, 0x4f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x2f,
  0x26, 0x17, 0x12, 0x0b, 0x06, 0x41, 0x2b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x53, 0x2f, 0x1e, 0x12, 0x0b, 0x06, 0x06, 0x3c, 0x22, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x48, 0x2f, 0x22, 0x1b, 0x0f, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
  0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x33, 0x26, 0x06, 0x00, 0x00, 0x00, 0x4c, 0x33, 0x2f,
  0x0b, 0x00, 0x00, 0x00, 0x4f, 0x2f, 0x22, 0x17, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x33, 0x26, 0x1b, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x45, 0x2f, 0x1e, 0x09, 0x06, 0x00, 0x00, 0x4c, 0x38, 0x2b, 0x26, 0x1b, 0x12,
  0x09, 0x53, 0x4c, 0x41, 0x1e, 0x17, 0x0f, 0x09, 0x4f, 0x38, 0x22, 0x17, 0x12, 0x06, 0x06, 0x5e,
  0x48, 0x38, 0x26, 0x1e, 0x12, 0x0b, 0x4c, 0x41, 0x38, 0x1b, 0x0f, 0x09, 0x06, 0x4f, 0x33, 0x26,
  0x1b, 0x12, 0x0b, 0x09, 0x4c, 0x2b, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x5b, 0x45, 0x33, 0x26, 0x1b,
  0x12, 0x0b, 0x41, 0x26, 0x12, 0x00, 0x00, 0x00, 0x00, 0x45, 0x33, 0x26, 0x0b, 0x06, 0x00, 0x00,
  0x53, 0x41, 0x38, 0x26, 0x1b, 0x12, 0x0f, 0x4f, 0x33, 0x26, 0x1b, 0x0b, 0x09, 0x09, 0x45, 0x2b,
  0x0f, 0x06, 0x00, 0x00, 0x00, 0x4f, 0x3c, 0x26, 0x1e, 0x12, 0x0f, 0x09, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x09, 0x00, 0x00, 0x06, 0x09, 0x0b, 0x12, 0x1e, 0x06, 0x06, 0x09, 0x12, 0x22, 0x2f,
  0x38, 0x00, 0x00, 0x09, 0x12, 0x22, 0x45, 0x57, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x1b, 0x2f, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x06, 0x06, 0x0b, 0x12, 0x17, 0x26, 0x2f, 0x00, 0x00, 0x06,
  0x09, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x00, 0x00, 0x00, 0x06, 0x0b,
  0x1e, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x2b,
  0x06, 0x06, 0x06, 0x0b, 0x12, 0x22, 0x45, 0x00, 0x00, 0x06, 0x09, 0x1b, 0x2b, 0x33, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x12, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x2b, 0x38, 0x06, 0x06, 0x0b, 0x12, 0x1e, 0x3c,
  0x4c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x57, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
  0x06, 0x00, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x46, 0x46, 0x44, 0x47, 0x43, 0x48, 0x27, 0x64,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01, 0x01,
  0x01, 0x00, 0x00
};

// PANTONE Match System Uncoated CDR10

static const unsigned char palette_19_12_C[] =
{
  0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x06, 0x06, 0x06, 0x06, 0x09, 0x12, 0x1b,
  0x1b, 0x09, 0x00, 0x0b, 0x12, 0x22, 0x2b, 0x33, 0x33, 0x06, 0x09, 0x0f, 0x1e, 0x26, 0x2b, 0x1e,
  0x06, 0x0f, 0x17, 0x2b, 0x2f, 0x33, 0x33, 0x09, 0x0f, 0x2b, 0x41, 0x3c, 0x33, 0x26, 0x17, 0x22,
  0x2f, 0x45, 0x48, 0x4f, 0x48, 0x1e, 0x2f, 0x3c, 0x4f, 0x4f, 0x4f, 0x4c, 0x26, 0x38, 0x48, 0x57,
  0x57, 0x57, 0x53, 0x0b, 0x1b, 0x38, 0x5e, 0x5e, 0x5b, 0x57, 0x1e, 0x2b, 0x38, 0x4f, 0x5e, 0x64,
  0x64, 0x1e, 0x2b, 0x3c, 0x64, 0x64, 0x64, 0x57, 0x2b, 0x3c, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x12,
  0x2f, 0x53, 0x5e, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x22, 0x48, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x45, 0x64, 0x64, 0x64, 0x64, 0x22, 0x38, 0x5b, 0x64, 0x64,
  0x64, 0x64, 0x1b, 0x2f, 0x48, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64,
  0x33, 0x4c, 0x57, 0x64, 0x64, 0x64, 0x64, 0x22, 0x48, 0x64, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x38,
  0x4c, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x41, 0x53, 0x64,
  0x64, 0x64, 0x64, 0x12, 0x26, 0x33, 0x64, 0x64, 0x64, 0x64, 0x1b, 0x3c, 0x5e, 0x64, 0x64, 0x64,
  0x64, 0x26, 0x33, 0x48, 0x64, 0x64, 0x64, 0x64, 0x22, 0x2f, 0x45, 0x5b, 0x64, 0x64, 0x64, 0x2b,
  0x3c, 0x57, 0x64, 0x64, 0x64, 0x64, 0x12, 0x17, 0x26, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x33, 0x5b,
  0x64, 0x64, 0x64, 0x64, 0x22, 0x2b, 0x38, 0x53, 0x64, 0x64, 0x64, 0x1b, 0x26, 0x3c, 0x64, 0x64,
  0x64, 0x4f, 0x0f, 0x17, 0x26, 0x5b, 0x64, 0x64, 0x4f, 0x1b, 0x26, 0x3c, 0x4c, 0x4c, 0x4c, 0x48,
  0x0b, 0x12, 0x1e, 0x41, 0x41, 0x3c, 0x2b, 0x09, 0x0f, 0x17, 0x2b, 0x38, 0x2b, 0x22, 0x09, 0x0b,
  0x12, 0x1e, 0x12, 0x0f, 0x00, 0x06, 0x0b, 0x0b, 0x12, 0x12, 0x0b, 0x06, 0x06, 0x06, 0x09, 0x0b,
  0x0b, 0x06, 0x00, 0x00, 0x06, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x0b, 0x17, 0x22, 0x06, 0x0b, 0x17,
  0x26, 0x48, 0x57, 0x5b, 0x06, 0x06, 0x09, 0x09, 0x0f, 0x0b, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x4f, 0x4c, 0x22, 0x17, 0x0f, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x06, 0x06, 0x06, 0x4f, 0x3c, 0x2f, 0x12,
  0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x48, 0x45, 0x1e, 0x0f, 0x09, 0x06, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x45, 0x3c, 0x0f, 0x06,
  0x00, 0x00, 0x53, 0x3c, 0x2f, 0x0f, 0x09, 0x00, 0x00, 0x57, 0x4c, 0x33, 0x1e, 0x12, 0x0b, 0x09,
  0x57, 0x4c, 0x45, 0x1b, 0x12, 0x09, 0x06, 0x64, 0x5e, 0x41, 0x2b, 0x1e, 0x0b, 0x09, 0x5e, 0x4f,
  0x4f, 0x2b, 0x1b, 0x12, 0x0b, 0x53, 0x4f, 0x48, 0x2f, 0x1e, 0x12, 0x06, 0x64, 0x64, 0x5b, 0x2b,
  0x1e, 0x17, 0x0f, 0x64, 0x64, 0x64, 0x4c, 0x38, 0x26, 0x1e, 0x4f, 0x48, 0x38, 0x22, 0x12, 0x0b,
  0x06, 0x5b, 0x5e, 0x64, 0x3c, 0x2b, 0x1e, 0x0f, 0x64, 0x53, 0x41, 0x2b, 0x1e, 0x12, 0x0b, 0x57,
  0x3c, 0x26, 0x12, 0x0b, 0x09, 0x06, 0x3c, 0x57, 0x53, 0x2b, 0x1b, 0x12, 0x0b, 0x57, 0x3c, 0x2b,
  0x1e, 0x12, 0x0b, 0x06, 0x45, 0x48, 0x4c, 0x2b, 0x22, 0x12, 0x0b, 0x48, 0x33, 0x1e, 0x12, 0x0b,
  0x06, 0x06, 0x45, 0x53, 0x5e, 0x2f, 0x1e, 0x17, 0x0b, 0x22, 0x33, 0x38, 0x17, 0x12, 0x12, 0x0b,
  0x22, 0x1b, 0x12, 0x09, 0x06, 0x06, 0x00, 0x22, 0x1b, 0x0f, 0x09, 0x06, 0x06, 0x00, 0x00, 0x0b,
  0x1b, 0x0b, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x1b, 0x22, 0x2f, 0x38, 0x4c, 0x53, 0x0f, 0x1e, 0x2b, 0x38, 0x4c, 0x5b, 0x64, 0x12,
  0x22, 0x2f, 0x48, 0x53, 0x64, 0x64, 0x12, 0x1b, 0x26, 0x38, 0x45, 0x5e, 0x64, 0x12, 0x1e, 0x2b,
  0x41, 0x64, 0x64, 0x64, 0x12, 0x1b, 0x2f, 0x45, 0x5b, 0x64, 0x64, 0x0b, 0x0f, 0x17, 0x22, 0x38,
  0x45, 0x4f, 0x00, 0x00, 0x00, 0x06, 0x09, 0x12, 0x09, 0x00, 0x06, 0x06, 0x0b, 0x17, 0x1b, 0x0b,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x12, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x45, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x2b, 0x5e, 0x64,
  0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x5b, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x1e, 0x51, 0x64, 0x63, 0x64, 0x63, 0x5f, 0x64,
  0x63, 0x64, 0x62, 0x59, 0x4e, 0x27, 0x14, 0x2f, 0x54, 0x53, 0x53, 0x51, 0x52, 0x54, 0x4c, 0x00,
  0x5b, 0x3a, 0x01, 0x00, 0x00, 0x02, 0x0a, 0x63, 0x4b, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x55, 0x09,
  0x00, 0x00, 0x00, 0x08, 0x4b, 0x60, 0x0a, 0x00, 0x00, 0x00, 0x07, 0x51, 0x2c, 0x2b, 0x28, 0x28,
  0x27, 0x24, 0x2a
};

static const unsigned char palette_19_12_M[] =
{
  0x00, 0x64, 0x00, 0x00, 0x33, 0x5b, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x0b, 0x0b, 0x0b, 0x06, 0x06, 0x09, 0x0f, 0x12, 0x12, 0x0b, 0x06, 0x09, 0x12, 0x1e,
  0x1b, 0x17, 0x17, 0x00, 0x06, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x06, 0x09, 0x0f, 0x1b, 0x1b, 0x17,
  0x12, 0x09, 0x12, 0x1b, 0x22, 0x26, 0x26, 0x1b, 0x0b, 0x12, 0x1e, 0x26, 0x2f, 0x2b, 0x26, 0x0b,
  0x17, 0x1e, 0x2f, 0x2f, 0x26, 0x1b, 0x0b, 0x12, 0x1e, 0x2b, 0x33, 0x2b, 0x2b, 0x17, 0x1e, 0x26,
  0x33, 0x41, 0x33, 0x33, 0x09, 0x12, 0x26, 0x3c, 0x41, 0x3c, 0x33, 0x12, 0x22, 0x2b, 0x38, 0x3c,
  0x38, 0x38, 0x0b, 0x1e, 0x2f, 0x3c, 0x41, 0x3c, 0x38, 0x1e, 0x26, 0x2f, 0x41, 0x45, 0x45, 0x45,
  0x12, 0x26, 0x33, 0x41, 0x45, 0x45, 0x3c, 0x17, 0x2f, 0x3c, 0x4f, 0x4f, 0x4c, 0x48, 0x2b, 0x33,
  0x45, 0x57, 0x5e, 0x5b, 0x5b, 0x1b, 0x3c, 0x4c, 0x5b, 0x5e, 0x5b, 0x48, 0x1b, 0x33, 0x48, 0x5b,
  0x5b, 0x5b, 0x4f, 0x26, 0x38, 0x4c, 0x5e, 0x5b, 0x5b, 0x4c, 0x1e, 0x2b, 0x48, 0x5e, 0x64, 0x64,
  0x57, 0x1b, 0x2f, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x22, 0x3c, 0x4c, 0x64, 0x64, 0x5b, 0x53, 0x2b,
  0x38, 0x48, 0x64, 0x64, 0x5e, 0x53, 0x1e, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64, 0x33, 0x45, 0x53,
  0x64, 0x64, 0x5e, 0x57, 0x22, 0x41, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x26, 0x41, 0x4c, 0x5e, 0x5e,
  0x5e, 0x5e, 0x1e, 0x3c, 0x53, 0x5e, 0x5e, 0x5e, 0x64, 0x1e, 0x26, 0x3c, 0x5b, 0x5e, 0x5e, 0x57,
  0x12, 0x2b, 0x38, 0x5b, 0x5b, 0x5e, 0x5b, 0x17, 0x26, 0x4c, 0x64, 0x64, 0x64, 0x5e, 0x22, 0x33,
  0x41, 0x5e, 0x64, 0x64, 0x5e, 0x2b, 0x41, 0x57, 0x64, 0x64, 0x64, 0x64, 0x2b, 0x3c, 0x4f, 0x64,
  0x64, 0x64, 0x64, 0x0f, 0x1e, 0x38, 0x5e, 0x5e, 0x5e, 0x5e, 0x1b, 0x26, 0x33, 0x4c, 0x5b, 0x5e,
  0x5e, 0x17, 0x22, 0x2f, 0x5e, 0x5e, 0x5e, 0x57, 0x22, 0x2f, 0x45, 0x5e, 0x5e, 0x5e, 0x5e, 0x0b,
  0x22, 0x3c, 0x53, 0x57, 0x57, 0x57, 0x0b, 0x17, 0x33, 0x4f, 0x4f, 0x4f, 0x4f, 0x09, 0x2b, 0x45,
  0x4f, 0x4c, 0x4c, 0x53, 0x09, 0x0f, 0x22, 0x48, 0x48, 0x48, 0x48, 0x06, 0x12, 0x2b, 0x3c, 0x45,
  0x41, 0x3c, 0x06, 0x0b, 0x1b, 0x38, 0x38, 0x38, 0x2f, 0x06, 0x09, 0x17, 0x2f, 0x26, 0x2b, 0x26,
  0x00, 0x09, 0x12, 0x2b, 0x2b, 0x12, 0x00, 0x00, 0x00, 0x09, 0x1e, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x09, 0x0b,
  0x0b, 0x06, 0x06, 0x0b, 0x0f, 0x12, 0x1b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x17,
  0x26, 0x45, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
  0x00, 0x00, 0x09, 0x06, 0x09, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x45, 0x41, 0x1b, 0x12, 0x0b, 0x06, 0x17, 0x12,
  0x0f, 0x09, 0x06, 0x00, 0x00, 0x12, 0x12, 0x12, 0x0b, 0x06, 0x06, 0x06, 0x48, 0x41, 0x41, 0x1e,
  0x17, 0x0f, 0x09, 0x38, 0x2f, 0x22, 0x17, 0x12, 0x0b, 0x06, 0x33, 0x38, 0x38, 0x22, 0x17, 0x0f,
  0x0b, 0x4f, 0x3c, 0x26, 0x1e, 0x17, 0x12, 0x0b, 0x53, 0x57, 0x57, 0x2b, 0x1b, 0x12, 0x0b, 0x4c,
  0x57, 0x64, 0x2f, 0x22, 0x1b, 0x0f, 0x41, 0x48, 0x4c, 0x33, 0x22, 0x17, 0x0f, 0x33, 0x33, 0x38,
  0x26, 0x1b, 0x12, 0x0b, 0x48, 0x3c, 0x2f, 0x26, 0x1b, 0x12, 0x0b, 0x5e, 0x5b, 0x5b, 0x33, 0x26,
  0x1e, 0x17, 0x64, 0x5b, 0x57, 0x33, 0x26, 0x1b, 0x12, 0x64, 0x57, 0x41, 0x2b, 0x1e, 0x17, 0x0f,
  0x5e, 0x5e, 0x5e, 0x33, 0x26, 0x17, 0x0f, 0x64, 0x5e, 0x41, 0x2b, 0x22, 0x12, 0x0b, 0x64, 0x5e,
  0x5e, 0x38, 0x2b, 0x1e, 0x12, 0x57, 0x48, 0x38, 0x22, 0x17, 0x0f, 0x06, 0x53, 0x4f, 0x48, 0x1e,
  0x12, 0x0f, 0x09, 0x33, 0x2f, 0x33, 0x17, 0x0f, 0x09, 0x06, 0x26, 0x0f, 0x0b, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x17, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0b, 0x12, 0x2b, 0x33, 0x06, 0x0b, 0x12,
  0x22, 0x3c, 0x45, 0x45, 0x06, 0x0b, 0x17, 0x26, 0x3c, 0x48, 0x4f, 0x09, 0x0b, 0x12, 0x1e, 0x2f,
  0x41, 0x4f, 0x0b, 0x12, 0x22, 0x2f, 0x41, 0x5b, 0x64, 0x0b, 0x12, 0x1b, 0x2b, 0x3c, 0x4c, 0x5e,
  0x0b, 0x1b, 0x1e, 0x2f, 0x38, 0x4f, 0x57, 0x0f, 0x17, 0x1e, 0x2b, 0x3c, 0x57, 0x53, 0x0f, 0x17,
  0x22, 0x38, 0x45, 0x53, 0x57, 0x0b, 0x0f, 0x1e, 0x2f, 0x45, 0x5b, 0x5b, 0x06, 0x0b, 0x12, 0x1b,
  0x26, 0x33, 0x38, 0x09, 0x0b, 0x12, 0x22, 0x26, 0x33, 0x33, 0x06, 0x0f, 0x12, 0x1b, 0x22, 0x33,
  0x33, 0x00, 0x00, 0x1b, 0x26, 0x26, 0x00, 0x00, 0x00, 0x16, 0x4f, 0x64, 0x64, 0x5b, 0x5b, 0x48,
  0x09, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x64, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2b, 0x3a,
  0x61, 0x63, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 0x64, 0x62, 0x64, 0x63, 0x29, 0x19, 0x01, 0x14,
  0x20, 0x01, 0x00, 0x01, 0x00, 0x01, 0x58, 0x50, 0x49, 0x47, 0x49, 0x46, 0x4d, 0x48, 0x44, 0x00,
  0x00, 0x00, 0x09, 0x41, 0x57, 0x5e, 0x60, 0x0c, 0x00, 0x17, 0x4f, 0x5e, 0x61, 0x63, 0x00, 0x03,
  0x20, 0x52, 0x5e, 0x5f, 0x3b, 0x00, 0x07, 0x2a, 0x5a, 0x61, 0x62, 0x48, 0x31, 0x34, 0x33, 0x38,
  0x3b, 0x3c, 0x20
};

static const unsigned char palette_19_12_Y[] =
{
  0x64, 0x00, 0x00, 0x00, 0x57, 0x57, 0x00, 0x33, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x48, 0x4f,
  0x64, 0x5e, 0x5e, 0x64, 0x64, 0x45, 0x48, 0x4f, 0x5e, 0x64, 0x64, 0x64, 0x38, 0x45, 0x53, 0x5e,
  0x64, 0x64, 0x64, 0x1b, 0x2b, 0x3c, 0x4c, 0x64, 0x64, 0x64, 0x33, 0x41, 0x4c, 0x64, 0x64, 0x64,
  0x64, 0x2b, 0x3c, 0x4f, 0x5b, 0x5e, 0x64, 0x64, 0x2f, 0x38, 0x4f, 0x4c, 0x64, 0x64, 0x64, 0x2f,
  0x4c, 0x53, 0x64, 0x64, 0x64, 0x64, 0x26, 0x33, 0x45, 0x57, 0x64, 0x64, 0x64, 0x38, 0x45, 0x4c,
  0x57, 0x64, 0x64, 0x64, 0x1b, 0x2b, 0x4c, 0x5e, 0x64, 0x64, 0x64, 0x22, 0x33, 0x48, 0x57, 0x64,
  0x64, 0x64, 0x12, 0x2f, 0x4c, 0x64, 0x64, 0x64, 0x64, 0x26, 0x2f, 0x3c, 0x57, 0x64, 0x64, 0x64,
  0x12, 0x2f, 0x45, 0x53, 0x64, 0x64, 0x57, 0x0f, 0x2b, 0x38, 0x5b, 0x5e, 0x53, 0x4f, 0x17, 0x1e,
  0x33, 0x5b, 0x64, 0x64, 0x64, 0x0b, 0x26, 0x3c, 0x57, 0x5e, 0x5e, 0x53, 0x09, 0x17, 0x2b, 0x4c,
  0x4c, 0x48, 0x41, 0x0b, 0x17, 0x26, 0x41, 0x41, 0x38, 0x38, 0x06, 0x06, 0x0f, 0x33, 0x3c, 0x38,
  0x2b, 0x06, 0x0b, 0x22, 0x41, 0x41, 0x41, 0x41, 0x00, 0x00, 0x06, 0x2b, 0x2b, 0x22, 0x22, 0x06,
  0x06, 0x06, 0x1e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x06, 0x06,
  0x06, 0x00, 0x00, 0x00, 0x12, 0x09, 0x0b, 0x0f, 0x06, 0x09, 0x0f, 0x1e, 0x0b, 0x12, 0x17, 0x0f,
  0x12, 0x1b, 0x1e, 0x09, 0x0f, 0x12, 0x1e, 0x1e, 0x26, 0x26, 0x0b, 0x1b, 0x2b, 0x2f, 0x2f, 0x2f,
  0x2f, 0x12, 0x1b, 0x26, 0x2f, 0x2f, 0x33, 0x38, 0x12, 0x1e, 0x2b, 0x33, 0x38, 0x38, 0x3c, 0x17,
  0x22, 0x33, 0x3c, 0x38, 0x3c, 0x3c, 0x0f, 0x12, 0x1b, 0x41, 0x41, 0x41, 0x41, 0x12, 0x1e, 0x3c,
  0x45, 0x45, 0x45, 0x45, 0x17, 0x1e, 0x2b, 0x41, 0x4c, 0x4c, 0x4f, 0x17, 0x22, 0x33, 0x4f, 0x4f,
  0x53, 0x57, 0x0f, 0x17, 0x22, 0x53, 0x5b, 0x5b, 0x57, 0x26, 0x33, 0x4f, 0x5b, 0x64, 0x64, 0x64,
  0x1e, 0x2f, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x22, 0x2f, 0x3c, 0x4f, 0x64, 0x64, 0x64, 0x3c, 0x48,
  0x5b, 0x5e, 0x64, 0x64, 0x57, 0x38, 0x4c, 0x4f, 0x53, 0x64, 0x64, 0x64, 0x33, 0x4c, 0x53, 0x5e,
  0x64, 0x64, 0x64, 0x45, 0x5b, 0x64, 0x64, 0x64, 0x64, 0x64, 0x06, 0x0f, 0x0f, 0x12, 0x17, 0x26,
  0x33, 0x09, 0x09, 0x0b, 0x12, 0x17, 0x2b, 0x48, 0x06, 0x09, 0x0b, 0x0f, 0x17, 0x1e, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x1b,
  0x2b, 0x4f, 0x5e, 0x64, 0x06, 0x06, 0x06, 0x06, 0x0b, 0x0f, 0x1b, 0x00, 0x06, 0x06, 0x06, 0x06,
  0x00, 0x00, 0x0b, 0x0b, 0x0f, 0x12, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x5e, 0x33, 0x26, 0x17, 0x0f, 0x64, 0x5b,
  0x4c, 0x2f, 0x26, 0x1b, 0x0f, 0x64, 0x64, 0x64, 0x48, 0x33, 0x26, 0x22, 0x64, 0x64, 0x64, 0x38,
  0x2b, 0x22, 0x17, 0x64, 0x5e, 0x48, 0x2b, 0x1e, 0x12, 0x0f, 0x5e, 0x5e, 0x64, 0x33, 0x26, 0x17,
  0x12, 0x64, 0x48, 0x2b, 0x22, 0x17, 0x12, 0x0b, 0x64, 0x64, 0x64, 0x2f, 0x1e, 0x12, 0x0b, 0x4c,
  0x53, 0x5b, 0x2b, 0x1b, 0x12, 0x0b, 0x41, 0x3c, 0x41, 0x17, 0x0b, 0x09, 0x06, 0x41, 0x38, 0x3c,
  0x12, 0x0b, 0x06, 0x06, 0x53, 0x33, 0x26, 0x1b, 0x0f, 0x09, 0x06, 0x64, 0x57, 0x4f, 0x17, 0x0b,
  0x09, 0x06, 0x45, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x38, 0x1e, 0x0b, 0x09, 0x06, 0x06,
  0x45, 0x26, 0x12, 0x00, 0x00, 0x00, 0x00, 0x64, 0x57, 0x33, 0x1e, 0x17, 0x09, 0x06, 0x38, 0x0b,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x2f, 0x1b, 0x06,
  0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x1e, 0x17, 0x0f, 0x0b, 0x06, 0x06, 0x22,
  0x1e, 0x12, 0x09, 0x06, 0x06, 0x06, 0x2f, 0x3c, 0x38, 0x1e, 0x12, 0x0f, 0x09, 0x48, 0x33, 0x22,
  0x17, 0x0f, 0x0b, 0x09, 0x3c, 0x2f, 0x2f, 0x1b, 0x12, 0x0b, 0x09, 0x3c, 0x33, 0x1e, 0x12, 0x0f,
  0x09, 0x06, 0x33, 0x38, 0x38, 0x1e, 0x12, 0x0f, 0x09, 0x4c, 0x5b, 0x5b, 0x33, 0x2b, 0x22, 0x17,
  0x48, 0x4f, 0x4c, 0x2b, 0x1b, 0x17, 0x0b, 0x64, 0x57, 0x41, 0x2f, 0x1e, 0x17, 0x0b, 0x5e, 0x64,
  0x64, 0x4f, 0x41, 0x33, 0x2b, 0x5b, 0x57, 0x41, 0x2f, 0x1e, 0x17, 0x12, 0x0b, 0x1e, 0x33, 0x45,
  0x57, 0x64, 0x64, 0x0b, 0x1e, 0x33, 0x45, 0x5e, 0x64, 0x64, 0x0f, 0x1b, 0x22, 0x2f, 0x5b, 0x64,
  0x64, 0x0b, 0x17, 0x17, 0x26, 0x2f, 0x3c, 0x33, 0x06, 0x09, 0x0b, 0x0b, 0x0f, 0x0f, 0x09, 0x06,
  0x09, 0x0b, 0x09, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x09, 0x12, 0x17, 0x38, 0x3c, 0x06, 0x09,
  0x0b, 0x12, 0x22, 0x41, 0x48, 0x06, 0x06, 0x0b, 0x12, 0x26, 0x48, 0x4c, 0x12, 0x1e, 0x2b, 0x3c,
  0x4f, 0x64, 0x64, 0x17, 0x1b, 0x2f, 0x53, 0x5e, 0x64, 0x64, 0x12, 0x1e, 0x2b, 0x38, 0x4c, 0x64,
  0x64, 0x1e, 0x2b, 0x5b, 0x00, 0x00, 0x0b, 0x00, 0x64, 0x63, 0x5b, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x33, 0x00, 0x00, 0x00, 0x64, 0x61, 0x00, 0x00, 0x60, 0x00, 0x00, 0x62, 0x62, 0x61,
  0x60, 0x5f, 0x60, 0x60, 0x60, 0x60, 0x38, 0x25, 0x09, 0x00, 0x01, 0x01, 0x00, 0x00, 0x05, 0x19,
  0x60, 0x59, 0x62, 0x63, 0x64, 0x63, 0x62, 0x61, 0x45, 0x46, 0x45, 0x46, 0x48, 0x45, 0x45, 0x00,
  0x0b, 0x62, 0x58, 0x5c, 0x4e, 0x29, 0x08, 0x04, 0x63, 0x61, 0x60, 0x5c, 0x34, 0x03, 0x34, 0x5e,
  0x5e, 0x5c, 0x37, 0x15, 0x00, 0x48, 0x61, 0x5f, 0x60, 0x4d, 0x14, 0x00, 0x53, 0x51, 0x4e, 0x50,
  0x4f, 0x4b, 0x20
};

static const unsigned char palette_19_12_K[] =
{
  0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1e, 0x33, 0x00, 0x00,
  0x00, 0x00, 0x06, 0x1b, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x33, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x33, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1e,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x38, 0x00, 0x00, 0x00, 0x00, 0x09, 0x26, 0x41, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x0b, 0x26, 0x53, 0x00, 0x00, 0x00, 0x00, 0x09, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x06,
  0x1e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x26, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x2f, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x33, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x4c, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x17, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x38, 0x00, 0x00, 0x00, 0x00, 0x06, 0x12,
  0x1e, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x12, 0x26, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x1b, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x3c, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x2b, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x2f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x2f, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x1e, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0f, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x26, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x38, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x06, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x06, 0x0b,
  0x1e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x45, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x22, 0x45,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x33, 0x4c, 0x00, 0x00, 0x00, 0x06, 0x12, 0x33, 0x41, 0x00, 0x00,
  0x00, 0x06, 0x22, 0x33, 0x45, 0x00, 0x00, 0x00, 0x12, 0x22, 0x2f, 0x45, 0x00, 0x00, 0x00, 0x06,
  0x12, 0x1e, 0x2b, 0x00, 0x00, 0x00, 0x06, 0x17, 0x1e, 0x2f, 0x00, 0x00, 0x00, 0x0f, 0x1e, 0x2f,
  0x3c, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2b, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x26, 0x48, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1e, 0x2f, 0x00, 0x00, 0x00,
  0x0f, 0x1e, 0x2b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x26, 0x3c, 0x00, 0x00, 0x00, 0x09, 0x1b,
  0x2f, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x17, 0x2b,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x1e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x2f, 0x00, 0x00, 0x00, 0x00,
  0x0b, 0x17, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x17, 0x2b, 0x41, 0x0f, 0x17, 0x22, 0x2b, 0x38, 0x4c,
  0x64, 0x12, 0x1b, 0x22, 0x2f, 0x38, 0x4f, 0x64, 0x12, 0x1e, 0x2b, 0x33, 0x45, 0x4f, 0x64, 0x0f,
  0x1b, 0x22, 0x2f, 0x41, 0x4f, 0x64, 0x0b, 0x17, 0x22, 0x2f, 0x41, 0x4f, 0x5e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x17, 0x22, 0x2f, 0x45, 0x4f, 0x53, 0x06, 0x0b, 0x12, 0x1b, 0x22,
  0x64, 0x64, 0x1e, 0x26, 0x2b, 0x2f, 0x38, 0x3c, 0x64, 0x06, 0x0b, 0x12, 0x1b, 0x22, 0x64, 0x64,
  0x26, 0x2f, 0x38, 0x41, 0x48, 0x4f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x2f,
  0x26, 0x17, 0x12, 0x0b, 0x06, 0x41, 0x2b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x53, 0x2f, 0x1e, 0x12, 0x0b, 0x06, 0x06, 0x3c, 0x22, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x48, 0x2f, 0x22, 0x1b, 0x0f, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
  0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x33, 0x26, 0x06, 0x00, 0x00, 0x00, 0x4c, 0x33, 0x2f,
  0x0b, 0x00, 0x00, 0x00, 0x4f, 0x2f, 0x22, 0x17, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x33, 0x26, 0x1b, 0x0b, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x45, 0x2f, 0x1e, 0x09, 0x06, 0x00, 0x00, 0x4c, 0x38, 0x2b, 0x26, 0x1b, 0x12,
  0x09, 0x53, 0x4c, 0x41, 0x1e, 0x17, 0x0f, 0x09, 0x4f, 0x38, 0x22, 0x17, 0x12, 0x06, 0x06, 0x5e,
  0x48, 0x38, 0x26, 0x1e, 0x12, 0x0b, 0x4c, 0x41, 0x38, 0x1b, 0x0f, 0x09, 0x06, 0x4f, 0x33, 0x26,
  0x1b, 0x12, 0x0b, 0x09, 0x4c, 0x2b, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x5b, 0x45, 0x33, 0x26, 0x1b,
  0x12, 0x0b, 0x41, 0x26, 0x12, 0x00, 0x00, 0x00, 0x00, 0x45, 0x33, 0x26, 0x0b, 0x06, 0x00, 0x00,
  0x53, 0x41, 0x38, 0x26, 0x1b, 0x12, 0x0f, 0x4f, 0x33, 0x26, 0x1b, 0x0b, 0x09, 0x09, 0x45, 0x2b,
  0x0f, 0x06, 0x00, 0x00, 0x00, 0x4f, 0x3c, 0x26, 0x1e, 0x12, 0x0f, 0x09, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x09, 0x00, 0x00, 0x06, 0x09, 0x0b, 0x12, 0x1e, 0x06, 0x06, 0x09, 0x12, 0x22, 0x2f,
  0x38, 0x00, 0x00, 0x09, 0x12, 0x22, 0x45, 0x57, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x1b, 0x2f, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x1b, 0x06, 0x06, 0x0b, 0x12, 0x17, 0x26, 0x2f, 0x00, 0x00, 0x06,
  0x09, 0x12, 0x26, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0b, 0x00, 0x00, 0x00, 0x06, 0x0b,
  0x1e, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x2b,
  0x06, 0x06, 0x06, 0x0b, 0x12, 0x22, 0x45, 0x00, 0x00, 0x06, 0x09, 0x1b, 0x2b, 0x33, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x12, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x2b, 0x38, 0x06, 0x06, 0x0b, 0x12, 0x1e, 0x3c,
  0x4c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x57, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
  0x06, 0x00, 0x64, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x46, 0x46, 0x44, 0x47, 0x43, 0x48, 0x27, 0x64,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01, 0x01,
  0x01, 0x00, 0x00
};

// PANTONE Metal Colours Unwarm CDR10

static const unsigned char palette_19_14_C[] =
{
  0x2c, 0x29, 0x29, 0x28, 0x26, 0x28, 0x2f, 0x2e, 0x30, 0x2c, 0x2b, 0x29, 0x2a, 0x28, 0x1c, 0x1d,
  0x27, 0x2a, 0x26, 0x25, 0x2b, 0x29, 0x25, 0x1e, 0x2d, 0x2c, 0x2b, 0x2d, 0x30, 0x34, 0x33, 0x36,
  0x2f, 0x31, 0x38, 0x37, 0x36, 0x3b, 0x41, 0x4d, 0x33, 0x39, 0x46, 0x4e, 0x36, 0x47, 0x4c, 0x54,
  0x3d, 0x45, 0x4d, 0x51, 0x3c, 0x45, 0x4c, 0x53, 0x36, 0x41, 0x48, 0x51, 0x3a, 0x44, 0x49, 0x4f,
  0x35, 0x3c, 0x43, 0x4a, 0x36, 0x3a, 0x41, 0x46, 0x2f, 0x38, 0x3b, 0x3c, 0x2f, 0x2d, 0x2c, 0x2c,
  0x31, 0x2a, 0x26, 0x22, 0x2e, 0x29, 0x21, 0x21, 0x33, 0x38, 0x3c, 0x40, 0x2e, 0x34, 0x38, 0x3c,
  0x25, 0x27, 0x27, 0x20, 0x31, 0x36, 0x3a, 0x3c, 0x49, 0x4b, 0x51, 0x57, 0x3d, 0x44, 0x49, 0x57,
  0x36, 0x49, 0x52, 0x56, 0x30, 0x42, 0x50, 0x4c, 0x36, 0x39, 0x3e, 0x42, 0x23, 0x2e, 0x36, 0x45,
  0x44, 0x4a, 0x51, 0x59, 0x37, 0x42, 0x4c, 0x54, 0x1d, 0x18, 0x15, 0x12, 0x27, 0x25, 0x2a, 0x28,
  0x30, 0x31, 0x35, 0x38, 0x37, 0x3a, 0x3e, 0x43, 0x44, 0x41, 0x4a, 0x4e, 0x4a, 0x4d, 0x4f, 0x51,
  0x51, 0x57, 0x54, 0x55, 0x55, 0x55, 0x59, 0x57, 0x52, 0x53, 0x57, 0x55, 0x35, 0x3a, 0x47, 0x55,
  0x2e, 0x2f, 0x33, 0x38, 0x25, 0x27, 0x24, 0x20, 0x25, 0x23, 0x21, 0x1f, 0x1f, 0x1a, 0x1b, 0x12,
  0x20, 0x19, 0x10, 0x17, 0x20, 0x1e, 0x15, 0x0d, 0x1d, 0x1d, 0x0f, 0x0e
};

static const unsigned char palette_19_14_M[] =
{
  0x28, 0x2f, 0x2f, 0x33, 0x36, 0x38, 0x26, 0x27, 0x28, 0x2b, 0x2f, 0x2f, 0x2d, 0x32, 0x37, 0x3d,
  0x2b, 0x2d, 0x35, 0x38, 0x2c, 0x35, 0x3c, 0x45, 0x2e, 0x3e, 0x46, 0x47, 0x33, 0x39, 0x40, 0x47,
  0x2a, 0x33, 0x37, 0x42, 0x2e, 0x34, 0x3c, 0x40, 0x2d, 0x30, 0x3c, 0x40, 0x2c, 0x30, 0x36, 0x3b,
  0x21, 0x24, 0x2a, 0x2f, 0x21, 0x26, 0x29, 0x28, 0x22, 0x24, 0x24, 0x24, 0x1b, 0x1d, 0x26, 0x24,
  0x1d, 0x1e, 0x1d, 0x1d, 0x1e, 0x1d, 0x1f, 0x1d, 0x22, 0x1e, 0x1b, 0x16, 0x20, 0x21, 0x1b, 0x18,
  0x21, 0x23, 0x1e, 0x1a, 0x22, 0x24, 0x24, 0x23, 0x2a, 0x2d, 0x32, 0x3b, 0x2b, 0x2f, 0x33, 0x36,
  0x2d, 0x34, 0x39, 0x3f, 0x2c, 0x30, 0x38, 0x3a, 0x3a, 0x43, 0x40, 0x4c, 0x28, 0x2c, 0x38, 0x54,
  0x2e, 0x47, 0x4a, 0x54, 0x40, 0x47, 0x52, 0x51, 0x3b, 0x42, 0x47, 0x47, 0x33, 0x37, 0x3c, 0x4c,
  0x3a, 0x46, 0x4e, 0x57, 0x39, 0x45, 0x4b, 0x52, 0x2a, 0x25, 0x1d, 0x1a, 0x29, 0x24, 0x23, 0x1d,
  0x2b, 0x24, 0x21, 0x1b, 0x2a, 0x25, 0x23, 0x1d, 0x29, 0x28, 0x24, 0x1d, 0x33, 0x30, 0x33, 0x2f,
  0x3c, 0x43, 0x42, 0x41, 0x52, 0x50, 0x54, 0x4f, 0x50, 0x4e, 0x51, 0x52, 0x43, 0x4a, 0x4d, 0x54,
  0x45, 0x49, 0x49, 0x4a, 0x45, 0x49, 0x4c, 0x51, 0x41, 0x45, 0x4b, 0x4c, 0x42, 0x46, 0x47, 0x4d,
  0x3f, 0x45, 0x47, 0x48, 0x3b, 0x3e, 0x3e, 0x3e, 0x2e, 0x37, 0x2c, 0x37
};

static const unsigned char palette_19_14_Y[] =
{
  0x52, 0x4d, 0x4d, 0x4a, 0x4b, 0x45, 0x24, 0x29, 0x2f, 0x35, 0x3a, 0x42, 0x2f, 0x34, 0x47, 0x48,
  0x27, 0x2c, 0x2e, 0x34, 0x23, 0x22, 0x23, 0x20, 0x1e, 0x18, 0x17, 0x19, 0x1b, 0x1c, 0x19, 0x1b,
  0x1d, 0x1a, 0x1a, 0x14, 0x1b, 0x1a, 0x17, 0x0f, 0x1f, 0x1c, 0x16, 0x11, 0x1f, 0x1a, 0x15, 0x10,
  0x1d, 0x18, 0x1a, 0x14, 0x1f, 0x1e, 0x19, 0x18, 0x21, 0x20, 0x1f, 0x20, 0x20, 0x23, 0x23, 0x24,
  0x23, 0x27, 0x2a, 0x2d, 0x2c, 0x32, 0x35, 0x3f, 0x2c, 0x3b, 0x45, 0x4b, 0x39, 0x42, 0x49, 0x4d,
  0x3a, 0x41, 0x4a, 0x54, 0x30, 0x37, 0x41, 0x4a, 0x2a, 0x2c, 0x35, 0x3f, 0x28, 0x28, 0x2f, 0x37,
  0x26, 0x28, 0x2b, 0x2d, 0x23, 0x27, 0x26, 0x28, 0x2a, 0x33, 0x35, 0x3b, 0x2d, 0x39, 0x33, 0x4f,
  0x44, 0x53, 0x56, 0x53, 0x3b, 0x4e, 0x58, 0x4d, 0x4a, 0x47, 0x4b, 0x4e, 0x55, 0x4e, 0x55, 0x57,
  0x3b, 0x49, 0x4f, 0x53, 0x49, 0x50, 0x53, 0x5a, 0x55, 0x5b, 0x5b, 0x5f, 0x55, 0x5d, 0x5b, 0x5d,
  0x54, 0x5a, 0x5b, 0x5d, 0x49, 0x54, 0x54, 0x57, 0x41, 0x45, 0x3d, 0x43, 0x3f, 0x3f, 0x40, 0x39,
  0x40, 0x44, 0x3d, 0x32, 0x42, 0x3b, 0x3b, 0x36, 0x3c, 0x3c, 0x38, 0x2f, 0x37, 0x31, 0x3d, 0x3e,
  0x3a, 0x33, 0x36, 0x2c, 0x40, 0x37, 0x35, 0x35, 0x3b, 0x3e, 0x39, 0x41, 0x4a, 0x4f, 0x45, 0x4e,
  0x48, 0x5b, 0x5f, 0x5b, 0x55, 0x5d, 0x5f, 0x5e, 0x58, 0x5b, 0x5b, 0x5e
};

static const unsigned char palette_19_14_K[] =
{
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x05, 0x05, 0x04, 0x04,
  0x04, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06,
  0x04, 0x04, 0x05, 0x04, 0x04, 0x05, 0x04, 0x03, 0x05, 0x05, 0x04, 0x03, 0x05, 0x04, 0x03, 0x02,
  0x03, 0x02, 0x03, 0x02, 0x03, 0x04, 0x02, 0x02, 0x02, 0x04, 0x03, 0x03, 0x02, 0x03, 0x05, 0x04,
  0x02, 0x03, 0x03, 0x04, 0x03, 0x03, 0x04, 0x05, 0x03, 0x04, 0x04, 0x03, 0x04, 0x05, 0x04, 0x03,
  0x04, 0x05, 0x04, 0x03, 0x04, 0x05, 0x05, 0x05, 0x05, 0x07, 0x08, 0x11, 0x05, 0x06, 0x08, 0x09,
  0x04, 0x04, 0x05, 0x04, 0x05, 0x07, 0x07, 0x08, 0x08, 0x14, 0x12, 0x1a, 0x05, 0x07, 0x10, 0x31,
  0x08, 0x22, 0x29, 0x31, 0x08, 0x1b, 0x2d, 0x26, 0x0d, 0x10, 0x17, 0x1b, 0x06, 0x09, 0x11, 0x22,
  0x10, 0x1f, 0x2a, 0x35, 0x0d, 0x1b, 0x26, 0x31, 0x04, 0x03, 0x02, 0x02, 0x07, 0x06, 0x06, 0x04,
  0x08, 0x07, 0x06, 0x05, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x06, 0x05, 0x0f, 0x0f, 0x12, 0x11,
  0x1a, 0x21, 0x1a, 0x0f, 0x25, 0x1e, 0x1e, 0x17, 0x21, 0x1f, 0x1a, 0x16, 0x09, 0x0c, 0x1b, 0x24,
  0x08, 0x07, 0x08, 0x08, 0x06, 0x06, 0x06, 0x05, 0x06, 0x06, 0x05, 0x05, 0x05, 0x04, 0x04, 0x02,
  0x05, 0x04, 0x02, 0x04, 0x06, 0x05, 0x03, 0x01, 0x05, 0x05, 0x02, 0x01
};

// PANTONE Pastel Colours Coated CDR10

static const unsigned char palette_19_15_C[] =
{
  0x05, 0x03, 0x08, 0x14, 0x2c, 0x1f, 0x1b, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x06, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x07, 0x08, 0x09, 0x0b, 0x07, 0x09, 0x09, 0x0d, 0x05, 0x05, 0x08, 0x0a, 0x05,
  0x05, 0x07, 0x09, 0x05, 0x07, 0x08, 0x09, 0x05, 0x04, 0x06, 0x07, 0x05, 0x05, 0x06, 0x09, 0x05,
  0x06, 0x08, 0x09, 0x05, 0x05, 0x07, 0x09, 0x04, 0x06, 0x07, 0x0a, 0x05, 0x05, 0x06, 0x07, 0x04,
  0x06, 0x07, 0x08, 0x05, 0x07, 0x07, 0x09, 0x07, 0x08, 0x09, 0x0a, 0x09, 0x0a, 0x0d, 0x0f, 0x0a,
  0x0d, 0x0f, 0x0f, 0x0c, 0x0e, 0x12, 0x10, 0x10, 0x11, 0x11, 0x13, 0x0f, 0x12, 0x14, 0x16, 0x0e,
  0x14, 0x18, 0x18, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x16, 0x15, 0x16, 0x0a, 0x0b, 0x0b, 0x0f, 0x09,
  0x0b, 0x0b, 0x0f, 0x08, 0x0b, 0x0c, 0x0c, 0x07, 0x09, 0x0a, 0x0d, 0x07, 0x00, 0x0a, 0x0d
};

static const unsigned char palette_19_15_M[] =
{
  0x05, 0x1d, 0x1b, 0x1d, 0x03, 0x00, 0x19, 0x05, 0x06, 0x07, 0x07, 0x05, 0x05, 0x06, 0x06, 0x04,
  0x05, 0x05, 0x05, 0x07, 0x08, 0x0a, 0x0b, 0x06, 0x07, 0x09, 0x09, 0x05, 0x05, 0x08, 0x0a, 0x05,
  0x05, 0x07, 0x08, 0x06, 0x08, 0x09, 0x0a, 0x07, 0x08, 0x08, 0x09, 0x08, 0x08, 0x0a, 0x0c, 0x08,
  0x09, 0x0c, 0x0c, 0x07, 0x09, 0x0d, 0x0e, 0x0b, 0x0d, 0x0e, 0x10, 0x07, 0x09, 0x09, 0x0a, 0x0a,
  0x0c, 0x0d, 0x0d, 0x0a, 0x0c, 0x0d, 0x0e, 0x09, 0x09, 0x0c, 0x0e, 0x0b, 0x0c, 0x0f, 0x0f, 0x08,
  0x09, 0x0a, 0x0c, 0x07, 0x08, 0x0a, 0x09, 0x07, 0x07, 0x09, 0x0b, 0x07, 0x05, 0x05, 0x09, 0x05,
  0x05, 0x07, 0x08, 0x05, 0x05, 0x06, 0x07, 0x04, 0x05, 0x07, 0x09, 0x04, 0x05, 0x07, 0x08, 0x05,
  0x04, 0x07, 0x08, 0x05, 0x05, 0x07, 0x09, 0x05, 0x06, 0x09, 0x09, 0x05, 0x00, 0x09, 0x0a
};

static const unsigned char palette_19_15_Y[] =
{
  0x1b, 0x0b, 0x02, 0x00, 0x07, 0x12, 0x1f, 0x0d, 0x06, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x06,
  0x06, 0x05, 0x05, 0x09, 0x0b, 0x0b, 0x0f, 0x0a, 0x0b, 0x0b, 0x0e, 0x0f, 0x15, 0x18, 0x17, 0x0c,
  0x0e, 0x10, 0x12, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0b, 0x0d, 0x0e, 0x0d, 0x0e, 0x0f, 0x16, 0x0b,
  0x0c, 0x12, 0x12, 0x09, 0x0b, 0x0d, 0x12, 0x0b, 0x0d, 0x0f, 0x12, 0x07, 0x08, 0x09, 0x0a, 0x06,
  0x07, 0x09, 0x0c, 0x06, 0x08, 0x09, 0x0b, 0x06, 0x07, 0x08, 0x08, 0x05, 0x07, 0x07, 0x09, 0x06,
  0x08, 0x07, 0x08, 0x07, 0x07, 0x08, 0x09, 0x08, 0x0a, 0x0a, 0x0b, 0x08, 0x09, 0x0a, 0x0b, 0x09,
  0x0b, 0x0d, 0x0d, 0x0a, 0x0a, 0x0b, 0x0e, 0x0c, 0x0f, 0x0f, 0x12, 0x08, 0x09, 0x0b, 0x0d, 0x09,
  0x0c, 0x0d, 0x10, 0x0b, 0x0e, 0x0f, 0x11, 0x0b, 0x0e, 0x10, 0x15, 0x0e, 0x00, 0x16, 0x18
};

static const unsigned char palette_19_15_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00
};

// PANTONE Pastel Colours Uncoated CDR10

static const unsigned char palette_19_16_C[] =
{
  0x05, 0x03, 0x08, 0x14, 0x2c, 0x1f, 0x1b, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x06, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x07, 0x08, 0x09, 0x0b, 0x07, 0x09, 0x09, 0x0d, 0x05, 0x05, 0x08, 0x0a, 0x05,
  0x05, 0x07, 0x09, 0x05, 0x07, 0x08, 0x09, 0x05, 0x04, 0x06, 0x07, 0x05, 0x05, 0x06, 0x09, 0x05,
  0x06, 0x08, 0x09, 0x05, 0x05, 0x07, 0x09, 0x04, 0x06, 0x07, 0x0a, 0x05, 0x05, 0x06, 0x07, 0x04,
  0x06, 0x07, 0x08, 0x05, 0x07, 0x07, 0x09, 0x07, 0x08, 0x09, 0x0a, 0x09, 0x0a, 0x0d, 0x0f, 0x0a,
  0x0d, 0x0f, 0x0f, 0x0c, 0x0e, 0x12, 0x10, 0x10, 0x11, 0x11, 0x13, 0x0f, 0x12, 0x14, 0x16, 0x0e,
  0x14, 0x18, 0x18, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x16, 0x15, 0x16, 0x0a, 0x0b, 0x0b, 0x0f, 0x09,
  0x0b, 0x0b, 0x0f, 0x08, 0x0b, 0x0c, 0x0c, 0x07, 0x09, 0x0a, 0x0d, 0x07, 0x00, 0x0a, 0x0d
};

static const unsigned char palette_19_16_M[] =
{
  0x05, 0x1d, 0x1b, 0x1d, 0x03, 0x00, 0x19, 0x05, 0x06, 0x07, 0x07, 0x05, 0x05, 0x06, 0x06, 0x04,
  0x05, 0x05, 0x05, 0x07, 0x08, 0x0a, 0x0b, 0x06, 0x07, 0x09, 0x09, 0x05, 0x05, 0x08, 0x0a, 0x05,
  0x05, 0x07, 0x08, 0x06, 0x08, 0x09, 0x0a, 0x07, 0x08, 0x08, 0x09, 0x08, 0x08, 0x0a, 0x0c, 0x08,
  0x09, 0x0c, 0x0c, 0x07, 0x09, 0x0d, 0x0e, 0x0b, 0x0d, 0x0e, 0x10, 0x07, 0x09, 0x09, 0x0a, 0x0a,
  0x0c, 0x0d, 0x0d, 0x0a, 0x0c, 0x0d, 0x0e, 0x09, 0x09, 0x0c, 0x0e, 0x0b, 0x0c, 0x0f, 0x0f, 0x08,
  0x09, 0x0a, 0x0c, 0x07, 0x08, 0x0a, 0x09, 0x07, 0x07, 0x09, 0x0b, 0x07, 0x05, 0x05, 0x09, 0x05,
  0x05, 0x07, 0x08, 0x05, 0x05, 0x06, 0x07, 0x04, 0x05, 0x07, 0x09, 0x04, 0x05, 0x07, 0x08, 0x05,
  0x04, 0x07, 0x08, 0x05, 0x05, 0x07, 0x09, 0x05, 0x06, 0x09, 0x09, 0x05, 0x00, 0x09, 0x0a
};

static const unsigned char palette_19_16_Y[] =
{
  0x1b, 0x0b, 0x02, 0x00, 0x07, 0x12, 0x1f, 0x0d, 0x06, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x06,
  0x06, 0x05, 0x05, 0x09, 0x0b, 0x0b, 0x0f, 0x0a, 0x0b, 0x0b, 0x0e, 0x0f, 0x15, 0x18, 0x17, 0x0c,
  0x0e, 0x10, 0x12, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0b, 0x0d, 0x0e, 0x0d, 0x0e, 0x0f, 0x16, 0x0b,
  0x0c, 0x12, 0x12, 0x09, 0x0b, 0x0d, 0x12, 0x0b, 0x0d, 0x0f, 0x12, 0x07, 0x08, 0x09, 0x0a, 0x06,
  0x07, 0x09, 0x0c, 0x06, 0x08, 0x09, 0x0b, 0x06, 0x07, 0x08, 0x08, 0x05, 0x07, 0x07, 0x09, 0x06,
  0x08, 0x07, 0x08, 0x07, 0x07, 0x08, 0x09, 0x08, 0x0a, 0x0a, 0x0b, 0x08, 0x09, 0x0a, 0x0b, 0x09,
  0x0b, 0x0d, 0x0d, 0x0a, 0x0a, 0x0b, 0x0e, 0x0c, 0x0f, 0x0f, 0x12, 0x08, 0x09, 0x0b, 0x0d, 0x09,
  0x0c, 0x0d, 0x10, 0x0b, 0x0e, 0x0f, 0x11, 0x0b, 0x0e, 0x10, 0x15, 0x0e, 0x00, 0x16, 0x18
};

static const unsigned char palette_19_16_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00
};

// HKS

static const unsigned char palette_19_17_C[] =
{
  0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x02, 0x02, 0x03, 0x02, 0x04, 0x03, 0x04, 0x04, 0x05, 0x05,
  0x07, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x05, 0x06, 0x07, 0x08, 0x09, 0x08,
  0x09, 0x0b, 0x09, 0x09, 0x0c, 0x09, 0x0a, 0x0a, 0x08, 0x0a, 0x0a, 0x0b, 0x0c, 0x08, 0x09, 0x0b,
  0x0b, 0x0c, 0x0a, 0x0b, 0x0b, 0x0a, 0x0b, 0x09, 0x0a, 0x09, 0x09, 0x0a, 0x0a, 0x09, 0x08, 0x04,
  0x05, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x09, 0x07, 0x05, 0x06, 0x08, 0x08, 0x0a, 0x06, 0x09,
  0x06, 0x08, 0x09, 0x07, 0x07, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x03, 0x02, 0x01, 0x01, 0x02, 0x02,
  0x03, 0x02, 0x04, 0x05, 0x07, 0x06, 0x0a, 0x03, 0x02, 0x03, 0x05, 0x05, 0x06, 0x05, 0x06, 0x09,
  0x06, 0x06, 0x09, 0x0b, 0x0d, 0x0c, 0x0c, 0x10, 0x0e, 0x0d, 0x10, 0x0e, 0x0f, 0x0f, 0x0b, 0x0f,
  0x0f, 0x11, 0x11, 0x0c, 0x0e, 0x10, 0x0f, 0x11, 0x0f, 0x10, 0x0f, 0x0f, 0x11, 0x0e, 0x0e, 0x0c,
  0x0e, 0x0e, 0x0d, 0x0c, 0x0b, 0x06, 0x06, 0x04, 0x05, 0x07, 0x09, 0x0a, 0x0c, 0x0c, 0x0a, 0x06,
  0x08, 0x0a, 0x0c, 0x0e, 0x08, 0x0d, 0x09, 0x0b, 0x0d, 0x09, 0x09, 0x0e, 0x04, 0x05, 0x03, 0x04,
  0x03, 0x02, 0x00, 0x01, 0x02, 0x02, 0x03, 0x02, 0x04, 0x06, 0x08, 0x08, 0x0d, 0x02, 0x01, 0x03,
  0x05, 0x05, 0x06, 0x05, 0x07, 0x0b, 0x06, 0x06, 0x0c, 0x0e, 0x10, 0x0f, 0x0f, 0x14, 0x11, 0x11,
  0x13, 0x12, 0x14, 0x12, 0x0e, 0x12, 0x13, 0x14, 0x16, 0x0f, 0x12, 0x14, 0x13, 0x15, 0x14, 0x14,
  0x13, 0x13, 0x15, 0x10, 0x11, 0x0f, 0x11, 0x11, 0x10, 0x0e, 0x0d, 0x07, 0x06, 0x04, 0x06, 0x09,
  0x0c, 0x0c, 0x0f, 0x0f, 0x0d, 0x07, 0x09, 0x0d, 0x0e, 0x11, 0x0a, 0x0f, 0x0b, 0x0e, 0x11, 0x0b,
  0x0b, 0x10, 0x04, 0x05, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x01, 0x01, 0x02, 0x01, 0x03, 0x06,
  0x0a, 0x09, 0x0f, 0x01, 0x00, 0x03, 0x06, 0x06, 0x08, 0x07, 0x09, 0x0d, 0x08, 0x08, 0x0e, 0x10,
  0x13, 0x11, 0x12, 0x17, 0x15, 0x15, 0x17, 0x16, 0x18, 0x16, 0x12, 0x15, 0x16, 0x19, 0x1a, 0x12,
  0x15, 0x18, 0x16, 0x19, 0x18, 0x17, 0x17, 0x16, 0x19, 0x13, 0x14, 0x11, 0x13, 0x15, 0x12, 0x11,
  0x0e, 0x07, 0x07, 0x05, 0x06, 0x0a, 0x0e, 0x0f, 0x15, 0x11, 0x0f, 0x08, 0x0a, 0x0f, 0x11, 0x14,
  0x0b, 0x13, 0x0e, 0x10, 0x15, 0x0d, 0x0d, 0x14, 0x04, 0x05, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x02, 0x00, 0x03, 0x06, 0x0b, 0x0a, 0x11, 0x01, 0x01, 0x02, 0x06, 0x05, 0x09, 0x08,
  0x09, 0x0f, 0x09, 0x08, 0x11, 0x13, 0x16, 0x14, 0x15, 0x1b, 0x19, 0x18, 0x1a, 0x19, 0x1a, 0x1a,
  0x14, 0x17, 0x1a, 0x1c, 0x1e, 0x14, 0x18, 0x1b, 0x19, 0x1c, 0x1c, 0x1a, 0x1a, 0x19, 0x1c, 0x15,
  0x17, 0x13, 0x16, 0x17, 0x14, 0x12, 0x10, 0x08, 0x08, 0x05, 0x06, 0x0b, 0x0f, 0x11, 0x17, 0x14,
  0x11, 0x08, 0x0b, 0x11, 0x13, 0x18, 0x0c, 0x15, 0x0f, 0x13, 0x18, 0x0f, 0x10, 0x17, 0x04, 0x04,
  0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x06, 0x0c, 0x0b, 0x13, 0x00,
  0x00, 0x02, 0x06, 0x06, 0x0a, 0x0a, 0x0a, 0x11, 0x0b, 0x09, 0x14, 0x17, 0x1b, 0x18, 0x19, 0x1f,
  0x1c, 0x1c, 0x1e, 0x1d, 0x1f, 0x1e, 0x18, 0x1a, 0x1f, 0x20, 0x21, 0x17, 0x1c, 0x1f, 0x1c, 0x21,
  0x1f, 0x1e, 0x20, 0x1d, 0x20, 0x19, 0x1c, 0x16, 0x19, 0x1b, 0x17, 0x15, 0x12, 0x08, 0x08, 0x05,
  0x06, 0x0c, 0x11, 0x13, 0x1a, 0x17, 0x13, 0x08, 0x0c, 0x15, 0x18, 0x1c, 0x0e, 0x19, 0x12, 0x16,
  0x1c, 0x10, 0x12, 0x1a, 0x04, 0x04, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x06, 0x0d, 0x0c, 0x15, 0x00, 0x00, 0x01, 0x07, 0x05, 0x0c, 0x0b, 0x0b, 0x13, 0x0c, 0x0a,
  0x16, 0x1a, 0x1f, 0x1c, 0x1b, 0x22, 0x1e, 0x1f, 0x21, 0x20, 0x22, 0x21, 0x1a, 0x1d, 0x22, 0x22,
  0x24, 0x19, 0x1f, 0x22, 0x1e, 0x23, 0x23, 0x21, 0x22, 0x20, 0x23, 0x1c, 0x1f, 0x18, 0x1c, 0x1e,
  0x19, 0x17, 0x13, 0x08, 0x08, 0x05, 0x07, 0x0d, 0x12, 0x15, 0x1b, 0x19, 0x15, 0x08, 0x0e, 0x16,
  0x19, 0x1e, 0x0f, 0x1c, 0x13, 0x18, 0x1e, 0x13, 0x15, 0x1d, 0x04, 0x04, 0x02, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0d, 0x0d, 0x16, 0x00, 0x00, 0x01, 0x07, 0x05,
  0x0c, 0x0c, 0x0c, 0x15, 0x0d, 0x0a, 0x19, 0x1e, 0x22, 0x20, 0x1f, 0x25, 0x22, 0x22, 0x24, 0x24,
  0x24, 0x24, 0x1d, 0x20, 0x25, 0x26, 0x26, 0x1c, 0x22, 0x25, 0x21, 0x26, 0x26, 0x24, 0x25, 0x21,
  0x26, 0x1f, 0x21, 0x1a, 0x1f, 0x20, 0x1c, 0x18, 0x16, 0x0a, 0x09, 0x06, 0x07, 0x0e, 0x14, 0x17,
  0x1b, 0x19, 0x15, 0x09, 0x0f, 0x16, 0x19, 0x20, 0x10, 0x1e, 0x15, 0x1b, 0x20, 0x15, 0x17, 0x20,
  0x03, 0x04, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x0d, 0x0e,
  0x15, 0x00, 0x00, 0x01, 0x08, 0x06, 0x0c, 0x0d, 0x0e, 0x19, 0x0e, 0x0c, 0x1c, 0x20, 0x24, 0x22,
  0x22, 0x26, 0x24, 0x25, 0x26, 0x26, 0x26, 0x27, 0x20, 0x22, 0x27, 0x27, 0x27, 0x1e, 0x25, 0x27,
  0x22, 0x27, 0x27, 0x27, 0x26, 0x22, 0x27, 0x21, 0x22, 0x1b, 0x20, 0x22, 0x1e, 0x19, 0x18, 0x0a,
  0x09, 0x06, 0x07, 0x0f, 0x15, 0x18, 0x1b, 0x18, 0x14, 0x09, 0x0e, 0x15, 0x18, 0x20, 0x12, 0x1e,
  0x16, 0x1d, 0x21, 0x17, 0x1a, 0x20, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x1e, 0x1e, 0x37, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x14, 0x05, 0x14, 0x2d,
  0x14, 0x0a, 0x32, 0x46, 0x5a, 0x50, 0x50, 0x64, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x55,
  0x64, 0x64, 0x64, 0x46, 0x64, 0x64, 0x50, 0x64, 0x64, 0x64, 0x64, 0x3c, 0x64, 0x50, 0x46, 0x0a,
  0x3c, 0x50, 0x41, 0x3c, 0x37, 0x0f, 0x0f, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x32, 0x0a,
  0x00, 0x05, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x19, 0x00, 0x00, 0x0f, 0x0a, 0x0a, 0x09, 0x0a,
  0x09, 0x0a, 0x09, 0x0a, 0x09, 0x09, 0x0a, 0x09, 0x0a, 0x0b, 0x0b, 0x0b, 0x0c, 0x09, 0x09, 0x0a,
  0x0a, 0x0a, 0x0b, 0x0a, 0x0c, 0x0c, 0x0a, 0x0b, 0x0b, 0x0e, 0x0d, 0x0d, 0x0c, 0x0f, 0x0e, 0x0e,
  0x0f, 0x0f, 0x10, 0x0f, 0x0d, 0x0e, 0x0f, 0x10, 0x10, 0x0d, 0x0e, 0x10, 0x0f, 0x10, 0x0f, 0x10,
  0x10, 0x0e, 0x0f, 0x0e, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0d, 0x0c, 0x0a, 0x0a, 0x0a, 0x0b, 0x0b,
  0x0c, 0x0d, 0x0d, 0x0d, 0x0c, 0x0a, 0x0b, 0x0c, 0x0d, 0x0a, 0x0b, 0x0e, 0x0b, 0x0d, 0x0e, 0x0d,
  0x0b, 0x0f, 0x0a, 0x0a, 0x09, 0x0a, 0x09, 0x09, 0x08, 0x08, 0x08, 0x09, 0x0a, 0x08, 0x0a, 0x0b,
  0x0c, 0x0c, 0x0e, 0x09, 0x08, 0x0a, 0x0b, 0x0a, 0x0c, 0x0a, 0x0d, 0x0e, 0x0a, 0x0c, 0x0d, 0x10,
  0x11, 0x10, 0x10, 0x13, 0x12, 0x11, 0x13, 0x12, 0x13, 0x13, 0x10, 0x12, 0x13, 0x14, 0x15, 0x10,
  0x13, 0x14, 0x13, 0x15, 0x14, 0x13, 0x14, 0x12, 0x14, 0x11, 0x12, 0x11, 0x11, 0x12, 0x11, 0x10,
  0x0e, 0x0b, 0x0b, 0x0a, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x10, 0x0f, 0x0b, 0x0d, 0x0e, 0x10, 0x0e,
  0x0d, 0x12, 0x0d, 0x10, 0x12, 0x0e, 0x0e, 0x12, 0x0a, 0x0a, 0x0a, 0x0a, 0x09, 0x09, 0x07, 0x08,
  0x08, 0x08, 0x0a, 0x08, 0x0a, 0x0c, 0x0e, 0x0d, 0x10, 0x08, 0x08, 0x09, 0x0b, 0x0b, 0x0c, 0x09,
  0x0e, 0x0f, 0x0a, 0x0c, 0x0f, 0x12, 0x13, 0x12, 0x12, 0x16, 0x15, 0x14, 0x16, 0x14, 0x17, 0x15,
  0x12, 0x14, 0x16, 0x17, 0x18, 0x12, 0x16, 0x17, 0x17, 0x18, 0x18, 0x16, 0x17, 0x14, 0x17, 0x13,
  0x15, 0x13, 0x13, 0x15, 0x13, 0x12, 0x11, 0x0c, 0x0b, 0x0b, 0x0c, 0x0d, 0x10, 0x10, 0x12, 0x12,
  0x11, 0x0c, 0x0d, 0x10, 0x12, 0x10, 0x0e, 0x14, 0x0e, 0x12, 0x14, 0x10, 0x0f, 0x14, 0x0a, 0x0a,
  0x09, 0x0a, 0x08, 0x08, 0x06, 0x08, 0x06, 0x08, 0x09, 0x06, 0x0a, 0x0c, 0x0e, 0x0e, 0x12, 0x08,
  0x06, 0x0a, 0x0b, 0x0b, 0x0c, 0x09, 0x0f, 0x10, 0x0b, 0x0c, 0x11, 0x14, 0x16, 0x15, 0x15, 0x19,
  0x18, 0x17, 0x19, 0x18, 0x1a, 0x19, 0x15, 0x18, 0x19, 0x1a, 0x1c, 0x15, 0x19, 0x1a, 0x1a, 0x1c,
  0x1b, 0x19, 0x1a, 0x17, 0x1b, 0x15, 0x18, 0x14, 0x16, 0x18, 0x15, 0x13, 0x12, 0x0c, 0x0b, 0x0b,
  0x0c, 0x0e, 0x11, 0x12, 0x16, 0x14, 0x13, 0x0c, 0x0e, 0x13, 0x15, 0x15, 0x0f, 0x17, 0x10, 0x14,
  0x17, 0x11, 0x12, 0x17, 0x0a, 0x09, 0x09, 0x0a, 0x08, 0x07, 0x05, 0x07, 0x06, 0x08, 0x09, 0x06,
  0x0a, 0x0c, 0x0f, 0x0f, 0x14, 0x08, 0x06, 0x09, 0x0c, 0x0b, 0x0d, 0x0a, 0x0f, 0x12, 0x0c, 0x0d,
  0x13, 0x16, 0x18, 0x18, 0x17, 0x1c, 0x1a, 0x19, 0x1b, 0x1a, 0x1d, 0x1b, 0x17, 0x1a, 0x1d, 0x1d,
  0x1f, 0x18, 0x1b, 0x1c, 0x1c, 0x1e, 0x1e, 0x1c, 0x1d, 0x1a, 0x1d, 0x17, 0x1a, 0x16, 0x18, 0x1a,
  0x18, 0x15, 0x14, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x12, 0x14, 0x19, 0x16, 0x14, 0x0d, 0x0f, 0x14,
  0x17, 0x18, 0x10, 0x19, 0x11, 0x16, 0x1a, 0x12, 0x13, 0x19, 0x0a, 0x09, 0x08, 0x09, 0x06, 0x06,
  0x03, 0x04, 0x04, 0x06, 0x07, 0x04, 0x0a, 0x0c, 0x10, 0x10, 0x16, 0x07, 0x04, 0x09, 0x0c, 0x0b,
  0x0e, 0x0b, 0x10, 0x14, 0x0c, 0x0d, 0x15, 0x19, 0x1c, 0x1b, 0x1a, 0x20, 0x1e, 0x1d, 0x1f, 0x1f,
  0x21, 0x20, 0x1b, 0x1d, 0x21, 0x21, 0x22, 0x1b, 0x1e, 0x20, 0x1e, 0x22, 0x21, 0x20, 0x21, 0x1d,
  0x21, 0x1a, 0x1e, 0x19, 0x1b, 0x1d, 0x1a, 0x16, 0x15, 0x0d, 0x0c, 0x0c, 0x0c, 0x10, 0x15, 0x16,
  0x1c, 0x19, 0x16, 0x0d, 0x10, 0x17, 0x1a, 0x1c, 0x12, 0x1c, 0x13, 0x19, 0x1d, 0x14, 0x16, 0x1c,
  0x0a, 0x0a, 0x08, 0x08, 0x06, 0x04, 0x02, 0x04, 0x04, 0x07, 0x06, 0x03, 0x09, 0x0d, 0x11, 0x11,
  0x17, 0x07, 0x04, 0x08, 0x0c, 0x0b, 0x0e, 0x0c, 0x10, 0x15, 0x0d, 0x0e, 0x18, 0x1c, 0x20, 0x1e,
  0x1d, 0x23, 0x21, 0x20, 0x22, 0x21, 0x23, 0x22, 0x1d, 0x20, 0x23, 0x23, 0x24, 0x1c, 0x20, 0x23,
  0x21, 0x24, 0x23, 0x23, 0x23, 0x20, 0x24, 0x1d, 0x20, 0x1b, 0x1e, 0x1f, 0x1d, 0x18, 0x17, 0x0d,
  0x0d, 0x0b, 0x0c, 0x11, 0x16, 0x18, 0x1c, 0x1a, 0x18, 0x0e, 0x11, 0x18, 0x1a, 0x1e, 0x13, 0x1e,
  0x14, 0x1b, 0x1f, 0x16, 0x17, 0x1e, 0x0a, 0x09, 0x08, 0x07, 0x05, 0x03, 0x01, 0x03, 0x02, 0x05,
  0x05, 0x02, 0x08, 0x0c, 0x10, 0x11, 0x17, 0x06, 0x02, 0x08, 0x0c, 0x0b, 0x0f, 0x0d, 0x11, 0x18,
  0x0e, 0x0f, 0x1b, 0x1f, 0x23, 0x21, 0x20, 0x25, 0x24, 0x23, 0x24, 0x25, 0x25, 0x25, 0x20, 0x23,
  0x26, 0x27, 0x27, 0x1f, 0x24, 0x26, 0x23, 0x26, 0x26, 0x26, 0x25, 0x22, 0x27, 0x20, 0x22, 0x1b,
  0x20, 0x21, 0x1f, 0x1a, 0x19, 0x0e, 0x0d, 0x0b, 0x0c, 0x12, 0x16, 0x19, 0x1c, 0x1a, 0x16, 0x0d,
  0x11, 0x17, 0x19, 0x20, 0x14, 0x1f, 0x16, 0x1d, 0x21, 0x18, 0x1a, 0x20, 0x09, 0x09, 0x06, 0x06,
  0x04, 0x02, 0x01, 0x01, 0x01, 0x05, 0x03, 0x02, 0x07, 0x0a, 0x0e, 0x11, 0x14, 0x06, 0x02, 0x08,
  0x0d, 0x0d, 0x11, 0x0e, 0x12, 0x1a, 0x10, 0x11, 0x1d, 0x21, 0x25, 0x23, 0x23, 0x26, 0x26, 0x25,
  0x26, 0x27, 0x27, 0x27, 0x22, 0x24, 0x27, 0x27, 0x27, 0x22, 0x25, 0x27, 0x25, 0x27, 0x27, 0x27,
  0x27, 0x23, 0x27, 0x21, 0x22, 0x1c, 0x21, 0x23, 0x20, 0x1b, 0x1a, 0x0e, 0x0d, 0x0b, 0x0c, 0x12,
  0x16, 0x19, 0x1c, 0x18, 0x15, 0x0d, 0x10, 0x15, 0x18, 0x20, 0x16, 0x1e, 0x18, 0x1f, 0x21, 0x19,
  0x1c, 0x21, 0x09, 0x09, 0x05, 0x05, 0x03, 0x02, 0x01, 0x01, 0x01, 0x04, 0x03, 0x02, 0x06, 0x0a,
  0x0d, 0x10, 0x12, 0x06, 0x02, 0x08, 0x0e, 0x0e, 0x13, 0x0d, 0x12, 0x1b, 0x11, 0x12, 0x1e, 0x22,
  0x25, 0x24, 0x24, 0x26, 0x27, 0x27, 0x26, 0x27, 0x27, 0x27, 0x24, 0x26, 0x27, 0x27, 0x27, 0x23,
  0x27, 0x27, 0x25, 0x27, 0x27, 0x27, 0x27, 0x23, 0x27, 0x22, 0x23, 0x1c, 0x22, 0x24, 0x21, 0x1c,
  0x1b, 0x0f, 0x0e, 0x0c, 0x0c, 0x12, 0x16, 0x19, 0x1c, 0x18, 0x14, 0x0c, 0x0e, 0x14, 0x17, 0x20,
  0x17, 0x1e, 0x1a, 0x1f, 0x22, 0x1a, 0x1e, 0x21, 0x12, 0x12, 0x12, 0x13, 0x12, 0x14, 0x13, 0x13,
  0x13, 0x12, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x15, 0x13, 0x12, 0x13, 0x14, 0x13, 0x14, 0x14,
  0x16, 0x15, 0x14, 0x14, 0x14, 0x16, 0x15, 0x15, 0x15, 0x15, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17,
  0x15, 0x16, 0x17, 0x17, 0x18, 0x15, 0x16, 0x17, 0x16, 0x17, 0x16, 0x16, 0x17, 0x16, 0x16, 0x15,
  0x16, 0x16, 0x16, 0x15, 0x15, 0x15, 0x13, 0x13, 0x12, 0x14, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x12, 0x14, 0x15, 0x0a, 0x14, 0x16, 0x13, 0x14, 0x16, 0x15, 0x14, 0x17, 0x12, 0x12,
  0x11, 0x13, 0x12, 0x13, 0x12, 0x13, 0x12, 0x11, 0x14, 0x12, 0x14, 0x15, 0x15, 0x15, 0x16, 0x13,
  0x12, 0x13, 0x14, 0x13, 0x14, 0x13, 0x16, 0x16, 0x14, 0x14, 0x15, 0x17, 0x17, 0x17, 0x17, 0x18,
  0x18, 0x18, 0x19, 0x19, 0x1a, 0x19, 0x18, 0x18, 0x1a, 0x1a, 0x1b, 0x17, 0x19, 0x19, 0x19, 0x1a,
  0x1a, 0x19, 0x1a, 0x18, 0x19, 0x17, 0x18, 0x17, 0x17, 0x18, 0x17, 0x16, 0x15, 0x13, 0x13, 0x14,
  0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x15, 0x14, 0x13, 0x16, 0x17, 0x0d, 0x15, 0x18, 0x14, 0x16,
  0x18, 0x16, 0x16, 0x18, 0x12, 0x12, 0x11, 0x13, 0x11, 0x13, 0x12, 0x13, 0x11, 0x11, 0x14, 0x12,
  0x14, 0x15, 0x16, 0x16, 0x17, 0x12, 0x11, 0x13, 0x14, 0x13, 0x15, 0x13, 0x17, 0x17, 0x14, 0x14,
  0x16, 0x18, 0x19, 0x18, 0x19, 0x1a, 0x1a, 0x1a, 0x1b, 0x1b, 0x1c, 0x1b, 0x19, 0x1a, 0x1c, 0x1c,
  0x1d, 0x19, 0x1b, 0x1c, 0x1b, 0x1c, 0x1c, 0x1b, 0x1c, 0x19, 0x1c, 0x18, 0x1a, 0x19, 0x19, 0x1a,
  0x18, 0x17, 0x16, 0x13, 0x12, 0x14, 0x15, 0x15, 0x17, 0x17, 0x18, 0x18, 0x17, 0x13, 0x14, 0x17,
  0x18, 0x11, 0x16, 0x1a, 0x15, 0x18, 0x1a, 0x17, 0x17, 0x1a, 0x11, 0x11, 0x10, 0x13, 0x10, 0x12,
  0x12, 0x12, 0x10, 0x12, 0x13, 0x11, 0x14, 0x16, 0x17, 0x16, 0x19, 0x12, 0x10, 0x13, 0x14, 0x14,
  0x15, 0x13, 0x17, 0x18, 0x14, 0x15, 0x17, 0x1a, 0x1b, 0x1a, 0x1b, 0x1d, 0x1d, 0x1c, 0x1d, 0x1d,
  0x1e, 0x1e, 0x1b, 0x1c, 0x1e, 0x1e, 0x1f, 0x1b, 0x1d, 0x1e, 0x1d, 0x1e, 0x1e, 0x1c, 0x1e, 0x1b,
  0x1e, 0x1a, 0x1c, 0x1a, 0x1a, 0x1b, 0x1a, 0x19, 0x17, 0x14, 0x13, 0x15, 0x16, 0x16, 0x18, 0x18,
  0x1a, 0x19, 0x18, 0x14, 0x15, 0x18, 0x1a, 0x14, 0x17, 0x1b, 0x16, 0x19, 0x1c, 0x18, 0x17, 0x1c,
  0x12, 0x11, 0x10, 0x12, 0x10, 0x11, 0x10, 0x12, 0x0f, 0x11, 0x12, 0x10, 0x14, 0x16, 0x17, 0x16,
  0x1a, 0x12, 0x10, 0x13, 0x15, 0x14, 0x16, 0x13, 0x18, 0x19, 0x14, 0x15, 0x18, 0x1b, 0x1d, 0x1c,
  0x1c, 0x1f, 0x1f, 0x1e, 0x1f, 0x1f, 0x20, 0x20, 0x1d, 0x1e, 0x20, 0x20, 0x21, 0x1c, 0x1f, 0x1f,
  0x1f, 0x21, 0x21, 0x1f, 0x20, 0x1d, 0x20, 0x1b, 0x1d, 0x1b, 0x1c, 0x1d, 0x1b, 0x1a, 0x18, 0x14,
  0x14, 0x14, 0x16, 0x16, 0x18, 0x19, 0x1c, 0x1a, 0x19, 0x14, 0x15, 0x1a, 0x1c, 0x18, 0x17, 0x1d,
  0x17, 0x1a, 0x1e, 0x19, 0x19, 0x1d, 0x11, 0x11, 0x10, 0x12, 0x10, 0x10, 0x0f, 0x10, 0x0e, 0x11,
  0x12, 0x0e, 0x13, 0x15, 0x17, 0x17, 0x1a, 0x12, 0x0f, 0x13, 0x14, 0x14, 0x16, 0x13, 0x18, 0x1a,
  0x15, 0x15, 0x19, 0x1e, 0x20, 0x1f, 0x1f, 0x22, 0x22, 0x20, 0x21, 0x22, 0x24, 0x23, 0x1f, 0x20,
  0x23, 0x23, 0x24, 0x1e, 0x21, 0x22, 0x22, 0x24, 0x23, 0x22, 0x23, 0x20, 0x23, 0x1e, 0x20, 0x1c,
  0x1e, 0x1f, 0x1d, 0x1b, 0x1a, 0x15, 0x13, 0x14, 0x15, 0x17, 0x1a, 0x1a, 0x1d, 0x1c, 0x1a, 0x14,
  0x16, 0x1a, 0x1c, 0x1c, 0x18, 0x1e, 0x18, 0x1d, 0x20, 0x1a, 0x1a, 0x1f, 0x11, 0x11, 0x10, 0x11,
  0x0f, 0x0f, 0x0d, 0x0f, 0x0d, 0x10, 0x10, 0x0d, 0x12, 0x14, 0x16, 0x17, 0x1a, 0x12, 0x0e, 0x12,
  0x14, 0x15, 0x16, 0x14, 0x18, 0x1c, 0x16, 0x16, 0x1b, 0x1f, 0x22, 0x21, 0x20, 0x23, 0x23, 0x22,
  0x23, 0x24, 0x25, 0x24, 0x20, 0x22, 0x25, 0x25, 0x26, 0x20, 0x23, 0x24, 0x24, 0x25, 0x24, 0x24,
  0x24, 0x21, 0x25, 0x1f, 0x21, 0x1d, 0x20, 0x21, 0x1f, 0x1c, 0x1b, 0x14, 0x14, 0x14, 0x15, 0x17,
  0x1a, 0x1b, 0x1d, 0x1c, 0x1a, 0x13, 0x16, 0x1a, 0x1b, 0x1e, 0x19, 0x1f, 0x1a, 0x1e, 0x20, 0x1c,
  0x1c, 0x20, 0x11, 0x11, 0x0f, 0x10, 0x0e, 0x0d, 0x0b, 0x0d, 0x0b, 0x10, 0x0d, 0x0a, 0x0f, 0x12,
  0x13, 0x15, 0x18, 0x12, 0x0d, 0x11, 0x14, 0x15, 0x17, 0x14, 0x17, 0x1d, 0x16, 0x16, 0x1d, 0x21,
  0x24, 0x23, 0x22, 0x25, 0x26, 0x24, 0x24, 0x26, 0x27, 0x26, 0x22, 0x24, 0x27, 0x27, 0x27, 0x22,
  0x25, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x22, 0x27, 0x21, 0x22, 0x1d, 0x21, 0x23, 0x21, 0x1d,
  0x1d, 0x15, 0x14, 0x14, 0x13, 0x16, 0x19, 0x1b, 0x1c, 0x1a, 0x17, 0x12, 0x14, 0x18, 0x1a, 0x20,
  0x1a, 0x1f, 0x1c, 0x1f, 0x21, 0x1c, 0x1d, 0x20, 0x12, 0x11, 0x0f, 0x10, 0x0e, 0x0c, 0x0b, 0x0a,
  0x09, 0x10, 0x0a, 0x0a, 0x0c, 0x0e, 0x10, 0x12, 0x14, 0x13, 0x0b, 0x0f, 0x14, 0x14, 0x17, 0x16,
  0x15, 0x1e, 0x18, 0x16, 0x1f, 0x22, 0x25, 0x24, 0x22, 0x25, 0x27, 0x27, 0x25, 0x27, 0x27, 0x27,
  0x24, 0x26, 0x27, 0x27, 0x27, 0x24, 0x26, 0x27, 0x27, 0x27, 0x27, 0x27, 0x26, 0x23, 0x27, 0x22,
  0x22, 0x1d, 0x21, 0x24, 0x21, 0x1e, 0x1e, 0x15, 0x15, 0x14, 0x12, 0x16, 0x18, 0x1b, 0x1d, 0x19,
  0x16, 0x11, 0x12, 0x17, 0x19, 0x20, 0x1b, 0x1f, 0x1e, 0x20, 0x22, 0x1d, 0x1e, 0x20, 0x12, 0x12,
  0x0f, 0x0f, 0x0e, 0x0c, 0x0b, 0x0a, 0x08, 0x10, 0x09, 0x09, 0x0b, 0x0d, 0x10, 0x10, 0x15, 0x14,
  0x0a, 0x0e, 0x12, 0x14, 0x17, 0x17, 0x13, 0x1d, 0x18, 0x15, 0x1f, 0x23, 0x25, 0x24, 0x22, 0x25,
  0x27, 0x27, 0x25, 0x27, 0x27, 0x27, 0x26, 0x26, 0x27, 0x27, 0x27, 0x25, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x26, 0x27, 0x23, 0x27, 0x23, 0x23, 0x1d, 0x22, 0x24, 0x22, 0x1e, 0x1e, 0x16, 0x15, 0x14,
  0x12, 0x15, 0x17, 0x1a, 0x1d, 0x1a, 0x15, 0x0f, 0x10, 0x16, 0x19, 0x20, 0x1c, 0x1f, 0x1f, 0x20,
  0x22, 0x1e, 0x1f, 0x21, 0x19, 0x19, 0x18, 0x1a, 0x1a, 0x1b, 0x1c, 0x1c, 0x1a, 0x19, 0x1c, 0x1c,
  0x1c, 0x1d, 0x1c, 0x1c, 0x1d, 0x1c, 0x1a, 0x1c, 0x1b, 0x1a, 0x1c, 0x1b, 0x1d, 0x1d, 0x1b, 0x1b,
  0x1c, 0x1c, 0x1b, 0x1c, 0x1c, 0x1b, 0x1d, 0x1e, 0x1c, 0x1d, 0x1e, 0x1e, 0x1d, 0x1d, 0x1e, 0x1e,
  0x1e, 0x1c, 0x1d, 0x1d, 0x1e, 0x1d, 0x1d, 0x1c, 0x1d, 0x1c, 0x1d, 0x1b, 0x1c, 0x1c, 0x1c, 0x1c,
  0x1b, 0x1c, 0x19, 0x1b, 0x1a, 0x1c, 0x1d, 0x1b, 0x1c, 0x1b, 0x1b, 0x1c, 0x1a, 0x1b, 0x1a, 0x1b,
  0x1c, 0x0a, 0x1b, 0x1c, 0x1a, 0x1a, 0x1d, 0x1c, 0x1c, 0x1c, 0x19, 0x19, 0x18, 0x1b, 0x19, 0x1b,
  0x1b, 0x1b, 0x1a, 0x19, 0x1c, 0x1a, 0x1c, 0x1d, 0x1d, 0x1c, 0x1d, 0x1b, 0x19, 0x1c, 0x1b, 0x1a,
  0x1c, 0x1b, 0x1e, 0x1d, 0x1c, 0x1b, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1e, 0x1e, 0x1e, 0x1e,
  0x1f, 0x1f, 0x1e, 0x1e, 0x1f, 0x1f, 0x20, 0x1d, 0x1f, 0x1e, 0x1f, 0x1f, 0x1f, 0x1e, 0x1e, 0x1e,
  0x1f, 0x1c, 0x1d, 0x1d, 0x1d, 0x1e, 0x1c, 0x1d, 0x1a, 0x1b, 0x1a, 0x1c, 0x1c, 0x1b, 0x1c, 0x1c,
  0x1c, 0x1d, 0x1b, 0x1a, 0x1a, 0x1c, 0x1d, 0x0e, 0x1c, 0x1d, 0x1b, 0x1c, 0x1e, 0x1c, 0x1c, 0x1e,
  0x19, 0x19, 0x18, 0x1b, 0x19, 0x1b, 0x1a, 0x1b, 0x19, 0x19, 0x1b, 0x1a, 0x1b, 0x1c, 0x1d, 0x1d,
  0x1d, 0x1b, 0x19, 0x1b, 0x1b, 0x1b, 0x1d, 0x1c, 0x1e, 0x1d, 0x1c, 0x1c, 0x1e, 0x1e, 0x1e, 0x1e,
  0x1f, 0x1f, 0x20, 0x1f, 0x20, 0x20, 0x21, 0x21, 0x1f, 0x1f, 0x21, 0x21, 0x21, 0x1f, 0x20, 0x20,
  0x20, 0x21, 0x20, 0x1f, 0x20, 0x1f, 0x21, 0x1d, 0x1e, 0x1d, 0x1e, 0x1f, 0x1d, 0x1e, 0x1c, 0x1b,
  0x1a, 0x1c, 0x1d, 0x1c, 0x1d, 0x1c, 0x1d, 0x1d, 0x1c, 0x1a, 0x1a, 0x1d, 0x1e, 0x11, 0x1d, 0x1e,
  0x1c, 0x1d, 0x1f, 0x1d, 0x1d, 0x1f, 0x19, 0x19, 0x18, 0x1a, 0x18, 0x1a, 0x1a, 0x1a, 0x18, 0x1a,
  0x1a, 0x19, 0x1b, 0x1b, 0x1c, 0x1d, 0x1d, 0x1b, 0x18, 0x1b, 0x1b, 0x1b, 0x1c, 0x1c, 0x1d, 0x1e,
  0x1c, 0x1c, 0x1e, 0x1f, 0x1f, 0x1f, 0x1f, 0x20, 0x21, 0x20, 0x20, 0x21, 0x22, 0x22, 0x20, 0x20,
  0x22, 0x22, 0x23, 0x20, 0x21, 0x21, 0x21, 0x22, 0x22, 0x20, 0x20, 0x20, 0x22, 0x1e, 0x1f, 0x1e,
  0x1f, 0x20, 0x1e, 0x1e, 0x1c, 0x1b, 0x1a, 0x1c, 0x1c, 0x1c, 0x1d, 0x1d, 0x1e, 0x1e, 0x1c, 0x1b,
  0x1a, 0x1d, 0x1e, 0x14, 0x1d, 0x1f, 0x1d, 0x1e, 0x1f, 0x1e, 0x1d, 0x1f, 0x19, 0x19, 0x18, 0x1a,
  0x18, 0x19, 0x18, 0x19, 0x17, 0x1a, 0x19, 0x18, 0x1a, 0x1a, 0x1c, 0x1c, 0x1d, 0x1b, 0x18, 0x1a,
  0x1b, 0x1b, 0x1c, 0x1c, 0x1c, 0x1e, 0x1c, 0x1c, 0x1e, 0x1f, 0x20, 0x20, 0x20, 0x21, 0x22, 0x22,
  0x21, 0x22, 0x24, 0x23, 0x21, 0x21, 0x24, 0x23, 0x24, 0x21, 0x22, 0x22, 0x23, 0x23, 0x23, 0x21,
  0x22, 0x20, 0x23, 0x1f, 0x20, 0x1e, 0x1f, 0x20, 0x1f, 0x1e, 0x1d, 0x1b, 0x1a, 0x1c, 0x1c, 0x1c,
  0x1d, 0x1d, 0x1f, 0x1e, 0x1c, 0x1a, 0x1a, 0x1d, 0x1e, 0x18, 0x1d, 0x1f, 0x1e, 0x1f, 0x20, 0x1e,
  0x1e, 0x20, 0x19, 0x18, 0x17, 0x18, 0x17, 0x17, 0x16, 0x17, 0x15, 0x19, 0x17, 0x14, 0x18, 0x19,
  0x1a, 0x1a, 0x1c, 0x1b, 0x16, 0x19, 0x1a, 0x1a, 0x1c, 0x1b, 0x1b, 0x1f, 0x1c, 0x1a, 0x1f, 0x20,
  0x22, 0x21, 0x21, 0x22, 0x24, 0x23, 0x22, 0x24, 0x25, 0x24, 0x22, 0x23, 0x25, 0x25, 0x26, 0x22,
  0x23, 0x24, 0x24, 0x25, 0x24, 0x23, 0x24, 0x21, 0x25, 0x20, 0x21, 0x1e, 0x20, 0x21, 0x20, 0x1e,
  0x1d, 0x1b, 0x1a, 0x1b, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1e, 0x1c, 0x19, 0x1a, 0x1c, 0x1d, 0x1c,
  0x1e, 0x20, 0x1e, 0x20, 0x21, 0x1f, 0x1e, 0x20, 0x19, 0x18, 0x17, 0x18, 0x17, 0x16, 0x14, 0x15,
  0x14, 0x19, 0x14, 0x11, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x15, 0x17, 0x19, 0x1a, 0x1a, 0x1b,
  0x1a, 0x1f, 0x1b, 0x1a, 0x20, 0x21, 0x23, 0x22, 0x21, 0x23, 0x25, 0x24, 0x23, 0x24, 0x26, 0x26,
  0x23, 0x24, 0x26, 0x26, 0x26, 0x23, 0x24, 0x25, 0x25, 0x25, 0x25, 0x24, 0x24, 0x22, 0x26, 0x21,
  0x22, 0x1e, 0x21, 0x22, 0x21, 0x1f, 0x1e, 0x1b, 0x1a, 0x1a, 0x19, 0x1b, 0x1c, 0x1d, 0x1e, 0x1d,
  0x1b, 0x17, 0x19, 0x1a, 0x1c, 0x1e, 0x1e, 0x1f, 0x1f, 0x20, 0x21, 0x1f, 0x1f, 0x20, 0x19, 0x18,
  0x16, 0x16, 0x16, 0x13, 0x11, 0x12, 0x10, 0x18, 0x11, 0x0e, 0x13, 0x14, 0x16, 0x16, 0x18, 0x1b,
  0x12, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x17, 0x1e, 0x1a, 0x17, 0x20, 0x22, 0x24, 0x23, 0x22, 0x25,
  0x26, 0x26, 0x24, 0x26, 0x27, 0x26, 0x23, 0x25, 0x27, 0x27, 0x27, 0x24, 0x26, 0x26, 0x26, 0x26,
  0x26, 0x25, 0x25, 0x22, 0x27, 0x22, 0x22, 0x1e, 0x21, 0x23, 0x22, 0x1f, 0x1f, 0x1b, 0x1a, 0x19,
  0x17, 0x19, 0x1b, 0x1c, 0x1e, 0x1c, 0x18, 0x15, 0x17, 0x19, 0x1b, 0x20, 0x1e, 0x1f, 0x20, 0x20,
  0x21, 0x1f, 0x1f, 0x21, 0x19, 0x18, 0x16, 0x16, 0x15, 0x12, 0x10, 0x10, 0x0d, 0x17, 0x0f, 0x0d,
  0x10, 0x12, 0x15, 0x15, 0x19, 0x1a, 0x0f, 0x12, 0x15, 0x15, 0x18, 0x18, 0x17, 0x1d, 0x18, 0x15,
  0x1f, 0x22, 0x24, 0x23, 0x21, 0x24, 0x27, 0x27, 0x25, 0x26, 0x27, 0x27, 0x24, 0x26, 0x27, 0x27,
  0x27, 0x25, 0x26, 0x26, 0x27, 0x26, 0x26, 0x26, 0x26, 0x23, 0x27, 0x22, 0x22, 0x1e, 0x22, 0x24,
  0x22, 0x1f, 0x1f, 0x1a, 0x1a, 0x18, 0x16, 0x18, 0x1a, 0x1c, 0x1e, 0x1c, 0x18, 0x13, 0x14, 0x19,
  0x1c, 0x20, 0x1e, 0x1f, 0x20, 0x20, 0x22, 0x1f, 0x20, 0x20, 0x19, 0x18, 0x17, 0x16, 0x16, 0x11,
  0x10, 0x0f, 0x0c, 0x16, 0x0e, 0x0d, 0x11, 0x13, 0x17, 0x17, 0x1a, 0x19, 0x0d, 0x11, 0x15, 0x14,
  0x18, 0x18, 0x18, 0x1d, 0x18, 0x15, 0x1e, 0x21, 0x24, 0x22, 0x21, 0x23, 0x27, 0x27, 0x24, 0x24,
  0x27, 0x27, 0x25, 0x26, 0x27, 0x27, 0x27, 0x26, 0x27, 0x26, 0x26, 0x26, 0x25, 0x25, 0x26, 0x22,
  0x25, 0x23, 0x22, 0x1e, 0x22, 0x24, 0x23, 0x20, 0x20, 0x1a, 0x1a, 0x18, 0x15, 0x18, 0x1a, 0x1c,
  0x1e, 0x1c, 0x18, 0x12, 0x13, 0x19, 0x1c, 0x20, 0x1f, 0x1f, 0x20, 0x21, 0x22, 0x1f, 0x20, 0x20
};

static const unsigned char palette_19_17_M[] =
{
  0x08, 0x08, 0x07, 0x09, 0x0b, 0x12, 0x17, 0x17, 0x18, 0x12, 0x16, 0x1a, 0x16, 0x18, 0x16, 0x16,
  0x18, 0x13, 0x1a, 0x1a, 0x1a, 0x1a, 0x19, 0x19, 0x15, 0x16, 0x17, 0x1e, 0x16, 0x13, 0x11, 0x14,
  0x11, 0x10, 0x0c, 0x09, 0x0f, 0x10, 0x0e, 0x0b, 0x0f, 0x0a, 0x06, 0x05, 0x06, 0x06, 0x06, 0x05,
  0x02, 0x04, 0x06, 0x0a, 0x05, 0x0b, 0x06, 0x07, 0x0d, 0x0d, 0x08, 0x05, 0x04, 0x04, 0x03, 0x09,
  0x08, 0x0c, 0x0e, 0x0f, 0x10, 0x0f, 0x0f, 0x12, 0x14, 0x14, 0x15, 0x12, 0x13, 0x10, 0x0b, 0x11,
  0x0b, 0x0d, 0x0e, 0x0c, 0x0c, 0x10, 0x09, 0x07, 0x06, 0x0b, 0x0f, 0x1a, 0x21, 0x23, 0x26, 0x1a,
  0x23, 0x2a, 0x23, 0x26, 0x25, 0x23, 0x27, 0x1b, 0x28, 0x29, 0x2a, 0x28, 0x28, 0x26, 0x20, 0x20,
  0x26, 0x2e, 0x21, 0x1d, 0x19, 0x1d, 0x1a, 0x17, 0x11, 0x09, 0x17, 0x18, 0x16, 0x0f, 0x16, 0x0b,
  0x06, 0x02, 0x05, 0x04, 0x04, 0x05, 0x00, 0x04, 0x07, 0x0d, 0x06, 0x10, 0x07, 0x06, 0x10, 0x12,
  0x0c, 0x04, 0x03, 0x03, 0x02, 0x09, 0x06, 0x14, 0x16, 0x16, 0x18, 0x14, 0x18, 0x1a, 0x1e, 0x1f,
  0x1f, 0x1b, 0x1b, 0x17, 0x0f, 0x19, 0x0d, 0x13, 0x15, 0x10, 0x10, 0x16, 0x0a, 0x06, 0x06, 0x0d,
  0x12, 0x1e, 0x28, 0x2b, 0x2f, 0x20, 0x2d, 0x35, 0x2d, 0x30, 0x31, 0x2e, 0x32, 0x26, 0x33, 0x35,
  0x37, 0x33, 0x35, 0x31, 0x2d, 0x2a, 0x31, 0x37, 0x2a, 0x23, 0x21, 0x24, 0x22, 0x1d, 0x16, 0x0a,
  0x1c, 0x1e, 0x1c, 0x13, 0x1b, 0x0d, 0x04, 0x03, 0x07, 0x01, 0x04, 0x05, 0x00, 0x02, 0x07, 0x0f,
  0x06, 0x14, 0x07, 0x05, 0x14, 0x18, 0x0d, 0x02, 0x00, 0x01, 0x00, 0x0b, 0x06, 0x18, 0x1d, 0x1b,
  0x1e, 0x19, 0x1f, 0x20, 0x26, 0x28, 0x28, 0x23, 0x22, 0x1e, 0x12, 0x1d, 0x10, 0x16, 0x1b, 0x12,
  0x13, 0x1b, 0x0a, 0x06, 0x07, 0x10, 0x15, 0x23, 0x2e, 0x31, 0x3a, 0x28, 0x3b, 0x41, 0x3c, 0x3c,
  0x40, 0x3c, 0x40, 0x2d, 0x3d, 0x42, 0x44, 0x41, 0x41, 0x3b, 0x3b, 0x34, 0x3c, 0x41, 0x33, 0x2c,
  0x27, 0x2e, 0x2a, 0x24, 0x1a, 0x0c, 0x23, 0x26, 0x24, 0x17, 0x22, 0x0f, 0x05, 0x00, 0x07, 0x01,
  0x02, 0x04, 0x00, 0x01, 0x08, 0x10, 0x06, 0x19, 0x06, 0x04, 0x19, 0x1b, 0x0f, 0x02, 0x01, 0x02,
  0x00, 0x0d, 0x07, 0x1d, 0x22, 0x21, 0x25, 0x20, 0x2f, 0x29, 0x2f, 0x31, 0x2e, 0x2c, 0x2c, 0x27,
  0x14, 0x25, 0x13, 0x1b, 0x24, 0x15, 0x18, 0x21, 0x0b, 0x07, 0x07, 0x11, 0x16, 0x29, 0x35, 0x37,
  0x43, 0x2b, 0x46, 0x4c, 0x46, 0x47, 0x4c, 0x47, 0x48, 0x34, 0x43, 0x4c, 0x4b, 0x4c, 0x49, 0x45,
  0x46, 0x3c, 0x46, 0x49, 0x3b, 0x35, 0x30, 0x35, 0x32, 0x2a, 0x1f, 0x0d, 0x2a, 0x2d, 0x2b, 0x1c,
  0x26, 0x11, 0x03, 0x01, 0x05, 0x01, 0x02, 0x03, 0x00, 0x01, 0x09, 0x13, 0x05, 0x1d, 0x07, 0x04,
  0x1d, 0x1f, 0x11, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x07, 0x21, 0x27, 0x24, 0x2b, 0x24, 0x37, 0x31,
  0x36, 0x37, 0x36, 0x34, 0x34, 0x2e, 0x17, 0x2b, 0x14, 0x20, 0x2c, 0x19, 0x1a, 0x29, 0x0b, 0x08,
  0x08, 0x15, 0x1a, 0x2f, 0x3c, 0x40, 0x4e, 0x31, 0x52, 0x57, 0x52, 0x54, 0x58, 0x57, 0x56, 0x3a,
  0x4f, 0x55, 0x54, 0x56, 0x55, 0x4f, 0x53, 0x46, 0x50, 0x57, 0x45, 0x43, 0x3f, 0x41, 0x3e, 0x36,
  0x26, 0x0f, 0x34, 0x37, 0x35, 0x22, 0x2f, 0x14, 0x03, 0x00, 0x05, 0x00, 0x01, 0x03, 0x00, 0x00,
  0x0c, 0x18, 0x05, 0x26, 0x07, 0x05, 0x26, 0x28, 0x17, 0x01, 0x00, 0x00, 0x00, 0x10, 0x07, 0x27,
  0x30, 0x2c, 0x34, 0x2d, 0x41, 0x3c, 0x41, 0x40, 0x41, 0x44, 0x44, 0x39, 0x1b, 0x37, 0x18, 0x27,
  0x36, 0x1d, 0x21, 0x32, 0x0d, 0x09, 0x08, 0x18, 0x1d, 0x33, 0x44, 0x46, 0x55, 0x35, 0x59, 0x5d,
  0x58, 0x5b, 0x5e, 0x5d, 0x5d, 0x40, 0x55, 0x5b, 0x59, 0x5d, 0x5d, 0x56, 0x5b, 0x4c, 0x57, 0x5f,
  0x4c, 0x4d, 0x4a, 0x4b, 0x46, 0x3f, 0x2c, 0x11, 0x3d, 0x3f, 0x3e, 0x29, 0x36, 0x15, 0x04, 0x00,
  0x07, 0x00, 0x01, 0x04, 0x00, 0x00, 0x0f, 0x1e, 0x07, 0x2c, 0x07, 0x07, 0x2d, 0x2e, 0x1d, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x08, 0x2b, 0x36, 0x33, 0x3a, 0x33, 0x46, 0x45, 0x4a, 0x47, 0x48, 0x4b,
  0x4c, 0x40, 0x1e, 0x3f, 0x1b, 0x2c, 0x3c, 0x21, 0x27, 0x3b, 0x0f, 0x0a, 0x0a, 0x1e, 0x23, 0x3c,
  0x4c, 0x4e, 0x5a, 0x3a, 0x5f, 0x60, 0x5f, 0x61, 0x62, 0x62, 0x63, 0x45, 0x5c, 0x61, 0x5e, 0x63,
  0x62, 0x5d, 0x61, 0x55, 0x5d, 0x64, 0x56, 0x57, 0x54, 0x57, 0x53, 0x46, 0x34, 0x14, 0x46, 0x4b,
  0x47, 0x31, 0x3d, 0x19, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x05, 0x00, 0x00, 0x11, 0x24, 0x08, 0x2f,
  0x07, 0x0b, 0x32, 0x36, 0x23, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0a, 0x31, 0x3e, 0x3c, 0x41, 0x3c,
  0x49, 0x4c, 0x52, 0x4f, 0x52, 0x53, 0x52, 0x46, 0x23, 0x48, 0x1f, 0x35, 0x42, 0x26, 0x2d, 0x42,
  0x10, 0x0d, 0x0b, 0x21, 0x28, 0x43, 0x4f, 0x53, 0x5d, 0x40, 0x62, 0x62, 0x62, 0x64, 0x63, 0x64,
  0x63, 0x4b, 0x5f, 0x64, 0x63, 0x64, 0x64, 0x62, 0x64, 0x5f, 0x62, 0x64, 0x5d, 0x5e, 0x59, 0x5d,
  0x5c, 0x49, 0x3c, 0x19, 0x49, 0x52, 0x50, 0x3a, 0x46, 0x1e, 0x09, 0x02, 0x15, 0x00, 0x02, 0x07,
  0x00, 0x01, 0x15, 0x27, 0x0b, 0x2e, 0x10, 0x0e, 0x2f, 0x3a, 0x25, 0x02, 0x00, 0x00, 0x00, 0x1b,
  0x0d, 0x36, 0x44, 0x43, 0x47, 0x41, 0x4b, 0x50, 0x55, 0x55, 0x58, 0x56, 0x55, 0x48, 0x28, 0x4b,
  0x22, 0x3c, 0x45, 0x2b, 0x36, 0x43, 0x0a, 0x00, 0x00, 0x14, 0x1e, 0x2d, 0x3c, 0x41, 0x55, 0x2d,
  0x5a, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x37, 0x55, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x5a, 0x5a, 0x64, 0x3c, 0x32, 0x1e, 0x46, 0x55, 0x46, 0x32, 0x46, 0x1e,
  0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x28, 0x37, 0x2d, 0x32, 0x1e, 0x3c, 0x3c, 0x5f, 0x50,
  0x55, 0x4b, 0x50, 0x00, 0x08, 0x19, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x11, 0x10, 0x0f, 0x12,
  0x12, 0x1b, 0x1f, 0x20, 0x1e, 0x19, 0x1d, 0x23, 0x1d, 0x1f, 0x1e, 0x1d, 0x1c, 0x1b, 0x1f, 0x20,
  0x22, 0x1f, 0x20, 0x22, 0x1e, 0x1d, 0x1f, 0x21, 0x1d, 0x1c, 0x19, 0x1b, 0x18, 0x16, 0x15, 0x11,
  0x18, 0x18, 0x17, 0x14, 0x17, 0x12, 0x10, 0x0e, 0x10, 0x0f, 0x0f, 0x10, 0x0b, 0x0d, 0x0f, 0x12,
  0x10, 0x14, 0x10, 0x10, 0x16, 0x16, 0x13, 0x0e, 0x0d, 0x0d, 0x0d, 0x12, 0x10, 0x16, 0x18, 0x17,
  0x16, 0x18, 0x17, 0x19, 0x1b, 0x1c, 0x1b, 0x1a, 0x1a, 0x10, 0x14, 0x19, 0x13, 0x15, 0x17, 0x16,
  0x13, 0x18, 0x11, 0x0f, 0x10, 0x14, 0x16, 0x21, 0x28, 0x2a, 0x2a, 0x21, 0x27, 0x31, 0x28, 0x29,
  0x2a, 0x28, 0x29, 0x23, 0x2b, 0x2c, 0x31, 0x2c, 0x2c, 0x2f, 0x2a, 0x28, 0x2d, 0x2e, 0x2a, 0x24,
  0x21, 0x24, 0x1f, 0x1d, 0x18, 0x13, 0x1f, 0x1f, 0x1e, 0x18, 0x1d, 0x14, 0x10, 0x0d, 0x11, 0x0c,
  0x0e, 0x10, 0x06, 0x0b, 0x12, 0x15, 0x10, 0x18, 0x11, 0x10, 0x1b, 0x1c, 0x15, 0x0f, 0x0c, 0x0b,
  0x0a, 0x12, 0x10, 0x1b, 0x1d, 0x1c, 0x1e, 0x1c, 0x1e, 0x20, 0x24, 0x26, 0x25, 0x21, 0x24, 0x17,
  0x18, 0x21, 0x14, 0x1a, 0x1c, 0x18, 0x18, 0x1e, 0x12, 0x10, 0x0f, 0x15, 0x18, 0x28, 0x2f, 0x30,
  0x32, 0x25, 0x31, 0x3b, 0x33, 0x34, 0x34, 0x31, 0x31, 0x2a, 0x34, 0x36, 0x3a, 0x36, 0x35, 0x37,
  0x35, 0x2e, 0x36, 0x37, 0x33, 0x2b, 0x27, 0x2a, 0x25, 0x23, 0x1b, 0x14, 0x24, 0x24, 0x23, 0x1c,
  0x22, 0x16, 0x10, 0x0d, 0x11, 0x0b, 0x0d, 0x10, 0x02, 0x0b, 0x13, 0x18, 0x10, 0x1b, 0x12, 0x10,
  0x1d, 0x21, 0x17, 0x0c, 0x0a, 0x09, 0x08, 0x15, 0x0f, 0x1f, 0x22, 0x21, 0x22, 0x1f, 0x26, 0x26,
  0x2c, 0x2d, 0x2c, 0x27, 0x2b, 0x1d, 0x1a, 0x26, 0x16, 0x1e, 0x21, 0x1b, 0x1b, 0x24, 0x12, 0x10,
  0x10, 0x17, 0x1c, 0x2c, 0x37, 0x37, 0x3c, 0x29, 0x3c, 0x47, 0x3d, 0x40, 0x3f, 0x3c, 0x3d, 0x31,
  0x3e, 0x41, 0x46, 0x41, 0x40, 0x41, 0x3f, 0x38, 0x40, 0x41, 0x3b, 0x34, 0x2d, 0x34, 0x2d, 0x2a,
  0x1f, 0x16, 0x29, 0x2b, 0x29, 0x1f, 0x28, 0x19, 0x0f, 0x0b, 0x12, 0x0b, 0x0b, 0x10, 0x00, 0x09,
  0x14, 0x1a, 0x10, 0x21, 0x13, 0x0f, 0x23, 0x24, 0x1a, 0x0c, 0x08, 0x09, 0x06, 0x16, 0x10, 0x22,
  0x27, 0x26, 0x28, 0x25, 0x2e, 0x2e, 0x33, 0x35, 0x33, 0x30, 0x33, 0x28, 0x1d, 0x2f, 0x18, 0x24,
  0x29, 0x1f, 0x1e, 0x2a, 0x13, 0x11, 0x10, 0x1a, 0x1f, 0x31, 0x3e, 0x3e, 0x44, 0x2d, 0x45, 0x4e,
  0x45, 0x4a, 0x47, 0x45, 0x47, 0x36, 0x45, 0x4b, 0x4c, 0x4b, 0x4a, 0x49, 0x49, 0x40, 0x48, 0x4b,
  0x41, 0x3c, 0x34, 0x3c, 0x34, 0x30, 0x25, 0x16, 0x2f, 0x31, 0x2f, 0x23, 0x2f, 0x1a, 0x0e, 0x0a,
  0x12, 0x08, 0x0b, 0x10, 0x00, 0x07, 0x16, 0x1c, 0x12, 0x23, 0x13, 0x0f, 0x27, 0x28, 0x1c, 0x0a,
  0x06, 0x07, 0x05, 0x18, 0x10, 0x26, 0x2c, 0x2b, 0x2f, 0x2a, 0x37, 0x36, 0x3a, 0x3c, 0x3a, 0x38,
  0x3c, 0x2f, 0x20, 0x35, 0x1a, 0x28, 0x30, 0x21, 0x22, 0x30, 0x14, 0x11, 0x12, 0x1d, 0x23, 0x38,
  0x47, 0x48, 0x4e, 0x35, 0x52, 0x5a, 0x50, 0x54, 0x54, 0x53, 0x55, 0x3e, 0x52, 0x54, 0x55, 0x56,
  0x56, 0x52, 0x54, 0x49, 0x52, 0x5a, 0x4b, 0x47, 0x42, 0x4a, 0x40, 0x3a, 0x2a, 0x18, 0x3a, 0x3b,
  0x39, 0x29, 0x35, 0x1e, 0x10, 0x09, 0x14, 0x05, 0x0b, 0x10, 0x00, 0x06, 0x18, 0x23, 0x12, 0x2b,
  0x15, 0x10, 0x2f, 0x2e, 0x21, 0x0b, 0x06, 0x07, 0x04, 0x1b, 0x12, 0x2d, 0x36, 0x33, 0x38, 0x32,
  0x43, 0x41, 0x46, 0x44, 0x43, 0x48, 0x4a, 0x39, 0x24, 0x3e, 0x1d, 0x2e, 0x3a, 0x26, 0x29, 0x38,
  0x16, 0x13, 0x13, 0x21, 0x27, 0x3f, 0x4b, 0x4e, 0x55, 0x3a, 0x58, 0x60, 0x58, 0x5a, 0x5a, 0x5a,
  0x5b, 0x42, 0x58, 0x5b, 0x5b, 0x5c, 0x5d, 0x58, 0x5b, 0x50, 0x59, 0x61, 0x52, 0x50, 0x4c, 0x53,
  0x49, 0x43, 0x31, 0x1a, 0x42, 0x41, 0x41, 0x2f, 0x3d, 0x22, 0x0f, 0x07, 0x16, 0x05, 0x0b, 0x12,
  0x00, 0x05, 0x1a, 0x28, 0x13, 0x30, 0x15, 0x13, 0x34, 0x35, 0x26, 0x0b, 0x04, 0x07, 0x01, 0x1c,
  0x12, 0x32, 0x3b, 0x38, 0x3e, 0x37, 0x48, 0x49, 0x4c, 0x4c, 0x4a, 0x50, 0x4f, 0x41, 0x27, 0x45,
  0x21, 0x34, 0x40, 0x29, 0x2e, 0x3f, 0x17, 0x16, 0x15, 0x26, 0x2c, 0x46, 0x50, 0x54, 0x5b, 0x41,
  0x5f, 0x63, 0x5f, 0x61, 0x60, 0x61, 0x62, 0x49, 0x5f, 0x61, 0x5f, 0x62, 0x62, 0x5f, 0x62, 0x59,
  0x5f, 0x64, 0x5b, 0x5a, 0x55, 0x5b, 0x54, 0x48, 0x38, 0x1e, 0x48, 0x4e, 0x4a, 0x36, 0x44, 0x26,
  0x11, 0x06, 0x1a, 0x04, 0x0b, 0x14, 0x00, 0x07, 0x1b, 0x2b, 0x13, 0x31, 0x18, 0x16, 0x33, 0x39,
  0x29, 0x0c, 0x03, 0x08, 0x02, 0x1f, 0x15, 0x39, 0x42, 0x3f, 0x45, 0x40, 0x4b, 0x4e, 0x54, 0x53,
  0x53, 0x55, 0x54, 0x46, 0x2b, 0x4a, 0x24, 0x3c, 0x44, 0x2e, 0x35, 0x43, 0x1a, 0x18, 0x17, 0x29,
  0x30, 0x48, 0x51, 0x59, 0x60, 0x46, 0x62, 0x64, 0x62, 0x64, 0x63, 0x64, 0x63, 0x50, 0x62, 0x64,
  0x63, 0x64, 0x64, 0x63, 0x64, 0x61, 0x63, 0x64, 0x60, 0x60, 0x5b, 0x5f, 0x5d, 0x48, 0x40, 0x23,
  0x49, 0x54, 0x50, 0x3e, 0x4c, 0x2a, 0x1a, 0x10, 0x25, 0x03, 0x0e, 0x18, 0x00, 0x0d, 0x1d, 0x28,
  0x12, 0x2f, 0x21, 0x17, 0x31, 0x3c, 0x2a, 0x0d, 0x05, 0x09, 0x05, 0x24, 0x18, 0x3d, 0x48, 0x46,
  0x4a, 0x42, 0x4c, 0x51, 0x56, 0x57, 0x58, 0x57, 0x55, 0x48, 0x2f, 0x4c, 0x29, 0x40, 0x46, 0x32,
  0x3c, 0x43, 0x1c, 0x19, 0x18, 0x2b, 0x32, 0x48, 0x52, 0x5b, 0x61, 0x4b, 0x63, 0x64, 0x63, 0x64,
  0x63, 0x64, 0x62, 0x54, 0x63, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 0x64, 0x63, 0x62,
  0x5d, 0x61, 0x60, 0x4a, 0x45, 0x2a, 0x4b, 0x5a, 0x53, 0x46, 0x52, 0x2e, 0x24, 0x18, 0x2e, 0x04,
  0x12, 0x1b, 0x00, 0x10, 0x1f, 0x28, 0x12, 0x2f, 0x26, 0x18, 0x31, 0x3d, 0x2a, 0x10, 0x08, 0x0a,
  0x06, 0x28, 0x1a, 0x40, 0x4b, 0x4a, 0x4c, 0x45, 0x4c, 0x52, 0x59, 0x59, 0x5b, 0x59, 0x57, 0x47,
  0x32, 0x4b, 0x2d, 0x41, 0x47, 0x36, 0x3f, 0x44, 0x21, 0x20, 0x1e, 0x22, 0x23, 0x2b, 0x2d, 0x2e,
  0x2c, 0x26, 0x2c, 0x2f, 0x2d, 0x2f, 0x2f, 0x2c, 0x2d, 0x29, 0x2c, 0x2f, 0x30, 0x2c, 0x2d, 0x2f,
  0x2f, 0x2d, 0x2d, 0x2f, 0x2d, 0x2b, 0x27, 0x29, 0x29, 0x23, 0x25, 0x25, 0x28, 0x29, 0x29, 0x27,
  0x29, 0x24, 0x24, 0x23, 0x25, 0x21, 0x22, 0x21, 0x1f, 0x20, 0x21, 0x23, 0x22, 0x27, 0x22, 0x21,
  0x27, 0x27, 0x24, 0x21, 0x1f, 0x21, 0x1c, 0x22, 0x21, 0x28, 0x2a, 0x28, 0x28, 0x26, 0x27, 0x28,
  0x27, 0x29, 0x29, 0x29, 0x2a, 0x10, 0x23, 0x29, 0x21, 0x24, 0x28, 0x26, 0x24, 0x2a, 0x20, 0x1f,
  0x1f, 0x26, 0x25, 0x2f, 0x36, 0x36, 0x34, 0x2c, 0x36, 0x3a, 0x37, 0x37, 0x37, 0x35, 0x36, 0x2f,
  0x35, 0x37, 0x3b, 0x35, 0x37, 0x3a, 0x38, 0x35, 0x38, 0x38, 0x37, 0x33, 0x2f, 0x31, 0x2f, 0x2b,
  0x29, 0x25, 0x2e, 0x2e, 0x2d, 0x29, 0x2d, 0x25, 0x24, 0x22, 0x26, 0x21, 0x22, 0x21, 0x1a, 0x20,
  0x24, 0x24, 0x22, 0x2a, 0x24, 0x22, 0x2a, 0x2c, 0x27, 0x20, 0x1f, 0x20, 0x1c, 0x23, 0x21, 0x2c,
  0x2f, 0x2c, 0x2c, 0x2a, 0x2c, 0x2e, 0x2f, 0x31, 0x30, 0x2f, 0x31, 0x17, 0x27, 0x2f, 0x24, 0x28,
  0x2c, 0x29, 0x28, 0x2e, 0x20, 0x1f, 0x1f, 0x26, 0x26, 0x34, 0x3a, 0x3a, 0x3b, 0x31, 0x3c, 0x43,
  0x3d, 0x3f, 0x3f, 0x3c, 0x3d, 0x34, 0x3c, 0x3f, 0x44, 0x3e, 0x3e, 0x3f, 0x40, 0x3c, 0x3f, 0x40,
  0x3d, 0x37, 0x33, 0x37, 0x35, 0x2f, 0x2c, 0x26, 0x33, 0x33, 0x32, 0x2d, 0x31, 0x27, 0x25, 0x23,
  0x27, 0x20, 0x22, 0x23, 0x16, 0x20, 0x25, 0x28, 0x24, 0x2c, 0x24, 0x20, 0x2d, 0x2f, 0x28, 0x20,
  0x1d, 0x1e, 0x1b, 0x24, 0x21, 0x2e, 0x33, 0x2f, 0x31, 0x2d, 0x31, 0x33, 0x36, 0x37, 0x36, 0x33,
  0x37, 0x1f, 0x29, 0x35, 0x26, 0x2c, 0x31, 0x2d, 0x2a, 0x33, 0x21, 0x1f, 0x21, 0x28, 0x2a, 0x38,
  0x40, 0x41, 0x43, 0x34, 0x45, 0x4c, 0x45, 0x49, 0x46, 0x44, 0x45, 0x3a, 0x43, 0x49, 0x4c, 0x47,
  0x47, 0x48, 0x49, 0x43, 0x47, 0x48, 0x43, 0x3d, 0x38, 0x3e, 0x3a, 0x35, 0x31, 0x28, 0x36, 0x38,
  0x37, 0x30, 0x36, 0x28, 0x24, 0x22, 0x28, 0x1f, 0x23, 0x26, 0x14, 0x1f, 0x27, 0x2a, 0x25, 0x2f,
  0x26, 0x22, 0x30, 0x32, 0x2a, 0x21, 0x1d, 0x1f, 0x19, 0x26, 0x23, 0x33, 0x37, 0x34, 0x36, 0x32,
  0x39, 0x38, 0x3c, 0x3d, 0x3c, 0x3b, 0x3c, 0x27, 0x2c, 0x39, 0x27, 0x31, 0x37, 0x2f, 0x2d, 0x38,
  0x21, 0x21, 0x21, 0x2b, 0x2c, 0x3c, 0x46, 0x46, 0x49, 0x37, 0x4c, 0x53, 0x4b, 0x4f, 0x4e, 0x4c,
  0x4e, 0x40, 0x4a, 0x50, 0x52, 0x4f, 0x4e, 0x4e, 0x50, 0x48, 0x4e, 0x50, 0x4a, 0x43, 0x3e, 0x45,
  0x40, 0x3b, 0x35, 0x29, 0x3b, 0x3d, 0x3c, 0x34, 0x3a, 0x2a, 0x24, 0x22, 0x29, 0x1f, 0x23, 0x24,
  0x12, 0x1f, 0x28, 0x2c, 0x26, 0x31, 0x27, 0x23, 0x34, 0x35, 0x2c, 0x21, 0x1c, 0x1d, 0x19, 0x28,
  0x23, 0x36, 0x3b, 0x37, 0x3a, 0x36, 0x40, 0x3f, 0x41, 0x43, 0x40, 0x41, 0x45, 0x2e, 0x2e, 0x40,
  0x2a, 0x35, 0x3d, 0x32, 0x31, 0x3c, 0x23, 0x23, 0x23, 0x2d, 0x2f, 0x42, 0x4c, 0x4e, 0x52, 0x3d,
  0x55, 0x5d, 0x54, 0x57, 0x57, 0x57, 0x57, 0x43, 0x54, 0x57, 0x58, 0x58, 0x58, 0x57, 0x57, 0x50,
  0x57, 0x5b, 0x53, 0x4d, 0x49, 0x50, 0x49, 0x42, 0x3a, 0x2c, 0x43, 0x46, 0x44, 0x39, 0x43, 0x2d,
  0x26, 0x21, 0x2a, 0x1d, 0x23, 0x26, 0x0f, 0x1e, 0x2a, 0x31, 0x24, 0x36, 0x29, 0x24, 0x38, 0x39,
  0x31, 0x21, 0x1d, 0x1e, 0x19, 0x2b, 0x24, 0x3a, 0x41, 0x3d, 0x41, 0x3b, 0x47, 0x47, 0x4b, 0x4b,
  0x49, 0x4d, 0x4d, 0x38, 0x31, 0x45, 0x2d, 0x3a, 0x42, 0x35, 0x36, 0x41, 0x25, 0x24, 0x23, 0x2f,
  0x33, 0x45, 0x50, 0x52, 0x57, 0x42, 0x5a, 0x60, 0x59, 0x5c, 0x5b, 0x5c, 0x5c, 0x49, 0x5a, 0x5d,
  0x5c, 0x5d, 0x5e, 0x5d, 0x5c, 0x55, 0x5c, 0x61, 0x59, 0x55, 0x51, 0x57, 0x4f, 0x46, 0x3f, 0x2f,
  0x46, 0x4c, 0x49, 0x3d, 0x45, 0x30, 0x28, 0x21, 0x2d, 0x1d, 0x23, 0x28, 0x0f, 0x1d, 0x2a, 0x33,
  0x23, 0x38, 0x2a, 0x25, 0x3a, 0x3c, 0x31, 0x21, 0x1b, 0x1f, 0x19, 0x2d, 0x26, 0x3e, 0x44, 0x42,
  0x45, 0x40, 0x49, 0x4b, 0x4e, 0x50, 0x4d, 0x50, 0x50, 0x41, 0x35, 0x47, 0x30, 0x3e, 0x44, 0x38,
  0x39, 0x43, 0x26, 0x26, 0x26, 0x34, 0x37, 0x4b, 0x55, 0x57, 0x5d, 0x47, 0x5f, 0x63, 0x5f, 0x61,
  0x61, 0x61, 0x60, 0x4e, 0x60, 0x61, 0x60, 0x62, 0x63, 0x62, 0x62, 0x5c, 0x61, 0x64, 0x60, 0x5c,
  0x58, 0x5e, 0x56, 0x47, 0x45, 0x31, 0x49, 0x54, 0x51, 0x44, 0x4d, 0x33, 0x2d, 0x23, 0x31, 0x1e,
  0x24, 0x27, 0x0f, 0x1d, 0x27, 0x31, 0x1f, 0x35, 0x2a, 0x23, 0x35, 0x3d, 0x30, 0x1f, 0x18, 0x1f,
  0x19, 0x31, 0x29, 0x43, 0x48, 0x46, 0x49, 0x43, 0x4b, 0x4e, 0x54, 0x54, 0x54, 0x55, 0x54, 0x46,
  0x37, 0x4a, 0x35, 0x42, 0x46, 0x3b, 0x3f, 0x44, 0x2a, 0x2a, 0x28, 0x37, 0x3b, 0x4d, 0x56, 0x5a,
  0x60, 0x4c, 0x62, 0x64, 0x62, 0x63, 0x62, 0x63, 0x61, 0x54, 0x62, 0x64, 0x62, 0x64, 0x64, 0x64,
  0x63, 0x62, 0x64, 0x64, 0x64, 0x60, 0x5b, 0x60, 0x5c, 0x48, 0x4b, 0x37, 0x49, 0x59, 0x57, 0x4b,
  0x52, 0x38, 0x37, 0x2f, 0x39, 0x22, 0x27, 0x28, 0x16, 0x1c, 0x23, 0x2c, 0x1b, 0x33, 0x2d, 0x23,
  0x35, 0x3e, 0x2f, 0x1f, 0x1b, 0x22, 0x1d, 0x34, 0x2c, 0x45, 0x4c, 0x4a, 0x4c, 0x46, 0x4b, 0x51,
  0x57, 0x58, 0x59, 0x57, 0x55, 0x48, 0x3b, 0x4b, 0x3a, 0x45, 0x47, 0x3e, 0x43, 0x45, 0x2c, 0x2c,
  0x2a, 0x37, 0x3e, 0x4e, 0x56, 0x5d, 0x61, 0x50, 0x63, 0x64, 0x62, 0x63, 0x61, 0x62, 0x5e, 0x58,
  0x63, 0x63, 0x63, 0x64, 0x64, 0x64, 0x63, 0x62, 0x64, 0x64, 0x64, 0x62, 0x5d, 0x62, 0x5e, 0x49,
  0x51, 0x3b, 0x4b, 0x5b, 0x5a, 0x4f, 0x55, 0x3c, 0x3d, 0x35, 0x3f, 0x24, 0x2a, 0x28, 0x1b, 0x1d,
  0x24, 0x2c, 0x19, 0x33, 0x2e, 0x23, 0x35, 0x3f, 0x2f, 0x1e, 0x1b, 0x24, 0x20, 0x37, 0x31, 0x47,
  0x4e, 0x4c, 0x4d, 0x47, 0x4b, 0x50, 0x59, 0x5a, 0x5c, 0x59, 0x55, 0x47, 0x3e, 0x4a, 0x3e, 0x45,
  0x47, 0x40, 0x45, 0x45, 0x31, 0x33, 0x31, 0x34, 0x36, 0x3c, 0x40, 0x3f, 0x3d, 0x37, 0x3f, 0x41,
  0x40, 0x42, 0x40, 0x3f, 0x40, 0x3d, 0x3b, 0x3f, 0x3e, 0x3b, 0x3e, 0x40, 0x42, 0x3f, 0x3f, 0x3d,
  0x3d, 0x3b, 0x38, 0x3b, 0x3a, 0x34, 0x38, 0x3c, 0x39, 0x3c, 0x3c, 0x3d, 0x3d, 0x38, 0x39, 0x3a,
  0x3a, 0x37, 0x38, 0x36, 0x38, 0x37, 0x38, 0x33, 0x38, 0x38, 0x37, 0x33, 0x38, 0x38, 0x36, 0x35,
  0x31, 0x38, 0x2c, 0x37, 0x34, 0x3c, 0x3f, 0x39, 0x3a, 0x37, 0x37, 0x3b, 0x38, 0x3a, 0x38, 0x38,
  0x3a, 0x10, 0x37, 0x39, 0x33, 0x33, 0x3b, 0x38, 0x38, 0x3b, 0x32, 0x33, 0x31, 0x38, 0x37, 0x40,
  0x44, 0x43, 0x42, 0x3a, 0x43, 0x47, 0x44, 0x47, 0x45, 0x44, 0x44, 0x40, 0x41, 0x45, 0x47, 0x42,
  0x45, 0x46, 0x47, 0x44, 0x46, 0x45, 0x45, 0x3f, 0x3d, 0x3e, 0x3e, 0x3a, 0x3c, 0x3a, 0x3e, 0x40,
  0x40, 0x3e, 0x40, 0x38, 0x38, 0x38, 0x3b, 0x37, 0x38, 0x36, 0x35, 0x37, 0x38, 0x37, 0x38, 0x3a,
  0x3a, 0x33, 0x3b, 0x3c, 0x38, 0x35, 0x30, 0x37, 0x2c, 0x38, 0x35, 0x3f, 0x40, 0x3c, 0x3e, 0x3a,
  0x3c, 0x3e, 0x3c, 0x3e, 0x3c, 0x3e, 0x40, 0x17, 0x38, 0x3f, 0x37, 0x38, 0x3f, 0x3b, 0x38, 0x3f,
  0x34, 0x34, 0x31, 0x3a, 0x39, 0x43, 0x47, 0x48, 0x47, 0x3e, 0x49, 0x4c, 0x4a, 0x4c, 0x4b, 0x4a,
  0x4a, 0x43, 0x47, 0x4b, 0x4d, 0x49, 0x4c, 0x4c, 0x4c, 0x48, 0x4c, 0x4a, 0x4a, 0x44, 0x42, 0x44,
  0x44, 0x3e, 0x40, 0x3c, 0x41, 0x43, 0x44, 0x41, 0x42, 0x3a, 0x3b, 0x39, 0x3c, 0x39, 0x38, 0x38,
  0x34, 0x38, 0x3a, 0x38, 0x37, 0x3c, 0x3b, 0x34, 0x3c, 0x3e, 0x3a, 0x37, 0x31, 0x37, 0x2f, 0x39,
  0x35, 0x41, 0x43, 0x3f, 0x41, 0x3d, 0x40, 0x42, 0x41, 0x44, 0x41, 0x43, 0x43, 0x1f, 0x3d, 0x42,
  0x39, 0x3c, 0x42, 0x3e, 0x3c, 0x41, 0x33, 0x34, 0x33, 0x3b, 0x3a, 0x45, 0x4b, 0x4a, 0x4b, 0x41,
  0x4d, 0x52, 0x4e, 0x50, 0x4f, 0x4e, 0x4e, 0x47, 0x4b, 0x50, 0x52, 0x50, 0x51, 0x51, 0x50, 0x4c,
  0x51, 0x50, 0x4d, 0x48, 0x45, 0x49, 0x48, 0x42, 0x42, 0x3d, 0x43, 0x47, 0x47, 0x43, 0x46, 0x3b,
  0x3b, 0x3a, 0x3c, 0x38, 0x39, 0x3a, 0x31, 0x36, 0x3a, 0x3b, 0x37, 0x3e, 0x3a, 0x34, 0x3e, 0x3f,
  0x3a, 0x36, 0x31, 0x35, 0x2f, 0x3a, 0x36, 0x43, 0x44, 0x42, 0x43, 0x40, 0x43, 0x44, 0x44, 0x47,
  0x45, 0x45, 0x47, 0x27, 0x3f, 0x45, 0x3b, 0x40, 0x43, 0x41, 0x3d, 0x43, 0x34, 0x34, 0x33, 0x3c,
  0x3c, 0x47, 0x4d, 0x4e, 0x50, 0x44, 0x52, 0x57, 0x52, 0x54, 0x52, 0x52, 0x52, 0x4a, 0x51, 0x54,
  0x55, 0x54, 0x55, 0x55, 0x54, 0x50, 0x55, 0x54, 0x52, 0x4d, 0x49, 0x4e, 0x4b, 0x44, 0x45, 0x3d,
  0x45, 0x4a, 0x49, 0x44, 0x49, 0x3d, 0x3c, 0x39, 0x3d, 0x38, 0x38, 0x39, 0x30, 0x35, 0x39, 0x3b,
  0x36, 0x3e, 0x3b, 0x35, 0x3f, 0x40, 0x3b, 0x35, 0x31, 0x35, 0x2f, 0x3c, 0x37, 0x44, 0x45, 0x43,
  0x45, 0x41, 0x46, 0x47, 0x49, 0x4b, 0x49, 0x49, 0x4a, 0x2e, 0x3f, 0x46, 0x3c, 0x41, 0x45, 0x42,
  0x40, 0x44, 0x34, 0x35, 0x34, 0x3c, 0x3c, 0x49, 0x51, 0x52, 0x55, 0x47, 0x56, 0x5d, 0x57, 0x58,
  0x58, 0x58, 0x57, 0x4d, 0x57, 0x58, 0x5a, 0x5b, 0x5b, 0x5b, 0x59, 0x55, 0x5a, 0x5d, 0x58, 0x52,
  0x4e, 0x54, 0x4f, 0x47, 0x47, 0x3e, 0x47, 0x4d, 0x4d, 0x46, 0x4b, 0x3e, 0x3b, 0x38, 0x3c, 0x38,
  0x38, 0x37, 0x2e, 0x30, 0x36, 0x3a, 0x31, 0x3d, 0x38, 0x33, 0x3e, 0x40, 0x3a, 0x33, 0x2d, 0x34,
  0x2d, 0x3c, 0x38, 0x45, 0x49, 0x45, 0x47, 0x43, 0x49, 0x4a, 0x4d, 0x4f, 0x4d, 0x4e, 0x4e, 0x39,
  0x42, 0x49, 0x3e, 0x43, 0x46, 0x43, 0x42, 0x46, 0x37, 0x37, 0x35, 0x3d, 0x3f, 0x4b, 0x54, 0x54,
  0x59, 0x4a, 0x5a, 0x60, 0x59, 0x5b, 0x5a, 0x5c, 0x5a, 0x50, 0x5b, 0x5c, 0x5c, 0x5e, 0x5f, 0x5f,
  0x5c, 0x58, 0x5d, 0x61, 0x5d, 0x57, 0x54, 0x59, 0x51, 0x47, 0x49, 0x3f, 0x48, 0x50, 0x50, 0x47,
  0x4d, 0x40, 0x3d, 0x39, 0x3d, 0x39, 0x38, 0x35, 0x2e, 0x2d, 0x33, 0x38, 0x2c, 0x3b, 0x36, 0x31,
  0x3b, 0x40, 0x38, 0x30, 0x2b, 0x34, 0x2e, 0x3e, 0x38, 0x47, 0x4a, 0x47, 0x49, 0x45, 0x4a, 0x4b,
  0x50, 0x52, 0x51, 0x52, 0x51, 0x41, 0x43, 0x49, 0x41, 0x45, 0x47, 0x43, 0x43, 0x45, 0x37, 0x37,
  0x37, 0x3e, 0x41, 0x4f, 0x57, 0x57, 0x5d, 0x4e, 0x5e, 0x62, 0x5d, 0x5f, 0x5d, 0x5f, 0x5d, 0x53,
  0x5f, 0x5f, 0x60, 0x61, 0x61, 0x62, 0x5f, 0x5b, 0x61, 0x63, 0x61, 0x5c, 0x57, 0x5d, 0x54, 0x48,
  0x4b, 0x3f, 0x48, 0x54, 0x54, 0x49, 0x50, 0x40, 0x3f, 0x38, 0x3d, 0x3a, 0x37, 0x2f, 0x2b, 0x26,
  0x2d, 0x33, 0x26, 0x37, 0x32, 0x2e, 0x3a, 0x41, 0x34, 0x2b, 0x28, 0x32, 0x2c, 0x3e, 0x39, 0x49,
  0x4c, 0x4a, 0x4b, 0x46, 0x4a, 0x4e, 0x54, 0x56, 0x55, 0x55, 0x52, 0x46, 0x43, 0x4a, 0x42, 0x46,
  0x47, 0x44, 0x46, 0x46, 0x39, 0x38, 0x38, 0x40, 0x44, 0x51, 0x58, 0x5b, 0x60, 0x50, 0x60, 0x62,
  0x5f, 0x5f, 0x5b, 0x5d, 0x58, 0x57, 0x61, 0x61, 0x5f, 0x62, 0x60, 0x62, 0x5c, 0x5d, 0x61, 0x62,
  0x62, 0x5f, 0x59, 0x5f, 0x55, 0x49, 0x4d, 0x3f, 0x49, 0x54, 0x56, 0x49, 0x51, 0x40, 0x3f, 0x3a,
  0x3e, 0x3c, 0x34, 0x2d, 0x29, 0x24, 0x2d, 0x31, 0x23, 0x38, 0x33, 0x2a, 0x3a, 0x41, 0x34, 0x29,
  0x26, 0x32, 0x2d, 0x40, 0x3c, 0x4a, 0x4e, 0x4c, 0x4d, 0x47, 0x49, 0x4e, 0x55, 0x58, 0x59, 0x54,
  0x51, 0x48, 0x44, 0x4a, 0x44, 0x47, 0x47, 0x45, 0x47, 0x45, 0x3b, 0x3b, 0x3b, 0x41, 0x46, 0x52,
  0x59, 0x5c, 0x60, 0x53, 0x61, 0x62, 0x5e, 0x5d, 0x58, 0x5a, 0x54, 0x59, 0x62, 0x60, 0x5f, 0x61,
  0x5d, 0x61, 0x5a, 0x5b, 0x5f, 0x61, 0x61, 0x5e, 0x58, 0x5b, 0x52, 0x47, 0x4e, 0x40, 0x49, 0x51,
  0x57, 0x4b, 0x52, 0x41, 0x40, 0x3a, 0x3e, 0x3a, 0x33, 0x2e, 0x2a, 0x29, 0x32, 0x37, 0x24, 0x39,
  0x39, 0x29, 0x3a, 0x41, 0x35, 0x29, 0x25, 0x32, 0x2d, 0x41, 0x3e, 0x4b, 0x50, 0x4d, 0x4e, 0x49,
  0x48, 0x4c, 0x54, 0x5a, 0x5a, 0x54, 0x50, 0x47, 0x45, 0x49, 0x45, 0x47, 0x47, 0x45, 0x47, 0x46
};

static const unsigned char palette_19_17_Y[] =
{
  0x0f, 0x15, 0x1a, 0x15, 0x16, 0x13, 0x0f, 0x0d, 0x0a, 0x0a, 0x0a, 0x08, 0x09, 0x08, 0x08, 0x06,
  0x07, 0x04, 0x08, 0x05, 0x05, 0x04, 0x04, 0x02, 0x05, 0x04, 0x04, 0x03, 0x00, 0x04, 0x05, 0x03,
  0x07, 0x0d, 0x02, 0x07, 0x0b, 0x02, 0x02, 0x04, 0x05, 0x06, 0x05, 0x07, 0x08, 0x07, 0x0a, 0x0f,
  0x0f, 0x13, 0x0f, 0x0f, 0x13, 0x11, 0x0d, 0x15, 0x12, 0x16, 0x13, 0x14, 0x18, 0x17, 0x1a, 0x11,
  0x13, 0x10, 0x14, 0x10, 0x11, 0x11, 0x0f, 0x10, 0x0e, 0x0f, 0x0e, 0x0d, 0x0e, 0x0f, 0x0a, 0x0d,
  0x09, 0x0b, 0x0b, 0x0a, 0x0a, 0x0f, 0x19, 0x21, 0x2a, 0x23, 0x21, 0x1d, 0x19, 0x16, 0x10, 0x10,
  0x0e, 0x0c, 0x0d, 0x0a, 0x0b, 0x09, 0x0b, 0x05, 0x0b, 0x08, 0x07, 0x03, 0x01, 0x00, 0x07, 0x02,
  0x01, 0x02, 0x00, 0x04, 0x05, 0x04, 0x07, 0x12, 0x02, 0x08, 0x10, 0x03, 0x00, 0x05, 0x04, 0x0a,
  0x05, 0x0a, 0x0a, 0x08, 0x0f, 0x16, 0x16, 0x1d, 0x19, 0x18, 0x1d, 0x1c, 0x15, 0x22, 0x1c, 0x20,
  0x21, 0x21, 0x26, 0x26, 0x28, 0x1d, 0x21, 0x19, 0x1e, 0x1a, 0x1a, 0x18, 0x18, 0x16, 0x17, 0x17,
  0x16, 0x14, 0x14, 0x16, 0x0f, 0x15, 0x0d, 0x11, 0x11, 0x0f, 0x0e, 0x16, 0x1f, 0x2d, 0x34, 0x2c,
  0x2e, 0x25, 0x21, 0x1d, 0x18, 0x14, 0x12, 0x0f, 0x12, 0x10, 0x10, 0x0c, 0x0f, 0x07, 0x0e, 0x0a,
  0x09, 0x04, 0x00, 0x00, 0x07, 0x02, 0x00, 0x00, 0x00, 0x03, 0x04, 0x01, 0x09, 0x18, 0x02, 0x0b,
  0x14, 0x02, 0x00, 0x04, 0x05, 0x0c, 0x06, 0x0b, 0x0b, 0x09, 0x14, 0x1d, 0x1d, 0x26, 0x21, 0x1d,
  0x26, 0x25, 0x1a, 0x2a, 0x22, 0x29, 0x28, 0x2b, 0x30, 0x31, 0x33, 0x27, 0x2b, 0x22, 0x27, 0x21,
  0x23, 0x1f, 0x20, 0x1e, 0x1f, 0x1e, 0x1b, 0x1a, 0x1a, 0x1c, 0x13, 0x19, 0x10, 0x16, 0x19, 0x13,
  0x12, 0x1b, 0x26, 0x37, 0x3f, 0x3a, 0x39, 0x31, 0x2d, 0x25, 0x21, 0x18, 0x1c, 0x17, 0x1a, 0x13,
  0x16, 0x0f, 0x13, 0x08, 0x14, 0x0d, 0x0b, 0x03, 0x00, 0x00, 0x09, 0x01, 0x00, 0x00, 0x00, 0x02,
  0x05, 0x01, 0x09, 0x1c, 0x00, 0x0d, 0x19, 0x00, 0x00, 0x04, 0x04, 0x0c, 0x07, 0x0f, 0x0d, 0x09,
  0x18, 0x24, 0x23, 0x2f, 0x2a, 0x23, 0x2f, 0x2e, 0x1f, 0x34, 0x2b, 0x2f, 0x30, 0x37, 0x3a, 0x3e,
  0x3c, 0x31, 0x36, 0x2c, 0x30, 0x2a, 0x2c, 0x29, 0x30, 0x26, 0x26, 0x27, 0x23, 0x23, 0x21, 0x24,
  0x17, 0x21, 0x16, 0x1c, 0x1f, 0x18, 0x17, 0x23, 0x2c, 0x40, 0x47, 0x46, 0x42, 0x3b, 0x38, 0x2d,
  0x2b, 0x1d, 0x26, 0x20, 0x23, 0x19, 0x1e, 0x13, 0x18, 0x08, 0x1b, 0x11, 0x0c, 0x02, 0x01, 0x00,
  0x09, 0x00, 0x00, 0x01, 0x00, 0x02, 0x03, 0x01, 0x09, 0x21, 0x01, 0x0e, 0x1d, 0x00, 0x00, 0x04,
  0x04, 0x0e, 0x07, 0x10, 0x0f, 0x0b, 0x1c, 0x29, 0x28, 0x36, 0x32, 0x29, 0x38, 0x37, 0x24, 0x3c,
  0x33, 0x38, 0x38, 0x40, 0x43, 0x47, 0x45, 0x39, 0x3f, 0x33, 0x39, 0x31, 0x33, 0x31, 0x3a, 0x2f,
  0x2d, 0x2d, 0x29, 0x2a, 0x2a, 0x2c, 0x1b, 0x27, 0x1a, 0x20, 0x26, 0x1b, 0x1b, 0x2a, 0x34, 0x4c,
  0x52, 0x54, 0x4c, 0x46, 0x45, 0x3b, 0x3e, 0x24, 0x36, 0x31, 0x32, 0x24, 0x2a, 0x19, 0x20, 0x0c,
  0x26, 0x19, 0x10, 0x02, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00, 0x09, 0x28,
  0x00, 0x10, 0x23, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x08, 0x14, 0x11, 0x0b, 0x20, 0x32, 0x2f, 0x42,
  0x3a, 0x31, 0x47, 0x43, 0x2b, 0x49, 0x40, 0x45, 0x44, 0x4d, 0x4c, 0x54, 0x4c, 0x44, 0x4a, 0x3d,
  0x47, 0x3d, 0x40, 0x3d, 0x45, 0x3a, 0x38, 0x39, 0x35, 0x38, 0x37, 0x35, 0x1f, 0x30, 0x1f, 0x27,
  0x2f, 0x21, 0x23, 0x33, 0x39, 0x53, 0x59, 0x5c, 0x55, 0x4f, 0x50, 0x46, 0x4c, 0x29, 0x45, 0x40,
  0x3d, 0x2d, 0x33, 0x22, 0x26, 0x0f, 0x2f, 0x21, 0x14, 0x05, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x02, 0x00, 0x09, 0x2d, 0x00, 0x12, 0x28, 0x00, 0x00, 0x01, 0x03, 0x11, 0x09, 0x16,
  0x14, 0x0e, 0x25, 0x38, 0x35, 0x4a, 0x42, 0x39, 0x4f, 0x4b, 0x31, 0x52, 0x4b, 0x4d, 0x4e, 0x57,
  0x56, 0x5b, 0x55, 0x4c, 0x52, 0x47, 0x51, 0x47, 0x48, 0x44, 0x49, 0x43, 0x41, 0x40, 0x3d, 0x41,
  0x40, 0x3c, 0x25, 0x38, 0x22, 0x2c, 0x34, 0x26, 0x27, 0x3a, 0x41, 0x5c, 0x60, 0x62, 0x60, 0x5c,
  0x5f, 0x54, 0x57, 0x31, 0x54, 0x4d, 0x49, 0x3c, 0x3e, 0x2b, 0x2f, 0x11, 0x3f, 0x2d, 0x1b, 0x08,
  0x00, 0x00, 0x17, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2d, 0x00, 0x14, 0x2c, 0x00,
  0x00, 0x02, 0x01, 0x12, 0x09, 0x1a, 0x15, 0x11, 0x2a, 0x3f, 0x3a, 0x52, 0x4d, 0x42, 0x57, 0x52,
  0x38, 0x5d, 0x53, 0x57, 0x59, 0x5d, 0x5f, 0x61, 0x5e, 0x56, 0x5a, 0x52, 0x5c, 0x51, 0x51, 0x51,
  0x4e, 0x4c, 0x4c, 0x4e, 0x4b, 0x49, 0x45, 0x40, 0x2a, 0x40, 0x26, 0x33, 0x39, 0x2c, 0x2e, 0x43,
  0x48, 0x62, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5d, 0x5f, 0x38, 0x60, 0x57, 0x53, 0x49, 0x46, 0x38,
  0x33, 0x14, 0x4d, 0x3b, 0x25, 0x16, 0x05, 0x00, 0x26, 0x00, 0x00, 0x13, 0x00, 0x00, 0x01, 0x00,
  0x07, 0x29, 0x00, 0x16, 0x29, 0x00, 0x00, 0x00, 0x02, 0x13, 0x0a, 0x1e, 0x18, 0x13, 0x30, 0x45,
  0x3f, 0x55, 0x51, 0x4b, 0x5c, 0x56, 0x3d, 0x62, 0x58, 0x5f, 0x5d, 0x61, 0x63, 0x63, 0x63, 0x5f,
  0x60, 0x58, 0x60, 0x59, 0x58, 0x58, 0x4f, 0x51, 0x51, 0x56, 0x55, 0x4c, 0x48, 0x43, 0x2f, 0x43,
  0x29, 0x39, 0x3b, 0x30, 0x36, 0x48, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d,
  0x64, 0x5f, 0x64, 0x50, 0x5a, 0x46, 0x50, 0x19, 0x55, 0x46, 0x32, 0x19, 0x14, 0x00, 0x28, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0f, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x0a, 0x0a, 0x05, 0x28, 0x37, 0x3c, 0x50, 0x46, 0x50, 0x5a, 0x41, 0x32, 0x64, 0x64, 0x46,
  0x5a, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x5a, 0x3c, 0x64, 0x64,
  0x64, 0x46, 0x46, 0x00, 0x1e, 0x1e, 0x0f, 0x05, 0x0a, 0x19, 0x14, 0x1e, 0x18, 0x1c, 0x20, 0x1a,
  0x1d, 0x1b, 0x1a, 0x18, 0x14, 0x13, 0x13, 0x10, 0x12, 0x11, 0x12, 0x10, 0x10, 0x0f, 0x10, 0x0f,
  0x0f, 0x0d, 0x0c, 0x0b, 0x10, 0x0c, 0x0b, 0x0d, 0x07, 0x0e, 0x0d, 0x0d, 0x0f, 0x13, 0x0c, 0x0f,
  0x14, 0x0d, 0x0c, 0x0d, 0x0f, 0x10, 0x0f, 0x11, 0x10, 0x10, 0x14, 0x16, 0x16, 0x1b, 0x18, 0x17,
  0x1c, 0x18, 0x15, 0x1b, 0x19, 0x1d, 0x19, 0x1d, 0x1f, 0x1f, 0x1e, 0x19, 0x1b, 0x18, 0x1a, 0x17,
  0x17, 0x19, 0x16, 0x17, 0x18, 0x16, 0x15, 0x16, 0x17, 0x0f, 0x13, 0x18, 0x12, 0x12, 0x14, 0x14,
  0x12, 0x18, 0x1f, 0x26, 0x2b, 0x27, 0x26, 0x26, 0x22, 0x1f, 0x18, 0x18, 0x17, 0x16, 0x16, 0x15,
  0x15, 0x13, 0x15, 0x0f, 0x14, 0x11, 0x11, 0x0c, 0x0a, 0x05, 0x10, 0x0b, 0x09, 0x0b, 0x03, 0x0d,
  0x0f, 0x0b, 0x10, 0x18, 0x0b, 0x12, 0x19, 0x0c, 0x09, 0x0f, 0x0f, 0x12, 0x0f, 0x14, 0x12, 0x12,
  0x18, 0x1e, 0x1e, 0x24, 0x22, 0x1e, 0x27, 0x20, 0x1b, 0x26, 0x23, 0x27, 0x24, 0x28, 0x2a, 0x2d,
  0x2b, 0x23, 0x24, 0x21, 0x23, 0x20, 0x1f, 0x21, 0x1e, 0x1e, 0x1d, 0x1f, 0x1e, 0x1b, 0x1d, 0x16,
  0x18, 0x1f, 0x15, 0x1a, 0x1a, 0x19, 0x17, 0x1f, 0x24, 0x2e, 0x34, 0x31, 0x2f, 0x2d, 0x29, 0x25,
  0x1e, 0x1b, 0x1b, 0x1b, 0x1c, 0x19, 0x1b, 0x16, 0x18, 0x10, 0x18, 0x13, 0x11, 0x0c, 0x0a, 0x04,
  0x14, 0x0b, 0x05, 0x0b, 0x00, 0x0c, 0x0e, 0x09, 0x12, 0x1d, 0x09, 0x13, 0x1c, 0x0b, 0x06, 0x0d,
  0x0e, 0x14, 0x10, 0x15, 0x15, 0x13, 0x1c, 0x23, 0x24, 0x2d, 0x28, 0x23, 0x2e, 0x27, 0x1f, 0x2d,
  0x29, 0x2f, 0x2b, 0x31, 0x33, 0x38, 0x35, 0x2b, 0x2e, 0x26, 0x2a, 0x26, 0x26, 0x26, 0x23, 0x23,
  0x24, 0x25, 0x23, 0x21, 0x23, 0x1c, 0x1a, 0x23, 0x17, 0x1d, 0x1f, 0x1c, 0x19, 0x23, 0x2a, 0x37,
  0x40, 0x40, 0x3a, 0x37, 0x33, 0x2c, 0x24, 0x1e, 0x24, 0x20, 0x22, 0x1d, 0x1f, 0x18, 0x1b, 0x12,
  0x1a, 0x17, 0x13, 0x0c, 0x08, 0x02, 0x14, 0x08, 0x05, 0x09, 0x00, 0x09, 0x0f, 0x07, 0x12, 0x21,
  0x07, 0x15, 0x20, 0x0a, 0x03, 0x0d, 0x0d, 0x15, 0x10, 0x15, 0x16, 0x13, 0x1f, 0x28, 0x2a, 0x36,
  0x30, 0x29, 0x37, 0x30, 0x25, 0x35, 0x31, 0x36, 0x34, 0x3b, 0x3d, 0x42, 0x40, 0x33, 0x37, 0x2f,
  0x33, 0x2d, 0x2d, 0x2f, 0x2d, 0x2a, 0x2b, 0x2c, 0x28, 0x28, 0x29, 0x25, 0x1f, 0x2a, 0x1a, 0x23,
  0x25, 0x20, 0x1f, 0x2b, 0x30, 0x41, 0x48, 0x49, 0x43, 0x3f, 0x3c, 0x33, 0x2c, 0x22, 0x2b, 0x26,
  0x29, 0x23, 0x24, 0x1b, 0x20, 0x12, 0x1f, 0x19, 0x16, 0x0b, 0x07, 0x01, 0x14, 0x05, 0x03, 0x09,
  0x00, 0x08, 0x0d, 0x03, 0x13, 0x26, 0x06, 0x15, 0x24, 0x07, 0x01, 0x0c, 0x0d, 0x16, 0x11, 0x18,
  0x18, 0x14, 0x23, 0x2e, 0x2f, 0x3c, 0x35, 0x2d, 0x3e, 0x35, 0x2a, 0x3e, 0x39, 0x3d, 0x3b, 0x43,
  0x45, 0x49, 0x47, 0x3c, 0x3f, 0x37, 0x3c, 0x34, 0x35, 0x36, 0x37, 0x34, 0x30, 0x34, 0x2f, 0x2d,
  0x32, 0x2d, 0x22, 0x30, 0x1d, 0x26, 0x2a, 0x23, 0x23, 0x30, 0x37, 0x4e, 0x53, 0x56, 0x4f, 0x4b,
  0x4c, 0x40, 0x38, 0x28, 0x38, 0x36, 0x33, 0x2c, 0x2d, 0x20, 0x26, 0x13, 0x2a, 0x21, 0x18, 0x0b,
  0x05, 0x00, 0x18, 0x05, 0x01, 0x07, 0x00, 0x04, 0x0b, 0x01, 0x13, 0x2b, 0x02, 0x18, 0x29, 0x04,
  0x00, 0x0c, 0x0d, 0x19, 0x12, 0x1b, 0x19, 0x16, 0x28, 0x35, 0x35, 0x47, 0x40, 0x37, 0x4b, 0x41,
  0x31, 0x49, 0x44, 0x49, 0x45, 0x50, 0x4f, 0x52, 0x4f, 0x47, 0x4a, 0x43, 0x4b, 0x41, 0x42, 0x40,
  0x45, 0x40, 0x3d, 0x3e, 0x38, 0x3e, 0x3e, 0x35, 0x28, 0x37, 0x21, 0x2d, 0x33, 0x28, 0x2a, 0x38,
  0x3c, 0x56, 0x5b, 0x5e, 0x59, 0x56, 0x57, 0x4b, 0x44, 0x2d, 0x42, 0x43, 0x40, 0x34, 0x33, 0x28,
  0x2b, 0x16, 0x33, 0x26, 0x1d, 0x0c, 0x04, 0x00, 0x1b, 0x03, 0x00, 0x0a, 0x00, 0x04, 0x09, 0x01,
  0x14, 0x2f, 0x02, 0x19, 0x2d, 0x03, 0x00, 0x0b, 0x0b, 0x19, 0x12, 0x1c, 0x1a, 0x17, 0x2b, 0x3b,
  0x3a, 0x4d, 0x44, 0x3f, 0x52, 0x4b, 0x37, 0x53, 0x4d, 0x52, 0x4f, 0x58, 0x5a, 0x58, 0x59, 0x4e,
  0x51, 0x4b, 0x54, 0x49, 0x4a, 0x47, 0x4a, 0x47, 0x45, 0x49, 0x40, 0x45, 0x43, 0x3c, 0x2c, 0x3e,
  0x24, 0x32, 0x38, 0x2d, 0x2f, 0x3e, 0x45, 0x5f, 0x62, 0x63, 0x61, 0x61, 0x63, 0x57, 0x53, 0x35,
  0x52, 0x50, 0x4d, 0x41, 0x3e, 0x30, 0x30, 0x18, 0x40, 0x31, 0x23, 0x10, 0x06, 0x00, 0x22, 0x02,
  0x00, 0x14, 0x00, 0x02, 0x07, 0x00, 0x12, 0x2d, 0x01, 0x1d, 0x2d, 0x01, 0x00, 0x09, 0x09, 0x1b,
  0x13, 0x1f, 0x1d, 0x19, 0x30, 0x43, 0x41, 0x53, 0x4d, 0x47, 0x58, 0x54, 0x3c, 0x5d, 0x55, 0x5c,
  0x5a, 0x5e, 0x61, 0x60, 0x62, 0x58, 0x5a, 0x55, 0x5d, 0x53, 0x53, 0x52, 0x4e, 0x4f, 0x4d, 0x53,
  0x4c, 0x4b, 0x47, 0x42, 0x31, 0x42, 0x29, 0x39, 0x3a, 0x31, 0x35, 0x44, 0x4b, 0x62, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x60, 0x60, 0x3c, 0x5c, 0x59, 0x56, 0x4c, 0x49, 0x3b, 0x34, 0x1c, 0x4f, 0x40,
  0x30, 0x20, 0x12, 0x00, 0x2e, 0x03, 0x02, 0x21, 0x00, 0x02, 0x07, 0x00, 0x0e, 0x2a, 0x00, 0x1f,
  0x29, 0x00, 0x00, 0x07, 0x07, 0x1d, 0x14, 0x23, 0x20, 0x1b, 0x35, 0x48, 0x45, 0x57, 0x52, 0x4b,
  0x5d, 0x55, 0x41, 0x62, 0x57, 0x5f, 0x5e, 0x62, 0x64, 0x63, 0x64, 0x5f, 0x61, 0x5b, 0x61, 0x5b,
  0x59, 0x58, 0x50, 0x52, 0x52, 0x59, 0x55, 0x4e, 0x48, 0x44, 0x35, 0x44, 0x2e, 0x3d, 0x3c, 0x36,
  0x3b, 0x47, 0x50, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 0x41, 0x60, 0x5d, 0x5b, 0x52,
  0x4d, 0x41, 0x3a, 0x21, 0x56, 0x49, 0x39, 0x2d, 0x1e, 0x01, 0x37, 0x06, 0x0a, 0x28, 0x00, 0x01,
  0x07, 0x00, 0x0a, 0x2b, 0x00, 0x20, 0x26, 0x00, 0x00, 0x07, 0x07, 0x1e, 0x15, 0x25, 0x22, 0x1b,
  0x38, 0x4a, 0x47, 0x57, 0x53, 0x4c, 0x5f, 0x57, 0x43, 0x64, 0x58, 0x60, 0x5f, 0x63, 0x64, 0x64,
  0x64, 0x62, 0x63, 0x5d, 0x63, 0x5d, 0x5c, 0x5b, 0x50, 0x52, 0x54, 0x5c, 0x5a, 0x4f, 0x4b, 0x43,
  0x39, 0x44, 0x32, 0x3f, 0x3c, 0x38, 0x3f, 0x47, 0x24, 0x28, 0x2a, 0x29, 0x2a, 0x2c, 0x2a, 0x29,
  0x24, 0x22, 0x24, 0x23, 0x26, 0x24, 0x24, 0x21, 0x23, 0x20, 0x21, 0x23, 0x21, 0x1e, 0x1f, 0x1f,
  0x25, 0x21, 0x1f, 0x1f, 0x1b, 0x1f, 0x1c, 0x1d, 0x21, 0x1f, 0x1e, 0x23, 0x23, 0x20, 0x1e, 0x20,
  0x1f, 0x21, 0x21, 0x22, 0x24, 0x22, 0x24, 0x24, 0x24, 0x28, 0x27, 0x24, 0x2b, 0x28, 0x24, 0x29,
  0x27, 0x2b, 0x28, 0x2a, 0x2a, 0x2c, 0x29, 0x28, 0x27, 0x29, 0x2b, 0x28, 0x26, 0x26, 0x24, 0x25,
  0x24, 0x24, 0x23, 0x26, 0x25, 0x0e, 0x23, 0x24, 0x1f, 0x22, 0x25, 0x24, 0x23, 0x28, 0x2a, 0x30,
  0x35, 0x33, 0x32, 0x33, 0x31, 0x2e, 0x28, 0x25, 0x29, 0x27, 0x2a, 0x28, 0x26, 0x25, 0x26, 0x22,
  0x23, 0x24, 0x24, 0x1e, 0x1f, 0x1b, 0x26, 0x1f, 0x1e, 0x1d, 0x18, 0x1f, 0x1e, 0x1b, 0x22, 0x24,
  0x1d, 0x23, 0x27, 0x1e, 0x1c, 0x20, 0x21, 0x20, 0x21, 0x23, 0x24, 0x22, 0x27, 0x29, 0x2b, 0x30,
  0x2d, 0x2a, 0x31, 0x2e, 0x28, 0x30, 0x2f, 0x33, 0x2f, 0x32, 0x35, 0x37, 0x35, 0x2f, 0x31, 0x2f,
  0x32, 0x2c, 0x2d, 0x2c, 0x29, 0x2b, 0x28, 0x2b, 0x29, 0x29, 0x2b, 0x15, 0x27, 0x2a, 0x23, 0x25,
  0x29, 0x27, 0x26, 0x2c, 0x2f, 0x38, 0x3c, 0x3b, 0x39, 0x3a, 0x36, 0x33, 0x2c, 0x29, 0x2d, 0x2b,
  0x2c, 0x2c, 0x2c, 0x26, 0x29, 0x23, 0x27, 0x26, 0x25, 0x1d, 0x1f, 0x19, 0x29, 0x1d, 0x1b, 0x1e,
  0x13, 0x1d, 0x1d, 0x1a, 0x22, 0x28, 0x1d, 0x23, 0x2a, 0x1e, 0x19, 0x1f, 0x1f, 0x21, 0x21, 0x24,
  0x26, 0x23, 0x29, 0x2e, 0x2f, 0x36, 0x33, 0x2e, 0x39, 0x33, 0x2c, 0x35, 0x33, 0x39, 0x35, 0x39,
  0x3a, 0x40, 0x3c, 0x34, 0x37, 0x35, 0x37, 0x33, 0x32, 0x31, 0x2f, 0x30, 0x30, 0x31, 0x2e, 0x2d,
  0x2f, 0x1d, 0x2a, 0x30, 0x25, 0x2a, 0x2c, 0x2c, 0x28, 0x2f, 0x34, 0x3f, 0x44, 0x45, 0x42, 0x3f,
  0x3e, 0x39, 0x32, 0x2d, 0x33, 0x30, 0x33, 0x30, 0x2e, 0x2a, 0x2b, 0x23, 0x29, 0x2a, 0x27, 0x1f,
  0x1f, 0x18, 0x29, 0x1d, 0x1b, 0x1e, 0x10, 0x1c, 0x1e, 0x1a, 0x24, 0x2c, 0x1b, 0x24, 0x2c, 0x1c,
  0x16, 0x1f, 0x20, 0x23, 0x21, 0x25, 0x26, 0x23, 0x2c, 0x34, 0x33, 0x3c, 0x39, 0x32, 0x3d, 0x38,
  0x30, 0x3c, 0x39, 0x3f, 0x3b, 0x41, 0x42, 0x47, 0x44, 0x3c, 0x3f, 0x3b, 0x3e, 0x39, 0x38, 0x37,
  0x36, 0x35, 0x35, 0x37, 0x33, 0x32, 0x34, 0x24, 0x2d, 0x34, 0x27, 0x2e, 0x30, 0x2e, 0x2c, 0x35,
  0x38, 0x47, 0x4c, 0x4e, 0x49, 0x47, 0x45, 0x40, 0x37, 0x2f, 0x38, 0x35, 0x37, 0x33, 0x32, 0x2b,
  0x2f, 0x24, 0x2d, 0x2d, 0x29, 0x1f, 0x1e, 0x14, 0x2a, 0x1c, 0x19, 0x1e, 0x0c, 0x1b, 0x1e, 0x17,
  0x24, 0x2f, 0x1b, 0x25, 0x2f, 0x1b, 0x13, 0x1f, 0x1f, 0x24, 0x21, 0x26, 0x26, 0x24, 0x2f, 0x36,
  0x38, 0x42, 0x3d, 0x37, 0x44, 0x3d, 0x33, 0x43, 0x3f, 0x44, 0x40, 0x48, 0x49, 0x4e, 0x4a, 0x43,
  0x46, 0x41, 0x45, 0x3e, 0x3e, 0x3e, 0x3c, 0x3a, 0x3a, 0x3c, 0x37, 0x39, 0x3a, 0x2c, 0x30, 0x39,
  0x2a, 0x31, 0x35, 0x31, 0x2f, 0x39, 0x3e, 0x51, 0x55, 0x58, 0x53, 0x51, 0x50, 0x49, 0x43, 0x35,
  0x41, 0x40, 0x40, 0x3a, 0x38, 0x31, 0x33, 0x26, 0x35, 0x30, 0x2a, 0x20, 0x1d, 0x0f, 0x2a, 0x1b,
  0x18, 0x1e, 0x06, 0x18, 0x1c, 0x11, 0x25, 0x33, 0x19, 0x26, 0x32, 0x18, 0x0f, 0x1f, 0x1f, 0x25,
  0x22, 0x28, 0x28, 0x24, 0x32, 0x3d, 0x3e, 0x4a, 0x43, 0x3e, 0x4e, 0x47, 0x39, 0x4d, 0x47, 0x4c,
  0x4c, 0x52, 0x53, 0x55, 0x53, 0x4c, 0x4e, 0x49, 0x50, 0x47, 0x48, 0x45, 0x46, 0x45, 0x43, 0x46,
  0x40, 0x43, 0x41, 0x35, 0x34, 0x3d, 0x2d, 0x37, 0x3a, 0x35, 0x34, 0x3e, 0x43, 0x57, 0x5b, 0x5e,
  0x5a, 0x59, 0x59, 0x50, 0x4b, 0x38, 0x49, 0x49, 0x45, 0x3e, 0x3c, 0x35, 0x33, 0x29, 0x3c, 0x36,
  0x2e, 0x23, 0x1d, 0x0f, 0x2d, 0x1a, 0x16, 0x1f, 0x02, 0x16, 0x19, 0x10, 0x25, 0x33, 0x16, 0x28,
  0x33, 0x17, 0x09, 0x1d, 0x1d, 0x25, 0x21, 0x29, 0x28, 0x25, 0x34, 0x41, 0x43, 0x4f, 0x48, 0x43,
  0x54, 0x4c, 0x3c, 0x54, 0x4e, 0x54, 0x53, 0x59, 0x5b, 0x5a, 0x5a, 0x51, 0x54, 0x50, 0x57, 0x4e,
  0x4d, 0x4b, 0x4b, 0x49, 0x47, 0x4c, 0x45, 0x47, 0x44, 0x3c, 0x38, 0x41, 0x31, 0x3a, 0x3c, 0x38,
  0x37, 0x41, 0x4a, 0x5f, 0x62, 0x63, 0x62, 0x61, 0x62, 0x59, 0x55, 0x3e, 0x53, 0x52, 0x4e, 0x43,
  0x42, 0x38, 0x32, 0x2d, 0x48, 0x3c, 0x33, 0x26, 0x1e, 0x0d, 0x30, 0x1b, 0x17, 0x26, 0x00, 0x10,
  0x13, 0x0c, 0x21, 0x2f, 0x13, 0x2a, 0x2e, 0x0f, 0x05, 0x1b, 0x1e, 0x27, 0x23, 0x2c, 0x29, 0x27,
  0x38, 0x47, 0x47, 0x54, 0x4e, 0x47, 0x59, 0x52, 0x41, 0x5d, 0x54, 0x5b, 0x5a, 0x5e, 0x61, 0x60,
  0x61, 0x5a, 0x5c, 0x58, 0x5e, 0x55, 0x54, 0x52, 0x4d, 0x4e, 0x4d, 0x55, 0x4d, 0x4c, 0x47, 0x41,
  0x3b, 0x43, 0x35, 0x3e, 0x3d, 0x3b, 0x3d, 0x45, 0x50, 0x62, 0x64, 0x64, 0x64, 0x64, 0x64, 0x60,
  0x5f, 0x45, 0x5b, 0x57, 0x55, 0x4b, 0x46, 0x3c, 0x33, 0x33, 0x51, 0x43, 0x38, 0x2f, 0x24, 0x17,
  0x33, 0x18, 0x1d, 0x2c, 0x02, 0x0d, 0x0f, 0x09, 0x14, 0x2c, 0x11, 0x2c, 0x2a, 0x0d, 0x05, 0x1a,
  0x1a, 0x28, 0x25, 0x2e, 0x2b, 0x2a, 0x3c, 0x49, 0x4c, 0x56, 0x52, 0x4b, 0x5c, 0x54, 0x43, 0x62,
  0x56, 0x5e, 0x5d, 0x61, 0x63, 0x63, 0x64, 0x60, 0x62, 0x5d, 0x61, 0x5b, 0x59, 0x58, 0x4d, 0x51,
  0x52, 0x59, 0x54, 0x4e, 0x49, 0x45, 0x3f, 0x43, 0x3b, 0x41, 0x3d, 0x3e, 0x41, 0x47, 0x54, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x63, 0x61, 0x49, 0x5d, 0x5b, 0x58, 0x4e, 0x49, 0x40, 0x3a, 0x36,
  0x57, 0x49, 0x3c, 0x35, 0x29, 0x21, 0x37, 0x15, 0x21, 0x2f, 0x04, 0x09, 0x0b, 0x06, 0x0a, 0x2f,
  0x11, 0x2c, 0x2b, 0x0e, 0x07, 0x1c, 0x16, 0x29, 0x26, 0x31, 0x2c, 0x2c, 0x3e, 0x4b, 0x4d, 0x57,
  0x52, 0x4c, 0x5d, 0x55, 0x44, 0x62, 0x55, 0x5f, 0x5d, 0x62, 0x64, 0x64, 0x64, 0x62, 0x63, 0x5e,
  0x62, 0x5d, 0x5b, 0x5a, 0x4c, 0x4e, 0x53, 0x5c, 0x59, 0x4e, 0x49, 0x43, 0x42, 0x43, 0x3e, 0x41,
  0x3d, 0x41, 0x43, 0x45, 0x32, 0x36, 0x37, 0x37, 0x38, 0x3a, 0x3b, 0x39, 0x35, 0x31, 0x38, 0x37,
  0x38, 0x3a, 0x37, 0x36, 0x36, 0x35, 0x32, 0x35, 0x33, 0x30, 0x33, 0x31, 0x39, 0x34, 0x33, 0x30,
  0x30, 0x2e, 0x2d, 0x2e, 0x33, 0x2e, 0x30, 0x35, 0x33, 0x32, 0x32, 0x34, 0x35, 0x33, 0x33, 0x36,
  0x35, 0x33, 0x35, 0x35, 0x38, 0x38, 0x37, 0x31, 0x39, 0x36, 0x36, 0x35, 0x35, 0x38, 0x37, 0x38,
  0x37, 0x3d, 0x35, 0x38, 0x36, 0x39, 0x3b, 0x36, 0x36, 0x35, 0x33, 0x37, 0x32, 0x35, 0x33, 0x33,
  0x35, 0x0e, 0x34, 0x35, 0x2f, 0x2f, 0x35, 0x34, 0x34, 0x36, 0x37, 0x3c, 0x40, 0x3f, 0x3e, 0x41,
  0x3f, 0x3d, 0x37, 0x35, 0x3a, 0x39, 0x3b, 0x3a, 0x3a, 0x38, 0x38, 0x34, 0x33, 0x37, 0x35, 0x30,
  0x33, 0x31, 0x3a, 0x33, 0x32, 0x31, 0x2f, 0x2e, 0x2e, 0x2e, 0x33, 0x32, 0x31, 0x35, 0x35, 0x32,
  0x31, 0x34, 0x34, 0x32, 0x32, 0x34, 0x35, 0x33, 0x38, 0x38, 0x3a, 0x3e, 0x3c, 0x36, 0x3d, 0x3b,
  0x38, 0x3b, 0x3a, 0x3e, 0x3c, 0x3e, 0x3d, 0x43, 0x3c, 0x3d, 0x3c, 0x3e, 0x40, 0x3a, 0x3a, 0x38,
  0x37, 0x39, 0x36, 0x38, 0x35, 0x37, 0x39, 0x16, 0x35, 0x38, 0x33, 0x34, 0x38, 0x37, 0x34, 0x39,
  0x3b, 0x43, 0x45, 0x45, 0x44, 0x47, 0x43, 0x41, 0x3c, 0x38, 0x3d, 0x3b, 0x3d, 0x3c, 0x3b, 0x3a,
  0x39, 0x37, 0x37, 0x38, 0x36, 0x33, 0x36, 0x31, 0x3a, 0x32, 0x32, 0x30, 0x2d, 0x2e, 0x2f, 0x2e,
  0x35, 0x35, 0x30, 0x35, 0x37, 0x31, 0x30, 0x34, 0x34, 0x33, 0x33, 0x35, 0x36, 0x35, 0x39, 0x3c,
  0x3e, 0x42, 0x3f, 0x39, 0x42, 0x3e, 0x3c, 0x40, 0x3e, 0x42, 0x40, 0x45, 0x44, 0x4a, 0x45, 0x42,
  0x41, 0x42, 0x45, 0x3e, 0x40, 0x3d, 0x3c, 0x3c, 0x3a, 0x3e, 0x3a, 0x3c, 0x3b, 0x1d, 0x3a, 0x3b,
  0x35, 0x37, 0x3b, 0x3a, 0x37, 0x3c, 0x3f, 0x47, 0x4a, 0x4c, 0x49, 0x49, 0x47, 0x44, 0x3e, 0x3a,
  0x41, 0x3e, 0x40, 0x3d, 0x3d, 0x3a, 0x38, 0x37, 0x37, 0x3a, 0x38, 0x33, 0x34, 0x2f, 0x3a, 0x31,
  0x31, 0x30, 0x2b, 0x2d, 0x2e, 0x2d, 0x35, 0x37, 0x30, 0x36, 0x38, 0x2f, 0x2d, 0x33, 0x33, 0x32,
  0x33, 0x37, 0x37, 0x35, 0x3b, 0x3e, 0x40, 0x45, 0x42, 0x3c, 0x44, 0x41, 0x3e, 0x45, 0x42, 0x46,
  0x44, 0x4a, 0x49, 0x4e, 0x4b, 0x47, 0x47, 0x46, 0x47, 0x42, 0x41, 0x41, 0x3e, 0x3f, 0x3e, 0x41,
  0x3e, 0x3e, 0x3e, 0x24, 0x3c, 0x3d, 0x37, 0x3a, 0x3c, 0x3c, 0x39, 0x3f, 0x41, 0x4d, 0x50, 0x53,
  0x50, 0x4e, 0x4c, 0x47, 0x43, 0x3e, 0x42, 0x40, 0x43, 0x3e, 0x3d, 0x3a, 0x39, 0x37, 0x3b, 0x3a,
  0x38, 0x32, 0x32, 0x2d, 0x38, 0x2f, 0x30, 0x2f, 0x28, 0x2c, 0x2d, 0x2a, 0x34, 0x38, 0x2e, 0x36,
  0x38, 0x2e, 0x29, 0x31, 0x31, 0x34, 0x34, 0x36, 0x36, 0x37, 0x3c, 0x40, 0x43, 0x48, 0x45, 0x3f,
  0x49, 0x43, 0x3e, 0x49, 0x45, 0x49, 0x47, 0x4d, 0x4e, 0x53, 0x50, 0x4c, 0x4d, 0x4b, 0x4c, 0x46,
  0x46, 0x45, 0x43, 0x41, 0x41, 0x44, 0x40, 0x40, 0x41, 0x2c, 0x3d, 0x40, 0x38, 0x3c, 0x3d, 0x3e,
  0x3b, 0x40, 0x46, 0x55, 0x58, 0x59, 0x57, 0x54, 0x53, 0x4c, 0x49, 0x40, 0x47, 0x45, 0x45, 0x3f,
  0x3e, 0x3a, 0x37, 0x39, 0x3f, 0x3b, 0x38, 0x31, 0x2e, 0x2a, 0x36, 0x2e, 0x2d, 0x2d, 0x22, 0x27,
  0x29, 0x23, 0x30, 0x37, 0x2c, 0x35, 0x37, 0x28, 0x22, 0x2f, 0x2f, 0x35, 0x32, 0x36, 0x36, 0x36,
  0x3d, 0x44, 0x47, 0x4d, 0x49, 0x43, 0x50, 0x4a, 0x41, 0x51, 0x4b, 0x4f, 0x4e, 0x55, 0x55, 0x58,
  0x56, 0x51, 0x52, 0x4f, 0x53, 0x4c, 0x4b, 0x4a, 0x47, 0x46, 0x45, 0x4a, 0x45, 0x45, 0x43, 0x35,
  0x40, 0x40, 0x3b, 0x3f, 0x3f, 0x3f, 0x3e, 0x42, 0x4b, 0x59, 0x5d, 0x5f, 0x5b, 0x5a, 0x59, 0x52,
  0x4e, 0x43, 0x4c, 0x4b, 0x49, 0x41, 0x3f, 0x38, 0x35, 0x3a, 0x44, 0x3d, 0x37, 0x31, 0x2c, 0x28,
  0x34, 0x2a, 0x2b, 0x2a, 0x1d, 0x23, 0x22, 0x1c, 0x2d, 0x36, 0x28, 0x35, 0x35, 0x23, 0x1d, 0x2b,
  0x2c, 0x33, 0x31, 0x37, 0x35, 0x37, 0x3e, 0x46, 0x49, 0x50, 0x4b, 0x45, 0x54, 0x4e, 0x42, 0x56,
  0x50, 0x54, 0x55, 0x58, 0x5c, 0x5c, 0x5b, 0x56, 0x57, 0x54, 0x58, 0x50, 0x4f, 0x4e, 0x4a, 0x49,
  0x48, 0x4e, 0x4a, 0x47, 0x44, 0x3c, 0x42, 0x42, 0x3d, 0x41, 0x3e, 0x41, 0x40, 0x43, 0x50, 0x60,
  0x62, 0x62, 0x61, 0x61, 0x60, 0x58, 0x56, 0x47, 0x52, 0x50, 0x4d, 0x43, 0x41, 0x38, 0x33, 0x3b,
  0x49, 0x3f, 0x37, 0x2e, 0x27, 0x23, 0x30, 0x24, 0x26, 0x27, 0x15, 0x18, 0x18, 0x11, 0x23, 0x31,
  0x24, 0x34, 0x30, 0x19, 0x16, 0x28, 0x28, 0x33, 0x2f, 0x37, 0x33, 0x38, 0x40, 0x49, 0x4b, 0x53,
  0x4e, 0x48, 0x58, 0x53, 0x43, 0x5d, 0x52, 0x5a, 0x59, 0x5d, 0x61, 0x60, 0x61, 0x5c, 0x5e, 0x59,
  0x5d, 0x56, 0x53, 0x54, 0x49, 0x4c, 0x4e, 0x54, 0x4e, 0x4b, 0x45, 0x40, 0x43, 0x42, 0x3f, 0x41,
  0x3e, 0x42, 0x42, 0x44, 0x54, 0x62, 0x64, 0x64, 0x63, 0x63, 0x62, 0x5f, 0x5c, 0x4a, 0x54, 0x52,
  0x50, 0x44, 0x43, 0x3b, 0x39, 0x3d, 0x50, 0x41, 0x38, 0x2f, 0x27, 0x1f, 0x36, 0x1d, 0x23, 0x2a,
  0x0a, 0x0c, 0x0f, 0x07, 0x21, 0x32, 0x21, 0x33, 0x2e, 0x12, 0x15, 0x26, 0x21, 0x32, 0x31, 0x37,
  0x33, 0x3a, 0x41, 0x49, 0x4e, 0x55, 0x4f, 0x49, 0x5a, 0x51, 0x44, 0x60, 0x51, 0x5b, 0x5b, 0x5e,
  0x62, 0x62, 0x63, 0x5f, 0x61, 0x5b, 0x60, 0x5b, 0x57, 0x57, 0x47, 0x4b, 0x4e, 0x58, 0x53, 0x4a,
  0x45, 0x43, 0x45, 0x43, 0x41, 0x42, 0x3e, 0x44, 0x43, 0x45, 0x56, 0x63, 0x64, 0x64, 0x64, 0x63,
  0x61, 0x60, 0x5e, 0x4d, 0x55, 0x54, 0x4e, 0x45, 0x43, 0x3e, 0x3d, 0x3e, 0x52, 0x44, 0x3b, 0x32,
  0x2d, 0x1f, 0x39, 0x21, 0x26, 0x2d, 0x09, 0x08, 0x0c, 0x06, 0x25, 0x33, 0x1e, 0x32, 0x30, 0x19,
  0x10, 0x24, 0x1d, 0x31, 0x31, 0x37, 0x33, 0x3a, 0x41, 0x4a, 0x4e, 0x54, 0x4d, 0x48, 0x59, 0x4f,
  0x44, 0x60, 0x4d, 0x56, 0x5a, 0x5e, 0x62, 0x62, 0x63, 0x60, 0x62, 0x5d, 0x60, 0x5c, 0x56, 0x58,
  0x45, 0x47, 0x4c, 0x59, 0x55, 0x49, 0x44, 0x43, 0x47, 0x42, 0x43, 0x42, 0x3e, 0x44, 0x44, 0x43
};

static const unsigned char palette_19_17_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x05, 0x02, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x05, 0x03, 0x00, 0x00, 0x04,
  0x07, 0x05, 0x00, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x04, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x09, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x04, 0x02, 0x10,
  0x00, 0x01, 0x16, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x05,
  0x1c, 0x15, 0x10, 0x01, 0x04, 0x10, 0x16, 0x19, 0x00, 0x12, 0x00, 0x00, 0x09, 0x00, 0x00, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x00, 0x03, 0x02, 0x02, 0x03, 0x0a, 0x04,
  0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01,
  0x02, 0x24, 0x00, 0x00, 0x1a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x02, 0x07, 0x14, 0x06, 0x1d, 0x01, 0x04, 0x28, 0x1b, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x04, 0x0d, 0x0f, 0x29, 0x28, 0x1c, 0x03, 0x0b, 0x1b, 0x23, 0x39, 0x00, 0x2e,
  0x00, 0x03, 0x11, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1e, 0x00, 0x14, 0x32, 0x14, 0x00, 0x4b, 0x3c,
  0x28, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x32, 0x32, 0x50, 0x46, 0x00, 0x00,
  0x1e, 0x32, 0x3c, 0x64, 0x23, 0x5a, 0x28, 0x41, 0x50, 0x37, 0x3c, 0x5a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x03, 0x02, 0x00, 0x00, 0x03, 0x05, 0x01, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x02, 0x07, 0x00, 0x00, 0x0d, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x19, 0x0d, 0x09, 0x02, 0x01, 0x0d, 0x11, 0x07, 0x00, 0x0b,
  0x00, 0x00, 0x05, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00,
  0x02, 0x02, 0x04, 0x03, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x1b, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x07, 0x0d, 0x07, 0x1b, 0x02, 0x03, 0x25, 0x16,
  0x0f, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x0b, 0x0a, 0x2d, 0x24, 0x1b, 0x05,
  0x05, 0x1b, 0x23, 0x1b, 0x00, 0x23, 0x00, 0x03, 0x0d, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x02, 0x03, 0x00, 0x05, 0x04, 0x07, 0x0a, 0x15, 0x0c, 0x21, 0x00, 0x02, 0x02,
  0x02, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x02, 0x00, 0x02, 0x04, 0x02, 0x07, 0x2d, 0x00, 0x00,
  0x23, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x05, 0x10, 0x1d,
  0x0e, 0x26, 0x05, 0x09, 0x33, 0x23, 0x1a, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00, 0x01, 0x04, 0x08,
  0x17, 0x14, 0x36, 0x34, 0x29, 0x0a, 0x10, 0x27, 0x2d, 0x3e, 0x00, 0x37, 0x00, 0x07, 0x18, 0x00,
  0x02, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x05, 0x00, 0x08, 0x05, 0x0b, 0x10,
  0x1e, 0x15, 0x2f, 0x00, 0x03, 0x04, 0x04, 0x02, 0x02, 0x00, 0x0c, 0x01, 0x00, 0x03, 0x01, 0x03,
  0x07, 0x04, 0x10, 0x38, 0x00, 0x00, 0x2f, 0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x07, 0x00, 0x08, 0x19, 0x2a, 0x16, 0x2f, 0x0a, 0x0e, 0x3d, 0x2d, 0x23, 0x09, 0x03, 0x01,
  0x01, 0x00, 0x00, 0x02, 0x07, 0x0d, 0x21, 0x20, 0x3a, 0x3c, 0x33, 0x0f, 0x1d, 0x2e, 0x36, 0x54,
  0x00, 0x43, 0x00, 0x0b, 0x20, 0x01, 0x06, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x02, 0x02, 0x01, 0x00, 0x02, 0x04, 0x00, 0x00, 0x04,
  0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x04, 0x03, 0x02, 0x00,
  0x04, 0x04, 0x04, 0x06, 0x07, 0x04, 0x0a, 0x00, 0x00, 0x01, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00,
  0x00, 0x01, 0x00, 0x01, 0x02, 0x01, 0x02, 0x07, 0x00, 0x00, 0x07, 0x01, 0x01, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x05, 0x04, 0x07, 0x08, 0x02, 0x02, 0x0b, 0x08,
  0x06, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x01, 0x04, 0x02, 0x06, 0x04, 0x15, 0x0e, 0x0a, 0x04,
  0x03, 0x0e, 0x13, 0x01, 0x00, 0x0a, 0x00, 0x02, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x04, 0x07, 0x06, 0x04, 0x00, 0x08, 0x08, 0x09, 0x0a, 0x0e, 0x09, 0x11, 0x00, 0x02, 0x04,
  0x03, 0x02, 0x01, 0x00, 0x07, 0x02, 0x00, 0x02, 0x00, 0x02, 0x04, 0x02, 0x05, 0x12, 0x01, 0x00,
  0x0f, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x05, 0x00, 0x08, 0x0a, 0x0b,
  0x0e, 0x14, 0x04, 0x05, 0x1b, 0x14, 0x0f, 0x09, 0x04, 0x03, 0x01, 0x01, 0x00, 0x03, 0x09, 0x06,
  0x0d, 0x09, 0x27, 0x1a, 0x14, 0x08, 0x06, 0x1b, 0x21, 0x06, 0x00, 0x17, 0x00, 0x04, 0x10, 0x01,
  0x01, 0x13, 0x00, 0x00, 0x00, 0x02, 0x02, 0x07, 0x0d, 0x0a, 0x0a, 0x00, 0x12, 0x0e, 0x13, 0x12,
  0x1d, 0x14, 0x20, 0x00, 0x07, 0x09, 0x07, 0x03, 0x03, 0x00, 0x0f, 0x05, 0x01, 0x07, 0x00, 0x05,
  0x08, 0x06, 0x0d, 0x29, 0x02, 0x02, 0x1f, 0x06, 0x02, 0x03, 0x04, 0x01, 0x01, 0x01, 0x02, 0x00,
  0x02, 0x0c, 0x01, 0x0f, 0x16, 0x1a, 0x17, 0x29, 0x0c, 0x0f, 0x32, 0x26, 0x1d, 0x0f, 0x08, 0x05,
  0x04, 0x03, 0x01, 0x08, 0x0f, 0x0d, 0x1a, 0x17, 0x39, 0x30, 0x29, 0x12, 0x13, 0x2c, 0x32, 0x1a,
  0x01, 0x2c, 0x00, 0x0b, 0x1c, 0x02, 0x05, 0x2a, 0x00, 0x01, 0x01, 0x03, 0x03, 0x09, 0x0f, 0x10,
  0x12, 0x02, 0x19, 0x15, 0x1d, 0x1f, 0x2a, 0x23, 0x31, 0x02, 0x0d, 0x11, 0x10, 0x0b, 0x0c, 0x02,
  0x1a, 0x0b, 0x05, 0x0f, 0x02, 0x0b, 0x10, 0x0b, 0x1b, 0x37, 0x04, 0x04, 0x2f, 0x0e, 0x05, 0x08,
  0x08, 0x03, 0x03, 0x04, 0x07, 0x00, 0x04, 0x18, 0x05, 0x19, 0x28, 0x2d, 0x22, 0x33, 0x16, 0x1a,
  0x3c, 0x33, 0x2c, 0x1a, 0x0d, 0x0a, 0x08, 0x06, 0x04, 0x0d, 0x16, 0x18, 0x27, 0x26, 0x43, 0x40,
  0x36, 0x1a, 0x21, 0x37, 0x3b, 0x3a, 0x02, 0x40, 0x03, 0x15, 0x28, 0x05, 0x0c, 0x3b, 0x00, 0x02,
  0x01, 0x03, 0x04, 0x09, 0x10, 0x14, 0x17, 0x03, 0x1f, 0x19, 0x25, 0x27, 0x32, 0x2e, 0x40, 0x04,
  0x15, 0x1d, 0x1a, 0x12, 0x18, 0x07, 0x26, 0x19, 0x0a, 0x15, 0x03, 0x12, 0x19, 0x11, 0x29, 0x41,
  0x06, 0x08, 0x3b, 0x19, 0x08, 0x10, 0x0e, 0x06, 0x06, 0x07, 0x0d, 0x00, 0x08, 0x1b, 0x09, 0x22,
  0x2f, 0x39, 0x2b, 0x3e, 0x23, 0x22, 0x46, 0x3c, 0x33, 0x22, 0x11, 0x0f, 0x0a, 0x09, 0x06, 0x11,
  0x1a, 0x1f, 0x31, 0x30, 0x48, 0x47, 0x3f, 0x23, 0x2f, 0x3c, 0x43, 0x53, 0x04, 0x49, 0x06, 0x1c,
  0x31, 0x08, 0x16, 0x46, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x02, 0x01, 0x00, 0x03, 0x02,
  0x03, 0x04, 0x03, 0x02, 0x03, 0x02, 0x00, 0x02, 0x01, 0x00, 0x01, 0x01, 0x04, 0x02, 0x01, 0x01,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02,
  0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x00, 0x02, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x04, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01,
  0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x01, 0x04,
  0x05, 0x05, 0x02, 0x00, 0x04, 0x04, 0x05, 0x06, 0x06, 0x04, 0x05, 0x02, 0x01, 0x04, 0x03, 0x01,
  0x03, 0x02, 0x09, 0x03, 0x03, 0x02, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x03,
  0x03, 0x03, 0x03, 0x01, 0x01, 0x02, 0x03, 0x01, 0x03, 0x02, 0x02, 0x04, 0x03, 0x01, 0x03, 0x03,
  0x04, 0x01, 0x03, 0x04, 0x02, 0x02, 0x01, 0x04, 0x00, 0x02, 0x01, 0x04, 0x06, 0x02, 0x02, 0x01,
  0x02, 0x03, 0x01, 0x02, 0x01, 0x02, 0x03, 0x00, 0x01, 0x04, 0x00, 0x01, 0x04, 0x02, 0x01, 0x04,
  0x00, 0x01, 0x00, 0x04, 0x02, 0x09, 0x09, 0x09, 0x03, 0x01, 0x07, 0x07, 0x09, 0x0d, 0x0b, 0x09,
  0x0a, 0x02, 0x02, 0x05, 0x06, 0x03, 0x09, 0x04, 0x0e, 0x04, 0x05, 0x03, 0x04, 0x02, 0x02, 0x03,
  0x05, 0x03, 0x03, 0x03, 0x06, 0x04, 0x06, 0x05, 0x05, 0x02, 0x04, 0x03, 0x05, 0x02, 0x04, 0x05,
  0x04, 0x08, 0x07, 0x03, 0x06, 0x05, 0x07, 0x02, 0x05, 0x07, 0x04, 0x06, 0x03, 0x07, 0x02, 0x02,
  0x01, 0x08, 0x0b, 0x04, 0x07, 0x04, 0x05, 0x05, 0x03, 0x05, 0x02, 0x05, 0x06, 0x00, 0x03, 0x07,
  0x01, 0x02, 0x07, 0x04, 0x02, 0x07, 0x00, 0x02, 0x01, 0x05, 0x03, 0x0a, 0x0e, 0x0b, 0x05, 0x02,
  0x0d, 0x0c, 0x0e, 0x10, 0x11, 0x0d, 0x0e, 0x04, 0x04, 0x09, 0x0b, 0x05, 0x0b, 0x05, 0x13, 0x07,
  0x07, 0x05, 0x04, 0x04, 0x04, 0x05, 0x09, 0x07, 0x05, 0x04, 0x0a, 0x08, 0x08, 0x09, 0x07, 0x02,
  0x04, 0x05, 0x07, 0x03, 0x06, 0x08, 0x04, 0x0b, 0x0b, 0x07, 0x09, 0x0a, 0x09, 0x04, 0x0b, 0x0b,
  0x07, 0x0a, 0x05, 0x0a, 0x03, 0x04, 0x02, 0x0b, 0x0e, 0x07, 0x0a, 0x07, 0x0a, 0x0b, 0x07, 0x07,
  0x05, 0x09, 0x0e, 0x00, 0x04, 0x0d, 0x02, 0x04, 0x0b, 0x07, 0x03, 0x0d, 0x01, 0x03, 0x03, 0x09,
  0x06, 0x0d, 0x14, 0x12, 0x0a, 0x04, 0x10, 0x12, 0x15, 0x16, 0x18, 0x11, 0x17, 0x05, 0x06, 0x0d,
  0x0f, 0x08, 0x0e, 0x06, 0x18, 0x09, 0x0a, 0x06, 0x07, 0x06, 0x06, 0x07, 0x0e, 0x0b, 0x07, 0x05,
  0x0e, 0x0b, 0x0b, 0x0b, 0x0a, 0x05, 0x07, 0x06, 0x0a, 0x04, 0x07, 0x0b, 0x07, 0x12, 0x12, 0x09,
  0x10, 0x0d, 0x0f, 0x07, 0x11, 0x10, 0x0c, 0x0f, 0x07, 0x0e, 0x05, 0x07, 0x05, 0x10, 0x13, 0x0b,
  0x12, 0x0b, 0x16, 0x11, 0x0c, 0x0b, 0x07, 0x10, 0x16, 0x00, 0x05, 0x14, 0x03, 0x07, 0x11, 0x09,
  0x05, 0x12, 0x01, 0x05, 0x05, 0x0c, 0x08, 0x13, 0x1d, 0x19, 0x10, 0x05, 0x19, 0x19, 0x1e, 0x1f,
  0x23, 0x1e, 0x22, 0x07, 0x0a, 0x13, 0x14, 0x0e, 0x16, 0x0a, 0x1f, 0x10, 0x0d, 0x0d, 0x09, 0x0a,
  0x0c, 0x0c, 0x17, 0x18, 0x0d, 0x09, 0x19, 0x12, 0x0f, 0x11, 0x0d, 0x08, 0x09, 0x09, 0x0e, 0x04,
  0x0b, 0x16, 0x0d, 0x1d, 0x1e, 0x15, 0x1d, 0x1e, 0x18, 0x0f, 0x22, 0x1d, 0x17, 0x1c, 0x0d, 0x14,
  0x09, 0x0b, 0x07, 0x15, 0x1e, 0x12, 0x1b, 0x13, 0x2d, 0x20, 0x18, 0x16, 0x0f, 0x23, 0x26, 0x01,
  0x0a, 0x1f, 0x04, 0x0e, 0x1d, 0x0b, 0x08, 0x1f, 0x03, 0x08, 0x07, 0x11, 0x0d, 0x19, 0x24, 0x21,
  0x19, 0x07, 0x25, 0x26, 0x28, 0x28, 0x2c, 0x28, 0x2c, 0x0b, 0x14, 0x1c, 0x1b, 0x14, 0x1d, 0x10,
  0x27, 0x16, 0x14, 0x17, 0x0e, 0x10, 0x15, 0x12, 0x1e, 0x27, 0x11, 0x0e, 0x24, 0x18, 0x12, 0x16,
  0x14, 0x0c, 0x0e, 0x0e, 0x14, 0x06, 0x0f, 0x1e, 0x14, 0x27, 0x28, 0x1e, 0x26, 0x2d, 0x20, 0x19,
  0x33, 0x2a, 0x27, 0x27, 0x17, 0x1d, 0x0f, 0x12, 0x0b, 0x1d, 0x25, 0x1a, 0x26, 0x1f, 0x3a, 0x30,
  0x28, 0x20, 0x19, 0x30, 0x35, 0x06, 0x0d, 0x2c, 0x07, 0x16, 0x27, 0x0e, 0x0d, 0x2a, 0x04, 0x0b,
  0x0b, 0x12, 0x12, 0x20, 0x2d, 0x29, 0x25, 0x0c, 0x2f, 0x2c, 0x32, 0x33, 0x37, 0x31, 0x3a, 0x0f,
  0x1e, 0x27, 0x23, 0x1f, 0x24, 0x16, 0x31, 0x23, 0x1b, 0x1f, 0x13, 0x19, 0x21, 0x1c, 0x2e, 0x39,
  0x19, 0x14, 0x31, 0x24, 0x17, 0x22, 0x1e, 0x11, 0x12, 0x14, 0x18, 0x0a, 0x16, 0x2b, 0x1b, 0x31,
  0x35, 0x30, 0x31, 0x3e, 0x2c, 0x27, 0x42, 0x3b, 0x35, 0x2f, 0x1f, 0x23, 0x17, 0x19, 0x12, 0x24,
  0x2b, 0x24, 0x33, 0x2f, 0x46, 0x41, 0x39, 0x2a, 0x2a, 0x3e, 0x41, 0x19, 0x0f, 0x3c, 0x0d, 0x23,
  0x33, 0x12, 0x17, 0x3a, 0x07, 0x0f, 0x0d, 0x15, 0x19, 0x21, 0x31, 0x31, 0x2e, 0x11, 0x37, 0x34,
  0x3b, 0x3c, 0x43, 0x3f, 0x48, 0x1b, 0x29, 0x34, 0x33, 0x2e, 0x36, 0x24, 0x40, 0x31, 0x2f, 0x2d,
  0x1f, 0x23, 0x2a, 0x25, 0x3d, 0x42, 0x21, 0x20, 0x3d, 0x31, 0x1f, 0x2d, 0x2b, 0x18, 0x1f, 0x1e,
  0x24, 0x13, 0x21, 0x31, 0x27, 0x3b, 0x41, 0x40, 0x3c, 0x44, 0x3b, 0x34, 0x49, 0x44, 0x3e, 0x39,
  0x26, 0x2d, 0x20, 0x24, 0x1e, 0x2a, 0x31, 0x2e, 0x3e, 0x3a, 0x4f, 0x4c, 0x43, 0x33, 0x36, 0x45,
  0x48, 0x37, 0x13, 0x48, 0x18, 0x2a, 0x3b, 0x19, 0x24, 0x47, 0x0b, 0x14, 0x12, 0x17, 0x1e, 0x22,
  0x34, 0x33, 0x35, 0x17, 0x3c, 0x3a, 0x43, 0x42, 0x49, 0x48, 0x4e, 0x28, 0x31, 0x3a, 0x3c, 0x36,
  0x3e, 0x30, 0x46, 0x3d, 0x39, 0x35, 0x2b, 0x2d, 0x33, 0x30, 0x45, 0x49, 0x2d, 0x28, 0x45, 0x3c,
  0x25, 0x36, 0x32, 0x1d, 0x2a, 0x2a, 0x30, 0x16, 0x2b, 0x3b, 0x31, 0x43, 0x4a, 0x49, 0x43, 0x4b,
  0x46, 0x3b, 0x50, 0x4b, 0x46, 0x41, 0x2c, 0x34, 0x27, 0x2d, 0x26, 0x30, 0x35, 0x37, 0x45, 0x42,
  0x52, 0x51, 0x4b, 0x39, 0x41, 0x4a, 0x4d, 0x53, 0x19, 0x50, 0x22, 0x33, 0x40, 0x1c, 0x2d, 0x4d
};

// HKS K

static const unsigned char palette_19_1A_C[] =
{
  0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x1e, 0x1e,
  0x37, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x14, 0x05, 0x14, 0x2d, 0x14, 0x0a, 0x32, 0x46, 0x5a, 0x50,
  0x50, 0x64, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x55, 0x64, 0x64, 0x64, 0x46, 0x64, 0x64,
  0x50, 0x64, 0x64, 0x64, 0x64, 0x3c, 0x64, 0x50, 0x46, 0x0a, 0x3c, 0x50, 0x41, 0x3c, 0x37, 0x0f,
  0x0f, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x32, 0x0a, 0x00, 0x05, 0x0a, 0x00, 0x00, 0x00,
  0x0a, 0x0a, 0x19, 0x00, 0x00, 0x0f
};

static const unsigned char palette_19_1A_M[] =
{
  0x0a, 0x00, 0x00, 0x14, 0x1e, 0x2d, 0x3c, 0x41, 0x55, 0x2d, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x37, 0x55, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x5a,
  0x64, 0x3c, 0x32, 0x1e, 0x46, 0x55, 0x46, 0x32, 0x46, 0x1e, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
  0x00, 0x28, 0x37, 0x2d, 0x32, 0x1e, 0x3c, 0x3c, 0x5f, 0x50, 0x55, 0x4b, 0x50, 0x00, 0x08, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00
};

static const unsigned char palette_19_1A_Y[] =
{
  0x3c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x64, 0x5f, 0x64, 0x50, 0x5a, 0x46,
  0x50, 0x19, 0x55, 0x46, 0x32, 0x19, 0x14, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x00, 0x0f, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0a, 0x0a, 0x05, 0x28, 0x37,
  0x3c, 0x50, 0x46, 0x50, 0x5a, 0x41, 0x32, 0x64, 0x64, 0x46, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x5a, 0x3c, 0x64, 0x64, 0x64, 0x46, 0x46, 0x00, 0x1e, 0x1e,
  0x0f, 0x05, 0x0a, 0x19, 0x14, 0x1e
};

static const unsigned char palette_19_1A_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3c, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x1e, 0x00, 0x14, 0x32, 0x14, 0x00, 0x4b, 0x3c, 0x28, 0x0a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1e, 0x32, 0x32, 0x50, 0x46, 0x00, 0x00, 0x1e, 0x32, 0x3c, 0x64, 0x23, 0x5a,
  0x28, 0x41, 0x50, 0x37, 0x3c, 0x5a
};

// HKS N

static const unsigned char palette_19_1B_C[] =
{
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x0a,
  0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x0a, 0x23, 0x0a, 0x05, 0x28, 0x3c, 0x50, 0x3c,
  0x46, 0x5a, 0x64, 0x50, 0x5a, 0x5a, 0x64, 0x64, 0x5a, 0x5a, 0x64, 0x64, 0x64, 0x32, 0x64, 0x64,
  0x50, 0x55, 0x64, 0x64, 0x50, 0x55, 0x64, 0x3c, 0x3c, 0x0a, 0x37, 0x41, 0x2d, 0x28, 0x28, 0x14,
  0x0a, 0x00, 0x00, 0x14, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x0a, 0x23, 0x00, 0x0a, 0x0f
};

static const unsigned char palette_19_1B_M[] =
{
  0x05, 0x00, 0x00, 0x0a, 0x0f, 0x1e, 0x2d, 0x32, 0x46, 0x1e, 0x3c, 0x5a, 0x4b, 0x55, 0x64, 0x64,
  0x64, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x5a, 0x50, 0x50,
  0x50, 0x32, 0x28, 0x07, 0x3c, 0x37, 0x32, 0x1e, 0x46, 0x14, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x19, 0x1e, 0x28, 0x1e, 0x1e, 0x28, 0x32, 0x37, 0x37, 0x41, 0x46, 0x46, 0x00, 0x05, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00
};

static const unsigned char palette_19_1B_Y[] =
{
  0x3c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x23, 0x46, 0x50, 0x46, 0x46, 0x50, 0x3c,
  0x3c, 0x0f, 0x50, 0x46, 0x1e, 0x19, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x00, 0x03, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x05, 0x08, 0x0a, 0x1e, 0x2d,
  0x2d, 0x41, 0x41, 0x37, 0x46, 0x55, 0x28, 0x5a, 0x5a, 0x46, 0x5a, 0x50, 0x4b, 0x5a, 0x64, 0x64,
  0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x50, 0x5a, 0x50, 0x64, 0x64, 0x5a, 0x55, 0x00, 0x1e, 0x14,
  0x0f, 0x0a, 0x0a, 0x14, 0x14, 0x19
};

static const unsigned char palette_19_1B_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x23, 0x23, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x19, 0x1e, 0x32, 0x32, 0x1e, 0x00, 0x05, 0x1e, 0x28, 0x64, 0x23, 0x55,
  0x1e, 0x32, 0x3c, 0x28, 0x28, 0x5f
};

// HKS Z

static const unsigned char palette_19_1C_C[] =
{
  0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x05,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a, 0x23, 0x0f, 0x0a, 0x1e, 0x32, 0x5f, 0x46,
  0x46, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x64, 0x64, 0x46, 0x64, 0x64,
  0x4b, 0x55, 0x64, 0x64, 0x64, 0x5a, 0x64, 0x41, 0x46, 0x19, 0x3c, 0x4b, 0x37, 0x28, 0x28, 0x0a,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x19, 0x23, 0x28, 0x00, 0x00,
  0x0f, 0x14, 0x23, 0x0a, 0x05, 0x0f
};

static const unsigned char palette_19_1C_M[] =
{
  0x05, 0x00, 0x00, 0x0a, 0x0f, 0x19, 0x2d, 0x37, 0x41, 0x2d, 0x4b, 0x5a, 0x55, 0x5f, 0x64, 0x64,
  0x64, 0x37, 0x5a, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x5f, 0x5f, 0x64, 0x5f, 0x64, 0x55, 0x5f,
  0x64, 0x41, 0x23, 0x0a, 0x37, 0x41, 0x3c, 0x1e, 0x5a, 0x0a, 0x05, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x19, 0x23, 0x23, 0x28, 0x19, 0x32, 0x3c, 0x41, 0x46, 0x4b, 0x5f, 0x5a, 0x00, 0x0a, 0x1e,
  0x00, 0x05, 0x0a, 0x05, 0x00, 0x00
};

static const unsigned char palette_19_1C_Y[] =
{
  0x46, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x5a, 0x64, 0x5f, 0x46, 0x50, 0x23,
  0x37, 0x14, 0x50, 0x41, 0x19, 0x14, 0x05, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0a, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x19, 0x2d,
  0x28, 0x46, 0x41, 0x37, 0x55, 0x64, 0x23, 0x64, 0x5f, 0x55, 0x55, 0x5f, 0x4b, 0x50, 0x55, 0x5a,
  0x64, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5f, 0x64, 0x5a, 0x64, 0x5a, 0x00, 0x14, 0x1e,
  0x05, 0x00, 0x00, 0x0a, 0x05, 0x14
};

static const unsigned char palette_19_1C_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x23, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x00, 0x1e, 0x0f, 0x00, 0x28, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0f, 0x23, 0x19, 0x46, 0x37, 0x23, 0x0a, 0x05, 0x0f, 0x19, 0x64, 0x1e, 0x5f,
  0x14, 0x32, 0x46, 0x1e, 0x32, 0x5f
};

// HKS E

static const unsigned char palette_19_1D_C[] =
{
  0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x08, 0x0f, 0x23, 0x11, 0x07, 0x28, 0x37, 0x4b, 0x46,
  0x46, 0x50, 0x5a, 0x5a, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x64, 0x64, 0x64, 0x32, 0x5f, 0x5f,
  0x46, 0x55, 0x64, 0x64, 0x55, 0x5a, 0x64, 0x41, 0x55, 0x0a, 0x32, 0x3c, 0x37, 0x2d, 0x28, 0x05,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x19, 0x0a, 0x0a, 0x0a, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00,
  0x0a, 0x0a, 0x14, 0x0a, 0x05, 0x0f
};

static const unsigned char palette_19_1D_M[] =
{
  0x05, 0x00, 0x00, 0x08, 0x0f, 0x1e, 0x2d, 0x32, 0x41, 0x23, 0x46, 0x5a, 0x55, 0x64, 0x64, 0x64,
  0x64, 0x32, 0x50, 0x5f, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x5f, 0x5a, 0x5a, 0x50, 0x4b, 0x50,
  0x55, 0x32, 0x1e, 0x0f, 0x3c, 0x37, 0x2d, 0x16, 0x3c, 0x12, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x19, 0x1e, 0x23, 0x23, 0x1e, 0x32, 0x41, 0x41, 0x3c, 0x46, 0x46, 0x50, 0x00, 0x0a, 0x14,
  0x00, 0x00, 0x00, 0x05, 0x03, 0x00
};

static const unsigned char palette_19_1D_Y[] =
{
  0x3c, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x5a, 0x23, 0x5a, 0x50, 0x4b, 0x46, 0x50, 0x3c,
  0x3c, 0x0f, 0x46, 0x4b, 0x1e, 0x14, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0c, 0x0f, 0x05, 0x1e, 0x2d,
  0x28, 0x41, 0x41, 0x32, 0x46, 0x5a, 0x2d, 0x64, 0x55, 0x46, 0x64, 0x5a, 0x5a, 0x5f, 0x5f, 0x64,
  0x64, 0x50, 0x64, 0x64, 0x64, 0x64, 0x64, 0x50, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00, 0x1e, 0x14,
  0x0f, 0x0f, 0x0f, 0x12, 0x14, 0x1e
};

static const unsigned char palette_19_1D_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1e, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x00, 0x19, 0x00, 0x00, 0x1e, 0x23, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x0a, 0x19, 0x0a, 0x28, 0x28, 0x0f, 0x00, 0x00, 0x0f, 0x1e, 0x64, 0x19, 0x50,
  0x19, 0x2d, 0x3c, 0x1e, 0x2a, 0x46
};

// PANTONE Metalic Coated

static const unsigned char palette_19_1E_R[] =
{
  0x84, 0x8b, 0x89, 0x8a, 0x8e, 0x95, 0x8d, 0x8d, 0x8d, 0x8a, 0x89, 0x8a, 0x97, 0x9a, 0xa0, 0xa1,
  0x91, 0x99, 0x9c, 0xa3, 0x98, 0x9d, 0xa2, 0xa7, 0x92, 0x99, 0x9a, 0x9c, 0x90, 0x8f, 0x8f, 0x8f,
  0x8d, 0x8a, 0x88, 0x88, 0x83, 0x7e, 0x79, 0x71, 0x83, 0x79, 0x66, 0x5b, 0x7c, 0x5e, 0x4e, 0x3b,
  0x6d, 0x5f, 0x4c, 0x31, 0x6f, 0x5e, 0x49, 0x2b, 0x81, 0x62, 0x4c, 0x2a, 0x72, 0x62, 0x4d, 0x33,
  0x7c, 0x70, 0x60, 0x49, 0x80, 0x78, 0x6a, 0x54, 0x8a, 0x80, 0x78, 0x69, 0x8d, 0x8b, 0x89, 0x85,
  0x93, 0x92, 0x98, 0xa1, 0x91, 0x96, 0x9b, 0x9d, 0x81, 0x76, 0x69, 0x5c, 0x91, 0x7d, 0x74, 0x69,
  0x9a, 0x9e, 0xa2, 0xaa, 0x89, 0x85, 0x7f, 0x77, 0x45, 0x4c, 0x35, 0x1f, 0x70, 0x5e, 0x4b, 0x33,
  0x78, 0x55, 0x46, 0x35, 0x83, 0x6d, 0x63, 0x60, 0x7f, 0x79, 0x71, 0x70, 0x93, 0x84, 0x7e, 0x6e,
  0x5d, 0x50, 0x42, 0x34, 0x78, 0x69, 0x59, 0x4e, 0x9a, 0xa3, 0xac, 0xac, 0x8d, 0x89, 0x85, 0x7e,
  0x7d, 0x78, 0x6e, 0x65, 0x72, 0x6a, 0x5a, 0x43, 0x56, 0x5d, 0x46, 0x2e, 0x4d, 0x34, 0x35, 0x00,
  0x2e, 0x00, 0x35, 0x06, 0x46, 0x3c, 0x3a, 0x2a, 0x5b, 0x55, 0x47, 0x4e, 0x86, 0x85, 0x6a, 0x62,
  0x8b, 0x8b, 0x8d, 0x84, 0x9a, 0x93, 0x95, 0x96, 0x98, 0x9d, 0xa3, 0xaa, 0xa4, 0xb6, 0xb8, 0xbb,
  0xa0, 0xb3, 0xb6, 0xb7, 0xa1, 0xac, 0xae, 0xc1, 0x96, 0xa2, 0xb3, 0xbf, 0x89, 0xa7, 0xaa, 0x9f,
  0xa3, 0xa3, 0xa0, 0xa2, 0xa1, 0x8e, 0x8e, 0x89, 0x87, 0x72, 0x70, 0x58, 0x52, 0x31, 0x2b, 0x3f,
  0x3d, 0x11, 0x00, 0x42, 0x3f, 0x21, 0x1c, 0x58, 0x55, 0x61, 0x5f, 0x75, 0x72, 0x83, 0x82, 0x9f,
  0xa2, 0xa4, 0xa4, 0x56, 0x52, 0x62, 0x5f, 0xac, 0xad, 0x74, 0x71, 0x25, 0x2c, 0x37, 0x3c, 0x3c,
  0x43, 0x64, 0x60, 0x78, 0x78, 0x6b, 0x76, 0x39, 0x3f, 0x44, 0x47, 0xa6, 0xa0, 0x83, 0x83, 0x61,
  0x64, 0x49, 0x4e, 0x37, 0x3d, 0x00, 0x16, 0x1a, 0x26, 0x2f, 0x33, 0x54, 0x58, 0x66, 0x6a, 0x84,
  0x84, 0x93, 0x90, 0xa7, 0xa2, 0xb7, 0xb3, 0xb2, 0xac, 0xbb, 0xb7, 0xaa, 0xa3
};

static const unsigned char palette_19_1E_G[] =
{
  0x76, 0x73, 0x6e, 0x6f, 0x6d, 0x69, 0x90, 0x8c, 0x86, 0x7e, 0x79, 0x74, 0x81, 0x7a, 0x71, 0x66,
  0x88, 0x81, 0x79, 0x70, 0x82, 0x7b, 0x71, 0x66, 0x82, 0x6a, 0x5d, 0x4e, 0x76, 0x69, 0x5a, 0x4c,
  0x82, 0x75, 0x69, 0x5b, 0x76, 0x6a, 0x5e, 0x50, 0x84, 0x79, 0x61, 0x54, 0x88, 0x78, 0x6e, 0x62,
  0x88, 0x83, 0x7e, 0x77, 0x8c, 0x8a, 0x86, 0x80, 0x90, 0x8e, 0x8b, 0x8a, 0x8f, 0x8b, 0x88, 0x84,
  0x97, 0x97, 0x9a, 0x9c, 0x96, 0x99, 0x9a, 0x93, 0x92, 0x96, 0x98, 0x93, 0x95, 0x95, 0x97, 0x99,
  0x94, 0x92, 0x95, 0x9b, 0x90, 0x90, 0x8e, 0x89, 0x81, 0x75, 0x68, 0x5b, 0x8b, 0x79, 0x6d, 0x60,
  0x83, 0x7b, 0x71, 0x67, 0x83, 0x77, 0x6a, 0x5e, 0x65, 0x60, 0x57, 0x48, 0x7f, 0x7d, 0x64, 0x41,
  0x76, 0x58, 0x4f, 0x41, 0x4c, 0x45, 0x32, 0x34, 0x56, 0x4a, 0x3f, 0x43, 0x6d, 0x5e, 0x56, 0x46,
  0x5a, 0x48, 0x3f, 0x34, 0x63, 0x56, 0x48, 0x44, 0x7c, 0x84, 0x8b, 0x87, 0x75, 0x79, 0x7d, 0x81,
  0x78, 0x7a, 0x7f, 0x8f, 0x75, 0x7b, 0x7f, 0x82, 0x73, 0x7a, 0x78, 0x86, 0x6c, 0x6e, 0x6f, 0x71,
  0x6d, 0x66, 0x5e, 0x57, 0x3f, 0x43, 0x3c, 0x3a, 0x39, 0x3b, 0x2d, 0x2b, 0x41, 0x33, 0x37, 0x2a,
  0x41, 0x33, 0x22, 0x22, 0x50, 0x43, 0x37, 0x27, 0x54, 0x47, 0x3b, 0x3e, 0x5b, 0x5b, 0x5c, 0x4f,
  0x66, 0x59, 0x53, 0x4e, 0x68, 0x66, 0x5c, 0x60, 0x6e, 0x68, 0x73, 0x6d, 0x70, 0x5b, 0x55, 0x63,
  0x5d, 0x64, 0x5d, 0x41, 0x37, 0x3b, 0x33, 0x4e, 0x46, 0x4f, 0x4a, 0x49, 0x3e, 0x59, 0x52, 0x75,
  0x6f, 0x79, 0x72, 0x7f, 0x78, 0x79, 0x6d, 0x93, 0x8e, 0x8c, 0x86, 0x92, 0x8c, 0x91, 0x8d, 0x91,
  0x8f, 0x82, 0x7c, 0x50, 0x49, 0x55, 0x4f, 0x5b, 0x53, 0x53, 0x4c, 0x56, 0x5d, 0x4e, 0x56, 0x4c,
  0x55, 0x3e, 0x43, 0x4f, 0x55, 0x49, 0x55, 0x3f, 0x48, 0x3d, 0x42, 0x8c, 0x8e, 0x8e, 0x91, 0x8a,
  0x8d, 0x88, 0x8a, 0x92, 0x93, 0x7a, 0x7f, 0x62, 0x69, 0x45, 0x4e, 0x38, 0x41, 0x37, 0x41, 0x30,
  0x3d, 0x35, 0x40, 0x49, 0x4f, 0x58, 0x5f, 0x56, 0x5b, 0x64, 0x68, 0x65, 0x69
};

static const unsigned char palette_19_1E_B[] =
{
  0x4d, 0x4a, 0x4b, 0x4c, 0x4f, 0x4c, 0x92, 0x8a, 0x7d, 0x70, 0x66, 0x5a, 0x76, 0x6a, 0x5b, 0x4c,
  0x87, 0x7c, 0x71, 0x63, 0x8c, 0x88, 0x7f, 0x75, 0x94, 0x90, 0x8b, 0x85, 0x95, 0x92, 0x8f, 0x8c,
  0x98, 0x95, 0x94, 0x94, 0x98, 0x98, 0x99, 0x96, 0x95, 0x97, 0x97, 0x98, 0x97, 0x9c, 0x9f, 0xa1,
  0x9a, 0x9c, 0x9f, 0xa3, 0x9a, 0x9e, 0xa1, 0xa1, 0x98, 0x9c, 0x9b, 0x9f, 0x98, 0x95, 0x93, 0x90,
  0x97, 0x95, 0x94, 0x93, 0x8e, 0x8b, 0x82, 0x72, 0x8c, 0x7a, 0x6e, 0x5e, 0x7d, 0x70, 0x62, 0x52,
  0x78, 0x6b, 0x5c, 0x4b, 0x85, 0x77, 0x68, 0x58, 0x82, 0x75, 0x66, 0x59, 0x8d, 0x7a, 0x6e, 0x60,
  0x87, 0x7d, 0x72, 0x67, 0x8d, 0x84, 0x7a, 0x6e, 0x80, 0x7e, 0x72, 0x6b, 0x7c, 0x75, 0x6b, 0x4c,
  0x5d, 0x49, 0x45, 0x3a, 0x4d, 0x47, 0x38, 0x47, 0x49, 0x4a, 0x44, 0x3c, 0x41, 0x3b, 0x33, 0x27,
  0x59, 0x47, 0x44, 0x3e, 0x4d, 0x44, 0x39, 0x3c, 0x38, 0x2c, 0x1a, 0x00, 0x35, 0x1d, 0x1e, 0x0d,
  0x47, 0x38, 0x30, 0x31, 0x4d, 0x46, 0x44, 0x40, 0x5a, 0x5b, 0x5a, 0x61, 0x63, 0x61, 0x65, 0x71,
  0x70, 0x73, 0x68, 0x6f, 0x5f, 0x63, 0x7b, 0x6e, 0x5f, 0x5f, 0x60, 0x60, 0x5c, 0x5f, 0x5c, 0x65,
  0x53, 0x54, 0x5b, 0x63, 0x51, 0x4e, 0x4b, 0x42, 0x59, 0x5b, 0x5f, 0x50, 0x43, 0x49, 0x5c, 0x51,
  0x4e, 0x33, 0x17, 0x23, 0x37, 0x2d, 0x1c, 0x14, 0x32, 0x27, 0x00, 0x10, 0x54, 0x38, 0x2a, 0x4f,
  0x44, 0x6a, 0x5d, 0x78, 0x69, 0x79, 0x6d, 0x85, 0x7a, 0x83, 0x79, 0x90, 0x81, 0x95, 0x8c, 0x90,
  0x85, 0x93, 0x87, 0x86, 0x79, 0x7c, 0x6a, 0x82, 0x77, 0x68, 0x5d, 0x5b, 0x4f, 0x3e, 0x2e, 0x46,
  0x3d, 0x44, 0x39, 0x4a, 0x42, 0x50, 0x49, 0x53, 0x45, 0x5f, 0x56, 0x82, 0x8a, 0x5f, 0x6b, 0x4a,
  0x55, 0x54, 0x55, 0x4e, 0x56, 0x30, 0x3d, 0x4e, 0x5a, 0x36, 0x3d, 0x24, 0x35, 0x2c, 0x3b, 0x3b,
  0x49, 0x53, 0x5e, 0x77, 0x7e, 0x82, 0x8b, 0x80, 0x8a, 0x7c, 0x8a, 0x73, 0x7d, 0x75, 0x82, 0x72,
  0x7d, 0x54, 0x61, 0x5e, 0x65, 0x60, 0x6b, 0x37, 0x43, 0x28, 0x35, 0x26, 0x34
};

// PANTONE Pastel Coated

static const unsigned char palette_19_1F_R[] =
{
  0xf0, 0xfb, 0xf0, 0xc7, 0x7e, 0xa2, 0xa5, 0xf0, 0xed, 0xef, 0xec, 0xe7, 0xdb, 0xe2, 0xe5, 0xe8,
  0xed, 0xef, 0xea, 0xed, 0xe4, 0xe6, 0xe2, 0xe0, 0xd9, 0xd6, 0xd3, 0xd1, 0xf0, 0xe8, 0xe4, 0xef,
  0xf0, 0xe4, 0xd9, 0xf0, 0xf1, 0xea, 0xf1, 0xe7, 0xe2, 0xd9, 0xf2, 0xf2, 0xf2, 0xe9, 0xe4, 0xeb,
  0xe1, 0xf2, 0xed, 0xf3, 0xe5, 0xe3, 0xde, 0xdd, 0xf1, 0xef, 0xed, 0xe7, 0xed, 0xe7, 0xe1, 0xf1,
  0xed, 0xef, 0xe5, 0xe4, 0xe9, 0xe4, 0xe8, 0xe2, 0xde, 0xd9, 0xe1, 0xd9, 0xdd, 0xd1, 0xdc, 0xd1,
  0xca, 0xce, 0xd8, 0xcc, 0xd3, 0xd3, 0xc9, 0xce, 0xcc, 0xca, 0xbf, 0xd8, 0xc6, 0xc0, 0xbd, 0xba,
  0xb9, 0xb9, 0xd0, 0xc6, 0xc5, 0xc3, 0xb8, 0xc8, 0xbf, 0xdd, 0xd9, 0xd7, 0xd6, 0xd3, 0xca, 0xc6,
  0xe0, 0xe1, 0xd9, 0xd6, 0xd5, 0xce, 0xc9, 0xe7, 0xe4, 0xdf, 0xd8, 0xdc, 0xd9, 0xd0, 0xf6, 0xef,
  0xd1, 0x9d, 0xb8, 0xb4, 0xef, 0xf0, 0xed, 0xed, 0xec, 0xe4, 0xef, 0xee, 0xeb, 0xf0, 0xf3, 0xda,
  0xcc, 0xc9, 0xc9, 0xc7, 0xc6, 0xe8, 0xe7, 0xe6, 0xda, 0xd9
};

static const unsigned char palette_19_1F_G[] =
{
  0xf0, 0xba, 0xbd, 0xa8, 0xd3, 0xe7, 0xa0, 0xee, 0xed, 0xe4, 0xe4, 0xe0, 0xe9, 0xeb, 0xe7, 0xe7,
  0xed, 0xed, 0xee, 0xef, 0xe3, 0xe7, 0xe4, 0xdd, 0xdc, 0xd9, 0xd0, 0xcd, 0xeb, 0xe4, 0xe0, 0xee,
  0xee, 0xe2, 0xd7, 0xe6, 0xe4, 0xde, 0xe6, 0xdf, 0xdb, 0xd1, 0xe1, 0xe3, 0xe0, 0xd7, 0xda, 0xdf,
  0xd4, 0xe4, 0xdb, 0xdf, 0xd4, 0xd5, 0xd3, 0xcc, 0xe5, 0xdd, 0xdb, 0xd7, 0xd5, 0xd1, 0xce, 0xde,
  0xd9, 0xdf, 0xcb, 0xd3, 0xd5, 0xcf, 0xe0, 0xd9, 0xd5, 0xce, 0xdb, 0xd2, 0xcb, 0xe0, 0xe0, 0xd6,
  0xd0, 0xd3, 0xd2, 0xc5, 0xe0, 0xdf, 0xd6, 0xe1, 0xde, 0xdb, 0xd1, 0xea, 0xe3, 0xe1, 0xe0, 0xdb,
  0xd5, 0xdb, 0xe9, 0xe7, 0xe4, 0xea, 0xe0, 0xdc, 0xda, 0xea, 0xed, 0xe9, 0xe5, 0xe0, 0xe0, 0xda,
  0xee, 0xee, 0xe7, 0xe1, 0xdd, 0xdb, 0xd7, 0xec, 0xee, 0xe7, 0xdc, 0xde, 0xda, 0xd6, 0xcd, 0xcd,
  0xba, 0xda, 0xe8, 0xad, 0xef, 0xec, 0xea, 0xe6, 0xe4, 0xda, 0xe9, 0xe5, 0xe5, 0xe9, 0xdf, 0xdf,
  0xd2, 0xe4, 0xe0, 0xdd, 0xd9, 0xef, 0xee, 0xe9, 0xe0, 0xda
};

static const unsigned char palette_19_1F_B[] =
{
  0xb3, 0xc6, 0xe1, 0xe2, 0xeb, 0xd9, 0x97, 0xd0, 0xd1, 0xe2, 0xe5, 0xe7, 0xe8, 0xe5, 0xe2, 0xe2,
  0xe3, 0xea, 0xea, 0xea, 0xde, 0xe1, 0xde, 0xd6, 0xd6, 0xd5, 0xc8, 0xc6, 0xc7, 0xc8, 0xcc, 0xc2,
  0xb7, 0xbf, 0xb6, 0xd4, 0xcf, 0xcc, 0xc7, 0xc3, 0xc6, 0xbb, 0xcd, 0xd0, 0xd0, 0xc7, 0xc9, 0xce,
  0xc2, 0xdd, 0xd4, 0xdb, 0xcc, 0xc7, 0xc6, 0xc4, 0xe5, 0xde, 0xdb, 0xd6, 0xd1, 0xcd, 0xc9, 0xe3,
  0xde, 0xe8, 0xd1, 0xd5, 0xdf, 0xd9, 0xea, 0xe3, 0xdf, 0xdb, 0xe9, 0xe4, 0xd2, 0xea, 0xea, 0xe5,
  0xe3, 0xe1, 0xdf, 0xd4, 0xeb, 0xe7, 0xe1, 0xea, 0xe7, 0xe2, 0xd9, 0xed, 0xeb, 0xe6, 0xeb, 0xe5,
  0xdd, 0xe0, 0xe8, 0xe8, 0xe3, 0xe7, 0xdd, 0xda, 0xdd, 0xe0, 0xe7, 0xe1, 0xde, 0xd9, 0xdc, 0xd5,
  0xe4, 0xdd, 0xd4, 0xd1, 0xce, 0xce, 0xca, 0xca, 0xd4, 0xd0, 0xc9, 0xc4, 0xc5, 0xbe, 0xd5, 0xe4,
  0xe5, 0xeb, 0xdd, 0xa4, 0xe7, 0xe9, 0xea, 0xd6, 0xd6, 0xcd, 0xdf, 0xd8, 0xdb, 0xe4, 0xe0, 0xea,
  0xdc, 0xe6, 0xdd, 0xd8, 0xd5, 0xe5, 0xde, 0xd2, 0xca, 0xc8
};

// PANTONE Pastel Uncoated

static const unsigned char palette_19_20_R[] =
{
  0xf8, 0xff, 0xf6, 0xb8, 0x63, 0x71, 0x9a, 0xf9, 0xf3, 0xf7, 0xf4, 0xee, 0xdd, 0xe2, 0xe7, 0xeb,
  0xf7, 0xf8, 0xec, 0xf2, 0xe0, 0xeb, 0xdf, 0xde, 0xcd, 0xc6, 0xd2, 0xc8, 0xfa, 0xed, 0xe4, 0xf9,
  0xfa, 0xe6, 0xd4, 0xfa, 0xfc, 0xf1, 0xfb, 0xec, 0xe1, 0xd6, 0xfc, 0xfd, 0xfc, 0xf0, 0xea, 0xef,
  0xe3, 0xfb, 0xf5, 0xfb, 0xeb, 0xe7, 0xe0, 0xe2, 0xfb, 0xf7, 0xf0, 0xe7, 0xf5, 0xec, 0xe3, 0xfa,
  0xf4, 0xf8, 0xe9, 0xdf, 0xf2, 0xec, 0xf0, 0xe8, 0xe4, 0xdf, 0xe3, 0xda, 0xdc, 0xdf, 0xd9, 0xc8,
  0xc6, 0xbf, 0xd0, 0xcb, 0xcc, 0xb9, 0xba, 0xc2, 0xba, 0xb6, 0xb4, 0xc4, 0xba, 0xac, 0xb5, 0xa2,
  0xa4, 0xa0, 0xc7, 0xba, 0xb2, 0xb4, 0xa8, 0xb3, 0xaf, 0xd3, 0xd1, 0xce, 0xc3, 0xc4, 0xb4, 0xb0,
  0xd7, 0xe0, 0xd2, 0xcb, 0xc3, 0xc2, 0xb8, 0xed, 0xe9, 0xe1, 0xd1, 0xdc, 0xcd, 0xcb, 0xff, 0xf8,
  0xd1, 0x8e, 0xb2, 0xbe, 0xf7, 0xf9, 0xf3, 0xf6, 0xf5, 0xe9, 0xf9, 0xf6, 0xf2, 0xf9, 0xfc, 0xd9,
  0xca, 0xc9, 0xbc, 0xbc, 0xb9, 0xed, 0xee, 0xed, 0xe0, 0xd5
};

static const unsigned char palette_19_20_G[] =
{
  0xf6, 0xb1, 0xab, 0x94, 0xcf, 0xe6, 0x96, 0xf4, 0xf3, 0xea, 0xe9, 0xe6, 0xf0, 0xf2, 0xeb, 0xea,
  0xf7, 0xf2, 0xf5, 0xf7, 0xdd, 0xec, 0xe2, 0xdb, 0xd1, 0xcb, 0xce, 0xc3, 0xf3, 0xe6, 0xde, 0xf7,
  0xf7, 0xe4, 0xd0, 0xec, 0xe6, 0xe0, 0xeb, 0xdf, 0xd6, 0xcb, 0xe3, 0xe0, 0xe2, 0xd8, 0xdd, 0xdb,
  0xd2, 0xe8, 0xde, 0xe4, 0xd5, 0xd5, 0xd1, 0xcf, 0xeb, 0xdf, 0xd3, 0xcd, 0xd7, 0xcf, 0xcb, 0xe7,
  0xdb, 0xe1, 0xc9, 0xc4, 0xde, 0xd4, 0xe9, 0xde, 0xd8, 0xd2, 0xdb, 0xd2, 0xc3, 0xec, 0xe0, 0xcf,
  0xcd, 0xc6, 0xc7, 0xc2, 0xe0, 0xd1, 0xce, 0xe0, 0xd8, 0xd2, 0xcb, 0xec, 0xe4, 0xe0, 0xe2, 0xd3,
  0xcb, 0xd4, 0xef, 0xec, 0xe2, 0xed, 0xdf, 0xd3, 0xd4, 0xec, 0xf4, 0xec, 0xe0, 0xda, 0xd9, 0xcf,
  0xf5, 0xf6, 0xea, 0xde, 0xd1, 0xd5, 0xcd, 0xf4, 0xf7, 0xec, 0xd7, 0xdf, 0xce, 0xd4, 0xd2, 0xcf,
  0xb7, 0xdd, 0xf0, 0xb9, 0xf7, 0xf2, 0xee, 0xef, 0xed, 0xdc, 0xf0, 0xeb, 0xea, 0xf0, 0xe6, 0xe0,
  0xd2, 0xe9, 0xdf, 0xdb, 0xd5, 0xf7, 0xf7, 0xf0, 0xe7, 0xd7
};

static const unsigned char palette_19_20_B[] =
{
  0xa2, 0xbe, 0xdd, 0xde, 0xef, 0xcf, 0x90, 0xc2, 0xc4, 0xe9, 0xec, 0xee, 0xf0, 0xe9, 0xe5, 0xe4,
  0xe7, 0xee, 0xef, 0xee, 0xd6, 0xe5, 0xdd, 0xd2, 0xcc, 0xc7, 0xc6, 0xbc, 0xc1, 0xc0, 0xc3, 0xbe,
  0xb2, 0xb8, 0xab, 0xd5, 0xcb, 0xcb, 0xc3, 0xbd, 0xba, 0xb4, 0xc9, 0xc3, 0xcf, 0xc7, 0xca, 0xc5,
  0xbd, 0xe0, 0xd7, 0xe0, 0xcd, 0xc5, 0xc4, 0xc7, 0xeb, 0xe1, 0xd6, 0xce, 0xd4, 0xcc, 0xc7, 0xec,
  0xe2, 0xef, 0xd2, 0xca, 0xe9, 0xe0, 0xf2, 0xea, 0xe5, 0xe1, 0xf0, 0xea, 0xce, 0xf4, 0xf2, 0xe9,
  0xe8, 0xde, 0xdd, 0xd6, 0xf2, 0xe7, 0xe0, 0xf1, 0xea, 0xe0, 0xd7, 0xf3, 0xf2, 0xea, 0xf2, 0xe4,
  0xda, 0xde, 0xf0, 0xef, 0xe3, 0xea, 0xdc, 0xd2, 0xda, 0xdc, 0xe9, 0xe2, 0xd6, 0xd1, 0xd4, 0xc9,
  0xe3, 0xdc, 0xd0, 0xc6, 0xbc, 0xc4, 0xbc, 0xcc, 0xd8, 0xcf, 0xbf, 0xc0, 0xb3, 0xb8, 0xd9, 0xeb,
  0xea, 0xf2, 0xe2, 0xb1, 0xea, 0xed, 0xef, 0xdf, 0xdf, 0xce, 0xe4, 0xdc, 0xdf, 0xea, 0xe8, 0xf1,
  0xdf, 0xed, 0xdd, 0xd6, 0xd0, 0xea, 0xe7, 0xd7, 0xd0, 0xc2
};

// PANTONE Solid Matte

static const unsigned char palette_19_23_C[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2b, 0x5c, 0x64, 0x64, 0x64, 0x5f, 0x38, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x5d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x07, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x0f, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0e, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x01, 0x02, 0x01, 0x00, 0x05,
  0x08, 0x11, 0x01, 0x04, 0x05, 0x00, 0x06, 0x0f, 0x18, 0x01, 0x03, 0x06, 0x09, 0x0c, 0x12, 0x13,
  0x03, 0x06, 0x0e, 0x12, 0x15, 0x21, 0x1f, 0x03, 0x10, 0x1a, 0x1d, 0x26, 0x27, 0x28, 0x05, 0x0b,
  0x13, 0x22, 0x25, 0x2d, 0x2b, 0x07, 0x10, 0x1f, 0x2b, 0x2e, 0x34, 0x37, 0x09, 0x13, 0x32, 0x45,
  0x42, 0x3e, 0x39, 0x14, 0x1e, 0x32, 0x3d, 0x44, 0x46, 0x41, 0x17, 0x24, 0x30, 0x43, 0x49, 0x4a,
  0x4a, 0x1e, 0x2c, 0x42, 0x4e, 0x54, 0x54, 0x54, 0x0c, 0x1b, 0x38, 0x52, 0x56, 0x56, 0x50, 0x19,
  0x26, 0x35, 0x43, 0x5c, 0x5c, 0x5a, 0x1f, 0x30, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x27, 0x38, 0x4c,
  0x64, 0x64, 0x64, 0x64, 0x15, 0x2a, 0x54, 0x64, 0x64, 0x64, 0x64, 0x15, 0x22, 0x4b, 0x64, 0x64,
  0x64, 0x64, 0x1c, 0x44, 0x60, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c, 0x46, 0x64, 0x64, 0x64, 0x64,
  0x28, 0x3a, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x18, 0x24, 0x3a, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x3d,
  0x54, 0x64, 0x64, 0x64, 0x64, 0x33, 0x44, 0x56, 0x64, 0x64, 0x64, 0x64, 0x23, 0x3c, 0x57, 0x64,
  0x64, 0x64, 0x64, 0x24, 0x39, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x30, 0x44, 0x5e, 0x64, 0x64, 0x64,
  0x64, 0x32, 0x45, 0x59, 0x64, 0x64, 0x64, 0x64, 0x18, 0x29, 0x3e, 0x64, 0x64, 0x64, 0x64, 0x25,
  0x36, 0x55, 0x64, 0x64, 0x64, 0x5f, 0x2e, 0x36, 0x4e, 0x62, 0x64, 0x64, 0x5e, 0x2d, 0x37, 0x4c,
  0x5e, 0x61, 0x64, 0x5c, 0x2f, 0x3f, 0x59, 0x64, 0x64, 0x64, 0x64, 0x1b, 0x21, 0x38, 0x5f, 0x64,
  0x64, 0x64, 0x28, 0x31, 0x54, 0x64, 0x64, 0x64, 0x5f, 0x28, 0x36, 0x4a, 0x5a, 0x64, 0x64, 0x5f,
  0x21, 0x2b, 0x38, 0x60, 0x64, 0x5e, 0x50, 0x22, 0x25, 0x2e, 0x59, 0x5f, 0x5f, 0x53, 0x26, 0x2a,
  0x3e, 0x4b, 0x4e, 0x4e, 0x49, 0x16, 0x1d, 0x25, 0x3f, 0x43, 0x40, 0x35, 0x10, 0x14, 0x1b, 0x2f,
  0x35, 0x33, 0x2b, 0x0a, 0x0f, 0x17, 0x1c, 0x1a, 0x18, 0x16, 0x06, 0x0a, 0x0e, 0x17, 0x18, 0x14,
  0x14, 0x03, 0x03, 0x07, 0x0b, 0x0a, 0x0b, 0x0e, 0x01, 0x01, 0x04, 0x06, 0x06, 0x0b, 0x11, 0x05,
  0x08, 0x0a, 0x0e, 0x12, 0x17, 0x38, 0x05, 0x08, 0x0b, 0x10, 0x13, 0x1b, 0x35, 0x08, 0x0d, 0x11,
  0x16, 0x1c, 0x21, 0x57, 0x06, 0x0c, 0x10, 0x15, 0x1e, 0x26, 0x5b, 0x07, 0x0c, 0x15, 0x21, 0x2d,
  0x43, 0x5a, 0x05, 0x09, 0x0e, 0x15, 0x25, 0x29, 0x34, 0x12, 0x17, 0x1d, 0x26, 0x32, 0x34, 0x37,
  0x02, 0x04, 0x06, 0x09, 0x0b, 0x00, 0x00, 0x0b, 0x0e, 0x10, 0x11, 0x14, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x48, 0x28, 0x25,
  0x64, 0x33, 0x00, 0x1e, 0x20, 0x1f, 0x11, 0x0c, 0x0a, 0x07, 0x18, 0x10, 0x0d, 0x08, 0x06, 0x05,
  0x03, 0x15, 0x09, 0x06, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x11, 0x0d, 0x07, 0x05, 0x03, 0x02, 0x1d,
  0x0d, 0x08, 0x06, 0x04, 0x02, 0x01, 0x15, 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x11, 0x0d,
  0x09, 0x06, 0x04, 0x03, 0x20, 0x19, 0x13, 0x09, 0x04, 0x03, 0x02, 0x14, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1d, 0x0f, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x20, 0x17, 0x13, 0x05, 0x00, 0x00, 0x00,
  0x24, 0x10, 0x0b, 0x08, 0x03, 0x02, 0x01, 0x1e, 0x14, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x2e, 0x37,
  0x38, 0x11, 0x09, 0x04, 0x02, 0x34, 0x2d, 0x25, 0x1b, 0x0d, 0x06, 0x04, 0x38, 0x40, 0x42, 0x23,
  0x17, 0x10, 0x0b, 0x34, 0x2a, 0x1b, 0x0f, 0x09, 0x05, 0x02, 0x47, 0x4c, 0x4b, 0x28, 0x19, 0x0d,
  0x0a, 0x61, 0x54, 0x49, 0x30, 0x1b, 0x13, 0x0a, 0x54, 0x5f, 0x5f, 0x2b, 0x22, 0x15, 0x0e, 0x64,
  0x64, 0x64, 0x40, 0x27, 0x1b, 0x15, 0x64, 0x47, 0x39, 0x2c, 0x1c, 0x15, 0x10, 0x64, 0x64, 0x64,
  0x3b, 0x2b, 0x23, 0x16, 0x64, 0x53, 0x3e, 0x2e, 0x27, 0x1c, 0x13, 0x55, 0x40, 0x2e, 0x23, 0x1a,
  0x12, 0x0d, 0x51, 0x53, 0x52, 0x33, 0x29, 0x20, 0x17, 0x53, 0x3c, 0x2f, 0x27, 0x1f, 0x16, 0x0e,
  0x51, 0x53, 0x53, 0x34, 0x29, 0x20, 0x11, 0x52, 0x30, 0x29, 0x1d, 0x16, 0x11, 0x0c, 0x57, 0x59,
  0x56, 0x32, 0x23, 0x1d, 0x16, 0x36, 0x39, 0x34, 0x21, 0x1b, 0x17, 0x10, 0x34, 0x28, 0x24, 0x1c,
  0x14, 0x10, 0x0a, 0x31, 0x23, 0x1e, 0x16, 0x0e, 0x0a, 0x07, 0x1a, 0x16, 0x19, 0x0f, 0x0a, 0x08,
  0x05, 0x20, 0x15, 0x0f, 0x0e, 0x0a, 0x07, 0x05, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x01,
  0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x03, 0x04, 0x05, 0x07, 0x0b, 0x0d, 0x0f, 0x0c, 0x19, 0x24,
  0x2f, 0x3d, 0x4f, 0x5e, 0x14, 0x25, 0x31, 0x49, 0x5d, 0x64, 0x64, 0x1e, 0x26, 0x41, 0x59, 0x64,
  0x64, 0x64, 0x0d, 0x15, 0x29, 0x37, 0x49, 0x60, 0x64, 0x0a, 0x12, 0x28, 0x3e, 0x60, 0x64, 0x64,
  0x0a, 0x17, 0x27, 0x3c, 0x5b, 0x64, 0x64, 0x04, 0x05, 0x14, 0x28, 0x3b, 0x4a, 0x5a, 0x01, 0x02,
  0x04, 0x08, 0x0e, 0x0f, 0x09, 0x02, 0x03, 0x04, 0x0a, 0x12, 0x1b, 0x17, 0x02, 0x03, 0x05, 0x0a,
  0x12, 0x1b, 0x19, 0x00, 0x01, 0x02, 0x04, 0x07, 0x0c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x05, 0x07, 0x0b, 0x01, 0x02, 0x03, 0x07, 0x0a, 0x0c, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x03, 0x08,
  0x07, 0x0f, 0x00, 0x00, 0x00, 0x04, 0x05, 0x07, 0x12, 0x02, 0x02, 0x03, 0x07, 0x07, 0x09, 0x0d,
  0x02, 0x0f, 0x13, 0x1e, 0x27, 0x33, 0x46, 0x09, 0x1c, 0x28, 0x33, 0x4c, 0x46, 0x44, 0x17, 0x2e,
  0x37, 0x37, 0x3e, 0x5a, 0x48, 0x11, 0x34, 0x4c, 0x64, 0x62, 0x64, 0x64, 0x24, 0x43, 0x5e, 0x64,
  0x5e, 0x64, 0x63, 0x28, 0x3e, 0x4a, 0x62, 0x44, 0x5c, 0x55, 0x21, 0x3c, 0x50, 0x57, 0x5f, 0x53,
  0x5d, 0x09, 0x14, 0x2a, 0x35, 0x37, 0x36, 0x2b, 0x11, 0x14, 0x1f, 0x1e, 0x2c, 0x14, 0x2d, 0x01,
  0x01, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00, 0x02, 0x04, 0x05, 0x06, 0x00, 0x02, 0x04,
  0x09, 0x0b, 0x16, 0x18, 0x00, 0x04, 0x06, 0x08, 0x09, 0x0b, 0x0a, 0x03, 0x05, 0x07, 0x0a, 0x10,
  0x17, 0x24, 0x04, 0x07, 0x0b, 0x12, 0x18, 0x18, 0x28, 0x0a, 0x18, 0x17, 0x21, 0x37, 0x46, 0x63,
  0x5a, 0x23, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x37, 0x14, 0x14,
  0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x05, 0x0a, 0x19, 0x23, 0x14
};

static const unsigned char palette_19_23_M[] =
{
  0x01, 0x04, 0x44, 0x56, 0x5a, 0x64, 0x57, 0x5a, 0x62, 0x55, 0x52, 0x0d, 0x00, 0x38, 0x00, 0x64,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x61, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0a, 0x0d, 0x14, 0x01, 0x02, 0x06, 0x0a, 0x18, 0x12, 0x14, 0x04, 0x05, 0x07, 0x0c, 0x16, 0x1a,
  0x15, 0x06, 0x08, 0x0e, 0x15, 0x1b, 0x1f, 0x1e, 0x05, 0x08, 0x11, 0x1e, 0x23, 0x1e, 0x22, 0x05,
  0x07, 0x0b, 0x1e, 0x24, 0x24, 0x20, 0x0b, 0x15, 0x1c, 0x26, 0x32, 0x2e, 0x2a, 0x0f, 0x16, 0x21,
  0x2d, 0x38, 0x33, 0x31, 0x11, 0x19, 0x20, 0x34, 0x3a, 0x37, 0x28, 0x11, 0x16, 0x23, 0x37, 0x3e,
  0x3d, 0x40, 0x22, 0x2d, 0x34, 0x44, 0x4b, 0x4b, 0x4c, 0x0c, 0x18, 0x2c, 0x40, 0x4a, 0x47, 0x43,
  0x1b, 0x27, 0x32, 0x3e, 0x48, 0x48, 0x4a, 0x18, 0x28, 0x37, 0x44, 0x4a, 0x4e, 0x50, 0x28, 0x2f,
  0x38, 0x44, 0x4c, 0x52, 0x52, 0x1e, 0x32, 0x3d, 0x48, 0x50, 0x55, 0x4f, 0x22, 0x3a, 0x4a, 0x56,
  0x58, 0x5c, 0x5e, 0x2b, 0x32, 0x4f, 0x58, 0x60, 0x60, 0x60, 0x20, 0x44, 0x52, 0x5a, 0x62, 0x5e,
  0x54, 0x1e, 0x2f, 0x4c, 0x5c, 0x64, 0x64, 0x5f, 0x28, 0x3a, 0x50, 0x61, 0x64, 0x64, 0x58, 0x1c,
  0x2e, 0x4d, 0x62, 0x64, 0x64, 0x64, 0x17, 0x2d, 0x52, 0x64, 0x64, 0x64, 0x61, 0x24, 0x3b, 0x53,
  0x64, 0x64, 0x61, 0x5e, 0x2c, 0x3d, 0x4e, 0x5c, 0x64, 0x64, 0x60, 0x1f, 0x3e, 0x5c, 0x64, 0x64,
  0x64, 0x64, 0x32, 0x47, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x28, 0x3a, 0x45, 0x57, 0x64, 0x64, 0x64,
  0x24, 0x33, 0x4a, 0x50, 0x5a, 0x64, 0x64, 0x1d, 0x3d, 0x54, 0x5f, 0x64, 0x64, 0x64, 0x1e, 0x2b,
  0x38, 0x5a, 0x64, 0x64, 0x5f, 0x1a, 0x29, 0x42, 0x5a, 0x5b, 0x60, 0x60, 0x14, 0x22, 0x4d, 0x64,
  0x64, 0x62, 0x5c, 0x21, 0x32, 0x4b, 0x58, 0x64, 0x64, 0x5b, 0x25, 0x32, 0x46, 0x5b, 0x62, 0x62,
  0x64, 0x26, 0x32, 0x4c, 0x5e, 0x64, 0x64, 0x64, 0x0f, 0x1c, 0x3b, 0x58, 0x60, 0x64, 0x5f, 0x1a,
  0x26, 0x37, 0x44, 0x62, 0x64, 0x64, 0x19, 0x28, 0x32, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x2e, 0x46,
  0x5f, 0x5f, 0x62, 0x62, 0x09, 0x1b, 0x46, 0x5c, 0x58, 0x5a, 0x5c, 0x04, 0x0a, 0x28, 0x55, 0x55,
  0x52, 0x4b, 0x09, 0x27, 0x42, 0x54, 0x5a, 0x5b, 0x5a, 0x06, 0x0d, 0x21, 0x52, 0x4e, 0x55, 0x52,
  0x08, 0x11, 0x30, 0x48, 0x48, 0x4b, 0x4c, 0x01, 0x03, 0x0b, 0x44, 0x44, 0x44, 0x49, 0x01, 0x07,
  0x15, 0x34, 0x34, 0x37, 0x38, 0x00, 0x03, 0x08, 0x2a, 0x2e, 0x2b, 0x2f, 0x00, 0x00, 0x01, 0x1c,
  0x1f, 0x18, 0x19, 0x00, 0x00, 0x00, 0x0d, 0x14, 0x13, 0x18, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08,
  0x0f, 0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x05, 0x11, 0x00, 0x00, 0x00, 0x00, 0x03, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x0b, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x09, 0x10, 0x1a, 0x06,
  0x09, 0x0d, 0x12, 0x17, 0x1d, 0x38, 0x09, 0x0f, 0x13, 0x19, 0x1f, 0x27, 0x38, 0x05, 0x08, 0x0c,
  0x0e, 0x12, 0x17, 0x4a, 0x04, 0x08, 0x0b, 0x0e, 0x16, 0x1c, 0x4a, 0x03, 0x06, 0x0b, 0x12, 0x1b,
  0x2d, 0x45, 0x0b, 0x11, 0x17, 0x25, 0x33, 0x36, 0x3d, 0x04, 0x07, 0x0a, 0x0f, 0x1c, 0x20, 0x27,
  0x03, 0x05, 0x07, 0x0b, 0x0d, 0x00, 0x00, 0x10, 0x13, 0x17, 0x19, 0x1d, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x00, 0x2a, 0x2e, 0x35, 0x3c,
  0x4e, 0x2c, 0x00, 0x23, 0x24, 0x1f, 0x0d, 0x08, 0x06, 0x04, 0x2a, 0x1f, 0x17, 0x0e, 0x09, 0x07,
  0x05, 0x22, 0x19, 0x17, 0x07, 0x05, 0x02, 0x01, 0x30, 0x34, 0x33, 0x1b, 0x11, 0x0c, 0x07, 0x4e,
  0x35, 0x2b, 0x26, 0x1b, 0x12, 0x0e, 0x46, 0x44, 0x46, 0x2c, 0x1a, 0x17, 0x12, 0x4f, 0x40, 0x2f,
  0x24, 0x1b, 0x14, 0x0e, 0x43, 0x4b, 0x4b, 0x2b, 0x19, 0x11, 0x0d, 0x51, 0x5b, 0x5d, 0x34, 0x28,
  0x1c, 0x15, 0x55, 0x55, 0x54, 0x36, 0x2b, 0x1f, 0x19, 0x49, 0x4a, 0x4a, 0x2f, 0x24, 0x1a, 0x12,
  0x54, 0x3f, 0x35, 0x2c, 0x1f, 0x18, 0x11, 0x52, 0x56, 0x53, 0x2d, 0x24, 0x1e, 0x19, 0x5a, 0x63,
  0x62, 0x35, 0x27, 0x1e, 0x18, 0x55, 0x4d, 0x3d, 0x2e, 0x1d, 0x11, 0x0e, 0x50, 0x58, 0x56, 0x31,
  0x24, 0x1b, 0x13, 0x4a, 0x43, 0x30, 0x21, 0x17, 0x10, 0x09, 0x5a, 0x63, 0x64, 0x38, 0x25, 0x1c,
  0x14, 0x5f, 0x4f, 0x3e, 0x27, 0x14, 0x0f, 0x07, 0x46, 0x48, 0x48, 0x1a, 0x12, 0x09, 0x05, 0x3a,
  0x39, 0x3a, 0x13, 0x08, 0x04, 0x02, 0x46, 0x1e, 0x17, 0x0f, 0x07, 0x04, 0x03, 0x28, 0x1d, 0x13,
  0x08, 0x05, 0x03, 0x02, 0x2e, 0x0e, 0x09, 0x05, 0x03, 0x02, 0x01, 0x26, 0x15, 0x0e, 0x08, 0x05,
  0x03, 0x02, 0x1e, 0x11, 0x0d, 0x05, 0x03, 0x02, 0x01, 0x23, 0x11, 0x0b, 0x07, 0x05, 0x03, 0x01,
  0x1f, 0x10, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x25, 0x11, 0x0d, 0x08, 0x05, 0x04, 0x03, 0x1a, 0x0b,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0b, 0x06, 0x01, 0x01, 0x01, 0x00, 0x1c, 0x13, 0x10, 0x0a,
  0x07, 0x05, 0x03, 0x1b, 0x10, 0x0c, 0x07, 0x04, 0x03, 0x02, 0x15, 0x09, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x1f, 0x11, 0x0c, 0x09, 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x06, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x02, 0x04, 0x02, 0x03, 0x04, 0x06, 0x0a, 0x11, 0x14, 0x01, 0x02, 0x03,
  0x06, 0x0a, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0b, 0x19, 0x02, 0x03, 0x0b, 0x18, 0x1e, 0x35, 0x47, 0x03, 0x06, 0x10, 0x1c, 0x3b, 0x49, 0x50,
  0x02, 0x06, 0x0c, 0x1d, 0x35, 0x4b, 0x58, 0x06, 0x07, 0x14, 0x27, 0x3a, 0x49, 0x5f, 0x0e, 0x19,
  0x29, 0x33, 0x47, 0x5e, 0x64, 0x0e, 0x12, 0x17, 0x2b, 0x39, 0x4c, 0x58, 0x14, 0x1b, 0x24, 0x30,
  0x3f, 0x51, 0x60, 0x0e, 0x16, 0x21, 0x2b, 0x38, 0x4b, 0x50, 0x0e, 0x18, 0x26, 0x35, 0x48, 0x56,
  0x5d, 0x0a, 0x14, 0x22, 0x34, 0x46, 0x54, 0x5c, 0x11, 0x19, 0x1e, 0x2e, 0x37, 0x3c, 0x41, 0x0e,
  0x14, 0x1f, 0x2d, 0x35, 0x41, 0x45, 0x0f, 0x15, 0x1b, 0x27, 0x2f, 0x3f, 0x44, 0x05, 0x06, 0x0b,
  0x09, 0x0b, 0x11, 0x22, 0x1e, 0x21, 0x24, 0x2a, 0x3e, 0x38, 0x3e, 0x1c, 0x45, 0x50, 0x50, 0x4d,
  0x62, 0x64, 0x0e, 0x47, 0x57, 0x5d, 0x62, 0x64, 0x55, 0x17, 0x20, 0x30, 0x44, 0x53, 0x59, 0x5e,
  0x0b, 0x1d, 0x2b, 0x2c, 0x36, 0x47, 0x5d, 0x07, 0x14, 0x1e, 0x2b, 0x4d, 0x4a, 0x55, 0x0c, 0x1a,
  0x21, 0x19, 0x16, 0x3c, 0x32, 0x00, 0x03, 0x06, 0x06, 0x18, 0x2d, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x1f, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x12, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x01, 0x03, 0x05, 0x04, 0x04, 0x16, 0x18, 0x02,
  0x05, 0x04, 0x08, 0x0f, 0x1e, 0x2c, 0x07, 0x0d, 0x0f, 0x19, 0x23, 0x30, 0x35, 0x1a, 0x21, 0x26,
  0x46, 0x4c, 0x33, 0x2a, 0x18, 0x1d, 0x3a, 0x3e, 0x46, 0x33, 0x4e, 0x04, 0x0a, 0x0e, 0x12, 0x1c,
  0x24, 0x34, 0x04, 0x0a, 0x0d, 0x08, 0x0b, 0x0d, 0x1e, 0x03, 0x04, 0x0b, 0x0e, 0x1e, 0x2b, 0x49,
  0x05, 0x00, 0x00, 0x14, 0x28, 0x32, 0x4b, 0x00, 0x00, 0x0a, 0x19, 0x32, 0x46, 0x3c, 0x19, 0x1e,
  0x1e, 0x14, 0x28, 0x32, 0x00, 0x19, 0x14, 0x23, 0x0f, 0x00, 0x00, 0x00
};

static const unsigned char palette_19_23_Y[] =
{
  0x64, 0x64, 0x64, 0x50, 0x3c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3a, 0x35, 0x64, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x64, 0x00, 0x00, 0x64, 0x01, 0x00, 0x3a, 0x46, 0x5f, 0x64,
  0x64, 0x64, 0x58, 0x46, 0x50, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x47, 0x4d, 0x50, 0x64, 0x64, 0x64,
  0x64, 0x3c, 0x45, 0x50, 0x58, 0x64, 0x64, 0x64, 0x23, 0x30, 0x44, 0x5f, 0x64, 0x5f, 0x62, 0x39,
  0x44, 0x46, 0x64, 0x64, 0x64, 0x64, 0x38, 0x4a, 0x57, 0x5f, 0x64, 0x64, 0x64, 0x2f, 0x3a, 0x4b,
  0x5f, 0x64, 0x64, 0x64, 0x3e, 0x4c, 0x56, 0x64, 0x64, 0x64, 0x55, 0x2a, 0x2f, 0x46, 0x64, 0x64,
  0x64, 0x64, 0x36, 0x45, 0x50, 0x64, 0x64, 0x64, 0x64, 0x20, 0x31, 0x47, 0x5f, 0x64, 0x64, 0x64,
  0x22, 0x32, 0x4d, 0x61, 0x64, 0x64, 0x64, 0x1f, 0x2c, 0x4b, 0x62, 0x64, 0x64, 0x64, 0x27, 0x32,
  0x3e, 0x5a, 0x64, 0x64, 0x64, 0x16, 0x2d, 0x46, 0x5a, 0x5e, 0x64, 0x47, 0x12, 0x26, 0x39, 0x50,
  0x54, 0x54, 0x58, 0x10, 0x15, 0x32, 0x50, 0x5a, 0x4c, 0x51, 0x0a, 0x1c, 0x35, 0x3c, 0x55, 0x41,
  0x36, 0x08, 0x0f, 0x20, 0x4c, 0x4b, 0x47, 0x3b, 0x08, 0x10, 0x23, 0x3c, 0x3c, 0x36, 0x2a, 0x02,
  0x06, 0x15, 0x2e, 0x33, 0x32, 0x2f, 0x05, 0x0c, 0x25, 0x41, 0x42, 0x41, 0x3d, 0x02, 0x05, 0x11,
  0x30, 0x2d, 0x25, 0x24, 0x04, 0x06, 0x08, 0x12, 0x18, 0x1a, 0x1a, 0x00, 0x00, 0x01, 0x12, 0x16,
  0x18, 0x15, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01,
  0x06, 0x09, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x1e, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x0a, 0x13, 0x01, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x17, 0x06, 0x04, 0x00, 0x00,
  0x05, 0x0b, 0x12, 0x06, 0x07, 0x06, 0x01, 0x04, 0x08, 0x14, 0x09, 0x0d, 0x0b, 0x0a, 0x0e, 0x12,
  0x1a, 0x0c, 0x10, 0x14, 0x14, 0x14, 0x1a, 0x1c, 0x07, 0x0c, 0x14, 0x1e, 0x20, 0x23, 0x24, 0x0e,
  0x16, 0x26, 0x31, 0x32, 0x32, 0x2f, 0x12, 0x18, 0x20, 0x2a, 0x2d, 0x30, 0x30, 0x15, 0x1a, 0x26,
  0x2f, 0x31, 0x33, 0x34, 0x18, 0x20, 0x32, 0x3b, 0x3a, 0x3b, 0x3b, 0x0e, 0x11, 0x1e, 0x3a, 0x3c,
  0x3a, 0x3a, 0x17, 0x1c, 0x36, 0x4a, 0x43, 0x42, 0x3e, 0x1a, 0x25, 0x34, 0x46, 0x48, 0x45, 0x46,
  0x1a, 0x21, 0x2a, 0x58, 0x57, 0x54, 0x45, 0x1a, 0x1d, 0x24, 0x5a, 0x62, 0x5d, 0x49, 0x2d, 0x30,
  0x4e, 0x64, 0x62, 0x62, 0x5e, 0x24, 0x2d, 0x3a, 0x61, 0x62, 0x64, 0x59, 0x24, 0x2a, 0x37, 0x5e,
  0x60, 0x62, 0x62, 0x36, 0x48, 0x59, 0x5c, 0x5d, 0x62, 0x5c, 0x36, 0x48, 0x4c, 0x53, 0x62, 0x64,
  0x64, 0x30, 0x42, 0x4f, 0x5a, 0x62, 0x64, 0x64, 0x3a, 0x49, 0x64, 0x64, 0x64, 0x64, 0x64, 0x0a,
  0x0e, 0x10, 0x16, 0x1b, 0x20, 0x35, 0x0a, 0x0d, 0x12, 0x15, 0x1a, 0x1e, 0x2d, 0x0c, 0x10, 0x14,
  0x18, 0x1c, 0x22, 0x3f, 0x07, 0x09, 0x0b, 0x0e, 0x13, 0x15, 0x33, 0x04, 0x05, 0x09, 0x0d, 0x11,
  0x1b, 0x28, 0x08, 0x08, 0x0a, 0x12, 0x21, 0x25, 0x2f, 0x0a, 0x0c, 0x0e, 0x12, 0x18, 0x1e, 0x26,
  0x04, 0x07, 0x09, 0x0d, 0x0e, 0x00, 0x00, 0x12, 0x15, 0x17, 0x19, 0x1c, 0x1f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x3b, 0x23,
  0x2c, 0x24, 0x00, 0x3e, 0x49, 0x4d, 0x2d, 0x23, 0x1c, 0x16, 0x59, 0x50, 0x43, 0x32, 0x27, 0x20,
  0x19, 0x5d, 0x62, 0x61, 0x3a, 0x35, 0x2b, 0x21, 0x47, 0x57, 0x57, 0x37, 0x2a, 0x22, 0x1a, 0x5b,
  0x44, 0x32, 0x2a, 0x21, 0x18, 0x14, 0x5c, 0x5e, 0x61, 0x35, 0x1f, 0x1e, 0x19, 0x47, 0x3c, 0x2b,
  0x21, 0x19, 0x16, 0x10, 0x3f, 0x49, 0x4a, 0x2d, 0x1b, 0x15, 0x12, 0x4c, 0x5c, 0x5f, 0x2b, 0x21,
  0x18, 0x13, 0x36, 0x35, 0x35, 0x11, 0x0a, 0x06, 0x05, 0x34, 0x36, 0x3a, 0x14, 0x0c, 0x09, 0x06,
  0x3b, 0x20, 0x19, 0x12, 0x0d, 0x0a, 0x07, 0x2c, 0x26, 0x20, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0d, 0x09, 0x06, 0x03, 0x02, 0x02, 0x13, 0x0a, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x12, 0x0b, 0x07, 0x04, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x0a, 0x08, 0x05, 0x02, 0x02, 0x01, 0x1e, 0x0f, 0x09, 0x03, 0x02, 0x01, 0x01, 0x17,
  0x0c, 0x09, 0x01, 0x00, 0x01, 0x00, 0x24, 0x0d, 0x0a, 0x07, 0x04, 0x03, 0x03, 0x20, 0x1b, 0x19,
  0x09, 0x06, 0x05, 0x03, 0x22, 0x17, 0x14, 0x0e, 0x0b, 0x08, 0x07, 0x32, 0x24, 0x1a, 0x13, 0x0d,
  0x09, 0x06, 0x3f, 0x3e, 0x40, 0x25, 0x1c, 0x16, 0x12, 0x33, 0x26, 0x1e, 0x17, 0x13, 0x0e, 0x0a,
  0x33, 0x2d, 0x29, 0x1a, 0x14, 0x0e, 0x08, 0x40, 0x29, 0x22, 0x19, 0x13, 0x10, 0x0d, 0x35, 0x30,
  0x2d, 0x18, 0x13, 0x0d, 0x0a, 0x55, 0x55, 0x4f, 0x31, 0x2a, 0x25, 0x1e, 0x4a, 0x42, 0x3e, 0x30,
  0x23, 0x1c, 0x16, 0x62, 0x52, 0x42, 0x33, 0x24, 0x1d, 0x15, 0x64, 0x64, 0x64, 0x49, 0x38, 0x32,
  0x2b, 0x60, 0x4c, 0x39, 0x33, 0x25, 0x1f, 0x1a, 0x22, 0x28, 0x2f, 0x42, 0x50, 0x64, 0x64, 0x1d,
  0x26, 0x2f, 0x3e, 0x4c, 0x64, 0x64, 0x1d, 0x23, 0x2a, 0x34, 0x44, 0x4e, 0x60, 0x09, 0x0e, 0x15,
  0x1c, 0x26, 0x31, 0x3c, 0x04, 0x07, 0x08, 0x0b, 0x0d, 0x0a, 0x08, 0x06, 0x05, 0x07, 0x07, 0x05,
  0x03, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x09, 0x01, 0x01, 0x01, 0x02, 0x04, 0x0a, 0x0c,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x04, 0x07, 0x0a, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x0c, 0x02, 0x01, 0x00, 0x01, 0x03, 0x07, 0x0b, 0x02, 0x01, 0x01, 0x02,
  0x04, 0x08, 0x0f, 0x05, 0x08, 0x09, 0x0e, 0x14, 0x21, 0x27, 0x04, 0x05, 0x08, 0x0e, 0x18, 0x2b,
  0x3a, 0x02, 0x05, 0x08, 0x11, 0x1b, 0x29, 0x38, 0x1e, 0x27, 0x2d, 0x55, 0x5a, 0x64, 0x64, 0x18,
  0x20, 0x2b, 0x40, 0x4f, 0x64, 0x64, 0x18, 0x1e, 0x26, 0x35, 0x43, 0x64, 0x64, 0x19, 0x26, 0x33,
  0x56, 0x61, 0x64, 0x44, 0x63, 0x62, 0x32, 0x45, 0x5f, 0x5f, 0x63, 0x1a, 0x41, 0x50, 0x30, 0x25,
  0x2c, 0x27, 0x03, 0x10, 0x0c, 0x1c, 0x28, 0x43, 0x1f, 0x02, 0x02, 0x05, 0x08, 0x10, 0x17, 0x13,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x13, 0x1d, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x06, 0x08, 0x01, 0x01, 0x06, 0x0c, 0x0e, 0x21, 0x1e, 0x1d,
  0x07, 0x08, 0x15, 0x11, 0x1a, 0x24, 0x1e, 0x1c, 0x20, 0x15, 0x19, 0x37, 0x41, 0x53, 0x5a, 0x53,
  0x46, 0x10, 0x23, 0x3c, 0x50, 0x4b, 0x4f, 0x53, 0x2d, 0x26, 0x24, 0x55, 0x62, 0x2d, 0x50, 0x14,
  0x17, 0x14, 0x21, 0x2d, 0x2d, 0x3b, 0x17, 0x21, 0x28, 0x32, 0x41, 0x5d, 0x64, 0x1a, 0x21, 0x2f,
  0x5c, 0x64, 0x2f, 0x2b, 0x16, 0x1e, 0x35, 0x30, 0x3b, 0x3b, 0x64, 0x0e, 0x11, 0x14, 0x19, 0x24,
  0x2b, 0x41, 0x0d, 0x16, 0x1e, 0x14, 0x18, 0x12, 0x16, 0x02, 0x08, 0x08, 0x0b, 0x11, 0x17, 0x1e,
  0x05, 0x3c, 0x46, 0x23, 0x19, 0x00, 0x00, 0x28, 0x64, 0x23, 0x19, 0x0f, 0x00, 0x00, 0x3c, 0x46,
  0x3c, 0x32, 0x46, 0x55, 0x00, 0x28, 0x1e, 0x0f, 0x05, 0x00, 0x14, 0x1e
};

static const unsigned char palette_19_23_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x02, 0x03, 0x00, 0x5c, 0x00, 0x00,
  0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x1c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1d, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b,
  0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x22, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1e, 0x2d, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x1f, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x38, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x08, 0x28, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x07, 0x20, 0x46,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x20, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0c, 0x33, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x36, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1f,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x36, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x23, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x20, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x16, 0x2b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x32, 0x00, 0x00, 0x00, 0x03, 0x17,
  0x23, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x14, 0x29, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1b, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x05,
  0x1c, 0x2d, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x23, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x2f, 0x00, 0x00, 0x00, 0x0f, 0x20, 0x2b, 0x44, 0x00, 0x00, 0x00,
  0x03, 0x0f, 0x18, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1e, 0x2f, 0x00, 0x00, 0x00, 0x04, 0x10,
  0x20, 0x43, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x3d, 0x00, 0x00, 0x00, 0x02, 0x12, 0x14, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x41, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x34, 0x53, 0x00, 0x00,
  0x00, 0x00, 0x0c, 0x30, 0x49, 0x00, 0x00, 0x00, 0x00, 0x12, 0x38, 0x4d, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x34, 0x48, 0x00, 0x00, 0x05, 0x03, 0x12, 0x2e, 0x4d, 0x00, 0x00, 0x00, 0x04, 0x12, 0x26,
  0x46, 0x00, 0x00, 0x00, 0x03, 0x16, 0x26, 0x3b, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x30, 0x00,
  0x00, 0x00, 0x0e, 0x1a, 0x28, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x32, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x17, 0x41, 0x00, 0x00, 0x00, 0x00, 0x10, 0x26, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x16, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x29, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x18, 0x2c, 0x48,
  0x00, 0x00, 0x00, 0x01, 0x12, 0x2b, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x3a, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x05, 0x18, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x11, 0x23, 0x38, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x19, 0x23, 0x00, 0x00, 0x00, 0x00, 0x16, 0x26, 0x42, 0x0e,
  0x18, 0x1d, 0x2a, 0x37, 0x43, 0x5c, 0x0d, 0x18, 0x23, 0x2d, 0x38, 0x46, 0x57, 0x0f, 0x1a, 0x22,
  0x2d, 0x36, 0x44, 0x5f, 0x0b, 0x15, 0x1d, 0x26, 0x35, 0x3f, 0x5d, 0x08, 0x0c, 0x16, 0x25, 0x33,
  0x46, 0x59, 0x0c, 0x12, 0x1a, 0x32, 0x4e, 0x54, 0x5c, 0x0d, 0x12, 0x1c, 0x2b, 0x41, 0x4c, 0x53,
  0x05, 0x0a, 0x0f, 0x17, 0x1a, 0x64, 0x64, 0x20, 0x26, 0x2c, 0x31, 0x38, 0x40, 0x64, 0x06, 0x0a,
  0x11, 0x18, 0x1d, 0x64, 0x64, 0x1f, 0x25, 0x2b, 0x33, 0x3c, 0x44, 0x64, 0x58, 0x5f, 0x59, 0x50,
  0x5b, 0x54, 0x64, 0x4f, 0x4d, 0x4a, 0x22, 0x16, 0x0e, 0x08, 0x48, 0x33, 0x26, 0x18, 0x10, 0x0a,
  0x05, 0x42, 0x29, 0x1a, 0x07, 0x05, 0x03, 0x01, 0x48, 0x3f, 0x30, 0x16, 0x0e, 0x0a, 0x05, 0x4e,
  0x28, 0x1a, 0x12, 0x0b, 0x06, 0x04, 0x46, 0x22, 0x14, 0x01, 0x00, 0x00, 0x00, 0x49, 0x33, 0x26,
  0x1a, 0x11, 0x0c, 0x07, 0x4e, 0x44, 0x3a, 0x1b, 0x0e, 0x08, 0x06, 0x3d, 0x21, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x48, 0x36, 0x2c, 0x04, 0x00, 0x00, 0x00, 0x50, 0x3f, 0x38, 0x0e, 0x04, 0x01, 0x01,
  0x53, 0x2f, 0x21, 0x15, 0x0a, 0x05, 0x03, 0x49, 0x3e, 0x31, 0x06, 0x01, 0x01, 0x00, 0x32, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x2a, 0x1a, 0x12, 0x08, 0x04, 0x04, 0x39, 0x27, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x44, 0x34, 0x22, 0x14, 0x0b, 0x08, 0x05, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x26, 0x1a, 0x0e, 0x07, 0x05, 0x04, 0x4c, 0x3e, 0x26, 0x08, 0x07, 0x04, 0x03, 0x4d,
  0x3d, 0x2a, 0x04, 0x01, 0x01, 0x01, 0x56, 0x29, 0x1f, 0x16, 0x0c, 0x08, 0x05, 0x53, 0x4f, 0x4a,
  0x13, 0x0a, 0x07, 0x03, 0x54, 0x32, 0x1b, 0x0e, 0x08, 0x05, 0x03, 0x54, 0x3b, 0x2b, 0x19, 0x0f,
  0x0a, 0x06, 0x4b, 0x38, 0x2d, 0x0f, 0x08, 0x04, 0x03, 0x51, 0x30, 0x21, 0x15, 0x0e, 0x08, 0x04,
  0x4c, 0x36, 0x25, 0x03, 0x01, 0x00, 0x00, 0x53, 0x33, 0x27, 0x18, 0x10, 0x0c, 0x08, 0x4c, 0x2f,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x45, 0x2d, 0x19, 0x04, 0x03, 0x02, 0x00, 0x4a, 0x3a, 0x30, 0x1f,
  0x14, 0x0f, 0x09, 0x4f, 0x34, 0x24, 0x16, 0x0c, 0x08, 0x05, 0x44, 0x27, 0x0e, 0x01, 0x00, 0x00,
  0x00, 0x4f, 0x30, 0x1e, 0x19, 0x0e, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0x0e, 0x00,
  0x01, 0x02, 0x05, 0x0b, 0x16, 0x1e, 0x03, 0x06, 0x09, 0x0f, 0x19, 0x23, 0x30, 0x02, 0x05, 0x0a,
  0x12, 0x20, 0x38, 0x52, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x10, 0x12, 0x01, 0x02, 0x06, 0x08, 0x0a, 0x18, 0x36, 0x00, 0x02, 0x02, 0x03, 0x11, 0x30, 0x3f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x01, 0x04, 0x01, 0x05, 0x0c, 0x14, 0x29, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0c, 0x20, 0x01, 0x00, 0x00, 0x02, 0x08, 0x15, 0x2f, 0x01, 0x00, 0x02, 0x07,
  0x0b, 0x1c, 0x3c, 0x01, 0x02, 0x06, 0x0c, 0x17, 0x2b, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x00,
  0x02, 0x02, 0x09, 0x14, 0x25, 0x32, 0x02, 0x04, 0x08, 0x11, 0x1b, 0x3d, 0x46, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x01, 0x00, 0x00, 0x09, 0x1b,
  0x21, 0x45, 0x00, 0x00, 0x00, 0x0e, 0x14, 0x1f, 0x3b, 0x00, 0x01, 0x07, 0x10, 0x17, 0x22, 0x2d,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x12, 0x37, 0x4a, 0x00, 0x00,
  0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x0c, 0x03, 0x1b, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x26, 0x35, 0x00, 0x00, 0x08, 0x1e, 0x23, 0x41, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36,
  0x3a, 0x01, 0x00, 0x00, 0x00, 0x05, 0x15, 0x27, 0x03, 0x08, 0x10, 0x1e, 0x28, 0x3a, 0x44, 0x00,
  0x03, 0x07, 0x0a, 0x1c, 0x26, 0x31, 0x01, 0x00, 0x04, 0x05, 0x0a, 0x17, 0x1f, 0x01, 0x06, 0x0c,
  0x24, 0x34, 0x3d, 0x45, 0x00, 0x0c, 0x12, 0x19, 0x1c, 0x22, 0x2e, 0x08, 0x0f, 0x15, 0x1d, 0x31,
  0x40, 0x55, 0x08, 0x14, 0x20, 0x18, 0x21, 0x26, 0x3c, 0x02, 0x0d, 0x15, 0x1f, 0x33, 0x3f, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x0f,
  0x0a, 0x1e, 0x00, 0x00, 0x28, 0x14, 0x19, 0x19, 0x14, 0x19, 0x19, 0x19
};

// PANTONE Solid Coated

static const unsigned char palette_19_24_C[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2b, 0x5c, 0x64, 0x64, 0x64, 0x5f, 0x38, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x5d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x07, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x0f, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0e, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x01, 0x02, 0x01, 0x00, 0x05,
  0x08, 0x11, 0x01, 0x04, 0x05, 0x00, 0x06, 0x0f, 0x18, 0x01, 0x03, 0x06, 0x09, 0x0c, 0x12, 0x13,
  0x03, 0x06, 0x0e, 0x12, 0x15, 0x21, 0x1f, 0x03, 0x10, 0x1a, 0x1d, 0x26, 0x27, 0x28, 0x05, 0x0b,
  0x13, 0x22, 0x25, 0x2d, 0x2b, 0x07, 0x10, 0x1f, 0x2b, 0x2e, 0x34, 0x37, 0x09, 0x13, 0x32, 0x45,
  0x42, 0x3e, 0x39, 0x14, 0x1e, 0x32, 0x3d, 0x44, 0x46, 0x41, 0x17, 0x24, 0x30, 0x43, 0x49, 0x4a,
  0x4a, 0x1e, 0x2c, 0x42, 0x4e, 0x54, 0x54, 0x54, 0x0c, 0x1b, 0x38, 0x52, 0x56, 0x56, 0x50, 0x19,
  0x26, 0x35, 0x43, 0x5c, 0x5c, 0x5a, 0x1f, 0x30, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x27, 0x38, 0x4c,
  0x64, 0x64, 0x64, 0x64, 0x15, 0x2a, 0x54, 0x64, 0x64, 0x64, 0x64, 0x15, 0x22, 0x4b, 0x64, 0x64,
  0x64, 0x64, 0x1c, 0x44, 0x60, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c, 0x46, 0x64, 0x64, 0x64, 0x64,
  0x28, 0x3a, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x18, 0x24, 0x3a, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x3d,
  0x54, 0x64, 0x64, 0x64, 0x64, 0x33, 0x44, 0x56, 0x64, 0x64, 0x64, 0x64, 0x23, 0x3c, 0x57, 0x64,
  0x64, 0x64, 0x64, 0x24, 0x39, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x30, 0x44, 0x5e, 0x64, 0x64, 0x64,
  0x64, 0x32, 0x45, 0x59, 0x64, 0x64, 0x64, 0x64, 0x18, 0x29, 0x3e, 0x64, 0x64, 0x64, 0x64, 0x25,
  0x36, 0x55, 0x64, 0x64, 0x64, 0x5f, 0x2e, 0x36, 0x4e, 0x62, 0x64, 0x64, 0x5e, 0x2d, 0x37, 0x4c,
  0x5e, 0x61, 0x64, 0x5c, 0x2f, 0x3f, 0x59, 0x64, 0x64, 0x64, 0x64, 0x1b, 0x21, 0x38, 0x5f, 0x64,
  0x64, 0x64, 0x28, 0x31, 0x54, 0x64, 0x64, 0x64, 0x5f, 0x28, 0x36, 0x4a, 0x5a, 0x64, 0x64, 0x5f,
  0x21, 0x2b, 0x38, 0x60, 0x64, 0x5e, 0x50, 0x22, 0x25, 0x2e, 0x59, 0x5f, 0x5f, 0x53, 0x26, 0x2a,
  0x3e, 0x4b, 0x4e, 0x4e, 0x49, 0x16, 0x1d, 0x25, 0x3f, 0x43, 0x40, 0x35, 0x10, 0x14, 0x1b, 0x2f,
  0x35, 0x33, 0x2b, 0x0a, 0x0f, 0x17, 0x1c, 0x1a, 0x18, 0x16, 0x06, 0x0a, 0x0e, 0x17, 0x18, 0x14,
  0x14, 0x03, 0x03, 0x07, 0x0b, 0x0a, 0x0b, 0x0e, 0x01, 0x01, 0x04, 0x06, 0x06, 0x0b, 0x11, 0x05,
  0x08, 0x0a, 0x0e, 0x12, 0x17, 0x38, 0x05, 0x08, 0x0b, 0x10, 0x13, 0x1b, 0x35, 0x08, 0x0d, 0x11,
  0x16, 0x1c, 0x21, 0x57, 0x06, 0x0c, 0x10, 0x15, 0x1e, 0x26, 0x5b, 0x07, 0x0c, 0x15, 0x21, 0x2d,
  0x43, 0x5a, 0x05, 0x09, 0x0e, 0x15, 0x25, 0x29, 0x34, 0x12, 0x17, 0x1d, 0x26, 0x32, 0x34, 0x37,
  0x02, 0x04, 0x06, 0x09, 0x0b, 0x00, 0x00, 0x0b, 0x0e, 0x10, 0x11, 0x14, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x48, 0x28, 0x25,
  0x64, 0x33, 0x00, 0x1e, 0x20, 0x1f, 0x11, 0x0c, 0x0a, 0x07, 0x18, 0x10, 0x0d, 0x08, 0x06, 0x05,
  0x03, 0x15, 0x09, 0x06, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x11, 0x0d, 0x07, 0x05, 0x03, 0x02, 0x1d,
  0x0d, 0x08, 0x06, 0x04, 0x02, 0x01, 0x15, 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x11, 0x0d,
  0x09, 0x06, 0x04, 0x03, 0x20, 0x19, 0x13, 0x09, 0x04, 0x03, 0x02, 0x14, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1d, 0x0f, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x20, 0x17, 0x13, 0x05, 0x00, 0x00, 0x00,
  0x24, 0x10, 0x0b, 0x08, 0x03, 0x02, 0x01, 0x1e, 0x14, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x2e, 0x37,
  0x38, 0x11, 0x09, 0x04, 0x02, 0x34, 0x2d, 0x25, 0x1b, 0x0d, 0x06, 0x04, 0x38, 0x40, 0x42, 0x23,
  0x17, 0x10, 0x0b, 0x34, 0x2a, 0x1b, 0x0f, 0x09, 0x05, 0x02, 0x47, 0x4c, 0x4b, 0x28, 0x19, 0x0d,
  0x0a, 0x61, 0x54, 0x49, 0x30, 0x1b, 0x13, 0x0a, 0x54, 0x5f, 0x5f, 0x2b, 0x22, 0x15, 0x0e, 0x64,
  0x64, 0x64, 0x40, 0x27, 0x1b, 0x15, 0x64, 0x47, 0x39, 0x2c, 0x1c, 0x15, 0x10, 0x64, 0x64, 0x64,
  0x3b, 0x2b, 0x23, 0x16, 0x64, 0x53, 0x3e, 0x2e, 0x27, 0x1c, 0x13, 0x55, 0x40, 0x2e, 0x23, 0x1a,
  0x12, 0x0d, 0x51, 0x53, 0x52, 0x33, 0x29, 0x20, 0x17, 0x53, 0x3c, 0x2f, 0x27, 0x1f, 0x16, 0x0e,
  0x51, 0x53, 0x53, 0x34, 0x29, 0x20, 0x11, 0x52, 0x30, 0x29, 0x1d, 0x16, 0x11, 0x0c, 0x57, 0x59,
  0x56, 0x32, 0x23, 0x1d, 0x16, 0x36, 0x39, 0x34, 0x21, 0x1b, 0x17, 0x10, 0x34, 0x28, 0x24, 0x1c,
  0x14, 0x10, 0x0a, 0x31, 0x23, 0x1e, 0x16, 0x0e, 0x0a, 0x07, 0x1a, 0x16, 0x19, 0x0f, 0x0a, 0x08,
  0x05, 0x20, 0x15, 0x0f, 0x0e, 0x0a, 0x07, 0x05, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x01,
  0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x03, 0x04, 0x05, 0x07, 0x0b, 0x0d, 0x0f, 0x0c, 0x19, 0x24,
  0x2f, 0x3d, 0x4f, 0x5e, 0x14, 0x25, 0x31, 0x49, 0x5d, 0x64, 0x64, 0x1e, 0x26, 0x41, 0x59, 0x64,
  0x64, 0x64, 0x0d, 0x15, 0x29, 0x37, 0x49, 0x60, 0x64, 0x0a, 0x12, 0x28, 0x3e, 0x60, 0x64, 0x64,
  0x0a, 0x17, 0x27, 0x3c, 0x5b, 0x64, 0x64, 0x04, 0x05, 0x14, 0x28, 0x3b, 0x4a, 0x5a, 0x01, 0x02,
  0x04, 0x08, 0x0e, 0x0f, 0x09, 0x02, 0x03, 0x04, 0x0a, 0x12, 0x1b, 0x17, 0x02, 0x03, 0x05, 0x0a,
  0x12, 0x1b, 0x19, 0x00, 0x01, 0x02, 0x04, 0x07, 0x0c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x05, 0x07, 0x0b, 0x01, 0x02, 0x03, 0x07, 0x0a, 0x0c, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x03, 0x08,
  0x07, 0x0f, 0x00, 0x00, 0x00, 0x04, 0x05, 0x07, 0x12, 0x02, 0x02, 0x03, 0x07, 0x07, 0x09, 0x0d,
  0x02, 0x0f, 0x13, 0x1e, 0x27, 0x33, 0x46, 0x09, 0x1c, 0x28, 0x33, 0x4c, 0x46, 0x44, 0x17, 0x2e,
  0x37, 0x37, 0x3e, 0x5a, 0x48, 0x11, 0x34, 0x4c, 0x64, 0x62, 0x64, 0x64, 0x24, 0x43, 0x5e, 0x64,
  0x5e, 0x64, 0x63, 0x28, 0x3e, 0x4a, 0x62, 0x44, 0x5c, 0x55, 0x21, 0x3c, 0x50, 0x57, 0x5f, 0x53,
  0x5d, 0x09, 0x14, 0x2a, 0x35, 0x37, 0x36, 0x2b, 0x11, 0x14, 0x1f, 0x1e, 0x2c, 0x14, 0x2d, 0x01,
  0x01, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00, 0x02, 0x04, 0x05, 0x06, 0x00, 0x02, 0x04,
  0x09, 0x0b, 0x16, 0x18, 0x00, 0x04, 0x06, 0x08, 0x09, 0x0b, 0x0a, 0x03, 0x05, 0x07, 0x0a, 0x10,
  0x17, 0x24, 0x04, 0x07, 0x0b, 0x12, 0x18, 0x18, 0x28, 0x0a, 0x18, 0x17, 0x21, 0x37, 0x46, 0x63,
  0x5a, 0x23, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x37, 0x14, 0x14,
  0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x05, 0x0a, 0x19, 0x23, 0x14
};

static const unsigned char palette_19_24_M[] =
{
  0x01, 0x04, 0x44, 0x56, 0x5a, 0x64, 0x57, 0x5a, 0x62, 0x55, 0x52, 0x0d, 0x00, 0x38, 0x00, 0x64,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x61, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0a, 0x0d, 0x14, 0x01, 0x02, 0x06, 0x0a, 0x18, 0x12, 0x14, 0x04, 0x05, 0x07, 0x0c, 0x16, 0x1a,
  0x15, 0x06, 0x08, 0x0e, 0x15, 0x1b, 0x1f, 0x1e, 0x05, 0x08, 0x11, 0x1e, 0x23, 0x1e, 0x22, 0x05,
  0x07, 0x0b, 0x1e, 0x24, 0x24, 0x20, 0x0b, 0x15, 0x1c, 0x26, 0x32, 0x2e, 0x2a, 0x0f, 0x16, 0x21,
  0x2d, 0x38, 0x33, 0x31, 0x11, 0x19, 0x20, 0x34, 0x3a, 0x37, 0x28, 0x11, 0x16, 0x23, 0x37, 0x3e,
  0x3d, 0x40, 0x22, 0x2d, 0x34, 0x44, 0x4b, 0x4b, 0x4c, 0x0c, 0x18, 0x2c, 0x40, 0x4a, 0x47, 0x43,
  0x1b, 0x27, 0x32, 0x3e, 0x48, 0x48, 0x4a, 0x18, 0x28, 0x37, 0x44, 0x4a, 0x4e, 0x50, 0x28, 0x2f,
  0x38, 0x44, 0x4c, 0x52, 0x52, 0x1e, 0x32, 0x3d, 0x48, 0x50, 0x55, 0x4f, 0x22, 0x3a, 0x4a, 0x56,
  0x58, 0x5c, 0x5e, 0x2b, 0x32, 0x4f, 0x58, 0x60, 0x60, 0x60, 0x20, 0x44, 0x52, 0x5a, 0x62, 0x5e,
  0x54, 0x1e, 0x2f, 0x4c, 0x5c, 0x64, 0x64, 0x5f, 0x28, 0x3a, 0x50, 0x61, 0x64, 0x64, 0x58, 0x1c,
  0x2e, 0x4d, 0x62, 0x64, 0x64, 0x64, 0x17, 0x2d, 0x52, 0x64, 0x64, 0x64, 0x61, 0x24, 0x3b, 0x53,
  0x64, 0x64, 0x61, 0x5e, 0x2c, 0x3d, 0x4e, 0x5c, 0x64, 0x64, 0x60, 0x1f, 0x3e, 0x5c, 0x64, 0x64,
  0x64, 0x64, 0x32, 0x47, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x28, 0x3a, 0x45, 0x57, 0x64, 0x64, 0x64,
  0x24, 0x33, 0x4a, 0x50, 0x5a, 0x64, 0x64, 0x1d, 0x3d, 0x54, 0x5f, 0x64, 0x64, 0x64, 0x1e, 0x2b,
  0x38, 0x5a, 0x64, 0x64, 0x5f, 0x1a, 0x29, 0x42, 0x5a, 0x5b, 0x60, 0x60, 0x14, 0x22, 0x4d, 0x64,
  0x64, 0x62, 0x5c, 0x21, 0x32, 0x4b, 0x58, 0x64, 0x64, 0x5b, 0x25, 0x32, 0x46, 0x5b, 0x62, 0x62,
  0x64, 0x26, 0x32, 0x4c, 0x5e, 0x64, 0x64, 0x64, 0x0f, 0x1c, 0x3b, 0x58, 0x60, 0x64, 0x5f, 0x1a,
  0x26, 0x37, 0x44, 0x62, 0x64, 0x64, 0x19, 0x28, 0x32, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x2e, 0x46,
  0x5f, 0x5f, 0x62, 0x62, 0x09, 0x1b, 0x46, 0x5c, 0x58, 0x5a, 0x5c, 0x04, 0x0a, 0x28, 0x55, 0x55,
  0x52, 0x4b, 0x09, 0x27, 0x42, 0x54, 0x5a, 0x5b, 0x5a, 0x06, 0x0d, 0x21, 0x52, 0x4e, 0x55, 0x52,
  0x08, 0x11, 0x30, 0x48, 0x48, 0x4b, 0x4c, 0x01, 0x03, 0x0b, 0x44, 0x44, 0x44, 0x49, 0x01, 0x07,
  0x15, 0x34, 0x34, 0x37, 0x38, 0x00, 0x03, 0x08, 0x2a, 0x2e, 0x2b, 0x2f, 0x00, 0x00, 0x01, 0x1c,
  0x1f, 0x18, 0x19, 0x00, 0x00, 0x00, 0x0d, 0x14, 0x13, 0x18, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08,
  0x0f, 0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x05, 0x11, 0x00, 0x00, 0x00, 0x00, 0x03, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x0b, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x09, 0x10, 0x1a, 0x06,
  0x09, 0x0d, 0x12, 0x17, 0x1d, 0x38, 0x09, 0x0f, 0x13, 0x19, 0x1f, 0x27, 0x38, 0x05, 0x08, 0x0c,
  0x0e, 0x12, 0x17, 0x4a, 0x04, 0x08, 0x0b, 0x0e, 0x16, 0x1c, 0x4a, 0x03, 0x06, 0x0b, 0x12, 0x1b,
  0x2d, 0x45, 0x0b, 0x11, 0x17, 0x25, 0x33, 0x36, 0x3d, 0x04, 0x07, 0x0a, 0x0f, 0x1c, 0x20, 0x27,
  0x03, 0x05, 0x07, 0x0b, 0x0d, 0x00, 0x00, 0x10, 0x13, 0x17, 0x19, 0x1d, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x00, 0x2a, 0x2e, 0x35, 0x3c,
  0x4e, 0x2c, 0x00, 0x23, 0x24, 0x1f, 0x0d, 0x08, 0x06, 0x04, 0x2a, 0x1f, 0x17, 0x0e, 0x09, 0x07,
  0x05, 0x22, 0x19, 0x17, 0x07, 0x05, 0x02, 0x01, 0x30, 0x34, 0x33, 0x1b, 0x11, 0x0c, 0x07, 0x4e,
  0x35, 0x2b, 0x26, 0x1b, 0x12, 0x0e, 0x46, 0x44, 0x46, 0x2c, 0x1a, 0x17, 0x12, 0x4f, 0x40, 0x2f,
  0x24, 0x1b, 0x14, 0x0e, 0x43, 0x4b, 0x4b, 0x2b, 0x19, 0x11, 0x0d, 0x51, 0x5b, 0x5d, 0x34, 0x28,
  0x1c, 0x15, 0x55, 0x55, 0x54, 0x36, 0x2b, 0x1f, 0x19, 0x49, 0x4a, 0x4a, 0x2f, 0x24, 0x1a, 0x12,
  0x54, 0x3f, 0x35, 0x2c, 0x1f, 0x18, 0x11, 0x52, 0x56, 0x53, 0x2d, 0x24, 0x1e, 0x19, 0x5a, 0x63,
  0x62, 0x35, 0x27, 0x1e, 0x18, 0x55, 0x4d, 0x3d, 0x2e, 0x1d, 0x11, 0x0e, 0x50, 0x58, 0x56, 0x31,
  0x24, 0x1b, 0x13, 0x4a, 0x43, 0x30, 0x21, 0x17, 0x10, 0x09, 0x5a, 0x63, 0x64, 0x38, 0x25, 0x1c,
  0x14, 0x5f, 0x4f, 0x3e, 0x27, 0x14, 0x0f, 0x07, 0x46, 0x48, 0x48, 0x1a, 0x12, 0x09, 0x05, 0x3a,
  0x39, 0x3a, 0x13, 0x08, 0x04, 0x02, 0x46, 0x1e, 0x17, 0x0f, 0x07, 0x04, 0x03, 0x28, 0x1d, 0x13,
  0x08, 0x05, 0x03, 0x02, 0x2e, 0x0e, 0x09, 0x05, 0x03, 0x02, 0x01, 0x26, 0x15, 0x0e, 0x08, 0x05,
  0x03, 0x02, 0x1e, 0x11, 0x0d, 0x05, 0x03, 0x02, 0x01, 0x23, 0x11, 0x0b, 0x07, 0x05, 0x03, 0x01,
  0x1f, 0x10, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x25, 0x11, 0x0d, 0x08, 0x05, 0x04, 0x03, 0x1a, 0x0b,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0b, 0x06, 0x01, 0x01, 0x01, 0x00, 0x1c, 0x13, 0x10, 0x0a,
  0x07, 0x05, 0x03, 0x1b, 0x10, 0x0c, 0x07, 0x04, 0x03, 0x02, 0x15, 0x09, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x1f, 0x11, 0x0c, 0x09, 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x06, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x02, 0x04, 0x02, 0x03, 0x04, 0x06, 0x0a, 0x11, 0x14, 0x01, 0x02, 0x03,
  0x06, 0x0a, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0b, 0x19, 0x02, 0x03, 0x0b, 0x18, 0x1e, 0x35, 0x47, 0x03, 0x06, 0x10, 0x1c, 0x3b, 0x49, 0x50,
  0x02, 0x06, 0x0c, 0x1d, 0x35, 0x4b, 0x58, 0x06, 0x07, 0x14, 0x27, 0x3a, 0x49, 0x5f, 0x0e, 0x19,
  0x29, 0x33, 0x47, 0x5e, 0x64, 0x0e, 0x12, 0x17, 0x2b, 0x39, 0x4c, 0x58, 0x14, 0x1b, 0x24, 0x30,
  0x3f, 0x51, 0x60, 0x0e, 0x16, 0x21, 0x2b, 0x38, 0x4b, 0x50, 0x0e, 0x18, 0x26, 0x35, 0x48, 0x56,
  0x5d, 0x0a, 0x14, 0x22, 0x34, 0x46, 0x54, 0x5c, 0x11, 0x19, 0x1e, 0x2e, 0x37, 0x3c, 0x41, 0x0e,
  0x14, 0x1f, 0x2d, 0x35, 0x41, 0x45, 0x0f, 0x15, 0x1b, 0x27, 0x2f, 0x3f, 0x44, 0x05, 0x06, 0x0b,
  0x09, 0x0b, 0x11, 0x22, 0x1e, 0x21, 0x24, 0x2a, 0x3e, 0x38, 0x3e, 0x1c, 0x45, 0x50, 0x50, 0x4d,
  0x62, 0x64, 0x0e, 0x47, 0x57, 0x5d, 0x62, 0x64, 0x55, 0x17, 0x20, 0x30, 0x44, 0x53, 0x59, 0x5e,
  0x0b, 0x1d, 0x2b, 0x2c, 0x36, 0x47, 0x5d, 0x07, 0x14, 0x1e, 0x2b, 0x4d, 0x4a, 0x55, 0x0c, 0x1a,
  0x21, 0x19, 0x16, 0x3c, 0x32, 0x00, 0x03, 0x06, 0x06, 0x18, 0x2d, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x1f, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x12, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x01, 0x03, 0x05, 0x04, 0x04, 0x16, 0x18, 0x02,
  0x05, 0x04, 0x08, 0x0f, 0x1e, 0x2c, 0x07, 0x0d, 0x0f, 0x19, 0x23, 0x30, 0x35, 0x1a, 0x21, 0x26,
  0x46, 0x4c, 0x33, 0x2a, 0x18, 0x1d, 0x3a, 0x3e, 0x46, 0x33, 0x4e, 0x04, 0x0a, 0x0e, 0x12, 0x1c,
  0x24, 0x34, 0x04, 0x0a, 0x0d, 0x08, 0x0b, 0x0d, 0x1e, 0x03, 0x04, 0x0b, 0x0e, 0x1e, 0x2b, 0x49,
  0x05, 0x00, 0x00, 0x14, 0x28, 0x32, 0x4b, 0x00, 0x00, 0x0a, 0x19, 0x32, 0x46, 0x3c, 0x19, 0x1e,
  0x1e, 0x14, 0x28, 0x32, 0x00, 0x19, 0x14, 0x23, 0x0f, 0x00, 0x00, 0x00
};

static const unsigned char palette_19_24_Y[] =
{
  0x64, 0x64, 0x64, 0x50, 0x3c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3a, 0x35, 0x64, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x64, 0x00, 0x00, 0x64, 0x01, 0x00, 0x3a, 0x46, 0x5f, 0x64,
  0x64, 0x64, 0x58, 0x46, 0x50, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x47, 0x4d, 0x50, 0x64, 0x64, 0x64,
  0x64, 0x3c, 0x45, 0x50, 0x58, 0x64, 0x64, 0x64, 0x23, 0x30, 0x44, 0x5f, 0x64, 0x5f, 0x62, 0x39,
  0x44, 0x46, 0x64, 0x64, 0x64, 0x64, 0x38, 0x4a, 0x57, 0x5f, 0x64, 0x64, 0x64, 0x2f, 0x3a, 0x4b,
  0x5f, 0x64, 0x64, 0x64, 0x3e, 0x4c, 0x56, 0x64, 0x64, 0x64, 0x55, 0x2a, 0x2f, 0x46, 0x64, 0x64,
  0x64, 0x64, 0x36, 0x45, 0x50, 0x64, 0x64, 0x64, 0x64, 0x20, 0x31, 0x47, 0x5f, 0x64, 0x64, 0x64,
  0x22, 0x32, 0x4d, 0x61, 0x64, 0x64, 0x64, 0x1f, 0x2c, 0x4b, 0x62, 0x64, 0x64, 0x64, 0x27, 0x32,
  0x3e, 0x5a, 0x64, 0x64, 0x64, 0x16, 0x2d, 0x46, 0x5a, 0x5e, 0x64, 0x47, 0x12, 0x26, 0x39, 0x50,
  0x54, 0x54, 0x58, 0x10, 0x15, 0x32, 0x50, 0x5a, 0x4c, 0x51, 0x0a, 0x1c, 0x35, 0x3c, 0x55, 0x41,
  0x36, 0x08, 0x0f, 0x20, 0x4c, 0x4b, 0x47, 0x3b, 0x08, 0x10, 0x23, 0x3c, 0x3c, 0x36, 0x2a, 0x02,
  0x06, 0x15, 0x2e, 0x33, 0x32, 0x2f, 0x05, 0x0c, 0x25, 0x41, 0x42, 0x41, 0x3d, 0x02, 0x05, 0x11,
  0x30, 0x2d, 0x25, 0x24, 0x04, 0x06, 0x08, 0x12, 0x18, 0x1a, 0x1a, 0x00, 0x00, 0x01, 0x12, 0x16,
  0x18, 0x15, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01,
  0x06, 0x09, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x1e, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x0a, 0x13, 0x01, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x17, 0x06, 0x04, 0x00, 0x00,
  0x05, 0x0b, 0x12, 0x06, 0x07, 0x06, 0x01, 0x04, 0x08, 0x14, 0x09, 0x0d, 0x0b, 0x0a, 0x0e, 0x12,
  0x1a, 0x0c, 0x10, 0x14, 0x14, 0x14, 0x1a, 0x1c, 0x07, 0x0c, 0x14, 0x1e, 0x20, 0x23, 0x24, 0x0e,
  0x16, 0x26, 0x31, 0x32, 0x32, 0x2f, 0x12, 0x18, 0x20, 0x2a, 0x2d, 0x30, 0x30, 0x15, 0x1a, 0x26,
  0x2f, 0x31, 0x33, 0x34, 0x18, 0x20, 0x32, 0x3b, 0x3a, 0x3b, 0x3b, 0x0e, 0x11, 0x1e, 0x3a, 0x3c,
  0x3a, 0x3a, 0x17, 0x1c, 0x36, 0x4a, 0x43, 0x42, 0x3e, 0x1a, 0x25, 0x34, 0x46, 0x48, 0x45, 0x46,
  0x1a, 0x21, 0x2a, 0x58, 0x57, 0x54, 0x45, 0x1a, 0x1d, 0x24, 0x5a, 0x62, 0x5d, 0x49, 0x2d, 0x30,
  0x4e, 0x64, 0x62, 0x62, 0x5e, 0x24, 0x2d, 0x3a, 0x61, 0x62, 0x64, 0x59, 0x24, 0x2a, 0x37, 0x5e,
  0x60, 0x62, 0x62, 0x36, 0x48, 0x59, 0x5c, 0x5d, 0x62, 0x5c, 0x36, 0x48, 0x4c, 0x53, 0x62, 0x64,
  0x64, 0x30, 0x42, 0x4f, 0x5a, 0x62, 0x64, 0x64, 0x3a, 0x49, 0x64, 0x64, 0x64, 0x64, 0x64, 0x0a,
  0x0e, 0x10, 0x16, 0x1b, 0x20, 0x35, 0x0a, 0x0d, 0x12, 0x15, 0x1a, 0x1e, 0x2d, 0x0c, 0x10, 0x14,
  0x18, 0x1c, 0x22, 0x3f, 0x07, 0x09, 0x0b, 0x0e, 0x13, 0x15, 0x33, 0x04, 0x05, 0x09, 0x0d, 0x11,
  0x1b, 0x28, 0x08, 0x08, 0x0a, 0x12, 0x21, 0x25, 0x2f, 0x0a, 0x0c, 0x0e, 0x12, 0x18, 0x1e, 0x26,
  0x04, 0x07, 0x09, 0x0d, 0x0e, 0x00, 0x00, 0x12, 0x15, 0x17, 0x19, 0x1c, 0x1f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x3b, 0x23,
  0x2c, 0x24, 0x00, 0x3e, 0x49, 0x4d, 0x2d, 0x23, 0x1c, 0x16, 0x59, 0x50, 0x43, 0x32, 0x27, 0x20,
  0x19, 0x5d, 0x62, 0x61, 0x3a, 0x35, 0x2b, 0x21, 0x47, 0x57, 0x57, 0x37, 0x2a, 0x22, 0x1a, 0x5b,
  0x44, 0x32, 0x2a, 0x21, 0x18, 0x14, 0x5c, 0x5e, 0x61, 0x35, 0x1f, 0x1e, 0x19, 0x47, 0x3c, 0x2b,
  0x21, 0x19, 0x16, 0x10, 0x3f, 0x49, 0x4a, 0x2d, 0x1b, 0x15, 0x12, 0x4c, 0x5c, 0x5f, 0x2b, 0x21,
  0x18, 0x13, 0x36, 0x35, 0x35, 0x11, 0x0a, 0x06, 0x05, 0x34, 0x36, 0x3a, 0x14, 0x0c, 0x09, 0x06,
  0x3b, 0x20, 0x19, 0x12, 0x0d, 0x0a, 0x07, 0x2c, 0x26, 0x20, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0d, 0x09, 0x06, 0x03, 0x02, 0x02, 0x13, 0x0a, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x12, 0x0b, 0x07, 0x04, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x0a, 0x08, 0x05, 0x02, 0x02, 0x01, 0x1e, 0x0f, 0x09, 0x03, 0x02, 0x01, 0x01, 0x17,
  0x0c, 0x09, 0x01, 0x00, 0x01, 0x00, 0x24, 0x0d, 0x0a, 0x07, 0x04, 0x03, 0x03, 0x20, 0x1b, 0x19,
  0x09, 0x06, 0x05, 0x03, 0x22, 0x17, 0x14, 0x0e, 0x0b, 0x08, 0x07, 0x32, 0x24, 0x1a, 0x13, 0x0d,
  0x09, 0x06, 0x3f, 0x3e, 0x40, 0x25, 0x1c, 0x16, 0x12, 0x33, 0x26, 0x1e, 0x17, 0x13, 0x0e, 0x0a,
  0x33, 0x2d, 0x29, 0x1a, 0x14, 0x0e, 0x08, 0x40, 0x29, 0x22, 0x19, 0x13, 0x10, 0x0d, 0x35, 0x30,
  0x2d, 0x18, 0x13, 0x0d, 0x0a, 0x55, 0x55, 0x4f, 0x31, 0x2a, 0x25, 0x1e, 0x4a, 0x42, 0x3e, 0x30,
  0x23, 0x1c, 0x16, 0x62, 0x52, 0x42, 0x33, 0x24, 0x1d, 0x15, 0x64, 0x64, 0x64, 0x49, 0x38, 0x32,
  0x2b, 0x60, 0x4c, 0x39, 0x33, 0x25, 0x1f, 0x1a, 0x22, 0x28, 0x2f, 0x42, 0x50, 0x64, 0x64, 0x1d,
  0x26, 0x2f, 0x3e, 0x4c, 0x64, 0x64, 0x1d, 0x23, 0x2a, 0x34, 0x44, 0x4e, 0x60, 0x09, 0x0e, 0x15,
  0x1c, 0x26, 0x31, 0x3c, 0x04, 0x07, 0x08, 0x0b, 0x0d, 0x0a, 0x08, 0x06, 0x05, 0x07, 0x07, 0x05,
  0x03, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x09, 0x01, 0x01, 0x01, 0x02, 0x04, 0x0a, 0x0c,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x04, 0x07, 0x0a, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x0c, 0x02, 0x01, 0x00, 0x01, 0x03, 0x07, 0x0b, 0x02, 0x01, 0x01, 0x02,
  0x04, 0x08, 0x0f, 0x05, 0x08, 0x09, 0x0e, 0x14, 0x21, 0x27, 0x04, 0x05, 0x08, 0x0e, 0x18, 0x2b,
  0x3a, 0x02, 0x05, 0x08, 0x11, 0x1b, 0x29, 0x38, 0x1e, 0x27, 0x2d, 0x55, 0x5a, 0x64, 0x64, 0x18,
  0x20, 0x2b, 0x40, 0x4f, 0x64, 0x64, 0x18, 0x1e, 0x26, 0x35, 0x43, 0x64, 0x64, 0x19, 0x26, 0x33,
  0x56, 0x61, 0x64, 0x44, 0x63, 0x62, 0x32, 0x45, 0x5f, 0x5f, 0x63, 0x1a, 0x41, 0x50, 0x30, 0x25,
  0x2c, 0x27, 0x03, 0x10, 0x0c, 0x1c, 0x28, 0x43, 0x1f, 0x02, 0x02, 0x05, 0x08, 0x10, 0x17, 0x13,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x13, 0x1d, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x06, 0x08, 0x01, 0x01, 0x06, 0x0c, 0x0e, 0x21, 0x1e, 0x1d,
  0x07, 0x08, 0x15, 0x11, 0x1a, 0x24, 0x1e, 0x1c, 0x20, 0x15, 0x19, 0x37, 0x41, 0x53, 0x5a, 0x53,
  0x46, 0x10, 0x23, 0x3c, 0x50, 0x4b, 0x4f, 0x53, 0x2d, 0x26, 0x24, 0x55, 0x62, 0x2d, 0x50, 0x14,
  0x17, 0x14, 0x21, 0x2d, 0x2d, 0x3b, 0x17, 0x21, 0x28, 0x32, 0x41, 0x5d, 0x64, 0x1a, 0x21, 0x2f,
  0x5c, 0x64, 0x2f, 0x2b, 0x16, 0x1e, 0x35, 0x30, 0x3b, 0x3b, 0x64, 0x0e, 0x11, 0x14, 0x19, 0x24,
  0x2b, 0x41, 0x0d, 0x16, 0x1e, 0x14, 0x18, 0x12, 0x16, 0x02, 0x08, 0x08, 0x0b, 0x11, 0x17, 0x1e,
  0x05, 0x3c, 0x46, 0x23, 0x19, 0x00, 0x00, 0x28, 0x64, 0x23, 0x19, 0x0f, 0x00, 0x00, 0x3c, 0x46,
  0x3c, 0x32, 0x46, 0x55, 0x00, 0x28, 0x1e, 0x0f, 0x05, 0x00, 0x14, 0x1e
};

static const unsigned char palette_19_24_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x02, 0x03, 0x00, 0x5c, 0x00, 0x00,
  0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x1c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1d, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b,
  0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x22, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1e, 0x2d, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x1f, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x38, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x08, 0x28, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x07, 0x20, 0x46,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x20, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0c, 0x33, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x36, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1f,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x36, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x23, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x20, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x16, 0x2b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x32, 0x00, 0x00, 0x00, 0x03, 0x17,
  0x23, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x14, 0x29, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1b, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x05,
  0x1c, 0x2d, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x23, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x2f, 0x00, 0x00, 0x00, 0x0f, 0x20, 0x2b, 0x44, 0x00, 0x00, 0x00,
  0x03, 0x0f, 0x18, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1e, 0x2f, 0x00, 0x00, 0x00, 0x04, 0x10,
  0x20, 0x43, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x3d, 0x00, 0x00, 0x00, 0x02, 0x12, 0x14, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x41, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x34, 0x53, 0x00, 0x00,
  0x00, 0x00, 0x0c, 0x30, 0x49, 0x00, 0x00, 0x00, 0x00, 0x12, 0x38, 0x4d, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x34, 0x48, 0x00, 0x00, 0x05, 0x03, 0x12, 0x2e, 0x4d, 0x00, 0x00, 0x00, 0x04, 0x12, 0x26,
  0x46, 0x00, 0x00, 0x00, 0x03, 0x16, 0x26, 0x3b, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x30, 0x00,
  0x00, 0x00, 0x0e, 0x1a, 0x28, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x32, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x17, 0x41, 0x00, 0x00, 0x00, 0x00, 0x10, 0x26, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x16, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x29, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x18, 0x2c, 0x48,
  0x00, 0x00, 0x00, 0x01, 0x12, 0x2b, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x3a, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x05, 0x18, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x11, 0x23, 0x38, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x19, 0x23, 0x00, 0x00, 0x00, 0x00, 0x16, 0x26, 0x42, 0x0e,
  0x18, 0x1d, 0x2a, 0x37, 0x43, 0x5c, 0x0d, 0x18, 0x23, 0x2d, 0x38, 0x46, 0x57, 0x0f, 0x1a, 0x22,
  0x2d, 0x36, 0x44, 0x5f, 0x0b, 0x15, 0x1d, 0x26, 0x35, 0x3f, 0x5d, 0x08, 0x0c, 0x16, 0x25, 0x33,
  0x46, 0x59, 0x0c, 0x12, 0x1a, 0x32, 0x4e, 0x54, 0x5c, 0x0d, 0x12, 0x1c, 0x2b, 0x41, 0x4c, 0x53,
  0x05, 0x0a, 0x0f, 0x17, 0x1a, 0x64, 0x64, 0x20, 0x26, 0x2c, 0x31, 0x38, 0x40, 0x64, 0x06, 0x0a,
  0x11, 0x18, 0x1d, 0x64, 0x64, 0x1f, 0x25, 0x2b, 0x33, 0x3c, 0x44, 0x64, 0x58, 0x5f, 0x59, 0x50,
  0x5b, 0x54, 0x64, 0x4f, 0x4d, 0x4a, 0x22, 0x16, 0x0e, 0x08, 0x48, 0x33, 0x26, 0x18, 0x10, 0x0a,
  0x05, 0x42, 0x29, 0x1a, 0x07, 0x05, 0x03, 0x01, 0x48, 0x3f, 0x30, 0x16, 0x0e, 0x0a, 0x05, 0x4e,
  0x28, 0x1a, 0x12, 0x0b, 0x06, 0x04, 0x46, 0x22, 0x14, 0x01, 0x00, 0x00, 0x00, 0x49, 0x33, 0x26,
  0x1a, 0x11, 0x0c, 0x07, 0x4e, 0x44, 0x3a, 0x1b, 0x0e, 0x08, 0x06, 0x3d, 0x21, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x48, 0x36, 0x2c, 0x04, 0x00, 0x00, 0x00, 0x50, 0x3f, 0x38, 0x0e, 0x04, 0x01, 0x01,
  0x53, 0x2f, 0x21, 0x15, 0x0a, 0x05, 0x03, 0x49, 0x3e, 0x31, 0x06, 0x01, 0x01, 0x00, 0x32, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x2a, 0x1a, 0x12, 0x08, 0x04, 0x04, 0x39, 0x27, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x44, 0x34, 0x22, 0x14, 0x0b, 0x08, 0x05, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x26, 0x1a, 0x0e, 0x07, 0x05, 0x04, 0x4c, 0x3e, 0x26, 0x08, 0x07, 0x04, 0x03, 0x4d,
  0x3d, 0x2a, 0x04, 0x01, 0x01, 0x01, 0x56, 0x29, 0x1f, 0x16, 0x0c, 0x08, 0x05, 0x53, 0x4f, 0x4a,
  0x13, 0x0a, 0x07, 0x03, 0x54, 0x32, 0x1b, 0x0e, 0x08, 0x05, 0x03, 0x54, 0x3b, 0x2b, 0x19, 0x0f,
  0x0a, 0x06, 0x4b, 0x38, 0x2d, 0x0f, 0x08, 0x04, 0x03, 0x51, 0x30, 0x21, 0x15, 0x0e, 0x08, 0x04,
  0x4c, 0x36, 0x25, 0x03, 0x01, 0x00, 0x00, 0x53, 0x33, 0x27, 0x18, 0x10, 0x0c, 0x08, 0x4c, 0x2f,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x45, 0x2d, 0x19, 0x04, 0x03, 0x02, 0x00, 0x4a, 0x3a, 0x30, 0x1f,
  0x14, 0x0f, 0x09, 0x4f, 0x34, 0x24, 0x16, 0x0c, 0x08, 0x05, 0x44, 0x27, 0x0e, 0x01, 0x00, 0x00,
  0x00, 0x4f, 0x30, 0x1e, 0x19, 0x0e, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0x0e, 0x00,
  0x01, 0x02, 0x05, 0x0b, 0x16, 0x1e, 0x03, 0x06, 0x09, 0x0f, 0x19, 0x23, 0x30, 0x02, 0x05, 0x0a,
  0x12, 0x20, 0x38, 0x52, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x10, 0x12, 0x01, 0x02, 0x06, 0x08, 0x0a, 0x18, 0x36, 0x00, 0x02, 0x02, 0x03, 0x11, 0x30, 0x3f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x01, 0x04, 0x01, 0x05, 0x0c, 0x14, 0x29, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0c, 0x20, 0x01, 0x00, 0x00, 0x02, 0x08, 0x15, 0x2f, 0x01, 0x00, 0x02, 0x07,
  0x0b, 0x1c, 0x3c, 0x01, 0x02, 0x06, 0x0c, 0x17, 0x2b, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x00,
  0x02, 0x02, 0x09, 0x14, 0x25, 0x32, 0x02, 0x04, 0x08, 0x11, 0x1b, 0x3d, 0x46, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x01, 0x00, 0x00, 0x09, 0x1b,
  0x21, 0x45, 0x00, 0x00, 0x00, 0x0e, 0x14, 0x1f, 0x3b, 0x00, 0x01, 0x07, 0x10, 0x17, 0x22, 0x2d,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x12, 0x37, 0x4a, 0x00, 0x00,
  0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x0c, 0x03, 0x1b, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x26, 0x35, 0x00, 0x00, 0x08, 0x1e, 0x23, 0x41, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36,
  0x3a, 0x01, 0x00, 0x00, 0x00, 0x05, 0x15, 0x27, 0x03, 0x08, 0x10, 0x1e, 0x28, 0x3a, 0x44, 0x00,
  0x03, 0x07, 0x0a, 0x1c, 0x26, 0x31, 0x01, 0x00, 0x04, 0x05, 0x0a, 0x17, 0x1f, 0x01, 0x06, 0x0c,
  0x24, 0x34, 0x3d, 0x45, 0x00, 0x0c, 0x12, 0x19, 0x1c, 0x22, 0x2e, 0x08, 0x0f, 0x15, 0x1d, 0x31,
  0x40, 0x55, 0x08, 0x14, 0x20, 0x18, 0x21, 0x26, 0x3c, 0x02, 0x0d, 0x15, 0x1f, 0x33, 0x3f, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x0f,
  0x0a, 0x1e, 0x00, 0x00, 0x28, 0x14, 0x19, 0x19, 0x14, 0x19, 0x19, 0x19
};

// Pantone Solid Uncoated

static const unsigned char palette_19_25_C[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2b, 0x5c, 0x64, 0x64, 0x64, 0x5f, 0x38, 0x00, 0x00,
  0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x5d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x07, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05,
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x0f, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0e, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x01, 0x02, 0x01, 0x00, 0x05,
  0x08, 0x11, 0x01, 0x04, 0x05, 0x00, 0x06, 0x0f, 0x18, 0x01, 0x03, 0x06, 0x09, 0x0c, 0x12, 0x13,
  0x03, 0x06, 0x0e, 0x12, 0x15, 0x21, 0x1f, 0x03, 0x10, 0x1a, 0x1d, 0x26, 0x27, 0x28, 0x05, 0x0b,
  0x13, 0x22, 0x25, 0x2d, 0x2b, 0x07, 0x10, 0x1f, 0x2b, 0x2e, 0x34, 0x37, 0x09, 0x13, 0x32, 0x45,
  0x42, 0x3e, 0x39, 0x14, 0x1e, 0x32, 0x3d, 0x44, 0x46, 0x41, 0x17, 0x24, 0x30, 0x43, 0x49, 0x4a,
  0x4a, 0x1e, 0x2c, 0x42, 0x4e, 0x54, 0x54, 0x54, 0x0c, 0x1b, 0x38, 0x52, 0x56, 0x56, 0x50, 0x19,
  0x26, 0x35, 0x43, 0x5c, 0x5c, 0x5a, 0x1f, 0x30, 0x3c, 0x64, 0x64, 0x64, 0x64, 0x27, 0x38, 0x4c,
  0x64, 0x64, 0x64, 0x64, 0x15, 0x2a, 0x54, 0x64, 0x64, 0x64, 0x64, 0x15, 0x22, 0x4b, 0x64, 0x64,
  0x64, 0x64, 0x1c, 0x44, 0x60, 0x64, 0x64, 0x64, 0x64, 0x20, 0x2c, 0x46, 0x64, 0x64, 0x64, 0x64,
  0x28, 0x3a, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x18, 0x24, 0x3a, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x3d,
  0x54, 0x64, 0x64, 0x64, 0x64, 0x33, 0x44, 0x56, 0x64, 0x64, 0x64, 0x64, 0x23, 0x3c, 0x57, 0x64,
  0x64, 0x64, 0x64, 0x24, 0x39, 0x4f, 0x64, 0x64, 0x64, 0x64, 0x30, 0x44, 0x5e, 0x64, 0x64, 0x64,
  0x64, 0x32, 0x45, 0x59, 0x64, 0x64, 0x64, 0x64, 0x18, 0x29, 0x3e, 0x64, 0x64, 0x64, 0x64, 0x25,
  0x36, 0x55, 0x64, 0x64, 0x64, 0x5f, 0x2e, 0x36, 0x4e, 0x62, 0x64, 0x64, 0x5e, 0x2d, 0x37, 0x4c,
  0x5e, 0x61, 0x64, 0x5c, 0x2f, 0x3f, 0x59, 0x64, 0x64, 0x64, 0x64, 0x1b, 0x21, 0x38, 0x5f, 0x64,
  0x64, 0x64, 0x28, 0x31, 0x54, 0x64, 0x64, 0x64, 0x5f, 0x28, 0x36, 0x4a, 0x5a, 0x64, 0x64, 0x5f,
  0x21, 0x2b, 0x38, 0x60, 0x64, 0x5e, 0x50, 0x22, 0x25, 0x2e, 0x59, 0x5f, 0x5f, 0x53, 0x26, 0x2a,
  0x3e, 0x4b, 0x4e, 0x4e, 0x49, 0x16, 0x1d, 0x25, 0x3f, 0x43, 0x40, 0x35, 0x10, 0x14, 0x1b, 0x2f,
  0x35, 0x33, 0x2b, 0x0a, 0x0f, 0x17, 0x1c, 0x1a, 0x18, 0x16, 0x06, 0x0a, 0x0e, 0x17, 0x18, 0x14,
  0x14, 0x03, 0x03, 0x07, 0x0b, 0x0a, 0x0b, 0x0e, 0x01, 0x01, 0x04, 0x06, 0x06, 0x0b, 0x11, 0x05,
  0x08, 0x0a, 0x0e, 0x12, 0x17, 0x38, 0x05, 0x08, 0x0b, 0x10, 0x13, 0x1b, 0x35, 0x08, 0x0d, 0x11,
  0x16, 0x1c, 0x21, 0x57, 0x06, 0x0c, 0x10, 0x15, 0x1e, 0x26, 0x5b, 0x07, 0x0c, 0x15, 0x21, 0x2d,
  0x43, 0x5a, 0x05, 0x09, 0x0e, 0x15, 0x25, 0x29, 0x34, 0x12, 0x17, 0x1d, 0x26, 0x32, 0x34, 0x37,
  0x02, 0x04, 0x06, 0x09, 0x0b, 0x00, 0x00, 0x0b, 0x0e, 0x10, 0x11, 0x14, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x48, 0x28, 0x25,
  0x64, 0x33, 0x00, 0x1e, 0x20, 0x1f, 0x11, 0x0c, 0x0a, 0x07, 0x18, 0x10, 0x0d, 0x08, 0x06, 0x05,
  0x03, 0x15, 0x09, 0x06, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x11, 0x0d, 0x07, 0x05, 0x03, 0x02, 0x1d,
  0x0d, 0x08, 0x06, 0x04, 0x02, 0x01, 0x15, 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x11, 0x0d,
  0x09, 0x06, 0x04, 0x03, 0x20, 0x19, 0x13, 0x09, 0x04, 0x03, 0x02, 0x14, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1d, 0x0f, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x20, 0x17, 0x13, 0x05, 0x00, 0x00, 0x00,
  0x24, 0x10, 0x0b, 0x08, 0x03, 0x02, 0x01, 0x1e, 0x14, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x2e, 0x37,
  0x38, 0x11, 0x09, 0x04, 0x02, 0x34, 0x2d, 0x25, 0x1b, 0x0d, 0x06, 0x04, 0x38, 0x40, 0x42, 0x23,
  0x17, 0x10, 0x0b, 0x34, 0x2a, 0x1b, 0x0f, 0x09, 0x05, 0x02, 0x47, 0x4c, 0x4b, 0x28, 0x19, 0x0d,
  0x0a, 0x61, 0x54, 0x49, 0x30, 0x1b, 0x13, 0x0a, 0x54, 0x5f, 0x5f, 0x2b, 0x22, 0x15, 0x0e, 0x64,
  0x64, 0x64, 0x40, 0x27, 0x1b, 0x15, 0x64, 0x47, 0x39, 0x2c, 0x1c, 0x15, 0x10, 0x64, 0x64, 0x64,
  0x3b, 0x2b, 0x23, 0x16, 0x64, 0x53, 0x3e, 0x2e, 0x27, 0x1c, 0x13, 0x55, 0x40, 0x2e, 0x23, 0x1a,
  0x12, 0x0d, 0x51, 0x53, 0x52, 0x33, 0x29, 0x20, 0x17, 0x53, 0x3c, 0x2f, 0x27, 0x1f, 0x16, 0x0e,
  0x51, 0x53, 0x53, 0x34, 0x29, 0x20, 0x11, 0x52, 0x30, 0x29, 0x1d, 0x16, 0x11, 0x0c, 0x57, 0x59,
  0x56, 0x32, 0x23, 0x1d, 0x16, 0x36, 0x39, 0x34, 0x21, 0x1b, 0x17, 0x10, 0x34, 0x28, 0x24, 0x1c,
  0x14, 0x10, 0x0a, 0x31, 0x23, 0x1e, 0x16, 0x0e, 0x0a, 0x07, 0x1a, 0x16, 0x19, 0x0f, 0x0a, 0x08,
  0x05, 0x20, 0x15, 0x0f, 0x0e, 0x0a, 0x07, 0x05, 0x01, 0x01, 0x02, 0x02, 0x02, 0x00, 0x00, 0x01,
  0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x03, 0x04, 0x05, 0x07, 0x0b, 0x0d, 0x0f, 0x0c, 0x19, 0x24,
  0x2f, 0x3d, 0x4f, 0x5e, 0x14, 0x25, 0x31, 0x49, 0x5d, 0x64, 0x64, 0x1e, 0x26, 0x41, 0x59, 0x64,
  0x64, 0x64, 0x0d, 0x15, 0x29, 0x37, 0x49, 0x60, 0x64, 0x0a, 0x12, 0x28, 0x3e, 0x60, 0x64, 0x64,
  0x0a, 0x17, 0x27, 0x3c, 0x5b, 0x64, 0x64, 0x04, 0x05, 0x14, 0x28, 0x3b, 0x4a, 0x5a, 0x01, 0x02,
  0x04, 0x08, 0x0e, 0x0f, 0x09, 0x02, 0x03, 0x04, 0x0a, 0x12, 0x1b, 0x17, 0x02, 0x03, 0x05, 0x0a,
  0x12, 0x1b, 0x19, 0x00, 0x01, 0x02, 0x04, 0x07, 0x0c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x05, 0x07, 0x0b, 0x01, 0x02, 0x03, 0x07, 0x0a, 0x0c, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x03, 0x08,
  0x07, 0x0f, 0x00, 0x00, 0x00, 0x04, 0x05, 0x07, 0x12, 0x02, 0x02, 0x03, 0x07, 0x07, 0x09, 0x0d,
  0x02, 0x0f, 0x13, 0x1e, 0x27, 0x33, 0x46, 0x09, 0x1c, 0x28, 0x33, 0x4c, 0x46, 0x44, 0x17, 0x2e,
  0x37, 0x37, 0x3e, 0x5a, 0x48, 0x11, 0x34, 0x4c, 0x64, 0x62, 0x64, 0x64, 0x24, 0x43, 0x5e, 0x64,
  0x5e, 0x64, 0x63, 0x28, 0x3e, 0x4a, 0x62, 0x44, 0x5c, 0x55, 0x21, 0x3c, 0x50, 0x57, 0x5f, 0x53,
  0x5d, 0x09, 0x14, 0x2a, 0x35, 0x37, 0x36, 0x2b, 0x11, 0x14, 0x1f, 0x1e, 0x2c, 0x14, 0x2d, 0x01,
  0x01, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00, 0x02, 0x04, 0x05, 0x06, 0x00, 0x02, 0x04,
  0x09, 0x0b, 0x16, 0x18, 0x00, 0x04, 0x06, 0x08, 0x09, 0x0b, 0x0a, 0x03, 0x05, 0x07, 0x0a, 0x10,
  0x17, 0x24, 0x04, 0x07, 0x0b, 0x12, 0x18, 0x18, 0x28, 0x0a, 0x18, 0x17, 0x21, 0x37, 0x46, 0x63,
  0x5a, 0x23, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x37, 0x14, 0x14,
  0x1e, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x00, 0x05, 0x0a, 0x19, 0x23, 0x14
};

static const unsigned char palette_19_25_M[] =
{
  0x01, 0x04, 0x44, 0x56, 0x5a, 0x64, 0x57, 0x5a, 0x62, 0x55, 0x52, 0x0d, 0x00, 0x38, 0x00, 0x64,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x61, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0a, 0x0d, 0x14, 0x01, 0x02, 0x06, 0x0a, 0x18, 0x12, 0x14, 0x04, 0x05, 0x07, 0x0c, 0x16, 0x1a,
  0x15, 0x06, 0x08, 0x0e, 0x15, 0x1b, 0x1f, 0x1e, 0x05, 0x08, 0x11, 0x1e, 0x23, 0x1e, 0x22, 0x05,
  0x07, 0x0b, 0x1e, 0x24, 0x24, 0x20, 0x0b, 0x15, 0x1c, 0x26, 0x32, 0x2e, 0x2a, 0x0f, 0x16, 0x21,
  0x2d, 0x38, 0x33, 0x31, 0x11, 0x19, 0x20, 0x34, 0x3a, 0x37, 0x28, 0x11, 0x16, 0x23, 0x37, 0x3e,
  0x3d, 0x40, 0x22, 0x2d, 0x34, 0x44, 0x4b, 0x4b, 0x4c, 0x0c, 0x18, 0x2c, 0x40, 0x4a, 0x47, 0x43,
  0x1b, 0x27, 0x32, 0x3e, 0x48, 0x48, 0x4a, 0x18, 0x28, 0x37, 0x44, 0x4a, 0x4e, 0x50, 0x28, 0x2f,
  0x38, 0x44, 0x4c, 0x52, 0x52, 0x1e, 0x32, 0x3d, 0x48, 0x50, 0x55, 0x4f, 0x22, 0x3a, 0x4a, 0x56,
  0x58, 0x5c, 0x5e, 0x2b, 0x32, 0x4f, 0x58, 0x60, 0x60, 0x60, 0x20, 0x44, 0x52, 0x5a, 0x62, 0x5e,
  0x54, 0x1e, 0x2f, 0x4c, 0x5c, 0x64, 0x64, 0x5f, 0x28, 0x3a, 0x50, 0x61, 0x64, 0x64, 0x58, 0x1c,
  0x2e, 0x4d, 0x62, 0x64, 0x64, 0x64, 0x17, 0x2d, 0x52, 0x64, 0x64, 0x64, 0x61, 0x24, 0x3b, 0x53,
  0x64, 0x64, 0x61, 0x5e, 0x2c, 0x3d, 0x4e, 0x5c, 0x64, 0x64, 0x60, 0x1f, 0x3e, 0x5c, 0x64, 0x64,
  0x64, 0x64, 0x32, 0x47, 0x5a, 0x64, 0x64, 0x64, 0x64, 0x28, 0x3a, 0x45, 0x57, 0x64, 0x64, 0x64,
  0x24, 0x33, 0x4a, 0x50, 0x5a, 0x64, 0x64, 0x1d, 0x3d, 0x54, 0x5f, 0x64, 0x64, 0x64, 0x1e, 0x2b,
  0x38, 0x5a, 0x64, 0x64, 0x5f, 0x1a, 0x29, 0x42, 0x5a, 0x5b, 0x60, 0x60, 0x14, 0x22, 0x4d, 0x64,
  0x64, 0x62, 0x5c, 0x21, 0x32, 0x4b, 0x58, 0x64, 0x64, 0x5b, 0x25, 0x32, 0x46, 0x5b, 0x62, 0x62,
  0x64, 0x26, 0x32, 0x4c, 0x5e, 0x64, 0x64, 0x64, 0x0f, 0x1c, 0x3b, 0x58, 0x60, 0x64, 0x5f, 0x1a,
  0x26, 0x37, 0x44, 0x62, 0x64, 0x64, 0x19, 0x28, 0x32, 0x64, 0x64, 0x64, 0x64, 0x1e, 0x2e, 0x46,
  0x5f, 0x5f, 0x62, 0x62, 0x09, 0x1b, 0x46, 0x5c, 0x58, 0x5a, 0x5c, 0x04, 0x0a, 0x28, 0x55, 0x55,
  0x52, 0x4b, 0x09, 0x27, 0x42, 0x54, 0x5a, 0x5b, 0x5a, 0x06, 0x0d, 0x21, 0x52, 0x4e, 0x55, 0x52,
  0x08, 0x11, 0x30, 0x48, 0x48, 0x4b, 0x4c, 0x01, 0x03, 0x0b, 0x44, 0x44, 0x44, 0x49, 0x01, 0x07,
  0x15, 0x34, 0x34, 0x37, 0x38, 0x00, 0x03, 0x08, 0x2a, 0x2e, 0x2b, 0x2f, 0x00, 0x00, 0x01, 0x1c,
  0x1f, 0x18, 0x19, 0x00, 0x00, 0x00, 0x0d, 0x14, 0x13, 0x18, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08,
  0x0f, 0x00, 0x00, 0x00, 0x01, 0x05, 0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x05, 0x11, 0x00, 0x00, 0x00, 0x00, 0x03, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x0b, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x09, 0x10, 0x1a, 0x06,
  0x09, 0x0d, 0x12, 0x17, 0x1d, 0x38, 0x09, 0x0f, 0x13, 0x19, 0x1f, 0x27, 0x38, 0x05, 0x08, 0x0c,
  0x0e, 0x12, 0x17, 0x4a, 0x04, 0x08, 0x0b, 0x0e, 0x16, 0x1c, 0x4a, 0x03, 0x06, 0x0b, 0x12, 0x1b,
  0x2d, 0x45, 0x0b, 0x11, 0x17, 0x25, 0x33, 0x36, 0x3d, 0x04, 0x07, 0x0a, 0x0f, 0x1c, 0x20, 0x27,
  0x03, 0x05, 0x07, 0x0b, 0x0d, 0x00, 0x00, 0x10, 0x13, 0x17, 0x19, 0x1d, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x00, 0x2a, 0x2e, 0x35, 0x3c,
  0x4e, 0x2c, 0x00, 0x23, 0x24, 0x1f, 0x0d, 0x08, 0x06, 0x04, 0x2a, 0x1f, 0x17, 0x0e, 0x09, 0x07,
  0x05, 0x22, 0x19, 0x17, 0x07, 0x05, 0x02, 0x01, 0x30, 0x34, 0x33, 0x1b, 0x11, 0x0c, 0x07, 0x4e,
  0x35, 0x2b, 0x26, 0x1b, 0x12, 0x0e, 0x46, 0x44, 0x46, 0x2c, 0x1a, 0x17, 0x12, 0x4f, 0x40, 0x2f,
  0x24, 0x1b, 0x14, 0x0e, 0x43, 0x4b, 0x4b, 0x2b, 0x19, 0x11, 0x0d, 0x51, 0x5b, 0x5d, 0x34, 0x28,
  0x1c, 0x15, 0x55, 0x55, 0x54, 0x36, 0x2b, 0x1f, 0x19, 0x49, 0x4a, 0x4a, 0x2f, 0x24, 0x1a, 0x12,
  0x54, 0x3f, 0x35, 0x2c, 0x1f, 0x18, 0x11, 0x52, 0x56, 0x53, 0x2d, 0x24, 0x1e, 0x19, 0x5a, 0x63,
  0x62, 0x35, 0x27, 0x1e, 0x18, 0x55, 0x4d, 0x3d, 0x2e, 0x1d, 0x11, 0x0e, 0x50, 0x58, 0x56, 0x31,
  0x24, 0x1b, 0x13, 0x4a, 0x43, 0x30, 0x21, 0x17, 0x10, 0x09, 0x5a, 0x63, 0x64, 0x38, 0x25, 0x1c,
  0x14, 0x5f, 0x4f, 0x3e, 0x27, 0x14, 0x0f, 0x07, 0x46, 0x48, 0x48, 0x1a, 0x12, 0x09, 0x05, 0x3a,
  0x39, 0x3a, 0x13, 0x08, 0x04, 0x02, 0x46, 0x1e, 0x17, 0x0f, 0x07, 0x04, 0x03, 0x28, 0x1d, 0x13,
  0x08, 0x05, 0x03, 0x02, 0x2e, 0x0e, 0x09, 0x05, 0x03, 0x02, 0x01, 0x26, 0x15, 0x0e, 0x08, 0x05,
  0x03, 0x02, 0x1e, 0x11, 0x0d, 0x05, 0x03, 0x02, 0x01, 0x23, 0x11, 0x0b, 0x07, 0x05, 0x03, 0x01,
  0x1f, 0x10, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x25, 0x11, 0x0d, 0x08, 0x05, 0x04, 0x03, 0x1a, 0x0b,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0b, 0x06, 0x01, 0x01, 0x01, 0x00, 0x1c, 0x13, 0x10, 0x0a,
  0x07, 0x05, 0x03, 0x1b, 0x10, 0x0c, 0x07, 0x04, 0x03, 0x02, 0x15, 0x09, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x1f, 0x11, 0x0c, 0x09, 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x06, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x02, 0x04, 0x02, 0x03, 0x04, 0x06, 0x0a, 0x11, 0x14, 0x01, 0x02, 0x03,
  0x06, 0x0a, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x0b, 0x19, 0x02, 0x03, 0x0b, 0x18, 0x1e, 0x35, 0x47, 0x03, 0x06, 0x10, 0x1c, 0x3b, 0x49, 0x50,
  0x02, 0x06, 0x0c, 0x1d, 0x35, 0x4b, 0x58, 0x06, 0x07, 0x14, 0x27, 0x3a, 0x49, 0x5f, 0x0e, 0x19,
  0x29, 0x33, 0x47, 0x5e, 0x64, 0x0e, 0x12, 0x17, 0x2b, 0x39, 0x4c, 0x58, 0x14, 0x1b, 0x24, 0x30,
  0x3f, 0x51, 0x60, 0x0e, 0x16, 0x21, 0x2b, 0x38, 0x4b, 0x50, 0x0e, 0x18, 0x26, 0x35, 0x48, 0x56,
  0x5d, 0x0a, 0x14, 0x22, 0x34, 0x46, 0x54, 0x5c, 0x11, 0x19, 0x1e, 0x2e, 0x37, 0x3c, 0x41, 0x0e,
  0x14, 0x1f, 0x2d, 0x35, 0x41, 0x45, 0x0f, 0x15, 0x1b, 0x27, 0x2f, 0x3f, 0x44, 0x05, 0x06, 0x0b,
  0x09, 0x0b, 0x11, 0x22, 0x1e, 0x21, 0x24, 0x2a, 0x3e, 0x38, 0x3e, 0x1c, 0x45, 0x50, 0x50, 0x4d,
  0x62, 0x64, 0x0e, 0x47, 0x57, 0x5d, 0x62, 0x64, 0x55, 0x17, 0x20, 0x30, 0x44, 0x53, 0x59, 0x5e,
  0x0b, 0x1d, 0x2b, 0x2c, 0x36, 0x47, 0x5d, 0x07, 0x14, 0x1e, 0x2b, 0x4d, 0x4a, 0x55, 0x0c, 0x1a,
  0x21, 0x19, 0x16, 0x3c, 0x32, 0x00, 0x03, 0x06, 0x06, 0x18, 0x2d, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x1f, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0c, 0x12, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x01, 0x03, 0x05, 0x04, 0x04, 0x16, 0x18, 0x02,
  0x05, 0x04, 0x08, 0x0f, 0x1e, 0x2c, 0x07, 0x0d, 0x0f, 0x19, 0x23, 0x30, 0x35, 0x1a, 0x21, 0x26,
  0x46, 0x4c, 0x33, 0x2a, 0x18, 0x1d, 0x3a, 0x3e, 0x46, 0x33, 0x4e, 0x04, 0x0a, 0x0e, 0x12, 0x1c,
  0x24, 0x34, 0x04, 0x0a, 0x0d, 0x08, 0x0b, 0x0d, 0x1e, 0x03, 0x04, 0x0b, 0x0e, 0x1e, 0x2b, 0x49,
  0x05, 0x00, 0x00, 0x14, 0x28, 0x32, 0x4b, 0x00, 0x00, 0x0a, 0x19, 0x32, 0x46, 0x3c, 0x19, 0x1e,
  0x1e, 0x14, 0x28, 0x32, 0x00, 0x19, 0x14, 0x23, 0x0f, 0x00, 0x00, 0x00
};

static const unsigned char palette_19_25_Y[] =
{
  0x64, 0x64, 0x64, 0x50, 0x3c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3a, 0x35, 0x64, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x64, 0x00, 0x00, 0x64, 0x01, 0x00, 0x3a, 0x46, 0x5f, 0x64,
  0x64, 0x64, 0x58, 0x46, 0x50, 0x5f, 0x64, 0x64, 0x64, 0x64, 0x47, 0x4d, 0x50, 0x64, 0x64, 0x64,
  0x64, 0x3c, 0x45, 0x50, 0x58, 0x64, 0x64, 0x64, 0x23, 0x30, 0x44, 0x5f, 0x64, 0x5f, 0x62, 0x39,
  0x44, 0x46, 0x64, 0x64, 0x64, 0x64, 0x38, 0x4a, 0x57, 0x5f, 0x64, 0x64, 0x64, 0x2f, 0x3a, 0x4b,
  0x5f, 0x64, 0x64, 0x64, 0x3e, 0x4c, 0x56, 0x64, 0x64, 0x64, 0x55, 0x2a, 0x2f, 0x46, 0x64, 0x64,
  0x64, 0x64, 0x36, 0x45, 0x50, 0x64, 0x64, 0x64, 0x64, 0x20, 0x31, 0x47, 0x5f, 0x64, 0x64, 0x64,
  0x22, 0x32, 0x4d, 0x61, 0x64, 0x64, 0x64, 0x1f, 0x2c, 0x4b, 0x62, 0x64, 0x64, 0x64, 0x27, 0x32,
  0x3e, 0x5a, 0x64, 0x64, 0x64, 0x16, 0x2d, 0x46, 0x5a, 0x5e, 0x64, 0x47, 0x12, 0x26, 0x39, 0x50,
  0x54, 0x54, 0x58, 0x10, 0x15, 0x32, 0x50, 0x5a, 0x4c, 0x51, 0x0a, 0x1c, 0x35, 0x3c, 0x55, 0x41,
  0x36, 0x08, 0x0f, 0x20, 0x4c, 0x4b, 0x47, 0x3b, 0x08, 0x10, 0x23, 0x3c, 0x3c, 0x36, 0x2a, 0x02,
  0x06, 0x15, 0x2e, 0x33, 0x32, 0x2f, 0x05, 0x0c, 0x25, 0x41, 0x42, 0x41, 0x3d, 0x02, 0x05, 0x11,
  0x30, 0x2d, 0x25, 0x24, 0x04, 0x06, 0x08, 0x12, 0x18, 0x1a, 0x1a, 0x00, 0x00, 0x01, 0x12, 0x16,
  0x18, 0x15, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01,
  0x06, 0x09, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x1e, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x0a, 0x13, 0x01, 0x00, 0x00, 0x00, 0x05, 0x0c, 0x17, 0x06, 0x04, 0x00, 0x00,
  0x05, 0x0b, 0x12, 0x06, 0x07, 0x06, 0x01, 0x04, 0x08, 0x14, 0x09, 0x0d, 0x0b, 0x0a, 0x0e, 0x12,
  0x1a, 0x0c, 0x10, 0x14, 0x14, 0x14, 0x1a, 0x1c, 0x07, 0x0c, 0x14, 0x1e, 0x20, 0x23, 0x24, 0x0e,
  0x16, 0x26, 0x31, 0x32, 0x32, 0x2f, 0x12, 0x18, 0x20, 0x2a, 0x2d, 0x30, 0x30, 0x15, 0x1a, 0x26,
  0x2f, 0x31, 0x33, 0x34, 0x18, 0x20, 0x32, 0x3b, 0x3a, 0x3b, 0x3b, 0x0e, 0x11, 0x1e, 0x3a, 0x3c,
  0x3a, 0x3a, 0x17, 0x1c, 0x36, 0x4a, 0x43, 0x42, 0x3e, 0x1a, 0x25, 0x34, 0x46, 0x48, 0x45, 0x46,
  0x1a, 0x21, 0x2a, 0x58, 0x57, 0x54, 0x45, 0x1a, 0x1d, 0x24, 0x5a, 0x62, 0x5d, 0x49, 0x2d, 0x30,
  0x4e, 0x64, 0x62, 0x62, 0x5e, 0x24, 0x2d, 0x3a, 0x61, 0x62, 0x64, 0x59, 0x24, 0x2a, 0x37, 0x5e,
  0x60, 0x62, 0x62, 0x36, 0x48, 0x59, 0x5c, 0x5d, 0x62, 0x5c, 0x36, 0x48, 0x4c, 0x53, 0x62, 0x64,
  0x64, 0x30, 0x42, 0x4f, 0x5a, 0x62, 0x64, 0x64, 0x3a, 0x49, 0x64, 0x64, 0x64, 0x64, 0x64, 0x0a,
  0x0e, 0x10, 0x16, 0x1b, 0x20, 0x35, 0x0a, 0x0d, 0x12, 0x15, 0x1a, 0x1e, 0x2d, 0x0c, 0x10, 0x14,
  0x18, 0x1c, 0x22, 0x3f, 0x07, 0x09, 0x0b, 0x0e, 0x13, 0x15, 0x33, 0x04, 0x05, 0x09, 0x0d, 0x11,
  0x1b, 0x28, 0x08, 0x08, 0x0a, 0x12, 0x21, 0x25, 0x2f, 0x0a, 0x0c, 0x0e, 0x12, 0x18, 0x1e, 0x26,
  0x04, 0x07, 0x09, 0x0d, 0x0e, 0x00, 0x00, 0x12, 0x15, 0x17, 0x19, 0x1c, 0x1f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x3b, 0x23,
  0x2c, 0x24, 0x00, 0x3e, 0x49, 0x4d, 0x2d, 0x23, 0x1c, 0x16, 0x59, 0x50, 0x43, 0x32, 0x27, 0x20,
  0x19, 0x5d, 0x62, 0x61, 0x3a, 0x35, 0x2b, 0x21, 0x47, 0x57, 0x57, 0x37, 0x2a, 0x22, 0x1a, 0x5b,
  0x44, 0x32, 0x2a, 0x21, 0x18, 0x14, 0x5c, 0x5e, 0x61, 0x35, 0x1f, 0x1e, 0x19, 0x47, 0x3c, 0x2b,
  0x21, 0x19, 0x16, 0x10, 0x3f, 0x49, 0x4a, 0x2d, 0x1b, 0x15, 0x12, 0x4c, 0x5c, 0x5f, 0x2b, 0x21,
  0x18, 0x13, 0x36, 0x35, 0x35, 0x11, 0x0a, 0x06, 0x05, 0x34, 0x36, 0x3a, 0x14, 0x0c, 0x09, 0x06,
  0x3b, 0x20, 0x19, 0x12, 0x0d, 0x0a, 0x07, 0x2c, 0x26, 0x20, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0d, 0x09, 0x06, 0x03, 0x02, 0x02, 0x13, 0x0a, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x12, 0x0b, 0x07, 0x04, 0x03, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x0a, 0x08, 0x05, 0x02, 0x02, 0x01, 0x1e, 0x0f, 0x09, 0x03, 0x02, 0x01, 0x01, 0x17,
  0x0c, 0x09, 0x01, 0x00, 0x01, 0x00, 0x24, 0x0d, 0x0a, 0x07, 0x04, 0x03, 0x03, 0x20, 0x1b, 0x19,
  0x09, 0x06, 0x05, 0x03, 0x22, 0x17, 0x14, 0x0e, 0x0b, 0x08, 0x07, 0x32, 0x24, 0x1a, 0x13, 0x0d,
  0x09, 0x06, 0x3f, 0x3e, 0x40, 0x25, 0x1c, 0x16, 0x12, 0x33, 0x26, 0x1e, 0x17, 0x13, 0x0e, 0x0a,
  0x33, 0x2d, 0x29, 0x1a, 0x14, 0x0e, 0x08, 0x40, 0x29, 0x22, 0x19, 0x13, 0x10, 0x0d, 0x35, 0x30,
  0x2d, 0x18, 0x13, 0x0d, 0x0a, 0x55, 0x55, 0x4f, 0x31, 0x2a, 0x25, 0x1e, 0x4a, 0x42, 0x3e, 0x30,
  0x23, 0x1c, 0x16, 0x62, 0x52, 0x42, 0x33, 0x24, 0x1d, 0x15, 0x64, 0x64, 0x64, 0x49, 0x38, 0x32,
  0x2b, 0x60, 0x4c, 0x39, 0x33, 0x25, 0x1f, 0x1a, 0x22, 0x28, 0x2f, 0x42, 0x50, 0x64, 0x64, 0x1d,
  0x26, 0x2f, 0x3e, 0x4c, 0x64, 0x64, 0x1d, 0x23, 0x2a, 0x34, 0x44, 0x4e, 0x60, 0x09, 0x0e, 0x15,
  0x1c, 0x26, 0x31, 0x3c, 0x04, 0x07, 0x08, 0x0b, 0x0d, 0x0a, 0x08, 0x06, 0x05, 0x07, 0x07, 0x05,
  0x03, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x05, 0x09, 0x01, 0x01, 0x01, 0x02, 0x04, 0x0a, 0x0c,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x04, 0x07, 0x0a, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x0c, 0x02, 0x01, 0x00, 0x01, 0x03, 0x07, 0x0b, 0x02, 0x01, 0x01, 0x02,
  0x04, 0x08, 0x0f, 0x05, 0x08, 0x09, 0x0e, 0x14, 0x21, 0x27, 0x04, 0x05, 0x08, 0x0e, 0x18, 0x2b,
  0x3a, 0x02, 0x05, 0x08, 0x11, 0x1b, 0x29, 0x38, 0x1e, 0x27, 0x2d, 0x55, 0x5a, 0x64, 0x64, 0x18,
  0x20, 0x2b, 0x40, 0x4f, 0x64, 0x64, 0x18, 0x1e, 0x26, 0x35, 0x43, 0x64, 0x64, 0x19, 0x26, 0x33,
  0x56, 0x61, 0x64, 0x44, 0x63, 0x62, 0x32, 0x45, 0x5f, 0x5f, 0x63, 0x1a, 0x41, 0x50, 0x30, 0x25,
  0x2c, 0x27, 0x03, 0x10, 0x0c, 0x1c, 0x28, 0x43, 0x1f, 0x02, 0x02, 0x05, 0x08, 0x10, 0x17, 0x13,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x13, 0x1d, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x06, 0x08, 0x01, 0x01, 0x06, 0x0c, 0x0e, 0x21, 0x1e, 0x1d,
  0x07, 0x08, 0x15, 0x11, 0x1a, 0x24, 0x1e, 0x1c, 0x20, 0x15, 0x19, 0x37, 0x41, 0x53, 0x5a, 0x53,
  0x46, 0x10, 0x23, 0x3c, 0x50, 0x4b, 0x4f, 0x53, 0x2d, 0x26, 0x24, 0x55, 0x62, 0x2d, 0x50, 0x14,
  0x17, 0x14, 0x21, 0x2d, 0x2d, 0x3b, 0x17, 0x21, 0x28, 0x32, 0x41, 0x5d, 0x64, 0x1a, 0x21, 0x2f,
  0x5c, 0x64, 0x2f, 0x2b, 0x16, 0x1e, 0x35, 0x30, 0x3b, 0x3b, 0x64, 0x0e, 0x11, 0x14, 0x19, 0x24,
  0x2b, 0x41, 0x0d, 0x16, 0x1e, 0x14, 0x18, 0x12, 0x16, 0x02, 0x08, 0x08, 0x0b, 0x11, 0x17, 0x1e,
  0x05, 0x3c, 0x46, 0x23, 0x19, 0x00, 0x00, 0x28, 0x64, 0x23, 0x19, 0x0f, 0x00, 0x00, 0x3c, 0x46,
  0x3c, 0x32, 0x46, 0x55, 0x00, 0x28, 0x1e, 0x0f, 0x05, 0x00, 0x14, 0x1e
};

static const unsigned char palette_19_25_K[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x02, 0x03, 0x00, 0x5c, 0x00, 0x00,
  0x00, 0x64, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x1c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1d, 0x26, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b,
  0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x22, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1e, 0x2d, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x1f, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x38, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x08, 0x28, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x07, 0x20, 0x46,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x20, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1a, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0c, 0x33, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x36, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1f,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x36, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x23, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x20, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x16, 0x2b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x32, 0x00, 0x00, 0x00, 0x03, 0x17,
  0x23, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x14, 0x29, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1b, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x05,
  0x1c, 0x2d, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x23, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x2f, 0x00, 0x00, 0x00, 0x0f, 0x20, 0x2b, 0x44, 0x00, 0x00, 0x00,
  0x03, 0x0f, 0x18, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1e, 0x2f, 0x00, 0x00, 0x00, 0x04, 0x10,
  0x20, 0x43, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x3d, 0x00, 0x00, 0x00, 0x02, 0x12, 0x14, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x41, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x34, 0x53, 0x00, 0x00,
  0x00, 0x00, 0x0c, 0x30, 0x49, 0x00, 0x00, 0x00, 0x00, 0x12, 0x38, 0x4d, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x34, 0x48, 0x00, 0x00, 0x05, 0x03, 0x12, 0x2e, 0x4d, 0x00, 0x00, 0x00, 0x04, 0x12, 0x26,
  0x46, 0x00, 0x00, 0x00, 0x03, 0x16, 0x26, 0x3b, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x20, 0x30, 0x00,
  0x00, 0x00, 0x0e, 0x1a, 0x28, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x32, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x17, 0x41, 0x00, 0x00, 0x00, 0x00, 0x10, 0x26, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x16, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x29, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x18, 0x2c, 0x48,
  0x00, 0x00, 0x00, 0x01, 0x12, 0x2b, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x3a, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x18, 0x27, 0x00, 0x00, 0x00, 0x00, 0x05, 0x18, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x11, 0x23, 0x38, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x19, 0x23, 0x00, 0x00, 0x00, 0x00, 0x16, 0x26, 0x42, 0x0e,
  0x18, 0x1d, 0x2a, 0x37, 0x43, 0x5c, 0x0d, 0x18, 0x23, 0x2d, 0x38, 0x46, 0x57, 0x0f, 0x1a, 0x22,
  0x2d, 0x36, 0x44, 0x5f, 0x0b, 0x15, 0x1d, 0x26, 0x35, 0x3f, 0x5d, 0x08, 0x0c, 0x16, 0x25, 0x33,
  0x46, 0x59, 0x0c, 0x12, 0x1a, 0x32, 0x4e, 0x54, 0x5c, 0x0d, 0x12, 0x1c, 0x2b, 0x41, 0x4c, 0x53,
  0x05, 0x0a, 0x0f, 0x17, 0x1a, 0x64, 0x64, 0x20, 0x26, 0x2c, 0x31, 0x38, 0x40, 0x64, 0x06, 0x0a,
  0x11, 0x18, 0x1d, 0x64, 0x64, 0x1f, 0x25, 0x2b, 0x33, 0x3c, 0x44, 0x64, 0x58, 0x5f, 0x59, 0x50,
  0x5b, 0x54, 0x64, 0x4f, 0x4d, 0x4a, 0x22, 0x16, 0x0e, 0x08, 0x48, 0x33, 0x26, 0x18, 0x10, 0x0a,
  0x05, 0x42, 0x29, 0x1a, 0x07, 0x05, 0x03, 0x01, 0x48, 0x3f, 0x30, 0x16, 0x0e, 0x0a, 0x05, 0x4e,
  0x28, 0x1a, 0x12, 0x0b, 0x06, 0x04, 0x46, 0x22, 0x14, 0x01, 0x00, 0x00, 0x00, 0x49, 0x33, 0x26,
  0x1a, 0x11, 0x0c, 0x07, 0x4e, 0x44, 0x3a, 0x1b, 0x0e, 0x08, 0x06, 0x3d, 0x21, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x48, 0x36, 0x2c, 0x04, 0x00, 0x00, 0x00, 0x50, 0x3f, 0x38, 0x0e, 0x04, 0x01, 0x01,
  0x53, 0x2f, 0x21, 0x15, 0x0a, 0x05, 0x03, 0x49, 0x3e, 0x31, 0x06, 0x01, 0x01, 0x00, 0x32, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x2a, 0x1a, 0x12, 0x08, 0x04, 0x04, 0x39, 0x27, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x44, 0x34, 0x22, 0x14, 0x0b, 0x08, 0x05, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x26, 0x1a, 0x0e, 0x07, 0x05, 0x04, 0x4c, 0x3e, 0x26, 0x08, 0x07, 0x04, 0x03, 0x4d,
  0x3d, 0x2a, 0x04, 0x01, 0x01, 0x01, 0x56, 0x29, 0x1f, 0x16, 0x0c, 0x08, 0x05, 0x53, 0x4f, 0x4a,
  0x13, 0x0a, 0x07, 0x03, 0x54, 0x32, 0x1b, 0x0e, 0x08, 0x05, 0x03, 0x54, 0x3b, 0x2b, 0x19, 0x0f,
  0x0a, 0x06, 0x4b, 0x38, 0x2d, 0x0f, 0x08, 0x04, 0x03, 0x51, 0x30, 0x21, 0x15, 0x0e, 0x08, 0x04,
  0x4c, 0x36, 0x25, 0x03, 0x01, 0x00, 0x00, 0x53, 0x33, 0x27, 0x18, 0x10, 0x0c, 0x08, 0x4c, 0x2f,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x45, 0x2d, 0x19, 0x04, 0x03, 0x02, 0x00, 0x4a, 0x3a, 0x30, 0x1f,
  0x14, 0x0f, 0x09, 0x4f, 0x34, 0x24, 0x16, 0x0c, 0x08, 0x05, 0x44, 0x27, 0x0e, 0x01, 0x00, 0x00,
  0x00, 0x4f, 0x30, 0x1e, 0x19, 0x0e, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0x0e, 0x00,
  0x01, 0x02, 0x05, 0x0b, 0x16, 0x1e, 0x03, 0x06, 0x09, 0x0f, 0x19, 0x23, 0x30, 0x02, 0x05, 0x0a,
  0x12, 0x20, 0x38, 0x52, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x10, 0x12, 0x01, 0x02, 0x06, 0x08, 0x0a, 0x18, 0x36, 0x00, 0x02, 0x02, 0x03, 0x11, 0x30, 0x3f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x01, 0x04, 0x01, 0x05, 0x0c, 0x14, 0x29, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0c, 0x20, 0x01, 0x00, 0x00, 0x02, 0x08, 0x15, 0x2f, 0x01, 0x00, 0x02, 0x07,
  0x0b, 0x1c, 0x3c, 0x01, 0x02, 0x06, 0x0c, 0x17, 0x2b, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x00,
  0x02, 0x02, 0x09, 0x14, 0x25, 0x32, 0x02, 0x04, 0x08, 0x11, 0x1b, 0x3d, 0x46, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x01, 0x00, 0x00, 0x09, 0x1b,
  0x21, 0x45, 0x00, 0x00, 0x00, 0x0e, 0x14, 0x1f, 0x3b, 0x00, 0x01, 0x07, 0x10, 0x17, 0x22, 0x2d,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x12, 0x37, 0x4a, 0x00, 0x00,
  0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x0c, 0x03, 0x1b, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x26, 0x35, 0x00, 0x00, 0x08, 0x1e, 0x23, 0x41, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36,
  0x3a, 0x01, 0x00, 0x00, 0x00, 0x05, 0x15, 0x27, 0x03, 0x08, 0x10, 0x1e, 0x28, 0x3a, 0x44, 0x00,
  0x03, 0x07, 0x0a, 0x1c, 0x26, 0x31, 0x01, 0x00, 0x04, 0x05, 0x0a, 0x17, 0x1f, 0x01, 0x06, 0x0c,
  0x24, 0x34, 0x3d, 0x45, 0x00, 0x0c, 0x12, 0x19, 0x1c, 0x22, 0x2e, 0x08, 0x0f, 0x15, 0x1d, 0x31,
  0x40, 0x55, 0x08, 0x14, 0x20, 0x18, 0x21, 0x26, 0x3c, 0x02, 0x0d, 0x15, 0x1f, 0x33, 0x3f, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x0f,
  0x0a, 0x1e, 0x00, 0x00, 0x28, 0x14, 0x19, 0x19, 0x14, 0x19, 0x19, 0x19
};

static const unsigned char palette_0E_0C_L[] =
{
  0xe7, 0xae, 0x83, 0x80, 0x99, 0x1c, 0xe9, 0xe8, 0xea, 0xeb, 0xec, 0xee, 0xf1, 0xe7, 0xea, 0xeb,
  0xec, 0xed, 0xef, 0xf1, 0xd2, 0xd2, 0xdc, 0xdc, 0xe3, 0xe6, 0xe8, 0xc3, 0xc5, 0xcc, 0xcc, 0xd4,
  0xd6, 0xe3, 0xa3, 0xb5, 0xb4, 0xc2, 0xc3, 0xce, 0xd8, 0x78, 0x88, 0x93, 0xa0, 0xb3, 0xc7, 0xd0,
  0xe2, 0xe5, 0xe6, 0xe6, 0xea, 0xec, 0xee, 0xdc, 0xdf, 0xe1, 0xe0, 0xe4, 0xe7, 0xed, 0xcc, 0xce,
  0xd7, 0xd8, 0xe2, 0xe4, 0xe5, 0xba, 0xbc, 0xc3, 0xc5, 0xcd, 0xd0, 0xde, 0xa1, 0xb2, 0xb2, 0xc1,
  0xc4, 0xcc, 0xd6, 0x79, 0x88, 0x94, 0x9f, 0xb0, 0xc2, 0xcc, 0xd5, 0xd7, 0xdb, 0xde, 0xe1, 0xe5,
  0xe9, 0xcc, 0xcf, 0xd2, 0xd6, 0xd9, 0xdd, 0xe2, 0xbe, 0xc1, 0xcc, 0xd0, 0xd8, 0xda, 0xe0, 0xaa,
  0xad, 0xb7, 0xba, 0xc3, 0xc6, 0xd4, 0x93, 0xa6, 0xa6, 0xba, 0xbd, 0xc6, 0xd0, 0x6a, 0x76, 0x84,
  0x92, 0xa6, 0xb8, 0xc2, 0xc1, 0xc5, 0xca, 0xcd, 0xd0, 0xd8, 0xdb, 0xb9, 0xbc, 0xc0, 0xc4, 0xcb,
  0xd2, 0xda, 0xad, 0xb0, 0xbd, 0xc0, 0xca, 0xcf, 0xd2, 0x99, 0x9c, 0xa7, 0xaa, 0xb5, 0xbc, 0xcb,
  0x87, 0x97, 0x9c, 0xab, 0xaf, 0xbb, 0xc5, 0x62, 0x6e, 0x78, 0x85, 0x99, 0xad, 0xbc, 0xac, 0xb3,
  0xc1, 0xcd, 0xda, 0xe1, 0xe9, 0xad, 0xba, 0xc6, 0xd5, 0xdd, 0xe4, 0xec, 0x9b, 0xa1, 0xb5, 0xc1,
  0xd2, 0xd9, 0xe0, 0x90, 0x9c, 0xae, 0xbc, 0xc8, 0xcf, 0xde, 0x77, 0x8a, 0x93, 0xad, 0xb7, 0xc4,
  0xd1, 0x59, 0x6c, 0x7e, 0x97, 0xac, 0xbf, 0xcc, 0xad, 0xb4, 0xbb, 0xc1, 0xc8, 0xce, 0xd5, 0xac,
  0xb0, 0xbb, 0xc1, 0xc8, 0xcc, 0xd2, 0x9b, 0xa3, 0xb0, 0xb5, 0xc0, 0xc6, 0xcd, 0x91, 0x94, 0xa3,
  0xa9, 0xb5, 0xb6, 0xc4, 0x79, 0x8c, 0x92, 0xa4, 0xa9, 0xb4, 0xbe, 0x5b, 0x66, 0x78, 0x89, 0x9a,
  0xaa, 0xb5, 0xad, 0xb2, 0xbd, 0xc2, 0xc8, 0xce, 0xd9, 0xad, 0xb0, 0xb7, 0xc1, 0xc9, 0xd1, 0xdd,
  0x9c, 0xa1, 0xb3, 0xb7, 0xc2, 0xc7, 0xd1, 0x91, 0x95, 0xa2, 0xaa, 0xb6, 0xbf, 0xd1, 0x79, 0x8a,
  0x93, 0xa5, 0xaa, 0xb4, 0xc4, 0x5b, 0x67, 0x76, 0x87, 0x9b, 0xb0, 0xc0, 0xaf, 0xb4, 0xbb, 0xc3,
  0xcc, 0xd2, 0xdd, 0xaf, 0xb4, 0xbf, 0xc6, 0xd0, 0xda, 0xe4, 0x9d, 0xa2, 0xb0, 0xb8, 0xc5, 0xcb,
  0xd6, 0x92, 0x97, 0xa6, 0xae, 0xbc, 0xc5, 0xd7, 0x78, 0x8a, 0x91, 0xa5, 0xad, 0xb9, 0xc7, 0x5a,
  0x68, 0x78, 0x89, 0xa1, 0xb6, 0xc6, 0xb6, 0xb6, 0xbf, 0xc4, 0xcc, 0xd8, 0xe7, 0xb4, 0xbb, 0xc3,
  0xc9, 0xd1, 0xdf, 0xea, 0xa9, 0xaa, 0xb7, 0xbb, 0xc6, 0xd2, 0xdf, 0x9f, 0xa4, 0xaf, 0xb4, 0xc0,
  0xcd, 0xdf, 0x89, 0x95, 0x99, 0xa7, 0xad, 0xbf, 0xd1, 0x69, 0x74, 0x81, 0x8d, 0xa5, 0xbe, 0xce,
  0xb1, 0xb7, 0xbe, 0xc1, 0xcd, 0xd8, 0xe3, 0xa9, 0xb0, 0xb6, 0xbe, 0xc3, 0xcc, 0xdc, 0xa3, 0xa7,
  0xb3, 0xb8, 0xc7, 0xd1, 0xdb, 0x94, 0x98, 0xa0, 0xa6, 0xb1, 0xba, 0xd0, 0x84, 0x93, 0x96, 0xa5,
  0xaf, 0xbf, 0xcd, 0x64, 0x6d, 0x78, 0x87, 0x98, 0xae, 0xc2, 0xa1, 0xa5, 0xac, 0xb5, 0xbf, 0xc9,
  0xd7, 0x99, 0x9e, 0xa6, 0xac, 0xb3, 0xbd, 0xc9, 0x95, 0x98, 0xa5, 0xad, 0xb9, 0xc4, 0xd1, 0x86,
  0x8a, 0x96, 0x9a, 0xa5, 0xad, 0xc0, 0x79, 0x86, 0x8c, 0x9c, 0xa5, 0xb3, 0xc5, 0x5a, 0x67, 0x74,
  0x7e, 0x90, 0xa2, 0xb4, 0x91, 0x95, 0x9c, 0xa0, 0xa7, 0xb4, 0xbe, 0x8a, 0x8e, 0x91, 0x95, 0x9e,
  0xab, 0xbc, 0x85, 0x89, 0x95, 0x99, 0xa4, 0xaf, 0xb9, 0x75, 0x7a, 0x80, 0x84, 0x90, 0x9c, 0xb2,
  0x6c, 0x79, 0x80, 0x8c, 0x91, 0x9f, 0xae, 0x51, 0x5b, 0x64, 0x6b, 0x7e, 0x94, 0xa6, 0x84, 0x89,
  0x97, 0xa8, 0xbe, 0xcd, 0xdc, 0x86, 0x91, 0x9e, 0xb5, 0xc5, 0xd4, 0xe3, 0x7b, 0x7f, 0x90, 0xa0,
  0xb9, 0xc6, 0xd5, 0x76, 0x80, 0x90, 0xa3, 0xb5, 0xc2, 0xd8, 0x63, 0x71, 0x7a, 0x91, 0xa5, 0xb6,
  0xc8, 0x4f, 0x5d, 0x6d, 0x84, 0x9f, 0xb6, 0xcb, 0x86, 0x8b, 0x91, 0x94, 0x9d, 0xa9, 0xb8, 0x86,
  0x8a, 0x94, 0x9a, 0xa0, 0xa9, 0xb4, 0x7b, 0x81, 0x8a, 0x8f, 0x9a, 0xa5, 0xb3, 0x75, 0x77, 0x84,
  0x8a, 0x94, 0x9b, 0xac, 0x63, 0x71, 0x75, 0x83, 0x88, 0x97, 0xa9, 0x4f, 0x57, 0x63, 0x70, 0x80,
  0x90, 0xa0, 0x89, 0x8d, 0x98, 0xa0, 0xa7, 0xae, 0xc1, 0x8a, 0x8c, 0x93, 0xa0, 0xaa, 0xb8, 0xcc,
  0x7d, 0x81, 0x90, 0x97, 0xa2, 0xaa, 0xbd, 0x78, 0x7a, 0x85, 0x8f, 0x9b, 0xa9, 0xc2, 0x64, 0x71,
  0x7a, 0x88, 0x8d, 0x9b, 0xb2, 0x4e, 0x56, 0x62, 0x72, 0x85, 0x9b, 0xb2, 0x8a, 0x8e, 0x97, 0xa2,
  0xae, 0xb9, 0xcd, 0x8b, 0x90, 0x9d, 0xa7, 0xb6, 0xc9, 0xd9, 0x7e, 0x82, 0x8f, 0x9a, 0xa8, 0xb4,
  0xc7, 0x77, 0x7a, 0x8a, 0x93, 0xa4, 0xb4, 0xcd, 0x63, 0x70, 0x77, 0x8b, 0x93, 0xa1, 0xb9, 0x4b,
  0x56, 0x66, 0x76, 0x8d, 0xaa, 0xc0, 0x7f, 0x81, 0x90, 0x9a, 0xaa, 0xc4, 0xde, 0x7e, 0x86, 0x98,
  0xa4, 0xb4, 0xd0, 0xe3, 0x74, 0x75, 0x89, 0x92, 0xa4, 0xbe, 0xd7, 0x6b, 0x74, 0x86, 0x92, 0xa5,
  0xc0, 0xd8, 0x5a, 0x65, 0x71, 0x80, 0x8f, 0xad, 0xca, 0x41, 0x4d, 0x60, 0x73, 0x8c, 0xb0, 0xc8,
  0x79, 0x80, 0x91, 0x9e, 0xaf, 0xc6, 0xda, 0x72, 0x7a, 0x88, 0x96, 0xa3, 0xb5, 0xcc, 0x6e, 0x76,
  0x89, 0x94, 0xaa, 0xc0, 0xd2, 0x60, 0x67, 0x75, 0x84, 0x96, 0xa4, 0xc2, 0x55, 0x64, 0x71, 0x86,
  0x96, 0xaf, 0xc6, 0x3b, 0x45, 0x55, 0x69, 0x7f, 0x9a, 0xb6, 0x73, 0x7c, 0x8a, 0x9d, 0xaa, 0xbb,
  0xce, 0x66, 0x76, 0x8b, 0x94, 0xa1, 0xab, 0xc0, 0x6a, 0x74, 0x84, 0x94, 0xa4, 0xb3, 0xc7, 0x5a,
  0x68, 0x7e, 0x86, 0x94, 0x9d, 0xb4, 0x55, 0x65, 0x6f, 0x86, 0x92, 0xa5, 0xbb, 0x39, 0x49, 0x5c,
  0x6c, 0x7f, 0x93, 0xaa, 0x58, 0x69, 0x7f, 0x89, 0x94, 0x9f, 0xac, 0x49, 0x60, 0x6e, 0x7c, 0x89,
  0x9b, 0xaf, 0x51, 0x61, 0x79, 0x83, 0x90, 0x9b, 0xa9, 0x40, 0x55, 0x65, 0x70, 0x7f, 0x8e, 0xa7,
  0x41, 0x56, 0x67, 0x77, 0x82, 0x8e, 0x9e, 0x2a, 0x3c, 0x4b, 0x5b, 0x70, 0x86, 0x9b, 0x38, 0x50,
  0x75, 0x95, 0xb5, 0xc9, 0xdd, 0x3d, 0x67, 0x84, 0xab, 0xbf, 0xd2, 0xe3, 0x35, 0x4c, 0x6f, 0x8d,
  0xb0, 0xc2, 0xd5, 0x38, 0x5a, 0x76, 0x98, 0xaf, 0xc1, 0xd7, 0x2e, 0x41, 0x5e, 0x80, 0x9a, 0xb1,
  0xc9, 0x25, 0x3f, 0x58, 0x7a, 0x97, 0xb3, 0xc8, 0x43, 0x59, 0x6b, 0x79, 0x88, 0x9b, 0xb2, 0x55,
  0x64, 0x7b, 0x87, 0x92, 0xa0, 0xb1, 0x40, 0x54, 0x67, 0x73, 0x84, 0x97, 0xab, 0x4a, 0x58, 0x6f,
  0x7a, 0x87, 0x93, 0xa7, 0x34, 0x49, 0x57, 0x68, 0x75, 0x8a, 0xa1, 0x30, 0x3d, 0x52, 0x62, 0x77,
  0x8b, 0x9e, 0x5e, 0x6b, 0x80, 0x8d, 0x9b, 0xa9, 0xc0, 0x6c, 0x73, 0x80, 0x97, 0xa7, 0xba, 0xd0,
  0x58, 0x63, 0x78, 0x85, 0x96, 0xa5, 0xbb, 0x60, 0x66, 0x75, 0x86, 0x9b, 0xaa, 0xc5, 0x47, 0x57,
  0x66, 0x7a, 0x85, 0x98, 0xb0, 0x3e, 0x49, 0x56, 0x6c, 0x84, 0x9f, 0xb7, 0x75, 0x80, 0x8c, 0x9d,
  0xac, 0xbc, 0xd3, 0x7c, 0x87, 0x97, 0xa5, 0xbb, 0xcd, 0xdd, 0x6a, 0x77, 0x85, 0x95, 0xa7, 0xb6,
  0xcc, 0x6b, 0x74, 0x87, 0x94, 0xa9, 0xbc, 0xd1, 0x55, 0x66, 0x71, 0x88, 0x95, 0xa7, 0xc0, 0x44,
  0x52, 0x65, 0x79, 0x95, 0xb1, 0xc4, 0x7f, 0x8c, 0xa4, 0xaf, 0xbe, 0xd4, 0xe5, 0x80, 0x95, 0xab,
  0xb8, 0xc9, 0xde, 0xe9, 0x77, 0x83, 0x9e, 0xa7, 0xba, 0xd0, 0xe1, 0x72, 0x85, 0x9d, 0xa9, 0xbb,
  0xcf, 0xe2, 0x61, 0x73, 0x86, 0x99, 0xa7, 0xbf, 0xd6, 0x4c, 0x5d, 0x74, 0x88, 0xa1, 0xc2, 0xd3,
  0x7e, 0x94, 0xa9, 0xb5, 0xc6, 0xd8, 0xe3, 0x7c, 0x90, 0x9f, 0xaf, 0xbe, 0xca, 0xdb, 0x75, 0x88,
  0xa0, 0xad, 0xc2, 0xd1, 0xdd, 0x6f, 0x7f, 0x90, 0x9e, 0xb0, 0xb9, 0xd0, 0x60, 0x78, 0x87, 0x9d,
  0xac, 0xc0, 0xd2, 0x49, 0x5a, 0x6b, 0x81, 0x98, 0xae, 0xc3, 0x82, 0x88, 0x95, 0xa9, 0xb9, 0xcb,
  0xdb, 0x80, 0x8e, 0x9f, 0xa9, 0xb4, 0xc1, 0xd1, 0x79, 0x80, 0x91, 0xa3, 0xb6, 0xc6, 0xd5, 0x72,
  0x7f, 0x93, 0x9b, 0xaa, 0xb4, 0xca, 0x62, 0x6f, 0x79, 0x94, 0xa2, 0xb5, 0xc8, 0x49, 0x59, 0x6d,
  0x7d, 0x91, 0xa8, 0xbb, 0x7b, 0x89, 0x9b, 0xa4, 0xaf, 0xb9, 0xc5, 0x76, 0x8a, 0x93, 0x9e, 0xaa,
  0xb9, 0xc8, 0x73, 0x7f, 0x94, 0x9c, 0xac, 0xb6, 0xbf, 0x67, 0x78, 0x86, 0x8f, 0x9d, 0xab, 0xbf,
  0x5d, 0x6f, 0x7d, 0x90, 0x99, 0xa7, 0xb5, 0x43, 0x54, 0x63, 0x73, 0x89, 0xa0, 0xb2, 0x6a, 0x85,
  0x9f, 0xb6, 0xcb, 0xd7, 0xe4, 0x75, 0x95, 0xac, 0xc5, 0xd2, 0xdd, 0xe8, 0x65, 0x7d, 0x9b, 0xaf,
  0xc6, 0xd3, 0xde, 0x6a, 0x86, 0x9e, 0xb4, 0xc4, 0xd0, 0xe0, 0x54, 0x6e, 0x86, 0xa1, 0xb3, 0xc4,
  0xd5, 0x46, 0x61, 0x78, 0x94, 0xad, 0xc4, 0xd3, 0x7b, 0x8c, 0x9a, 0xa3, 0xac, 0xb9, 0xc8, 0x84,
  0x92, 0xa6, 0xad, 0xb4, 0xbe, 0xc7, 0x73, 0x85, 0x94, 0x9d, 0xa9, 0xb5, 0xc2, 0x77, 0x82, 0x97,
  0x9e, 0xa7, 0xb0, 0xbf, 0x5f, 0x77, 0x80, 0x90, 0x98, 0xa8, 0xba, 0x4f, 0x5e, 0x72, 0x82, 0x94,
  0xa6, 0xb3, 0x89, 0x97, 0xaa, 0xb4, 0xbc, 0xc6, 0xd3, 0x92, 0x97, 0xa7, 0xb8, 0xc3, 0xcf, 0xdd,
  0x81, 0x8f, 0xa5, 0xad, 0xb8, 0xc2, 0xcd, 0x82, 0x89, 0x9c, 0xaa, 0xb8, 0xc2, 0xd4, 0x6a, 0x7e,
  0x90, 0x9f, 0xa6, 0xb4, 0xc4, 0x56, 0x64, 0x79, 0x8d, 0xa2, 0xb8, 0xc8, 0x94, 0xa2, 0xaf, 0xbe,
  0xc7, 0xd1, 0xdf, 0x97, 0xa6, 0xb8, 0xc3, 0xcf, 0xdb, 0xe6, 0x8b, 0x98, 0xa8, 0xb5, 0xc2, 0xcb,
  0xd9, 0x87, 0x93, 0xa7, 0xb2, 0xc1, 0xcb, 0xdb, 0x72, 0x86, 0x93, 0xa9, 0xb1, 0xbd, 0xce, 0x59,
  0x6b, 0x80, 0x93, 0xaa, 0xc1, 0xce, 0x98, 0xa2, 0xb4, 0xbc, 0xc5, 0xd6, 0xe5, 0x99, 0xa9, 0xba,
  0xc3, 0xcd, 0xdf, 0xea, 0x8e, 0x95, 0xac, 0xb3, 0xbf, 0xd0, 0xdf, 0x87, 0x93, 0xa6, 0xad, 0xbc,
  0xcc, 0xde, 0x75, 0x84, 0x92, 0xa2, 0xab, 0xbf, 0xd3, 0x5e, 0x6c, 0x7e, 0x8d, 0xa2, 0xc0, 0xd0,
  0x98, 0xa6, 0xb8, 0xc1, 0xcc, 0xda, 0xe5, 0x99, 0xa6, 0xb4, 0xbe, 0xc7, 0xd0, 0xdc, 0x8d, 0x9a,
  0xaf, 0xb7, 0xc6, 0xd3, 0xdd, 0x85, 0x90, 0xa0, 0xa9, 0xb6, 0xbe, 0xd0, 0x73, 0x87, 0x94, 0xa6,
  0xaf, 0xc1, 0xd1, 0x5d, 0x6b, 0x7c, 0x8a, 0x9e, 0xb3, 0xc5, 0x9b, 0x9c, 0xab, 0xba, 0xc4, 0xd0,
  0xdd, 0x9b, 0xa1, 0xb6, 0xbd, 0xc1, 0xcb, 0xd8, 0x90, 0x91, 0xa4, 0xb0, 0xbd, 0xc9, 0xd6, 0x87,
  0x8c, 0xa2, 0xa9, 0xb2, 0xb9, 0xcd, 0x75, 0x80, 0x8b, 0xa0, 0xa7, 0xb9, 0xc9, 0x5d, 0x67, 0x7d,
  0x8a, 0x99, 0xad, 0xbd, 0x99, 0x9f, 0xb3, 0xba, 0xc0, 0xc4, 0xce, 0x97, 0xa4, 0xb1, 0xb8, 0xc0,
  0xc9, 0xd2, 0x8c, 0x93, 0xab, 0xb1, 0xbb, 0xbf, 0xc9, 0x84, 0x8f, 0x9f, 0xa5, 0xb0, 0xb7, 0xc8,
  0x74, 0x82, 0x91, 0xa1, 0xa6, 0xaf, 0xbc, 0x5e, 0x6b, 0x7b, 0x87, 0x9a, 0xad, 0xbb, 0x9a, 0xa6,
  0xb6, 0xc5, 0xd4, 0xde, 0xe7, 0x9d, 0xb2, 0xbf, 0xd0, 0xd9, 0xe2, 0xeb, 0x8f, 0x9a, 0xaf, 0xbc,
  0xcd, 0xd7, 0xe0, 0x8a, 0x9b, 0xac, 0xb9, 0xc6, 0xce, 0xde, 0x75, 0x87, 0x94, 0xa9, 0xb5, 0xc4,
  0xd1, 0x5e, 0x72, 0x82, 0x96, 0xa9, 0xbf, 0xcd, 0xa7, 0xb0, 0xb6, 0xbc, 0xc2, 0xcd, 0xd7, 0xb7,
  0xbd, 0xc5, 0xc9, 0xcc, 0xd6, 0xdc, 0x9a, 0xa2, 0xad, 0xb3, 0xbd, 0xc7, 0xd0, 0x9f, 0xa4, 0xaf,
  0xb2, 0xba, 0xc3, 0xcf, 0x7f, 0x90, 0x93, 0xa2, 0xa8, 0xb5, 0xc3, 0x6d, 0x78, 0x85, 0x91, 0xa2,
  0xb5, 0xbf, 0xbe, 0xc4, 0xcc, 0xd1, 0xd6, 0xdb, 0xdf, 0xcc, 0xd1, 0xd8, 0xdd, 0xe0, 0xe4, 0xe9,
  0xae, 0xb3, 0xc1, 0xc6, 0xcf, 0xd4, 0xd8, 0xaf, 0xb2, 0xbe, 0xc3, 0xca, 0xce, 0xdb, 0x89, 0x9b,
  0xa2, 0xb2, 0xb4, 0xc0, 0xcb, 0x71, 0x7e, 0x8c, 0x9b, 0xac, 0xbf, 0xcb, 0xd4, 0xda, 0xde, 0xe2,
  0xe3, 0xe7, 0xed, 0xdc, 0xe1, 0xe3, 0xe5, 0xea, 0xeb, 0xed, 0xbf, 0xc3, 0xd0, 0xd3, 0xda, 0xde,
  0xe4, 0xba, 0xbd, 0xc7, 0xc8, 0xd2, 0xd4, 0xdf, 0x96, 0xa8, 0xab, 0xbd, 0xbe, 0xc5, 0xd4, 0x77,
  0x83, 0x91, 0x9f, 0xb2, 0xc5, 0xcf, 0xa9, 0xa4, 0xa1, 0x9f, 0x9b, 0x98, 0x96, 0x99, 0x95, 0x94,
  0x91, 0x8f, 0x8d, 0x8a, 0x8a, 0x87, 0x88, 0x86, 0x85, 0x82, 0x80, 0x7d, 0x7b, 0x7b, 0x7a, 0x78,
  0x75, 0x77, 0x66, 0x68, 0x68, 0x68, 0x6b, 0x6c, 0x6d, 0x58, 0x59, 0x5a, 0x5a, 0x5c, 0x5d, 0x5f,
  0xa4, 0x9b, 0x94, 0x8f, 0x85, 0x7d, 0x79, 0x93, 0x8c, 0x86, 0x80, 0x79, 0x73, 0x6f, 0x86, 0x82,
  0x7c, 0x76, 0x71, 0x6c, 0x67, 0x73, 0x70, 0x6d, 0x68, 0x64, 0x61, 0x5f, 0x69, 0x68, 0x65, 0x62,
  0x5e, 0x5b, 0x59, 0x50, 0x53, 0x53, 0x53, 0x4f, 0x4c, 0x4b, 0xee, 0xe0, 0xd3, 0xc1, 0x98, 0x73,
  0x3d, 0xe7, 0xd9, 0xcc, 0xad, 0x87, 0x5c, 0x32, 0xe7, 0xdb, 0xcf, 0xb9, 0xa1, 0x89, 0x68, 0xe5,
  0xd9, 0xcc, 0xb7, 0xa0, 0x87, 0x69, 0xe4, 0xd2, 0xc7, 0xb0, 0x96, 0x7b, 0x5c, 0xe3, 0xcd, 0xc1,
  0xac, 0x93, 0x73, 0x55, 0xe4, 0xd1, 0xc4, 0xaf, 0x96, 0x79, 0x5b, 0xe5, 0xd4, 0xc6, 0xb4, 0x9b,
  0x81, 0x61, 0x57, 0x57, 0x53, 0x48, 0x45, 0x42, 0x3c, 0x50, 0x4e, 0x48, 0x43, 0x3e, 0x3a, 0x37,
  0x4d, 0x46, 0x41, 0x3a, 0x36, 0x32, 0x30, 0x41, 0x39, 0x2e, 0x30, 0x29, 0x21, 0x26, 0x36, 0x30,
  0x2b, 0x36, 0x33, 0x2f, 0x3b, 0x38, 0x37, 0x33, 0x40, 0x3f, 0x3a, 0x48, 0xa4, 0x93, 0x85, 0x7b,
  0x6c, 0x5f, 0x4e, 0x86, 0x78, 0x6c, 0x62, 0x58, 0x4d, 0x41, 0x61, 0x57, 0x4f, 0x48, 0x43, 0x3b,
  0x31, 0x65, 0x5a, 0x52, 0x4b, 0x44, 0x3b, 0x30, 0x30, 0x2d, 0x29, 0x26, 0x23, 0x20, 0x1c, 0x5f,
  0x54, 0x4b, 0x46, 0x41, 0x39, 0x2f, 0x5f, 0x59, 0x51, 0x4b, 0x45, 0x3f, 0x34, 0x7a, 0x6e, 0x65,
  0x5d, 0x55, 0x4a, 0x3f, 0x7c, 0x72, 0x6a, 0x61, 0x59, 0x50, 0x43, 0x9e, 0x8c, 0x7f, 0x74, 0x68,
  0x5d, 0x4c, 0xf2, 0xf2, 0xf1, 0xf0, 0xf0, 0xef, 0xef, 0xec, 0xea, 0xea, 0xe9, 0xe8, 0xe8, 0xe7,
  0xec, 0xec, 0xea, 0xe9, 0xe8, 0xe8, 0xe7, 0xe6, 0xe5, 0xe3, 0xe2, 0xe1, 0xe1, 0xe1, 0xee, 0xed,
  0xe9, 0xec, 0xea, 0xe7, 0xe5, 0xe5, 0xe1, 0xe0, 0xdf, 0xdd, 0xdc, 0xdb, 0xee, 0xe8, 0xe0, 0xeb,
  0xe5, 0xe1, 0xde, 0xe7, 0xdd, 0xdf, 0xe2, 0xdd, 0xd8, 0xd6, 0xef, 0xeb, 0xe6, 0xed, 0xe9, 0xe7,
  0xe5, 0xea, 0xe4, 0xe4, 0xe6, 0xe2, 0xe0, 0xdf, 0xf0, 0xed, 0xe9, 0xef, 0xed, 0xea, 0xe9, 0xef,
  0xe9, 0xec, 0xee, 0xec, 0xe9, 0xe8
};

static const unsigned char palette_0E_0C_A[] =
{
  0x7f, 0xb7, 0xcf, 0x5c, 0x35, 0x80, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7e, 0x7d, 0x7b, 0x7b,
  0x7b, 0x7b, 0x7d, 0x7f, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7e, 0x7c, 0x7a, 0x7b, 0x7b, 0x7b,
  0x7d, 0x7f, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7e, 0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7d, 0x7f,
  0x83, 0x80, 0x80, 0x80, 0x7d, 0x7f, 0x80, 0x89, 0x86, 0x84, 0x84, 0x83, 0x81, 0x7f, 0x81, 0x7f,
  0x7f, 0x7f, 0x7d, 0x7e, 0x80, 0x85, 0x82, 0x82, 0x80, 0x81, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e,
  0x7d, 0x7e, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x90, 0x8e, 0x8a, 0x88, 0x85, 0x84,
  0x82, 0x99, 0x96, 0x93, 0x91, 0x8e, 0x8b, 0x89, 0x8c, 0x8a, 0x88, 0x86, 0x85, 0x83, 0x82, 0x92,
  0x90, 0x8f, 0x8c, 0x8b, 0x89, 0x87, 0x87, 0x87, 0x85, 0x84, 0x83, 0x82, 0x81, 0x89, 0x89, 0x88,
  0x88, 0x88, 0x87, 0x86, 0xa4, 0xa0, 0x9b, 0x98, 0x95, 0x8f, 0x8b, 0xab, 0xa7, 0xa5, 0xa2, 0x9c,
  0x95, 0x8f, 0x9d, 0x99, 0x97, 0x95, 0x93, 0x8d, 0x8b, 0xa1, 0x9d, 0x9c, 0x99, 0x97, 0x91, 0x8e,
  0x93, 0x94, 0x90, 0x91, 0x8f, 0x8a, 0x89, 0x92, 0x92, 0x92, 0x92, 0x91, 0x8f, 0x8b, 0xb6, 0xb1,
  0xa5, 0x9b, 0x90, 0x8b, 0x86, 0xb6, 0xab, 0xa0, 0x94, 0x8e, 0x89, 0x84, 0xaf, 0xa9, 0xa2, 0x98,
  0x90, 0x8a, 0x86, 0xab, 0xa1, 0x9a, 0x8f, 0x8b, 0x87, 0x84, 0xa1, 0xa2, 0x9a, 0x94, 0x8c, 0x89,
  0x85, 0x98, 0x94, 0x90, 0x8b, 0x88, 0x86, 0x83, 0xb5, 0xb1, 0xab, 0xa5, 0xa0, 0x9b, 0x95, 0xb7,
  0xb3, 0xab, 0xa5, 0xa0, 0x9d, 0x98, 0xae, 0xa8, 0xa5, 0xa0, 0x9d, 0x99, 0x94, 0xab, 0xa9, 0xa2,
  0x9d, 0x9a, 0x99, 0x96, 0xa3, 0xa2, 0x9d, 0x9b, 0x98, 0x95, 0x91, 0x99, 0x9b, 0x96, 0x95, 0x95,
  0x96, 0x93, 0xb7, 0xb3, 0xaa, 0xa6, 0xa0, 0x9c, 0x93, 0xb7, 0xb5, 0xaf, 0xa6, 0xa0, 0x99, 0x90,
  0xb0, 0xac, 0xa5, 0xa2, 0x9e, 0x9a, 0x91, 0xab, 0xaa, 0xa6, 0x9f, 0x9b, 0x95, 0x8e, 0xa2, 0xa3,
  0x9c, 0x9b, 0x98, 0x96, 0x8f, 0x99, 0x9b, 0x99, 0x97, 0x95, 0x92, 0x8c, 0xb6, 0xb2, 0xac, 0xa5,
  0x9e, 0x99, 0x91, 0xb6, 0xb2, 0xa9, 0xa3, 0x9b, 0x93, 0x8a, 0xaf, 0xab, 0xa8, 0xa1, 0x9c, 0x97,
  0x8f, 0xab, 0xa7, 0xa1, 0x9c, 0x96, 0x8f, 0x89, 0xa2, 0xa3, 0x9e, 0x9b, 0x96, 0x93, 0x8d, 0x98,
  0x99, 0x96, 0x94, 0x91, 0x8d, 0x88, 0xb1, 0xb1, 0xa8, 0xa5, 0x9f, 0x94, 0x8a, 0xb1, 0xad, 0xa6,
  0xa1, 0x9a, 0x8f, 0x87, 0xab, 0xaa, 0xa5, 0xa2, 0x9d, 0x93, 0x89, 0xa8, 0xa4, 0x9f, 0x9b, 0x96,
  0x8c, 0x86, 0x9f, 0xa2, 0x9d, 0x9d, 0x98, 0x91, 0x88, 0x96, 0x97, 0x95, 0x94, 0x91, 0x8b, 0x85,
  0xb2, 0xae, 0xa8, 0xa5, 0x9c, 0x94, 0x8d, 0xb6, 0xb2, 0xae, 0xa8, 0xa3, 0x9c, 0x91, 0xad, 0xa9,
  0xa6, 0xa2, 0x9b, 0x93, 0x8c, 0xac, 0xa9, 0xa7, 0xa2, 0x9e, 0x98, 0x90, 0xa2, 0xa2, 0x9d, 0x9d,
  0x96, 0x90, 0x8b, 0x9a, 0x9a, 0x9a, 0x98, 0x98, 0x95, 0x8e, 0xbb, 0xba, 0xb4, 0xad, 0xa6, 0x9e,
  0x94, 0xbf, 0xbc, 0xb6, 0xb2, 0xad, 0xa7, 0x9e, 0xb5, 0xb3, 0xb1, 0xaa, 0xa5, 0x9d, 0x93, 0xb4,
  0xb2, 0xaf, 0xac, 0xa8, 0xa2, 0x9b, 0xa8, 0xac, 0xa8, 0xa5, 0x9f, 0x9a, 0x91, 0xa0, 0xa3, 0xa2,
  0xa3, 0xa2, 0xa0, 0x98, 0xc3, 0xc0, 0xbc, 0xb9, 0xb5, 0xad, 0xa6, 0xc6, 0xc4, 0xc2, 0xc0, 0xbb,
  0xb2, 0xa7, 0xbc, 0xba, 0xb8, 0xb5, 0xb2, 0xaa, 0xa3, 0xbb, 0xb9, 0xba, 0xb8, 0xb4, 0xad, 0xa4,
  0xae, 0xb2, 0xae, 0xaf, 0xab, 0xa6, 0xa1, 0xa5, 0xa9, 0xab, 0xad, 0xad, 0xa9, 0xa1, 0xc8, 0xc6,
  0xbf, 0xb5, 0xa6, 0x9b, 0x90, 0xc8, 0xc2, 0xbb, 0xab, 0xa1, 0x97, 0x8b, 0xc1, 0xbf, 0xbb, 0xb1,
  0xa4, 0x9a, 0x8f, 0xbd, 0xb8, 0xb3, 0xa4, 0x9c, 0x93, 0x8a, 0xb3, 0xb7, 0xb1, 0xac, 0x9f, 0x97,
  0x8e, 0xa7, 0xa7, 0xa5, 0x9e, 0x98, 0x92, 0x89, 0xc8, 0xc5, 0xc2, 0xbf, 0xbb, 0xb3, 0xa9, 0xc7,
  0xc6, 0xc1, 0xbd, 0xb9, 0xb4, 0xac, 0xc1, 0xbe, 0xbe, 0xbb, 0xb8, 0xb1, 0xa7, 0xbe, 0xbc, 0xb9,
  0xb6, 0xb3, 0xaf, 0xa9, 0xb5, 0xb6, 0xb4, 0xb4, 0xb1, 0xac, 0xa4, 0xa8, 0xab, 0xab, 0xab, 0xac,
  0xad, 0xa6, 0xc8, 0xc6, 0xc0, 0xbb, 0xb6, 0xb2, 0xa4, 0xc9, 0xc9, 0xc5, 0xbd, 0xb6, 0xac, 0x9c,
  0xc2, 0xc0, 0xbc, 0xb8, 0xb5, 0xaf, 0xa2, 0xbe, 0xbd, 0xbc, 0xb4, 0xb0, 0xa6, 0x9a, 0xb3, 0xb7,
  0xb1, 0xb1, 0xad, 0xa9, 0x9d, 0xa7, 0xab, 0xac, 0xaa, 0xa8, 0xa3, 0x98, 0xca, 0xc8, 0xc3, 0xbc,
  0xb3, 0xab, 0x9b, 0xcb, 0xc9, 0xc0, 0xb9, 0xae, 0xa0, 0x92, 0xc3, 0xc1, 0xbf, 0xb8, 0xb1, 0xa9,
  0x9a, 0xbf, 0xbd, 0xb8, 0xb1, 0xa9, 0x9d, 0x91, 0xb5, 0xb8, 0xb3, 0xb1, 0xaa, 0xa4, 0x98, 0xa8,
  0xaa, 0xa9, 0xa6, 0xa1, 0x99, 0x8e, 0xd0, 0xcf, 0xc8, 0xc2, 0xb6, 0xa3, 0x90, 0xce, 0xcd, 0xc3,
  0xba, 0xae, 0x9a, 0x8c, 0xc8, 0xc8, 0xc3, 0xbe, 0xb4, 0xa1, 0x8f, 0xc3, 0xc2, 0xbb, 0xb2, 0xa9,
  0x95, 0x89, 0xb9, 0xbe, 0xb8, 0xb8, 0xae, 0x9e, 0x8e, 0xaa, 0xad, 0xaa, 0xa8, 0xa3, 0x95, 0x89,
  0xcb, 0xca, 0xc1, 0xb8, 0xae, 0x9d, 0x8f, 0xc7, 0xc6, 0xc1, 0xba, 0xaf, 0xa6, 0x98, 0xc5, 0xc3,
  0xbd, 0xb5, 0xad, 0x9c, 0x8e, 0xbd, 0xbc, 0xba, 0xb2, 0xa9, 0xa1, 0x96, 0xb6, 0xba, 0xb2, 0xae,
  0xa5, 0x98, 0x8c, 0xa7, 0xaa, 0xaa, 0xa8, 0xa3, 0x9f, 0x94, 0xc0, 0xbf, 0xb9, 0xaf, 0xa8, 0x9e,
  0x93, 0xb9, 0xb4, 0xa9, 0xa6, 0xa2, 0x9f, 0x93, 0xbb, 0xba, 0xb6, 0xad, 0xa7, 0x9e, 0x93, 0xb1,
  0xae, 0xa5, 0xa2, 0xa0, 0x9c, 0x92, 0xae, 0xb2, 0xad, 0xa9, 0xa2, 0x9a, 0x91, 0x9f, 0xa1, 0x9b,
  0x9b, 0x9b, 0x99, 0x90, 0xb0, 0xae, 0xa5, 0xa1, 0x9e, 0xa1, 0x9b, 0xa6, 0xa3, 0x9d, 0x9b, 0x9a,
  0x98, 0x94, 0xad, 0xaa, 0xa3, 0xa0, 0x9e, 0xa1, 0x9a, 0xa1, 0x9e, 0x9a, 0x98, 0x97, 0x95, 0x92,
  0xa4, 0xa5, 0x9d, 0x9d, 0x99, 0x9d, 0x98, 0x95, 0x95, 0x93, 0x93, 0x93, 0x94, 0x92, 0xa4, 0xa0,
  0x99, 0x92, 0x8c, 0x88, 0x85, 0xa4, 0x9b, 0x96, 0x8f, 0x8b, 0x87, 0x84, 0xa0, 0x9d, 0x99, 0x92,
  0x8c, 0x88, 0x85, 0x9f, 0x99, 0x94, 0x8d, 0x8a, 0x86, 0x84, 0x9c, 0x9a, 0x95, 0x90, 0x8b, 0x88,
  0x84, 0x93, 0x91, 0x8f, 0x8a, 0x88, 0x85, 0x83, 0x9a, 0x99, 0x96, 0x94, 0x90, 0x8b, 0x87, 0x8a,
  0x87, 0x88, 0x87, 0x86, 0x80, 0x80, 0x97, 0x96, 0x95, 0x93, 0x90, 0x8c, 0x88, 0x89, 0x86, 0x87,
  0x86, 0x86, 0x7f, 0x81, 0x92, 0x93, 0x91, 0x91, 0x8e, 0x8a, 0x87, 0x85, 0x83, 0x85, 0x85, 0x84,
  0x7f, 0x80, 0x80, 0x7d, 0x7f, 0x7d, 0x7d, 0x7d, 0x80, 0x72, 0x6f, 0x6e, 0x6f, 0x73, 0x77, 0x7b,
  0x7e, 0x7d, 0x7f, 0x7e, 0x7d, 0x7e, 0x81, 0x72, 0x6f, 0x6f, 0x71, 0x75, 0x79, 0x7b, 0x7f, 0x7d,
  0x80, 0x7e, 0x7e, 0x7e, 0x81, 0x76, 0x72, 0x72, 0x73, 0x75, 0x79, 0x7d, 0x6a, 0x68, 0x69, 0x6c,
  0x72, 0x74, 0x77, 0x63, 0x61, 0x66, 0x6b, 0x6e, 0x75, 0x7c, 0x6c, 0x6a, 0x6b, 0x6e, 0x73, 0x74,
  0x77, 0x66, 0x64, 0x69, 0x6d, 0x6f, 0x76, 0x7c, 0x6e, 0x6c, 0x6c, 0x6f, 0x75, 0x76, 0x79, 0x6d,
  0x6a, 0x6d, 0x70, 0x72, 0x78, 0x7c, 0x5c, 0x5b, 0x61, 0x65, 0x6b, 0x73, 0x7b, 0x5a, 0x5d, 0x64,
  0x68, 0x6f, 0x77, 0x7d, 0x5d, 0x5d, 0x63, 0x67, 0x6c, 0x74, 0x7b, 0x5d, 0x60, 0x67, 0x6b, 0x71,
  0x79, 0x7d, 0x62, 0x60, 0x66, 0x68, 0x6e, 0x75, 0x7c, 0x67, 0x67, 0x6b, 0x6e, 0x72, 0x78, 0x7d,
  0x58, 0x5a, 0x61, 0x65, 0x6d, 0x74, 0x79, 0x55, 0x57, 0x5c, 0x62, 0x67, 0x6d, 0x75, 0x5a, 0x5c,
  0x61, 0x66, 0x6e, 0x74, 0x79, 0x59, 0x5b, 0x5f, 0x64, 0x6a, 0x6e, 0x76, 0x60, 0x5f, 0x65, 0x68,
  0x6f, 0x75, 0x7a, 0x65, 0x63, 0x65, 0x69, 0x6c, 0x6f, 0x76, 0x50, 0x53, 0x57, 0x5f, 0x65, 0x6d,
  0x74, 0x4b, 0x4e, 0x56, 0x5b, 0x60, 0x66, 0x6e, 0x53, 0x55, 0x5a, 0x61, 0x67, 0x6e, 0x75, 0x50,
  0x54, 0x5a, 0x5f, 0x63, 0x69, 0x6f, 0x5b, 0x5a, 0x5e, 0x63, 0x69, 0x6e, 0x75, 0x60, 0x5f, 0x62,
  0x63, 0x66, 0x69, 0x6f, 0x44, 0x47, 0x50, 0x55, 0x5b, 0x62, 0x67, 0x3c, 0x41, 0x47, 0x4d, 0x54,
  0x5d, 0x67, 0x48, 0x4b, 0x52, 0x56, 0x5c, 0x63, 0x68, 0x44, 0x48, 0x4c, 0x52, 0x57, 0x60, 0x68,
  0x52, 0x51, 0x59, 0x5a, 0x5f, 0x65, 0x69, 0x59, 0x57, 0x57, 0x59, 0x5c, 0x61, 0x6a, 0x36, 0x3c,
  0x4a, 0x59, 0x66, 0x6e, 0x77, 0x37, 0x46, 0x53, 0x63, 0x6b, 0x73, 0x7a, 0x3a, 0x41, 0x4e, 0x5b,
  0x68, 0x6f, 0x77, 0x3e, 0x4c, 0x57, 0x66, 0x6d, 0x74, 0x7a, 0x46, 0x47, 0x54, 0x5e, 0x6a, 0x71,
  0x78, 0x54, 0x59, 0x60, 0x6a, 0x70, 0x75, 0x7b, 0x35, 0x3d, 0x45, 0x4b, 0x51, 0x59, 0x63, 0x34,
  0x3b, 0x48, 0x4e, 0x54, 0x59, 0x60, 0x39, 0x42, 0x48, 0x4d, 0x53, 0x5a, 0x63, 0x3c, 0x42, 0x4d,
  0x53, 0x57, 0x5b, 0x61, 0x45, 0x48, 0x4f, 0x51, 0x57, 0x5d, 0x66, 0x52, 0x51, 0x58, 0x59, 0x5c,
  0x5d, 0x63, 0x33, 0x3a, 0x48, 0x4e, 0x55, 0x5c, 0x68, 0x35, 0x37, 0x40, 0x4d, 0x57, 0x62, 0x6e,
  0x38, 0x3f, 0x4b, 0x51, 0x57, 0x5e, 0x68, 0x3b, 0x3e, 0x47, 0x54, 0x5c, 0x65, 0x6f, 0x44, 0x45,
  0x53, 0x54, 0x5a, 0x60, 0x6a, 0x52, 0x4e, 0x53, 0x5b, 0x60, 0x66, 0x6f, 0x35, 0x3b, 0x45, 0x51,
  0x5a, 0x62, 0x6e, 0x35, 0x3c, 0x4b, 0x54, 0x5f, 0x6a, 0x74, 0x3a, 0x41, 0x47, 0x52, 0x5a, 0x62,
  0x6e, 0x3d, 0x43, 0x50, 0x59, 0x61, 0x6c, 0x75, 0x45, 0x46, 0x50, 0x57, 0x60, 0x65, 0x70, 0x52,
  0x53, 0x5b, 0x60, 0x66, 0x6e, 0x76, 0x34, 0x38, 0x45, 0x4b, 0x54, 0x65, 0x74, 0x34, 0x3b, 0x4a,
  0x51, 0x5a, 0x6c, 0x78, 0x3a, 0x3d, 0x48, 0x4e, 0x55, 0x65, 0x75, 0x3d, 0x44, 0x50, 0x57, 0x60,
  0x6f, 0x79, 0x47, 0x44, 0x51, 0x53, 0x5c, 0x69, 0x77, 0x53, 0x54, 0x5b, 0x5f, 0x64, 0x71, 0x7a,
  0x34, 0x3a, 0x48, 0x50, 0x5a, 0x68, 0x73, 0x35, 0x3b, 0x45, 0x4d, 0x56, 0x5f, 0x6b, 0x3a, 0x40,
  0x4c, 0x53, 0x5c, 0x69, 0x74, 0x3d, 0x43, 0x4c, 0x54, 0x5a, 0x63, 0x6c, 0x45, 0x47, 0x54, 0x58,
  0x61, 0x6c, 0x75, 0x50, 0x52, 0x57, 0x5b, 0x5f, 0x65, 0x6f, 0x36, 0x36, 0x3f, 0x4b, 0x54, 0x60,
  0x6c, 0x37, 0x3a, 0x48, 0x4e, 0x53, 0x5a, 0x67, 0x3c, 0x3d, 0x42, 0x4d, 0x54, 0x60, 0x6c, 0x40,
  0x43, 0x4e, 0x54, 0x58, 0x5f, 0x69, 0x48, 0x44, 0x4b, 0x52, 0x5a, 0x63, 0x6e, 0x53, 0x52, 0x59,
  0x5b, 0x5c, 0x60, 0x6a, 0x37, 0x3a, 0x47, 0x4c, 0x52, 0x55, 0x5f, 0x38, 0x3e, 0x46, 0x4c, 0x51,
  0x59, 0x62, 0x3d, 0x3f, 0x4a, 0x4f, 0x54, 0x57, 0x60, 0x41, 0x47, 0x4e, 0x53, 0x57, 0x5d, 0x65,
  0x48, 0x46, 0x52, 0x55, 0x5a, 0x5c, 0x62, 0x53, 0x54, 0x59, 0x5a, 0x5c, 0x60, 0x66, 0x3b, 0x40,
  0x4b, 0x57, 0x64, 0x6c, 0x76, 0x3c, 0x48, 0x52, 0x60, 0x67, 0x71, 0x79, 0x41, 0x46, 0x4e, 0x5a,
  0x64, 0x6d, 0x76, 0x45, 0x50, 0x58, 0x64, 0x6b, 0x73, 0x7a, 0x4b, 0x4c, 0x56, 0x5d, 0x68, 0x70,
  0x77, 0x57, 0x5c, 0x61, 0x69, 0x6d, 0x73, 0x7a, 0x42, 0x48, 0x4b, 0x50, 0x55, 0x5e, 0x67, 0x4f,
  0x53, 0x58, 0x5b, 0x5d, 0x66, 0x6b, 0x47, 0x4d, 0x4e, 0x53, 0x57, 0x60, 0x68, 0x56, 0x5a, 0x5d,
  0x60, 0x62, 0x69, 0x6c, 0x52, 0x53, 0x57, 0x58, 0x5c, 0x63, 0x6a, 0x63, 0x64, 0x66, 0x66, 0x66,
  0x6a, 0x6d, 0x59, 0x5c, 0x60, 0x63, 0x67, 0x6b, 0x6f, 0x66, 0x69, 0x6c, 0x6e, 0x70, 0x73, 0x77,
  0x5d, 0x60, 0x62, 0x65, 0x67, 0x6b, 0x6f, 0x6a, 0x6c, 0x6e, 0x71, 0x72, 0x74, 0x78, 0x64, 0x65,
  0x68, 0x69, 0x6b, 0x6e, 0x71, 0x71, 0x71, 0x72, 0x73, 0x73, 0x75, 0x78, 0x6d, 0x6f, 0x71, 0x72,
  0x72, 0x76, 0x7a, 0x74, 0x76, 0x75, 0x75, 0x79, 0x7a, 0x7b, 0x6e, 0x70, 0x71, 0x73, 0x73, 0x76,
  0x7a, 0x75, 0x77, 0x76, 0x76, 0x79, 0x7a, 0x7c, 0x72, 0x72, 0x73, 0x74, 0x74, 0x76, 0x7b, 0x77,
  0x78, 0x78, 0x77, 0x79, 0x7a, 0x7c, 0x91, 0x95, 0x99, 0x9c, 0x9f, 0xa3, 0xa4, 0x8d, 0x91, 0x95,
  0x99, 0x9b, 0x9e, 0xa0, 0x8c, 0x8f, 0x92, 0x95, 0x98, 0x9b, 0x9c, 0x8b, 0x8e, 0x91, 0x93, 0x97,
  0x9a, 0x99, 0x8f, 0x90, 0x93, 0x95, 0x96, 0x96, 0x95, 0x8a, 0x8c, 0x8f, 0x91, 0x92, 0x92, 0x92,
  0x93, 0x9a, 0xa0, 0xa5, 0xab, 0xb0, 0xb3, 0x91, 0x96, 0x9d, 0xa2, 0xa7, 0xac, 0xae, 0x8f, 0x94,
  0x9a, 0xa0, 0xa4, 0xa8, 0xab, 0x8f, 0x94, 0x99, 0x9e, 0xa3, 0xa6, 0xa8, 0x8c, 0x8f, 0x93, 0x97,
  0x9c, 0xa0, 0xa2, 0x8a, 0x8d, 0x90, 0x94, 0x98, 0x9b, 0x9d, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x82, 0x82, 0x82, 0x81, 0x82,
  0x83, 0x82, 0x83, 0x84, 0x86, 0x83, 0x82, 0x88, 0x87, 0x89, 0x8a, 0x8e, 0x8d, 0x83, 0x89, 0x88,
  0x85, 0x86, 0x8c, 0x8e, 0x7f, 0x79, 0x7a, 0x78, 0x77, 0x72, 0x73, 0x7e, 0x77, 0x78, 0x7a, 0x79,
  0x74, 0x73, 0x7e, 0x7d, 0x7c, 0x84, 0x83, 0x83, 0x84, 0x81, 0x83, 0x85, 0x86, 0x86, 0x86, 0x87,
  0x85, 0x89, 0x8c, 0x8f, 0x8e, 0x8e, 0x8f, 0x90, 0x97, 0x9b, 0x89, 0x8e, 0x91, 0x88, 0x7b, 0x77,
  0x72, 0x73, 0x6f, 0x6c, 0x6b, 0x78, 0x72, 0x68, 0x76, 0x70, 0x65, 0x71, 0x82, 0x81, 0x80, 0x7f,
  0x7f, 0x7f, 0x7e, 0xa6, 0xa1, 0x9e, 0x9b, 0x98, 0x94, 0x90, 0xb8, 0xb2, 0xad, 0xaa, 0xa6, 0xa1,
  0x9a, 0xbc, 0xb6, 0xb2, 0xae, 0xab, 0xa5, 0x9e, 0x9a, 0x99, 0x97, 0x96, 0x93, 0x91, 0x8e, 0x6a,
  0x70, 0x71, 0x72, 0x73, 0x74, 0x77, 0x43, 0x48, 0x4e, 0x52, 0x56, 0x5a, 0x62, 0x46, 0x4c, 0x51,
  0x55, 0x5a, 0x5e, 0x65, 0x4f, 0x54, 0x58, 0x5b, 0x5f, 0x63, 0x69, 0x73, 0x74, 0x75, 0x76, 0x77,
  0x78, 0x79, 0x80, 0x7f, 0x7e, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x82, 0x81, 0x81, 0x80,
  0x84, 0x83, 0x85, 0x87, 0x87, 0x86, 0x86, 0x84, 0x83, 0x84, 0x86, 0x85, 0x85, 0x85, 0x84, 0x84,
  0x88, 0x85, 0x86, 0x88, 0x89, 0x8a, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x84, 0x88, 0x8e, 0x82,
  0x86, 0x8a, 0x8d, 0x80, 0x88, 0x83, 0x7e, 0x82, 0x86, 0x89, 0x7f, 0x7d, 0x7a, 0x7d, 0x7b, 0x7a,
  0x79, 0x7a, 0x76, 0x75, 0x75, 0x74, 0x73, 0x73, 0x7e, 0x7b, 0x76, 0x7d, 0x7a, 0x78, 0x77, 0x7d,
  0x76, 0x79, 0x7c, 0x79, 0x76, 0x75
};

static const unsigned char palette_0E_0C_B[] =
{
  0xe3, 0xd6, 0x7a, 0x4c, 0xa2, 0x7f, 0xd1, 0xd0, 0xc9, 0xc8, 0xbe, 0xa9, 0x93, 0xd1, 0xce, 0xc4,
  0xbe, 0xb4, 0x9e, 0x8e, 0xc7, 0xc6, 0xc3, 0xc1, 0xbc, 0xa8, 0x91, 0xc2, 0xbe, 0xb8, 0xb4, 0xac,
  0x99, 0x8b, 0xb5, 0xbc, 0xb4, 0xb9, 0xb1, 0xa2, 0x8e, 0xa5, 0xa8, 0xa7, 0xa8, 0xa4, 0x96, 0x8a,
  0xd2, 0xce, 0xc7, 0xc1, 0xb5, 0xa4, 0x94, 0xd2, 0xcf, 0xcb, 0xc5, 0xbc, 0xb2, 0x9e, 0xc8, 0xc3,
  0xc1, 0xba, 0xb3, 0xa4, 0x93, 0xc3, 0xc0, 0xc0, 0xba, 0xb4, 0xac, 0x9c, 0xb7, 0xba, 0xb3, 0xb3,
  0xaa, 0x9e, 0x90, 0xa9, 0xab, 0xad, 0xad, 0xac, 0xa8, 0x98, 0xd2, 0xd1, 0xcc, 0xc5, 0xba, 0xad,
  0x9e, 0xd3, 0xd0, 0xc8, 0xc3, 0xbe, 0xb6, 0xa6, 0xc6, 0xc6, 0xc5, 0xbd, 0xb7, 0xaa, 0x9c, 0xc3,
  0xc0, 0xbb, 0xb7, 0xb5, 0xae, 0xa2, 0xb4, 0xba, 0xb7, 0xb5, 0xaf, 0xa6, 0x9a, 0xa7, 0xaa, 0xaa,
  0xab, 0xae, 0xab, 0xa0, 0xd8, 0xd2, 0xca, 0xc6, 0xc2, 0xbd, 0xb3, 0xdb, 0xd5, 0xd1, 0xcd, 0xc5,
  0xbd, 0xb1, 0xca, 0xc7, 0xc5, 0xc0, 0xbe, 0xba, 0xb1, 0xc8, 0xc4, 0xc3, 0xc0, 0xbe, 0xb6, 0xae,
  0xb9, 0xbd, 0xb6, 0xb8, 0xb5, 0xb3, 0xad, 0xac, 0xae, 0xaf, 0xb1, 0xb4, 0xb1, 0xa8, 0xdf, 0xdb,
  0xce, 0xbd, 0xaa, 0x9f, 0x92, 0xdf, 0xd5, 0xc6, 0xb1, 0xa3, 0x98, 0x8d, 0xd5, 0xd1, 0xc9, 0xb9,
  0xa7, 0x9d, 0x91, 0xce, 0xc5, 0xbb, 0xa8, 0x9f, 0x96, 0x8c, 0xbf, 0xc3, 0xbb, 0xb3, 0xa2, 0x9a,
  0x8f, 0xab, 0xad, 0xaa, 0xa0, 0x9a, 0x93, 0x8a, 0xdc, 0xd8, 0xd2, 0xcc, 0xc3, 0xb8, 0xac, 0xda,
  0xd6, 0xcc, 0xc5, 0xbc, 0xb5, 0xad, 0xd0, 0xcb, 0xca, 0xc4, 0xbe, 0xb6, 0xaa, 0xc8, 0xc5, 0xc0,
  0xb9, 0xb4, 0xaf, 0xa9, 0xbd, 0xc1, 0xbc, 0xbc, 0xb5, 0xb0, 0xa7, 0xaa, 0xae, 0xad, 0xad, 0xad,
  0xac, 0xa6, 0xd9, 0xd5, 0xcb, 0xc3, 0xb9, 0xb1, 0xa3, 0xd6, 0xd3, 0xcb, 0xbe, 0xb4, 0xa8, 0x9a,
  0xce, 0xca, 0xc3, 0xbd, 0xb7, 0xaf, 0xa1, 0xc5, 0xc3, 0xbf, 0xb4, 0xae, 0xa2, 0x98, 0xb9, 0xbe,
  0xb6, 0xb4, 0xad, 0xa9, 0x9e, 0xa7, 0xac, 0xac, 0xa9, 0xa6, 0xa0, 0x96, 0xd3, 0xcf, 0xc6, 0xbb,
  0xae, 0xa6, 0x98, 0xd1, 0xcd, 0xbf, 0xb5, 0xa7, 0x9b, 0x90, 0xc8, 0xc5, 0xc0, 0xb5, 0xac, 0xa5,
  0x96, 0xc1, 0xbe, 0xb5, 0xac, 0xa1, 0x97, 0x8e, 0xb5, 0xb8, 0xb2, 0xad, 0xa4, 0x9e, 0x94, 0xa5,
  0xa8, 0xa5, 0xa2, 0x9c, 0x94, 0x8d, 0xca, 0xca, 0xbd, 0xb7, 0xab, 0x9b, 0x8d, 0xc8, 0xc4, 0xb8,
  0xb0, 0xa4, 0x94, 0x89, 0xc2, 0xc0, 0xb8, 0xb2, 0xaa, 0x9a, 0x8d, 0xbc, 0xb9, 0xb0, 0xa8, 0x9f,
  0x90, 0x88, 0xb1, 0xb5, 0xae, 0xae, 0xa4, 0x97, 0x8b, 0xa3, 0xa5, 0xa2, 0xa1, 0x9a, 0x90, 0x87,
  0xc4, 0xc0, 0xb5, 0xae, 0xa4, 0x97, 0x8c, 0xc1, 0xbd, 0xb8, 0xb0, 0xa6, 0x9f, 0x93, 0xbd, 0xba,
  0xb3, 0xab, 0xa3, 0x97, 0x8b, 0xb6, 0xb4, 0xb1, 0xaa, 0xa1, 0x9b, 0x92, 0xae, 0xb1, 0xa8, 0xa6,
  0x9c, 0x93, 0x8a, 0xa0, 0xa1, 0xa1, 0x9f, 0x9c, 0x98, 0x90, 0xc6, 0xc5, 0xbd, 0xb2, 0xa7, 0x9b,
  0x91, 0xc2, 0xbd, 0xb0, 0xa8, 0xa2, 0x9d, 0x92, 0xbe, 0xbe, 0xb9, 0xae, 0xa6, 0x9a, 0x8f, 0xb7,
  0xb4, 0xa9, 0xa4, 0x9e, 0x99, 0x8f, 0xaf, 0xb4, 0xb0, 0xaa, 0xa0, 0x98, 0x8e, 0xa0, 0xa2, 0x9f,
  0x9d, 0x9a, 0x98, 0x8e, 0xbe, 0xb9, 0xaf, 0xa9, 0xa2, 0xa0, 0x9a, 0xb9, 0xb0, 0xa9, 0xa4, 0xa0,
  0x9a, 0x93, 0xb6, 0xb2, 0xa9, 0xa4, 0x9f, 0x9e, 0x98, 0xb0, 0xa7, 0xa3, 0x9e, 0x9b, 0x97, 0x91,
  0xa9, 0xaa, 0xa2, 0xa0, 0x9b, 0x9b, 0x95, 0x9c, 0x9a, 0x98, 0x98, 0x96, 0x94, 0x90, 0xb1, 0xab,
  0xa2, 0x97, 0x8d, 0x89, 0x85, 0xaf, 0xa5, 0x9c, 0x91, 0x8b, 0x87, 0x84, 0xab, 0xa5, 0x9f, 0x95,
  0x8d, 0x88, 0x84, 0xa6, 0x9f, 0x97, 0x8e, 0x89, 0x85, 0x83, 0x9f, 0x9f, 0x99, 0x93, 0x8b, 0x87,
  0x84, 0x97, 0x94, 0x90, 0x8a, 0x88, 0x85, 0x83, 0xa8, 0xa4, 0xa1, 0x9e, 0x96, 0x8f, 0x89, 0x9b,
  0x98, 0x93, 0x90, 0x8d, 0x86, 0x84, 0xa2, 0x9f, 0x9d, 0x99, 0x94, 0x8e, 0x89, 0x96, 0x93, 0x8f,
  0x8d, 0x8b, 0x84, 0x84, 0x9a, 0x9a, 0x97, 0x94, 0x90, 0x8b, 0x87, 0x8c, 0x8a, 0x89, 0x88, 0x88,
  0x83, 0x82, 0x94, 0x8f, 0x8d, 0x89, 0x86, 0x83, 0x84, 0x88, 0x83, 0x80, 0x7d, 0x7d, 0x7d, 0x7e,
  0x8f, 0x8c, 0x8a, 0x88, 0x86, 0x83, 0x83, 0x83, 0x80, 0x7d, 0x7b, 0x7b, 0x7c, 0x7e, 0x89, 0x89,
  0x86, 0x85, 0x83, 0x81, 0x82, 0x80, 0x7f, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x81, 0x7d, 0x7b, 0x7a,
  0x7c, 0x7a, 0x7b, 0x7a, 0x76, 0x76, 0x78, 0x76, 0x7a, 0x7e, 0x7f, 0x7b, 0x7a, 0x79, 0x7b, 0x7a,
  0x7b, 0x78, 0x76, 0x76, 0x77, 0x77, 0x7a, 0x7e, 0x7d, 0x7a, 0x79, 0x79, 0x7b, 0x7a, 0x7b, 0x79,
  0x77, 0x77, 0x78, 0x77, 0x7a, 0x7e, 0x76, 0x76, 0x72, 0x72, 0x73, 0x77, 0x7c, 0x74, 0x73, 0x72,
  0x72, 0x74, 0x79, 0x7e, 0x75, 0x74, 0x72, 0x71, 0x73, 0x77, 0x7c, 0x73, 0x73, 0x72, 0x73, 0x74,
  0x7a, 0x7e, 0x75, 0x74, 0x72, 0x72, 0x73, 0x77, 0x7c, 0x76, 0x75, 0x74, 0x74, 0x75, 0x79, 0x7d,
  0x70, 0x70, 0x6e, 0x6f, 0x72, 0x76, 0x7a, 0x6c, 0x6c, 0x6c, 0x6d, 0x6e, 0x72, 0x78, 0x70, 0x70,
  0x6e, 0x6f, 0x72, 0x76, 0x7a, 0x6c, 0x6c, 0x6c, 0x6e, 0x6f, 0x73, 0x78, 0x71, 0x70, 0x70, 0x70,
  0x73, 0x77, 0x7b, 0x72, 0x71, 0x70, 0x70, 0x70, 0x73, 0x79, 0x65, 0x66, 0x67, 0x6b, 0x6e, 0x72,
  0x77, 0x5d, 0x5e, 0x62, 0x65, 0x68, 0x6b, 0x71, 0x66, 0x68, 0x68, 0x6b, 0x6d, 0x71, 0x76, 0x60,
  0x62, 0x65, 0x67, 0x6a, 0x6d, 0x71, 0x69, 0x69, 0x6a, 0x6c, 0x6f, 0x72, 0x76, 0x6a, 0x69, 0x6a,
  0x6b, 0x6c, 0x6e, 0x72, 0x53, 0x57, 0x5c, 0x5f, 0x62, 0x68, 0x6b, 0x4a, 0x50, 0x53, 0x58, 0x5c,
  0x63, 0x6a, 0x57, 0x5a, 0x5d, 0x60, 0x63, 0x68, 0x6c, 0x51, 0x56, 0x58, 0x5c, 0x60, 0x66, 0x6c,
  0x5e, 0x5e, 0x62, 0x63, 0x66, 0x6a, 0x6d, 0x61, 0x61, 0x61, 0x62, 0x63, 0x67, 0x6c, 0x45, 0x4a,
  0x55, 0x60, 0x6b, 0x72, 0x79, 0x46, 0x51, 0x5a, 0x67, 0x6e, 0x75, 0x7b, 0x49, 0x4f, 0x57, 0x61,
  0x6b, 0x72, 0x79, 0x4d, 0x56, 0x5e, 0x69, 0x6f, 0x76, 0x7b, 0x55, 0x54, 0x5c, 0x63, 0x6c, 0x72,
  0x79, 0x61, 0x62, 0x66, 0x6d, 0x71, 0x75, 0x7b, 0x44, 0x4b, 0x51, 0x55, 0x5a, 0x60, 0x68, 0x46,
  0x4a, 0x53, 0x57, 0x5b, 0x60, 0x66, 0x49, 0x4f, 0x53, 0x57, 0x5b, 0x61, 0x69, 0x4d, 0x51, 0x58,
  0x5c, 0x5f, 0x62, 0x67, 0x53, 0x54, 0x59, 0x5a, 0x5f, 0x64, 0x6a, 0x60, 0x5e, 0x61, 0x62, 0x63,
  0x64, 0x69, 0x47, 0x4b, 0x53, 0x58, 0x5d, 0x63, 0x6d, 0x49, 0x4b, 0x50, 0x58, 0x5f, 0x68, 0x71,
  0x4b, 0x4f, 0x55, 0x59, 0x5e, 0x64, 0x6d, 0x50, 0x52, 0x55, 0x5d, 0x63, 0x6a, 0x72, 0x55, 0x54,
  0x5b, 0x5d, 0x62, 0x66, 0x6e, 0x60, 0x5e, 0x5f, 0x63, 0x66, 0x6b, 0x73, 0x4a, 0x4e, 0x53, 0x5a,
  0x61, 0x68, 0x71, 0x4c, 0x50, 0x57, 0x5d, 0x66, 0x6f, 0x77, 0x4f, 0x53, 0x56, 0x5c, 0x62, 0x68,
  0x72, 0x53, 0x56, 0x5c, 0x61, 0x68, 0x71, 0x77, 0x58, 0x58, 0x5c, 0x60, 0x66, 0x6b, 0x73, 0x63,
  0x62, 0x65, 0x67, 0x6c, 0x72, 0x78, 0x4c, 0x50, 0x5a, 0x5f, 0x67, 0x71, 0x7a, 0x4d, 0x54, 0x5d,
  0x64, 0x6c, 0x76, 0x7c, 0x4f, 0x54, 0x5c, 0x61, 0x68, 0x72, 0x7b, 0x53, 0x5a, 0x62, 0x68, 0x6e,
  0x77, 0x7d, 0x58, 0x59, 0x61, 0x64, 0x6a, 0x73, 0x7b, 0x61, 0x63, 0x68, 0x6b, 0x6f, 0x77, 0x7d,
  0x50, 0x56, 0x60, 0x66, 0x6c, 0x75, 0x7b, 0x53, 0x59, 0x5e, 0x65, 0x6c, 0x70, 0x76, 0x53, 0x59,
  0x61, 0x67, 0x6d, 0x75, 0x7b, 0x58, 0x5e, 0x62, 0x68, 0x6e, 0x71, 0x77, 0x5a, 0x5d, 0x65, 0x69,
  0x6f, 0x75, 0x7b, 0x64, 0x66, 0x68, 0x6b, 0x70, 0x72, 0x77, 0x59, 0x5b, 0x5e, 0x65, 0x6b, 0x73,
  0x79, 0x61, 0x65, 0x6b, 0x6c, 0x6f, 0x72, 0x78, 0x5c, 0x5e, 0x60, 0x67, 0x6c, 0x73, 0x79, 0x64,
  0x69, 0x6d, 0x6f, 0x71, 0x74, 0x79, 0x62, 0x61, 0x64, 0x68, 0x6e, 0x73, 0x78, 0x6c, 0x6e, 0x70,
  0x70, 0x72, 0x74, 0x78, 0x6a, 0x6d, 0x70, 0x71, 0x73, 0x72, 0x75, 0x76, 0x79, 0x78, 0x78, 0x77,
  0x78, 0x78, 0x6b, 0x6e, 0x70, 0x71, 0x73, 0x72, 0x75, 0x77, 0x79, 0x78, 0x78, 0x78, 0x78, 0x79,
  0x6e, 0x6e, 0x71, 0x72, 0x74, 0x72, 0x75, 0x78, 0x79, 0x79, 0x78, 0x78, 0x78, 0x78, 0x83, 0x7f,
  0x7d, 0x7c, 0x7d, 0x7d, 0x7f, 0x82, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x80, 0x82, 0x7e, 0x7d, 0x7c,
  0x7c, 0x7e, 0x7f, 0x82, 0x7c, 0x7d, 0x7d, 0x7d, 0x7f, 0x80, 0x80, 0x7e, 0x7d, 0x7c, 0x7d, 0x7e,
  0x7f, 0x7f, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x8c, 0x85, 0x82, 0x81, 0x80, 0x80, 0x80, 0x92,
  0x8e, 0x88, 0x86, 0x84, 0x86, 0x84, 0x8a, 0x83, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x90, 0x8c, 0x87,
  0x84, 0x83, 0x85, 0x83, 0x88, 0x83, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x89, 0x88, 0x84, 0x83, 0x83,
  0x84, 0x83, 0x9a, 0x95, 0x8c, 0x8a, 0x88, 0x87, 0x83, 0x9d, 0x9c, 0x96, 0x90, 0x8b, 0x88, 0x84,
  0x98, 0x93, 0x8b, 0x89, 0x87, 0x86, 0x82, 0x9a, 0x98, 0x93, 0x8d, 0x8a, 0x86, 0x84, 0x92, 0x90,
  0x88, 0x88, 0x86, 0x85, 0x82, 0x8f, 0x91, 0x8e, 0x8a, 0x89, 0x86, 0x84, 0x9e, 0x9a, 0x95, 0x90,
  0x8b, 0x89, 0x86, 0xa0, 0x9c, 0x94, 0x8f, 0x8c, 0x87, 0x84, 0x9c, 0x98, 0x94, 0x8f, 0x8b, 0x89,
  0x86, 0x9c, 0x98, 0x91, 0x8d, 0x8b, 0x86, 0x83, 0x96, 0x95, 0x91, 0x8d, 0x89, 0x87, 0x85, 0x91,
  0x91, 0x8c, 0x8a, 0x89, 0x85, 0x82, 0xa2, 0xa0, 0x99, 0x96, 0x92, 0x8b, 0x85, 0xa3, 0x9e, 0x96,
  0x93, 0x8f, 0x88, 0x84, 0x9f, 0x9d, 0x97, 0x95, 0x91, 0x8a, 0x85, 0x9e, 0x99, 0x93, 0x90, 0x8c,
  0x86, 0x83, 0x99, 0x99, 0x93, 0x92, 0x8e, 0x89, 0x84, 0x93, 0x92, 0x8e, 0x8d, 0x8b, 0x86, 0x83,
  0xa5, 0xa0, 0x9a, 0x97, 0x91, 0x8b, 0x88, 0xa5, 0xa2, 0x9e, 0x99, 0x97, 0x91, 0x8a, 0xa1, 0x9d,
  0x98, 0x95, 0x90, 0x8b, 0x88, 0xa1, 0x9e, 0x9a, 0x96, 0x94, 0x8e, 0x8a, 0x9b, 0x9a, 0x94, 0x93,
  0x8d, 0x89, 0x86, 0x96, 0x95, 0x93, 0x92, 0x91, 0x8e, 0x88, 0xa8, 0xa7, 0xa2, 0x9c, 0x99, 0x93,
  0x8d, 0xac, 0xaa, 0xa6, 0xa2, 0x9e, 0x9a, 0x94, 0xa3, 0xa3, 0xa1, 0x9b, 0x98, 0x93, 0x8d, 0xa6,
  0xa4, 0xa1, 0x9e, 0x9b, 0x97, 0x92, 0x9d, 0x9f, 0x9b, 0x99, 0x95, 0x90, 0x8b, 0x99, 0x9a, 0x99,
  0x98, 0x98, 0x96, 0x91, 0xb1, 0xaf, 0xac, 0xa9, 0xa5, 0x9e, 0x99, 0xb5, 0xb5, 0xb4, 0xb2, 0xab,
  0xa3, 0x9b, 0xac, 0xab, 0xa8, 0xa6, 0xa3, 0x9c, 0x97, 0xad, 0xad, 0xae, 0xaa, 0xa6, 0x9f, 0x98,
  0xa3, 0xa5, 0xa2, 0xa2, 0x9e, 0x9a, 0x96, 0x9f, 0xa2, 0xa3, 0xa3, 0xa1, 0x9e, 0x97, 0xb8, 0xb8,
  0xb3, 0xaa, 0x9f, 0x97, 0x8e, 0xb8, 0xb6, 0xaf, 0xa3, 0x9c, 0x93, 0x8a, 0xb3, 0xb3, 0xb0, 0xa8,
  0x9f, 0x96, 0x8c, 0xb1, 0xae, 0xa9, 0x9e, 0x98, 0x8f, 0x88, 0xa9, 0xac, 0xa8, 0xa3, 0x99, 0x93,
  0x8b, 0x9f, 0xa1, 0x9e, 0x97, 0x94, 0x8e, 0x87, 0xbc, 0xba, 0xb8, 0xb4, 0xb0, 0xab, 0xa3, 0xc1,
  0xc1, 0xba, 0xb6, 0xb1, 0xaf, 0xa7, 0xb6, 0xb4, 0xb3, 0xb0, 0xad, 0xa9, 0xa2, 0xb8, 0xb6, 0xb2,
  0xae, 0xab, 0xa9, 0xa4, 0xac, 0xae, 0xab, 0xab, 0xa7, 0xa4, 0x9f, 0xa5, 0xa7, 0xa5, 0xa6, 0xa5,
  0xa6, 0xa1, 0xcd, 0xca, 0xc0, 0xb9, 0xb4, 0xad, 0xa0, 0xd3, 0xd2, 0xca, 0xbe, 0xb4, 0xa9, 0x9b,
  0xc5, 0xc2, 0xba, 0xb6, 0xb1, 0xaa, 0x9e, 0xc5, 0xc3, 0xbf, 0xb3, 0xac, 0xa3, 0x98, 0xb5, 0xb8,
  0xae, 0xae, 0xa9, 0xa5, 0x9b, 0xaa, 0xae, 0xad, 0xa8, 0xa5, 0x9f, 0x95, 0xd6, 0xd1, 0xc8, 0xbc,
  0xb0, 0xa8, 0x99, 0xd9, 0xd3, 0xc4, 0xb9, 0xad, 0x9e, 0x90, 0xcc, 0xc8, 0xc3, 0xb8, 0xae, 0xa5,
  0x98, 0xca, 0xc4, 0xb9, 0xaf, 0xa7, 0x99, 0x8e, 0xba, 0xbc, 0xb4, 0xaf, 0xa6, 0xa2, 0x95, 0xac,
  0xae, 0xa9, 0xa5, 0xa0, 0x98, 0x8e, 0xa4, 0xae, 0xb6, 0xbb, 0xc0, 0xc5, 0xc7, 0x9e, 0xa8, 0xaf,
  0xb6, 0xb9, 0xbd, 0xc0, 0x9e, 0xa6, 0xac, 0xb1, 0xb5, 0xb9, 0xbb, 0x9a, 0xa0, 0xa7, 0xab, 0xaf,
  0xb3, 0xb3, 0x9f, 0xa3, 0xa7, 0xaa, 0xad, 0xae, 0xb0, 0x95, 0x99, 0x9e, 0xa1, 0xa4, 0xa5, 0xa8,
  0x96, 0x9c, 0xa1, 0xa5, 0xa8, 0xab, 0xac, 0x94, 0x99, 0x9e, 0xa1, 0xa5, 0xa7, 0xa8, 0x8f, 0x94,
  0x97, 0x9b, 0x9d, 0xa0, 0xa3, 0x8e, 0x92, 0x97, 0x99, 0x9c, 0x9e, 0x9f, 0x8c, 0x91, 0x95, 0x97,
  0x99, 0x9c, 0x9d, 0x8b, 0x8f, 0x92, 0x94, 0x96, 0x98, 0x99, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x8a, 0x89, 0x8a, 0x8a, 0x8f, 0x8f, 0x85,
  0x89, 0x8b, 0x8d, 0x8d, 0x91, 0x8d, 0x83, 0x87, 0x86, 0x84, 0x83, 0x88, 0x89, 0x80, 0x7b, 0x7b,
  0x7a, 0x79, 0x76, 0x76, 0x80, 0x7d, 0x7d, 0x7d, 0x7e, 0x7c, 0x7b, 0x82, 0x85, 0x89, 0x85, 0x86,
  0x89, 0x87, 0x8a, 0x8e, 0x94, 0x8f, 0x91, 0x90, 0x94, 0x8f, 0x8c, 0x8f, 0x8f, 0x8f, 0x8e, 0x90,
  0x8b, 0x90, 0x93, 0x86, 0x8b, 0x8d, 0x87, 0x7b, 0x79, 0x79, 0x75, 0x75, 0x76, 0x75, 0x7b, 0x76,
  0x70, 0x7d, 0x79, 0x72, 0x7c, 0x82, 0x84, 0x87, 0x89, 0x8a, 0x8c, 0x8e, 0xc6, 0xbc, 0xb4, 0xaf,
  0xa9, 0xa3, 0x9b, 0xbc, 0xb4, 0xae, 0xa9, 0xa4, 0x9e, 0x97, 0xa5, 0xa1, 0x9d, 0x9b, 0x99, 0x95,
  0x91, 0x79, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d, 0x4f, 0x53, 0x57, 0x5a, 0x5e, 0x62, 0x68, 0x58,
  0x5b, 0x5e, 0x61, 0x63, 0x67, 0x6c, 0x84, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x96, 0x92, 0x90,
  0x8e, 0x8c, 0x8a, 0x87, 0xb0, 0xab, 0xa7, 0xa3, 0x9f, 0x9c, 0x95, 0xc0, 0xb7, 0xb0, 0xaa, 0xa5,
  0xa0, 0x99, 0x85, 0x88, 0x8e, 0x86, 0x89, 0x8c, 0x8f, 0x84, 0x88, 0x8c, 0x86, 0x89, 0x8b, 0x8d,
  0x8c, 0x8f, 0x8e, 0x8c, 0x8f, 0x91, 0x93, 0x88, 0x8e, 0x90, 0x8a, 0x8d, 0x90, 0x91, 0x86, 0x86,
  0x8a, 0x83, 0x85, 0x87, 0x89, 0x83, 0x86, 0x82, 0x7f, 0x81, 0x83, 0x85, 0x81, 0x7f, 0x7d, 0x7f,
  0x7d, 0x7c, 0x7b, 0x7d, 0x7a, 0x7a, 0x7a, 0x78, 0x77, 0x77, 0x80, 0x7e, 0x7b, 0x81, 0x7f, 0x7d,
  0x7c, 0x82, 0x7e, 0x81, 0x83, 0x81, 0x80, 0x7f, 0x82, 0x83, 0x85, 0x85, 0x86, 0x87, 0x87, 0x89,
  0x8b, 0x8d, 0x8e, 0x8f, 0x8f, 0x8f
};

static const unsigned char palette_0E_18_L[] =
{
  0xeb, 0xb8, 0x8e, 0x90, 0x9d, 0x4b, 0xe9, 0xec, 0xee, 0xef, 0xef, 0xf2, 0xf3, 0xe8, 0xed, 0xef,
  0xf0, 0xf1, 0xf3, 0xf3, 0xcd, 0xce, 0xdb, 0xdb, 0xe4, 0xe6, 0xe8, 0xbb, 0xbf, 0xc8, 0xc7, 0xcf,
  0xd2, 0xe2, 0x9b, 0xac, 0xab, 0xb9, 0xba, 0xc6, 0xd3, 0x7b, 0x84, 0x8d, 0x97, 0xaa, 0xbe, 0xcc,
  0xe1, 0xe7, 0xe8, 0xe9, 0xee, 0xef, 0xf0, 0xdb, 0xe0, 0xe3, 0xe6, 0xe7, 0xeb, 0xf0, 0xc5, 0xc9,
  0xd6, 0xd5, 0xe2, 0xe3, 0xe5, 0xb2, 0xb3, 0xbc, 0xbc, 0xc5, 0xc8, 0xdb, 0x98, 0xa8, 0xa7, 0xb6,
  0xba, 0xc6, 0xd0, 0x7a, 0x81, 0x88, 0x92, 0xa2, 0xb6, 0xc6, 0xd7, 0xd9, 0xdd, 0xe1, 0xe4, 0xe8,
  0xec, 0xcf, 0xd2, 0xd6, 0xd9, 0xdd, 0xe1, 0xe5, 0xbc, 0xbf, 0xcc, 0xd0, 0xda, 0xdd, 0xe2, 0xa9,
  0xad, 0xb7, 0xb9, 0xc1, 0xc5, 0xd5, 0x91, 0xa1, 0xa4, 0xb6, 0xb6, 0xc3, 0xcf, 0x72, 0x7c, 0x88,
  0x93, 0xa1, 0xb5, 0xc1, 0xc5, 0xca, 0xcf, 0xd2, 0xd5, 0xdc, 0xe0, 0xbc, 0xc2, 0xc6, 0xca, 0xcf,
  0xd6, 0xdd, 0xad, 0xb2, 0xc0, 0xc3, 0xcd, 0xd3, 0xd6, 0x97, 0x9d, 0xa8, 0xab, 0xb6, 0xbb, 0xcc,
  0x87, 0x98, 0x9d, 0xab, 0xac, 0xb9, 0xc4, 0x6a, 0x76, 0x80, 0x8a, 0x9a, 0xad, 0xba, 0xb1, 0xb9,
  0xc5, 0xd1, 0xdc, 0xe3, 0xea, 0xb3, 0xc1, 0xcb, 0xd7, 0xdf, 0xe6, 0xee, 0x9d, 0xa4, 0xb8, 0xc3,
  0xd4, 0xda, 0xe1, 0x94, 0xa1, 0xaf, 0xba, 0xc8, 0xcd, 0xdd, 0x7b, 0x8c, 0x96, 0xac, 0xb4, 0xc2,
  0xd0, 0x66, 0x75, 0x82, 0x94, 0xa9, 0xbe, 0xcb, 0xb2, 0xb9, 0xc0, 0xc6, 0xcb, 0xd1, 0xd8, 0xb3,
  0xb6, 0xc1, 0xc7, 0xcc, 0xcf, 0xd5, 0x9e, 0xa5, 0xb4, 0xb9, 0xc3, 0xc9, 0xcf, 0x93, 0x95, 0xa5,
  0xaa, 0xb4, 0xb6, 0xc7, 0x7c, 0x8e, 0x93, 0xa3, 0xa7, 0xb2, 0xbf, 0x68, 0x6f, 0x7d, 0x89, 0x9a,
  0xa9, 0xb6, 0xb4, 0xb9, 0xc2, 0xc7, 0xcc, 0xd0, 0xda, 0xb4, 0xb6, 0xbd, 0xc6, 0xcc, 0xd4, 0xde,
  0xa0, 0xa6, 0xb6, 0xba, 0xc4, 0xc8, 0xd2, 0x97, 0x9a, 0xa5, 0xad, 0xb7, 0xbe, 0xd1, 0x80, 0x8f,
  0x97, 0xa5, 0xaa, 0xb4, 0xc3, 0x69, 0x73, 0x7d, 0x8b, 0x9d, 0xb1, 0xc0, 0xb4, 0xb9, 0xc0, 0xc6,
  0xce, 0xd3, 0xde, 0xb4, 0xb9, 0xc3, 0xc9, 0xd1, 0xdb, 0xe6, 0xa1, 0xa6, 0xb3, 0xba, 0xc6, 0xcc,
  0xd6, 0x95, 0x9a, 0xa9, 0xae, 0xba, 0xc3, 0xd6, 0x80, 0x90, 0x94, 0xa6, 0xab, 0xb7, 0xc6, 0x6a,
  0x75, 0x82, 0x8e, 0xa1, 0xb7, 0xc6, 0xb7, 0xb8, 0xc2, 0xc7, 0xce, 0xd9, 0xe6, 0xb5, 0xbc, 0xc6,
  0xcc, 0xd3, 0xe0, 0xea, 0xa6, 0xa6, 0xb7, 0xbb, 0xc7, 0xd1, 0xde, 0x9a, 0xa1, 0xaf, 0xb2, 0xbe,
  0xc9, 0xdc, 0x85, 0x92, 0x99, 0xa6, 0xac, 0xbc, 0xce, 0x6b, 0x76, 0x82, 0x8f, 0xa3, 0xb9, 0xc9,
  0xb2, 0xb8, 0xc0, 0xc5, 0xd0, 0xd8, 0xe1, 0xac, 0xb2, 0xb9, 0xc1, 0xc6, 0xce, 0xdc, 0xa1, 0xa7,
  0xb5, 0xb9, 0xc8, 0xd1, 0xd9, 0x94, 0x98, 0xa3, 0xa8, 0xb3, 0xba, 0xce, 0x82, 0x91, 0x97, 0xa6,
  0xaf, 0xbd, 0xca, 0x69, 0x72, 0x7d, 0x89, 0x9a, 0xad, 0xbe, 0xa7, 0xaa, 0xb1, 0xba, 0xc2, 0xcc,
  0xd8, 0xa0, 0xa4, 0xac, 0xb2, 0xb7, 0xc0, 0xcb, 0x96, 0x9a, 0xa7, 0xb0, 0xbc, 0xc5, 0xd1, 0x88,
  0x8d, 0x99, 0x9c, 0xa7, 0xad, 0xc0, 0x7a, 0x87, 0x8d, 0x9e, 0xa4, 0xb2, 0xc2, 0x62, 0x6c, 0x75,
  0x81, 0x8f, 0xa1, 0xb1, 0x97, 0x9c, 0xa4, 0xa7, 0xac, 0xb8, 0xc1, 0x8f, 0x95, 0x9a, 0x9e, 0xa6,
  0xb1, 0xc0, 0x89, 0x8e, 0x9c, 0x9f, 0xa9, 0xb3, 0xbb, 0x7a, 0x7f, 0x88, 0x8c, 0x96, 0xa0, 0xb3,
  0x71, 0x7d, 0x84, 0x90, 0x94, 0xa2, 0xae, 0x5b, 0x63, 0x6c, 0x75, 0x84, 0x96, 0xa7, 0x8d, 0x92,
  0x9c, 0xaa, 0xbd, 0xca, 0xdc, 0x8f, 0x99, 0xa4, 0xb7, 0xc4, 0xd2, 0xe3, 0x81, 0x85, 0x96, 0xa3,
  0xb7, 0xc5, 0xd4, 0x7c, 0x85, 0x92, 0xa4, 0xb4, 0xc0, 0xd5, 0x6a, 0x76, 0x80, 0x94, 0xa3, 0xb3,
  0xc6, 0x5c, 0x67, 0x73, 0x86, 0x9b, 0xb3, 0xc7, 0x8f, 0x93, 0x98, 0x9d, 0xa3, 0xac, 0xb9, 0x92,
  0x93, 0x9c, 0xa0, 0xa5, 0xac, 0xb6, 0x83, 0x87, 0x90, 0x95, 0x9e, 0xa7, 0xb3, 0x7f, 0x7f, 0x8a,
  0x8f, 0x97, 0x9b, 0xac, 0x6d, 0x78, 0x7c, 0x88, 0x8d, 0x99, 0xa9, 0x5f, 0x64, 0x6e, 0x78, 0x84,
  0x93, 0xa1, 0x8b, 0x8d, 0x9a, 0xa2, 0xaa, 0xb1, 0xc2, 0x8c, 0x8d, 0x96, 0xa2, 0xac, 0xba, 0xcc,
  0x7f, 0x82, 0x92, 0x9b, 0xa3, 0xab, 0xbd, 0x79, 0x79, 0x86, 0x92, 0x9c, 0xaa, 0xc2, 0x68, 0x72,
  0x7d, 0x8c, 0x93, 0x9e, 0xb2, 0x5b, 0x60, 0x6a, 0x7a, 0x89, 0x9f, 0xb3, 0x8c, 0x8e, 0x99, 0xa5,
  0xb0, 0xba, 0xce, 0x8d, 0x8f, 0x9e, 0xa9, 0xb8, 0xc8, 0xdb, 0x7f, 0x82, 0x90, 0x9c, 0xaa, 0xb5,
  0xc8, 0x79, 0x7b, 0x8b, 0x97, 0xa7, 0xb6, 0xcf, 0x69, 0x73, 0x7b, 0x8f, 0x97, 0xa4, 0xbc, 0x5b,
  0x61, 0x6e, 0x7d, 0x91, 0xaa, 0xbf, 0x8f, 0x90, 0x9b, 0xa2, 0xad, 0xc2, 0xdb, 0x8d, 0x95, 0xa1,
  0xa9, 0xb6, 0xce, 0xe3, 0x83, 0x83, 0x92, 0x98, 0xa7, 0xba, 0xd3, 0x7c, 0x80, 0x8d, 0x96, 0xa5,
  0xb8, 0xd4, 0x6d, 0x74, 0x7c, 0x88, 0x92, 0xa9, 0xc3, 0x5d, 0x64, 0x70, 0x7b, 0x8e, 0xad, 0xc4,
  0x87, 0x8e, 0x98, 0xa2, 0xb1, 0xc4, 0xd7, 0x81, 0x88, 0x90, 0x9b, 0xa6, 0xb4, 0xca, 0x7c, 0x82,
  0x90, 0x98, 0xab, 0xbd, 0xcf, 0x73, 0x77, 0x80, 0x8a, 0x96, 0xa3, 0xbf, 0x68, 0x73, 0x7b, 0x89,
  0x97, 0xac, 0xc2, 0x59, 0x60, 0x68, 0x74, 0x84, 0x98, 0xb0, 0x76, 0x79, 0x83, 0x93, 0xa0, 0xb1,
  0xc7, 0x6d, 0x75, 0x84, 0x8d, 0x99, 0xa3, 0xb8, 0x6f, 0x71, 0x7d, 0x8b, 0x9b, 0xab, 0xc0, 0x64,
  0x6a, 0x79, 0x82, 0x8e, 0x98, 0xaf, 0x60, 0x67, 0x6d, 0x7f, 0x8a, 0x9c, 0xb3, 0x54, 0x59, 0x64,
  0x6d, 0x7d, 0x8e, 0xa3, 0x65, 0x6b, 0x7a, 0x84, 0x8e, 0x9a, 0xa8, 0x5c, 0x68, 0x72, 0x7a, 0x86,
  0x97, 0xaa, 0x61, 0x66, 0x77, 0x7e, 0x8b, 0x95, 0xa3, 0x56, 0x60, 0x69, 0x71, 0x7e, 0x8b, 0xa2,
  0x57, 0x5f, 0x69, 0x76, 0x7e, 0x8a, 0x9a, 0x4d, 0x53, 0x5a, 0x64, 0x71, 0x84, 0x96, 0x5b, 0x68,
  0x7e, 0x96, 0xb2, 0xc4, 0xd9, 0x5d, 0x75, 0x89, 0xa8, 0xba, 0xcd, 0xe1, 0x58, 0x64, 0x7a, 0x90,
  0xad, 0xbe, 0xd2, 0x59, 0x6c, 0x7f, 0x98, 0xac, 0xbc, 0xd5, 0x52, 0x5e, 0x6e, 0x85, 0x9a, 0xad,
  0xc4, 0x4e, 0x5c, 0x6a, 0x81, 0x97, 0xaf, 0xc5, 0x62, 0x6d, 0x78, 0x7e, 0x8d, 0x9c, 0xaf, 0x6d,
  0x74, 0x84, 0x8e, 0x97, 0xa3, 0xaf, 0x5f, 0x69, 0x75, 0x7d, 0x89, 0x97, 0xa9, 0x65, 0x6b, 0x7a,
  0x81, 0x8c, 0x95, 0xa6, 0x56, 0x61, 0x69, 0x76, 0x7e, 0x8e, 0xa1, 0x53, 0x53, 0x66, 0x71, 0x7d,
  0x8d, 0x9b, 0x74, 0x7c, 0x88, 0x91, 0x9c, 0xa9, 0xbb, 0x7f, 0x84, 0x8c, 0x9a, 0xa6, 0xb9, 0xcc,
  0x6f, 0x76, 0x82, 0x8a, 0x97, 0xa4, 0xb6, 0x74, 0x78, 0x82, 0x8c, 0x9a, 0xa8, 0xc0, 0x62, 0x6c,
  0x75, 0x7f, 0x88, 0x96, 0xa9, 0x5b, 0x62, 0x6a, 0x76, 0x88, 0x9e, 0xb1, 0x85, 0x8e, 0x95, 0xa1,
  0xad, 0xbb, 0xd0, 0x8c, 0x96, 0x9f, 0xa8, 0xbb, 0xcc, 0xdb, 0x7c, 0x83, 0x8f, 0x97, 0xa7, 0xb4,
  0xc8, 0x7c, 0x84, 0x90, 0x95, 0xa9, 0xb8, 0xcc, 0x6b, 0x78, 0x7c, 0x8c, 0x96, 0xa5, 0xbc, 0x5f,
  0x68, 0x74, 0x7e, 0x93, 0xab, 0xbc, 0x8f, 0x94, 0xa9, 0xb4, 0xc1, 0xd3, 0xe5, 0x8d, 0x99, 0xaf,
  0xbc, 0xc9, 0xdd, 0xea, 0x85, 0x8a, 0xa0, 0xab, 0xbb, 0xcd, 0xdf, 0x7f, 0x8a, 0x9e, 0xaa, 0xba,
  0xcb, 0xde, 0x71, 0x7b, 0x8b, 0x9c, 0xa7, 0xbc, 0xd1, 0x5e, 0x6a, 0x7c, 0x8e, 0xa3, 0xbf, 0xcf,
  0x8c, 0x98, 0xab, 0xb8, 0xc6, 0xd6, 0xe3, 0x8b, 0x97, 0xa6, 0xb4, 0xc1, 0xcb, 0xdb, 0x83, 0x8e,
  0xa4, 0xaf, 0xc1, 0xd0, 0xdc, 0x7d, 0x87, 0x96, 0xa3, 0xb1, 0xb9, 0xd0, 0x70, 0x7f, 0x8e, 0xa2,
  0xad, 0xbe, 0xd0, 0x5d, 0x68, 0x77, 0x88, 0x9c, 0xaf, 0xc2, 0x8f, 0x93, 0x9d, 0xac, 0xba, 0xca,
  0xd9, 0x8c, 0x97, 0xa6, 0xac, 0xb6, 0xc1, 0xd1, 0x86, 0x89, 0x96, 0xa4, 0xb4, 0xc3, 0xd2, 0x7f,
  0x87, 0x97, 0x9d, 0xa9, 0xb3, 0xc6, 0x72, 0x7b, 0x81, 0x95, 0xa0, 0xb3, 0xc4, 0x5f, 0x69, 0x77,
  0x83, 0x93, 0xa7, 0xba, 0x89, 0x93, 0xa2, 0xa9, 0xb2, 0xbb, 0xc6, 0x84, 0x95, 0x9d, 0xa5, 0xaf,
  0xbb, 0xc9, 0x80, 0x89, 0x9a, 0xa1, 0xad, 0xb6, 0xc0, 0x77, 0x83, 0x8e, 0x94, 0xa0, 0xac, 0xbe,
  0x6e, 0x7c, 0x85, 0x94, 0x9b, 0xa7, 0xb4, 0x5a, 0x67, 0x71, 0x7d, 0x8d, 0xa1, 0xb1, 0x78, 0x8a,
  0xa4, 0xb7, 0xca, 0xd6, 0xe3, 0x7f, 0x9a, 0xaf, 0xc5, 0xd0, 0xdc, 0xe9, 0x72, 0x81, 0x9e, 0xb0,
  0xc5, 0xd0, 0xdc, 0x75, 0x8a, 0x9f, 0xb1, 0xbf, 0xca, 0xdd, 0x63, 0x74, 0x88, 0xa0, 0xae, 0xbf,
  0xcf, 0x58, 0x69, 0x7c, 0x93, 0xa6, 0xbd, 0xcd, 0x85, 0x92, 0xa0, 0xa8, 0xb1, 0xbd, 0xca, 0x90,
  0x98, 0xab, 0xb2, 0xb9, 0xc1, 0xcb, 0x7d, 0x8a, 0x9a, 0xa1, 0xac, 0xb8, 0xc4, 0x80, 0x86, 0x9a,
  0xa0, 0xa9, 0xb2, 0xc0, 0x6b, 0x7c, 0x85, 0x95, 0x9b, 0xa9, 0xb9, 0x5e, 0x68, 0x79, 0x86, 0x95,
  0xa5, 0xb3, 0x91, 0x9e, 0xaf, 0xb7, 0xbe, 0xc7, 0xd4, 0x96, 0x9e, 0xac, 0xbb, 0xc5, 0xd0, 0xdc,
  0x88, 0x94, 0xa8, 0xb0, 0xb9, 0xc2, 0xcd, 0x88, 0x8d, 0x9e, 0xaa, 0xb6, 0xc0, 0xd2, 0x73, 0x84,
  0x92, 0xa1, 0xa7, 0xb3, 0xc2, 0x62, 0x6c, 0x7c, 0x8f, 0xa1, 0xb5, 0xc3, 0x9a, 0xa7, 0xb4, 0xc0,
  0xc9, 0xd2, 0xdf, 0x9d, 0xa9, 0xbc, 0xc4, 0xcf, 0xdb, 0xe5, 0x90, 0x9b, 0xab, 0xb7, 0xc3, 0xcb,
  0xd7, 0x8b, 0x95, 0xa8, 0xb0, 0xbe, 0xc8, 0xd8, 0x79, 0x89, 0x94, 0xa7, 0xae, 0xba, 0xcb, 0x65,
  0x71, 0x83, 0x93, 0xa6, 0xbc, 0xca, 0x9e, 0xa3, 0xb7, 0xbd, 0xc4, 0xd4, 0xe5, 0x9e, 0xaa, 0xbd,
  0xc3, 0xcc, 0xdd, 0xe9, 0x8f, 0x93, 0xab, 0xaf, 0xbc, 0xca, 0xda, 0x87, 0x8f, 0xa2, 0xa6, 0xb3,
  0xc1, 0xd7, 0x73, 0x7f, 0x8b, 0x99, 0x9f, 0xb2, 0xc7, 0x5f, 0x68, 0x77, 0x83, 0x96, 0xb1, 0xc3,
  0x9d, 0xa8, 0xba, 0xc2, 0xcc, 0xd8, 0xe4, 0x9c, 0xa8, 0xb5, 0xbe, 0xc6, 0xcf, 0xdc, 0x8f, 0x97,
  0xae, 0xb4, 0xc2, 0xcf, 0xda, 0x85, 0x8d, 0x9d, 0xa4, 0xaf, 0xb6, 0xcc, 0x72, 0x83, 0x8e, 0xa0,
  0xa6, 0xb7, 0xc8, 0x5f, 0x68, 0x74, 0x82, 0x94, 0xa9, 0xbb, 0xa0, 0xa5, 0xb4, 0xc0, 0xc8, 0xd2,
  0xde, 0x9f, 0xa9, 0xbb, 0xc1, 0xc6, 0xcd, 0xd9, 0x8f, 0x93, 0xa8, 0xb2, 0xbf, 0xc9, 0xd5, 0x85,
  0x8d, 0xa0, 0xa5, 0xaf, 0xb6, 0xca, 0x70, 0x7d, 0x88, 0x9c, 0xa0, 0xb1, 0xc2, 0x5c, 0x65, 0x75,
  0x82, 0x92, 0xa6, 0xb7, 0x9d, 0xa8, 0xbb, 0xc0, 0xc5, 0xc9, 0xd1, 0x99, 0xaa, 0xb8, 0xbd, 0xc4,
  0xca, 0xd4, 0x8d, 0x96, 0xad, 0xb1, 0xbd, 0xc0, 0xc8, 0x80, 0x8d, 0x9c, 0xa2, 0xad, 0xb3, 0xc5,
  0x71, 0x82, 0x8c, 0x9d, 0xa2, 0xaa, 0xb9, 0x5c, 0x68, 0x75, 0x81, 0x92, 0xa6, 0xb4, 0x9c, 0xa8,
  0xbb, 0xc9, 0xd7, 0xe1, 0xe9, 0x9f, 0xb5, 0xc3, 0xd3, 0xdc, 0xe5, 0xec, 0x8c, 0x97, 0xaf, 0xbb,
  0xcd, 0xd7, 0xde, 0x86, 0x96, 0xa6, 0xb2, 0xbf, 0xc6, 0xd9, 0x6f, 0x80, 0x8b, 0xa1, 0xab, 0xba,
  0xc9, 0x5d, 0x6a, 0x78, 0x89, 0x9e, 0xb5, 0xbf, 0xa8, 0xb2, 0xba, 0xc2, 0xc9, 0xd3, 0xdc, 0xb7,
  0xbd, 0xc7, 0xcc, 0xd0, 0xda, 0xdf, 0x96, 0x9f, 0xae, 0xb4, 0xc1, 0xca, 0xd1, 0x96, 0x9a, 0xa9,
  0xab, 0xb6, 0xbd, 0xcc, 0x77, 0x88, 0x8c, 0x9d, 0xa2, 0xb1, 0xbf, 0x65, 0x6d, 0x7b, 0x87, 0x98,
  0xad, 0xb9, 0xc1, 0xc5, 0xcd, 0xd2, 0xd7, 0xdc, 0xe1, 0xcd, 0xd1, 0xd8, 0xdd, 0xe1, 0xe5, 0xea,
  0xa8, 0xab, 0xbc, 0xc1, 0xcd, 0xd2, 0xd7, 0xa2, 0xa3, 0xb1, 0xb6, 0xc2, 0xc6, 0xd7, 0x7f, 0x8e,
  0x95, 0xa7, 0xaa, 0xb7, 0xc3, 0x65, 0x6f, 0x7c, 0x8b, 0x9f, 0xb4, 0xc2, 0xd5, 0xda, 0xdf, 0xe3,
  0xe4, 0xe8, 0xee, 0xdd, 0xde, 0xe5, 0xe6, 0xec, 0xed, 0xef, 0xb6, 0xbb, 0xcb, 0xce, 0xd8, 0xdc,
  0xe1, 0xac, 0xae, 0xbc, 0xbc, 0xca, 0xcd, 0xda, 0x87, 0x9a, 0x9f, 0xb2, 0xb3, 0xc0, 0xcd, 0x69,
  0x74, 0x83, 0x92, 0xa8, 0xbc, 0xc5, 0xa9, 0xa4, 0x9d, 0x9f, 0x9b, 0x99, 0x97, 0x9d, 0x99, 0x95,
  0x94, 0x8f, 0x8d, 0x8c, 0x8e, 0x8b, 0x89, 0x87, 0x84, 0x82, 0x81, 0x87, 0x83, 0x82, 0x80, 0x7e,
  0x7a, 0x7b, 0x79, 0x79, 0x76, 0x76, 0x75, 0x76, 0x75, 0x71, 0x70, 0x6f, 0x6d, 0x6e, 0x6f, 0x6e,
  0xa5, 0x9e, 0x97, 0x90, 0x89, 0x83, 0x80, 0x9a, 0x94, 0x8e, 0x87, 0x80, 0x7b, 0x78, 0x8f, 0x8b,
  0x84, 0x7f, 0x79, 0x76, 0x71, 0x84, 0x7f, 0x79, 0x75, 0x70, 0x6d, 0x6c, 0x7d, 0x7b, 0x77, 0x72,
  0x6f, 0x6a, 0x69, 0x6f, 0x6d, 0x6c, 0x6a, 0x67, 0x64, 0x62, 0xec, 0xdd, 0xcf, 0xbe, 0x9c, 0x85,
  0x68, 0xe7, 0xd7, 0xc8, 0xad, 0x93, 0x7a, 0x63, 0xe6, 0xd9, 0xcc, 0xb7, 0xa3, 0x91, 0x7d, 0xe4,
  0xd8, 0xca, 0xb7, 0xa2, 0x91, 0x7f, 0xe4, 0xd2, 0xc5, 0xb1, 0x9f, 0x8b, 0x7a, 0xe2, 0xcc, 0xc0,
  0xae, 0x9e, 0x88, 0x75, 0xe3, 0xd2, 0xc6, 0xb4, 0xa2, 0x90, 0x7b, 0xe4, 0xd6, 0xc7, 0xb8, 0xa6,
  0x96, 0x80, 0x6a, 0x68, 0x66, 0x63, 0x62, 0x62, 0x62, 0x67, 0x66, 0x62, 0x61, 0x61, 0x5f, 0x60,
  0x66, 0x62, 0x5f, 0x5c, 0x5b, 0x5a, 0x5a, 0x61, 0x59, 0x54, 0x5a, 0x56, 0x51, 0x58, 0x62, 0x5c,
  0x57, 0x5f, 0x5c, 0x59, 0x63, 0x65, 0x60, 0x59, 0x63, 0x62, 0x5d, 0x6a, 0xa9, 0x96, 0x89, 0x80,
  0x78, 0x72, 0x6a, 0x96, 0x88, 0x7f, 0x77, 0x70, 0x68, 0x63, 0x71, 0x68, 0x62, 0x5e, 0x5b, 0x59,
  0x55, 0x75, 0x6c, 0x64, 0x61, 0x5e, 0x5b, 0x57, 0x5b, 0x58, 0x55, 0x53, 0x53, 0x51, 0x4f, 0x7b,
  0x73, 0x72, 0x69, 0x66, 0x62, 0x5e, 0x75, 0x70, 0x6a, 0x66, 0x62, 0x5e, 0x5c, 0x89, 0x80, 0x78,
  0x72, 0x6d, 0x69, 0x62, 0x89, 0x7f, 0x77, 0x71, 0x6d, 0x68, 0x63, 0xa7, 0x96, 0x8b, 0x81, 0x7c,
  0x77, 0x6e, 0xf5, 0xf4, 0xf4, 0xf2, 0xf2, 0xf2, 0xf1, 0xed, 0xec, 0xeb, 0xe9, 0xe8, 0xe8, 0xe8,
  0xef, 0xee, 0xec, 0xeb, 0xea, 0xea, 0xea, 0xe7, 0xe5, 0xe3, 0xe2, 0xe0, 0xe0, 0xe0, 0xee, 0xee,
  0xea, 0xec, 0xe9, 0xe7, 0xe5, 0xe4, 0xe1, 0xdf, 0xdd, 0xdb, 0xd9, 0xd8, 0xef, 0xe8, 0xdf, 0xec,
  0xe5, 0xe0, 0xdb, 0xe9, 0xdd, 0xdf, 0xe3, 0xdd, 0xd7, 0xd3, 0xf2, 0xee, 0xe8, 0xef, 0xec, 0xe8,
  0xe6, 0xed, 0xe6, 0xe6, 0xe8, 0xe5, 0xe5, 0xe1, 0xf2, 0xef, 0xeb, 0xf2, 0xef, 0xed, 0xeb, 0xf2,
  0xeb, 0xee, 0xf1, 0xee, 0xec, 0xea
};

static const unsigned char palette_0E_18_A[] =
{
  0x7f, 0xb1, 0xc4, 0x66, 0x46, 0x82, 0x80, 0x7e, 0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x83, 0x7d, 0x7c,
  0x7b, 0x7c, 0x7d, 0x7e, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x7f, 0x7c, 0x7c, 0x7c, 0x7c,
  0x7d, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f,
  0x89, 0x84, 0x83, 0x82, 0x7f, 0x7f, 0x81, 0x90, 0x8b, 0x88, 0x86, 0x85, 0x83, 0x80, 0x85, 0x81,
  0x81, 0x81, 0x7f, 0x7f, 0x80, 0x87, 0x84, 0x84, 0x82, 0x83, 0x81, 0x7f, 0x81, 0x7f, 0x7f, 0x80,
  0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x94, 0x91, 0x8d, 0x89, 0x87, 0x85,
  0x83, 0x9b, 0x99, 0x95, 0x92, 0x8f, 0x8c, 0x89, 0x8d, 0x8b, 0x8a, 0x87, 0x85, 0x84, 0x83, 0x90,
  0x8e, 0x8d, 0x8b, 0x8a, 0x88, 0x87, 0x85, 0x86, 0x84, 0x84, 0x82, 0x82, 0x81, 0x84, 0x85, 0x85,
  0x85, 0x85, 0x85, 0x85, 0xa5, 0xa0, 0x9c, 0x99, 0x96, 0x90, 0x8c, 0xac, 0xa7, 0xa4, 0xa1, 0x9c,
  0x96, 0x8f, 0x9a, 0x97, 0x96, 0x94, 0x93, 0x8d, 0x8a, 0x9c, 0x98, 0x98, 0x95, 0x93, 0x8e, 0x8c,
  0x8d, 0x8f, 0x8c, 0x8e, 0x8c, 0x89, 0x88, 0x8b, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x89, 0xb4, 0xaf,
  0xa5, 0x9b, 0x92, 0x8c, 0x87, 0xb3, 0xa8, 0xa0, 0x95, 0x8f, 0x8a, 0x85, 0xa8, 0xa4, 0x9f, 0x97,
  0x8f, 0x8b, 0x86, 0xa3, 0x9b, 0x96, 0x8e, 0x8b, 0x87, 0x84, 0x98, 0x9a, 0x93, 0x90, 0x8a, 0x87,
  0x85, 0x8e, 0x8c, 0x8a, 0x88, 0x86, 0x85, 0x83, 0xb4, 0xaf, 0xaa, 0xa5, 0xa0, 0x9b, 0x96, 0xb4,
  0xb2, 0xa9, 0xa5, 0xa0, 0x9d, 0x99, 0xa9, 0xa4, 0xa3, 0x9e, 0x9c, 0x98, 0x93, 0xa4, 0xa2, 0x9e,
  0x99, 0x97, 0x96, 0x94, 0x98, 0x9a, 0x96, 0x97, 0x93, 0x92, 0x8f, 0x8f, 0x91, 0x8f, 0x8f, 0x90,
  0x93, 0x91, 0xb4, 0xb0, 0xa8, 0xa4, 0xa0, 0x9c, 0x93, 0xb4, 0xb2, 0xad, 0xa6, 0xa0, 0x9a, 0x91,
  0xa9, 0xa6, 0xa2, 0x9f, 0x9d, 0x9a, 0x91, 0xa4, 0xa3, 0xa1, 0x9b, 0x99, 0x93, 0x8e, 0x99, 0x9c,
  0x96, 0x97, 0x95, 0x93, 0x8e, 0x8f, 0x92, 0x92, 0x91, 0x91, 0x90, 0x8b, 0xb4, 0xb0, 0xab, 0xa5,
  0x9e, 0x99, 0x91, 0xb4, 0xb0, 0xa8, 0xa3, 0x9c, 0x94, 0x8b, 0xaa, 0xa6, 0xa5, 0x9f, 0x9c, 0x98,
  0x90, 0xa5, 0xa1, 0x9e, 0x99, 0x95, 0x8f, 0x8a, 0x9a, 0x9d, 0x98, 0x98, 0x94, 0x92, 0x8d, 0x90,
  0x91, 0x90, 0x90, 0x8f, 0x8c, 0x88, 0xb2, 0xb1, 0xa8, 0xa4, 0x9f, 0x96, 0x8b, 0xb3, 0xae, 0xa5,
  0xa0, 0x9a, 0x90, 0x88, 0xa9, 0xa8, 0xa3, 0xa0, 0x9c, 0x94, 0x8a, 0xa5, 0xa1, 0x9c, 0x98, 0x94,
  0x8d, 0x87, 0x9a, 0x9e, 0x98, 0x99, 0x94, 0x90, 0x88, 0x8e, 0x90, 0x8e, 0x8e, 0x8e, 0x8a, 0x86,
  0xb3, 0xaf, 0xa8, 0xa4, 0x9c, 0x95, 0x8e, 0xb5, 0xb2, 0xad, 0xa7, 0xa3, 0x9d, 0x93, 0xaa, 0xa6,
  0xa3, 0x9f, 0x9a, 0x94, 0x8e, 0xa7, 0xa4, 0xa2, 0x9d, 0x9b, 0x96, 0x90, 0x9b, 0x9d, 0x97, 0x98,
  0x92, 0x8e, 0x8b, 0x91, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8d, 0xb7, 0xb6, 0xb1, 0xaa, 0xa5, 0x9e,
  0x95, 0xba, 0xb7, 0xb2, 0xaf, 0xab, 0xa5, 0x9d, 0xad, 0xac, 0xab, 0xa5, 0xa2, 0x9b, 0x93, 0xaa,
  0xa8, 0xa6, 0xa3, 0xa2, 0x9e, 0x99, 0x9c, 0xa1, 0x9e, 0x9d, 0x99, 0x96, 0x90, 0x92, 0x94, 0x95,
  0x97, 0x99, 0x9a, 0x95, 0xbd, 0xba, 0xb6, 0xb4, 0xb1, 0xaa, 0xa4, 0xbf, 0xbc, 0xbb, 0xb9, 0xb5,
  0xae, 0xa5, 0xb2, 0xb0, 0xaf, 0xae, 0xad, 0xa7, 0xa1, 0xae, 0xac, 0xad, 0xab, 0xab, 0xa5, 0xa1,
  0xa0, 0xa4, 0xa1, 0xa5, 0xa2, 0x9f, 0x9d, 0x95, 0x97, 0x9a, 0x9d, 0xa0, 0xa1, 0x9c, 0xc0, 0xbe,
  0xb9, 0xb2, 0xa7, 0x9e, 0x92, 0xbf, 0xbb, 0xb6, 0xab, 0xa2, 0x99, 0x8d, 0xb5, 0xb4, 0xb3, 0xad,
  0xa4, 0x9c, 0x91, 0xb0, 0xac, 0xab, 0xa1, 0x9b, 0x94, 0x8c, 0xa2, 0xa8, 0xa5, 0xa4, 0x9b, 0x97,
  0x8f, 0x94, 0x97, 0x98, 0x96, 0x95, 0x92, 0x8a, 0xbf, 0xbe, 0xbc, 0xba, 0xb7, 0xb2, 0xaa, 0xbf,
  0xbe, 0xba, 0xb9, 0xb6, 0xb3, 0xac, 0xb5, 0xb3, 0xb5, 0xb3, 0xb3, 0xae, 0xa7, 0xaf, 0xaf, 0xaf,
  0xad, 0xac, 0xaa, 0xa7, 0xa3, 0xa8, 0xa6, 0xab, 0xa8, 0xa6, 0xa2, 0x96, 0x99, 0x9b, 0x9e, 0xa2,
  0xa5, 0xa2, 0xc0, 0xc0, 0xbb, 0xb8, 0xb4, 0xaf, 0xa3, 0xc1, 0xc1, 0xbf, 0xb9, 0xb3, 0xaa, 0x9d,
  0xb7, 0xb6, 0xb5, 0xb1, 0xb1, 0xac, 0xa1, 0xb1, 0xb1, 0xb2, 0xad, 0xab, 0xa2, 0x9a, 0xa4, 0xaa,
  0xa6, 0xa9, 0xa5, 0xa4, 0x9c, 0x96, 0x9b, 0x9d, 0x9e, 0xa0, 0x9e, 0x96, 0xc2, 0xc2, 0xbe, 0xb8,
  0xb1, 0xab, 0x9d, 0xc3, 0xc3, 0xbc, 0xb6, 0xad, 0xa1, 0x93, 0xb7, 0xb7, 0xb8, 0xb3, 0xae, 0xa7,
  0x9a, 0xb2, 0xb2, 0xb0, 0xaa, 0xa5, 0x9a, 0x90, 0xa5, 0xab, 0xa8, 0xa9, 0xa3, 0xa0, 0x95, 0x97,
  0x9b, 0x9c, 0x9c, 0x9b, 0x96, 0x8d, 0xc4, 0xc3, 0xbf, 0xbb, 0xb4, 0xa6, 0x93, 0xc1, 0xc2, 0xbc,
  0xb7, 0xae, 0x9d, 0x8e, 0xba, 0xb9, 0xb8, 0xb6, 0xb1, 0xa3, 0x91, 0xae, 0xb2, 0xaf, 0xab, 0xa5,
  0x97, 0x8b, 0xa5, 0xad, 0xa9, 0xac, 0xa6, 0x9c, 0x90, 0x99, 0x9c, 0x9c, 0x9d, 0x9d, 0x94, 0x8a,
  0xbc, 0xbc, 0xb7, 0xb2, 0xad, 0x9f, 0x91, 0xb6, 0xb6, 0xb5, 0xb1, 0xaa, 0xa5, 0x9b, 0xb3, 0xb3,
  0xb2, 0xad, 0xaa, 0x9d, 0x90, 0xaa, 0xaa, 0xab, 0xa7, 0xa2, 0x9e, 0x97, 0xa4, 0xa9, 0xa5, 0xa5,
  0xa0, 0x97, 0x8d, 0x96, 0x98, 0x9a, 0x9b, 0x9a, 0x9b, 0x94, 0xb0, 0xb3, 0xb4, 0xb0, 0xab, 0xa3,
  0x98, 0xa7, 0xa9, 0xa6, 0xa5, 0xa3, 0xa1, 0x97, 0xaa, 0xad, 0xb0, 0xac, 0xa8, 0xa1, 0x96, 0x9f,
  0xa1, 0xa0, 0x9f, 0x9e, 0x9b, 0x94, 0x9e, 0xa4, 0xa4, 0xa6, 0xa1, 0x9b, 0x93, 0x91, 0x95, 0x94,
  0x96, 0x97, 0x98, 0x92, 0x9d, 0xa1, 0xa0, 0x9f, 0x9d, 0xa1, 0x9d, 0x94, 0x97, 0x97, 0x98, 0x98,
  0x98, 0x96, 0x99, 0x9d, 0x9d, 0x9d, 0x9c, 0xa0, 0x9c, 0x90, 0x92, 0x93, 0x93, 0x94, 0x94, 0x93,
  0x93, 0x98, 0x96, 0x98, 0x96, 0x9a, 0x97, 0x8a, 0x8b, 0x8c, 0x8e, 0x90, 0x92, 0x91, 0x90, 0x91,
  0x92, 0x91, 0x8e, 0x8b, 0x87, 0x91, 0x91, 0x92, 0x90, 0x8d, 0x8a, 0x85, 0x8e, 0x8e, 0x90, 0x90,
  0x8d, 0x8a, 0x86, 0x8d, 0x8e, 0x8e, 0x8c, 0x8a, 0x87, 0x84, 0x8a, 0x8c, 0x8c, 0x8d, 0x8a, 0x88,
  0x85, 0x88, 0x89, 0x89, 0x88, 0x88, 0x86, 0x84, 0x8c, 0x8e, 0x8e, 0x8e, 0x8e, 0x8b, 0x88, 0x85,
  0x84, 0x86, 0x86, 0x87, 0x82, 0x82, 0x8a, 0x8b, 0x8d, 0x8e, 0x8d, 0x8b, 0x88, 0x83, 0x82, 0x84,
  0x85, 0x85, 0x80, 0x82, 0x88, 0x89, 0x8a, 0x8b, 0x8b, 0x89, 0x87, 0x83, 0x83, 0x83, 0x84, 0x84,
  0x81, 0x81, 0x81, 0x81, 0x82, 0x80, 0x81, 0x7f, 0x83, 0x79, 0x77, 0x75, 0x75, 0x77, 0x79, 0x7c,
  0x80, 0x80, 0x82, 0x80, 0x80, 0x7f, 0x82, 0x78, 0x77, 0x76, 0x76, 0x78, 0x7a, 0x7d, 0x80, 0x80,
  0x81, 0x80, 0x80, 0x7f, 0x83, 0x7d, 0x7b, 0x7a, 0x79, 0x79, 0x7b, 0x7d, 0x73, 0x71, 0x71, 0x71,
  0x75, 0x75, 0x77, 0x6d, 0x6b, 0x6d, 0x6f, 0x6f, 0x75, 0x7c, 0x74, 0x73, 0x72, 0x73, 0x76, 0x76,
  0x78, 0x70, 0x6f, 0x70, 0x71, 0x72, 0x78, 0x7c, 0x77, 0x75, 0x75, 0x74, 0x77, 0x77, 0x79, 0x78,
  0x76, 0x76, 0x76, 0x75, 0x78, 0x7d, 0x66, 0x66, 0x67, 0x69, 0x6c, 0x73, 0x7a, 0x66, 0x66, 0x68,
  0x6b, 0x6f, 0x76, 0x7c, 0x68, 0x68, 0x68, 0x6a, 0x6d, 0x73, 0x7b, 0x69, 0x69, 0x6b, 0x6f, 0x72,
  0x78, 0x7d, 0x6e, 0x6b, 0x6d, 0x6d, 0x70, 0x75, 0x7b, 0x75, 0x73, 0x73, 0x74, 0x75, 0x79, 0x7d,
  0x64, 0x63, 0x65, 0x68, 0x6d, 0x73, 0x78, 0x61, 0x61, 0x62, 0x66, 0x69, 0x6d, 0x74, 0x66, 0x66,
  0x67, 0x6a, 0x6e, 0x73, 0x79, 0x66, 0x67, 0x67, 0x6a, 0x6c, 0x70, 0x76, 0x6d, 0x6b, 0x6d, 0x6d,
  0x72, 0x75, 0x7a, 0x74, 0x71, 0x70, 0x70, 0x71, 0x72, 0x77, 0x5d, 0x5e, 0x60, 0x63, 0x67, 0x6c,
  0x72, 0x5a, 0x5a, 0x5d, 0x5f, 0x62, 0x66, 0x6c, 0x62, 0x62, 0x62, 0x66, 0x68, 0x6d, 0x73, 0x61,
  0x62, 0x63, 0x65, 0x67, 0x6b, 0x6e, 0x6a, 0x68, 0x69, 0x69, 0x6d, 0x70, 0x74, 0x71, 0x6f, 0x6e,
  0x6d, 0x6c, 0x6d, 0x71, 0x56, 0x56, 0x59, 0x5b, 0x5e, 0x63, 0x68, 0x52, 0x52, 0x54, 0x56, 0x5a,
  0x5f, 0x66, 0x5b, 0x5c, 0x5c, 0x5e, 0x60, 0x64, 0x68, 0x5b, 0x5c, 0x5c, 0x5e, 0x60, 0x65, 0x69,
  0x66, 0x63, 0x66, 0x64, 0x67, 0x69, 0x6c, 0x6e, 0x6b, 0x6a, 0x68, 0x67, 0x68, 0x6c, 0x51, 0x50,
  0x54, 0x5b, 0x65, 0x6d, 0x75, 0x50, 0x53, 0x58, 0x62, 0x69, 0x71, 0x79, 0x56, 0x56, 0x58, 0x5f,
  0x68, 0x6e, 0x77, 0x58, 0x5c, 0x60, 0x69, 0x6d, 0x74, 0x7b, 0x61, 0x5e, 0x62, 0x64, 0x6d, 0x72,
  0x78, 0x6c, 0x6b, 0x6c, 0x70, 0x72, 0x75, 0x7b, 0x4b, 0x4e, 0x50, 0x53, 0x56, 0x5c, 0x63, 0x49,
  0x4b, 0x51, 0x54, 0x57, 0x5a, 0x61, 0x52, 0x55, 0x55, 0x57, 0x59, 0x5e, 0x64, 0x54, 0x56, 0x5a,
  0x5d, 0x5e, 0x61, 0x64, 0x60, 0x5d, 0x5f, 0x5d, 0x60, 0x63, 0x68, 0x6b, 0x68, 0x68, 0x67, 0x66,
  0x63, 0x67, 0x47, 0x49, 0x4f, 0x53, 0x57, 0x5c, 0x66, 0x46, 0x47, 0x4b, 0x52, 0x59, 0x61, 0x6b,
  0x4e, 0x50, 0x54, 0x58, 0x5a, 0x5f, 0x68, 0x51, 0x52, 0x54, 0x5b, 0x60, 0x66, 0x6e, 0x5c, 0x59,
  0x5f, 0x5e, 0x62, 0x64, 0x6c, 0x69, 0x65, 0x64, 0x66, 0x67, 0x6a, 0x70, 0x45, 0x48, 0x4d, 0x55,
  0x5b, 0x62, 0x6c, 0x45, 0x48, 0x50, 0x56, 0x5e, 0x68, 0x72, 0x4d, 0x50, 0x51, 0x58, 0x5d, 0x63,
  0x6d, 0x51, 0x54, 0x59, 0x5f, 0x64, 0x6d, 0x75, 0x5c, 0x58, 0x5d, 0x5e, 0x64, 0x68, 0x70, 0x68,
  0x67, 0x67, 0x68, 0x6a, 0x6f, 0x76, 0x47, 0x47, 0x4d, 0x51, 0x55, 0x62, 0x71, 0x46, 0x48, 0x50,
  0x54, 0x5b, 0x6a, 0x76, 0x50, 0x51, 0x54, 0x57, 0x59, 0x64, 0x72, 0x55, 0x58, 0x5c, 0x61, 0x64,
  0x6f, 0x78, 0x61, 0x5d, 0x62, 0x60, 0x65, 0x6b, 0x75, 0x6e, 0x6d, 0x6e, 0x6e, 0x6d, 0x73, 0x7a,
  0x46, 0x48, 0x4f, 0x54, 0x5b, 0x65, 0x71, 0x46, 0x48, 0x4d, 0x51, 0x57, 0x5d, 0x69, 0x50, 0x52,
  0x55, 0x5a, 0x5d, 0x68, 0x72, 0x55, 0x57, 0x5a, 0x5f, 0x60, 0x66, 0x6c, 0x61, 0x5d, 0x64, 0x62,
  0x67, 0x6d, 0x74, 0x6e, 0x6c, 0x6c, 0x6b, 0x6a, 0x6a, 0x70, 0x47, 0x47, 0x4c, 0x53, 0x58, 0x60,
  0x6b, 0x47, 0x49, 0x50, 0x54, 0x57, 0x5c, 0x66, 0x52, 0x53, 0x53, 0x59, 0x5c, 0x63, 0x6d, 0x58,
  0x5b, 0x5e, 0x61, 0x62, 0x66, 0x6b, 0x64, 0x5f, 0x63, 0x62, 0x66, 0x6a, 0x71, 0x71, 0x6f, 0x6f,
  0x6d, 0x6b, 0x69, 0x70, 0x48, 0x4a, 0x51, 0x54, 0x57, 0x59, 0x60, 0x4a, 0x4c, 0x51, 0x54, 0x57,
  0x5b, 0x62, 0x53, 0x54, 0x57, 0x5a, 0x5b, 0x5c, 0x62, 0x5a, 0x5c, 0x5e, 0x60, 0x60, 0x64, 0x67,
  0x63, 0x5f, 0x65, 0x62, 0x65, 0x64, 0x67, 0x6f, 0x6e, 0x6e, 0x6c, 0x69, 0x68, 0x6b, 0x4c, 0x4d,
  0x53, 0x5b, 0x65, 0x6d, 0x76, 0x4c, 0x50, 0x57, 0x62, 0x69, 0x71, 0x79, 0x55, 0x58, 0x5a, 0x61,
  0x68, 0x70, 0x77, 0x5b, 0x60, 0x63, 0x6b, 0x6f, 0x75, 0x7a, 0x66, 0x62, 0x67, 0x68, 0x70, 0x74,
  0x78, 0x71, 0x71, 0x71, 0x74, 0x75, 0x78, 0x7c, 0x4f, 0x52, 0x53, 0x57, 0x5b, 0x63, 0x69, 0x57,
  0x5a, 0x5c, 0x5e, 0x61, 0x69, 0x6c, 0x58, 0x5b, 0x5a, 0x5d, 0x5f, 0x66, 0x6b, 0x64, 0x66, 0x66,
  0x68, 0x69, 0x6e, 0x6f, 0x68, 0x65, 0x67, 0x65, 0x68, 0x6b, 0x6f, 0x75, 0x74, 0x73, 0x72, 0x70,
  0x72, 0x73, 0x5e, 0x60, 0x61, 0x64, 0x67, 0x6b, 0x6f, 0x68, 0x6a, 0x6c, 0x6e, 0x70, 0x72, 0x76,
  0x67, 0x67, 0x65, 0x68, 0x69, 0x6d, 0x71, 0x70, 0x71, 0x71, 0x73, 0x74, 0x76, 0x78, 0x71, 0x6f,
  0x6f, 0x6e, 0x70, 0x71, 0x73, 0x79, 0x79, 0x78, 0x78, 0x77, 0x77, 0x7a, 0x6f, 0x70, 0x71, 0x72,
  0x72, 0x76, 0x7a, 0x76, 0x76, 0x76, 0x75, 0x79, 0x7a, 0x7b, 0x72, 0x73, 0x72, 0x74, 0x73, 0x76,
  0x7a, 0x78, 0x79, 0x78, 0x77, 0x7a, 0x7b, 0x7b, 0x77, 0x77, 0x78, 0x76, 0x77, 0x78, 0x7b, 0x7c,
  0x7c, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x8d, 0x90, 0x91, 0x95, 0x96, 0x98, 0x98, 0x8a, 0x8c, 0x8f,
  0x90, 0x92, 0x93, 0x93, 0x88, 0x89, 0x8b, 0x8c, 0x8d, 0x8f, 0x8f, 0x88, 0x89, 0x8a, 0x8c, 0x8d,
  0x8e, 0x8e, 0x89, 0x8a, 0x8b, 0x8c, 0x8c, 0x8c, 0x8b, 0x86, 0x87, 0x89, 0x89, 0x8a, 0x89, 0x89,
  0x92, 0x96, 0x9a, 0x9e, 0xa2, 0xa4, 0xa6, 0x8e, 0x92, 0x96, 0x99, 0x9d, 0x9f, 0xa0, 0x8c, 0x8f,
  0x93, 0x96, 0x99, 0x9b, 0x9c, 0x8b, 0x8e, 0x91, 0x94, 0x96, 0x98, 0x99, 0x89, 0x8a, 0x8d, 0x8f,
  0x92, 0x93, 0x94, 0x87, 0x88, 0x8a, 0x8c, 0x8e, 0x8f, 0x90, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
  0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x82, 0x82, 0x82, 0x81, 0x82,
  0x83, 0x82, 0x83, 0x84, 0x85, 0x82, 0x82, 0x88, 0x87, 0x88, 0x89, 0x8b, 0x89, 0x84, 0x89, 0x88,
  0x87, 0x85, 0x88, 0x8a, 0x7f, 0x7b, 0x7c, 0x7c, 0x7b, 0x79, 0x7b, 0x7f, 0x7a, 0x7b, 0x7c, 0x7c,
  0x7a, 0x7a, 0x7f, 0x7e, 0x7e, 0x82, 0x81, 0x81, 0x82, 0x80, 0x82, 0x83, 0x83, 0x83, 0x83, 0x84,
  0x83, 0x85, 0x85, 0x88, 0x88, 0x88, 0x89, 0x88, 0x8c, 0x8e, 0x85, 0x88, 0x8b, 0x86, 0x7f, 0x7e,
  0x7d, 0x7d, 0x7b, 0x79, 0x78, 0x7e, 0x7b, 0x77, 0x7c, 0x79, 0x74, 0x79, 0x81, 0x81, 0x80, 0x7f,
  0x7f, 0x7f, 0x7f, 0x9d, 0x98, 0x95, 0x92, 0x8f, 0x8d, 0x8a, 0xa9, 0xa2, 0x9e, 0x9a, 0x97, 0x94,
  0x90, 0xac, 0xa5, 0xa0, 0x9c, 0x9a, 0x96, 0x93, 0x8d, 0x8c, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x74,
  0x78, 0x79, 0x7b, 0x7c, 0x7c, 0x7e, 0x60, 0x65, 0x69, 0x6d, 0x6f, 0x71, 0x73, 0x5f, 0x65, 0x6a,
  0x6d, 0x70, 0x72, 0x74, 0x61, 0x66, 0x6b, 0x6e, 0x70, 0x72, 0x74, 0x77, 0x78, 0x79, 0x7a, 0x7b,
  0x7b, 0x7c, 0x80, 0x7f, 0x7e, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7e, 0x82, 0x81, 0x80, 0x80,
  0x84, 0x83, 0x86, 0x87, 0x87, 0x87, 0x87, 0x84, 0x83, 0x85, 0x86, 0x86, 0x86, 0x86, 0x85, 0x85,
  0x88, 0x86, 0x88, 0x8a, 0x8b, 0x8c, 0x8e, 0x90, 0x91, 0x92, 0x94, 0x94, 0x84, 0x89, 0x90, 0x83,
  0x88, 0x8c, 0x8f, 0x81, 0x8a, 0x84, 0x7e, 0x83, 0x87, 0x8a, 0x7f, 0x7d, 0x7b, 0x7d, 0x7b, 0x7a,
  0x79, 0x7a, 0x77, 0x76, 0x76, 0x75, 0x74, 0x73, 0x7e, 0x7b, 0x77, 0x7d, 0x7b, 0x78, 0x77, 0x7d,
  0x77, 0x79, 0x7c, 0x79, 0x77, 0x75
};

static const unsigned char palette_0E_18_B[] =
{
  0xd3, 0xbe, 0x7a, 0x54, 0x98, 0x81, 0xd3, 0xce, 0xc0, 0xbc, 0xb5, 0xa7, 0x94, 0xd3, 0xca, 0xbc,
  0xb6, 0xae, 0x9e, 0x8f, 0xc3, 0xbd, 0xb7, 0xb2, 0xb1, 0xa3, 0x93, 0xba, 0xb2, 0xab, 0xa6, 0xa2,
  0x95, 0x8d, 0xa8, 0xad, 0xa3, 0xa6, 0xa1, 0x9a, 0x8f, 0x98, 0x98, 0x95, 0x96, 0x97, 0x92, 0x8a,
  0xd0, 0xca, 0xbe, 0xb7, 0xaf, 0xa4, 0x96, 0xcf, 0xc8, 0xc0, 0xba, 0xb4, 0xad, 0x9e, 0xc1, 0xba,
  0xb4, 0xae, 0xab, 0xa0, 0x94, 0xb8, 0xb1, 0xae, 0xa8, 0xa6, 0xa1, 0x9a, 0xa9, 0xaa, 0xa1, 0xa2,
  0x9d, 0x98, 0x90, 0x9a, 0x99, 0x98, 0x98, 0x9a, 0x9b, 0x95, 0xca, 0xcc, 0xc9, 0xc2, 0xb9, 0xad,
  0x9f, 0xc9, 0xc9, 0xc2, 0xbf, 0xba, 0xb2, 0xa7, 0xbb, 0xbd, 0xc0, 0xb9, 0xb4, 0xa8, 0x9c, 0xb4,
  0xb4, 0xb2, 0xaf, 0xae, 0xa7, 0xa0, 0xa5, 0xad, 0xac, 0xad, 0xa6, 0xa0, 0x97, 0x97, 0x9c, 0x9d,
  0x9f, 0xa1, 0xa2, 0x9b, 0xc8, 0xc8, 0xc3, 0xc1, 0xbc, 0xb8, 0xb0, 0xc8, 0xc7, 0xc4, 0xc2, 0xbd,
  0xb7, 0xae, 0xb9, 0xba, 0xbb, 0xb9, 0xb7, 0xb3, 0xac, 0xb1, 0xb1, 0xb3, 0xb1, 0xb0, 0xab, 0xa8,
  0xa4, 0xac, 0xa8, 0xad, 0xa9, 0xa9, 0xa5, 0x98, 0x9c, 0x9e, 0xa1, 0xa4, 0xa5, 0xa1, 0xc6, 0xc6,
  0xc1, 0xb7, 0xa8, 0x9f, 0x94, 0xc6, 0xc4, 0xbd, 0xaf, 0xa4, 0x9a, 0x8f, 0xb8, 0xba, 0xba, 0xb0,
  0xa5, 0x9c, 0x93, 0xb3, 0xb1, 0xaf, 0xa3, 0x9c, 0x95, 0x8d, 0xa5, 0xab, 0xa8, 0xa7, 0x9b, 0x96,
  0x8f, 0x97, 0x9a, 0x9a, 0x97, 0x94, 0x91, 0x89, 0xc6, 0xc4, 0xc2, 0xbf, 0xb9, 0xb2, 0xaa, 0xc4,
  0xc4, 0xc0, 0xbb, 0xb6, 0xb1, 0xaa, 0xb8, 0xb7, 0xba, 0xb7, 0xb5, 0xae, 0xa6, 0xb1, 0xb0, 0xb0,
  0xac, 0xab, 0xa7, 0xa4, 0xa3, 0xaa, 0xa8, 0xac, 0xa7, 0xa5, 0xa0, 0x97, 0x9a, 0x9c, 0x9d, 0x9f,
  0xa2, 0x9f, 0xc3, 0xc2, 0xbd, 0xba, 0xb5, 0xaf, 0xa4, 0xc2, 0xc2, 0xbf, 0xb8, 0xb1, 0xa9, 0x9d,
  0xb6, 0xb6, 0xb6, 0xb3, 0xb1, 0xac, 0xa2, 0xb0, 0xb0, 0xb0, 0xaa, 0xa8, 0xa1, 0x99, 0xa3, 0xa9,
  0xa6, 0xa9, 0xa6, 0xa4, 0x9e, 0x96, 0x9b, 0x9c, 0x9d, 0x9e, 0x9d, 0x96, 0xc3, 0xc0, 0xbc, 0xb6,
  0xae, 0xa6, 0x9a, 0xc2, 0xbf, 0xb8, 0xb3, 0xa8, 0x9e, 0x93, 0xb6, 0xb5, 0xb5, 0xaf, 0xab, 0xa4,
  0x99, 0xb0, 0xae, 0xab, 0xa7, 0xa1, 0x98, 0x92, 0xa3, 0xa8, 0xa5, 0xa6, 0xa1, 0x9d, 0x95, 0x97,
  0x9a, 0x9a, 0x9b, 0x99, 0x94, 0x8e, 0xbf, 0xbf, 0xb7, 0xb1, 0xaa, 0x9e, 0x90, 0xbf, 0xbc, 0xb3,
  0xad, 0xa5, 0x97, 0x8c, 0xb5, 0xb5, 0xb1, 0xad, 0xa7, 0x9c, 0x8e, 0xaf, 0xad, 0xa8, 0xa3, 0x9e,
  0x93, 0x8a, 0xa3, 0xa8, 0xa3, 0xa5, 0x9f, 0x98, 0x8d, 0x95, 0x98, 0x97, 0x98, 0x96, 0x91, 0x89,
  0xbb, 0xb9, 0xb0, 0xaa, 0xa4, 0x99, 0x8f, 0xb7, 0xb6, 0xb1, 0xab, 0xa4, 0x9f, 0x96, 0xb1, 0xaf,
  0xab, 0xa5, 0xa1, 0x97, 0x8e, 0xa9, 0xa8, 0xa6, 0xa1, 0x9d, 0x99, 0x93, 0xa0, 0xa5, 0x9f, 0x9e,
  0x99, 0x92, 0x8c, 0x94, 0x95, 0x96, 0x96, 0x96, 0x95, 0x90, 0xb6, 0xb6, 0xb2, 0xaa, 0xa3, 0x9b,
  0x93, 0xb0, 0xad, 0xa6, 0xa2, 0x9f, 0x9b, 0x93, 0xac, 0xac, 0xac, 0xa5, 0xa0, 0x99, 0x91, 0xa3,
  0xa2, 0x9e, 0x9a, 0x99, 0x96, 0x91, 0x9d, 0xa1, 0xa0, 0x9f, 0x9a, 0x95, 0x8f, 0x90, 0x92, 0x91,
  0x92, 0x92, 0x93, 0x8e, 0xaa, 0xa9, 0xa3, 0x9f, 0x9c, 0x9c, 0x99, 0xa5, 0xa1, 0x9e, 0x9b, 0x99,
  0x96, 0x94, 0xa2, 0xa1, 0x9e, 0x9b, 0x99, 0x9a, 0x96, 0x9a, 0x97, 0x96, 0x94, 0x93, 0x92, 0x91,
  0x96, 0x99, 0x95, 0x96, 0x93, 0x96, 0x94, 0x8c, 0x8c, 0x8c, 0x8d, 0x8e, 0x8f, 0x8e, 0xa6, 0xa2,
  0x9d, 0x97, 0x90, 0x8c, 0x88, 0xa6, 0x9e, 0x99, 0x92, 0x8d, 0x89, 0x86, 0x9f, 0x9c, 0x98, 0x93,
  0x8e, 0x8a, 0x87, 0x9b, 0x96, 0x93, 0x8d, 0x8a, 0x88, 0x86, 0x93, 0x95, 0x91, 0x90, 0x8a, 0x89,
  0x87, 0x8c, 0x8c, 0x8b, 0x89, 0x88, 0x87, 0x84, 0xa0, 0x9d, 0x9a, 0x99, 0x94, 0x90, 0x8c, 0x97,
  0x93, 0x91, 0x90, 0x8e, 0x88, 0x87, 0x99, 0x96, 0x96, 0x94, 0x92, 0x8f, 0x8b, 0x8f, 0x8c, 0x8c,
  0x8b, 0x8b, 0x86, 0x86, 0x90, 0x91, 0x8f, 0x90, 0x8d, 0x8c, 0x89, 0x87, 0x86, 0x86, 0x86, 0x87,
  0x85, 0x85, 0x92, 0x8f, 0x8e, 0x8c, 0x89, 0x87, 0x86, 0x8a, 0x87, 0x84, 0x82, 0x80, 0x80, 0x80,
  0x8c, 0x8a, 0x8b, 0x89, 0x88, 0x86, 0x86, 0x84, 0x82, 0x81, 0x7f, 0x80, 0x80, 0x80, 0x87, 0x87,
  0x86, 0x86, 0x85, 0x84, 0x85, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x86, 0x84, 0x80, 0x7e,
  0x7f, 0x7d, 0x7d, 0x81, 0x7e, 0x7c, 0x7c, 0x79, 0x7c, 0x80, 0x82, 0x81, 0x7f, 0x7d, 0x7e, 0x7d,
  0x7d, 0x7e, 0x7c, 0x7a, 0x7b, 0x79, 0x7c, 0x7f, 0x7f, 0x7f, 0x7e, 0x7d, 0x7e, 0x7d, 0x7d, 0x7e,
  0x7c, 0x7c, 0x7c, 0x7b, 0x7c, 0x80, 0x7a, 0x7a, 0x78, 0x77, 0x76, 0x78, 0x7d, 0x78, 0x79, 0x77,
  0x76, 0x77, 0x7a, 0x7f, 0x79, 0x79, 0x77, 0x76, 0x76, 0x79, 0x7d, 0x78, 0x78, 0x77, 0x77, 0x78,
  0x7b, 0x7f, 0x79, 0x78, 0x78, 0x77, 0x77, 0x7a, 0x7d, 0x7b, 0x7a, 0x7a, 0x79, 0x79, 0x7c, 0x7f,
  0x74, 0x75, 0x73, 0x72, 0x75, 0x77, 0x7b, 0x70, 0x70, 0x70, 0x70, 0x71, 0x73, 0x78, 0x74, 0x75,
  0x72, 0x72, 0x75, 0x77, 0x7b, 0x72, 0x73, 0x72, 0x73, 0x72, 0x75, 0x79, 0x76, 0x76, 0x76, 0x75,
  0x77, 0x79, 0x7c, 0x79, 0x79, 0x77, 0x77, 0x76, 0x76, 0x7a, 0x6e, 0x70, 0x6f, 0x6f, 0x6f, 0x72,
  0x76, 0x68, 0x68, 0x67, 0x68, 0x6a, 0x6c, 0x71, 0x6f, 0x71, 0x70, 0x6f, 0x70, 0x72, 0x77, 0x6c,
  0x6d, 0x6b, 0x6d, 0x6e, 0x70, 0x72, 0x74, 0x73, 0x73, 0x72, 0x73, 0x74, 0x78, 0x76, 0x75, 0x73,
  0x72, 0x72, 0x71, 0x74, 0x62, 0x63, 0x63, 0x64, 0x66, 0x6a, 0x6d, 0x5d, 0x5d, 0x5d, 0x5f, 0x61,
  0x66, 0x6b, 0x66, 0x67, 0x65, 0x66, 0x67, 0x6b, 0x6e, 0x64, 0x65, 0x64, 0x65, 0x66, 0x6b, 0x6e,
  0x6e, 0x6c, 0x6c, 0x6b, 0x6c, 0x6e, 0x70, 0x73, 0x71, 0x6f, 0x6d, 0x6c, 0x6d, 0x70, 0x5b, 0x5b,
  0x5d, 0x63, 0x6c, 0x72, 0x79, 0x5b, 0x5b, 0x60, 0x68, 0x6e, 0x75, 0x7c, 0x60, 0x5f, 0x60, 0x66,
  0x6d, 0x72, 0x7a, 0x62, 0x64, 0x66, 0x6e, 0x72, 0x77, 0x7d, 0x69, 0x66, 0x69, 0x6a, 0x71, 0x75,
  0x7a, 0x72, 0x71, 0x71, 0x74, 0x75, 0x78, 0x7d, 0x58, 0x59, 0x5b, 0x60, 0x60, 0x64, 0x69, 0x56,
  0x57, 0x5b, 0x5e, 0x60, 0x63, 0x68, 0x5d, 0x5e, 0x5e, 0x60, 0x61, 0x65, 0x6a, 0x5f, 0x60, 0x62,
  0x65, 0x66, 0x68, 0x6a, 0x68, 0x65, 0x67, 0x66, 0x68, 0x6a, 0x6e, 0x70, 0x70, 0x6e, 0x6d, 0x6c,
  0x6b, 0x6d, 0x56, 0x58, 0x5b, 0x5d, 0x60, 0x65, 0x6c, 0x56, 0x57, 0x58, 0x5d, 0x61, 0x69, 0x71,
  0x5c, 0x5e, 0x5e, 0x60, 0x62, 0x66, 0x6e, 0x60, 0x61, 0x60, 0x64, 0x67, 0x6d, 0x73, 0x68, 0x65,
  0x68, 0x66, 0x69, 0x6b, 0x70, 0x71, 0x6f, 0x6d, 0x6d, 0x6e, 0x70, 0x75, 0x56, 0x58, 0x5a, 0x5e,
  0x63, 0x68, 0x71, 0x56, 0x59, 0x5c, 0x60, 0x67, 0x6f, 0x77, 0x5c, 0x5e, 0x5e, 0x61, 0x65, 0x6a,
  0x73, 0x60, 0x63, 0x64, 0x67, 0x6c, 0x73, 0x79, 0x68, 0x66, 0x68, 0x68, 0x6c, 0x6f, 0x76, 0x72,
  0x70, 0x71, 0x70, 0x72, 0x75, 0x7a, 0x55, 0x56, 0x5e, 0x62, 0x68, 0x71, 0x7b, 0x56, 0x58, 0x60,
  0x66, 0x6c, 0x76, 0x7d, 0x5b, 0x5c, 0x60, 0x65, 0x69, 0x72, 0x7c, 0x5f, 0x61, 0x66, 0x6c, 0x70,
  0x79, 0x7e, 0x66, 0x63, 0x69, 0x6a, 0x6e, 0x75, 0x7c, 0x70, 0x6f, 0x71, 0x72, 0x74, 0x7a, 0x7e,
  0x59, 0x5b, 0x62, 0x68, 0x6c, 0x75, 0x7c, 0x5c, 0x5e, 0x63, 0x68, 0x6e, 0x71, 0x77, 0x5e, 0x60,
  0x66, 0x6b, 0x6e, 0x76, 0x7d, 0x63, 0x65, 0x68, 0x6d, 0x71, 0x74, 0x78, 0x68, 0x66, 0x6c, 0x6e,
  0x73, 0x77, 0x7d, 0x71, 0x70, 0x71, 0x73, 0x74, 0x75, 0x7a, 0x61, 0x61, 0x63, 0x68, 0x6d, 0x73,
  0x79, 0x67, 0x69, 0x6e, 0x6f, 0x71, 0x74, 0x7a, 0x65, 0x65, 0x65, 0x6a, 0x6e, 0x74, 0x7a, 0x6c,
  0x6e, 0x71, 0x72, 0x73, 0x76, 0x7b, 0x6d, 0x6b, 0x6c, 0x6d, 0x71, 0x76, 0x7a, 0x75, 0x75, 0x76,
  0x76, 0x75, 0x77, 0x7b, 0x6d, 0x6f, 0x72, 0x73, 0x75, 0x73, 0x76, 0x75, 0x78, 0x79, 0x79, 0x79,
  0x7a, 0x7a, 0x70, 0x71, 0x73, 0x74, 0x76, 0x74, 0x77, 0x76, 0x79, 0x79, 0x7a, 0x7a, 0x7a, 0x7b,
  0x74, 0x73, 0x76, 0x76, 0x77, 0x76, 0x78, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7b,
  0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x7c, 0x7a, 0x7d, 0x7e, 0x7e, 0x7f, 0x81, 0x7c, 0x7a, 0x7c, 0x7d,
  0x7e, 0x7f, 0x81, 0x7c, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x7c, 0x7b, 0x7d, 0x7e, 0x7e, 0x7f,
  0x81, 0x7c, 0x7c, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x83, 0x80, 0x81, 0x81, 0x80, 0x81, 0x82, 0x8a,
  0x89, 0x86, 0x86, 0x84, 0x87, 0x85, 0x82, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x82, 0x87, 0x86, 0x85,
  0x84, 0x83, 0x85, 0x85, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83, 0x82,
  0x85, 0x84, 0x90, 0x8f, 0x8b, 0x8b, 0x8a, 0x89, 0x85, 0x93, 0x94, 0x92, 0x8f, 0x8d, 0x89, 0x86,
  0x8d, 0x8c, 0x8a, 0x89, 0x89, 0x88, 0x84, 0x8f, 0x8f, 0x8e, 0x8c, 0x8a, 0x88, 0x86, 0x88, 0x89,
  0x87, 0x87, 0x86, 0x86, 0x83, 0x86, 0x87, 0x88, 0x88, 0x88, 0x87, 0x85, 0x95, 0x94, 0x92, 0x8f,
  0x8d, 0x8b, 0x88, 0x97, 0x96, 0x92, 0x90, 0x8e, 0x8a, 0x86, 0x92, 0x91, 0x91, 0x8e, 0x8c, 0x8b,
  0x88, 0x92, 0x91, 0x8f, 0x8c, 0x8b, 0x88, 0x85, 0x8c, 0x8d, 0x8c, 0x8b, 0x89, 0x88, 0x86, 0x87,
  0x88, 0x89, 0x89, 0x89, 0x87, 0x84, 0x98, 0x98, 0x95, 0x94, 0x92, 0x8d, 0x88, 0x98, 0x97, 0x94,
  0x92, 0x90, 0x8a, 0x86, 0x93, 0x93, 0x92, 0x91, 0x90, 0x8c, 0x87, 0x91, 0x90, 0x8f, 0x8d, 0x8c,
  0x88, 0x85, 0x8b, 0x8d, 0x8c, 0x8d, 0x8b, 0x89, 0x86, 0x85, 0x86, 0x87, 0x87, 0x88, 0x86, 0x84,
  0x99, 0x99, 0x97, 0x96, 0x92, 0x8e, 0x8b, 0x9b, 0x9b, 0x99, 0x98, 0x97, 0x93, 0x8d, 0x95, 0x94,
  0x94, 0x93, 0x90, 0x8d, 0x8a, 0x93, 0x93, 0x93, 0x91, 0x91, 0x8e, 0x8b, 0x8c, 0x8f, 0x8d, 0x8e,
  0x8c, 0x8a, 0x88, 0x87, 0x88, 0x89, 0x8a, 0x8c, 0x8c, 0x8a, 0x9d, 0x9c, 0x9c, 0x99, 0x97, 0x94,
  0x8f, 0x9f, 0xa0, 0xa1, 0x9f, 0x9d, 0x99, 0x96, 0x97, 0x96, 0x98, 0x96, 0x95, 0x92, 0x8e, 0x96,
  0x96, 0x98, 0x96, 0x96, 0x93, 0x92, 0x8d, 0x8f, 0x8f, 0x90, 0x8f, 0x8e, 0x8b, 0x87, 0x89, 0x8c,
  0x8d, 0x8f, 0x90, 0x8e, 0xa2, 0xa4, 0xa5, 0xa3, 0xa1, 0x9c, 0x99, 0xa6, 0xa9, 0xab, 0xaa, 0xa6,
  0xa2, 0x9c, 0x9c, 0x9c, 0xa0, 0x9f, 0x9f, 0x9a, 0x97, 0x9b, 0x9d, 0x9f, 0x9e, 0x9e, 0x9a, 0x98,
  0x90, 0x95, 0x95, 0x98, 0x96, 0x94, 0x94, 0x8b, 0x8e, 0x90, 0x93, 0x96, 0x97, 0x94, 0xaa, 0xac,
  0xab, 0xa6, 0x9f, 0x98, 0x8f, 0xab, 0xac, 0xa8, 0xa1, 0x9c, 0x94, 0x8b, 0xa2, 0xa4, 0xa5, 0xa1,
  0x9c, 0x95, 0x8e, 0x9f, 0x9e, 0x9e, 0x98, 0x94, 0x8f, 0x8a, 0x94, 0x9a, 0x98, 0x99, 0x93, 0x90,
  0x8c, 0x8b, 0x8e, 0x8f, 0x8e, 0x8e, 0x8c, 0x87, 0xb0, 0xb0, 0xaf, 0xad, 0xaa, 0xa8, 0xa3, 0xb8,
  0xb8, 0xb3, 0xb0, 0xad, 0xad, 0xa7, 0xa7, 0xa7, 0xa8, 0xa6, 0xa7, 0xa4, 0xa0, 0xa8, 0xa8, 0xa6,
  0xa2, 0xa2, 0xa1, 0xa1, 0x98, 0x9c, 0x9a, 0x9e, 0x9c, 0x9c, 0x9a, 0x8f, 0x92, 0x93, 0x95, 0x98,
  0x9d, 0x9a, 0xbe, 0xbd, 0xb6, 0xb4, 0xb0, 0xad, 0xa3, 0xc5, 0xc5, 0xc1, 0xba, 0xb3, 0xaa, 0x9f,
  0xb1, 0xb0, 0xae, 0xac, 0xac, 0xa8, 0x9f, 0xae, 0xae, 0xaf, 0xa8, 0xa7, 0x9f, 0x99, 0x9d, 0xa1,
  0x9e, 0xa1, 0x9f, 0x9f, 0x99, 0x90, 0x94, 0x97, 0x98, 0x9b, 0x9a, 0x94, 0xc9, 0xc7, 0xc1, 0xba,
  0xb1, 0xab, 0x9e, 0xce, 0xce, 0xc0, 0xb9, 0xb0, 0xa2, 0x96, 0xb9, 0xb7, 0xb8, 0xb2, 0xad, 0xa7,
  0x9b, 0xb4, 0xb1, 0xad, 0xa8, 0xa4, 0x9a, 0x92, 0xa1, 0xa8, 0xa4, 0xa5, 0x9f, 0x9e, 0x95, 0x92,
  0x95, 0x96, 0x98, 0x99, 0x95, 0x8e, 0x9e, 0xa4, 0xa6, 0xac, 0xac, 0xad, 0xae, 0x99, 0x9e, 0xa2,
  0xa5, 0xa6, 0xa7, 0xa7, 0x96, 0x9a, 0x9d, 0x9f, 0xa0, 0xa1, 0xa2, 0x93, 0x96, 0x99, 0x9b, 0x9d,
  0x9d, 0x9d, 0x95, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9b, 0x8f, 0x91, 0x94, 0x94, 0x95, 0x96, 0x96,
  0x94, 0x97, 0x99, 0x9a, 0x9a, 0x99, 0x98, 0x92, 0x94, 0x96, 0x96, 0x96, 0x96, 0x95, 0x8d, 0x90,
  0x91, 0x92, 0x91, 0x91, 0x91, 0x8d, 0x8e, 0x8f, 0x8f, 0x8f, 0x90, 0x8f, 0x8b, 0x8d, 0x8f, 0x8f,
  0x8f, 0x8f, 0x8e, 0x8a, 0x8b, 0x8c, 0x8d, 0x8d, 0x8d, 0x8c, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82,
  0x82, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x86, 0x8d, 0x8b, 0x8a, 0x8b, 0x8e, 0x8b, 0x88,
  0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x8b, 0x85, 0x88, 0x87, 0x85, 0x85, 0x88, 0x89, 0x82, 0x7e, 0x7e,
  0x7d, 0x7d, 0x7b, 0x7c, 0x81, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x83, 0x87, 0x8a, 0x87, 0x87,
  0x88, 0x86, 0x87, 0x89, 0x8b, 0x8a, 0x8b, 0x8b, 0x8d, 0x8a, 0x89, 0x8a, 0x8b, 0x8b, 0x8b, 0x8d,
  0x88, 0x8b, 0x8c, 0x85, 0x87, 0x89, 0x86, 0x7f, 0x7e, 0x7e, 0x7d, 0x7c, 0x7c, 0x7b, 0x7f, 0x7d,
  0x7b, 0x80, 0x7d, 0x7a, 0x7e, 0x82, 0x82, 0x82, 0x85, 0x85, 0x85, 0x88, 0xb0, 0xa8, 0xa3, 0x9d,
  0x97, 0x93, 0x8f, 0xaa, 0xa4, 0x9f, 0x9b, 0x97, 0x94, 0x91, 0x92, 0x8f, 0x8c, 0x8b, 0x8a, 0x89,
  0x88, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x68, 0x6c, 0x6f, 0x71, 0x73, 0x74, 0x77, 0x67,
  0x6c, 0x6d, 0x72, 0x73, 0x75, 0x77, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x8b, 0x88, 0x86,
  0x85, 0x84, 0x84, 0x83, 0x9c, 0x98, 0x95, 0x92, 0x8f, 0x8c, 0x8a, 0xaa, 0xa4, 0x9f, 0x99, 0x95,
  0x92, 0x8d, 0x87, 0x8a, 0x8f, 0x88, 0x8c, 0x8f, 0x91, 0x86, 0x89, 0x8e, 0x87, 0x8b, 0x8e, 0x8f,
  0x8e, 0x91, 0x90, 0x8f, 0x92, 0x94, 0x96, 0x8a, 0x8f, 0x91, 0x8d, 0x90, 0x92, 0x93, 0x89, 0x88,
  0x8c, 0x84, 0x87, 0x89, 0x8b, 0x86, 0x88, 0x84, 0x80, 0x83, 0x86, 0x87, 0x82, 0x80, 0x7e, 0x80,
  0x7f, 0x7d, 0x7c, 0x7f, 0x7c, 0x7b, 0x7b, 0x7a, 0x79, 0x78, 0x82, 0x80, 0x7c, 0x83, 0x81, 0x7f,
  0x7e, 0x84, 0x80, 0x82, 0x85, 0x83, 0x83, 0x81, 0x84, 0x85, 0x86, 0x87, 0x88, 0x88, 0x89, 0x8b,
  0x89, 0x8e, 0x8f, 0x90, 0x90, 0x90
};

static const unsigned char palette_0E_21_L[] =
{
  0xe4, 0xab, 0x7b, 0x7e, 0x92, 0x20, 0xe8, 0xe8, 0xea, 0xea, 0xeb, 0xee, 0xf0, 0xe6, 0xea, 0xea,
  0xeb, 0xec, 0xee, 0xf1, 0xd1, 0xd2, 0xdb, 0xdb, 0xe2, 0xe5, 0xe7, 0xc2, 0xc5, 0xcc, 0xcb, 0xd4,
  0xd6, 0xe2, 0xa2, 0xb4, 0xb3, 0xc1, 0xc3, 0xce, 0xd8, 0x77, 0x88, 0x93, 0x9f, 0xb3, 0xc7, 0xd0,
  0xe1, 0xe5, 0xe5, 0xe6, 0xea, 0xec, 0xee, 0xdb, 0xde, 0xe0, 0xdf, 0xe3, 0xe7, 0xec, 0xcb, 0xce,
  0xd6, 0xd8, 0xe1, 0xe3, 0xe5, 0xb9, 0xbb, 0xc2, 0xc4, 0xcc, 0xcf, 0xde, 0xa1, 0xb2, 0xb1, 0xc1,
  0xc4, 0xcc, 0xd5, 0x79, 0x87, 0x94, 0x9f, 0xb0, 0xc2, 0xcc, 0xd4, 0xd6, 0xdb, 0xde, 0xe1, 0xe4,
  0xe9, 0xcb, 0xce, 0xd2, 0xd5, 0xd8, 0xdd, 0xe2, 0xbd, 0xc0, 0xcc, 0xd0, 0xd8, 0xd9, 0xe0, 0xa9,
  0xac, 0xb6, 0xba, 0xc2, 0xc6, 0xd4, 0x92, 0xa5, 0xa6, 0xb9, 0xbd, 0xc6, 0xd0, 0x6a, 0x76, 0x83,
  0x92, 0xa6, 0xb8, 0xc2, 0xc0, 0xc4, 0xca, 0xcd, 0xcf, 0xd7, 0xdb, 0xb9, 0xbb, 0xc0, 0xc3, 0xca,
  0xd1, 0xd9, 0xac, 0xaf, 0xbd, 0xbf, 0xca, 0xcf, 0xd2, 0x98, 0x9c, 0xa6, 0xa9, 0xb5, 0xbb, 0xca,
  0x86, 0x96, 0x9c, 0xab, 0xae, 0xba, 0xc4, 0x62, 0x6d, 0x78, 0x85, 0x99, 0xac, 0xbb, 0xac, 0xb3,
  0xc0, 0xcc, 0xd9, 0xe0, 0xe8, 0xad, 0xba, 0xc6, 0xd4, 0xdd, 0xe3, 0xeb, 0x9a, 0xa1, 0xb4, 0xc0,
  0xd2, 0xd9, 0xe0, 0x90, 0x9c, 0xad, 0xbc, 0xc8, 0xce, 0xdd, 0x76, 0x89, 0x93, 0xac, 0xb7, 0xc4,
  0xd0, 0x58, 0x6b, 0x7e, 0x96, 0xab, 0xbf, 0xcc, 0xac, 0xb3, 0xba, 0xc1, 0xc7, 0xcd, 0xd4, 0xac,
  0xb0, 0xbb, 0xc1, 0xc7, 0xcb, 0xd1, 0x9b, 0xa3, 0xb0, 0xb5, 0xc0, 0xc6, 0xcc, 0x90, 0x93, 0xa3,
  0xa8, 0xb4, 0xb5, 0xc3, 0x79, 0x8c, 0x92, 0xa4, 0xa8, 0xb3, 0xbe, 0x5b, 0x66, 0x77, 0x88, 0x9a,
  0xa9, 0xb5, 0xac, 0xb1, 0xbc, 0xc1, 0xc8, 0xcd, 0xd8, 0xad, 0xb0, 0xb7, 0xc1, 0xc9, 0xd1, 0xdd,
  0x9b, 0xa0, 0xb2, 0xb7, 0xc1, 0xc6, 0xd1, 0x91, 0x94, 0xa1, 0xaa, 0xb5, 0xbe, 0xd0, 0x79, 0x89,
  0x93, 0xa4, 0xa9, 0xb4, 0xc4, 0x5b, 0x66, 0x76, 0x87, 0x9b, 0xb0, 0xbf, 0xae, 0xb3, 0xbb, 0xc3,
  0xcc, 0xd1, 0xdc, 0xaf, 0xb3, 0xbe, 0xc6, 0xcf, 0xda, 0xe4, 0x9c, 0xa1, 0xb0, 0xb7, 0xc4, 0xca,
  0xd5, 0x91, 0x96, 0xa6, 0xad, 0xbb, 0xc5, 0xd7, 0x78, 0x8a, 0x91, 0xa4, 0xac, 0xb9, 0xc7, 0x5a,
  0x68, 0x78, 0x89, 0xa1, 0xb6, 0xc5, 0xb7, 0xb7, 0xbf, 0xc4, 0xcb, 0xd8, 0xe6, 0xb4, 0xba, 0xc3,
  0xc8, 0xd1, 0xdf, 0xea, 0xa9, 0xa9, 0xb7, 0xba, 0xc5, 0xd1, 0xdf, 0x9e, 0xa3, 0xaf, 0xb3, 0xbf,
  0xcd, 0xde, 0x88, 0x94, 0x99, 0xa6, 0xad, 0xbf, 0xd1, 0x69, 0x74, 0x81, 0x8d, 0xa5, 0xbe, 0xcd,
  0xb0, 0xb6, 0xbd, 0xc1, 0xcd, 0xd8, 0xe2, 0xa9, 0xaf, 0xb5, 0xbd, 0xc3, 0xcc, 0xdc, 0xa2, 0xa7,
  0xb3, 0xb7, 0xc7, 0xd1, 0xdb, 0x93, 0x97, 0xa0, 0xa5, 0xb1, 0xb9, 0xcf, 0x84, 0x92, 0x96, 0xa5,
  0xaf, 0xbe, 0xcc, 0x63, 0x6d, 0x78, 0x86, 0x97, 0xad, 0xc1, 0xa0, 0xa4, 0xac, 0xb5, 0xbe, 0xc9,
  0xd7, 0x99, 0x9d, 0xa5, 0xab, 0xb3, 0xbc, 0xc9, 0x94, 0x98, 0xa4, 0xac, 0xb8, 0xc3, 0xd1, 0x85,
  0x8a, 0x95, 0x99, 0xa5, 0xad, 0xc0, 0x78, 0x86, 0x8b, 0x9c, 0xa5, 0xb2, 0xc5, 0x5a, 0x67, 0x73,
  0x7e, 0x8f, 0xa2, 0xb3, 0x91, 0x95, 0x9c, 0x9f, 0xa6, 0xb3, 0xbd, 0x89, 0x8d, 0x90, 0x94, 0x9d,
  0xaa, 0xbc, 0x84, 0x88, 0x94, 0x99, 0xa3, 0xaf, 0xb8, 0x75, 0x7a, 0x80, 0x84, 0x90, 0x9c, 0xb1,
  0x6c, 0x78, 0x7f, 0x8b, 0x90, 0x9f, 0xad, 0x51, 0x5b, 0x63, 0x6a, 0x7d, 0x93, 0xa6, 0x83, 0x89,
  0x97, 0xa7, 0xbd, 0xcd, 0xdc, 0x85, 0x91, 0x9e, 0xb5, 0xc4, 0xd3, 0xe2, 0x7a, 0x7f, 0x90, 0x9f,
  0xb9, 0xc5, 0xd5, 0x76, 0x80, 0x8f, 0xa3, 0xb5, 0xc1, 0xd7, 0x62, 0x70, 0x7a, 0x90, 0xa4, 0xb5,
  0xc8, 0x4f, 0x5d, 0x6c, 0x84, 0x9e, 0xb6, 0xca, 0x85, 0x8b, 0x91, 0x94, 0x9c, 0xa8, 0xb7, 0x86,
  0x89, 0x94, 0x99, 0xa0, 0xa8, 0xb3, 0x7a, 0x80, 0x8a, 0x8f, 0x99, 0xa4, 0xb3, 0x75, 0x77, 0x84,
  0x89, 0x94, 0x9a, 0xac, 0x63, 0x71, 0x75, 0x83, 0x88, 0x96, 0xa8, 0x4e, 0x57, 0x63, 0x6f, 0x7f,
  0x8f, 0x9f, 0x88, 0x8d, 0x97, 0x9f, 0xa7, 0xae, 0xc1, 0x89, 0x8c, 0x93, 0x9f, 0xa9, 0xb7, 0xcc,
  0x7d, 0x81, 0x90, 0x97, 0xa1, 0xa9, 0xbc, 0x77, 0x79, 0x84, 0x8e, 0x9a, 0xa8, 0xc1, 0x63, 0x71,
  0x7a, 0x88, 0x8d, 0x9a, 0xb1, 0x4d, 0x56, 0x61, 0x72, 0x84, 0x9b, 0xb1, 0x8a, 0x8e, 0x97, 0xa2,
  0xad, 0xb9, 0xcd, 0x8a, 0x8f, 0x9c, 0xa6, 0xb6, 0xc9, 0xd8, 0x7e, 0x82, 0x8f, 0x99, 0xa8, 0xb3,
  0xc6, 0x76, 0x7a, 0x89, 0x92, 0xa3, 0xb3, 0xcc, 0x63, 0x6f, 0x77, 0x8a, 0x93, 0xa1, 0xb9, 0x4a,
  0x55, 0x66, 0x76, 0x8c, 0xaa, 0xbf, 0x7f, 0x80, 0x8f, 0x99, 0xa9, 0xc3, 0xde, 0x7d, 0x86, 0x97,
  0xa4, 0xb4, 0xd0, 0xe3, 0x73, 0x75, 0x89, 0x91, 0xa4, 0xbd, 0xd6, 0x6b, 0x73, 0x86, 0x91, 0xa4,
  0xbf, 0xd8, 0x5a, 0x64, 0x70, 0x80, 0x8e, 0xac, 0xc9, 0x40, 0x4c, 0x60, 0x72, 0x8c, 0xaf, 0xc7,
  0x79, 0x80, 0x90, 0x9d, 0xae, 0xc5, 0xd9, 0x72, 0x7a, 0x87, 0x95, 0xa3, 0xb4, 0xcc, 0x6d, 0x75,
  0x89, 0x93, 0xa9, 0xc0, 0xd1, 0x60, 0x67, 0x75, 0x83, 0x95, 0xa4, 0xc2, 0x54, 0x63, 0x71, 0x86,
  0x95, 0xae, 0xc5, 0x3b, 0x45, 0x55, 0x69, 0x7e, 0x99, 0xb5, 0x72, 0x7b, 0x8a, 0x9d, 0xaa, 0xba,
  0xcd, 0x66, 0x75, 0x8b, 0x94, 0xa1, 0xab, 0xc0, 0x69, 0x73, 0x84, 0x93, 0xa4, 0xb3, 0xc7, 0x59,
  0x67, 0x7d, 0x86, 0x94, 0x9d, 0xb4, 0x54, 0x65, 0x6f, 0x86, 0x92, 0xa4, 0xba, 0x38, 0x49, 0x5b,
  0x6c, 0x7e, 0x93, 0xa9, 0x58, 0x69, 0x7f, 0x89, 0x93, 0x9f, 0xac, 0x49, 0x60, 0x6e, 0x7b, 0x89,
  0x9a, 0xae, 0x51, 0x61, 0x79, 0x83, 0x8f, 0x9b, 0xa9, 0x40, 0x54, 0x64, 0x6f, 0x7e, 0x8e, 0xa7,
  0x41, 0x55, 0x67, 0x77, 0x81, 0x8d, 0x9e, 0x29, 0x3c, 0x4b, 0x5b, 0x6f, 0x85, 0x9a, 0x37, 0x4f,
  0x74, 0x94, 0xb5, 0xc8, 0xdc, 0x3d, 0x66, 0x84, 0xaa, 0xbe, 0xd1, 0xe3, 0x34, 0x4b, 0x6e, 0x8d,
  0xb0, 0xc1, 0xd5, 0x37, 0x5a, 0x76, 0x97, 0xae, 0xc0, 0xd7, 0x2d, 0x41, 0x5d, 0x80, 0x99, 0xb0,
  0xc8, 0x24, 0x3f, 0x57, 0x79, 0x97, 0xb2, 0xc8, 0x43, 0x59, 0x6b, 0x78, 0x87, 0x9b, 0xb1, 0x55,
  0x64, 0x7b, 0x87, 0x92, 0xa0, 0xb0, 0x40, 0x54, 0x66, 0x73, 0x83, 0x97, 0xab, 0x49, 0x57, 0x6f,
  0x79, 0x86, 0x92, 0xa6, 0x33, 0x49, 0x56, 0x68, 0x74, 0x8a, 0xa1, 0x2f, 0x3d, 0x51, 0x62, 0x76,
  0x8a, 0x9d, 0x5e, 0x6b, 0x7f, 0x8c, 0x9a, 0xa9, 0xc0, 0x6c, 0x73, 0x80, 0x96, 0xa7, 0xb9, 0xd0,
  0x58, 0x62, 0x78, 0x84, 0x96, 0xa5, 0xbb, 0x5f, 0x65, 0x74, 0x85, 0x9a, 0xa9, 0xc5, 0x46, 0x56,
  0x65, 0x7a, 0x84, 0x97, 0xaf, 0x3d, 0x48, 0x56, 0x6c, 0x84, 0x9f, 0xb6, 0x74, 0x7f, 0x8b, 0x9d,
  0xac, 0xbc, 0xd2, 0x7b, 0x86, 0x97, 0xa5, 0xba, 0xcd, 0xdd, 0x6a, 0x76, 0x85, 0x94, 0xa7, 0xb6,
  0xcc, 0x6b, 0x74, 0x87, 0x94, 0xa9, 0xbb, 0xd1, 0x55, 0x66, 0x70, 0x87, 0x95, 0xa6, 0xbf, 0x44,
  0x51, 0x64, 0x78, 0x94, 0xb1, 0xc3, 0x7f, 0x8c, 0xa4, 0xaf, 0xbe, 0xd3, 0xe4, 0x7f, 0x94, 0xab,
  0xb8, 0xc9, 0xde, 0xe9, 0x77, 0x83, 0x9d, 0xa7, 0xba, 0xcf, 0xe0, 0x72, 0x84, 0x9d, 0xa8, 0xbb,
  0xcf, 0xe1, 0x61, 0x72, 0x86, 0x99, 0xa6, 0xbf, 0xd5, 0x4b, 0x5d, 0x74, 0x87, 0xa1, 0xc1, 0xd3,
  0x7e, 0x93, 0xa9, 0xb4, 0xc6, 0xd7, 0xe3, 0x7b, 0x8f, 0x9f, 0xaf, 0xbd, 0xca, 0xda, 0x75, 0x88,
  0x9f, 0xac, 0xc1, 0xd1, 0xdd, 0x6e, 0x7e, 0x90, 0x9d, 0xb0, 0xb9, 0xd0, 0x5f, 0x77, 0x87, 0x9d,
  0xac, 0xc0, 0xd1, 0x48, 0x59, 0x6b, 0x80, 0x97, 0xae, 0xc3, 0x81, 0x88, 0x95, 0xa9, 0xb8, 0xca,
  0xdb, 0x7f, 0x8d, 0x9f, 0xa9, 0xb4, 0xc1, 0xd1, 0x78, 0x80, 0x90, 0xa2, 0xb5, 0xc6, 0xd5, 0x71,
  0x7f, 0x92, 0x9b, 0xa9, 0xb4, 0xc9, 0x61, 0x6f, 0x78, 0x93, 0xa1, 0xb5, 0xc8, 0x48, 0x59, 0x6c,
  0x7d, 0x91, 0xa7, 0xbb, 0x7a, 0x88, 0x9a, 0xa3, 0xaf, 0xb9, 0xc4, 0x75, 0x8a, 0x93, 0x9e, 0xaa,
  0xb8, 0xc7, 0x72, 0x7e, 0x93, 0x9c, 0xab, 0xb5, 0xbf, 0x66, 0x77, 0x85, 0x8e, 0x9c, 0xaa, 0xbe,
  0x5c, 0x6f, 0x7d, 0x8f, 0x99, 0xa7, 0xb5, 0x42, 0x54, 0x63, 0x73, 0x88, 0x9f, 0xb2, 0x6a, 0x84,
  0x9f, 0xb5, 0xca, 0xd6, 0xe3, 0x74, 0x95, 0xab, 0xc5, 0xd2, 0xdc, 0xe8, 0x64, 0x7d, 0x9a, 0xaf,
  0xc5, 0xd2, 0xde, 0x69, 0x86, 0x9d, 0xb4, 0xc4, 0xd0, 0xdf, 0x53, 0x6e, 0x85, 0xa0, 0xb3, 0xc3,
  0xd4, 0x45, 0x60, 0x78, 0x93, 0xac, 0xc3, 0xd2, 0x7b, 0x8c, 0x99, 0xa2, 0xab, 0xb9, 0xc7, 0x84,
  0x92, 0xa6, 0xad, 0xb4, 0xbe, 0xc6, 0x73, 0x84, 0x94, 0x9c, 0xa9, 0xb4, 0xc1, 0x77, 0x82, 0x97,
  0x9e, 0xa6, 0xaf, 0xbe, 0x5f, 0x76, 0x80, 0x90, 0x98, 0xa8, 0xba, 0x4f, 0x5e, 0x72, 0x81, 0x94,
  0xa6, 0xb2, 0x88, 0x97, 0xa9, 0xb3, 0xbc, 0xc5, 0xd2, 0x92, 0x97, 0xa7, 0xb7, 0xc2, 0xcf, 0xdd,
  0x81, 0x8f, 0xa5, 0xad, 0xb8, 0xc1, 0xcd, 0x81, 0x89, 0x9b, 0xaa, 0xb7, 0xc2, 0xd4, 0x6a, 0x7d,
  0x8f, 0x9f, 0xa5, 0xb4, 0xc4, 0x55, 0x63, 0x78, 0x8d, 0xa1, 0xb8, 0xc7, 0x94, 0xa2, 0xaf, 0xbd,
  0xc7, 0xd0, 0xde, 0x97, 0xa6, 0xb8, 0xc2, 0xcf, 0xdb, 0xe5, 0x8b, 0x98, 0xa7, 0xb5, 0xc2, 0xcb,
  0xd8, 0x87, 0x92, 0xa7, 0xb1, 0xc0, 0xcb, 0xda, 0x71, 0x86, 0x92, 0xa8, 0xb1, 0xbd, 0xce, 0x59,
  0x6a, 0x80, 0x92, 0xa9, 0xc0, 0xce, 0x98, 0xa1, 0xb4, 0xbb, 0xc5, 0xd6, 0xe5, 0x99, 0xa8, 0xba,
  0xc2, 0xcc, 0xde, 0xea, 0x8e, 0x95, 0xac, 0xb2, 0xbf, 0xcf, 0xdf, 0x86, 0x92, 0xa6, 0xad, 0xbc,
  0xcc, 0xde, 0x75, 0x83, 0x92, 0xa1, 0xaa, 0xbe, 0xd3, 0x5e, 0x6b, 0x7e, 0x8c, 0xa2, 0xbf, 0xcf,
  0x97, 0xa5, 0xb8, 0xc1, 0xcb, 0xd9, 0xe5, 0x98, 0xa5, 0xb3, 0xbd, 0xc6, 0xd0, 0xdc, 0x8d, 0x99,
  0xaf, 0xb7, 0xc5, 0xd2, 0xdd, 0x85, 0x8f, 0xa0, 0xa8, 0xb5, 0xbe, 0xd0, 0x73, 0x86, 0x94, 0xa6,
  0xaf, 0xc1, 0xd0, 0x5c, 0x6b, 0x7b, 0x8a, 0x9d, 0xb2, 0xc4, 0x9b, 0x9c, 0xaa, 0xb9, 0xc4, 0xcf,
  0xdc, 0x9a, 0xa1, 0xb5, 0xbd, 0xc1, 0xcb, 0xd8, 0x90, 0x91, 0xa3, 0xb0, 0xbc, 0xc9, 0xd5, 0x86,
  0x8b, 0xa1, 0xa8, 0xb1, 0xb9, 0xcd, 0x75, 0x7f, 0x8a, 0x9f, 0xa7, 0xb8, 0xc8, 0x5c, 0x67, 0x7c,
  0x8a, 0x99, 0xad, 0xbc, 0x98, 0x9f, 0xb3, 0xba, 0xc0, 0xc4, 0xce, 0x97, 0xa3, 0xb0, 0xb8, 0xbf,
  0xc8, 0xd2, 0x8c, 0x92, 0xab, 0xb1, 0xbb, 0xbf, 0xc8, 0x83, 0x8f, 0x9e, 0xa5, 0xaf, 0xb7, 0xc8,
  0x74, 0x81, 0x90, 0xa0, 0xa5, 0xae, 0xbc, 0x5e, 0x6b, 0x7b, 0x87, 0x9a, 0xac, 0xba, 0x9a, 0xa5,
  0xb6, 0xc4, 0xd4, 0xdd, 0xe7, 0x9d, 0xb1, 0xbf, 0xd0, 0xd8, 0xe2, 0xeb, 0x8f, 0x99, 0xae, 0xbc,
  0xcd, 0xd7, 0xdf, 0x8a, 0x9b, 0xac, 0xb8, 0xc5, 0xcd, 0xdd, 0x74, 0x86, 0x93, 0xa8, 0xb4, 0xc3,
  0xd0, 0x5e, 0x71, 0x81, 0x96, 0xa9, 0xbf, 0xcc, 0xa6, 0xaf, 0xb6, 0xbb, 0xc1, 0xcc, 0xd6, 0xb6,
  0xbc, 0xc4, 0xc8, 0xcb, 0xd6, 0xdb, 0x99, 0xa2, 0xad, 0xb2, 0xbd, 0xc6, 0xd0, 0x9f, 0xa4, 0xaf,
  0xb2, 0xba, 0xc3, 0xce, 0x7e, 0x8f, 0x92, 0xa2, 0xa7, 0xb5, 0xc3, 0x6d, 0x78, 0x85, 0x91, 0xa1,
  0xb5, 0xbe, 0xbd, 0xc4, 0xcc, 0xd0, 0xd5, 0xda, 0xdf, 0xcc, 0xd1, 0xd7, 0xdc, 0xe0, 0xe3, 0xe8,
  0xad, 0xb2, 0xc1, 0xc5, 0xce, 0xd4, 0xd8, 0xae, 0xb2, 0xbd, 0xc3, 0xca, 0xce, 0xda, 0x89, 0x9b,
  0xa1, 0xb1, 0xb4, 0xbf, 0xcb, 0x71, 0x7d, 0x8c, 0x9a, 0xac, 0xbf, 0xca, 0xd4, 0xd9, 0xde, 0xe1,
  0xe2, 0xe7, 0xec, 0xdc, 0xe0, 0xe3, 0xe4, 0xe9, 0xeb, 0xed, 0xbf, 0xc3, 0xcf, 0xd3, 0xda, 0xde,
  0xe3, 0xba, 0xbc, 0xc6, 0xc8, 0xd1, 0xd4, 0xdf, 0x96, 0xa7, 0xaa, 0xbd, 0xbe, 0xc5, 0xd3, 0x77,
  0x83, 0x91, 0x9e, 0xb2, 0xc5, 0xce, 0xa9, 0xa3, 0xa1, 0x9e, 0x9b, 0x97, 0x96, 0x98, 0x95, 0x94,
  0x90, 0x8e, 0x8c, 0x8a, 0x89, 0x86, 0x87, 0x85, 0x84, 0x82, 0x80, 0x7c, 0x7b, 0x7b, 0x7a, 0x77,
  0x75, 0x76, 0x65, 0x67, 0x68, 0x68, 0x6a, 0x6b, 0x6c, 0x57, 0x58, 0x5a, 0x5a, 0x5b, 0x5d, 0x5e,
  0xa3, 0x9b, 0x93, 0x8e, 0x85, 0x7d, 0x78, 0x92, 0x8c, 0x86, 0x80, 0x78, 0x73, 0x6e, 0x86, 0x81,
  0x7c, 0x75, 0x71, 0x6b, 0x67, 0x73, 0x6f, 0x6d, 0x67, 0x63, 0x60, 0x5e, 0x68, 0x67, 0x65, 0x61,
  0x5e, 0x5b, 0x58, 0x50, 0x53, 0x53, 0x53, 0x4f, 0x4c, 0x4a, 0xed, 0xdf, 0xd3, 0xc1, 0x98, 0x73,
  0x3d, 0xe6, 0xd9, 0xcb, 0xac, 0x87, 0x5b, 0x31, 0xe7, 0xdb, 0xce, 0xb9, 0xa0, 0x88, 0x68, 0xe4,
  0xd9, 0xcc, 0xb6, 0xa0, 0x87, 0x68, 0xe3, 0xd2, 0xc7, 0xaf, 0x96, 0x7a, 0x5c, 0xe2, 0xcc, 0xc1,
  0xab, 0x93, 0x72, 0x54, 0xe4, 0xd0, 0xc4, 0xae, 0x95, 0x79, 0x5b, 0xe4, 0xd3, 0xc5, 0xb3, 0x9a,
  0x80, 0x60, 0x56, 0x56, 0x53, 0x47, 0x44, 0x41, 0x3b, 0x50, 0x4d, 0x48, 0x42, 0x3e, 0x3a, 0x37,
  0x4d, 0x46, 0x40, 0x39, 0x35, 0x32, 0x30, 0x40, 0x38, 0x2d, 0x30, 0x28, 0x21, 0x26, 0x35, 0x30,
  0x2b, 0x35, 0x33, 0x2e, 0x3a, 0x38, 0x37, 0x33, 0x40, 0x3f, 0x3a, 0x48, 0xa4, 0x93, 0x85, 0x7a,
  0x6c, 0x5f, 0x4e, 0x86, 0x77, 0x6b, 0x62, 0x57, 0x4c, 0x40, 0x60, 0x56, 0x4e, 0x48, 0x42, 0x3a,
  0x30, 0x65, 0x5a, 0x51, 0x4a, 0x43, 0x3b, 0x30, 0x30, 0x2c, 0x28, 0x25, 0x23, 0x20, 0x1b, 0x5e,
  0x53, 0x4b, 0x45, 0x40, 0x39, 0x2f, 0x5f, 0x59, 0x51, 0x4b, 0x45, 0x3e, 0x33, 0x79, 0x6e, 0x65,
  0x5d, 0x54, 0x4a, 0x3f, 0x7b, 0x72, 0x69, 0x61, 0x58, 0x50, 0x42, 0x9d, 0x8c, 0x7f, 0x74, 0x68,
  0x5d, 0x4c, 0xf1, 0xf1, 0xf1, 0xf0, 0xef, 0xef, 0xee, 0xeb, 0xea, 0xea, 0xe8, 0xe8, 0xe7, 0xe6,
  0xeb, 0xec, 0xea, 0xe8, 0xe7, 0xe7, 0xe7, 0xe6, 0xe5, 0xe2, 0xe2, 0xe1, 0xe0, 0xe1, 0xed, 0xed,
  0xe9, 0xec, 0xe9, 0xe7, 0xe5, 0xe4, 0xe1, 0xe0, 0xde, 0xdd, 0xdb, 0xda, 0xee, 0xe7, 0xe0, 0xea,
  0xe5, 0xe0, 0xdd, 0xe6, 0xdd, 0xdf, 0xe2, 0xdc, 0xd8, 0xd5, 0xef, 0xeb, 0xe5, 0xed, 0xe9, 0xe7,
  0xe5, 0xea, 0xe3, 0xe4, 0xe6, 0xe2, 0xe0, 0xdf, 0xef, 0xed, 0xe8, 0xef, 0xec, 0xea, 0xe9, 0xee,
  0xe9, 0xeb, 0xee, 0xeb, 0xe9, 0xe7
};

static const unsigned char palette_0E_21_A[] =
{
  0x7e, 0xb8, 0xd1, 0x5d, 0x32, 0x80, 0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7f, 0x7e, 0x7c, 0x7b,
  0x7b, 0x7c, 0x7d, 0x7f, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7e, 0x7d, 0x7b, 0x7b, 0x7b, 0x7c,
  0x7d, 0x7f, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7f, 0x7d, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7f,
  0x82, 0x80, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x88, 0x85, 0x84, 0x84, 0x83, 0x80, 0x80, 0x80, 0x7f,
  0x7f, 0x80, 0x7e, 0x7e, 0x80, 0x85, 0x82, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x7d, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x90, 0x8e, 0x89, 0x87, 0x85, 0x84,
  0x82, 0x99, 0x96, 0x93, 0x90, 0x8e, 0x8a, 0x88, 0x8c, 0x8a, 0x88, 0x85, 0x84, 0x83, 0x82, 0x92,
  0x8f, 0x8e, 0x8c, 0x8b, 0x88, 0x87, 0x87, 0x87, 0x85, 0x84, 0x82, 0x82, 0x81, 0x88, 0x88, 0x88,
  0x88, 0x88, 0x86, 0x85, 0xa4, 0x9f, 0x9a, 0x97, 0x95, 0x8e, 0x8b, 0xab, 0xa7, 0xa4, 0xa1, 0x9b,
  0x95, 0x8f, 0x9c, 0x98, 0x97, 0x95, 0x92, 0x8d, 0x8a, 0xa0, 0x9d, 0x9c, 0x99, 0x96, 0x91, 0x8d,
  0x93, 0x93, 0x8f, 0x90, 0x8e, 0x8a, 0x88, 0x92, 0x91, 0x92, 0x92, 0x91, 0x8e, 0x8a, 0xb6, 0xb0,
  0xa5, 0x9a, 0x90, 0x8b, 0x86, 0xb5, 0xaa, 0xa0, 0x94, 0x8d, 0x88, 0x84, 0xae, 0xa9, 0xa1, 0x98,
  0x8f, 0x8a, 0x86, 0xaa, 0xa1, 0x99, 0x8f, 0x8b, 0x86, 0x83, 0xa1, 0xa1, 0x9a, 0x94, 0x8c, 0x88,
  0x84, 0x97, 0x94, 0x90, 0x8b, 0x88, 0x85, 0x83, 0xb5, 0xb0, 0xaa, 0xa5, 0xa0, 0x9a, 0x95, 0xb6,
  0xb3, 0xaa, 0xa4, 0x9f, 0x9d, 0x98, 0xad, 0xa8, 0xa5, 0x9f, 0x9d, 0x98, 0x93, 0xab, 0xa8, 0xa2,
  0x9c, 0x99, 0x98, 0x95, 0xa2, 0xa1, 0x9c, 0x9b, 0x97, 0x94, 0x91, 0x99, 0x9a, 0x96, 0x95, 0x94,
  0x96, 0x93, 0xb7, 0xb3, 0xaa, 0xa5, 0xa0, 0x9b, 0x92, 0xb6, 0xb4, 0xae, 0xa6, 0x9f, 0x99, 0x90,
  0xaf, 0xab, 0xa5, 0xa1, 0x9e, 0x9a, 0x91, 0xab, 0xa9, 0xa5, 0x9e, 0x9b, 0x94, 0x8e, 0xa2, 0xa3,
  0x9b, 0x9b, 0x98, 0x95, 0x8f, 0x98, 0x9a, 0x99, 0x96, 0x95, 0x92, 0x8c, 0xb6, 0xb2, 0xac, 0xa5,
  0x9d, 0x98, 0x90, 0xb6, 0xb2, 0xa8, 0xa2, 0x9b, 0x92, 0x8a, 0xae, 0xab, 0xa7, 0xa1, 0x9c, 0x97,
  0x8f, 0xaa, 0xa7, 0xa1, 0x9b, 0x96, 0x8f, 0x89, 0xa2, 0xa2, 0x9d, 0x9b, 0x95, 0x92, 0x8d, 0x98,
  0x99, 0x95, 0x94, 0x91, 0x8d, 0x87, 0xb0, 0xaf, 0xa8, 0xa5, 0x9e, 0x94, 0x89, 0xb1, 0xad, 0xa5,
  0xa1, 0x99, 0x8f, 0x87, 0xab, 0xa9, 0xa5, 0xa1, 0x9c, 0x93, 0x89, 0xa8, 0xa4, 0x9f, 0x9a, 0x96,
  0x8c, 0x86, 0x9e, 0xa1, 0x9d, 0x9d, 0x97, 0x90, 0x87, 0x96, 0x96, 0x94, 0x94, 0x91, 0x8b, 0x84,
  0xb2, 0xae, 0xa8, 0xa5, 0x9c, 0x93, 0x8c, 0xb5, 0xb2, 0xad, 0xa7, 0xa3, 0x9b, 0x91, 0xac, 0xa9,
  0xa6, 0xa1, 0x9b, 0x93, 0x8b, 0xab, 0xa8, 0xa7, 0xa1, 0x9e, 0x98, 0x90, 0xa1, 0xa1, 0x9c, 0x9c,
  0x95, 0x90, 0x8a, 0x99, 0x9a, 0x9a, 0x98, 0x98, 0x95, 0x8d, 0xbb, 0xb9, 0xb3, 0xad, 0xa5, 0x9e,
  0x94, 0xbe, 0xbc, 0xb6, 0xb2, 0xac, 0xa6, 0x9d, 0xb4, 0xb3, 0xb0, 0xaa, 0xa4, 0x9c, 0x92, 0xb4,
  0xb2, 0xae, 0xab, 0xa8, 0xa2, 0x9b, 0xa8, 0xab, 0xa7, 0xa5, 0x9e, 0x99, 0x90, 0xa0, 0xa3, 0xa2,
  0xa2, 0xa1, 0x9f, 0x98, 0xc2, 0xc0, 0xbb, 0xb9, 0xb4, 0xac, 0xa5, 0xc5, 0xc3, 0xc2, 0xc0, 0xba,
  0xb2, 0xa6, 0xbb, 0xb9, 0xb7, 0xb4, 0xb1, 0xaa, 0xa3, 0xba, 0xb9, 0xba, 0xb7, 0xb4, 0xac, 0xa4,
  0xae, 0xb1, 0xad, 0xaf, 0xab, 0xa6, 0xa0, 0xa5, 0xa8, 0xab, 0xac, 0xad, 0xa9, 0xa0, 0xc7, 0xc5,
  0xbf, 0xb4, 0xa5, 0x9b, 0x8f, 0xc7, 0xc2, 0xba, 0xab, 0xa1, 0x96, 0x8a, 0xc1, 0xbf, 0xbb, 0xb1,
  0xa4, 0x99, 0x8e, 0xbc, 0xb8, 0xb2, 0xa4, 0x9c, 0x93, 0x8a, 0xb3, 0xb6, 0xb1, 0xac, 0x9e, 0x96,
  0x8e, 0xa7, 0xa7, 0xa5, 0x9d, 0x97, 0x91, 0x88, 0xc7, 0xc5, 0xc2, 0xbf, 0xba, 0xb3, 0xa9, 0xc7,
  0xc5, 0xc0, 0xbd, 0xb9, 0xb4, 0xac, 0xc1, 0xbe, 0xbd, 0xbb, 0xb8, 0xb1, 0xa7, 0xbd, 0xbc, 0xb9,
  0xb5, 0xb2, 0xae, 0xa8, 0xb4, 0xb6, 0xb3, 0xb4, 0xb1, 0xac, 0xa4, 0xa8, 0xab, 0xaa, 0xaa, 0xac,
  0xac, 0xa6, 0xc8, 0xc6, 0xc0, 0xbb, 0xb6, 0xb1, 0xa3, 0xc9, 0xc8, 0xc4, 0xbc, 0xb6, 0xab, 0x9c,
  0xc1, 0xbf, 0xbc, 0xb7, 0xb4, 0xaf, 0xa1, 0xbe, 0xbd, 0xbb, 0xb3, 0xaf, 0xa5, 0x99, 0xb3, 0xb6,
  0xb0, 0xb1, 0xad, 0xa9, 0x9d, 0xa7, 0xaa, 0xab, 0xa9, 0xa7, 0xa2, 0x97, 0xca, 0xc8, 0xc3, 0xbb,
  0xb3, 0xaa, 0x9b, 0xcb, 0xc8, 0xc0, 0xb9, 0xad, 0x9f, 0x92, 0xc2, 0xc0, 0xbe, 0xb7, 0xb1, 0xa8,
  0x99, 0xbf, 0xbd, 0xb8, 0xb1, 0xa8, 0x9c, 0x91, 0xb4, 0xb8, 0xb3, 0xb0, 0xa9, 0xa4, 0x97, 0xa7,
  0xaa, 0xa8, 0xa6, 0xa1, 0x98, 0x8d, 0xd0, 0xcf, 0xc8, 0xc1, 0xb5, 0xa2, 0x8f, 0xce, 0xcd, 0xc2,
  0xba, 0xae, 0x99, 0x8b, 0xc8, 0xc8, 0xc3, 0xbd, 0xb4, 0xa1, 0x8e, 0xc3, 0xc1, 0xbb, 0xb2, 0xa9,
  0x95, 0x88, 0xb9, 0xbe, 0xb7, 0xb8, 0xae, 0x9e, 0x8d, 0xaa, 0xad, 0xaa, 0xa7, 0xa2, 0x94, 0x88,
  0xcb, 0xc9, 0xc0, 0xb7, 0xad, 0x9d, 0x8e, 0xc6, 0xc6, 0xc1, 0xb9, 0xaf, 0xa6, 0x97, 0xc4, 0xc3,
  0xbd, 0xb5, 0xad, 0x9b, 0x8e, 0xbc, 0xbc, 0xb9, 0xb2, 0xa8, 0xa0, 0x95, 0xb6, 0xba, 0xb1, 0xae,
  0xa5, 0x97, 0x8b, 0xa6, 0xaa, 0xaa, 0xa8, 0xa3, 0x9f, 0x93, 0xbf, 0xbf, 0xb9, 0xaf, 0xa7, 0x9d,
  0x93, 0xb8, 0xb3, 0xa8, 0xa5, 0xa1, 0x9e, 0x93, 0xbb, 0xb9, 0xb5, 0xad, 0xa6, 0x9d, 0x92, 0xb0,
  0xad, 0xa5, 0xa2, 0x9f, 0x9b, 0x92, 0xae, 0xb1, 0xad, 0xa9, 0xa2, 0x9a, 0x90, 0x9f, 0xa0, 0x9b,
  0x9b, 0x9b, 0x99, 0x90, 0xb0, 0xae, 0xa4, 0xa1, 0x9e, 0xa0, 0x9b, 0xa6, 0xa2, 0x9c, 0x9a, 0x99,
  0x97, 0x94, 0xac, 0xaa, 0xa3, 0xa0, 0x9d, 0xa0, 0x9a, 0xa1, 0x9d, 0x99, 0x97, 0x96, 0x95, 0x92,
  0xa4, 0xa4, 0x9d, 0x9c, 0x99, 0x9c, 0x98, 0x94, 0x94, 0x93, 0x93, 0x93, 0x94, 0x91, 0xa3, 0xa0,
  0x98, 0x92, 0x8b, 0x88, 0x84, 0xa3, 0x9b, 0x95, 0x8e, 0x8a, 0x86, 0x83, 0x9f, 0x9d, 0x98, 0x92,
  0x8b, 0x88, 0x84, 0x9f, 0x98, 0x94, 0x8d, 0x89, 0x86, 0x83, 0x9b, 0x99, 0x94, 0x90, 0x8a, 0x87,
  0x84, 0x92, 0x90, 0x8e, 0x8a, 0x87, 0x85, 0x82, 0x99, 0x98, 0x96, 0x93, 0x8f, 0x8b, 0x86, 0x8a,
  0x87, 0x87, 0x86, 0x85, 0x80, 0x80, 0x96, 0x95, 0x95, 0x93, 0x90, 0x8b, 0x88, 0x88, 0x85, 0x86,
  0x86, 0x85, 0x7f, 0x80, 0x92, 0x92, 0x91, 0x90, 0x8d, 0x89, 0x86, 0x85, 0x83, 0x84, 0x84, 0x84,
  0x80, 0x80, 0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d, 0x80, 0x73, 0x70, 0x6e, 0x70, 0x74, 0x77, 0x7c,
  0x7f, 0x7d, 0x80, 0x7f, 0x7e, 0x7e, 0x80, 0x73, 0x70, 0x70, 0x72, 0x75, 0x79, 0x7c, 0x7f, 0x7e,
  0x80, 0x7f, 0x7e, 0x7e, 0x80, 0x76, 0x73, 0x72, 0x73, 0x76, 0x79, 0x7d, 0x6b, 0x69, 0x6a, 0x6d,
  0x72, 0x75, 0x78, 0x63, 0x61, 0x67, 0x6b, 0x6e, 0x76, 0x7c, 0x6c, 0x6b, 0x6b, 0x6f, 0x74, 0x75,
  0x78, 0x66, 0x64, 0x69, 0x6e, 0x6f, 0x77, 0x7c, 0x6f, 0x6c, 0x6d, 0x70, 0x75, 0x76, 0x79, 0x6e,
  0x6b, 0x6e, 0x71, 0x72, 0x78, 0x7d, 0x5c, 0x5b, 0x62, 0x66, 0x6b, 0x74, 0x7b, 0x5b, 0x5d, 0x64,
  0x69, 0x6f, 0x78, 0x7d, 0x5e, 0x5d, 0x63, 0x67, 0x6c, 0x75, 0x7c, 0x5e, 0x61, 0x67, 0x6c, 0x71,
  0x79, 0x7e, 0x62, 0x60, 0x66, 0x69, 0x6e, 0x75, 0x7c, 0x67, 0x67, 0x6c, 0x6e, 0x72, 0x79, 0x7d,
  0x59, 0x5b, 0x61, 0x66, 0x6e, 0x75, 0x7a, 0x56, 0x57, 0x5c, 0x62, 0x68, 0x6e, 0x76, 0x5b, 0x5d,
  0x61, 0x67, 0x6e, 0x75, 0x7a, 0x59, 0x5b, 0x5f, 0x65, 0x6a, 0x6f, 0x76, 0x60, 0x60, 0x65, 0x69,
  0x70, 0x75, 0x7a, 0x65, 0x64, 0x66, 0x69, 0x6c, 0x70, 0x77, 0x51, 0x53, 0x58, 0x60, 0x66, 0x6d,
  0x75, 0x4b, 0x4f, 0x56, 0x5b, 0x61, 0x66, 0x6f, 0x54, 0x56, 0x5a, 0x62, 0x67, 0x6e, 0x75, 0x50,
  0x54, 0x5b, 0x5f, 0x64, 0x69, 0x70, 0x5b, 0x5a, 0x5e, 0x64, 0x69, 0x6f, 0x75, 0x61, 0x5f, 0x62,
  0x64, 0x66, 0x69, 0x70, 0x44, 0x48, 0x51, 0x55, 0x5b, 0x62, 0x68, 0x3d, 0x42, 0x47, 0x4e, 0x55,
  0x5e, 0x67, 0x49, 0x4c, 0x52, 0x57, 0x5c, 0x63, 0x68, 0x44, 0x48, 0x4d, 0x52, 0x58, 0x61, 0x68,
  0x53, 0x52, 0x59, 0x5b, 0x60, 0x66, 0x6a, 0x5a, 0x57, 0x58, 0x59, 0x5d, 0x62, 0x6a, 0x37, 0x3d,
  0x4b, 0x59, 0x67, 0x6f, 0x77, 0x38, 0x47, 0x53, 0x63, 0x6c, 0x73, 0x7a, 0x3b, 0x42, 0x4e, 0x5b,
  0x68, 0x70, 0x78, 0x3e, 0x4d, 0x57, 0x66, 0x6e, 0x75, 0x7b, 0x47, 0x48, 0x55, 0x5e, 0x6b, 0x71,
  0x79, 0x54, 0x59, 0x60, 0x6b, 0x70, 0x75, 0x7b, 0x35, 0x3e, 0x46, 0x4c, 0x52, 0x5a, 0x64, 0x35,
  0x3b, 0x49, 0x4e, 0x54, 0x59, 0x60, 0x3a, 0x43, 0x48, 0x4e, 0x53, 0x5b, 0x63, 0x3d, 0x42, 0x4e,
  0x53, 0x57, 0x5b, 0x62, 0x45, 0x49, 0x4f, 0x52, 0x57, 0x5e, 0x66, 0x53, 0x52, 0x59, 0x5a, 0x5c,
  0x5e, 0x63, 0x34, 0x3a, 0x48, 0x4f, 0x55, 0x5c, 0x68, 0x35, 0x37, 0x40, 0x4e, 0x58, 0x63, 0x6e,
  0x39, 0x40, 0x4c, 0x52, 0x57, 0x5e, 0x69, 0x3c, 0x3f, 0x48, 0x54, 0x5c, 0x65, 0x6f, 0x45, 0x45,
  0x53, 0x55, 0x5b, 0x61, 0x6a, 0x52, 0x4f, 0x53, 0x5c, 0x60, 0x67, 0x70, 0x35, 0x3c, 0x45, 0x51,
  0x5b, 0x62, 0x6e, 0x35, 0x3d, 0x4b, 0x55, 0x5f, 0x6b, 0x75, 0x3a, 0x41, 0x47, 0x53, 0x5b, 0x62,
  0x6e, 0x3e, 0x44, 0x50, 0x5a, 0x62, 0x6d, 0x75, 0x46, 0x47, 0x50, 0x58, 0x60, 0x66, 0x70, 0x53,
  0x53, 0x5b, 0x60, 0x66, 0x6f, 0x76, 0x35, 0x38, 0x45, 0x4b, 0x55, 0x65, 0x75, 0x34, 0x3c, 0x4a,
  0x51, 0x5b, 0x6d, 0x78, 0x3b, 0x3e, 0x49, 0x4e, 0x56, 0x66, 0x75, 0x3e, 0x45, 0x50, 0x58, 0x60,
  0x70, 0x7a, 0x47, 0x45, 0x51, 0x53, 0x5c, 0x69, 0x77, 0x53, 0x54, 0x5c, 0x5f, 0x64, 0x71, 0x7a,
  0x34, 0x3b, 0x49, 0x51, 0x5b, 0x69, 0x74, 0x36, 0x3b, 0x45, 0x4e, 0x56, 0x5f, 0x6b, 0x3a, 0x41,
  0x4d, 0x54, 0x5d, 0x69, 0x74, 0x3d, 0x44, 0x4c, 0x55, 0x5b, 0x63, 0x6d, 0x46, 0x47, 0x55, 0x58,
  0x61, 0x6d, 0x75, 0x51, 0x52, 0x58, 0x5c, 0x60, 0x65, 0x70, 0x37, 0x37, 0x3f, 0x4b, 0x54, 0x61,
  0x6d, 0x37, 0x3b, 0x48, 0x4e, 0x54, 0x5b, 0x68, 0x3d, 0x3d, 0x43, 0x4e, 0x55, 0x60, 0x6d, 0x40,
  0x43, 0x4f, 0x54, 0x58, 0x5f, 0x6a, 0x48, 0x44, 0x4b, 0x52, 0x5b, 0x64, 0x6e, 0x54, 0x52, 0x59,
  0x5b, 0x5c, 0x60, 0x6a, 0x38, 0x3a, 0x47, 0x4d, 0x52, 0x56, 0x5f, 0x39, 0x3e, 0x47, 0x4c, 0x52,
  0x59, 0x63, 0x3d, 0x40, 0x4a, 0x50, 0x54, 0x58, 0x61, 0x41, 0x47, 0x4e, 0x53, 0x57, 0x5e, 0x66,
  0x49, 0x46, 0x53, 0x55, 0x5a, 0x5c, 0x63, 0x53, 0x54, 0x59, 0x5b, 0x5d, 0x60, 0x67, 0x3c, 0x41,
  0x4b, 0x57, 0x64, 0x6d, 0x76, 0x3d, 0x48, 0x52, 0x60, 0x68, 0x71, 0x7a, 0x41, 0x47, 0x4f, 0x5a,
  0x65, 0x6e, 0x77, 0x45, 0x51, 0x59, 0x65, 0x6b, 0x73, 0x7b, 0x4c, 0x4d, 0x57, 0x5e, 0x69, 0x70,
  0x77, 0x57, 0x5d, 0x62, 0x6a, 0x6e, 0x74, 0x7a, 0x42, 0x48, 0x4c, 0x50, 0x55, 0x5f, 0x67, 0x4f,
  0x54, 0x58, 0x5b, 0x5e, 0x67, 0x6b, 0x47, 0x4d, 0x4f, 0x53, 0x57, 0x60, 0x68, 0x56, 0x5b, 0x5e,
  0x60, 0x62, 0x6a, 0x6c, 0x52, 0x54, 0x57, 0x58, 0x5d, 0x63, 0x6a, 0x63, 0x64, 0x66, 0x67, 0x66,
  0x6b, 0x6d, 0x5a, 0x5d, 0x60, 0x64, 0x67, 0x6b, 0x6f, 0x66, 0x69, 0x6d, 0x6f, 0x71, 0x73, 0x77,
  0x5e, 0x61, 0x62, 0x65, 0x68, 0x6c, 0x70, 0x6a, 0x6d, 0x6f, 0x71, 0x72, 0x74, 0x78, 0x65, 0x65,
  0x68, 0x69, 0x6c, 0x6e, 0x72, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x78, 0x6d, 0x70, 0x71, 0x73,
  0x73, 0x76, 0x7b, 0x75, 0x76, 0x76, 0x75, 0x79, 0x7a, 0x7c, 0x6f, 0x71, 0x72, 0x73, 0x73, 0x76,
  0x7b, 0x76, 0x77, 0x77, 0x77, 0x79, 0x7b, 0x7c, 0x72, 0x73, 0x74, 0x75, 0x75, 0x77, 0x7b, 0x78,
  0x79, 0x78, 0x78, 0x7a, 0x7b, 0x7c, 0x90, 0x95, 0x98, 0x9b, 0x9e, 0xa2, 0xa3, 0x8d, 0x91, 0x94,
  0x98, 0x9a, 0x9e, 0x9f, 0x8b, 0x8f, 0x92, 0x95, 0x97, 0x9a, 0x9b, 0x8b, 0x8e, 0x91, 0x93, 0x96,
  0x99, 0x98, 0x8e, 0x90, 0x93, 0x94, 0x95, 0x95, 0x95, 0x89, 0x8c, 0x8f, 0x91, 0x92, 0x92, 0x92,
  0x93, 0x99, 0x9f, 0xa4, 0xaa, 0xaf, 0xb2, 0x90, 0x96, 0x9c, 0xa1, 0xa7, 0xab, 0xae, 0x8f, 0x94,
  0x9a, 0xa0, 0xa4, 0xa8, 0xab, 0x8e, 0x94, 0x99, 0x9e, 0xa2, 0xa5, 0xa8, 0x8b, 0x8f, 0x92, 0x97,
  0x9b, 0x9f, 0xa2, 0x8a, 0x8c, 0x8f, 0x93, 0x97, 0x9a, 0x9d, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81,
  0x82, 0x82, 0x83, 0x83, 0x85, 0x82, 0x82, 0x88, 0x86, 0x88, 0x8a, 0x8d, 0x8c, 0x82, 0x88, 0x88,
  0x85, 0x86, 0x8b, 0x8d, 0x7f, 0x79, 0x7a, 0x79, 0x77, 0x73, 0x74, 0x7e, 0x78, 0x78, 0x7a, 0x79,
  0x75, 0x74, 0x7e, 0x7d, 0x7d, 0x83, 0x83, 0x83, 0x84, 0x80, 0x83, 0x85, 0x85, 0x86, 0x86, 0x87,
  0x85, 0x88, 0x8b, 0x8e, 0x8e, 0x8d, 0x8e, 0x8f, 0x97, 0x9b, 0x88, 0x8e, 0x91, 0x88, 0x7b, 0x77,
  0x73, 0x73, 0x6f, 0x6d, 0x6c, 0x79, 0x72, 0x69, 0x76, 0x70, 0x66, 0x71, 0x81, 0x80, 0x80, 0x80,
  0x80, 0x7f, 0x7f, 0xa6, 0xa1, 0x9d, 0x9a, 0x97, 0x94, 0x8f, 0xb7, 0xb2, 0xad, 0xa9, 0xa6, 0xa1,
  0x9a, 0xbc, 0xb6, 0xb1, 0xad, 0xaa, 0xa5, 0x9e, 0x9a, 0x98, 0x97, 0x95, 0x93, 0x90, 0x8e, 0x6b,
  0x70, 0x72, 0x72, 0x73, 0x75, 0x77, 0x44, 0x49, 0x4e, 0x52, 0x56, 0x5b, 0x63, 0x46, 0x4c, 0x51,
  0x55, 0x5a, 0x5f, 0x65, 0x4f, 0x54, 0x58, 0x5c, 0x5f, 0x63, 0x69, 0x74, 0x75, 0x75, 0x76, 0x77,
  0x78, 0x79, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80,
  0x83, 0x83, 0x85, 0x86, 0x86, 0x86, 0x86, 0x83, 0x82, 0x84, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84,
  0x87, 0x85, 0x86, 0x87, 0x89, 0x89, 0x8b, 0x8c, 0x8e, 0x8f, 0x90, 0x90, 0x83, 0x87, 0x8d, 0x82,
  0x86, 0x8a, 0x8c, 0x80, 0x88, 0x83, 0x7e, 0x82, 0x85, 0x88, 0x80, 0x7e, 0x7b, 0x7d, 0x7b, 0x7a,
  0x7a, 0x7a, 0x77, 0x76, 0x76, 0x74, 0x73, 0x73, 0x7e, 0x7b, 0x77, 0x7e, 0x7b, 0x78, 0x77, 0x7d,
  0x77, 0x7a, 0x7c, 0x79, 0x77, 0x75
};

static const unsigned char palette_0E_21_B[] =
{
  0xe7, 0xda, 0x75, 0x4a, 0xa4, 0x7f, 0xd1, 0xcf, 0xc8, 0xc7, 0xbe, 0xa8, 0x92, 0xd1, 0xcd, 0xc3,
  0xbe, 0xb4, 0x9d, 0x8d, 0xc7, 0xc6, 0xc3, 0xc1, 0xbc, 0xa8, 0x91, 0xc2, 0xbd, 0xb8, 0xb3, 0xac,
  0x98, 0x8a, 0xb4, 0xbb, 0xb4, 0xb8, 0xb1, 0xa1, 0x8e, 0xa4, 0xa8, 0xa6, 0xa8, 0xa4, 0x96, 0x89,
  0xd1, 0xcd, 0xc6, 0xc0, 0xb5, 0xa4, 0x93, 0xd2, 0xce, 0xcb, 0xc5, 0xbb, 0xb2, 0x9d, 0xc7, 0xc3,
  0xc1, 0xba, 0xb2, 0xa3, 0x92, 0xc2, 0xbf, 0xbf, 0xb9, 0xb3, 0xac, 0x9b, 0xb7, 0xb9, 0xb2, 0xb3,
  0xa9, 0x9e, 0x8f, 0xa8, 0xab, 0xac, 0xac, 0xac, 0xa7, 0x98, 0xd1, 0xd0, 0xcb, 0xc4, 0xb9, 0xad,
  0x9d, 0xd3, 0xd0, 0xc7, 0xc3, 0xbe, 0xb5, 0xa6, 0xc6, 0xc5, 0xc5, 0xbd, 0xb7, 0xaa, 0x9b, 0xc2,
  0xc0, 0xbb, 0xb6, 0xb5, 0xae, 0xa2, 0xb4, 0xb9, 0xb6, 0xb5, 0xaf, 0xa5, 0x99, 0xa7, 0xaa, 0xa9,
  0xab, 0xad, 0xab, 0xa0, 0xd7, 0xd2, 0xca, 0xc6, 0xc1, 0xbd, 0xb3, 0xda, 0xd5, 0xd1, 0xcc, 0xc5,
  0xbc, 0xb0, 0xc9, 0xc7, 0xc4, 0xc0, 0xbd, 0xba, 0xb0, 0xc8, 0xc4, 0xc3, 0xbf, 0xbd, 0xb5, 0xad,
  0xb8, 0xbd, 0xb5, 0xb8, 0xb4, 0xb3, 0xac, 0xab, 0xad, 0xaf, 0xb1, 0xb3, 0xb1, 0xa7, 0xde, 0xdb,
  0xce, 0xbd, 0xaa, 0x9f, 0x91, 0xde, 0xd4, 0xc6, 0xb0, 0xa3, 0x97, 0x8d, 0xd5, 0xd0, 0xc8, 0xb9,
  0xa6, 0x9c, 0x90, 0xce, 0xc4, 0xbb, 0xa8, 0x9f, 0x95, 0x8c, 0xbe, 0xc2, 0xba, 0xb2, 0xa1, 0x9a,
  0x8e, 0xab, 0xac, 0xa9, 0xa0, 0x9a, 0x93, 0x8a, 0xdb, 0xd7, 0xd2, 0xcc, 0xc2, 0xb8, 0xab, 0xda,
  0xd6, 0xcc, 0xc5, 0xbc, 0xb4, 0xac, 0xcf, 0xcb, 0xca, 0xc3, 0xbe, 0xb5, 0xa9, 0xc7, 0xc5, 0xbf,
  0xb9, 0xb4, 0xaf, 0xa9, 0xbc, 0xc0, 0xbb, 0xbc, 0xb5, 0xaf, 0xa7, 0xaa, 0xae, 0xac, 0xac, 0xad,
  0xab, 0xa5, 0xd8, 0xd4, 0xca, 0xc3, 0xb9, 0xb0, 0xa2, 0xd6, 0xd2, 0xcb, 0xbe, 0xb3, 0xa7, 0x9a,
  0xcd, 0xc9, 0xc2, 0xbd, 0xb6, 0xae, 0xa1, 0xc5, 0xc3, 0xbe, 0xb3, 0xad, 0xa2, 0x97, 0xb9, 0xbd,
  0xb5, 0xb4, 0xad, 0xa8, 0x9d, 0xa7, 0xab, 0xac, 0xa9, 0xa5, 0x9f, 0x95, 0xd3, 0xce, 0xc6, 0xba,
  0xae, 0xa5, 0x98, 0xd1, 0xcd, 0xbe, 0xb5, 0xa7, 0x9a, 0x8f, 0xc8, 0xc4, 0xc0, 0xb5, 0xac, 0xa4,
  0x96, 0xc1, 0xbe, 0xb5, 0xab, 0xa1, 0x96, 0x8e, 0xb5, 0xb7, 0xb1, 0xac, 0xa4, 0x9d, 0x93, 0xa4,
  0xa8, 0xa4, 0xa2, 0x9b, 0x94, 0x8c, 0xc9, 0xc8, 0xbc, 0xb7, 0xab, 0x9b, 0x8c, 0xc8, 0xc4, 0xb7,
  0xb0, 0xa4, 0x94, 0x89, 0xc2, 0xc0, 0xb8, 0xb2, 0xa9, 0x99, 0x8c, 0xbc, 0xb8, 0xaf, 0xa8, 0x9f,
  0x90, 0x88, 0xb1, 0xb5, 0xae, 0xad, 0xa4, 0x97, 0x8a, 0xa3, 0xa5, 0xa2, 0xa0, 0x9a, 0x8f, 0x86,
  0xc3, 0xbf, 0xb5, 0xae, 0xa4, 0x97, 0x8b, 0xc1, 0xbd, 0xb8, 0xaf, 0xa6, 0x9e, 0x92, 0xbc, 0xba,
  0xb3, 0xaa, 0xa3, 0x96, 0x8b, 0xb5, 0xb3, 0xb1, 0xa9, 0xa0, 0x9b, 0x92, 0xae, 0xb0, 0xa8, 0xa5,
  0x9c, 0x93, 0x8a, 0x9f, 0xa1, 0xa0, 0x9e, 0x9b, 0x97, 0x8f, 0xc5, 0xc5, 0xbc, 0xb2, 0xa6, 0x9b,
  0x90, 0xc1, 0xbc, 0xb0, 0xa7, 0xa1, 0x9c, 0x91, 0xbe, 0xbd, 0xb8, 0xae, 0xa5, 0x99, 0x8f, 0xb6,
  0xb4, 0xa9, 0xa3, 0x9e, 0x98, 0x8f, 0xaf, 0xb4, 0xaf, 0xaa, 0x9f, 0x97, 0x8d, 0x9f, 0xa2, 0x9e,
  0x9c, 0x9a, 0x97, 0x8d, 0xbd, 0xb8, 0xae, 0xa8, 0xa1, 0x9f, 0x99, 0xb8, 0xaf, 0xa9, 0xa4, 0x9f,
  0x99, 0x92, 0xb6, 0xb2, 0xa9, 0xa4, 0x9e, 0x9e, 0x98, 0xaf, 0xa7, 0xa3, 0x9e, 0x9a, 0x96, 0x91,
  0xa9, 0xaa, 0xa1, 0x9f, 0x9a, 0x9b, 0x95, 0x9b, 0x99, 0x97, 0x97, 0x96, 0x94, 0x8f, 0xb0, 0xab,
  0xa2, 0x97, 0x8d, 0x89, 0x84, 0xaf, 0xa4, 0x9b, 0x90, 0x8a, 0x87, 0x83, 0xaa, 0xa5, 0x9e, 0x94,
  0x8c, 0x88, 0x84, 0xa6, 0x9e, 0x97, 0x8d, 0x89, 0x85, 0x82, 0x9f, 0x9f, 0x99, 0x92, 0x8a, 0x87,
  0x83, 0x96, 0x93, 0x8f, 0x8a, 0x87, 0x85, 0x82, 0xa7, 0xa4, 0xa1, 0x9d, 0x96, 0x8e, 0x89, 0x9b,
  0x97, 0x92, 0x90, 0x8d, 0x85, 0x84, 0xa2, 0x9e, 0x9d, 0x98, 0x94, 0x8e, 0x89, 0x95, 0x92, 0x8f,
  0x8c, 0x8a, 0x84, 0x83, 0x99, 0x99, 0x97, 0x94, 0x90, 0x8b, 0x86, 0x8b, 0x8a, 0x89, 0x88, 0x88,
  0x82, 0x82, 0x93, 0x8f, 0x8c, 0x89, 0x86, 0x83, 0x83, 0x87, 0x83, 0x80, 0x7e, 0x7d, 0x7e, 0x7f,
  0x8f, 0x8b, 0x8a, 0x87, 0x86, 0x82, 0x83, 0x83, 0x80, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x89, 0x88,
  0x85, 0x84, 0x82, 0x80, 0x81, 0x80, 0x80, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x80, 0x7e, 0x7b, 0x7a,
  0x7c, 0x7b, 0x7c, 0x7a, 0x77, 0x77, 0x78, 0x77, 0x7b, 0x7f, 0x80, 0x7c, 0x7b, 0x79, 0x7c, 0x7a,
  0x7b, 0x79, 0x76, 0x77, 0x78, 0x77, 0x7a, 0x7e, 0x7d, 0x7b, 0x7a, 0x7a, 0x7c, 0x7a, 0x7c, 0x79,
  0x78, 0x78, 0x78, 0x77, 0x7b, 0x7f, 0x77, 0x76, 0x73, 0x72, 0x74, 0x78, 0x7d, 0x75, 0x74, 0x72,
  0x73, 0x75, 0x7a, 0x7e, 0x75, 0x75, 0x72, 0x72, 0x73, 0x77, 0x7d, 0x74, 0x73, 0x72, 0x73, 0x75,
  0x7a, 0x7e, 0x75, 0x75, 0x72, 0x72, 0x74, 0x77, 0x7d, 0x76, 0x75, 0x74, 0x74, 0x76, 0x7a, 0x7e,
  0x71, 0x70, 0x6f, 0x6f, 0x73, 0x77, 0x7b, 0x6d, 0x6d, 0x6c, 0x6d, 0x6e, 0x72, 0x78, 0x71, 0x70,
  0x6f, 0x6f, 0x73, 0x77, 0x7b, 0x6d, 0x6d, 0x6d, 0x6e, 0x6f, 0x73, 0x78, 0x72, 0x71, 0x70, 0x70,
  0x74, 0x77, 0x7b, 0x73, 0x71, 0x71, 0x71, 0x71, 0x74, 0x79, 0x65, 0x67, 0x68, 0x6b, 0x6e, 0x72,
  0x77, 0x5d, 0x5f, 0x62, 0x65, 0x69, 0x6c, 0x72, 0x66, 0x68, 0x69, 0x6b, 0x6e, 0x71, 0x77, 0x60,
  0x63, 0x65, 0x68, 0x6b, 0x6d, 0x71, 0x6a, 0x69, 0x6b, 0x6d, 0x70, 0x72, 0x77, 0x6b, 0x6a, 0x6a,
  0x6b, 0x6c, 0x6e, 0x73, 0x54, 0x58, 0x5c, 0x5f, 0x62, 0x68, 0x6c, 0x4a, 0x50, 0x53, 0x58, 0x5d,
  0x64, 0x6b, 0x57, 0x5b, 0x5e, 0x61, 0x63, 0x69, 0x6d, 0x51, 0x56, 0x59, 0x5d, 0x60, 0x67, 0x6c,
  0x5e, 0x5f, 0x63, 0x63, 0x67, 0x6a, 0x6e, 0x62, 0x61, 0x62, 0x62, 0x64, 0x67, 0x6d, 0x46, 0x4b,
  0x56, 0x60, 0x6b, 0x72, 0x7a, 0x47, 0x51, 0x5b, 0x68, 0x6f, 0x76, 0x7c, 0x4a, 0x4f, 0x57, 0x61,
  0x6c, 0x72, 0x79, 0x4e, 0x57, 0x5e, 0x6a, 0x70, 0x76, 0x7c, 0x56, 0x54, 0x5d, 0x64, 0x6d, 0x73,
  0x79, 0x61, 0x62, 0x66, 0x6d, 0x71, 0x76, 0x7b, 0x44, 0x4b, 0x51, 0x55, 0x5a, 0x61, 0x69, 0x46,
  0x4b, 0x53, 0x58, 0x5c, 0x60, 0x67, 0x49, 0x4f, 0x53, 0x57, 0x5b, 0x62, 0x69, 0x4d, 0x51, 0x58,
  0x5c, 0x5f, 0x63, 0x68, 0x54, 0x55, 0x5a, 0x5b, 0x5f, 0x64, 0x6a, 0x60, 0x5f, 0x62, 0x63, 0x64,
  0x65, 0x6a, 0x47, 0x4b, 0x53, 0x58, 0x5e, 0x63, 0x6d, 0x49, 0x4b, 0x50, 0x59, 0x60, 0x68, 0x72,
  0x4c, 0x4f, 0x55, 0x5a, 0x5e, 0x64, 0x6e, 0x51, 0x52, 0x56, 0x5d, 0x63, 0x6a, 0x73, 0x55, 0x55,
  0x5c, 0x5e, 0x62, 0x67, 0x6f, 0x61, 0x5f, 0x60, 0x63, 0x67, 0x6c, 0x74, 0x4b, 0x4f, 0x54, 0x5b,
  0x61, 0x68, 0x72, 0x4c, 0x50, 0x57, 0x5e, 0x66, 0x6f, 0x77, 0x4f, 0x53, 0x56, 0x5d, 0x63, 0x69,
  0x72, 0x53, 0x57, 0x5c, 0x62, 0x69, 0x71, 0x78, 0x59, 0x58, 0x5d, 0x61, 0x67, 0x6b, 0x74, 0x63,
  0x63, 0x65, 0x68, 0x6d, 0x73, 0x79, 0x4c, 0x51, 0x5b, 0x60, 0x67, 0x71, 0x7b, 0x4e, 0x54, 0x5e,
  0x64, 0x6c, 0x77, 0x7d, 0x50, 0x54, 0x5d, 0x62, 0x68, 0x72, 0x7b, 0x53, 0x5a, 0x62, 0x68, 0x6f,
  0x78, 0x7e, 0x58, 0x59, 0x62, 0x64, 0x6b, 0x73, 0x7c, 0x61, 0x64, 0x69, 0x6c, 0x70, 0x78, 0x7d,
  0x50, 0x57, 0x61, 0x66, 0x6d, 0x75, 0x7b, 0x54, 0x5a, 0x5f, 0x65, 0x6c, 0x70, 0x77, 0x53, 0x5a,
  0x61, 0x67, 0x6d, 0x75, 0x7c, 0x59, 0x5e, 0x63, 0x68, 0x6e, 0x71, 0x77, 0x5a, 0x5e, 0x65, 0x69,
  0x6f, 0x76, 0x7c, 0x64, 0x67, 0x69, 0x6c, 0x70, 0x72, 0x77, 0x5a, 0x5b, 0x5f, 0x65, 0x6c, 0x73,
  0x79, 0x61, 0x65, 0x6b, 0x6d, 0x70, 0x73, 0x79, 0x5d, 0x5e, 0x61, 0x67, 0x6d, 0x73, 0x79, 0x65,
  0x69, 0x6e, 0x6f, 0x72, 0x75, 0x79, 0x63, 0x62, 0x64, 0x69, 0x6f, 0x74, 0x79, 0x6d, 0x6e, 0x70,
  0x71, 0x72, 0x74, 0x79, 0x6b, 0x6e, 0x71, 0x72, 0x74, 0x72, 0x75, 0x76, 0x7a, 0x79, 0x78, 0x78,
  0x78, 0x79, 0x6c, 0x6e, 0x71, 0x71, 0x74, 0x73, 0x75, 0x77, 0x7a, 0x79, 0x79, 0x79, 0x79, 0x79,
  0x6e, 0x6f, 0x72, 0x73, 0x74, 0x73, 0x75, 0x78, 0x7a, 0x79, 0x79, 0x78, 0x78, 0x79, 0x83, 0x80,
  0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x81, 0x7c, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x82, 0x7f, 0x7d, 0x7d,
  0x7d, 0x7e, 0x80, 0x81, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x7d, 0x7d, 0x7d, 0x7e,
  0x80, 0x7f, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x8b, 0x84, 0x82, 0x80, 0x80, 0x80, 0x80, 0x92,
  0x8e, 0x87, 0x85, 0x83, 0x85, 0x83, 0x8a, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8f, 0x8c, 0x86,
  0x84, 0x82, 0x84, 0x83, 0x88, 0x82, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x89, 0x88, 0x84, 0x83, 0x82,
  0x84, 0x83, 0x99, 0x94, 0x8c, 0x8a, 0x88, 0x86, 0x82, 0x9c, 0x9b, 0x96, 0x8f, 0x8b, 0x87, 0x84,
  0x97, 0x92, 0x8a, 0x88, 0x87, 0x86, 0x82, 0x99, 0x98, 0x92, 0x8c, 0x89, 0x86, 0x83, 0x92, 0x90,
  0x88, 0x87, 0x86, 0x84, 0x81, 0x8f, 0x91, 0x8e, 0x8a, 0x88, 0x85, 0x83, 0x9e, 0x9a, 0x95, 0x8f,
  0x8b, 0x88, 0x86, 0x9f, 0x9b, 0x93, 0x8f, 0x8b, 0x87, 0x83, 0x9b, 0x97, 0x94, 0x8e, 0x8b, 0x88,
  0x85, 0x9b, 0x98, 0x91, 0x8c, 0x8a, 0x85, 0x83, 0x96, 0x95, 0x90, 0x8c, 0x89, 0x87, 0x84, 0x91,
  0x91, 0x8c, 0x8a, 0x88, 0x85, 0x82, 0xa2, 0x9f, 0x98, 0x95, 0x91, 0x8a, 0x85, 0xa2, 0x9d, 0x96,
  0x93, 0x8e, 0x87, 0x83, 0x9f, 0x9d, 0x97, 0x94, 0x91, 0x8a, 0x84, 0x9e, 0x99, 0x93, 0x90, 0x8c,
  0x86, 0x82, 0x98, 0x99, 0x93, 0x92, 0x8e, 0x88, 0x83, 0x92, 0x91, 0x8e, 0x8c, 0x8a, 0x85, 0x82,
  0xa4, 0xa0, 0x99, 0x96, 0x90, 0x8b, 0x88, 0xa5, 0xa2, 0x9d, 0x99, 0x97, 0x91, 0x8a, 0xa1, 0x9d,
  0x97, 0x95, 0x90, 0x8a, 0x87, 0xa1, 0x9d, 0x99, 0x95, 0x93, 0x8e, 0x89, 0x9a, 0x99, 0x93, 0x92,
  0x8d, 0x89, 0x86, 0x96, 0x95, 0x93, 0x91, 0x91, 0x8d, 0x88, 0xa8, 0xa6, 0xa2, 0x9c, 0x98, 0x92,
  0x8c, 0xab, 0xa9, 0xa6, 0xa2, 0x9e, 0x9a, 0x94, 0xa3, 0xa3, 0xa0, 0x9b, 0x98, 0x92, 0x8d, 0xa5,
  0xa3, 0xa1, 0x9d, 0x9a, 0x96, 0x92, 0x9d, 0x9e, 0x9b, 0x98, 0x94, 0x90, 0x8a, 0x98, 0x9a, 0x99,
  0x98, 0x97, 0x95, 0x91, 0xb0, 0xae, 0xab, 0xa8, 0xa4, 0x9d, 0x98, 0xb5, 0xb4, 0xb4, 0xb1, 0xab,
  0xa3, 0x9b, 0xac, 0xaa, 0xa8, 0xa5, 0xa2, 0x9c, 0x97, 0xad, 0xad, 0xad, 0xa9, 0xa6, 0x9e, 0x98,
  0xa3, 0xa5, 0xa1, 0xa1, 0x9e, 0x99, 0x96, 0x9f, 0xa1, 0xa2, 0xa3, 0xa1, 0x9d, 0x97, 0xb8, 0xb7,
  0xb3, 0xaa, 0x9f, 0x96, 0x8d, 0xb8, 0xb5, 0xae, 0xa3, 0x9b, 0x92, 0x89, 0xb3, 0xb2, 0xaf, 0xa7,
  0x9e, 0x96, 0x8b, 0xb0, 0xad, 0xa8, 0x9e, 0x98, 0x8f, 0x88, 0xa9, 0xab, 0xa7, 0xa2, 0x99, 0x92,
  0x8a, 0x9f, 0xa0, 0x9e, 0x97, 0x93, 0x8e, 0x87, 0xbb, 0xba, 0xb7, 0xb4, 0xaf, 0xaa, 0xa2, 0xc1,
  0xc0, 0xba, 0xb5, 0xb0, 0xae, 0xa7, 0xb6, 0xb4, 0xb2, 0xb0, 0xad, 0xa8, 0xa1, 0xb8, 0xb6, 0xb1,
  0xad, 0xaa, 0xa8, 0xa3, 0xac, 0xad, 0xaa, 0xab, 0xa6, 0xa3, 0x9f, 0xa5, 0xa6, 0xa5, 0xa5, 0xa4,
  0xa6, 0xa1, 0xcc, 0xca, 0xbf, 0xb9, 0xb3, 0xac, 0x9f, 0xd2, 0xd1, 0xca, 0xbe, 0xb4, 0xa8, 0x9b,
  0xc5, 0xc2, 0xba, 0xb5, 0xb0, 0xaa, 0x9e, 0xc5, 0xc3, 0xbe, 0xb3, 0xab, 0xa2, 0x97, 0xb5, 0xb8,
  0xae, 0xad, 0xa9, 0xa4, 0x9a, 0xaa, 0xad, 0xac, 0xa8, 0xa5, 0x9f, 0x95, 0xd6, 0xd1, 0xc8, 0xbc,
  0xb0, 0xa7, 0x99, 0xd9, 0xd3, 0xc4, 0xb8, 0xac, 0x9d, 0x90, 0xcc, 0xc7, 0xc2, 0xb7, 0xae, 0xa5,
  0x98, 0xc9, 0xc4, 0xb8, 0xaf, 0xa6, 0x99, 0x8e, 0xba, 0xbc, 0xb4, 0xaf, 0xa6, 0xa1, 0x94, 0xac,
  0xad, 0xa8, 0xa4, 0xa0, 0x97, 0x8d, 0xa3, 0xad, 0xb5, 0xbb, 0xc0, 0xc4, 0xc7, 0x9e, 0xa7, 0xaf,
  0xb5, 0xb9, 0xbd, 0xbf, 0x9e, 0xa5, 0xab, 0xb0, 0xb4, 0xb8, 0xba, 0x99, 0xa0, 0xa6, 0xaa, 0xaf,
  0xb2, 0xb3, 0x9f, 0xa2, 0xa6, 0xa9, 0xac, 0xae, 0xb0, 0x94, 0x99, 0x9d, 0xa1, 0xa3, 0xa5, 0xa7,
  0x96, 0x9c, 0xa1, 0xa5, 0xa8, 0xaa, 0xac, 0x93, 0x98, 0x9e, 0xa1, 0xa4, 0xa7, 0xa8, 0x8e, 0x93,
  0x97, 0x9b, 0x9c, 0x9f, 0xa2, 0x8e, 0x92, 0x96, 0x99, 0x9c, 0x9e, 0x9e, 0x8c, 0x91, 0x94, 0x96,
  0x99, 0x9b, 0x9c, 0x8b, 0x8e, 0x91, 0x94, 0x96, 0x97, 0x98, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x89, 0x88, 0x89, 0x8a, 0x8f, 0x8e, 0x85,
  0x89, 0x8a, 0x8c, 0x8d, 0x91, 0x8c, 0x83, 0x86, 0x85, 0x84, 0x83, 0x88, 0x89, 0x80, 0x7c, 0x7c,
  0x7b, 0x7a, 0x76, 0x77, 0x80, 0x7d, 0x7d, 0x7e, 0x7f, 0x7d, 0x7b, 0x81, 0x85, 0x88, 0x84, 0x86,
  0x89, 0x87, 0x89, 0x8e, 0x93, 0x8e, 0x90, 0x90, 0x93, 0x8f, 0x8c, 0x8e, 0x8f, 0x8e, 0x8e, 0x8f,
  0x8a, 0x90, 0x93, 0x85, 0x8a, 0x8c, 0x87, 0x7b, 0x79, 0x7a, 0x76, 0x75, 0x77, 0x75, 0x7b, 0x76,
  0x70, 0x7d, 0x79, 0x73, 0x7c, 0x81, 0x83, 0x86, 0x88, 0x89, 0x8b, 0x8e, 0xc5, 0xbc, 0xb4, 0xae,
  0xa8, 0xa2, 0x9a, 0xbb, 0xb3, 0xad, 0xa8, 0xa3, 0x9d, 0x96, 0xa4, 0xa0, 0x9d, 0x9a, 0x98, 0x95,
  0x91, 0x79, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7e, 0x50, 0x54, 0x57, 0x5a, 0x5e, 0x63, 0x69, 0x58,
  0x5c, 0x5f, 0x62, 0x64, 0x67, 0x6c, 0x83, 0x82, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x96, 0x92, 0x8f,
  0x8e, 0x8b, 0x89, 0x86, 0xb0, 0xaa, 0xa7, 0xa2, 0x9f, 0x9b, 0x94, 0xc0, 0xb7, 0xb0, 0xa9, 0xa5,
  0xa0, 0x98, 0x84, 0x88, 0x8d, 0x85, 0x89, 0x8c, 0x8f, 0x84, 0x87, 0x8c, 0x85, 0x88, 0x8a, 0x8c,
  0x8b, 0x8f, 0x8d, 0x8c, 0x8e, 0x91, 0x93, 0x88, 0x8e, 0x8f, 0x8a, 0x8c, 0x8f, 0x91, 0x86, 0x86,
  0x8a, 0x82, 0x84, 0x86, 0x88, 0x83, 0x85, 0x82, 0x7f, 0x81, 0x83, 0x85, 0x80, 0x7f, 0x7d, 0x7f,
  0x7e, 0x7c, 0x7c, 0x7d, 0x7b, 0x7a, 0x7a, 0x79, 0x78, 0x77, 0x80, 0x7e, 0x7b, 0x80, 0x7f, 0x7e,
  0x7d, 0x81, 0x7f, 0x80, 0x83, 0x81, 0x80, 0x80, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 0x86, 0x88,
  0x8a, 0x8d, 0x8e, 0x8e, 0x8e, 0x8f
};

static const unsigned char palette_0E_22_L[] =
{
  0xe9, 0xb4, 0x8a, 0x8f, 0x9d, 0x4d, 0xe9, 0xec, 0xee, 0xee, 0xef, 0xf1, 0xf2, 0xe7, 0xec, 0xef,
  0xef, 0xf0, 0xf3, 0xf3, 0xcc, 0xcd, 0xdb, 0xdb, 0xe4, 0xe6, 0xe7, 0xbb, 0xbf, 0xc7, 0xc6, 0xcf,
  0xd1, 0xe1, 0x9a, 0xab, 0xab, 0xb9, 0xba, 0xc6, 0xd3, 0x7a, 0x84, 0x8c, 0x96, 0xaa, 0xbe, 0xcc,
  0xe1, 0xe6, 0xe8, 0xe9, 0xed, 0xee, 0xf0, 0xdb, 0xdf, 0xe2, 0xe5, 0xe6, 0xea, 0xef, 0xc5, 0xc8,
  0xd5, 0xd5, 0xe1, 0xe3, 0xe4, 0xb2, 0xb3, 0xbc, 0xbc, 0xc4, 0xc8, 0xdb, 0x97, 0xa8, 0xa7, 0xb6,
  0xb9, 0xc5, 0xd0, 0x79, 0x81, 0x88, 0x91, 0xa2, 0xb6, 0xc5, 0xd6, 0xd9, 0xdd, 0xe1, 0xe3, 0xe7,
  0xeb, 0xcf, 0xd1, 0xd5, 0xd8, 0xdc, 0xe0, 0xe4, 0xbc, 0xbe, 0xcb, 0xd0, 0xda, 0xdd, 0xe1, 0xa9,
  0xac, 0xb6, 0xb8, 0xc1, 0xc5, 0xd4, 0x90, 0xa1, 0xa3, 0xb5, 0xb6, 0xc2, 0xce, 0x71, 0x7c, 0x88,
  0x92, 0xa1, 0xb4, 0xc0, 0xc5, 0xc9, 0xce, 0xd2, 0xd5, 0xdb, 0xe0, 0xbc, 0xc1, 0xc6, 0xc9, 0xcf,
  0xd6, 0xdc, 0xac, 0xb1, 0xc0, 0xc2, 0xcc, 0xd2, 0xd6, 0x96, 0x9d, 0xa7, 0xab, 0xb6, 0xbb, 0xcb,
  0x87, 0x97, 0x9c, 0xaa, 0xac, 0xb8, 0xc3, 0x6a, 0x75, 0x7f, 0x89, 0x99, 0xac, 0xba, 0xb1, 0xb8,
  0xc5, 0xd0, 0xdc, 0xe2, 0xe9, 0xb3, 0xc0, 0xca, 0xd7, 0xdf, 0xe6, 0xed, 0x9d, 0xa4, 0xb8, 0xc2,
  0xd3, 0xd9, 0xe0, 0x93, 0xa0, 0xaf, 0xba, 0xc7, 0xcc, 0xdd, 0x7a, 0x8c, 0x96, 0xac, 0xb4, 0xc2,
  0xd0, 0x65, 0x75, 0x82, 0x94, 0xa8, 0xbd, 0xcb, 0xb2, 0xb9, 0xc0, 0xc5, 0xcb, 0xd1, 0xd7, 0xb2,
  0xb5, 0xc0, 0xc6, 0xcc, 0xcf, 0xd5, 0x9d, 0xa5, 0xb3, 0xb9, 0xc3, 0xc8, 0xcf, 0x92, 0x95, 0xa5,
  0xa9, 0xb4, 0xb6, 0xc6, 0x7c, 0x8d, 0x92, 0xa3, 0xa7, 0xb2, 0xbf, 0x67, 0x6f, 0x7d, 0x88, 0x99,
  0xa9, 0xb5, 0xb4, 0xb9, 0xc2, 0xc6, 0xcb, 0xd0, 0xd9, 0xb4, 0xb6, 0xbc, 0xc5, 0xcc, 0xd3, 0xde,
  0xa0, 0xa6, 0xb6, 0xba, 0xc4, 0xc8, 0xd2, 0x96, 0x9a, 0xa5, 0xac, 0xb7, 0xbe, 0xd0, 0x80, 0x8f,
  0x97, 0xa5, 0xa9, 0xb3, 0xc3, 0x69, 0x72, 0x7d, 0x8b, 0x9c, 0xb0, 0xbf, 0xb4, 0xb9, 0xbf, 0xc6,
  0xce, 0xd3, 0xde, 0xb4, 0xb9, 0xc3, 0xc9, 0xd1, 0xdb, 0xe5, 0xa0, 0xa5, 0xb3, 0xba, 0xc5, 0xcc,
  0xd5, 0x95, 0x9a, 0xa8, 0xae, 0xba, 0xc3, 0xd5, 0x7f, 0x8f, 0x94, 0xa5, 0xab, 0xb7, 0xc6, 0x69,
  0x75, 0x81, 0x8e, 0xa0, 0xb7, 0xc5, 0xb6, 0xb8, 0xc2, 0xc7, 0xcd, 0xd8, 0xe6, 0xb5, 0xbc, 0xc6,
  0xcc, 0xd3, 0xdf, 0xea, 0xa5, 0xa6, 0xb7, 0xba, 0xc6, 0xd0, 0xde, 0x9a, 0xa0, 0xae, 0xb2, 0xbd,
  0xc8, 0xdc, 0x84, 0x91, 0x98, 0xa6, 0xac, 0xbb, 0xcd, 0x6a, 0x76, 0x82, 0x8e, 0xa2, 0xb9, 0xc9,
  0xb1, 0xb8, 0xbf, 0xc4, 0xcf, 0xd8, 0xe1, 0xac, 0xb2, 0xb9, 0xc0, 0xc5, 0xce, 0xdb, 0xa0, 0xa6,
  0xb5, 0xb9, 0xc8, 0xd0, 0xd8, 0x93, 0x97, 0xa3, 0xa8, 0xb2, 0xb9, 0xce, 0x81, 0x91, 0x97, 0xa5,
  0xae, 0xbd, 0xca, 0x68, 0x71, 0x7d, 0x88, 0x9a, 0xac, 0xbe, 0xa7, 0xaa, 0xb1, 0xba, 0xc2, 0xcb,
  0xd7, 0x9f, 0xa4, 0xac, 0xb1, 0xb7, 0xbf, 0xcb, 0x96, 0x9a, 0xa7, 0xb0, 0xbb, 0xc4, 0xd0, 0x88,
  0x8d, 0x98, 0x9c, 0xa6, 0xad, 0xc0, 0x79, 0x86, 0x8d, 0x9d, 0xa3, 0xb1, 0xc1, 0x61, 0x6b, 0x75,
  0x80, 0x8f, 0xa0, 0xb1, 0x97, 0x9c, 0xa3, 0xa7, 0xac, 0xb8, 0xc1, 0x8e, 0x95, 0x99, 0x9e, 0xa5,
  0xb1, 0xbf, 0x88, 0x8d, 0x9b, 0x9e, 0xa8, 0xb2, 0xbb, 0x79, 0x7f, 0x87, 0x8c, 0x96, 0xa0, 0xb3,
  0x70, 0x7c, 0x83, 0x8f, 0x93, 0xa1, 0xad, 0x5b, 0x63, 0x6c, 0x74, 0x83, 0x95, 0xa7, 0x8d, 0x91,
  0x9c, 0xaa, 0xbd, 0xc9, 0xdb, 0x8e, 0x98, 0xa3, 0xb6, 0xc4, 0xd2, 0xe2, 0x80, 0x85, 0x95, 0xa2,
  0xb7, 0xc4, 0xd4, 0x7b, 0x84, 0x92, 0xa3, 0xb3, 0xbf, 0xd5, 0x6a, 0x76, 0x7f, 0x93, 0xa3, 0xb2,
  0xc6, 0x5b, 0x67, 0x73, 0x86, 0x9b, 0xb2, 0xc6, 0x8f, 0x93, 0x98, 0x9c, 0xa2, 0xab, 0xb8, 0x91,
  0x93, 0x9b, 0x9f, 0xa5, 0xab, 0xb6, 0x83, 0x87, 0x90, 0x95, 0x9e, 0xa7, 0xb3, 0x7e, 0x7f, 0x8a,
  0x8e, 0x97, 0x9b, 0xac, 0x6c, 0x77, 0x7b, 0x88, 0x8d, 0x98, 0xa9, 0x5e, 0x63, 0x6d, 0x78, 0x84,
  0x92, 0xa1, 0x8b, 0x8c, 0x9a, 0xa1, 0xa9, 0xb0, 0xc2, 0x8c, 0x8c, 0x95, 0xa2, 0xac, 0xb9, 0xcb,
  0x7e, 0x81, 0x92, 0x9a, 0xa3, 0xab, 0xbc, 0x78, 0x79, 0x85, 0x91, 0x9c, 0xa9, 0xc1, 0x68, 0x72,
  0x7d, 0x8c, 0x92, 0x9e, 0xb2, 0x5a, 0x5f, 0x69, 0x79, 0x89, 0x9e, 0xb3, 0x8c, 0x8e, 0x98, 0xa4,
  0xaf, 0xba, 0xce, 0x8c, 0x8f, 0x9e, 0xa9, 0xb7, 0xc7, 0xda, 0x7f, 0x81, 0x90, 0x9b, 0xaa, 0xb4,
  0xc7, 0x79, 0x7a, 0x8b, 0x96, 0xa6, 0xb5, 0xce, 0x69, 0x73, 0x7b, 0x8e, 0x96, 0xa4, 0xbc, 0x5a,
  0x60, 0x6e, 0x7c, 0x91, 0xa9, 0xbf, 0x8f, 0x90, 0x9a, 0xa1, 0xac, 0xc1, 0xdb, 0x8d, 0x95, 0xa0,
  0xa9, 0xb6, 0xcd, 0xe2, 0x82, 0x82, 0x91, 0x97, 0xa6, 0xba, 0xd3, 0x7c, 0x80, 0x8d, 0x95, 0xa5,
  0xb8, 0xd4, 0x6d, 0x73, 0x7b, 0x88, 0x92, 0xa9, 0xc2, 0x5c, 0x63, 0x6f, 0x7b, 0x8e, 0xad, 0xc3,
  0x87, 0x8d, 0x97, 0xa1, 0xb1, 0xc3, 0xd6, 0x80, 0x87, 0x8f, 0x9b, 0xa5, 0xb3, 0xca, 0x7c, 0x81,
  0x8f, 0x98, 0xab, 0xbd, 0xcf, 0x72, 0x76, 0x80, 0x89, 0x96, 0xa3, 0xbe, 0x68, 0x73, 0x7a, 0x89,
  0x96, 0xac, 0xc2, 0x59, 0x5f, 0x67, 0x73, 0x84, 0x98, 0xb0, 0x76, 0x78, 0x82, 0x92, 0xa0, 0xb1,
  0xc6, 0x6c, 0x74, 0x83, 0x8c, 0x98, 0xa3, 0xb8, 0x6e, 0x71, 0x7c, 0x8b, 0x9b, 0xab, 0xbf, 0x64,
  0x6a, 0x79, 0x81, 0x8d, 0x97, 0xaf, 0x60, 0x67, 0x6d, 0x7f, 0x8a, 0x9b, 0xb3, 0x53, 0x59, 0x63,
  0x6d, 0x7c, 0x8e, 0xa2, 0x64, 0x6a, 0x79, 0x83, 0x8e, 0x9a, 0xa8, 0x5b, 0x67, 0x71, 0x7a, 0x85,
  0x96, 0xa9, 0x60, 0x66, 0x76, 0x7e, 0x8a, 0x95, 0xa3, 0x56, 0x60, 0x69, 0x71, 0x7d, 0x8b, 0xa2,
  0x56, 0x5e, 0x69, 0x75, 0x7d, 0x8a, 0x9a, 0x4c, 0x53, 0x5a, 0x63, 0x71, 0x84, 0x96, 0x5a, 0x68,
  0x7d, 0x96, 0xb2, 0xc3, 0xd8, 0x5c, 0x74, 0x89, 0xa8, 0xba, 0xcc, 0xe1, 0x58, 0x63, 0x79, 0x90,
  0xac, 0xbd, 0xd1, 0x59, 0x6c, 0x7f, 0x98, 0xac, 0xbb, 0xd4, 0x52, 0x5e, 0x6d, 0x85, 0x9a, 0xad,
  0xc3, 0x4d, 0x5b, 0x69, 0x80, 0x97, 0xaf, 0xc4, 0x61, 0x6d, 0x77, 0x7d, 0x8d, 0x9c, 0xaf, 0x6d,
  0x74, 0x84, 0x8d, 0x96, 0xa2, 0xaf, 0x5f, 0x69, 0x74, 0x7d, 0x89, 0x97, 0xa8, 0x64, 0x6a, 0x79,
  0x81, 0x8b, 0x94, 0xa6, 0x55, 0x61, 0x68, 0x76, 0x7e, 0x8d, 0xa0, 0x53, 0x52, 0x65, 0x70, 0x7d,
  0x8d, 0x9a, 0x74, 0x7c, 0x87, 0x90, 0x9b, 0xa8, 0xbb, 0x7f, 0x83, 0x8c, 0x9a, 0xa6, 0xb8, 0xcc,
  0x6f, 0x76, 0x82, 0x89, 0x96, 0xa3, 0xb6, 0x73, 0x78, 0x81, 0x8c, 0x99, 0xa8, 0xc0, 0x62, 0x6c,
  0x74, 0x7f, 0x88, 0x95, 0xa9, 0x5b, 0x61, 0x6a, 0x76, 0x88, 0x9d, 0xb1, 0x84, 0x8e, 0x95, 0xa0,
  0xac, 0xbb, 0xd0, 0x8c, 0x95, 0x9f, 0xa8, 0xba, 0xcc, 0xdb, 0x7c, 0x83, 0x8e, 0x97, 0xa6, 0xb3,
  0xc8, 0x7b, 0x83, 0x8f, 0x95, 0xa8, 0xb7, 0xcc, 0x6a, 0x77, 0x7c, 0x8b, 0x95, 0xa4, 0xbb, 0x5e,
  0x68, 0x73, 0x7d, 0x93, 0xaa, 0xbb, 0x8e, 0x93, 0xa8, 0xb3, 0xc0, 0xd3, 0xe4, 0x8d, 0x99, 0xaf,
  0xbc, 0xc9, 0xdd, 0xea, 0x84, 0x89, 0xa0, 0xab, 0xba, 0xcc, 0xde, 0x7f, 0x89, 0x9d, 0xa9, 0xba,
  0xcb, 0xde, 0x71, 0x7a, 0x8a, 0x9c, 0xa6, 0xbb, 0xd0, 0x5d, 0x6a, 0x7c, 0x8d, 0xa2, 0xbe, 0xce,
  0x8b, 0x98, 0xab, 0xb7, 0xc6, 0xd6, 0xe3, 0x8b, 0x97, 0xa5, 0xb4, 0xc0, 0xcb, 0xdb, 0x82, 0x8d,
  0xa4, 0xaf, 0xc1, 0xcf, 0xdc, 0x7d, 0x86, 0x95, 0xa2, 0xb0, 0xb9, 0xcf, 0x70, 0x7f, 0x8d, 0xa1,
  0xad, 0xbd, 0xcf, 0x5d, 0x67, 0x77, 0x88, 0x9b, 0xaf, 0xc1, 0x8e, 0x93, 0x9c, 0xac, 0xba, 0xca,
  0xd9, 0x8c, 0x96, 0xa5, 0xac, 0xb6, 0xc1, 0xd0, 0x85, 0x89, 0x95, 0xa4, 0xb3, 0xc3, 0xd2, 0x7f,
  0x87, 0x96, 0x9c, 0xa8, 0xb2, 0xc6, 0x71, 0x7b, 0x80, 0x95, 0x9f, 0xb2, 0xc4, 0x5e, 0x68, 0x76,
  0x82, 0x92, 0xa6, 0xb9, 0x88, 0x93, 0xa2, 0xa8, 0xb1, 0xba, 0xc6, 0x83, 0x95, 0x9d, 0xa4, 0xae,
  0xbb, 0xc8, 0x80, 0x88, 0x99, 0xa0, 0xad, 0xb5, 0xbf, 0x76, 0x82, 0x8e, 0x93, 0xa0, 0xab, 0xbd,
  0x6e, 0x7b, 0x85, 0x93, 0x9a, 0xa6, 0xb4, 0x5a, 0x66, 0x70, 0x7c, 0x8d, 0xa1, 0xb1, 0x78, 0x89,
  0xa4, 0xb7, 0xc9, 0xd6, 0xe2, 0x7e, 0x99, 0xae, 0xc4, 0xd0, 0xdc, 0xe8, 0x72, 0x81, 0x9e, 0xb0,
  0xc4, 0xd0, 0xdc, 0x74, 0x89, 0x9e, 0xb0, 0xbf, 0xc9, 0xdc, 0x62, 0x74, 0x88, 0x9f, 0xae, 0xbe,
  0xcf, 0x58, 0x69, 0x7c, 0x92, 0xa6, 0xbc, 0xcd, 0x84, 0x92, 0xa0, 0xa8, 0xb0, 0xbc, 0xca, 0x8f,
  0x98, 0xab, 0xb2, 0xb8, 0xc0, 0xca, 0x7d, 0x89, 0x99, 0xa1, 0xac, 0xb7, 0xc3, 0x7f, 0x86, 0x9a,
  0xa0, 0xa9, 0xb1, 0xc0, 0x6b, 0x7c, 0x85, 0x95, 0x9b, 0xa9, 0xb8, 0x5e, 0x68, 0x79, 0x85, 0x94,
  0xa5, 0xb3, 0x90, 0x9d, 0xae, 0xb6, 0xbe, 0xc7, 0xd3, 0x96, 0x9d, 0xac, 0xbb, 0xc4, 0xcf, 0xdc,
  0x87, 0x94, 0xa8, 0xaf, 0xb9, 0xc1, 0xcd, 0x87, 0x8c, 0x9e, 0xaa, 0xb6, 0xbf, 0xd1, 0x73, 0x84,
  0x91, 0xa1, 0xa7, 0xb3, 0xc1, 0x62, 0x6b, 0x7c, 0x8e, 0xa0, 0xb4, 0xc3, 0x99, 0xa6, 0xb3, 0xc0,
  0xc8, 0xd1, 0xde, 0x9d, 0xa9, 0xbb, 0xc4, 0xcf, 0xda, 0xe4, 0x8f, 0x9a, 0xab, 0xb6, 0xc2, 0xcb,
  0xd7, 0x8a, 0x94, 0xa8, 0xaf, 0xbd, 0xc7, 0xd8, 0x79, 0x89, 0x93, 0xa7, 0xad, 0xba, 0xcb, 0x64,
  0x70, 0x83, 0x93, 0xa6, 0xbc, 0xc9, 0x9e, 0xa3, 0xb6, 0xbd, 0xc4, 0xd4, 0xe4, 0x9e, 0xaa, 0xbc,
  0xc3, 0xcc, 0xdd, 0xe9, 0x8e, 0x92, 0xaa, 0xaf, 0xbb, 0xca, 0xd9, 0x87, 0x8e, 0xa2, 0xa5, 0xb2,
  0xc1, 0xd7, 0x73, 0x7e, 0x8a, 0x99, 0x9f, 0xb2, 0xc6, 0x5e, 0x67, 0x77, 0x83, 0x96, 0xb1, 0xc2,
  0x9d, 0xa8, 0xba, 0xc2, 0xcb, 0xd8, 0xe4, 0x9b, 0xa8, 0xb4, 0xbe, 0xc6, 0xce, 0xdb, 0x8e, 0x96,
  0xad, 0xb4, 0xc1, 0xce, 0xd9, 0x85, 0x8c, 0x9c, 0xa3, 0xaf, 0xb6, 0xcb, 0x72, 0x82, 0x8d, 0x9f,
  0xa6, 0xb7, 0xc7, 0x5e, 0x67, 0x74, 0x82, 0x93, 0xa9, 0xba, 0xa0, 0xa5, 0xb3, 0xc0, 0xc7, 0xd2,
  0xde, 0x9f, 0xa9, 0xbb, 0xc1, 0xc6, 0xcd, 0xd9, 0x8f, 0x93, 0xa7, 0xb2, 0xbf, 0xc9, 0xd4, 0x85,
  0x8d, 0xa0, 0xa5, 0xaf, 0xb6, 0xc9, 0x70, 0x7d, 0x87, 0x9b, 0x9f, 0xb1, 0xc1, 0x5b, 0x65, 0x75,
  0x81, 0x92, 0xa6, 0xb7, 0x9c, 0xa7, 0xba, 0xbf, 0xc5, 0xc8, 0xd1, 0x98, 0xaa, 0xb7, 0xbd, 0xc3,
  0xca, 0xd4, 0x8c, 0x95, 0xad, 0xb1, 0xbd, 0xc0, 0xc8, 0x80, 0x8d, 0x9c, 0xa1, 0xad, 0xb3, 0xc5,
  0x70, 0x81, 0x8c, 0x9d, 0xa1, 0xaa, 0xb8, 0x5b, 0x68, 0x74, 0x81, 0x92, 0xa5, 0xb3, 0x9b, 0xa8,
  0xbb, 0xc9, 0xd7, 0xe0, 0xe9, 0x9e, 0xb4, 0xc2, 0xd3, 0xdb, 0xe4, 0xec, 0x8b, 0x97, 0xae, 0xba,
  0xcd, 0xd6, 0xde, 0x86, 0x95, 0xa6, 0xb1, 0xbe, 0xc6, 0xd8, 0x6e, 0x7f, 0x8b, 0xa1, 0xaa, 0xba,
  0xc9, 0x5d, 0x6a, 0x78, 0x89, 0x9d, 0xb4, 0xbf, 0xa8, 0xb2, 0xba, 0xc1, 0xc9, 0xd3, 0xdc, 0xb7,
  0xbd, 0xc6, 0xcb, 0xd0, 0xda, 0xde, 0x95, 0x9e, 0xad, 0xb4, 0xc0, 0xc9, 0xd1, 0x96, 0x9a, 0xa8,
  0xab, 0xb6, 0xbc, 0xcc, 0x76, 0x87, 0x8c, 0x9d, 0xa2, 0xb0, 0xbf, 0x65, 0x6d, 0x7a, 0x86, 0x98,
  0xad, 0xb9, 0xc0, 0xc5, 0xcd, 0xd1, 0xd7, 0xdb, 0xe1, 0xcd, 0xd0, 0xd7, 0xdd, 0xe1, 0xe5, 0xe9,
  0xa8, 0xab, 0xbc, 0xc1, 0xcd, 0xd1, 0xd7, 0xa1, 0xa3, 0xb1, 0xb6, 0xc1, 0xc6, 0xd6, 0x7e, 0x8d,
  0x94, 0xa6, 0xa9, 0xb7, 0xc3, 0x64, 0x6e, 0x7c, 0x8b, 0x9e, 0xb3, 0xc1, 0xd4, 0xd9, 0xde, 0xe2,
  0xe4, 0xe8, 0xee, 0xdd, 0xdd, 0xe5, 0xe6, 0xeb, 0xed, 0xee, 0xb5, 0xba, 0xca, 0xce, 0xd8, 0xdc,
  0xe1, 0xab, 0xae, 0xbb, 0xbc, 0xca, 0xcc, 0xda, 0x87, 0x99, 0x9e, 0xb1, 0xb3, 0xbf, 0xcc, 0x69,
  0x73, 0x82, 0x92, 0xa7, 0xbb, 0xc4, 0xa9, 0xa4, 0x9c, 0x9e, 0x9b, 0x98, 0x97, 0x9c, 0x98, 0x94,
  0x94, 0x8f, 0x8d, 0x8b, 0x8e, 0x8a, 0x88, 0x86, 0x84, 0x81, 0x80, 0x86, 0x83, 0x82, 0x80, 0x7d,
  0x7a, 0x7a, 0x79, 0x79, 0x76, 0x75, 0x74, 0x75, 0x75, 0x70, 0x70, 0x6e, 0x6d, 0x6e, 0x6e, 0x6e,
  0xa5, 0x9e, 0x97, 0x8f, 0x89, 0x82, 0x7f, 0x9a, 0x93, 0x8d, 0x86, 0x80, 0x7b, 0x78, 0x8e, 0x8a,
  0x84, 0x7e, 0x79, 0x75, 0x71, 0x84, 0x7e, 0x78, 0x75, 0x70, 0x6c, 0x6b, 0x7d, 0x7a, 0x77, 0x72,
  0x6e, 0x6a, 0x69, 0x6f, 0x6d, 0x6c, 0x6a, 0x66, 0x63, 0x62, 0xec, 0xdd, 0xce, 0xbd, 0x9c, 0x85,
  0x68, 0xe6, 0xd6, 0xc7, 0xac, 0x92, 0x79, 0x62, 0xe6, 0xd8, 0xcb, 0xb6, 0xa3, 0x91, 0x7c, 0xe4,
  0xd7, 0xc9, 0xb6, 0xa1, 0x90, 0x7e, 0xe4, 0xd1, 0xc5, 0xb0, 0x9e, 0x8a, 0x7a, 0xe2, 0xcb, 0xc0,
  0xae, 0x9d, 0x87, 0x74, 0xe3, 0xd1, 0xc5, 0xb4, 0xa1, 0x8f, 0x7b, 0xe4, 0xd5, 0xc6, 0xb7, 0xa6,
  0x96, 0x7f, 0x69, 0x68, 0x66, 0x63, 0x62, 0x61, 0x61, 0x66, 0x66, 0x62, 0x60, 0x60, 0x5f, 0x5f,
  0x66, 0x62, 0x5f, 0x5c, 0x5a, 0x59, 0x5a, 0x61, 0x59, 0x53, 0x5a, 0x55, 0x50, 0x57, 0x61, 0x5c,
  0x57, 0x5e, 0x5b, 0x58, 0x62, 0x64, 0x60, 0x59, 0x63, 0x61, 0x5c, 0x6a, 0xa8, 0x95, 0x89, 0x80,
  0x78, 0x72, 0x6a, 0x96, 0x88, 0x7e, 0x76, 0x6f, 0x68, 0x63, 0x70, 0x67, 0x61, 0x5d, 0x5b, 0x58,
  0x54, 0x75, 0x6b, 0x64, 0x60, 0x5d, 0x5a, 0x57, 0x5b, 0x57, 0x54, 0x52, 0x52, 0x51, 0x4f, 0x7a,
  0x72, 0x71, 0x68, 0x66, 0x62, 0x5e, 0x74, 0x6f, 0x69, 0x65, 0x61, 0x5e, 0x5b, 0x89, 0x7f, 0x77,
  0x71, 0x6d, 0x68, 0x62, 0x88, 0x7f, 0x77, 0x71, 0x6c, 0x68, 0x63, 0xa6, 0x96, 0x8b, 0x81, 0x7b,
  0x76, 0x6e, 0xf4, 0xf4, 0xf3, 0xf2, 0xf1, 0xf1, 0xf1, 0xed, 0xeb, 0xea, 0xe8, 0xe7, 0xe7, 0xe7,
  0xee, 0xee, 0xec, 0xea, 0xea, 0xea, 0xe9, 0xe7, 0xe5, 0xe2, 0xe1, 0xe0, 0xe0, 0xdf, 0xee, 0xee,
  0xe9, 0xec, 0xe9, 0xe6, 0xe5, 0xe4, 0xe1, 0xde, 0xdd, 0xdb, 0xd8, 0xd7, 0xef, 0xe8, 0xdf, 0xeb,
  0xe4, 0xdf, 0xdb, 0xe8, 0xdc, 0xdf, 0xe2, 0xdc, 0xd7, 0xd3, 0xf1, 0xed, 0xe7, 0xef, 0xeb, 0xe8,
  0xe6, 0xec, 0xe5, 0xe6, 0xe8, 0xe5, 0xe5, 0xe0, 0xf2, 0xef, 0xeb, 0xf1, 0xee, 0xec, 0xeb, 0xf1,
  0xeb, 0xee, 0xf1, 0xee, 0xec, 0xea
};

static const unsigned char palette_0E_22_A[] =
{
  0x80, 0xb3, 0xc4, 0x6a, 0x46, 0x81, 0x80, 0x7e, 0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x82, 0x7e, 0x7c,
  0x7c, 0x7c, 0x7d, 0x7f, 0x7f, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7e, 0x80, 0x7d, 0x7c, 0x7c, 0x7d,
  0x7e, 0x7f, 0x7e, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f,
  0x89, 0x84, 0x82, 0x82, 0x7f, 0x80, 0x80, 0x8f, 0x8b, 0x88, 0x85, 0x85, 0x82, 0x80, 0x85, 0x81,
  0x81, 0x81, 0x7f, 0x80, 0x80, 0x86, 0x84, 0x83, 0x81, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x93, 0x91, 0x8c, 0x89, 0x87, 0x84,
  0x82, 0x9b, 0x98, 0x95, 0x92, 0x8e, 0x8b, 0x88, 0x8d, 0x8b, 0x89, 0x86, 0x85, 0x84, 0x82, 0x8f,
  0x8d, 0x8d, 0x8b, 0x89, 0x87, 0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x84, 0x84, 0x84,
  0x85, 0x85, 0x85, 0x84, 0xa4, 0xa0, 0x9c, 0x98, 0x95, 0x8f, 0x8c, 0xac, 0xa7, 0xa4, 0xa0, 0x9b,
  0x95, 0x8f, 0x99, 0x96, 0x96, 0x93, 0x92, 0x8c, 0x8a, 0x9b, 0x98, 0x97, 0x94, 0x92, 0x8e, 0x8c,
  0x8c, 0x8e, 0x8c, 0x8d, 0x8b, 0x88, 0x88, 0x8a, 0x8a, 0x8b, 0x8b, 0x8c, 0x8b, 0x89, 0xb4, 0xae,
  0xa4, 0x9a, 0x91, 0x8c, 0x86, 0xb2, 0xa8, 0xa0, 0x95, 0x8e, 0x89, 0x84, 0xa8, 0xa4, 0x9f, 0x96,
  0x8f, 0x8a, 0x85, 0xa3, 0x9a, 0x96, 0x8e, 0x8a, 0x87, 0x84, 0x98, 0x99, 0x93, 0x90, 0x8a, 0x87,
  0x84, 0x8d, 0x8b, 0x8a, 0x87, 0x86, 0x85, 0x82, 0xb3, 0xaf, 0xa9, 0xa4, 0xa0, 0x9b, 0x95, 0xb4,
  0xb2, 0xa9, 0xa4, 0x9f, 0x9d, 0x98, 0xa8, 0xa3, 0xa2, 0x9d, 0x9c, 0x98, 0x93, 0xa4, 0xa2, 0x9d,
  0x99, 0x97, 0x96, 0x93, 0x98, 0x9a, 0x95, 0x96, 0x93, 0x92, 0x8f, 0x8f, 0x91, 0x8f, 0x8e, 0x8f,
  0x92, 0x90, 0xb3, 0xaf, 0xa8, 0xa4, 0xa0, 0x9c, 0x93, 0xb3, 0xb2, 0xad, 0xa5, 0x9f, 0x99, 0x90,
  0xa8, 0xa5, 0xa1, 0x9e, 0x9d, 0x99, 0x91, 0xa4, 0xa3, 0xa1, 0x9b, 0x98, 0x93, 0x8d, 0x99, 0x9b,
  0x95, 0x97, 0x94, 0x93, 0x8e, 0x8e, 0x92, 0x91, 0x91, 0x91, 0x90, 0x8b, 0xb4, 0xb0, 0xaa, 0xa5,
  0x9e, 0x99, 0x90, 0xb3, 0xb0, 0xa7, 0xa2, 0x9c, 0x93, 0x8b, 0xa9, 0xa5, 0xa5, 0x9f, 0x9b, 0x97,
  0x8f, 0xa4, 0xa1, 0x9d, 0x98, 0x95, 0x8e, 0x89, 0x9a, 0x9c, 0x98, 0x97, 0x93, 0x91, 0x8c, 0x8f,
  0x91, 0x8f, 0x8f, 0x8e, 0x8c, 0x87, 0xb1, 0xb0, 0xa8, 0xa4, 0x9f, 0x95, 0x8a, 0xb2, 0xad, 0xa5,
  0xa0, 0x9a, 0x90, 0x87, 0xa9, 0xa8, 0xa3, 0x9f, 0x9c, 0x93, 0x89, 0xa4, 0xa0, 0x9b, 0x97, 0x94,
  0x8c, 0x86, 0x99, 0x9d, 0x97, 0x98, 0x94, 0x8f, 0x88, 0x8e, 0x8f, 0x8e, 0x8e, 0x8d, 0x8a, 0x85,
  0xb3, 0xae, 0xa8, 0xa3, 0x9c, 0x95, 0x8e, 0xb5, 0xb1, 0xac, 0xa6, 0xa2, 0x9c, 0x92, 0xaa, 0xa6,
  0xa3, 0x9f, 0x9a, 0x93, 0x8d, 0xa7, 0xa3, 0xa1, 0x9c, 0x9a, 0x95, 0x8f, 0x9a, 0x9c, 0x97, 0x98,
  0x92, 0x8e, 0x8a, 0x90, 0x91, 0x91, 0x91, 0x92, 0x92, 0x8c, 0xb7, 0xb5, 0xb1, 0xaa, 0xa4, 0x9d,
  0x94, 0xba, 0xb7, 0xb1, 0xae, 0xaa, 0xa5, 0x9d, 0xac, 0xab, 0xab, 0xa4, 0xa1, 0x9b, 0x93, 0xaa,
  0xa8, 0xa6, 0xa3, 0xa2, 0x9d, 0x99, 0x9c, 0xa0, 0x9d, 0x9d, 0x99, 0x95, 0x8f, 0x91, 0x94, 0x95,
  0x97, 0x99, 0x9a, 0x94, 0xbc, 0xba, 0xb6, 0xb3, 0xb0, 0xa9, 0xa4, 0xbe, 0xbc, 0xba, 0xb8, 0xb4,
  0xae, 0xa5, 0xb1, 0xaf, 0xaf, 0xad, 0xac, 0xa6, 0xa1, 0xad, 0xac, 0xad, 0xab, 0xaa, 0xa5, 0xa1,
  0xa0, 0xa4, 0xa0, 0xa4, 0xa1, 0x9f, 0x9c, 0x94, 0x97, 0x9a, 0x9c, 0xa0, 0xa0, 0x9b, 0xbf, 0xbe,
  0xb9, 0xb2, 0xa6, 0x9e, 0x91, 0xbf, 0xbb, 0xb6, 0xab, 0xa2, 0x98, 0x8d, 0xb5, 0xb3, 0xb3, 0xac,
  0xa4, 0x9b, 0x91, 0xaf, 0xac, 0xaa, 0xa0, 0x9b, 0x94, 0x8c, 0xa2, 0xa8, 0xa4, 0xa4, 0x9b, 0x96,
  0x8f, 0x94, 0x97, 0x98, 0x96, 0x94, 0x91, 0x89, 0xbf, 0xbd, 0xbb, 0xb9, 0xb6, 0xb2, 0xaa, 0xbe,
  0xbe, 0xba, 0xb8, 0xb6, 0xb2, 0xac, 0xb4, 0xb3, 0xb5, 0xb3, 0xb3, 0xae, 0xa7, 0xaf, 0xae, 0xae,
  0xac, 0xac, 0xaa, 0xa7, 0xa2, 0xa7, 0xa6, 0xaa, 0xa8, 0xa6, 0xa1, 0x96, 0x99, 0x9b, 0x9d, 0xa2,
  0xa5, 0xa1, 0xc0, 0xc0, 0xbb, 0xb7, 0xb3, 0xaf, 0xa3, 0xc1, 0xc1, 0xbe, 0xb8, 0xb3, 0xaa, 0x9d,
  0xb6, 0xb5, 0xb5, 0xb1, 0xb0, 0xac, 0xa1, 0xb1, 0xb1, 0xb1, 0xac, 0xaa, 0xa2, 0x99, 0xa3, 0xa9,
  0xa6, 0xa8, 0xa5, 0xa3, 0x9b, 0x96, 0x9a, 0x9d, 0x9e, 0x9f, 0x9e, 0x95, 0xc1, 0xc1, 0xbe, 0xb8,
  0xb1, 0xaa, 0x9c, 0xc2, 0xc2, 0xbc, 0xb5, 0xac, 0xa1, 0x93, 0xb7, 0xb7, 0xb7, 0xb2, 0xad, 0xa7,
  0x9a, 0xb2, 0xb2, 0xb0, 0xaa, 0xa4, 0x9a, 0x8f, 0xa4, 0xaa, 0xa7, 0xa8, 0xa2, 0x9f, 0x95, 0x97,
  0x9b, 0x9c, 0x9c, 0x9b, 0x96, 0x8d, 0xc3, 0xc3, 0xbe, 0xbb, 0xb4, 0xa5, 0x92, 0xc1, 0xc1, 0xbb,
  0xb7, 0xae, 0x9d, 0x8d, 0xb9, 0xb8, 0xb8, 0xb5, 0xb1, 0xa3, 0x91, 0xad, 0xb1, 0xaf, 0xaa, 0xa5,
  0x97, 0x8b, 0xa4, 0xac, 0xa8, 0xab, 0xa5, 0x9b, 0x8f, 0x98, 0x9b, 0x9c, 0x9c, 0x9c, 0x93, 0x89,
  0xbb, 0xbc, 0xb7, 0xb1, 0xac, 0x9f, 0x91, 0xb5, 0xb6, 0xb4, 0xb1, 0xaa, 0xa5, 0x9a, 0xb2, 0xb3,
  0xb1, 0xac, 0xaa, 0x9d, 0x8f, 0xaa, 0xaa, 0xaa, 0xa6, 0xa2, 0x9e, 0x96, 0xa3, 0xa8, 0xa4, 0xa5,
  0x9f, 0x96, 0x8d, 0x95, 0x98, 0x99, 0x9a, 0x9a, 0x9a, 0x94, 0xb0, 0xb3, 0xb4, 0xb0, 0xab, 0xa2,
  0x97, 0xa6, 0xa9, 0xa5, 0xa5, 0xa2, 0xa0, 0x97, 0xaa, 0xac, 0xaf, 0xac, 0xa8, 0xa0, 0x96, 0x9f,
  0xa1, 0x9f, 0x9e, 0x9e, 0x9b, 0x94, 0x9d, 0xa3, 0xa3, 0xa5, 0xa0, 0x9b, 0x93, 0x90, 0x94, 0x93,
  0x96, 0x96, 0x97, 0x91, 0x9d, 0xa0, 0xa0, 0x9f, 0x9d, 0xa1, 0x9c, 0x93, 0x96, 0x96, 0x97, 0x98,
  0x98, 0x96, 0x99, 0x9c, 0x9d, 0x9c, 0x9c, 0x9f, 0x9b, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x93,
  0x92, 0x97, 0x96, 0x97, 0x96, 0x99, 0x97, 0x89, 0x8b, 0x8c, 0x8e, 0x90, 0x92, 0x90, 0x90, 0x91,
  0x91, 0x91, 0x8d, 0x8b, 0x87, 0x90, 0x91, 0x91, 0x8f, 0x8d, 0x89, 0x85, 0x8d, 0x8e, 0x8f, 0x8f,
  0x8c, 0x8a, 0x86, 0x8d, 0x8d, 0x8d, 0x8b, 0x89, 0x86, 0x83, 0x8a, 0x8c, 0x8c, 0x8c, 0x89, 0x87,
  0x85, 0x88, 0x88, 0x88, 0x88, 0x88, 0x86, 0x83, 0x8c, 0x8d, 0x8e, 0x8d, 0x8d, 0x8a, 0x88, 0x85,
  0x84, 0x85, 0x86, 0x86, 0x81, 0x82, 0x8a, 0x8a, 0x8c, 0x8d, 0x8d, 0x8a, 0x88, 0x83, 0x82, 0x84,
  0x84, 0x84, 0x80, 0x81, 0x87, 0x89, 0x89, 0x8b, 0x8a, 0x88, 0x86, 0x82, 0x82, 0x82, 0x83, 0x84,
  0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x82, 0x79, 0x77, 0x75, 0x75, 0x77, 0x7a, 0x7c,
  0x80, 0x80, 0x82, 0x80, 0x80, 0x80, 0x82, 0x79, 0x78, 0x76, 0x76, 0x78, 0x7b, 0x7d, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x82, 0x7d, 0x7c, 0x7a, 0x79, 0x79, 0x7b, 0x7d, 0x74, 0x72, 0x71, 0x72,
  0x76, 0x75, 0x77, 0x6d, 0x6b, 0x6e, 0x70, 0x6f, 0x75, 0x7c, 0x75, 0x74, 0x73, 0x74, 0x76, 0x77,
  0x78, 0x70, 0x6f, 0x70, 0x72, 0x73, 0x78, 0x7d, 0x78, 0x75, 0x76, 0x75, 0x78, 0x78, 0x7a, 0x79,
  0x77, 0x77, 0x77, 0x76, 0x79, 0x7d, 0x66, 0x66, 0x67, 0x69, 0x6d, 0x73, 0x7a, 0x66, 0x66, 0x68,
  0x6b, 0x6f, 0x77, 0x7c, 0x68, 0x68, 0x69, 0x6b, 0x6e, 0x74, 0x7b, 0x6a, 0x6a, 0x6c, 0x6f, 0x72,
  0x79, 0x7d, 0x6e, 0x6c, 0x6e, 0x6e, 0x71, 0x76, 0x7c, 0x75, 0x73, 0x74, 0x74, 0x75, 0x7a, 0x7e,
  0x65, 0x64, 0x66, 0x68, 0x6d, 0x73, 0x78, 0x61, 0x61, 0x63, 0x66, 0x69, 0x6e, 0x75, 0x67, 0x67,
  0x68, 0x6a, 0x6f, 0x74, 0x79, 0x67, 0x67, 0x68, 0x6b, 0x6d, 0x70, 0x76, 0x6d, 0x6b, 0x6d, 0x6e,
  0x72, 0x76, 0x7a, 0x74, 0x72, 0x71, 0x71, 0x71, 0x72, 0x77, 0x5e, 0x5f, 0x60, 0x64, 0x67, 0x6c,
  0x73, 0x5a, 0x5b, 0x5d, 0x5f, 0x63, 0x66, 0x6d, 0x62, 0x63, 0x63, 0x66, 0x68, 0x6d, 0x74, 0x62,
  0x63, 0x64, 0x66, 0x68, 0x6b, 0x6f, 0x6b, 0x68, 0x6a, 0x6a, 0x6d, 0x70, 0x75, 0x72, 0x70, 0x6f,
  0x6e, 0x6d, 0x6e, 0x72, 0x56, 0x57, 0x59, 0x5c, 0x5e, 0x63, 0x68, 0x52, 0x52, 0x54, 0x57, 0x5a,
  0x60, 0x67, 0x5c, 0x5c, 0x5d, 0x5f, 0x60, 0x65, 0x69, 0x5c, 0x5d, 0x5d, 0x5f, 0x60, 0x66, 0x69,
  0x67, 0x64, 0x66, 0x64, 0x67, 0x6a, 0x6c, 0x6e, 0x6c, 0x6a, 0x68, 0x67, 0x68, 0x6c, 0x51, 0x51,
  0x54, 0x5b, 0x66, 0x6d, 0x76, 0x50, 0x53, 0x58, 0x63, 0x69, 0x71, 0x7a, 0x56, 0x57, 0x59, 0x60,
  0x68, 0x6f, 0x77, 0x58, 0x5d, 0x60, 0x69, 0x6e, 0x74, 0x7b, 0x62, 0x5e, 0x62, 0x64, 0x6d, 0x72,
  0x78, 0x6d, 0x6c, 0x6c, 0x71, 0x72, 0x75, 0x7b, 0x4c, 0x4f, 0x51, 0x54, 0x57, 0x5c, 0x64, 0x4a,
  0x4c, 0x51, 0x54, 0x58, 0x5b, 0x61, 0x53, 0x56, 0x56, 0x58, 0x59, 0x5e, 0x65, 0x54, 0x56, 0x5a,
  0x5d, 0x5e, 0x62, 0x65, 0x60, 0x5d, 0x60, 0x5e, 0x61, 0x63, 0x68, 0x6b, 0x69, 0x69, 0x67, 0x66,
  0x64, 0x68, 0x48, 0x4a, 0x50, 0x53, 0x58, 0x5d, 0x67, 0x47, 0x47, 0x4b, 0x52, 0x59, 0x61, 0x6c,
  0x4f, 0x51, 0x54, 0x58, 0x5a, 0x60, 0x69, 0x52, 0x52, 0x55, 0x5c, 0x60, 0x67, 0x6f, 0x5d, 0x59,
  0x60, 0x5f, 0x62, 0x65, 0x6c, 0x69, 0x66, 0x65, 0x67, 0x68, 0x6a, 0x71, 0x46, 0x49, 0x4e, 0x55,
  0x5c, 0x62, 0x6d, 0x46, 0x48, 0x51, 0x56, 0x5e, 0x69, 0x73, 0x4e, 0x50, 0x52, 0x58, 0x5d, 0x63,
  0x6d, 0x52, 0x54, 0x5a, 0x5f, 0x64, 0x6e, 0x75, 0x5c, 0x59, 0x5d, 0x5f, 0x64, 0x68, 0x71, 0x69,
  0x67, 0x68, 0x69, 0x6a, 0x6f, 0x77, 0x47, 0x47, 0x4e, 0x51, 0x56, 0x63, 0x72, 0x47, 0x49, 0x51,
  0x55, 0x5b, 0x6a, 0x76, 0x50, 0x52, 0x54, 0x57, 0x59, 0x65, 0x73, 0x56, 0x59, 0x5d, 0x61, 0x64,
  0x70, 0x78, 0x62, 0x5d, 0x63, 0x60, 0x65, 0x6b, 0x76, 0x6f, 0x6e, 0x6f, 0x6e, 0x6e, 0x73, 0x7a,
  0x47, 0x48, 0x4f, 0x54, 0x5b, 0x66, 0x71, 0x47, 0x49, 0x4d, 0x52, 0x57, 0x5e, 0x69, 0x51, 0x53,
  0x56, 0x5a, 0x5e, 0x69, 0x73, 0x56, 0x58, 0x5a, 0x5f, 0x61, 0x66, 0x6d, 0x61, 0x5d, 0x64, 0x63,
  0x68, 0x6e, 0x75, 0x6e, 0x6d, 0x6d, 0x6c, 0x6a, 0x6a, 0x71, 0x47, 0x48, 0x4d, 0x53, 0x58, 0x61,
  0x6c, 0x48, 0x4a, 0x51, 0x54, 0x58, 0x5d, 0x67, 0x52, 0x53, 0x53, 0x59, 0x5c, 0x64, 0x6e, 0x59,
  0x5b, 0x5e, 0x61, 0x63, 0x66, 0x6c, 0x65, 0x60, 0x63, 0x62, 0x67, 0x6a, 0x72, 0x71, 0x6f, 0x70,
  0x6e, 0x6b, 0x6a, 0x70, 0x48, 0x4a, 0x51, 0x54, 0x57, 0x5a, 0x60, 0x4a, 0x4c, 0x51, 0x54, 0x57,
  0x5b, 0x63, 0x53, 0x55, 0x57, 0x5a, 0x5b, 0x5d, 0x63, 0x5a, 0x5d, 0x5e, 0x60, 0x61, 0x64, 0x68,
  0x64, 0x60, 0x66, 0x63, 0x66, 0x65, 0x68, 0x70, 0x6f, 0x6e, 0x6c, 0x6a, 0x69, 0x6c, 0x4c, 0x4e,
  0x54, 0x5b, 0x66, 0x6e, 0x76, 0x4c, 0x51, 0x57, 0x62, 0x69, 0x72, 0x7a, 0x56, 0x58, 0x5a, 0x61,
  0x68, 0x70, 0x77, 0x5b, 0x61, 0x63, 0x6c, 0x70, 0x76, 0x7b, 0x67, 0x63, 0x68, 0x69, 0x70, 0x74,
  0x79, 0x72, 0x72, 0x72, 0x75, 0x76, 0x78, 0x7d, 0x50, 0x52, 0x54, 0x57, 0x5c, 0x63, 0x6a, 0x58,
  0x5a, 0x5c, 0x5f, 0x61, 0x69, 0x6d, 0x59, 0x5c, 0x5a, 0x5e, 0x5f, 0x66, 0x6c, 0x65, 0x67, 0x67,
  0x69, 0x6a, 0x6f, 0x70, 0x69, 0x66, 0x67, 0x66, 0x69, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x72, 0x71,
  0x72, 0x73, 0x5f, 0x60, 0x61, 0x64, 0x68, 0x6b, 0x6f, 0x69, 0x6b, 0x6c, 0x6f, 0x70, 0x73, 0x77,
  0x67, 0x67, 0x65, 0x68, 0x6a, 0x6d, 0x71, 0x71, 0x72, 0x72, 0x73, 0x74, 0x76, 0x78, 0x72, 0x6f,
  0x70, 0x6e, 0x71, 0x72, 0x73, 0x7a, 0x79, 0x79, 0x79, 0x78, 0x78, 0x7a, 0x6f, 0x71, 0x71, 0x73,
  0x73, 0x76, 0x7a, 0x77, 0x77, 0x76, 0x76, 0x79, 0x7a, 0x7b, 0x72, 0x74, 0x73, 0x74, 0x74, 0x77,
  0x7b, 0x79, 0x7a, 0x78, 0x78, 0x7a, 0x7b, 0x7c, 0x78, 0x78, 0x78, 0x77, 0x77, 0x79, 0x7c, 0x7c,
  0x7c, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d, 0x8d, 0x8f, 0x91, 0x94, 0x96, 0x97, 0x98, 0x8a, 0x8c, 0x8e,
  0x90, 0x91, 0x92, 0x93, 0x87, 0x89, 0x8b, 0x8c, 0x8d, 0x8f, 0x8f, 0x87, 0x88, 0x8a, 0x8b, 0x8d,
  0x8e, 0x8d, 0x89, 0x89, 0x8a, 0x8b, 0x8b, 0x8b, 0x8a, 0x86, 0x87, 0x88, 0x89, 0x89, 0x89, 0x88,
  0x91, 0x96, 0x9a, 0x9e, 0xa1, 0xa4, 0xa5, 0x8e, 0x92, 0x95, 0x99, 0x9c, 0x9f, 0xa0, 0x8b, 0x8f,
  0x92, 0x96, 0x99, 0x9b, 0x9b, 0x8b, 0x8d, 0x90, 0x93, 0x96, 0x97, 0x98, 0x88, 0x8a, 0x8c, 0x8f,
  0x92, 0x93, 0x94, 0x87, 0x88, 0x89, 0x8c, 0x8d, 0x8f, 0x8f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81,
  0x82, 0x82, 0x82, 0x83, 0x84, 0x82, 0x82, 0x87, 0x86, 0x88, 0x89, 0x8a, 0x88, 0x83, 0x89, 0x88,
  0x86, 0x85, 0x88, 0x89, 0x80, 0x7b, 0x7c, 0x7c, 0x7c, 0x7a, 0x7b, 0x7f, 0x7b, 0x7b, 0x7d, 0x7d,
  0x7b, 0x7b, 0x80, 0x7f, 0x7e, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84,
  0x83, 0x84, 0x85, 0x87, 0x87, 0x87, 0x89, 0x88, 0x8b, 0x8e, 0x85, 0x88, 0x8a, 0x85, 0x80, 0x7f,
  0x7d, 0x7d, 0x7c, 0x7a, 0x79, 0x7e, 0x7c, 0x78, 0x7d, 0x7a, 0x75, 0x79, 0x81, 0x80, 0x80, 0x80,
  0x7f, 0x7f, 0x7f, 0x9c, 0x98, 0x94, 0x92, 0x8f, 0x8c, 0x89, 0xa8, 0xa2, 0x9d, 0x99, 0x97, 0x93,
  0x90, 0xab, 0xa4, 0x9f, 0x9c, 0x9a, 0x96, 0x92, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x89, 0x88, 0x75,
  0x79, 0x79, 0x7b, 0x7c, 0x7d, 0x7e, 0x60, 0x66, 0x6a, 0x6d, 0x6f, 0x71, 0x74, 0x60, 0x66, 0x6a,
  0x6d, 0x70, 0x72, 0x75, 0x61, 0x67, 0x6b, 0x6e, 0x70, 0x72, 0x75, 0x77, 0x79, 0x7a, 0x7b, 0x7b,
  0x7c, 0x7c, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80,
  0x83, 0x83, 0x85, 0x87, 0x86, 0x86, 0x86, 0x83, 0x83, 0x84, 0x86, 0x86, 0x85, 0x85, 0x84, 0x84,
  0x87, 0x85, 0x88, 0x89, 0x8a, 0x8c, 0x8d, 0x8f, 0x91, 0x92, 0x93, 0x94, 0x84, 0x89, 0x8f, 0x82,
  0x87, 0x8b, 0x8f, 0x81, 0x8a, 0x84, 0x7f, 0x83, 0x87, 0x8a, 0x7f, 0x7e, 0x7b, 0x7d, 0x7c, 0x7a,
  0x79, 0x7a, 0x78, 0x76, 0x76, 0x75, 0x75, 0x74, 0x7e, 0x7c, 0x77, 0x7e, 0x7b, 0x79, 0x77, 0x7d,
  0x77, 0x7a, 0x7d, 0x7a, 0x77, 0x76
};

static const unsigned char palette_0E_22_B[] =
{
  0xd6, 0xbe, 0x7a, 0x51, 0x96, 0x80, 0xd3, 0xcd, 0xc0, 0xbb, 0xb4, 0xa7, 0x94, 0xd2, 0xc9, 0xbc,
  0xb6, 0xad, 0x9d, 0x8f, 0xc2, 0xbd, 0xb7, 0xb2, 0xb0, 0xa2, 0x92, 0xba, 0xb2, 0xab, 0xa5, 0xa2,
  0x94, 0x8d, 0xa8, 0xac, 0xa2, 0xa5, 0xa1, 0x9a, 0x8e, 0x98, 0x97, 0x95, 0x95, 0x96, 0x91, 0x8a,
  0xd0, 0xc9, 0xbd, 0xb7, 0xaf, 0xa3, 0x96, 0xcf, 0xc8, 0xc0, 0xb9, 0xb3, 0xad, 0x9e, 0xc1, 0xba,
  0xb3, 0xad, 0xaa, 0xa0, 0x94, 0xb7, 0xb0, 0xad, 0xa8, 0xa6, 0xa1, 0x99, 0xa8, 0xaa, 0xa0, 0xa2,
  0x9c, 0x97, 0x90, 0x9a, 0x99, 0x97, 0x97, 0x9a, 0x9b, 0x94, 0xca, 0xcb, 0xc8, 0xc1, 0xb9, 0xac,
  0x9e, 0xc9, 0xc8, 0xc1, 0xbe, 0xb9, 0xb2, 0xa6, 0xbb, 0xbc, 0xc0, 0xb9, 0xb4, 0xa8, 0x9b, 0xb3,
  0xb3, 0xb2, 0xae, 0xad, 0xa7, 0xa0, 0xa5, 0xad, 0xab, 0xac, 0xa6, 0x9f, 0x97, 0x96, 0x9b, 0x9c,
  0x9f, 0xa0, 0xa1, 0x9b, 0xc8, 0xc8, 0xc3, 0xc0, 0xbb, 0xb7, 0xaf, 0xc7, 0xc6, 0xc4, 0xc1, 0xbd,
  0xb6, 0xad, 0xb9, 0xba, 0xba, 0xb8, 0xb7, 0xb3, 0xab, 0xb1, 0xb1, 0xb3, 0xb0, 0xb0, 0xab, 0xa7,
  0xa4, 0xab, 0xa8, 0xad, 0xa8, 0xa8, 0xa5, 0x97, 0x9b, 0x9d, 0xa0, 0xa3, 0xa5, 0xa0, 0xc6, 0xc5,
  0xc0, 0xb6, 0xa8, 0x9f, 0x93, 0xc6, 0xc3, 0xbc, 0xae, 0xa4, 0x9a, 0x8e, 0xb8, 0xb9, 0xba, 0xb0,
  0xa4, 0x9b, 0x92, 0xb3, 0xb1, 0xae, 0xa3, 0x9b, 0x94, 0x8c, 0xa5, 0xab, 0xa7, 0xa6, 0x9b, 0x95,
  0x8f, 0x97, 0x99, 0x9a, 0x97, 0x94, 0x90, 0x89, 0xc5, 0xc4, 0xc2, 0xbf, 0xb9, 0xb1, 0xa9, 0xc4,
  0xc3, 0xbf, 0xbb, 0xb6, 0xb0, 0xaa, 0xb8, 0xb7, 0xba, 0xb6, 0xb4, 0xad, 0xa5, 0xb0, 0xaf, 0xb0,
  0xac, 0xaa, 0xa6, 0xa3, 0xa3, 0xaa, 0xa8, 0xab, 0xa7, 0xa5, 0xa0, 0x96, 0x9a, 0x9b, 0x9d, 0x9f,
  0xa1, 0x9e, 0xc2, 0xc1, 0xbd, 0xba, 0xb4, 0xaf, 0xa4, 0xc2, 0xc1, 0xbe, 0xb7, 0xb0, 0xa8, 0x9d,
  0xb5, 0xb5, 0xb6, 0xb2, 0xb1, 0xac, 0xa2, 0xb0, 0xb0, 0xaf, 0xaa, 0xa7, 0xa0, 0x99, 0xa3, 0xa8,
  0xa6, 0xa9, 0xa6, 0xa3, 0x9e, 0x96, 0x9a, 0x9c, 0x9d, 0x9d, 0x9c, 0x95, 0xc3, 0xc0, 0xbb, 0xb5,
  0xae, 0xa6, 0x99, 0xc1, 0xbf, 0xb7, 0xb2, 0xa8, 0x9d, 0x93, 0xb6, 0xb4, 0xb5, 0xaf, 0xab, 0xa4,
  0x98, 0xaf, 0xad, 0xab, 0xa6, 0xa0, 0x97, 0x91, 0xa3, 0xa7, 0xa4, 0xa5, 0xa1, 0x9d, 0x95, 0x96,
  0x99, 0x99, 0x9a, 0x98, 0x94, 0x8e, 0xbf, 0xbe, 0xb6, 0xb1, 0xaa, 0x9d, 0x8f, 0xbf, 0xbc, 0xb2,
  0xac, 0xa4, 0x97, 0x8b, 0xb5, 0xb4, 0xb0, 0xac, 0xa7, 0x9b, 0x8e, 0xaf, 0xad, 0xa7, 0xa3, 0x9e,
  0x92, 0x8a, 0xa2, 0xa7, 0xa2, 0xa4, 0x9f, 0x97, 0x8d, 0x94, 0x97, 0x97, 0x97, 0x96, 0x90, 0x89,
  0xba, 0xb8, 0xb0, 0xaa, 0xa3, 0x99, 0x8e, 0xb7, 0xb5, 0xb1, 0xab, 0xa3, 0x9f, 0x95, 0xb1, 0xaf,
  0xaa, 0xa5, 0xa1, 0x97, 0x8e, 0xa9, 0xa7, 0xa6, 0xa1, 0x9c, 0x99, 0x93, 0xa0, 0xa4, 0x9e, 0x9e,
  0x98, 0x92, 0x8b, 0x93, 0x95, 0x96, 0x96, 0x95, 0x95, 0x8f, 0xb5, 0xb5, 0xb1, 0xaa, 0xa3, 0x9b,
  0x92, 0xb0, 0xad, 0xa6, 0xa1, 0x9e, 0x9b, 0x93, 0xab, 0xac, 0xab, 0xa5, 0xa0, 0x98, 0x91, 0xa3,
  0xa1, 0x9e, 0x9a, 0x98, 0x95, 0x90, 0x9c, 0xa1, 0x9f, 0x9f, 0x99, 0x94, 0x8e, 0x8f, 0x92, 0x91,
  0x91, 0x92, 0x93, 0x8e, 0xa9, 0xa8, 0xa3, 0x9f, 0x9b, 0x9c, 0x99, 0xa5, 0xa1, 0x9e, 0x9b, 0x98,
  0x96, 0x93, 0xa2, 0xa1, 0x9e, 0x9a, 0x99, 0x9a, 0x96, 0x99, 0x96, 0x96, 0x93, 0x93, 0x91, 0x90,
  0x96, 0x98, 0x94, 0x95, 0x93, 0x95, 0x93, 0x8c, 0x8c, 0x8c, 0x8d, 0x8e, 0x8f, 0x8e, 0xa6, 0xa2,
  0x9c, 0x96, 0x8f, 0x8b, 0x87, 0xa5, 0x9e, 0x98, 0x91, 0x8c, 0x89, 0x86, 0x9e, 0x9b, 0x98, 0x93,
  0x8e, 0x8a, 0x87, 0x9b, 0x96, 0x92, 0x8d, 0x89, 0x87, 0x85, 0x93, 0x94, 0x90, 0x8f, 0x8a, 0x88,
  0x86, 0x8c, 0x8b, 0x8a, 0x89, 0x87, 0x86, 0x84, 0xa0, 0x9c, 0x9a, 0x98, 0x94, 0x90, 0x8c, 0x96,
  0x93, 0x91, 0x8f, 0x8e, 0x88, 0x86, 0x99, 0x95, 0x96, 0x94, 0x92, 0x8e, 0x8a, 0x8f, 0x8c, 0x8b,
  0x8a, 0x8a, 0x85, 0x85, 0x8f, 0x90, 0x8e, 0x90, 0x8d, 0x8b, 0x89, 0x86, 0x85, 0x85, 0x86, 0x86,
  0x84, 0x84, 0x91, 0x8f, 0x8d, 0x8b, 0x89, 0x86, 0x86, 0x8a, 0x87, 0x84, 0x81, 0x80, 0x80, 0x80,
  0x8c, 0x8a, 0x8a, 0x88, 0x88, 0x85, 0x85, 0x84, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x86, 0x86,
  0x86, 0x86, 0x84, 0x84, 0x84, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x86, 0x83, 0x80, 0x7f,
  0x80, 0x7e, 0x7d, 0x81, 0x7f, 0x7c, 0x7c, 0x7a, 0x7c, 0x80, 0x82, 0x80, 0x7f, 0x7e, 0x7f, 0x7d,
  0x7e, 0x7e, 0x7c, 0x7b, 0x7b, 0x7a, 0x7c, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e,
  0x7d, 0x7c, 0x7c, 0x7b, 0x7d, 0x80, 0x7b, 0x7b, 0x78, 0x77, 0x77, 0x79, 0x7e, 0x79, 0x79, 0x77,
  0x77, 0x77, 0x7b, 0x7f, 0x79, 0x79, 0x77, 0x77, 0x77, 0x79, 0x7e, 0x78, 0x78, 0x77, 0x77, 0x78,
  0x7c, 0x80, 0x7a, 0x79, 0x78, 0x77, 0x78, 0x7a, 0x7e, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x7c, 0x80,
  0x74, 0x75, 0x73, 0x73, 0x75, 0x78, 0x7c, 0x70, 0x71, 0x71, 0x71, 0x71, 0x74, 0x79, 0x75, 0x75,
  0x73, 0x73, 0x76, 0x78, 0x7c, 0x73, 0x73, 0x73, 0x73, 0x73, 0x76, 0x7a, 0x77, 0x77, 0x76, 0x75,
  0x78, 0x7a, 0x7d, 0x7a, 0x79, 0x78, 0x77, 0x77, 0x77, 0x7a, 0x6e, 0x70, 0x6f, 0x6f, 0x70, 0x72,
  0x77, 0x69, 0x69, 0x67, 0x69, 0x6b, 0x6d, 0x71, 0x70, 0x71, 0x70, 0x70, 0x70, 0x73, 0x77, 0x6d,
  0x6d, 0x6c, 0x6d, 0x6e, 0x70, 0x73, 0x74, 0x74, 0x73, 0x72, 0x73, 0x75, 0x78, 0x77, 0x75, 0x74,
  0x73, 0x72, 0x72, 0x75, 0x62, 0x64, 0x63, 0x64, 0x66, 0x6b, 0x6e, 0x5e, 0x5e, 0x5e, 0x5f, 0x62,
  0x66, 0x6c, 0x67, 0x67, 0x66, 0x66, 0x67, 0x6b, 0x6f, 0x65, 0x66, 0x64, 0x66, 0x67, 0x6b, 0x6f,
  0x6f, 0x6d, 0x6d, 0x6b, 0x6d, 0x6f, 0x71, 0x73, 0x71, 0x6f, 0x6e, 0x6d, 0x6d, 0x71, 0x5c, 0x5b,
  0x5e, 0x64, 0x6c, 0x72, 0x7a, 0x5b, 0x5c, 0x60, 0x69, 0x6f, 0x75, 0x7d, 0x60, 0x60, 0x60, 0x67,
  0x6d, 0x73, 0x7a, 0x63, 0x64, 0x66, 0x6e, 0x72, 0x78, 0x7d, 0x6a, 0x67, 0x69, 0x6b, 0x71, 0x75,
  0x7b, 0x72, 0x71, 0x71, 0x75, 0x76, 0x79, 0x7e, 0x58, 0x59, 0x5b, 0x61, 0x60, 0x64, 0x69, 0x56,
  0x57, 0x5b, 0x5e, 0x61, 0x63, 0x68, 0x5e, 0x5f, 0x5f, 0x61, 0x61, 0x65, 0x6b, 0x60, 0x61, 0x62,
  0x65, 0x66, 0x68, 0x6b, 0x68, 0x66, 0x67, 0x66, 0x68, 0x6a, 0x6e, 0x71, 0x71, 0x6f, 0x6e, 0x6c,
  0x6b, 0x6e, 0x56, 0x58, 0x5b, 0x5d, 0x61, 0x65, 0x6d, 0x56, 0x57, 0x59, 0x5d, 0x62, 0x69, 0x71,
  0x5d, 0x5e, 0x5f, 0x61, 0x62, 0x67, 0x6e, 0x60, 0x61, 0x61, 0x65, 0x68, 0x6e, 0x74, 0x68, 0x65,
  0x68, 0x66, 0x6a, 0x6b, 0x71, 0x71, 0x6f, 0x6e, 0x6e, 0x6e, 0x71, 0x76, 0x56, 0x59, 0x5b, 0x5f,
  0x64, 0x69, 0x72, 0x56, 0x59, 0x5d, 0x61, 0x67, 0x70, 0x78, 0x5d, 0x5f, 0x5f, 0x62, 0x66, 0x6a,
  0x73, 0x61, 0x63, 0x65, 0x68, 0x6d, 0x74, 0x79, 0x69, 0x67, 0x69, 0x68, 0x6d, 0x70, 0x76, 0x72,
  0x71, 0x71, 0x71, 0x73, 0x75, 0x7a, 0x55, 0x57, 0x5e, 0x63, 0x68, 0x72, 0x7b, 0x56, 0x59, 0x61,
  0x66, 0x6d, 0x77, 0x7e, 0x5b, 0x5c, 0x61, 0x66, 0x6a, 0x73, 0x7c, 0x60, 0x62, 0x67, 0x6c, 0x71,
  0x79, 0x7f, 0x67, 0x63, 0x69, 0x6a, 0x6f, 0x75, 0x7d, 0x71, 0x6f, 0x71, 0x73, 0x74, 0x7a, 0x7f,
  0x5a, 0x5b, 0x63, 0x68, 0x6d, 0x75, 0x7c, 0x5c, 0x5f, 0x63, 0x69, 0x6e, 0x72, 0x78, 0x5e, 0x61,
  0x66, 0x6b, 0x6f, 0x76, 0x7d, 0x63, 0x66, 0x69, 0x6e, 0x72, 0x74, 0x79, 0x68, 0x67, 0x6d, 0x6f,
  0x73, 0x78, 0x7e, 0x72, 0x71, 0x72, 0x73, 0x75, 0x76, 0x7a, 0x62, 0x62, 0x64, 0x68, 0x6d, 0x74,
  0x79, 0x67, 0x6a, 0x6e, 0x6f, 0x71, 0x74, 0x7a, 0x66, 0x66, 0x66, 0x6b, 0x6e, 0x74, 0x7a, 0x6c,
  0x6f, 0x72, 0x73, 0x74, 0x77, 0x7b, 0x6e, 0x6b, 0x6c, 0x6e, 0x72, 0x76, 0x7b, 0x76, 0x75, 0x77,
  0x76, 0x76, 0x77, 0x7b, 0x6e, 0x70, 0x73, 0x73, 0x75, 0x74, 0x77, 0x76, 0x79, 0x79, 0x7a, 0x7a,
  0x7a, 0x7b, 0x70, 0x72, 0x73, 0x75, 0x76, 0x75, 0x78, 0x77, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b,
  0x74, 0x74, 0x76, 0x76, 0x78, 0x77, 0x79, 0x7b, 0x7b, 0x7b, 0x7c, 0x7b, 0x7b, 0x7c, 0x7d, 0x7b,
  0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x7d, 0x7b, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x7c, 0x7b, 0x7d, 0x7e,
  0x7f, 0x80, 0x80, 0x7d, 0x7b, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x7c, 0x7b, 0x7d, 0x7e, 0x7f, 0x80,
  0x80, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x83, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x89,
  0x88, 0x86, 0x85, 0x84, 0x86, 0x85, 0x82, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x86, 0x85, 0x84,
  0x84, 0x83, 0x85, 0x84, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82,
  0x85, 0x84, 0x8f, 0x8e, 0x8b, 0x8a, 0x89, 0x88, 0x84, 0x93, 0x93, 0x92, 0x8f, 0x8c, 0x89, 0x86,
  0x8d, 0x8c, 0x89, 0x89, 0x88, 0x87, 0x84, 0x8e, 0x8f, 0x8e, 0x8b, 0x8a, 0x87, 0x85, 0x88, 0x89,
  0x86, 0x87, 0x86, 0x86, 0x83, 0x85, 0x87, 0x88, 0x87, 0x87, 0x86, 0x85, 0x95, 0x94, 0x92, 0x8f,
  0x8c, 0x8a, 0x88, 0x96, 0x96, 0x92, 0x8f, 0x8d, 0x89, 0x85, 0x91, 0x91, 0x90, 0x8e, 0x8b, 0x8a,
  0x88, 0x91, 0x90, 0x8e, 0x8c, 0x8b, 0x87, 0x84, 0x8b, 0x8d, 0x8b, 0x8b, 0x89, 0x88, 0x86, 0x87,
  0x88, 0x88, 0x88, 0x88, 0x86, 0x84, 0x97, 0x97, 0x95, 0x93, 0x92, 0x8d, 0x87, 0x98, 0x97, 0x94,
  0x92, 0x8f, 0x8a, 0x86, 0x93, 0x92, 0x92, 0x91, 0x90, 0x8c, 0x87, 0x91, 0x8f, 0x8e, 0x8d, 0x8b,
  0x87, 0x85, 0x8a, 0x8d, 0x8b, 0x8c, 0x8b, 0x89, 0x85, 0x85, 0x86, 0x86, 0x87, 0x88, 0x86, 0x84,
  0x99, 0x98, 0x96, 0x95, 0x91, 0x8e, 0x8a, 0x9a, 0x9a, 0x99, 0x97, 0x96, 0x92, 0x8d, 0x94, 0x93,
  0x93, 0x92, 0x90, 0x8c, 0x89, 0x93, 0x92, 0x92, 0x90, 0x91, 0x8e, 0x8b, 0x8c, 0x8e, 0x8c, 0x8e,
  0x8b, 0x8a, 0x88, 0x86, 0x87, 0x88, 0x8a, 0x8b, 0x8b, 0x89, 0x9c, 0x9c, 0x9b, 0x98, 0x97, 0x93,
  0x8f, 0x9e, 0x9f, 0xa0, 0x9e, 0x9c, 0x99, 0x95, 0x97, 0x96, 0x97, 0x96, 0x95, 0x92, 0x8d, 0x95,
  0x95, 0x97, 0x96, 0x95, 0x93, 0x92, 0x8c, 0x8f, 0x8f, 0x90, 0x8e, 0x8d, 0x8a, 0x87, 0x88, 0x8b,
  0x8d, 0x8f, 0x90, 0x8e, 0xa2, 0xa3, 0xa4, 0xa3, 0xa1, 0x9c, 0x99, 0xa6, 0xa9, 0xab, 0xa9, 0xa6,
  0xa1, 0x9c, 0x9b, 0x9c, 0x9f, 0x9e, 0x9e, 0x99, 0x97, 0x9a, 0x9d, 0x9f, 0x9e, 0x9e, 0x9a, 0x98,
  0x90, 0x94, 0x94, 0x97, 0x96, 0x94, 0x93, 0x8a, 0x8d, 0x90, 0x93, 0x95, 0x96, 0x93, 0xaa, 0xac,
  0xaa, 0xa6, 0x9e, 0x97, 0x8e, 0xab, 0xab, 0xa8, 0xa1, 0x9b, 0x94, 0x8b, 0xa2, 0xa3, 0xa5, 0xa0,
  0x9b, 0x94, 0x8d, 0x9e, 0x9e, 0x9d, 0x97, 0x94, 0x8f, 0x89, 0x94, 0x99, 0x98, 0x98, 0x93, 0x90,
  0x8b, 0x8b, 0x8d, 0x8e, 0x8d, 0x8e, 0x8c, 0x87, 0xaf, 0xb0, 0xae, 0xac, 0xaa, 0xa7, 0xa2, 0xb7,
  0xb8, 0xb3, 0xb0, 0xac, 0xac, 0xa6, 0xa7, 0xa6, 0xa8, 0xa6, 0xa6, 0xa4, 0x9f, 0xa7, 0xa7, 0xa5,
  0xa2, 0xa1, 0xa1, 0xa0, 0x98, 0x9c, 0x9a, 0x9e, 0x9c, 0x9c, 0x99, 0x8f, 0x92, 0x93, 0x95, 0x98,
  0x9d, 0x9a, 0xbd, 0xbc, 0xb5, 0xb3, 0xb0, 0xac, 0xa2, 0xc4, 0xc5, 0xc1, 0xba, 0xb3, 0xaa, 0x9e,
  0xb1, 0xaf, 0xae, 0xab, 0xab, 0xa8, 0x9e, 0xae, 0xad, 0xae, 0xa8, 0xa6, 0x9f, 0x99, 0x9c, 0xa1,
  0x9d, 0xa1, 0x9e, 0x9f, 0x98, 0x8f, 0x93, 0x96, 0x98, 0x9a, 0x9a, 0x93, 0xc9, 0xc7, 0xc1, 0xb9,
  0xb1, 0xaa, 0x9d, 0xce, 0xce, 0xc0, 0xb9, 0xb0, 0xa2, 0x95, 0xb8, 0xb7, 0xb8, 0xb1, 0xad, 0xa7,
  0x9b, 0xb3, 0xb1, 0xad, 0xa7, 0xa3, 0x99, 0x92, 0xa1, 0xa7, 0xa4, 0xa4, 0x9f, 0x9d, 0x95, 0x92,
  0x95, 0x96, 0x97, 0x98, 0x94, 0x8e, 0x9e, 0xa3, 0xa6, 0xab, 0xac, 0xad, 0xae, 0x99, 0x9e, 0xa2,
  0xa4, 0xa5, 0xa6, 0xa6, 0x95, 0x99, 0x9d, 0x9e, 0x9f, 0xa1, 0xa1, 0x92, 0x95, 0x98, 0x9a, 0x9c,
  0x9c, 0x9d, 0x94, 0x96, 0x97, 0x99, 0x99, 0x9a, 0x9b, 0x8f, 0x90, 0x93, 0x94, 0x94, 0x95, 0x95,
  0x94, 0x97, 0x99, 0x9a, 0x99, 0x99, 0x98, 0x92, 0x94, 0x95, 0x96, 0x96, 0x95, 0x94, 0x8c, 0x8f,
  0x91, 0x91, 0x91, 0x91, 0x91, 0x8c, 0x8e, 0x8e, 0x8f, 0x8f, 0x8f, 0x8f, 0x8b, 0x8d, 0x8e, 0x8e,
  0x8f, 0x8e, 0x8e, 0x89, 0x8a, 0x8c, 0x8c, 0x8c, 0x8c, 0x8b, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81,
  0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x82, 0x85, 0x8d, 0x8b, 0x8a, 0x8a, 0x8d, 0x8b, 0x87,
  0x8b, 0x8c, 0x8c, 0x8d, 0x8f, 0x8a, 0x85, 0x87, 0x87, 0x85, 0x85, 0x87, 0x88, 0x81, 0x7e, 0x7f,
  0x7e, 0x7d, 0x7c, 0x7c, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x83, 0x86, 0x8a, 0x86, 0x86,
  0x88, 0x85, 0x86, 0x89, 0x8b, 0x8a, 0x8b, 0x8b, 0x8d, 0x8a, 0x88, 0x89, 0x8a, 0x8b, 0x8b, 0x8c,
  0x88, 0x8a, 0x8b, 0x85, 0x87, 0x88, 0x86, 0x80, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x80, 0x7e,
  0x7b, 0x80, 0x7e, 0x7a, 0x7f, 0x82, 0x81, 0x82, 0x85, 0x85, 0x85, 0x88, 0xb0, 0xa8, 0xa2, 0x9c,
  0x97, 0x93, 0x8e, 0xa9, 0xa3, 0x9e, 0x9b, 0x97, 0x94, 0x90, 0x91, 0x8e, 0x8c, 0x8b, 0x8a, 0x89,
  0x87, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x68, 0x6c, 0x70, 0x72, 0x73, 0x75, 0x77, 0x68,
  0x6c, 0x6d, 0x72, 0x74, 0x75, 0x78, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x8a, 0x88, 0x86,
  0x85, 0x84, 0x83, 0x82, 0x9b, 0x98, 0x95, 0x91, 0x8e, 0x8c, 0x89, 0xaa, 0xa3, 0x9f, 0x99, 0x95,
  0x91, 0x8d, 0x86, 0x89, 0x8e, 0x88, 0x8b, 0x8e, 0x91, 0x86, 0x89, 0x8d, 0x87, 0x8a, 0x8d, 0x8f,
  0x8e, 0x90, 0x90, 0x8f, 0x91, 0x93, 0x95, 0x8a, 0x8f, 0x91, 0x8d, 0x90, 0x92, 0x93, 0x88, 0x88,
  0x8c, 0x84, 0x86, 0x89, 0x8b, 0x85, 0x88, 0x84, 0x80, 0x83, 0x85, 0x87, 0x82, 0x80, 0x7e, 0x80,
  0x7f, 0x7e, 0x7d, 0x7f, 0x7c, 0x7c, 0x7c, 0x7a, 0x79, 0x78, 0x81, 0x80, 0x7d, 0x82, 0x80, 0x7f,
  0x7e, 0x83, 0x80, 0x82, 0x84, 0x82, 0x83, 0x80, 0x84, 0x85, 0x86, 0x87, 0x87, 0x88, 0x88, 0x8a,
  0x88, 0x8d, 0x8f, 0x8f, 0x90, 0x90
};

#endif // __CDRCOLORPALETTES_H__
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
