/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_CONTROL_H
#define QT_BAMF_CONTROL_H

#include <QtCore/QObject>

class OrgAyatanaBamfControlInterface;

class __attribute__ ((visibility ("default"))) BamfControl: public QObject
{
    Q_OBJECT

public:
    static BamfControl& get_default()
    {
        static BamfControl instance;
        return instance;
    }

private:
    BamfControl();
    BamfControl(BamfControl const&);
    void operator=(BamfControl const&);
    ~BamfControl();

    OrgAyatanaBamfControlInterface *m_proxy;

public:
    void insert_desktop_file(const QString &desktop_file) const;
    void register_application_for_pid(const QString &application, int pid) const;
};

#endif

