//
//                         __ __ __ __   __ __ __ __   __ __ __ __   __ __ __ __
//                        /_//_//_//_/\ /_//_//_//_/\ /_//_//_//_/\ /_//_//_//_/\
//                        \_/_//_/\\_\/ \_/_//_/\\_\//_/\\_\\_\\_\//_/\\_\\_/_/\/
//                         /_//_/\/      /_//_/\/   /_/\/ __      /_/\/ __ /_/\/
//                        /_//_/\/      /_//_/\/   /_//_//_/\    /_//_//_//_/\/
//                       /_//_/\/      /_//_/\/   /_/\\_\\_\/   /_/\\_\\_\\_\/
//                   __ /_//_/\/   __ /_//_/\/   /_/\/ __ __   /_/\/
//                  /_//_//_//_/\ /_//_//_//_/\ /_//_//_//_/\ /_/\/
//                  \_\\_\\_\\_\/ \_\\_\\_\\_\/ \_\\_\\_\\_\/ \_\/
//                                                    
//
//                     ..::  Interactive Internet Entertainment Platform  ::..
//
//                         (C) 2000-2006, FAN YI PENG. ALL RIGHTS RESERVED
//
// ________________________________________________________________________________________________
//
/// @file  IIEP_Def.H
/// @brief 
// ________________________________________________________________________________________________
//
//
//                               _____________________________________
//                              |                                     |
//                              |                DATA                 |
// _____________________________|_____________________________________|____________________________
//
//                                            __________
// __________________________________________|  CONFIG  |__________________________________________

#pragma once

#ifdef _DEBUG
  #pragma comment(lib, "IIEP_DBG.LIB")
#else
  #pragma comment(lib, "IIEP.LIB")
#endif

// ____________________________________________ CONFIG ____________________________________________
//
//                                            __________
// __________________________________________|  DEFINE  |__________________________________________
//
//      _____________
// ____/  Data Type  \_____________________________________________________________________________

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
typedef __int64        QWORD;

typedef BYTE  *PBYTE;
typedef WORD  *PWORD;
typedef DWORD *PDWORD;
typedef QWORD *PQWORD;

typedef void *PVOID;

// ______ Data Type _______________________________________________________________________________
//
//      ___________
// ____/  Release  \_______________________________________________________________________________

#define SAFE_DELETE(p)       if (p) { delete (p);       (p) = 0; }
#define SAFE_DELETE_ARRAY(p) if (p) { delete[] (p);     (p) = 0; }
#define SAFE_RELEASE(p)	     if (p) { (p) -> Release(); (p) = 0; }

// ______ Release _________________________________________________________________________________
//
//      __________
// ____/  Assert  \________________________________________________________________________________

#ifndef ASSERT
  #ifdef _DEBUG
    namespace IIEP { bool AssertFunction(bool, long, const char *, const char *); }
    #define ASSERT(expression) \
    if (IIEP::AssertFunction((bool) (expression), __LINE__, __FILE__, __FUNCTION__)) {_asm {int 3}}
  #else
    #define ASSERT(expression)
  #endif
#endif

// ______ Assert __________________________________________________________________________________
//
//      _______
// ____/  LOG  \___________________________________________________________________________________

namespace IIEP
{
  void DebugLog(const char *pcszFormat, ...);
  void DebugLog(const WORD *pcwsFormat, ...);

  void WriteLog(const char *pcszFormat, ...);
  void WriteLog(const WORD *pcwsFormat, ...);
}

// ______ LOG _____________________________________________________________________________________
//
//      ________
// ____/  TODO  \__________________________________________________________________________________

#ifdef _DEBUG
  #define TODO \
  IIEP::DebugLog("\n[TODO] %d: \"%s\"- %s()\n~~~~~~\n", __LINE__, __FILE__, __FUNCTION__);
  #define ToDo(x) \
  IIEP::DebugLog("\n[TODO] %d: \"%s\"- %s(): %s\n~~~~~~\n", __LINE__, __FILE__, __FUNCTION__, (x));
#else
  #define TODO
  #define ToDo(x)
#endif

// ______ TODO ____________________________________________________________________________________
//
//      ________
// ____/  Path  \__________________________________________________________________________________

namespace IIEP
{
  void ResetToExePath(void);
}

// ______ Path ____________________________________________________________________________________
//
//      __________
// ____/  CMutex  \________________________________________________________________________________

namespace IIEP
{
  class CMutex
  {
    public:

    CMutex(void) { m_bLocked = false; }
    ~CMutex(void) {}

    void Lock(void);
    void Unlock(void) { m_bLocked = false; }
    void Set(void)    { m_bLocked = true;  }
    void Wait(void);

    bool IsLock(void) const { return m_bLocked; }

    private:

    volatile bool m_bLocked;
  };
}

// ______ CMutex __________________________________________________________________________________
//
//      _________
// ____/  SRect  \_________________________________________________________________________________

namespace IIEP
{
  /// @brief νṹ

  struct SRect
  {
    SRect(void) {}

    SRect(long nX, long nY, long nWidth, long nHeight)
    {
      m_nX      = nX;
      m_nY      = nY;
      m_nWidth  = nWidth;
      m_nHeight = nHeight;
    }

    // -------------------------------------------------------------------------------------------

    void Set(long nX, long nY, long nWidth, long nHeight)
    {
      m_nX      = nX;
      m_nY      = nY;
      m_nWidth  = nWidth;
      m_nHeight = nHeight;
    }

    // -------------------------------------------------------------------------------------------

    long m_nX;      ///< Ͻ X 
    long m_nY;      ///< Ͻ Y 
    long m_nWidth;  ///< ο
    long m_nHeight; ///< θ߶
  };
}

// ______ SRect ___________________________________________________________________________________
//
//      ___________________________
// ____/  Sample Grabber CallBack  \_______________________________________________________________

namespace IIEP
{
  typedef void (*CALLBACK_SampleGrabberBuffer) (PVOID, DWORD);
}

// ______ Sample Grabber CallBack _________________________________________________________________
//
// ____________________________________________ DEFINE ____________________________________________
//
// ____________________________________________________________________________________ DATA ______
//
// ___________________________________________ FILE END ___________________________________________