// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    ffi, ContentFormats, ContentProvider, Device, Display, DragAction, DragCancelReason, Surface,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GdkDrag")]
    pub struct Drag(Object<ffi::GdkDrag>);

    match fn {
        type_ => || ffi::gdk_drag_get_type(),
    }
}

impl Drag {
    pub const NONE: Option<&'static Drag> = None;

    #[doc(alias = "gdk_drag_begin")]
    pub fn begin(
        surface: &impl IsA<Surface>,
        device: &impl IsA<Device>,
        content: &impl IsA<ContentProvider>,
        actions: DragAction,
        dx: f64,
        dy: f64,
    ) -> Option<Drag> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_drag_begin(
                surface.as_ref().to_glib_none().0,
                device.as_ref().to_glib_none().0,
                content.as_ref().to_glib_none().0,
                actions.into_glib(),
                dx,
                dy,
            ))
        }
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Drag>> Sealed for T {}
}

pub trait DragExt: IsA<Drag> + sealed::Sealed + 'static {
    #[doc(alias = "gdk_drag_drop_done")]
    fn drop_done(&self, success: bool) {
        unsafe {
            ffi::gdk_drag_drop_done(self.as_ref().to_glib_none().0, success.into_glib());
        }
    }

    #[doc(alias = "gdk_drag_get_actions")]
    #[doc(alias = "get_actions")]
    fn actions(&self) -> DragAction {
        unsafe { from_glib(ffi::gdk_drag_get_actions(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_get_content")]
    #[doc(alias = "get_content")]
    fn content(&self) -> ContentProvider {
        unsafe { from_glib_none(ffi::gdk_drag_get_content(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_get_device")]
    #[doc(alias = "get_device")]
    fn device(&self) -> Device {
        unsafe { from_glib_none(ffi::gdk_drag_get_device(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> Display {
        unsafe { from_glib_none(ffi::gdk_drag_get_display(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_get_drag_surface")]
    #[doc(alias = "get_drag_surface")]
    fn drag_surface(&self) -> Option<Surface> {
        unsafe {
            from_glib_none(ffi::gdk_drag_get_drag_surface(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_drag_get_formats")]
    #[doc(alias = "get_formats")]
    fn formats(&self) -> ContentFormats {
        unsafe { from_glib_none(ffi::gdk_drag_get_formats(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_get_selected_action")]
    #[doc(alias = "get_selected_action")]
    #[doc(alias = "selected-action")]
    fn selected_action(&self) -> DragAction {
        unsafe {
            from_glib(ffi::gdk_drag_get_selected_action(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_drag_get_surface")]
    #[doc(alias = "get_surface")]
    fn surface(&self) -> Surface {
        unsafe { from_glib_none(ffi::gdk_drag_get_surface(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_drag_set_hotspot")]
    fn set_hotspot(&self, hot_x: i32, hot_y: i32) {
        unsafe {
            ffi::gdk_drag_set_hotspot(self.as_ref().to_glib_none().0, hot_x, hot_y);
        }
    }

    fn set_actions(&self, actions: DragAction) {
        ObjectExt::set_property(self.as_ref(), "actions", actions)
    }

    #[doc(alias = "selected-action")]
    fn set_selected_action(&self, selected_action: DragAction) {
        ObjectExt::set_property(self.as_ref(), "selected-action", selected_action)
    }

    #[doc(alias = "cancel")]
    fn connect_cancel<F: Fn(&Self, DragCancelReason) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cancel_trampoline<
            P: IsA<Drag>,
            F: Fn(&P, DragCancelReason) + 'static,
        >(
            this: *mut ffi::GdkDrag,
            reason: ffi::GdkDragCancelReason,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Drag::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(reason),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cancel\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    cancel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "dnd-finished")]
    fn connect_dnd_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn dnd_finished_trampoline<P: IsA<Drag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDrag,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Drag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"dnd-finished\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    dnd_finished_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drop-performed")]
    fn connect_drop_performed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drop_performed_trampoline<P: IsA<Drag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDrag,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Drag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drop-performed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drop_performed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "actions")]
    fn connect_actions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_actions_trampoline<P: IsA<Drag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDrag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Drag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::actions\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_actions_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "display")]
    fn connect_display_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_display_trampoline<P: IsA<Drag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDrag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Drag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::display\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_display_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selected-action")]
    fn connect_selected_action_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selected_action_trampoline<
            P: IsA<Drag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GdkDrag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Drag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selected-action\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selected_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Drag>> DragExt for O {}
