## RabbitMQ 3.8.1

RabbitMQ `3.8.1` is a maintenance release that focuses on bug fixes.

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.x` series is recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release from `3.7.6` or an older version, extra care has to be taken.

Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded at the same time as Erlang**. Alternatively the node can be upgraded
to `3.7.18` first, then Erlang 21.x or 22.x, then to RabbitMQ 3.8.x.

#### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Rolling cluster upgrade could fail if new versions were deployed to all cluster nodes at once instead
   of a rolling upgrade-then-restart for each node individually.

   GitHub issue: [rabbitmq/rabbitmq-server#2132](https://github.com/rabbitmq/rabbitmq-server/issues/2132)

 * Avoid pattern expansion when logging connection closure reason.

   GitHub issue: [rabbitmq/rabbitmq-server#2155](https://github.com/rabbitmq/rabbitmq-server/pull/2155)

 * Improved error handling in a module that continuously registers the node with [epmd](https://www.rabbitmq.com/clustering.html) avoids
   log noise.

   GitHub issue: [rabbitmq/rabbitmq-server#2130](https://github.com/rabbitmq/rabbitmq-server/issues/2130)

#### Enhancements

 * Peak [quorum queue](https://www.rabbitmq.com/quorum-queues.html) memory usage was reduced by up to 25% on some workloads.

   GitHub issue: [rabbitmq/rabbitmq-server#2138](https://github.com/rabbitmq/rabbitmq-server/pull/2138)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl await_startup` failed with an exception when effective timeout was set to `infinity`.

   GitHub issue: [rabbitmq/rabbitmq-server#2144](https://github.com/rabbitmq/rabbitmq-server/pull/2144)

 * `rabbitmq-diagnostics check_port_connectivity` produced a false positive in an IPv6-only environment.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-cli#385](https://github.com/rabbitmq/rabbitmq-cli/pull/385)

 * `rabbitmq-diagnostics list_unresponsive_queues` failed in environments that had quorum queues.

   GitHub issue: [rabbitmq/rabbitmq-cli#386](https://github.com/rabbitmq/rabbitmq-cli/issues/386)

 * `rabbitmq-diagnostics status`, `rabbitmq-diagnostics cluster_status`, `rabbitmq-diagnostics listeners` now support
   `--formatter=erlang` (raw Erlang data structure output)

   GitHub issue: [rabbitmq/rabbitmq-cli#383](https://github.com/rabbitmq/rabbitmq-cli/issues/383)

#### Enhancements

 * `rabbitmq-diagnostics consume_event_stream` is a new command that makes it easier to consume a stream
   of internal commands. This can be useful for troubleshooting and auditing. Previously this was only
   possible via the [rabbitmq-event-exchange](https://github.com/rabbitmq/rabbitmq-event-exchange) plugin.

   GitHub issue: [rabbitmq/rabbitmq-cli#299](https://github.com/rabbitmq/rabbitmq-cli/issues/299)

 * `rabbitmq-diagnostics check_certificate_expiration` is a new [health check](https://www.rabbitmq.com/monitoring.html#health-checks) command
   that fails when any of the certificates used by target node expire within a specified time window.

   `rabbitmq-diagnostics certificates` is its diagnostics (informative) counterpart that displays all CA and leaf certificates
   used by target node.

   GitHub issue: [rabbitmq/rabbitmq-cli#305](https://github.com/rabbitmq/rabbitmq-cli/issues/305)


### Prometheus Plugin

#### Bug Fixes

 * Prometheus scraping API endpoint was unreasonably strict about the set of content types it accepts from clients,
   which caused Telegraf Prometheus input requests to fail with an`406 Not Acceptable` response.

   GitHub issue: [rabbitmq/rabbitmq-prometheus#12](https://github.com/rabbitmq/rabbitmq-prometheus/issues/12)


### Management Plugin

#### Bug Fixes

 * Some metrics were omitted in the UI for queues that did not have `x-queue-type` set.

   GitHub issue: [rabbitmq/rabbitmq-management#741](https://github.com/rabbitmq/rabbitmq-management/issues/741)


### LDAP Plugin

#### Enhancements

 * Errors were not propagated back to the client correctly in case of an LDAP server authentication failure.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#116](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/116)


### Kubernetes Peer Discovery Plugin

#### Bug Fixes

 * Requests to Kubernetes API endpoints failed with an `nxdomain` (domain name resolution failure)
   in an IPv6-only environment.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-k8s#55](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s/issues/55)


### Consul Peer Discovery Plugin

#### Enhancements

 * It is now possible to specify service metadata values:

   ``` ini
   cluster_formation.consul.svc_meta.key1 = value1
   cluster_formation.consul.svc_meta.key2 = value2
   ```

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-consul#34](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/34)


### MQTT Plugin

 * Client ID tracking is now more resilient to node failures and decomissioning.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#213](https://github.com/rabbitmq/rabbitmq-mqtt/issues/213)


### STOMP Plugin

#### Enhancements

 * The [`x-queue-type` header](https://www.rabbitmq.com/quorum-queues.html) is now accepted from STOMP clients.

   GitHub issue: [rabbitmq/rabbitmq-stomp#138](https://github.com/rabbitmq/rabbitmq-stomp/issues/138)

#### Bug Fixes

 * `stomp.hide_server` is now available in the new style configuration format.

   GitHub issue: [rabbitmq/rabbitmq-stomp#140](https://github.com/rabbitmq/rabbitmq-stomp/issues/140)


### Web STOMP Plugin

#### Bug Fixes

 * The plugin emitted a warning on start.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#115](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/115)


### Web MQTT Plugin

#### Bug Fixes

 * The plugin emitted a warning on start.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#59](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/59)


### Erlang Client

#### Bug Fixes

 * Connection could not be restarted after a heartbeat timeout due to strict pattern matching.

   Contributed by Giuseppe D'Anna (@larrywax).

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#126](https://github.com/rabbitmq/rabbitmq-erlang-client/pull/126)


### Tracing Plugin

#### Bug Fixes

 * On Windows, deleting the file used by an active (running) trace resulted in an `EACCES` exception.

   GitHub issue: [rabbitmq/rabbitmq-tracing#31](https://github.com/rabbitmq/rabbitmq-tracing/issues/31)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.8.1.tar.xz`.
