## RabbitMQ 3.7.26

RabbitMQ `3.7.26` is a maintenance release. It focuses on bug fixes and usability
improvements.

RabbitMQ `3.7.x` series are out of general support and covered by the [limited extended support](https://www.rabbitmq.com/versions.html) policy.

Please consider [upgrading](https://www.rabbitmq.com/upgrade.html) to [RabbitMQ `3.8.x`](https://www.rabbitmq.com/changelog.html).

### Erlang/OTP Compatibility Notes

This release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Previously recent `3.7.x` nodes could start on Erlang 20.3 and to some extent tested on it despite
the Erlang `21.3+` requirements in release notes and documentation.

Starting with this release, `21.3+` is a **hard requirement** enforced in the code
to [ensure forward compatibility with Erlang 23](https://github.com/rabbitmq/rabbitmq-server/pull/2269).

Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.
[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Federation Plugin

#### Enhancements

 * "Command" operations such as binding propagation now use a separate channel for all links, preventing latency
   spikes for asynchronous operations (such as message publishing) (a head-of-line blocking problem).

   Contributed by Grigory Starinkin.

   GitHub issue: [rabbitmq/rabbitmq-federation#97](https://github.com/rabbitmq/rabbitmq-federation/pull/97)

### Management Plugin

#### Bug Fixes

 * `rabbitmqadmin` failed with an exception on Python 3 when `-f pretty_json` flag was used.

   GitHub issue: [rabbitmq/rabbitmq-management#794](https://github.com/rabbitmq/rabbitmq-management/issues/794)


### Shovel Plugin

#### Bug Fixes

 * AMQP 1.0 client used by Shovel now correctly encodes Erlang atoms.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#45](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/45)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.26.tar.xz`.
