/* pkcs11-token.c generated by valac 0.28.0, the Vala compiler
 * generated from pkcs11-token.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-pkcs11.h"
#include <gck/gck.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <p11-kit/pkcs11.h>
#include <gcr/gcr-base.h>
#include "libseahorse/seahorse-util.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GckTokenInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckTokenInfo_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SeahorsePkcs11TokenLockData SeahorsePkcs11TokenLockData;
typedef struct _SeahorsePkcs11TokenUnlockData SeahorsePkcs11TokenUnlockData;
#define __vala_GckAttributes_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckAttributes_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_GckSessionInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckSessionInfo_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GckAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckAttribute_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_GckBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckBuilder_free (var), NULL)))
typedef struct _SeahorsePkcs11TokenLoadData SeahorsePkcs11TokenLoadData;
#define __vala_GckUriData_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckUriData_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorsePkcs11TokenPrivate {
	GckSlot* _slot;
	gchar* _uri;
	GckTokenInfo* _info;
	GArray* _mechanisms;
	GckSession* _session;
	GHashTable* _object_for_handle;
	GHashTable* _objects_for_id;
	GHashTable* _id_for_object;
	GHashTable* _objects_visible;
};

struct _SeahorsePkcs11TokenLockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorsePkcs11Token* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GckSession* _tmp0_;
	gboolean _tmp1_;
	GckSession* _tmp2_;
	GCancellable* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _SeahorsePkcs11TokenUnlockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorsePkcs11Token* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GckSession* _tmp0_;
	gboolean _tmp1_;
	GckSession* _tmp2_;
	gboolean _tmp3_;
	GckSession* _tmp4_;
	GTlsInteraction* _tmp5_;
	GCancellable* _tmp6_;
	gboolean _tmp7_;
	GckSessionOptions options;
	GckSessionOptions _tmp8_;
	GckSession* _tmp9_;
	GckSlot* _tmp10_;
	GckSessionOptions _tmp11_;
	GCancellable* _tmp12_;
	GckSession* _tmp13_;
	GckSession* _tmp14_;
	GError * _inner_error_;
};

struct _SeahorsePkcs11TokenLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorsePkcs11Token* self;
	GCancellable* cancellable;
	gboolean result;
	GHashTable* checks;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GList* object_collection;
	GList* object_it;
	GObject* object;
	gulong handle;
	GObject* _tmp4_;
	gulong _tmp5_;
	gulong _tmp6_;
	GHashTable* _tmp7_;
	gulong _tmp8_;
	gulong* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	GckSession* _tmp12_;
	GckSessionOptions options;
	GckSessionOptions _tmp13_;
	GckSession* _tmp14_;
	GckSlot* _tmp15_;
	GckSessionOptions _tmp16_;
	GCancellable* _tmp17_;
	GckSession* _tmp18_;
	GckSession* _tmp19_;
	GckBuilder* builder;
	GckBuilder* _tmp20_;
	GckBuilder* _tmp21_;
	GckBuilder* _tmp22_;
	GckEnumerator* enumerator;
	GckSession* _tmp23_;
	GckBuilder* _tmp24_;
	GckAttributes* _tmp25_;
	GckEnumerator* _tmp26_;
	GckEnumerator* _tmp27_;
	GckBuilder* _tmp28_;
	GckBuilder* _tmp29_;
	GckBuilder* _tmp30_;
	GckEnumerator* chained;
	GckSession* _tmp31_;
	GckBuilder* _tmp32_;
	GckAttributes* _tmp33_;
	GckEnumerator* _tmp34_;
	GckEnumerator* _tmp35_;
	GckEnumerator* _tmp36_;
	GckEnumerator* _tmp37_;
	gboolean _tmp38_;
	GList* objects;
	GckEnumerator* _tmp39_;
	GCancellable* _tmp40_;
	GList* _tmp41_;
	GList* _tmp42_;
	GHashTable* _tmp43_;
	GList* _tmp44_;
	GList* _tmp45_;
	GList* _tmp46_;
	GList* _tmp47_;
	GList* _vala1_object_collection;
	GList* _vala1_object_it;
	GckModule* _tmp48_;
	GckModule* _vala1_object;
	gulong _vala1_handle;
	GckModule* _tmp49_;
	gulong _tmp50_;
	gulong _tmp51_;
	GHashTable* _tmp52_;
	gulong _tmp53_;
	GError * _inner_error_;
};


static gpointer seahorse_pkcs11_token_parent_class = NULL;
static GcrCollectionIface* seahorse_pkcs11_token_gcr_collection_parent_iface = NULL;
static SeahorsePlaceIface* seahorse_pkcs11_token_seahorse_place_parent_iface = NULL;
static SeahorseLockableIface* seahorse_pkcs11_token_seahorse_lockable_parent_iface = NULL;

#define SEAHORSE_PKCS11_TOKEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11TokenPrivate))
enum  {
	SEAHORSE_PKCS11_TOKEN_DUMMY_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_UNLOCKABLE,
	SEAHORSE_PKCS11_TOKEN_LOCKABLE,
	SEAHORSE_PKCS11_TOKEN_INFO,
	SEAHORSE_PKCS11_TOKEN_SESSION,
	SEAHORSE_PKCS11_TOKEN_SLOT,
	SEAHORSE_PKCS11_TOKEN_LABEL,
	SEAHORSE_PKCS11_TOKEN_DESCRIPTION,
	SEAHORSE_PKCS11_TOKEN_URI,
	SEAHORSE_PKCS11_TOKEN_ICON,
	SEAHORSE_PKCS11_TOKEN_ACTIONS,
	SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS,
	SEAHORSE_PKCS11_TOKEN_MECHANISMS
};
static void _vala_GckTokenInfo_free (GckTokenInfo* self);
static void seahorse_pkcs11_token_real_dispose (GObject* base);
static void seahorse_pkcs11_token_real_lock_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_lock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_lock_co (SeahorsePkcs11TokenLockData* _data_);
static gboolean seahorse_pkcs11_token_is_session_logged_in (GckSession* session);
static void seahorse_pkcs11_token_lock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_pkcs11_token_real_unlock_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_unlock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_unlock_co (SeahorsePkcs11TokenUnlockData* _data_);
static void seahorse_pkcs11_token_unlock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GckSessionOptions seahorse_pkcs11_token_calculate_session_options (SeahorsePkcs11Token* self);
static gboolean seahorse_pkcs11_token_real_contains (GcrCollection* base, GObject* object);
static guint seahorse_pkcs11_token_real_get_length (GcrCollection* base);
static GList* seahorse_pkcs11_token_real_get_objects (GcrCollection* base);
static GckTokenInfo* seahorse_pkcs11_token_ensure_token_info (SeahorsePkcs11Token* self);
static void _vala_GckAttributes_free (GckAttributes* self);
static void seahorse_pkcs11_token_remove_objects (SeahorsePkcs11Token* self, GList* objects);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_GckSessionInfo_free (GckSessionInfo* self);
static void seahorse_pkcs11_token_update_token_info (SeahorsePkcs11Token* self);
static GckTokenInfo* _vala_GckTokenInfo_copy (GckTokenInfo* self);
static void seahorse_pkcs11_token_update_id_map (SeahorsePkcs11Token* self, GObject* object, GckAttribute* id);
static GckAttribute* _vala_GckAttribute_copy (GckAttribute* self);
static void _vala_GckAttribute_free (GckAttribute* self);
static GObject* seahorse_pkcs11_token_lookup_id_map (SeahorsePkcs11Token* self, GType object_type, GckAttribute* id);
static void seahorse_pkcs11_token_update_visibility (SeahorsePkcs11Token* self, GList* objects, gboolean visible);
static gboolean seahorse_pkcs11_token_make_certificate_key_pair (SeahorsePkcs11Certificate* certificate, SeahorsePkcs11PrivateKey* private_key);
static GObject* seahorse_pkcs11_token_break_certificate_key_pair (GObject* object);
static void seahorse_pkcs11_token_receive_objects (SeahorsePkcs11Token* self, GList* objects);
static gulong* _ulong_dup (gulong* self);
static void seahorse_pkcs11_token_real_load_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_load (SeahorsePlace* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_load_co (SeahorsePkcs11TokenLoadData* _data_);
static void _g_free0_ (gpointer var);
static void seahorse_pkcs11_token_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_GckBuilder_free (GckBuilder* self);
static GObject * seahorse_pkcs11_token_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static guint _gck_attribute_hash_ghash_func (gconstpointer key);
static gboolean _gck_attribute_equal_gequal_func (gconstpointer a, gconstpointer b);
static void __vala_GckAttribute_free0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _vala_GckUriData_free (GckUriData* self);
static void seahorse_pkcs11_token_finalize (GObject* obj);
static void _vala_seahorse_pkcs11_token_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_pkcs11_token_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GckTokenInfo_free (GckTokenInfo* self) {
	g_boxed_free (gck_token_info_get_type (), self);
}


SeahorsePkcs11Token* seahorse_pkcs11_token_construct (GType object_type, GckSlot* slot) {
	SeahorsePkcs11Token * self = NULL;
	GckSlot* _tmp0_ = NULL;
	g_return_val_if_fail (slot != NULL, NULL);
	_tmp0_ = slot;
	self = (SeahorsePkcs11Token*) g_object_new (object_type, "slot", _tmp0_, NULL);
	return self;
}


SeahorsePkcs11Token* seahorse_pkcs11_token_new (GckSlot* slot) {
	return seahorse_pkcs11_token_construct (SEAHORSE_PKCS11_TYPE_TOKEN, slot);
}


static void seahorse_pkcs11_token_real_dispose (GObject* base) {
	SeahorsePkcs11Token * self;
	self = (SeahorsePkcs11Token*) base;
	_g_object_unref0 (self->priv->_slot);
	self->priv->_slot = NULL;
	_g_object_unref0 (self->priv->_session);
	self->priv->_session = NULL;
}


static void seahorse_pkcs11_token_real_lock_data_free (gpointer _data) {
	SeahorsePkcs11TokenLockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenLockData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void seahorse_pkcs11_token_real_lock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenLockData* _data_;
	SeahorsePkcs11Token* _tmp0_ = NULL;
	GTlsInteraction* _tmp1_ = NULL;
	GTlsInteraction* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenLockData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_pkcs11_token_real_lock);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_pkcs11_token_real_lock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = interaction;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_pkcs11_token_real_lock_co (_data_);
}


static gboolean seahorse_pkcs11_token_real_lock_finish (SeahorseLockable* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorsePkcs11TokenLockData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_pkcs11_token_lock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorsePkcs11TokenLockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_lock_co (_data_);
}


static gboolean seahorse_pkcs11_token_real_lock_co (SeahorsePkcs11TokenLockData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_session;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = seahorse_pkcs11_token_is_session_logged_in (_data_->_tmp0_);
	if (!_data_->_tmp1_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->_session;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	_data_->_state_ = 1;
	gck_session_logout_async (_data_->_tmp2_, _data_->_tmp3_, seahorse_pkcs11_token_lock_ready, _data_);
	return FALSE;
	_state_1:
	gck_session_logout_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->cancellable;
	_data_->_state_ = 2;
	seahorse_place_load ((SeahorsePlace*) _data_->self, _data_->_tmp5_, seahorse_pkcs11_token_lock_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = seahorse_place_load_finish ((SeahorsePlace*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp4_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp4_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void seahorse_pkcs11_token_real_unlock_data_free (gpointer _data) {
	SeahorsePkcs11TokenUnlockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenUnlockData, _data_);
}


static void seahorse_pkcs11_token_real_unlock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenUnlockData* _data_;
	SeahorsePkcs11Token* _tmp0_ = NULL;
	GTlsInteraction* _tmp1_ = NULL;
	GTlsInteraction* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenUnlockData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_pkcs11_token_real_unlock);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_pkcs11_token_real_unlock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = interaction;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_pkcs11_token_real_unlock_co (_data_);
}


static gboolean seahorse_pkcs11_token_real_unlock_finish (SeahorseLockable* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorsePkcs11TokenUnlockData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_pkcs11_token_unlock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorsePkcs11TokenUnlockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_unlock_co (_data_);
}


static gboolean seahorse_pkcs11_token_real_unlock_co (SeahorsePkcs11TokenUnlockData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_session;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = seahorse_pkcs11_token_is_session_logged_in (_data_->_tmp0_);
	if (_data_->_tmp1_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->_session;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->_session;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->interaction;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->cancellable;
		_data_->_state_ = 1;
		gck_session_login_interactive_async (_data_->_tmp4_, CKU_USER, _data_->_tmp5_, _data_->_tmp6_, seahorse_pkcs11_token_unlock_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = gck_session_login_interactive_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp3_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp3_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = seahorse_pkcs11_token_calculate_session_options (_data_->self);
		_data_->options = _data_->_tmp8_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->priv->_slot;
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = _data_->options;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->cancellable;
		_data_->_state_ = 2;
		gck_slot_open_session_async (_data_->_tmp10_, _data_->_tmp11_ | GCK_SESSION_LOGIN_USER, _data_->_tmp12_, seahorse_pkcs11_token_unlock_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = gck_slot_open_session_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_object_unref0 (_data_->self->priv->_session);
		_data_->self->priv->_session = _data_->_tmp14_;
		_data_->result = TRUE;
		_g_object_unref0 (_data_->_tmp9_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean seahorse_pkcs11_token_real_contains (GcrCollection* base, GObject* object) {
	SeahorsePkcs11Token * self;
	gboolean result = FALSE;
	GHashTable* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = self->priv->_objects_visible;
	_tmp1_ = object;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	result = ((GObject*) _tmp2_) != NULL;
	return result;
}


static guint seahorse_pkcs11_token_real_get_length (GcrCollection* base) {
	SeahorsePkcs11Token * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_objects_visible;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = _tmp1_;
	return result;
}


static GList* seahorse_pkcs11_token_real_get_objects (GcrCollection* base) {
	SeahorsePkcs11Token * self;
	GList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_objects_visible;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}


static void _vala_GckAttributes_free (GckAttributes* self) {
	g_boxed_free (gck_attributes_get_type (), self);
}


gboolean seahorse_pkcs11_token_is_deletable (SeahorsePkcs11Token* self, GckObject* object) {
	gboolean result = FALSE;
	GckTokenInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GckAttributes* attributes = NULL;
	GckObject* _tmp2_ = NULL;
	GckAttributes* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = _tmp0_->flags;
	if ((_tmp1_ & CKF_WRITE_PROTECTED) == CKF_WRITE_PROTECTED) {
		result = FALSE;
		return result;
	}
	_tmp2_ = object;
	g_object_get ((GObject*) _tmp2_, "attributes", &attributes, NULL);
	_tmp3_ = attributes;
	if (_tmp3_ != NULL) {
		gboolean ret = FALSE;
		GckAttributes* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		ret = TRUE;
		_tmp4_ = attributes;
		gck_attributes_find_boolean (_tmp4_, CKA_MODIFIABLE, &_tmp5_);
		ret = _tmp5_;
		result = ret;
		__vala_GckAttributes_free0 (attributes);
		return result;
	}
	result = FALSE;
	__vala_GckAttributes_free0 (attributes);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void seahorse_pkcs11_token_remove_object (SeahorsePkcs11Token* self, GckObject* object) {
	GList* objects = NULL;
	GckObject* _tmp0_ = NULL;
	GckObject* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	objects = NULL;
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	objects = g_list_append (objects, _tmp1_);
	seahorse_pkcs11_token_remove_objects (self, objects);
	__g_list_free__g_object_unref0_0 (objects);
}


gboolean seahorse_pkcs11_token_has_mechanism (SeahorsePkcs11Token* self, gulong mechanism) {
	gboolean result = FALSE;
	GArray* _tmp0_ = NULL;
	GArray* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = seahorse_pkcs11_token_get_mechanisms (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = mechanism;
	_tmp3_ = gck_mechanisms_check (_tmp1_, _tmp2_, GCK_INVALID, NULL);
	result = _tmp3_;
	return result;
}


static void _vala_GckSessionInfo_free (GckSessionInfo* self) {
	g_boxed_free (gck_session_info_get_type (), self);
}


static gboolean seahorse_pkcs11_token_is_session_logged_in (GckSession* session) {
	gboolean result = FALSE;
	GckSession* _tmp0_ = NULL;
	GckSessionInfo* info = NULL;
	GckSession* _tmp1_ = NULL;
	GckSessionInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GckSessionInfo* _tmp4_ = NULL;
	_tmp0_ = session;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = session;
	_tmp2_ = gck_session_get_info (_tmp1_);
	info = _tmp2_;
	_tmp4_ = info;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GckSessionInfo* _tmp7_ = NULL;
		gulong _tmp8_ = 0UL;
		_tmp7_ = info;
		_tmp8_ = _tmp7_->state;
		if (_tmp8_ == CKS_RW_USER_FUNCTIONS) {
			_tmp6_ = TRUE;
		} else {
			GckSessionInfo* _tmp9_ = NULL;
			gulong _tmp10_ = 0UL;
			_tmp9_ = info;
			_tmp10_ = _tmp9_->state;
			_tmp6_ = _tmp10_ == CKS_RO_USER_FUNCTIONS;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			GckSessionInfo* _tmp11_ = NULL;
			gulong _tmp12_ = 0UL;
			_tmp11_ = info;
			_tmp12_ = _tmp11_->state;
			_tmp5_ = _tmp12_ == CKS_RW_SO_FUNCTIONS;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	__vala_GckSessionInfo_free0 (info);
	return result;
}


static GckTokenInfo* seahorse_pkcs11_token_ensure_token_info (SeahorsePkcs11Token* self) {
	GckTokenInfo* result = NULL;
	GckTokenInfo* _tmp0_ = NULL;
	GckTokenInfo* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	if (_tmp0_ == NULL) {
		seahorse_pkcs11_token_update_token_info (self);
	}
	_tmp1_ = self->priv->_info;
	result = _tmp1_;
	return result;
}


static GckTokenInfo* _vala_GckTokenInfo_copy (GckTokenInfo* self) {
	return g_boxed_copy (gck_token_info_get_type (), self);
}


static gpointer __vala_GckTokenInfo_copy0 (gpointer self) {
	return self ? _vala_GckTokenInfo_copy (self) : NULL;
}


static void seahorse_pkcs11_token_update_token_info (SeahorsePkcs11Token* self) {
	GckTokenInfo* info = NULL;
	GckSlot* _tmp0_ = NULL;
	GckTokenInfo* _tmp1_ = NULL;
	GckTokenInfo* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	info = _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ != NULL) {
		GckTokenInfo* _tmp3_ = NULL;
		GckTokenInfo* _tmp4_ = NULL;
		_tmp3_ = info;
		_tmp4_ = __vala_GckTokenInfo_copy0 (_tmp3_);
		__vala_GckTokenInfo_free0 (self->priv->_info);
		self->priv->_info = _tmp4_;
		g_object_notify ((GObject*) self, "info");
		g_object_notify ((GObject*) self, "lockable");
		g_object_notify ((GObject*) self, "unlockable");
	}
	__vala_GckTokenInfo_free0 (info);
}


static GckAttribute* _vala_GckAttribute_copy (GckAttribute* self) {
	return g_boxed_copy (gck_attribute_get_type (), self);
}


static gpointer __vala_GckAttribute_copy0 (gpointer self) {
	return self ? _vala_GckAttribute_copy (self) : NULL;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void _vala_GckAttribute_free (GckAttribute* self) {
	g_boxed_free (gck_attribute_get_type (), self);
}


static void seahorse_pkcs11_token_update_id_map (SeahorsePkcs11Token* self, GObject* object, GckAttribute* id) {
	gboolean add = FALSE;
	gboolean remove = FALSE;
	GckAttribute* pid = NULL;
	GHashTable* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GckAttribute* _tmp3_ = NULL;
	GckAttribute* _tmp4_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	add = FALSE;
	remove = FALSE;
	_tmp0_ = self->priv->_id_for_object;
	_tmp1_ = object;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = __vala_GckAttribute_copy0 ((GckAttribute*) _tmp2_);
	pid = _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ == NULL) {
		GckAttribute* _tmp5_ = NULL;
		_tmp5_ = pid;
		if (_tmp5_ != NULL) {
			GckAttribute* _tmp6_ = NULL;
			_tmp6_ = pid;
			id = _tmp6_;
			remove = TRUE;
		}
	} else {
		GckAttribute* _tmp7_ = NULL;
		_tmp7_ = pid;
		if (_tmp7_ == NULL) {
			add = TRUE;
		} else {
			GckAttribute* _tmp8_ = NULL;
			GckAttribute* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			_tmp8_ = id;
			_tmp9_ = pid;
			_tmp10_ = gck_attribute_equal (_tmp8_, _tmp9_);
			if (!_tmp10_) {
				remove = TRUE;
				add = TRUE;
			}
		}
	}
	_tmp11_ = add;
	if (_tmp11_) {
		GPtrArray* objects = NULL;
		GHashTable* _tmp12_ = NULL;
		GckAttribute* _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		GPtrArray* _tmp15_ = NULL;
		GPtrArray* _tmp23_ = NULL;
		GObject* _tmp24_ = NULL;
		GObject* _tmp25_ = NULL;
		GHashTable* _tmp26_ = NULL;
		GObject* _tmp27_ = NULL;
		GObject* _tmp28_ = NULL;
		GckAttribute* _tmp29_ = NULL;
		GckAttribute* _tmp30_ = NULL;
		_tmp12_ = self->priv->_objects_for_id;
		_tmp13_ = id;
		_tmp14_ = g_hash_table_lookup (_tmp12_, _tmp13_);
		objects = (GPtrArray*) _tmp14_;
		_tmp15_ = objects;
		if (_tmp15_ == NULL) {
			GPtrArray* objs = NULL;
			GPtrArray* _tmp16_ = NULL;
			GHashTable* _tmp17_ = NULL;
			GckAttribute* _tmp18_ = NULL;
			GckAttribute* _tmp19_ = NULL;
			GPtrArray* _tmp20_ = NULL;
			GPtrArray* _tmp21_ = NULL;
			GPtrArray* _tmp22_ = NULL;
			_tmp16_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
			objs = _tmp16_;
			_tmp17_ = self->priv->_objects_for_id;
			_tmp18_ = id;
			_tmp19_ = __vala_GckAttribute_copy0 (_tmp18_);
			_tmp20_ = objs;
			_tmp21_ = _g_ptr_array_ref0 (_tmp20_);
			g_hash_table_insert (_tmp17_, _tmp19_, _tmp21_);
			_tmp22_ = objs;
			objects = _tmp22_;
			_g_ptr_array_unref0 (objs);
		}
		_tmp23_ = objects;
		_tmp24_ = object;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		g_ptr_array_add (_tmp23_, _tmp25_);
		_tmp26_ = self->priv->_id_for_object;
		_tmp27_ = object;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_tmp29_ = id;
		_tmp30_ = __vala_GckAttribute_copy0 (_tmp29_);
		g_hash_table_insert (_tmp26_, _tmp28_, _tmp30_);
	}
	_tmp31_ = remove;
	if (_tmp31_) {
		GHashTable* _tmp32_ = NULL;
		GObject* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		GPtrArray* objects = NULL;
		GHashTable* _tmp35_ = NULL;
		GckAttribute* _tmp36_ = NULL;
		gconstpointer _tmp37_ = NULL;
		GPtrArray* _tmp38_ = NULL;
		GPtrArray* _tmp39_ = NULL;
		GPtrArray* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		GPtrArray* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp32_ = self->priv->_id_for_object;
		_tmp33_ = object;
		_tmp34_ = g_hash_table_remove (_tmp32_, _tmp33_);
		if (!_tmp34_) {
			g_assert_not_reached ();
		}
		_tmp35_ = self->priv->_objects_for_id;
		_tmp36_ = id;
		_tmp37_ = g_hash_table_lookup (_tmp35_, _tmp36_);
		_tmp38_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp37_);
		objects = _tmp38_;
		_tmp39_ = objects;
		_vala_assert (_tmp39_ != NULL, "objects != null");
		_tmp40_ = objects;
		_tmp41_ = g_ptr_array_get_length (_tmp40_);
		_tmp42_ = _tmp41_;
		_vala_assert (_tmp42_ > 0, "objects.length > 0");
		_tmp43_ = objects;
		_tmp44_ = g_ptr_array_get_length (_tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ == 1) {
			GHashTable* _tmp46_ = NULL;
			GckAttribute* _tmp47_ = NULL;
			gboolean _tmp48_ = FALSE;
			_tmp46_ = self->priv->_objects_for_id;
			_tmp47_ = id;
			_tmp48_ = g_hash_table_remove (_tmp46_, _tmp47_);
			if (!_tmp48_) {
				g_assert_not_reached ();
			}
		} else {
			GPtrArray* _tmp49_ = NULL;
			GObject* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
			_tmp49_ = objects;
			_tmp50_ = object;
			_tmp51_ = g_ptr_array_remove (_tmp49_, _tmp50_);
			if (!_tmp51_) {
				g_assert_not_reached ();
			}
		}
		_g_ptr_array_unref0 (objects);
	}
	__vala_GckAttribute_free0 (pid);
}


static GObject* seahorse_pkcs11_token_lookup_id_map (SeahorsePkcs11Token* self, GType object_type, GckAttribute* id) {
	GObject* result = NULL;
	GckAttribute* _tmp0_ = NULL;
	GPtrArray* objects = NULL;
	GHashTable* _tmp1_ = NULL;
	GckAttribute* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = id;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_objects_for_id;
	_tmp2_ = id;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp3_);
	objects = _tmp4_;
	_tmp5_ = objects;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_ptr_array_unref0 (objects);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				GPtrArray* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GPtrArray* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gconstpointer _tmp14_ = NULL;
				GType _tmp15_ = 0UL;
				GType _tmp16_ = 0UL;
				gboolean _tmp17_ = FALSE;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = objects;
				_tmp10_ = g_ptr_array_get_length (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < _tmp11_)) {
					break;
				}
				_tmp12_ = objects;
				_tmp13_ = i;
				_tmp14_ = g_ptr_array_index (_tmp12_, (guint) _tmp13_);
				_tmp15_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_);
				_tmp16_ = object_type;
				_tmp17_ = g_type_is_a (_tmp15_, _tmp16_);
				if (_tmp17_) {
					GPtrArray* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gconstpointer _tmp20_ = NULL;
					GObject* _tmp21_ = NULL;
					_tmp18_ = objects;
					_tmp19_ = i;
					_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
					_tmp21_ = _g_object_ref0 ((GObject*) _tmp20_);
					result = _tmp21_;
					_g_ptr_array_unref0 (objects);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_ptr_array_unref0 (objects);
	return result;
}


static void seahorse_pkcs11_token_update_visibility (SeahorsePkcs11Token* self, GList* objects, gboolean visible) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp0_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp1_ = NULL;
			GObject* object = NULL;
			_tmp1_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp1_;
			{
				gboolean have = FALSE;
				GHashTable* _tmp2_ = NULL;
				GObject* _tmp3_ = NULL;
				gconstpointer _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				_tmp2_ = self->priv->_objects_visible;
				_tmp3_ = object;
				_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
				have = ((GObject*) _tmp4_) != NULL;
				_tmp6_ = have;
				if (!_tmp6_) {
					gboolean _tmp7_ = FALSE;
					_tmp7_ = visible;
					_tmp5_ = _tmp7_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GHashTable* _tmp8_ = NULL;
					GObject* _tmp9_ = NULL;
					GObject* _tmp10_ = NULL;
					GObject* _tmp11_ = NULL;
					GObject* _tmp12_ = NULL;
					GObject* _tmp13_ = NULL;
					_tmp8_ = self->priv->_objects_visible;
					_tmp9_ = object;
					_tmp10_ = _g_object_ref0 (_tmp9_);
					_tmp11_ = object;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					g_hash_table_insert (_tmp8_, _tmp10_, _tmp12_);
					_tmp13_ = object;
					gcr_collection_emit_added ((GcrCollection*) self, _tmp13_);
				} else {
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					_tmp15_ = have;
					if (_tmp15_) {
						gboolean _tmp16_ = FALSE;
						_tmp16_ = visible;
						_tmp14_ = !_tmp16_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						GHashTable* _tmp17_ = NULL;
						GObject* _tmp18_ = NULL;
						gboolean _tmp19_ = FALSE;
						GObject* _tmp20_ = NULL;
						_tmp17_ = self->priv->_objects_visible;
						_tmp18_ = object;
						_tmp19_ = g_hash_table_remove (_tmp17_, _tmp18_);
						if (!_tmp19_) {
							g_assert_not_reached ();
						}
						_tmp20_ = object;
						gcr_collection_emit_removed ((GcrCollection*) self, _tmp20_);
					}
				}
				_g_object_unref0 (object);
			}
		}
	}
}


static gboolean seahorse_pkcs11_token_make_certificate_key_pair (SeahorsePkcs11Certificate* certificate, SeahorsePkcs11PrivateKey* private_key) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SeahorsePkcs11Certificate* _tmp1_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp2_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp3_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SeahorsePkcs11Certificate* _tmp10_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp11_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp12_ = NULL;
	SeahorsePkcs11Certificate* _tmp13_ = NULL;
	g_return_val_if_fail (certificate != NULL, FALSE);
	g_return_val_if_fail (private_key != NULL, FALSE);
	_tmp1_ = certificate;
	_tmp2_ = seahorse_pkcs11_certificate_get_partner (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		SeahorsePkcs11PrivateKey* _tmp6_ = NULL;
		SeahorsePkcs11Certificate* _tmp7_ = NULL;
		SeahorsePkcs11Certificate* _tmp8_ = NULL;
		SeahorsePkcs11Certificate* _tmp9_ = NULL;
		_tmp6_ = private_key;
		_tmp7_ = seahorse_pkcs11_private_key_get_partner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_ != NULL;
		_g_object_unref0 (_tmp9_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = certificate;
	_tmp11_ = private_key;
	seahorse_pkcs11_certificate_set_partner (_tmp10_, _tmp11_);
	_tmp12_ = private_key;
	_tmp13_ = certificate;
	seahorse_pkcs11_private_key_set_partner (_tmp12_, _tmp13_);
	result = TRUE;
	return result;
}


static GObject* seahorse_pkcs11_token_break_certificate_key_pair (GObject* object) {
	GObject* result = NULL;
	GObject* pair = NULL;
	GObject* _tmp0_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	pair = NULL;
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_PKCS11_TYPE_CERTIFICATE)) {
		SeahorsePkcs11Certificate* certificate = NULL;
		GObject* _tmp1_ = NULL;
		SeahorsePkcs11Certificate* _tmp2_ = NULL;
		SeahorsePkcs11Certificate* _tmp3_ = NULL;
		SeahorsePkcs11PrivateKey* _tmp4_ = NULL;
		SeahorsePkcs11PrivateKey* _tmp5_ = NULL;
		SeahorsePkcs11Certificate* _tmp6_ = NULL;
		_tmp1_ = object;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate));
		certificate = _tmp2_;
		_tmp3_ = certificate;
		_tmp4_ = seahorse_pkcs11_certificate_get_partner (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (pair);
		pair = (GObject*) _tmp5_;
		_tmp6_ = certificate;
		seahorse_pkcs11_certificate_set_partner (_tmp6_, NULL);
		_g_object_unref0 (certificate);
	} else {
		GObject* _tmp7_ = NULL;
		_tmp7_ = object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY)) {
			SeahorsePkcs11PrivateKey* private_key = NULL;
			GObject* _tmp8_ = NULL;
			SeahorsePkcs11PrivateKey* _tmp9_ = NULL;
			SeahorsePkcs11PrivateKey* _tmp10_ = NULL;
			SeahorsePkcs11Certificate* _tmp11_ = NULL;
			SeahorsePkcs11Certificate* _tmp12_ = NULL;
			SeahorsePkcs11PrivateKey* _tmp13_ = NULL;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
			private_key = _tmp9_;
			_tmp10_ = private_key;
			_tmp11_ = seahorse_pkcs11_private_key_get_partner (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (pair);
			pair = (GObject*) _tmp12_;
			_tmp13_ = private_key;
			seahorse_pkcs11_private_key_set_partner (_tmp13_, NULL);
			_g_object_unref0 (private_key);
		}
	}
	result = pair;
	return result;
}


static gulong* _ulong_dup (gulong* self) {
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}


static gpointer __ulong_dup0 (gpointer self) {
	return self ? _ulong_dup (self) : NULL;
}


static void seahorse_pkcs11_token_receive_objects (SeahorsePkcs11Token* self, GList* objects) {
	GList* show = NULL;
	GList* hide = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp59_ = NULL;
	GList* _tmp60_ = NULL;
	g_return_if_fail (self != NULL);
	show = NULL;
	hide = NULL;
	_tmp0_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp0_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp1_ = NULL;
			GObject* object = NULL;
			_tmp1_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				GObject* _tmp3_ = NULL;
				gulong handle = 0UL;
				GObject* _tmp5_ = NULL;
				gulong _tmp6_ = 0UL;
				gulong _tmp7_ = 0UL;
				GckAttributes* attrs = NULL;
				GObject* _tmp8_ = NULL;
				GckAttributes* _tmp9_ = NULL;
				GckAttributes* _tmp10_ = NULL;
				GObject* prev = NULL;
				GHashTable* _tmp11_ = NULL;
				gulong _tmp12_ = 0UL;
				gconstpointer _tmp13_ = NULL;
				GObject* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GckAttribute* id = NULL;
				GckAttributes* _tmp28_ = NULL;
				GObject* _tmp31_ = NULL;
				GckAttribute* _tmp32_ = NULL;
				GObject* _tmp33_ = NULL;
				_tmp3_ = object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gck_object_get_type ())) {
					GObject* _tmp4_ = NULL;
					_tmp4_ = object;
					_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gck_object_cache_get_type ());
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp5_ = object;
				_tmp6_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gck_object_get_type (), GckObject));
				_tmp7_ = _tmp6_;
				handle = _tmp7_;
				_tmp8_ = object;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gck_object_cache_get_type (), GckObjectCache), "attributes", &_tmp9_, NULL);
				_tmp10_ = _tmp9_;
				attrs = _tmp10_;
				_tmp11_ = self->priv->_object_for_handle;
				_tmp12_ = handle;
				_tmp13_ = g_hash_table_lookup (_tmp11_, &_tmp12_);
				_tmp14_ = _g_object_ref0 ((GObject*) _tmp13_);
				prev = _tmp14_;
				_tmp15_ = prev;
				if (_tmp15_ == NULL) {
					GHashTable* _tmp16_ = NULL;
					gulong _tmp17_ = 0UL;
					gulong* _tmp18_ = NULL;
					GObject* _tmp19_ = NULL;
					GObject* _tmp20_ = NULL;
					GObject* _tmp21_ = NULL;
					_tmp16_ = self->priv->_object_for_handle;
					_tmp17_ = handle;
					_tmp18_ = __ulong_dup0 (&_tmp17_);
					_tmp19_ = object;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
					_tmp21_ = object;
					g_object_set (_tmp21_, "place", self, NULL);
				} else {
					GObject* _tmp22_ = NULL;
					GObject* _tmp23_ = NULL;
					_tmp22_ = prev;
					_tmp23_ = object;
					if (_tmp22_ != _tmp23_) {
						GObject* _tmp24_ = NULL;
						GckAttributes* _tmp25_ = NULL;
						GObject* _tmp26_ = NULL;
						GObject* _tmp27_ = NULL;
						_tmp24_ = object;
						_tmp25_ = attrs;
						g_object_set (_tmp24_, "attributes", _tmp25_, NULL);
						_tmp26_ = prev;
						_tmp27_ = _g_object_ref0 (_tmp26_);
						_g_object_unref0 (object);
						object = _tmp27_;
					}
				}
				id = NULL;
				_tmp28_ = attrs;
				if (_tmp28_ != NULL) {
					GckAttributes* _tmp29_ = NULL;
					GckAttribute* _tmp30_ = NULL;
					_tmp29_ = attrs;
					_tmp30_ = gck_attributes_find (_tmp29_, CKA_ID);
					id = _tmp30_;
				}
				_tmp31_ = object;
				_tmp32_ = id;
				seahorse_pkcs11_token_update_id_map (self, _tmp31_, _tmp32_);
				_tmp33_ = object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, SEAHORSE_PKCS11_TYPE_CERTIFICATE)) {
					GObject* pair = NULL;
					GckAttribute* _tmp34_ = NULL;
					GObject* _tmp35_ = NULL;
					gboolean _tmp36_ = FALSE;
					GObject* _tmp37_ = NULL;
					GObject* _tmp43_ = NULL;
					GObject* _tmp44_ = NULL;
					_tmp34_ = id;
					_tmp35_ = seahorse_pkcs11_token_lookup_id_map (self, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, _tmp34_);
					pair = _tmp35_;
					_tmp37_ = pair;
					if (_tmp37_ != NULL) {
						GObject* _tmp38_ = NULL;
						GObject* _tmp39_ = NULL;
						gboolean _tmp40_ = FALSE;
						_tmp38_ = object;
						_tmp39_ = pair;
						_tmp40_ = seahorse_pkcs11_token_make_certificate_key_pair (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
						_tmp36_ = _tmp40_;
					} else {
						_tmp36_ = FALSE;
					}
					if (_tmp36_) {
						GObject* _tmp41_ = NULL;
						GObject* _tmp42_ = NULL;
						_tmp41_ = pair;
						_tmp42_ = _g_object_ref0 (_tmp41_);
						hide = g_list_prepend (hide, _tmp42_);
					}
					_tmp43_ = object;
					_tmp44_ = _g_object_ref0 (_tmp43_);
					show = g_list_prepend (show, _tmp44_);
					_g_object_unref0 (pair);
				} else {
					GObject* _tmp45_ = NULL;
					_tmp45_ = object;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY)) {
						GObject* pair = NULL;
						GckAttribute* _tmp46_ = NULL;
						GObject* _tmp47_ = NULL;
						gboolean _tmp48_ = FALSE;
						GObject* _tmp49_ = NULL;
						_tmp46_ = id;
						_tmp47_ = seahorse_pkcs11_token_lookup_id_map (self, SEAHORSE_PKCS11_TYPE_CERTIFICATE, _tmp46_);
						pair = _tmp47_;
						_tmp49_ = pair;
						if (_tmp49_ != NULL) {
							GObject* _tmp50_ = NULL;
							GObject* _tmp51_ = NULL;
							gboolean _tmp52_ = FALSE;
							_tmp50_ = pair;
							_tmp51_ = object;
							_tmp52_ = seahorse_pkcs11_token_make_certificate_key_pair (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate), G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
							_tmp48_ = _tmp52_;
						} else {
							_tmp48_ = FALSE;
						}
						if (_tmp48_) {
							GObject* _tmp53_ = NULL;
							GObject* _tmp54_ = NULL;
							_tmp53_ = object;
							_tmp54_ = _g_object_ref0 (_tmp53_);
							hide = g_list_prepend (hide, _tmp54_);
						} else {
							GObject* _tmp55_ = NULL;
							GObject* _tmp56_ = NULL;
							_tmp55_ = object;
							_tmp56_ = _g_object_ref0 (_tmp55_);
							show = g_list_prepend (show, _tmp56_);
						}
						_g_object_unref0 (pair);
					} else {
						GObject* _tmp57_ = NULL;
						GObject* _tmp58_ = NULL;
						_tmp57_ = object;
						_tmp58_ = _g_object_ref0 (_tmp57_);
						show = g_list_prepend (show, _tmp58_);
					}
				}
				_g_object_unref0 (prev);
				__vala_GckAttributes_free0 (attrs);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp59_ = hide;
	seahorse_pkcs11_token_update_visibility (self, _tmp59_, FALSE);
	_tmp60_ = show;
	seahorse_pkcs11_token_update_visibility (self, _tmp60_, TRUE);
	__g_list_free__g_object_unref0_0 (hide);
	__g_list_free__g_object_unref0_0 (show);
}


static void seahorse_pkcs11_token_remove_objects (SeahorsePkcs11Token* self, GList* objects) {
	GList* depaired = NULL;
	GList* hide = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp10_ = NULL;
	GList* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	depaired = NULL;
	hide = NULL;
	_tmp0_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp0_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp1_ = NULL;
			GObject* object = NULL;
			_tmp1_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp1_;
			{
				GObject* pair = NULL;
				GObject* _tmp2_ = NULL;
				GObject* _tmp3_ = NULL;
				GObject* _tmp4_ = NULL;
				GObject* _tmp7_ = NULL;
				GObject* _tmp8_ = NULL;
				GObject* _tmp9_ = NULL;
				_tmp2_ = object;
				_tmp3_ = seahorse_pkcs11_token_break_certificate_key_pair (_tmp2_);
				pair = _tmp3_;
				_tmp4_ = pair;
				if (_tmp4_ != NULL) {
					GObject* _tmp5_ = NULL;
					GObject* _tmp6_ = NULL;
					_tmp5_ = pair;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					depaired = g_list_prepend (depaired, _tmp6_);
				}
				_tmp7_ = object;
				seahorse_pkcs11_token_update_id_map (self, _tmp7_, NULL);
				_tmp8_ = object;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				hide = g_list_prepend (hide, _tmp9_);
				_g_object_unref0 (pair);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp10_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp10_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp11_ = NULL;
			GObject* object = NULL;
			_tmp11_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp11_;
			{
				gulong handle = 0UL;
				GObject* _tmp12_ = NULL;
				gulong _tmp13_ = 0UL;
				gulong _tmp14_ = 0UL;
				GObject* _tmp15_ = NULL;
				GHashTable* _tmp16_ = NULL;
				gulong _tmp17_ = 0UL;
				_tmp12_ = object;
				_tmp13_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gck_object_get_type (), GckObject));
				_tmp14_ = _tmp13_;
				handle = _tmp14_;
				_tmp15_ = object;
				g_object_set (_tmp15_, "place", NULL, NULL);
				_tmp16_ = self->priv->_object_for_handle;
				_tmp17_ = handle;
				g_hash_table_remove (_tmp16_, &_tmp17_);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp18_ = hide;
	seahorse_pkcs11_token_update_visibility (self, _tmp18_, FALSE);
	_tmp19_ = depaired;
	seahorse_pkcs11_token_receive_objects (self, _tmp19_);
	__g_list_free__g_object_unref0_0 (hide);
	__g_list_free__g_object_unref0_0 (depaired);
}


static GckSessionOptions seahorse_pkcs11_token_calculate_session_options (SeahorsePkcs11Token* self) {
	GckSessionOptions result = 0;
	GckTokenInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	g_return_val_if_fail (self != NULL, 0);
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = _tmp0_->flags;
	if ((_tmp1_ & CKF_WRITE_PROTECTED) == CKF_WRITE_PROTECTED) {
		result = GCK_SESSION_READ_ONLY;
		return result;
	} else {
		result = GCK_SESSION_READ_WRITE;
		return result;
	}
}


static void seahorse_pkcs11_token_real_load_data_free (gpointer _data) {
	SeahorsePkcs11TokenLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenLoadData, _data_);
}


static void seahorse_pkcs11_token_real_load (SeahorsePlace* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenLoadData* _data_;
	SeahorsePkcs11Token* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenLoadData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_pkcs11_token_real_load);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_pkcs11_token_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_pkcs11_token_real_load_co (_data_);
}


static gboolean seahorse_pkcs11_token_real_load_finish (SeahorsePlace* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorsePkcs11TokenLoadData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static void seahorse_pkcs11_token_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorsePkcs11TokenLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_load_co (_data_);
}


static void _vala_GckBuilder_free (GckBuilder* self) {
	g_boxed_free (gck_builder_get_type (), self);
}


static gboolean seahorse_pkcs11_token_real_load_co (SeahorsePkcs11TokenLoadData* _data_) {
	static const gulong CERTIFICATE_ATTRS[] = {CKA_VALUE, CKA_ID, CKA_LABEL, CKA_CLASS, CKA_CERTIFICATE_CATEGORY, CKA_MODIFIABLE};
	static const gulong KEY_ATTRS[] = {CKA_MODULUS_BITS, CKA_ID, CKA_LABEL, CKA_CLASS, CKA_KEY_TYPE, CKA_MODIFIABLE};
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = seahorse_ulong_hash;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = seahorse_ulong_equal;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_object_unref0_);
	_data_->checks = _data_->_tmp2_;
	seahorse_pkcs11_token_update_token_info (_data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = gcr_collection_get_objects ((GcrCollection*) _data_->self);
	{
		_data_->object_collection = _data_->_tmp3_;
		for (_data_->object_it = _data_->object_collection; _data_->object_it != NULL; _data_->object_it = _data_->object_it->next) {
			_data_->object = (GObject*) _data_->object_it->data;
			{
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->object;
				_data_->_tmp5_ = 0UL;
				_data_->_tmp5_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gck_object_get_type (), GckObject));
				_data_->_tmp6_ = 0UL;
				_data_->_tmp6_ = _data_->_tmp5_;
				_data_->handle = _data_->_tmp6_;
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = _data_->checks;
				_data_->_tmp8_ = 0UL;
				_data_->_tmp8_ = _data_->handle;
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = __ulong_dup0 (&_data_->_tmp8_);
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->object;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
				g_hash_table_insert (_data_->_tmp7_, _data_->_tmp9_, _data_->_tmp11_);
			}
		}
		_g_list_free0 (_data_->object_collection);
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->_session;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp13_ = 0;
		_data_->_tmp13_ = seahorse_pkcs11_token_calculate_session_options (_data_->self);
		_data_->options = _data_->_tmp13_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->_slot;
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = _data_->options;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->cancellable;
		_data_->_state_ = 1;
		gck_slot_open_session_async (_data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, seahorse_pkcs11_token_load_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = gck_slot_open_session_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp14_ = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_hash_table_unref0 (_data_->checks);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp14_;
		_data_->_tmp14_ = NULL;
		_g_object_unref0 (_data_->self->priv->_session);
		_data_->self->priv->_session = _data_->_tmp19_;
		_g_object_unref0 (_data_->_tmp14_);
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = gck_builder_new (GCK_BUILDER_NONE);
	_data_->builder = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->builder;
	gck_builder_add_boolean (_data_->_tmp21_, CKA_TOKEN, TRUE);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->builder;
	gck_builder_add_ulong (_data_->_tmp22_, CKA_CLASS, CKO_CERTIFICATE);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->self->priv->_session;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->builder;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = gck_builder_end (_data_->_tmp24_);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = gck_session_enumerate_objects (_data_->_tmp23_, _data_->_tmp25_);
	_data_->enumerator = _data_->_tmp26_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->enumerator;
	gck_enumerator_set_object_type_full (_data_->_tmp27_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, CERTIFICATE_ATTRS, G_N_ELEMENTS (CERTIFICATE_ATTRS));
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = gck_builder_new (GCK_BUILDER_NONE);
	__vala_GckBuilder_free0 (_data_->builder);
	_data_->builder = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->builder;
	gck_builder_add_boolean (_data_->_tmp29_, CKA_TOKEN, TRUE);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->builder;
	gck_builder_add_ulong (_data_->_tmp30_, CKA_CLASS, CKO_PRIVATE_KEY);
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->self->priv->_session;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->builder;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = gck_builder_end (_data_->_tmp32_);
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = gck_session_enumerate_objects (_data_->_tmp31_, _data_->_tmp33_);
	_data_->chained = _data_->_tmp34_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->chained;
	gck_enumerator_set_object_type_full (_data_->_tmp35_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, KEY_ATTRS, G_N_ELEMENTS (KEY_ATTRS));
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->enumerator;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->chained;
	gck_enumerator_set_chained (_data_->_tmp36_, _data_->_tmp37_);
	{
		_data_->_tmp38_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp38_) {
			}
			_data_->_tmp38_ = FALSE;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->enumerator;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->cancellable;
			_data_->_state_ = 2;
			gck_enumerator_next_async (_data_->_tmp39_, 16, _data_->_tmp40_, seahorse_pkcs11_token_load_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = gck_enumerator_next_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error_);
			_data_->objects = _data_->_tmp41_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->chained);
				_g_object_unref0 (_data_->enumerator);
				__vala_GckBuilder_free0 (_data_->builder);
				_g_hash_table_unref0 (_data_->checks);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = _data_->objects;
			if (_data_->_tmp42_ == NULL) {
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->checks;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = g_hash_table_get_values (_data_->_tmp43_);
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = _data_->_tmp44_;
				seahorse_pkcs11_token_remove_objects (_data_->self, _data_->_tmp45_);
				_g_list_free0 (_data_->_tmp45_);
				_data_->result = TRUE;
				__g_list_free__g_object_unref0_0 (_data_->objects);
				_g_object_unref0 (_data_->chained);
				_g_object_unref0 (_data_->enumerator);
				__vala_GckBuilder_free0 (_data_->builder);
				_g_hash_table_unref0 (_data_->checks);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp46_ = NULL;
			_data_->_tmp46_ = _data_->objects;
			seahorse_pkcs11_token_receive_objects (_data_->self, _data_->_tmp46_);
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->objects;
			{
				_data_->_vala1_object_collection = _data_->_tmp47_;
				for (_data_->_vala1_object_it = _data_->_vala1_object_collection; _data_->_vala1_object_it != NULL; _data_->_vala1_object_it = _data_->_vala1_object_it->next) {
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _g_object_ref0 ((GckModule*) _data_->_vala1_object_it->data);
					_data_->_vala1_object = _data_->_tmp48_;
					{
						_data_->_tmp49_ = NULL;
						_data_->_tmp49_ = _data_->_vala1_object;
						_data_->_tmp50_ = 0UL;
						_data_->_tmp50_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, gck_object_get_type (), GckObject));
						_data_->_tmp51_ = 0UL;
						_data_->_tmp51_ = _data_->_tmp50_;
						_data_->_vala1_handle = _data_->_tmp51_;
						_data_->_tmp52_ = NULL;
						_data_->_tmp52_ = _data_->checks;
						_data_->_tmp53_ = 0UL;
						_data_->_tmp53_ = _data_->_vala1_handle;
						g_hash_table_remove (_data_->_tmp52_, &_data_->_tmp53_);
						_g_object_unref0 (_data_->_vala1_object);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (_data_->objects);
		}
	}
	_g_object_unref0 (_data_->chained);
	_g_object_unref0 (_data_->enumerator);
	__vala_GckBuilder_free0 (_data_->builder);
	_g_hash_table_unref0 (_data_->checks);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean seahorse_pkcs11_token_real_get_unlockable (SeahorseLockable* base) {
	gboolean result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GckTokenInfo* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GckSession* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (SeahorsePkcs11Token*) base;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = _tmp0_->flags;
	if ((_tmp1_ & CKF_LOGIN_REQUIRED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_info;
	_tmp3_ = _tmp2_->flags;
	if ((_tmp3_ & CKF_USER_PIN_INITIALIZED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_session;
	_tmp5_ = seahorse_pkcs11_token_is_session_logged_in (_tmp4_);
	result = !_tmp5_;
	return result;
}


static gboolean seahorse_pkcs11_token_real_get_lockable (SeahorseLockable* base) {
	gboolean result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GckTokenInfo* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GckSession* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (SeahorsePkcs11Token*) base;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = _tmp0_->flags;
	if ((_tmp1_ & CKF_LOGIN_REQUIRED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_info;
	_tmp3_ = _tmp2_->flags;
	if ((_tmp3_ & CKF_USER_PIN_INITIALIZED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_session;
	_tmp5_ = seahorse_pkcs11_token_is_session_logged_in (_tmp4_);
	result = _tmp5_;
	return result;
}


GckTokenInfo* seahorse_pkcs11_token_get_info (SeahorsePkcs11Token* self) {
	GckTokenInfo* result;
	GckTokenInfo* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = seahorse_pkcs11_token_ensure_token_info (self);
	result = _tmp0_;
	return result;
}


GckSession* seahorse_pkcs11_token_get_session (SeahorsePkcs11Token* self) {
	GckSession* result;
	GckSession* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}


void seahorse_pkcs11_token_set_session (SeahorsePkcs11Token* self, GckSession* value) {
	GckSession* _tmp0_ = NULL;
	GckSession* _tmp1_ = NULL;
	GckSession* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = seahorse_pkcs11_token_get_session (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_session);
	self->priv->_session = _tmp2_;
	g_object_notify ((GObject*) self, "session");
	g_object_notify ((GObject*) self, "lockable");
	g_object_notify ((GObject*) self, "unlockable");
	g_object_notify ((GObject *) self, "session");
}


GckSlot* seahorse_pkcs11_token_get_slot (SeahorsePkcs11Token* self) {
	GckSlot* result;
	GckSlot* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}


static void seahorse_pkcs11_token_set_slot (SeahorsePkcs11Token* self, GckSlot* value) {
	GckSlot* _tmp0_ = NULL;
	GckSlot* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_slot);
	self->priv->_slot = _tmp1_;
	g_object_notify ((GObject *) self, "slot");
}


static gchar* seahorse_pkcs11_token_real_get_label (SeahorsePlace* base) {
	gchar* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_ = NULL;
	GckTokenInfo* _tmp1_ = NULL;
	GckTokenInfo* _tmp2_ = NULL;
	GckTokenInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = C_ ("Label", "Unknown");
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp5_ = token;
	_tmp6_ = _tmp5_->label;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}


static gchar* seahorse_pkcs11_token_real_get_description (SeahorsePlace* base) {
	gchar* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_ = NULL;
	GckTokenInfo* _tmp1_ = NULL;
	GckTokenInfo* _tmp2_ = NULL;
	GckTokenInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp4_ = token;
	_tmp5_ = _tmp4_->manufacturer_id;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}


static gchar* seahorse_pkcs11_token_real_get_uri (SeahorsePlace* base) {
	gchar* result;
	SeahorsePkcs11Token* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static GIcon* seahorse_pkcs11_token_real_get_icon (SeahorsePlace* base) {
	GIcon* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_ = NULL;
	GckTokenInfo* _tmp1_ = NULL;
	GckTokenInfo* _tmp2_ = NULL;
	GckTokenInfo* _tmp4_ = NULL;
	GIcon* _tmp5_ = NULL;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		GThemedIcon* _tmp3_ = NULL;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new (GTK_STOCK_DIALOG_QUESTION);
		result = (GIcon*) _tmp3_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp4_ = token;
	_tmp5_ = gcr_icon_for_token (_tmp4_);
	result = _tmp5_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}


static GtkActionGroup* seahorse_pkcs11_token_real_get_actions (SeahorsePlace* base) {
	GtkActionGroup* result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = NULL;
	return result;
}


SeahorseFlags seahorse_pkcs11_token_get_object_flags (SeahorsePkcs11Token* self) {
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


GArray* seahorse_pkcs11_token_get_mechanisms (SeahorsePkcs11Token* self) {
	GArray* result;
	GArray* _tmp0_ = NULL;
	GArray* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mechanisms;
	if (_tmp0_ == NULL) {
		GckSlot* _tmp1_ = NULL;
		GArray* _tmp2_ = NULL;
		_tmp1_ = self->priv->_slot;
		_tmp2_ = gck_slot_get_mechanisms (_tmp1_);
		_g_array_unref0 (self->priv->_mechanisms);
		self->priv->_mechanisms = _tmp2_;
	}
	_tmp3_ = self->priv->_mechanisms;
	result = _tmp3_;
	return result;
}


static guint _gck_attribute_hash_ghash_func (gconstpointer key) {
	guint result;
	result = gck_attribute_hash (key);
	return result;
}


static gboolean _gck_attribute_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = gck_attribute_equal (a, (GckAttribute*) b);
	return result;
}


static void __vala_GckAttribute_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GckAttribute_free (var), NULL));
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _vala_GckUriData_free (GckUriData* self) {
	g_boxed_free (gck_uri_data_get_type (), self);
}


static GObject * seahorse_pkcs11_token_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Token * self;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashFunc _tmp4_ = NULL;
	GEqualFunc _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	GHashFunc _tmp7_ = NULL;
	GEqualFunc _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	GckUriData* data = NULL;
	GckUriData* _tmp10_ = NULL;
	GckUriData* _tmp11_ = NULL;
	GckTokenInfo* _tmp12_ = NULL;
	GckTokenInfo* _tmp13_ = NULL;
	GckUriData* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_token_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	_tmp0_ = seahorse_ulong_hash;
	_tmp1_ = seahorse_ulong_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_object_for_handle);
	self->priv->_object_for_handle = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_gck_attribute_hash_ghash_func, _gck_attribute_equal_gequal_func, __vala_GckAttribute_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->_objects_for_id);
	self->priv->_objects_for_id = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->_id_for_object);
	self->priv->_id_for_object = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_objects_visible);
	self->priv->_objects_visible = _tmp9_;
	seahorse_place_load ((SeahorsePlace*) self, NULL, NULL, NULL);
	_tmp10_ = gck_uri_data_new ();
	data = _tmp10_;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp11_ = data;
	_tmp12_ = self->priv->_info;
	_tmp13_ = __vala_GckTokenInfo_copy0 (_tmp12_);
	__vala_GckTokenInfo_free0 (_tmp11_->token_info);
	_tmp11_->token_info = _tmp13_;
	_tmp14_ = data;
	_tmp15_ = gck_uri_build (_tmp14_, GCK_URI_FOR_TOKEN);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp15_;
	__vala_GckUriData_free0 (data);
	return obj;
}


static void seahorse_pkcs11_token_class_init (SeahorsePkcs11TokenClass * klass) {
	seahorse_pkcs11_token_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorsePkcs11TokenPrivate));
	((GObjectClass *) klass)->dispose = seahorse_pkcs11_token_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_token_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_token_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_token_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_token_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_UNLOCKABLE, g_param_spec_boolean ("unlockable", "unlockable", "unlockable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_LOCKABLE, g_param_spec_boolean ("lockable", "lockable", "lockable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_INFO, g_param_spec_boxed ("info", "info", "info", gck_token_info_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_SESSION, g_param_spec_object ("session", "session", "session", gck_session_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_SLOT, g_param_spec_object ("slot", "slot", "slot", gck_slot_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_ACTIONS, g_param_spec_object ("actions", "actions", "actions", gtk_action_group_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS, g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_MECHANISMS, g_param_spec_boxed ("mechanisms", "mechanisms", "mechanisms", G_TYPE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void seahorse_pkcs11_token_gcr_collection_interface_init (GcrCollectionIface * iface) {
	seahorse_pkcs11_token_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*)(GcrCollection*, GObject*)) seahorse_pkcs11_token_real_contains;
	iface->get_length = (guint (*)(GcrCollection*)) seahorse_pkcs11_token_real_get_length;
	iface->get_objects = (GList* (*)(GcrCollection*)) seahorse_pkcs11_token_real_get_objects;
}


static void seahorse_pkcs11_token_seahorse_place_interface_init (SeahorsePlaceIface * iface) {
	seahorse_pkcs11_token_seahorse_place_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (gboolean (*)(SeahorsePlace*, GCancellable*, GError**)) seahorse_pkcs11_token_real_load;
	iface->load_finish = seahorse_pkcs11_token_real_load_finish;
	iface->get_label = seahorse_pkcs11_token_real_get_label;
	iface->get_description = seahorse_pkcs11_token_real_get_description;
	iface->get_uri = seahorse_pkcs11_token_real_get_uri;
	iface->get_icon = seahorse_pkcs11_token_real_get_icon;
	iface->get_actions = seahorse_pkcs11_token_real_get_actions;
}


static void seahorse_pkcs11_token_seahorse_lockable_interface_init (SeahorseLockableIface * iface) {
	seahorse_pkcs11_token_seahorse_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->lock = (gboolean (*)(SeahorseLockable*, GTlsInteraction*, GCancellable*, GError**)) seahorse_pkcs11_token_real_lock;
	iface->lock_finish = seahorse_pkcs11_token_real_lock_finish;
	iface->unlock = (gboolean (*)(SeahorseLockable*, GTlsInteraction*, GCancellable*, GError**)) seahorse_pkcs11_token_real_unlock;
	iface->unlock_finish = seahorse_pkcs11_token_real_unlock_finish;
	iface->get_unlockable = seahorse_pkcs11_token_real_get_unlockable;
	iface->get_lockable = seahorse_pkcs11_token_real_get_lockable;
}


static void seahorse_pkcs11_token_instance_init (SeahorsePkcs11Token * self) {
	self->priv = SEAHORSE_PKCS11_TOKEN_GET_PRIVATE (self);
}


static void seahorse_pkcs11_token_finalize (GObject* obj) {
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	_g_object_unref0 (self->priv->_slot);
	_g_free0 (self->priv->_uri);
	__vala_GckTokenInfo_free0 (self->priv->_info);
	_g_array_unref0 (self->priv->_mechanisms);
	_g_object_unref0 (self->priv->_session);
	_g_hash_table_unref0 (self->priv->_object_for_handle);
	_g_hash_table_unref0 (self->priv->_objects_for_id);
	_g_hash_table_unref0 (self->priv->_id_for_object);
	_g_hash_table_unref0 (self->priv->_objects_visible);
	G_OBJECT_CLASS (seahorse_pkcs11_token_parent_class)->finalize (obj);
}


GType seahorse_pkcs11_token_get_type (void) {
	static volatile gsize seahorse_pkcs11_token_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_pkcs11_token_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11TokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Token), 0, (GInstanceInitFunc) seahorse_pkcs11_token_instance_init, NULL };
		static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_place_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_seahorse_place_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_lockable_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_seahorse_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_pkcs11_token_type_id;
		seahorse_pkcs11_token_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorsePkcs11Token", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_pkcs11_token_type_id, gcr_collection_get_type (), &gcr_collection_info);
		g_type_add_interface_static (seahorse_pkcs11_token_type_id, SEAHORSE_TYPE_PLACE, &seahorse_place_info);
		g_type_add_interface_static (seahorse_pkcs11_token_type_id, SEAHORSE_TYPE_LOCKABLE, &seahorse_lockable_info);
		g_once_init_leave (&seahorse_pkcs11_token_type_id__volatile, seahorse_pkcs11_token_type_id);
	}
	return seahorse_pkcs11_token_type_id__volatile;
}


static void _vala_seahorse_pkcs11_token_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	switch (property_id) {
		case SEAHORSE_PKCS11_TOKEN_UNLOCKABLE:
		g_value_set_boolean (value, seahorse_lockable_get_unlockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_LOCKABLE:
		g_value_set_boolean (value, seahorse_lockable_get_lockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_INFO:
		g_value_set_boxed (value, seahorse_pkcs11_token_get_info (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_SESSION:
		g_value_set_object (value, seahorse_pkcs11_token_get_session (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_SLOT:
		g_value_set_object (value, seahorse_pkcs11_token_get_slot (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_LABEL:
		g_value_take_string (value, seahorse_place_get_label ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_DESCRIPTION:
		g_value_take_string (value, seahorse_place_get_description ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_URI:
		g_value_take_string (value, seahorse_place_get_uri ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_ICON:
		g_value_take_object (value, seahorse_place_get_icon ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_ACTIONS:
		g_value_take_object (value, seahorse_place_get_actions ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS:
		g_value_set_flags (value, seahorse_pkcs11_token_get_object_flags (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_MECHANISMS:
		g_value_set_boxed (value, seahorse_pkcs11_token_get_mechanisms (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_pkcs11_token_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	switch (property_id) {
		case SEAHORSE_PKCS11_TOKEN_SESSION:
		seahorse_pkcs11_token_set_session (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_TOKEN_SLOT:
		seahorse_pkcs11_token_set_slot (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



