/*
 * Copyright (C) 2013, Igalia S.L.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WidgetBackingStoreGtkX11_h
#define WidgetBackingStoreGtkX11_h

#include "WidgetBackingStore.h"

#if PLATFORM(GTK) && PLATFORM(X11) && defined(GDK_WINDOWING_X11)
#include <X11/Xlib.h>

namespace WebCore {

class WidgetBackingStoreGtkX11 : public WidgetBackingStore {

public:
    static PassOwnPtr<WidgetBackingStore> create(GtkWidget*, const IntSize&, float deviceScaleFactor);
    WidgetBackingStoreGtkX11(GtkWidget*, const IntSize&, float deviceScaleFactor);
    ~WidgetBackingStoreGtkX11();
    cairo_surface_t* cairoSurface();
    void scroll(const IntRect& scrollRect, const IntSize& scrollOffset);

private:
    Display* m_display;
    Pixmap m_pixmap;
    GC m_gc;
    RefPtr<cairo_surface_t> m_surface;
};

} // namespace WebCore

#endif // PLATFORM(GTK) && PLATFORM(X11) && defined(GDK_WINDOWING_X11)

#endif // GtkWidgetBackingStoreX11_h
