/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.RequestPermissionException;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.util.HashMap;
import java.util.Map;

public class RequestBuilder {
    public static final Method DELETE = new Method("DELETE");
    public static final Method GET = new Method("GET");
    public static final Method HEAD = new Method("HEAD");
    public static final Method POST = new Method("POST");
    public static final Method PUT = new Method("PUT");
    private RequestCallback callback;
    private Map<String, String> headers;
    private final String httpMethod;
    private String password;
    private String requestData;
    private int timeoutMillis;
    private final String url;
    private String user;

    public RequestBuilder(Method httpMethod, String url) {
        this(httpMethod == null ? null : httpMethod.toString(), url);
    }

    protected RequestBuilder(String httpMethod, String url) {
        StringValidator.throwIfEmptyOrNull("httpMethod", httpMethod);
        StringValidator.throwIfEmptyOrNull("url", url);
        this.httpMethod = httpMethod;
        this.url = url;
    }

    public RequestCallback getCallback() {
        return this.callback;
    }

    public String getHeader(String header) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(header);
    }

    public String getHTTPMethod() {
        return this.httpMethod;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Request send() throws RequestException {
        StringValidator.throwIfNull("callback", this.callback);
        return this.doSend(this.requestData, this.callback);
    }

    public Request sendRequest(String requestData, RequestCallback callback) throws RequestException {
        StringValidator.throwIfNull("callback", callback);
        return this.doSend(requestData, callback);
    }

    public void setCallback(RequestCallback callback) {
        StringValidator.throwIfNull("callback", callback);
        this.callback = callback;
    }

    public void setHeader(String header, String value) {
        StringValidator.throwIfEmptyOrNull("header", header);
        StringValidator.throwIfEmptyOrNull("value", value);
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(header, value);
    }

    public void setPassword(String password) {
        StringValidator.throwIfEmptyOrNull("password", password);
        this.password = password;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException("Timeouts cannot be negative");
        }
        this.timeoutMillis = timeoutMillis;
    }

    public void setUser(String user) {
        StringValidator.throwIfEmptyOrNull("user", user);
        this.user = user;
    }

    private Request doSend(String requestData, final RequestCallback callback) throws RequestException {
        XMLHttpRequest xmlHttpRequest = XMLHttpRequest.create();
        try {
            if (this.user != null && this.password != null) {
                xmlHttpRequest.open(this.httpMethod, this.url, this.user, this.password);
            } else if (this.user != null) {
                xmlHttpRequest.open(this.httpMethod, this.url, this.user);
            } else {
                xmlHttpRequest.open(this.httpMethod, this.url);
            }
        }
        catch (JavaScriptException e) {
            RequestPermissionException requestPermissionException = new RequestPermissionException(this.url);
            requestPermissionException.initCause(new RequestException(e.getMessage()));
            throw requestPermissionException;
        }
        this.setHeaders(xmlHttpRequest);
        final Request request = new Request(xmlHttpRequest, this.timeoutMillis, callback);
        xmlHttpRequest.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                if (xhr.getReadyState() == 4) {
                    xhr.clearOnReadyStateChange();
                    request.fireOnResponseReceived(callback);
                }
            }
        });
        try {
            xmlHttpRequest.send(requestData);
        }
        catch (JavaScriptException e) {
            throw new RequestException(e.getMessage());
        }
        return request;
    }

    private void setHeaders(XMLHttpRequest xmlHttpRequest) throws RequestException {
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                try {
                    xmlHttpRequest.setRequestHeader(header.getKey(), header.getValue());
                }
                catch (JavaScriptException e) {
                    throw new RequestException(e.getMessage());
                }
            }
        } else {
            xmlHttpRequest.setRequestHeader("Content-Type", "text/plain; charset=utf-8");
        }
    }

    public static final class Method {
        private final String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

