/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.server.DeadEntityException;
import com.google.web.bindery.requestfactory.server.ReportableException;
import com.google.web.bindery.requestfactory.server.RequestState;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Resolver {
    private final Map<ResolutionKey, Object> resolved = new HashMap<ResolutionKey, Object>();
    private final ServiceLayer service;
    private final RequestState state;
    private int syntheticId;

    static int index(String path) {
        int idx = path.lastIndexOf(91);
        if (idx == -1) {
            return -1;
        }
        return Integer.parseInt(path.substring(idx + 1, path.lastIndexOf(93)));
    }

    static boolean matchesPropertyRef(Set<String> propertyRefs, String newPrefix) {
        return propertyRefs.contains(newPrefix.replaceAll("\\[\\d+\\]", ""));
    }

    static String snipIndex(String path) {
        int idx = path.lastIndexOf(91);
        if (idx == -1) {
            return path;
        }
        return path.substring(0, idx);
    }

    Resolver(RequestState state) {
        this.state = state;
        this.service = state.getServiceLayer();
    }

    public Object resolveClientValue(Object domainValue, Type assignableTo, Set<String> propertyRefs) {
        return this.resolveClientValue(domainValue, assignableTo, this.getPropertyRefs(propertyRefs), "");
    }

    public Object resolveDomainValue(Object maybeEntityProxy, boolean detectDeadEntities) {
        if (maybeEntityProxy instanceof BaseProxy) {
            AutoBean bean = AutoBeanUtils.getAutoBean((BaseProxy)maybeEntityProxy);
            Object domain = bean.getTag("domainObject");
            if (domain == null && detectDeadEntities) {
                throw new ReportableException(new DeadEntityException("The requested entity is not available on the server"));
            }
            return domain;
        }
        if (maybeEntityProxy instanceof Collection) {
            AbstractCollection accumulator;
            if (maybeEntityProxy instanceof List) {
                accumulator = new ArrayList();
            } else if (maybeEntityProxy instanceof Set) {
                accumulator = new HashSet();
            } else {
                throw new ReportableException("Unsupported collection type " + maybeEntityProxy.getClass().getName());
            }
            for (Object o : (Collection)maybeEntityProxy) {
                accumulator.add(this.resolveDomainValue(o, detectDeadEntities));
            }
            return accumulator;
        }
        return maybeEntityProxy;
    }

    private Set<String> getPropertyRefs(Set<String> refs) {
        if (refs == null) {
            return Collections.emptySet();
        }
        TreeSet<String> toReturn = new TreeSet<String>();
        for (String raw : refs) {
            int idx = raw.length();
            while (idx >= 0) {
                toReturn.add(raw.substring(0, idx));
                idx = raw.lastIndexOf(46, idx - 1);
            }
        }
        return toReturn;
    }

    private <T extends BaseProxy> T resolveClientProxy(final Object domainEntity, Class<T> proxyType, final Set<String> propertyRefs, ResolutionKey key, final String prefix) {
        Object domainVersion;
        if (domainEntity == null) {
            return null;
        }
        SimpleProxyId<Object> id = this.state.getStableId(domainEntity);
        boolean isEntityProxy = this.state.isEntityType(proxyType);
        final boolean isOwnerValueProxy = this.state.isValueType(proxyType);
        if (id == null || id.isEphemeral()) {
            Splittable flatValue;
            Object domainId;
            if (isEntityProxy) {
                domainId = this.service.getId(domainEntity);
                domainVersion = this.service.getVersion(domainEntity);
            } else {
                domainId = null;
                domainVersion = null;
            }
            if (id == null) {
                if (domainId == null) {
                    id = this.state.getIdFactory().allocateSyntheticId(proxyType, ++this.syntheticId);
                } else {
                    flatValue = this.state.flatten(domainId);
                    id = this.state.getIdFactory().getId(proxyType, flatValue.getPayload(), 0);
                }
            } else if (domainId != null) {
                flatValue = this.state.flatten(domainId);
                id.setServerId(flatValue.getPayload());
            }
        } else {
            domainVersion = isEntityProxy ? this.service.getVersion(domainEntity) : null;
        }
        AutoBean<?> bean = this.state.getBeanForPayload(id, domainEntity);
        this.resolved.put(key, bean.as());
        bean.setTag("inResponse", true);
        if (domainVersion != null) {
            Splittable flatVersion = this.state.flatten(domainVersion);
            bean.setTag("version", SimpleRequestProcessor.toBase64(flatVersion.getPayload()));
        }
        bean.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                boolean shouldSend;
                String newPrefix = (prefix.length() > 0 ? prefix + "." : "") + propertyName;
                Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
                boolean bl = shouldSend = isOwnerValueProxy || Resolver.matchesPropertyRef(propertyRefs, newPrefix) || elementType != null && ValueCodex.canDecode(elementType);
                if (!shouldSend) {
                    return false;
                }
                Object domainValue = Resolver.this.service.getProperty(domainEntity, propertyName);
                if (domainValue == null) {
                    return false;
                }
                Type type = elementType == null ? ctx.getType() : new CollectionType(ctx.getType(), elementType);
                Object clientValue = Resolver.this.resolveClientValue(domainValue, type, propertyRefs, newPrefix);
                ctx.set(clientValue);
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                value = Resolver.this.service.getProperty(domainEntity, propertyName);
                ctx.set(value);
                return false;
            }
        });
        return (T)((BaseProxy)bean.as());
    }

    private Object resolveClientValue(Object domainValue, Type returnType, Set<String> propertyRefs, String prefix) {
        boolean anyType;
        if (domainValue == null) {
            return null;
        }
        boolean bl = anyType = returnType == null;
        if (anyType) {
            returnType = Object.class;
        }
        Class<?> assignableTo = TypeUtils.ensureBaseType((Type)returnType);
        ResolutionKey key = new ResolutionKey(domainValue, (Type)returnType);
        Object previous = this.resolved.get(key);
        if (previous != null && assignableTo.isInstance(previous)) {
            return assignableTo.cast(previous);
        }
        Class<?> returnClass = this.service.resolveClientType(domainValue.getClass(), assignableTo, true);
        if (anyType) {
            assignableTo = returnClass;
        }
        if (ValueCodex.canDecode(returnClass)) {
            return assignableTo.cast(domainValue);
        }
        boolean isProxy = BaseProxy.class.isAssignableFrom(returnClass);
        boolean isId = EntityProxyId.class.isAssignableFrom(returnClass);
        if (isProxy || isId) {
            Class<BaseProxy> proxyClass = assignableTo.asSubclass(BaseProxy.class);
            BaseProxy entity = this.resolveClientProxy(domainValue, proxyClass, propertyRefs, key, prefix);
            if (isId) {
                return assignableTo.cast(((EntityProxy)entity).stableId());
            }
            return assignableTo.cast(entity);
        }
        if (Collection.class.isAssignableFrom(returnClass)) {
            AbstractCollection accumulator;
            if (List.class.isAssignableFrom(returnClass)) {
                accumulator = new ArrayList();
            } else if (Set.class.isAssignableFrom(returnClass)) {
                accumulator = new HashSet();
            } else {
                throw new ReportableException("Unsupported collection type" + returnClass.getName());
            }
            this.resolved.put(key, accumulator);
            Type elementType = TypeUtils.getSingleParameterization(Collection.class, new Type[]{returnType});
            for (Object o : (Collection)domainValue) {
                accumulator.add(this.resolveClientValue(o, elementType, propertyRefs, prefix));
            }
            return assignableTo.cast(accumulator);
        }
        throw new ReportableException("Unsupported domain type " + returnClass.getCanonicalName());
    }

    private static class ResolutionKey {
        private final Object domainObject;
        private final int hashCode;
        private final Type requestedType;

        public ResolutionKey(Object domainObject, Type requestedType) {
            this.domainObject = domainObject;
            this.requestedType = requestedType;
            this.hashCode = System.identityHashCode(domainObject) * 13 + requestedType.hashCode() * 7;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResolutionKey)) {
                return false;
            }
            ResolutionKey other = (ResolutionKey)o;
            if (this.domainObject != other.domainObject) {
                return false;
            }
            return this.requestedType.equals(other.requestedType);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.domainObject.toString() + " => " + this.requestedType.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionType
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Class<?> elementType;

        private CollectionType(Class<?> rawType, Class<?> elementType) {
            this.rawType = rawType;
            this.elementType = elementType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollectionType)) {
                return false;
            }
            CollectionType other = (CollectionType)o;
            return this.rawType.equals(other.rawType) && this.elementType.equals(other.elementType);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.elementType};
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return this.rawType.hashCode() * 13 + this.elementType.hashCode() * 7;
        }
    }
}

