#ifndef HAVE_EASY_SPICE_H
#define HAVE_EASY_SPICE_H

#include <errno.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "struct.h"
#include "prototypes.h"
#include "support.h"


/**** GLOBAL CONSTANTS AND STRUCTURES ************************************/
/* different verbose levels:
 * Verbose1 should print all external programm calls
 * Verbose2 should print function calls
 * Verbose3 is for detailed internal messages (e.g. parsing)
 * TODO: move the verbose level to the command line (e.g. -v -vv -vvv)
 */
#define VERBOSE1 1
#define VERBOSE2 0
#define VERBOSE3 0
/* Debug: should only be used for development */
#define DEBUG 0

/* The length of a char buffer for reading lines from files */
#define FICHIER_MAX_LINE 255

/* filename extention for the easyspice project files:
 * as "project" is not specific enough I'd recommend "easyspice"
 */
#define PROJECT_EXTENTION ".easyspice"
#define PROJECT_RCFILENAME ".easyspicerc"

/* Version number for every file written by easyspice.
 * Version 0 is the "old" colon seperated file format. It has no version number in it's files.
 * Version 1 is the first GKeyFile based file format
 */
#define FILE_FORMAT_VERSION 1

#endif
