/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeRouteTablesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeRouteTablesRequestMarshaller
implements Marshaller<Request<DescribeRouteTablesRequest>, DescribeRouteTablesRequest> {
    public Request<DescribeRouteTablesRequest> marshall(DescribeRouteTablesRequest describeRouteTablesRequest) {
        if (describeRouteTablesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRouteTablesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeRouteTables");
        request.addParameter("Version", "2013-10-15");
        if (describeRouteTablesRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)describeRouteTablesRequest.isDryRun()));
        }
        List<String> routeTableIdsList = describeRouteTablesRequest.getRouteTableIds();
        int routeTableIdsListIndex = 1;
        for (String routeTableIdsListValue : routeTableIdsList) {
            if (routeTableIdsListValue != null) {
                request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)routeTableIdsListValue));
            }
            ++routeTableIdsListIndex;
        }
        List<Filter> filtersList = describeRouteTablesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

