/*
 *	for new GOGO-no-coda (1999/09)
 *	modified by PEN@MarineCat
 */
#include <ctype.h>
#include <assert.h>
#include <errno.h>
#include <float.h>

#include "common.h"
#include "musenc.h"

static const int freq_table[][3] = {
	{22050, 24000, 16000},
	{44100, 48000, 32000}
};
	
static const int bitrate_table[2][15] = {
	{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
	{0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
};

/* getframebits ̃e[u */
/* ŏɌĂ΂̂ freq_kHz  gl.enc_freqHz ɕύX邱ƂȂǂ͏oȂ */

int bitsPerFrame_table[15][2]; 	//sv
int mean_bits_table[15][2]; 	//sv

static void old_getframebits(int *bitsPerFrame, int *mean_bits, int rate_idx, int padding){
	static const float freqHzTbl[][3] = { {22.05, 24, 16}, {44.1, 48, 32} }; /* 邢 */
	int whole_SpF;
	float bit_rate, freq_kHz;
	int sideinfo_len;

	/* DON'T CHANGE this `freq_kHz' to gl.enc_freqHz */
	freq_kHz = freqHzTbl[gl.version][gl.freq_idx];
	bit_rate = bitrate_table[gl.version][rate_idx];
  
	/* determine the mean bitrate for main data */
	sideinfo_len = 32;
	if( gl.version == 1 ){   /* MPEG 1 */
		sideinfo_len += ( gl.stereo == 1 ) ? 136 : 256;
	}else{ /* MPEG 2 */
		sideinfo_len += ( gl.stereo == 1 ) ? 72 : 136;
	}

	whole_SpF = (gl.frameSize / freq_kHz) * (bit_rate / 8.0);
	*bitsPerFrame = 8 * (whole_SpF + padding);
	*mean_bits = (*bitsPerFrame - sideinfo_len) / gl.mode_gr;
}

void
framebitstable_init(void){
	struct GLOBAL_VAR keep_gl;
	int   br;
	int   padding;
	keep_gl = gl;
	
	for( br = 0; br < 15; br++ ){
		for( padding = 0; padding < 2; padding++ ){
			old_getframebits(
				&bitsPerFrame_table[br][padding], 
				&mean_bits_table[br][padding],
				br, padding);
		}
	}
	gl = keep_gl;
}

int get_rate_idx(int rate_kbps,int version){
	int i;
	for(i = 0; i < 15; i++){
		if(bitrate_table[version][i] == rate_kbps) return i;
	}
	fprintf(stderr, "bitrate err:rate=%d, ver=%d\n", rate_kbps, version);
	return -1;
}

int get_freq_idx(int freqHz, int *version){
	int idx, id;
	for(id = 0; id < 2; id++){
		for(idx = 0; idx < 3; idx++){
			if(freqHz == freq_table[id][idx]){
				*version = id;/* = (LSF) ? 0 : 1 */
				return idx;
			}
		}
	}
	return -1;
}

int NormalizeSmpFreq(long freqHz)
{
	int nDist = 0x7fff;
	int nIndex = -1;
	int i, ld;
	int *tbl = (int *)freq_table;
	for(i = 0; i < sizeof(freq_table) / sizeof(freq_table[0][0]); i++){
		ld = abs(tbl[i] - freqHz);
		if(nDist > ld){
			nDist = ld;
			nIndex = i;
		}
	}
	return tbl[nIndex];
}

/*
 *	size bytemۂẴ|C^Ԃ
 *	0Ŗ߂Ȃ
 *	mۂɎsexit(1)s
 */

void *mem_alloc(unsigned long size, char *item){
	void *ptr;

	ptr = (void *)calloc(size, 1);
	if( ptr == NULL ){
		fprintf(stderr,"malloc err [%d]byte.\n",(int)size);
		TERM( ME_NOMEMORY );
	}
	return ptr;
}

/* *ptrŊmۂꂽJ *ptrNULLɂȂ */

void mem_free(void **ptr){
	free( *ptr );
	*ptr = NULL;
}

/* JỸׂ */

void memFreeChk(void){
}

/* RIFF_DATA_CHUNK */
struct CK_RIFF {
	long	chunk;						/* "RIFF" */
	long	size;					/* sizeof "RIFF" */
} ;

struct CK_FMT {
	long	chunk;						/* "WAVE" */
	long	form;						/* "fmt " */
	long	size;						/* 16 */
	short	formatID;					/*  1 = RAW WAVE */
	short	num_of_channel;				/* 1 or 2 */
	long	srate;						/* 44100 etc. */
	long	avg_bytes_par_sec;			/* freq * elementsize */
	short	block_size;					/* byte per element */
	short	bits_par_sample;			/* 16 */
} ;

struct CK_DATA {
	long	chunk;						/* "DATA" */
	long	size;						/* sizeof "DATA" */
} ;

struct CK_WAVE {
	struct	CK_RIFF		riff;
	struct	CK_FMT		fmt;
} ;

int
WAV_checkFMT(FILE *fp, int *size, int *bit, int *freq, int *channel)
{
	struct	CK_WAVE		wav;
	char	prevbuf[8];
	int i, c;

	*size = *freq = *channel = 0;
	if( fp == NULL ) return FALSE;

        /* because we can't use fread() in stdin-mode */

	for( i = 0; i < sizeof( wav ); i++ ){
		c = fgetc( fp );
		if( c == EOF )return FALSE;
		*( ((char *)&wav) + i ) = c;
	}

	if( memcmp( &wav.riff.chunk, "RIFF", 4) )
		return FALSE;
	if( memcmp( &wav.fmt.chunk, "WAVEfmt ", 8) )
		return FALSE;
	if( wav.fmt.formatID != 1 )
		return FALSE;
	memset( prevbuf, 0, sizeof(prevbuf) );

	do{
		memcpy( prevbuf, prevbuf+1, sizeof(prevbuf) - 1);
		c = fgetc( fp );
		if( c == EOF ) return FALSE;

		prevbuf[sizeof(prevbuf)-1] = c;
        }while( memcmp( prevbuf, "data", 4 ) );
	/* prevbuf='data...'(...DWORDdata`ÑTCY)ƂȂ */

	*size    = *(unsigned int *)( prevbuf + 4 );
	*freq    = wav.fmt.srate;
	*bit     = wav.fmt.bits_par_sample;
	*channel = wav.fmt.num_of_channel; 

	return TRUE;
}
