/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class ContigComparator
implements Comparator<String> {
    private Set<String> specialChrs = new TreeSet<String>();

    public ContigComparator() {
        this.specialChrs.add("X");
        this.specialChrs.add("Y");
    }

    @Override
    public int compare(String chr1, String chr2) {
        if (chr1.equals(chr2)) {
            return 0;
        }
        Integer x = this.convertStringWithoutException(chr1);
        Integer y = this.convertStringWithoutException(chr2);
        if (x != null && y != null) {
            return x < y ? -1 : 1;
        }
        if (x == null && y == null) {
            if (this.specialChrs.contains(chr1) && this.specialChrs.contains(chr2) || !this.specialChrs.contains(chr1) && !this.specialChrs.contains(chr2)) {
                return chr1.compareTo(chr2);
            }
            if (this.specialChrs.contains(chr1)) {
                return -1;
            }
            return 1;
        }
        if (x != null) {
            return -1;
        }
        return 1;
    }

    private Integer convertStringWithoutException(String contig) {
        Integer x = null;
        try {
            x = Integer.decode(contig);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return x;
    }
}

