/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ApplicationDetails {
    final List<String> applicationHeader;
    final List<String> attribution;
    final String runningInstructions;
    final String additionalHelp;

    public ApplicationDetails(List<String> applicationHeader, List<String> attribution, String runningInstructions, String additionalHelp) {
        this.applicationHeader = applicationHeader;
        this.attribution = attribution;
        this.runningInstructions = runningInstructions;
        this.additionalHelp = additionalHelp;
    }

    public static List<String> createDefaultHeader(Class<? extends CommandLineProgram> application) {
        return Collections.singletonList("Program Name: " + application.getName());
    }

    public static String createDefaultRunningInstructions(Class<? extends CommandLineProgram> application) {
        String runningInstructions = null;
        try {
            runningInstructions = JVMUtils.getLocationFor(application).getName();
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to determine running instructions", ex);
        }
        runningInstructions = runningInstructions.endsWith(".jar") ? String.format("-jar %s", runningInstructions) : application.getName();
        return runningInstructions;
    }
}

